Object.assign(window.search, {"doc_urls":["warpgrapher/intro.html#warpgrapher","warpgrapher/quickstart.html#quickstart","warpgrapher/quickstart.html#configuration","warpgrapher/quickstart.html#source-code","warpgrapher/quickstart.html#database","warpgrapher/quickstart.html#run","warpgrapher/quickstart.html#full-example-code","integrations/intro.html#server-integration","integrations/actix.html#actix-web-integration","integrations/lambda.html#aws-lambda","configuration/intro.html#introduction","configuration/databases.html#databases","configuration/databases.html#gremlin-based-databases","configuration/databases.html#apache-tinkerpop","configuration/databases.html#aws-neptune","configuration/databases.html#azure-cosmos-db","configuration/databases.html#neo4j","configuration/formats.html#warpgrapher-config","configuration/formats.html#string-configuration","configuration/formats.html#yaml-file-configuration","configuration/formats.html#programmatic-configuration","configuration/types.html#types","configuration/types.html#type-configuration","configuration/types.html#generated-schema","configuration/types.html#full-schema-listing","configuration/relationships.html#relationships","configuration/relationships.html#relationship-configuration","configuration/relationships.html#generated-schema","configuration/relationships.html#queries-in-a-model-with-relationships","configuration/relationships.html#querying-for-a-relationship","configuration/relationships.html#querying-for-a-node","configuration/relationships.html#mutations-in-a-model-with-relationships","configuration/relationships.html#mutating-a-relationship","configuration/relationships.html#mutating-a-node","configuration/relationships.html#updating-a-node","configuration/relationships.html#deleting-a-node","configuration/relationships.html#full-schema-listing","api/intro.html#warpgrapher-crud-api","api/node_create.html#node-create","api/node_create.html#node-with-no-relationships","api/node_create.html#node-related-to-a-new-node","api/node_create.html#node-related-to-an-existing-node","api/node_read.html#node-read","api/node_read.html#all-nodes","api/node_read.html#node-with-matching-properties","api/node_read.html#node-with-matching-relationships","api/node_read.html#node-with-matching-destinations","api/node_update.html#node-update","api/node_update.html#match-node-properties","api/node_update.html#match-destination-properties","api/node_update.html#add-a-destination-node","api/node_update.html#update-a-destination-node","api/node_update.html#delete-a-relationship","api/node_delete.html#node-delete","api/node_delete.html#node-with-matching-properties","api/rel_create.html#relationship-create","api/rel_create.html#between-existing-nodes","api/rel_create.html#from-an-existing-to-a-new-node","api/rel_read.html#relationship-read","api/rel_read.html#by-relationship-properties","api/rel_read.html#by-source-node","api/rel_read.html#by-destination-node","api/rel_update.html#relationship-update","api/rel_update.html#update-relationship-properties","api/rel_delete.html#relationship-delete","api/rel_delete.html#delete-relationship","engine/intro.html#engine-features","engine/endpoints_static.html#static-endpoints","engine/endpoints_static.html#version","engine/endpoints_defined.html#defined-endpoints","engine/endpoints_defined.html#configuration","engine/endpoints_defined.html#implementation","engine/endpoints_defined.html#add-resolvers-to-the-warpgrapher-engine","engine/endpoints_defined.html#example-of-calling-the-endpoint","engine/endpoints_defined.html#full-example-source","engine/dynamic_props.html#dynamic-props","engine/dynamic_props.html#configuration","engine/dynamic_props.html#implementation","engine/dynamic_props.html#add-resolvers-to-the-engine","engine/dynamic_props.html#example-api-call","engine/dynamic_props.html#full-example-source","engine/dynamic_rels.html#dynamic-relationships","engine/dynamic_rels.html#configuration","engine/dynamic_rels.html#implementation","engine/dynamic_rels.html#add-the-resolver-to-the-engine","engine/dynamic_rels.html#example-api-call","engine/dynamic_rels.html#full-example-source","engine/context_request.html#request-context","engine/context_request.html#define-the-requestcontext","engine/context_request.html#engine-type-parameter","engine/context_request.html#access-the-context","engine/context_request.html#full-example-source","engine/input_validation.html#input-validation","engine/input_validation.html#configuration","engine/input_validation.html#implementation","engine/input_validation.html#add-validators-to-the-engine","engine/input_validation.html#example-api-call","engine/input_validation.html#full-example-source","engine/event_handlers.html#event-handlers","engine/event_handlers.html#configuration","engine/event_handlers.html#implementation","engine/event_handlers.html#before-engine-build","engine/event_handlers.html#before-request-processing","engine/event_handlers.html#before-node-creation","engine/event_handlers.html#after-node-read","engine/event_handlers.html#before-node-update-and-delete","engine/event_handlers.html#add-handlers-to-the-engine","engine/event_handlers.html#example-api-call","engine/event_handlers.html#full-example-source"],"index":{"documentStore":{"docInfo":{"0":{"body":85,"breadcrumbs":2,"title":1},"1":{"body":59,"breadcrumbs":2,"title":1},"10":{"body":82,"breadcrumbs":2,"title":1},"100":{"body":69,"breadcrumbs":5,"title":1},"101":{"body":101,"breadcrumbs":7,"title":3},"102":{"body":105,"breadcrumbs":7,"title":3},"103":{"body":93,"breadcrumbs":7,"title":3},"104":{"body":101,"breadcrumbs":6,"title":2},"105":{"body":199,"breadcrumbs":8,"title":4},"106":{"body":52,"breadcrumbs":7,"title":3},"107":{"body":28,"breadcrumbs":7,"title":3},"108":{"body":391,"breadcrumbs":7,"title":3},"11":{"body":119,"breadcrumbs":3,"title":1},"12":{"body":176,"breadcrumbs":5,"title":3},"13":{"body":103,"breadcrumbs":4,"title":2},"14":{"body":28,"breadcrumbs":4,"title":2},"15":{"body":128,"breadcrumbs":5,"title":3},"16":{"body":68,"breadcrumbs":3,"title":1},"17":{"body":24,"breadcrumbs":4,"title":2},"18":{"body":19,"breadcrumbs":4,"title":2},"19":{"body":35,"breadcrumbs":5,"title":3},"2":{"body":186,"breadcrumbs":2,"title":1},"20":{"body":95,"breadcrumbs":4,"title":2},"21":{"body":24,"breadcrumbs":3,"title":1},"22":{"body":514,"breadcrumbs":4,"title":2},"23":{"body":566,"breadcrumbs":4,"title":2},"24":{"body":92,"breadcrumbs":5,"title":3},"25":{"body":154,"breadcrumbs":3,"title":1},"26":{"body":244,"breadcrumbs":4,"title":2},"27":{"body":23,"breadcrumbs":4,"title":2},"28":{"body":90,"breadcrumbs":5,"title":3},"29":{"body":311,"breadcrumbs":4,"title":2},"3":{"body":222,"breadcrumbs":3,"title":2},"30":{"body":180,"breadcrumbs":4,"title":2},"31":{"body":122,"breadcrumbs":5,"title":3},"32":{"body":603,"breadcrumbs":4,"title":2},"33":{"body":108,"breadcrumbs":4,"title":2},"34":{"body":179,"breadcrumbs":4,"title":2},"35":{"body":57,"breadcrumbs":4,"title":2},"36":{"body":286,"breadcrumbs":5,"title":3},"37":{"body":41,"breadcrumbs":7,"title":3},"38":{"body":31,"breadcrumbs":8,"title":2},"39":{"body":24,"breadcrumbs":8,"title":2},"4":{"body":29,"breadcrumbs":2,"title":1},"40":{"body":66,"breadcrumbs":10,"title":4},"41":{"body":85,"breadcrumbs":10,"title":4},"42":{"body":31,"breadcrumbs":8,"title":2},"43":{"body":38,"breadcrumbs":7,"title":1},"44":{"body":26,"breadcrumbs":9,"title":3},"45":{"body":72,"breadcrumbs":9,"title":3},"46":{"body":74,"breadcrumbs":9,"title":3},"47":{"body":35,"breadcrumbs":8,"title":2},"48":{"body":38,"breadcrumbs":9,"title":3},"49":{"body":88,"breadcrumbs":9,"title":3},"5":{"body":35,"breadcrumbs":2,"title":1},"50":{"body":103,"breadcrumbs":9,"title":3},"51":{"body":88,"breadcrumbs":9,"title":3},"52":{"body":68,"breadcrumbs":8,"title":2},"53":{"body":24,"breadcrumbs":8,"title":2},"54":{"body":29,"breadcrumbs":9,"title":3},"55":{"body":27,"breadcrumbs":8,"title":2},"56":{"body":74,"breadcrumbs":9,"title":3},"57":{"body":69,"breadcrumbs":9,"title":3},"58":{"body":27,"breadcrumbs":8,"title":2},"59":{"body":58,"breadcrumbs":8,"title":2},"6":{"body":113,"breadcrumbs":4,"title":3},"60":{"body":113,"breadcrumbs":8,"title":2},"61":{"body":85,"breadcrumbs":8,"title":2},"62":{"body":3,"breadcrumbs":8,"title":2},"63":{"body":62,"breadcrumbs":9,"title":3},"64":{"body":2,"breadcrumbs":8,"title":2},"65":{"body":20,"breadcrumbs":8,"title":2},"66":{"body":93,"breadcrumbs":4,"title":2},"67":{"body":15,"breadcrumbs":6,"title":2},"68":{"body":33,"breadcrumbs":5,"title":1},"69":{"body":14,"breadcrumbs":6,"title":2},"7":{"body":20,"breadcrumbs":4,"title":2},"70":{"body":160,"breadcrumbs":5,"title":1},"71":{"body":47,"breadcrumbs":5,"title":1},"72":{"body":45,"breadcrumbs":8,"title":4},"73":{"body":20,"breadcrumbs":7,"title":3},"74":{"body":159,"breadcrumbs":7,"title":3},"75":{"body":35,"breadcrumbs":6,"title":2},"76":{"body":34,"breadcrumbs":5,"title":1},"77":{"body":33,"breadcrumbs":5,"title":1},"78":{"body":44,"breadcrumbs":7,"title":3},"79":{"body":25,"breadcrumbs":7,"title":3},"8":{"body":459,"breadcrumbs":7,"title":3},"80":{"body":147,"breadcrumbs":7,"title":3},"81":{"body":13,"breadcrumbs":6,"title":2},"82":{"body":44,"breadcrumbs":5,"title":1},"83":{"body":64,"breadcrumbs":5,"title":1},"84":{"body":42,"breadcrumbs":7,"title":3},"85":{"body":26,"breadcrumbs":7,"title":3},"86":{"body":180,"breadcrumbs":7,"title":3},"87":{"body":22,"breadcrumbs":6,"title":2},"88":{"body":54,"breadcrumbs":6,"title":2},"89":{"body":23,"breadcrumbs":7,"title":3},"9":{"body":346,"breadcrumbs":6,"title":2},"90":{"body":28,"breadcrumbs":6,"title":2},"91":{"body":155,"breadcrumbs":7,"title":3},"92":{"body":35,"breadcrumbs":6,"title":2},"93":{"body":33,"breadcrumbs":5,"title":1},"94":{"body":57,"breadcrumbs":5,"title":1},"95":{"body":38,"breadcrumbs":7,"title":3},"96":{"body":22,"breadcrumbs":7,"title":3},"97":{"body":163,"breadcrumbs":7,"title":3},"98":{"body":74,"breadcrumbs":6,"title":2},"99":{"body":32,"breadcrumbs":5,"title":1}},"docs":{"0":{"body":"Warpgrapher is framework for developing graph-based API services. Describe the data model for which you want to run a web service. Wargrapher automatically generates a GraphQL schema from the data model, as well as a set of resolvers for basic reate, read, update, and delete (CRUD) operations on that data. If you need more more sophisticated, custom queries and endpoints, you can supply your own custom resolvers. Warpgrapher will automatically generate the GraphQL configuration and invoke your custom resolvers when appropriate. The project is currently in development. Prior to reaching v1.0.0: Minor versions represent breaking changes. Patch versions represent fixes and features. There are no deprecation warnings between releases. For in-depth usage information, see the API Documentation . To browse the source code or contribute, see the project's GitHub Repository .","breadcrumbs":"Warpgrapher » Warpgrapher","id":"0","title":"Warpgrapher"},"1":{"body":"This guide will walk through creating a brand new project using the Warpgrapher engine. The quickstart example will create a very simple service. It will store email addresses for users. Warpgrapher is far more capable, allowing storage and retrieval of complex data models with many relationships. But for now, to get started quickly, begin with as simple a data model as possible. This quickstart assumes a working knowledge of Rust, GraphQL, and at least one graph database. For example, we don't cover creating a new Rust project using cargo init.","breadcrumbs":"Quickstart » Quickstart","id":"1","title":"Quickstart"},"10":{"body":"Warpgrapher is published as a Rust crate. There are crate features for each of the databases supported as a back-end. For Gremlin-based databases such as Apache Tinkerpop and Azure CosmosDB, use the gremlin feature. [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"gremlin\"] } For Cypher-based databases, such as AWS Neptune and Neo4j, use the cypher feature. [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"cypher\"] } The database features are not mutually exclusive, so building with both features enabled will not do any harm. However, only one database may be used for an instance of the Warpgrapher engine. Compiling with no database features selected will succeed, but the resulting engine will have sharply limited functionality, as it will have no ability to connect to a back-end storage mechanism. Continue for a tutorial on using Warpgrapher to build a web service.","breadcrumbs":"Configuration » Introduction","id":"10","title":"Introduction"},"100":{"body":"The example introduces four event hooks illustrating different lifecycle events. One event handler is set up for before the engine is built. It takes in the configuration and modifies it to insert an additional property allowing the system to track the owner of a given Record. A second event handler runs before every request, inserting the current username into a request context so that the system can determine who is making a request, and thus whether that current user matches the ownership of the records being affected. The remaining event handlers run after node read events and before node modification events, in order to enforce the access control rules.","breadcrumbs":"Engine Features » Event Handlers » Implementation","id":"100","title":"Implementation"},"101":{"body":"The following function is run before the engine is built. It takes in a mutable copy of the configuration to be used to set up Warpgrapher Engine. This allows before engine build event handlers to make any concievable modification to the configuration. They can add or remove endpoints, types, properties, relationships, dynamic resolvers, validation, or anything else that can be included in a configuration. /// before_build_engine event hook\n/// Adds owner meta fields to all types in the model (though in this example, there's only one,\n/// the record type)\nfn add_owner_field(config: &mut Configuration) -> Result<(), Error> { for t in config.model.iter_mut() { let mut_props: &mut Vec<Property> = t.mut_props(); mut_props.push(Property::new( \"owner\".to_string(), UsesFilter::none(), \"String\".to_string(), false, false, None, None, )); } Ok(())\n} In this example, the handler is iterating through the configuration, finding every type declared in the data model. To each type, the handler is adding a new owner property that will record the identity of the owner of the record. This will later be used to validate that only the owner can read and modify the data.","breadcrumbs":"Engine Features » Event Handlers » Before Engine Build","id":"101","title":"Before Engine Build"},"102":{"body":"The following event hook function is run before every request that is processed by the Warpgrapher engine. In a full system implementation, it would likely pull information from the metadata parameter, such as request headers like a JWT, that might be parsed to pull out user identity information. That data might then be used to look up a user profile in the database. In this case, the example simply hard-codes a username. It does, however, demonstrate the use of an application-specific request context as a means of passing data in for use by other event handlers or by custom resolvers. /// This event handler executes at the beginning of every request and attempts to insert the\n/// current user's profile into the request context.\nfn insert_user_profile( mut rctx: Rctx, mut _ef: EventFacade<Rctx>, _metadata: HashMap<String, String>,\n) -> BoxFuture<Result<Rctx, Error>> { Box::pin(async move { // A real implementation would likely pull a user identity from an authentication token in // metadata, or use that token to look up a full user profile in a database. In this // example, the identify is hard-coded. rctx.username = \"user-from-JWT\".to_string(); Ok(rctx) })\n}","breadcrumbs":"Engine Features » Event Handlers » Before Request Processing","id":"102","title":"Before Request Processing"},"103":{"body":"The insert_owner event hook is run prior to the creation of any new nodes. The Value passed to the function is the GraphQL input type in the form of a Warpgrapher Value. In this case, the function modifies the input value to insert an additional property, the owner of the node about to be created, which is set to be the username of the current user. /// before_create event hook\n/// Inserts an owner meta property into every new node containing the id of the creator\nfn insert_owner(mut v: Value, ef: EventFacade<'_, Rctx>) -> BoxFuture<Result<Value, Error>> { Box::pin(async move { if let CrudOperation::CreateNode(_) = ef.op() { if let Value::Map(ref mut input) = v { let user_name = ef .context() .request_context() .expect(\"Expect context\") .username .to_string(); input.insert(\"owner\".to_string(), Value::String(user_name)); } } Ok(v) })\n} The modified input value is returned from the event hook, and when Warpgrapher continues executing the node creation operation, the owner property is included in the node creation operation, alongside all the other input properties.","breadcrumbs":"Engine Features » Event Handlers » Before Node Creation","id":"103","title":"Before Node Creation"},"104":{"body":"The enforce_read_access event hook, defined below, is set to run after each node read operation. The Rust function is passed a Vec of nodes that that were read. The event hook function iterates through the nodes that were read, pulling out their owner property. That owner property is compared with the current logged in username. If the two match, the node belongs to the user, and the node is retained in the results list. If the two do not match, then the current logged in user is not the owner of the record, and the node is discarded from the results list without ever being passed back to the user. /// after_read event hook\n/// Filters the read nodes to those that are authorized to be read\nfn enforce_read_access( mut nodes: Vec<Node<Rctx>>, ef: EventFacade<'_, Rctx>,\n) -> BoxFuture<Result<Vec<Node<Rctx>>, Error>> { Box::pin(async move { nodes.retain(|node| { let node_owner: String = node .fields() .get(\"owner\") .unwrap() .clone() .try_into() .expect(\"Expect to find owner field.\"); node_owner == ef .context() .request_context() .expect(\"Context expected\") .username }); Ok(nodes) })\n}","breadcrumbs":"Engine Features » Event Handlers » After Node Read","id":"104","title":"After Node Read"},"105":{"body":"The enforce_write_access event hook, shown below, is set to run before each node update or delete operation. The Rust function is passed the input value that corresponds to the GraphQL schema input argument type for the update or delete operation. In this example implementation, the function executes the MATCH portion of the update or delete query, reading all the nodes that are intended to be modified. For each of the nodes read, the event handler tests whether the owner attribute is the current logged in username. If the two match, the node belongs to the current user, and it is kept in the result set. If the username does not match the owner property on the object, then the node is discarded. Once the node list is filtered, the event handler constructs a new MATCH query that will match the unique identifiers of all the nodes remaining in the filtered list. This new MATCH query is returned from the event handler and used subsequently in Warpgrapher's automatically generated resolvers to do the update or deletion operation. /// before_update event hook\n/// Filters out nodes that the user is not authorized to modify\nfn enforce_write_access( v: Value, mut ef: EventFacade<'_, Rctx>,\n) -> BoxFuture<Result<Value, Error>> { Box::pin(async move { if let Value::Map(mut m) = v.clone() { if let Some(input_match) = m.remove(\"MATCH\") { let nodes = &ef.read_nodes(\"Record\", input_match, None).await?; // filter nodes that are authorized let filtered_node_ids: Vec<Value> = nodes .iter() .filter(|n| { let node_owner: String = n.fields().get(\"owner\").unwrap().clone().try_into().unwrap(); node_owner == ef .context() .request_context() .expect(\"Expect context.\") .username }) .map(|n| Ok(n.id()?.clone())) .collect::<Result<Vec<Value>, Error>>()?; // replace MATCH input with filtered nodes m.insert( \"MATCH\".to_string(), Value::Map(hashmap! { \"id\".to_string() => Value::Map(hashmap! { \"IN\".to_string() => Value::Array(filtered_node_ids) }) }), ); // return modified input Ok(Value::Map(m)) } else { // Return original input unmodified Ok(v) } } else { // Return original input unmodified Ok(v) } })\n} Although not necessary for this use case, the event handler could have just east as easily modified the SET portion of the update query as the MATCH, in some way adjusting the values used to update an existing node.","breadcrumbs":"Engine Features » Event Handlers » Before Node Update and Delete","id":"105","title":"Before Node Update and Delete"},"106":{"body":"The event handlers are all added to an EventHandlerBag which is then passed to the Warpgrapher engine. The registration function determines where in the life cycle the hook will be called, and in some cases, such as before and after node and relationship CRUD operation handlers, there are arguments to specify which nodes or relationships should be affected. let mut ehb = EventHandlerBag::new(); ehb.register_before_request(insert_user_profile); ehb.register_before_engine_build(add_owner_field); ehb.register_before_node_create(vec![\"Record\".to_string()], insert_owner); ehb.register_after_node_read(vec![\"Record\".to_string()], enforce_read_access); ehb.register_before_node_update(vec![\"Record\".to_string()], enforce_write_access); ehb.register_before_node_delete(vec![\"Record\".to_string()], enforce_write_access); // create warpgrapher engine let engine: Engine<Rctx> = Engine::new(config, db) .with_event_handlers(ehb) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Event Handlers » Add Handlers to the Engine","id":"106","title":"Add Handlers to the Engine"},"107":{"body":"The following GraphQL query triggers at least the first several event handlers in the call. Other queries and mutations would be needed to exercise all of them. let query = \" mutation { RecordCreate(input: { content: \\\"Test Content\\\" }) { id name } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap();","breadcrumbs":"Engine Features » Event Handlers » Example API Call","id":"107","title":"Example API Call"},"108":{"body":"See below for the full source code to the example above. use maplit::hashmap;\nuse std::collections::HashMap;\nuse std::convert::TryFrom;\nuse std::convert::TryInto;\nuse warpgrapher::engine::config::{Configuration, Property, UsesFilter};\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::CrudOperation;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::events::{EventFacade, EventHandlerBag};\nuse warpgrapher::engine::objects::Node;\nuse warpgrapher::engine::value::Value;\nuse warpgrapher::juniper::BoxFuture;\nuse warpgrapher::{Engine, Error}; static CONFIG: &str = \"\nversion: 1\nmodel: - name: Record props: - name: content type: String\n\"; #[derive(Clone, Debug)]\npub struct Rctx { pub username: String,\n} impl Rctx {} impl RequestContext for Rctx { type DBEndpointType = CypherEndpoint; fn new() -> Self { Rctx { username: String::new(), } }\n} /// This event handler executes at the beginning of every request and attempts to insert the\n/// current user's profile into the request context.\nfn insert_user_profile( mut rctx: Rctx, mut _ef: EventFacade<Rctx>, _metadata: HashMap<String, String>,\n) -> BoxFuture<Result<Rctx, Error>> { Box::pin(async move { // A real implementation would likely pull a user identity from an authentication token in // metadata, or use that token to look up a full user profile in a database. In this // example, the identify is hard-coded. rctx.username = \"user-from-JWT\".to_string(); Ok(rctx) })\n} /// before_build_engine event hook\n/// Adds owner meta fields to all types in the model (though in this example, there's only one,\n/// the record type)\nfn add_owner_field(config: &mut Configuration) -> Result<(), Error> { for t in config.model.iter_mut() { let mut_props: &mut Vec<Property> = t.mut_props(); mut_props.push(Property::new( \"owner\".to_string(), UsesFilter::none(), \"String\".to_string(), false, false, None, None, )); } Ok(())\n} /// before_create event hook\n/// Inserts an owner meta property into every new node containing the id of the creator\nfn insert_owner(mut v: Value, ef: EventFacade<'_, Rctx>) -> BoxFuture<Result<Value, Error>> { Box::pin(async move { if let CrudOperation::CreateNode(_) = ef.op() { if let Value::Map(ref mut input) = v { let user_name = ef .context() .request_context() .expect(\"Expect context\") .username .to_string(); input.insert(\"owner\".to_string(), Value::String(user_name)); } } Ok(v) })\n} /// after_read event hook\n/// Filters the read nodes to those that are authorized to be read\nfn enforce_read_access( mut nodes: Vec<Node<Rctx>>, ef: EventFacade<'_, Rctx>,\n) -> BoxFuture<Result<Vec<Node<Rctx>>, Error>> { Box::pin(async move { nodes.retain(|node| { let node_owner: String = node .fields() .get(\"owner\") .unwrap() .clone() .try_into() .expect(\"Expect to find owner field.\"); node_owner == ef .context() .request_context() .expect(\"Context expected\") .username }); Ok(nodes) })\n} /// before_update event hook\n/// Filters out nodes that the user is not authorized to modify\nfn enforce_write_access( v: Value, mut ef: EventFacade<'_, Rctx>,\n) -> BoxFuture<Result<Value, Error>> { Box::pin(async move { if let Value::Map(mut m) = v.clone() { if let Some(input_match) = m.remove(\"MATCH\") { let nodes = &ef.read_nodes(\"Record\", input_match, None).await?; // filter nodes that are authorized let filtered_node_ids: Vec<Value> = nodes .iter() .filter(|n| { let node_owner: String = n.fields().get(\"owner\").unwrap().clone().try_into().unwrap(); node_owner == ef .context() .request_context() .expect(\"Expect context.\") .username }) .map(|n| Ok(n.id()?.clone())) .collect::<Result<Vec<Value>, Error>>()?; // replace MATCH input with filtered nodes m.insert( \"MATCH\".to_string(), Value::Map(hashmap! { \"id\".to_string() => Value::Map(hashmap! { \"IN\".to_string() => Value::Array(filtered_node_ids) }) }), ); // return modified input Ok(Value::Map(m)) } else { // Return original input unmodified Ok(v) } } else { // Return original input unmodified Ok(v) } })\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); let mut ehb = EventHandlerBag::new(); ehb.register_before_request(insert_user_profile); ehb.register_before_engine_build(add_owner_field); ehb.register_before_node_create(vec![\"Record\".to_string()], insert_owner); ehb.register_after_node_read(vec![\"Record\".to_string()], enforce_read_access); ehb.register_before_node_update(vec![\"Record\".to_string()], enforce_write_access); ehb.register_before_node_delete(vec![\"Record\".to_string()], enforce_write_access); // create warpgrapher engine let engine: Engine<Rctx> = Engine::new(config, db) .with_event_handlers(ehb) .build() .expect(\"Failed to build engine\"); let query = \" mutation { RecordCreate(input: { content: \\\"Test Content\\\" }) { id name } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Engine Features » Event Handlers » Full Example Source","id":"108","title":"Full Example Source"},"11":{"body":"Warpgrapher translates GraphQL queries into CRUD operations against a back-end data store, based on a configuration specifying a data model. The tutorial will return to the topic of the configuration file soon, but the first step is configuring Warpgrapher to integrate with the back-end database. Without a graph database behind it, Warpgrapher's functionality is sharply limited. Warppgrapher supports several database back-ends for graph data: Apache Tinkerpop AWS Neptune (Cypher variant) Azure Cosmos DB (Gremlin variant) Neo4J It may be possible to use Warpgrapher with other graph databases. The list above is the set that the maintainers have used previosuly. Using each of the databases above requires selecting the appropriate crate feature and setting up environment variables to provide connection information to Warpgrapher, as described below. Regardless of database, export an environment variable to control the size of the database connection pool: export WG_POOL_SIZE=8 If the WG_POOL_SIZE variable is not set, Warpgrapher defaults to a pool the same size as the number of CPUs detected. If the number of CPUs cannot be detected, Warpgrapher defaults to a pool of 8 connections.","breadcrumbs":"Configuration » Databases » Databases","id":"11","title":"Databases"},"12":{"body":"For all gremlin-based databases, such as Apache Tinkerpop and Azure Cosmos DB the following environment variables control connection to the database. WG_GREMLIN_HOST is the host name for the database to which to connect. WG_GREMLIN_READ_REPICA provides a separate host name for read-only replica nodes, if being used for additional scalability. If not set, the read pool connects to the same host as the read/write connection pool. WG_GREMLIN_PORT provides the port to which Warpgrapher should connect. WG_GREMLIN_USER is the username to use to authenticate to the database, if required. WG_GREMLIN_PASS is the password to use to authenticate to the database, if required. WG_GREMLIN_USE_TLS is set to true if Warpgrapher should connect to the database over a TLS connection, and false if not using TLS. Defaults to true. WG_GREMLIN_VALIDATE_CERTS is set to true if Warpgrapher should validate the certificate used for a TLS connection, and false. Defaults to true. Should only be set to false in non-production environments. WG_GREMLIN_LONG_IDS is set to true if Warpgrapher should use long integers for vertex and edge identifiers. If false, Warpgrapher uses strings. Defaults to false. Consult your graph database's documentation to determine what values are valid for identifiers. WG_GREMLIN_PARTITIONS is set to true if Warpgrapher should require a partition ID, and false if Warpgrapher should ignore or omit partition IDs. Defaults to false. WG_GREMLIN_SESSIONS is set to true if Warpgrapher mutations should be conducted within a single Gremlin session, which in some databases provides transactional semantics, and false if sessions should not be used. Defaults to false. WG_GREMLIN_VERSION may be set to 1, 2, or 3, to indicate the version of GraphSON serialization that should be used in communicating with the database. Defaults to 3. Example configurations for supported databases are shown below. In many cases, some environment variables are omitted for each database where the defaults are correct.","breadcrumbs":"Configuration » Databases » Gremlin-Based Databases","id":"12","title":"Gremlin-Based Databases"},"13":{"body":"Add Warpgrapher to your project config with the gremlin feature enabled. cargo.toml [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"gremlin\"] } Set up environment variables to contact your Gremlin-based DB: export WG_GREMLIN_HOST=localhost\nexport WG_GREMLIN_PORT=8182\nexport WG_GREMLIN_USER=username\nexport WG_GREMLIN_PASS=password\nexport WG_GREMLIN_USE_TLS=true\nexport WG_GREMLIN_VALIDATE_CERTS=true\nexport WG_GREMLIN_LONG_IDS=true The WG_GREMLIN_CERT environment variable is true if Warpgrapher should ignore the validity of certificates. This may be necessary in a development or test environment, but should always be set to false in production. If you do not already have a Gremlin-based database running, you can run one using Docker: docker run -it --rm -p 8182:8182 tinkerpop/gremlin-server:latest To use an interactive gremlin console to manually inspect test instances, run docker build -t gremlin-console -f tests/fixtures/gremlin-console/Dockerfile tests/fixtures/gremlin-console\ndocker run -i --net=host --rm gremlin-console:latest In the console, connect to the remote graph: :remote connect tinkerpop.server conf/remote.yaml\n:remote console","breadcrumbs":"Configuration » Databases » Apache Tinkerpop","id":"13","title":"Apache Tinkerpop"},"14":{"body":"Add Warpgrapher to your project config: cargo.toml [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"cypher\"] } Then set up environment variables to contact your Neptune DB: export WG_CYPHER_HOST=127.0.0.1\nexport WG_CYPHER_READ_REPLICAS=127.0.0.1\nexport WG_CYPHER_PORT=7687\nexport WG_CYPHER_USER=\nexport WG_CYPHER_PASS=","breadcrumbs":"Configuration » Databases » AWS Neptune","id":"14","title":"AWS Neptune"},"15":{"body":"Add Warpgrapher to your project config: cargo.toml [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"gremlin\"] } Then set up environment variables to contact your Cosmos DB: export WG_GREMLIN_HOST=*MY-COSMOS-DB*.gremlin.cosmos.azure.com\nexport WG_GREMLIN_PORT=443\nexport WG_GREMLIN_USER=/dbs/*MY-COSMOS-DB*/colls/*MY-COSMOS-COLLECTION*\nexport WG_GREMLIN_PASS=*MY-COSMOS-KEY*\nexport WG_GREMLIN_USE_TLS=true\nexport WG_GREMLIN_VALIDATE_CERTS=true\nexport WG_GREMLIN_PARTITIONS=true\nexport WG_GREMLIN_VERSION=1 Note that when setting up your Cosmos database, you must configure it to offer a Gremlin graph API. Note also that you must set your partition key to be named partitionKey, as this name for the partition key is hard-coded into Warpgrapher. (This could be changed. If that would be helpful to you, file an issue with a feature request to make the partition key name configurable. Be advised that Gremlin traversals are not executed atomically within Cosmos DB. A traversal may fail part way through if, for example, one reaches the read unit capacity limit. See this article for details. The workaround proposed in the article helps, but even idempotent queries do not guarantee atomicity. Warpgrapher does not use idempotent queries with automated retries to overcome this shortcoming of Cosmos DB, so note that if using Cosmos, there is a risk that a failed query could leave partially applied results behind.","breadcrumbs":"Configuration » Databases » Azure Cosmos DB","id":"15","title":"Azure Cosmos DB"},"16":{"body":"Add Warpgrapher to your project config. [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"cypher\"] } Then set up environment variables to contact your Neo4J DB. export WG_CYPHER_HOST=127.0.0.1\nexport WG_CYPHER_READ_REPLICAS=127.0.0.1\nexport WG_CYPHER_PORT=7687\nexport WG_CYPHER_USER=neo4j\nexport WG_CYPHER_PASS=*MY-DB-PASSWORD* Note that the WG_CYPHER_READ_REPLICAS variable is optional. It is used for Neo4J cluster configurations in which there are both read/write nodes and read-only replicas. If the WG_CYPHER_READ_REPLICAS variable is set, read-only queries will be directed to the read replicas, whereas mutations will be sent to the instance(s) at WG_CYPHER_HOST. If you do not already have a Neo4J database running, you can run one using Docker: docker run -e NEO4J_AUTH=\"${WG_CYPHER_USER}/${WG_CYPHER_PASS}\" neo4j:4.4","breadcrumbs":"Configuration » Databases » Neo4J","id":"16","title":"Neo4J"},"17":{"body":"The Quickstart demonstrated using a string constant to hold the Warpgrapher configuration. It is also possible to read the configuration from a YAML file or to build a configuration programmatically using the configuration module's API. The following three configurations are all equivalent.","breadcrumbs":"Configuration » Formats » Warpgrapher Config","id":"17","title":"Warpgrapher Config"},"18":{"body":"The following is the string constant from the Quickstart . static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String required: false\n\";","breadcrumbs":"Configuration » Formats » String Configuration","id":"18","title":"String Configuration"},"19":{"body":"The same configuration can be created in a YAML file, as follows. config.yaml version: 1\nmodel: # User - name: User props: - name: email type: String The configuration can then be loaded and used to set up a Configuration struct. main.rs let config_file = File::open(\"config.yaml\").expect(\"Could not read file\"); let config = Configuration::try_from(config_file).expect(\"Failed to parse config file\");","breadcrumbs":"Configuration » Formats » YAML File Configuration","id":"19","title":"YAML File Configuration"},"2":{"body":"First, set up the Cargo.toml file to import Warpgrapher as a dependency. There are crate features for each of the databases supported as a back-end. Use the gremlin feature to support Gremlin-based databases such as Apache Tinkerpop and Azure CosmosDB. Use cypher to support Cypher-based databases, such as AWS Neptune and Neo4J. This tutorial example uses Neo4J. Cargo.toml [dependencies]\nwarpgrapher = { version = \"0.10.4\", features = [\"cypher\"] } The src/main.rs file begins with a definition of the data model for the example: static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String required: false\n\"; Configurations are written in YAML. Although this example uses a static string for convenience, configurations may be stored in standalone files, or assembled from multiple parts. The example configuration illustrates several principles in configuring a Warpgrapher engine. The configuration format itself is versioned, for backward compatibility. The version: 1 line notes that this configuration uses version 1 of the configuration file format. Until Warpgrapher reaches version 1.0, breaking changes in the config file format are permitted. After 1.0, breaking changes will trigger an increment to the configuration version. The configuration contains a model object. The model is a list of types present in the data model. In this case, the data model has only a single type called User. Type definitions contain one or more properties on the type, listed under props. In this example, the props list contains only one property, named email. The email property is of type String. Altogether, this configuration defines a very simple data model. That data model keeps records about users, and the one property tracked for users is their email address.","breadcrumbs":"Quickstart » Configuration","id":"2","title":"Configuration"},"20":{"body":"The code below shows the creation of the same configuration programmatically. // build warpgrapher config let config = Configuration::new( 1, vec![Type::new( \"User\".to_string(), vec![Property::new( \"email\".to_string(), UsesFilter::all(), \"String\".to_string(), false, false, None, None, )], Vec::new(), EndpointsFilter::all(), )], vec![], ); The programmatic version includes some function arguments that do not appear in the YAML versions of the configuration, because they take on default values when omitted from a YAML configuration. For example, the UsesFilter on a property allows granular control over whether a property is included in create, read, update, and delete operations. This allows, among other things, the creation of read-only attributes. Similarly, the EndpointsFilter determines whether the User type has create, read, update, and delete operations exposed in the GraphQL schema. For example, if users are created by a separate account provisioning system, it might be desirable to filter out the create operation, so that the GraphQL schema doesn't allow the possibility of creating new users.","breadcrumbs":"Configuration » Formats » Programmatic Configuration","id":"20","title":"Programmatic Configuration"},"21":{"body":"The Quickstart presented a first example of a Warpgrapher configuration, shown again here. static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String required: false\n\";","breadcrumbs":"Configuration » Types » Types","id":"21","title":"Types"},"22":{"body":"Recall that the version value is used to indicate the configuration file format version to be used. Right now, the only valid value is 1. The next element in the configuration a a data model. The model object is a list of types. The example shown in the Quickstart uses many defaults for simplicity. The definition below shows the full range of options for property definitions. Don't worry about relationships between types for the moment. Those are covered in the next section . model: - name: String props: - name: String uses: create: Boolean query: Boolean update: Boolean output: Boolean type: String # Boolean | Float | ID | Int | String required: Boolean list: Boolean resolver: String validator: String endpoints: read: Boolean create: Boolean update: Boolean delete: Boolean Right under the model object is a list of types. The first attribute describing a type is a name. In the example from the Quickstart , the name of the type is User. The second attribute describing a type is props. The props attribute is a list of properties that are stored on nodes of that type. Each property is described the several configuration attributes, as follows. The name attribute is a string that identifies the property. It must be unique within the scope of the type. In the Quickstart example, the sole property on the User type is named email. The uses attribute is an object that contains four fields within it, create, query, update, and output, each a boolean value. The fields within the uses attribute control whether the property is present in various parts of the GraphQL schema. If the create attribute is true, then the property will be included in the GraphQL input for creation operations. If false, the property will be omitted from creation operations. If the query attribute is true, the property will be included in the GraphQL schema for search query input. If false, the property will be omitted from search query operations. If the update attribute is true, the property will be included in the GraphQL schema input for updating existing nodes. If false, the property will be omitted from the update schema. Lastly, if the output attribute is true, the property will be included in the GraphQL schema for nodes returned to the client. If false, the property will be omitted from the output. By default, all uses boolean attributes are true, meaning that the property is included in all relevant areas of the GraphQL schema. Selectively setting some of the uses attributes handles uses cases where a property should not be available for some operations. For example, one might set the create attribute to false if a property is a calculated value that should never be set directly. One might set update to false to make an attribute immutable -- for example, the email property of the User type might have update set to false if GraphQL clients should not be able to tamper with the identities of users. One might set output to false for properties that should never be read through the GraphQL interface, such as for keeping people from reading out a password property. The type attribute of the property definition is a String value that must take on a value of Boolean, Float, ID, Int, or String, defining type of the property. If the required attribute of the property definition is false, the property is not required (it is optional). By default this attribute is true, which means it must be provided when nodes of this type are created (unless hidden from the create use) and it must be present (non-null) when retrieving the node from Warpgrapher (again, unless hidden from the output use). If the list attribute of the property definition is true, the property is a list of scalar values of type. If list is false, the property is only a single value of that scalar type. The resolver attribute is a text key that is used to identify a custom-written resolver function. Warpgrapher allows applications to define custom resolvers that do more or different things than the default CRUD operations automatically provided by Warpgrapher itself. For example, a custom resolver might dynamically calculate a value, such as a total or average, rather than just returning a value from the database. Custom resolvers for dynamic properties are covered in greater detail later in the book. The validator attribute is a text key that is used to identify a fuction that validates an input. For example, a validation function might check an email against and email validation regex. Validation functions are covered in greater detail later in the book. Note that the endpoints attribute is on the type definition, not the property definition, as indicated by the indentation in the YAML example above. The endpoints attribute is somewhat similar to the uses boolean, but at the level of the whole type rather than a single property. If the read attribute is true, Warpgrapher will generate a query in the GraphQL schema so that node of this type can be retrieved. If false, no query will be generated. If the create attribute is true, Warpgrapher will generate a node creation mutation in the GraphQL schema. If false, no creation mutation will be generated. If the update attribute is true, Warpgrapher will generate a node update mutation in the GraphQL schema. If false, no update mutation will be generated. Lastly, if the delete attribute is true, Warpgrapher will generate a node deletion mutation in the GraphQL schema. If false, no delete mutation will be generated.","breadcrumbs":"Configuration » Types » Type Configuration","id":"22","title":"Type Configuration"},"23":{"body":"Warpgrapher uses the configuration described above to automatically generate a GraphQL schema and default resolver to create, read, update, and delete nodes of the types defined in the configuration's model section. The remainder of this section walks through the contents of the schema in detail. The top level GraphQL Query has two queries within it, as shown below. The _version query returns a scalar String with the version of the GraphQL service. The value returned is set with the with_version method on the EngineBuilder. type Query { User(input: UserQueryInput, partitionKey: String): [User!] _version: String\n} The User query, above, is generated by Warpgrapher for the retrieval of User nodes. The query takes two parameters, an input parameter that provides any search parameters that narrow down the set of Users to be retrieved, and a partitionKey. The partitionKey is described in more detail in the Databases section of the book. The query returns a User type. The UserQueryInput, defined in the schema snippet below, is use to provide search parameters to identify the User nodes to return to the client. The User node configuration had only one property, email. Warpgrapher automatically adds an id property that contains a unique identifier for nodes. In the GraphQL schema, the id is always represented as a string. However, in some Gremlin back-ends, the id may be required to be an integer, in which case the id field in the GraphQL schema will be a String that can be successfully parsed into an integer value. input UserQueryInput { email: StringQueryInput id: StringQueryInput\n} Note that the types of both email and id are StringQueryInput, not a simple String scalar. This is because the query input allows for more than just an exact match. input StringQueryInput { CONTAINS: String EQ: String GT: String GTE: String IN: [String!] LT: String LTE: String NOTCONTAINS: String NOTEQ: String NOTIN: [String!]\n} The StringQueryInput has various options for matching a String more flexibly than an exact match. The CONTAINS operator looks for the associated String value anywhere in the target property (e.g. the email or id properties of a User node). EQ looks for an exact match. GT and GTE are greater-than and great-than-or-equals, which are useful for searching for ranges based on alphabetization, as do LT and LTE. The IN operators allows for searching for any string that is within a given set of Strings. NOTCONTAINS is the opposite of CONTAINS, looking for property values that do not contain the provided String. NOTEQ looks for non-matching Strings. And finally, NOTIN matches property values that do not appear in the provided set of Strings. type User { email: String id: ID!\n} The User type is the definition of the output type for the User GraphQL query. The names are the same, but these are two distinct things in the GraphQL schema -- the User query returns an array of zero or more User types. The User type is two fields, and id and an email. The id is a unique identifier for that node, which may be an integer or a UUID, depending on the graph database used. The email string is the single property that was defined on the example schema. type Mutation { UserCreate(input: UserCreateMutationInput!, partitionKey: String): User UserDelete(input: UserDeleteInput!, partitionKey: String): Int UserUpdate(partitionKey: String, input: UserUpdateInput!): [User!]\n} In addition to providing queries to retrieve existing nodes, Warpgrapher also automatically generates GraphQL schema elements and resolvers for create, update, and delete operations. The schema snippet above shows the mutations that are generated for the User node in the example configuration. All three of the mutations take a partitionKey, which was described in the section on queries, above. Additionally, all three mutations take an input value, that provides the information necessary to complete the create, update, or delete operation, respectively. Creation operations return the created node. Update operations return all the nodes that were matched and updated. Lastly, the delete operation returns the number of nodes that were deleted. The input arguments are detailed below. input UserCreateMutationInput { email: String id: ID\n} The UserCreateMutationInput mutation input includes the email property defined in the example configuration. It also includes an id property. Note that the id property is optional. If not provided by the client, it will be set to a unique identifier by the Warpgrapher server. The reason that clients are permitted to set the id when creating nodes is to allow for offline mode support, which may require the creation of identifiers within local caches that should remain the same after synchronization with the server. input UserDeleteInput { DELETE: UserDeleteMutationInput MATCH: UserQueryInput\n} input UserDeleteMutationInput The UserDeleteInput input is used to identify which nodes to delete. Note that the MATCH part of the argument is the very same UserQueryInput type used in the User query schema element above. So searching for which nodes to delete is the same input format used to search for nodes to return in a read query. The UserDeleteMutationInput is empty right now, and may be omitted. It will become relevant later, in the discussion on relationships between nodes. input UserUpdateInput { MATCH: UserQueryInput SET: UserUpdateMutationInput\n} input UserUpdateMutationInput { email: String\n} Lastly, the UserUpdateInput input is provided to the udpate mutation in order to select the nodes that need to be updated and describe the update to be applied. The MATCH attribute is used to identify what nodes require the update. Note that the type of the MATCH attribute is UserQueryInput, which is the same type used for searching for nodes in the GraphQL query above. The SET attribute is used to provide the new values to which the matching nodes should be set. In this example, it is a single String value for the email of the User. Note that ids are set only at creation. They cannot be updated later.","breadcrumbs":"Configuration » Types » Generated Schema","id":"23","title":"Generated Schema"},"24":{"body":"The full schema, described in pieces above, is included below: input UserDeleteInput { DELETE: UserDeleteMutationInput MATCH: UserQueryInput\n} input UserQueryInput { email: StringQueryInput id: StringQueryInput\n} type Mutation { UserCreate(input: UserCreateMutationInput!, partitionKey: String): User UserDelete(input: UserDeleteInput!, partitionKey: String): Int UserUpdate(partitionKey: String, input: UserUpdateInput!): [User!]\n} input UserUpdateMutationInput { email: String\n} type Subscription input UserUpdateInput { MATCH: UserQueryInput SET: UserUpdateMutationInput\n} type Query { User(input: UserQueryInput, partitionKey: String): [User!] _version: String\n} input UserDeleteMutationInput type User { email: String id: ID!\n} input UserCreateMutationInput { email: String id: ID\n} input StringQueryInput { CONTAINS: String EQ: String GT: String GTE: String IN: [String!] LT: String LTE: String NOTCONTAINS: String NOTEQ: String NOTIN: [String!]\n}","breadcrumbs":"Configuration » Types » Full Schema Listing","id":"24","title":"Full Schema Listing"},"25":{"body":"The Quickstart example used a very simple model with only one type, containing one property. The Types section explored configuration file format and the resulting GraphQL schema in more detail. However, Warpgrapher can generate create, read, update, and delete operations for relationships between types as well. The configuration below includes describes two types and a relationship between them. version: 1\nmodel: - name: User props: - name: email type: String required: false - name: Organization props: - name: name type: String required: false rels: - name: members nodes: [User] list: true props: - name: joinDate type: String required: false The configuration above adds a second type, called Organization. The definition of the organization type contains the rels attribute, which was not seen in the earlier example. The rels attribute contains a list of permissible relationships between nodes. In this case, the configuration adds a members relationship from nodes of of the Organization type to nodes of the User type, indicating that certain users are members of an organization. The name attribute in the configuration is the name of the relationship and must be unique within the scope of that type. The nodes attribute is a list of other types that may be at the destination end of the relationship. In this case, the only type at may be a member is the User type, but in other use cases, the destination node might be allowed to be one of several types. Lastly, the list attribute is true, indicating that an Organization may have more than one member.","breadcrumbs":"Configuration » Relationships » Relationships","id":"25","title":"Relationships"},"26":{"body":"The example configuration above is fairly simple, and does not make use of several optional attributes. The definition below shows the full set of configuration options that are permissible on a relationship. model: - name: String rels: - name: String nodes: [String] # Values in the list must be other types in the model list: Boolean props: - name: String uses: create: Boolean query: Boolean update: Boolean output: Boolean type: String # Boolean | Float | ID | Int | String required: Boolean list: Boolean resolver: String validator: String endpoints: read: Boolean create: Boolean update: Boolean delete: Boolean resolver: String The snippet above shows that relationships are defined in a list under the rels attribute within a type definition. Each relationship has a name that must be unique within the scope of that type. The nodes attribute is a list of name of types within the model that can appear as destination nodes in the relationship. Note that the a type may appear in its own relationship's nodes lists. A node is permitted to have relationships to nodes of the same type. If the list attribute is true, then a node may have relationships of the same type to multiple destination nodes, modeling one-to-many relationships. If list is false, then the node may only have a single relationship of that type, to a single destination node. The props attribute on a relationship works the same way that the props attribute works on nodes, except that the properties are associated with the relationship rather than with the node. See the description of the props attribute in the section on types for more details. Similarly, the endpoints attribute on relationships works the same way that it does on nodes. The individual boolean attributes within the endpoints object control whether Warpgrapher generates GraphQL schema elements for create, read, update, and delete operations. Just as with types, the default for all the boolean values is true, meaning that by default Warpgrapher creates schema elements and resolvers for all CRUD operations. Lastly, the resolver attribute is also similar to the attribute of the same name on property definitions. The string in the resolver attribute is mapped to a custom-written Rust function provided when setting up the Warpgrapher engine. This allows systems using Warpgrapher to control the behavior of resolving some relationships. Use cases for this include dynamically-generated relationships that are computed at query time rather than being stored in the back-end data store.","breadcrumbs":"Configuration » Relationships » Relationship Configuration","id":"26","title":"Relationship Configuration"},"27":{"body":"This section describes each of the GraphQL schema elements that Warpgrapher generates for CRUD operations on relationships. Discussion of the schema elements related solely to types, absent relationships, was covered previously in the types section .","breadcrumbs":"Configuration » Relationships » Generated Schema","id":"27","title":"Generated Schema"},"28":{"body":"The top level GraphQL query object includes three (3) queries. This should make intuitive sense. The model has two nodes, Organization and User, and one relationship, the OrganizationMembers relationship from a source organization to a destination user that is a member of that organization. Warpgrapher's generated schema allows for querying either node type or the relationship between them. As will be discussed in detail below, the inputs to these query operations have a recursive structure, so that using the top level query for the relationship, it is possible to filter based on the properties of the source or destination nodes. Similarly, when querying for a node type, it is possible to add search parameters related to relationships, the destinations of those relationships, and so on. type Query { Organization( partitionKey: String input: OrganizationQueryInput ): [Organization!] OrganizationMembers( partitionKey: String input: OrganizationMembersQueryInput ): [OrganizationMembersRel!] User(partitionKey: String, input: UserQueryInput): [User!] _version: String\n}","breadcrumbs":"Configuration » Relationships » Queries in a Model with Relationships","id":"28","title":"Queries in a Model with Relationships"},"29":{"body":"In the top level GraphQL query, note that a new query, called OrganizationMembers has been generated for the relationship. This query has an input parameter, OrganizationMembersQueryInput that provides search query arguments to select the set of relationships to be returned. The OrganizationMembersQueryInput query parameter, defined below, provides a means to search for a given instance of a relationship. It is possible to search based on an id or set of IDs, and the joinDate attribute allows queries based on the properties on the relationship. In addition to using the id or another property on the relationship, the OrganizationMembersQueryInput parameter also includes a src and a dst attribute. These attributes allow Warpgrapher clients to search for relationships based on properties of the source or destination nodes joined by the relationship. input OrganizationMembersQueryInput { dst: OrganizationMembersDstQueryInput id: StringQueryInput joinDate: StringQueryInput src: OrganizationMembersSrcQueryInput\n} The two input objects for the src and dst input objects are shown below. Note that for the source query input, the only attribute is an Organization attribute that is an OrganizationQueryInput and that for the destination, the only attribute is a User attribute that is a UserQueryInput. There are two important observations here. First, the reason for having the OrganizationMembersDstQueryInput object is that a relationship might have more than one node type as a possible destination. When building the GraphQL schema, Warpgrapher has to allow for the client to query any of those possible destination nodes. In this example, the only type of destination node is a User, so that's the only possibility shown below. If the nodes list had more types of nodes, any of those node types could be queried through the OrganizationMembersDstQueryInput. The second observation is that both the OrganizationQueryInput and the UserQueryInput inputs are the same input parameters used to query for a set of nodes in the Organization and User root level GraphQL queries shown above. input OrganizationMembersSrcQueryInput { Organization: OrganizationQueryInput\n} input OrganizationMembersDstQueryInput { User: UserQueryInput\n} We'll come back to the node-based query input in a moment, in the section below on Querying for a Node. First, the code snippet below shows the schema for output from the relationship query. The relationship includes four attributes, a unique identifier for the relationship called id, joinDate for the property configured on the relationship, and src and dst attributes that represent the source and destination nodes respectively. type OrganizationMembersRel { dst: OrganizationMembersNodesUnion! id: ID! joinDate: String src: Organization!\n} The src attribute in the OrganizationMembersRel output type is an Organization type, which is exactly the same output type used for node queries, and so will be covered in the section on querying for nodes, below. The dst attribute is a little more complex. Recall from the description of the configuration schema that Warpgrapher may connect from a source node type to a destination that can be one of many node types. A GraphQL union type is used to represent the multiple destination node types that may exist. As shown in the schema snippet below, in this example of OrganizationMembersNodesUnion, there is only a single destination node type of User. A more complex configuration might have multiple node types in the union. union OrganizationMembersNodesUnion = User Note that the User type is the same type that is used to return users in queries for nodes.","breadcrumbs":"Configuration » Relationships » Querying for a Relationship","id":"29","title":"Querying for a Relationship"},"3":{"body":"Once the configuration describing the data model is in place, it takes relatively little code to get a Warpgrapher engine up and running, ready to handle all the basic CRUD operations for that data. The example creates a request context for the engine. The request context does two things. First, it tells the engine which type of database endpoint to use, which is Neo4J in this case. Second, the context provides a way for systems built on Warpgrapher to pass application-specific data into the engine for later use by custom-written endpoints and resolvers. In this example, there's no such custom data, so the context is empty other than designating a DBEndpointType of CypherEndpoint. struct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} The Warpgrapher engine is asynchronous, so the main function is set up to be executed by Tokio in this example. #[tokio::main]\nasync fn main() { Warpgrapher is invoked to parse the configuration string created in CONFIG above. // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); Next, the databse endpoint is configured using a set of environment variables. See below for the correct environment variables and values. // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); The configuration and database created above are passed to the Warpgrapher engine, as follows. // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .build() .expect(\"Failed to build engine\"); At this point, the Warpgrapher engine is created and ready to field queries. The remainder of the source code in the example file created a simple query to demonstrate that the query engine is functioning. It creates a sample GraphQL query, submits the query to the Warpgrapher engine, and then prints out the query results to stdout. In a realistic system, the Warpgrapher engine would be invoked from the handler function of an HTTP server. // execute graphql mutation to create new user let query = \" mutation { UserCreate(input: { email: \\\"a@b.com\\\" }) { id email } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // display result println!(\"result: {:#?}\", result);","breadcrumbs":"Quickstart » Source Code","id":"3","title":"Source Code"},"30":{"body":"The root GraphQL Query object has queries for each of the node types in the configuration. To see how relationships affect node queries, have a look at the Organization query, beginning with the OrganizationQueryInput definition in the snippet below. In addition to the id and name attributes for searching based on the scalar properties of the type, the schema also includes a members attribute, of type OrganizationMembersQueryInput. This is the same input object described above that's used in the root level query for the OrganizationMembers relationship. This recursive schema structure is really quite powerful, as it allows the client to query for nodes based on a combination of the node's property values, the values of properties in the relationships that it has, and the values of properties in the destination nodes at the other end of those relationships, to any level of depth. For example, it would be easy to construct a query that retrieves all of the organizations that contain a particular user as a member. For examples of relationship-based queries, see the chapter on API usage . input OrganizationQueryInput { id: StringQueryInput members: OrganizationMembersQueryInput name: StringQueryInput\n} Relationshps information can be navigated in the output type for the node, as well. The Organization output type shown in the snippet below includes both the scalar properties on the type, the id and name, as well as the relationship to the members of the Organization. The members attribute includes an input of type OrganizationMembersQueryInput. This is the same input type that is used to query for members relationships from the GraphQL root query, desribed above. This means that when retrieving Organization nodes, it's possible to filter the set of members that you want to retrieve in a nested query. Again, the recursive structure of the schema generated by Warpgrapher allows you the flexibility to query to any level of depth in a sub-graph that is needed. type Organization { id: ID! members(input: OrganizationMembersQueryInput): [OrganizationMembersRel!] name: String\n}","breadcrumbs":"Configuration » Relationships » Querying for a Node","id":"30","title":"Querying for a Node"},"31":{"body":"The GraphQL schema's top level mutation object contains nine (9) mutations. This should make intuitive sense. There are three mutations (create, update, and delete), and three kinds of things that can be mutated: organization nodes, user nodes, and membership relationships between organizations and nodes. There are quite a few nested input and output types contributing to these mutations. The high-level principle to keep in mind is that Warpgrapher allows recursive operations that support manipulation of whole sub-graphs at a time. For example, node mutations have nested input objects that allow manipulation of the relationships on those nodes, and the destination nodes at the end of those relationships, and so on. type Mutation { OrganizationCreate( input: OrganizationCreateMutationInput! partitionKey: String ): Organization OrganizationDelete(partitionKey: String, input: OrganizationDeleteInput!): Int OrganizationMembersCreate( input: OrganizationMembersCreateInput! partitionKey: String ): [OrganizationMembersRel!] OrganizationMembersDelete( input: OrganizationMembersDeleteInput! partitionKey: String ): Int OrganizationMembersUpdate( partitionKey: String input: OrganizationMembersUpdateInput! ): [OrganizationMembersRel!] OrganizationUpdate( partitionKey: String input: OrganizationUpdateInput! ): [Organization!] UserCreate(input: UserCreateMutationInput!, partitionKey: String): User UserDelete(partitionKey: String, input: UserDeleteInput!): Int UserUpdate(partitionKey: String, input: UserUpdateInput!): [User!]\n}","breadcrumbs":"Configuration » Relationships » Mutations in a Model with Relationships","id":"31","title":"Mutations in a Model with Relationships"},"32":{"body":"Creating a Relationship The snippet below contains the input for creation of one or more OrganizationMembers relationships. There are two attributes, MATCH and CREATE. The MATCH attribute is used to identify the organization or organizations that should be matched as the source of the relationship(s) to be created. It has the same type, OrganizationQueryInput that is used to query for nodes using the Organization query under the GraphQL Query root described above. The match query may select more than one node, allowing similar relationships to be created in bulk. Matching existing source nodes is the only option when creating a relationship. If it is necessary to create the node at the source end of the relationship, see the node creation operation, in this case OrganizationCreate instead. input OrganizationMembersCreateInput { CREATE: [OrganizationMembersCreateMutationInput!] MATCH: OrganizationQueryInput\n} The CREATE attribute has a type of OrganizationMembersCreateMutationInput. That input structure is shown in the schema snippet below. It includes the joinDate attribute on the relationship. The id object is accepted as an input to facilitate offline operation, in which the client may need to choose the unique identifier for the relationship. If the client does not choose the identifier, it will be randomly assigned by the Warpgrapher service. input OrganizationMembersCreateMutationInput { dst: OrganizationMembersNodesMutationInputUnion! id: ID joinDate: String\n} The dst property in the OrganizationMembersCreateMutationInput above is of type OrganizationMembersNodesMutationInputUnion, which is included in the schema snippet below. Don't be intimidated by the lengthy name of the union type. Recall that in the configuration above, the destination type of a relationship is allowed to have more than one type. In this configuration, it only has one type, but the OrganizationMembersNodesMutationInputUnion is what allows the destination of the relationship to have multiple types. In this case, the only option is User, with a type of UserInput. input OrganizationMembersNodesMutationInputUnion { User: UserInput\n} The UserInput type, which provides the destination node for the relationship(s) to be created, has two attributes. When using the EXISTING attribute, Warpgrapher search the graph database for a set of nodes matching the UserQueryInput search criteria and uses the results as the destination nodes for creation of the relationship(s). Note that this UserQueryInput type is the same input type that is used to query for users in the user query under the GraphQL root Query. No matter where in the recursive hierarchy, searhing for User nodes always uses the same input. The NEW attribute creates a new User node as the destination of the relationship. Note that the UserCreateMutationInput input type is the same input type used to create a User node in the UserCreate mutation under the GraphQL root Mutation object. input UserInput { EXISTING: UserQueryInput NEW: UserCreateMutationInput\n} The output of creating one or more relationships, OrganizationMembersRel, is the same output type returned from querying for the organization's members relationship, as was described in the section on queries, above. It contains the newly created relationship. Updating a Relationship The input for a relationship update mutation, OrganizationMembersUpdateInput is shown in the schema snippet below. The update input consists of two parts. The MATCH attribute is a query input to identify the relationships that should be updated. Note that the match input type, OrganizationMembersQueryInput is the same input type used to provide search parameters when searching for relationships under the OrganizationMembers query under the GraphQL root Query object. The SET attribute is used to describe the changes that should be made to values in the relationship(s) matched by the MATCH parameter, and potentially the sub-graph beneath. input OrganizationMembersUpdateInput { MATCH: OrganizationMembersQueryInput SET: OrganizationMembersUpdateMutationInput!\n} The SET input is of type OrganizationMembersUpdateMutationInput, shown in the snippet below. The joinDate attribute is the same input type used during relationship creation operations, described in the section above. The src and dst attributes allow a single update to provide new values not only for the relationship properties, but also properties on the source and destination nodes at the ends of the relationship. input OrganizationMembersUpdateMutationInput { dst: OrganizationMembersDstUpdateMutationInput joinDate: String src: OrganizationMembersSrcUpdateMutationInput\n} The source and destination node input types are shown in the schema snippets below. Note that the types, OrganizationUpdateMutationInput and UserUpdateMutationInput are the same input types used for the SET attributes in the single node update operation, described in in the section on single-node mutation operations below. Thus, we have hit the point where the GraphQL schema structure that Warpgrapher generates is recursive. A relationship update mutation can update the properties on the relationship, as described just above, or using this recursive input structure, reach down into the source and destination nodes at the ends of the relationship and edit their properties as well. input OrganizationMembersSrcUpdateMutationInput { Organization: OrganizationUpdateMutationInput\n} input OrganizationMembersDstUpdateMutationInput { User: UserUpdateMutationInput\n} The output for updating one or more relationships, OrganizationMembersRel, is the same output type returned from querying for an organization's members relationship, as was described in the section on queries, above. For update operations, it returns the list of relationships that were updated in the mutation. Deleting a Relationship The input for a relationship delete mutation, OrganizationMembersDeleteInput, is shown in the schema snippet below. The MATCH attribute is used to query for the relationships that are desired to be deleted. Note that the input type, OrganizationMembersQueryInput is the same input type used to query for relationships under the relationship query in the GraphQL root Query object, described in the section on querying, above. input OrganizationMembersDeleteInput { MATCH: OrganizationMembersQueryInput dst: OrganizationMembersDstDeleteMutationInput src: OrganizationMembersSrcDeleteMutationInput\n} The src and destination delete mutation inputs are not particularly interesting for this simple schema. The input type for the src of the relationship contains a single Organization attribute that has the same type as the deletion input for an OrganizationDelete mutation. However, the only option in that type is deletion of members, which is what is already being done. On the destination side, because the User type has no relationships of its own, the UserDeleteMutationInput object is empty altogether. Thus, for the most part, the src and dst attriubtes on the OrganizationMembersDeleteInput are not particularly useful, though in more complex models, they allows the possibility of deleting multiple nodes and relationships in a single query. input OrganizationMembersSrcDeleteMutationInput { Organization: OrganizationDeleteMutationInput\n} input OrganizationMembersDstDeleteMutationInput { User: UserDeleteMutationInput\n} input OrganizationDeleteMutationInput { members: [OrganizationMembersDeleteInput!]\n} input UserDeleteMutationInput The output from the relationship deletion mutation is an integer with a count of the relationships deleted.","breadcrumbs":"Configuration » Relationships » Mutating a Relationship","id":"32","title":"Mutating a Relationship"},"33":{"body":"In many ways, modifying a node in a data model that includes relationships is similar to what was described in the node-only portion of the book, previously. Thus, this section doesn't repeat that same content, instead focusing only on the changes the come from having a relationship in the mix. Creating a Node The snippet below contains the input for creation of an organization. Note the members attribute, of type OrganizationMembersCreateMutationInput, which allows for the creation of members attributes in the same mutation that creates the organization. The OrganizationMembersCreateMutationInput input type is the same one that is used for the CREATE attribute in the OrganizationMembersCreate mutation under the root GraphQL mutation object. Thus, when creating a node, you can create members for it using the same full flexbility provided by the mutation dedicated to creating relationships. The recursive nature of the creation inputs allows for the creation of entire sub-graphs. input OrganizationCreateMutationInput { id: ID members: [OrganizationMembersCreateMutationInput!] name: String\n} The rest of the inputs and output for the node creation mutation are the same as those described previously for a simpler model without relationships.","breadcrumbs":"Configuration » Relationships » Mutating a Node","id":"33","title":"Mutating a Node"},"34":{"body":"The OrganizationUpdateInput for making changes to organizations looks similar to the input types used for objects that don't have relationships. It has a MATCH attribute to select the objects to update, and a SET attribute to describe the changes to be made. The difference is in the input OrganizationUpdateInput { MATCH: OrganizationQueryInput SET: OrganizationUpdateMutationInput\n} input OrganizationUpdateMutationInput { members: [OrganizationMembersChangeInput!] name: String\n} The differences for the inclusion of relationships begin in the OrganizationUpdateMutationInput input type used to set new values for the nodes to be updated, which includes a members attribute of type OrganizationMembersChangeInput. There are three changes one could make to a relationship: add one or more new relationships to destination nodes, delete one or more relationships to destination nodes, or keep the relationships to the same set of destination nodes but make changes to the properties of one or more of those destination nodes. Those options are captured in the OrganizationMembersChangeInput input type in the schema snippet below. input OrganizationMembersChangeInput { ADD: OrganizationMembersCreateMutationInput DELETE: OrganizationMembersDeleteInput UPDATE: OrganizationMembersUpdateInput\n} The OrganizationMembersCreateMutationInput input type for the ADD operation is the same one that was described above as the CREATE attribute the section on mutations to create new relationships. This makes sense, as in this context it is already clear what the source node or nodes are, and the ADD attribute need only create the new relationships to be added. Similarly, the OrganizationMembersDeleteInput used for the DELETE attribute here is the same one that is used for the OrganizationMembersDelete operation under the root GraphQL Mutation type. The match will be scoped to the relationships under the source node(s) selected by the OrganizationUpdateInput MATCH query. As expected, the same is true for the OrganizationMembersUpdateInput input type used for the UPDATE attribute. It's the same as the input used for the OrganizationMembersUpdate mutation under the root GraphQL Mutation type.","breadcrumbs":"Configuration » Relationships » Updating a Node","id":"34","title":"Updating a Node"},"35":{"body":"The OrganizationDeleteInput input type, shown in the schema snippet below, looks similar to the one for nodes without relationships. However, the OrganizationDeleteMutationInput is different, as it includes a members attribute of type OrganizationMembersDeleteInput, which is the same type used for the OrganizationMembersDelete mutation under the GraphQL root Mutation type. In the case of this model, this additional input does little. In a more complex model with multiple types of relationships, however, it would allow for deletion of whole subgraphs of nodes and relationships. input OrganizationDeleteInput { DELETE: OrganizationDeleteMutationInput MATCH: OrganizationQueryInput\n} input OrganizationDeleteMutationInput { members: [OrganizationMembersDeleteInput!]\n}","breadcrumbs":"Configuration » Relationships » Deleting a Node","id":"35","title":"Deleting a Node"},"36":{"body":"The full schema for the example above is included below. input OrganizationMembersDeleteInput { MATCH: OrganizationMembersQueryInput dst: OrganizationMembersDstDeleteMutationInput src: OrganizationMembersSrcDeleteMutationInput\n} input OrganizationCreateMutationInput { id: ID members: [OrganizationMembersCreateMutationInput!] name: String\n} input OrganizationMembersCreateInput { CREATE: [OrganizationMembersCreateMutationInput!] MATCH: OrganizationQueryInput\n} input OrganizationMembersSrcQueryInput { Organization: OrganizationQueryInput\n} type Mutation { OrganizationCreate( input: OrganizationCreateMutationInput! partitionKey: String ): Organization OrganizationDelete(partitionKey: String, input: OrganizationDeleteInput!): Int OrganizationMembersCreate( input: OrganizationMembersCreateInput! partitionKey: String ): [OrganizationMembersRel!] OrganizationMembersDelete( input: OrganizationMembersDeleteInput! partitionKey: String ): Int OrganizationMembersUpdate( partitionKey: String input: OrganizationMembersUpdateInput! ): [OrganizationMembersRel!] OrganizationUpdate( partitionKey: String input: OrganizationUpdateInput! ): [Organization!] UserCreate(input: UserCreateMutationInput!, partitionKey: String): User UserDelete(partitionKey: String, input: UserDeleteInput!): Int UserUpdate(partitionKey: String, input: UserUpdateInput!): [User!]\n} input OrganizationMembersChangeInput { ADD: OrganizationMembersCreateMutationInput DELETE: OrganizationMembersDeleteInput UPDATE: OrganizationMembersUpdateInput\n} input UserUpdateMutationInput { email: String\n} input UserDeleteInput { DELETE: UserDeleteMutationInput MATCH: UserQueryInput\n} input OrganizationMembersNodesMutationInputUnion { User: UserInput\n} input UserInput { EXISTING: UserQueryInput NEW: UserCreateMutationInput\n} input OrganizationQueryInput { id: StringQueryInput members: OrganizationMembersQueryInput name: StringQueryInput\n} union OrganizationMembersNodesUnion = User type Query { Organization( partitionKey: String input: OrganizationQueryInput ): [Organization!] OrganizationMembers( partitionKey: String input: OrganizationMembersQueryInput ): [OrganizationMembersRel!] User(partitionKey: String, input: UserQueryInput): [User!] _version: String\n} input OrganizationMembersDstDeleteMutationInput { User: UserDeleteMutationInput\n} input OrganizationMembersUpdateInput { MATCH: OrganizationMembersQueryInput SET: OrganizationMembersUpdateMutationInput!\n} input OrganizationMembersSrcUpdateMutationInput { Organization: OrganizationUpdateMutationInput\n} input UserUpdateInput { MATCH: UserQueryInput SET: UserUpdateMutationInput\n} input OrganizationUpdateInput { MATCH: OrganizationQueryInput SET: OrganizationUpdateMutationInput\n} type OrganizationMembersRel { dst: OrganizationMembersNodesUnion! id: ID! joinDate: String src: Organization!\n} input OrganizationMembersUpdateMutationInput { dst: OrganizationMembersDstUpdateMutationInput joinDate: String src: OrganizationMembersSrcUpdateMutationInput\n} input OrganizationMembersSrcDeleteMutationInput { Organization: OrganizationDeleteMutationInput\n} input UserQueryInput { email: StringQueryInput id: StringQueryInput\n} input OrganizationMembersQueryInput { dst: OrganizationMembersDstQueryInput id: StringQueryInput joinDate: StringQueryInput src: OrganizationMembersSrcQueryInput\n} input OrganizationDeleteMutationInput { members: [OrganizationMembersDeleteInput!]\n} type Organization { id: ID! members(input: OrganizationMembersQueryInput): [OrganizationMembersRel!] name: String\n} input OrganizationUpdateMutationInput { members: [OrganizationMembersChangeInput!] name: String\n} type Subscription input OrganizationMembersCreateMutationInput { dst: OrganizationMembersNodesMutationInputUnion! id: ID joinDate: String\n} input UserDeleteMutationInput input OrganizationMembersDstUpdateMutationInput { User: UserUpdateMutationInput\n} type User { email: String id: ID!\n} input OrganizationMembersDstQueryInput { User: UserQueryInput\n} input UserCreateMutationInput { email: String id: ID\n} input StringQueryInput { CONTAINS: String EQ: String GT: String GTE: String IN: [String!] LT: String LTE: String NOTCONTAINS: String NOTEQ: String NOTIN: [String!]\n} input OrganizationDeleteInput { DELETE: OrganizationDeleteMutationInput MATCH: OrganizationQueryInput\n}","breadcrumbs":"Configuration » Relationships » Full Schema Listing","id":"36","title":"Full Schema Listing"},"37":{"body":"One of the primary features of Warpgrapher is the auto-generation of CRUD operations for all Types. This includes basic and advanced queries that support nested operations and graph traversals. The schema itself was described in the preceeding sections. This chapter provides a set of usage examples for the various queries and mutations, for both nodes and relationships. For for more details on general GraphQL syntax, see: https://graphql.org/learn/.","breadcrumbs":"CRUD API Usage Examples » Warpgrapher CRUD API","id":"37","title":"Warpgrapher CRUD API"},"38":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. Node with No Relationships Node Related to a New Node Node Related to an Existing Node","breadcrumbs":"CRUD API Usage Examples » Node Create » Node Create","id":"38","title":"Node Create"},"39":{"body":"The GraphQL query below creates a new organization. mutation { OrganizationCreate(input: { name: \"Warpforge\" }) { id name }\n} The output is as follows. { \"data\": { \"OrganizationCreate\": { \"id\": \"edff7816-f40c-4be1-904a-b7ab62e60be1\", \"name\": \"Warpforge\" } }\n}","breadcrumbs":"CRUD API Usage Examples » Node Create » Node with No Relationships","id":"39","title":"Node with No Relationships"},"4":{"body":"Configure database settings using the following environment variables: export WG_CYPHER_HOST=127.0.0.1\nexport WG_CYPHER_PORT=7687\nexport WG_CYPHER_USER=neo4j\nexport WG_CYPHER_PASS=*MY-DB-PASSWORD* Start a 4.1 Neo4j database: docker run --rm -p 7687:7687 -e NEO4J_AUTH=\"${WG_CYPHER_USER}/${WG_CYPHER_PASS}\" neo4j:4.4","breadcrumbs":"Quickstart » Database","id":"4","title":"Database"},"40":{"body":"The GraphQL query below creates a new organization with a relationship to a member who is a new user. mutation { OrganizationCreate( input: { name: \"Just Us League\" members: { joinDate: \"2020-02-20\", dst: { User: { NEW: { email: \"alistair@example.com\" } } } } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows. { \"data\": { \"OrganizationCreate\": { \"id\": \"a33ab37b-af51-4ccd-88ee-7d4d6eb75de9\", \"name\": \"Just Us League\", \"members\": [ { \"id\": \"295d191f-0d66-484c-b1eb-39494f0ae8a0\", \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"5ca84494-dd14-468e-812f-cb2da07157db\", \"email\": \"alistair@example.com\" } } ] } }\n}","breadcrumbs":"CRUD API Usage Examples » Node Create » Node Related to a New Node","id":"40","title":"Node Related to a New Node"},"41":{"body":"The GraphQL query below creates a new organization with new relationship to an existing member, alistair@example.com, the same user created in the example above. mutation { OrganizationCreate( input: { name: \"Consortia Unlimited\" members: { joinDate: \"2020-02-20\", dst: { User: { EXISTING: { email: \"alistair@example.com\" } } } } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows: { \"data\": { \"OrganizationCreate\": { \"id\": \"9ecef884-2afc-457e-8486-e1f84c761050\", \"name\": \"Consortia Unlimited\", \"members\": [ { \"id\": \"008fdc43-f3cf-48eb-a9e9-c5c753c65ee9\", \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"5ca84494-dd14-468e-812f-cb2da07157db\", \"email\": \"alistair@example.com\" } } ] } }\n} Note that the id for the member in this example is the same as that in the last example, because the relationship was created to the same user.","breadcrumbs":"CRUD API Usage Examples » Node Create » Node Related to an Existing Node","id":"41","title":"Node Related to an Existing Node"},"42":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. All Nodes Node with Matching Properties Node with Matching Relationships Node with Matching Destinations","breadcrumbs":"CRUD API Usage Examples » Node Read » Node Read","id":"42","title":"Node Read"},"43":{"body":"The GraphQL query below lists all organizations. query { Organization { id name }\n} The output is as follows. { \"data\": { \"Organization\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Just Us League\" }, { \"id\": \"5692bd2a-2bc9-4497-8285-1f7860478cd6\", \"name\": \"Consortia Unlimited\" }, { \"id\": \"1eea1d47-1fe8-4bed-9116-e0037fbdb296\", \"name\": \"Warpforge\" } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Read » All Nodes","id":"43","title":"All Nodes"},"44":{"body":"The GraphQL query below lists all organizations with the name Warpforge. query { Organization(input: { name: { EQ: \"Warpforge\" } }) { id name }\n} The output is as follows. { \"data\": { \"Organization\": [ { \"id\": \"1eea1d47-1fe8-4bed-9116-e0037fbdb296\", \"name\": \"Warpforge\" } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Read » Node with Matching Properties","id":"44","title":"Node with Matching Properties"},"45":{"body":"The GraphQL query below lists all organizations with members that joined in 2020. query { Organization( input: { members: { joinDate: { CONTAINS: \"2020\" } } } ) { id name members { joinDate dst { ... on User { id email } } } }\n} The output is as follows: { \"data\": { \"Organization\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Just Us League\", \"members\": [ { \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] }, { \"id\": \"5692bd2a-2bc9-4497-8285-1f7860478cd6\", \"name\": \"Consortia Unlimited\", \"members\": [ { \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Read » Node with Matching Relationships","id":"45","title":"Node with Matching Relationships"},"46":{"body":"The GraphQL query below lists all the organizations of which the user alistair@example.com is a member. query { Organization( input: { members: { dst: { User: { email: { EQ: \"alistair@example.com\" } } } } } ) { id name members { joinDate dst { ... on User { id email } } } }\n} The output is as follows: { \"data\": { \"Organization\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Just Us League\", \"members\": [ { \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] }, { \"id\": \"5692bd2a-2bc9-4497-8285-1f7860478cd6\", \"name\": \"Consortia Unlimited\", \"members\": [ { \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Read » Node with Matching Destinations","id":"46","title":"Node with Matching Destinations"},"47":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. Match Node Properties Match Destination Properties Add a Destination Node Update a Destination Node Delete a Relationship","breadcrumbs":"CRUD API Usage Examples » Node Update » Node Update","id":"47","title":"Node Update"},"48":{"body":"The GraphQL query below match a node based on its properties and updates it. mutation { OrganizationUpdate( input: { MATCH: { name: { EQ: \"Warpforge\" } } SET: { name: \"Harsh Truth Heavy Industries\" } } ) { id name }\n} The output is as follows. { \"data\": { \"OrganizationUpdate\": [ { \"id\": \"1eea1d47-1fe8-4bed-9116-e0037fbdb296\", \"name\": \"Harsh Truth Heavy Industries\" } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Update » Match Node Properties","id":"48","title":"Match Node Properties"},"49":{"body":"The GraphQL query below matches a node based on properties on a desination node to which it is related, then updates it. mutation { OrganizationUpdate( input: { MATCH: { members: { dst: { User: { email: { EQ: \"balthazar@example.com\" } } } } } SET: { name: \"Prophet and Loss Inc.\" } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows. { \"data\": { \"OrganizationUpdate\": [ { \"id\": \"5692bd2a-2bc9-4497-8285-1f7860478cd6\", \"name\": \"Prophet and Loss Inc.\", \"members\": [ { \"id\": \"78acc7ac-2153-413d-a8d7-688e472340d5\", \"joinDate\": \"2021-01-02\", \"dst\": { \"id\": \"ea2a1b68-fda2-4adb-9c80-554761a1c97b\", \"email\": \"balthazar@example.com\" } }, { \"id\": \"00051bc1-133c-445d-b00c-4faf61b2bffa\", \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Update » Match Destination Properties","id":"49","title":"Match Destination Properties"},"5":{"body":"Run the example using cargo as follows. cargo run The output from the example should look something like the following. result: Object({ \"data\": Object({ \"UserCreate\": Object({ \"id\": String( \"7e1e3497-dcfd-4579-b690-86b110c8f96a\", ), \"email\": String( \"a@b.com\", ), }), }),\n}) The identifier will be a different UUID than the one shown above, of course.","breadcrumbs":"Quickstart » Run","id":"5","title":"Run"},"50":{"body":"The GraphQL query below updates the Warpforge organization to add an additional, newly created user. If an EXISTING attribute were used in place of NEW in the query below, one could query for existing users to add to the organization. mutation { OrganizationUpdate( input: { MATCH: { name: { EQ: \"Warpforge\" } } SET: { members: { ADD: { joinDate: \"2018-01-08\", dst: { User: { NEW: { email: \"constantine@example.com\" } } } } } } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows. { \"data\": { \"OrganizationUpdate\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\", \"members\": [ { \"id\": \"38cd72c8-75b5-4547-9829-38d6a6854eb9\", \"joinDate\": \"2018-01-08\", \"dst\": { \"id\": \"f2e894bf-e98e-48a7-b16a-adc95cd34ac3\", \"email\": \"constantine@example.com\" } }, { \"id\": \"bd302b7f-8a3f-49ab-aac3-c3348d8b8d94\", \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Update » Add a Destination Node","id":"50","title":"Add a Destination Node"},"51":{"body":"The GraphQL query below updates a value on a destination node. mutation { OrganizationUpdate( input: { MATCH: { name: { EQ: \"Warpforge\" } } SET: { members: { UPDATE: { MATCH: { dst: { User: { email: { EQ: \"constantine@example.com\" } } } } SET: { dst: { User: { email: \"javier@example.com\" } } } } } } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows. { \"data\": { \"OrganizationUpdate\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\", \"members\": [ { \"id\": \"38cd72c8-75b5-4547-9829-38d6a6854eb9\", \"joinDate\": \"2018-01-08\", \"dst\": { \"id\": \"f2e894bf-e98e-48a7-b16a-adc95cd34ac3\", \"email\": \"javier@example.com\" } }, { \"id\": \"bd302b7f-8a3f-49ab-aac3-c3348d8b8d94\", \"joinDate\": \"2020-02-20\", \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Update » Update a Destination Node","id":"51","title":"Update a Destination Node"},"52":{"body":"The GraphQL query below deletes the relationship from the Warpforge organization to alistair@example.com, removing them as a member of the organization. mutation { OrganizationUpdate( input: { MATCH: { name: { EQ: \"Warpforge\" } } SET: { members: { DELETE: { MATCH: { dst: { User: { email: { EQ: \"alistair@example.com\" } } } } } } } } ) { id name members { id joinDate dst { ... on User { id email } } } }\n} The output is as follows. { \"data\": { \"OrganizationUpdate\": [ { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\", \"members\": [ { \"id\": \"38cd72c8-75b5-4547-9829-38d6a6854eb9\", \"joinDate\": \"2018-01-08\", \"dst\": { \"id\": \"f2e894bf-e98e-48a7-b16a-adc95cd34ac3\", \"email\": \"javier@example.com\" } } ] } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Node Update » Delete a Relationship","id":"52","title":"Delete a Relationship"},"53":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. Node with Matching Properties","breadcrumbs":"CRUD API Usage Examples » Node Delete » Node Delete","id":"53","title":"Node Delete"},"54":{"body":"The GraphQL query below deletes a node based on matching against its properties. mutation { OrganizationDelete( input: { MATCH: { name: { EQ: \"Harsh Truth Heavy Industries\" } } } )\n} The output is as follows, indicating that one organization was successfully deleted. { \"data\": { \"OrganizationDelete\": 1 }\n}","breadcrumbs":"CRUD API Usage Examples » Node Delete » Node with Matching Properties","id":"54","title":"Node with Matching Properties"},"55":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. Between Existing Nodes From an Existing to a New Node","breadcrumbs":"CRUD API Usage Examples » Relationship Create » Relationship Create","id":"55","title":"Relationship Create"},"56":{"body":"The GraphQL query below creates a new membership relationship between two existing nodes, adding alistair@example.com to the Warpforge projct. mutation { OrganizationMembersCreate( input: { MATCH: { name: { EQ: \"Warpforge\" } } CREATE: { joinDate: \"2022-01-28\", dst: { User: { EXISTING: { email: { EQ: \"alistair@example.com\" } } } } } } ) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembersCreate\": [ { \"id\": \"21173765-b2a3-4bb1-bfa7-5787ef17d6a8\", \"joinDate\": \"2022-01-28\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Create » Between Existing Nodes","id":"56","title":"Between Existing Nodes"},"57":{"body":"The GraphQL below creates a new membership relationship from an existing organization to a newly created user. mutation { OrganizationMembersCreate( input: { MATCH: { name: { EQ: \"Warpforge\" } } CREATE: { joinDate: \"2022-01-28\", dst: { User: { NEW: { email: \"constantine@example.com\" } } } } } ) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembersCreate\": [ { \"id\": \"3ab33be6-16a3-4e50-87b5-3bb7d195ea54\", \"joinDate\": \"2022-01-28\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"c2b71308-2fd7-4d43-b037-30ec473e90a5\", \"email\": \"constantine@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Create » From an Existing to a New Node","id":"57","title":"From an Existing to a New Node"},"58":{"body":"The GraphQL API examples below use the example schema described in the Relationships section of the book. The unique IDs for nodes and relationships in the examples below may differ than other sections and chapters of the book. By Relationship Properties By Source Node By Destination Node","breadcrumbs":"CRUD API Usage Examples » Relationship Read » Relationship Read","id":"58","title":"Relationship Read"},"59":{"body":"The GraphQL query below retrieves all the members who joined organizations on 2018-01-08. query { OrganizationMembers(input: { joinDate: { EQ: \"2018-01-08\" } }) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembers\": [ { \"id\": \"38cd72c8-75b5-4547-9829-38d6a6854eb9\", \"joinDate\": \"2018-01-08\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"f2e894bf-e98e-48a7-b16a-adc95cd34ac3\", \"email\": \"javier@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Read » By Relationship Properties","id":"59","title":"By Relationship Properties"},"6":{"body":"The full example source code listing is below: src/main.rs use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String required: false\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .build() .expect(\"Failed to build engine\"); // execute graphql mutation to create new user let query = \" mutation { UserCreate(input: { email: \\\"a@b.com\\\" }) { id email } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // display result println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Quickstart » Full Example Code","id":"6","title":"Full Example Code"},"60":{"body":"The GraphQL query below retrieves all the members of users in the Warpforge organization. query { OrganizationMembers( input: { src: { Organization: { name: { EQ: \"Warpforge\" } } } } ) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembers\": [ { \"id\": \"3ab33be6-16a3-4e50-87b5-3bb7d195ea54\", \"joinDate\": \"2022-01-28\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"c2b71308-2fd7-4d43-b037-30ec473e90a5\", \"email\": \"constantine@example.com\" } }, { \"id\": \"21173765-b2a3-4bb1-bfa7-5787ef17d6a8\", \"joinDate\": \"2022-01-28\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } }, { \"id\": \"38cd72c8-75b5-4547-9829-38d6a6854eb9\", \"joinDate\": \"2018-01-08\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"f2e894bf-e98e-48a7-b16a-adc95cd34ac3\", \"email\": \"javier@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Read » By Source Node","id":"60","title":"By Source Node"},"61":{"body":"The GraphQL query below retrieves all of the members of alistair@example.com. query { OrganizationMembers( input: { dst: { User: { email: { EQ: \"alistair@example.com\" } } } } ) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembers\": [ { \"id\": \"21173765-b2a3-4bb1-bfa7-5787ef17d6a8\", \"joinDate\": \"2022-01-28\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } }, { \"id\": \"00051bc1-133c-445d-b00c-4faf61b2bffa\", \"joinDate\": \"2020-02-20\", \"src\": { \"id\": \"5692bd2a-2bc9-4497-8285-1f7860478cd6\", \"name\": \"Prophet and Loss Inc.\" }, \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Read » By Destination Node","id":"61","title":"By Destination Node"},"62":{"body":"Update Relationship Properties","breadcrumbs":"CRUD API Usage Examples » Relationship Update » Relationship Update","id":"62","title":"Relationship Update"},"63":{"body":"The GraphQL updates the date on a membership. mutation { OrganizationMembersUpdate( input: { MATCH: { src: { Organization: { name: \"Warpforge\" } } dst: { User: { email: \"alistair@example.com\" } } } SET: { joinDate: \"2021-12-31\" } } ) { id joinDate src { id name } dst { ... on User { id email } } }\n} The output is as follows. { \"data\": { \"OrganizationMembersUpdate\": [ { \"id\": \"21173765-b2a3-4bb1-bfa7-5787ef17d6a8\", \"joinDate\": \"2021-12-31\", \"src\": { \"id\": \"85faa40f-04a8-4f0a-ae44-804604b4ef4c\", \"name\": \"Warpforge\" }, \"dst\": { \"id\": \"de5e58cd-eb5e-4bf8-8a7a-9656999f4013\", \"email\": \"alistair@example.com\" } } ] }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Update » Update Relationship Properties","id":"63","title":"Update Relationship Properties"},"64":{"body":"Delete Relationship","breadcrumbs":"CRUD API Usage Examples » Relationship Delete » Relationship Delete","id":"64","title":"Relationship Delete"},"65":{"body":"The GraphQL mutation { OrganizationMembersDelete( input: { MATCH: { src: { Organization: { name: { EQ: \"Warpforge\" } } } dst: { User: { email: { EQ: \"constantine@example.com\" } } } } } )\n} The output is as follows. { \"data\": { \"OrganizationMembersDelete\": 1 }\n}","breadcrumbs":"CRUD API Usage Examples » Relationship Delete » Delete relationship","id":"65","title":"Delete relationship"},"66":{"body":"As shown in the previous chapters, Warpgrapher offers a considerable amount of power and flexibility out of the box. With a configuration describing a data model and a little bit of server integration code, it is possible to stand up a fully functional GraphQL service, with automatically generated CRUD operations for nodes and relationships. The recursive structure of the schema allows for single queries and mutations over arbitrarily deep sub-graphs. However, these features by themselves are still not enough for a production service. A robust production system will doubtless need to validate inputs. It will likely need to conduct authorization checks on requests as a security control. It will need to include business logic that does calculations over existing data or launches additional workflows. This chapter discusses the extensibility features of the Warpgrapher engine make it possible to build a real GraphQL API service on top of the foundation that Warpgrapher provides.","breadcrumbs":"Engine Features » Engine Features","id":"66","title":"Engine Features"},"67":{"body":"Warpgrapher includes built-in static endpoints that provide useful information or functionality. Built-in static endpoints names are preceded by _.","breadcrumbs":"Engine Features » Static Endpoints » Static Endpoints","id":"67","title":"Static Endpoints"},"68":{"body":"If the Engine is built with an explicit version: let mut server: Engine<()> = Engine::new(config, db) .with_version(\"0.1.0\".to_string()) .build(); the version value can be accessed via the _version endpoint: query { _version\n} { \"data\": { \"_version\": \"0.1.0\" }\n} If the server is not configured with an explicit version, the _version endpoint will return null: { \"data\": { \"_version\": null }\n}","breadcrumbs":"Engine Features » Static Endpoints » Version","id":"68","title":"Version"},"69":{"body":"In addition to the CRUD endpoints auto-generated for each type, Warpgrapher provides the ability to define additional custom endpoints.","breadcrumbs":"Engine Features » Defined Endpoints » Defined Endpoints","id":"69","title":"Defined Endpoints"},"7":{"body":"The Warpgrapher engine does not come with a bundled HTTP server. Instead, it can be integrated with the HTTP server framework of choice for a given application. Or, instead, it can be invoked in other ways, such as from a lambda function.","breadcrumbs":"Server Integration » Server Integration","id":"7","title":"Server Integration"},"70":{"body":"The schema for an endpoint entry in the Warpgrapher configuration is as follows. endpoints: - name: String class: String # /Mutation | Query/ input: # null if there is no input parameter type: String list: Boolean required: Boolean output: # null if there is no input parameter type: String list: Boolean # defaults to false required: Boolean # defaults to false The name of the endpoint will be used later as the key to a hash of endpoint resolution fuctions. It uniquely identified this endpoint. The class attribute tells Warpgrapher whether this endpoint belongs under the root query or root mutation object. The convention is that any operation with side effects, modifying the persistent data store, should be a mutation. Read-only operations are queries. The input attribute allows specification of an input to the endpoint function. The input type may be a scalar GraphQL type -- Boolean, Float, ID, Int, or String -- or it may be a type defined elsewhere in the model section of the Warpgrapher configuration. The list determines whether the input is actually a list of that type rather than a singular instance. If the required attribute is true, the input is required. If false, the input is optional. The output attribute describes the value returned by the custom endpoint. It has fields similar to input, in that it includes type, lsit, and required attributes. The following configuration defines a custom endpoints, TopIssue. version: 1\nmodel: - name: Issue props: - name: name type: String - name: points type: Int endpoints: - name: TopIssue class: Query input: null output: type: Issue","breadcrumbs":"Engine Features » Defined Endpoints » Configuration","id":"70","title":"Configuration"},"71":{"body":"To implement the custom endpoint, a resolver function is defined, as follows. In this example, the function just puts together a static response and resolves it. A real system would like do some comparison of nodes and relationships to determine the top issue, and dynamically return that record. // endpoint returning a list of `Issue` nodes\nfn resolve_top_issue(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { let top_issue = facade.node( \"Issue\", hashmap! { \"name\".to_string() => Value::from(\"Learn more rust\".to_string()), \"points\".to_string() => Value::from(Into::<i64>::into(5)) }, ); facade.resolve_node(&top_issue).await })\n}","breadcrumbs":"Engine Features » Defined Endpoints » Implementation","id":"71","title":"Implementation"},"72":{"body":"To add the custom endpoint resolver to the engine, it must be associated with the name the endpoint was given in the configuration above. The example code below creates a HashMap to map from the custom endpoint name and the implementing function. That map is then passed to the Engine when it is created. // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert(\"TopIssue\".to_string(), Box::new(resolve_top_issue)); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Defined Endpoints » Add Resolvers to the Warpgrapher Engine","id":"72","title":"Add Resolvers to the Warpgrapher Engine"},"73":{"body":"The code below calls the endine with a query that exercises the custom endpoint. let query = \" query { TopIssue { name points } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap();","breadcrumbs":"Engine Features » Defined Endpoints » Example of Calling the Endpoint","id":"73","title":"Example of Calling the Endpoint"},"74":{"body":"See below for the full code for the example above. use maplit::hashmap;\nuse std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::resolvers::{ExecutionResult, ResolverFacade, Resolvers};\nuse warpgrapher::engine::value::Value;\nuse warpgrapher::juniper::BoxFuture;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: Issue props: - name: name type: String - name: points type: Int endpoints: - name: TopIssue class: Query input: null output: type: Issue\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} // endpoint returning a list of `Issue` nodes\nfn resolve_top_issue(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { let top_issue = facade.node( \"Issue\", hashmap! { \"name\".to_string() => Value::from(\"Learn more rust\".to_string()), \"points\".to_string() => Value::from(Into::<i64>::into(5)) }, ); facade.resolve_node(&top_issue).await })\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert(\"TopIssue\".to_string(), Box::new(resolve_top_issue)); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\"); // create new project let query = \" query { TopIssue { name points } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // verify result println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Engine Features » Defined Endpoints » Full Example Source","id":"74","title":"Full Example Source"},"75":{"body":"When Warpgrapher auto-generates a CRUD endpoint, the values of Node and Relationship properties are retreived from the database and returned in a query. In some cases, however, it may be necessary to perform real-time computations to derive the value of a prop. We call these type of properties \"dynamic properties\", and Warpgrapher provides a mechanism to execute custom logic to resolve their values.","breadcrumbs":"Engine Features » Dynamic Props » Dynamic Props","id":"75","title":"Dynamic Props"},"76":{"body":"In the configuration below, points is a dynamic property on the Project type. It has an associated resolver name of resolve_project_points. That name will be used later to connect the Rust resolver function to this entry in the configuration. model: - name: Project props: - name: name type: String - name: points type: Int resolver: resolve_project_points\n\";","breadcrumbs":"Engine Features » Dynamic Props » Configuration","id":"76","title":"Configuration"},"77":{"body":"The implementation below defines the resolver. In this example, the resolver simply returns a constant value. In a real system, the implementation might retrieve records and do some calculation to total up a number of points associated with a project. fn resolve_project_points(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { // compute value let points = 5; facade.resolve_scalar(points) })\n}","breadcrumbs":"Engine Features » Dynamic Props » Implementation","id":"77","title":"Implementation"},"78":{"body":"The code in the snippet below adds the resolver function to a map. They key is the name for the custom resolver that was used in the configuration, above. The map is then passed to the Wargrapher engine, allowing the engine to find the resolver function when the dynamic property must be resolved. let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_points\".to_string(), Box::new(resolve_project_points), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Dynamic Props » Add Resolvers to the Engine","id":"78","title":"Add Resolvers to the Engine"},"79":{"body":"The following GraphQL query uses the dynamic resolver defined above. // create new project let query = \" mutation { ProjectCreate(input: { name: \\\"Project1\\\" }) { id points } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap();","breadcrumbs":"Engine Features » Dynamic Props » Example API Call","id":"79","title":"Example API Call"},"8":{"body":"A full example of integrating Warpgrapher with Actix Web is contained in the warpgrapher-actixweb respository on Github. A slightly simplified version of that project is reproduced with additional description below. To integrate Warpgrapher with an Actix Web engine, include the following dependencies in the Cargo.toml file. Cargo.toml [dependencies]\nactix-http = \"3.0.0-beta.5\"\nactix-web = \"4.0.0-beta.6\"\nactix-cors = \"0.6.0-beta.2\"\nserde = \"1.0.135\"\nserde_json = \"1.0.78\"\nwarpgrapher = { version=\"0.10.4\", features=[\"cypher\"]} The rest of the code necessary to accomplish the integration is contained within the single source code file below. First, a number of structs and functions are imported from the Actix and Warpgrapher crates. src/main.rs use actix_cors::Cors;\nuse actix_http::error::Error;\nuse actix_web::middleware::Logger;\nuse actix_web::web::{Data, Json};\nuse actix_web::{web, App, HttpResponse, HttpServer, Responder};\nuse serde::Deserialize;\nuse serde_json::Value;\nuse std::collections::HashMap;\nuse std::convert::TryFrom;\nuse std::fs::File; use warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::juniper::http::playground::playground_source;\nuse warpgrapher::Engine; The AppData struct, defined below, is used to pass application data created during setup into the web server. In the case of this integration, the application data that is passed into the web server is the Warpgrapher Engine. #[derive(Clone)]\nstruct AppData { engine: Engine<Rctx>,\n} impl AppData { fn new(engine: Engine<Rctx>) -> AppData { AppData { engine } }\n} Just like the Quickstart tutorial, this integration creates a RequestContext that could be used to pass data into the Warpgrapher engine for custom resolvers or endpoints, but is left empty in this example. The Rctx struct does contain on associated type, which selects Cypher as the database type to be used for this Warpgrapher engine. #[derive(Clone, Debug)]\nstruct Rctx {} impl RequestContext for Rctx { type DBEndpointType = CypherEndpoint; fn new() -> Self { Rctx {} }\n} Next, the integration includes a GraphqlRequest that is used to deserialize queries coming from Actix Web and pass the query content to the Warpgrapher engine. #[derive(Clone, Debug, Deserialize)]\nstruct GraphqlRequest { pub query: String, pub variables: Option<Value>,\n} The following function is the handler that takes requests from the Actix Web framework and passes it into the Warpgrapher engine. In short, it pulls the query and query variables from the Actix Web query and passes those as arguments to the Warpgrapher engine's execute function. A successful response is passed back as an Ok result. Errors are returned within an InternalServerError. async fn graphql(data: Data<AppData>, req: Json<GraphqlRequest>) -> Result<HttpResponse, Error> { let engine = &data.engine; let metadata: HashMap<String, String> = HashMap::new(); let resp = engine .execute(req.query.to_string(), req.variables.clone(), metadata) .await; match resp { Ok(body) => Ok(HttpResponse::Ok() .content_type(\"application/json\") .body(body.to_string())), Err(e) => Ok(HttpResponse::InternalServerError() .content_type(\"application/json\") .body(e.to_string())), }\n} To make it easier to explore the schema generated by Warpgrapher, the integration example also includes a handler function that returns a GraphQL playground, as the /playground path. The handler function is shown below. async fn playground(_data: Data<AppData>) -> impl Responder { let html = playground_source(\"/graphql\", None); HttpResponse::Ok() .content_type(\"text/html; charset=utf-8\") .body(html)\n} The create_engine function pulls data from environment variables to determine how to connect to a Cypher-based database. These are the same environment variables described in the Quickstart and the Neo4J section of the Databases book. async fn create_engine(config: Configuration) -> Engine<Rctx> { let db = CypherEndpoint::from_env() .expect(\"Failed to parse endpoint from environment\") .pool() .await .expect(\"Failed to create db endpoint\"); let engine: Engine<Rctx> = Engine::<Rctx>::new(config, db) .build() .expect(\"Failed to build engine\"); engine\n} Lastly, the main function itself pulls all of the above elements together. It reads a configuration from a ./config.yaml file and passes that to the function defined above to create an Warpgrapher Engine. It packages the Warpgrapher engine into an AppData struct to pass off to Actix Web and creates an HttpServer to begin fielding requests. The GraphQL API is bound to the /graphql path, and the playground is bound to the /playground path. #[actix_web::main]\nasync fn main() -> std::io::Result<()> { let config_file = File::open(\"./config.yaml\".to_string()).expect(\"Could not read file\"); let config = Configuration::try_from(config_file).expect(\"Failed to parse config file\"); let engine = create_engine(config.clone()).await; let graphql_endpoint = \"/graphql\"; let playground_endpoint = \"/playground\"; let bind_addr = \"0.0.0.0\".to_string(); let bind_port = \"5000\".to_string(); let addr = format!(\"{}:{}\", bind_addr, bind_port); let app_data = AppData::new(engine); println!(\"Starting server on {}\", addr); HttpServer::new(move || { App::new() .app_data(actix_web::web::Data::new(app_data.clone())) .wrap(Logger::default()) .wrap(Cors::permissive()) .route(graphql_endpoint, web::post().to(graphql)) .route(playground_endpoint, web::get().to(playground)) }) .bind(&addr) .expect(\"Failed to start server\") .run() .await\n} To view or clone a full repository project with an Actix Web integration, visit the warpgrapher-actixweb repository on GitHub.","breadcrumbs":"Server Integration » Actix Web » Actix Web Integration","id":"8","title":"Actix Web Integration"},"80":{"body":"See below for the full source code to the example above. use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::resolvers::{ExecutionResult, ResolverFacade, Resolvers};\nuse warpgrapher::juniper::BoxFuture;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: Project props: - name: name type: String - name: points type: Int resolver: resolve_project_points\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} fn resolve_project_points(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { // compute value let points = 5; facade.resolve_scalar(points) })\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_points\".to_string(), Box::new(resolve_project_points), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\"); // create new project let query = \" mutation { ProjectCreate(input: { name: \\\"Project1\\\" }) { id points } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // verify result assert_eq!( \"123456\", result .get(\"data\") .unwrap() .get(\"GetEnvironment\") .unwrap() .as_str() .unwrap(), );\n}","breadcrumbs":"Engine Features » Dynamic Props » Full Example Source","id":"80","title":"Full Example Source"},"81":{"body":"Dynamic relationships are similiar to dynamic properties, but returning dynamically calculated relationships to other nodes as opposed to individual properties.","breadcrumbs":"Engine Features » Dynamic Relationships » Dynamic Relationships","id":"81","title":"Dynamic Relationships"},"82":{"body":"The configuration below includes a dynamic resolver called resolve_project_top_contributor for the top_contributor relationship. That resolver name will be used later to associate a Rust function to carry out the dynamic resolution. version: 1\nmodel: - name: User props: - name: name type: String - name: Project props: - name: name type: String rels: - name: top_contributor nodes: [User] resolver: resolve_project_top_contributor","breadcrumbs":"Engine Features » Dynamic Relationships » Configuration","id":"82","title":"Configuration"},"83":{"body":"The next step is to define the custom resolution function in Rust. In this example, the custom relationship resolver creates a hard-coded node and relationship. In a real system, the function might load records and do some calculation or analytic logic to determine who is the top contributor to a project, and then return that user. fn resolve_project_top_contributor( facade: ResolverFacade<AppRequestContext>,\n) -> BoxFuture<ExecutionResult> { Box::pin(async move { // create dynamic dst node let mut top_contributor_props = HashMap::<String, Value>::new(); top_contributor_props.insert( \"id\".to_string(), Value::from(Uuid::new_v4().to_hyphenated().to_string()), ); top_contributor_props.insert(\"name\".to_string(), Value::from(\"user0\".to_string())); let top_contributor = facade.node(\"User\", top_contributor_props); // create dynamic rel let rel_id = \"1234567890\".to_string(); let top_contributor_rel = facade.create_rel_with_dst_node( Value::from(rel_id), \"topdev\", HashMap::new(), top_contributor, )?;","breadcrumbs":"Engine Features » Dynamic Relationships » Implementation","id":"83","title":"Implementation"},"84":{"body":"The resolver is added to a map associated with the name used in the configuration, above. The map is then passed to the Warpgrapher engine. This allows the engine to find the Rust function implementing the custom resolver when it is needed. .await .expect(\"Failed to create cypher database pool\"); // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_top_contributor\".to_string(), Box::new(resolve_project_top_contributor), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db)","breadcrumbs":"Engine Features » Dynamic Relationships » Add the Resolver to the Engine","id":"84","title":"Add the Resolver to the Engine"},"85":{"body":"The following GraphQL query uses the dynamic resolver defined above. .build() .expect(\"Failed to build engine\"); // create new project let query = \" mutation { ProjectCreate(input: { name: \\\"Project1\\\" }) { id top_contributor { dst { ... on User { id name } } } } }","breadcrumbs":"Engine Features » Dynamic Relationships » Example API Call","id":"85","title":"Example API Call"},"86":{"body":"See below for the full source code to the example above. use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse uuid::Uuid;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::resolvers::{ExecutionResult, ResolverFacade, Resolvers};\nuse warpgrapher::engine::value::Value;\nuse warpgrapher::juniper::BoxFuture;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: name type: String - name: Project props: - name: name type: String rels: - name: top_contributor nodes: [User] resolver: resolve_project_top_contributor\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} fn resolve_project_top_contributor( facade: ResolverFacade<AppRequestContext>,\n) -> BoxFuture<ExecutionResult> { Box::pin(async move { // create dynamic dst node let mut top_contributor_props = HashMap::<String, Value>::new(); top_contributor_props.insert( \"id\".to_string(), Value::from(Uuid::new_v4().to_hyphenated().to_string()), ); top_contributor_props.insert(\"name\".to_string(), Value::from(\"user0\".to_string())); let top_contributor = facade.node(\"User\", top_contributor_props); // create dynamic rel let rel_id = \"1234567890\".to_string(); let top_contributor_rel = facade.create_rel_with_dst_node( Value::from(rel_id), \"topdev\", HashMap::new(), top_contributor, )?; facade.resolve_rel(&top_contributor_rel).await })\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_top_contributor\".to_string(), Box::new(resolve_project_top_contributor), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\"); // create new project let query = \" mutation { ProjectCreate(input: { name: \\\"Project1\\\" }) { id top_contributor { dst { ... on User { id name } } } } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // verify result println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Engine Features » Dynamic Relationships » Full Example Source","id":"86","title":"Full Example Source"},"87":{"body":"In some cases, it's desirable to pass custom state information from your application into the Warpgrapher request cycle, so that your custom resolvers can make use of that information. The request context makes this passing of state possible.","breadcrumbs":"Engine Features » Request Context » Request Context","id":"87","title":"Request Context"},"88":{"body":"Every system using Warpgrapher defines a struct that implements RequestContext. In addition to implementing the trait, that struct is free to carry additional state information. However, the context must implement Clone, Debug, Sync, Send, as well as Warpgrapher's RequestContext trait. See the code snippet below for an example. #[derive(Clone, Debug)]\nstruct AppRequestContext { request_id: String,\n} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { // generate random request id let request_id = \"1234\".to_string(); AppRequestContext { request_id } }\n}","breadcrumbs":"Engine Features » Request Context » Define the RequestContext","id":"88","title":"Define the RequestContext"},"89":{"body":"The struct that implements RequestContext is passed to the Engine as a type parameter, as shown in the code snippet below. // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Request Context » Engine Type Parameter","id":"89","title":"Engine Type Parameter"},"9":{"body":"To integrate Warpgrapher with AWS lambda, begin by including the following dependencies in Cargo.toml. Cargo.toml [dependencies]\nlambda_runtime = \"0.3.0\"\nserde = \"1.0.57\"\nserde_json = \"1.0.57\"\nserde_derive = \"1.0.57\"\ntokio = { version=\"1.4.0\", features=[\"rt-multi-thread\", \"macros\"] }\nwarpgrapher = { version=\"0.10.4\", features = [\"gremlin\"] } In the main.rs source file, include the following code to include structs and functions that are needed from dependencies. use api_service::{create_app_engine, Error};\nuse lambda_runtime::handler_fn;\nuse serde_derive::Deserialize;\nuse serde_json::{json, Value};\nuse std::collections::HashMap;\nuse std::env::var_os;\nuse std::sync::Arc;\nuse warpgrapher::engine::database::gremlin::GremlinEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::juniper::BoxFuture; Next the lambda integration defines a GraphqlRequest struct that is used to deserialize query strings and request variables from the lambda interface for passing to the Warpgrapher engine. #[derive(Clone, Debug, Deserialize)]\npub struct GraphqlRequest { pub query: String, pub variables: Option<Value>,\n} The AwsLambdaProxyRequest struct is used to deserialize requests incoming from AWS lambda. Within the body of the request is the content that will be deserialized into the GraphqlRequest struct described above. #[derive(Clone, Debug, Deserialize)]\npub struct AwsLambdaProxyRequest { pub body: String, #[serde(rename = \"requestContext\")] pub request_context: AwsLambdaProxyRequestContext,\n} The aws_proxy_response function below packages a result returned by a Warpgrapher engine's execute function into a format that can be returned to the AWS lambda framework. pub fn aws_proxy_response(body: serde_json::Value) -> Result<JSON, Error> { Ok(json!({ \"body\": serde_json::to_string(&body) .map_err(|e| Error::JsonSerializationError { source: e})?, \"headers\": json!({}), \"isBase64Encoded\": false, \"statusCode\": 200 }))\n} The create_app_engine function takes a database pool, Gremlin in this example, and returns a Warpgrapher Engine that can be used to handle GraphQL queries. static CONFIG: &str = \" version: 1 model: - name: User props: - name: email type: String \"; // create config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // create warpgrapher engine let engine: Engine<Rctx> = Engine::<Rctx>::new(config, db).build()?; Ok(engine)\n} The main function ties the above elements together to process a GraphQL query when the lambda function is invoked. The function creates a database pool from environment variables, as described in the Databases section of the book. The main function then uses the create_app_engine function to create a Warpgrapher Engine. A closure is defined that deserializes the request from the AWS lambda function and passes it to the Warpgrapher engine for execution using the execute method. The results are packaged up for response using the aws_proxy_response method. That handler closure is passed to the lambda runtime for invocation when requests need to be processed. #[tokio::main]\nasync fn main() -> Result<(), Error> { // define database endpoint let endpoint = GremlinEndpoint::from_env()?; let db = endpoint.pool().await?; // create warpgrapher engine let engine = Arc::new(create_app_engine(db).await?); let func = handler_fn( move |event: Value, _: lambda_runtime::Context| -> BoxFuture<Result<Value, Error>> { let eng = engine.clone(); Box::pin(async move { let engine = eng.clone(); // parse handler event as aws proxy request and extract graphql request let proxy_request = serde_json::from_value(event).map_err(|e| Error::JsonDeserializationError { desc: \"Failed to deserialize aws proxy request\".to_string(), source: e, })?; let gql_request = serde_json::from_str(&proxy_request.body).map_err(|e| Error::JsonDeserializationError { desc: \"Failed to deserialize graphql request in body\".to_string(), source: e, })?; // execute request let result = engine .execute( gql_request.query.to_string(), gql_request.variables, HashMap::new(), ) .await?; // format response for api-gateway proxy aws_proxy_response(result) .or_else(|e| aws_proxy_response(json!({ \"errors\": [format!(\"{}\", e)] }))) }) }, ); lambda_runtime::run(func) .await .map_err(|_| Error::LambdaError {})?; Ok(())\n}","breadcrumbs":"Server Integration » AWS Lambda » AWS Lambda","id":"9","title":"AWS Lambda"},"90":{"body":"Once passed to the Engine, the struct implementing RequestContext is available to functions that implement custom endpoints and resolvers, as shown in the snippet below. fn resolve_echo_request(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { let request_context = facade.request_context().unwrap(); let request_id = request_context.request_id.clone(); facade.resolve_scalar(format!(\"echo! (request_id: {})\", request_id)) })\n}","breadcrumbs":"Engine Features » Request Context » Access the Context","id":"90","title":"Access the Context"},"91":{"body":"use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::resolvers::{ExecutionResult, ResolverFacade, Resolvers};\nuse warpgrapher::juniper::BoxFuture;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String\nendpoints: - name: EchoRequest class: Query input: null output: type: String\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext { request_id: String,\n} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { // generate random request id let request_id = \"1234\".to_string(); AppRequestContext { request_id } }\n} fn resolve_echo_request(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { let request_context = facade.request_context().unwrap(); let request_id = request_context.request_id.clone(); facade.resolve_scalar(format!(\"echo! (request_id: {})\", request_id)) })\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // define resolvers let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert(\"EchoRequest\".to_string(), Box::new(resolve_echo_request)); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\"); // execute query on `GetEnvironment` endpoint let query = \" query { EchoRequest } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // verify result println!(\"result: {:#?}\", result); assert_eq!( \"echo! (request_id: 1234)\", result .get(\"data\") .unwrap() .get(\"EchoRequest\") .unwrap() .as_str() .unwrap(), );\n}","breadcrumbs":"Engine Features » Request Context » Full Example Source","id":"91","title":"Full Example Source"},"92":{"body":"In many cases, it's necessary to ensure that inputs are valid. What constitutes a valid input is up to the application, but it may mean that values have to be less than a certain length, within a certain range, and/or include or exclude certain characters. Warpgrapher makes it possible to write custom validation functions to reject invalid inputs.","breadcrumbs":"Engine Features » Input Validation » Input Validation","id":"92","title":"Input Validation"},"93":{"body":"In the configuration snippet below, the name property has a validator field with the name NameValidator. The NameValidator string will be used later to connect the Rust function with this definition in the schema. version: 1\nmodel: # User - name: User props: - name: name type: String required: true validator: NameValidator","breadcrumbs":"Engine Features » Input Validation » Configuration","id":"93","title":"Configuration"},"94":{"body":"The implementation below defines the input validation function itself. The function is relatively simple, rejecting the input if the name is \"KENOBI\". All other names are accepted. fn name_validator(value: &Value) -> Result<(), Error> { if let Value::Map(m) = value { if let Some(Value::String(name)) = m.get(\"name\") { if name == \"KENOBI\" { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed. Cannot be named KENOBI\", field_name = \"name\" ), }) } else { Ok(()) } } else { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed.\", field_name = \"name\" ), }) } } else { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed.\", field_name = \"name\" ), }) }\n}","breadcrumbs":"Engine Features » Input Validation » Implementation","id":"94","title":"Implementation"},"95":{"body":"The validators, such as the one defined above, are packaged into a map from the name(s) used in the configuration to the Rust functions. The map is then provided to the Warpgrapher Engine as the engine is built. // load validators let mut validators: Validators = Validators::new(); validators.insert(\"NameValidator\".to_string(), Box::new(name_validator)); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_validators(validators.clone()) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Input Validation » Add Validators to the Engine","id":"95","title":"Add Validators to the Engine"},"96":{"body":"The follow example API call invokes the validator defined above. let query = \" mutation { UserCreate(input: { name: \\\"KENOBI\\\" }) { id name } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap();","breadcrumbs":"Engine Features » Input Validation » Example API Call","id":"96","title":"Example API Call"},"97":{"body":"See below for the full source code to the example above. use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::cypher::CypherEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::engine::validators::Validators;\nuse warpgrapher::engine::value::Value;\nuse warpgrapher::{Engine, Error}; static CONFIG: &str = \"\nversion: 1\nmodel: # User - name: User props: - name: name type: String required: true validator: NameValidator\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = CypherEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} fn name_validator(value: &Value) -> Result<(), Error> { if let Value::Map(m) = value { if let Some(Value::String(name)) = m.get(\"name\") { if name == \"KENOBI\" { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed. Cannot be named KENOBI\", field_name = \"name\" ), }) } else { Ok(()) } } else { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed.\", field_name = \"name\" ), }) } } else { Err(Error::ValidationFailed { message: format!( \"Input validator for {field_name} failed.\", field_name = \"name\" ), }) }\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = CypherEndpoint::from_env() .expect(\"Failed to parse cypher endpoint from environment\") .pool() .await .expect(\"Failed to create cypher database pool\"); // load validators let mut validators: Validators = Validators::new(); validators.insert(\"NameValidator\".to_string(), Box::new(name_validator)); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_validators(validators.clone()) .build() .expect(\"Failed to build engine\"); let query = \" mutation { UserCreate(input: { name: \\\"KENOBI\\\" }) { id name } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Engine Features » Input Validation » Full Example Source","id":"97","title":"Full Example Source"},"98":{"body":"The earlier sections of the book covered a great many options for customizing the behavior of Warpgrapher, including input validation, request context, custom endpoints, and dynamic properties and relationships. Warpgrapher offers an additional API, the event handling API, to modify Warpgrapher's behavior at almost every point in the lifecycle of a request. Event handlers may be added before Engine creation, before or after request handling, and before or after nodes ore relationsihps are created, read, updated, or deleted. This section will introduce the event handling API using an extended example of implementing a very simple authorization model. Each data record will be owned by one user, and only that user is entitled to read or modify that record.","breadcrumbs":"Engine Features » Event Handlers » Event Handlers","id":"98","title":"Event Handlers"},"99":{"body":"Unlike some of the other customization points in the Warpgrapher engine, no special configuration is required for event handlers. They are created and added to the Engine using only Rust code. The data model used for this section's example is as follows. version: 1\nmodel: - name: Record props: - name: content type: String","breadcrumbs":"Engine Features » Event Handlers » Configuration","id":"99","title":"Configuration"}},"length":109,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{".":{"0":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"0":{".":{"4":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"5":{"1":{"b":{"c":{"1":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":0,"docs":{},"f":{"d":{"c":{"4":{"3":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"df":9,"docs":{"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.0}}},"2":{"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"4":{"a":{"8":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0}}},"d":{"6":{"6":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{".":{"1":{"3":{"5":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"7":{"8":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"3":{"4":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"5":{"6":{"7":{"8":{"9":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"3":{"3":{"c":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"a":{"3":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":22,"docs":{"108":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"a":{"1":{"d":{"4":{"7":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"7":{"8":{"6":{"0":{"4":{"7":{"8":{"c":{"d":{"6":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"8":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}}},"2":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"1":{"8":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":2.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"1":{"df":2,"docs":{"49":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"2":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"1":{"1":{"7":{"3":{"7":{"6":{"5":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"9":{"5":{"d":{"1":{"9":{"1":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"c":{"9":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}},"f":{"d":{"7":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"e":{"c":{"4":{"7":{"3":{"df":0,"docs":{},"e":{"9":{"0":{"a":{"5":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"8":{"c":{"d":{"7":{"2":{"c":{"8":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"6":{"a":{"6":{"8":{"5":{"4":{"df":0,"docs":{},"e":{"b":{"9":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"9":{"4":{"df":0,"docs":{},"f":{"0":{"a":{"df":0,"docs":{},"e":{"8":{"a":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"3":{"3":{"b":{"df":0,"docs":{},"e":{"6":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"7":{"d":{"1":{"9":{"5":{"df":0,"docs":{},"e":{"a":{"5":{"4":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"4":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"1":{"3":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{"d":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"9":{"7":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"7":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"7":{"9":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"6":{"8":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"8":{"4":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"a":{"7":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"a":{"b":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"1":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"d":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"f":{"8":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"c":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"4":{"3":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"5":{"0":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"f":{"0":{"a":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"6":{"1":{"b":{"2":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"5":{"0":{"0":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"7":{"6":{"1":{"a":{"1":{"c":{"9":{"7":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"2":{"b":{"d":{"2":{"a":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"8":{"7":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"1":{"7":{"d":{"6":{"a":{"8":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"8":{"4":{"4":{"9":{"4":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"6":{"8":{"8":{"df":0,"docs":{},"e":{"4":{"7":{"2":{"3":{"4":{"0":{"d":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{"b":{"5":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"7":{":":{"7":{"6":{"8":{"7":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"a":{"c":{"c":{"7":{"a":{"c":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"4":{"d":{"6":{"df":0,"docs":{},"e":{"b":{"7":{"5":{"d":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"1":{"df":0,"docs":{},"e":{"3":{"4":{"9":{"7":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"8":{"0":{"4":{"6":{"0":{"4":{"b":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"4":{"c":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"2":{"df":0,"docs":{},"f":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"8":{"2":{":":{"8":{"1":{"8":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"8":{"5":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"6":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":0,"docs":{},"f":{"a":{"a":{"4":{"0":{"df":0,"docs":{},"f":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"6":{"b":{"1":{"1":{"0":{"c":{"8":{"df":0,"docs":{},"f":{"9":{"6":{"a":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"b":{"5":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}},"a":{"3":{"df":0,"docs":{},"f":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}},"7":{"a":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"8":{"tf":1.0}}},"9":{"0":{"4":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"6":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"5":{"6":{"9":{"9":{"9":{"df":0,"docs":{},"f":{"4":{"0":{"1":{"3":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"2":{"9":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"8":{"0":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"8":{"8":{"4":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"68":{"tf":2.23606797749979}}}}}}}}}},"a":{"3":{"3":{"a":{"b":{"3":{"7":{"b":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"d":{"7":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"@":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"3":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":28,"docs":{"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.8284271247461903},"34":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"100":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"{":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":3.4641016151377544}},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"c":{"9":{"5":{"c":{"d":{"3":{"4":{"a":{"c":{"3":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":18,"docs":{"101":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"34":{"tf":2.0},"36":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":2.0},"72":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":13,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":1.4142135623730951},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}}}},"df":7,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"4":{"4":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"f":{"5":{"1":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":12,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.0},"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":19,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"2":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"101":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":19,"docs":{"0":{"tf":1.4142135623730951},"107":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":7,"docs":{"102":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}}},"df":2,"docs":{"15":{"tf":1.0},"23":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"3":{"tf":2.0},"6":{"tf":2.0},"74":{"tf":2.0},"80":{"tf":2.0},"86":{"tf":2.0},"88":{"tf":2.0},"91":{"tf":2.0},"97":{"tf":2.0}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"d":{"b":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":8,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":5.196152422706632},"23":{"tf":1.7320508075688772},"25":{"tf":2.23606797749979},"26":{"tf":3.4641016151377544},"29":{"tf":3.3166247903554},"30":{"tf":1.7320508075688772},"32":{"tf":3.7416573867739413},"33":{"tf":1.7320508075688772},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"50":{"tf":1.0},"70":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"66":{"tf":1.0},"98":{"tf":1.0}}}}},"o":{"df":3,"docs":{"37":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"9":{"tf":2.6457513110645907}},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"e":{"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0}}}}}},"b":{"0":{"0":{"c":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"3":{"7":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"6":{"a":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"2":{"a":{"3":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"a":{"b":{"6":{"2":{"df":0,"docs":{},"e":{"6":{"0":{"b":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"104":{"tf":1.0},"11":{"tf":1.7320508075688772},"2":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"3":{"0":{"2":{"b":{"7":{"df":0,"docs":{},"f":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":5,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"12":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"15":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"70":{"tf":1.0}}}},"w":{"df":62,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":2.8284271247461903},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{".":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"5":{"df":1,"docs":{"8":{"tf":1.0}}},"6":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"28":{"tf":1.0},"31":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951}}}}}}}},"f":{"a":{"7":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"y":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":12,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":3.872983346207417},"26":{"tf":3.7416573867739413},"70":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"80":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"66":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":8,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"13":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"95":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"c":{"2":{"b":{"7":{"1":{"3":{"0":{"8":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"3":{"4":{"8":{"d":{"8":{"b":{"8":{"d":{"9":{"4":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"c":{"7":{"5":{"3":{"c":{"6":{"5":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":11,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0}}}}},"b":{"2":{"d":{"a":{"0":{"7":{"1":{"5":{"7":{"d":{"b":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.0},"92":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"22":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":22,"docs":{"0":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}},"x":{"df":4,"docs":{"1":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":20,"docs":{"108":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":2.0},"74":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.0},"86":{"tf":2.0},"9":{"tf":2.0},"91":{"tf":2.0},"97":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"23":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":35,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":2.23606797749979},"108":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":3.3166247903554},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":2.0},"25":{"tf":2.23606797749979},"26":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"3":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"4":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":2.8284271247461903},"13":{"tf":1.4142135623730951},"29":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":2.23606797749979}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":7,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"23":{"tf":1.0},"33":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":2.449489742783178},"3":{"tf":2.0},"34":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"103":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"31":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}},"r":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":3.1622776601683795}},"s":{"d":{"b":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"22":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"98":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":42,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":2.23606797749979},"22":{"tf":2.8284271247461903},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":2.0},"3":{"tf":3.0},"31":{"tf":1.0},"32":{"tf":3.605551275463989},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.23606797749979},"80":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":2.23606797749979},"89":{"tf":1.0},"9":{"tf":2.23606797749979},"91":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"103":{"tf":2.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":1.7320508075688772},"32":{"tf":2.0},"33":{"tf":2.23606797749979},"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"d":{"df":11,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"_":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":20,"docs":{"0":{"tf":1.7320508075688772},"102":{"tf":1.0},"22":{"tf":2.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"90":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"10":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":25,"docs":{"1":{"tf":1.0},"10":{"tf":2.449489742783178},"102":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"11":{"tf":2.8284271247461903},"12":{"tf":3.3166247903554},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":2.0},"32":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":2.0},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}}}}},"b":{")":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"*":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"1":{"4":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"5":{"df":0,"docs":{},"e":{"5":{"8":{"c":{"d":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":10,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.6457513110645907},"20":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":29,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":2.6457513110645907},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"30":{"tf":1.0},"93":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"105":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":2.8284271247461903},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":3.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"47":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"98":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"b":{"df":23,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":2.8284271247461903},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":2.8284271247461903}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"r":{"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":16,"docs":{"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":3.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":3.1622776601683795},"34":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"15":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"104":{"tf":1.0},"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"23":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":2.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"32":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":21,"docs":{"29":{"tf":2.449489742783178},"32":{"tf":2.449489742783178},"36":{"tf":2.23606797749979},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"49":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"61":{"tf":2.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":14,"docs":{"101":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"23":{"tf":1.0}}}},"0":{"0":{"3":{"7":{"df":0,"docs":{},"f":{"b":{"d":{"b":{"2":{"9":{"6":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"f":{"8":{"4":{"c":{"7":{"6":{"1":{"0":{"5":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"9":{"8":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"a":{"2":{"a":{"1":{"b":{"6":{"8":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"69":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}}},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"b":{"5":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"91":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}}}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"7":{"8":{"1":{"6":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"12":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":3,"docs":{"16":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":2.0}},"f":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":2.449489742783178}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":30,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":3.3166247903554},"24":{"tf":2.0},"25":{"tf":1.0},"3":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"49":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":2.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"8":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":24,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"108":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"3":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":3.1622776601683795},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":2.0},"75":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"100":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"g":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":30,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":1.0},"106":{"tf":2.23606797749979},"108":{"tf":1.7320508075688772},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":3.605551275463989},"6":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":2.449489742783178},"74":{"tf":1.7320508075688772},"78":{"tf":2.449489742783178},"8":{"tf":4.0},"80":{"tf":1.7320508075688772},"84":{"tf":2.23606797749979},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"9":{"tf":3.1622776601683795},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":2.449489742783178},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"'":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},":":{":":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":15,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"3":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":4,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"70":{"tf":1.0},"76":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"q":{"df":17,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.4142135623730951}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":10,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":2.6457513110645907},"8":{"tf":1.4142135623730951},"9":{"tf":2.23606797749979},"94":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}},"t":{"df":12,"docs":{"100":{"tf":2.6457513110645907},"101":{"tf":1.4142135623730951},"102":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":2.449489742783178},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951},"98":{"tf":2.0},"99":{"tf":1.0}},"f":{"a":{"c":{"a":{"d":{"df":0,"docs":{},"e":{"<":{"'":{"_":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":49,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":2.0},"12":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":2.8284271247461903},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":2.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979},"91":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"107":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"106":{"tf":1.0},"108":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"89":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"14":{"tf":2.23606797749979},"15":{"tf":2.8284271247461903},"16":{"tf":2.23606797749979},"4":{"tf":2.0}}}},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"2":{"df":0,"docs":{},"e":{"8":{"9":{"4":{"b":{"df":0,"docs":{},"f":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{"c":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"4":{"0":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"a":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}},"e":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":14,"docs":{"101":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"12":{"tf":3.0},"13":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":3.7416573867739413},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"d":{"a":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"37":{"tf":1.0},"66":{"tf":1.7320508075688772},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"[":{"\"":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":2.449489742783178},"97":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":9,"docs":{"101":{"tf":1.0},"104":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{".":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":2.23606797749979},"108":{"tf":2.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"d":{"df":5,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"8":{"tf":1.0}}}}},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":21,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.7320508075688772},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":39,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.4142135623730951},"96":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}},"df":1,"docs":{"103":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":3,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"0":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":14,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":30,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.8284271247461903},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":3.1622776601683795},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.0},"22":{"tf":2.8284271247461903},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0}}}}},"t":{"(":{"\"":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"100":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"h":{"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0}},"q":{"df":0,"docs":{},"l":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":55,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":3.4641016151377544},"23":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.0},"85":{"tf":1.0},"9":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":2.6457513110645907},"15":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":12,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"105":{"tf":2.0},"106":{"tf":1.7320508075688772},"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"d":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"15":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":15,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":3,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"21":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":2.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}}}},"i":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":49,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":4.123105625617661},"24":{"tf":2.23606797749979},"26":{"tf":1.0},"29":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"36":{"tf":3.872983346207417},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"41":{"tf":2.6457513110645907},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":2.449489742783178},"46":{"tf":2.449489742783178},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.8284271247461903},"5":{"tf":1.0},"50":{"tf":2.8284271247461903},"51":{"tf":2.8284271247461903},"52":{"tf":2.449489742783178},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"59":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":3.4641016151377544},"61":{"tf":3.0},"63":{"tf":2.449489742783178},"70":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":10,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":2.6457513110645907},"29":{"tf":1.0},"32":{"tf":2.0},"5":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"77":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"u":{"d":{"df":25,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.7320508075688772},"92":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"i":{"c":{"df":4,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"54":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"26":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"0":{"tf":1.0},"102":{"tf":1.4142135623730951},"11":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":39,"docs":{"103":{"tf":2.23606797749979},"105":{"tf":2.449489742783178},"108":{"tf":2.23606797749979},"22":{"tf":2.0},"23":{"tf":4.0},"24":{"tf":2.8284271247461903},"28":{"tf":2.0},"29":{"tf":3.1622776601683795},"30":{"tf":2.0},"31":{"tf":3.1622776601683795},"32":{"tf":6.0},"33":{"tf":2.23606797749979},"34":{"tf":3.0},"35":{"tf":2.0},"36":{"tf":6.244997998398398},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":3.3166247903554},"74":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":2.0},"94":{"tf":2.23606797749979},"97":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.0},"70":{"tf":1.0}},"e":{"(":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":10,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"23":{"tf":1.7320508075688772},"32":{"tf":1.0}},"r":{"df":5,"docs":{"11":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":3.0},"9":{"tf":1.4142135623730951}}}},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"f":{"a":{"c":{"df":2,"docs":{"22":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"100":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"31":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}}}},"s":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"6":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":4,"docs":{"15":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"74":{"tf":2.0}}}}},"t":{"'":{"df":4,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":18,"docs":{"25":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":2.0},"36":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":3,"docs":{"29":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"102":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":3,"docs":{"94":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"y":{"df":4,"docs":{"15":{"tf":2.0},"22":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":3.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"101":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":4,"docs":{"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"100":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"106":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":2.6457513110645907},"24":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":2.8284271247461903},"29":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"66":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":4,"docs":{"19":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}},"i":{"c":{"df":3,"docs":{"66":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"23":{"tf":2.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"m":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":1.0},"97":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":2.0},"66":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"26":{"tf":1.0},"72":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"108":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"c":{"df":0,"docs":{},"h":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":27,"docs":{"100":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":2.8284271247461903},"108":{"tf":1.0},"23":{"tf":3.605551275463989},"24":{"tf":1.4142135623730951},"32":{"tf":3.7416573867739413},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":2.6457513110645907},"42":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"102":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"92":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"25":{"tf":2.23606797749979},"28":{"tf":1.0},"30":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":2.0},"41":{"tf":2.23606797749979},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":2.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":4,"docs":{"31":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"102":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.4142135623730951}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}},"l":{"df":33,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.8284271247461903},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"100":{"tf":1.0},"101":{"tf":1.0}},"i":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":2.0},"108":{"tf":1.4142135623730951},"33":{"tf":1.0},"70":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"2":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}}}},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":37,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":2.8284271247461903},"32":{"tf":3.3166247903554},"33":{"tf":2.449489742783178},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":18,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":2.8284271247461903},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"df":1,"docs":{"95":{"tf":1.0}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":58,"docs":{"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":2.449489742783178},"23":{"tf":1.0},"25":{"tf":3.0},"26":{"tf":2.449489742783178},"30":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":2.0},"44":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"48":{"tf":2.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.6457513110645907},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":2.449489742783178},"76":{"tf":2.449489742783178},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"82":{"tf":2.8284271247461903},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":3.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979},"94":{"tf":2.6457513110645907},"96":{"tf":1.4142135623730951},"97":{"tf":3.1622776601683795},"99":{"tf":1.4142135623730951}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"93":{"tf":1.7320508075688772},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"105":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":9,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"66":{"tf":1.7320508075688772},"84":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"4":{"df":0,"docs":{},"j":{":":{"4":{".":{"4":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"/":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":2.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"37":{"tf":1.0}}}},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":30,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"20":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":2.0},"34":{"tf":2.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"32":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"(":{"df":1,"docs":{"34":{"tf":1.0}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":2.0}}}}}},"df":52,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":2.449489742783178},"104":{"tf":3.1622776601683795},"105":{"tf":3.7416573867739413},"106":{"tf":1.4142135623730951},"108":{"tf":3.0},"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":3.0},"23":{"tf":4.58257569495584},"25":{"tf":2.449489742783178},"26":{"tf":3.605551275463989},"28":{"tf":2.0},"29":{"tf":4.358898943540674},"30":{"tf":2.6457513110645907},"31":{"tf":2.449489742783178},"32":{"tf":4.123105625617661},"33":{"tf":2.449489742783178},"34":{"tf":2.8284271247461903},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":2.6457513110645907},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":2.449489742783178},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"101":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":10,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":2.23606797749979},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"41":{"tf":1.0}},"q":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"w":{"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"105":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"32":{"tf":1.0}}}}}}},"k":{"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"n":{".":{"df":0,"docs":{},"i":{"d":{"(":{")":{"?":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":3,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}}}},"df":6,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0}}}}},"n":{"c":{"df":3,"docs":{"105":{"tf":1.0},"3":{"tf":1.0},"90":{"tf":1.0}}},"df":25,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":2.23606797749979},"23":{"tf":2.6457513110645907},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"81":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":8,"docs":{"16":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"70":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"23":{"tf":1.0}}}}},"df":1,"docs":{"98":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":24,"docs":{"25":{"tf":2.449489742783178},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"30":{"tf":2.449489742783178},"31":{"tf":2.0},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":3.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"df":6,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"54":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":8,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{}},"r":{"df":5,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"36":{"tf":2.0}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"65":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.0},"32":{"tf":2.0},"36":{"tf":2.449489742783178}}}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"r":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.449489742783178}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"31":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":32,"docs":{"22":{"tf":2.449489742783178},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"8":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"102":{"tf":1.0},"23":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":13,"docs":{"102":{"tf":1.0},"108":{"tf":1.7320508075688772},"19":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}},"t":{"df":5,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":6,"docs":{"15":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"31":{"tf":2.449489742783178},"36":{"tf":2.8284271247461903}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"3":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":3.0},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}},"t":{"df":3,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"(":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"(":{"\"":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"l":{"df":13,"docs":{"108":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"66":{"tf":1.0}},"s":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"31":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"103":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"j":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"1":{"df":4,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":21,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"6":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":34,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":2.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"2":{"tf":2.0},"20":{"tf":1.4142135623730951},"22":{"tf":5.477225575051661},"23":{"tf":3.1622776601683795},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.23606797749979},"32":{"tf":2.23606797749979},"34":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":15,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":3.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":3,"docs":{"108":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.6457513110645907}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"102":{"tf":1.7320508075688772},"104":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":52,"docs":{"0":{"tf":1.0},"105":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":3.872983346207417},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":2.8284271247461903},"29":{"tf":4.242640687119285},"3":{"tf":2.6457513110645907},"30":{"tf":3.605551275463989},"32":{"tf":4.47213595499958},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":2.0},"91":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"25":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"92":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":3.0},"8":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0}}}},"d":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.0}}}}}}},"df":21,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":2.449489742783178},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":2.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"42":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"107":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":10,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"104":{"tf":1.0},"108":{"tf":1.4142135623730951},"2":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":6,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"(":{"df":1,"docs":{"32":{"tf":2.0}}},"df":42,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"106":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":2.6457513110645907},"26":{"tf":3.7416573867739413},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":3.605551275463989},"30":{"tf":2.6457513110645907},"31":{"tf":2.0},"32":{"tf":6.082762530298219},"33":{"tf":2.0},"34":{"tf":3.0},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"45":{"tf":1.0},"47":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}}}},"df":7,"docs":{"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"23":{"tf":1.0},"3":{"tf":1.0}}},"df":3,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}},"v":{"df":2,"docs":{"101":{"tf":1.0},"52":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"a":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"8":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"88":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":13,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":2.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":12,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":2.449489742783178},"108":{"tf":1.4142135623730951},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"9":{"tf":3.0},"91":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.23606797749979},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"v":{"df":26,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"3":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":2.449489742783178},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":2.23606797749979},"85":{"tf":1.0},"86":{"tf":2.0},"87":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"80":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}},"e":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}}}}}}},":":{":":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":7,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":3,"docs":{"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"t":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":23,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":2.0},"32":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"9":{"tf":2.0},"91":{"tf":2.0},"94":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}}},"i":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":8,"docs":{"1":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":18,"docs":{"103":{"tf":1.0},"105":{"tf":2.0},"108":{"tf":1.7320508075688772},"11":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":3.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"m":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.0}}},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":7,"docs":{"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}},"n":{"df":13,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"8":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":12,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"26":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":3.3166247903554},"33":{"tf":2.23606797749979},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"41":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":27,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":3.1622776601683795},"23":{"tf":3.3166247903554},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"32":{"tf":2.6457513110645907},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":2.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":20,"docs":{"22":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"108":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":2,"docs":{"108":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":2.0}}}},"i":{"c":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}},"t":{"df":32,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":2.8284271247461903},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":3.1622776601683795},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":2.23606797749979},"34":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"63":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"df":5,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.0}},"n":{"df":14,"docs":{"105":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":2.23606797749979},"35":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"20":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":2,"docs":{"102":{"tf":1.0},"77":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":9,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":2.23606797749979},"66":{"tf":1.0},"8":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.6457513110645907},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"22":{"tf":1.0},"27":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":17,"docs":{"0":{"tf":1.0},"108":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"3":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"9":{"tf":2.0},"91":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"102":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":2,"docs":{"106":{"tf":1.0},"11":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":10,"docs":{"29":{"tf":2.449489742783178},"32":{"tf":2.449489742783178},"36":{"tf":2.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"i":{"c":{"df":13,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.7320508075688772},"71":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":9,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"83":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}},"r":{"df":11,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":39,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.23606797749979},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":3.0},"23":{"tf":5.5677643628300215},"24":{"tf":4.242640687119285},"25":{"tf":1.7320508075688772},"26":{"tf":3.1622776601683795},"28":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":3.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":5.656854249492381},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":2.449489742783178},"74":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"99":{"tf":1.0}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907}}}}}}}}}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"108":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":2.6457513110645907},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":2.449489742783178},"90":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":5,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"66":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"54":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"102":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"88":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"t":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"3":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":5,"docs":{"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}}}}},"u":{"df":3,"docs":{"100":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"i":{"df":1,"docs":{"9":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0}}}}}}}}}},"l":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":4,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":2.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}},"df":7,"docs":{"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"100":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.0},"2":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"12":{"tf":2.6457513110645907},"13":{"tf":1.0},"22":{"tf":3.3166247903554},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":9,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.7320508075688772},"56":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":43,"docs":{"101":{"tf":2.23606797749979},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":4.47213595499958},"23":{"tf":3.605551275463989},"24":{"tf":2.0},"25":{"tf":4.0},"26":{"tf":3.3166247903554},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":4.0},"3":{"tf":1.4142135623730951},"30":{"tf":3.0},"31":{"tf":1.4142135623730951},"32":{"tf":5.385164807134504},"33":{"tf":1.4142135623730951},"34":{"tf":2.8284271247461903},"35":{"tf":2.23606797749979},"36":{"tf":2.449489742783178},"37":{"tf":1.0},"6":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":3.1622776601683795},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":14,"docs":{"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"80":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"0":{"tf":1.0},"105":{"tf":2.6457513110645907},"20":{"tf":1.4142135623730951},"22":{"tf":3.3166247903554},"23":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":3.3166247903554},"34":{"tf":2.23606797749979},"36":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":17,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}}},"df":57,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.0},"101":{"tf":1.4142135623730951},"102":{"tf":2.0},"105":{"tf":1.7320508075688772},"108":{"tf":3.872983346207417},"11":{"tf":1.7320508075688772},"12":{"tf":3.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":2.23606797749979},"22":{"tf":3.7416573867739413},"23":{"tf":3.1622776601683795},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.23606797749979},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":4.0},"33":{"tf":1.4142135623730951},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":2.6457513110645907},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":3.3166247903554},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":4.47213595499958},"80":{"tf":3.0},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":3.3166247903554},"87":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":4.0},"91":{"tf":3.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":3.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"'":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}},"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":48,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":2.23606797749979},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"108":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":2.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":4.358898943540674},"24":{"tf":2.0},"25":{"tf":2.23606797749979},"28":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":3.1622776601683795},"36":{"tf":3.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":7,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"108":{"tf":2.23606797749979},"12":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"23":{"tf":2.6457513110645907},"24":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"36":{"tf":2.449489742783178}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"108":{"tf":1.0},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"23":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":13,"docs":{"101":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"22":{"tf":2.6457513110645907},"26":{"tf":1.0},"66":{"tf":1.0},"92":{"tf":2.0},"93":{"tf":1.4142135623730951},"94":{"tf":2.0},"95":{"tf":2.23606797749979},"96":{"tf":1.0},"97":{"tf":2.6457513110645907},"98":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":22,"docs":{"103":{"tf":2.23606797749979},"105":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":3.1622776601683795},"23":{"tf":2.8284271247461903},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"i":{"6":{"4":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"5":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"v":{"4":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"37":{"tf":1.0}}}}}}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}},"e":{"c":{"!":{"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"104":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"98":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"0":{".":{"1":{"0":{".":{"4":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"4":{".":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":29,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.6457513110645907},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.0},"23":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":14,"docs":{"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":53,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"11":{"tf":2.449489742783178},"12":{"tf":2.8284271247461903},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"29":{"tf":1.7320508075688772},"3":{"tf":3.1622776601683795},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":3.872983346207417},"80":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":3.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":5,"docs":{"105":{"tf":1.0},"11":{"tf":1.0},"28":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"108":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"108":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"108":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"y":{"df":6,"docs":{"105":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"b":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"8":{"tf":3.3166247903554}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"88":{"tf":1.0}}}}},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"7":{"6":{"8":{"7":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"s":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"4":{"4":{"3":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"8":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"=":{"/":{"d":{"b":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"1":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"11":{"tf":1.0}},"e":{"=":{"8":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"22":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"b":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":7,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"\"":{"0":{".":{"1":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0}}}}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{".":{"0":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"0":{".":{"4":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"5":{"1":{"b":{"c":{"1":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":0,"docs":{},"f":{"d":{"c":{"4":{"3":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"df":9,"docs":{"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.0}}},"2":{"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"4":{"a":{"8":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0}}},"d":{"6":{"6":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{".":{"1":{"3":{"5":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"7":{"8":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"3":{"4":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"5":{"6":{"7":{"8":{"9":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"3":{"3":{"c":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"a":{"3":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":22,"docs":{"108":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"a":{"1":{"d":{"4":{"7":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"7":{"8":{"6":{"0":{"4":{"7":{"8":{"c":{"d":{"6":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"8":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}}},"2":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"1":{"8":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":2.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"1":{"df":2,"docs":{"49":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"2":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":8,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}},"1":{"1":{"7":{"3":{"7":{"6":{"5":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"9":{"5":{"d":{"1":{"9":{"1":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"c":{"9":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}},"f":{"d":{"7":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"e":{"c":{"4":{"7":{"3":{"df":0,"docs":{},"e":{"9":{"0":{"a":{"5":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"8":{"c":{"d":{"7":{"2":{"c":{"8":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"6":{"a":{"6":{"8":{"5":{"4":{"df":0,"docs":{},"e":{"b":{"9":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"9":{"4":{"df":0,"docs":{},"f":{"0":{"a":{"df":0,"docs":{},"e":{"8":{"a":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"3":{"3":{"b":{"df":0,"docs":{},"e":{"6":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"7":{"d":{"1":{"9":{"5":{"df":0,"docs":{},"e":{"a":{"5":{"4":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"4":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"1":{"3":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{"d":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"9":{"7":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"7":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"7":{"9":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"6":{"8":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"8":{"4":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"a":{"7":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"a":{"b":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"1":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"d":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"f":{"8":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"c":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"4":{"3":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"5":{"0":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"f":{"0":{"a":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"6":{"1":{"b":{"2":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"5":{"0":{"0":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"7":{"6":{"1":{"a":{"1":{"c":{"9":{"7":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"2":{"b":{"d":{"2":{"a":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"8":{"7":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"1":{"7":{"d":{"6":{"a":{"8":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"8":{"4":{"4":{"9":{"4":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"6":{"8":{"8":{"df":0,"docs":{},"e":{"4":{"7":{"2":{"3":{"4":{"0":{"d":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{"b":{"5":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"7":{":":{"7":{"6":{"8":{"7":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"a":{"c":{"c":{"7":{"a":{"c":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"4":{"d":{"6":{"df":0,"docs":{},"e":{"b":{"7":{"5":{"d":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"1":{"df":0,"docs":{},"e":{"3":{"4":{"9":{"7":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"8":{"0":{"4":{"6":{"0":{"4":{"b":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"4":{"c":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"2":{"df":0,"docs":{},"f":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"8":{"2":{":":{"8":{"1":{"8":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"8":{"5":{"df":5,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"6":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":0,"docs":{},"f":{"a":{"a":{"4":{"0":{"df":0,"docs":{},"f":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"6":{"b":{"1":{"1":{"0":{"c":{"8":{"df":0,"docs":{},"f":{"9":{"6":{"a":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"b":{"5":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}},"a":{"3":{"df":0,"docs":{},"f":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}},"7":{"a":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"8":{"tf":1.0}}},"9":{"0":{"4":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"6":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"5":{"6":{"9":{"9":{"9":{"df":0,"docs":{},"f":{"4":{"0":{"1":{"3":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"2":{"9":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"8":{"0":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"8":{"8":{"4":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"68":{"tf":2.23606797749979}}}}}}}}}},"a":{"3":{"3":{"a":{"b":{"3":{"7":{"b":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"d":{"7":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"@":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"3":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":28,"docs":{"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.8284271247461903},"34":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"100":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"{":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":3.7416573867739413}},"w":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"c":{"9":{"5":{"c":{"d":{"3":{"4":{"a":{"c":{"3":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":18,"docs":{"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"34":{"tf":2.0},"36":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"78":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":13,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":1.4142135623730951},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}}}},"df":7,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"4":{"4":{"df":12,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"f":{"5":{"1":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":12,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.0},"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":19,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"2":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"101":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":41,"docs":{"0":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"85":{"tf":1.4142135623730951},"9":{"tf":1.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"b":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":7,"docs":{"102":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}}},"df":2,"docs":{"15":{"tf":1.0},"23":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"3":{"tf":2.0},"6":{"tf":2.0},"74":{"tf":2.0},"80":{"tf":2.0},"86":{"tf":2.0},"88":{"tf":2.0},"91":{"tf":2.0},"97":{"tf":2.0}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"d":{"b":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":8,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":5.196152422706632},"23":{"tf":1.7320508075688772},"25":{"tf":2.23606797749979},"26":{"tf":3.4641016151377544},"29":{"tf":3.3166247903554},"30":{"tf":1.7320508075688772},"32":{"tf":3.7416573867739413},"33":{"tf":1.7320508075688772},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"50":{"tf":1.0},"70":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"66":{"tf":1.0},"98":{"tf":1.0}}}}},"o":{"df":3,"docs":{"37":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"9":{"tf":3.0}},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"e":{"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}},"b":{"0":{"0":{"c":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"3":{"7":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"6":{"a":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"2":{"a":{"3":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"a":{"b":{"6":{"2":{"df":0,"docs":{},"e":{"6":{"0":{"b":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"104":{"tf":1.0},"11":{"tf":1.7320508075688772},"2":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"3":{"0":{"2":{"b":{"7":{"df":0,"docs":{},"f":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":5,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"12":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":2.0},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"15":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"70":{"tf":1.0}}}},"w":{"df":62,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":2.8284271247461903},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{".":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"5":{"df":1,"docs":{"8":{"tf":1.0}}},"6":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"28":{"tf":1.0},"31":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772}}}}}}}},"f":{"a":{"7":{"df":4,"docs":{"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"y":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":12,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":3.872983346207417},"26":{"tf":3.7416573867739413},"70":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"80":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"66":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":8,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"13":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"95":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"c":{"2":{"b":{"7":{"1":{"3":{"0":{"8":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"3":{"4":{"8":{"d":{"8":{"b":{"8":{"d":{"9":{"4":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"c":{"7":{"5":{"3":{"c":{"6":{"5":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":11,"docs":{"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"2":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0}}}}},"b":{"2":{"d":{"a":{"0":{"7":{"1":{"5":{"7":{"d":{"b":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.0},"92":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"22":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":22,"docs":{"0":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.7320508075688772},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}},"x":{"df":4,"docs":{"1":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":20,"docs":{"108":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":2.0},"74":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.0},"86":{"tf":2.0},"9":{"tf":2.0},"91":{"tf":2.0},"97":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"23":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":46,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":2.23606797749979},"108":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":2.449489742783178},"18":{"tf":1.7320508075688772},"19":{"tf":2.449489742783178},"2":{"tf":3.4641016151377544},"20":{"tf":2.449489742783178},"21":{"tf":1.4142135623730951},"22":{"tf":2.449489742783178},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":2.449489742783178},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":2.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.0},"76":{"tf":2.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.7320508075688772},"95":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":2.8284271247461903},"13":{"tf":1.4142135623730951},"29":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":2.23606797749979}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":7,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"23":{"tf":1.0},"33":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":14,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":2.449489742783178},"3":{"tf":2.0},"34":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.0},"98":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"103":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"31":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}},"r":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":3.3166247903554}},"s":{"d":{"b":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"22":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"98":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":42,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":2.23606797749979},"22":{"tf":2.8284271247461903},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":2.0},"3":{"tf":3.0},"31":{"tf":1.0},"32":{"tf":3.605551275463989},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"50":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":2.0},"6":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.23606797749979},"80":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":2.23606797749979},"89":{"tf":1.0},"9":{"tf":2.23606797749979},"91":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"103":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":1.7320508075688772},"32":{"tf":2.0},"33":{"tf":2.23606797749979},"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"d":{"df":39,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"_":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":20,"docs":{"0":{"tf":1.7320508075688772},"102":{"tf":1.0},"22":{"tf":2.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"90":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"10":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":26,"docs":{"1":{"tf":1.0},"10":{"tf":2.449489742783178},"102":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"11":{"tf":3.1622776601683795},"12":{"tf":3.605551275463989},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":2.0},"32":{"tf":1.0},"4":{"tf":2.0},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":2.0},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}}}}},"b":{")":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"*":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"1":{"4":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"5":{"df":0,"docs":{},"e":{"5":{"8":{"c":{"d":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":10,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"66":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.6457513110645907},"20":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":30,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":2.6457513110645907},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"30":{"tf":1.0},"93":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"105":{"tf":2.449489742783178},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":2.8284271247461903},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":3.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":1.7320508075688772},"47":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"64":{"tf":2.0},"65":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"b":{"df":23,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":2.8284271247461903},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":2.8284271247461903}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"r":{"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":16,"docs":{"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":3.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":3.1622776601683795},"34":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"58":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"15":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"104":{"tf":1.0},"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"23":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":2.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"32":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":21,"docs":{"29":{"tf":2.449489742783178},"32":{"tf":2.449489742783178},"36":{"tf":2.23606797749979},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"49":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"61":{"tf":2.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":17,"docs":{"101":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.449489742783178},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"23":{"tf":1.0}}}},"0":{"0":{"3":{"7":{"df":0,"docs":{},"f":{"b":{"d":{"b":{"2":{"9":{"6":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"f":{"8":{"4":{"c":{"7":{"6":{"1":{"0":{"5":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"9":{"8":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"a":{"2":{"a":{"1":{"b":{"6":{"8":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"69":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}}},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"b":{"5":{"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"91":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}}}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"7":{"8":{"1":{"6":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"12":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":3,"docs":{"16":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":2.0}},"f":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":2.449489742783178}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":30,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":3.3166247903554},"24":{"tf":2.0},"25":{"tf":1.0},"3":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"49":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":2.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"8":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":24,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"108":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"3":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"68":{"tf":1.7320508075688772},"69":{"tf":2.23606797749979},"70":{"tf":3.3166247903554},"71":{"tf":1.7320508075688772},"72":{"tf":2.0},"73":{"tf":2.0},"74":{"tf":2.23606797749979},"75":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"100":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"g":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":52,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"100":{"tf":1.4142135623730951},"101":{"tf":2.449489742783178},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":2.6457513110645907},"107":{"tf":1.0},"108":{"tf":2.0},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":3.605551275463989},"6":{"tf":1.7320508075688772},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.8284271247461903},"73":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.8284271247461903},"79":{"tf":1.0},"8":{"tf":4.0},"80":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.6457513110645907},"85":{"tf":1.4142135623730951},"86":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.6457513110645907},"9":{"tf":3.1622776601683795},"90":{"tf":1.4142135623730951},"91":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.8284271247461903},"96":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}},"e":{"'":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},":":{":":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":15,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"3":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":4,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"70":{"tf":1.0},"76":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"q":{"df":17,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.4142135623730951}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":10,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":2.6457513110645907},"8":{"tf":1.4142135623730951},"9":{"tf":2.23606797749979},"94":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}},"t":{"df":12,"docs":{"100":{"tf":2.8284271247461903},"101":{"tf":1.7320508075688772},"102":{"tf":2.0},"103":{"tf":2.0},"104":{"tf":2.0},"105":{"tf":2.6457513110645907},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":2.449489742783178},"9":{"tf":1.4142135623730951},"98":{"tf":2.449489742783178},"99":{"tf":1.4142135623730951}},"f":{"a":{"c":{"a":{"d":{"df":0,"docs":{},"e":{"<":{"'":{"_":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":70,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":2.23606797749979},"12":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":2.8284271247461903},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":2.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"88":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979},"91":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"107":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":2.0},"50":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":2.0},"57":{"tf":1.7320508075688772},"66":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"106":{"tf":1.0},"108":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"89":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"14":{"tf":2.23606797749979},"15":{"tf":2.8284271247461903},"16":{"tf":2.23606797749979},"4":{"tf":2.0}}}},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"2":{"df":0,"docs":{},"e":{"8":{"9":{"4":{"b":{"df":0,"docs":{},"f":{"df":5,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{"c":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"4":{"0":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"a":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}},"e":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":14,"docs":{"101":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"12":{"tf":3.0},"13":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":3.7416573867739413},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"d":{"a":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":53,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"37":{"tf":1.0},"66":{"tf":2.23606797749979},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"[":{"\"":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":2.449489742783178},"97":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":9,"docs":{"101":{"tf":1.0},"104":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{".":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":2.23606797749979},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":6,"docs":{"104":{"tf":1.0},"105":{"tf":2.23606797749979},"108":{"tf":2.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"d":{"df":5,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"8":{"tf":1.0}}}}},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":21,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.7320508075688772},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":39,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.4142135623730951},"96":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}},"df":1,"docs":{"103":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":3,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"0":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":14,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":1.7320508075688772},"26":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":30,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.8284271247461903},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":3.1622776601683795},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.0},"22":{"tf":2.8284271247461903},"23":{"tf":2.449489742783178},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0}}}}},"t":{"(":{"\"":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"80":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"100":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"h":{"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0}},"q":{"df":0,"docs":{},"l":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":55,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":3.4641016151377544},"23":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.0},"85":{"tf":1.0},"9":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":2.6457513110645907},"15":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":14,"docs":{"100":{"tf":2.0},"101":{"tf":2.0},"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":2.23606797749979},"107":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"98":{"tf":2.0},"99":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"r":{"d":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"15":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":15,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":3,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"21":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":2.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}}}}}},"i":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":49,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":4.123105625617661},"24":{"tf":2.23606797749979},"26":{"tf":1.0},"29":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"36":{"tf":3.872983346207417},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"41":{"tf":2.6457513110645907},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":2.449489742783178},"46":{"tf":2.449489742783178},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.8284271247461903},"5":{"tf":1.0},"50":{"tf":2.8284271247461903},"51":{"tf":2.8284271247461903},"52":{"tf":2.449489742783178},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"59":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":3.4641016151377544},"61":{"tf":3.0},"63":{"tf":2.449489742783178},"70":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":10,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":2.6457513110645907},"29":{"tf":1.0},"32":{"tf":2.0},"5":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"77":{"tf":2.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"29":{"tf":1.0},"8":{"tf":1.0}}}}}}},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"u":{"d":{"df":25,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.7320508075688772},"92":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"i":{"c":{"df":4,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"54":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"26":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"0":{"tf":1.0},"102":{"tf":1.4142135623730951},"11":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":42,"docs":{"103":{"tf":2.23606797749979},"105":{"tf":2.449489742783178},"108":{"tf":2.23606797749979},"22":{"tf":2.0},"23":{"tf":4.0},"24":{"tf":2.8284271247461903},"28":{"tf":2.0},"29":{"tf":3.1622776601683795},"30":{"tf":2.0},"31":{"tf":3.1622776601683795},"32":{"tf":6.0},"33":{"tf":2.23606797749979},"34":{"tf":3.0},"35":{"tf":2.0},"36":{"tf":6.244997998398398},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":3.3166247903554},"74":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":2.449489742783178},"93":{"tf":1.0},"94":{"tf":2.449489742783178},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.0},"70":{"tf":1.0}},"e":{"(":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":10,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"23":{"tf":1.7320508075688772},"32":{"tf":1.0}},"r":{"df":5,"docs":{"11":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":3.3166247903554},"9":{"tf":1.7320508075688772}}}},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"f":{"a":{"c":{"df":2,"docs":{"22":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"100":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"31":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}}}},"s":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"6":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":4,"docs":{"15":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"74":{"tf":2.0}}}}},"t":{"'":{"df":4,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":18,"docs":{"25":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":2.0},"36":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":3,"docs":{"29":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"102":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":3,"docs":{"94":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"y":{"df":4,"docs":{"15":{"tf":2.0},"22":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":3.3166247903554}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"101":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":4,"docs":{"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"100":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"106":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":2.6457513110645907},"24":{"tf":1.4142135623730951},"25":{"tf":2.0},"26":{"tf":2.8284271247461903},"29":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"66":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":4,"docs":{"19":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}},"i":{"c":{"df":3,"docs":{"66":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"23":{"tf":2.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"m":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":10,"docs":{"108":{"tf":1.0},"3":{"tf":1.4142135623730951},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":1.0},"97":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":2.0},"66":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"26":{"tf":1.0},"72":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"108":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"c":{"df":0,"docs":{},"h":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":27,"docs":{"100":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":2.8284271247461903},"108":{"tf":1.0},"23":{"tf":3.605551275463989},"24":{"tf":1.4142135623730951},"32":{"tf":3.7416573867739413},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":2.6457513110645907},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":2.0},"49":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"102":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"92":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"25":{"tf":2.23606797749979},"28":{"tf":1.0},"30":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":2.0},"41":{"tf":2.23606797749979},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":2.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":4,"docs":{"31":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"94":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"102":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.4142135623730951}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}},"l":{"df":33,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.8284271247461903},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"100":{"tf":1.0},"101":{"tf":1.0}},"i":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":2.0},"108":{"tf":1.4142135623730951},"33":{"tf":1.0},"70":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"2":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}}}},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":37,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":3.0},"32":{"tf":3.4641016151377544},"33":{"tf":2.6457513110645907},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"df":18,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":2.8284271247461903},"68":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"df":1,"docs":{"95":{"tf":1.0}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":58,"docs":{"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":2.449489742783178},"23":{"tf":1.0},"25":{"tf":3.0},"26":{"tf":2.449489742783178},"30":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":2.0},"44":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"48":{"tf":2.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.6457513110645907},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":2.449489742783178},"76":{"tf":2.449489742783178},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"82":{"tf":2.8284271247461903},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":3.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979},"94":{"tf":2.6457513110645907},"96":{"tf":1.4142135623730951},"97":{"tf":3.1622776601683795},"99":{"tf":1.4142135623730951}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"93":{"tf":1.7320508075688772},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"105":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":9,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"66":{"tf":1.7320508075688772},"84":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"4":{"df":0,"docs":{},"j":{":":{"4":{".":{"4":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"/":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"2":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"37":{"tf":1.0}}}},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":30,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"20":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":2.0},"34":{"tf":2.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.23606797749979},"41":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"32":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"(":{"df":1,"docs":{"34":{"tf":1.0}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"108":{"tf":2.0}}}}}},"df":53,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":2.6457513110645907},"104":{"tf":3.3166247903554},"105":{"tf":3.872983346207417},"106":{"tf":1.4142135623730951},"108":{"tf":3.0},"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":3.0},"23":{"tf":4.58257569495584},"25":{"tf":2.449489742783178},"26":{"tf":3.605551275463989},"28":{"tf":2.0},"29":{"tf":4.358898943540674},"30":{"tf":2.8284271247461903},"31":{"tf":2.449489742783178},"32":{"tf":4.123105625617661},"33":{"tf":2.6457513110645907},"34":{"tf":3.0},"35":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":3.0},"39":{"tf":1.7320508075688772},"40":{"tf":2.23606797749979},"41":{"tf":2.23606797749979},"42":{"tf":2.8284271247461903},"43":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":2.6457513110645907},"48":{"tf":2.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":2.23606797749979},"54":{"tf":2.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}},"e":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"101":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":10,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":2.23606797749979},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"41":{"tf":1.0}},"q":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0}}}}},"w":{"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"105":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"32":{"tf":1.0}}}}}}},"k":{"(":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"n":{".":{"df":0,"docs":{},"i":{"d":{"(":{")":{"?":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":3,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}}}},"df":6,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.0}}}}},"n":{"c":{"df":3,"docs":{"105":{"tf":1.0},"3":{"tf":1.0},"90":{"tf":1.0}}},"df":25,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":2.23606797749979},"23":{"tf":2.6457513110645907},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"81":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":8,"docs":{"16":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"70":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"23":{"tf":1.0}}}}},"df":1,"docs":{"98":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":24,"docs":{"25":{"tf":2.449489742783178},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"30":{"tf":2.449489742783178},"31":{"tf":2.0},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":3.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"df":6,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"54":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":8,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{}},"r":{"df":5,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"36":{"tf":2.0}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"65":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.0},"32":{"tf":2.0},"36":{"tf":2.449489742783178}}}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"r":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.449489742783178}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"31":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":32,"docs":{"22":{"tf":2.449489742783178},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"91":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"8":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"102":{"tf":1.0},"23":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.0},"32":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"s":{"df":13,"docs":{"102":{"tf":1.0},"108":{"tf":1.7320508075688772},"19":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}}},"t":{"df":5,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":6,"docs":{"15":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"31":{"tf":2.449489742783178},"36":{"tf":2.8284271247461903}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"3":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":3.0},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}},"t":{"df":3,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"(":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"(":{"\"":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"l":{"df":13,"docs":{"108":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"66":{"tf":1.0}},"s":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"31":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"103":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":2.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"j":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"1":{"df":4,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":24,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"6":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":34,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":2.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"2":{"tf":2.0},"20":{"tf":1.4142135623730951},"22":{"tf":5.477225575051661},"23":{"tf":3.1622776601683795},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.23606797749979},"32":{"tf":2.23606797749979},"34":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":15,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":3.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":3,"docs":{"108":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.6457513110645907}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"102":{"tf":1.7320508075688772},"104":{"tf":1.0},"108":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":52,"docs":{"0":{"tf":1.0},"105":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":3.872983346207417},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.0},"29":{"tf":4.358898943540674},"3":{"tf":2.6457513110645907},"30":{"tf":3.7416573867739413},"32":{"tf":4.47213595499958},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":2.0},"91":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":2.23606797749979},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"25":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"92":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":3.0},"8":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0}}}},"d":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.0}}}}}}},"df":28,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":2.6457513110645907},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":2.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"107":{"tf":1.0},"108":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":10,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"104":{"tf":1.0},"108":{"tf":1.4142135623730951},"2":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":6,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"92":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"49":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"(":{"df":1,"docs":{"32":{"tf":2.0}}},"df":48,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"106":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":3.0},"26":{"tf":4.0},"27":{"tf":1.7320508075688772},"28":{"tf":3.0},"29":{"tf":3.872983346207417},"30":{"tf":2.8284271247461903},"31":{"tf":2.449489742783178},"32":{"tf":6.244997998398398},"33":{"tf":2.23606797749979},"34":{"tf":3.1622776601683795},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":2.449489742783178},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":2.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":2.23606797749979},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.0}}}},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}}}},"df":7,"docs":{"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"23":{"tf":1.0},"3":{"tf":1.0}}},"df":3,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}},"v":{"df":2,"docs":{"101":{"tf":1.0},"52":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"a":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"8":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"88":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":13,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":2.23606797749979},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":14,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":2.6457513110645907},"108":{"tf":1.4142135623730951},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":3.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.23606797749979},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"v":{"df":26,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"3":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":2.6457513110645907},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"85":{"tf":1.0},"86":{"tf":2.0},"87":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"80":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}},"e":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}}}}}}},":":{":":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":7,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":3,"docs":{"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"t":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":23,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":2.0},"32":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"9":{"tf":2.0},"91":{"tf":2.0},"94":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}}},"i":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":8,"docs":{"1":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":18,"docs":{"103":{"tf":1.0},"105":{"tf":2.0},"108":{"tf":1.7320508075688772},"11":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":3.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"m":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.0}}},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":7,"docs":{"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}},"n":{"df":13,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.0},"8":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":12,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"26":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":3.3166247903554},"33":{"tf":2.23606797749979},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"41":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":27,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":3.1622776601683795},"23":{"tf":3.4641016151377544},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"32":{"tf":2.6457513110645907},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":2.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"100":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":20,"docs":{"22":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"108":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":2,"docs":{"108":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":7,"docs":{"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"i":{"c":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}},"t":{"df":32,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":2.8284271247461903},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":3.1622776601683795},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":2.23606797749979},"34":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"63":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"df":5,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.0}},"n":{"df":14,"docs":{"105":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":2.23606797749979},"35":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"20":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":2,"docs":{"102":{"tf":1.0},"77":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":9,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":2.23606797749979},"66":{"tf":1.0},"8":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.6457513110645907},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"22":{"tf":1.0},"27":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":17,"docs":{"0":{"tf":1.0},"108":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"3":{"tf":1.7320508075688772},"32":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"9":{"tf":2.0},"91":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"102":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":2,"docs":{"106":{"tf":1.0},"11":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":10,"docs":{"29":{"tf":2.449489742783178},"32":{"tf":2.449489742783178},"36":{"tf":2.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"i":{"c":{"df":14,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":9,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"83":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}},"r":{"df":11,"docs":{"108":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":39,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.23606797749979},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":3.0},"23":{"tf":5.5677643628300215},"24":{"tf":4.242640687119285},"25":{"tf":1.7320508075688772},"26":{"tf":3.1622776601683795},"28":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":3.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":5.656854249492381},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":2.449489742783178},"74":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"99":{"tf":1.0}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907}}}}}}}}}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"108":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":2.6457513110645907},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":2.449489742783178},"90":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":5,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"66":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"54":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"102":{"tf":1.0},"106":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"88":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"t":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"3":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"13":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":5,"docs":{"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}}}}},"u":{"df":3,"docs":{"100":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"i":{"df":1,"docs":{"9":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}}}}}},"l":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":4,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":2.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}},"df":7,"docs":{"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"100":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.0},"2":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"12":{"tf":2.6457513110645907},"13":{"tf":1.0},"22":{"tf":3.3166247903554},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":9,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"23":{"tf":2.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.7320508075688772},"56":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":43,"docs":{"101":{"tf":2.23606797749979},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":4.69041575982343},"23":{"tf":3.7416573867739413},"24":{"tf":2.23606797749979},"25":{"tf":4.0},"26":{"tf":3.3166247903554},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":4.0},"3":{"tf":1.4142135623730951},"30":{"tf":3.0},"31":{"tf":1.4142135623730951},"32":{"tf":5.385164807134504},"33":{"tf":1.4142135623730951},"34":{"tf":2.8284271247461903},"35":{"tf":2.23606797749979},"36":{"tf":2.449489742783178},"37":{"tf":1.0},"6":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":3.1622776601683795},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"36":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":14,"docs":{"105":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"80":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"105":{"tf":2.8284271247461903},"20":{"tf":1.4142135623730951},"22":{"tf":3.3166247903554},"23":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":3.3166247903554},"34":{"tf":2.449489742783178},"36":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":2.23606797749979},"52":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":2.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":17,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":31,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"df":57,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.0},"101":{"tf":1.4142135623730951},"102":{"tf":2.0},"105":{"tf":1.7320508075688772},"108":{"tf":3.872983346207417},"11":{"tf":1.7320508075688772},"12":{"tf":3.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":2.23606797749979},"22":{"tf":3.7416573867739413},"23":{"tf":3.1622776601683795},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.23606797749979},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":4.0},"33":{"tf":1.4142135623730951},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":2.6457513110645907},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":3.3166247903554},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":4.47213595499958},"80":{"tf":3.0},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":3.3166247903554},"87":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":4.0},"91":{"tf":3.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":3.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"'":{"df":2,"docs":{"102":{"tf":1.0},"108":{"tf":1.0}}},"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":48,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":2.23606797749979},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"108":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":2.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":4.358898943540674},"24":{"tf":2.0},"25":{"tf":2.23606797749979},"28":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":3.1622776601683795},"36":{"tf":3.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":2.0},"36":{"tf":1.4142135623730951}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":7,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"108":{"tf":2.23606797749979},"12":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"23":{"tf":2.6457513110645907},"24":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"36":{"tf":2.449489742783178}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"108":{"tf":1.0},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"23":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}}}},"df":0,"docs":{}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":13,"docs":{"101":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"22":{"tf":2.6457513110645907},"26":{"tf":1.0},"66":{"tf":1.0},"92":{"tf":2.449489742783178},"93":{"tf":1.7320508075688772},"94":{"tf":2.23606797749979},"95":{"tf":2.6457513110645907},"96":{"tf":1.4142135623730951},"97":{"tf":2.8284271247461903},"98":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":22,"docs":{"103":{"tf":2.23606797749979},"105":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"12":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":3.1622776601683795},"23":{"tf":2.8284271247461903},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"e":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"<":{"df":0,"docs":{},"i":{"6":{"4":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"5":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"v":{"4":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"df":2,"docs":{"94":{"tf":1.0},"97":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"103":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"83":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"37":{"tf":1.0}}}}}}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"108":{"tf":1.7320508075688772}},"e":{"c":{"!":{"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"104":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.0},"108":{"tf":1.0}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"104":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"98":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"0":{".":{"1":{"0":{".":{"4":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"4":{".":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":29,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.6457513110645907},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":2.23606797749979},"70":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.0},"23":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":14,"docs":{"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":53,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"11":{"tf":2.449489742783178},"12":{"tf":2.8284271247461903},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"2":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"29":{"tf":1.7320508075688772},"3":{"tf":3.1622776601683795},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":3.872983346207417},"80":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":3.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":5,"docs":{"105":{"tf":1.0},"11":{"tf":1.0},"28":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"108":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"108":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"108":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"108":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"y":{"df":6,"docs":{"105":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"b":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"8":{"tf":3.605551275463989}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"88":{"tf":1.0}}}}},"g":{"_":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"7":{"6":{"8":{"7":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"s":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"4":{"4":{"3":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"8":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"=":{"/":{"d":{"b":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"1":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"11":{"tf":1.0}},"e":{"=":{"8":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"22":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"b":{"df":2,"docs":{"106":{"tf":1.0},"108":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":7,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"\"":{"0":{".":{"1":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0}}}}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"title":{"root":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"d":{"d":{"df":6,"docs":{"106":{"tf":1.0},"50":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":5,"docs":{"107":{"tf":1.0},"37":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"96":{"tf":1.0}}}},"w":{"df":2,"docs":{"14":{"tf":1.0},"9":{"tf":1.0}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"107":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"87":{"tf":1.0},"90":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"55":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"88":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"46":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"75":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"108":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"27":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"36":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"31":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"40":{"tf":1.0},"57":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":26,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"102":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":6,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"104":{"tf":1.0},"42":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":17,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"81":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}}},"df":2,"docs":{"102":{"tf":1.0},"87":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"72":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":8,"docs":{"108":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"89":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"34":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"92":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.0},"72":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});