use core::{
	alloc::Layout,
	mem::{ size_of, align_of },
};

pub fn layout_for_n<T>(n: usize) -> Layout {
	unsafe {
		Layout::from_size_align_unchecked(
			size_of::<T>() * n,
			align_of::<T>(),
		)
	}
}
