
# Table of Contents

1.  [Warlock](#org4532644)
    1.  [More](#orgc581ab1)
    2.  [Goals](#org7bb6f6a)
    3.  [Non-goals](#org79a52c8)
    4.  [Why not to use this crate](#org46c6793)
    5.  [About allocators](#org5239f87)


<a id="org4532644"></a>

# Warlock

A collection of data structures optimized for use alongside an arena
allocator.


<a id="orgc581ab1"></a>

## More

Warlock provides some collections typically provided by `std` which are
optimized for use alongside an arena allocator. That is, these collections
**DO NOT** free their own memory. The memory they allocate is expected to be
cleaned up by the allocator itself. However, when the collections contain
items that \`impl Drop\`, the collections will drop any items they contain
properly.

These collections also differ slightly from the standard collections in that
they assume that memory allocations can fail, and will return \`Result\`s for
any operation that allocates memory.

Warlock also provides a very, very, very simple bump allocator, which may be
used alongside these data structures.


<a id="org7bb6f6a"></a>

## Goals

-   As close to `std` as possible
-   Compile on Rust stable (see [1.5](#org5239f87) for more information)


<a id="org79a52c8"></a>

## Non-goals

-   Be a 100% drop-in replacement for `std` containers


<a id="org46c6793"></a>

## Why not to use this crate

-   You want collections that behave correctly w/r/t memory allocation under any
    circumstance.
-   You want a 100% stable crate. This crate is under heavy development


<a id="org5239f87"></a>

## About allocators

As of this writing, there is currently an ongoing effort to add a standard
`Allocator` trait/concept to `std`. It is *partially* complete, however, I
expect that it will be quite a while before it lands in stable. In the
meantime, this crate provides an `Allocator` trait which is designed to be
as close as possible to the proposed standard. Once the standard `Allocator`
trait is merged, **this will be dropped**.

**In the future**, this crate will provide an optional feature which will
add a blanket implementation of the `std` `Allocator` trait for
`warlock::Allocator`.
