/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */

/// Ws : Full Worldstate Object



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Ws {
    #[serde(rename = "timestamp")]
    pub timestamp: String,
    #[serde(rename = "alerts")]
    pub alerts: Box<crate::models::Alert>,
    #[serde(rename = "arbitration")]
    pub arbitration: Box<crate::models::Arbitration>,
    #[serde(rename = "cetusCycle")]
    pub cetus_cycle: Box<crate::models::CetusCycle>,
    #[serde(rename = "constructionProgress")]
    pub construction_progress: Box<crate::models::Construction>,
    #[serde(rename = "conclaveChallenges")]
    pub conclave_challenges: Vec<serde_json::Value>,
    #[serde(rename = "dailyDeals")]
    pub daily_deals: Vec<serde_json::Value>,
    #[serde(rename = "darkSectors", skip_serializing_if = "Option::is_none")]
    pub dark_sectors: Option<Vec<serde_json::Value>>,
    #[serde(rename = "earthCycle")]
    pub earth_cycle: Box<crate::models::EarthCycle>,
    #[serde(rename = "events")]
    pub events: Vec<crate::models::Event>,
    #[serde(rename = "fissures")]
    pub fissures: Vec<crate::models::Fissure>,
    #[serde(rename = "flashSales")]
    pub flash_sales: Vec<serde_json::Value>,
    #[serde(rename = "globalUpgrades")]
    pub global_upgrades: Vec<serde_json::Value>,
    #[serde(rename = "invasions")]
    pub invasions: Vec<crate::models::Invasion>,
    #[serde(rename = "kuva", skip_serializing_if = "Option::is_none")]
    pub kuva: Option<Box<crate::models::Kuva>>,
    #[serde(rename = "news")]
    pub news: Vec<serde_json::Value>,
    #[serde(rename = "nightwave", skip_serializing_if = "Option::is_none")]
    pub nightwave: Option<Box<crate::models::Nightwave>>,
    #[serde(rename = "persistentEnemies")]
    pub persistent_enemies: Vec<serde_json::Value>,
    #[serde(rename = "simaris", skip_serializing_if = "Option::is_none")]
    pub simaris: Option<Box<crate::models::Simaris>>,
    #[serde(rename = "sortie")]
    pub sortie: Box<crate::models::Sortie>,
    #[serde(rename = "steelPath")]
    pub steel_path: Box<crate::models::SteelPath>,
    #[serde(rename = "syndicateMissions")]
    pub syndicate_missions: Vec<crate::models::SyndicateMission>,
    #[serde(rename = "vallisCycle")]
    pub vallis_cycle: Box<crate::models::VallisCycle>,
    #[serde(rename = "voidTrader")]
    pub void_trader: Box<crate::models::VoidTrader>,
}

impl Ws {
    /// Full Worldstate Object
    pub fn new(timestamp: String, alerts: crate::models::Alert, arbitration: crate::models::Arbitration, cetus_cycle: crate::models::CetusCycle, construction_progress: crate::models::Construction, conclave_challenges: Vec<serde_json::Value>, daily_deals: Vec<serde_json::Value>, earth_cycle: crate::models::EarthCycle, events: Vec<crate::models::Event>, fissures: Vec<crate::models::Fissure>, flash_sales: Vec<serde_json::Value>, global_upgrades: Vec<serde_json::Value>, invasions: Vec<crate::models::Invasion>, news: Vec<serde_json::Value>, persistent_enemies: Vec<serde_json::Value>, sortie: crate::models::Sortie, steel_path: crate::models::SteelPath, syndicate_missions: Vec<crate::models::SyndicateMission>, vallis_cycle: crate::models::VallisCycle, void_trader: crate::models::VoidTrader) -> Ws {
        Ws {
            timestamp,
            alerts: Box::new(alerts),
            arbitration: Box::new(arbitration),
            cetus_cycle: Box::new(cetus_cycle),
            construction_progress: Box::new(construction_progress),
            conclave_challenges,
            daily_deals,
            dark_sectors: None,
            earth_cycle: Box::new(earth_cycle),
            events,
            fissures,
            flash_sales,
            global_upgrades,
            invasions,
            kuva: None,
            news,
            nightwave: None,
            persistent_enemies,
            simaris: None,
            sortie: Box::new(sortie),
            steel_path: Box::new(steel_path),
            syndicate_missions,
            vallis_cycle: Box::new(vallis_cycle),
            void_trader: Box::new(void_trader),
        }
    }
}


