/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct WeaponsFields {
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "uniqueName", skip_serializing_if = "Option::is_none")]
    pub unique_name: Option<String>,
    #[serde(rename = "patchlogs", skip_serializing_if = "Option::is_none")]
    pub patchlogs: Option<Vec<crate::models::Patchlog>>,
    #[serde(rename = "components", skip_serializing_if = "Option::is_none")]
    pub components: Option<Box<crate::models::Item>>,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<String>,
    #[serde(rename = "tradable", skip_serializing_if = "Option::is_none")]
    pub tradable: Option<bool>,
    #[serde(rename = "introduced", skip_serializing_if = "Option::is_none")]
    pub introduced: Option<Box<crate::models::Introduced>>,
    #[serde(rename = "category", skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "productCategory", skip_serializing_if = "Option::is_none")]
    pub product_category: Option<String>,
    /// Image name, accessible at https://cdn.warframestat.us/img/{imageName} 
    #[serde(rename = "imageName", skip_serializing_if = "Option::is_none")]
    pub image_name: Option<String>,
    #[serde(rename = "estimatedVaultDate", skip_serializing_if = "Option::is_none")]
    pub estimated_vault_date: Option<String>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "mr", skip_serializing_if = "Option::is_none")]
    pub mr: Option<f32>,
    #[serde(rename = "riven_disposition", skip_serializing_if = "Option::is_none")]
    pub riven_disposition: Option<f32>,
    #[serde(rename = "polarities", skip_serializing_if = "Option::is_none")]
    pub polarities: Option<Vec<crate::models::Polarity>>,
    #[serde(rename = "thumbnail", skip_serializing_if = "Option::is_none")]
    pub thumbnail: Option<String>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    #[serde(rename = "vaulted", skip_serializing_if = "Option::is_none")]
    pub vaulted: Option<bool>,
    #[serde(rename = "marketCost", skip_serializing_if = "Option::is_none")]
    pub market_cost: Option<String>,
    #[serde(rename = "bpCost", skip_serializing_if = "Option::is_none")]
    pub bp_cost: Option<String>,
    #[serde(rename = "attacks", skip_serializing_if = "Option::is_none")]
    pub attacks: Option<Vec<crate::models::Attack>>,
    #[serde(rename = "masteryReq", skip_serializing_if = "Option::is_none")]
    pub mastery_req: Option<i32>,
    #[serde(rename = "buildPrice", skip_serializing_if = "Option::is_none")]
    pub build_price: Option<i32>,
    #[serde(rename = "buildTime", skip_serializing_if = "Option::is_none")]
    pub build_time: Option<i32>,
    #[serde(rename = "skipBuildTimePrice", skip_serializing_if = "Option::is_none")]
    pub skip_build_time_price: Option<i32>,
    #[serde(rename = "buildQuantity", skip_serializing_if = "Option::is_none")]
    pub build_quantity: Option<i32>,
    #[serde(rename = "consumeOnBuild", skip_serializing_if = "Option::is_none")]
    pub consume_on_build: Option<bool>,
    #[serde(rename = "wikiaThumbnail", skip_serializing_if = "Option::is_none")]
    pub wikia_thumbnail: Option<String>,
    #[serde(rename = "wikiaUrl", skip_serializing_if = "Option::is_none")]
    pub wikia_url: Option<String>,
    #[serde(rename = "criticalChance", skip_serializing_if = "Option::is_none")]
    pub critical_chance: Option<f32>,
    #[serde(rename = "criticalMultiplier", skip_serializing_if = "Option::is_none")]
    pub critical_multiplier: Option<f32>,
    #[serde(rename = "disposition", skip_serializing_if = "Option::is_none")]
    pub disposition: Option<i32>,
    #[serde(rename = "fireRate", skip_serializing_if = "Option::is_none")]
    pub fire_rate: Option<f32>,
    #[serde(rename = "omegaAttenuation", skip_serializing_if = "Option::is_none")]
    pub omega_attenuation: Option<f32>,
    #[serde(rename = "procChance", skip_serializing_if = "Option::is_none")]
    pub proc_chance: Option<f32>,
    #[serde(rename = "releaseDate", skip_serializing_if = "Option::is_none")]
    pub release_date: Option<f32>,
    /// Specifies the slot of an item.
    #[serde(rename = "slot", skip_serializing_if = "Option::is_none")]
    pub slot: Option<i32>,
    #[serde(rename = "totalDamage", skip_serializing_if = "Option::is_none")]
    pub total_damage: Option<i32>,
    #[serde(rename = "vaultDate", skip_serializing_if = "Option::is_none")]
    pub vault_date: Option<String>,
    #[serde(rename = "accuracy", skip_serializing_if = "Option::is_none")]
    pub accuracy: Option<f32>,
    #[serde(rename = "ammo", skip_serializing_if = "Option::is_none")]
    pub ammo: Option<f32>,
    #[serde(rename = "magazineSize", skip_serializing_if = "Option::is_none")]
    pub magazine_size: Option<i32>,
    #[serde(rename = "multishot", skip_serializing_if = "Option::is_none")]
    pub multishot: Option<f32>,
    #[serde(rename = "noise", skip_serializing_if = "Option::is_none")]
    pub noise: Option<String>,
    #[serde(rename = "trigger", skip_serializing_if = "Option::is_none")]
    pub trigger: Option<String>,
    #[serde(rename = "blockingAngle", skip_serializing_if = "Option::is_none")]
    pub blocking_angle: Option<i32>,
    #[serde(rename = "comboDuration", skip_serializing_if = "Option::is_none")]
    pub combo_duration: Option<i32>,
    #[serde(rename = "damagePerShot", skip_serializing_if = "Option::is_none")]
    pub damage_per_shot: Option<Vec<f32>>,
    #[serde(rename = "followThrough", skip_serializing_if = "Option::is_none")]
    pub follow_through: Option<f32>,
    #[serde(rename = "heavyAttackDamage", skip_serializing_if = "Option::is_none")]
    pub heavy_attack_damage: Option<i32>,
    #[serde(rename = "heavySlamAttack", skip_serializing_if = "Option::is_none")]
    pub heavy_slam_attack: Option<i32>,
    #[serde(rename = "heavySlamRadialDamage", skip_serializing_if = "Option::is_none")]
    pub heavy_slam_radial_damage: Option<i32>,
    #[serde(rename = "heavySlamRadius", skip_serializing_if = "Option::is_none")]
    pub heavy_slam_radius: Option<i32>,
    #[serde(rename = "range", skip_serializing_if = "Option::is_none")]
    pub range: Option<f32>,
    #[serde(rename = "slamAttack", skip_serializing_if = "Option::is_none")]
    pub slam_attack: Option<i32>,
    #[serde(rename = "slamRadialDamage", skip_serializing_if = "Option::is_none")]
    pub slam_radial_damage: Option<i32>,
    #[serde(rename = "slamRadius", skip_serializing_if = "Option::is_none")]
    pub slam_radius: Option<i32>,
    #[serde(rename = "slideAttack", skip_serializing_if = "Option::is_none")]
    pub slide_attack: Option<i32>,
    #[serde(rename = "stancePolarity", skip_serializing_if = "Option::is_none")]
    pub stance_polarity: Option<crate::models::Polarity>,
    #[serde(rename = "windUp", skip_serializing_if = "Option::is_none")]
    pub wind_up: Option<f32>,
}

impl WeaponsFields {
    pub fn new() -> WeaponsFields {
        WeaponsFields {
            name: None,
            unique_name: None,
            patchlogs: None,
            components: None,
            description: None,
            _type: None,
            tradable: None,
            introduced: None,
            category: None,
            product_category: None,
            image_name: None,
            estimated_vault_date: None,
            url: None,
            mr: None,
            riven_disposition: None,
            polarities: None,
            thumbnail: None,
            tags: None,
            vaulted: None,
            market_cost: None,
            bp_cost: None,
            attacks: None,
            mastery_req: None,
            build_price: None,
            build_time: None,
            skip_build_time_price: None,
            build_quantity: None,
            consume_on_build: None,
            wikia_thumbnail: None,
            wikia_url: None,
            critical_chance: None,
            critical_multiplier: None,
            disposition: None,
            fire_rate: None,
            omega_attenuation: None,
            proc_chance: None,
            release_date: None,
            slot: None,
            total_damage: None,
            vault_date: None,
            accuracy: None,
            ammo: None,
            magazine_size: None,
            multishot: None,
            noise: None,
            trigger: None,
            blocking_angle: None,
            combo_duration: None,
            damage_per_shot: None,
            follow_through: None,
            heavy_attack_damage: None,
            heavy_slam_attack: None,
            heavy_slam_radial_damage: None,
            heavy_slam_radius: None,
            range: None,
            slam_attack: None,
            slam_radial_damage: None,
            slam_radius: None,
            slide_attack: None,
            stance_polarity: None,
            wind_up: None,
        }
    }
}


