/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Reward {
    /// Items that have a quantity attached
    #[serde(rename = "countedItems")]
    pub counted_items: Vec<crate::models::RewardCountedItems>,
    /// thumbnail URL
    #[serde(rename = "thumbnail")]
    pub thumbnail: String,
    /// RGB value as an int assigned to this reward
    #[serde(rename = "color")]
    pub color: f32,
    /// Amount of credits awarded
    #[serde(rename = "credits")]
    pub credits: f32,
    /// string representation of the reward
    #[serde(rename = "asString")]
    pub as_string: String,
    /// Items' names possible to be won
    #[serde(rename = "items")]
    pub items: Vec<String>,
    /// formatted string describing all included items
    #[serde(rename = "itemString")]
    pub item_string: String,
}

impl Reward {
    pub fn new(counted_items: Vec<crate::models::RewardCountedItems>, thumbnail: String, color: f32, credits: f32, as_string: String, items: Vec<String>, item_string: String) -> Reward {
        Reward {
            counted_items,
            thumbnail,
            color,
            credits,
            as_string,
            items,
            item_string,
        }
    }
}


