use std::fmt::Display;

/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts)
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */

///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Platform {
    #[serde(rename = "pc")]
    Pc,
    #[serde(rename = "ps4")]
    Ps4,
    #[serde(rename = "xb1")]
    Xb1,
    #[serde(rename = "swi")]
    Swi,
}

impl Default for Platform {
    fn default() -> Platform {
        Self::Pc
    }
}

impl Display for Platform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let platform = match self {
            Self::Pc => String::from("pc"),
            Self::Ps4 => String::from("ps4"),
            Self::Xb1 => String::from("xb1"),
            Self::Swi => String::from("swi"),
        };

        f.write_str(platform.as_str())
    }
}
