/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Mission {
    #[serde(rename = "reward")]
    pub reward: Box<crate::models::Reward>,
    #[serde(rename = "node")]
    pub node: String,
    #[serde(rename = "faction")]
    pub faction: String,
    #[serde(rename = "maxEnemyLevel")]
    pub max_enemy_level: f32,
    #[serde(rename = "minEnemyLevel")]
    pub min_enemy_level: f32,
    #[serde(rename = "maxWaveNum")]
    pub max_wave_num: f32,
    #[serde(rename = "type")]
    pub _type: String,
    #[serde(rename = "nightmare")]
    pub nightmare: bool,
    /// Whether or not an Archwing is required for participating in the mision.
    #[serde(rename = "archwingRequired")]
    pub archwing_required: bool,
    /// Whether or not the mission takes place in a submerssible mission.
    #[serde(rename = "isSharkwing", skip_serializing_if = "Option::is_none")]
    pub is_sharkwing: Option<bool>,
    /// Enemy specification for the mission
    #[serde(rename = "enemySpec", skip_serializing_if = "Option::is_none")]
    pub enemy_spec: Option<String>,
    /// Override for the map on this mission
    #[serde(rename = "levelOverride", skip_serializing_if = "Option::is_none")]
    pub level_override: Option<String>,
    /// Array of strings denoting extra spawners for a mission
    #[serde(rename = "advancedSpawners", skip_serializing_if = "Option::is_none")]
    pub advanced_spawners: Option<Vec<String>>,
    /// Items required to enter the mission
    #[serde(rename = "requiredItems", skip_serializing_if = "Option::is_none")]
    pub required_items: Option<Vec<String>>,
    /// Whether or not the required items are consumed
    #[serde(rename = "consumeRequiredItems", skip_serializing_if = "Option::is_none")]
    pub consume_required_items: Option<bool>,
    /// Whether or not leaders are always allowed
    #[serde(rename = "leadersAlwaysAllowed", skip_serializing_if = "Option::is_none")]
    pub leaders_always_allowed: Option<bool>,
    /// Affectors for this mission
    #[serde(rename = "levelAuras", skip_serializing_if = "Option::is_none")]
    pub level_auras: Option<Vec<String>>,
}

impl Mission {
    pub fn new(reward: crate::models::Reward, node: String, faction: String, max_enemy_level: f32, min_enemy_level: f32, max_wave_num: f32, _type: String, nightmare: bool, archwing_required: bool) -> Mission {
        Mission {
            reward: Box::new(reward),
            node,
            faction,
            max_enemy_level,
            min_enemy_level,
            max_wave_num,
            _type,
            nightmare,
            archwing_required,
            is_sharkwing: None,
            enemy_spec: None,
            level_override: None,
            advanced_spawners: None,
            required_items: None,
            consume_required_items: None,
            leaders_always_allowed: None,
            level_auras: None,
        }
    }
}


