/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct InvasionAllOf {
    #[serde(rename = "attacker", skip_serializing_if = "Option::is_none")]
    pub attacker: Option<Box<serde_json::Value>>,
    #[serde(rename = "attackerReward", skip_serializing_if = "Option::is_none")]
    pub attacker_reward: Option<Box<serde_json::Value>>,
    #[serde(rename = "attackingFaction")]
    pub attacking_faction: String,
    /// Whether or not this invasion is \"over\"
    #[serde(rename = "completed")]
    pub completed: bool,
    /// percentage complete as a float value
    #[serde(rename = "completion")]
    pub completion: f32,
    /// How many fights have happened.
    #[serde(rename = "count")]
    pub count: f32,
    #[serde(rename = "defender", skip_serializing_if = "Option::is_none")]
    pub defender: Option<Box<serde_json::Value>>,
    #[serde(rename = "defenderReward", skip_serializing_if = "Option::is_none")]
    pub defender_reward: Option<Box<serde_json::Value>>,
    #[serde(rename = "defendingFaction")]
    pub defending_faction: String,
    /// description of invasion
    #[serde(rename = "desc")]
    pub desc: String,
    /// time string showing approximate time to the end of the invasion
    #[serde(rename = "eta")]
    pub eta: String,
    /// localized Node name
    #[serde(rename = "node")]
    pub node: String,
    /// i18n key for matching node (always english translation)
    #[serde(rename = "nodeKey", skip_serializing_if = "Option::is_none")]
    pub node_key: Option<String>,
    /// How many runs of this mission are needed to qualify for the reward
    #[serde(rename = "requiredRuns")]
    pub required_runs: f32,
    #[serde(rename = "rewardTypes", skip_serializing_if = "Option::is_none")]
    pub reward_types: Option<Vec<crate::models::RewardType>>,
    #[serde(rename = "startString", skip_serializing_if = "Option::is_none")]
    pub start_string: Option<String>,
    #[serde(rename = "vsInfestation")]
    pub vs_infestation: bool,
}

impl InvasionAllOf {
    pub fn new(attacking_faction: String, completed: bool, completion: f32, count: f32, defending_faction: String, desc: String, eta: String, node: String, required_runs: f32, vs_infestation: bool) -> InvasionAllOf {
        InvasionAllOf {
            attacker: None,
            attacker_reward: None,
            attacking_faction,
            completed,
            completion,
            count,
            defender: None,
            defender_reward: None,
            defending_faction,
            desc,
            eta,
            node,
            node_key: None,
            required_runs,
            reward_types: None,
            start_string: None,
            vs_infestation,
        }
    }
}


