/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Fissure {
    #[serde(rename = "node")]
    pub node: String,
    #[serde(rename = "expired")]
    pub expired: bool,
    #[serde(rename = "eta")]
    pub eta: String,
    #[serde(rename = "missionType")]
    pub mission_type: String,
    #[serde(rename = "tier")]
    pub tier: String,
    #[serde(rename = "tierNum")]
    pub tier_num: f32,
    #[serde(rename = "enemy")]
    pub enemy: String,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "expiry")]
    pub expiry: String,
    #[serde(rename = "activation")]
    pub activation: String,
    /// Whether or not this fissure is a void storm
    #[serde(rename = "isStorm", skip_serializing_if = "Option::is_none")]
    pub is_storm: Option<bool>,
}

impl Fissure {
    pub fn new(node: String, expired: bool, eta: String, mission_type: String, tier: String, tier_num: f32, enemy: String, id: String, expiry: String, activation: String) -> Fissure {
        Fissure {
            node,
            expired,
            eta,
            mission_type,
            tier,
            tier_num,
            enemy,
            id,
            expiry,
            activation,
            is_storm: None,
        }
    }
}


