/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct EventMessage {
    /// Who commissioned this reward
    #[serde(rename = "sender", skip_serializing_if = "Option::is_none")]
    pub sender: Option<String>,
    /// Title of the in-game mail received for completing the step.
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// Body of the in-game mail received for completing the step.
    #[serde(rename = "message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// Path to sender icon string.
    #[serde(rename = "senderIcon", skip_serializing_if = "Option::is_none")]
    pub sender_icon: Option<String>,
    /// Attachments to the message. Unknown usage.
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
}

impl EventMessage {
    pub fn new() -> EventMessage {
        EventMessage {
            sender: None,
            subject: None,
            message: None,
            sender_icon: None,
            attachments: None,
        }
    }
}


