/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Event {
    /// Timestamp of when the event started
    #[serde(rename = "activation", skip_serializing_if = "Option::is_none")]
    pub activation: Option<String>,
    /// Timestamp of when the event ends
    #[serde(rename = "expiry", skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    /// Maximum score to complete the event
    #[serde(rename = "maximumScore", skip_serializing_if = "Option::is_none")]
    pub maximum_score: Option<f32>,
    /// The current score for the event
    #[serde(rename = "currentScore", skip_serializing_if = "Option::is_none")]
    pub current_score: Option<f32>,
    /// Interval for the first goal
    #[serde(rename = "smallInterval", skip_serializing_if = "Option::is_none")]
    pub small_interval: Option<f32>,
    /// Interval for the second intermediate score
    #[serde(rename = "largeInterval", skip_serializing_if = "Option::is_none")]
    pub large_interval: Option<f32>,
    #[serde(rename = "faction", skip_serializing_if = "Option::is_none")]
    pub faction: Option<crate::models::Faction>,
    /// The description or \"subtitle\" for the event.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Tooltip for the event
    #[serde(rename = "tooltip", skip_serializing_if = "Option::is_none")]
    pub tooltip: Option<String>,
    /// Node that the event is taking place on
    #[serde(rename = "node", skip_serializing_if = "Option::is_none")]
    pub node: Option<String>,
    /// Nodes that the event is happening concurrently on
    #[serde(rename = "concurrentNodes", skip_serializing_if = "Option::is_none")]
    pub concurrent_nodes: Option<Vec<String>>,
    /// Node that is being attacked & defended in the event.
    #[serde(rename = "victimNode", skip_serializing_if = "Option::is_none")]
    pub victim_node: Option<String>,
    /// Localized tag for the event score
    #[serde(rename = "scoreLocTag", skip_serializing_if = "Option::is_none")]
    pub score_loc_tag: Option<String>,
    #[serde(rename = "rewards", skip_serializing_if = "Option::is_none")]
    pub rewards: Option<Vec<crate::models::Reward>>,
    /// Whether or not the event is expired
    #[serde(rename = "expired", skip_serializing_if = "Option::is_none")]
    pub expired: Option<bool>,
    /// Amount of health remaining for the target
    #[serde(rename = "health", skip_serializing_if = "Option::is_none")]
    pub health: Option<f32>,
    #[serde(rename = "affiliatedWith", skip_serializing_if = "Option::is_none")]
    pub affiliated_with: Option<crate::models::Syndicate>,
    #[serde(rename = "jobs", skip_serializing_if = "Option::is_none")]
    pub jobs: Option<Vec<crate::models::SyndicateJob>>,
    /// Interim steps, marking progress towards the final goal.
    #[serde(rename = "interimSteps", skip_serializing_if = "Option::is_none")]
    pub interim_steps: Option<Vec<crate::models::EventInterimSteps>>,
    #[serde(rename = "progressSteps", skip_serializing_if = "Option::is_none")]
    pub progress_steps: Option<Box<crate::models::EventProgressSteps>>,
    /// Total of progressSteps values.
    #[serde(rename = "progressTotal", skip_serializing_if = "Option::is_none")]
    pub progress_total: Option<f32>,
    /// Whether or not to show the total score at the end of the mission
    #[serde(rename = "showTotalAtEndOfMission", skip_serializing_if = "Option::is_none")]
    pub show_total_at_end_of_mission: Option<bool>,
    /// Whether or not the event is personal
    #[serde(rename = "isPersonal", skip_serializing_if = "Option::is_none")]
    pub is_personal: Option<bool>,
    /// Whether or not the event is communal
    #[serde(rename = "isCommunity", skip_serializing_if = "Option::is_none")]
    pub is_community: Option<bool>,
    /// Drops in the area around the event node
    #[serde(rename = "regionDrops", skip_serializing_if = "Option::is_none")]
    pub region_drops: Option<Vec<String>>,
    /// Archwing Drops in effect while this event is active
    #[serde(rename = "archwingDrops", skip_serializing_if = "Option::is_none")]
    pub archwing_drops: Option<Vec<String>>,
    /// Attempt to summarize event in a short string. (Do not use).
    #[serde(rename = "asString", skip_serializing_if = "Option::is_none")]
    pub as_string: Option<String>,
    /// Miscellaneous metadata in a string provided by Digital Extremes
    #[serde(rename = "metadata", skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    /// Completion bonus amounts per-stage
    #[serde(rename = "completionBonuses", skip_serializing_if = "Option::is_none")]
    pub completion_bonuses: Option<Vec<f32>>,
    /// Internal string used for unknown purpose
    #[serde(rename = "scoreVar", skip_serializing_if = "Option::is_none")]
    pub score_var: Option<String>,
    /// Alternate Expiry. Use unknown.
    #[serde(rename = "altExpiry", skip_serializing_if = "Option::is_none")]
    pub alt_expiry: Option<String>,
    /// Alternate Activation. Use unknown.
    #[serde(rename = "altActivation", skip_serializing_if = "Option::is_none")]
    pub alt_activation: Option<String>,
    #[serde(rename = "nextAlt", skip_serializing_if = "Option::is_none")]
    pub next_alt: Option<Box<crate::models::EventNextAlt>>,
}

impl Event {
    pub fn new() -> Event {
        Event {
            activation: None,
            expiry: None,
            maximum_score: None,
            current_score: None,
            small_interval: None,
            large_interval: None,
            faction: None,
            description: None,
            tooltip: None,
            node: None,
            concurrent_nodes: None,
            victim_node: None,
            score_loc_tag: None,
            rewards: None,
            expired: None,
            health: None,
            affiliated_with: None,
            jobs: None,
            interim_steps: None,
            progress_steps: None,
            progress_total: None,
            show_total_at_end_of_mission: None,
            is_personal: None,
            is_community: None,
            region_drops: None,
            archwing_drops: None,
            as_string: None,
            metadata: None,
            completion_bonuses: None,
            score_var: None,
            alt_expiry: None,
            alt_activation: None,
            next_alt: None,
        }
    }
}


