/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */

/// DarkSectorHistory : Describes a Dark Sector Historical Battle.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DarkSectorHistory {
    /// Clan or alliance that was defending.
    #[serde(rename = "defender", skip_serializing_if = "Option::is_none")]
    pub defender: Option<String>,
    /// Whether or not the defender was an alliance.
    #[serde(rename = "defenderIsAlliance", skip_serializing_if = "Option::is_none")]
    pub defender_is_alliance: Option<bool>,
    /// Clan or alliance that was attacking.
    #[serde(rename = "attacker", skip_serializing_if = "Option::is_none")]
    pub attacker: Option<String>,
    /// One of attacker or defender, whichever one won.
    #[serde(rename = "winner", skip_serializing_if = "Option::is_none")]
    pub winner: Option<String>,
    /// When the battle started.
    #[serde(rename = "start", skip_serializing_if = "Option::is_none")]
    pub start: Option<String>,
    /// When the battle ended.
    #[serde(rename = "end", skip_serializing_if = "Option::is_none")]
    pub end: Option<String>,
}

impl DarkSectorHistory {
    /// Describes a Dark Sector Historical Battle.
    pub fn new() -> DarkSectorHistory {
        DarkSectorHistory {
            defender: None,
            defender_is_alliance: None,
            attacker: None,
            winner: None,
            start: None,
            end: None,
        }
    }
}


