/*
 * WarframeStat.us API
 *
 * Simple API for data from the game Warframe. [Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/) [Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts) 
 *
 * The version of the OpenAPI document: living
 * Contact: tobiah@protonmail.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CambionCycle {
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "expiry")]
    pub expiry: String,
    #[serde(rename = "activation")]
    pub activation: String,
    #[serde(rename = "active")]
    pub active: Active,
    #[serde(rename = "timeLeft", skip_serializing_if = "Option::is_none")]
    pub time_left: Option<String>,
}

impl CambionCycle {
    pub fn new(id: String, expiry: String, activation: String, active: Active) -> CambionCycle {
        CambionCycle {
            id,
            expiry,
            activation,
            active,
            time_left: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Active {
    #[serde(rename = "vome")]
    Vome,
    #[serde(rename = "fass")]
    Fass,
}

impl Default for Active {
    fn default() -> Active {
        Self::Vome
    }
}

