# Rust API client for warframestat-rs

Simple API for data from the game Warframe.
[Parser Docs](https://wfcd.github.io/warframe-worldstate-parser/)
[Items Types](https://github.com/WFCD/warframe-items/blob/master/index.d.ts)



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: living
- Package version: 0.0.1
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `warframestat-rs` and add the following to `Cargo.toml` under `[dependencies]`:

```
warframestat-rs = { path = "./warframestat-rs" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.warframestat.us*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*RivensApi* | [**platform_rivens_get**](docs/RivensApi.md#platform_rivens_get) | **GET** /{platform}/rivens | Get Riven statistic data
*RivensApi* | [**platform_rivens_search_query_get**](docs/RivensApi.md#platform_rivens_search_query_get) | **GET** /{platform}/rivens/search/{query} | Get Riven statistic data
*SearchableApi* | [**arcanes_search_query_get**](docs/SearchableApi.md#arcanes_search_query_get) | **GET** /arcanes/search/{query} | Get Arcane Enhancement Data based on the query
*SearchableApi* | [**conclave_search_query_get**](docs/SearchableApi.md#conclave_search_query_get) | **GET** /conclave/search/{query} | Get conclave challenge data based on the query
*SearchableApi* | [**drops_search_query_get**](docs/SearchableApi.md#drops_search_query_get) | **GET** /drops/search/{query} | Get Warframe Drops data
*SearchableApi* | [**events_search_query_get**](docs/SearchableApi.md#events_search_query_get) | **GET** /events/search/{query} | Get Event-specific Data based on the query
*SearchableApi* | [**factions_search_query_get**](docs/SearchableApi.md#factions_search_query_get) | **GET** /factions/search/{query} | Get Faction translation information based on the query.
*SearchableApi* | [**fissure_modifiers_search_query_get**](docs/SearchableApi.md#fissure_modifiers_search_query_get) | **GET** /fissureModifiers/search/{query} | Get Fissure Modifier translation data based on the query.
*SearchableApi* | [**items_search_query_get**](docs/SearchableApi.md#items_search_query_get) | **GET** /items/search/{query} | Get Warframe Items data
*SearchableApi* | [**languages_search_query_get**](docs/SearchableApi.md#languages_search_query_get) | **GET** /languages/search/{query} | Get Language strings for Warframe based on the query.
*SearchableApi* | [**mission_types_search_query_get**](docs/SearchableApi.md#mission_types_search_query_get) | **GET** /missionTypes/search/{query} | Get MissionType Translation Keys based on the query
*SearchableApi* | [**mods_query_get**](docs/SearchableApi.md#mods_query_get) | **GET** /mods/{query} | Get item data.
*SearchableApi* | [**mods_search_query_get**](docs/SearchableApi.md#mods_search_query_get) | **GET** /mods/search/{query} | Get Warframe Items data
*SearchableApi* | [**operation_types_search_query_get**](docs/SearchableApi.md#operation_types_search_query_get) | **GET** /operationTypes/search/{query} | Get operation types data based on the query.
*SearchableApi* | [**persistent_enemy_search_query_get**](docs/SearchableApi.md#persistent_enemy_search_query_get) | **GET** /persistentEnemy/search/{query} | Get Persistent Enemy translation data based on the query.
*SearchableApi* | [**sol_nodes_search_query_get**](docs/SearchableApi.md#sol_nodes_search_query_get) | **GET** /solNodes/search/{query} | Get Sol Node information and translation data based on the query.
*SearchableApi* | [**sortie_search_query_get**](docs/SearchableApi.md#sortie_search_query_get) | **GET** /sortie/search/{query} | Get Sortie translation information based on the query.
*SearchableApi* | [**syndicates_search_query_get**](docs/SearchableApi.md#syndicates_search_query_get) | **GET** /syndicates/search/{query} | Get Syndicate translation data based on the query.
*SearchableApi* | [**tutorials_search_query_get**](docs/SearchableApi.md#tutorials_search_query_get) | **GET** /tutorials/search/{query} | Get Tutorials Data based on the query
*SearchableApi* | [**upgrade_types_search_query_get**](docs/SearchableApi.md#upgrade_types_search_query_get) | **GET** /upgradeTypes/search/{query} | Get upgrade types data for global upgrades based on the query.
*SearchableApi* | [**warframes_query_get**](docs/SearchableApi.md#warframes_query_get) | **GET** /warframes/{query} | Get Warframe specs and data, such as polarity and defenses, and profile based on the query. Single result
*SearchableApi* | [**warframes_search_query_get**](docs/SearchableApi.md#warframes_search_query_get) | **GET** /warframes/search/{query} | Get Warframe specs and data, such as polarities defenses, and profile based on the query.
*SearchableApi* | [**weapons_query_get**](docs/SearchableApi.md#weapons_query_get) | **GET** /weapons/{query} | Get Weapon specs and data, such as polarity based on the query. Single result
*SearchableApi* | [**weapons_search_query_get**](docs/SearchableApi.md#weapons_search_query_get) | **GET** /weapons/search/{query} | Get Weapon data and statistics based on the query.
*StaticProcessingDataApi* | [**arcanes_get**](docs/StaticProcessingDataApi.md#arcanes_get) | **GET** /arcanes | Get Arcane Enhancement Data
*StaticProcessingDataApi* | [**conclave_get**](docs/StaticProcessingDataApi.md#conclave_get) | **GET** /conclave | Get conclave challenge data
*StaticProcessingDataApi* | [**events_get**](docs/StaticProcessingDataApi.md#events_get) | **GET** /events | Get Event-specific Data
*StaticProcessingDataApi* | [**factions_get**](docs/StaticProcessingDataApi.md#factions_get) | **GET** /factions | Get Faction translation information.
*StaticProcessingDataApi* | [**fissure_modifiers_get**](docs/StaticProcessingDataApi.md#fissure_modifiers_get) | **GET** /fissureModifiers | Get Fissure Modifier translation data.
*StaticProcessingDataApi* | [**items_get**](docs/StaticProcessingDataApi.md#items_get) | **GET** /items | Get item data.
*StaticProcessingDataApi* | [**items_query_get**](docs/StaticProcessingDataApi.md#items_query_get) | **GET** /items/{query} | Get item data.
*StaticProcessingDataApi* | [**languages_get**](docs/StaticProcessingDataApi.md#languages_get) | **GET** /languages | Get Language strings for Warframe.
*StaticProcessingDataApi* | [**locales_get**](docs/StaticProcessingDataApi.md#locales_get) | **GET** /locales | Full list of supported locales
*StaticProcessingDataApi* | [**mission_types_get**](docs/StaticProcessingDataApi.md#mission_types_get) | **GET** /missionTypes | Get MissionType Translation Keys
*StaticProcessingDataApi* | [**mods_get**](docs/StaticProcessingDataApi.md#mods_get) | **GET** /mods | Get Mod data.
*StaticProcessingDataApi* | [**mods_query_get**](docs/StaticProcessingDataApi.md#mods_query_get) | **GET** /mods/{query} | Get item data.
*StaticProcessingDataApi* | [**mods_search_query_get**](docs/StaticProcessingDataApi.md#mods_search_query_get) | **GET** /mods/search/{query} | Get Warframe Items data
*StaticProcessingDataApi* | [**operation_types_get**](docs/StaticProcessingDataApi.md#operation_types_get) | **GET** /operationTypes | Get operation types data.
*StaticProcessingDataApi* | [**persistent_enemy_get**](docs/StaticProcessingDataApi.md#persistent_enemy_get) | **GET** /persistentEnemy | Get Persistent Enemy translation data.
*StaticProcessingDataApi* | [**sol_nodes_get**](docs/StaticProcessingDataApi.md#sol_nodes_get) | **GET** /solNodes | Get Sol Node information and translation data.
*StaticProcessingDataApi* | [**sortie_get**](docs/StaticProcessingDataApi.md#sortie_get) | **GET** /sortie | Get Sortie translation information.
*StaticProcessingDataApi* | [**syndicates_get**](docs/StaticProcessingDataApi.md#syndicates_get) | **GET** /syndicates | Get Syndicate translation data.
*StaticProcessingDataApi* | [**tutorials_get**](docs/StaticProcessingDataApi.md#tutorials_get) | **GET** /tutorials | Get Tutorials Data
*StaticProcessingDataApi* | [**upgrade_types_get**](docs/StaticProcessingDataApi.md#upgrade_types_get) | **GET** /upgradeTypes | Get upgrade types data for global upgrades.
*StaticProcessingDataApi* | [**warframes_get**](docs/StaticProcessingDataApi.md#warframes_get) | **GET** /warframes | Get Warframe specs and data, such as polarities defenses, and profile.
*StaticProcessingDataApi* | [**warframes_query_get**](docs/StaticProcessingDataApi.md#warframes_query_get) | **GET** /warframes/{query} | Get Warframe specs and data, such as polarity and defenses, and profile based on the query. Single result
*StaticProcessingDataApi* | [**weapons_get**](docs/StaticProcessingDataApi.md#weapons_get) | **GET** /weapons | Get Weapon data and statistics.
*StaticProcessingDataApi* | [**weapons_query_get**](docs/StaticProcessingDataApi.md#weapons_query_get) | **GET** /weapons/{query} | Get Weapon specs and data, such as polarity based on the query. Single result
*StaticProcessingDataApi* | [**weapons_search_query_get**](docs/StaticProcessingDataApi.md#weapons_search_query_get) | **GET** /weapons/search/{query} | Get Weapon data and statistics based on the query.
*UnstableApi* | [**platform_arbitration_get**](docs/UnstableApi.md#platform_arbitration_get) | **GET** /{platform}/arbitration | [Unstable] Arbitration data
*UnstableApi* | [**platform_kuva_get**](docs/UnstableApi.md#platform_kuva_get) | **GET** /{platform}/kuva | [Unstable] Current Kuva Mission listing
*WorldstateApi* | [**platform_alerts_get**](docs/WorldstateApi.md#platform_alerts_get) | **GET** /{platform}/alerts | Alerts data
*WorldstateApi* | [**platform_arbitration_get**](docs/WorldstateApi.md#platform_arbitration_get) | **GET** /{platform}/arbitration | [Unstable] Arbitration data
*WorldstateApi* | [**platform_cambion_cycle_get**](docs/WorldstateApi.md#platform_cambion_cycle_get) | **GET** /{platform}/cambionCycle | Get Current Cambion Drift Status
*WorldstateApi* | [**platform_cetus_cycle_get**](docs/WorldstateApi.md#platform_cetus_cycle_get) | **GET** /{platform}/cetusCycle | Get Current Cetus Status
*WorldstateApi* | [**platform_conclave_challenges_get**](docs/WorldstateApi.md#platform_conclave_challenges_get) | **GET** /{platform}/conclaveChallenges | Get Conclave Challenge Data
*WorldstateApi* | [**platform_construction_progress_get**](docs/WorldstateApi.md#platform_construction_progress_get) | **GET** /{platform}/constructionProgress | Get Construction Progress for Fomorians and Razorbacks
*WorldstateApi* | [**platform_daily_deals_get**](docs/WorldstateApi.md#platform_daily_deals_get) | **GET** /{platform}/dailyDeals | Daily Deal information from Darvo
*WorldstateApi* | [**platform_dark_sectors_get**](docs/WorldstateApi.md#platform_dark_sectors_get) | **GET** /{platform}/darkSectors | Dark Sector occupation and history
*WorldstateApi* | [**platform_earth_cycle_get**](docs/WorldstateApi.md#platform_earth_cycle_get) | **GET** /{platform}/earthCycle | Get the current Earth rotation information
*WorldstateApi* | [**platform_events_get**](docs/WorldstateApi.md#platform_events_get) | **GET** /{platform}/events | Listing of ongoing events
*WorldstateApi* | [**platform_fissures_get**](docs/WorldstateApi.md#platform_fissures_get) | **GET** /{platform}/fissures | Data on current fissures
*WorldstateApi* | [**platform_flash_sales_get**](docs/WorldstateApi.md#platform_flash_sales_get) | **GET** /{platform}/flashSales | Current Flash Sales from Darvo
*WorldstateApi* | [**platform_get**](docs/WorldstateApi.md#platform_get) | **GET** /{platform} | Get Warframe Worldstate Data for the provided platform
*WorldstateApi* | [**platform_global_upgrades_get**](docs/WorldstateApi.md#platform_global_upgrades_get) | **GET** /{platform}/globalUpgrades | Current Global Upgrades
*WorldstateApi* | [**platform_invasions_get**](docs/WorldstateApi.md#platform_invasions_get) | **GET** /{platform}/invasions | Invasion Data
*WorldstateApi* | [**platform_kuva_get**](docs/WorldstateApi.md#platform_kuva_get) | **GET** /{platform}/kuva | [Unstable] Current Kuva Mission listing
*WorldstateApi* | [**platform_news_get**](docs/WorldstateApi.md#platform_news_get) | **GET** /{platform}/news | Current Listing of News items
*WorldstateApi* | [**platform_nightwave_get**](docs/WorldstateApi.md#platform_nightwave_get) | **GET** /{platform}/nightwave | Get the current Nightwave state.
*WorldstateApi* | [**platform_persistent_enemies_get**](docs/WorldstateApi.md#platform_persistent_enemies_get) | **GET** /{platform}/persistentEnemies | Get Persistent Enemy Data
*WorldstateApi* | [**platform_rivens_get**](docs/WorldstateApi.md#platform_rivens_get) | **GET** /{platform}/rivens | Get Riven statistic data
*WorldstateApi* | [**platform_rivens_search_query_get**](docs/WorldstateApi.md#platform_rivens_search_query_get) | **GET** /{platform}/rivens/search/{query} | Get Riven statistic data
*WorldstateApi* | [**platform_sentient_outposts_get**](docs/WorldstateApi.md#platform_sentient_outposts_get) | **GET** /{platform}/sentientOutposts | Get the current Sentient Outpost, if any
*WorldstateApi* | [**platform_simaris_get**](docs/WorldstateApi.md#platform_simaris_get) | **GET** /{platform}/simaris | Get the current Sanctuary Status
*WorldstateApi* | [**platform_sortie_get**](docs/WorldstateApi.md#platform_sortie_get) | **GET** /{platform}/sortie | Current Sortie Data
*WorldstateApi* | [**platform_steel_path_get**](docs/WorldstateApi.md#platform_steel_path_get) | **GET** /{platform}/steelPath | Current Steel Path Data
*WorldstateApi* | [**platform_syndicate_missions_get**](docs/WorldstateApi.md#platform_syndicate_missions_get) | **GET** /{platform}/syndicateMissions | Listing of Syndicate mission nodes
*WorldstateApi* | [**platform_timestamp_get**](docs/WorldstateApi.md#platform_timestamp_get) | **GET** /{platform}/timestamp | Get the timestamp that the current worldstate was generated at.
*WorldstateApi* | [**platform_vallis_cycle_get**](docs/WorldstateApi.md#platform_vallis_cycle_get) | **GET** /{platform}/vallisCycle | Get the current state of the Orb Vallis
*WorldstateApi* | [**platform_void_trader_get**](docs/WorldstateApi.md#platform_void_trader_get) | **GET** /{platform}/voidTrader | Get the current Void Trader Information


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [Arbitration](docs/Arbitration.md)
 - [Arcane](docs/Arcane.md)
 - [Attack](docs/Attack.md)
 - [AttackFalloff](docs/AttackFalloff.md)
 - [AttackPellet](docs/AttackPellet.md)
 - [CambionCycle](docs/CambionCycle.md)
 - [CetusCycle](docs/CetusCycle.md)
 - [Conclave](docs/Conclave.md)
 - [ConclaveCategories](docs/ConclaveCategories.md)
 - [ConclaveModes](docs/ConclaveModes.md)
 - [ConclaveModesPvpmodeAll](docs/ConclaveModesPvpmodeAll.md)
 - [Construction](docs/Construction.md)
 - [Damage](docs/Damage.md)
 - [DarkSectorHistory](docs/DarkSectorHistory.md)
 - [EarthCycle](docs/EarthCycle.md)
 - [Element](docs/Element.md)
 - [Event](docs/Event.md)
 - [EventInterimSteps](docs/EventInterimSteps.md)
 - [EventMessage](docs/EventMessage.md)
 - [EventNextAlt](docs/EventNextAlt.md)
 - [EventProgressSteps](docs/EventProgressSteps.md)
 - [Faction](docs/Faction.md)
 - [Factions](docs/Factions.md)
 - [Fissure](docs/Fissure.md)
 - [FissureModifiers](docs/FissureModifiers.md)
 - [FissureModifiersVoidT1](docs/FissureModifiersVoidT1.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse200Previous](docs/InlineResponse200Previous.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [Introduced](docs/Introduced.md)
 - [Invasion](docs/Invasion.md)
 - [InvasionAllOf](docs/InvasionAllOf.md)
 - [InvasionFaction](docs/InvasionFaction.md)
 - [Item](docs/Item.md)
 - [ItemsFields](docs/ItemsFields.md)
 - [Kuva](docs/Kuva.md)
 - [Language](docs/Language.md)
 - [Languages](docs/Languages.md)
 - [MeleeWeapon](docs/MeleeWeapon.md)
 - [MeleeWeaponAllOf](docs/MeleeWeaponAllOf.md)
 - [Mission](docs/Mission.md)
 - [MissionTypes](docs/MissionTypes.md)
 - [ModAllOf](docs/ModAllOf.md)
 - [ModAllOfLevelStats](docs/ModAllOfLevelStats.md)
 - [ModelMod](docs/ModelMod.md)
 - [Nightwave](docs/Nightwave.md)
 - [NightwaveChallenge](docs/NightwaveChallenge.md)
 - [OperationTypes](docs/OperationTypes.md)
 - [Patchlog](docs/Patchlog.md)
 - [Platform](docs/Platform.md)
 - [Polarity](docs/Polarity.md)
 - [RangedWeapon](docs/RangedWeapon.md)
 - [RangedWeaponAllOf](docs/RangedWeaponAllOf.md)
 - [Reward](docs/Reward.md)
 - [RewardCountedItems](docs/RewardCountedItems.md)
 - [RewardType](docs/RewardType.md)
 - [Riven](docs/Riven.md)
 - [RivenRivenCompatability](docs/RivenRivenCompatability.md)
 - [RivenStatistic](docs/RivenStatistic.md)
 - [Simaris](docs/Simaris.md)
 - [SimpleReward](docs/SimpleReward.md)
 - [SlamAttack](docs/SlamAttack.md)
 - [SlamAttackRadial](docs/SlamAttackRadial.md)
 - [SolNode](docs/SolNode.md)
 - [SolNodeSolKey](docs/SolNodeSolKey.md)
 - [Sortie](docs/Sortie.md)
 - [SortieAllOf](docs/SortieAllOf.md)
 - [SortieAllOfVariants](docs/SortieAllOfVariants.md)
 - [SortieData](docs/SortieData.md)
 - [SortieDataBosses](docs/SortieDataBosses.md)
 - [SortieDataBossesSortieBossKela](docs/SortieDataBossesSortieBossKela.md)
 - [SortieDataEndStates](docs/SortieDataEndStates.md)
 - [SortieDataModifierTypes](docs/SortieDataModifierTypes.md)
 - [SortieDataRegions](docs/SortieDataRegions.md)
 - [SteelPath](docs/SteelPath.md)
 - [SteelPathAllOf](docs/SteelPathAllOf.md)
 - [Syndicate](docs/Syndicate.md)
 - [SyndicateJob](docs/SyndicateJob.md)
 - [SyndicateMission](docs/SyndicateMission.md)
 - [Syndicates](docs/Syndicates.md)
 - [SyndicatesArbitersSyndicate](docs/SyndicatesArbitersSyndicate.md)
 - [UpgradeTypes](docs/UpgradeTypes.md)
 - [VallisCycle](docs/VallisCycle.md)
 - [VoidTrader](docs/VoidTrader.md)
 - [VoidTraderAllOf](docs/VoidTraderAllOf.md)
 - [VoidTraderAllOfInventory](docs/VoidTraderAllOfInventory.md)
 - [Warframe](docs/Warframe.md)
 - [WarframeAllOf](docs/WarframeAllOf.md)
 - [Weapon](docs/Weapon.md)
 - [WeaponAllOf](docs/WeaponAllOf.md)
 - [WeaponsFields](docs/WeaponsFields.md)
 - [WorldstateObject](docs/WorldstateObject.md)
 - [Ws](docs/Ws.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

tobiah@protonmail.com

