# waPC Guest SDK

![crates.io](https://img.shields.io/crates/v/wapc-guest.svg)
![license](https://img.shields.io/crates/l/wapc-guest.svg)

The `wapc-guest` library is an implementation of the guest-side of the [waPC](https://wapc.io) WebAssembly protocol. `wapc-guest` gives Rust developers the pieces necessary to easily compile WebAssembly modules that you can load in waPC hosts. Each guest module registers function handlers with [`register_function()`]. Each handler should return a [CallResult] (a `Result<Vec<u8>,Box<dyn Error + Sync + Send>>`) with the function's return value.

It's typically used by code generated by the [`wapc`](https://github.com/wapc/cli) CLI.

## Example

```rust
use wapc_guest as wapc;

#[no_mangle]
pub fn wapc_init() {
  wapc::register_function("ping", ping);
}

fn ping(msg: &[u8]) -> wapc::CallResult {
  wapc::console_log(&format!(
    "IN_WASM: Received request for `ping` operation with payload : {}",
    std::str::from_utf8(msg).unwrap()
  ));
  let _res = wapc::host_call("binding", "sample:namespace", "pong", msg)?;
  Ok(msg.to_vec())
}
```

## Building

This crate is meant for projects targeting `wasm32-unknown-unknown` or `wasm32-wasi`.
