# walter

[![Crate](https://img.shields.io/crates/v/walter.svg)](https://crates.io/crates/walter)
[![API](https://docs.rs/walter/badge.svg)](https://docs.rs/walter)

Walter is a simple hooking library.

Walter supports both 32 and 64 bit.

View the [examples] on how to hook.

# Example hook
[wgl_swap_buffers]
```rust,ignore
mod bindings {
    windows::include_bindings!();
}

use std::ffi::c_void;
use walter::{
    TrampolineHook64,
};
use bindings::Windows::Win32::{
    System::{
        SystemServices::DLL_PROCESS_ATTACH,
        LibraryLoader::{
            GetProcAddress,
            GetModuleHandleA,
        },
    },
    Foundation::{
        BOOL,
        HANDLE,
        HINSTANCE,
    },
};
use once_cell::sync::Lazy;
use std::sync::Mutex;

static HOOK: Lazy<Mutex<Option<TrampolineHook64>>> = Lazy::new(|| {
    Mutex::new(None)
});

pub extern "stdcall" fn wgl_swap_buffers(hdc: HANDLE) -> BOOL {
    let gateway = HOOK
        .lock()
        .unwrap()
        .as_ref()
        .unwrap()
        .gateway();

    let gateway_call: extern "stdcall" fn (hdc: HANDLE) -> BOOL;
    gateway_call = unsafe { std::mem::transmute(gateway) };
    gateway_call(hdc);

    BOOL::from(true)
}

#[no_mangle]
pub extern "stdcall" fn DllMain(_module: HINSTANCE, reason: u32, _reserved: *mut c_void) -> BOOL {
    match reason {
        DLL_PROCESS_ATTACH => {
            let module = unsafe { GetModuleHandleA("opengl32.dll") };
            let src_wgl_swap_buffers = unsafe {
                GetProcAddress(module, "wglSwapBuffers")
            }.unwrap();

            let hook = TrampolineHook64::hook(
                src_wgl_swap_buffers as *mut c_void,
                wgl_swap_buffers as *mut c_void,
                20
            ).unwrap();

            *HOOK.lock().unwrap() = Some(hook);
        }
        _ => {}
    }

    BOOL::from(true)
}
```

[wgl_swap_buffers]: ./examples/wgl_swap_buffers
[examples]: ./examples

