pub fn style(string: &str, color: Option<Color>, style: Option<Style>) -> String {
    let color = match color {
        Some(color) => match color {
            Color::Red => "31",
        },
        None => "",
    };

    let color_suffix = match color {
        "" => "",
        _ => ";",
    };

    let style = match style {
        Some(style) => match style {
            Style::Bold => "1",
        },
        None => "",
    };

    return format!("\x1b[{}{}{}m{}\x1b[0m", color, color_suffix, style, string);
}

pub enum Color {
    Red,
}

pub enum Style {
    Bold,
}
