use std::{env, process};
use walnut::utils::{
    print_error,
    stylization::{style, Style},
};

const VERSION: Option<&str> = option_env!("CARGO_PKG_VERSION");

fn main() {
    let mut arguments = env::args().skip(1);

    let first_argument = match arguments.next() {
        Some(argument) => argument,
        None => {
            print_error("this program requires at least one argument to run.");
            process::exit(1)
        }
    };

    match first_argument.as_str() {
        "help" => {
            println!(
                "{} (prints installed version of Walnut)",
                style("=> `walnut version`", None, Some(Style::Bold))
            );
        }
        "version" => match VERSION {
            Some(version) => {
                println!("v{}", version);
            }
            None => {
                println!("unknown version")
            }
        },
        _ => {
            print_error("this command does not exist.");
            process::exit(1)
        }
    }
}
