// SPDX-License-Identifier: Apache-2.0

// DO NOT EDIT.
//
// This file has been generated by the Kotlin project in the `generator`
// directory from a Vulkan API registry.

#![allow(
    non_camel_case_types,
    non_snake_case,
    clippy::missing_safety_doc,
    clippy::too_many_arguments,
    clippy::type_complexity,
    clippy::upper_case_acronyms
)]

use std::fmt;
use std::marker::PhantomData;
use std::ops;
use std::os::raw::{c_char, c_int};

use super::*;

/// A type that can be used interchangeably with another in FFI.
pub unsafe trait Cast {
    /// The other type this type type can be used interchangeably with in FFI.
    type Target;

    /// Converts this value into a value of the other type.
    fn into(self) -> Self::Target;

    /// Converts this reference into a reference to the other type.
    #[inline]
    fn as_ref(&self) -> &Self::Target {
        unsafe { &*(self as *const Self as *const Self::Target) }
    }

    /// Converts this mutable reference into a mutable reference to the other type.
    #[inline]
    fn as_mut(&mut self) -> &mut Self::Target {
        unsafe { &mut *(self as *mut Self as *mut Self::Target) }
    }
}

/// A Vulkan type that has an associated builder.
pub trait HasBuilder<'b> {
    /// The associated builder for this type.
    type Builder: Copy
        + Clone
        + fmt::Debug
        + Default
        + ops::Deref<Target = Self>
        + ops::DerefMut<Target = Self>
        + 'b;

    /// Constructs an instance of the associated builder for this type.
    #[inline]
    fn builder() -> Self::Builder {
        Default::default()
    }
}

unsafe impl Cast for AabbPositionsKHR {
    type Target = AabbPositionsKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AabbPositionsKHR {
    type Builder = AabbPositionsKHRBuilder;
}

/// A builder for a [`AabbPositionsKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AabbPositionsKHRBuilder {
    value: AabbPositionsKHR,
}

impl AabbPositionsKHRBuilder {
    #[inline]
    pub fn min_x(mut self, min_x: f32) -> Self {
        self.value.min_x = min_x;
        self
    }

    #[inline]
    pub fn min_y(mut self, min_y: f32) -> Self {
        self.value.min_y = min_y;
        self
    }

    #[inline]
    pub fn min_z(mut self, min_z: f32) -> Self {
        self.value.min_z = min_z;
        self
    }

    #[inline]
    pub fn max_x(mut self, max_x: f32) -> Self {
        self.value.max_x = max_x;
        self
    }

    #[inline]
    pub fn max_y(mut self, max_y: f32) -> Self {
        self.value.max_y = max_y;
        self
    }

    #[inline]
    pub fn max_z(mut self, max_z: f32) -> Self {
        self.value.max_z = max_z;
        self
    }

    #[inline]
    pub fn build(self) -> AabbPositionsKHR {
        self.value
    }
}

impl ops::Deref for AabbPositionsKHRBuilder {
    type Target = AabbPositionsKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AabbPositionsKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AabbPositionsKHRBuilder {
    type Target = AabbPositionsKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureBuildGeometryInfoKHR {
    type Target = AccelerationStructureBuildGeometryInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureBuildGeometryInfoKHR {
    type Builder = AccelerationStructureBuildGeometryInfoKHRBuilder<'b>;
}

/// A builder for a [`AccelerationStructureBuildGeometryInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureBuildGeometryInfoKHRBuilder<'b> {
    value: AccelerationStructureBuildGeometryInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureBuildGeometryInfoKHRBuilder<'b> {
    #[inline]
    pub fn type_(mut self, type_: AccelerationStructureTypeKHR) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: BuildAccelerationStructureFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn mode(mut self, mode: BuildAccelerationStructureModeKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn src_acceleration_structure(
        mut self,
        src_acceleration_structure: AccelerationStructureKHR,
    ) -> Self {
        self.value.src_acceleration_structure = src_acceleration_structure;
        self
    }

    #[inline]
    pub fn dst_acceleration_structure(
        mut self,
        dst_acceleration_structure: AccelerationStructureKHR,
    ) -> Self {
        self.value.dst_acceleration_structure = dst_acceleration_structure;
        self
    }

    #[inline]
    pub fn geometries(
        mut self,
        geometries: &'b [impl Cast<Target = AccelerationStructureGeometryKHR>],
    ) -> Self {
        self.value.geometry_count = geometries.len() as u32;
        self.value.geometries = geometries.as_ptr().cast();
        self
    }

    #[inline]
    pub fn pointer_geometries(
        mut self,
        pointer_geometries: &'b [*const AccelerationStructureGeometryKHR],
    ) -> Self {
        self.value.geometry_count = pointer_geometries.len() as u32;
        self.value.pointer_geometries = pointer_geometries.as_ptr();
        self
    }

    #[inline]
    pub fn scratch_data(mut self, scratch_data: DeviceOrHostAddressKHR) -> Self {
        self.value.scratch_data = scratch_data;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureBuildGeometryInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureBuildGeometryInfoKHRBuilder<'b> {
    type Target = AccelerationStructureBuildGeometryInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureBuildGeometryInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureBuildGeometryInfoKHRBuilder<'b> {
    type Target = AccelerationStructureBuildGeometryInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureBuildRangeInfoKHR {
    type Target = AccelerationStructureBuildRangeInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureBuildRangeInfoKHR {
    type Builder = AccelerationStructureBuildRangeInfoKHRBuilder;
}

/// A builder for a [`AccelerationStructureBuildRangeInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureBuildRangeInfoKHRBuilder {
    value: AccelerationStructureBuildRangeInfoKHR,
}

impl AccelerationStructureBuildRangeInfoKHRBuilder {
    #[inline]
    pub fn primitive_count(mut self, primitive_count: u32) -> Self {
        self.value.primitive_count = primitive_count;
        self
    }

    #[inline]
    pub fn primitive_offset(mut self, primitive_offset: u32) -> Self {
        self.value.primitive_offset = primitive_offset;
        self
    }

    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.value.first_vertex = first_vertex;
        self
    }

    #[inline]
    pub fn transform_offset(mut self, transform_offset: u32) -> Self {
        self.value.transform_offset = transform_offset;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureBuildRangeInfoKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureBuildRangeInfoKHRBuilder {
    type Target = AccelerationStructureBuildRangeInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureBuildRangeInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureBuildRangeInfoKHRBuilder {
    type Target = AccelerationStructureBuildRangeInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureBuildSizesInfoKHR {
    type Target = AccelerationStructureBuildSizesInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureBuildSizesInfoKHR {
    type Builder = AccelerationStructureBuildSizesInfoKHRBuilder;
}

/// A builder for a [`AccelerationStructureBuildSizesInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureBuildSizesInfoKHRBuilder {
    value: AccelerationStructureBuildSizesInfoKHR,
}

impl AccelerationStructureBuildSizesInfoKHRBuilder {
    #[inline]
    pub fn acceleration_structure_size(mut self, acceleration_structure_size: DeviceSize) -> Self {
        self.value.acceleration_structure_size = acceleration_structure_size;
        self
    }

    #[inline]
    pub fn update_scratch_size(mut self, update_scratch_size: DeviceSize) -> Self {
        self.value.update_scratch_size = update_scratch_size;
        self
    }

    #[inline]
    pub fn build_scratch_size(mut self, build_scratch_size: DeviceSize) -> Self {
        self.value.build_scratch_size = build_scratch_size;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureBuildSizesInfoKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureBuildSizesInfoKHRBuilder {
    type Target = AccelerationStructureBuildSizesInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureBuildSizesInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureBuildSizesInfoKHRBuilder {
    type Target = AccelerationStructureBuildSizesInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`AccelerationStructureCreateInfoKHR`].
pub unsafe trait ExtendsAccelerationStructureCreateInfoKHR: fmt::Debug {}
unsafe impl ExtendsAccelerationStructureCreateInfoKHR for AccelerationStructureMotionInfoNV {}

unsafe impl Cast for AccelerationStructureCreateInfoKHR {
    type Target = AccelerationStructureCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureCreateInfoKHR {
    type Builder = AccelerationStructureCreateInfoKHRBuilder<'b>;
}

/// A builder for a [`AccelerationStructureCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureCreateInfoKHRBuilder<'b> {
    value: AccelerationStructureCreateInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureCreateInfoKHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsAccelerationStructureCreateInfoKHR,
    {
        let next = (next.as_mut() as *mut T).cast::<AccelerationStructureCreateInfoKHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn create_flags(mut self, create_flags: AccelerationStructureCreateFlagsKHR) -> Self {
        self.value.create_flags = create_flags;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn type_(mut self, type_: AccelerationStructureTypeKHR) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn device_address(mut self, device_address: DeviceAddress) -> Self {
        self.value.device_address = device_address;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureCreateInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureCreateInfoKHRBuilder<'b> {
    type Target = AccelerationStructureCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureCreateInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureCreateInfoKHRBuilder<'b> {
    type Target = AccelerationStructureCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureCreateInfoNV {
    type Target = AccelerationStructureCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureCreateInfoNV {
    type Builder = AccelerationStructureCreateInfoNVBuilder<'b>;
}

/// A builder for a [`AccelerationStructureCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureCreateInfoNVBuilder<'b> {
    value: AccelerationStructureCreateInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureCreateInfoNVBuilder<'b> {
    #[inline]
    pub fn compacted_size(mut self, compacted_size: DeviceSize) -> Self {
        self.value.compacted_size = compacted_size;
        self
    }

    #[inline]
    pub fn info(mut self, info: impl Cast<Target = AccelerationStructureInfoNV>) -> Self {
        self.value.info = info.into();
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureCreateInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureCreateInfoNVBuilder<'b> {
    type Target = AccelerationStructureCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureCreateInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureCreateInfoNVBuilder<'b> {
    type Target = AccelerationStructureCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureDeviceAddressInfoKHR {
    type Target = AccelerationStructureDeviceAddressInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureDeviceAddressInfoKHR {
    type Builder = AccelerationStructureDeviceAddressInfoKHRBuilder;
}

/// A builder for a [`AccelerationStructureDeviceAddressInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureDeviceAddressInfoKHRBuilder {
    value: AccelerationStructureDeviceAddressInfoKHR,
}

impl AccelerationStructureDeviceAddressInfoKHRBuilder {
    #[inline]
    pub fn acceleration_structure(
        mut self,
        acceleration_structure: AccelerationStructureKHR,
    ) -> Self {
        self.value.acceleration_structure = acceleration_structure;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureDeviceAddressInfoKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureDeviceAddressInfoKHRBuilder {
    type Target = AccelerationStructureDeviceAddressInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureDeviceAddressInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureDeviceAddressInfoKHRBuilder {
    type Target = AccelerationStructureDeviceAddressInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryAabbsDataKHR {
    type Target = AccelerationStructureGeometryAabbsDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureGeometryAabbsDataKHR {
    type Builder = AccelerationStructureGeometryAabbsDataKHRBuilder;
}

/// A builder for a [`AccelerationStructureGeometryAabbsDataKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureGeometryAabbsDataKHRBuilder {
    value: AccelerationStructureGeometryAabbsDataKHR,
}

impl AccelerationStructureGeometryAabbsDataKHRBuilder {
    #[inline]
    pub fn data(mut self, data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.data = data;
        self
    }

    #[inline]
    pub fn stride(mut self, stride: DeviceSize) -> Self {
        self.value.stride = stride;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureGeometryAabbsDataKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureGeometryAabbsDataKHRBuilder {
    type Target = AccelerationStructureGeometryAabbsDataKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureGeometryAabbsDataKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryAabbsDataKHRBuilder {
    type Target = AccelerationStructureGeometryAabbsDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryInstancesDataKHR {
    type Target = AccelerationStructureGeometryInstancesDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureGeometryInstancesDataKHR {
    type Builder = AccelerationStructureGeometryInstancesDataKHRBuilder;
}

/// A builder for a [`AccelerationStructureGeometryInstancesDataKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureGeometryInstancesDataKHRBuilder {
    value: AccelerationStructureGeometryInstancesDataKHR,
}

impl AccelerationStructureGeometryInstancesDataKHRBuilder {
    #[inline]
    pub fn array_of_pointers(mut self, array_of_pointers: bool) -> Self {
        self.value.array_of_pointers = array_of_pointers as Bool32;
        self
    }

    #[inline]
    pub fn data(mut self, data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.data = data;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureGeometryInstancesDataKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureGeometryInstancesDataKHRBuilder {
    type Target = AccelerationStructureGeometryInstancesDataKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureGeometryInstancesDataKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryInstancesDataKHRBuilder {
    type Target = AccelerationStructureGeometryInstancesDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryKHR {
    type Target = AccelerationStructureGeometryKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureGeometryKHR {
    type Builder = AccelerationStructureGeometryKHRBuilder;
}

/// A builder for a [`AccelerationStructureGeometryKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureGeometryKHRBuilder {
    value: AccelerationStructureGeometryKHR,
}

impl AccelerationStructureGeometryKHRBuilder {
    #[inline]
    pub fn geometry_type(mut self, geometry_type: GeometryTypeKHR) -> Self {
        self.value.geometry_type = geometry_type;
        self
    }

    #[inline]
    pub fn geometry(mut self, geometry: AccelerationStructureGeometryDataKHR) -> Self {
        self.value.geometry = geometry;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: GeometryFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureGeometryKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureGeometryKHRBuilder {
    type Target = AccelerationStructureGeometryKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureGeometryKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryKHRBuilder {
    type Target = AccelerationStructureGeometryKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryMotionTrianglesDataNV {
    type Target = AccelerationStructureGeometryMotionTrianglesDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureGeometryMotionTrianglesDataNV {
    type Builder = AccelerationStructureGeometryMotionTrianglesDataNVBuilder;
}

/// A builder for a [`AccelerationStructureGeometryMotionTrianglesDataNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureGeometryMotionTrianglesDataNVBuilder {
    value: AccelerationStructureGeometryMotionTrianglesDataNV,
}

impl AccelerationStructureGeometryMotionTrianglesDataNVBuilder {
    #[inline]
    pub fn vertex_data(mut self, vertex_data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.vertex_data = vertex_data;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureGeometryMotionTrianglesDataNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureGeometryMotionTrianglesDataNVBuilder {
    type Target = AccelerationStructureGeometryMotionTrianglesDataNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureGeometryMotionTrianglesDataNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureGeometryMotionTrianglesDataNVBuilder {
    type Target = AccelerationStructureGeometryMotionTrianglesDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`AccelerationStructureGeometryTrianglesDataKHR`].
pub unsafe trait ExtendsAccelerationStructureGeometryTrianglesDataKHR: fmt::Debug {}
unsafe impl ExtendsAccelerationStructureGeometryTrianglesDataKHR
    for AccelerationStructureGeometryMotionTrianglesDataNV
{
}

unsafe impl Cast for AccelerationStructureGeometryTrianglesDataKHR {
    type Target = AccelerationStructureGeometryTrianglesDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureGeometryTrianglesDataKHR {
    type Builder = AccelerationStructureGeometryTrianglesDataKHRBuilder<'b>;
}

/// A builder for a [`AccelerationStructureGeometryTrianglesDataKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureGeometryTrianglesDataKHRBuilder<'b> {
    value: AccelerationStructureGeometryTrianglesDataKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureGeometryTrianglesDataKHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsAccelerationStructureGeometryTrianglesDataKHR,
    {
        let next =
            (next.as_mut() as *mut T).cast::<AccelerationStructureGeometryTrianglesDataKHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn vertex_format(mut self, vertex_format: Format) -> Self {
        self.value.vertex_format = vertex_format;
        self
    }

    #[inline]
    pub fn vertex_data(mut self, vertex_data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.vertex_data = vertex_data;
        self
    }

    #[inline]
    pub fn vertex_stride(mut self, vertex_stride: DeviceSize) -> Self {
        self.value.vertex_stride = vertex_stride;
        self
    }

    #[inline]
    pub fn max_vertex(mut self, max_vertex: u32) -> Self {
        self.value.max_vertex = max_vertex;
        self
    }

    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.value.index_type = index_type;
        self
    }

    #[inline]
    pub fn index_data(mut self, index_data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.index_data = index_data;
        self
    }

    #[inline]
    pub fn transform_data(mut self, transform_data: DeviceOrHostAddressConstKHR) -> Self {
        self.value.transform_data = transform_data;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureGeometryTrianglesDataKHR {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureGeometryTrianglesDataKHRBuilder<'b> {
    type Target = AccelerationStructureGeometryTrianglesDataKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureGeometryTrianglesDataKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureGeometryTrianglesDataKHRBuilder<'b> {
    type Target = AccelerationStructureGeometryTrianglesDataKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureInfoNV {
    type Target = AccelerationStructureInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureInfoNV {
    type Builder = AccelerationStructureInfoNVBuilder<'b>;
}

/// A builder for a [`AccelerationStructureInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureInfoNVBuilder<'b> {
    value: AccelerationStructureInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureInfoNVBuilder<'b> {
    #[inline]
    pub fn type_(mut self, type_: AccelerationStructureTypeNV) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: BuildAccelerationStructureFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.value.instance_count = instance_count;
        self
    }

    #[inline]
    pub fn geometries(mut self, geometries: &'b [impl Cast<Target = GeometryNV>]) -> Self {
        self.value.geometry_count = geometries.len() as u32;
        self.value.geometries = geometries.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureInfoNVBuilder<'b> {
    type Target = AccelerationStructureInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureInfoNVBuilder<'b> {
    type Target = AccelerationStructureInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureInstanceKHR {
    type Target = AccelerationStructureInstanceKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureInstanceKHR {
    type Builder = AccelerationStructureInstanceKHRBuilder;
}

/// A builder for a [`AccelerationStructureInstanceKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureInstanceKHRBuilder {
    value: AccelerationStructureInstanceKHR,
}

impl AccelerationStructureInstanceKHRBuilder {
    #[inline]
    pub fn transform(mut self, transform: impl Cast<Target = TransformMatrixKHR>) -> Self {
        self.value.transform = transform.into();
        self
    }

    #[inline]
    pub fn instance_custom_index(mut self, instance_custom_index: u32) -> Self {
        self.value.instance_custom_index = instance_custom_index;
        self
    }

    #[inline]
    pub fn mask(mut self, mask: u32) -> Self {
        self.value.mask = mask;
        self
    }

    #[inline]
    pub fn instance_shader_binding_table_record_offset(
        mut self,
        instance_shader_binding_table_record_offset: u32,
    ) -> Self {
        self.value.instance_shader_binding_table_record_offset =
            instance_shader_binding_table_record_offset;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: GeometryInstanceFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn acceleration_structure_reference(
        mut self,
        acceleration_structure_reference: u64,
    ) -> Self {
        self.value.acceleration_structure_reference = acceleration_structure_reference;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureInstanceKHR {
        self.value
    }
}

impl ops::Deref for AccelerationStructureInstanceKHRBuilder {
    type Target = AccelerationStructureInstanceKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureInstanceKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureInstanceKHRBuilder {
    type Target = AccelerationStructureInstanceKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureMatrixMotionInstanceNV {
    type Target = AccelerationStructureMatrixMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureMatrixMotionInstanceNV {
    type Builder = AccelerationStructureMatrixMotionInstanceNVBuilder;
}

/// A builder for a [`AccelerationStructureMatrixMotionInstanceNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureMatrixMotionInstanceNVBuilder {
    value: AccelerationStructureMatrixMotionInstanceNV,
}

impl AccelerationStructureMatrixMotionInstanceNVBuilder {
    #[inline]
    pub fn transform_t0(mut self, transform_t0: impl Cast<Target = TransformMatrixKHR>) -> Self {
        self.value.transform_t0 = transform_t0.into();
        self
    }

    #[inline]
    pub fn transform_t1(mut self, transform_t1: impl Cast<Target = TransformMatrixKHR>) -> Self {
        self.value.transform_t1 = transform_t1.into();
        self
    }

    #[inline]
    pub fn instance_custom_index(mut self, instance_custom_index: u32) -> Self {
        self.value.instance_custom_index = instance_custom_index;
        self
    }

    #[inline]
    pub fn mask(mut self, mask: u32) -> Self {
        self.value.mask = mask;
        self
    }

    #[inline]
    pub fn instance_shader_binding_table_record_offset(
        mut self,
        instance_shader_binding_table_record_offset: u32,
    ) -> Self {
        self.value.instance_shader_binding_table_record_offset =
            instance_shader_binding_table_record_offset;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: GeometryInstanceFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn acceleration_structure_reference(
        mut self,
        acceleration_structure_reference: u64,
    ) -> Self {
        self.value.acceleration_structure_reference = acceleration_structure_reference;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureMatrixMotionInstanceNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureMatrixMotionInstanceNVBuilder {
    type Target = AccelerationStructureMatrixMotionInstanceNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureMatrixMotionInstanceNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureMatrixMotionInstanceNVBuilder {
    type Target = AccelerationStructureMatrixMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureMemoryRequirementsInfoNV {
    type Target = AccelerationStructureMemoryRequirementsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureMemoryRequirementsInfoNV {
    type Builder = AccelerationStructureMemoryRequirementsInfoNVBuilder;
}

/// A builder for a [`AccelerationStructureMemoryRequirementsInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureMemoryRequirementsInfoNVBuilder {
    value: AccelerationStructureMemoryRequirementsInfoNV,
}

impl AccelerationStructureMemoryRequirementsInfoNVBuilder {
    #[inline]
    pub fn type_(mut self, type_: AccelerationStructureMemoryRequirementsTypeNV) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn acceleration_structure(
        mut self,
        acceleration_structure: AccelerationStructureNV,
    ) -> Self {
        self.value.acceleration_structure = acceleration_structure;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureMemoryRequirementsInfoNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureMemoryRequirementsInfoNVBuilder {
    type Target = AccelerationStructureMemoryRequirementsInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureMemoryRequirementsInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureMemoryRequirementsInfoNVBuilder {
    type Target = AccelerationStructureMemoryRequirementsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureMotionInfoNV {
    type Target = AccelerationStructureMotionInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureMotionInfoNV {
    type Builder = AccelerationStructureMotionInfoNVBuilder;
}

/// A builder for a [`AccelerationStructureMotionInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureMotionInfoNVBuilder {
    value: AccelerationStructureMotionInfoNV,
}

impl AccelerationStructureMotionInfoNVBuilder {
    #[inline]
    pub fn max_instances(mut self, max_instances: u32) -> Self {
        self.value.max_instances = max_instances;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: AccelerationStructureMotionInfoFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureMotionInfoNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureMotionInfoNVBuilder {
    type Target = AccelerationStructureMotionInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureMotionInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureMotionInfoNVBuilder {
    type Target = AccelerationStructureMotionInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureMotionInstanceNV {
    type Target = AccelerationStructureMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureMotionInstanceNV {
    type Builder = AccelerationStructureMotionInstanceNVBuilder;
}

/// A builder for a [`AccelerationStructureMotionInstanceNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureMotionInstanceNVBuilder {
    value: AccelerationStructureMotionInstanceNV,
}

impl AccelerationStructureMotionInstanceNVBuilder {
    #[inline]
    pub fn type_(mut self, type_: AccelerationStructureMotionInstanceTypeNV) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: AccelerationStructureMotionInstanceFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn data(mut self, data: AccelerationStructureMotionInstanceDataNV) -> Self {
        self.value.data = data;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureMotionInstanceNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureMotionInstanceNVBuilder {
    type Target = AccelerationStructureMotionInstanceNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureMotionInstanceNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureMotionInstanceNVBuilder {
    type Target = AccelerationStructureMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureSRTMotionInstanceNV {
    type Target = AccelerationStructureSRTMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AccelerationStructureSRTMotionInstanceNV {
    type Builder = AccelerationStructureSRTMotionInstanceNVBuilder;
}

/// A builder for a [`AccelerationStructureSRTMotionInstanceNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureSRTMotionInstanceNVBuilder {
    value: AccelerationStructureSRTMotionInstanceNV,
}

impl AccelerationStructureSRTMotionInstanceNVBuilder {
    #[inline]
    pub fn transform_t0(mut self, transform_t0: impl Cast<Target = SRTDataNV>) -> Self {
        self.value.transform_t0 = transform_t0.into();
        self
    }

    #[inline]
    pub fn transform_t1(mut self, transform_t1: impl Cast<Target = SRTDataNV>) -> Self {
        self.value.transform_t1 = transform_t1.into();
        self
    }

    #[inline]
    pub fn instance_custom_index(mut self, instance_custom_index: u32) -> Self {
        self.value.instance_custom_index = instance_custom_index;
        self
    }

    #[inline]
    pub fn mask(mut self, mask: u32) -> Self {
        self.value.mask = mask;
        self
    }

    #[inline]
    pub fn instance_shader_binding_table_record_offset(
        mut self,
        instance_shader_binding_table_record_offset: u32,
    ) -> Self {
        self.value.instance_shader_binding_table_record_offset =
            instance_shader_binding_table_record_offset;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: GeometryInstanceFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn acceleration_structure_reference(
        mut self,
        acceleration_structure_reference: u64,
    ) -> Self {
        self.value.acceleration_structure_reference = acceleration_structure_reference;
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureSRTMotionInstanceNV {
        self.value
    }
}

impl ops::Deref for AccelerationStructureSRTMotionInstanceNVBuilder {
    type Target = AccelerationStructureSRTMotionInstanceNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AccelerationStructureSRTMotionInstanceNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AccelerationStructureSRTMotionInstanceNVBuilder {
    type Target = AccelerationStructureSRTMotionInstanceNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AccelerationStructureVersionInfoKHR {
    type Target = AccelerationStructureVersionInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AccelerationStructureVersionInfoKHR {
    type Builder = AccelerationStructureVersionInfoKHRBuilder<'b>;
}

/// A builder for a [`AccelerationStructureVersionInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AccelerationStructureVersionInfoKHRBuilder<'b> {
    value: AccelerationStructureVersionInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AccelerationStructureVersionInfoKHRBuilder<'b> {
    #[inline]
    pub fn version_data(mut self, version_data: &'b [u8]) -> Self {
        self.value.version_data = version_data.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> AccelerationStructureVersionInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for AccelerationStructureVersionInfoKHRBuilder<'b> {
    type Target = AccelerationStructureVersionInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AccelerationStructureVersionInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AccelerationStructureVersionInfoKHRBuilder<'b> {
    type Target = AccelerationStructureVersionInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AcquireNextImageInfoKHR {
    type Target = AcquireNextImageInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AcquireNextImageInfoKHR {
    type Builder = AcquireNextImageInfoKHRBuilder;
}

/// A builder for a [`AcquireNextImageInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AcquireNextImageInfoKHRBuilder {
    value: AcquireNextImageInfoKHR,
}

impl AcquireNextImageInfoKHRBuilder {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.value.swapchain = swapchain;
        self
    }

    #[inline]
    pub fn timeout(mut self, timeout: u64) -> Self {
        self.value.timeout = timeout;
        self
    }

    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.value.semaphore = semaphore;
        self
    }

    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.value.fence = fence;
        self
    }

    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.value.device_mask = device_mask;
        self
    }

    #[inline]
    pub fn build(self) -> AcquireNextImageInfoKHR {
        self.value
    }
}

impl ops::Deref for AcquireNextImageInfoKHRBuilder {
    type Target = AcquireNextImageInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AcquireNextImageInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AcquireNextImageInfoKHRBuilder {
    type Target = AcquireNextImageInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AcquireProfilingLockInfoKHR {
    type Target = AcquireProfilingLockInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AcquireProfilingLockInfoKHR {
    type Builder = AcquireProfilingLockInfoKHRBuilder;
}

/// A builder for a [`AcquireProfilingLockInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AcquireProfilingLockInfoKHRBuilder {
    value: AcquireProfilingLockInfoKHR,
}

impl AcquireProfilingLockInfoKHRBuilder {
    #[inline]
    pub fn flags(mut self, flags: AcquireProfilingLockFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn timeout(mut self, timeout: u64) -> Self {
        self.value.timeout = timeout;
        self
    }

    #[inline]
    pub fn build(self) -> AcquireProfilingLockInfoKHR {
        self.value
    }
}

impl ops::Deref for AcquireProfilingLockInfoKHRBuilder {
    type Target = AcquireProfilingLockInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AcquireProfilingLockInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AcquireProfilingLockInfoKHRBuilder {
    type Target = AcquireProfilingLockInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AllocationCallbacks {
    type Target = AllocationCallbacks;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AllocationCallbacks {
    type Builder = AllocationCallbacksBuilder<'b>;
}

/// A builder for a [`AllocationCallbacks`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AllocationCallbacksBuilder<'b> {
    value: AllocationCallbacks,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AllocationCallbacksBuilder<'b> {
    #[inline]
    pub fn user_data<T>(mut self, user_data: &'b mut T) -> Self {
        self.value.user_data = (user_data as *mut T).cast();
        self
    }

    #[inline]
    pub fn allocation(mut self, allocation: PFN_vkAllocationFunction) -> Self {
        self.value.allocation = allocation;
        self
    }

    #[inline]
    pub fn reallocation(mut self, reallocation: PFN_vkReallocationFunction) -> Self {
        self.value.reallocation = reallocation;
        self
    }

    #[inline]
    pub fn free(mut self, free: PFN_vkFreeFunction) -> Self {
        self.value.free = free;
        self
    }

    #[inline]
    pub fn internal_allocation(
        mut self,
        internal_allocation: PFN_vkInternalAllocationNotification,
    ) -> Self {
        self.value.internal_allocation = internal_allocation;
        self
    }

    #[inline]
    pub fn internal_free(mut self, internal_free: PFN_vkInternalFreeNotification) -> Self {
        self.value.internal_free = internal_free;
        self
    }

    #[inline]
    pub fn build(self) -> AllocationCallbacks {
        self.value
    }
}

impl<'b> ops::Deref for AllocationCallbacksBuilder<'b> {
    type Target = AllocationCallbacks;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AllocationCallbacksBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AllocationCallbacksBuilder<'b> {
    type Target = AllocationCallbacks;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AndroidHardwareBufferFormatPropertiesANDROID {
    type Target = AndroidHardwareBufferFormatPropertiesANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AndroidHardwareBufferFormatPropertiesANDROID {
    type Builder = AndroidHardwareBufferFormatPropertiesANDROIDBuilder;
}

/// A builder for a [`AndroidHardwareBufferFormatPropertiesANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AndroidHardwareBufferFormatPropertiesANDROIDBuilder {
    value: AndroidHardwareBufferFormatPropertiesANDROID,
}

impl AndroidHardwareBufferFormatPropertiesANDROIDBuilder {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn external_format(mut self, external_format: u64) -> Self {
        self.value.external_format = external_format;
        self
    }

    #[inline]
    pub fn format_features(mut self, format_features: FormatFeatureFlags) -> Self {
        self.value.format_features = format_features;
        self
    }

    #[inline]
    pub fn sampler_ycbcr_conversion_components(
        mut self,
        sampler_ycbcr_conversion_components: impl Cast<Target = ComponentMapping>,
    ) -> Self {
        self.value.sampler_ycbcr_conversion_components = sampler_ycbcr_conversion_components.into();
        self
    }

    #[inline]
    pub fn suggested_ycbcr_model(
        mut self,
        suggested_ycbcr_model: SamplerYcbcrModelConversion,
    ) -> Self {
        self.value.suggested_ycbcr_model = suggested_ycbcr_model;
        self
    }

    #[inline]
    pub fn suggested_ycbcr_range(mut self, suggested_ycbcr_range: SamplerYcbcrRange) -> Self {
        self.value.suggested_ycbcr_range = suggested_ycbcr_range;
        self
    }

    #[inline]
    pub fn suggested_x_chroma_offset(mut self, suggested_x_chroma_offset: ChromaLocation) -> Self {
        self.value.suggested_x_chroma_offset = suggested_x_chroma_offset;
        self
    }

    #[inline]
    pub fn suggested_y_chroma_offset(mut self, suggested_y_chroma_offset: ChromaLocation) -> Self {
        self.value.suggested_y_chroma_offset = suggested_y_chroma_offset;
        self
    }

    #[inline]
    pub fn build(self) -> AndroidHardwareBufferFormatPropertiesANDROID {
        self.value
    }
}

impl ops::Deref for AndroidHardwareBufferFormatPropertiesANDROIDBuilder {
    type Target = AndroidHardwareBufferFormatPropertiesANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AndroidHardwareBufferFormatPropertiesANDROIDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AndroidHardwareBufferFormatPropertiesANDROIDBuilder {
    type Target = AndroidHardwareBufferFormatPropertiesANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`AndroidHardwareBufferPropertiesANDROID`].
pub unsafe trait ExtendsAndroidHardwareBufferPropertiesANDROID: fmt::Debug {}
unsafe impl ExtendsAndroidHardwareBufferPropertiesANDROID
    for AndroidHardwareBufferFormatPropertiesANDROID
{
}

unsafe impl Cast for AndroidHardwareBufferPropertiesANDROID {
    type Target = AndroidHardwareBufferPropertiesANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AndroidHardwareBufferPropertiesANDROID {
    type Builder = AndroidHardwareBufferPropertiesANDROIDBuilder<'b>;
}

/// A builder for a [`AndroidHardwareBufferPropertiesANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AndroidHardwareBufferPropertiesANDROIDBuilder<'b> {
    value: AndroidHardwareBufferPropertiesANDROID,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AndroidHardwareBufferPropertiesANDROIDBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsAndroidHardwareBufferPropertiesANDROID,
    {
        let next = (next.as_mut() as *mut T).cast::<AndroidHardwareBufferPropertiesANDROID>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> Self {
        self.value.allocation_size = allocation_size;
        self
    }

    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> AndroidHardwareBufferPropertiesANDROID {
        self.value
    }
}

impl<'b> ops::Deref for AndroidHardwareBufferPropertiesANDROIDBuilder<'b> {
    type Target = AndroidHardwareBufferPropertiesANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AndroidHardwareBufferPropertiesANDROIDBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AndroidHardwareBufferPropertiesANDROIDBuilder<'b> {
    type Target = AndroidHardwareBufferPropertiesANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AndroidHardwareBufferUsageANDROID {
    type Target = AndroidHardwareBufferUsageANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AndroidHardwareBufferUsageANDROID {
    type Builder = AndroidHardwareBufferUsageANDROIDBuilder;
}

/// A builder for a [`AndroidHardwareBufferUsageANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AndroidHardwareBufferUsageANDROIDBuilder {
    value: AndroidHardwareBufferUsageANDROID,
}

impl AndroidHardwareBufferUsageANDROIDBuilder {
    #[inline]
    pub fn android_hardware_buffer_usage(mut self, android_hardware_buffer_usage: u64) -> Self {
        self.value.android_hardware_buffer_usage = android_hardware_buffer_usage;
        self
    }

    #[inline]
    pub fn build(self) -> AndroidHardwareBufferUsageANDROID {
        self.value
    }
}

impl ops::Deref for AndroidHardwareBufferUsageANDROIDBuilder {
    type Target = AndroidHardwareBufferUsageANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AndroidHardwareBufferUsageANDROIDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AndroidHardwareBufferUsageANDROIDBuilder {
    type Target = AndroidHardwareBufferUsageANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AndroidSurfaceCreateInfoKHR {
    type Target = AndroidSurfaceCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AndroidSurfaceCreateInfoKHR {
    type Builder = AndroidSurfaceCreateInfoKHRBuilder<'b>;
}

/// A builder for a [`AndroidSurfaceCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AndroidSurfaceCreateInfoKHRBuilder<'b> {
    value: AndroidSurfaceCreateInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AndroidSurfaceCreateInfoKHRBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: AndroidSurfaceCreateFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn window(mut self, window: *mut ANativeWindow) -> Self {
        self.value.window = window;
        self
    }

    #[inline]
    pub fn build(self) -> AndroidSurfaceCreateInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for AndroidSurfaceCreateInfoKHRBuilder<'b> {
    type Target = AndroidSurfaceCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AndroidSurfaceCreateInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AndroidSurfaceCreateInfoKHRBuilder<'b> {
    type Target = AndroidSurfaceCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ApplicationInfo {
    type Target = ApplicationInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ApplicationInfo {
    type Builder = ApplicationInfoBuilder<'b>;
}

/// A builder for a [`ApplicationInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ApplicationInfoBuilder<'b> {
    value: ApplicationInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ApplicationInfoBuilder<'b> {
    #[inline]
    pub fn application_name(mut self, application_name: &'b [u8]) -> Self {
        self.value.application_name = application_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn application_version(mut self, application_version: u32) -> Self {
        self.value.application_version = application_version;
        self
    }

    #[inline]
    pub fn engine_name(mut self, engine_name: &'b [u8]) -> Self {
        self.value.engine_name = engine_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn engine_version(mut self, engine_version: u32) -> Self {
        self.value.engine_version = engine_version;
        self
    }

    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.value.api_version = api_version;
        self
    }

    #[inline]
    pub fn build(self) -> ApplicationInfo {
        self.value
    }
}

impl<'b> ops::Deref for ApplicationInfoBuilder<'b> {
    type Target = ApplicationInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ApplicationInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ApplicationInfoBuilder<'b> {
    type Target = ApplicationInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AttachmentDescription {
    type Target = AttachmentDescription;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AttachmentDescription {
    type Builder = AttachmentDescriptionBuilder;
}

/// A builder for a [`AttachmentDescription`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentDescriptionBuilder {
    value: AttachmentDescription,
}

impl AttachmentDescriptionBuilder {
    #[inline]
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.value.samples = samples;
        self
    }

    #[inline]
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> Self {
        self.value.load_op = load_op;
        self
    }

    #[inline]
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> Self {
        self.value.store_op = store_op;
        self
    }

    #[inline]
    pub fn stencil_load_op(mut self, stencil_load_op: AttachmentLoadOp) -> Self {
        self.value.stencil_load_op = stencil_load_op;
        self
    }

    #[inline]
    pub fn stencil_store_op(mut self, stencil_store_op: AttachmentStoreOp) -> Self {
        self.value.stencil_store_op = stencil_store_op;
        self
    }

    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.value.initial_layout = initial_layout;
        self
    }

    #[inline]
    pub fn final_layout(mut self, final_layout: ImageLayout) -> Self {
        self.value.final_layout = final_layout;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentDescription {
        self.value
    }
}

impl ops::Deref for AttachmentDescriptionBuilder {
    type Target = AttachmentDescription;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AttachmentDescriptionBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AttachmentDescriptionBuilder {
    type Target = AttachmentDescription;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`AttachmentDescription2`].
pub unsafe trait ExtendsAttachmentDescription2: fmt::Debug {}
unsafe impl ExtendsAttachmentDescription2 for AttachmentDescriptionStencilLayout {}

unsafe impl Cast for AttachmentDescription2 {
    type Target = AttachmentDescription2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AttachmentDescription2 {
    type Builder = AttachmentDescription2Builder<'b>;
}

/// A builder for a [`AttachmentDescription2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentDescription2Builder<'b> {
    value: AttachmentDescription2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AttachmentDescription2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsAttachmentDescription2,
    {
        let next = (next.as_mut() as *mut T).cast::<AttachmentDescription2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.value.samples = samples;
        self
    }

    #[inline]
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> Self {
        self.value.load_op = load_op;
        self
    }

    #[inline]
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> Self {
        self.value.store_op = store_op;
        self
    }

    #[inline]
    pub fn stencil_load_op(mut self, stencil_load_op: AttachmentLoadOp) -> Self {
        self.value.stencil_load_op = stencil_load_op;
        self
    }

    #[inline]
    pub fn stencil_store_op(mut self, stencil_store_op: AttachmentStoreOp) -> Self {
        self.value.stencil_store_op = stencil_store_op;
        self
    }

    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.value.initial_layout = initial_layout;
        self
    }

    #[inline]
    pub fn final_layout(mut self, final_layout: ImageLayout) -> Self {
        self.value.final_layout = final_layout;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentDescription2 {
        self.value
    }
}

impl<'b> ops::Deref for AttachmentDescription2Builder<'b> {
    type Target = AttachmentDescription2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AttachmentDescription2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AttachmentDescription2Builder<'b> {
    type Target = AttachmentDescription2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AttachmentDescriptionStencilLayout {
    type Target = AttachmentDescriptionStencilLayout;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AttachmentDescriptionStencilLayout {
    type Builder = AttachmentDescriptionStencilLayoutBuilder;
}

/// A builder for a [`AttachmentDescriptionStencilLayout`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentDescriptionStencilLayoutBuilder {
    value: AttachmentDescriptionStencilLayout,
}

impl AttachmentDescriptionStencilLayoutBuilder {
    #[inline]
    pub fn stencil_initial_layout(mut self, stencil_initial_layout: ImageLayout) -> Self {
        self.value.stencil_initial_layout = stencil_initial_layout;
        self
    }

    #[inline]
    pub fn stencil_final_layout(mut self, stencil_final_layout: ImageLayout) -> Self {
        self.value.stencil_final_layout = stencil_final_layout;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentDescriptionStencilLayout {
        self.value
    }
}

impl ops::Deref for AttachmentDescriptionStencilLayoutBuilder {
    type Target = AttachmentDescriptionStencilLayout;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AttachmentDescriptionStencilLayoutBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AttachmentDescriptionStencilLayoutBuilder {
    type Target = AttachmentDescriptionStencilLayout;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AttachmentReference {
    type Target = AttachmentReference;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AttachmentReference {
    type Builder = AttachmentReferenceBuilder;
}

/// A builder for a [`AttachmentReference`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentReferenceBuilder {
    value: AttachmentReference,
}

impl AttachmentReferenceBuilder {
    #[inline]
    pub fn attachment(mut self, attachment: u32) -> Self {
        self.value.attachment = attachment;
        self
    }

    #[inline]
    pub fn layout(mut self, layout: ImageLayout) -> Self {
        self.value.layout = layout;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentReference {
        self.value
    }
}

impl ops::Deref for AttachmentReferenceBuilder {
    type Target = AttachmentReference;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AttachmentReferenceBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AttachmentReferenceBuilder {
    type Target = AttachmentReference;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`AttachmentReference2`].
pub unsafe trait ExtendsAttachmentReference2: fmt::Debug {}
unsafe impl ExtendsAttachmentReference2 for AttachmentReferenceStencilLayout {}

unsafe impl Cast for AttachmentReference2 {
    type Target = AttachmentReference2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AttachmentReference2 {
    type Builder = AttachmentReference2Builder<'b>;
}

/// A builder for a [`AttachmentReference2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentReference2Builder<'b> {
    value: AttachmentReference2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AttachmentReference2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsAttachmentReference2,
    {
        let next = (next.as_mut() as *mut T).cast::<AttachmentReference2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn attachment(mut self, attachment: u32) -> Self {
        self.value.attachment = attachment;
        self
    }

    #[inline]
    pub fn layout(mut self, layout: ImageLayout) -> Self {
        self.value.layout = layout;
        self
    }

    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentReference2 {
        self.value
    }
}

impl<'b> ops::Deref for AttachmentReference2Builder<'b> {
    type Target = AttachmentReference2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AttachmentReference2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AttachmentReference2Builder<'b> {
    type Target = AttachmentReference2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AttachmentReferenceStencilLayout {
    type Target = AttachmentReferenceStencilLayout;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for AttachmentReferenceStencilLayout {
    type Builder = AttachmentReferenceStencilLayoutBuilder;
}

/// A builder for a [`AttachmentReferenceStencilLayout`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentReferenceStencilLayoutBuilder {
    value: AttachmentReferenceStencilLayout,
}

impl AttachmentReferenceStencilLayoutBuilder {
    #[inline]
    pub fn stencil_layout(mut self, stencil_layout: ImageLayout) -> Self {
        self.value.stencil_layout = stencil_layout;
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentReferenceStencilLayout {
        self.value
    }
}

impl ops::Deref for AttachmentReferenceStencilLayoutBuilder {
    type Target = AttachmentReferenceStencilLayout;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for AttachmentReferenceStencilLayoutBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for AttachmentReferenceStencilLayoutBuilder {
    type Target = AttachmentReferenceStencilLayout;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for AttachmentSampleLocationsEXT {
    type Target = AttachmentSampleLocationsEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for AttachmentSampleLocationsEXT {
    type Builder = AttachmentSampleLocationsEXTBuilder<'b>;
}

/// A builder for a [`AttachmentSampleLocationsEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct AttachmentSampleLocationsEXTBuilder<'b> {
    value: AttachmentSampleLocationsEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> AttachmentSampleLocationsEXTBuilder<'b> {
    #[inline]
    pub fn attachment_index(mut self, attachment_index: u32) -> Self {
        self.value.attachment_index = attachment_index;
        self
    }

    #[inline]
    pub fn sample_locations_info(
        mut self,
        sample_locations_info: impl Cast<Target = SampleLocationsInfoEXT>,
    ) -> Self {
        self.value.sample_locations_info = sample_locations_info.into();
        self
    }

    #[inline]
    pub fn build(self) -> AttachmentSampleLocationsEXT {
        self.value
    }
}

impl<'b> ops::Deref for AttachmentSampleLocationsEXTBuilder<'b> {
    type Target = AttachmentSampleLocationsEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for AttachmentSampleLocationsEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for AttachmentSampleLocationsEXTBuilder<'b> {
    type Target = AttachmentSampleLocationsEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BaseInStructure {
    type Target = BaseInStructure;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BaseInStructure {
    type Builder = BaseInStructureBuilder;
}

/// A builder for a [`BaseInStructure`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BaseInStructureBuilder {
    value: BaseInStructure,
}

impl BaseInStructureBuilder {
    #[inline]
    pub fn s_type(mut self, s_type: StructureType) -> Self {
        self.value.s_type = s_type;
        self
    }

    #[inline]
    pub fn build(self) -> BaseInStructure {
        self.value
    }
}

impl ops::Deref for BaseInStructureBuilder {
    type Target = BaseInStructure;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BaseInStructureBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BaseInStructureBuilder {
    type Target = BaseInStructure;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BaseOutStructure {
    type Target = BaseOutStructure;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BaseOutStructure {
    type Builder = BaseOutStructureBuilder;
}

/// A builder for a [`BaseOutStructure`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BaseOutStructureBuilder {
    value: BaseOutStructure,
}

impl BaseOutStructureBuilder {
    #[inline]
    pub fn s_type(mut self, s_type: StructureType) -> Self {
        self.value.s_type = s_type;
        self
    }

    #[inline]
    pub fn build(self) -> BaseOutStructure {
        self.value
    }
}

impl ops::Deref for BaseOutStructureBuilder {
    type Target = BaseOutStructure;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BaseOutStructureBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BaseOutStructureBuilder {
    type Target = BaseOutStructure;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindAccelerationStructureMemoryInfoNV {
    type Target = BindAccelerationStructureMemoryInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindAccelerationStructureMemoryInfoNV {
    type Builder = BindAccelerationStructureMemoryInfoNVBuilder<'b>;
}

/// A builder for a [`BindAccelerationStructureMemoryInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindAccelerationStructureMemoryInfoNVBuilder<'b> {
    value: BindAccelerationStructureMemoryInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindAccelerationStructureMemoryInfoNVBuilder<'b> {
    #[inline]
    pub fn acceleration_structure(
        mut self,
        acceleration_structure: AccelerationStructureNV,
    ) -> Self {
        self.value.acceleration_structure = acceleration_structure;
        self
    }

    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.value.memory_offset = memory_offset;
        self
    }

    #[inline]
    pub fn device_indices(mut self, device_indices: &'b [u32]) -> Self {
        self.value.device_index_count = device_indices.len() as u32;
        self.value.device_indices = device_indices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> BindAccelerationStructureMemoryInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for BindAccelerationStructureMemoryInfoNVBuilder<'b> {
    type Target = BindAccelerationStructureMemoryInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindAccelerationStructureMemoryInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindAccelerationStructureMemoryInfoNVBuilder<'b> {
    type Target = BindAccelerationStructureMemoryInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindBufferMemoryDeviceGroupInfo {
    type Target = BindBufferMemoryDeviceGroupInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindBufferMemoryDeviceGroupInfo {
    type Builder = BindBufferMemoryDeviceGroupInfoBuilder<'b>;
}

/// A builder for a [`BindBufferMemoryDeviceGroupInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindBufferMemoryDeviceGroupInfoBuilder<'b> {
    value: BindBufferMemoryDeviceGroupInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindBufferMemoryDeviceGroupInfoBuilder<'b> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'b [u32]) -> Self {
        self.value.device_index_count = device_indices.len() as u32;
        self.value.device_indices = device_indices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> BindBufferMemoryDeviceGroupInfo {
        self.value
    }
}

impl<'b> ops::Deref for BindBufferMemoryDeviceGroupInfoBuilder<'b> {
    type Target = BindBufferMemoryDeviceGroupInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindBufferMemoryDeviceGroupInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindBufferMemoryDeviceGroupInfoBuilder<'b> {
    type Target = BindBufferMemoryDeviceGroupInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`BindBufferMemoryInfo`].
pub unsafe trait ExtendsBindBufferMemoryInfo: fmt::Debug {}
unsafe impl ExtendsBindBufferMemoryInfo for BindBufferMemoryDeviceGroupInfo {}

unsafe impl Cast for BindBufferMemoryInfo {
    type Target = BindBufferMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindBufferMemoryInfo {
    type Builder = BindBufferMemoryInfoBuilder<'b>;
}

/// A builder for a [`BindBufferMemoryInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindBufferMemoryInfoBuilder<'b> {
    value: BindBufferMemoryInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindBufferMemoryInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsBindBufferMemoryInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<BindBufferMemoryInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.value.memory_offset = memory_offset;
        self
    }

    #[inline]
    pub fn build(self) -> BindBufferMemoryInfo {
        self.value
    }
}

impl<'b> ops::Deref for BindBufferMemoryInfoBuilder<'b> {
    type Target = BindBufferMemoryInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindBufferMemoryInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindBufferMemoryInfoBuilder<'b> {
    type Target = BindBufferMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindImageMemoryDeviceGroupInfo {
    type Target = BindImageMemoryDeviceGroupInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindImageMemoryDeviceGroupInfo {
    type Builder = BindImageMemoryDeviceGroupInfoBuilder<'b>;
}

/// A builder for a [`BindImageMemoryDeviceGroupInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindImageMemoryDeviceGroupInfoBuilder<'b> {
    value: BindImageMemoryDeviceGroupInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindImageMemoryDeviceGroupInfoBuilder<'b> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'b [u32]) -> Self {
        self.value.device_index_count = device_indices.len() as u32;
        self.value.device_indices = device_indices.as_ptr();
        self
    }

    #[inline]
    pub fn split_instance_bind_regions(
        mut self,
        split_instance_bind_regions: &'b [impl Cast<Target = Rect2D>],
    ) -> Self {
        self.value.split_instance_bind_region_count = split_instance_bind_regions.len() as u32;
        self.value.split_instance_bind_regions = split_instance_bind_regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> BindImageMemoryDeviceGroupInfo {
        self.value
    }
}

impl<'b> ops::Deref for BindImageMemoryDeviceGroupInfoBuilder<'b> {
    type Target = BindImageMemoryDeviceGroupInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindImageMemoryDeviceGroupInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindImageMemoryDeviceGroupInfoBuilder<'b> {
    type Target = BindImageMemoryDeviceGroupInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`BindImageMemoryInfo`].
pub unsafe trait ExtendsBindImageMemoryInfo: fmt::Debug {}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemoryDeviceGroupInfo {}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemorySwapchainInfoKHR {}
unsafe impl ExtendsBindImageMemoryInfo for BindImagePlaneMemoryInfo {}

unsafe impl Cast for BindImageMemoryInfo {
    type Target = BindImageMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindImageMemoryInfo {
    type Builder = BindImageMemoryInfoBuilder<'b>;
}

/// A builder for a [`BindImageMemoryInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindImageMemoryInfoBuilder<'b> {
    value: BindImageMemoryInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindImageMemoryInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsBindImageMemoryInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<BindImageMemoryInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.value.memory_offset = memory_offset;
        self
    }

    #[inline]
    pub fn build(self) -> BindImageMemoryInfo {
        self.value
    }
}

impl<'b> ops::Deref for BindImageMemoryInfoBuilder<'b> {
    type Target = BindImageMemoryInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindImageMemoryInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindImageMemoryInfoBuilder<'b> {
    type Target = BindImageMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindImageMemorySwapchainInfoKHR {
    type Target = BindImageMemorySwapchainInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BindImageMemorySwapchainInfoKHR {
    type Builder = BindImageMemorySwapchainInfoKHRBuilder;
}

/// A builder for a [`BindImageMemorySwapchainInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindImageMemorySwapchainInfoKHRBuilder {
    value: BindImageMemorySwapchainInfoKHR,
}

impl BindImageMemorySwapchainInfoKHRBuilder {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.value.swapchain = swapchain;
        self
    }

    #[inline]
    pub fn image_index(mut self, image_index: u32) -> Self {
        self.value.image_index = image_index;
        self
    }

    #[inline]
    pub fn build(self) -> BindImageMemorySwapchainInfoKHR {
        self.value
    }
}

impl ops::Deref for BindImageMemorySwapchainInfoKHRBuilder {
    type Target = BindImageMemorySwapchainInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BindImageMemorySwapchainInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BindImageMemorySwapchainInfoKHRBuilder {
    type Target = BindImageMemorySwapchainInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindImagePlaneMemoryInfo {
    type Target = BindImagePlaneMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BindImagePlaneMemoryInfo {
    type Builder = BindImagePlaneMemoryInfoBuilder;
}

/// A builder for a [`BindImagePlaneMemoryInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindImagePlaneMemoryInfoBuilder {
    value: BindImagePlaneMemoryInfo,
}

impl BindImagePlaneMemoryInfoBuilder {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.value.plane_aspect = plane_aspect;
        self
    }

    #[inline]
    pub fn build(self) -> BindImagePlaneMemoryInfo {
        self.value
    }
}

impl ops::Deref for BindImagePlaneMemoryInfoBuilder {
    type Target = BindImagePlaneMemoryInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BindImagePlaneMemoryInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BindImagePlaneMemoryInfoBuilder {
    type Target = BindImagePlaneMemoryInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindIndexBufferIndirectCommandNV {
    type Target = BindIndexBufferIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BindIndexBufferIndirectCommandNV {
    type Builder = BindIndexBufferIndirectCommandNVBuilder;
}

/// A builder for a [`BindIndexBufferIndirectCommandNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindIndexBufferIndirectCommandNVBuilder {
    value: BindIndexBufferIndirectCommandNV,
}

impl BindIndexBufferIndirectCommandNVBuilder {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.value.buffer_address = buffer_address;
        self
    }

    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.value.index_type = index_type;
        self
    }

    #[inline]
    pub fn build(self) -> BindIndexBufferIndirectCommandNV {
        self.value
    }
}

impl ops::Deref for BindIndexBufferIndirectCommandNVBuilder {
    type Target = BindIndexBufferIndirectCommandNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BindIndexBufferIndirectCommandNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BindIndexBufferIndirectCommandNVBuilder {
    type Target = BindIndexBufferIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindShaderGroupIndirectCommandNV {
    type Target = BindShaderGroupIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BindShaderGroupIndirectCommandNV {
    type Builder = BindShaderGroupIndirectCommandNVBuilder;
}

/// A builder for a [`BindShaderGroupIndirectCommandNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindShaderGroupIndirectCommandNVBuilder {
    value: BindShaderGroupIndirectCommandNV,
}

impl BindShaderGroupIndirectCommandNVBuilder {
    #[inline]
    pub fn group_index(mut self, group_index: u32) -> Self {
        self.value.group_index = group_index;
        self
    }

    #[inline]
    pub fn build(self) -> BindShaderGroupIndirectCommandNV {
        self.value
    }
}

impl ops::Deref for BindShaderGroupIndirectCommandNVBuilder {
    type Target = BindShaderGroupIndirectCommandNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BindShaderGroupIndirectCommandNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BindShaderGroupIndirectCommandNVBuilder {
    type Target = BindShaderGroupIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`BindSparseInfo`].
pub unsafe trait ExtendsBindSparseInfo: fmt::Debug {}
unsafe impl ExtendsBindSparseInfo for DeviceGroupBindSparseInfo {}
unsafe impl ExtendsBindSparseInfo for TimelineSemaphoreSubmitInfo {}

unsafe impl Cast for BindSparseInfo {
    type Target = BindSparseInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BindSparseInfo {
    type Builder = BindSparseInfoBuilder<'b>;
}

/// A builder for a [`BindSparseInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindSparseInfoBuilder<'b> {
    value: BindSparseInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BindSparseInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsBindSparseInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<BindSparseInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'b [Semaphore]) -> Self {
        self.value.wait_semaphore_count = wait_semaphores.len() as u32;
        self.value.wait_semaphores = wait_semaphores.as_ptr();
        self
    }

    #[inline]
    pub fn buffer_binds(
        mut self,
        buffer_binds: &'b [impl Cast<Target = SparseBufferMemoryBindInfo>],
    ) -> Self {
        self.value.buffer_bind_count = buffer_binds.len() as u32;
        self.value.buffer_binds = buffer_binds.as_ptr().cast();
        self
    }

    #[inline]
    pub fn image_opaque_binds(
        mut self,
        image_opaque_binds: &'b [impl Cast<Target = SparseImageOpaqueMemoryBindInfo>],
    ) -> Self {
        self.value.image_opaque_bind_count = image_opaque_binds.len() as u32;
        self.value.image_opaque_binds = image_opaque_binds.as_ptr().cast();
        self
    }

    #[inline]
    pub fn image_binds(
        mut self,
        image_binds: &'b [impl Cast<Target = SparseImageMemoryBindInfo>],
    ) -> Self {
        self.value.image_bind_count = image_binds.len() as u32;
        self.value.image_binds = image_binds.as_ptr().cast();
        self
    }

    #[inline]
    pub fn signal_semaphores(mut self, signal_semaphores: &'b [Semaphore]) -> Self {
        self.value.signal_semaphore_count = signal_semaphores.len() as u32;
        self.value.signal_semaphores = signal_semaphores.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> BindSparseInfo {
        self.value
    }
}

impl<'b> ops::Deref for BindSparseInfoBuilder<'b> {
    type Target = BindSparseInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BindSparseInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BindSparseInfoBuilder<'b> {
    type Target = BindSparseInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BindVertexBufferIndirectCommandNV {
    type Target = BindVertexBufferIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BindVertexBufferIndirectCommandNV {
    type Builder = BindVertexBufferIndirectCommandNVBuilder;
}

/// A builder for a [`BindVertexBufferIndirectCommandNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BindVertexBufferIndirectCommandNVBuilder {
    value: BindVertexBufferIndirectCommandNV,
}

impl BindVertexBufferIndirectCommandNVBuilder {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.value.buffer_address = buffer_address;
        self
    }

    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.value.stride = stride;
        self
    }

    #[inline]
    pub fn build(self) -> BindVertexBufferIndirectCommandNV {
        self.value
    }
}

impl ops::Deref for BindVertexBufferIndirectCommandNVBuilder {
    type Target = BindVertexBufferIndirectCommandNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BindVertexBufferIndirectCommandNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BindVertexBufferIndirectCommandNVBuilder {
    type Target = BindVertexBufferIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BlitImageInfo2KHR {
    type Target = BlitImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BlitImageInfo2KHR {
    type Builder = BlitImageInfo2KHRBuilder<'b>;
}

/// A builder for a [`BlitImageInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BlitImageInfo2KHRBuilder<'b> {
    value: BlitImageInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BlitImageInfo2KHRBuilder<'b> {
    #[inline]
    pub fn src_image(mut self, src_image: Image) -> Self {
        self.value.src_image = src_image;
        self
    }

    #[inline]
    pub fn src_image_layout(mut self, src_image_layout: ImageLayout) -> Self {
        self.value.src_image_layout = src_image_layout;
        self
    }

    #[inline]
    pub fn dst_image(mut self, dst_image: Image) -> Self {
        self.value.dst_image = dst_image;
        self
    }

    #[inline]
    pub fn dst_image_layout(mut self, dst_image_layout: ImageLayout) -> Self {
        self.value.dst_image_layout = dst_image_layout;
        self
    }

    #[inline]
    pub fn regions(mut self, regions: &'b [impl Cast<Target = ImageBlit2KHR>]) -> Self {
        self.value.region_count = regions.len() as u32;
        self.value.regions = regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn filter(mut self, filter: Filter) -> Self {
        self.value.filter = filter;
        self
    }

    #[inline]
    pub fn build(self) -> BlitImageInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for BlitImageInfo2KHRBuilder<'b> {
    type Target = BlitImageInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BlitImageInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BlitImageInfo2KHRBuilder<'b> {
    type Target = BlitImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferCopy {
    type Target = BufferCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferCopy {
    type Builder = BufferCopyBuilder;
}

/// A builder for a [`BufferCopy`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferCopyBuilder {
    value: BufferCopy,
}

impl BufferCopyBuilder {
    #[inline]
    pub fn src_offset(mut self, src_offset: DeviceSize) -> Self {
        self.value.src_offset = src_offset;
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: DeviceSize) -> Self {
        self.value.dst_offset = dst_offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> BufferCopy {
        self.value
    }
}

impl ops::Deref for BufferCopyBuilder {
    type Target = BufferCopy;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferCopyBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferCopyBuilder {
    type Target = BufferCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferCopy2KHR {
    type Target = BufferCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferCopy2KHR {
    type Builder = BufferCopy2KHRBuilder;
}

/// A builder for a [`BufferCopy2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferCopy2KHRBuilder {
    value: BufferCopy2KHR,
}

impl BufferCopy2KHRBuilder {
    #[inline]
    pub fn src_offset(mut self, src_offset: DeviceSize) -> Self {
        self.value.src_offset = src_offset;
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: DeviceSize) -> Self {
        self.value.dst_offset = dst_offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> BufferCopy2KHR {
        self.value
    }
}

impl ops::Deref for BufferCopy2KHRBuilder {
    type Target = BufferCopy2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferCopy2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferCopy2KHRBuilder {
    type Target = BufferCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`BufferCreateInfo`].
pub unsafe trait ExtendsBufferCreateInfo: fmt::Debug {}
unsafe impl ExtendsBufferCreateInfo for BufferDeviceAddressCreateInfoEXT {}
unsafe impl ExtendsBufferCreateInfo for BufferOpaqueCaptureAddressCreateInfo {}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNV {}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfo {}

unsafe impl Cast for BufferCreateInfo {
    type Target = BufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BufferCreateInfo {
    type Builder = BufferCreateInfoBuilder<'b>;
}

/// A builder for a [`BufferCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferCreateInfoBuilder<'b> {
    value: BufferCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BufferCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsBufferCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<BufferCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.value.sharing_mode = sharing_mode;
        self
    }

    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'b [u32]) -> Self {
        self.value.queue_family_index_count = queue_family_indices.len() as u32;
        self.value.queue_family_indices = queue_family_indices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> BufferCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for BufferCreateInfoBuilder<'b> {
    type Target = BufferCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BufferCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BufferCreateInfoBuilder<'b> {
    type Target = BufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferDeviceAddressCreateInfoEXT {
    type Target = BufferDeviceAddressCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferDeviceAddressCreateInfoEXT {
    type Builder = BufferDeviceAddressCreateInfoEXTBuilder;
}

/// A builder for a [`BufferDeviceAddressCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferDeviceAddressCreateInfoEXTBuilder {
    value: BufferDeviceAddressCreateInfoEXT,
}

impl BufferDeviceAddressCreateInfoEXTBuilder {
    #[inline]
    pub fn device_address(mut self, device_address: DeviceAddress) -> Self {
        self.value.device_address = device_address;
        self
    }

    #[inline]
    pub fn build(self) -> BufferDeviceAddressCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for BufferDeviceAddressCreateInfoEXTBuilder {
    type Target = BufferDeviceAddressCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferDeviceAddressCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferDeviceAddressCreateInfoEXTBuilder {
    type Target = BufferDeviceAddressCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferDeviceAddressInfo {
    type Target = BufferDeviceAddressInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferDeviceAddressInfo {
    type Builder = BufferDeviceAddressInfoBuilder;
}

/// A builder for a [`BufferDeviceAddressInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferDeviceAddressInfoBuilder {
    value: BufferDeviceAddressInfo,
}

impl BufferDeviceAddressInfoBuilder {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn build(self) -> BufferDeviceAddressInfo {
        self.value
    }
}

impl ops::Deref for BufferDeviceAddressInfoBuilder {
    type Target = BufferDeviceAddressInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferDeviceAddressInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferDeviceAddressInfoBuilder {
    type Target = BufferDeviceAddressInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferImageCopy {
    type Target = BufferImageCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferImageCopy {
    type Builder = BufferImageCopyBuilder;
}

/// A builder for a [`BufferImageCopy`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferImageCopyBuilder {
    value: BufferImageCopy,
}

impl BufferImageCopyBuilder {
    #[inline]
    pub fn buffer_offset(mut self, buffer_offset: DeviceSize) -> Self {
        self.value.buffer_offset = buffer_offset;
        self
    }

    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.value.buffer_row_length = buffer_row_length;
        self
    }

    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.value.buffer_image_height = buffer_image_height;
        self
    }

    #[inline]
    pub fn image_subresource(
        mut self,
        image_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.image_subresource = image_subresource.into();
        self
    }

    #[inline]
    pub fn image_offset(mut self, image_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.image_offset = image_offset.into();
        self
    }

    #[inline]
    pub fn image_extent(mut self, image_extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.image_extent = image_extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> BufferImageCopy {
        self.value
    }
}

impl ops::Deref for BufferImageCopyBuilder {
    type Target = BufferImageCopy;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferImageCopyBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferImageCopyBuilder {
    type Target = BufferImageCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`BufferImageCopy2KHR`].
pub unsafe trait ExtendsBufferImageCopy2KHR: fmt::Debug {}
unsafe impl ExtendsBufferImageCopy2KHR for CopyCommandTransformInfoQCOM {}

unsafe impl Cast for BufferImageCopy2KHR {
    type Target = BufferImageCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for BufferImageCopy2KHR {
    type Builder = BufferImageCopy2KHRBuilder<'b>;
}

/// A builder for a [`BufferImageCopy2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferImageCopy2KHRBuilder<'b> {
    value: BufferImageCopy2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> BufferImageCopy2KHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsBufferImageCopy2KHR,
    {
        let next = (next.as_mut() as *mut T).cast::<BufferImageCopy2KHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn buffer_offset(mut self, buffer_offset: DeviceSize) -> Self {
        self.value.buffer_offset = buffer_offset;
        self
    }

    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.value.buffer_row_length = buffer_row_length;
        self
    }

    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.value.buffer_image_height = buffer_image_height;
        self
    }

    #[inline]
    pub fn image_subresource(
        mut self,
        image_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.image_subresource = image_subresource.into();
        self
    }

    #[inline]
    pub fn image_offset(mut self, image_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.image_offset = image_offset.into();
        self
    }

    #[inline]
    pub fn image_extent(mut self, image_extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.image_extent = image_extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> BufferImageCopy2KHR {
        self.value
    }
}

impl<'b> ops::Deref for BufferImageCopy2KHRBuilder<'b> {
    type Target = BufferImageCopy2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for BufferImageCopy2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for BufferImageCopy2KHRBuilder<'b> {
    type Target = BufferImageCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferMemoryBarrier {
    type Target = BufferMemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferMemoryBarrier {
    type Builder = BufferMemoryBarrierBuilder;
}

/// A builder for a [`BufferMemoryBarrier`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferMemoryBarrierBuilder {
    value: BufferMemoryBarrier,
}

impl BufferMemoryBarrierBuilder {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.value.src_queue_family_index = src_queue_family_index;
        self
    }

    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.value.dst_queue_family_index = dst_queue_family_index;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> BufferMemoryBarrier {
        self.value
    }
}

impl ops::Deref for BufferMemoryBarrierBuilder {
    type Target = BufferMemoryBarrier;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferMemoryBarrierBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferMemoryBarrierBuilder {
    type Target = BufferMemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferMemoryBarrier2KHR {
    type Target = BufferMemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferMemoryBarrier2KHR {
    type Builder = BufferMemoryBarrier2KHRBuilder;
}

/// A builder for a [`BufferMemoryBarrier2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferMemoryBarrier2KHRBuilder {
    value: BufferMemoryBarrier2KHR,
}

impl BufferMemoryBarrier2KHRBuilder {
    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.src_stage_mask = src_stage_mask;
        self
    }

    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags2KHR) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.dst_stage_mask = dst_stage_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags2KHR) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.value.src_queue_family_index = src_queue_family_index;
        self
    }

    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.value.dst_queue_family_index = dst_queue_family_index;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> BufferMemoryBarrier2KHR {
        self.value
    }
}

impl ops::Deref for BufferMemoryBarrier2KHRBuilder {
    type Target = BufferMemoryBarrier2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferMemoryBarrier2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferMemoryBarrier2KHRBuilder {
    type Target = BufferMemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferMemoryRequirementsInfo2 {
    type Target = BufferMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferMemoryRequirementsInfo2 {
    type Builder = BufferMemoryRequirementsInfo2Builder;
}

/// A builder for a [`BufferMemoryRequirementsInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferMemoryRequirementsInfo2Builder {
    value: BufferMemoryRequirementsInfo2,
}

impl BufferMemoryRequirementsInfo2Builder {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn build(self) -> BufferMemoryRequirementsInfo2 {
        self.value
    }
}

impl ops::Deref for BufferMemoryRequirementsInfo2Builder {
    type Target = BufferMemoryRequirementsInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferMemoryRequirementsInfo2Builder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferMemoryRequirementsInfo2Builder {
    type Target = BufferMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferOpaqueCaptureAddressCreateInfo {
    type Target = BufferOpaqueCaptureAddressCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferOpaqueCaptureAddressCreateInfo {
    type Builder = BufferOpaqueCaptureAddressCreateInfoBuilder;
}

/// A builder for a [`BufferOpaqueCaptureAddressCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferOpaqueCaptureAddressCreateInfoBuilder {
    value: BufferOpaqueCaptureAddressCreateInfo,
}

impl BufferOpaqueCaptureAddressCreateInfoBuilder {
    #[inline]
    pub fn opaque_capture_address(mut self, opaque_capture_address: u64) -> Self {
        self.value.opaque_capture_address = opaque_capture_address;
        self
    }

    #[inline]
    pub fn build(self) -> BufferOpaqueCaptureAddressCreateInfo {
        self.value
    }
}

impl ops::Deref for BufferOpaqueCaptureAddressCreateInfoBuilder {
    type Target = BufferOpaqueCaptureAddressCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferOpaqueCaptureAddressCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferOpaqueCaptureAddressCreateInfoBuilder {
    type Target = BufferOpaqueCaptureAddressCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for BufferViewCreateInfo {
    type Target = BufferViewCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for BufferViewCreateInfo {
    type Builder = BufferViewCreateInfoBuilder;
}

/// A builder for a [`BufferViewCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct BufferViewCreateInfoBuilder {
    value: BufferViewCreateInfo,
}

impl BufferViewCreateInfoBuilder {
    #[inline]
    pub fn flags(mut self, flags: BufferViewCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.value.range = range;
        self
    }

    #[inline]
    pub fn build(self) -> BufferViewCreateInfo {
        self.value
    }
}

impl ops::Deref for BufferViewCreateInfoBuilder {
    type Target = BufferViewCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for BufferViewCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for BufferViewCreateInfoBuilder {
    type Target = BufferViewCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CalibratedTimestampInfoEXT {
    type Target = CalibratedTimestampInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CalibratedTimestampInfoEXT {
    type Builder = CalibratedTimestampInfoEXTBuilder;
}

/// A builder for a [`CalibratedTimestampInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CalibratedTimestampInfoEXTBuilder {
    value: CalibratedTimestampInfoEXT,
}

impl CalibratedTimestampInfoEXTBuilder {
    #[inline]
    pub fn time_domain(mut self, time_domain: TimeDomainEXT) -> Self {
        self.value.time_domain = time_domain;
        self
    }

    #[inline]
    pub fn build(self) -> CalibratedTimestampInfoEXT {
        self.value
    }
}

impl ops::Deref for CalibratedTimestampInfoEXTBuilder {
    type Target = CalibratedTimestampInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CalibratedTimestampInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CalibratedTimestampInfoEXTBuilder {
    type Target = CalibratedTimestampInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CheckpointData2NV {
    type Target = CheckpointData2NV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CheckpointData2NV {
    type Builder = CheckpointData2NVBuilder<'b>;
}

/// A builder for a [`CheckpointData2NV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CheckpointData2NVBuilder<'b> {
    value: CheckpointData2NV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CheckpointData2NVBuilder<'b> {
    #[inline]
    pub fn stage(mut self, stage: PipelineStageFlags2KHR) -> Self {
        self.value.stage = stage;
        self
    }

    #[inline]
    pub fn checkpoint_marker<T>(mut self, checkpoint_marker: &'b mut T) -> Self {
        self.value.checkpoint_marker = (checkpoint_marker as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> CheckpointData2NV {
        self.value
    }
}

impl<'b> ops::Deref for CheckpointData2NVBuilder<'b> {
    type Target = CheckpointData2NV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CheckpointData2NVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CheckpointData2NVBuilder<'b> {
    type Target = CheckpointData2NV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CheckpointDataNV {
    type Target = CheckpointDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CheckpointDataNV {
    type Builder = CheckpointDataNVBuilder<'b>;
}

/// A builder for a [`CheckpointDataNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CheckpointDataNVBuilder<'b> {
    value: CheckpointDataNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CheckpointDataNVBuilder<'b> {
    #[inline]
    pub fn stage(mut self, stage: PipelineStageFlags) -> Self {
        self.value.stage = stage;
        self
    }

    #[inline]
    pub fn checkpoint_marker<T>(mut self, checkpoint_marker: &'b mut T) -> Self {
        self.value.checkpoint_marker = (checkpoint_marker as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> CheckpointDataNV {
        self.value
    }
}

impl<'b> ops::Deref for CheckpointDataNVBuilder<'b> {
    type Target = CheckpointDataNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CheckpointDataNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CheckpointDataNVBuilder<'b> {
    type Target = CheckpointDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ClearAttachment {
    type Target = ClearAttachment;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ClearAttachment {
    type Builder = ClearAttachmentBuilder;
}

/// A builder for a [`ClearAttachment`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ClearAttachmentBuilder {
    value: ClearAttachment,
}

impl ClearAttachmentBuilder {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn color_attachment(mut self, color_attachment: u32) -> Self {
        self.value.color_attachment = color_attachment;
        self
    }

    #[inline]
    pub fn clear_value(mut self, clear_value: ClearValue) -> Self {
        self.value.clear_value = clear_value;
        self
    }

    #[inline]
    pub fn build(self) -> ClearAttachment {
        self.value
    }
}

impl ops::Deref for ClearAttachmentBuilder {
    type Target = ClearAttachment;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ClearAttachmentBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ClearAttachmentBuilder {
    type Target = ClearAttachment;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ClearDepthStencilValue {
    type Target = ClearDepthStencilValue;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ClearDepthStencilValue {
    type Builder = ClearDepthStencilValueBuilder;
}

/// A builder for a [`ClearDepthStencilValue`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ClearDepthStencilValueBuilder {
    value: ClearDepthStencilValue,
}

impl ClearDepthStencilValueBuilder {
    #[inline]
    pub fn depth(mut self, depth: f32) -> Self {
        self.value.depth = depth;
        self
    }

    #[inline]
    pub fn stencil(mut self, stencil: u32) -> Self {
        self.value.stencil = stencil;
        self
    }

    #[inline]
    pub fn build(self) -> ClearDepthStencilValue {
        self.value
    }
}

impl ops::Deref for ClearDepthStencilValueBuilder {
    type Target = ClearDepthStencilValue;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ClearDepthStencilValueBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ClearDepthStencilValueBuilder {
    type Target = ClearDepthStencilValue;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ClearRect {
    type Target = ClearRect;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ClearRect {
    type Builder = ClearRectBuilder;
}

/// A builder for a [`ClearRect`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ClearRectBuilder {
    value: ClearRect,
}

impl ClearRectBuilder {
    #[inline]
    pub fn rect(mut self, rect: impl Cast<Target = Rect2D>) -> Self {
        self.value.rect = rect.into();
        self
    }

    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.value.base_array_layer = base_array_layer;
        self
    }

    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.value.layer_count = layer_count;
        self
    }

    #[inline]
    pub fn build(self) -> ClearRect {
        self.value
    }
}

impl ops::Deref for ClearRectBuilder {
    type Target = ClearRect;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ClearRectBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ClearRectBuilder {
    type Target = ClearRect;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CoarseSampleLocationNV {
    type Target = CoarseSampleLocationNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CoarseSampleLocationNV {
    type Builder = CoarseSampleLocationNVBuilder;
}

/// A builder for a [`CoarseSampleLocationNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CoarseSampleLocationNVBuilder {
    value: CoarseSampleLocationNV,
}

impl CoarseSampleLocationNVBuilder {
    #[inline]
    pub fn pixel_x(mut self, pixel_x: u32) -> Self {
        self.value.pixel_x = pixel_x;
        self
    }

    #[inline]
    pub fn pixel_y(mut self, pixel_y: u32) -> Self {
        self.value.pixel_y = pixel_y;
        self
    }

    #[inline]
    pub fn sample(mut self, sample: u32) -> Self {
        self.value.sample = sample;
        self
    }

    #[inline]
    pub fn build(self) -> CoarseSampleLocationNV {
        self.value
    }
}

impl ops::Deref for CoarseSampleLocationNVBuilder {
    type Target = CoarseSampleLocationNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CoarseSampleLocationNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CoarseSampleLocationNVBuilder {
    type Target = CoarseSampleLocationNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CoarseSampleOrderCustomNV {
    type Target = CoarseSampleOrderCustomNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CoarseSampleOrderCustomNV {
    type Builder = CoarseSampleOrderCustomNVBuilder<'b>;
}

/// A builder for a [`CoarseSampleOrderCustomNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CoarseSampleOrderCustomNVBuilder<'b> {
    value: CoarseSampleOrderCustomNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CoarseSampleOrderCustomNVBuilder<'b> {
    #[inline]
    pub fn shading_rate(mut self, shading_rate: ShadingRatePaletteEntryNV) -> Self {
        self.value.shading_rate = shading_rate;
        self
    }

    #[inline]
    pub fn sample_count(mut self, sample_count: u32) -> Self {
        self.value.sample_count = sample_count;
        self
    }

    #[inline]
    pub fn sample_locations(
        mut self,
        sample_locations: &'b [impl Cast<Target = CoarseSampleLocationNV>],
    ) -> Self {
        self.value.sample_location_count = sample_locations.len() as u32;
        self.value.sample_locations = sample_locations.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CoarseSampleOrderCustomNV {
        self.value
    }
}

impl<'b> ops::Deref for CoarseSampleOrderCustomNVBuilder<'b> {
    type Target = CoarseSampleOrderCustomNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CoarseSampleOrderCustomNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CoarseSampleOrderCustomNVBuilder<'b> {
    type Target = CoarseSampleOrderCustomNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandBufferAllocateInfo {
    type Target = CommandBufferAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CommandBufferAllocateInfo {
    type Builder = CommandBufferAllocateInfoBuilder;
}

/// A builder for a [`CommandBufferAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferAllocateInfoBuilder {
    value: CommandBufferAllocateInfo,
}

impl CommandBufferAllocateInfoBuilder {
    #[inline]
    pub fn command_pool(mut self, command_pool: CommandPool) -> Self {
        self.value.command_pool = command_pool;
        self
    }

    #[inline]
    pub fn level(mut self, level: CommandBufferLevel) -> Self {
        self.value.level = level;
        self
    }

    #[inline]
    pub fn command_buffer_count(mut self, command_buffer_count: u32) -> Self {
        self.value.command_buffer_count = command_buffer_count;
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferAllocateInfo {
        self.value
    }
}

impl ops::Deref for CommandBufferAllocateInfoBuilder {
    type Target = CommandBufferAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CommandBufferAllocateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CommandBufferAllocateInfoBuilder {
    type Target = CommandBufferAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`CommandBufferBeginInfo`].
pub unsafe trait ExtendsCommandBufferBeginInfo: fmt::Debug {}
unsafe impl ExtendsCommandBufferBeginInfo for DeviceGroupCommandBufferBeginInfo {}

unsafe impl Cast for CommandBufferBeginInfo {
    type Target = CommandBufferBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CommandBufferBeginInfo {
    type Builder = CommandBufferBeginInfoBuilder<'b>;
}

/// A builder for a [`CommandBufferBeginInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferBeginInfoBuilder<'b> {
    value: CommandBufferBeginInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CommandBufferBeginInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsCommandBufferBeginInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<CommandBufferBeginInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: CommandBufferUsageFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn inheritance_info(
        mut self,
        inheritance_info: &'b impl Cast<Target = CommandBufferInheritanceInfo>,
    ) -> Self {
        self.value.inheritance_info = inheritance_info.as_ref();
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferBeginInfo {
        self.value
    }
}

impl<'b> ops::Deref for CommandBufferBeginInfoBuilder<'b> {
    type Target = CommandBufferBeginInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CommandBufferBeginInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CommandBufferBeginInfoBuilder<'b> {
    type Target = CommandBufferBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandBufferInheritanceConditionalRenderingInfoEXT {
    type Target = CommandBufferInheritanceConditionalRenderingInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CommandBufferInheritanceConditionalRenderingInfoEXT {
    type Builder = CommandBufferInheritanceConditionalRenderingInfoEXTBuilder;
}

/// A builder for a [`CommandBufferInheritanceConditionalRenderingInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferInheritanceConditionalRenderingInfoEXTBuilder {
    value: CommandBufferInheritanceConditionalRenderingInfoEXT,
}

impl CommandBufferInheritanceConditionalRenderingInfoEXTBuilder {
    #[inline]
    pub fn conditional_rendering_enable(mut self, conditional_rendering_enable: bool) -> Self {
        self.value.conditional_rendering_enable = conditional_rendering_enable as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferInheritanceConditionalRenderingInfoEXT {
        self.value
    }
}

impl ops::Deref for CommandBufferInheritanceConditionalRenderingInfoEXTBuilder {
    type Target = CommandBufferInheritanceConditionalRenderingInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CommandBufferInheritanceConditionalRenderingInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CommandBufferInheritanceConditionalRenderingInfoEXTBuilder {
    type Target = CommandBufferInheritanceConditionalRenderingInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`CommandBufferInheritanceInfo`].
pub unsafe trait ExtendsCommandBufferInheritanceInfo: fmt::Debug {}
unsafe impl ExtendsCommandBufferInheritanceInfo
    for CommandBufferInheritanceConditionalRenderingInfoEXT
{
}
unsafe impl ExtendsCommandBufferInheritanceInfo
    for CommandBufferInheritanceRenderPassTransformInfoQCOM
{
}
unsafe impl ExtendsCommandBufferInheritanceInfo for CommandBufferInheritanceViewportScissorInfoNV {}

unsafe impl Cast for CommandBufferInheritanceInfo {
    type Target = CommandBufferInheritanceInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CommandBufferInheritanceInfo {
    type Builder = CommandBufferInheritanceInfoBuilder<'b>;
}

/// A builder for a [`CommandBufferInheritanceInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferInheritanceInfoBuilder<'b> {
    value: CommandBufferInheritanceInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CommandBufferInheritanceInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsCommandBufferInheritanceInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<CommandBufferInheritanceInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.value.render_pass = render_pass;
        self
    }

    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.value.subpass = subpass;
        self
    }

    #[inline]
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> Self {
        self.value.framebuffer = framebuffer;
        self
    }

    #[inline]
    pub fn occlusion_query_enable(mut self, occlusion_query_enable: bool) -> Self {
        self.value.occlusion_query_enable = occlusion_query_enable as Bool32;
        self
    }

    #[inline]
    pub fn query_flags(mut self, query_flags: QueryControlFlags) -> Self {
        self.value.query_flags = query_flags;
        self
    }

    #[inline]
    pub fn pipeline_statistics(mut self, pipeline_statistics: QueryPipelineStatisticFlags) -> Self {
        self.value.pipeline_statistics = pipeline_statistics;
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferInheritanceInfo {
        self.value
    }
}

impl<'b> ops::Deref for CommandBufferInheritanceInfoBuilder<'b> {
    type Target = CommandBufferInheritanceInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CommandBufferInheritanceInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CommandBufferInheritanceInfoBuilder<'b> {
    type Target = CommandBufferInheritanceInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandBufferInheritanceRenderPassTransformInfoQCOM {
    type Target = CommandBufferInheritanceRenderPassTransformInfoQCOM;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CommandBufferInheritanceRenderPassTransformInfoQCOM {
    type Builder = CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder;
}

/// A builder for a [`CommandBufferInheritanceRenderPassTransformInfoQCOM`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder {
    value: CommandBufferInheritanceRenderPassTransformInfoQCOM,
}

impl CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder {
    #[inline]
    pub fn transform(mut self, transform: SurfaceTransformFlagsKHR) -> Self {
        self.value.transform = transform;
        self
    }

    #[inline]
    pub fn render_area(mut self, render_area: impl Cast<Target = Rect2D>) -> Self {
        self.value.render_area = render_area.into();
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferInheritanceRenderPassTransformInfoQCOM {
        self.value
    }
}

impl ops::Deref for CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder {
    type Target = CommandBufferInheritanceRenderPassTransformInfoQCOM;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CommandBufferInheritanceRenderPassTransformInfoQCOMBuilder {
    type Target = CommandBufferInheritanceRenderPassTransformInfoQCOM;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandBufferInheritanceViewportScissorInfoNV {
    type Target = CommandBufferInheritanceViewportScissorInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CommandBufferInheritanceViewportScissorInfoNV {
    type Builder = CommandBufferInheritanceViewportScissorInfoNVBuilder<'b>;
}

/// A builder for a [`CommandBufferInheritanceViewportScissorInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferInheritanceViewportScissorInfoNVBuilder<'b> {
    value: CommandBufferInheritanceViewportScissorInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CommandBufferInheritanceViewportScissorInfoNVBuilder<'b> {
    #[inline]
    pub fn viewport_scissor_2d(mut self, viewport_scissor_2d: bool) -> Self {
        self.value.viewport_scissor_2d = viewport_scissor_2d as Bool32;
        self
    }

    #[inline]
    pub fn viewport_depth_count(mut self, viewport_depth_count: u32) -> Self {
        self.value.viewport_depth_count = viewport_depth_count;
        self
    }

    #[inline]
    pub fn viewport_depths(mut self, viewport_depths: &'b impl Cast<Target = Viewport>) -> Self {
        self.value.viewport_depths = viewport_depths.as_ref();
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferInheritanceViewportScissorInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for CommandBufferInheritanceViewportScissorInfoNVBuilder<'b> {
    type Target = CommandBufferInheritanceViewportScissorInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CommandBufferInheritanceViewportScissorInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CommandBufferInheritanceViewportScissorInfoNVBuilder<'b> {
    type Target = CommandBufferInheritanceViewportScissorInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandBufferSubmitInfoKHR {
    type Target = CommandBufferSubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CommandBufferSubmitInfoKHR {
    type Builder = CommandBufferSubmitInfoKHRBuilder;
}

/// A builder for a [`CommandBufferSubmitInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandBufferSubmitInfoKHRBuilder {
    value: CommandBufferSubmitInfoKHR,
}

impl CommandBufferSubmitInfoKHRBuilder {
    #[inline]
    pub fn command_buffer(mut self, command_buffer: CommandBuffer) -> Self {
        self.value.command_buffer = command_buffer;
        self
    }

    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.value.device_mask = device_mask;
        self
    }

    #[inline]
    pub fn build(self) -> CommandBufferSubmitInfoKHR {
        self.value
    }
}

impl ops::Deref for CommandBufferSubmitInfoKHRBuilder {
    type Target = CommandBufferSubmitInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CommandBufferSubmitInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CommandBufferSubmitInfoKHRBuilder {
    type Target = CommandBufferSubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CommandPoolCreateInfo {
    type Target = CommandPoolCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CommandPoolCreateInfo {
    type Builder = CommandPoolCreateInfoBuilder;
}

/// A builder for a [`CommandPoolCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CommandPoolCreateInfoBuilder {
    value: CommandPoolCreateInfo,
}

impl CommandPoolCreateInfoBuilder {
    #[inline]
    pub fn flags(mut self, flags: CommandPoolCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.value.queue_family_index = queue_family_index;
        self
    }

    #[inline]
    pub fn build(self) -> CommandPoolCreateInfo {
        self.value
    }
}

impl ops::Deref for CommandPoolCreateInfoBuilder {
    type Target = CommandPoolCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CommandPoolCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CommandPoolCreateInfoBuilder {
    type Target = CommandPoolCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ComponentMapping {
    type Target = ComponentMapping;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ComponentMapping {
    type Builder = ComponentMappingBuilder;
}

/// A builder for a [`ComponentMapping`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ComponentMappingBuilder {
    value: ComponentMapping,
}

impl ComponentMappingBuilder {
    #[inline]
    pub fn r(mut self, r: ComponentSwizzle) -> Self {
        self.value.r = r;
        self
    }

    #[inline]
    pub fn g(mut self, g: ComponentSwizzle) -> Self {
        self.value.g = g;
        self
    }

    #[inline]
    pub fn b(mut self, b: ComponentSwizzle) -> Self {
        self.value.b = b;
        self
    }

    #[inline]
    pub fn a(mut self, a: ComponentSwizzle) -> Self {
        self.value.a = a;
        self
    }

    #[inline]
    pub fn build(self) -> ComponentMapping {
        self.value
    }
}

impl ops::Deref for ComponentMappingBuilder {
    type Target = ComponentMapping;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ComponentMappingBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ComponentMappingBuilder {
    type Target = ComponentMapping;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ComputePipelineCreateInfo`].
pub unsafe trait ExtendsComputePipelineCreateInfo: fmt::Debug {}
unsafe impl ExtendsComputePipelineCreateInfo for PipelineCompilerControlCreateInfoAMD {}
unsafe impl ExtendsComputePipelineCreateInfo for PipelineCreationFeedbackCreateInfoEXT {}
unsafe impl ExtendsComputePipelineCreateInfo for SubpassShadingPipelineCreateInfoHUAWEI {}

unsafe impl Cast for ComputePipelineCreateInfo {
    type Target = ComputePipelineCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ComputePipelineCreateInfo {
    type Builder = ComputePipelineCreateInfoBuilder<'b>;
}

/// A builder for a [`ComputePipelineCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ComputePipelineCreateInfoBuilder<'b> {
    value: ComputePipelineCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ComputePipelineCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsComputePipelineCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<ComputePipelineCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn stage(mut self, stage: impl Cast<Target = PipelineShaderStageCreateInfo>) -> Self {
        self.value.stage = stage.into();
        self
    }

    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.value.layout = layout;
        self
    }

    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.value.base_pipeline_handle = base_pipeline_handle;
        self
    }

    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.value.base_pipeline_index = base_pipeline_index;
        self
    }

    #[inline]
    pub fn build(self) -> ComputePipelineCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for ComputePipelineCreateInfoBuilder<'b> {
    type Target = ComputePipelineCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ComputePipelineCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ComputePipelineCreateInfoBuilder<'b> {
    type Target = ComputePipelineCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ConditionalRenderingBeginInfoEXT {
    type Target = ConditionalRenderingBeginInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ConditionalRenderingBeginInfoEXT {
    type Builder = ConditionalRenderingBeginInfoEXTBuilder;
}

/// A builder for a [`ConditionalRenderingBeginInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ConditionalRenderingBeginInfoEXTBuilder {
    value: ConditionalRenderingBeginInfoEXT,
}

impl ConditionalRenderingBeginInfoEXTBuilder {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: ConditionalRenderingFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> ConditionalRenderingBeginInfoEXT {
        self.value
    }
}

impl ops::Deref for ConditionalRenderingBeginInfoEXTBuilder {
    type Target = ConditionalRenderingBeginInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ConditionalRenderingBeginInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ConditionalRenderingBeginInfoEXTBuilder {
    type Target = ConditionalRenderingBeginInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ConformanceVersion {
    type Target = ConformanceVersion;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ConformanceVersion {
    type Builder = ConformanceVersionBuilder;
}

/// A builder for a [`ConformanceVersion`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ConformanceVersionBuilder {
    value: ConformanceVersion,
}

impl ConformanceVersionBuilder {
    #[inline]
    pub fn major(mut self, major: u8) -> Self {
        self.value.major = major;
        self
    }

    #[inline]
    pub fn minor(mut self, minor: u8) -> Self {
        self.value.minor = minor;
        self
    }

    #[inline]
    pub fn subminor(mut self, subminor: u8) -> Self {
        self.value.subminor = subminor;
        self
    }

    #[inline]
    pub fn patch(mut self, patch: u8) -> Self {
        self.value.patch = patch;
        self
    }

    #[inline]
    pub fn build(self) -> ConformanceVersion {
        self.value
    }
}

impl ops::Deref for ConformanceVersionBuilder {
    type Target = ConformanceVersion;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ConformanceVersionBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ConformanceVersionBuilder {
    type Target = ConformanceVersion;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CooperativeMatrixPropertiesNV {
    type Target = CooperativeMatrixPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CooperativeMatrixPropertiesNV {
    type Builder = CooperativeMatrixPropertiesNVBuilder;
}

/// A builder for a [`CooperativeMatrixPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CooperativeMatrixPropertiesNVBuilder {
    value: CooperativeMatrixPropertiesNV,
}

impl CooperativeMatrixPropertiesNVBuilder {
    #[inline]
    pub fn m_size(mut self, m_size: u32) -> Self {
        self.value.m_size = m_size;
        self
    }

    #[inline]
    pub fn n_size(mut self, n_size: u32) -> Self {
        self.value.n_size = n_size;
        self
    }

    #[inline]
    pub fn k_size(mut self, k_size: u32) -> Self {
        self.value.k_size = k_size;
        self
    }

    #[inline]
    pub fn a_type(mut self, a_type: ComponentTypeNV) -> Self {
        self.value.a_type = a_type;
        self
    }

    #[inline]
    pub fn b_type(mut self, b_type: ComponentTypeNV) -> Self {
        self.value.b_type = b_type;
        self
    }

    #[inline]
    pub fn c_type(mut self, c_type: ComponentTypeNV) -> Self {
        self.value.c_type = c_type;
        self
    }

    #[inline]
    pub fn d_type(mut self, d_type: ComponentTypeNV) -> Self {
        self.value.d_type = d_type;
        self
    }

    #[inline]
    pub fn scope(mut self, scope: ScopeNV) -> Self {
        self.value.scope = scope;
        self
    }

    #[inline]
    pub fn build(self) -> CooperativeMatrixPropertiesNV {
        self.value
    }
}

impl ops::Deref for CooperativeMatrixPropertiesNVBuilder {
    type Target = CooperativeMatrixPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CooperativeMatrixPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CooperativeMatrixPropertiesNVBuilder {
    type Target = CooperativeMatrixPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyAccelerationStructureInfoKHR {
    type Target = CopyAccelerationStructureInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CopyAccelerationStructureInfoKHR {
    type Builder = CopyAccelerationStructureInfoKHRBuilder;
}

/// A builder for a [`CopyAccelerationStructureInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyAccelerationStructureInfoKHRBuilder {
    value: CopyAccelerationStructureInfoKHR,
}

impl CopyAccelerationStructureInfoKHRBuilder {
    #[inline]
    pub fn src(mut self, src: AccelerationStructureKHR) -> Self {
        self.value.src = src;
        self
    }

    #[inline]
    pub fn dst(mut self, dst: AccelerationStructureKHR) -> Self {
        self.value.dst = dst;
        self
    }

    #[inline]
    pub fn mode(mut self, mode: CopyAccelerationStructureModeKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn build(self) -> CopyAccelerationStructureInfoKHR {
        self.value
    }
}

impl ops::Deref for CopyAccelerationStructureInfoKHRBuilder {
    type Target = CopyAccelerationStructureInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CopyAccelerationStructureInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CopyAccelerationStructureInfoKHRBuilder {
    type Target = CopyAccelerationStructureInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyAccelerationStructureToMemoryInfoKHR {
    type Target = CopyAccelerationStructureToMemoryInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CopyAccelerationStructureToMemoryInfoKHR {
    type Builder = CopyAccelerationStructureToMemoryInfoKHRBuilder;
}

/// A builder for a [`CopyAccelerationStructureToMemoryInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyAccelerationStructureToMemoryInfoKHRBuilder {
    value: CopyAccelerationStructureToMemoryInfoKHR,
}

impl CopyAccelerationStructureToMemoryInfoKHRBuilder {
    #[inline]
    pub fn src(mut self, src: AccelerationStructureKHR) -> Self {
        self.value.src = src;
        self
    }

    #[inline]
    pub fn dst(mut self, dst: DeviceOrHostAddressKHR) -> Self {
        self.value.dst = dst;
        self
    }

    #[inline]
    pub fn mode(mut self, mode: CopyAccelerationStructureModeKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn build(self) -> CopyAccelerationStructureToMemoryInfoKHR {
        self.value
    }
}

impl ops::Deref for CopyAccelerationStructureToMemoryInfoKHRBuilder {
    type Target = CopyAccelerationStructureToMemoryInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CopyAccelerationStructureToMemoryInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CopyAccelerationStructureToMemoryInfoKHRBuilder {
    type Target = CopyAccelerationStructureToMemoryInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyBufferInfo2KHR {
    type Target = CopyBufferInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CopyBufferInfo2KHR {
    type Builder = CopyBufferInfo2KHRBuilder<'b>;
}

/// A builder for a [`CopyBufferInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyBufferInfo2KHRBuilder<'b> {
    value: CopyBufferInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CopyBufferInfo2KHRBuilder<'b> {
    #[inline]
    pub fn src_buffer(mut self, src_buffer: Buffer) -> Self {
        self.value.src_buffer = src_buffer;
        self
    }

    #[inline]
    pub fn dst_buffer(mut self, dst_buffer: Buffer) -> Self {
        self.value.dst_buffer = dst_buffer;
        self
    }

    #[inline]
    pub fn regions(mut self, regions: &'b [impl Cast<Target = BufferCopy2KHR>]) -> Self {
        self.value.region_count = regions.len() as u32;
        self.value.regions = regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CopyBufferInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for CopyBufferInfo2KHRBuilder<'b> {
    type Target = CopyBufferInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CopyBufferInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CopyBufferInfo2KHRBuilder<'b> {
    type Target = CopyBufferInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyBufferToImageInfo2KHR {
    type Target = CopyBufferToImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CopyBufferToImageInfo2KHR {
    type Builder = CopyBufferToImageInfo2KHRBuilder<'b>;
}

/// A builder for a [`CopyBufferToImageInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyBufferToImageInfo2KHRBuilder<'b> {
    value: CopyBufferToImageInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CopyBufferToImageInfo2KHRBuilder<'b> {
    #[inline]
    pub fn src_buffer(mut self, src_buffer: Buffer) -> Self {
        self.value.src_buffer = src_buffer;
        self
    }

    #[inline]
    pub fn dst_image(mut self, dst_image: Image) -> Self {
        self.value.dst_image = dst_image;
        self
    }

    #[inline]
    pub fn dst_image_layout(mut self, dst_image_layout: ImageLayout) -> Self {
        self.value.dst_image_layout = dst_image_layout;
        self
    }

    #[inline]
    pub fn regions(mut self, regions: &'b [impl Cast<Target = BufferImageCopy2KHR>]) -> Self {
        self.value.region_count = regions.len() as u32;
        self.value.regions = regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CopyBufferToImageInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for CopyBufferToImageInfo2KHRBuilder<'b> {
    type Target = CopyBufferToImageInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CopyBufferToImageInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CopyBufferToImageInfo2KHRBuilder<'b> {
    type Target = CopyBufferToImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyCommandTransformInfoQCOM {
    type Target = CopyCommandTransformInfoQCOM;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CopyCommandTransformInfoQCOM {
    type Builder = CopyCommandTransformInfoQCOMBuilder;
}

/// A builder for a [`CopyCommandTransformInfoQCOM`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyCommandTransformInfoQCOMBuilder {
    value: CopyCommandTransformInfoQCOM,
}

impl CopyCommandTransformInfoQCOMBuilder {
    #[inline]
    pub fn transform(mut self, transform: SurfaceTransformFlagsKHR) -> Self {
        self.value.transform = transform;
        self
    }

    #[inline]
    pub fn build(self) -> CopyCommandTransformInfoQCOM {
        self.value
    }
}

impl ops::Deref for CopyCommandTransformInfoQCOMBuilder {
    type Target = CopyCommandTransformInfoQCOM;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CopyCommandTransformInfoQCOMBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CopyCommandTransformInfoQCOMBuilder {
    type Target = CopyCommandTransformInfoQCOM;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyDescriptorSet {
    type Target = CopyDescriptorSet;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CopyDescriptorSet {
    type Builder = CopyDescriptorSetBuilder;
}

/// A builder for a [`CopyDescriptorSet`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyDescriptorSetBuilder {
    value: CopyDescriptorSet,
}

impl CopyDescriptorSetBuilder {
    #[inline]
    pub fn src_set(mut self, src_set: DescriptorSet) -> Self {
        self.value.src_set = src_set;
        self
    }

    #[inline]
    pub fn src_binding(mut self, src_binding: u32) -> Self {
        self.value.src_binding = src_binding;
        self
    }

    #[inline]
    pub fn src_array_element(mut self, src_array_element: u32) -> Self {
        self.value.src_array_element = src_array_element;
        self
    }

    #[inline]
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> Self {
        self.value.dst_set = dst_set;
        self
    }

    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.value.dst_binding = dst_binding;
        self
    }

    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.value.dst_array_element = dst_array_element;
        self
    }

    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.value.descriptor_count = descriptor_count;
        self
    }

    #[inline]
    pub fn build(self) -> CopyDescriptorSet {
        self.value
    }
}

impl ops::Deref for CopyDescriptorSetBuilder {
    type Target = CopyDescriptorSet;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CopyDescriptorSetBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CopyDescriptorSetBuilder {
    type Target = CopyDescriptorSet;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyImageInfo2KHR {
    type Target = CopyImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CopyImageInfo2KHR {
    type Builder = CopyImageInfo2KHRBuilder<'b>;
}

/// A builder for a [`CopyImageInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyImageInfo2KHRBuilder<'b> {
    value: CopyImageInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CopyImageInfo2KHRBuilder<'b> {
    #[inline]
    pub fn src_image(mut self, src_image: Image) -> Self {
        self.value.src_image = src_image;
        self
    }

    #[inline]
    pub fn src_image_layout(mut self, src_image_layout: ImageLayout) -> Self {
        self.value.src_image_layout = src_image_layout;
        self
    }

    #[inline]
    pub fn dst_image(mut self, dst_image: Image) -> Self {
        self.value.dst_image = dst_image;
        self
    }

    #[inline]
    pub fn dst_image_layout(mut self, dst_image_layout: ImageLayout) -> Self {
        self.value.dst_image_layout = dst_image_layout;
        self
    }

    #[inline]
    pub fn regions(mut self, regions: &'b [impl Cast<Target = ImageCopy2KHR>]) -> Self {
        self.value.region_count = regions.len() as u32;
        self.value.regions = regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CopyImageInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for CopyImageInfo2KHRBuilder<'b> {
    type Target = CopyImageInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CopyImageInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CopyImageInfo2KHRBuilder<'b> {
    type Target = CopyImageInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyImageToBufferInfo2KHR {
    type Target = CopyImageToBufferInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CopyImageToBufferInfo2KHR {
    type Builder = CopyImageToBufferInfo2KHRBuilder<'b>;
}

/// A builder for a [`CopyImageToBufferInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyImageToBufferInfo2KHRBuilder<'b> {
    value: CopyImageToBufferInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CopyImageToBufferInfo2KHRBuilder<'b> {
    #[inline]
    pub fn src_image(mut self, src_image: Image) -> Self {
        self.value.src_image = src_image;
        self
    }

    #[inline]
    pub fn src_image_layout(mut self, src_image_layout: ImageLayout) -> Self {
        self.value.src_image_layout = src_image_layout;
        self
    }

    #[inline]
    pub fn dst_buffer(mut self, dst_buffer: Buffer) -> Self {
        self.value.dst_buffer = dst_buffer;
        self
    }

    #[inline]
    pub fn regions(mut self, regions: &'b [impl Cast<Target = BufferImageCopy2KHR>]) -> Self {
        self.value.region_count = regions.len() as u32;
        self.value.regions = regions.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CopyImageToBufferInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for CopyImageToBufferInfo2KHRBuilder<'b> {
    type Target = CopyImageToBufferInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CopyImageToBufferInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CopyImageToBufferInfo2KHRBuilder<'b> {
    type Target = CopyImageToBufferInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CopyMemoryToAccelerationStructureInfoKHR {
    type Target = CopyMemoryToAccelerationStructureInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for CopyMemoryToAccelerationStructureInfoKHR {
    type Builder = CopyMemoryToAccelerationStructureInfoKHRBuilder;
}

/// A builder for a [`CopyMemoryToAccelerationStructureInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CopyMemoryToAccelerationStructureInfoKHRBuilder {
    value: CopyMemoryToAccelerationStructureInfoKHR,
}

impl CopyMemoryToAccelerationStructureInfoKHRBuilder {
    #[inline]
    pub fn src(mut self, src: DeviceOrHostAddressConstKHR) -> Self {
        self.value.src = src;
        self
    }

    #[inline]
    pub fn dst(mut self, dst: AccelerationStructureKHR) -> Self {
        self.value.dst = dst;
        self
    }

    #[inline]
    pub fn mode(mut self, mode: CopyAccelerationStructureModeKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn build(self) -> CopyMemoryToAccelerationStructureInfoKHR {
        self.value
    }
}

impl ops::Deref for CopyMemoryToAccelerationStructureInfoKHRBuilder {
    type Target = CopyMemoryToAccelerationStructureInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for CopyMemoryToAccelerationStructureInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for CopyMemoryToAccelerationStructureInfoKHRBuilder {
    type Target = CopyMemoryToAccelerationStructureInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CuFunctionCreateInfoNVX {
    type Target = CuFunctionCreateInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CuFunctionCreateInfoNVX {
    type Builder = CuFunctionCreateInfoNVXBuilder<'b>;
}

/// A builder for a [`CuFunctionCreateInfoNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CuFunctionCreateInfoNVXBuilder<'b> {
    value: CuFunctionCreateInfoNVX,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CuFunctionCreateInfoNVXBuilder<'b> {
    #[inline]
    pub fn module(mut self, module: CuModuleNVX) -> Self {
        self.value.module = module;
        self
    }

    #[inline]
    pub fn name(mut self, name: &'b [u8]) -> Self {
        self.value.name = name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CuFunctionCreateInfoNVX {
        self.value
    }
}

impl<'b> ops::Deref for CuFunctionCreateInfoNVXBuilder<'b> {
    type Target = CuFunctionCreateInfoNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CuFunctionCreateInfoNVXBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CuFunctionCreateInfoNVXBuilder<'b> {
    type Target = CuFunctionCreateInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CuLaunchInfoNVX {
    type Target = CuLaunchInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CuLaunchInfoNVX {
    type Builder = CuLaunchInfoNVXBuilder<'b>;
}

/// A builder for a [`CuLaunchInfoNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CuLaunchInfoNVXBuilder<'b> {
    value: CuLaunchInfoNVX,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CuLaunchInfoNVXBuilder<'b> {
    #[inline]
    pub fn function(mut self, function: CuFunctionNVX) -> Self {
        self.value.function = function;
        self
    }

    #[inline]
    pub fn grid_dim_x(mut self, grid_dim_x: u32) -> Self {
        self.value.grid_dim_x = grid_dim_x;
        self
    }

    #[inline]
    pub fn grid_dim_y(mut self, grid_dim_y: u32) -> Self {
        self.value.grid_dim_y = grid_dim_y;
        self
    }

    #[inline]
    pub fn grid_dim_z(mut self, grid_dim_z: u32) -> Self {
        self.value.grid_dim_z = grid_dim_z;
        self
    }

    #[inline]
    pub fn block_dim_x(mut self, block_dim_x: u32) -> Self {
        self.value.block_dim_x = block_dim_x;
        self
    }

    #[inline]
    pub fn block_dim_y(mut self, block_dim_y: u32) -> Self {
        self.value.block_dim_y = block_dim_y;
        self
    }

    #[inline]
    pub fn block_dim_z(mut self, block_dim_z: u32) -> Self {
        self.value.block_dim_z = block_dim_z;
        self
    }

    #[inline]
    pub fn shared_mem_bytes(mut self, shared_mem_bytes: u32) -> Self {
        self.value.shared_mem_bytes = shared_mem_bytes;
        self
    }

    #[inline]
    pub fn params(mut self, params: &'b [u8]) -> Self {
        self.value.param_count = params.len() as usize;
        self.value.params = params.as_ptr().cast();
        self
    }

    #[inline]
    pub fn extras(mut self, extras: &'b [u8]) -> Self {
        self.value.extra_count = extras.len() as usize;
        self.value.extras = extras.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> CuLaunchInfoNVX {
        self.value
    }
}

impl<'b> ops::Deref for CuLaunchInfoNVXBuilder<'b> {
    type Target = CuLaunchInfoNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CuLaunchInfoNVXBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CuLaunchInfoNVXBuilder<'b> {
    type Target = CuLaunchInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for CuModuleCreateInfoNVX {
    type Target = CuModuleCreateInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for CuModuleCreateInfoNVX {
    type Builder = CuModuleCreateInfoNVXBuilder<'b>;
}

/// A builder for a [`CuModuleCreateInfoNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct CuModuleCreateInfoNVXBuilder<'b> {
    value: CuModuleCreateInfoNVX,
    _marker: PhantomData<&'b ()>,
}

impl<'b> CuModuleCreateInfoNVXBuilder<'b> {
    #[inline]
    pub fn data_size(mut self, data_size: usize) -> Self {
        self.value.data_size = data_size;
        self
    }

    #[inline]
    pub fn data<T>(mut self, data: &'b T) -> Self {
        self.value.data = (data as *const T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> CuModuleCreateInfoNVX {
        self.value
    }
}

impl<'b> ops::Deref for CuModuleCreateInfoNVXBuilder<'b> {
    type Target = CuModuleCreateInfoNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for CuModuleCreateInfoNVXBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for CuModuleCreateInfoNVXBuilder<'b> {
    type Target = CuModuleCreateInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for D3D12FenceSubmitInfoKHR {
    type Target = D3D12FenceSubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for D3D12FenceSubmitInfoKHR {
    type Builder = D3D12FenceSubmitInfoKHRBuilder<'b>;
}

/// A builder for a [`D3D12FenceSubmitInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct D3D12FenceSubmitInfoKHRBuilder<'b> {
    value: D3D12FenceSubmitInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> D3D12FenceSubmitInfoKHRBuilder<'b> {
    #[inline]
    pub fn wait_semaphore_values_count(mut self, wait_semaphore_values_count: u32) -> Self {
        self.value.wait_semaphore_values_count = wait_semaphore_values_count;
        self
    }

    #[inline]
    pub fn wait_semaphore_values(mut self, wait_semaphore_values: &'b [u64]) -> Self {
        self.value.wait_semaphore_values_count = wait_semaphore_values.len() as u32;
        self.value.wait_semaphore_values = wait_semaphore_values.as_ptr();
        self
    }

    #[inline]
    pub fn signal_semaphore_values_count(mut self, signal_semaphore_values_count: u32) -> Self {
        self.value.signal_semaphore_values_count = signal_semaphore_values_count;
        self
    }

    #[inline]
    pub fn signal_semaphore_values(mut self, signal_semaphore_values: &'b [u64]) -> Self {
        self.value.signal_semaphore_values_count = signal_semaphore_values.len() as u32;
        self.value.signal_semaphore_values = signal_semaphore_values.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> D3D12FenceSubmitInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for D3D12FenceSubmitInfoKHRBuilder<'b> {
    type Target = D3D12FenceSubmitInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for D3D12FenceSubmitInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for D3D12FenceSubmitInfoKHRBuilder<'b> {
    type Target = D3D12FenceSubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugMarkerMarkerInfoEXT {
    type Target = DebugMarkerMarkerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugMarkerMarkerInfoEXT {
    type Builder = DebugMarkerMarkerInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugMarkerMarkerInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugMarkerMarkerInfoEXTBuilder<'b> {
    value: DebugMarkerMarkerInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugMarkerMarkerInfoEXTBuilder<'b> {
    #[inline]
    pub fn marker_name(mut self, marker_name: &'b [u8]) -> Self {
        self.value.marker_name = marker_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn color(mut self, color: [f32; 4]) -> Self {
        self.value.color = color;
        self
    }

    #[inline]
    pub fn build(self) -> DebugMarkerMarkerInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugMarkerMarkerInfoEXTBuilder<'b> {
    type Target = DebugMarkerMarkerInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugMarkerMarkerInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugMarkerMarkerInfoEXTBuilder<'b> {
    type Target = DebugMarkerMarkerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugMarkerObjectNameInfoEXT {
    type Target = DebugMarkerObjectNameInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugMarkerObjectNameInfoEXT {
    type Builder = DebugMarkerObjectNameInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugMarkerObjectNameInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugMarkerObjectNameInfoEXTBuilder<'b> {
    value: DebugMarkerObjectNameInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugMarkerObjectNameInfoEXTBuilder<'b> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.value.object_type = object_type;
        self
    }

    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.value.object = object;
        self
    }

    #[inline]
    pub fn object_name(mut self, object_name: &'b [u8]) -> Self {
        self.value.object_name = object_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugMarkerObjectNameInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugMarkerObjectNameInfoEXTBuilder<'b> {
    type Target = DebugMarkerObjectNameInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugMarkerObjectNameInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugMarkerObjectNameInfoEXTBuilder<'b> {
    type Target = DebugMarkerObjectNameInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugMarkerObjectTagInfoEXT {
    type Target = DebugMarkerObjectTagInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugMarkerObjectTagInfoEXT {
    type Builder = DebugMarkerObjectTagInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugMarkerObjectTagInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugMarkerObjectTagInfoEXTBuilder<'b> {
    value: DebugMarkerObjectTagInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugMarkerObjectTagInfoEXTBuilder<'b> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.value.object_type = object_type;
        self
    }

    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.value.object = object;
        self
    }

    #[inline]
    pub fn tag_name(mut self, tag_name: u64) -> Self {
        self.value.tag_name = tag_name;
        self
    }

    #[inline]
    pub fn tag(mut self, tag: &'b [u8]) -> Self {
        self.value.tag_size = tag.len() as usize;
        self.value.tag = tag.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugMarkerObjectTagInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugMarkerObjectTagInfoEXTBuilder<'b> {
    type Target = DebugMarkerObjectTagInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugMarkerObjectTagInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugMarkerObjectTagInfoEXTBuilder<'b> {
    type Target = DebugMarkerObjectTagInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugReportCallbackCreateInfoEXT {
    type Target = DebugReportCallbackCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugReportCallbackCreateInfoEXT {
    type Builder = DebugReportCallbackCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugReportCallbackCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugReportCallbackCreateInfoEXTBuilder<'b> {
    value: DebugReportCallbackCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugReportCallbackCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DebugReportFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn callback(mut self, callback: PFN_vkDebugReportCallbackEXT) -> Self {
        self.value.callback = callback;
        self
    }

    #[inline]
    pub fn user_data<T>(mut self, user_data: &'b mut T) -> Self {
        self.value.user_data = (user_data as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugReportCallbackCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugReportCallbackCreateInfoEXTBuilder<'b> {
    type Target = DebugReportCallbackCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugReportCallbackCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugReportCallbackCreateInfoEXTBuilder<'b> {
    type Target = DebugReportCallbackCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugUtilsLabelEXT {
    type Target = DebugUtilsLabelEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugUtilsLabelEXT {
    type Builder = DebugUtilsLabelEXTBuilder<'b>;
}

/// A builder for a [`DebugUtilsLabelEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugUtilsLabelEXTBuilder<'b> {
    value: DebugUtilsLabelEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugUtilsLabelEXTBuilder<'b> {
    #[inline]
    pub fn label_name(mut self, label_name: &'b [u8]) -> Self {
        self.value.label_name = label_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn color(mut self, color: [f32; 4]) -> Self {
        self.value.color = color;
        self
    }

    #[inline]
    pub fn build(self) -> DebugUtilsLabelEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugUtilsLabelEXTBuilder<'b> {
    type Target = DebugUtilsLabelEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugUtilsLabelEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugUtilsLabelEXTBuilder<'b> {
    type Target = DebugUtilsLabelEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugUtilsMessengerCallbackDataEXT {
    type Target = DebugUtilsMessengerCallbackDataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugUtilsMessengerCallbackDataEXT {
    type Builder = DebugUtilsMessengerCallbackDataEXTBuilder<'b>;
}

/// A builder for a [`DebugUtilsMessengerCallbackDataEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugUtilsMessengerCallbackDataEXTBuilder<'b> {
    value: DebugUtilsMessengerCallbackDataEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugUtilsMessengerCallbackDataEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DebugUtilsMessengerCallbackDataFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn message_id_name(mut self, message_id_name: &'b [u8]) -> Self {
        self.value.message_id_name = message_id_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn message_id_number(mut self, message_id_number: i32) -> Self {
        self.value.message_id_number = message_id_number;
        self
    }

    #[inline]
    pub fn message(mut self, message: &'b [u8]) -> Self {
        self.value.message = message.as_ptr().cast();
        self
    }

    #[inline]
    pub fn queue_labels(
        mut self,
        queue_labels: &'b [impl Cast<Target = DebugUtilsLabelEXT>],
    ) -> Self {
        self.value.queue_label_count = queue_labels.len() as u32;
        self.value.queue_labels = queue_labels.as_ptr().cast();
        self
    }

    #[inline]
    pub fn cmd_buf_labels(
        mut self,
        cmd_buf_labels: &'b [impl Cast<Target = DebugUtilsLabelEXT>],
    ) -> Self {
        self.value.cmd_buf_label_count = cmd_buf_labels.len() as u32;
        self.value.cmd_buf_labels = cmd_buf_labels.as_ptr().cast();
        self
    }

    #[inline]
    pub fn objects(
        mut self,
        objects: &'b [impl Cast<Target = DebugUtilsObjectNameInfoEXT>],
    ) -> Self {
        self.value.object_count = objects.len() as u32;
        self.value.objects = objects.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugUtilsMessengerCallbackDataEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugUtilsMessengerCallbackDataEXTBuilder<'b> {
    type Target = DebugUtilsMessengerCallbackDataEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugUtilsMessengerCallbackDataEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugUtilsMessengerCallbackDataEXTBuilder<'b> {
    type Target = DebugUtilsMessengerCallbackDataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugUtilsMessengerCreateInfoEXT {
    type Target = DebugUtilsMessengerCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugUtilsMessengerCreateInfoEXT {
    type Builder = DebugUtilsMessengerCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugUtilsMessengerCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugUtilsMessengerCreateInfoEXTBuilder<'b> {
    value: DebugUtilsMessengerCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugUtilsMessengerCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DebugUtilsMessengerCreateFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn message_severity(mut self, message_severity: DebugUtilsMessageSeverityFlagsEXT) -> Self {
        self.value.message_severity = message_severity;
        self
    }

    #[inline]
    pub fn message_type(mut self, message_type: DebugUtilsMessageTypeFlagsEXT) -> Self {
        self.value.message_type = message_type;
        self
    }

    #[inline]
    pub fn user_callback(mut self, user_callback: PFN_vkDebugUtilsMessengerCallbackEXT) -> Self {
        self.value.user_callback = user_callback;
        self
    }

    #[inline]
    pub fn user_data<T>(mut self, user_data: &'b mut T) -> Self {
        self.value.user_data = (user_data as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugUtilsMessengerCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugUtilsMessengerCreateInfoEXTBuilder<'b> {
    type Target = DebugUtilsMessengerCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugUtilsMessengerCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugUtilsMessengerCreateInfoEXTBuilder<'b> {
    type Target = DebugUtilsMessengerCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugUtilsObjectNameInfoEXT {
    type Target = DebugUtilsObjectNameInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugUtilsObjectNameInfoEXT {
    type Builder = DebugUtilsObjectNameInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugUtilsObjectNameInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugUtilsObjectNameInfoEXTBuilder<'b> {
    value: DebugUtilsObjectNameInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugUtilsObjectNameInfoEXTBuilder<'b> {
    #[inline]
    pub fn object_type(mut self, object_type: ObjectType) -> Self {
        self.value.object_type = object_type;
        self
    }

    #[inline]
    pub fn object_handle(mut self, object_handle: u64) -> Self {
        self.value.object_handle = object_handle;
        self
    }

    #[inline]
    pub fn object_name(mut self, object_name: &'b [u8]) -> Self {
        self.value.object_name = object_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugUtilsObjectNameInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugUtilsObjectNameInfoEXTBuilder<'b> {
    type Target = DebugUtilsObjectNameInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugUtilsObjectNameInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugUtilsObjectNameInfoEXTBuilder<'b> {
    type Target = DebugUtilsObjectNameInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DebugUtilsObjectTagInfoEXT {
    type Target = DebugUtilsObjectTagInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DebugUtilsObjectTagInfoEXT {
    type Builder = DebugUtilsObjectTagInfoEXTBuilder<'b>;
}

/// A builder for a [`DebugUtilsObjectTagInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DebugUtilsObjectTagInfoEXTBuilder<'b> {
    value: DebugUtilsObjectTagInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DebugUtilsObjectTagInfoEXTBuilder<'b> {
    #[inline]
    pub fn object_type(mut self, object_type: ObjectType) -> Self {
        self.value.object_type = object_type;
        self
    }

    #[inline]
    pub fn object_handle(mut self, object_handle: u64) -> Self {
        self.value.object_handle = object_handle;
        self
    }

    #[inline]
    pub fn tag_name(mut self, tag_name: u64) -> Self {
        self.value.tag_name = tag_name;
        self
    }

    #[inline]
    pub fn tag(mut self, tag: &'b [u8]) -> Self {
        self.value.tag_size = tag.len() as usize;
        self.value.tag = tag.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DebugUtilsObjectTagInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DebugUtilsObjectTagInfoEXTBuilder<'b> {
    type Target = DebugUtilsObjectTagInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DebugUtilsObjectTagInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DebugUtilsObjectTagInfoEXTBuilder<'b> {
    type Target = DebugUtilsObjectTagInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DedicatedAllocationBufferCreateInfoNV {
    type Target = DedicatedAllocationBufferCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DedicatedAllocationBufferCreateInfoNV {
    type Builder = DedicatedAllocationBufferCreateInfoNVBuilder;
}

/// A builder for a [`DedicatedAllocationBufferCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DedicatedAllocationBufferCreateInfoNVBuilder {
    value: DedicatedAllocationBufferCreateInfoNV,
}

impl DedicatedAllocationBufferCreateInfoNVBuilder {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.value.dedicated_allocation = dedicated_allocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DedicatedAllocationBufferCreateInfoNV {
        self.value
    }
}

impl ops::Deref for DedicatedAllocationBufferCreateInfoNVBuilder {
    type Target = DedicatedAllocationBufferCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DedicatedAllocationBufferCreateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DedicatedAllocationBufferCreateInfoNVBuilder {
    type Target = DedicatedAllocationBufferCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DedicatedAllocationImageCreateInfoNV {
    type Target = DedicatedAllocationImageCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DedicatedAllocationImageCreateInfoNV {
    type Builder = DedicatedAllocationImageCreateInfoNVBuilder;
}

/// A builder for a [`DedicatedAllocationImageCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DedicatedAllocationImageCreateInfoNVBuilder {
    value: DedicatedAllocationImageCreateInfoNV,
}

impl DedicatedAllocationImageCreateInfoNVBuilder {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.value.dedicated_allocation = dedicated_allocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DedicatedAllocationImageCreateInfoNV {
        self.value
    }
}

impl ops::Deref for DedicatedAllocationImageCreateInfoNVBuilder {
    type Target = DedicatedAllocationImageCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DedicatedAllocationImageCreateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DedicatedAllocationImageCreateInfoNVBuilder {
    type Target = DedicatedAllocationImageCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DedicatedAllocationMemoryAllocateInfoNV {
    type Target = DedicatedAllocationMemoryAllocateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DedicatedAllocationMemoryAllocateInfoNV {
    type Builder = DedicatedAllocationMemoryAllocateInfoNVBuilder;
}

/// A builder for a [`DedicatedAllocationMemoryAllocateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DedicatedAllocationMemoryAllocateInfoNVBuilder {
    value: DedicatedAllocationMemoryAllocateInfoNV,
}

impl DedicatedAllocationMemoryAllocateInfoNVBuilder {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn build(self) -> DedicatedAllocationMemoryAllocateInfoNV {
        self.value
    }
}

impl ops::Deref for DedicatedAllocationMemoryAllocateInfoNVBuilder {
    type Target = DedicatedAllocationMemoryAllocateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DedicatedAllocationMemoryAllocateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DedicatedAllocationMemoryAllocateInfoNVBuilder {
    type Target = DedicatedAllocationMemoryAllocateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DependencyInfoKHR {
    type Target = DependencyInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DependencyInfoKHR {
    type Builder = DependencyInfoKHRBuilder<'b>;
}

/// A builder for a [`DependencyInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DependencyInfoKHRBuilder<'b> {
    value: DependencyInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DependencyInfoKHRBuilder<'b> {
    #[inline]
    pub fn dependency_flags(mut self, dependency_flags: DependencyFlags) -> Self {
        self.value.dependency_flags = dependency_flags;
        self
    }

    #[inline]
    pub fn memory_barriers(
        mut self,
        memory_barriers: &'b [impl Cast<Target = MemoryBarrier2KHR>],
    ) -> Self {
        self.value.memory_barrier_count = memory_barriers.len() as u32;
        self.value.memory_barriers = memory_barriers.as_ptr().cast();
        self
    }

    #[inline]
    pub fn buffer_memory_barriers(
        mut self,
        buffer_memory_barriers: &'b [impl Cast<Target = BufferMemoryBarrier2KHR>],
    ) -> Self {
        self.value.buffer_memory_barrier_count = buffer_memory_barriers.len() as u32;
        self.value.buffer_memory_barriers = buffer_memory_barriers.as_ptr().cast();
        self
    }

    #[inline]
    pub fn image_memory_barriers(
        mut self,
        image_memory_barriers: &'b [impl Cast<Target = ImageMemoryBarrier2KHR>],
    ) -> Self {
        self.value.image_memory_barrier_count = image_memory_barriers.len() as u32;
        self.value.image_memory_barriers = image_memory_barriers.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DependencyInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for DependencyInfoKHRBuilder<'b> {
    type Target = DependencyInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DependencyInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DependencyInfoKHRBuilder<'b> {
    type Target = DependencyInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorBufferInfo {
    type Target = DescriptorBufferInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorBufferInfo {
    type Builder = DescriptorBufferInfoBuilder;
}

/// A builder for a [`DescriptorBufferInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorBufferInfoBuilder {
    value: DescriptorBufferInfo,
}

impl DescriptorBufferInfoBuilder {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.value.range = range;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorBufferInfo {
        self.value
    }
}

impl ops::Deref for DescriptorBufferInfoBuilder {
    type Target = DescriptorBufferInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorBufferInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorBufferInfoBuilder {
    type Target = DescriptorBufferInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorImageInfo {
    type Target = DescriptorImageInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorImageInfo {
    type Builder = DescriptorImageInfoBuilder;
}

/// A builder for a [`DescriptorImageInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorImageInfoBuilder {
    value: DescriptorImageInfo,
}

impl DescriptorImageInfoBuilder {
    #[inline]
    pub fn sampler(mut self, sampler: Sampler) -> Self {
        self.value.sampler = sampler;
        self
    }

    #[inline]
    pub fn image_view(mut self, image_view: ImageView) -> Self {
        self.value.image_view = image_view;
        self
    }

    #[inline]
    pub fn image_layout(mut self, image_layout: ImageLayout) -> Self {
        self.value.image_layout = image_layout;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorImageInfo {
        self.value
    }
}

impl ops::Deref for DescriptorImageInfoBuilder {
    type Target = DescriptorImageInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorImageInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorImageInfoBuilder {
    type Target = DescriptorImageInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DescriptorPoolCreateInfo`].
pub unsafe trait ExtendsDescriptorPoolCreateInfo: fmt::Debug {}
unsafe impl ExtendsDescriptorPoolCreateInfo for DescriptorPoolInlineUniformBlockCreateInfoEXT {}
unsafe impl ExtendsDescriptorPoolCreateInfo for MutableDescriptorTypeCreateInfoVALVE {}

unsafe impl Cast for DescriptorPoolCreateInfo {
    type Target = DescriptorPoolCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorPoolCreateInfo {
    type Builder = DescriptorPoolCreateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorPoolCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorPoolCreateInfoBuilder<'b> {
    value: DescriptorPoolCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorPoolCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDescriptorPoolCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<DescriptorPoolCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: DescriptorPoolCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn max_sets(mut self, max_sets: u32) -> Self {
        self.value.max_sets = max_sets;
        self
    }

    #[inline]
    pub fn pool_sizes(mut self, pool_sizes: &'b [impl Cast<Target = DescriptorPoolSize>]) -> Self {
        self.value.pool_size_count = pool_sizes.len() as u32;
        self.value.pool_sizes = pool_sizes.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorPoolCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorPoolCreateInfoBuilder<'b> {
    type Target = DescriptorPoolCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorPoolCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorPoolCreateInfoBuilder<'b> {
    type Target = DescriptorPoolCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorPoolInlineUniformBlockCreateInfoEXT {
    type Target = DescriptorPoolInlineUniformBlockCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorPoolInlineUniformBlockCreateInfoEXT {
    type Builder = DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder;
}

/// A builder for a [`DescriptorPoolInlineUniformBlockCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder {
    value: DescriptorPoolInlineUniformBlockCreateInfoEXT,
}

impl DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder {
    #[inline]
    pub fn max_inline_uniform_block_bindings(
        mut self,
        max_inline_uniform_block_bindings: u32,
    ) -> Self {
        self.value.max_inline_uniform_block_bindings = max_inline_uniform_block_bindings;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorPoolInlineUniformBlockCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder {
    type Target = DescriptorPoolInlineUniformBlockCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorPoolInlineUniformBlockCreateInfoEXTBuilder {
    type Target = DescriptorPoolInlineUniformBlockCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorPoolSize {
    type Target = DescriptorPoolSize;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorPoolSize {
    type Builder = DescriptorPoolSizeBuilder;
}

/// A builder for a [`DescriptorPoolSize`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorPoolSizeBuilder {
    value: DescriptorPoolSize,
}

impl DescriptorPoolSizeBuilder {
    #[inline]
    pub fn type_(mut self, type_: DescriptorType) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.value.descriptor_count = descriptor_count;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorPoolSize {
        self.value
    }
}

impl ops::Deref for DescriptorPoolSizeBuilder {
    type Target = DescriptorPoolSize;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorPoolSizeBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorPoolSizeBuilder {
    type Target = DescriptorPoolSize;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DescriptorSetAllocateInfo`].
pub unsafe trait ExtendsDescriptorSetAllocateInfo: fmt::Debug {}
unsafe impl ExtendsDescriptorSetAllocateInfo for DescriptorSetVariableDescriptorCountAllocateInfo {}

unsafe impl Cast for DescriptorSetAllocateInfo {
    type Target = DescriptorSetAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetAllocateInfo {
    type Builder = DescriptorSetAllocateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorSetAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetAllocateInfoBuilder<'b> {
    value: DescriptorSetAllocateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetAllocateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDescriptorSetAllocateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<DescriptorSetAllocateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn descriptor_pool(mut self, descriptor_pool: DescriptorPool) -> Self {
        self.value.descriptor_pool = descriptor_pool;
        self
    }

    #[inline]
    pub fn set_layouts(mut self, set_layouts: &'b [DescriptorSetLayout]) -> Self {
        self.value.descriptor_set_count = set_layouts.len() as u32;
        self.value.set_layouts = set_layouts.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetAllocateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetAllocateInfoBuilder<'b> {
    type Target = DescriptorSetAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetAllocateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetAllocateInfoBuilder<'b> {
    type Target = DescriptorSetAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorSetLayoutBinding {
    type Target = DescriptorSetLayoutBinding;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetLayoutBinding {
    type Builder = DescriptorSetLayoutBindingBuilder<'b>;
}

/// A builder for a [`DescriptorSetLayoutBinding`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetLayoutBindingBuilder<'b> {
    value: DescriptorSetLayoutBinding,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetLayoutBindingBuilder<'b> {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.value.binding = binding;
        self
    }

    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.value.descriptor_type = descriptor_type;
        self
    }

    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.value.descriptor_count = descriptor_count;
        self
    }

    #[inline]
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> Self {
        self.value.stage_flags = stage_flags;
        self
    }

    #[inline]
    pub fn immutable_samplers(mut self, immutable_samplers: &'b [Sampler]) -> Self {
        self.value.descriptor_count = immutable_samplers.len() as u32;
        self.value.immutable_samplers = immutable_samplers.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetLayoutBinding {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetLayoutBindingBuilder<'b> {
    type Target = DescriptorSetLayoutBinding;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetLayoutBindingBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetLayoutBindingBuilder<'b> {
    type Target = DescriptorSetLayoutBinding;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorSetLayoutBindingFlagsCreateInfo {
    type Target = DescriptorSetLayoutBindingFlagsCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetLayoutBindingFlagsCreateInfo {
    type Builder = DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorSetLayoutBindingFlagsCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b> {
    value: DescriptorSetLayoutBindingFlagsCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b> {
    #[inline]
    pub fn binding_flags(mut self, binding_flags: &'b [DescriptorBindingFlags]) -> Self {
        self.value.binding_count = binding_flags.len() as u32;
        self.value.binding_flags = binding_flags.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetLayoutBindingFlagsCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b> {
    type Target = DescriptorSetLayoutBindingFlagsCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetLayoutBindingFlagsCreateInfoBuilder<'b> {
    type Target = DescriptorSetLayoutBindingFlagsCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DescriptorSetLayoutCreateInfo`].
pub unsafe trait ExtendsDescriptorSetLayoutCreateInfo: fmt::Debug {}
unsafe impl ExtendsDescriptorSetLayoutCreateInfo for DescriptorSetLayoutBindingFlagsCreateInfo {}
unsafe impl ExtendsDescriptorSetLayoutCreateInfo for MutableDescriptorTypeCreateInfoVALVE {}

unsafe impl Cast for DescriptorSetLayoutCreateInfo {
    type Target = DescriptorSetLayoutCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetLayoutCreateInfo {
    type Builder = DescriptorSetLayoutCreateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorSetLayoutCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetLayoutCreateInfoBuilder<'b> {
    value: DescriptorSetLayoutCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetLayoutCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDescriptorSetLayoutCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<DescriptorSetLayoutCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: DescriptorSetLayoutCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn bindings(
        mut self,
        bindings: &'b [impl Cast<Target = DescriptorSetLayoutBinding>],
    ) -> Self {
        self.value.binding_count = bindings.len() as u32;
        self.value.bindings = bindings.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetLayoutCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetLayoutCreateInfoBuilder<'b> {
    type Target = DescriptorSetLayoutCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetLayoutCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetLayoutCreateInfoBuilder<'b> {
    type Target = DescriptorSetLayoutCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DescriptorSetLayoutSupport`].
pub unsafe trait ExtendsDescriptorSetLayoutSupport: fmt::Debug {}
unsafe impl ExtendsDescriptorSetLayoutSupport
    for DescriptorSetVariableDescriptorCountLayoutSupport
{
}

unsafe impl Cast for DescriptorSetLayoutSupport {
    type Target = DescriptorSetLayoutSupport;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetLayoutSupport {
    type Builder = DescriptorSetLayoutSupportBuilder<'b>;
}

/// A builder for a [`DescriptorSetLayoutSupport`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetLayoutSupportBuilder<'b> {
    value: DescriptorSetLayoutSupport,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetLayoutSupportBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDescriptorSetLayoutSupport,
    {
        let next = (next.as_mut() as *mut T).cast::<DescriptorSetLayoutSupport>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn supported(mut self, supported: bool) -> Self {
        self.value.supported = supported as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetLayoutSupport {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetLayoutSupportBuilder<'b> {
    type Target = DescriptorSetLayoutSupport;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetLayoutSupportBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetLayoutSupportBuilder<'b> {
    type Target = DescriptorSetLayoutSupport;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorSetVariableDescriptorCountAllocateInfo {
    type Target = DescriptorSetVariableDescriptorCountAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorSetVariableDescriptorCountAllocateInfo {
    type Builder = DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorSetVariableDescriptorCountAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b> {
    value: DescriptorSetVariableDescriptorCountAllocateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b> {
    #[inline]
    pub fn descriptor_counts(mut self, descriptor_counts: &'b [u32]) -> Self {
        self.value.descriptor_set_count = descriptor_counts.len() as u32;
        self.value.descriptor_counts = descriptor_counts.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetVariableDescriptorCountAllocateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b> {
    type Target = DescriptorSetVariableDescriptorCountAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorSetVariableDescriptorCountAllocateInfoBuilder<'b> {
    type Target = DescriptorSetVariableDescriptorCountAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorSetVariableDescriptorCountLayoutSupport {
    type Target = DescriptorSetVariableDescriptorCountLayoutSupport;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorSetVariableDescriptorCountLayoutSupport {
    type Builder = DescriptorSetVariableDescriptorCountLayoutSupportBuilder;
}

/// A builder for a [`DescriptorSetVariableDescriptorCountLayoutSupport`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorSetVariableDescriptorCountLayoutSupportBuilder {
    value: DescriptorSetVariableDescriptorCountLayoutSupport,
}

impl DescriptorSetVariableDescriptorCountLayoutSupportBuilder {
    #[inline]
    pub fn max_variable_descriptor_count(mut self, max_variable_descriptor_count: u32) -> Self {
        self.value.max_variable_descriptor_count = max_variable_descriptor_count;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorSetVariableDescriptorCountLayoutSupport {
        self.value
    }
}

impl ops::Deref for DescriptorSetVariableDescriptorCountLayoutSupportBuilder {
    type Target = DescriptorSetVariableDescriptorCountLayoutSupport;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorSetVariableDescriptorCountLayoutSupportBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorSetVariableDescriptorCountLayoutSupportBuilder {
    type Target = DescriptorSetVariableDescriptorCountLayoutSupport;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorUpdateTemplateCreateInfo {
    type Target = DescriptorUpdateTemplateCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DescriptorUpdateTemplateCreateInfo {
    type Builder = DescriptorUpdateTemplateCreateInfoBuilder<'b>;
}

/// A builder for a [`DescriptorUpdateTemplateCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorUpdateTemplateCreateInfoBuilder<'b> {
    value: DescriptorUpdateTemplateCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DescriptorUpdateTemplateCreateInfoBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorUpdateTemplateCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn descriptor_update_entries(
        mut self,
        descriptor_update_entries: &'b [impl Cast<Target = DescriptorUpdateTemplateEntry>],
    ) -> Self {
        self.value.descriptor_update_entry_count = descriptor_update_entries.len() as u32;
        self.value.descriptor_update_entries = descriptor_update_entries.as_ptr().cast();
        self
    }

    #[inline]
    pub fn template_type(mut self, template_type: DescriptorUpdateTemplateType) -> Self {
        self.value.template_type = template_type;
        self
    }

    #[inline]
    pub fn descriptor_set_layout(mut self, descriptor_set_layout: DescriptorSetLayout) -> Self {
        self.value.descriptor_set_layout = descriptor_set_layout;
        self
    }

    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.value.pipeline_bind_point = pipeline_bind_point;
        self
    }

    #[inline]
    pub fn pipeline_layout(mut self, pipeline_layout: PipelineLayout) -> Self {
        self.value.pipeline_layout = pipeline_layout;
        self
    }

    #[inline]
    pub fn set(mut self, set: u32) -> Self {
        self.value.set = set;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorUpdateTemplateCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DescriptorUpdateTemplateCreateInfoBuilder<'b> {
    type Target = DescriptorUpdateTemplateCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DescriptorUpdateTemplateCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DescriptorUpdateTemplateCreateInfoBuilder<'b> {
    type Target = DescriptorUpdateTemplateCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DescriptorUpdateTemplateEntry {
    type Target = DescriptorUpdateTemplateEntry;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DescriptorUpdateTemplateEntry {
    type Builder = DescriptorUpdateTemplateEntryBuilder;
}

/// A builder for a [`DescriptorUpdateTemplateEntry`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DescriptorUpdateTemplateEntryBuilder {
    value: DescriptorUpdateTemplateEntry,
}

impl DescriptorUpdateTemplateEntryBuilder {
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.value.dst_binding = dst_binding;
        self
    }

    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.value.dst_array_element = dst_array_element;
        self
    }

    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.value.descriptor_count = descriptor_count;
        self
    }

    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.value.descriptor_type = descriptor_type;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: usize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn stride(mut self, stride: usize) -> Self {
        self.value.stride = stride;
        self
    }

    #[inline]
    pub fn build(self) -> DescriptorUpdateTemplateEntry {
        self.value
    }
}

impl ops::Deref for DescriptorUpdateTemplateEntryBuilder {
    type Target = DescriptorUpdateTemplateEntry;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DescriptorUpdateTemplateEntryBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DescriptorUpdateTemplateEntryBuilder {
    type Target = DescriptorUpdateTemplateEntry;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DeviceCreateInfo`].
pub unsafe trait ExtendsDeviceCreateInfo: fmt::Debug {}
unsafe impl ExtendsDeviceCreateInfo for DeviceDeviceMemoryReportCreateInfoEXT {}
unsafe impl ExtendsDeviceCreateInfo for DeviceDiagnosticsConfigCreateInfoNV {}
unsafe impl ExtendsDeviceCreateInfo for DeviceGroupDeviceCreateInfo {}
unsafe impl ExtendsDeviceCreateInfo for DeviceMemoryOverallocationCreateInfoAMD {}
unsafe impl ExtendsDeviceCreateInfo for DevicePrivateDataCreateInfoEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice16BitStorageFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice4444FormatsFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice8BitStorageFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceASTCDecodeFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceAccelerationStructureFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBufferDeviceAddressFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBufferDeviceAddressFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCoherentMemoryFeaturesAMD {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceColorWriteEnableFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceComputeShaderDerivativesFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceConditionalRenderingFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCooperativeMatrixFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCornerSampledImageFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCoverageReductionModeFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCustomBorderColorFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDepthClipEnableFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDescriptorIndexingFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceMemoryReportFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDiagnosticsConfigFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceExclusiveScissorFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceExtendedDynamicState2FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceExtendedDynamicStateFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceExternalMemoryRDMAFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2 {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentDensityMap2FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentDensityMapFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentShaderBarycentricFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentShaderInterlockFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentShadingRateFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceGlobalPriorityQueryFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceHostQueryResetFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceImageRobustnessFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceImagelessFramebufferFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceIndexTypeUint8FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInheritedViewportScissorFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInlineUniformBlockFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInvocationMaskFeaturesHUAWEI {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceLineRasterizationFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMemoryPriorityFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMeshShaderFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiDrawFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiviewFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePerformanceQueryFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePipelineCreationCacheControlFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePortabilitySubsetFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentIdFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentWaitFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePrivateDataFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceProtectedMemoryFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceProvokingVertexFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayQueryFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayTracingMotionBlurFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayTracingPipelineFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRepresentativeFragmentTestFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRobustness2FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSamplerYcbcrConversionFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceScalarBlockLayoutFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicFloat2FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicFloatFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicInt64Features {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderClockFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderDrawParametersFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderFloat16Int8Features {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderImageFootprintFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderIntegerDotProductFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderSMBuiltinsFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderTerminateInvocationFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShadingRateImageFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSubgroupSizeControlFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSubpassShadingFeaturesHUAWEI {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSynchronization2FeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTexelBufferAlignmentFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTimelineSemaphoreFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTransformFeedbackFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceUniformBufferStandardLayoutFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVertexAttributeDivisorFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVertexInputDynamicStateFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVulkan11Features {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVulkan12Features {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVulkanMemoryModelFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceYcbcrImageArraysFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {}

unsafe impl Cast for DeviceCreateInfo {
    type Target = DeviceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceCreateInfo {
    type Builder = DeviceCreateInfoBuilder<'b>;
}

/// A builder for a [`DeviceCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceCreateInfoBuilder<'b> {
    value: DeviceCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDeviceCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<DeviceCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: DeviceCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn queue_create_infos(
        mut self,
        queue_create_infos: &'b [impl Cast<Target = DeviceQueueCreateInfo>],
    ) -> Self {
        self.value.queue_create_info_count = queue_create_infos.len() as u32;
        self.value.queue_create_infos = queue_create_infos.as_ptr().cast();
        self
    }

    #[inline]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'b [*const c_char]) -> Self {
        self.value.enabled_layer_count = enabled_layer_names.len() as u32;
        self.value.enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }

    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'b [*const c_char]) -> Self {
        self.value.enabled_extension_count = enabled_extension_names.len() as u32;
        self.value.enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }

    #[inline]
    pub fn enabled_features(
        mut self,
        enabled_features: &'b impl Cast<Target = PhysicalDeviceFeatures>,
    ) -> Self {
        self.value.enabled_features = enabled_features.as_ref();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DeviceCreateInfoBuilder<'b> {
    type Target = DeviceCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceCreateInfoBuilder<'b> {
    type Target = DeviceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceDeviceMemoryReportCreateInfoEXT {
    type Target = DeviceDeviceMemoryReportCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceDeviceMemoryReportCreateInfoEXT {
    type Builder = DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`DeviceDeviceMemoryReportCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b> {
    value: DeviceDeviceMemoryReportCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DeviceMemoryReportFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn user_callback(mut self, user_callback: PFN_vkDeviceMemoryReportCallbackEXT) -> Self {
        self.value.user_callback = user_callback;
        self
    }

    #[inline]
    pub fn user_data<T>(mut self, user_data: &'b mut T) -> Self {
        self.value.user_data = (user_data as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceDeviceMemoryReportCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b> {
    type Target = DeviceDeviceMemoryReportCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceDeviceMemoryReportCreateInfoEXTBuilder<'b> {
    type Target = DeviceDeviceMemoryReportCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceDiagnosticsConfigCreateInfoNV {
    type Target = DeviceDiagnosticsConfigCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceDiagnosticsConfigCreateInfoNV {
    type Builder = DeviceDiagnosticsConfigCreateInfoNVBuilder;
}

/// A builder for a [`DeviceDiagnosticsConfigCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceDiagnosticsConfigCreateInfoNVBuilder {
    value: DeviceDiagnosticsConfigCreateInfoNV,
}

impl DeviceDiagnosticsConfigCreateInfoNVBuilder {
    #[inline]
    pub fn flags(mut self, flags: DeviceDiagnosticsConfigFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceDiagnosticsConfigCreateInfoNV {
        self.value
    }
}

impl ops::Deref for DeviceDiagnosticsConfigCreateInfoNVBuilder {
    type Target = DeviceDiagnosticsConfigCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceDiagnosticsConfigCreateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceDiagnosticsConfigCreateInfoNVBuilder {
    type Target = DeviceDiagnosticsConfigCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceEventInfoEXT {
    type Target = DeviceEventInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceEventInfoEXT {
    type Builder = DeviceEventInfoEXTBuilder;
}

/// A builder for a [`DeviceEventInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceEventInfoEXTBuilder {
    value: DeviceEventInfoEXT,
}

impl DeviceEventInfoEXTBuilder {
    #[inline]
    pub fn device_event(mut self, device_event: DeviceEventTypeEXT) -> Self {
        self.value.device_event = device_event;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceEventInfoEXT {
        self.value
    }
}

impl ops::Deref for DeviceEventInfoEXTBuilder {
    type Target = DeviceEventInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceEventInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceEventInfoEXTBuilder {
    type Target = DeviceEventInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupBindSparseInfo {
    type Target = DeviceGroupBindSparseInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceGroupBindSparseInfo {
    type Builder = DeviceGroupBindSparseInfoBuilder;
}

/// A builder for a [`DeviceGroupBindSparseInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupBindSparseInfoBuilder {
    value: DeviceGroupBindSparseInfo,
}

impl DeviceGroupBindSparseInfoBuilder {
    #[inline]
    pub fn resource_device_index(mut self, resource_device_index: u32) -> Self {
        self.value.resource_device_index = resource_device_index;
        self
    }

    #[inline]
    pub fn memory_device_index(mut self, memory_device_index: u32) -> Self {
        self.value.memory_device_index = memory_device_index;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupBindSparseInfo {
        self.value
    }
}

impl ops::Deref for DeviceGroupBindSparseInfoBuilder {
    type Target = DeviceGroupBindSparseInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceGroupBindSparseInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceGroupBindSparseInfoBuilder {
    type Target = DeviceGroupBindSparseInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupCommandBufferBeginInfo {
    type Target = DeviceGroupCommandBufferBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceGroupCommandBufferBeginInfo {
    type Builder = DeviceGroupCommandBufferBeginInfoBuilder;
}

/// A builder for a [`DeviceGroupCommandBufferBeginInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupCommandBufferBeginInfoBuilder {
    value: DeviceGroupCommandBufferBeginInfo,
}

impl DeviceGroupCommandBufferBeginInfoBuilder {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.value.device_mask = device_mask;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupCommandBufferBeginInfo {
        self.value
    }
}

impl ops::Deref for DeviceGroupCommandBufferBeginInfoBuilder {
    type Target = DeviceGroupCommandBufferBeginInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceGroupCommandBufferBeginInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceGroupCommandBufferBeginInfoBuilder {
    type Target = DeviceGroupCommandBufferBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupDeviceCreateInfo {
    type Target = DeviceGroupDeviceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceGroupDeviceCreateInfo {
    type Builder = DeviceGroupDeviceCreateInfoBuilder<'b>;
}

/// A builder for a [`DeviceGroupDeviceCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupDeviceCreateInfoBuilder<'b> {
    value: DeviceGroupDeviceCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceGroupDeviceCreateInfoBuilder<'b> {
    #[inline]
    pub fn physical_devices(mut self, physical_devices: &'b [PhysicalDevice]) -> Self {
        self.value.physical_device_count = physical_devices.len() as u32;
        self.value.physical_devices = physical_devices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupDeviceCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DeviceGroupDeviceCreateInfoBuilder<'b> {
    type Target = DeviceGroupDeviceCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceGroupDeviceCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceGroupDeviceCreateInfoBuilder<'b> {
    type Target = DeviceGroupDeviceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupPresentCapabilitiesKHR {
    type Target = DeviceGroupPresentCapabilitiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceGroupPresentCapabilitiesKHR {
    type Builder = DeviceGroupPresentCapabilitiesKHRBuilder;
}

/// A builder for a [`DeviceGroupPresentCapabilitiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupPresentCapabilitiesKHRBuilder {
    value: DeviceGroupPresentCapabilitiesKHR,
}

impl DeviceGroupPresentCapabilitiesKHRBuilder {
    #[inline]
    pub fn present_mask(mut self, present_mask: [u32; MAX_DEVICE_GROUP_SIZE]) -> Self {
        self.value.present_mask = present_mask;
        self
    }

    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.value.modes = modes;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupPresentCapabilitiesKHR {
        self.value
    }
}

impl ops::Deref for DeviceGroupPresentCapabilitiesKHRBuilder {
    type Target = DeviceGroupPresentCapabilitiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceGroupPresentCapabilitiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceGroupPresentCapabilitiesKHRBuilder {
    type Target = DeviceGroupPresentCapabilitiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupPresentInfoKHR {
    type Target = DeviceGroupPresentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceGroupPresentInfoKHR {
    type Builder = DeviceGroupPresentInfoKHRBuilder<'b>;
}

/// A builder for a [`DeviceGroupPresentInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupPresentInfoKHRBuilder<'b> {
    value: DeviceGroupPresentInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceGroupPresentInfoKHRBuilder<'b> {
    #[inline]
    pub fn device_masks(mut self, device_masks: &'b [u32]) -> Self {
        self.value.swapchain_count = device_masks.len() as u32;
        self.value.device_masks = device_masks.as_ptr();
        self
    }

    #[inline]
    pub fn mode(mut self, mode: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupPresentInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for DeviceGroupPresentInfoKHRBuilder<'b> {
    type Target = DeviceGroupPresentInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceGroupPresentInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceGroupPresentInfoKHRBuilder<'b> {
    type Target = DeviceGroupPresentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupRenderPassBeginInfo {
    type Target = DeviceGroupRenderPassBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceGroupRenderPassBeginInfo {
    type Builder = DeviceGroupRenderPassBeginInfoBuilder<'b>;
}

/// A builder for a [`DeviceGroupRenderPassBeginInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupRenderPassBeginInfoBuilder<'b> {
    value: DeviceGroupRenderPassBeginInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceGroupRenderPassBeginInfoBuilder<'b> {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.value.device_mask = device_mask;
        self
    }

    #[inline]
    pub fn device_render_areas(
        mut self,
        device_render_areas: &'b [impl Cast<Target = Rect2D>],
    ) -> Self {
        self.value.device_render_area_count = device_render_areas.len() as u32;
        self.value.device_render_areas = device_render_areas.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupRenderPassBeginInfo {
        self.value
    }
}

impl<'b> ops::Deref for DeviceGroupRenderPassBeginInfoBuilder<'b> {
    type Target = DeviceGroupRenderPassBeginInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceGroupRenderPassBeginInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceGroupRenderPassBeginInfoBuilder<'b> {
    type Target = DeviceGroupRenderPassBeginInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupSubmitInfo {
    type Target = DeviceGroupSubmitInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceGroupSubmitInfo {
    type Builder = DeviceGroupSubmitInfoBuilder<'b>;
}

/// A builder for a [`DeviceGroupSubmitInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupSubmitInfoBuilder<'b> {
    value: DeviceGroupSubmitInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceGroupSubmitInfoBuilder<'b> {
    #[inline]
    pub fn wait_semaphore_device_indices(
        mut self,
        wait_semaphore_device_indices: &'b [u32],
    ) -> Self {
        self.value.wait_semaphore_count = wait_semaphore_device_indices.len() as u32;
        self.value.wait_semaphore_device_indices = wait_semaphore_device_indices.as_ptr();
        self
    }

    #[inline]
    pub fn command_buffer_device_masks(mut self, command_buffer_device_masks: &'b [u32]) -> Self {
        self.value.command_buffer_count = command_buffer_device_masks.len() as u32;
        self.value.command_buffer_device_masks = command_buffer_device_masks.as_ptr();
        self
    }

    #[inline]
    pub fn signal_semaphore_device_indices(
        mut self,
        signal_semaphore_device_indices: &'b [u32],
    ) -> Self {
        self.value.signal_semaphore_count = signal_semaphore_device_indices.len() as u32;
        self.value.signal_semaphore_device_indices = signal_semaphore_device_indices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupSubmitInfo {
        self.value
    }
}

impl<'b> ops::Deref for DeviceGroupSubmitInfoBuilder<'b> {
    type Target = DeviceGroupSubmitInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceGroupSubmitInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceGroupSubmitInfoBuilder<'b> {
    type Target = DeviceGroupSubmitInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceGroupSwapchainCreateInfoKHR {
    type Target = DeviceGroupSwapchainCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceGroupSwapchainCreateInfoKHR {
    type Builder = DeviceGroupSwapchainCreateInfoKHRBuilder;
}

/// A builder for a [`DeviceGroupSwapchainCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceGroupSwapchainCreateInfoKHRBuilder {
    value: DeviceGroupSwapchainCreateInfoKHR,
}

impl DeviceGroupSwapchainCreateInfoKHRBuilder {
    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.value.modes = modes;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceGroupSwapchainCreateInfoKHR {
        self.value
    }
}

impl ops::Deref for DeviceGroupSwapchainCreateInfoKHRBuilder {
    type Target = DeviceGroupSwapchainCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceGroupSwapchainCreateInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceGroupSwapchainCreateInfoKHRBuilder {
    type Target = DeviceGroupSwapchainCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceMemoryOpaqueCaptureAddressInfo {
    type Target = DeviceMemoryOpaqueCaptureAddressInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceMemoryOpaqueCaptureAddressInfo {
    type Builder = DeviceMemoryOpaqueCaptureAddressInfoBuilder;
}

/// A builder for a [`DeviceMemoryOpaqueCaptureAddressInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceMemoryOpaqueCaptureAddressInfoBuilder {
    value: DeviceMemoryOpaqueCaptureAddressInfo,
}

impl DeviceMemoryOpaqueCaptureAddressInfoBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceMemoryOpaqueCaptureAddressInfo {
        self.value
    }
}

impl ops::Deref for DeviceMemoryOpaqueCaptureAddressInfoBuilder {
    type Target = DeviceMemoryOpaqueCaptureAddressInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceMemoryOpaqueCaptureAddressInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceMemoryOpaqueCaptureAddressInfoBuilder {
    type Target = DeviceMemoryOpaqueCaptureAddressInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceMemoryOverallocationCreateInfoAMD {
    type Target = DeviceMemoryOverallocationCreateInfoAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceMemoryOverallocationCreateInfoAMD {
    type Builder = DeviceMemoryOverallocationCreateInfoAMDBuilder;
}

/// A builder for a [`DeviceMemoryOverallocationCreateInfoAMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceMemoryOverallocationCreateInfoAMDBuilder {
    value: DeviceMemoryOverallocationCreateInfoAMD,
}

impl DeviceMemoryOverallocationCreateInfoAMDBuilder {
    #[inline]
    pub fn overallocation_behavior(
        mut self,
        overallocation_behavior: MemoryOverallocationBehaviorAMD,
    ) -> Self {
        self.value.overallocation_behavior = overallocation_behavior;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceMemoryOverallocationCreateInfoAMD {
        self.value
    }
}

impl ops::Deref for DeviceMemoryOverallocationCreateInfoAMDBuilder {
    type Target = DeviceMemoryOverallocationCreateInfoAMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceMemoryOverallocationCreateInfoAMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceMemoryOverallocationCreateInfoAMDBuilder {
    type Target = DeviceMemoryOverallocationCreateInfoAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceMemoryReportCallbackDataEXT {
    type Target = DeviceMemoryReportCallbackDataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceMemoryReportCallbackDataEXT {
    type Builder = DeviceMemoryReportCallbackDataEXTBuilder;
}

/// A builder for a [`DeviceMemoryReportCallbackDataEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceMemoryReportCallbackDataEXTBuilder {
    value: DeviceMemoryReportCallbackDataEXT,
}

impl DeviceMemoryReportCallbackDataEXTBuilder {
    #[inline]
    pub fn flags(mut self, flags: DeviceMemoryReportFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn type_(mut self, type_: DeviceMemoryReportEventTypeEXT) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn memory_object_id(mut self, memory_object_id: u64) -> Self {
        self.value.memory_object_id = memory_object_id;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn object_type(mut self, object_type: ObjectType) -> Self {
        self.value.object_type = object_type;
        self
    }

    #[inline]
    pub fn object_handle(mut self, object_handle: u64) -> Self {
        self.value.object_handle = object_handle;
        self
    }

    #[inline]
    pub fn heap_index(mut self, heap_index: u32) -> Self {
        self.value.heap_index = heap_index;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceMemoryReportCallbackDataEXT {
        self.value
    }
}

impl ops::Deref for DeviceMemoryReportCallbackDataEXTBuilder {
    type Target = DeviceMemoryReportCallbackDataEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceMemoryReportCallbackDataEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceMemoryReportCallbackDataEXTBuilder {
    type Target = DeviceMemoryReportCallbackDataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DevicePrivateDataCreateInfoEXT {
    type Target = DevicePrivateDataCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DevicePrivateDataCreateInfoEXT {
    type Builder = DevicePrivateDataCreateInfoEXTBuilder;
}

/// A builder for a [`DevicePrivateDataCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DevicePrivateDataCreateInfoEXTBuilder {
    value: DevicePrivateDataCreateInfoEXT,
}

impl DevicePrivateDataCreateInfoEXTBuilder {
    #[inline]
    pub fn private_data_slot_request_count(mut self, private_data_slot_request_count: u32) -> Self {
        self.value.private_data_slot_request_count = private_data_slot_request_count;
        self
    }

    #[inline]
    pub fn build(self) -> DevicePrivateDataCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for DevicePrivateDataCreateInfoEXTBuilder {
    type Target = DevicePrivateDataCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DevicePrivateDataCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DevicePrivateDataCreateInfoEXTBuilder {
    type Target = DevicePrivateDataCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`DeviceQueueCreateInfo`].
pub unsafe trait ExtendsDeviceQueueCreateInfo: fmt::Debug {}
unsafe impl ExtendsDeviceQueueCreateInfo for DeviceQueueGlobalPriorityCreateInfoEXT {}

unsafe impl Cast for DeviceQueueCreateInfo {
    type Target = DeviceQueueCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DeviceQueueCreateInfo {
    type Builder = DeviceQueueCreateInfoBuilder<'b>;
}

/// A builder for a [`DeviceQueueCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceQueueCreateInfoBuilder<'b> {
    value: DeviceQueueCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DeviceQueueCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsDeviceQueueCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<DeviceQueueCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.value.queue_family_index = queue_family_index;
        self
    }

    #[inline]
    pub fn queue_priorities(mut self, queue_priorities: &'b [f32]) -> Self {
        self.value.queue_count = queue_priorities.len() as u32;
        self.value.queue_priorities = queue_priorities.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> DeviceQueueCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for DeviceQueueCreateInfoBuilder<'b> {
    type Target = DeviceQueueCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DeviceQueueCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DeviceQueueCreateInfoBuilder<'b> {
    type Target = DeviceQueueCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceQueueGlobalPriorityCreateInfoEXT {
    type Target = DeviceQueueGlobalPriorityCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceQueueGlobalPriorityCreateInfoEXT {
    type Builder = DeviceQueueGlobalPriorityCreateInfoEXTBuilder;
}

/// A builder for a [`DeviceQueueGlobalPriorityCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceQueueGlobalPriorityCreateInfoEXTBuilder {
    value: DeviceQueueGlobalPriorityCreateInfoEXT,
}

impl DeviceQueueGlobalPriorityCreateInfoEXTBuilder {
    #[inline]
    pub fn global_priority(mut self, global_priority: QueueGlobalPriorityEXT) -> Self {
        self.value.global_priority = global_priority;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceQueueGlobalPriorityCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for DeviceQueueGlobalPriorityCreateInfoEXTBuilder {
    type Target = DeviceQueueGlobalPriorityCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceQueueGlobalPriorityCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceQueueGlobalPriorityCreateInfoEXTBuilder {
    type Target = DeviceQueueGlobalPriorityCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DeviceQueueInfo2 {
    type Target = DeviceQueueInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DeviceQueueInfo2 {
    type Builder = DeviceQueueInfo2Builder;
}

/// A builder for a [`DeviceQueueInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DeviceQueueInfo2Builder {
    value: DeviceQueueInfo2,
}

impl DeviceQueueInfo2Builder {
    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.value.queue_family_index = queue_family_index;
        self
    }

    #[inline]
    pub fn queue_index(mut self, queue_index: u32) -> Self {
        self.value.queue_index = queue_index;
        self
    }

    #[inline]
    pub fn build(self) -> DeviceQueueInfo2 {
        self.value
    }
}

impl ops::Deref for DeviceQueueInfo2Builder {
    type Target = DeviceQueueInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DeviceQueueInfo2Builder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DeviceQueueInfo2Builder {
    type Target = DeviceQueueInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DirectFBSurfaceCreateInfoEXT {
    type Target = DirectFBSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DirectFBSurfaceCreateInfoEXT {
    type Builder = DirectFBSurfaceCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`DirectFBSurfaceCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DirectFBSurfaceCreateInfoEXTBuilder<'b> {
    value: DirectFBSurfaceCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DirectFBSurfaceCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: DirectFBSurfaceCreateFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn dfb(mut self, dfb: *mut IDirectFB) -> Self {
        self.value.dfb = dfb;
        self
    }

    #[inline]
    pub fn surface(mut self, surface: *mut IDirectFBSurface) -> Self {
        self.value.surface = surface;
        self
    }

    #[inline]
    pub fn build(self) -> DirectFBSurfaceCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for DirectFBSurfaceCreateInfoEXTBuilder<'b> {
    type Target = DirectFBSurfaceCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DirectFBSurfaceCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DirectFBSurfaceCreateInfoEXTBuilder<'b> {
    type Target = DirectFBSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DispatchIndirectCommand {
    type Target = DispatchIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DispatchIndirectCommand {
    type Builder = DispatchIndirectCommandBuilder;
}

/// A builder for a [`DispatchIndirectCommand`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DispatchIndirectCommandBuilder {
    value: DispatchIndirectCommand,
}

impl DispatchIndirectCommandBuilder {
    #[inline]
    pub fn x(mut self, x: u32) -> Self {
        self.value.x = x;
        self
    }

    #[inline]
    pub fn y(mut self, y: u32) -> Self {
        self.value.y = y;
        self
    }

    #[inline]
    pub fn z(mut self, z: u32) -> Self {
        self.value.z = z;
        self
    }

    #[inline]
    pub fn build(self) -> DispatchIndirectCommand {
        self.value
    }
}

impl ops::Deref for DispatchIndirectCommandBuilder {
    type Target = DispatchIndirectCommand;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DispatchIndirectCommandBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DispatchIndirectCommandBuilder {
    type Target = DispatchIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayEventInfoEXT {
    type Target = DisplayEventInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayEventInfoEXT {
    type Builder = DisplayEventInfoEXTBuilder;
}

/// A builder for a [`DisplayEventInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayEventInfoEXTBuilder {
    value: DisplayEventInfoEXT,
}

impl DisplayEventInfoEXTBuilder {
    #[inline]
    pub fn display_event(mut self, display_event: DisplayEventTypeEXT) -> Self {
        self.value.display_event = display_event;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayEventInfoEXT {
        self.value
    }
}

impl ops::Deref for DisplayEventInfoEXTBuilder {
    type Target = DisplayEventInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayEventInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayEventInfoEXTBuilder {
    type Target = DisplayEventInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayModeCreateInfoKHR {
    type Target = DisplayModeCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayModeCreateInfoKHR {
    type Builder = DisplayModeCreateInfoKHRBuilder;
}

/// A builder for a [`DisplayModeCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayModeCreateInfoKHRBuilder {
    value: DisplayModeCreateInfoKHR,
}

impl DisplayModeCreateInfoKHRBuilder {
    #[inline]
    pub fn flags(mut self, flags: DisplayModeCreateFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn parameters(mut self, parameters: impl Cast<Target = DisplayModeParametersKHR>) -> Self {
        self.value.parameters = parameters.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayModeCreateInfoKHR {
        self.value
    }
}

impl ops::Deref for DisplayModeCreateInfoKHRBuilder {
    type Target = DisplayModeCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayModeCreateInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayModeCreateInfoKHRBuilder {
    type Target = DisplayModeCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayModeParametersKHR {
    type Target = DisplayModeParametersKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayModeParametersKHR {
    type Builder = DisplayModeParametersKHRBuilder;
}

/// A builder for a [`DisplayModeParametersKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayModeParametersKHRBuilder {
    value: DisplayModeParametersKHR,
}

impl DisplayModeParametersKHRBuilder {
    #[inline]
    pub fn visible_region(mut self, visible_region: impl Cast<Target = Extent2D>) -> Self {
        self.value.visible_region = visible_region.into();
        self
    }

    #[inline]
    pub fn refresh_rate(mut self, refresh_rate: u32) -> Self {
        self.value.refresh_rate = refresh_rate;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayModeParametersKHR {
        self.value
    }
}

impl ops::Deref for DisplayModeParametersKHRBuilder {
    type Target = DisplayModeParametersKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayModeParametersKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayModeParametersKHRBuilder {
    type Target = DisplayModeParametersKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayModeProperties2KHR {
    type Target = DisplayModeProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayModeProperties2KHR {
    type Builder = DisplayModeProperties2KHRBuilder;
}

/// A builder for a [`DisplayModeProperties2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayModeProperties2KHRBuilder {
    value: DisplayModeProperties2KHR,
}

impl DisplayModeProperties2KHRBuilder {
    #[inline]
    pub fn display_mode_properties(
        mut self,
        display_mode_properties: impl Cast<Target = DisplayModePropertiesKHR>,
    ) -> Self {
        self.value.display_mode_properties = display_mode_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayModeProperties2KHR {
        self.value
    }
}

impl ops::Deref for DisplayModeProperties2KHRBuilder {
    type Target = DisplayModeProperties2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayModeProperties2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayModeProperties2KHRBuilder {
    type Target = DisplayModeProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayModePropertiesKHR {
    type Target = DisplayModePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayModePropertiesKHR {
    type Builder = DisplayModePropertiesKHRBuilder;
}

/// A builder for a [`DisplayModePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayModePropertiesKHRBuilder {
    value: DisplayModePropertiesKHR,
}

impl DisplayModePropertiesKHRBuilder {
    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.value.display_mode = display_mode;
        self
    }

    #[inline]
    pub fn parameters(mut self, parameters: impl Cast<Target = DisplayModeParametersKHR>) -> Self {
        self.value.parameters = parameters.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayModePropertiesKHR {
        self.value
    }
}

impl ops::Deref for DisplayModePropertiesKHRBuilder {
    type Target = DisplayModePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayModePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayModePropertiesKHRBuilder {
    type Target = DisplayModePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayNativeHdrSurfaceCapabilitiesAMD {
    type Target = DisplayNativeHdrSurfaceCapabilitiesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayNativeHdrSurfaceCapabilitiesAMD {
    type Builder = DisplayNativeHdrSurfaceCapabilitiesAMDBuilder;
}

/// A builder for a [`DisplayNativeHdrSurfaceCapabilitiesAMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
    value: DisplayNativeHdrSurfaceCapabilitiesAMD,
}

impl DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
    #[inline]
    pub fn local_dimming_support(mut self, local_dimming_support: bool) -> Self {
        self.value.local_dimming_support = local_dimming_support as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayNativeHdrSurfaceCapabilitiesAMD {
        self.value
    }
}

impl ops::Deref for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
    type Target = DisplayNativeHdrSurfaceCapabilitiesAMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
    type Target = DisplayNativeHdrSurfaceCapabilitiesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPlaneCapabilities2KHR {
    type Target = DisplayPlaneCapabilities2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPlaneCapabilities2KHR {
    type Builder = DisplayPlaneCapabilities2KHRBuilder;
}

/// A builder for a [`DisplayPlaneCapabilities2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPlaneCapabilities2KHRBuilder {
    value: DisplayPlaneCapabilities2KHR,
}

impl DisplayPlaneCapabilities2KHRBuilder {
    #[inline]
    pub fn capabilities(
        mut self,
        capabilities: impl Cast<Target = DisplayPlaneCapabilitiesKHR>,
    ) -> Self {
        self.value.capabilities = capabilities.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPlaneCapabilities2KHR {
        self.value
    }
}

impl ops::Deref for DisplayPlaneCapabilities2KHRBuilder {
    type Target = DisplayPlaneCapabilities2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPlaneCapabilities2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPlaneCapabilities2KHRBuilder {
    type Target = DisplayPlaneCapabilities2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPlaneCapabilitiesKHR {
    type Target = DisplayPlaneCapabilitiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPlaneCapabilitiesKHR {
    type Builder = DisplayPlaneCapabilitiesKHRBuilder;
}

/// A builder for a [`DisplayPlaneCapabilitiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPlaneCapabilitiesKHRBuilder {
    value: DisplayPlaneCapabilitiesKHR,
}

impl DisplayPlaneCapabilitiesKHRBuilder {
    #[inline]
    pub fn supported_alpha(mut self, supported_alpha: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.value.supported_alpha = supported_alpha;
        self
    }

    #[inline]
    pub fn min_src_position(mut self, min_src_position: impl Cast<Target = Offset2D>) -> Self {
        self.value.min_src_position = min_src_position.into();
        self
    }

    #[inline]
    pub fn max_src_position(mut self, max_src_position: impl Cast<Target = Offset2D>) -> Self {
        self.value.max_src_position = max_src_position.into();
        self
    }

    #[inline]
    pub fn min_src_extent(mut self, min_src_extent: impl Cast<Target = Extent2D>) -> Self {
        self.value.min_src_extent = min_src_extent.into();
        self
    }

    #[inline]
    pub fn max_src_extent(mut self, max_src_extent: impl Cast<Target = Extent2D>) -> Self {
        self.value.max_src_extent = max_src_extent.into();
        self
    }

    #[inline]
    pub fn min_dst_position(mut self, min_dst_position: impl Cast<Target = Offset2D>) -> Self {
        self.value.min_dst_position = min_dst_position.into();
        self
    }

    #[inline]
    pub fn max_dst_position(mut self, max_dst_position: impl Cast<Target = Offset2D>) -> Self {
        self.value.max_dst_position = max_dst_position.into();
        self
    }

    #[inline]
    pub fn min_dst_extent(mut self, min_dst_extent: impl Cast<Target = Extent2D>) -> Self {
        self.value.min_dst_extent = min_dst_extent.into();
        self
    }

    #[inline]
    pub fn max_dst_extent(mut self, max_dst_extent: impl Cast<Target = Extent2D>) -> Self {
        self.value.max_dst_extent = max_dst_extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPlaneCapabilitiesKHR {
        self.value
    }
}

impl ops::Deref for DisplayPlaneCapabilitiesKHRBuilder {
    type Target = DisplayPlaneCapabilitiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPlaneCapabilitiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPlaneCapabilitiesKHRBuilder {
    type Target = DisplayPlaneCapabilitiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPlaneInfo2KHR {
    type Target = DisplayPlaneInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPlaneInfo2KHR {
    type Builder = DisplayPlaneInfo2KHRBuilder;
}

/// A builder for a [`DisplayPlaneInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPlaneInfo2KHRBuilder {
    value: DisplayPlaneInfo2KHR,
}

impl DisplayPlaneInfo2KHRBuilder {
    #[inline]
    pub fn mode(mut self, mode: DisplayModeKHR) -> Self {
        self.value.mode = mode;
        self
    }

    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.value.plane_index = plane_index;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPlaneInfo2KHR {
        self.value
    }
}

impl ops::Deref for DisplayPlaneInfo2KHRBuilder {
    type Target = DisplayPlaneInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPlaneInfo2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPlaneInfo2KHRBuilder {
    type Target = DisplayPlaneInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPlaneProperties2KHR {
    type Target = DisplayPlaneProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPlaneProperties2KHR {
    type Builder = DisplayPlaneProperties2KHRBuilder;
}

/// A builder for a [`DisplayPlaneProperties2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPlaneProperties2KHRBuilder {
    value: DisplayPlaneProperties2KHR,
}

impl DisplayPlaneProperties2KHRBuilder {
    #[inline]
    pub fn display_plane_properties(
        mut self,
        display_plane_properties: impl Cast<Target = DisplayPlanePropertiesKHR>,
    ) -> Self {
        self.value.display_plane_properties = display_plane_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPlaneProperties2KHR {
        self.value
    }
}

impl ops::Deref for DisplayPlaneProperties2KHRBuilder {
    type Target = DisplayPlaneProperties2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPlaneProperties2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPlaneProperties2KHRBuilder {
    type Target = DisplayPlaneProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPlanePropertiesKHR {
    type Target = DisplayPlanePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPlanePropertiesKHR {
    type Builder = DisplayPlanePropertiesKHRBuilder;
}

/// A builder for a [`DisplayPlanePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPlanePropertiesKHRBuilder {
    value: DisplayPlanePropertiesKHR,
}

impl DisplayPlanePropertiesKHRBuilder {
    #[inline]
    pub fn current_display(mut self, current_display: DisplayKHR) -> Self {
        self.value.current_display = current_display;
        self
    }

    #[inline]
    pub fn current_stack_index(mut self, current_stack_index: u32) -> Self {
        self.value.current_stack_index = current_stack_index;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPlanePropertiesKHR {
        self.value
    }
}

impl ops::Deref for DisplayPlanePropertiesKHRBuilder {
    type Target = DisplayPlanePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPlanePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPlanePropertiesKHRBuilder {
    type Target = DisplayPlanePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPowerInfoEXT {
    type Target = DisplayPowerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPowerInfoEXT {
    type Builder = DisplayPowerInfoEXTBuilder;
}

/// A builder for a [`DisplayPowerInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPowerInfoEXTBuilder {
    value: DisplayPowerInfoEXT,
}

impl DisplayPowerInfoEXTBuilder {
    #[inline]
    pub fn power_state(mut self, power_state: DisplayPowerStateEXT) -> Self {
        self.value.power_state = power_state;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPowerInfoEXT {
        self.value
    }
}

impl ops::Deref for DisplayPowerInfoEXTBuilder {
    type Target = DisplayPowerInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPowerInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPowerInfoEXTBuilder {
    type Target = DisplayPowerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPresentInfoKHR {
    type Target = DisplayPresentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplayPresentInfoKHR {
    type Builder = DisplayPresentInfoKHRBuilder;
}

/// A builder for a [`DisplayPresentInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPresentInfoKHRBuilder {
    value: DisplayPresentInfoKHR,
}

impl DisplayPresentInfoKHRBuilder {
    #[inline]
    pub fn src_rect(mut self, src_rect: impl Cast<Target = Rect2D>) -> Self {
        self.value.src_rect = src_rect.into();
        self
    }

    #[inline]
    pub fn dst_rect(mut self, dst_rect: impl Cast<Target = Rect2D>) -> Self {
        self.value.dst_rect = dst_rect.into();
        self
    }

    #[inline]
    pub fn persistent(mut self, persistent: bool) -> Self {
        self.value.persistent = persistent as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPresentInfoKHR {
        self.value
    }
}

impl ops::Deref for DisplayPresentInfoKHRBuilder {
    type Target = DisplayPresentInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplayPresentInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplayPresentInfoKHRBuilder {
    type Target = DisplayPresentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayProperties2KHR {
    type Target = DisplayProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DisplayProperties2KHR {
    type Builder = DisplayProperties2KHRBuilder<'b>;
}

/// A builder for a [`DisplayProperties2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayProperties2KHRBuilder<'b> {
    value: DisplayProperties2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DisplayProperties2KHRBuilder<'b> {
    #[inline]
    pub fn display_properties(
        mut self,
        display_properties: impl Cast<Target = DisplayPropertiesKHR>,
    ) -> Self {
        self.value.display_properties = display_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplayProperties2KHR {
        self.value
    }
}

impl<'b> ops::Deref for DisplayProperties2KHRBuilder<'b> {
    type Target = DisplayProperties2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DisplayProperties2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DisplayProperties2KHRBuilder<'b> {
    type Target = DisplayProperties2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplayPropertiesKHR {
    type Target = DisplayPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DisplayPropertiesKHR {
    type Builder = DisplayPropertiesKHRBuilder<'b>;
}

/// A builder for a [`DisplayPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplayPropertiesKHRBuilder<'b> {
    value: DisplayPropertiesKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DisplayPropertiesKHRBuilder<'b> {
    #[inline]
    pub fn display(mut self, display: DisplayKHR) -> Self {
        self.value.display = display;
        self
    }

    #[inline]
    pub fn display_name(mut self, display_name: &'b [u8]) -> Self {
        self.value.display_name = display_name.as_ptr().cast();
        self
    }

    #[inline]
    pub fn physical_dimensions(
        mut self,
        physical_dimensions: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.physical_dimensions = physical_dimensions.into();
        self
    }

    #[inline]
    pub fn physical_resolution(
        mut self,
        physical_resolution: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.physical_resolution = physical_resolution.into();
        self
    }

    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.value.supported_transforms = supported_transforms;
        self
    }

    #[inline]
    pub fn plane_reorder_possible(mut self, plane_reorder_possible: bool) -> Self {
        self.value.plane_reorder_possible = plane_reorder_possible as Bool32;
        self
    }

    #[inline]
    pub fn persistent_content(mut self, persistent_content: bool) -> Self {
        self.value.persistent_content = persistent_content as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> DisplayPropertiesKHR {
        self.value
    }
}

impl<'b> ops::Deref for DisplayPropertiesKHRBuilder<'b> {
    type Target = DisplayPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DisplayPropertiesKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DisplayPropertiesKHRBuilder<'b> {
    type Target = DisplayPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DisplaySurfaceCreateInfoKHR {
    type Target = DisplaySurfaceCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DisplaySurfaceCreateInfoKHR {
    type Builder = DisplaySurfaceCreateInfoKHRBuilder;
}

/// A builder for a [`DisplaySurfaceCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DisplaySurfaceCreateInfoKHRBuilder {
    value: DisplaySurfaceCreateInfoKHR,
}

impl DisplaySurfaceCreateInfoKHRBuilder {
    #[inline]
    pub fn flags(mut self, flags: DisplaySurfaceCreateFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.value.display_mode = display_mode;
        self
    }

    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.value.plane_index = plane_index;
        self
    }

    #[inline]
    pub fn plane_stack_index(mut self, plane_stack_index: u32) -> Self {
        self.value.plane_stack_index = plane_stack_index;
        self
    }

    #[inline]
    pub fn transform(mut self, transform: SurfaceTransformFlagsKHR) -> Self {
        self.value.transform = transform;
        self
    }

    #[inline]
    pub fn global_alpha(mut self, global_alpha: f32) -> Self {
        self.value.global_alpha = global_alpha;
        self
    }

    #[inline]
    pub fn alpha_mode(mut self, alpha_mode: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.value.alpha_mode = alpha_mode;
        self
    }

    #[inline]
    pub fn image_extent(mut self, image_extent: impl Cast<Target = Extent2D>) -> Self {
        self.value.image_extent = image_extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> DisplaySurfaceCreateInfoKHR {
        self.value
    }
}

impl ops::Deref for DisplaySurfaceCreateInfoKHRBuilder {
    type Target = DisplaySurfaceCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DisplaySurfaceCreateInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DisplaySurfaceCreateInfoKHRBuilder {
    type Target = DisplaySurfaceCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DrawIndexedIndirectCommand {
    type Target = DrawIndexedIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DrawIndexedIndirectCommand {
    type Builder = DrawIndexedIndirectCommandBuilder;
}

/// A builder for a [`DrawIndexedIndirectCommand`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DrawIndexedIndirectCommandBuilder {
    value: DrawIndexedIndirectCommand,
}

impl DrawIndexedIndirectCommandBuilder {
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.value.index_count = index_count;
        self
    }

    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.value.instance_count = instance_count;
        self
    }

    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.value.first_index = first_index;
        self
    }

    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.value.vertex_offset = vertex_offset;
        self
    }

    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.value.first_instance = first_instance;
        self
    }

    #[inline]
    pub fn build(self) -> DrawIndexedIndirectCommand {
        self.value
    }
}

impl ops::Deref for DrawIndexedIndirectCommandBuilder {
    type Target = DrawIndexedIndirectCommand;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DrawIndexedIndirectCommandBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DrawIndexedIndirectCommandBuilder {
    type Target = DrawIndexedIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DrawIndirectCommand {
    type Target = DrawIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DrawIndirectCommand {
    type Builder = DrawIndirectCommandBuilder;
}

/// A builder for a [`DrawIndirectCommand`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DrawIndirectCommandBuilder {
    value: DrawIndirectCommand,
}

impl DrawIndirectCommandBuilder {
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.value.vertex_count = vertex_count;
        self
    }

    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.value.instance_count = instance_count;
        self
    }

    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.value.first_vertex = first_vertex;
        self
    }

    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.value.first_instance = first_instance;
        self
    }

    #[inline]
    pub fn build(self) -> DrawIndirectCommand {
        self.value
    }
}

impl ops::Deref for DrawIndirectCommandBuilder {
    type Target = DrawIndirectCommand;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DrawIndirectCommandBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DrawIndirectCommandBuilder {
    type Target = DrawIndirectCommand;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DrawMeshTasksIndirectCommandNV {
    type Target = DrawMeshTasksIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DrawMeshTasksIndirectCommandNV {
    type Builder = DrawMeshTasksIndirectCommandNVBuilder;
}

/// A builder for a [`DrawMeshTasksIndirectCommandNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DrawMeshTasksIndirectCommandNVBuilder {
    value: DrawMeshTasksIndirectCommandNV,
}

impl DrawMeshTasksIndirectCommandNVBuilder {
    #[inline]
    pub fn task_count(mut self, task_count: u32) -> Self {
        self.value.task_count = task_count;
        self
    }

    #[inline]
    pub fn first_task(mut self, first_task: u32) -> Self {
        self.value.first_task = first_task;
        self
    }

    #[inline]
    pub fn build(self) -> DrawMeshTasksIndirectCommandNV {
        self.value
    }
}

impl ops::Deref for DrawMeshTasksIndirectCommandNVBuilder {
    type Target = DrawMeshTasksIndirectCommandNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DrawMeshTasksIndirectCommandNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DrawMeshTasksIndirectCommandNVBuilder {
    type Target = DrawMeshTasksIndirectCommandNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DrmFormatModifierPropertiesEXT {
    type Target = DrmFormatModifierPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for DrmFormatModifierPropertiesEXT {
    type Builder = DrmFormatModifierPropertiesEXTBuilder;
}

/// A builder for a [`DrmFormatModifierPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DrmFormatModifierPropertiesEXTBuilder {
    value: DrmFormatModifierPropertiesEXT,
}

impl DrmFormatModifierPropertiesEXTBuilder {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.value.drm_format_modifier = drm_format_modifier;
        self
    }

    #[inline]
    pub fn drm_format_modifier_plane_count(mut self, drm_format_modifier_plane_count: u32) -> Self {
        self.value.drm_format_modifier_plane_count = drm_format_modifier_plane_count;
        self
    }

    #[inline]
    pub fn drm_format_modifier_tiling_features(
        mut self,
        drm_format_modifier_tiling_features: FormatFeatureFlags,
    ) -> Self {
        self.value.drm_format_modifier_tiling_features = drm_format_modifier_tiling_features;
        self
    }

    #[inline]
    pub fn build(self) -> DrmFormatModifierPropertiesEXT {
        self.value
    }
}

impl ops::Deref for DrmFormatModifierPropertiesEXTBuilder {
    type Target = DrmFormatModifierPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for DrmFormatModifierPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for DrmFormatModifierPropertiesEXTBuilder {
    type Target = DrmFormatModifierPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for DrmFormatModifierPropertiesListEXT {
    type Target = DrmFormatModifierPropertiesListEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for DrmFormatModifierPropertiesListEXT {
    type Builder = DrmFormatModifierPropertiesListEXTBuilder<'b>;
}

/// A builder for a [`DrmFormatModifierPropertiesListEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct DrmFormatModifierPropertiesListEXTBuilder<'b> {
    value: DrmFormatModifierPropertiesListEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> DrmFormatModifierPropertiesListEXTBuilder<'b> {
    #[inline]
    pub fn drm_format_modifier_properties(
        mut self,
        drm_format_modifier_properties: &'b mut [impl Cast<Target = DrmFormatModifierPropertiesEXT>],
    ) -> Self {
        self.value.drm_format_modifier_count = drm_format_modifier_properties.len() as u32;
        self.value.drm_format_modifier_properties =
            drm_format_modifier_properties.as_mut_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> DrmFormatModifierPropertiesListEXT {
        self.value
    }
}

impl<'b> ops::Deref for DrmFormatModifierPropertiesListEXTBuilder<'b> {
    type Target = DrmFormatModifierPropertiesListEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for DrmFormatModifierPropertiesListEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for DrmFormatModifierPropertiesListEXTBuilder<'b> {
    type Target = DrmFormatModifierPropertiesListEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for EventCreateInfo {
    type Target = EventCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for EventCreateInfo {
    type Builder = EventCreateInfoBuilder;
}

/// A builder for a [`EventCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct EventCreateInfoBuilder {
    value: EventCreateInfo,
}

impl EventCreateInfoBuilder {
    #[inline]
    pub fn flags(mut self, flags: EventCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> EventCreateInfo {
        self.value
    }
}

impl ops::Deref for EventCreateInfoBuilder {
    type Target = EventCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for EventCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for EventCreateInfoBuilder {
    type Target = EventCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportFenceCreateInfo {
    type Target = ExportFenceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExportFenceCreateInfo {
    type Builder = ExportFenceCreateInfoBuilder;
}

/// A builder for a [`ExportFenceCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportFenceCreateInfoBuilder {
    value: ExportFenceCreateInfo,
}

impl ExportFenceCreateInfoBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExportFenceCreateInfo {
        self.value
    }
}

impl ops::Deref for ExportFenceCreateInfoBuilder {
    type Target = ExportFenceCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExportFenceCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExportFenceCreateInfoBuilder {
    type Target = ExportFenceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportFenceWin32HandleInfoKHR {
    type Target = ExportFenceWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ExportFenceWin32HandleInfoKHR {
    type Builder = ExportFenceWin32HandleInfoKHRBuilder<'b>;
}

/// A builder for a [`ExportFenceWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportFenceWin32HandleInfoKHRBuilder<'b> {
    value: ExportFenceWin32HandleInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ExportFenceWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    pub fn attributes(mut self, attributes: *const SECURITY_ATTRIBUTES) -> Self {
        self.value.attributes = attributes;
        self
    }

    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.value.dw_access = dw_access;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ExportFenceWin32HandleInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for ExportFenceWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportFenceWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ExportFenceWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ExportFenceWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportFenceWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportMemoryAllocateInfo {
    type Target = ExportMemoryAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExportMemoryAllocateInfo {
    type Builder = ExportMemoryAllocateInfoBuilder;
}

/// A builder for a [`ExportMemoryAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportMemoryAllocateInfoBuilder {
    value: ExportMemoryAllocateInfo,
}

impl ExportMemoryAllocateInfoBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExportMemoryAllocateInfo {
        self.value
    }
}

impl ops::Deref for ExportMemoryAllocateInfoBuilder {
    type Target = ExportMemoryAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExportMemoryAllocateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExportMemoryAllocateInfoBuilder {
    type Target = ExportMemoryAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportMemoryAllocateInfoNV {
    type Target = ExportMemoryAllocateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExportMemoryAllocateInfoNV {
    type Builder = ExportMemoryAllocateInfoNVBuilder;
}

/// A builder for a [`ExportMemoryAllocateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportMemoryAllocateInfoNVBuilder {
    value: ExportMemoryAllocateInfoNV,
}

impl ExportMemoryAllocateInfoNVBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExportMemoryAllocateInfoNV {
        self.value
    }
}

impl ops::Deref for ExportMemoryAllocateInfoNVBuilder {
    type Target = ExportMemoryAllocateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExportMemoryAllocateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExportMemoryAllocateInfoNVBuilder {
    type Target = ExportMemoryAllocateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportMemoryWin32HandleInfoKHR {
    type Target = ExportMemoryWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ExportMemoryWin32HandleInfoKHR {
    type Builder = ExportMemoryWin32HandleInfoKHRBuilder<'b>;
}

/// A builder for a [`ExportMemoryWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportMemoryWin32HandleInfoKHRBuilder<'b> {
    value: ExportMemoryWin32HandleInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ExportMemoryWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    pub fn attributes(mut self, attributes: *const SECURITY_ATTRIBUTES) -> Self {
        self.value.attributes = attributes;
        self
    }

    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.value.dw_access = dw_access;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ExportMemoryWin32HandleInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for ExportMemoryWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportMemoryWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ExportMemoryWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ExportMemoryWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportMemoryWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportMemoryWin32HandleInfoNV {
    type Target = ExportMemoryWin32HandleInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ExportMemoryWin32HandleInfoNV {
    type Builder = ExportMemoryWin32HandleInfoNVBuilder<'b>;
}

/// A builder for a [`ExportMemoryWin32HandleInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportMemoryWin32HandleInfoNVBuilder<'b> {
    value: ExportMemoryWin32HandleInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ExportMemoryWin32HandleInfoNVBuilder<'b> {
    #[inline]
    pub fn attributes(mut self, attributes: *const SECURITY_ATTRIBUTES) -> Self {
        self.value.attributes = attributes;
        self
    }

    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.value.dw_access = dw_access;
        self
    }

    #[inline]
    pub fn build(self) -> ExportMemoryWin32HandleInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for ExportMemoryWin32HandleInfoNVBuilder<'b> {
    type Target = ExportMemoryWin32HandleInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ExportMemoryWin32HandleInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ExportMemoryWin32HandleInfoNVBuilder<'b> {
    type Target = ExportMemoryWin32HandleInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportSemaphoreCreateInfo {
    type Target = ExportSemaphoreCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExportSemaphoreCreateInfo {
    type Builder = ExportSemaphoreCreateInfoBuilder;
}

/// A builder for a [`ExportSemaphoreCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportSemaphoreCreateInfoBuilder {
    value: ExportSemaphoreCreateInfo,
}

impl ExportSemaphoreCreateInfoBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExportSemaphoreCreateInfo {
        self.value
    }
}

impl ops::Deref for ExportSemaphoreCreateInfoBuilder {
    type Target = ExportSemaphoreCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExportSemaphoreCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExportSemaphoreCreateInfoBuilder {
    type Target = ExportSemaphoreCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExportSemaphoreWin32HandleInfoKHR {
    type Target = ExportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ExportSemaphoreWin32HandleInfoKHR {
    type Builder = ExportSemaphoreWin32HandleInfoKHRBuilder<'b>;
}

/// A builder for a [`ExportSemaphoreWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExportSemaphoreWin32HandleInfoKHRBuilder<'b> {
    value: ExportSemaphoreWin32HandleInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ExportSemaphoreWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    pub fn attributes(mut self, attributes: *const SECURITY_ATTRIBUTES) -> Self {
        self.value.attributes = attributes;
        self
    }

    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.value.dw_access = dw_access;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ExportSemaphoreWin32HandleInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for ExportSemaphoreWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ExportSemaphoreWin32HandleInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ExportSemaphoreWin32HandleInfoKHRBuilder<'b> {
    type Target = ExportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExtensionProperties {
    type Target = ExtensionProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExtensionProperties {
    type Builder = ExtensionPropertiesBuilder;
}

/// A builder for a [`ExtensionProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExtensionPropertiesBuilder {
    value: ExtensionProperties,
}

impl ExtensionPropertiesBuilder {
    #[inline]
    pub fn extension_name(
        mut self,
        extension_name: impl Into<StringArray<MAX_EXTENSION_NAME_SIZE>>,
    ) -> Self {
        self.value.extension_name = extension_name.into();
        self
    }

    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.value.spec_version = spec_version;
        self
    }

    #[inline]
    pub fn build(self) -> ExtensionProperties {
        self.value
    }
}

impl ops::Deref for ExtensionPropertiesBuilder {
    type Target = ExtensionProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExtensionPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExtensionPropertiesBuilder {
    type Target = ExtensionProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for Extent2D {
    type Target = Extent2D;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for Extent2D {
    type Builder = Extent2DBuilder;
}

/// A builder for a [`Extent2D`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct Extent2DBuilder {
    value: Extent2D,
}

impl Extent2DBuilder {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.value.width = width;
        self
    }

    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.value.height = height;
        self
    }

    #[inline]
    pub fn build(self) -> Extent2D {
        self.value
    }
}

impl ops::Deref for Extent2DBuilder {
    type Target = Extent2D;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for Extent2DBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for Extent2DBuilder {
    type Target = Extent2D;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for Extent3D {
    type Target = Extent3D;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for Extent3D {
    type Builder = Extent3DBuilder;
}

/// A builder for a [`Extent3D`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct Extent3DBuilder {
    value: Extent3D,
}

impl Extent3DBuilder {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.value.width = width;
        self
    }

    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.value.height = height;
        self
    }

    #[inline]
    pub fn depth(mut self, depth: u32) -> Self {
        self.value.depth = depth;
        self
    }

    #[inline]
    pub fn build(self) -> Extent3D {
        self.value
    }
}

impl ops::Deref for Extent3DBuilder {
    type Target = Extent3D;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for Extent3DBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for Extent3DBuilder {
    type Target = Extent3D;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalBufferProperties {
    type Target = ExternalBufferProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalBufferProperties {
    type Builder = ExternalBufferPropertiesBuilder;
}

/// A builder for a [`ExternalBufferProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalBufferPropertiesBuilder {
    value: ExternalBufferProperties,
}

impl ExternalBufferPropertiesBuilder {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: impl Cast<Target = ExternalMemoryProperties>,
    ) -> Self {
        self.value.external_memory_properties = external_memory_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> ExternalBufferProperties {
        self.value
    }
}

impl ops::Deref for ExternalBufferPropertiesBuilder {
    type Target = ExternalBufferProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalBufferPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalBufferPropertiesBuilder {
    type Target = ExternalBufferProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalFenceProperties {
    type Target = ExternalFenceProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalFenceProperties {
    type Builder = ExternalFencePropertiesBuilder;
}

/// A builder for a [`ExternalFenceProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalFencePropertiesBuilder {
    value: ExternalFenceProperties,
}

impl ExternalFencePropertiesBuilder {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.value.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }

    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.value.compatible_handle_types = compatible_handle_types;
        self
    }

    #[inline]
    pub fn external_fence_features(
        mut self,
        external_fence_features: ExternalFenceFeatureFlags,
    ) -> Self {
        self.value.external_fence_features = external_fence_features;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalFenceProperties {
        self.value
    }
}

impl ops::Deref for ExternalFencePropertiesBuilder {
    type Target = ExternalFenceProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalFencePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalFencePropertiesBuilder {
    type Target = ExternalFenceProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalFormatANDROID {
    type Target = ExternalFormatANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalFormatANDROID {
    type Builder = ExternalFormatANDROIDBuilder;
}

/// A builder for a [`ExternalFormatANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalFormatANDROIDBuilder {
    value: ExternalFormatANDROID,
}

impl ExternalFormatANDROIDBuilder {
    #[inline]
    pub fn external_format(mut self, external_format: u64) -> Self {
        self.value.external_format = external_format;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalFormatANDROID {
        self.value
    }
}

impl ops::Deref for ExternalFormatANDROIDBuilder {
    type Target = ExternalFormatANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalFormatANDROIDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalFormatANDROIDBuilder {
    type Target = ExternalFormatANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalImageFormatProperties {
    type Target = ExternalImageFormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalImageFormatProperties {
    type Builder = ExternalImageFormatPropertiesBuilder;
}

/// A builder for a [`ExternalImageFormatProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalImageFormatPropertiesBuilder {
    value: ExternalImageFormatProperties,
}

impl ExternalImageFormatPropertiesBuilder {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: impl Cast<Target = ExternalMemoryProperties>,
    ) -> Self {
        self.value.external_memory_properties = external_memory_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> ExternalImageFormatProperties {
        self.value
    }
}

impl ops::Deref for ExternalImageFormatPropertiesBuilder {
    type Target = ExternalImageFormatProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalImageFormatPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalImageFormatPropertiesBuilder {
    type Target = ExternalImageFormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalImageFormatPropertiesNV {
    type Target = ExternalImageFormatPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalImageFormatPropertiesNV {
    type Builder = ExternalImageFormatPropertiesNVBuilder;
}

/// A builder for a [`ExternalImageFormatPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalImageFormatPropertiesNVBuilder {
    value: ExternalImageFormatPropertiesNV,
}

impl ExternalImageFormatPropertiesNVBuilder {
    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: impl Cast<Target = ImageFormatProperties>,
    ) -> Self {
        self.value.image_format_properties = image_format_properties.into();
        self
    }

    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlagsNV,
    ) -> Self {
        self.value.external_memory_features = external_memory_features;
        self
    }

    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.value.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }

    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.value.compatible_handle_types = compatible_handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalImageFormatPropertiesNV {
        self.value
    }
}

impl ops::Deref for ExternalImageFormatPropertiesNVBuilder {
    type Target = ExternalImageFormatPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalImageFormatPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalImageFormatPropertiesNVBuilder {
    type Target = ExternalImageFormatPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalMemoryBufferCreateInfo {
    type Target = ExternalMemoryBufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalMemoryBufferCreateInfo {
    type Builder = ExternalMemoryBufferCreateInfoBuilder;
}

/// A builder for a [`ExternalMemoryBufferCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalMemoryBufferCreateInfoBuilder {
    value: ExternalMemoryBufferCreateInfo,
}

impl ExternalMemoryBufferCreateInfoBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalMemoryBufferCreateInfo {
        self.value
    }
}

impl ops::Deref for ExternalMemoryBufferCreateInfoBuilder {
    type Target = ExternalMemoryBufferCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalMemoryBufferCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalMemoryBufferCreateInfoBuilder {
    type Target = ExternalMemoryBufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalMemoryImageCreateInfo {
    type Target = ExternalMemoryImageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalMemoryImageCreateInfo {
    type Builder = ExternalMemoryImageCreateInfoBuilder;
}

/// A builder for a [`ExternalMemoryImageCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalMemoryImageCreateInfoBuilder {
    value: ExternalMemoryImageCreateInfo,
}

impl ExternalMemoryImageCreateInfoBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalMemoryImageCreateInfo {
        self.value
    }
}

impl ops::Deref for ExternalMemoryImageCreateInfoBuilder {
    type Target = ExternalMemoryImageCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalMemoryImageCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalMemoryImageCreateInfoBuilder {
    type Target = ExternalMemoryImageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalMemoryImageCreateInfoNV {
    type Target = ExternalMemoryImageCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalMemoryImageCreateInfoNV {
    type Builder = ExternalMemoryImageCreateInfoNVBuilder;
}

/// A builder for a [`ExternalMemoryImageCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalMemoryImageCreateInfoNVBuilder {
    value: ExternalMemoryImageCreateInfoNV,
}

impl ExternalMemoryImageCreateInfoNVBuilder {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.value.handle_types = handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalMemoryImageCreateInfoNV {
        self.value
    }
}

impl ops::Deref for ExternalMemoryImageCreateInfoNVBuilder {
    type Target = ExternalMemoryImageCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalMemoryImageCreateInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalMemoryImageCreateInfoNVBuilder {
    type Target = ExternalMemoryImageCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalMemoryProperties {
    type Target = ExternalMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalMemoryProperties {
    type Builder = ExternalMemoryPropertiesBuilder;
}

/// A builder for a [`ExternalMemoryProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalMemoryPropertiesBuilder {
    value: ExternalMemoryProperties,
}

impl ExternalMemoryPropertiesBuilder {
    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlags,
    ) -> Self {
        self.value.external_memory_features = external_memory_features;
        self
    }

    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.value.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }

    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.value.compatible_handle_types = compatible_handle_types;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalMemoryProperties {
        self.value
    }
}

impl ops::Deref for ExternalMemoryPropertiesBuilder {
    type Target = ExternalMemoryProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalMemoryPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalMemoryPropertiesBuilder {
    type Target = ExternalMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ExternalSemaphoreProperties {
    type Target = ExternalSemaphoreProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ExternalSemaphoreProperties {
    type Builder = ExternalSemaphorePropertiesBuilder;
}

/// A builder for a [`ExternalSemaphoreProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ExternalSemaphorePropertiesBuilder {
    value: ExternalSemaphoreProperties,
}

impl ExternalSemaphorePropertiesBuilder {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.value.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }

    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.value.compatible_handle_types = compatible_handle_types;
        self
    }

    #[inline]
    pub fn external_semaphore_features(
        mut self,
        external_semaphore_features: ExternalSemaphoreFeatureFlags,
    ) -> Self {
        self.value.external_semaphore_features = external_semaphore_features;
        self
    }

    #[inline]
    pub fn build(self) -> ExternalSemaphoreProperties {
        self.value
    }
}

impl ops::Deref for ExternalSemaphorePropertiesBuilder {
    type Target = ExternalSemaphoreProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ExternalSemaphorePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ExternalSemaphorePropertiesBuilder {
    type Target = ExternalSemaphoreProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`FenceCreateInfo`].
pub unsafe trait ExtendsFenceCreateInfo: fmt::Debug {}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfo {}
unsafe impl ExtendsFenceCreateInfo for ExportFenceWin32HandleInfoKHR {}

unsafe impl Cast for FenceCreateInfo {
    type Target = FenceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FenceCreateInfo {
    type Builder = FenceCreateInfoBuilder<'b>;
}

/// A builder for a [`FenceCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FenceCreateInfoBuilder<'b> {
    value: FenceCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FenceCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsFenceCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<FenceCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: FenceCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> FenceCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for FenceCreateInfoBuilder<'b> {
    type Target = FenceCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FenceCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FenceCreateInfoBuilder<'b> {
    type Target = FenceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FenceGetFdInfoKHR {
    type Target = FenceGetFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for FenceGetFdInfoKHR {
    type Builder = FenceGetFdInfoKHRBuilder;
}

/// A builder for a [`FenceGetFdInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FenceGetFdInfoKHRBuilder {
    value: FenceGetFdInfoKHR,
}

impl FenceGetFdInfoKHRBuilder {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.value.fence = fence;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> FenceGetFdInfoKHR {
        self.value
    }
}

impl ops::Deref for FenceGetFdInfoKHRBuilder {
    type Target = FenceGetFdInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for FenceGetFdInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for FenceGetFdInfoKHRBuilder {
    type Target = FenceGetFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FenceGetWin32HandleInfoKHR {
    type Target = FenceGetWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for FenceGetWin32HandleInfoKHR {
    type Builder = FenceGetWin32HandleInfoKHRBuilder;
}

/// A builder for a [`FenceGetWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FenceGetWin32HandleInfoKHRBuilder {
    value: FenceGetWin32HandleInfoKHR,
}

impl FenceGetWin32HandleInfoKHRBuilder {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.value.fence = fence;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> FenceGetWin32HandleInfoKHR {
        self.value
    }
}

impl ops::Deref for FenceGetWin32HandleInfoKHRBuilder {
    type Target = FenceGetWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for FenceGetWin32HandleInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for FenceGetWin32HandleInfoKHRBuilder {
    type Target = FenceGetWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FilterCubicImageViewImageFormatPropertiesEXT {
    type Target = FilterCubicImageViewImageFormatPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for FilterCubicImageViewImageFormatPropertiesEXT {
    type Builder = FilterCubicImageViewImageFormatPropertiesEXTBuilder;
}

/// A builder for a [`FilterCubicImageViewImageFormatPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FilterCubicImageViewImageFormatPropertiesEXTBuilder {
    value: FilterCubicImageViewImageFormatPropertiesEXT,
}

impl FilterCubicImageViewImageFormatPropertiesEXTBuilder {
    #[inline]
    pub fn filter_cubic(mut self, filter_cubic: bool) -> Self {
        self.value.filter_cubic = filter_cubic as Bool32;
        self
    }

    #[inline]
    pub fn filter_cubic_minmax(mut self, filter_cubic_minmax: bool) -> Self {
        self.value.filter_cubic_minmax = filter_cubic_minmax as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> FilterCubicImageViewImageFormatPropertiesEXT {
        self.value
    }
}

impl ops::Deref for FilterCubicImageViewImageFormatPropertiesEXTBuilder {
    type Target = FilterCubicImageViewImageFormatPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for FilterCubicImageViewImageFormatPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for FilterCubicImageViewImageFormatPropertiesEXTBuilder {
    type Target = FilterCubicImageViewImageFormatPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FormatProperties {
    type Target = FormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for FormatProperties {
    type Builder = FormatPropertiesBuilder;
}

/// A builder for a [`FormatProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FormatPropertiesBuilder {
    value: FormatProperties,
}

impl FormatPropertiesBuilder {
    #[inline]
    pub fn linear_tiling_features(mut self, linear_tiling_features: FormatFeatureFlags) -> Self {
        self.value.linear_tiling_features = linear_tiling_features;
        self
    }

    #[inline]
    pub fn optimal_tiling_features(mut self, optimal_tiling_features: FormatFeatureFlags) -> Self {
        self.value.optimal_tiling_features = optimal_tiling_features;
        self
    }

    #[inline]
    pub fn buffer_features(mut self, buffer_features: FormatFeatureFlags) -> Self {
        self.value.buffer_features = buffer_features;
        self
    }

    #[inline]
    pub fn build(self) -> FormatProperties {
        self.value
    }
}

impl ops::Deref for FormatPropertiesBuilder {
    type Target = FormatProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for FormatPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for FormatPropertiesBuilder {
    type Target = FormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`FormatProperties2`].
pub unsafe trait ExtendsFormatProperties2: fmt::Debug {}
unsafe impl ExtendsFormatProperties2 for DrmFormatModifierPropertiesListEXT {}

unsafe impl Cast for FormatProperties2 {
    type Target = FormatProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FormatProperties2 {
    type Builder = FormatProperties2Builder<'b>;
}

/// A builder for a [`FormatProperties2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FormatProperties2Builder<'b> {
    value: FormatProperties2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FormatProperties2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsFormatProperties2,
    {
        let next = (next.as_mut() as *mut T).cast::<FormatProperties2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn format_properties(
        mut self,
        format_properties: impl Cast<Target = FormatProperties>,
    ) -> Self {
        self.value.format_properties = format_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> FormatProperties2 {
        self.value
    }
}

impl<'b> ops::Deref for FormatProperties2Builder<'b> {
    type Target = FormatProperties2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FormatProperties2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FormatProperties2Builder<'b> {
    type Target = FormatProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FragmentShadingRateAttachmentInfoKHR {
    type Target = FragmentShadingRateAttachmentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FragmentShadingRateAttachmentInfoKHR {
    type Builder = FragmentShadingRateAttachmentInfoKHRBuilder<'b>;
}

/// A builder for a [`FragmentShadingRateAttachmentInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FragmentShadingRateAttachmentInfoKHRBuilder<'b> {
    value: FragmentShadingRateAttachmentInfoKHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FragmentShadingRateAttachmentInfoKHRBuilder<'b> {
    #[inline]
    pub fn fragment_shading_rate_attachment(
        mut self,
        fragment_shading_rate_attachment: &'b impl Cast<Target = AttachmentReference2>,
    ) -> Self {
        self.value.fragment_shading_rate_attachment = fragment_shading_rate_attachment.as_ref();
        self
    }

    #[inline]
    pub fn shading_rate_attachment_texel_size(
        mut self,
        shading_rate_attachment_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.shading_rate_attachment_texel_size = shading_rate_attachment_texel_size.into();
        self
    }

    #[inline]
    pub fn build(self) -> FragmentShadingRateAttachmentInfoKHR {
        self.value
    }
}

impl<'b> ops::Deref for FragmentShadingRateAttachmentInfoKHRBuilder<'b> {
    type Target = FragmentShadingRateAttachmentInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FragmentShadingRateAttachmentInfoKHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FragmentShadingRateAttachmentInfoKHRBuilder<'b> {
    type Target = FragmentShadingRateAttachmentInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FramebufferAttachmentImageInfo {
    type Target = FramebufferAttachmentImageInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FramebufferAttachmentImageInfo {
    type Builder = FramebufferAttachmentImageInfoBuilder<'b>;
}

/// A builder for a [`FramebufferAttachmentImageInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FramebufferAttachmentImageInfoBuilder<'b> {
    value: FramebufferAttachmentImageInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FramebufferAttachmentImageInfoBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.value.width = width;
        self
    }

    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.value.height = height;
        self
    }

    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.value.layer_count = layer_count;
        self
    }

    #[inline]
    pub fn view_formats(mut self, view_formats: &'b [Format]) -> Self {
        self.value.view_format_count = view_formats.len() as u32;
        self.value.view_formats = view_formats.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> FramebufferAttachmentImageInfo {
        self.value
    }
}

impl<'b> ops::Deref for FramebufferAttachmentImageInfoBuilder<'b> {
    type Target = FramebufferAttachmentImageInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FramebufferAttachmentImageInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FramebufferAttachmentImageInfoBuilder<'b> {
    type Target = FramebufferAttachmentImageInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FramebufferAttachmentsCreateInfo {
    type Target = FramebufferAttachmentsCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FramebufferAttachmentsCreateInfo {
    type Builder = FramebufferAttachmentsCreateInfoBuilder<'b>;
}

/// A builder for a [`FramebufferAttachmentsCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FramebufferAttachmentsCreateInfoBuilder<'b> {
    value: FramebufferAttachmentsCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FramebufferAttachmentsCreateInfoBuilder<'b> {
    #[inline]
    pub fn attachment_image_infos(
        mut self,
        attachment_image_infos: &'b [impl Cast<Target = FramebufferAttachmentImageInfo>],
    ) -> Self {
        self.value.attachment_image_info_count = attachment_image_infos.len() as u32;
        self.value.attachment_image_infos = attachment_image_infos.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> FramebufferAttachmentsCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for FramebufferAttachmentsCreateInfoBuilder<'b> {
    type Target = FramebufferAttachmentsCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FramebufferAttachmentsCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FramebufferAttachmentsCreateInfoBuilder<'b> {
    type Target = FramebufferAttachmentsCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`FramebufferCreateInfo`].
pub unsafe trait ExtendsFramebufferCreateInfo: fmt::Debug {}
unsafe impl ExtendsFramebufferCreateInfo for FramebufferAttachmentsCreateInfo {}

unsafe impl Cast for FramebufferCreateInfo {
    type Target = FramebufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for FramebufferCreateInfo {
    type Builder = FramebufferCreateInfoBuilder<'b>;
}

/// A builder for a [`FramebufferCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FramebufferCreateInfoBuilder<'b> {
    value: FramebufferCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> FramebufferCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsFramebufferCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<FramebufferCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: FramebufferCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.value.render_pass = render_pass;
        self
    }

    #[inline]
    pub fn attachments(mut self, attachments: &'b [ImageView]) -> Self {
        self.value.attachment_count = attachments.len() as u32;
        self.value.attachments = attachments.as_ptr();
        self
    }

    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.value.width = width;
        self
    }

    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.value.height = height;
        self
    }

    #[inline]
    pub fn layers(mut self, layers: u32) -> Self {
        self.value.layers = layers;
        self
    }

    #[inline]
    pub fn build(self) -> FramebufferCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for FramebufferCreateInfoBuilder<'b> {
    type Target = FramebufferCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for FramebufferCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for FramebufferCreateInfoBuilder<'b> {
    type Target = FramebufferCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for FramebufferMixedSamplesCombinationNV {
    type Target = FramebufferMixedSamplesCombinationNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for FramebufferMixedSamplesCombinationNV {
    type Builder = FramebufferMixedSamplesCombinationNVBuilder;
}

/// A builder for a [`FramebufferMixedSamplesCombinationNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct FramebufferMixedSamplesCombinationNVBuilder {
    value: FramebufferMixedSamplesCombinationNV,
}

impl FramebufferMixedSamplesCombinationNVBuilder {
    #[inline]
    pub fn coverage_reduction_mode(
        mut self,
        coverage_reduction_mode: CoverageReductionModeNV,
    ) -> Self {
        self.value.coverage_reduction_mode = coverage_reduction_mode;
        self
    }

    #[inline]
    pub fn rasterization_samples(mut self, rasterization_samples: SampleCountFlags) -> Self {
        self.value.rasterization_samples = rasterization_samples;
        self
    }

    #[inline]
    pub fn depth_stencil_samples(mut self, depth_stencil_samples: SampleCountFlags) -> Self {
        self.value.depth_stencil_samples = depth_stencil_samples;
        self
    }

    #[inline]
    pub fn color_samples(mut self, color_samples: SampleCountFlags) -> Self {
        self.value.color_samples = color_samples;
        self
    }

    #[inline]
    pub fn build(self) -> FramebufferMixedSamplesCombinationNV {
        self.value
    }
}

impl ops::Deref for FramebufferMixedSamplesCombinationNVBuilder {
    type Target = FramebufferMixedSamplesCombinationNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for FramebufferMixedSamplesCombinationNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for FramebufferMixedSamplesCombinationNVBuilder {
    type Target = FramebufferMixedSamplesCombinationNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeneratedCommandsInfoNV {
    type Target = GeneratedCommandsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for GeneratedCommandsInfoNV {
    type Builder = GeneratedCommandsInfoNVBuilder<'b>;
}

/// A builder for a [`GeneratedCommandsInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeneratedCommandsInfoNVBuilder<'b> {
    value: GeneratedCommandsInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> GeneratedCommandsInfoNVBuilder<'b> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.value.pipeline_bind_point = pipeline_bind_point;
        self
    }

    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.value.pipeline = pipeline;
        self
    }

    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.value.indirect_commands_layout = indirect_commands_layout;
        self
    }

    #[inline]
    pub fn streams(mut self, streams: &'b [impl Cast<Target = IndirectCommandsStreamNV>]) -> Self {
        self.value.stream_count = streams.len() as u32;
        self.value.streams = streams.as_ptr().cast();
        self
    }

    #[inline]
    pub fn sequences_count(mut self, sequences_count: u32) -> Self {
        self.value.sequences_count = sequences_count;
        self
    }

    #[inline]
    pub fn preprocess_buffer(mut self, preprocess_buffer: Buffer) -> Self {
        self.value.preprocess_buffer = preprocess_buffer;
        self
    }

    #[inline]
    pub fn preprocess_offset(mut self, preprocess_offset: DeviceSize) -> Self {
        self.value.preprocess_offset = preprocess_offset;
        self
    }

    #[inline]
    pub fn preprocess_size(mut self, preprocess_size: DeviceSize) -> Self {
        self.value.preprocess_size = preprocess_size;
        self
    }

    #[inline]
    pub fn sequences_count_buffer(mut self, sequences_count_buffer: Buffer) -> Self {
        self.value.sequences_count_buffer = sequences_count_buffer;
        self
    }

    #[inline]
    pub fn sequences_count_offset(mut self, sequences_count_offset: DeviceSize) -> Self {
        self.value.sequences_count_offset = sequences_count_offset;
        self
    }

    #[inline]
    pub fn sequences_index_buffer(mut self, sequences_index_buffer: Buffer) -> Self {
        self.value.sequences_index_buffer = sequences_index_buffer;
        self
    }

    #[inline]
    pub fn sequences_index_offset(mut self, sequences_index_offset: DeviceSize) -> Self {
        self.value.sequences_index_offset = sequences_index_offset;
        self
    }

    #[inline]
    pub fn build(self) -> GeneratedCommandsInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for GeneratedCommandsInfoNVBuilder<'b> {
    type Target = GeneratedCommandsInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for GeneratedCommandsInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for GeneratedCommandsInfoNVBuilder<'b> {
    type Target = GeneratedCommandsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeneratedCommandsMemoryRequirementsInfoNV {
    type Target = GeneratedCommandsMemoryRequirementsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for GeneratedCommandsMemoryRequirementsInfoNV {
    type Builder = GeneratedCommandsMemoryRequirementsInfoNVBuilder;
}

/// A builder for a [`GeneratedCommandsMemoryRequirementsInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeneratedCommandsMemoryRequirementsInfoNVBuilder {
    value: GeneratedCommandsMemoryRequirementsInfoNV,
}

impl GeneratedCommandsMemoryRequirementsInfoNVBuilder {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.value.pipeline_bind_point = pipeline_bind_point;
        self
    }

    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.value.pipeline = pipeline;
        self
    }

    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.value.indirect_commands_layout = indirect_commands_layout;
        self
    }

    #[inline]
    pub fn max_sequences_count(mut self, max_sequences_count: u32) -> Self {
        self.value.max_sequences_count = max_sequences_count;
        self
    }

    #[inline]
    pub fn build(self) -> GeneratedCommandsMemoryRequirementsInfoNV {
        self.value
    }
}

impl ops::Deref for GeneratedCommandsMemoryRequirementsInfoNVBuilder {
    type Target = GeneratedCommandsMemoryRequirementsInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for GeneratedCommandsMemoryRequirementsInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for GeneratedCommandsMemoryRequirementsInfoNVBuilder {
    type Target = GeneratedCommandsMemoryRequirementsInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeometryAABBNV {
    type Target = GeometryAABBNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for GeometryAABBNV {
    type Builder = GeometryAABBNVBuilder;
}

/// A builder for a [`GeometryAABBNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeometryAABBNVBuilder {
    value: GeometryAABBNV,
}

impl GeometryAABBNVBuilder {
    #[inline]
    pub fn aabb_data(mut self, aabb_data: Buffer) -> Self {
        self.value.aabb_data = aabb_data;
        self
    }

    #[inline]
    pub fn num_aab_bs(mut self, num_aab_bs: u32) -> Self {
        self.value.num_aab_bs = num_aab_bs;
        self
    }

    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.value.stride = stride;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn build(self) -> GeometryAABBNV {
        self.value
    }
}

impl ops::Deref for GeometryAABBNVBuilder {
    type Target = GeometryAABBNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for GeometryAABBNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for GeometryAABBNVBuilder {
    type Target = GeometryAABBNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeometryDataNV {
    type Target = GeometryDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for GeometryDataNV {
    type Builder = GeometryDataNVBuilder;
}

/// A builder for a [`GeometryDataNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeometryDataNVBuilder {
    value: GeometryDataNV,
}

impl GeometryDataNVBuilder {
    #[inline]
    pub fn triangles(mut self, triangles: impl Cast<Target = GeometryTrianglesNV>) -> Self {
        self.value.triangles = triangles.into();
        self
    }

    #[inline]
    pub fn aabbs(mut self, aabbs: impl Cast<Target = GeometryAABBNV>) -> Self {
        self.value.aabbs = aabbs.into();
        self
    }

    #[inline]
    pub fn build(self) -> GeometryDataNV {
        self.value
    }
}

impl ops::Deref for GeometryDataNVBuilder {
    type Target = GeometryDataNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for GeometryDataNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for GeometryDataNVBuilder {
    type Target = GeometryDataNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeometryNV {
    type Target = GeometryNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for GeometryNV {
    type Builder = GeometryNVBuilder;
}

/// A builder for a [`GeometryNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeometryNVBuilder {
    value: GeometryNV,
}

impl GeometryNVBuilder {
    #[inline]
    pub fn geometry_type(mut self, geometry_type: GeometryTypeKHR) -> Self {
        self.value.geometry_type = geometry_type;
        self
    }

    #[inline]
    pub fn geometry(mut self, geometry: impl Cast<Target = GeometryDataNV>) -> Self {
        self.value.geometry = geometry.into();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: GeometryFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> GeometryNV {
        self.value
    }
}

impl ops::Deref for GeometryNVBuilder {
    type Target = GeometryNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for GeometryNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for GeometryNVBuilder {
    type Target = GeometryNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GeometryTrianglesNV {
    type Target = GeometryTrianglesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for GeometryTrianglesNV {
    type Builder = GeometryTrianglesNVBuilder;
}

/// A builder for a [`GeometryTrianglesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GeometryTrianglesNVBuilder {
    value: GeometryTrianglesNV,
}

impl GeometryTrianglesNVBuilder {
    #[inline]
    pub fn vertex_data(mut self, vertex_data: Buffer) -> Self {
        self.value.vertex_data = vertex_data;
        self
    }

    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: DeviceSize) -> Self {
        self.value.vertex_offset = vertex_offset;
        self
    }

    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.value.vertex_count = vertex_count;
        self
    }

    #[inline]
    pub fn vertex_stride(mut self, vertex_stride: DeviceSize) -> Self {
        self.value.vertex_stride = vertex_stride;
        self
    }

    #[inline]
    pub fn vertex_format(mut self, vertex_format: Format) -> Self {
        self.value.vertex_format = vertex_format;
        self
    }

    #[inline]
    pub fn index_data(mut self, index_data: Buffer) -> Self {
        self.value.index_data = index_data;
        self
    }

    #[inline]
    pub fn index_offset(mut self, index_offset: DeviceSize) -> Self {
        self.value.index_offset = index_offset;
        self
    }

    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.value.index_count = index_count;
        self
    }

    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.value.index_type = index_type;
        self
    }

    #[inline]
    pub fn transform_data(mut self, transform_data: Buffer) -> Self {
        self.value.transform_data = transform_data;
        self
    }

    #[inline]
    pub fn transform_offset(mut self, transform_offset: DeviceSize) -> Self {
        self.value.transform_offset = transform_offset;
        self
    }

    #[inline]
    pub fn build(self) -> GeometryTrianglesNV {
        self.value
    }
}

impl ops::Deref for GeometryTrianglesNVBuilder {
    type Target = GeometryTrianglesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for GeometryTrianglesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for GeometryTrianglesNVBuilder {
    type Target = GeometryTrianglesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`GraphicsPipelineCreateInfo`].
pub unsafe trait ExtendsGraphicsPipelineCreateInfo: fmt::Debug {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for GraphicsPipelineShaderGroupsCreateInfoNV {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineCompilerControlCreateInfoAMD {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineCreationFeedbackCreateInfoEXT {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineDiscardRectangleStateCreateInfoEXT {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineFragmentShadingRateEnumStateCreateInfoNV {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineFragmentShadingRateStateCreateInfoKHR {}
unsafe impl ExtendsGraphicsPipelineCreateInfo
    for PipelineRepresentativeFragmentTestStateCreateInfoNV
{
}

unsafe impl Cast for GraphicsPipelineCreateInfo {
    type Target = GraphicsPipelineCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for GraphicsPipelineCreateInfo {
    type Builder = GraphicsPipelineCreateInfoBuilder<'b>;
}

/// A builder for a [`GraphicsPipelineCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GraphicsPipelineCreateInfoBuilder<'b> {
    value: GraphicsPipelineCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> GraphicsPipelineCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsGraphicsPipelineCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<GraphicsPipelineCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn stages(
        mut self,
        stages: &'b [impl Cast<Target = PipelineShaderStageCreateInfo>],
    ) -> Self {
        self.value.stage_count = stages.len() as u32;
        self.value.stages = stages.as_ptr().cast();
        self
    }

    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'b impl Cast<Target = PipelineVertexInputStateCreateInfo>,
    ) -> Self {
        self.value.vertex_input_state = vertex_input_state.as_ref();
        self
    }

    #[inline]
    pub fn input_assembly_state(
        mut self,
        input_assembly_state: &'b impl Cast<Target = PipelineInputAssemblyStateCreateInfo>,
    ) -> Self {
        self.value.input_assembly_state = input_assembly_state.as_ref();
        self
    }

    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'b impl Cast<Target = PipelineTessellationStateCreateInfo>,
    ) -> Self {
        self.value.tessellation_state = tessellation_state.as_ref();
        self
    }

    #[inline]
    pub fn viewport_state(
        mut self,
        viewport_state: &'b impl Cast<Target = PipelineViewportStateCreateInfo>,
    ) -> Self {
        self.value.viewport_state = viewport_state.as_ref();
        self
    }

    #[inline]
    pub fn rasterization_state(
        mut self,
        rasterization_state: &'b impl Cast<Target = PipelineRasterizationStateCreateInfo>,
    ) -> Self {
        self.value.rasterization_state = rasterization_state.as_ref();
        self
    }

    #[inline]
    pub fn multisample_state(
        mut self,
        multisample_state: &'b impl Cast<Target = PipelineMultisampleStateCreateInfo>,
    ) -> Self {
        self.value.multisample_state = multisample_state.as_ref();
        self
    }

    #[inline]
    pub fn depth_stencil_state(
        mut self,
        depth_stencil_state: &'b impl Cast<Target = PipelineDepthStencilStateCreateInfo>,
    ) -> Self {
        self.value.depth_stencil_state = depth_stencil_state.as_ref();
        self
    }

    #[inline]
    pub fn color_blend_state(
        mut self,
        color_blend_state: &'b impl Cast<Target = PipelineColorBlendStateCreateInfo>,
    ) -> Self {
        self.value.color_blend_state = color_blend_state.as_ref();
        self
    }

    #[inline]
    pub fn dynamic_state(
        mut self,
        dynamic_state: &'b impl Cast<Target = PipelineDynamicStateCreateInfo>,
    ) -> Self {
        self.value.dynamic_state = dynamic_state.as_ref();
        self
    }

    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.value.layout = layout;
        self
    }

    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.value.render_pass = render_pass;
        self
    }

    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.value.subpass = subpass;
        self
    }

    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.value.base_pipeline_handle = base_pipeline_handle;
        self
    }

    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.value.base_pipeline_index = base_pipeline_index;
        self
    }

    #[inline]
    pub fn build(self) -> GraphicsPipelineCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for GraphicsPipelineCreateInfoBuilder<'b> {
    type Target = GraphicsPipelineCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for GraphicsPipelineCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for GraphicsPipelineCreateInfoBuilder<'b> {
    type Target = GraphicsPipelineCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GraphicsPipelineShaderGroupsCreateInfoNV {
    type Target = GraphicsPipelineShaderGroupsCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for GraphicsPipelineShaderGroupsCreateInfoNV {
    type Builder = GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b>;
}

/// A builder for a [`GraphicsPipelineShaderGroupsCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b> {
    value: GraphicsPipelineShaderGroupsCreateInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b> {
    #[inline]
    pub fn groups(
        mut self,
        groups: &'b [impl Cast<Target = GraphicsShaderGroupCreateInfoNV>],
    ) -> Self {
        self.value.group_count = groups.len() as u32;
        self.value.groups = groups.as_ptr().cast();
        self
    }

    #[inline]
    pub fn pipelines(mut self, pipelines: &'b [Pipeline]) -> Self {
        self.value.pipeline_count = pipelines.len() as u32;
        self.value.pipelines = pipelines.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> GraphicsPipelineShaderGroupsCreateInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b> {
    type Target = GraphicsPipelineShaderGroupsCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'b> {
    type Target = GraphicsPipelineShaderGroupsCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for GraphicsShaderGroupCreateInfoNV {
    type Target = GraphicsShaderGroupCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for GraphicsShaderGroupCreateInfoNV {
    type Builder = GraphicsShaderGroupCreateInfoNVBuilder<'b>;
}

/// A builder for a [`GraphicsShaderGroupCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct GraphicsShaderGroupCreateInfoNVBuilder<'b> {
    value: GraphicsShaderGroupCreateInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> GraphicsShaderGroupCreateInfoNVBuilder<'b> {
    #[inline]
    pub fn stages(
        mut self,
        stages: &'b [impl Cast<Target = PipelineShaderStageCreateInfo>],
    ) -> Self {
        self.value.stage_count = stages.len() as u32;
        self.value.stages = stages.as_ptr().cast();
        self
    }

    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'b impl Cast<Target = PipelineVertexInputStateCreateInfo>,
    ) -> Self {
        self.value.vertex_input_state = vertex_input_state.as_ref();
        self
    }

    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'b impl Cast<Target = PipelineTessellationStateCreateInfo>,
    ) -> Self {
        self.value.tessellation_state = tessellation_state.as_ref();
        self
    }

    #[inline]
    pub fn build(self) -> GraphicsShaderGroupCreateInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for GraphicsShaderGroupCreateInfoNVBuilder<'b> {
    type Target = GraphicsShaderGroupCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for GraphicsShaderGroupCreateInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for GraphicsShaderGroupCreateInfoNVBuilder<'b> {
    type Target = GraphicsShaderGroupCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for HdrMetadataEXT {
    type Target = HdrMetadataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for HdrMetadataEXT {
    type Builder = HdrMetadataEXTBuilder;
}

/// A builder for a [`HdrMetadataEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct HdrMetadataEXTBuilder {
    value: HdrMetadataEXT,
}

impl HdrMetadataEXTBuilder {
    #[inline]
    pub fn display_primary_red(
        mut self,
        display_primary_red: impl Cast<Target = XYColorEXT>,
    ) -> Self {
        self.value.display_primary_red = display_primary_red.into();
        self
    }

    #[inline]
    pub fn display_primary_green(
        mut self,
        display_primary_green: impl Cast<Target = XYColorEXT>,
    ) -> Self {
        self.value.display_primary_green = display_primary_green.into();
        self
    }

    #[inline]
    pub fn display_primary_blue(
        mut self,
        display_primary_blue: impl Cast<Target = XYColorEXT>,
    ) -> Self {
        self.value.display_primary_blue = display_primary_blue.into();
        self
    }

    #[inline]
    pub fn white_point(mut self, white_point: impl Cast<Target = XYColorEXT>) -> Self {
        self.value.white_point = white_point.into();
        self
    }

    #[inline]
    pub fn max_luminance(mut self, max_luminance: f32) -> Self {
        self.value.max_luminance = max_luminance;
        self
    }

    #[inline]
    pub fn min_luminance(mut self, min_luminance: f32) -> Self {
        self.value.min_luminance = min_luminance;
        self
    }

    #[inline]
    pub fn max_content_light_level(mut self, max_content_light_level: f32) -> Self {
        self.value.max_content_light_level = max_content_light_level;
        self
    }

    #[inline]
    pub fn max_frame_average_light_level(mut self, max_frame_average_light_level: f32) -> Self {
        self.value.max_frame_average_light_level = max_frame_average_light_level;
        self
    }

    #[inline]
    pub fn build(self) -> HdrMetadataEXT {
        self.value
    }
}

impl ops::Deref for HdrMetadataEXTBuilder {
    type Target = HdrMetadataEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for HdrMetadataEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for HdrMetadataEXTBuilder {
    type Target = HdrMetadataEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for HeadlessSurfaceCreateInfoEXT {
    type Target = HeadlessSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for HeadlessSurfaceCreateInfoEXT {
    type Builder = HeadlessSurfaceCreateInfoEXTBuilder;
}

/// A builder for a [`HeadlessSurfaceCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct HeadlessSurfaceCreateInfoEXTBuilder {
    value: HeadlessSurfaceCreateInfoEXT,
}

impl HeadlessSurfaceCreateInfoEXTBuilder {
    #[inline]
    pub fn flags(mut self, flags: HeadlessSurfaceCreateFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> HeadlessSurfaceCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for HeadlessSurfaceCreateInfoEXTBuilder {
    type Target = HeadlessSurfaceCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for HeadlessSurfaceCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for HeadlessSurfaceCreateInfoEXTBuilder {
    type Target = HeadlessSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for IOSSurfaceCreateInfoMVK {
    type Target = IOSSurfaceCreateInfoMVK;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for IOSSurfaceCreateInfoMVK {
    type Builder = IOSSurfaceCreateInfoMVKBuilder<'b>;
}

/// A builder for a [`IOSSurfaceCreateInfoMVK`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct IOSSurfaceCreateInfoMVKBuilder<'b> {
    value: IOSSurfaceCreateInfoMVK,
    _marker: PhantomData<&'b ()>,
}

impl<'b> IOSSurfaceCreateInfoMVKBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: IOSSurfaceCreateFlagsMVK) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn view<T>(mut self, view: &'b T) -> Self {
        self.value.view = (view as *const T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> IOSSurfaceCreateInfoMVK {
        self.value
    }
}

impl<'b> ops::Deref for IOSSurfaceCreateInfoMVKBuilder<'b> {
    type Target = IOSSurfaceCreateInfoMVK;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for IOSSurfaceCreateInfoMVKBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for IOSSurfaceCreateInfoMVKBuilder<'b> {
    type Target = IOSSurfaceCreateInfoMVK;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageBlit {
    type Target = ImageBlit;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageBlit {
    type Builder = ImageBlitBuilder;
}

/// A builder for a [`ImageBlit`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageBlitBuilder {
    value: ImageBlit,
}

impl ImageBlitBuilder {
    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offsets(mut self, src_offsets: [Offset3D; 2]) -> Self {
        self.value.src_offsets = src_offsets;
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offsets(mut self, dst_offsets: [Offset3D; 2]) -> Self {
        self.value.dst_offsets = dst_offsets;
        self
    }

    #[inline]
    pub fn build(self) -> ImageBlit {
        self.value
    }
}

impl ops::Deref for ImageBlitBuilder {
    type Target = ImageBlit;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageBlitBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageBlitBuilder {
    type Target = ImageBlit;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageBlit2KHR`].
pub unsafe trait ExtendsImageBlit2KHR: fmt::Debug {}
unsafe impl ExtendsImageBlit2KHR for CopyCommandTransformInfoQCOM {}

unsafe impl Cast for ImageBlit2KHR {
    type Target = ImageBlit2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageBlit2KHR {
    type Builder = ImageBlit2KHRBuilder<'b>;
}

/// A builder for a [`ImageBlit2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageBlit2KHRBuilder<'b> {
    value: ImageBlit2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageBlit2KHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageBlit2KHR,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageBlit2KHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offsets(mut self, src_offsets: [Offset3D; 2]) -> Self {
        self.value.src_offsets = src_offsets;
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offsets(mut self, dst_offsets: [Offset3D; 2]) -> Self {
        self.value.dst_offsets = dst_offsets;
        self
    }

    #[inline]
    pub fn build(self) -> ImageBlit2KHR {
        self.value
    }
}

impl<'b> ops::Deref for ImageBlit2KHRBuilder<'b> {
    type Target = ImageBlit2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageBlit2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageBlit2KHRBuilder<'b> {
    type Target = ImageBlit2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageCopy {
    type Target = ImageCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageCopy {
    type Builder = ImageCopyBuilder;
}

/// A builder for a [`ImageCopy`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageCopyBuilder {
    value: ImageCopy,
}

impl ImageCopyBuilder {
    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offset(mut self, src_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.src_offset = src_offset.into();
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.dst_offset = dst_offset.into();
        self
    }

    #[inline]
    pub fn extent(mut self, extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.extent = extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageCopy {
        self.value
    }
}

impl ops::Deref for ImageCopyBuilder {
    type Target = ImageCopy;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageCopyBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageCopyBuilder {
    type Target = ImageCopy;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageCopy2KHR {
    type Target = ImageCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageCopy2KHR {
    type Builder = ImageCopy2KHRBuilder;
}

/// A builder for a [`ImageCopy2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageCopy2KHRBuilder {
    value: ImageCopy2KHR,
}

impl ImageCopy2KHRBuilder {
    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offset(mut self, src_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.src_offset = src_offset.into();
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.dst_offset = dst_offset.into();
        self
    }

    #[inline]
    pub fn extent(mut self, extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.extent = extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageCopy2KHR {
        self.value
    }
}

impl ops::Deref for ImageCopy2KHRBuilder {
    type Target = ImageCopy2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageCopy2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageCopy2KHRBuilder {
    type Target = ImageCopy2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageCreateInfo`].
pub unsafe trait ExtendsImageCreateInfo: fmt::Debug {}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNV {}
unsafe impl ExtendsImageCreateInfo for ExternalFormatANDROID {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfo {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNV {}
unsafe impl ExtendsImageCreateInfo for ImageDrmFormatModifierExplicitCreateInfoEXT {}
unsafe impl ExtendsImageCreateInfo for ImageDrmFormatModifierListCreateInfoEXT {}
unsafe impl ExtendsImageCreateInfo for ImageFormatListCreateInfo {}
unsafe impl ExtendsImageCreateInfo for ImageStencilUsageCreateInfo {}
unsafe impl ExtendsImageCreateInfo for ImageSwapchainCreateInfoKHR {}

unsafe impl Cast for ImageCreateInfo {
    type Target = ImageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageCreateInfo {
    type Builder = ImageCreateInfoBuilder<'b>;
}

/// A builder for a [`ImageCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageCreateInfoBuilder<'b> {
    value: ImageCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn image_type(mut self, image_type: ImageType) -> Self {
        self.value.image_type = image_type;
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn extent(mut self, extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.extent = extent.into();
        self
    }

    #[inline]
    pub fn mip_levels(mut self, mip_levels: u32) -> Self {
        self.value.mip_levels = mip_levels;
        self
    }

    #[inline]
    pub fn array_layers(mut self, array_layers: u32) -> Self {
        self.value.array_layers = array_layers;
        self
    }

    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.value.samples = samples;
        self
    }

    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.value.tiling = tiling;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.value.sharing_mode = sharing_mode;
        self
    }

    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'b [u32]) -> Self {
        self.value.queue_family_index_count = queue_family_indices.len() as u32;
        self.value.queue_family_indices = queue_family_indices.as_ptr();
        self
    }

    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.value.initial_layout = initial_layout;
        self
    }

    #[inline]
    pub fn build(self) -> ImageCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for ImageCreateInfoBuilder<'b> {
    type Target = ImageCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageCreateInfoBuilder<'b> {
    type Target = ImageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageDrmFormatModifierExplicitCreateInfoEXT {
    type Target = ImageDrmFormatModifierExplicitCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageDrmFormatModifierExplicitCreateInfoEXT {
    type Builder = ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`ImageDrmFormatModifierExplicitCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b> {
    value: ImageDrmFormatModifierExplicitCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.value.drm_format_modifier = drm_format_modifier;
        self
    }

    #[inline]
    pub fn plane_layouts(
        mut self,
        plane_layouts: &'b [impl Cast<Target = SubresourceLayout>],
    ) -> Self {
        self.value.drm_format_modifier_plane_count = plane_layouts.len() as u32;
        self.value.plane_layouts = plane_layouts.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> ImageDrmFormatModifierExplicitCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b> {
    type Target = ImageDrmFormatModifierExplicitCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageDrmFormatModifierExplicitCreateInfoEXTBuilder<'b> {
    type Target = ImageDrmFormatModifierExplicitCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageDrmFormatModifierListCreateInfoEXT {
    type Target = ImageDrmFormatModifierListCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageDrmFormatModifierListCreateInfoEXT {
    type Builder = ImageDrmFormatModifierListCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`ImageDrmFormatModifierListCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageDrmFormatModifierListCreateInfoEXTBuilder<'b> {
    value: ImageDrmFormatModifierListCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageDrmFormatModifierListCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn drm_format_modifiers(mut self, drm_format_modifiers: &'b [u64]) -> Self {
        self.value.drm_format_modifier_count = drm_format_modifiers.len() as u32;
        self.value.drm_format_modifiers = drm_format_modifiers.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> ImageDrmFormatModifierListCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for ImageDrmFormatModifierListCreateInfoEXTBuilder<'b> {
    type Target = ImageDrmFormatModifierListCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageDrmFormatModifierListCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageDrmFormatModifierListCreateInfoEXTBuilder<'b> {
    type Target = ImageDrmFormatModifierListCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageDrmFormatModifierPropertiesEXT {
    type Target = ImageDrmFormatModifierPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageDrmFormatModifierPropertiesEXT {
    type Builder = ImageDrmFormatModifierPropertiesEXTBuilder;
}

/// A builder for a [`ImageDrmFormatModifierPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageDrmFormatModifierPropertiesEXTBuilder {
    value: ImageDrmFormatModifierPropertiesEXT,
}

impl ImageDrmFormatModifierPropertiesEXTBuilder {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.value.drm_format_modifier = drm_format_modifier;
        self
    }

    #[inline]
    pub fn build(self) -> ImageDrmFormatModifierPropertiesEXT {
        self.value
    }
}

impl ops::Deref for ImageDrmFormatModifierPropertiesEXTBuilder {
    type Target = ImageDrmFormatModifierPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageDrmFormatModifierPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageDrmFormatModifierPropertiesEXTBuilder {
    type Target = ImageDrmFormatModifierPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageFormatListCreateInfo {
    type Target = ImageFormatListCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageFormatListCreateInfo {
    type Builder = ImageFormatListCreateInfoBuilder<'b>;
}

/// A builder for a [`ImageFormatListCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageFormatListCreateInfoBuilder<'b> {
    value: ImageFormatListCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageFormatListCreateInfoBuilder<'b> {
    #[inline]
    pub fn view_formats(mut self, view_formats: &'b [Format]) -> Self {
        self.value.view_format_count = view_formats.len() as u32;
        self.value.view_formats = view_formats.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> ImageFormatListCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for ImageFormatListCreateInfoBuilder<'b> {
    type Target = ImageFormatListCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageFormatListCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageFormatListCreateInfoBuilder<'b> {
    type Target = ImageFormatListCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageFormatProperties {
    type Target = ImageFormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageFormatProperties {
    type Builder = ImageFormatPropertiesBuilder;
}

/// A builder for a [`ImageFormatProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageFormatPropertiesBuilder {
    value: ImageFormatProperties,
}

impl ImageFormatPropertiesBuilder {
    #[inline]
    pub fn max_extent(mut self, max_extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.max_extent = max_extent.into();
        self
    }

    #[inline]
    pub fn max_mip_levels(mut self, max_mip_levels: u32) -> Self {
        self.value.max_mip_levels = max_mip_levels;
        self
    }

    #[inline]
    pub fn max_array_layers(mut self, max_array_layers: u32) -> Self {
        self.value.max_array_layers = max_array_layers;
        self
    }

    #[inline]
    pub fn sample_counts(mut self, sample_counts: SampleCountFlags) -> Self {
        self.value.sample_counts = sample_counts;
        self
    }

    #[inline]
    pub fn max_resource_size(mut self, max_resource_size: DeviceSize) -> Self {
        self.value.max_resource_size = max_resource_size;
        self
    }

    #[inline]
    pub fn build(self) -> ImageFormatProperties {
        self.value
    }
}

impl ops::Deref for ImageFormatPropertiesBuilder {
    type Target = ImageFormatProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageFormatPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageFormatPropertiesBuilder {
    type Target = ImageFormatProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageFormatProperties2`].
pub unsafe trait ExtendsImageFormatProperties2: fmt::Debug {}
unsafe impl ExtendsImageFormatProperties2 for AndroidHardwareBufferUsageANDROID {}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatProperties {}
unsafe impl ExtendsImageFormatProperties2 for FilterCubicImageViewImageFormatPropertiesEXT {}
unsafe impl ExtendsImageFormatProperties2 for SamplerYcbcrConversionImageFormatProperties {}
unsafe impl ExtendsImageFormatProperties2 for TextureLODGatherFormatPropertiesAMD {}

unsafe impl Cast for ImageFormatProperties2 {
    type Target = ImageFormatProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageFormatProperties2 {
    type Builder = ImageFormatProperties2Builder<'b>;
}

/// A builder for a [`ImageFormatProperties2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageFormatProperties2Builder<'b> {
    value: ImageFormatProperties2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageFormatProperties2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageFormatProperties2,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageFormatProperties2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: impl Cast<Target = ImageFormatProperties>,
    ) -> Self {
        self.value.image_format_properties = image_format_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageFormatProperties2 {
        self.value
    }
}

impl<'b> ops::Deref for ImageFormatProperties2Builder<'b> {
    type Target = ImageFormatProperties2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageFormatProperties2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageFormatProperties2Builder<'b> {
    type Target = ImageFormatProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageMemoryBarrier`].
pub unsafe trait ExtendsImageMemoryBarrier: fmt::Debug {}
unsafe impl ExtendsImageMemoryBarrier for SampleLocationsInfoEXT {}

unsafe impl Cast for ImageMemoryBarrier {
    type Target = ImageMemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageMemoryBarrier {
    type Builder = ImageMemoryBarrierBuilder<'b>;
}

/// A builder for a [`ImageMemoryBarrier`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageMemoryBarrierBuilder<'b> {
    value: ImageMemoryBarrier,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageMemoryBarrierBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageMemoryBarrier,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageMemoryBarrier>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn old_layout(mut self, old_layout: ImageLayout) -> Self {
        self.value.old_layout = old_layout;
        self
    }

    #[inline]
    pub fn new_layout(mut self, new_layout: ImageLayout) -> Self {
        self.value.new_layout = new_layout;
        self
    }

    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.value.src_queue_family_index = src_queue_family_index;
        self
    }

    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.value.dst_queue_family_index = dst_queue_family_index;
        self
    }

    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn subresource_range(
        mut self,
        subresource_range: impl Cast<Target = ImageSubresourceRange>,
    ) -> Self {
        self.value.subresource_range = subresource_range.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageMemoryBarrier {
        self.value
    }
}

impl<'b> ops::Deref for ImageMemoryBarrierBuilder<'b> {
    type Target = ImageMemoryBarrier;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageMemoryBarrierBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageMemoryBarrierBuilder<'b> {
    type Target = ImageMemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageMemoryBarrier2KHR`].
pub unsafe trait ExtendsImageMemoryBarrier2KHR: fmt::Debug {}
unsafe impl ExtendsImageMemoryBarrier2KHR for SampleLocationsInfoEXT {}

unsafe impl Cast for ImageMemoryBarrier2KHR {
    type Target = ImageMemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageMemoryBarrier2KHR {
    type Builder = ImageMemoryBarrier2KHRBuilder<'b>;
}

/// A builder for a [`ImageMemoryBarrier2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageMemoryBarrier2KHRBuilder<'b> {
    value: ImageMemoryBarrier2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageMemoryBarrier2KHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageMemoryBarrier2KHR,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageMemoryBarrier2KHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.src_stage_mask = src_stage_mask;
        self
    }

    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags2KHR) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.dst_stage_mask = dst_stage_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags2KHR) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn old_layout(mut self, old_layout: ImageLayout) -> Self {
        self.value.old_layout = old_layout;
        self
    }

    #[inline]
    pub fn new_layout(mut self, new_layout: ImageLayout) -> Self {
        self.value.new_layout = new_layout;
        self
    }

    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.value.src_queue_family_index = src_queue_family_index;
        self
    }

    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.value.dst_queue_family_index = dst_queue_family_index;
        self
    }

    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn subresource_range(
        mut self,
        subresource_range: impl Cast<Target = ImageSubresourceRange>,
    ) -> Self {
        self.value.subresource_range = subresource_range.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageMemoryBarrier2KHR {
        self.value
    }
}

impl<'b> ops::Deref for ImageMemoryBarrier2KHRBuilder<'b> {
    type Target = ImageMemoryBarrier2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageMemoryBarrier2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageMemoryBarrier2KHRBuilder<'b> {
    type Target = ImageMemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageMemoryRequirementsInfo2`].
pub unsafe trait ExtendsImageMemoryRequirementsInfo2: fmt::Debug {}
unsafe impl ExtendsImageMemoryRequirementsInfo2 for ImagePlaneMemoryRequirementsInfo {}

unsafe impl Cast for ImageMemoryRequirementsInfo2 {
    type Target = ImageMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageMemoryRequirementsInfo2 {
    type Builder = ImageMemoryRequirementsInfo2Builder<'b>;
}

/// A builder for a [`ImageMemoryRequirementsInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageMemoryRequirementsInfo2Builder<'b> {
    value: ImageMemoryRequirementsInfo2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageMemoryRequirementsInfo2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageMemoryRequirementsInfo2,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageMemoryRequirementsInfo2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn build(self) -> ImageMemoryRequirementsInfo2 {
        self.value
    }
}

impl<'b> ops::Deref for ImageMemoryRequirementsInfo2Builder<'b> {
    type Target = ImageMemoryRequirementsInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageMemoryRequirementsInfo2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageMemoryRequirementsInfo2Builder<'b> {
    type Target = ImageMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImagePipeSurfaceCreateInfoFUCHSIA {
    type Target = ImagePipeSurfaceCreateInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImagePipeSurfaceCreateInfoFUCHSIA {
    type Builder = ImagePipeSurfaceCreateInfoFUCHSIABuilder;
}

/// A builder for a [`ImagePipeSurfaceCreateInfoFUCHSIA`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImagePipeSurfaceCreateInfoFUCHSIABuilder {
    value: ImagePipeSurfaceCreateInfoFUCHSIA,
}

impl ImagePipeSurfaceCreateInfoFUCHSIABuilder {
    #[inline]
    pub fn flags(mut self, flags: ImagePipeSurfaceCreateFlagsFUCHSIA) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn image_pipe_handle(mut self, image_pipe_handle: zx_handle_t) -> Self {
        self.value.image_pipe_handle = image_pipe_handle;
        self
    }

    #[inline]
    pub fn build(self) -> ImagePipeSurfaceCreateInfoFUCHSIA {
        self.value
    }
}

impl ops::Deref for ImagePipeSurfaceCreateInfoFUCHSIABuilder {
    type Target = ImagePipeSurfaceCreateInfoFUCHSIA;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImagePipeSurfaceCreateInfoFUCHSIABuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImagePipeSurfaceCreateInfoFUCHSIABuilder {
    type Target = ImagePipeSurfaceCreateInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImagePlaneMemoryRequirementsInfo {
    type Target = ImagePlaneMemoryRequirementsInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImagePlaneMemoryRequirementsInfo {
    type Builder = ImagePlaneMemoryRequirementsInfoBuilder;
}

/// A builder for a [`ImagePlaneMemoryRequirementsInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImagePlaneMemoryRequirementsInfoBuilder {
    value: ImagePlaneMemoryRequirementsInfo,
}

impl ImagePlaneMemoryRequirementsInfoBuilder {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.value.plane_aspect = plane_aspect;
        self
    }

    #[inline]
    pub fn build(self) -> ImagePlaneMemoryRequirementsInfo {
        self.value
    }
}

impl ops::Deref for ImagePlaneMemoryRequirementsInfoBuilder {
    type Target = ImagePlaneMemoryRequirementsInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImagePlaneMemoryRequirementsInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImagePlaneMemoryRequirementsInfoBuilder {
    type Target = ImagePlaneMemoryRequirementsInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageResolve {
    type Target = ImageResolve;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageResolve {
    type Builder = ImageResolveBuilder;
}

/// A builder for a [`ImageResolve`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageResolveBuilder {
    value: ImageResolve,
}

impl ImageResolveBuilder {
    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offset(mut self, src_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.src_offset = src_offset.into();
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.dst_offset = dst_offset.into();
        self
    }

    #[inline]
    pub fn extent(mut self, extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.extent = extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageResolve {
        self.value
    }
}

impl ops::Deref for ImageResolveBuilder {
    type Target = ImageResolve;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageResolveBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageResolveBuilder {
    type Target = ImageResolve;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageResolve2KHR {
    type Target = ImageResolve2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageResolve2KHR {
    type Builder = ImageResolve2KHRBuilder;
}

/// A builder for a [`ImageResolve2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageResolve2KHRBuilder {
    value: ImageResolve2KHR,
}

impl ImageResolve2KHRBuilder {
    #[inline]
    pub fn src_subresource(
        mut self,
        src_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.src_subresource = src_subresource.into();
        self
    }

    #[inline]
    pub fn src_offset(mut self, src_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.src_offset = src_offset.into();
        self
    }

    #[inline]
    pub fn dst_subresource(
        mut self,
        dst_subresource: impl Cast<Target = ImageSubresourceLayers>,
    ) -> Self {
        self.value.dst_subresource = dst_subresource.into();
        self
    }

    #[inline]
    pub fn dst_offset(mut self, dst_offset: impl Cast<Target = Offset3D>) -> Self {
        self.value.dst_offset = dst_offset.into();
        self
    }

    #[inline]
    pub fn extent(mut self, extent: impl Cast<Target = Extent3D>) -> Self {
        self.value.extent = extent.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageResolve2KHR {
        self.value
    }
}

impl ops::Deref for ImageResolve2KHRBuilder {
    type Target = ImageResolve2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageResolve2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageResolve2KHRBuilder {
    type Target = ImageResolve2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageSparseMemoryRequirementsInfo2 {
    type Target = ImageSparseMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageSparseMemoryRequirementsInfo2 {
    type Builder = ImageSparseMemoryRequirementsInfo2Builder;
}

/// A builder for a [`ImageSparseMemoryRequirementsInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageSparseMemoryRequirementsInfo2Builder {
    value: ImageSparseMemoryRequirementsInfo2,
}

impl ImageSparseMemoryRequirementsInfo2Builder {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn build(self) -> ImageSparseMemoryRequirementsInfo2 {
        self.value
    }
}

impl ops::Deref for ImageSparseMemoryRequirementsInfo2Builder {
    type Target = ImageSparseMemoryRequirementsInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageSparseMemoryRequirementsInfo2Builder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageSparseMemoryRequirementsInfo2Builder {
    type Target = ImageSparseMemoryRequirementsInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageStencilUsageCreateInfo {
    type Target = ImageStencilUsageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageStencilUsageCreateInfo {
    type Builder = ImageStencilUsageCreateInfoBuilder;
}

/// A builder for a [`ImageStencilUsageCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageStencilUsageCreateInfoBuilder {
    value: ImageStencilUsageCreateInfo,
}

impl ImageStencilUsageCreateInfoBuilder {
    #[inline]
    pub fn stencil_usage(mut self, stencil_usage: ImageUsageFlags) -> Self {
        self.value.stencil_usage = stencil_usage;
        self
    }

    #[inline]
    pub fn build(self) -> ImageStencilUsageCreateInfo {
        self.value
    }
}

impl ops::Deref for ImageStencilUsageCreateInfoBuilder {
    type Target = ImageStencilUsageCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageStencilUsageCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageStencilUsageCreateInfoBuilder {
    type Target = ImageStencilUsageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageSubresource {
    type Target = ImageSubresource;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageSubresource {
    type Builder = ImageSubresourceBuilder;
}

/// A builder for a [`ImageSubresource`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageSubresourceBuilder {
    value: ImageSubresource,
}

impl ImageSubresourceBuilder {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.value.mip_level = mip_level;
        self
    }

    #[inline]
    pub fn array_layer(mut self, array_layer: u32) -> Self {
        self.value.array_layer = array_layer;
        self
    }

    #[inline]
    pub fn build(self) -> ImageSubresource {
        self.value
    }
}

impl ops::Deref for ImageSubresourceBuilder {
    type Target = ImageSubresource;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageSubresourceBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageSubresourceBuilder {
    type Target = ImageSubresource;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageSubresourceLayers {
    type Target = ImageSubresourceLayers;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageSubresourceLayers {
    type Builder = ImageSubresourceLayersBuilder;
}

/// A builder for a [`ImageSubresourceLayers`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageSubresourceLayersBuilder {
    value: ImageSubresourceLayers,
}

impl ImageSubresourceLayersBuilder {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.value.mip_level = mip_level;
        self
    }

    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.value.base_array_layer = base_array_layer;
        self
    }

    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.value.layer_count = layer_count;
        self
    }

    #[inline]
    pub fn build(self) -> ImageSubresourceLayers {
        self.value
    }
}

impl ops::Deref for ImageSubresourceLayersBuilder {
    type Target = ImageSubresourceLayers;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageSubresourceLayersBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageSubresourceLayersBuilder {
    type Target = ImageSubresourceLayers;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageSubresourceRange {
    type Target = ImageSubresourceRange;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageSubresourceRange {
    type Builder = ImageSubresourceRangeBuilder;
}

/// A builder for a [`ImageSubresourceRange`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageSubresourceRangeBuilder {
    value: ImageSubresourceRange,
}

impl ImageSubresourceRangeBuilder {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn base_mip_level(mut self, base_mip_level: u32) -> Self {
        self.value.base_mip_level = base_mip_level;
        self
    }

    #[inline]
    pub fn level_count(mut self, level_count: u32) -> Self {
        self.value.level_count = level_count;
        self
    }

    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.value.base_array_layer = base_array_layer;
        self
    }

    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.value.layer_count = layer_count;
        self
    }

    #[inline]
    pub fn build(self) -> ImageSubresourceRange {
        self.value
    }
}

impl ops::Deref for ImageSubresourceRangeBuilder {
    type Target = ImageSubresourceRange;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageSubresourceRangeBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageSubresourceRangeBuilder {
    type Target = ImageSubresourceRange;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageSwapchainCreateInfoKHR {
    type Target = ImageSwapchainCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageSwapchainCreateInfoKHR {
    type Builder = ImageSwapchainCreateInfoKHRBuilder;
}

/// A builder for a [`ImageSwapchainCreateInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageSwapchainCreateInfoKHRBuilder {
    value: ImageSwapchainCreateInfoKHR,
}

impl ImageSwapchainCreateInfoKHRBuilder {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.value.swapchain = swapchain;
        self
    }

    #[inline]
    pub fn build(self) -> ImageSwapchainCreateInfoKHR {
        self.value
    }
}

impl ops::Deref for ImageSwapchainCreateInfoKHRBuilder {
    type Target = ImageSwapchainCreateInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageSwapchainCreateInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageSwapchainCreateInfoKHRBuilder {
    type Target = ImageSwapchainCreateInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageViewASTCDecodeModeEXT {
    type Target = ImageViewASTCDecodeModeEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageViewASTCDecodeModeEXT {
    type Builder = ImageViewASTCDecodeModeEXTBuilder;
}

/// A builder for a [`ImageViewASTCDecodeModeEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageViewASTCDecodeModeEXTBuilder {
    value: ImageViewASTCDecodeModeEXT,
}

impl ImageViewASTCDecodeModeEXTBuilder {
    #[inline]
    pub fn decode_mode(mut self, decode_mode: Format) -> Self {
        self.value.decode_mode = decode_mode;
        self
    }

    #[inline]
    pub fn build(self) -> ImageViewASTCDecodeModeEXT {
        self.value
    }
}

impl ops::Deref for ImageViewASTCDecodeModeEXTBuilder {
    type Target = ImageViewASTCDecodeModeEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageViewASTCDecodeModeEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageViewASTCDecodeModeEXTBuilder {
    type Target = ImageViewASTCDecodeModeEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageViewAddressPropertiesNVX {
    type Target = ImageViewAddressPropertiesNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageViewAddressPropertiesNVX {
    type Builder = ImageViewAddressPropertiesNVXBuilder;
}

/// A builder for a [`ImageViewAddressPropertiesNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageViewAddressPropertiesNVXBuilder {
    value: ImageViewAddressPropertiesNVX,
}

impl ImageViewAddressPropertiesNVXBuilder {
    #[inline]
    pub fn device_address(mut self, device_address: DeviceAddress) -> Self {
        self.value.device_address = device_address;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> ImageViewAddressPropertiesNVX {
        self.value
    }
}

impl ops::Deref for ImageViewAddressPropertiesNVXBuilder {
    type Target = ImageViewAddressPropertiesNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageViewAddressPropertiesNVXBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageViewAddressPropertiesNVXBuilder {
    type Target = ImageViewAddressPropertiesNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`ImageViewCreateInfo`].
pub unsafe trait ExtendsImageViewCreateInfo: fmt::Debug {}
unsafe impl ExtendsImageViewCreateInfo for ImageViewASTCDecodeModeEXT {}
unsafe impl ExtendsImageViewCreateInfo for ImageViewUsageCreateInfo {}
unsafe impl ExtendsImageViewCreateInfo for SamplerYcbcrConversionInfo {}

unsafe impl Cast for ImageViewCreateInfo {
    type Target = ImageViewCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImageViewCreateInfo {
    type Builder = ImageViewCreateInfoBuilder<'b>;
}

/// A builder for a [`ImageViewCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageViewCreateInfoBuilder<'b> {
    value: ImageViewCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImageViewCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsImageViewCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<ImageViewCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: ImageViewCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn view_type(mut self, view_type: ImageViewType) -> Self {
        self.value.view_type = view_type;
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn components(mut self, components: impl Cast<Target = ComponentMapping>) -> Self {
        self.value.components = components.into();
        self
    }

    #[inline]
    pub fn subresource_range(
        mut self,
        subresource_range: impl Cast<Target = ImageSubresourceRange>,
    ) -> Self {
        self.value.subresource_range = subresource_range.into();
        self
    }

    #[inline]
    pub fn build(self) -> ImageViewCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for ImageViewCreateInfoBuilder<'b> {
    type Target = ImageViewCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImageViewCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImageViewCreateInfoBuilder<'b> {
    type Target = ImageViewCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageViewHandleInfoNVX {
    type Target = ImageViewHandleInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageViewHandleInfoNVX {
    type Builder = ImageViewHandleInfoNVXBuilder;
}

/// A builder for a [`ImageViewHandleInfoNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageViewHandleInfoNVXBuilder {
    value: ImageViewHandleInfoNVX,
}

impl ImageViewHandleInfoNVXBuilder {
    #[inline]
    pub fn image_view(mut self, image_view: ImageView) -> Self {
        self.value.image_view = image_view;
        self
    }

    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.value.descriptor_type = descriptor_type;
        self
    }

    #[inline]
    pub fn sampler(mut self, sampler: Sampler) -> Self {
        self.value.sampler = sampler;
        self
    }

    #[inline]
    pub fn build(self) -> ImageViewHandleInfoNVX {
        self.value
    }
}

impl ops::Deref for ImageViewHandleInfoNVXBuilder {
    type Target = ImageViewHandleInfoNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageViewHandleInfoNVXBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageViewHandleInfoNVXBuilder {
    type Target = ImageViewHandleInfoNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImageViewUsageCreateInfo {
    type Target = ImageViewUsageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImageViewUsageCreateInfo {
    type Builder = ImageViewUsageCreateInfoBuilder;
}

/// A builder for a [`ImageViewUsageCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImageViewUsageCreateInfoBuilder {
    value: ImageViewUsageCreateInfo,
}

impl ImageViewUsageCreateInfoBuilder {
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn build(self) -> ImageViewUsageCreateInfo {
        self.value
    }
}

impl ops::Deref for ImageViewUsageCreateInfoBuilder {
    type Target = ImageViewUsageCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImageViewUsageCreateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImageViewUsageCreateInfoBuilder {
    type Target = ImageViewUsageCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportAndroidHardwareBufferInfoANDROID {
    type Target = ImportAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImportAndroidHardwareBufferInfoANDROID {
    type Builder = ImportAndroidHardwareBufferInfoANDROIDBuilder<'b>;
}

/// A builder for a [`ImportAndroidHardwareBufferInfoANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportAndroidHardwareBufferInfoANDROIDBuilder<'b> {
    value: ImportAndroidHardwareBufferInfoANDROID,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImportAndroidHardwareBufferInfoANDROIDBuilder<'b> {
    #[inline]
    pub fn buffer(mut self, buffer: *mut AHardwareBuffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn build(self) -> ImportAndroidHardwareBufferInfoANDROID {
        self.value
    }
}

impl<'b> ops::Deref for ImportAndroidHardwareBufferInfoANDROIDBuilder<'b> {
    type Target = ImportAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImportAndroidHardwareBufferInfoANDROIDBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImportAndroidHardwareBufferInfoANDROIDBuilder<'b> {
    type Target = ImportAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportFenceFdInfoKHR {
    type Target = ImportFenceFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportFenceFdInfoKHR {
    type Builder = ImportFenceFdInfoKHRBuilder;
}

/// A builder for a [`ImportFenceFdInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportFenceFdInfoKHRBuilder {
    value: ImportFenceFdInfoKHR,
}

impl ImportFenceFdInfoKHRBuilder {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.value.fence = fence;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.value.fd = fd;
        self
    }

    #[inline]
    pub fn build(self) -> ImportFenceFdInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportFenceFdInfoKHRBuilder {
    type Target = ImportFenceFdInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportFenceFdInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportFenceFdInfoKHRBuilder {
    type Target = ImportFenceFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportFenceWin32HandleInfoKHR {
    type Target = ImportFenceWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportFenceWin32HandleInfoKHR {
    type Builder = ImportFenceWin32HandleInfoKHRBuilder;
}

/// A builder for a [`ImportFenceWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportFenceWin32HandleInfoKHRBuilder {
    value: ImportFenceWin32HandleInfoKHR,
}

impl ImportFenceWin32HandleInfoKHRBuilder {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.value.fence = fence;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.value.handle = handle;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ImportFenceWin32HandleInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportFenceWin32HandleInfoKHRBuilder {
    type Target = ImportFenceWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportFenceWin32HandleInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportFenceWin32HandleInfoKHRBuilder {
    type Target = ImportFenceWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportMemoryFdInfoKHR {
    type Target = ImportMemoryFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportMemoryFdInfoKHR {
    type Builder = ImportMemoryFdInfoKHRBuilder;
}

/// A builder for a [`ImportMemoryFdInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportMemoryFdInfoKHRBuilder {
    value: ImportMemoryFdInfoKHR,
}

impl ImportMemoryFdInfoKHRBuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.value.fd = fd;
        self
    }

    #[inline]
    pub fn build(self) -> ImportMemoryFdInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportMemoryFdInfoKHRBuilder {
    type Target = ImportMemoryFdInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportMemoryFdInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportMemoryFdInfoKHRBuilder {
    type Target = ImportMemoryFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportMemoryHostPointerInfoEXT {
    type Target = ImportMemoryHostPointerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for ImportMemoryHostPointerInfoEXT {
    type Builder = ImportMemoryHostPointerInfoEXTBuilder<'b>;
}

/// A builder for a [`ImportMemoryHostPointerInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportMemoryHostPointerInfoEXTBuilder<'b> {
    value: ImportMemoryHostPointerInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> ImportMemoryHostPointerInfoEXTBuilder<'b> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn host_pointer<T>(mut self, host_pointer: &'b mut T) -> Self {
        self.value.host_pointer = (host_pointer as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> ImportMemoryHostPointerInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for ImportMemoryHostPointerInfoEXTBuilder<'b> {
    type Target = ImportMemoryHostPointerInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for ImportMemoryHostPointerInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for ImportMemoryHostPointerInfoEXTBuilder<'b> {
    type Target = ImportMemoryHostPointerInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportMemoryWin32HandleInfoKHR {
    type Target = ImportMemoryWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportMemoryWin32HandleInfoKHR {
    type Builder = ImportMemoryWin32HandleInfoKHRBuilder;
}

/// A builder for a [`ImportMemoryWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportMemoryWin32HandleInfoKHRBuilder {
    value: ImportMemoryWin32HandleInfoKHR,
}

impl ImportMemoryWin32HandleInfoKHRBuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.value.handle = handle;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ImportMemoryWin32HandleInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportMemoryWin32HandleInfoKHRBuilder {
    type Target = ImportMemoryWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportMemoryWin32HandleInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportMemoryWin32HandleInfoKHRBuilder {
    type Target = ImportMemoryWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportMemoryWin32HandleInfoNV {
    type Target = ImportMemoryWin32HandleInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportMemoryWin32HandleInfoNV {
    type Builder = ImportMemoryWin32HandleInfoNVBuilder;
}

/// A builder for a [`ImportMemoryWin32HandleInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportMemoryWin32HandleInfoNVBuilder {
    value: ImportMemoryWin32HandleInfoNV,
}

impl ImportMemoryWin32HandleInfoNVBuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.value.handle = handle;
        self
    }

    #[inline]
    pub fn build(self) -> ImportMemoryWin32HandleInfoNV {
        self.value
    }
}

impl ops::Deref for ImportMemoryWin32HandleInfoNVBuilder {
    type Target = ImportMemoryWin32HandleInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportMemoryWin32HandleInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportMemoryWin32HandleInfoNVBuilder {
    type Target = ImportMemoryWin32HandleInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportMemoryZirconHandleInfoFUCHSIA {
    type Target = ImportMemoryZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportMemoryZirconHandleInfoFUCHSIA {
    type Builder = ImportMemoryZirconHandleInfoFUCHSIABuilder;
}

/// A builder for a [`ImportMemoryZirconHandleInfoFUCHSIA`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportMemoryZirconHandleInfoFUCHSIABuilder {
    value: ImportMemoryZirconHandleInfoFUCHSIA,
}

impl ImportMemoryZirconHandleInfoFUCHSIABuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn handle(mut self, handle: zx_handle_t) -> Self {
        self.value.handle = handle;
        self
    }

    #[inline]
    pub fn build(self) -> ImportMemoryZirconHandleInfoFUCHSIA {
        self.value
    }
}

impl ops::Deref for ImportMemoryZirconHandleInfoFUCHSIABuilder {
    type Target = ImportMemoryZirconHandleInfoFUCHSIA;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportMemoryZirconHandleInfoFUCHSIABuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportMemoryZirconHandleInfoFUCHSIABuilder {
    type Target = ImportMemoryZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportSemaphoreFdInfoKHR {
    type Target = ImportSemaphoreFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportSemaphoreFdInfoKHR {
    type Builder = ImportSemaphoreFdInfoKHRBuilder;
}

/// A builder for a [`ImportSemaphoreFdInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportSemaphoreFdInfoKHRBuilder {
    value: ImportSemaphoreFdInfoKHR,
}

impl ImportSemaphoreFdInfoKHRBuilder {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.value.semaphore = semaphore;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.value.fd = fd;
        self
    }

    #[inline]
    pub fn build(self) -> ImportSemaphoreFdInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportSemaphoreFdInfoKHRBuilder {
    type Target = ImportSemaphoreFdInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportSemaphoreFdInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportSemaphoreFdInfoKHRBuilder {
    type Target = ImportSemaphoreFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportSemaphoreWin32HandleInfoKHR {
    type Target = ImportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportSemaphoreWin32HandleInfoKHR {
    type Builder = ImportSemaphoreWin32HandleInfoKHRBuilder;
}

/// A builder for a [`ImportSemaphoreWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportSemaphoreWin32HandleInfoKHRBuilder {
    value: ImportSemaphoreWin32HandleInfoKHR,
}

impl ImportSemaphoreWin32HandleInfoKHRBuilder {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.value.semaphore = semaphore;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.value.handle = handle;
        self
    }

    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.value.name = name;
        self
    }

    #[inline]
    pub fn build(self) -> ImportSemaphoreWin32HandleInfoKHR {
        self.value
    }
}

impl ops::Deref for ImportSemaphoreWin32HandleInfoKHRBuilder {
    type Target = ImportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportSemaphoreWin32HandleInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportSemaphoreWin32HandleInfoKHRBuilder {
    type Target = ImportSemaphoreWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for ImportSemaphoreZirconHandleInfoFUCHSIA {
    type Target = ImportSemaphoreZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for ImportSemaphoreZirconHandleInfoFUCHSIA {
    type Builder = ImportSemaphoreZirconHandleInfoFUCHSIABuilder;
}

/// A builder for a [`ImportSemaphoreZirconHandleInfoFUCHSIA`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
    value: ImportSemaphoreZirconHandleInfoFUCHSIA,
}

impl ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.value.semaphore = semaphore;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn zircon_handle(mut self, zircon_handle: zx_handle_t) -> Self {
        self.value.zircon_handle = zircon_handle;
        self
    }

    #[inline]
    pub fn build(self) -> ImportSemaphoreZirconHandleInfoFUCHSIA {
        self.value
    }
}

impl ops::Deref for ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
    type Target = ImportSemaphoreZirconHandleInfoFUCHSIA;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
    type Target = ImportSemaphoreZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for IndirectCommandsLayoutCreateInfoNV {
    type Target = IndirectCommandsLayoutCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for IndirectCommandsLayoutCreateInfoNV {
    type Builder = IndirectCommandsLayoutCreateInfoNVBuilder<'b>;
}

/// A builder for a [`IndirectCommandsLayoutCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct IndirectCommandsLayoutCreateInfoNVBuilder<'b> {
    value: IndirectCommandsLayoutCreateInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> IndirectCommandsLayoutCreateInfoNVBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: IndirectCommandsLayoutUsageFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.value.pipeline_bind_point = pipeline_bind_point;
        self
    }

    #[inline]
    pub fn tokens(
        mut self,
        tokens: &'b [impl Cast<Target = IndirectCommandsLayoutTokenNV>],
    ) -> Self {
        self.value.token_count = tokens.len() as u32;
        self.value.tokens = tokens.as_ptr().cast();
        self
    }

    #[inline]
    pub fn stream_strides(mut self, stream_strides: &'b [u32]) -> Self {
        self.value.stream_count = stream_strides.len() as u32;
        self.value.stream_strides = stream_strides.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> IndirectCommandsLayoutCreateInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for IndirectCommandsLayoutCreateInfoNVBuilder<'b> {
    type Target = IndirectCommandsLayoutCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for IndirectCommandsLayoutCreateInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for IndirectCommandsLayoutCreateInfoNVBuilder<'b> {
    type Target = IndirectCommandsLayoutCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for IndirectCommandsLayoutTokenNV {
    type Target = IndirectCommandsLayoutTokenNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for IndirectCommandsLayoutTokenNV {
    type Builder = IndirectCommandsLayoutTokenNVBuilder<'b>;
}

/// A builder for a [`IndirectCommandsLayoutTokenNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct IndirectCommandsLayoutTokenNVBuilder<'b> {
    value: IndirectCommandsLayoutTokenNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> IndirectCommandsLayoutTokenNVBuilder<'b> {
    #[inline]
    pub fn token_type(mut self, token_type: IndirectCommandsTokenTypeNV) -> Self {
        self.value.token_type = token_type;
        self
    }

    #[inline]
    pub fn stream(mut self, stream: u32) -> Self {
        self.value.stream = stream;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn vertex_binding_unit(mut self, vertex_binding_unit: u32) -> Self {
        self.value.vertex_binding_unit = vertex_binding_unit;
        self
    }

    #[inline]
    pub fn vertex_dynamic_stride(mut self, vertex_dynamic_stride: bool) -> Self {
        self.value.vertex_dynamic_stride = vertex_dynamic_stride as Bool32;
        self
    }

    #[inline]
    pub fn pushconstant_pipeline_layout(
        mut self,
        pushconstant_pipeline_layout: PipelineLayout,
    ) -> Self {
        self.value.pushconstant_pipeline_layout = pushconstant_pipeline_layout;
        self
    }

    #[inline]
    pub fn pushconstant_shader_stage_flags(
        mut self,
        pushconstant_shader_stage_flags: ShaderStageFlags,
    ) -> Self {
        self.value.pushconstant_shader_stage_flags = pushconstant_shader_stage_flags;
        self
    }

    #[inline]
    pub fn pushconstant_offset(mut self, pushconstant_offset: u32) -> Self {
        self.value.pushconstant_offset = pushconstant_offset;
        self
    }

    #[inline]
    pub fn pushconstant_size(mut self, pushconstant_size: u32) -> Self {
        self.value.pushconstant_size = pushconstant_size;
        self
    }

    #[inline]
    pub fn indirect_state_flags(mut self, indirect_state_flags: IndirectStateFlagsNV) -> Self {
        self.value.indirect_state_flags = indirect_state_flags;
        self
    }

    #[inline]
    pub fn index_types(mut self, index_types: &'b [IndexType]) -> Self {
        self.value.index_type_count = index_types.len() as u32;
        self.value.index_types = index_types.as_ptr();
        self
    }

    #[inline]
    pub fn index_type_values(mut self, index_type_values: &'b [u32]) -> Self {
        self.value.index_type_count = index_type_values.len() as u32;
        self.value.index_type_values = index_type_values.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> IndirectCommandsLayoutTokenNV {
        self.value
    }
}

impl<'b> ops::Deref for IndirectCommandsLayoutTokenNVBuilder<'b> {
    type Target = IndirectCommandsLayoutTokenNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for IndirectCommandsLayoutTokenNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for IndirectCommandsLayoutTokenNVBuilder<'b> {
    type Target = IndirectCommandsLayoutTokenNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for IndirectCommandsStreamNV {
    type Target = IndirectCommandsStreamNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for IndirectCommandsStreamNV {
    type Builder = IndirectCommandsStreamNVBuilder;
}

/// A builder for a [`IndirectCommandsStreamNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct IndirectCommandsStreamNVBuilder {
    value: IndirectCommandsStreamNV,
}

impl IndirectCommandsStreamNVBuilder {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn build(self) -> IndirectCommandsStreamNV {
        self.value
    }
}

impl ops::Deref for IndirectCommandsStreamNVBuilder {
    type Target = IndirectCommandsStreamNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for IndirectCommandsStreamNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for IndirectCommandsStreamNVBuilder {
    type Target = IndirectCommandsStreamNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for InitializePerformanceApiInfoINTEL {
    type Target = InitializePerformanceApiInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for InitializePerformanceApiInfoINTEL {
    type Builder = InitializePerformanceApiInfoINTELBuilder<'b>;
}

/// A builder for a [`InitializePerformanceApiInfoINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct InitializePerformanceApiInfoINTELBuilder<'b> {
    value: InitializePerformanceApiInfoINTEL,
    _marker: PhantomData<&'b ()>,
}

impl<'b> InitializePerformanceApiInfoINTELBuilder<'b> {
    #[inline]
    pub fn user_data<T>(mut self, user_data: &'b mut T) -> Self {
        self.value.user_data = (user_data as *mut T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> InitializePerformanceApiInfoINTEL {
        self.value
    }
}

impl<'b> ops::Deref for InitializePerformanceApiInfoINTELBuilder<'b> {
    type Target = InitializePerformanceApiInfoINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for InitializePerformanceApiInfoINTELBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for InitializePerformanceApiInfoINTELBuilder<'b> {
    type Target = InitializePerformanceApiInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for InputAttachmentAspectReference {
    type Target = InputAttachmentAspectReference;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for InputAttachmentAspectReference {
    type Builder = InputAttachmentAspectReferenceBuilder;
}

/// A builder for a [`InputAttachmentAspectReference`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct InputAttachmentAspectReferenceBuilder {
    value: InputAttachmentAspectReference,
}

impl InputAttachmentAspectReferenceBuilder {
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.value.subpass = subpass;
        self
    }

    #[inline]
    pub fn input_attachment_index(mut self, input_attachment_index: u32) -> Self {
        self.value.input_attachment_index = input_attachment_index;
        self
    }

    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.value.aspect_mask = aspect_mask;
        self
    }

    #[inline]
    pub fn build(self) -> InputAttachmentAspectReference {
        self.value
    }
}

impl ops::Deref for InputAttachmentAspectReferenceBuilder {
    type Target = InputAttachmentAspectReference;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for InputAttachmentAspectReferenceBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for InputAttachmentAspectReferenceBuilder {
    type Target = InputAttachmentAspectReference;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`InstanceCreateInfo`].
pub unsafe trait ExtendsInstanceCreateInfo: fmt::Debug {}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXT {}
unsafe impl ExtendsInstanceCreateInfo for DebugUtilsMessengerCreateInfoEXT {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXT {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXT {}

unsafe impl Cast for InstanceCreateInfo {
    type Target = InstanceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for InstanceCreateInfo {
    type Builder = InstanceCreateInfoBuilder<'b>;
}

/// A builder for a [`InstanceCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct InstanceCreateInfoBuilder<'b> {
    value: InstanceCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> InstanceCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsInstanceCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<InstanceCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: InstanceCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn application_info(
        mut self,
        application_info: &'b impl Cast<Target = ApplicationInfo>,
    ) -> Self {
        self.value.application_info = application_info.as_ref();
        self
    }

    #[inline]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'b [*const c_char]) -> Self {
        self.value.enabled_layer_count = enabled_layer_names.len() as u32;
        self.value.enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }

    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'b [*const c_char]) -> Self {
        self.value.enabled_extension_count = enabled_extension_names.len() as u32;
        self.value.enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> InstanceCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for InstanceCreateInfoBuilder<'b> {
    type Target = InstanceCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for InstanceCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for InstanceCreateInfoBuilder<'b> {
    type Target = InstanceCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for LayerProperties {
    type Target = LayerProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for LayerProperties {
    type Builder = LayerPropertiesBuilder;
}

/// A builder for a [`LayerProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct LayerPropertiesBuilder {
    value: LayerProperties,
}

impl LayerPropertiesBuilder {
    #[inline]
    pub fn layer_name(
        mut self,
        layer_name: impl Into<StringArray<MAX_EXTENSION_NAME_SIZE>>,
    ) -> Self {
        self.value.layer_name = layer_name.into();
        self
    }

    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.value.spec_version = spec_version;
        self
    }

    #[inline]
    pub fn implementation_version(mut self, implementation_version: u32) -> Self {
        self.value.implementation_version = implementation_version;
        self
    }

    #[inline]
    pub fn description(
        mut self,
        description: impl Into<StringArray<MAX_DESCRIPTION_SIZE>>,
    ) -> Self {
        self.value.description = description.into();
        self
    }

    #[inline]
    pub fn build(self) -> LayerProperties {
        self.value
    }
}

impl ops::Deref for LayerPropertiesBuilder {
    type Target = LayerProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for LayerPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for LayerPropertiesBuilder {
    type Target = LayerProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MacOSSurfaceCreateInfoMVK {
    type Target = MacOSSurfaceCreateInfoMVK;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MacOSSurfaceCreateInfoMVK {
    type Builder = MacOSSurfaceCreateInfoMVKBuilder<'b>;
}

/// A builder for a [`MacOSSurfaceCreateInfoMVK`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MacOSSurfaceCreateInfoMVKBuilder<'b> {
    value: MacOSSurfaceCreateInfoMVK,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MacOSSurfaceCreateInfoMVKBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: MacOSSurfaceCreateFlagsMVK) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn view<T>(mut self, view: &'b T) -> Self {
        self.value.view = (view as *const T).cast();
        self
    }

    #[inline]
    pub fn build(self) -> MacOSSurfaceCreateInfoMVK {
        self.value
    }
}

impl<'b> ops::Deref for MacOSSurfaceCreateInfoMVKBuilder<'b> {
    type Target = MacOSSurfaceCreateInfoMVK;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MacOSSurfaceCreateInfoMVKBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MacOSSurfaceCreateInfoMVKBuilder<'b> {
    type Target = MacOSSurfaceCreateInfoMVK;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MappedMemoryRange {
    type Target = MappedMemoryRange;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MappedMemoryRange {
    type Builder = MappedMemoryRangeBuilder;
}

/// A builder for a [`MappedMemoryRange`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MappedMemoryRangeBuilder {
    value: MappedMemoryRange,
}

impl MappedMemoryRangeBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.value.offset = offset;
        self
    }

    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn build(self) -> MappedMemoryRange {
        self.value
    }
}

impl ops::Deref for MappedMemoryRangeBuilder {
    type Target = MappedMemoryRange;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MappedMemoryRangeBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MappedMemoryRangeBuilder {
    type Target = MappedMemoryRange;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryAllocateFlagsInfo {
    type Target = MemoryAllocateFlagsInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryAllocateFlagsInfo {
    type Builder = MemoryAllocateFlagsInfoBuilder;
}

/// A builder for a [`MemoryAllocateFlagsInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryAllocateFlagsInfoBuilder {
    value: MemoryAllocateFlagsInfo,
}

impl MemoryAllocateFlagsInfoBuilder {
    #[inline]
    pub fn flags(mut self, flags: MemoryAllocateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.value.device_mask = device_mask;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryAllocateFlagsInfo {
        self.value
    }
}

impl ops::Deref for MemoryAllocateFlagsInfoBuilder {
    type Target = MemoryAllocateFlagsInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryAllocateFlagsInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryAllocateFlagsInfoBuilder {
    type Target = MemoryAllocateFlagsInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`MemoryAllocateInfo`].
pub unsafe trait ExtendsMemoryAllocateInfo: fmt::Debug {}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNV {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfo {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNV {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHR {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNV {}
unsafe impl ExtendsMemoryAllocateInfo for ImportAndroidHardwareBufferInfoANDROID {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHR {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryHostPointerInfoEXT {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHR {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNV {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryZirconHandleInfoFUCHSIA {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryAllocateFlagsInfo {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryDedicatedAllocateInfo {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryOpaqueCaptureAddressAllocateInfo {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryPriorityAllocateInfoEXT {}

unsafe impl Cast for MemoryAllocateInfo {
    type Target = MemoryAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MemoryAllocateInfo {
    type Builder = MemoryAllocateInfoBuilder<'b>;
}

/// A builder for a [`MemoryAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryAllocateInfoBuilder<'b> {
    value: MemoryAllocateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MemoryAllocateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsMemoryAllocateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<MemoryAllocateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> Self {
        self.value.allocation_size = allocation_size;
        self
    }

    #[inline]
    pub fn memory_type_index(mut self, memory_type_index: u32) -> Self {
        self.value.memory_type_index = memory_type_index;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryAllocateInfo {
        self.value
    }
}

impl<'b> ops::Deref for MemoryAllocateInfoBuilder<'b> {
    type Target = MemoryAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MemoryAllocateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MemoryAllocateInfoBuilder<'b> {
    type Target = MemoryAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryBarrier {
    type Target = MemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryBarrier {
    type Builder = MemoryBarrierBuilder;
}

/// A builder for a [`MemoryBarrier`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryBarrierBuilder {
    value: MemoryBarrier,
}

impl MemoryBarrierBuilder {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryBarrier {
        self.value
    }
}

impl ops::Deref for MemoryBarrierBuilder {
    type Target = MemoryBarrier;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryBarrierBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryBarrierBuilder {
    type Target = MemoryBarrier;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryBarrier2KHR {
    type Target = MemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryBarrier2KHR {
    type Builder = MemoryBarrier2KHRBuilder;
}

/// A builder for a [`MemoryBarrier2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryBarrier2KHRBuilder {
    value: MemoryBarrier2KHR,
}

impl MemoryBarrier2KHRBuilder {
    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.src_stage_mask = src_stage_mask;
        self
    }

    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags2KHR) -> Self {
        self.value.src_access_mask = src_access_mask;
        self
    }

    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags2KHR) -> Self {
        self.value.dst_stage_mask = dst_stage_mask;
        self
    }

    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags2KHR) -> Self {
        self.value.dst_access_mask = dst_access_mask;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryBarrier2KHR {
        self.value
    }
}

impl ops::Deref for MemoryBarrier2KHRBuilder {
    type Target = MemoryBarrier2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryBarrier2KHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryBarrier2KHRBuilder {
    type Target = MemoryBarrier2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryDedicatedAllocateInfo {
    type Target = MemoryDedicatedAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryDedicatedAllocateInfo {
    type Builder = MemoryDedicatedAllocateInfoBuilder;
}

/// A builder for a [`MemoryDedicatedAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryDedicatedAllocateInfoBuilder {
    value: MemoryDedicatedAllocateInfo,
}

impl MemoryDedicatedAllocateInfoBuilder {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.value.image = image;
        self
    }

    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.value.buffer = buffer;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryDedicatedAllocateInfo {
        self.value
    }
}

impl ops::Deref for MemoryDedicatedAllocateInfoBuilder {
    type Target = MemoryDedicatedAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryDedicatedAllocateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryDedicatedAllocateInfoBuilder {
    type Target = MemoryDedicatedAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryDedicatedRequirements {
    type Target = MemoryDedicatedRequirements;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryDedicatedRequirements {
    type Builder = MemoryDedicatedRequirementsBuilder;
}

/// A builder for a [`MemoryDedicatedRequirements`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryDedicatedRequirementsBuilder {
    value: MemoryDedicatedRequirements,
}

impl MemoryDedicatedRequirementsBuilder {
    #[inline]
    pub fn prefers_dedicated_allocation(mut self, prefers_dedicated_allocation: bool) -> Self {
        self.value.prefers_dedicated_allocation = prefers_dedicated_allocation as Bool32;
        self
    }

    #[inline]
    pub fn requires_dedicated_allocation(mut self, requires_dedicated_allocation: bool) -> Self {
        self.value.requires_dedicated_allocation = requires_dedicated_allocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryDedicatedRequirements {
        self.value
    }
}

impl ops::Deref for MemoryDedicatedRequirementsBuilder {
    type Target = MemoryDedicatedRequirements;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryDedicatedRequirementsBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryDedicatedRequirementsBuilder {
    type Target = MemoryDedicatedRequirements;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryFdPropertiesKHR {
    type Target = MemoryFdPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryFdPropertiesKHR {
    type Builder = MemoryFdPropertiesKHRBuilder;
}

/// A builder for a [`MemoryFdPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryFdPropertiesKHRBuilder {
    value: MemoryFdPropertiesKHR,
}

impl MemoryFdPropertiesKHRBuilder {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryFdPropertiesKHR {
        self.value
    }
}

impl ops::Deref for MemoryFdPropertiesKHRBuilder {
    type Target = MemoryFdPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryFdPropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryFdPropertiesKHRBuilder {
    type Target = MemoryFdPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryGetAndroidHardwareBufferInfoANDROID {
    type Target = MemoryGetAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryGetAndroidHardwareBufferInfoANDROID {
    type Builder = MemoryGetAndroidHardwareBufferInfoANDROIDBuilder;
}

/// A builder for a [`MemoryGetAndroidHardwareBufferInfoANDROID`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryGetAndroidHardwareBufferInfoANDROIDBuilder {
    value: MemoryGetAndroidHardwareBufferInfoANDROID,
}

impl MemoryGetAndroidHardwareBufferInfoANDROIDBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryGetAndroidHardwareBufferInfoANDROID {
        self.value
    }
}

impl ops::Deref for MemoryGetAndroidHardwareBufferInfoANDROIDBuilder {
    type Target = MemoryGetAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryGetAndroidHardwareBufferInfoANDROIDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryGetAndroidHardwareBufferInfoANDROIDBuilder {
    type Target = MemoryGetAndroidHardwareBufferInfoANDROID;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryGetFdInfoKHR {
    type Target = MemoryGetFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryGetFdInfoKHR {
    type Builder = MemoryGetFdInfoKHRBuilder;
}

/// A builder for a [`MemoryGetFdInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryGetFdInfoKHRBuilder {
    value: MemoryGetFdInfoKHR,
}

impl MemoryGetFdInfoKHRBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryGetFdInfoKHR {
        self.value
    }
}

impl ops::Deref for MemoryGetFdInfoKHRBuilder {
    type Target = MemoryGetFdInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryGetFdInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryGetFdInfoKHRBuilder {
    type Target = MemoryGetFdInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryGetRemoteAddressInfoNV {
    type Target = MemoryGetRemoteAddressInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryGetRemoteAddressInfoNV {
    type Builder = MemoryGetRemoteAddressInfoNVBuilder;
}

/// A builder for a [`MemoryGetRemoteAddressInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryGetRemoteAddressInfoNVBuilder {
    value: MemoryGetRemoteAddressInfoNV,
}

impl MemoryGetRemoteAddressInfoNVBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryGetRemoteAddressInfoNV {
        self.value
    }
}

impl ops::Deref for MemoryGetRemoteAddressInfoNVBuilder {
    type Target = MemoryGetRemoteAddressInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryGetRemoteAddressInfoNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryGetRemoteAddressInfoNVBuilder {
    type Target = MemoryGetRemoteAddressInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryGetWin32HandleInfoKHR {
    type Target = MemoryGetWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryGetWin32HandleInfoKHR {
    type Builder = MemoryGetWin32HandleInfoKHRBuilder;
}

/// A builder for a [`MemoryGetWin32HandleInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryGetWin32HandleInfoKHRBuilder {
    value: MemoryGetWin32HandleInfoKHR,
}

impl MemoryGetWin32HandleInfoKHRBuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryGetWin32HandleInfoKHR {
        self.value
    }
}

impl ops::Deref for MemoryGetWin32HandleInfoKHRBuilder {
    type Target = MemoryGetWin32HandleInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryGetWin32HandleInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryGetWin32HandleInfoKHRBuilder {
    type Target = MemoryGetWin32HandleInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryGetZirconHandleInfoFUCHSIA {
    type Target = MemoryGetZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryGetZirconHandleInfoFUCHSIA {
    type Builder = MemoryGetZirconHandleInfoFUCHSIABuilder;
}

/// A builder for a [`MemoryGetZirconHandleInfoFUCHSIA`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryGetZirconHandleInfoFUCHSIABuilder {
    value: MemoryGetZirconHandleInfoFUCHSIA,
}

impl MemoryGetZirconHandleInfoFUCHSIABuilder {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.value.memory = memory;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryGetZirconHandleInfoFUCHSIA {
        self.value
    }
}

impl ops::Deref for MemoryGetZirconHandleInfoFUCHSIABuilder {
    type Target = MemoryGetZirconHandleInfoFUCHSIA;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryGetZirconHandleInfoFUCHSIABuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryGetZirconHandleInfoFUCHSIABuilder {
    type Target = MemoryGetZirconHandleInfoFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryHeap {
    type Target = MemoryHeap;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryHeap {
    type Builder = MemoryHeapBuilder;
}

/// A builder for a [`MemoryHeap`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryHeapBuilder {
    value: MemoryHeap,
}

impl MemoryHeapBuilder {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: MemoryHeapFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryHeap {
        self.value
    }
}

impl ops::Deref for MemoryHeapBuilder {
    type Target = MemoryHeap;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryHeapBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryHeapBuilder {
    type Target = MemoryHeap;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryHostPointerPropertiesEXT {
    type Target = MemoryHostPointerPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryHostPointerPropertiesEXT {
    type Builder = MemoryHostPointerPropertiesEXTBuilder;
}

/// A builder for a [`MemoryHostPointerPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryHostPointerPropertiesEXTBuilder {
    value: MemoryHostPointerPropertiesEXT,
}

impl MemoryHostPointerPropertiesEXTBuilder {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryHostPointerPropertiesEXT {
        self.value
    }
}

impl ops::Deref for MemoryHostPointerPropertiesEXTBuilder {
    type Target = MemoryHostPointerPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryHostPointerPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryHostPointerPropertiesEXTBuilder {
    type Target = MemoryHostPointerPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryOpaqueCaptureAddressAllocateInfo {
    type Target = MemoryOpaqueCaptureAddressAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryOpaqueCaptureAddressAllocateInfo {
    type Builder = MemoryOpaqueCaptureAddressAllocateInfoBuilder;
}

/// A builder for a [`MemoryOpaqueCaptureAddressAllocateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryOpaqueCaptureAddressAllocateInfoBuilder {
    value: MemoryOpaqueCaptureAddressAllocateInfo,
}

impl MemoryOpaqueCaptureAddressAllocateInfoBuilder {
    #[inline]
    pub fn opaque_capture_address(mut self, opaque_capture_address: u64) -> Self {
        self.value.opaque_capture_address = opaque_capture_address;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryOpaqueCaptureAddressAllocateInfo {
        self.value
    }
}

impl ops::Deref for MemoryOpaqueCaptureAddressAllocateInfoBuilder {
    type Target = MemoryOpaqueCaptureAddressAllocateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryOpaqueCaptureAddressAllocateInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryOpaqueCaptureAddressAllocateInfoBuilder {
    type Target = MemoryOpaqueCaptureAddressAllocateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryPriorityAllocateInfoEXT {
    type Target = MemoryPriorityAllocateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryPriorityAllocateInfoEXT {
    type Builder = MemoryPriorityAllocateInfoEXTBuilder;
}

/// A builder for a [`MemoryPriorityAllocateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryPriorityAllocateInfoEXTBuilder {
    value: MemoryPriorityAllocateInfoEXT,
}

impl MemoryPriorityAllocateInfoEXTBuilder {
    #[inline]
    pub fn priority(mut self, priority: f32) -> Self {
        self.value.priority = priority;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryPriorityAllocateInfoEXT {
        self.value
    }
}

impl ops::Deref for MemoryPriorityAllocateInfoEXTBuilder {
    type Target = MemoryPriorityAllocateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryPriorityAllocateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryPriorityAllocateInfoEXTBuilder {
    type Target = MemoryPriorityAllocateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryRequirements {
    type Target = MemoryRequirements;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryRequirements {
    type Builder = MemoryRequirementsBuilder;
}

/// A builder for a [`MemoryRequirements`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryRequirementsBuilder {
    value: MemoryRequirements,
}

impl MemoryRequirementsBuilder {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.value.size = size;
        self
    }

    #[inline]
    pub fn alignment(mut self, alignment: DeviceSize) -> Self {
        self.value.alignment = alignment;
        self
    }

    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryRequirements {
        self.value
    }
}

impl ops::Deref for MemoryRequirementsBuilder {
    type Target = MemoryRequirements;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryRequirementsBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryRequirementsBuilder {
    type Target = MemoryRequirements;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`MemoryRequirements2`].
pub unsafe trait ExtendsMemoryRequirements2: fmt::Debug {}
unsafe impl ExtendsMemoryRequirements2 for MemoryDedicatedRequirements {}

unsafe impl Cast for MemoryRequirements2 {
    type Target = MemoryRequirements2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MemoryRequirements2 {
    type Builder = MemoryRequirements2Builder<'b>;
}

/// A builder for a [`MemoryRequirements2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryRequirements2Builder<'b> {
    value: MemoryRequirements2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MemoryRequirements2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsMemoryRequirements2,
    {
        let next = (next.as_mut() as *mut T).cast::<MemoryRequirements2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn memory_requirements(
        mut self,
        memory_requirements: impl Cast<Target = MemoryRequirements>,
    ) -> Self {
        self.value.memory_requirements = memory_requirements.into();
        self
    }

    #[inline]
    pub fn build(self) -> MemoryRequirements2 {
        self.value
    }
}

impl<'b> ops::Deref for MemoryRequirements2Builder<'b> {
    type Target = MemoryRequirements2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MemoryRequirements2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MemoryRequirements2Builder<'b> {
    type Target = MemoryRequirements2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryType {
    type Target = MemoryType;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryType {
    type Builder = MemoryTypeBuilder;
}

/// A builder for a [`MemoryType`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryTypeBuilder {
    value: MemoryType,
}

impl MemoryTypeBuilder {
    #[inline]
    pub fn property_flags(mut self, property_flags: MemoryPropertyFlags) -> Self {
        self.value.property_flags = property_flags;
        self
    }

    #[inline]
    pub fn heap_index(mut self, heap_index: u32) -> Self {
        self.value.heap_index = heap_index;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryType {
        self.value
    }
}

impl ops::Deref for MemoryTypeBuilder {
    type Target = MemoryType;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryTypeBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryTypeBuilder {
    type Target = MemoryType;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryWin32HandlePropertiesKHR {
    type Target = MemoryWin32HandlePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryWin32HandlePropertiesKHR {
    type Builder = MemoryWin32HandlePropertiesKHRBuilder;
}

/// A builder for a [`MemoryWin32HandlePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryWin32HandlePropertiesKHRBuilder {
    value: MemoryWin32HandlePropertiesKHR,
}

impl MemoryWin32HandlePropertiesKHRBuilder {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryWin32HandlePropertiesKHR {
        self.value
    }
}

impl ops::Deref for MemoryWin32HandlePropertiesKHRBuilder {
    type Target = MemoryWin32HandlePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryWin32HandlePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryWin32HandlePropertiesKHRBuilder {
    type Target = MemoryWin32HandlePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MemoryZirconHandlePropertiesFUCHSIA {
    type Target = MemoryZirconHandlePropertiesFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MemoryZirconHandlePropertiesFUCHSIA {
    type Builder = MemoryZirconHandlePropertiesFUCHSIABuilder;
}

/// A builder for a [`MemoryZirconHandlePropertiesFUCHSIA`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MemoryZirconHandlePropertiesFUCHSIABuilder {
    value: MemoryZirconHandlePropertiesFUCHSIA,
}

impl MemoryZirconHandlePropertiesFUCHSIABuilder {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.value.memory_type_bits = memory_type_bits;
        self
    }

    #[inline]
    pub fn build(self) -> MemoryZirconHandlePropertiesFUCHSIA {
        self.value
    }
}

impl ops::Deref for MemoryZirconHandlePropertiesFUCHSIABuilder {
    type Target = MemoryZirconHandlePropertiesFUCHSIA;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MemoryZirconHandlePropertiesFUCHSIABuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MemoryZirconHandlePropertiesFUCHSIABuilder {
    type Target = MemoryZirconHandlePropertiesFUCHSIA;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MetalSurfaceCreateInfoEXT {
    type Target = MetalSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MetalSurfaceCreateInfoEXT {
    type Builder = MetalSurfaceCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`MetalSurfaceCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MetalSurfaceCreateInfoEXTBuilder<'b> {
    value: MetalSurfaceCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MetalSurfaceCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: MetalSurfaceCreateFlagsEXT) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn layer(mut self, layer: *const CAMetalLayer) -> Self {
        self.value.layer = layer;
        self
    }

    #[inline]
    pub fn build(self) -> MetalSurfaceCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for MetalSurfaceCreateInfoEXTBuilder<'b> {
    type Target = MetalSurfaceCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MetalSurfaceCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MetalSurfaceCreateInfoEXTBuilder<'b> {
    type Target = MetalSurfaceCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MultiDrawIndexedInfoEXT {
    type Target = MultiDrawIndexedInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MultiDrawIndexedInfoEXT {
    type Builder = MultiDrawIndexedInfoEXTBuilder;
}

/// A builder for a [`MultiDrawIndexedInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MultiDrawIndexedInfoEXTBuilder {
    value: MultiDrawIndexedInfoEXT,
}

impl MultiDrawIndexedInfoEXTBuilder {
    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.value.first_index = first_index;
        self
    }

    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.value.index_count = index_count;
        self
    }

    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.value.vertex_offset = vertex_offset;
        self
    }

    #[inline]
    pub fn build(self) -> MultiDrawIndexedInfoEXT {
        self.value
    }
}

impl ops::Deref for MultiDrawIndexedInfoEXTBuilder {
    type Target = MultiDrawIndexedInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MultiDrawIndexedInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MultiDrawIndexedInfoEXTBuilder {
    type Target = MultiDrawIndexedInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MultiDrawInfoEXT {
    type Target = MultiDrawInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MultiDrawInfoEXT {
    type Builder = MultiDrawInfoEXTBuilder;
}

/// A builder for a [`MultiDrawInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MultiDrawInfoEXTBuilder {
    value: MultiDrawInfoEXT,
}

impl MultiDrawInfoEXTBuilder {
    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.value.first_vertex = first_vertex;
        self
    }

    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.value.vertex_count = vertex_count;
        self
    }

    #[inline]
    pub fn build(self) -> MultiDrawInfoEXT {
        self.value
    }
}

impl ops::Deref for MultiDrawInfoEXTBuilder {
    type Target = MultiDrawInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MultiDrawInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MultiDrawInfoEXTBuilder {
    type Target = MultiDrawInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MultisamplePropertiesEXT {
    type Target = MultisamplePropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for MultisamplePropertiesEXT {
    type Builder = MultisamplePropertiesEXTBuilder;
}

/// A builder for a [`MultisamplePropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MultisamplePropertiesEXTBuilder {
    value: MultisamplePropertiesEXT,
}

impl MultisamplePropertiesEXTBuilder {
    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.max_sample_location_grid_size = max_sample_location_grid_size.into();
        self
    }

    #[inline]
    pub fn build(self) -> MultisamplePropertiesEXT {
        self.value
    }
}

impl ops::Deref for MultisamplePropertiesEXTBuilder {
    type Target = MultisamplePropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for MultisamplePropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for MultisamplePropertiesEXTBuilder {
    type Target = MultisamplePropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MutableDescriptorTypeCreateInfoVALVE {
    type Target = MutableDescriptorTypeCreateInfoVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MutableDescriptorTypeCreateInfoVALVE {
    type Builder = MutableDescriptorTypeCreateInfoVALVEBuilder<'b>;
}

/// A builder for a [`MutableDescriptorTypeCreateInfoVALVE`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MutableDescriptorTypeCreateInfoVALVEBuilder<'b> {
    value: MutableDescriptorTypeCreateInfoVALVE,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MutableDescriptorTypeCreateInfoVALVEBuilder<'b> {
    #[inline]
    pub fn mutable_descriptor_type_lists(
        mut self,
        mutable_descriptor_type_lists: &'b [impl Cast<Target = MutableDescriptorTypeListVALVE>],
    ) -> Self {
        self.value.mutable_descriptor_type_list_count = mutable_descriptor_type_lists.len() as u32;
        self.value.mutable_descriptor_type_lists = mutable_descriptor_type_lists.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> MutableDescriptorTypeCreateInfoVALVE {
        self.value
    }
}

impl<'b> ops::Deref for MutableDescriptorTypeCreateInfoVALVEBuilder<'b> {
    type Target = MutableDescriptorTypeCreateInfoVALVE;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MutableDescriptorTypeCreateInfoVALVEBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MutableDescriptorTypeCreateInfoVALVEBuilder<'b> {
    type Target = MutableDescriptorTypeCreateInfoVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for MutableDescriptorTypeListVALVE {
    type Target = MutableDescriptorTypeListVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for MutableDescriptorTypeListVALVE {
    type Builder = MutableDescriptorTypeListVALVEBuilder<'b>;
}

/// A builder for a [`MutableDescriptorTypeListVALVE`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct MutableDescriptorTypeListVALVEBuilder<'b> {
    value: MutableDescriptorTypeListVALVE,
    _marker: PhantomData<&'b ()>,
}

impl<'b> MutableDescriptorTypeListVALVEBuilder<'b> {
    #[inline]
    pub fn descriptor_types(mut self, descriptor_types: &'b [DescriptorType]) -> Self {
        self.value.descriptor_type_count = descriptor_types.len() as u32;
        self.value.descriptor_types = descriptor_types.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> MutableDescriptorTypeListVALVE {
        self.value
    }
}

impl<'b> ops::Deref for MutableDescriptorTypeListVALVEBuilder<'b> {
    type Target = MutableDescriptorTypeListVALVE;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for MutableDescriptorTypeListVALVEBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for MutableDescriptorTypeListVALVEBuilder<'b> {
    type Target = MutableDescriptorTypeListVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for Offset2D {
    type Target = Offset2D;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for Offset2D {
    type Builder = Offset2DBuilder;
}

/// A builder for a [`Offset2D`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct Offset2DBuilder {
    value: Offset2D,
}

impl Offset2DBuilder {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.value.x = x;
        self
    }

    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.value.y = y;
        self
    }

    #[inline]
    pub fn build(self) -> Offset2D {
        self.value
    }
}

impl ops::Deref for Offset2DBuilder {
    type Target = Offset2D;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for Offset2DBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for Offset2DBuilder {
    type Target = Offset2D;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for Offset3D {
    type Target = Offset3D;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for Offset3D {
    type Builder = Offset3DBuilder;
}

/// A builder for a [`Offset3D`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct Offset3DBuilder {
    value: Offset3D,
}

impl Offset3DBuilder {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.value.x = x;
        self
    }

    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.value.y = y;
        self
    }

    #[inline]
    pub fn z(mut self, z: i32) -> Self {
        self.value.z = z;
        self
    }

    #[inline]
    pub fn build(self) -> Offset3D {
        self.value
    }
}

impl ops::Deref for Offset3DBuilder {
    type Target = Offset3D;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for Offset3DBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for Offset3DBuilder {
    type Target = Offset3D;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PastPresentationTimingGOOGLE {
    type Target = PastPresentationTimingGOOGLE;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PastPresentationTimingGOOGLE {
    type Builder = PastPresentationTimingGOOGLEBuilder;
}

/// A builder for a [`PastPresentationTimingGOOGLE`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PastPresentationTimingGOOGLEBuilder {
    value: PastPresentationTimingGOOGLE,
}

impl PastPresentationTimingGOOGLEBuilder {
    #[inline]
    pub fn present_id(mut self, present_id: u32) -> Self {
        self.value.present_id = present_id;
        self
    }

    #[inline]
    pub fn desired_present_time(mut self, desired_present_time: u64) -> Self {
        self.value.desired_present_time = desired_present_time;
        self
    }

    #[inline]
    pub fn actual_present_time(mut self, actual_present_time: u64) -> Self {
        self.value.actual_present_time = actual_present_time;
        self
    }

    #[inline]
    pub fn earliest_present_time(mut self, earliest_present_time: u64) -> Self {
        self.value.earliest_present_time = earliest_present_time;
        self
    }

    #[inline]
    pub fn present_margin(mut self, present_margin: u64) -> Self {
        self.value.present_margin = present_margin;
        self
    }

    #[inline]
    pub fn build(self) -> PastPresentationTimingGOOGLE {
        self.value
    }
}

impl ops::Deref for PastPresentationTimingGOOGLEBuilder {
    type Target = PastPresentationTimingGOOGLE;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PastPresentationTimingGOOGLEBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PastPresentationTimingGOOGLEBuilder {
    type Target = PastPresentationTimingGOOGLE;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceConfigurationAcquireInfoINTEL {
    type Target = PerformanceConfigurationAcquireInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceConfigurationAcquireInfoINTEL {
    type Builder = PerformanceConfigurationAcquireInfoINTELBuilder;
}

/// A builder for a [`PerformanceConfigurationAcquireInfoINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceConfigurationAcquireInfoINTELBuilder {
    value: PerformanceConfigurationAcquireInfoINTEL,
}

impl PerformanceConfigurationAcquireInfoINTELBuilder {
    #[inline]
    pub fn type_(mut self, type_: PerformanceConfigurationTypeINTEL) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceConfigurationAcquireInfoINTEL {
        self.value
    }
}

impl ops::Deref for PerformanceConfigurationAcquireInfoINTELBuilder {
    type Target = PerformanceConfigurationAcquireInfoINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceConfigurationAcquireInfoINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceConfigurationAcquireInfoINTELBuilder {
    type Target = PerformanceConfigurationAcquireInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceCounterDescriptionKHR {
    type Target = PerformanceCounterDescriptionKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceCounterDescriptionKHR {
    type Builder = PerformanceCounterDescriptionKHRBuilder;
}

/// A builder for a [`PerformanceCounterDescriptionKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceCounterDescriptionKHRBuilder {
    value: PerformanceCounterDescriptionKHR,
}

impl PerformanceCounterDescriptionKHRBuilder {
    #[inline]
    pub fn flags(mut self, flags: PerformanceCounterDescriptionFlagsKHR) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn name(mut self, name: impl Into<StringArray<MAX_DESCRIPTION_SIZE>>) -> Self {
        self.value.name = name.into();
        self
    }

    #[inline]
    pub fn category(mut self, category: impl Into<StringArray<MAX_DESCRIPTION_SIZE>>) -> Self {
        self.value.category = category.into();
        self
    }

    #[inline]
    pub fn description(
        mut self,
        description: impl Into<StringArray<MAX_DESCRIPTION_SIZE>>,
    ) -> Self {
        self.value.description = description.into();
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceCounterDescriptionKHR {
        self.value
    }
}

impl ops::Deref for PerformanceCounterDescriptionKHRBuilder {
    type Target = PerformanceCounterDescriptionKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceCounterDescriptionKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceCounterDescriptionKHRBuilder {
    type Target = PerformanceCounterDescriptionKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceCounterKHR {
    type Target = PerformanceCounterKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceCounterKHR {
    type Builder = PerformanceCounterKHRBuilder;
}

/// A builder for a [`PerformanceCounterKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceCounterKHRBuilder {
    value: PerformanceCounterKHR,
}

impl PerformanceCounterKHRBuilder {
    #[inline]
    pub fn unit(mut self, unit: PerformanceCounterUnitKHR) -> Self {
        self.value.unit = unit;
        self
    }

    #[inline]
    pub fn scope(mut self, scope: PerformanceCounterScopeKHR) -> Self {
        self.value.scope = scope;
        self
    }

    #[inline]
    pub fn storage(mut self, storage: PerformanceCounterStorageKHR) -> Self {
        self.value.storage = storage;
        self
    }

    #[inline]
    pub fn uuid(mut self, uuid: impl Into<ByteArray<UUID_SIZE>>) -> Self {
        self.value.uuid = uuid.into();
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceCounterKHR {
        self.value
    }
}

impl ops::Deref for PerformanceCounterKHRBuilder {
    type Target = PerformanceCounterKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceCounterKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceCounterKHRBuilder {
    type Target = PerformanceCounterKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceMarkerInfoINTEL {
    type Target = PerformanceMarkerInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceMarkerInfoINTEL {
    type Builder = PerformanceMarkerInfoINTELBuilder;
}

/// A builder for a [`PerformanceMarkerInfoINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceMarkerInfoINTELBuilder {
    value: PerformanceMarkerInfoINTEL,
}

impl PerformanceMarkerInfoINTELBuilder {
    #[inline]
    pub fn marker(mut self, marker: u64) -> Self {
        self.value.marker = marker;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceMarkerInfoINTEL {
        self.value
    }
}

impl ops::Deref for PerformanceMarkerInfoINTELBuilder {
    type Target = PerformanceMarkerInfoINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceMarkerInfoINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceMarkerInfoINTELBuilder {
    type Target = PerformanceMarkerInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceOverrideInfoINTEL {
    type Target = PerformanceOverrideInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceOverrideInfoINTEL {
    type Builder = PerformanceOverrideInfoINTELBuilder;
}

/// A builder for a [`PerformanceOverrideInfoINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceOverrideInfoINTELBuilder {
    value: PerformanceOverrideInfoINTEL,
}

impl PerformanceOverrideInfoINTELBuilder {
    #[inline]
    pub fn type_(mut self, type_: PerformanceOverrideTypeINTEL) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn enable(mut self, enable: bool) -> Self {
        self.value.enable = enable as Bool32;
        self
    }

    #[inline]
    pub fn parameter(mut self, parameter: u64) -> Self {
        self.value.parameter = parameter;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceOverrideInfoINTEL {
        self.value
    }
}

impl ops::Deref for PerformanceOverrideInfoINTELBuilder {
    type Target = PerformanceOverrideInfoINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceOverrideInfoINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceOverrideInfoINTELBuilder {
    type Target = PerformanceOverrideInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceQuerySubmitInfoKHR {
    type Target = PerformanceQuerySubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceQuerySubmitInfoKHR {
    type Builder = PerformanceQuerySubmitInfoKHRBuilder;
}

/// A builder for a [`PerformanceQuerySubmitInfoKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceQuerySubmitInfoKHRBuilder {
    value: PerformanceQuerySubmitInfoKHR,
}

impl PerformanceQuerySubmitInfoKHRBuilder {
    #[inline]
    pub fn counter_pass_index(mut self, counter_pass_index: u32) -> Self {
        self.value.counter_pass_index = counter_pass_index;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceQuerySubmitInfoKHR {
        self.value
    }
}

impl ops::Deref for PerformanceQuerySubmitInfoKHRBuilder {
    type Target = PerformanceQuerySubmitInfoKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceQuerySubmitInfoKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceQuerySubmitInfoKHRBuilder {
    type Target = PerformanceQuerySubmitInfoKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceStreamMarkerInfoINTEL {
    type Target = PerformanceStreamMarkerInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceStreamMarkerInfoINTEL {
    type Builder = PerformanceStreamMarkerInfoINTELBuilder;
}

/// A builder for a [`PerformanceStreamMarkerInfoINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceStreamMarkerInfoINTELBuilder {
    value: PerformanceStreamMarkerInfoINTEL,
}

impl PerformanceStreamMarkerInfoINTELBuilder {
    #[inline]
    pub fn marker(mut self, marker: u32) -> Self {
        self.value.marker = marker;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceStreamMarkerInfoINTEL {
        self.value
    }
}

impl ops::Deref for PerformanceStreamMarkerInfoINTELBuilder {
    type Target = PerformanceStreamMarkerInfoINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceStreamMarkerInfoINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceStreamMarkerInfoINTELBuilder {
    type Target = PerformanceStreamMarkerInfoINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PerformanceValueINTEL {
    type Target = PerformanceValueINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PerformanceValueINTEL {
    type Builder = PerformanceValueINTELBuilder;
}

/// A builder for a [`PerformanceValueINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PerformanceValueINTELBuilder {
    value: PerformanceValueINTEL,
}

impl PerformanceValueINTELBuilder {
    #[inline]
    pub fn type_(mut self, type_: PerformanceValueTypeINTEL) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn data(mut self, data: PerformanceValueDataINTEL) -> Self {
        self.value.data = data;
        self
    }

    #[inline]
    pub fn build(self) -> PerformanceValueINTEL {
        self.value
    }
}

impl ops::Deref for PerformanceValueINTELBuilder {
    type Target = PerformanceValueINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PerformanceValueINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PerformanceValueINTELBuilder {
    type Target = PerformanceValueINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevice16BitStorageFeatures {
    type Target = PhysicalDevice16BitStorageFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevice16BitStorageFeatures {
    type Builder = PhysicalDevice16BitStorageFeaturesBuilder;
}

/// A builder for a [`PhysicalDevice16BitStorageFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevice16BitStorageFeaturesBuilder {
    value: PhysicalDevice16BitStorageFeatures,
}

impl PhysicalDevice16BitStorageFeaturesBuilder {
    #[inline]
    pub fn storage_buffer_16bit_access(mut self, storage_buffer_16bit_access: bool) -> Self {
        self.value.storage_buffer_16bit_access = storage_buffer_16bit_access as Bool32;
        self
    }

    #[inline]
    pub fn uniform_and_storage_buffer_16bit_access(
        mut self,
        uniform_and_storage_buffer_16bit_access: bool,
    ) -> Self {
        self.value.uniform_and_storage_buffer_16bit_access =
            uniform_and_storage_buffer_16bit_access as Bool32;
        self
    }

    #[inline]
    pub fn storage_push_constant16(mut self, storage_push_constant16: bool) -> Self {
        self.value.storage_push_constant16 = storage_push_constant16 as Bool32;
        self
    }

    #[inline]
    pub fn storage_input_output16(mut self, storage_input_output16: bool) -> Self {
        self.value.storage_input_output16 = storage_input_output16 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevice16BitStorageFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDevice16BitStorageFeaturesBuilder {
    type Target = PhysicalDevice16BitStorageFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevice16BitStorageFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevice16BitStorageFeaturesBuilder {
    type Target = PhysicalDevice16BitStorageFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevice4444FormatsFeaturesEXT {
    type Target = PhysicalDevice4444FormatsFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevice4444FormatsFeaturesEXT {
    type Builder = PhysicalDevice4444FormatsFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDevice4444FormatsFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevice4444FormatsFeaturesEXTBuilder {
    value: PhysicalDevice4444FormatsFeaturesEXT,
}

impl PhysicalDevice4444FormatsFeaturesEXTBuilder {
    #[inline]
    pub fn format_a4_r4_g4_b4(mut self, format_a4_r4_g4_b4: bool) -> Self {
        self.value.format_a4_r4_g4_b4 = format_a4_r4_g4_b4 as Bool32;
        self
    }

    #[inline]
    pub fn format_a4_b4_g4_r4(mut self, format_a4_b4_g4_r4: bool) -> Self {
        self.value.format_a4_b4_g4_r4 = format_a4_b4_g4_r4 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevice4444FormatsFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDevice4444FormatsFeaturesEXTBuilder {
    type Target = PhysicalDevice4444FormatsFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevice4444FormatsFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevice4444FormatsFeaturesEXTBuilder {
    type Target = PhysicalDevice4444FormatsFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevice8BitStorageFeatures {
    type Target = PhysicalDevice8BitStorageFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevice8BitStorageFeatures {
    type Builder = PhysicalDevice8BitStorageFeaturesBuilder;
}

/// A builder for a [`PhysicalDevice8BitStorageFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevice8BitStorageFeaturesBuilder {
    value: PhysicalDevice8BitStorageFeatures,
}

impl PhysicalDevice8BitStorageFeaturesBuilder {
    #[inline]
    pub fn storage_buffer_8bit_access(mut self, storage_buffer_8bit_access: bool) -> Self {
        self.value.storage_buffer_8bit_access = storage_buffer_8bit_access as Bool32;
        self
    }

    #[inline]
    pub fn uniform_and_storage_buffer_8bit_access(
        mut self,
        uniform_and_storage_buffer_8bit_access: bool,
    ) -> Self {
        self.value.uniform_and_storage_buffer_8bit_access =
            uniform_and_storage_buffer_8bit_access as Bool32;
        self
    }

    #[inline]
    pub fn storage_push_constant8(mut self, storage_push_constant8: bool) -> Self {
        self.value.storage_push_constant8 = storage_push_constant8 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevice8BitStorageFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDevice8BitStorageFeaturesBuilder {
    type Target = PhysicalDevice8BitStorageFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevice8BitStorageFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevice8BitStorageFeaturesBuilder {
    type Target = PhysicalDevice8BitStorageFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceASTCDecodeFeaturesEXT {
    type Target = PhysicalDeviceASTCDecodeFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceASTCDecodeFeaturesEXT {
    type Builder = PhysicalDeviceASTCDecodeFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceASTCDecodeFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceASTCDecodeFeaturesEXTBuilder {
    value: PhysicalDeviceASTCDecodeFeaturesEXT,
}

impl PhysicalDeviceASTCDecodeFeaturesEXTBuilder {
    #[inline]
    pub fn decode_mode_shared_exponent(mut self, decode_mode_shared_exponent: bool) -> Self {
        self.value.decode_mode_shared_exponent = decode_mode_shared_exponent as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceASTCDecodeFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceASTCDecodeFeaturesEXTBuilder {
    type Target = PhysicalDeviceASTCDecodeFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceASTCDecodeFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceASTCDecodeFeaturesEXTBuilder {
    type Target = PhysicalDeviceASTCDecodeFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceAccelerationStructureFeaturesKHR {
    type Target = PhysicalDeviceAccelerationStructureFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceAccelerationStructureFeaturesKHR {
    type Builder = PhysicalDeviceAccelerationStructureFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceAccelerationStructureFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceAccelerationStructureFeaturesKHRBuilder {
    value: PhysicalDeviceAccelerationStructureFeaturesKHR,
}

impl PhysicalDeviceAccelerationStructureFeaturesKHRBuilder {
    #[inline]
    pub fn acceleration_structure(mut self, acceleration_structure: bool) -> Self {
        self.value.acceleration_structure = acceleration_structure as Bool32;
        self
    }

    #[inline]
    pub fn acceleration_structure_capture_replay(
        mut self,
        acceleration_structure_capture_replay: bool,
    ) -> Self {
        self.value.acceleration_structure_capture_replay =
            acceleration_structure_capture_replay as Bool32;
        self
    }

    #[inline]
    pub fn acceleration_structure_indirect_build(
        mut self,
        acceleration_structure_indirect_build: bool,
    ) -> Self {
        self.value.acceleration_structure_indirect_build =
            acceleration_structure_indirect_build as Bool32;
        self
    }

    #[inline]
    pub fn acceleration_structure_host_commands(
        mut self,
        acceleration_structure_host_commands: bool,
    ) -> Self {
        self.value.acceleration_structure_host_commands =
            acceleration_structure_host_commands as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_acceleration_structure_update_after_bind(
        mut self,
        descriptor_binding_acceleration_structure_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_acceleration_structure_update_after_bind =
            descriptor_binding_acceleration_structure_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceAccelerationStructureFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceAccelerationStructureFeaturesKHRBuilder {
    type Target = PhysicalDeviceAccelerationStructureFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceAccelerationStructureFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceAccelerationStructureFeaturesKHRBuilder {
    type Target = PhysicalDeviceAccelerationStructureFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceAccelerationStructurePropertiesKHR {
    type Target = PhysicalDeviceAccelerationStructurePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceAccelerationStructurePropertiesKHR {
    type Builder = PhysicalDeviceAccelerationStructurePropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceAccelerationStructurePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceAccelerationStructurePropertiesKHRBuilder {
    value: PhysicalDeviceAccelerationStructurePropertiesKHR,
}

impl PhysicalDeviceAccelerationStructurePropertiesKHRBuilder {
    #[inline]
    pub fn max_geometry_count(mut self, max_geometry_count: u64) -> Self {
        self.value.max_geometry_count = max_geometry_count;
        self
    }

    #[inline]
    pub fn max_instance_count(mut self, max_instance_count: u64) -> Self {
        self.value.max_instance_count = max_instance_count;
        self
    }

    #[inline]
    pub fn max_primitive_count(mut self, max_primitive_count: u64) -> Self {
        self.value.max_primitive_count = max_primitive_count;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_acceleration_structures(
        mut self,
        max_per_stage_descriptor_acceleration_structures: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_acceleration_structures =
            max_per_stage_descriptor_acceleration_structures;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_acceleration_structures(
        mut self,
        max_per_stage_descriptor_update_after_bind_acceleration_structures: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_acceleration_structures =
            max_per_stage_descriptor_update_after_bind_acceleration_structures;
        self
    }

    #[inline]
    pub fn max_descriptor_set_acceleration_structures(
        mut self,
        max_descriptor_set_acceleration_structures: u32,
    ) -> Self {
        self.value.max_descriptor_set_acceleration_structures =
            max_descriptor_set_acceleration_structures;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_acceleration_structures(
        mut self,
        max_descriptor_set_update_after_bind_acceleration_structures: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_acceleration_structures =
            max_descriptor_set_update_after_bind_acceleration_structures;
        self
    }

    #[inline]
    pub fn min_acceleration_structure_scratch_offset_alignment(
        mut self,
        min_acceleration_structure_scratch_offset_alignment: u32,
    ) -> Self {
        self.value
            .min_acceleration_structure_scratch_offset_alignment =
            min_acceleration_structure_scratch_offset_alignment;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceAccelerationStructurePropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceAccelerationStructurePropertiesKHRBuilder {
    type Target = PhysicalDeviceAccelerationStructurePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceAccelerationStructurePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceAccelerationStructurePropertiesKHRBuilder {
    type Target = PhysicalDeviceAccelerationStructurePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    type Target = PhysicalDeviceBlendOperationAdvancedFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    type Builder = PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceBlendOperationAdvancedFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
    value: PhysicalDeviceBlendOperationAdvancedFeaturesEXT,
}

impl PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
    #[inline]
    pub fn advanced_blend_coherent_operations(
        mut self,
        advanced_blend_coherent_operations: bool,
    ) -> Self {
        self.value.advanced_blend_coherent_operations =
            advanced_blend_coherent_operations as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
    type Target = PhysicalDeviceBlendOperationAdvancedFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
    type Target = PhysicalDeviceBlendOperationAdvancedFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    type Target = PhysicalDeviceBlendOperationAdvancedPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    type Builder = PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceBlendOperationAdvancedPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
    value: PhysicalDeviceBlendOperationAdvancedPropertiesEXT,
}

impl PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
    #[inline]
    pub fn advanced_blend_max_color_attachments(
        mut self,
        advanced_blend_max_color_attachments: u32,
    ) -> Self {
        self.value.advanced_blend_max_color_attachments = advanced_blend_max_color_attachments;
        self
    }

    #[inline]
    pub fn advanced_blend_independent_blend(
        mut self,
        advanced_blend_independent_blend: bool,
    ) -> Self {
        self.value.advanced_blend_independent_blend = advanced_blend_independent_blend as Bool32;
        self
    }

    #[inline]
    pub fn advanced_blend_non_premultiplied_src_color(
        mut self,
        advanced_blend_non_premultiplied_src_color: bool,
    ) -> Self {
        self.value.advanced_blend_non_premultiplied_src_color =
            advanced_blend_non_premultiplied_src_color as Bool32;
        self
    }

    #[inline]
    pub fn advanced_blend_non_premultiplied_dst_color(
        mut self,
        advanced_blend_non_premultiplied_dst_color: bool,
    ) -> Self {
        self.value.advanced_blend_non_premultiplied_dst_color =
            advanced_blend_non_premultiplied_dst_color as Bool32;
        self
    }

    #[inline]
    pub fn advanced_blend_correlated_overlap(
        mut self,
        advanced_blend_correlated_overlap: bool,
    ) -> Self {
        self.value.advanced_blend_correlated_overlap = advanced_blend_correlated_overlap as Bool32;
        self
    }

    #[inline]
    pub fn advanced_blend_all_operations(mut self, advanced_blend_all_operations: bool) -> Self {
        self.value.advanced_blend_all_operations = advanced_blend_all_operations as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
    type Target = PhysicalDeviceBlendOperationAdvancedPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
    type Target = PhysicalDeviceBlendOperationAdvancedPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceBufferDeviceAddressFeatures {
    type Target = PhysicalDeviceBufferDeviceAddressFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceBufferDeviceAddressFeatures {
    type Builder = PhysicalDeviceBufferDeviceAddressFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceBufferDeviceAddressFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceBufferDeviceAddressFeaturesBuilder {
    value: PhysicalDeviceBufferDeviceAddressFeatures,
}

impl PhysicalDeviceBufferDeviceAddressFeaturesBuilder {
    #[inline]
    pub fn buffer_device_address(mut self, buffer_device_address: bool) -> Self {
        self.value.buffer_device_address = buffer_device_address as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_capture_replay(
        mut self,
        buffer_device_address_capture_replay: bool,
    ) -> Self {
        self.value.buffer_device_address_capture_replay =
            buffer_device_address_capture_replay as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_multi_device(
        mut self,
        buffer_device_address_multi_device: bool,
    ) -> Self {
        self.value.buffer_device_address_multi_device =
            buffer_device_address_multi_device as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceBufferDeviceAddressFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceBufferDeviceAddressFeaturesBuilder {
    type Target = PhysicalDeviceBufferDeviceAddressFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceBufferDeviceAddressFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceBufferDeviceAddressFeaturesBuilder {
    type Target = PhysicalDeviceBufferDeviceAddressFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceBufferDeviceAddressFeaturesEXT {
    type Target = PhysicalDeviceBufferDeviceAddressFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceBufferDeviceAddressFeaturesEXT {
    type Builder = PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceBufferDeviceAddressFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder {
    value: PhysicalDeviceBufferDeviceAddressFeaturesEXT,
}

impl PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder {
    #[inline]
    pub fn buffer_device_address(mut self, buffer_device_address: bool) -> Self {
        self.value.buffer_device_address = buffer_device_address as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_capture_replay(
        mut self,
        buffer_device_address_capture_replay: bool,
    ) -> Self {
        self.value.buffer_device_address_capture_replay =
            buffer_device_address_capture_replay as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_multi_device(
        mut self,
        buffer_device_address_multi_device: bool,
    ) -> Self {
        self.value.buffer_device_address_multi_device =
            buffer_device_address_multi_device as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceBufferDeviceAddressFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder {
    type Target = PhysicalDeviceBufferDeviceAddressFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceBufferDeviceAddressFeaturesEXTBuilder {
    type Target = PhysicalDeviceBufferDeviceAddressFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCoherentMemoryFeaturesAMD {
    type Target = PhysicalDeviceCoherentMemoryFeaturesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCoherentMemoryFeaturesAMD {
    type Builder = PhysicalDeviceCoherentMemoryFeaturesAMDBuilder;
}

/// A builder for a [`PhysicalDeviceCoherentMemoryFeaturesAMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCoherentMemoryFeaturesAMDBuilder {
    value: PhysicalDeviceCoherentMemoryFeaturesAMD,
}

impl PhysicalDeviceCoherentMemoryFeaturesAMDBuilder {
    #[inline]
    pub fn device_coherent_memory(mut self, device_coherent_memory: bool) -> Self {
        self.value.device_coherent_memory = device_coherent_memory as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCoherentMemoryFeaturesAMD {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCoherentMemoryFeaturesAMDBuilder {
    type Target = PhysicalDeviceCoherentMemoryFeaturesAMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCoherentMemoryFeaturesAMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCoherentMemoryFeaturesAMDBuilder {
    type Target = PhysicalDeviceCoherentMemoryFeaturesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceColorWriteEnableFeaturesEXT {
    type Target = PhysicalDeviceColorWriteEnableFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceColorWriteEnableFeaturesEXT {
    type Builder = PhysicalDeviceColorWriteEnableFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceColorWriteEnableFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceColorWriteEnableFeaturesEXTBuilder {
    value: PhysicalDeviceColorWriteEnableFeaturesEXT,
}

impl PhysicalDeviceColorWriteEnableFeaturesEXTBuilder {
    #[inline]
    pub fn color_write_enable(mut self, color_write_enable: bool) -> Self {
        self.value.color_write_enable = color_write_enable as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceColorWriteEnableFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceColorWriteEnableFeaturesEXTBuilder {
    type Target = PhysicalDeviceColorWriteEnableFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceColorWriteEnableFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceColorWriteEnableFeaturesEXTBuilder {
    type Target = PhysicalDeviceColorWriteEnableFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceComputeShaderDerivativesFeaturesNV {
    type Target = PhysicalDeviceComputeShaderDerivativesFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceComputeShaderDerivativesFeaturesNV {
    type Builder = PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceComputeShaderDerivativesFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder {
    value: PhysicalDeviceComputeShaderDerivativesFeaturesNV,
}

impl PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder {
    #[inline]
    pub fn compute_derivative_group_quads(mut self, compute_derivative_group_quads: bool) -> Self {
        self.value.compute_derivative_group_quads = compute_derivative_group_quads as Bool32;
        self
    }

    #[inline]
    pub fn compute_derivative_group_linear(
        mut self,
        compute_derivative_group_linear: bool,
    ) -> Self {
        self.value.compute_derivative_group_linear = compute_derivative_group_linear as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceComputeShaderDerivativesFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder {
    type Target = PhysicalDeviceComputeShaderDerivativesFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceComputeShaderDerivativesFeaturesNVBuilder {
    type Target = PhysicalDeviceComputeShaderDerivativesFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceConditionalRenderingFeaturesEXT {
    type Target = PhysicalDeviceConditionalRenderingFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceConditionalRenderingFeaturesEXT {
    type Builder = PhysicalDeviceConditionalRenderingFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceConditionalRenderingFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceConditionalRenderingFeaturesEXTBuilder {
    value: PhysicalDeviceConditionalRenderingFeaturesEXT,
}

impl PhysicalDeviceConditionalRenderingFeaturesEXTBuilder {
    #[inline]
    pub fn conditional_rendering(mut self, conditional_rendering: bool) -> Self {
        self.value.conditional_rendering = conditional_rendering as Bool32;
        self
    }

    #[inline]
    pub fn inherited_conditional_rendering(
        mut self,
        inherited_conditional_rendering: bool,
    ) -> Self {
        self.value.inherited_conditional_rendering = inherited_conditional_rendering as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceConditionalRenderingFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceConditionalRenderingFeaturesEXTBuilder {
    type Target = PhysicalDeviceConditionalRenderingFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceConditionalRenderingFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceConditionalRenderingFeaturesEXTBuilder {
    type Target = PhysicalDeviceConditionalRenderingFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceConservativeRasterizationPropertiesEXT {
    type Target = PhysicalDeviceConservativeRasterizationPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceConservativeRasterizationPropertiesEXT {
    type Builder = PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceConservativeRasterizationPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder {
    value: PhysicalDeviceConservativeRasterizationPropertiesEXT,
}

impl PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder {
    #[inline]
    pub fn primitive_overestimation_size(mut self, primitive_overestimation_size: f32) -> Self {
        self.value.primitive_overestimation_size = primitive_overestimation_size;
        self
    }

    #[inline]
    pub fn max_extra_primitive_overestimation_size(
        mut self,
        max_extra_primitive_overestimation_size: f32,
    ) -> Self {
        self.value.max_extra_primitive_overestimation_size =
            max_extra_primitive_overestimation_size;
        self
    }

    #[inline]
    pub fn extra_primitive_overestimation_size_granularity(
        mut self,
        extra_primitive_overestimation_size_granularity: f32,
    ) -> Self {
        self.value.extra_primitive_overestimation_size_granularity =
            extra_primitive_overestimation_size_granularity;
        self
    }

    #[inline]
    pub fn primitive_underestimation(mut self, primitive_underestimation: bool) -> Self {
        self.value.primitive_underestimation = primitive_underestimation as Bool32;
        self
    }

    #[inline]
    pub fn conservative_point_and_line_rasterization(
        mut self,
        conservative_point_and_line_rasterization: bool,
    ) -> Self {
        self.value.conservative_point_and_line_rasterization =
            conservative_point_and_line_rasterization as Bool32;
        self
    }

    #[inline]
    pub fn degenerate_triangles_rasterized(
        mut self,
        degenerate_triangles_rasterized: bool,
    ) -> Self {
        self.value.degenerate_triangles_rasterized = degenerate_triangles_rasterized as Bool32;
        self
    }

    #[inline]
    pub fn degenerate_lines_rasterized(mut self, degenerate_lines_rasterized: bool) -> Self {
        self.value.degenerate_lines_rasterized = degenerate_lines_rasterized as Bool32;
        self
    }

    #[inline]
    pub fn fully_covered_fragment_shader_input_variable(
        mut self,
        fully_covered_fragment_shader_input_variable: bool,
    ) -> Self {
        self.value.fully_covered_fragment_shader_input_variable =
            fully_covered_fragment_shader_input_variable as Bool32;
        self
    }

    #[inline]
    pub fn conservative_rasterization_post_depth_coverage(
        mut self,
        conservative_rasterization_post_depth_coverage: bool,
    ) -> Self {
        self.value.conservative_rasterization_post_depth_coverage =
            conservative_rasterization_post_depth_coverage as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceConservativeRasterizationPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder {
    type Target = PhysicalDeviceConservativeRasterizationPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceConservativeRasterizationPropertiesEXTBuilder {
    type Target = PhysicalDeviceConservativeRasterizationPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCooperativeMatrixFeaturesNV {
    type Target = PhysicalDeviceCooperativeMatrixFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCooperativeMatrixFeaturesNV {
    type Builder = PhysicalDeviceCooperativeMatrixFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceCooperativeMatrixFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCooperativeMatrixFeaturesNVBuilder {
    value: PhysicalDeviceCooperativeMatrixFeaturesNV,
}

impl PhysicalDeviceCooperativeMatrixFeaturesNVBuilder {
    #[inline]
    pub fn cooperative_matrix(mut self, cooperative_matrix: bool) -> Self {
        self.value.cooperative_matrix = cooperative_matrix as Bool32;
        self
    }

    #[inline]
    pub fn cooperative_matrix_robust_buffer_access(
        mut self,
        cooperative_matrix_robust_buffer_access: bool,
    ) -> Self {
        self.value.cooperative_matrix_robust_buffer_access =
            cooperative_matrix_robust_buffer_access as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCooperativeMatrixFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCooperativeMatrixFeaturesNVBuilder {
    type Target = PhysicalDeviceCooperativeMatrixFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCooperativeMatrixFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCooperativeMatrixFeaturesNVBuilder {
    type Target = PhysicalDeviceCooperativeMatrixFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCooperativeMatrixPropertiesNV {
    type Target = PhysicalDeviceCooperativeMatrixPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCooperativeMatrixPropertiesNV {
    type Builder = PhysicalDeviceCooperativeMatrixPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceCooperativeMatrixPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCooperativeMatrixPropertiesNVBuilder {
    value: PhysicalDeviceCooperativeMatrixPropertiesNV,
}

impl PhysicalDeviceCooperativeMatrixPropertiesNVBuilder {
    #[inline]
    pub fn cooperative_matrix_supported_stages(
        mut self,
        cooperative_matrix_supported_stages: ShaderStageFlags,
    ) -> Self {
        self.value.cooperative_matrix_supported_stages = cooperative_matrix_supported_stages;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCooperativeMatrixPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCooperativeMatrixPropertiesNVBuilder {
    type Target = PhysicalDeviceCooperativeMatrixPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCooperativeMatrixPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCooperativeMatrixPropertiesNVBuilder {
    type Target = PhysicalDeviceCooperativeMatrixPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCornerSampledImageFeaturesNV {
    type Target = PhysicalDeviceCornerSampledImageFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCornerSampledImageFeaturesNV {
    type Builder = PhysicalDeviceCornerSampledImageFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceCornerSampledImageFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCornerSampledImageFeaturesNVBuilder {
    value: PhysicalDeviceCornerSampledImageFeaturesNV,
}

impl PhysicalDeviceCornerSampledImageFeaturesNVBuilder {
    #[inline]
    pub fn corner_sampled_image(mut self, corner_sampled_image: bool) -> Self {
        self.value.corner_sampled_image = corner_sampled_image as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCornerSampledImageFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCornerSampledImageFeaturesNVBuilder {
    type Target = PhysicalDeviceCornerSampledImageFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCornerSampledImageFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCornerSampledImageFeaturesNVBuilder {
    type Target = PhysicalDeviceCornerSampledImageFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCoverageReductionModeFeaturesNV {
    type Target = PhysicalDeviceCoverageReductionModeFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCoverageReductionModeFeaturesNV {
    type Builder = PhysicalDeviceCoverageReductionModeFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceCoverageReductionModeFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCoverageReductionModeFeaturesNVBuilder {
    value: PhysicalDeviceCoverageReductionModeFeaturesNV,
}

impl PhysicalDeviceCoverageReductionModeFeaturesNVBuilder {
    #[inline]
    pub fn coverage_reduction_mode(mut self, coverage_reduction_mode: bool) -> Self {
        self.value.coverage_reduction_mode = coverage_reduction_mode as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCoverageReductionModeFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCoverageReductionModeFeaturesNVBuilder {
    type Target = PhysicalDeviceCoverageReductionModeFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCoverageReductionModeFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCoverageReductionModeFeaturesNVBuilder {
    type Target = PhysicalDeviceCoverageReductionModeFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCustomBorderColorFeaturesEXT {
    type Target = PhysicalDeviceCustomBorderColorFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCustomBorderColorFeaturesEXT {
    type Builder = PhysicalDeviceCustomBorderColorFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceCustomBorderColorFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCustomBorderColorFeaturesEXTBuilder {
    value: PhysicalDeviceCustomBorderColorFeaturesEXT,
}

impl PhysicalDeviceCustomBorderColorFeaturesEXTBuilder {
    #[inline]
    pub fn custom_border_colors(mut self, custom_border_colors: bool) -> Self {
        self.value.custom_border_colors = custom_border_colors as Bool32;
        self
    }

    #[inline]
    pub fn custom_border_color_without_format(
        mut self,
        custom_border_color_without_format: bool,
    ) -> Self {
        self.value.custom_border_color_without_format =
            custom_border_color_without_format as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCustomBorderColorFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCustomBorderColorFeaturesEXTBuilder {
    type Target = PhysicalDeviceCustomBorderColorFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCustomBorderColorFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCustomBorderColorFeaturesEXTBuilder {
    type Target = PhysicalDeviceCustomBorderColorFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceCustomBorderColorPropertiesEXT {
    type Target = PhysicalDeviceCustomBorderColorPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceCustomBorderColorPropertiesEXT {
    type Builder = PhysicalDeviceCustomBorderColorPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceCustomBorderColorPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceCustomBorderColorPropertiesEXTBuilder {
    value: PhysicalDeviceCustomBorderColorPropertiesEXT,
}

impl PhysicalDeviceCustomBorderColorPropertiesEXTBuilder {
    #[inline]
    pub fn max_custom_border_color_samplers(
        mut self,
        max_custom_border_color_samplers: u32,
    ) -> Self {
        self.value.max_custom_border_color_samplers = max_custom_border_color_samplers;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceCustomBorderColorPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceCustomBorderColorPropertiesEXTBuilder {
    type Target = PhysicalDeviceCustomBorderColorPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceCustomBorderColorPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceCustomBorderColorPropertiesEXTBuilder {
    type Target = PhysicalDeviceCustomBorderColorPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    type Target = PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    type Builder = PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder {
    value: PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV,
}

impl PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder {
    #[inline]
    pub fn dedicated_allocation_image_aliasing(
        mut self,
        dedicated_allocation_image_aliasing: bool,
    ) -> Self {
        self.value.dedicated_allocation_image_aliasing =
            dedicated_allocation_image_aliasing as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder {
    type Target = PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNVBuilder {
    type Target = PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDepthClipEnableFeaturesEXT {
    type Target = PhysicalDeviceDepthClipEnableFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDepthClipEnableFeaturesEXT {
    type Builder = PhysicalDeviceDepthClipEnableFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceDepthClipEnableFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDepthClipEnableFeaturesEXTBuilder {
    value: PhysicalDeviceDepthClipEnableFeaturesEXT,
}

impl PhysicalDeviceDepthClipEnableFeaturesEXTBuilder {
    #[inline]
    pub fn depth_clip_enable(mut self, depth_clip_enable: bool) -> Self {
        self.value.depth_clip_enable = depth_clip_enable as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDepthClipEnableFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDepthClipEnableFeaturesEXTBuilder {
    type Target = PhysicalDeviceDepthClipEnableFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDepthClipEnableFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDepthClipEnableFeaturesEXTBuilder {
    type Target = PhysicalDeviceDepthClipEnableFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDepthStencilResolveProperties {
    type Target = PhysicalDeviceDepthStencilResolveProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDepthStencilResolveProperties {
    type Builder = PhysicalDeviceDepthStencilResolvePropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceDepthStencilResolveProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDepthStencilResolvePropertiesBuilder {
    value: PhysicalDeviceDepthStencilResolveProperties,
}

impl PhysicalDeviceDepthStencilResolvePropertiesBuilder {
    #[inline]
    pub fn supported_depth_resolve_modes(
        mut self,
        supported_depth_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.value.supported_depth_resolve_modes = supported_depth_resolve_modes;
        self
    }

    #[inline]
    pub fn supported_stencil_resolve_modes(
        mut self,
        supported_stencil_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.value.supported_stencil_resolve_modes = supported_stencil_resolve_modes;
        self
    }

    #[inline]
    pub fn independent_resolve_none(mut self, independent_resolve_none: bool) -> Self {
        self.value.independent_resolve_none = independent_resolve_none as Bool32;
        self
    }

    #[inline]
    pub fn independent_resolve(mut self, independent_resolve: bool) -> Self {
        self.value.independent_resolve = independent_resolve as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDepthStencilResolveProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDepthStencilResolvePropertiesBuilder {
    type Target = PhysicalDeviceDepthStencilResolveProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDepthStencilResolvePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDepthStencilResolvePropertiesBuilder {
    type Target = PhysicalDeviceDepthStencilResolveProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDescriptorIndexingFeatures {
    type Target = PhysicalDeviceDescriptorIndexingFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDescriptorIndexingFeatures {
    type Builder = PhysicalDeviceDescriptorIndexingFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceDescriptorIndexingFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDescriptorIndexingFeaturesBuilder {
    value: PhysicalDeviceDescriptorIndexingFeatures,
}

impl PhysicalDeviceDescriptorIndexingFeaturesBuilder {
    #[inline]
    pub fn shader_input_attachment_array_dynamic_indexing(
        mut self,
        shader_input_attachment_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_input_attachment_array_dynamic_indexing =
            shader_input_attachment_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value
            .shader_uniform_texel_buffer_array_dynamic_indexing =
            shader_uniform_texel_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value
            .shader_storage_texel_buffer_array_dynamic_indexing =
            shader_storage_texel_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_uniform_buffer_array_non_uniform_indexing =
            shader_uniform_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing(
        mut self,
        shader_sampled_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_sampled_image_array_non_uniform_indexing =
            shader_sampled_image_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_storage_buffer_array_non_uniform_indexing =
            shader_storage_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing(
        mut self,
        shader_storage_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_storage_image_array_non_uniform_indexing =
            shader_storage_image_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing(
        mut self,
        shader_input_attachment_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_input_attachment_array_non_uniform_indexing =
            shader_input_attachment_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_uniform_texel_buffer_array_non_uniform_indexing =
            shader_uniform_texel_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_storage_texel_buffer_array_non_uniform_indexing =
            shader_storage_texel_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_uniform_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_uniform_buffer_update_after_bind =
            descriptor_binding_uniform_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_sampled_image_update_after_bind(
        mut self,
        descriptor_binding_sampled_image_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_sampled_image_update_after_bind =
            descriptor_binding_sampled_image_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_image_update_after_bind(
        mut self,
        descriptor_binding_storage_image_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_image_update_after_bind =
            descriptor_binding_storage_image_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_buffer_update_after_bind =
            descriptor_binding_storage_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_uniform_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_uniform_texel_buffer_update_after_bind =
            descriptor_binding_uniform_texel_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_texel_buffer_update_after_bind =
            descriptor_binding_storage_texel_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_update_unused_while_pending(
        mut self,
        descriptor_binding_update_unused_while_pending: bool,
    ) -> Self {
        self.value.descriptor_binding_update_unused_while_pending =
            descriptor_binding_update_unused_while_pending as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_partially_bound(
        mut self,
        descriptor_binding_partially_bound: bool,
    ) -> Self {
        self.value.descriptor_binding_partially_bound =
            descriptor_binding_partially_bound as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_variable_descriptor_count(
        mut self,
        descriptor_binding_variable_descriptor_count: bool,
    ) -> Self {
        self.value.descriptor_binding_variable_descriptor_count =
            descriptor_binding_variable_descriptor_count as Bool32;
        self
    }

    #[inline]
    pub fn runtime_descriptor_array(mut self, runtime_descriptor_array: bool) -> Self {
        self.value.runtime_descriptor_array = runtime_descriptor_array as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDescriptorIndexingFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDescriptorIndexingFeaturesBuilder {
    type Target = PhysicalDeviceDescriptorIndexingFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDescriptorIndexingFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDescriptorIndexingFeaturesBuilder {
    type Target = PhysicalDeviceDescriptorIndexingFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDescriptorIndexingProperties {
    type Target = PhysicalDeviceDescriptorIndexingProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDescriptorIndexingProperties {
    type Builder = PhysicalDeviceDescriptorIndexingPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceDescriptorIndexingProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDescriptorIndexingPropertiesBuilder {
    value: PhysicalDeviceDescriptorIndexingProperties,
}

impl PhysicalDeviceDescriptorIndexingPropertiesBuilder {
    #[inline]
    pub fn max_update_after_bind_descriptors_in_all_pools(
        mut self,
        max_update_after_bind_descriptors_in_all_pools: u32,
    ) -> Self {
        self.value.max_update_after_bind_descriptors_in_all_pools =
            max_update_after_bind_descriptors_in_all_pools;
        self
    }

    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_uniform_buffer_array_non_uniform_indexing_native =
            shader_uniform_buffer_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing_native(
        mut self,
        shader_sampled_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_sampled_image_array_non_uniform_indexing_native =
            shader_sampled_image_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_storage_buffer_array_non_uniform_indexing_native =
            shader_storage_buffer_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing_native(
        mut self,
        shader_storage_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_storage_image_array_non_uniform_indexing_native =
            shader_storage_image_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing_native(
        mut self,
        shader_input_attachment_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_input_attachment_array_non_uniform_indexing_native =
            shader_input_attachment_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn robust_buffer_access_update_after_bind(
        mut self,
        robust_buffer_access_update_after_bind: bool,
    ) -> Self {
        self.value.robust_buffer_access_update_after_bind =
            robust_buffer_access_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn quad_divergent_implicit_lod(mut self, quad_divergent_implicit_lod: bool) -> Self {
        self.value.quad_divergent_implicit_lod = quad_divergent_implicit_lod as Bool32;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_samplers(
        mut self,
        max_per_stage_descriptor_update_after_bind_samplers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_samplers =
            max_per_stage_descriptor_update_after_bind_samplers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_uniform_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_uniform_buffers =
            max_per_stage_descriptor_update_after_bind_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_storage_buffers =
            max_per_stage_descriptor_update_after_bind_storage_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_sampled_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_sampled_images =
            max_per_stage_descriptor_update_after_bind_sampled_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_images: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_storage_images =
            max_per_stage_descriptor_update_after_bind_storage_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_input_attachments(
        mut self,
        max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_input_attachments =
            max_per_stage_descriptor_update_after_bind_input_attachments;
        self
    }

    #[inline]
    pub fn max_per_stage_update_after_bind_resources(
        mut self,
        max_per_stage_update_after_bind_resources: u32,
    ) -> Self {
        self.value.max_per_stage_update_after_bind_resources =
            max_per_stage_update_after_bind_resources;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_samplers(
        mut self,
        max_descriptor_set_update_after_bind_samplers: u32,
    ) -> Self {
        self.value.max_descriptor_set_update_after_bind_samplers =
            max_descriptor_set_update_after_bind_samplers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_uniform_buffers =
            max_descriptor_set_update_after_bind_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_uniform_buffers_dynamic =
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_buffers =
            max_descriptor_set_update_after_bind_storage_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_buffers_dynamic =
            max_descriptor_set_update_after_bind_storage_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_sampled_images(
        mut self,
        max_descriptor_set_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_sampled_images =
            max_descriptor_set_update_after_bind_sampled_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_images(
        mut self,
        max_descriptor_set_update_after_bind_storage_images: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_images =
            max_descriptor_set_update_after_bind_storage_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_input_attachments(
        mut self,
        max_descriptor_set_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_input_attachments =
            max_descriptor_set_update_after_bind_input_attachments;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDescriptorIndexingProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDescriptorIndexingPropertiesBuilder {
    type Target = PhysicalDeviceDescriptorIndexingProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDescriptorIndexingPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDescriptorIndexingPropertiesBuilder {
    type Target = PhysicalDeviceDescriptorIndexingProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    type Target = PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    type Builder = PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceDeviceGeneratedCommandsFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
    value: PhysicalDeviceDeviceGeneratedCommandsFeaturesNV,
}

impl PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
    #[inline]
    pub fn device_generated_commands(mut self, device_generated_commands: bool) -> Self {
        self.value.device_generated_commands = device_generated_commands as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
    type Target = PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
    type Target = PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    type Target = PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    type Builder = PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceDeviceGeneratedCommandsPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
    value: PhysicalDeviceDeviceGeneratedCommandsPropertiesNV,
}

impl PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
    #[inline]
    pub fn max_graphics_shader_group_count(mut self, max_graphics_shader_group_count: u32) -> Self {
        self.value.max_graphics_shader_group_count = max_graphics_shader_group_count;
        self
    }

    #[inline]
    pub fn max_indirect_sequence_count(mut self, max_indirect_sequence_count: u32) -> Self {
        self.value.max_indirect_sequence_count = max_indirect_sequence_count;
        self
    }

    #[inline]
    pub fn max_indirect_commands_token_count(
        mut self,
        max_indirect_commands_token_count: u32,
    ) -> Self {
        self.value.max_indirect_commands_token_count = max_indirect_commands_token_count;
        self
    }

    #[inline]
    pub fn max_indirect_commands_stream_count(
        mut self,
        max_indirect_commands_stream_count: u32,
    ) -> Self {
        self.value.max_indirect_commands_stream_count = max_indirect_commands_stream_count;
        self
    }

    #[inline]
    pub fn max_indirect_commands_token_offset(
        mut self,
        max_indirect_commands_token_offset: u32,
    ) -> Self {
        self.value.max_indirect_commands_token_offset = max_indirect_commands_token_offset;
        self
    }

    #[inline]
    pub fn max_indirect_commands_stream_stride(
        mut self,
        max_indirect_commands_stream_stride: u32,
    ) -> Self {
        self.value.max_indirect_commands_stream_stride = max_indirect_commands_stream_stride;
        self
    }

    #[inline]
    pub fn min_sequences_count_buffer_offset_alignment(
        mut self,
        min_sequences_count_buffer_offset_alignment: u32,
    ) -> Self {
        self.value.min_sequences_count_buffer_offset_alignment =
            min_sequences_count_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn min_sequences_index_buffer_offset_alignment(
        mut self,
        min_sequences_index_buffer_offset_alignment: u32,
    ) -> Self {
        self.value.min_sequences_index_buffer_offset_alignment =
            min_sequences_index_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn min_indirect_commands_buffer_offset_alignment(
        mut self,
        min_indirect_commands_buffer_offset_alignment: u32,
    ) -> Self {
        self.value.min_indirect_commands_buffer_offset_alignment =
            min_indirect_commands_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
    type Target = PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
    type Target = PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceMemoryReportFeaturesEXT {
    type Target = PhysicalDeviceDeviceMemoryReportFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDeviceMemoryReportFeaturesEXT {
    type Builder = PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceDeviceMemoryReportFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder {
    value: PhysicalDeviceDeviceMemoryReportFeaturesEXT,
}

impl PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder {
    #[inline]
    pub fn device_memory_report(mut self, device_memory_report: bool) -> Self {
        self.value.device_memory_report = device_memory_report as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDeviceMemoryReportFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder {
    type Target = PhysicalDeviceDeviceMemoryReportFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDeviceMemoryReportFeaturesEXTBuilder {
    type Target = PhysicalDeviceDeviceMemoryReportFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDiagnosticsConfigFeaturesNV {
    type Target = PhysicalDeviceDiagnosticsConfigFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDiagnosticsConfigFeaturesNV {
    type Builder = PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceDiagnosticsConfigFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder {
    value: PhysicalDeviceDiagnosticsConfigFeaturesNV,
}

impl PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder {
    #[inline]
    pub fn diagnostics_config(mut self, diagnostics_config: bool) -> Self {
        self.value.diagnostics_config = diagnostics_config as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDiagnosticsConfigFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder {
    type Target = PhysicalDeviceDiagnosticsConfigFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDiagnosticsConfigFeaturesNVBuilder {
    type Target = PhysicalDeviceDiagnosticsConfigFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDiscardRectanglePropertiesEXT {
    type Target = PhysicalDeviceDiscardRectanglePropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDiscardRectanglePropertiesEXT {
    type Builder = PhysicalDeviceDiscardRectanglePropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceDiscardRectanglePropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
    value: PhysicalDeviceDiscardRectanglePropertiesEXT,
}

impl PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
    #[inline]
    pub fn max_discard_rectangles(mut self, max_discard_rectangles: u32) -> Self {
        self.value.max_discard_rectangles = max_discard_rectangles;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDiscardRectanglePropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
    type Target = PhysicalDeviceDiscardRectanglePropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
    type Target = PhysicalDeviceDiscardRectanglePropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDriverProperties {
    type Target = PhysicalDeviceDriverProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDriverProperties {
    type Builder = PhysicalDeviceDriverPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceDriverProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDriverPropertiesBuilder {
    value: PhysicalDeviceDriverProperties,
}

impl PhysicalDeviceDriverPropertiesBuilder {
    #[inline]
    pub fn driver_id(mut self, driver_id: DriverId) -> Self {
        self.value.driver_id = driver_id;
        self
    }

    #[inline]
    pub fn driver_name(
        mut self,
        driver_name: impl Into<StringArray<MAX_DRIVER_NAME_SIZE>>,
    ) -> Self {
        self.value.driver_name = driver_name.into();
        self
    }

    #[inline]
    pub fn driver_info(
        mut self,
        driver_info: impl Into<StringArray<MAX_DRIVER_INFO_SIZE>>,
    ) -> Self {
        self.value.driver_info = driver_info.into();
        self
    }

    #[inline]
    pub fn conformance_version(
        mut self,
        conformance_version: impl Cast<Target = ConformanceVersion>,
    ) -> Self {
        self.value.conformance_version = conformance_version.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDriverProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDriverPropertiesBuilder {
    type Target = PhysicalDeviceDriverProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDriverPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDriverPropertiesBuilder {
    type Target = PhysicalDeviceDriverProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceDrmPropertiesEXT {
    type Target = PhysicalDeviceDrmPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceDrmPropertiesEXT {
    type Builder = PhysicalDeviceDrmPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceDrmPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceDrmPropertiesEXTBuilder {
    value: PhysicalDeviceDrmPropertiesEXT,
}

impl PhysicalDeviceDrmPropertiesEXTBuilder {
    #[inline]
    pub fn has_primary(mut self, has_primary: bool) -> Self {
        self.value.has_primary = has_primary as Bool32;
        self
    }

    #[inline]
    pub fn has_render(mut self, has_render: bool) -> Self {
        self.value.has_render = has_render as Bool32;
        self
    }

    #[inline]
    pub fn primary_major(mut self, primary_major: i64) -> Self {
        self.value.primary_major = primary_major;
        self
    }

    #[inline]
    pub fn primary_minor(mut self, primary_minor: i64) -> Self {
        self.value.primary_minor = primary_minor;
        self
    }

    #[inline]
    pub fn render_major(mut self, render_major: i64) -> Self {
        self.value.render_major = render_major;
        self
    }

    #[inline]
    pub fn render_minor(mut self, render_minor: i64) -> Self {
        self.value.render_minor = render_minor;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceDrmPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceDrmPropertiesEXTBuilder {
    type Target = PhysicalDeviceDrmPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceDrmPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceDrmPropertiesEXTBuilder {
    type Target = PhysicalDeviceDrmPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExclusiveScissorFeaturesNV {
    type Target = PhysicalDeviceExclusiveScissorFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExclusiveScissorFeaturesNV {
    type Builder = PhysicalDeviceExclusiveScissorFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceExclusiveScissorFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExclusiveScissorFeaturesNVBuilder {
    value: PhysicalDeviceExclusiveScissorFeaturesNV,
}

impl PhysicalDeviceExclusiveScissorFeaturesNVBuilder {
    #[inline]
    pub fn exclusive_scissor(mut self, exclusive_scissor: bool) -> Self {
        self.value.exclusive_scissor = exclusive_scissor as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExclusiveScissorFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExclusiveScissorFeaturesNVBuilder {
    type Target = PhysicalDeviceExclusiveScissorFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExclusiveScissorFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExclusiveScissorFeaturesNVBuilder {
    type Target = PhysicalDeviceExclusiveScissorFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExtendedDynamicState2FeaturesEXT {
    type Target = PhysicalDeviceExtendedDynamicState2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExtendedDynamicState2FeaturesEXT {
    type Builder = PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceExtendedDynamicState2FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder {
    value: PhysicalDeviceExtendedDynamicState2FeaturesEXT,
}

impl PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder {
    #[inline]
    pub fn extended_dynamic_state2(mut self, extended_dynamic_state2: bool) -> Self {
        self.value.extended_dynamic_state2 = extended_dynamic_state2 as Bool32;
        self
    }

    #[inline]
    pub fn extended_dynamic_state2_logic_op(
        mut self,
        extended_dynamic_state2_logic_op: bool,
    ) -> Self {
        self.value.extended_dynamic_state2_logic_op = extended_dynamic_state2_logic_op as Bool32;
        self
    }

    #[inline]
    pub fn extended_dynamic_state2_patch_control_points(
        mut self,
        extended_dynamic_state2_patch_control_points: bool,
    ) -> Self {
        self.value.extended_dynamic_state2_patch_control_points =
            extended_dynamic_state2_patch_control_points as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExtendedDynamicState2FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder {
    type Target = PhysicalDeviceExtendedDynamicState2FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExtendedDynamicState2FeaturesEXTBuilder {
    type Target = PhysicalDeviceExtendedDynamicState2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExtendedDynamicStateFeaturesEXT {
    type Target = PhysicalDeviceExtendedDynamicStateFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExtendedDynamicStateFeaturesEXT {
    type Builder = PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceExtendedDynamicStateFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder {
    value: PhysicalDeviceExtendedDynamicStateFeaturesEXT,
}

impl PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder {
    #[inline]
    pub fn extended_dynamic_state(mut self, extended_dynamic_state: bool) -> Self {
        self.value.extended_dynamic_state = extended_dynamic_state as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExtendedDynamicStateFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder {
    type Target = PhysicalDeviceExtendedDynamicStateFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExtendedDynamicStateFeaturesEXTBuilder {
    type Target = PhysicalDeviceExtendedDynamicStateFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalBufferInfo {
    type Target = PhysicalDeviceExternalBufferInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExternalBufferInfo {
    type Builder = PhysicalDeviceExternalBufferInfoBuilder;
}

/// A builder for a [`PhysicalDeviceExternalBufferInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalBufferInfoBuilder {
    value: PhysicalDeviceExternalBufferInfo,
}

impl PhysicalDeviceExternalBufferInfoBuilder {
    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalBufferInfo {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExternalBufferInfoBuilder {
    type Target = PhysicalDeviceExternalBufferInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExternalBufferInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalBufferInfoBuilder {
    type Target = PhysicalDeviceExternalBufferInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalFenceInfo {
    type Target = PhysicalDeviceExternalFenceInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExternalFenceInfo {
    type Builder = PhysicalDeviceExternalFenceInfoBuilder;
}

/// A builder for a [`PhysicalDeviceExternalFenceInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalFenceInfoBuilder {
    value: PhysicalDeviceExternalFenceInfo,
}

impl PhysicalDeviceExternalFenceInfoBuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalFenceInfo {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExternalFenceInfoBuilder {
    type Target = PhysicalDeviceExternalFenceInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExternalFenceInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalFenceInfoBuilder {
    type Target = PhysicalDeviceExternalFenceInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalImageFormatInfo {
    type Target = PhysicalDeviceExternalImageFormatInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExternalImageFormatInfo {
    type Builder = PhysicalDeviceExternalImageFormatInfoBuilder;
}

/// A builder for a [`PhysicalDeviceExternalImageFormatInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalImageFormatInfoBuilder {
    value: PhysicalDeviceExternalImageFormatInfo,
}

impl PhysicalDeviceExternalImageFormatInfoBuilder {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalImageFormatInfo {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExternalImageFormatInfoBuilder {
    type Target = PhysicalDeviceExternalImageFormatInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExternalImageFormatInfoBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalImageFormatInfoBuilder {
    type Target = PhysicalDeviceExternalImageFormatInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalMemoryHostPropertiesEXT {
    type Target = PhysicalDeviceExternalMemoryHostPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExternalMemoryHostPropertiesEXT {
    type Builder = PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceExternalMemoryHostPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder {
    value: PhysicalDeviceExternalMemoryHostPropertiesEXT,
}

impl PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder {
    #[inline]
    pub fn min_imported_host_pointer_alignment(
        mut self,
        min_imported_host_pointer_alignment: DeviceSize,
    ) -> Self {
        self.value.min_imported_host_pointer_alignment = min_imported_host_pointer_alignment;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalMemoryHostPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder {
    type Target = PhysicalDeviceExternalMemoryHostPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalMemoryHostPropertiesEXTBuilder {
    type Target = PhysicalDeviceExternalMemoryHostPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalMemoryRDMAFeaturesNV {
    type Target = PhysicalDeviceExternalMemoryRDMAFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceExternalMemoryRDMAFeaturesNV {
    type Builder = PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceExternalMemoryRDMAFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder {
    value: PhysicalDeviceExternalMemoryRDMAFeaturesNV,
}

impl PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder {
    #[inline]
    pub fn external_memory_rdma(mut self, external_memory_rdma: bool) -> Self {
        self.value.external_memory_rdma = external_memory_rdma as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalMemoryRDMAFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder {
    type Target = PhysicalDeviceExternalMemoryRDMAFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceExternalMemoryRDMAFeaturesNVBuilder {
    type Target = PhysicalDeviceExternalMemoryRDMAFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceExternalSemaphoreInfo`].
pub unsafe trait ExtendsPhysicalDeviceExternalSemaphoreInfo: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceExternalSemaphoreInfo for SemaphoreTypeCreateInfo {}

unsafe impl Cast for PhysicalDeviceExternalSemaphoreInfo {
    type Target = PhysicalDeviceExternalSemaphoreInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceExternalSemaphoreInfo {
    type Builder = PhysicalDeviceExternalSemaphoreInfoBuilder<'b>;
}

/// A builder for a [`PhysicalDeviceExternalSemaphoreInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceExternalSemaphoreInfoBuilder<'b> {
    value: PhysicalDeviceExternalSemaphoreInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceExternalSemaphoreInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceExternalSemaphoreInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceExternalSemaphoreInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.value.handle_type = handle_type;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceExternalSemaphoreInfo {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceExternalSemaphoreInfoBuilder<'b> {
    type Target = PhysicalDeviceExternalSemaphoreInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceExternalSemaphoreInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceExternalSemaphoreInfoBuilder<'b> {
    type Target = PhysicalDeviceExternalSemaphoreInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFeatures {
    type Target = PhysicalDeviceFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFeatures {
    type Builder = PhysicalDeviceFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFeaturesBuilder {
    value: PhysicalDeviceFeatures,
}

impl PhysicalDeviceFeaturesBuilder {
    #[inline]
    pub fn robust_buffer_access(mut self, robust_buffer_access: bool) -> Self {
        self.value.robust_buffer_access = robust_buffer_access as Bool32;
        self
    }

    #[inline]
    pub fn full_draw_index_uint32(mut self, full_draw_index_uint32: bool) -> Self {
        self.value.full_draw_index_uint32 = full_draw_index_uint32 as Bool32;
        self
    }

    #[inline]
    pub fn image_cube_array(mut self, image_cube_array: bool) -> Self {
        self.value.image_cube_array = image_cube_array as Bool32;
        self
    }

    #[inline]
    pub fn independent_blend(mut self, independent_blend: bool) -> Self {
        self.value.independent_blend = independent_blend as Bool32;
        self
    }

    #[inline]
    pub fn geometry_shader(mut self, geometry_shader: bool) -> Self {
        self.value.geometry_shader = geometry_shader as Bool32;
        self
    }

    #[inline]
    pub fn tessellation_shader(mut self, tessellation_shader: bool) -> Self {
        self.value.tessellation_shader = tessellation_shader as Bool32;
        self
    }

    #[inline]
    pub fn sample_rate_shading(mut self, sample_rate_shading: bool) -> Self {
        self.value.sample_rate_shading = sample_rate_shading as Bool32;
        self
    }

    #[inline]
    pub fn dual_src_blend(mut self, dual_src_blend: bool) -> Self {
        self.value.dual_src_blend = dual_src_blend as Bool32;
        self
    }

    #[inline]
    pub fn logic_op(mut self, logic_op: bool) -> Self {
        self.value.logic_op = logic_op as Bool32;
        self
    }

    #[inline]
    pub fn multi_draw_indirect(mut self, multi_draw_indirect: bool) -> Self {
        self.value.multi_draw_indirect = multi_draw_indirect as Bool32;
        self
    }

    #[inline]
    pub fn draw_indirect_first_instance(mut self, draw_indirect_first_instance: bool) -> Self {
        self.value.draw_indirect_first_instance = draw_indirect_first_instance as Bool32;
        self
    }

    #[inline]
    pub fn depth_clamp(mut self, depth_clamp: bool) -> Self {
        self.value.depth_clamp = depth_clamp as Bool32;
        self
    }

    #[inline]
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: bool) -> Self {
        self.value.depth_bias_clamp = depth_bias_clamp as Bool32;
        self
    }

    #[inline]
    pub fn fill_mode_non_solid(mut self, fill_mode_non_solid: bool) -> Self {
        self.value.fill_mode_non_solid = fill_mode_non_solid as Bool32;
        self
    }

    #[inline]
    pub fn depth_bounds(mut self, depth_bounds: bool) -> Self {
        self.value.depth_bounds = depth_bounds as Bool32;
        self
    }

    #[inline]
    pub fn wide_lines(mut self, wide_lines: bool) -> Self {
        self.value.wide_lines = wide_lines as Bool32;
        self
    }

    #[inline]
    pub fn large_points(mut self, large_points: bool) -> Self {
        self.value.large_points = large_points as Bool32;
        self
    }

    #[inline]
    pub fn alpha_to_one(mut self, alpha_to_one: bool) -> Self {
        self.value.alpha_to_one = alpha_to_one as Bool32;
        self
    }

    #[inline]
    pub fn multi_viewport(mut self, multi_viewport: bool) -> Self {
        self.value.multi_viewport = multi_viewport as Bool32;
        self
    }

    #[inline]
    pub fn sampler_anisotropy(mut self, sampler_anisotropy: bool) -> Self {
        self.value.sampler_anisotropy = sampler_anisotropy as Bool32;
        self
    }

    #[inline]
    pub fn texture_compression_etc2(mut self, texture_compression_etc2: bool) -> Self {
        self.value.texture_compression_etc2 = texture_compression_etc2 as Bool32;
        self
    }

    #[inline]
    pub fn texture_compression_astc_ldr(mut self, texture_compression_astc_ldr: bool) -> Self {
        self.value.texture_compression_astc_ldr = texture_compression_astc_ldr as Bool32;
        self
    }

    #[inline]
    pub fn texture_compression_bc(mut self, texture_compression_bc: bool) -> Self {
        self.value.texture_compression_bc = texture_compression_bc as Bool32;
        self
    }

    #[inline]
    pub fn occlusion_query_precise(mut self, occlusion_query_precise: bool) -> Self {
        self.value.occlusion_query_precise = occlusion_query_precise as Bool32;
        self
    }

    #[inline]
    pub fn pipeline_statistics_query(mut self, pipeline_statistics_query: bool) -> Self {
        self.value.pipeline_statistics_query = pipeline_statistics_query as Bool32;
        self
    }

    #[inline]
    pub fn vertex_pipeline_stores_and_atomics(
        mut self,
        vertex_pipeline_stores_and_atomics: bool,
    ) -> Self {
        self.value.vertex_pipeline_stores_and_atomics =
            vertex_pipeline_stores_and_atomics as Bool32;
        self
    }

    #[inline]
    pub fn fragment_stores_and_atomics(mut self, fragment_stores_and_atomics: bool) -> Self {
        self.value.fragment_stores_and_atomics = fragment_stores_and_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_tessellation_and_geometry_point_size(
        mut self,
        shader_tessellation_and_geometry_point_size: bool,
    ) -> Self {
        self.value.shader_tessellation_and_geometry_point_size =
            shader_tessellation_and_geometry_point_size as Bool32;
        self
    }

    #[inline]
    pub fn shader_image_gather_extended(mut self, shader_image_gather_extended: bool) -> Self {
        self.value.shader_image_gather_extended = shader_image_gather_extended as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_extended_formats(
        mut self,
        shader_storage_image_extended_formats: bool,
    ) -> Self {
        self.value.shader_storage_image_extended_formats =
            shader_storage_image_extended_formats as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_multisample(
        mut self,
        shader_storage_image_multisample: bool,
    ) -> Self {
        self.value.shader_storage_image_multisample = shader_storage_image_multisample as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_read_without_format(
        mut self,
        shader_storage_image_read_without_format: bool,
    ) -> Self {
        self.value.shader_storage_image_read_without_format =
            shader_storage_image_read_without_format as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_write_without_format(
        mut self,
        shader_storage_image_write_without_format: bool,
    ) -> Self {
        self.value.shader_storage_image_write_without_format =
            shader_storage_image_write_without_format as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_uniform_buffer_array_dynamic_indexing =
            shader_uniform_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_sampled_image_array_dynamic_indexing(
        mut self,
        shader_sampled_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_sampled_image_array_dynamic_indexing =
            shader_sampled_image_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_storage_buffer_array_dynamic_indexing =
            shader_storage_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_array_dynamic_indexing(
        mut self,
        shader_storage_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_storage_image_array_dynamic_indexing =
            shader_storage_image_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_clip_distance(mut self, shader_clip_distance: bool) -> Self {
        self.value.shader_clip_distance = shader_clip_distance as Bool32;
        self
    }

    #[inline]
    pub fn shader_cull_distance(mut self, shader_cull_distance: bool) -> Self {
        self.value.shader_cull_distance = shader_cull_distance as Bool32;
        self
    }

    #[inline]
    pub fn shader_float64(mut self, shader_float64: bool) -> Self {
        self.value.shader_float64 = shader_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_int64(mut self, shader_int64: bool) -> Self {
        self.value.shader_int64 = shader_int64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_int16(mut self, shader_int16: bool) -> Self {
        self.value.shader_int16 = shader_int16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_resource_residency(mut self, shader_resource_residency: bool) -> Self {
        self.value.shader_resource_residency = shader_resource_residency as Bool32;
        self
    }

    #[inline]
    pub fn shader_resource_min_lod(mut self, shader_resource_min_lod: bool) -> Self {
        self.value.shader_resource_min_lod = shader_resource_min_lod as Bool32;
        self
    }

    #[inline]
    pub fn sparse_binding(mut self, sparse_binding: bool) -> Self {
        self.value.sparse_binding = sparse_binding as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency_buffer(mut self, sparse_residency_buffer: bool) -> Self {
        self.value.sparse_residency_buffer = sparse_residency_buffer as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency_image_2d(mut self, sparse_residency_image_2d: bool) -> Self {
        self.value.sparse_residency_image_2d = sparse_residency_image_2d as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency_image_3d(mut self, sparse_residency_image_3d: bool) -> Self {
        self.value.sparse_residency_image_3d = sparse_residency_image_3d as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency2_samples(mut self, sparse_residency2_samples: bool) -> Self {
        self.value.sparse_residency2_samples = sparse_residency2_samples as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency4_samples(mut self, sparse_residency4_samples: bool) -> Self {
        self.value.sparse_residency4_samples = sparse_residency4_samples as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency8_samples(mut self, sparse_residency8_samples: bool) -> Self {
        self.value.sparse_residency8_samples = sparse_residency8_samples as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency16_samples(mut self, sparse_residency16_samples: bool) -> Self {
        self.value.sparse_residency16_samples = sparse_residency16_samples as Bool32;
        self
    }

    #[inline]
    pub fn sparse_residency_aliased(mut self, sparse_residency_aliased: bool) -> Self {
        self.value.sparse_residency_aliased = sparse_residency_aliased as Bool32;
        self
    }

    #[inline]
    pub fn variable_multisample_rate(mut self, variable_multisample_rate: bool) -> Self {
        self.value.variable_multisample_rate = variable_multisample_rate as Bool32;
        self
    }

    #[inline]
    pub fn inherited_queries(mut self, inherited_queries: bool) -> Self {
        self.value.inherited_queries = inherited_queries as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFeaturesBuilder {
    type Target = PhysicalDeviceFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFeaturesBuilder {
    type Target = PhysicalDeviceFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceFeatures2`].
pub unsafe trait ExtendsPhysicalDeviceFeatures2: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice16BitStorageFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice4444FormatsFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice8BitStorageFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceASTCDecodeFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceAccelerationStructureFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceBufferDeviceAddressFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceBufferDeviceAddressFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCoherentMemoryFeaturesAMD {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceColorWriteEnableFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceComputeShaderDerivativesFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceConditionalRenderingFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCooperativeMatrixFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCornerSampledImageFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCoverageReductionModeFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCustomBorderColorFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDepthClipEnableFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDescriptorIndexingFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDeviceMemoryReportFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDiagnosticsConfigFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceExclusiveScissorFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceExtendedDynamicState2FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceExtendedDynamicStateFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceExternalMemoryRDMAFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentDensityMap2FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentDensityMapFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentShaderBarycentricFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentShaderInterlockFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentShadingRateFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceGlobalPriorityQueryFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceHostQueryResetFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceImageRobustnessFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceImagelessFramebufferFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceIndexTypeUint8FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInheritedViewportScissorFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInlineUniformBlockFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInvocationMaskFeaturesHUAWEI {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceLineRasterizationFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMemoryPriorityFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMeshShaderFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiDrawFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiviewFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePerformanceQueryFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDevicePipelineCreationCacheControlFeaturesEXT
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDevicePipelineExecutablePropertiesFeaturesKHR
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePortabilitySubsetFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentIdFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentWaitFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePrivateDataFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceProtectedMemoryFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceProvokingVertexFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayQueryFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayTracingMotionBlurFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayTracingPipelineFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRepresentativeFragmentTestFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRobustness2FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSamplerYcbcrConversionFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceScalarBlockLayoutFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicFloat2FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicFloatFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicInt64Features {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderClockFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderDrawParametersFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderFloat16Int8Features {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderImageFootprintFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderIntegerDotProductFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderSMBuiltinsFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderTerminateInvocationFeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShadingRateImageFeaturesNV {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSubgroupSizeControlFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSubpassShadingFeaturesHUAWEI {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSynchronization2FeaturesKHR {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTexelBufferAlignmentFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTimelineSemaphoreFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTransformFeedbackFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceUniformBufferStandardLayoutFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVariablePointersFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVertexAttributeDivisorFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVertexInputDynamicStateFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVulkan11Features {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVulkan12Features {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVulkanMemoryModelFeatures {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceYcbcrImageArraysFeaturesEXT {}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR
{
}

unsafe impl Cast for PhysicalDeviceFeatures2 {
    type Target = PhysicalDeviceFeatures2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceFeatures2 {
    type Builder = PhysicalDeviceFeatures2Builder<'b>;
}

/// A builder for a [`PhysicalDeviceFeatures2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFeatures2Builder<'b> {
    value: PhysicalDeviceFeatures2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceFeatures2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceFeatures2,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceFeatures2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn features(mut self, features: impl Cast<Target = PhysicalDeviceFeatures>) -> Self {
        self.value.features = features.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFeatures2 {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceFeatures2Builder<'b> {
    type Target = PhysicalDeviceFeatures2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceFeatures2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceFeatures2Builder<'b> {
    type Target = PhysicalDeviceFeatures2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFloatControlsProperties {
    type Target = PhysicalDeviceFloatControlsProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFloatControlsProperties {
    type Builder = PhysicalDeviceFloatControlsPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceFloatControlsProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFloatControlsPropertiesBuilder {
    value: PhysicalDeviceFloatControlsProperties,
}

impl PhysicalDeviceFloatControlsPropertiesBuilder {
    #[inline]
    pub fn denorm_behavior_independence(
        mut self,
        denorm_behavior_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.value.denorm_behavior_independence = denorm_behavior_independence;
        self
    }

    #[inline]
    pub fn rounding_mode_independence(
        mut self,
        rounding_mode_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.value.rounding_mode_independence = rounding_mode_independence;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float16(
        mut self,
        shader_signed_zero_inf_nan_preserve_float16: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float16 =
            shader_signed_zero_inf_nan_preserve_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float32(
        mut self,
        shader_signed_zero_inf_nan_preserve_float32: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float32 =
            shader_signed_zero_inf_nan_preserve_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float64(
        mut self,
        shader_signed_zero_inf_nan_preserve_float64: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float64 =
            shader_signed_zero_inf_nan_preserve_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float16(mut self, shader_denorm_preserve_float16: bool) -> Self {
        self.value.shader_denorm_preserve_float16 = shader_denorm_preserve_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float32(mut self, shader_denorm_preserve_float32: bool) -> Self {
        self.value.shader_denorm_preserve_float32 = shader_denorm_preserve_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float64(mut self, shader_denorm_preserve_float64: bool) -> Self {
        self.value.shader_denorm_preserve_float64 = shader_denorm_preserve_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float16(
        mut self,
        shader_denorm_flush_to_zero_float16: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float16 =
            shader_denorm_flush_to_zero_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float32(
        mut self,
        shader_denorm_flush_to_zero_float32: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float32 =
            shader_denorm_flush_to_zero_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float64(
        mut self,
        shader_denorm_flush_to_zero_float64: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float64 =
            shader_denorm_flush_to_zero_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float16(
        mut self,
        shader_rounding_mode_rte_float16: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float16 = shader_rounding_mode_rte_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float32(
        mut self,
        shader_rounding_mode_rte_float32: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float32 = shader_rounding_mode_rte_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float64(
        mut self,
        shader_rounding_mode_rte_float64: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float64 = shader_rounding_mode_rte_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float16(
        mut self,
        shader_rounding_mode_rtz_float16: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float16 = shader_rounding_mode_rtz_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float32(
        mut self,
        shader_rounding_mode_rtz_float32: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float32 = shader_rounding_mode_rtz_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float64(
        mut self,
        shader_rounding_mode_rtz_float64: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float64 = shader_rounding_mode_rtz_float64 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFloatControlsProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFloatControlsPropertiesBuilder {
    type Target = PhysicalDeviceFloatControlsProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFloatControlsPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFloatControlsPropertiesBuilder {
    type Target = PhysicalDeviceFloatControlsProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMap2FeaturesEXT {
    type Target = PhysicalDeviceFragmentDensityMap2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentDensityMap2FeaturesEXT {
    type Builder = PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentDensityMap2FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder {
    value: PhysicalDeviceFragmentDensityMap2FeaturesEXT,
}

impl PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder {
    #[inline]
    pub fn fragment_density_map_deferred(mut self, fragment_density_map_deferred: bool) -> Self {
        self.value.fragment_density_map_deferred = fragment_density_map_deferred as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentDensityMap2FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMap2FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMap2FeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMap2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMap2PropertiesEXT {
    type Target = PhysicalDeviceFragmentDensityMap2PropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentDensityMap2PropertiesEXT {
    type Builder = PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentDensityMap2PropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder {
    value: PhysicalDeviceFragmentDensityMap2PropertiesEXT,
}

impl PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder {
    #[inline]
    pub fn subsampled_loads(mut self, subsampled_loads: bool) -> Self {
        self.value.subsampled_loads = subsampled_loads as Bool32;
        self
    }

    #[inline]
    pub fn subsampled_coarse_reconstruction_early_access(
        mut self,
        subsampled_coarse_reconstruction_early_access: bool,
    ) -> Self {
        self.value.subsampled_coarse_reconstruction_early_access =
            subsampled_coarse_reconstruction_early_access as Bool32;
        self
    }

    #[inline]
    pub fn max_subsampled_array_layers(mut self, max_subsampled_array_layers: u32) -> Self {
        self.value.max_subsampled_array_layers = max_subsampled_array_layers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_subsampled_samplers(
        mut self,
        max_descriptor_set_subsampled_samplers: u32,
    ) -> Self {
        self.value.max_descriptor_set_subsampled_samplers = max_descriptor_set_subsampled_samplers;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentDensityMap2PropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMap2PropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMap2PropertiesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMap2PropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMapFeaturesEXT {
    type Target = PhysicalDeviceFragmentDensityMapFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentDensityMapFeaturesEXT {
    type Builder = PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentDensityMapFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder {
    value: PhysicalDeviceFragmentDensityMapFeaturesEXT,
}

impl PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder {
    #[inline]
    pub fn fragment_density_map(mut self, fragment_density_map: bool) -> Self {
        self.value.fragment_density_map = fragment_density_map as Bool32;
        self
    }

    #[inline]
    pub fn fragment_density_map_dynamic(mut self, fragment_density_map_dynamic: bool) -> Self {
        self.value.fragment_density_map_dynamic = fragment_density_map_dynamic as Bool32;
        self
    }

    #[inline]
    pub fn fragment_density_map_non_subsampled_images(
        mut self,
        fragment_density_map_non_subsampled_images: bool,
    ) -> Self {
        self.value.fragment_density_map_non_subsampled_images =
            fragment_density_map_non_subsampled_images as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentDensityMapFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMapFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMapFeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMapFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMapPropertiesEXT {
    type Target = PhysicalDeviceFragmentDensityMapPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentDensityMapPropertiesEXT {
    type Builder = PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentDensityMapPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder {
    value: PhysicalDeviceFragmentDensityMapPropertiesEXT,
}

impl PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder {
    #[inline]
    pub fn min_fragment_density_texel_size(
        mut self,
        min_fragment_density_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.min_fragment_density_texel_size = min_fragment_density_texel_size.into();
        self
    }

    #[inline]
    pub fn max_fragment_density_texel_size(
        mut self,
        max_fragment_density_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.max_fragment_density_texel_size = max_fragment_density_texel_size.into();
        self
    }

    #[inline]
    pub fn fragment_density_invocations(mut self, fragment_density_invocations: bool) -> Self {
        self.value.fragment_density_invocations = fragment_density_invocations as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentDensityMapPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMapPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentDensityMapPropertiesEXTBuilder {
    type Target = PhysicalDeviceFragmentDensityMapPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    type Target = PhysicalDeviceFragmentShaderBarycentricFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    type Builder = PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShaderBarycentricFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder {
    value: PhysicalDeviceFragmentShaderBarycentricFeaturesNV,
}

impl PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder {
    #[inline]
    pub fn fragment_shader_barycentric(mut self, fragment_shader_barycentric: bool) -> Self {
        self.value.fragment_shader_barycentric = fragment_shader_barycentric as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder {
    type Target = PhysicalDeviceFragmentShaderBarycentricFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShaderBarycentricFeaturesNVBuilder {
    type Target = PhysicalDeviceFragmentShaderBarycentricFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    type Target = PhysicalDeviceFragmentShaderInterlockFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    type Builder = PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShaderInterlockFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder {
    value: PhysicalDeviceFragmentShaderInterlockFeaturesEXT,
}

impl PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder {
    #[inline]
    pub fn fragment_shader_sample_interlock(
        mut self,
        fragment_shader_sample_interlock: bool,
    ) -> Self {
        self.value.fragment_shader_sample_interlock = fragment_shader_sample_interlock as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shader_pixel_interlock(
        mut self,
        fragment_shader_pixel_interlock: bool,
    ) -> Self {
        self.value.fragment_shader_pixel_interlock = fragment_shader_pixel_interlock as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shader_shading_rate_interlock(
        mut self,
        fragment_shader_shading_rate_interlock: bool,
    ) -> Self {
        self.value.fragment_shader_shading_rate_interlock =
            fragment_shader_shading_rate_interlock as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentShaderInterlockFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShaderInterlockFeaturesEXTBuilder {
    type Target = PhysicalDeviceFragmentShaderInterlockFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    type Target = PhysicalDeviceFragmentShadingRateEnumsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    type Builder = PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShadingRateEnumsFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder {
    value: PhysicalDeviceFragmentShadingRateEnumsFeaturesNV,
}

impl PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder {
    #[inline]
    pub fn fragment_shading_rate_enums(mut self, fragment_shading_rate_enums: bool) -> Self {
        self.value.fragment_shading_rate_enums = fragment_shading_rate_enums as Bool32;
        self
    }

    #[inline]
    pub fn supersample_fragment_shading_rates(
        mut self,
        supersample_fragment_shading_rates: bool,
    ) -> Self {
        self.value.supersample_fragment_shading_rates =
            supersample_fragment_shading_rates as Bool32;
        self
    }

    #[inline]
    pub fn no_invocation_fragment_shading_rates(
        mut self,
        no_invocation_fragment_shading_rates: bool,
    ) -> Self {
        self.value.no_invocation_fragment_shading_rates =
            no_invocation_fragment_shading_rates as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder {
    type Target = PhysicalDeviceFragmentShadingRateEnumsFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateEnumsFeaturesNVBuilder {
    type Target = PhysicalDeviceFragmentShadingRateEnumsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    type Target = PhysicalDeviceFragmentShadingRateEnumsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    type Builder = PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShadingRateEnumsPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder {
    value: PhysicalDeviceFragmentShadingRateEnumsPropertiesNV,
}

impl PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder {
    #[inline]
    pub fn max_fragment_shading_rate_invocation_count(
        mut self,
        max_fragment_shading_rate_invocation_count: SampleCountFlags,
    ) -> Self {
        self.value.max_fragment_shading_rate_invocation_count =
            max_fragment_shading_rate_invocation_count;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder {
    type Target = PhysicalDeviceFragmentShadingRateEnumsPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateEnumsPropertiesNVBuilder {
    type Target = PhysicalDeviceFragmentShadingRateEnumsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateFeaturesKHR {
    type Target = PhysicalDeviceFragmentShadingRateFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShadingRateFeaturesKHR {
    type Builder = PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShadingRateFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder {
    value: PhysicalDeviceFragmentShadingRateFeaturesKHR,
}

impl PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder {
    #[inline]
    pub fn pipeline_fragment_shading_rate(mut self, pipeline_fragment_shading_rate: bool) -> Self {
        self.value.pipeline_fragment_shading_rate = pipeline_fragment_shading_rate as Bool32;
        self
    }

    #[inline]
    pub fn primitive_fragment_shading_rate(
        mut self,
        primitive_fragment_shading_rate: bool,
    ) -> Self {
        self.value.primitive_fragment_shading_rate = primitive_fragment_shading_rate as Bool32;
        self
    }

    #[inline]
    pub fn attachment_fragment_shading_rate(
        mut self,
        attachment_fragment_shading_rate: bool,
    ) -> Self {
        self.value.attachment_fragment_shading_rate = attachment_fragment_shading_rate as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShadingRateFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRateFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateFeaturesKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRateFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateKHR {
    type Target = PhysicalDeviceFragmentShadingRateKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShadingRateKHR {
    type Builder = PhysicalDeviceFragmentShadingRateKHRBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShadingRateKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShadingRateKHRBuilder {
    value: PhysicalDeviceFragmentShadingRateKHR,
}

impl PhysicalDeviceFragmentShadingRateKHRBuilder {
    #[inline]
    pub fn sample_counts(mut self, sample_counts: SampleCountFlags) -> Self {
        self.value.sample_counts = sample_counts;
        self
    }

    #[inline]
    pub fn fragment_size(mut self, fragment_size: impl Cast<Target = Extent2D>) -> Self {
        self.value.fragment_size = fragment_size.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShadingRateKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShadingRateKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRateKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShadingRateKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRateKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRateKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRatePropertiesKHR {
    type Target = PhysicalDeviceFragmentShadingRatePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceFragmentShadingRatePropertiesKHR {
    type Builder = PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceFragmentShadingRatePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder {
    value: PhysicalDeviceFragmentShadingRatePropertiesKHR,
}

impl PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder {
    #[inline]
    pub fn min_fragment_shading_rate_attachment_texel_size(
        mut self,
        min_fragment_shading_rate_attachment_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.min_fragment_shading_rate_attachment_texel_size =
            min_fragment_shading_rate_attachment_texel_size.into();
        self
    }

    #[inline]
    pub fn max_fragment_shading_rate_attachment_texel_size(
        mut self,
        max_fragment_shading_rate_attachment_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.max_fragment_shading_rate_attachment_texel_size =
            max_fragment_shading_rate_attachment_texel_size.into();
        self
    }

    #[inline]
    pub fn max_fragment_shading_rate_attachment_texel_size_aspect_ratio(
        mut self,
        max_fragment_shading_rate_attachment_texel_size_aspect_ratio: u32,
    ) -> Self {
        self.value
            .max_fragment_shading_rate_attachment_texel_size_aspect_ratio =
            max_fragment_shading_rate_attachment_texel_size_aspect_ratio;
        self
    }

    #[inline]
    pub fn primitive_fragment_shading_rate_with_multiple_viewports(
        mut self,
        primitive_fragment_shading_rate_with_multiple_viewports: bool,
    ) -> Self {
        self.value
            .primitive_fragment_shading_rate_with_multiple_viewports =
            primitive_fragment_shading_rate_with_multiple_viewports as Bool32;
        self
    }

    #[inline]
    pub fn layered_shading_rate_attachments(
        mut self,
        layered_shading_rate_attachments: bool,
    ) -> Self {
        self.value.layered_shading_rate_attachments = layered_shading_rate_attachments as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_non_trivial_combiner_ops(
        mut self,
        fragment_shading_rate_non_trivial_combiner_ops: bool,
    ) -> Self {
        self.value.fragment_shading_rate_non_trivial_combiner_ops =
            fragment_shading_rate_non_trivial_combiner_ops as Bool32;
        self
    }

    #[inline]
    pub fn max_fragment_size(mut self, max_fragment_size: impl Cast<Target = Extent2D>) -> Self {
        self.value.max_fragment_size = max_fragment_size.into();
        self
    }

    #[inline]
    pub fn max_fragment_size_aspect_ratio(mut self, max_fragment_size_aspect_ratio: u32) -> Self {
        self.value.max_fragment_size_aspect_ratio = max_fragment_size_aspect_ratio;
        self
    }

    #[inline]
    pub fn max_fragment_shading_rate_coverage_samples(
        mut self,
        max_fragment_shading_rate_coverage_samples: u32,
    ) -> Self {
        self.value.max_fragment_shading_rate_coverage_samples =
            max_fragment_shading_rate_coverage_samples;
        self
    }

    #[inline]
    pub fn max_fragment_shading_rate_rasterization_samples(
        mut self,
        max_fragment_shading_rate_rasterization_samples: SampleCountFlags,
    ) -> Self {
        self.value.max_fragment_shading_rate_rasterization_samples =
            max_fragment_shading_rate_rasterization_samples;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_shader_depth_stencil_writes(
        mut self,
        fragment_shading_rate_with_shader_depth_stencil_writes: bool,
    ) -> Self {
        self.value
            .fragment_shading_rate_with_shader_depth_stencil_writes =
            fragment_shading_rate_with_shader_depth_stencil_writes as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_sample_mask(
        mut self,
        fragment_shading_rate_with_sample_mask: bool,
    ) -> Self {
        self.value.fragment_shading_rate_with_sample_mask =
            fragment_shading_rate_with_sample_mask as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_shader_sample_mask(
        mut self,
        fragment_shading_rate_with_shader_sample_mask: bool,
    ) -> Self {
        self.value.fragment_shading_rate_with_shader_sample_mask =
            fragment_shading_rate_with_shader_sample_mask as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_conservative_rasterization(
        mut self,
        fragment_shading_rate_with_conservative_rasterization: bool,
    ) -> Self {
        self.value
            .fragment_shading_rate_with_conservative_rasterization =
            fragment_shading_rate_with_conservative_rasterization as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_fragment_shader_interlock(
        mut self,
        fragment_shading_rate_with_fragment_shader_interlock: bool,
    ) -> Self {
        self.value
            .fragment_shading_rate_with_fragment_shader_interlock =
            fragment_shading_rate_with_fragment_shader_interlock as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_with_custom_sample_locations(
        mut self,
        fragment_shading_rate_with_custom_sample_locations: bool,
    ) -> Self {
        self.value
            .fragment_shading_rate_with_custom_sample_locations =
            fragment_shading_rate_with_custom_sample_locations as Bool32;
        self
    }

    #[inline]
    pub fn fragment_shading_rate_strict_multiply_combiner(
        mut self,
        fragment_shading_rate_strict_multiply_combiner: bool,
    ) -> Self {
        self.value.fragment_shading_rate_strict_multiply_combiner =
            fragment_shading_rate_strict_multiply_combiner as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceFragmentShadingRatePropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRatePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceFragmentShadingRatePropertiesKHRBuilder {
    type Target = PhysicalDeviceFragmentShadingRatePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceGlobalPriorityQueryFeaturesEXT {
    type Target = PhysicalDeviceGlobalPriorityQueryFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceGlobalPriorityQueryFeaturesEXT {
    type Builder = PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceGlobalPriorityQueryFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder {
    value: PhysicalDeviceGlobalPriorityQueryFeaturesEXT,
}

impl PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder {
    #[inline]
    pub fn global_priority_query(mut self, global_priority_query: bool) -> Self {
        self.value.global_priority_query = global_priority_query as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceGlobalPriorityQueryFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder {
    type Target = PhysicalDeviceGlobalPriorityQueryFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceGlobalPriorityQueryFeaturesEXTBuilder {
    type Target = PhysicalDeviceGlobalPriorityQueryFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceGroupProperties {
    type Target = PhysicalDeviceGroupProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceGroupProperties {
    type Builder = PhysicalDeviceGroupPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceGroupProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceGroupPropertiesBuilder {
    value: PhysicalDeviceGroupProperties,
}

impl PhysicalDeviceGroupPropertiesBuilder {
    #[inline]
    pub fn physical_device_count(mut self, physical_device_count: u32) -> Self {
        self.value.physical_device_count = physical_device_count;
        self
    }

    #[inline]
    pub fn physical_devices(
        mut self,
        physical_devices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE],
    ) -> Self {
        self.value.physical_devices = physical_devices;
        self
    }

    #[inline]
    pub fn subset_allocation(mut self, subset_allocation: bool) -> Self {
        self.value.subset_allocation = subset_allocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceGroupProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceGroupPropertiesBuilder {
    type Target = PhysicalDeviceGroupProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceGroupPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceGroupPropertiesBuilder {
    type Target = PhysicalDeviceGroupProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceHostQueryResetFeatures {
    type Target = PhysicalDeviceHostQueryResetFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceHostQueryResetFeatures {
    type Builder = PhysicalDeviceHostQueryResetFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceHostQueryResetFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceHostQueryResetFeaturesBuilder {
    value: PhysicalDeviceHostQueryResetFeatures,
}

impl PhysicalDeviceHostQueryResetFeaturesBuilder {
    #[inline]
    pub fn host_query_reset(mut self, host_query_reset: bool) -> Self {
        self.value.host_query_reset = host_query_reset as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceHostQueryResetFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceHostQueryResetFeaturesBuilder {
    type Target = PhysicalDeviceHostQueryResetFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceHostQueryResetFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceHostQueryResetFeaturesBuilder {
    type Target = PhysicalDeviceHostQueryResetFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceIDProperties {
    type Target = PhysicalDeviceIDProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceIDProperties {
    type Builder = PhysicalDeviceIDPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceIDProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceIDPropertiesBuilder {
    value: PhysicalDeviceIDProperties,
}

impl PhysicalDeviceIDPropertiesBuilder {
    #[inline]
    pub fn device_uuid(mut self, device_uuid: impl Into<ByteArray<UUID_SIZE>>) -> Self {
        self.value.device_uuid = device_uuid.into();
        self
    }

    #[inline]
    pub fn driver_uuid(mut self, driver_uuid: impl Into<ByteArray<UUID_SIZE>>) -> Self {
        self.value.driver_uuid = driver_uuid.into();
        self
    }

    #[inline]
    pub fn device_luid(mut self, device_luid: impl Into<ByteArray<LUID_SIZE>>) -> Self {
        self.value.device_luid = device_luid.into();
        self
    }

    #[inline]
    pub fn device_node_mask(mut self, device_node_mask: u32) -> Self {
        self.value.device_node_mask = device_node_mask;
        self
    }

    #[inline]
    pub fn device_luid_valid(mut self, device_luid_valid: bool) -> Self {
        self.value.device_luid_valid = device_luid_valid as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceIDProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceIDPropertiesBuilder {
    type Target = PhysicalDeviceIDProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceIDPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceIDPropertiesBuilder {
    type Target = PhysicalDeviceIDProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceImageDrmFormatModifierInfoEXT {
    type Target = PhysicalDeviceImageDrmFormatModifierInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceImageDrmFormatModifierInfoEXT {
    type Builder = PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b>;
}

/// A builder for a [`PhysicalDeviceImageDrmFormatModifierInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b> {
    value: PhysicalDeviceImageDrmFormatModifierInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b> {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.value.drm_format_modifier = drm_format_modifier;
        self
    }

    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.value.sharing_mode = sharing_mode;
        self
    }

    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'b [u32]) -> Self {
        self.value.queue_family_index_count = queue_family_indices.len() as u32;
        self.value.queue_family_indices = queue_family_indices.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceImageDrmFormatModifierInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b> {
    type Target = PhysicalDeviceImageDrmFormatModifierInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceImageDrmFormatModifierInfoEXTBuilder<'b> {
    type Target = PhysicalDeviceImageDrmFormatModifierInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceImageFormatInfo2`].
pub unsafe trait ExtendsPhysicalDeviceImageFormatInfo2: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageFormatListCreateInfo {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageStencilUsageCreateInfo {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceExternalImageFormatInfo {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceImageDrmFormatModifierInfoEXT {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceImageViewImageFormatInfoEXT {}

unsafe impl Cast for PhysicalDeviceImageFormatInfo2 {
    type Target = PhysicalDeviceImageFormatInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceImageFormatInfo2 {
    type Builder = PhysicalDeviceImageFormatInfo2Builder<'b>;
}

/// A builder for a [`PhysicalDeviceImageFormatInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceImageFormatInfo2Builder<'b> {
    value: PhysicalDeviceImageFormatInfo2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceImageFormatInfo2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceImageFormatInfo2,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceImageFormatInfo2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn type_(mut self, type_: ImageType) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.value.tiling = tiling;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceImageFormatInfo2 {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceImageFormatInfo2Builder<'b> {
    type Target = PhysicalDeviceImageFormatInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceImageFormatInfo2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceImageFormatInfo2Builder<'b> {
    type Target = PhysicalDeviceImageFormatInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceImageRobustnessFeaturesEXT {
    type Target = PhysicalDeviceImageRobustnessFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceImageRobustnessFeaturesEXT {
    type Builder = PhysicalDeviceImageRobustnessFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceImageRobustnessFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceImageRobustnessFeaturesEXTBuilder {
    value: PhysicalDeviceImageRobustnessFeaturesEXT,
}

impl PhysicalDeviceImageRobustnessFeaturesEXTBuilder {
    #[inline]
    pub fn robust_image_access(mut self, robust_image_access: bool) -> Self {
        self.value.robust_image_access = robust_image_access as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceImageRobustnessFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceImageRobustnessFeaturesEXTBuilder {
    type Target = PhysicalDeviceImageRobustnessFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceImageRobustnessFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceImageRobustnessFeaturesEXTBuilder {
    type Target = PhysicalDeviceImageRobustnessFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceImageViewImageFormatInfoEXT {
    type Target = PhysicalDeviceImageViewImageFormatInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceImageViewImageFormatInfoEXT {
    type Builder = PhysicalDeviceImageViewImageFormatInfoEXTBuilder;
}

/// A builder for a [`PhysicalDeviceImageViewImageFormatInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceImageViewImageFormatInfoEXTBuilder {
    value: PhysicalDeviceImageViewImageFormatInfoEXT,
}

impl PhysicalDeviceImageViewImageFormatInfoEXTBuilder {
    #[inline]
    pub fn image_view_type(mut self, image_view_type: ImageViewType) -> Self {
        self.value.image_view_type = image_view_type;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceImageViewImageFormatInfoEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceImageViewImageFormatInfoEXTBuilder {
    type Target = PhysicalDeviceImageViewImageFormatInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceImageViewImageFormatInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceImageViewImageFormatInfoEXTBuilder {
    type Target = PhysicalDeviceImageViewImageFormatInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceImagelessFramebufferFeatures {
    type Target = PhysicalDeviceImagelessFramebufferFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceImagelessFramebufferFeatures {
    type Builder = PhysicalDeviceImagelessFramebufferFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceImagelessFramebufferFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceImagelessFramebufferFeaturesBuilder {
    value: PhysicalDeviceImagelessFramebufferFeatures,
}

impl PhysicalDeviceImagelessFramebufferFeaturesBuilder {
    #[inline]
    pub fn imageless_framebuffer(mut self, imageless_framebuffer: bool) -> Self {
        self.value.imageless_framebuffer = imageless_framebuffer as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceImagelessFramebufferFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceImagelessFramebufferFeaturesBuilder {
    type Target = PhysicalDeviceImagelessFramebufferFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceImagelessFramebufferFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceImagelessFramebufferFeaturesBuilder {
    type Target = PhysicalDeviceImagelessFramebufferFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceIndexTypeUint8FeaturesEXT {
    type Target = PhysicalDeviceIndexTypeUint8FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceIndexTypeUint8FeaturesEXT {
    type Builder = PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceIndexTypeUint8FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder {
    value: PhysicalDeviceIndexTypeUint8FeaturesEXT,
}

impl PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder {
    #[inline]
    pub fn index_type_uint8(mut self, index_type_uint8: bool) -> Self {
        self.value.index_type_uint8 = index_type_uint8 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceIndexTypeUint8FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder {
    type Target = PhysicalDeviceIndexTypeUint8FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceIndexTypeUint8FeaturesEXTBuilder {
    type Target = PhysicalDeviceIndexTypeUint8FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceInheritedViewportScissorFeaturesNV {
    type Target = PhysicalDeviceInheritedViewportScissorFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceInheritedViewportScissorFeaturesNV {
    type Builder = PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceInheritedViewportScissorFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder {
    value: PhysicalDeviceInheritedViewportScissorFeaturesNV,
}

impl PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder {
    #[inline]
    pub fn inherited_viewport_scissor_2d(mut self, inherited_viewport_scissor_2d: bool) -> Self {
        self.value.inherited_viewport_scissor_2d = inherited_viewport_scissor_2d as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceInheritedViewportScissorFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder {
    type Target = PhysicalDeviceInheritedViewportScissorFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceInheritedViewportScissorFeaturesNVBuilder {
    type Target = PhysicalDeviceInheritedViewportScissorFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceInlineUniformBlockFeaturesEXT {
    type Target = PhysicalDeviceInlineUniformBlockFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceInlineUniformBlockFeaturesEXT {
    type Builder = PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceInlineUniformBlockFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder {
    value: PhysicalDeviceInlineUniformBlockFeaturesEXT,
}

impl PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder {
    #[inline]
    pub fn inline_uniform_block(mut self, inline_uniform_block: bool) -> Self {
        self.value.inline_uniform_block = inline_uniform_block as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_inline_uniform_block_update_after_bind(
        mut self,
        descriptor_binding_inline_uniform_block_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_inline_uniform_block_update_after_bind =
            descriptor_binding_inline_uniform_block_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceInlineUniformBlockFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder {
    type Target = PhysicalDeviceInlineUniformBlockFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceInlineUniformBlockFeaturesEXTBuilder {
    type Target = PhysicalDeviceInlineUniformBlockFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceInlineUniformBlockPropertiesEXT {
    type Target = PhysicalDeviceInlineUniformBlockPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceInlineUniformBlockPropertiesEXT {
    type Builder = PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceInlineUniformBlockPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder {
    value: PhysicalDeviceInlineUniformBlockPropertiesEXT,
}

impl PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder {
    #[inline]
    pub fn max_inline_uniform_block_size(mut self, max_inline_uniform_block_size: u32) -> Self {
        self.value.max_inline_uniform_block_size = max_inline_uniform_block_size;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_inline_uniform_blocks: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_inline_uniform_blocks =
            max_per_stage_descriptor_inline_uniform_blocks;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_inline_uniform_blocks =
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks;
        self
    }

    #[inline]
    pub fn max_descriptor_set_inline_uniform_blocks(
        mut self,
        max_descriptor_set_inline_uniform_blocks: u32,
    ) -> Self {
        self.value.max_descriptor_set_inline_uniform_blocks =
            max_descriptor_set_inline_uniform_blocks;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_inline_uniform_blocks(
        mut self,
        max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_inline_uniform_blocks =
            max_descriptor_set_update_after_bind_inline_uniform_blocks;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceInlineUniformBlockPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder {
    type Target = PhysicalDeviceInlineUniformBlockPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceInlineUniformBlockPropertiesEXTBuilder {
    type Target = PhysicalDeviceInlineUniformBlockPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceInvocationMaskFeaturesHUAWEI {
    type Target = PhysicalDeviceInvocationMaskFeaturesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceInvocationMaskFeaturesHUAWEI {
    type Builder = PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder;
}

/// A builder for a [`PhysicalDeviceInvocationMaskFeaturesHUAWEI`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder {
    value: PhysicalDeviceInvocationMaskFeaturesHUAWEI,
}

impl PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder {
    #[inline]
    pub fn invocation_mask(mut self, invocation_mask: bool) -> Self {
        self.value.invocation_mask = invocation_mask as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceInvocationMaskFeaturesHUAWEI {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder {
    type Target = PhysicalDeviceInvocationMaskFeaturesHUAWEI;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceInvocationMaskFeaturesHUAWEIBuilder {
    type Target = PhysicalDeviceInvocationMaskFeaturesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceLimits {
    type Target = PhysicalDeviceLimits;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceLimits {
    type Builder = PhysicalDeviceLimitsBuilder;
}

/// A builder for a [`PhysicalDeviceLimits`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceLimitsBuilder {
    value: PhysicalDeviceLimits,
}

impl PhysicalDeviceLimitsBuilder {
    #[inline]
    pub fn max_image_dimension_1d(mut self, max_image_dimension_1d: u32) -> Self {
        self.value.max_image_dimension_1d = max_image_dimension_1d;
        self
    }

    #[inline]
    pub fn max_image_dimension_2d(mut self, max_image_dimension_2d: u32) -> Self {
        self.value.max_image_dimension_2d = max_image_dimension_2d;
        self
    }

    #[inline]
    pub fn max_image_dimension_3d(mut self, max_image_dimension_3d: u32) -> Self {
        self.value.max_image_dimension_3d = max_image_dimension_3d;
        self
    }

    #[inline]
    pub fn max_image_dimension_cube(mut self, max_image_dimension_cube: u32) -> Self {
        self.value.max_image_dimension_cube = max_image_dimension_cube;
        self
    }

    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.value.max_image_array_layers = max_image_array_layers;
        self
    }

    #[inline]
    pub fn max_texel_buffer_elements(mut self, max_texel_buffer_elements: u32) -> Self {
        self.value.max_texel_buffer_elements = max_texel_buffer_elements;
        self
    }

    #[inline]
    pub fn max_uniform_buffer_range(mut self, max_uniform_buffer_range: u32) -> Self {
        self.value.max_uniform_buffer_range = max_uniform_buffer_range;
        self
    }

    #[inline]
    pub fn max_storage_buffer_range(mut self, max_storage_buffer_range: u32) -> Self {
        self.value.max_storage_buffer_range = max_storage_buffer_range;
        self
    }

    #[inline]
    pub fn max_push_constants_size(mut self, max_push_constants_size: u32) -> Self {
        self.value.max_push_constants_size = max_push_constants_size;
        self
    }

    #[inline]
    pub fn max_memory_allocation_count(mut self, max_memory_allocation_count: u32) -> Self {
        self.value.max_memory_allocation_count = max_memory_allocation_count;
        self
    }

    #[inline]
    pub fn max_sampler_allocation_count(mut self, max_sampler_allocation_count: u32) -> Self {
        self.value.max_sampler_allocation_count = max_sampler_allocation_count;
        self
    }

    #[inline]
    pub fn buffer_image_granularity(mut self, buffer_image_granularity: DeviceSize) -> Self {
        self.value.buffer_image_granularity = buffer_image_granularity;
        self
    }

    #[inline]
    pub fn sparse_address_space_size(mut self, sparse_address_space_size: DeviceSize) -> Self {
        self.value.sparse_address_space_size = sparse_address_space_size;
        self
    }

    #[inline]
    pub fn max_bound_descriptor_sets(mut self, max_bound_descriptor_sets: u32) -> Self {
        self.value.max_bound_descriptor_sets = max_bound_descriptor_sets;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_samplers(
        mut self,
        max_per_stage_descriptor_samplers: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_samplers = max_per_stage_descriptor_samplers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_uniform_buffers(
        mut self,
        max_per_stage_descriptor_uniform_buffers: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_uniform_buffers =
            max_per_stage_descriptor_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_storage_buffers(
        mut self,
        max_per_stage_descriptor_storage_buffers: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_storage_buffers =
            max_per_stage_descriptor_storage_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_sampled_images(
        mut self,
        max_per_stage_descriptor_sampled_images: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_sampled_images =
            max_per_stage_descriptor_sampled_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_storage_images(
        mut self,
        max_per_stage_descriptor_storage_images: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_storage_images =
            max_per_stage_descriptor_storage_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_input_attachments(
        mut self,
        max_per_stage_descriptor_input_attachments: u32,
    ) -> Self {
        self.value.max_per_stage_descriptor_input_attachments =
            max_per_stage_descriptor_input_attachments;
        self
    }

    #[inline]
    pub fn max_per_stage_resources(mut self, max_per_stage_resources: u32) -> Self {
        self.value.max_per_stage_resources = max_per_stage_resources;
        self
    }

    #[inline]
    pub fn max_descriptor_set_samplers(mut self, max_descriptor_set_samplers: u32) -> Self {
        self.value.max_descriptor_set_samplers = max_descriptor_set_samplers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_uniform_buffers(
        mut self,
        max_descriptor_set_uniform_buffers: u32,
    ) -> Self {
        self.value.max_descriptor_set_uniform_buffers = max_descriptor_set_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.value.max_descriptor_set_uniform_buffers_dynamic =
            max_descriptor_set_uniform_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_storage_buffers(
        mut self,
        max_descriptor_set_storage_buffers: u32,
    ) -> Self {
        self.value.max_descriptor_set_storage_buffers = max_descriptor_set_storage_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_storage_buffers_dynamic: u32,
    ) -> Self {
        self.value.max_descriptor_set_storage_buffers_dynamic =
            max_descriptor_set_storage_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_sampled_images(
        mut self,
        max_descriptor_set_sampled_images: u32,
    ) -> Self {
        self.value.max_descriptor_set_sampled_images = max_descriptor_set_sampled_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_storage_images(
        mut self,
        max_descriptor_set_storage_images: u32,
    ) -> Self {
        self.value.max_descriptor_set_storage_images = max_descriptor_set_storage_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_input_attachments(
        mut self,
        max_descriptor_set_input_attachments: u32,
    ) -> Self {
        self.value.max_descriptor_set_input_attachments = max_descriptor_set_input_attachments;
        self
    }

    #[inline]
    pub fn max_vertex_input_attributes(mut self, max_vertex_input_attributes: u32) -> Self {
        self.value.max_vertex_input_attributes = max_vertex_input_attributes;
        self
    }

    #[inline]
    pub fn max_vertex_input_bindings(mut self, max_vertex_input_bindings: u32) -> Self {
        self.value.max_vertex_input_bindings = max_vertex_input_bindings;
        self
    }

    #[inline]
    pub fn max_vertex_input_attribute_offset(
        mut self,
        max_vertex_input_attribute_offset: u32,
    ) -> Self {
        self.value.max_vertex_input_attribute_offset = max_vertex_input_attribute_offset;
        self
    }

    #[inline]
    pub fn max_vertex_input_binding_stride(mut self, max_vertex_input_binding_stride: u32) -> Self {
        self.value.max_vertex_input_binding_stride = max_vertex_input_binding_stride;
        self
    }

    #[inline]
    pub fn max_vertex_output_components(mut self, max_vertex_output_components: u32) -> Self {
        self.value.max_vertex_output_components = max_vertex_output_components;
        self
    }

    #[inline]
    pub fn max_tessellation_generation_level(
        mut self,
        max_tessellation_generation_level: u32,
    ) -> Self {
        self.value.max_tessellation_generation_level = max_tessellation_generation_level;
        self
    }

    #[inline]
    pub fn max_tessellation_patch_size(mut self, max_tessellation_patch_size: u32) -> Self {
        self.value.max_tessellation_patch_size = max_tessellation_patch_size;
        self
    }

    #[inline]
    pub fn max_tessellation_control_per_vertex_input_components(
        mut self,
        max_tessellation_control_per_vertex_input_components: u32,
    ) -> Self {
        self.value
            .max_tessellation_control_per_vertex_input_components =
            max_tessellation_control_per_vertex_input_components;
        self
    }

    #[inline]
    pub fn max_tessellation_control_per_vertex_output_components(
        mut self,
        max_tessellation_control_per_vertex_output_components: u32,
    ) -> Self {
        self.value
            .max_tessellation_control_per_vertex_output_components =
            max_tessellation_control_per_vertex_output_components;
        self
    }

    #[inline]
    pub fn max_tessellation_control_per_patch_output_components(
        mut self,
        max_tessellation_control_per_patch_output_components: u32,
    ) -> Self {
        self.value
            .max_tessellation_control_per_patch_output_components =
            max_tessellation_control_per_patch_output_components;
        self
    }

    #[inline]
    pub fn max_tessellation_control_total_output_components(
        mut self,
        max_tessellation_control_total_output_components: u32,
    ) -> Self {
        self.value.max_tessellation_control_total_output_components =
            max_tessellation_control_total_output_components;
        self
    }

    #[inline]
    pub fn max_tessellation_evaluation_input_components(
        mut self,
        max_tessellation_evaluation_input_components: u32,
    ) -> Self {
        self.value.max_tessellation_evaluation_input_components =
            max_tessellation_evaluation_input_components;
        self
    }

    #[inline]
    pub fn max_tessellation_evaluation_output_components(
        mut self,
        max_tessellation_evaluation_output_components: u32,
    ) -> Self {
        self.value.max_tessellation_evaluation_output_components =
            max_tessellation_evaluation_output_components;
        self
    }

    #[inline]
    pub fn max_geometry_shader_invocations(mut self, max_geometry_shader_invocations: u32) -> Self {
        self.value.max_geometry_shader_invocations = max_geometry_shader_invocations;
        self
    }

    #[inline]
    pub fn max_geometry_input_components(mut self, max_geometry_input_components: u32) -> Self {
        self.value.max_geometry_input_components = max_geometry_input_components;
        self
    }

    #[inline]
    pub fn max_geometry_output_components(mut self, max_geometry_output_components: u32) -> Self {
        self.value.max_geometry_output_components = max_geometry_output_components;
        self
    }

    #[inline]
    pub fn max_geometry_output_vertices(mut self, max_geometry_output_vertices: u32) -> Self {
        self.value.max_geometry_output_vertices = max_geometry_output_vertices;
        self
    }

    #[inline]
    pub fn max_geometry_total_output_components(
        mut self,
        max_geometry_total_output_components: u32,
    ) -> Self {
        self.value.max_geometry_total_output_components = max_geometry_total_output_components;
        self
    }

    #[inline]
    pub fn max_fragment_input_components(mut self, max_fragment_input_components: u32) -> Self {
        self.value.max_fragment_input_components = max_fragment_input_components;
        self
    }

    #[inline]
    pub fn max_fragment_output_attachments(mut self, max_fragment_output_attachments: u32) -> Self {
        self.value.max_fragment_output_attachments = max_fragment_output_attachments;
        self
    }

    #[inline]
    pub fn max_fragment_dual_src_attachments(
        mut self,
        max_fragment_dual_src_attachments: u32,
    ) -> Self {
        self.value.max_fragment_dual_src_attachments = max_fragment_dual_src_attachments;
        self
    }

    #[inline]
    pub fn max_fragment_combined_output_resources(
        mut self,
        max_fragment_combined_output_resources: u32,
    ) -> Self {
        self.value.max_fragment_combined_output_resources = max_fragment_combined_output_resources;
        self
    }

    #[inline]
    pub fn max_compute_shared_memory_size(mut self, max_compute_shared_memory_size: u32) -> Self {
        self.value.max_compute_shared_memory_size = max_compute_shared_memory_size;
        self
    }

    #[inline]
    pub fn max_compute_work_group_count(mut self, max_compute_work_group_count: [u32; 3]) -> Self {
        self.value.max_compute_work_group_count = max_compute_work_group_count;
        self
    }

    #[inline]
    pub fn max_compute_work_group_invocations(
        mut self,
        max_compute_work_group_invocations: u32,
    ) -> Self {
        self.value.max_compute_work_group_invocations = max_compute_work_group_invocations;
        self
    }

    #[inline]
    pub fn max_compute_work_group_size(mut self, max_compute_work_group_size: [u32; 3]) -> Self {
        self.value.max_compute_work_group_size = max_compute_work_group_size;
        self
    }

    #[inline]
    pub fn sub_pixel_precision_bits(mut self, sub_pixel_precision_bits: u32) -> Self {
        self.value.sub_pixel_precision_bits = sub_pixel_precision_bits;
        self
    }

    #[inline]
    pub fn sub_texel_precision_bits(mut self, sub_texel_precision_bits: u32) -> Self {
        self.value.sub_texel_precision_bits = sub_texel_precision_bits;
        self
    }

    #[inline]
    pub fn mipmap_precision_bits(mut self, mipmap_precision_bits: u32) -> Self {
        self.value.mipmap_precision_bits = mipmap_precision_bits;
        self
    }

    #[inline]
    pub fn max_draw_indexed_index_value(mut self, max_draw_indexed_index_value: u32) -> Self {
        self.value.max_draw_indexed_index_value = max_draw_indexed_index_value;
        self
    }

    #[inline]
    pub fn max_draw_indirect_count(mut self, max_draw_indirect_count: u32) -> Self {
        self.value.max_draw_indirect_count = max_draw_indirect_count;
        self
    }

    #[inline]
    pub fn max_sampler_lod_bias(mut self, max_sampler_lod_bias: f32) -> Self {
        self.value.max_sampler_lod_bias = max_sampler_lod_bias;
        self
    }

    #[inline]
    pub fn max_sampler_anisotropy(mut self, max_sampler_anisotropy: f32) -> Self {
        self.value.max_sampler_anisotropy = max_sampler_anisotropy;
        self
    }

    #[inline]
    pub fn max_viewports(mut self, max_viewports: u32) -> Self {
        self.value.max_viewports = max_viewports;
        self
    }

    #[inline]
    pub fn max_viewport_dimensions(mut self, max_viewport_dimensions: [u32; 2]) -> Self {
        self.value.max_viewport_dimensions = max_viewport_dimensions;
        self
    }

    #[inline]
    pub fn viewport_bounds_range(mut self, viewport_bounds_range: [f32; 2]) -> Self {
        self.value.viewport_bounds_range = viewport_bounds_range;
        self
    }

    #[inline]
    pub fn viewport_sub_pixel_bits(mut self, viewport_sub_pixel_bits: u32) -> Self {
        self.value.viewport_sub_pixel_bits = viewport_sub_pixel_bits;
        self
    }

    #[inline]
    pub fn min_memory_map_alignment(mut self, min_memory_map_alignment: usize) -> Self {
        self.value.min_memory_map_alignment = min_memory_map_alignment;
        self
    }

    #[inline]
    pub fn min_texel_buffer_offset_alignment(
        mut self,
        min_texel_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.value.min_texel_buffer_offset_alignment = min_texel_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn min_uniform_buffer_offset_alignment(
        mut self,
        min_uniform_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.value.min_uniform_buffer_offset_alignment = min_uniform_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn min_storage_buffer_offset_alignment(
        mut self,
        min_storage_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.value.min_storage_buffer_offset_alignment = min_storage_buffer_offset_alignment;
        self
    }

    #[inline]
    pub fn min_texel_offset(mut self, min_texel_offset: i32) -> Self {
        self.value.min_texel_offset = min_texel_offset;
        self
    }

    #[inline]
    pub fn max_texel_offset(mut self, max_texel_offset: u32) -> Self {
        self.value.max_texel_offset = max_texel_offset;
        self
    }

    #[inline]
    pub fn min_texel_gather_offset(mut self, min_texel_gather_offset: i32) -> Self {
        self.value.min_texel_gather_offset = min_texel_gather_offset;
        self
    }

    #[inline]
    pub fn max_texel_gather_offset(mut self, max_texel_gather_offset: u32) -> Self {
        self.value.max_texel_gather_offset = max_texel_gather_offset;
        self
    }

    #[inline]
    pub fn min_interpolation_offset(mut self, min_interpolation_offset: f32) -> Self {
        self.value.min_interpolation_offset = min_interpolation_offset;
        self
    }

    #[inline]
    pub fn max_interpolation_offset(mut self, max_interpolation_offset: f32) -> Self {
        self.value.max_interpolation_offset = max_interpolation_offset;
        self
    }

    #[inline]
    pub fn sub_pixel_interpolation_offset_bits(
        mut self,
        sub_pixel_interpolation_offset_bits: u32,
    ) -> Self {
        self.value.sub_pixel_interpolation_offset_bits = sub_pixel_interpolation_offset_bits;
        self
    }

    #[inline]
    pub fn max_framebuffer_width(mut self, max_framebuffer_width: u32) -> Self {
        self.value.max_framebuffer_width = max_framebuffer_width;
        self
    }

    #[inline]
    pub fn max_framebuffer_height(mut self, max_framebuffer_height: u32) -> Self {
        self.value.max_framebuffer_height = max_framebuffer_height;
        self
    }

    #[inline]
    pub fn max_framebuffer_layers(mut self, max_framebuffer_layers: u32) -> Self {
        self.value.max_framebuffer_layers = max_framebuffer_layers;
        self
    }

    #[inline]
    pub fn framebuffer_color_sample_counts(
        mut self,
        framebuffer_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.framebuffer_color_sample_counts = framebuffer_color_sample_counts;
        self
    }

    #[inline]
    pub fn framebuffer_depth_sample_counts(
        mut self,
        framebuffer_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.framebuffer_depth_sample_counts = framebuffer_depth_sample_counts;
        self
    }

    #[inline]
    pub fn framebuffer_stencil_sample_counts(
        mut self,
        framebuffer_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.framebuffer_stencil_sample_counts = framebuffer_stencil_sample_counts;
        self
    }

    #[inline]
    pub fn framebuffer_no_attachments_sample_counts(
        mut self,
        framebuffer_no_attachments_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.framebuffer_no_attachments_sample_counts =
            framebuffer_no_attachments_sample_counts;
        self
    }

    #[inline]
    pub fn max_color_attachments(mut self, max_color_attachments: u32) -> Self {
        self.value.max_color_attachments = max_color_attachments;
        self
    }

    #[inline]
    pub fn sampled_image_color_sample_counts(
        mut self,
        sampled_image_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.sampled_image_color_sample_counts = sampled_image_color_sample_counts;
        self
    }

    #[inline]
    pub fn sampled_image_integer_sample_counts(
        mut self,
        sampled_image_integer_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.sampled_image_integer_sample_counts = sampled_image_integer_sample_counts;
        self
    }

    #[inline]
    pub fn sampled_image_depth_sample_counts(
        mut self,
        sampled_image_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.sampled_image_depth_sample_counts = sampled_image_depth_sample_counts;
        self
    }

    #[inline]
    pub fn sampled_image_stencil_sample_counts(
        mut self,
        sampled_image_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.sampled_image_stencil_sample_counts = sampled_image_stencil_sample_counts;
        self
    }

    #[inline]
    pub fn storage_image_sample_counts(
        mut self,
        storage_image_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.storage_image_sample_counts = storage_image_sample_counts;
        self
    }

    #[inline]
    pub fn max_sample_mask_words(mut self, max_sample_mask_words: u32) -> Self {
        self.value.max_sample_mask_words = max_sample_mask_words;
        self
    }

    #[inline]
    pub fn timestamp_compute_and_graphics(mut self, timestamp_compute_and_graphics: bool) -> Self {
        self.value.timestamp_compute_and_graphics = timestamp_compute_and_graphics as Bool32;
        self
    }

    #[inline]
    pub fn timestamp_period(mut self, timestamp_period: f32) -> Self {
        self.value.timestamp_period = timestamp_period;
        self
    }

    #[inline]
    pub fn max_clip_distances(mut self, max_clip_distances: u32) -> Self {
        self.value.max_clip_distances = max_clip_distances;
        self
    }

    #[inline]
    pub fn max_cull_distances(mut self, max_cull_distances: u32) -> Self {
        self.value.max_cull_distances = max_cull_distances;
        self
    }

    #[inline]
    pub fn max_combined_clip_and_cull_distances(
        mut self,
        max_combined_clip_and_cull_distances: u32,
    ) -> Self {
        self.value.max_combined_clip_and_cull_distances = max_combined_clip_and_cull_distances;
        self
    }

    #[inline]
    pub fn discrete_queue_priorities(mut self, discrete_queue_priorities: u32) -> Self {
        self.value.discrete_queue_priorities = discrete_queue_priorities;
        self
    }

    #[inline]
    pub fn point_size_range(mut self, point_size_range: [f32; 2]) -> Self {
        self.value.point_size_range = point_size_range;
        self
    }

    #[inline]
    pub fn line_width_range(mut self, line_width_range: [f32; 2]) -> Self {
        self.value.line_width_range = line_width_range;
        self
    }

    #[inline]
    pub fn point_size_granularity(mut self, point_size_granularity: f32) -> Self {
        self.value.point_size_granularity = point_size_granularity;
        self
    }

    #[inline]
    pub fn line_width_granularity(mut self, line_width_granularity: f32) -> Self {
        self.value.line_width_granularity = line_width_granularity;
        self
    }

    #[inline]
    pub fn strict_lines(mut self, strict_lines: bool) -> Self {
        self.value.strict_lines = strict_lines as Bool32;
        self
    }

    #[inline]
    pub fn standard_sample_locations(mut self, standard_sample_locations: bool) -> Self {
        self.value.standard_sample_locations = standard_sample_locations as Bool32;
        self
    }

    #[inline]
    pub fn optimal_buffer_copy_offset_alignment(
        mut self,
        optimal_buffer_copy_offset_alignment: DeviceSize,
    ) -> Self {
        self.value.optimal_buffer_copy_offset_alignment = optimal_buffer_copy_offset_alignment;
        self
    }

    #[inline]
    pub fn optimal_buffer_copy_row_pitch_alignment(
        mut self,
        optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    ) -> Self {
        self.value.optimal_buffer_copy_row_pitch_alignment =
            optimal_buffer_copy_row_pitch_alignment;
        self
    }

    #[inline]
    pub fn non_coherent_atom_size(mut self, non_coherent_atom_size: DeviceSize) -> Self {
        self.value.non_coherent_atom_size = non_coherent_atom_size;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceLimits {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceLimitsBuilder {
    type Target = PhysicalDeviceLimits;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceLimitsBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceLimitsBuilder {
    type Target = PhysicalDeviceLimits;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceLineRasterizationFeaturesEXT {
    type Target = PhysicalDeviceLineRasterizationFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceLineRasterizationFeaturesEXT {
    type Builder = PhysicalDeviceLineRasterizationFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceLineRasterizationFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceLineRasterizationFeaturesEXTBuilder {
    value: PhysicalDeviceLineRasterizationFeaturesEXT,
}

impl PhysicalDeviceLineRasterizationFeaturesEXTBuilder {
    #[inline]
    pub fn rectangular_lines(mut self, rectangular_lines: bool) -> Self {
        self.value.rectangular_lines = rectangular_lines as Bool32;
        self
    }

    #[inline]
    pub fn bresenham_lines(mut self, bresenham_lines: bool) -> Self {
        self.value.bresenham_lines = bresenham_lines as Bool32;
        self
    }

    #[inline]
    pub fn smooth_lines(mut self, smooth_lines: bool) -> Self {
        self.value.smooth_lines = smooth_lines as Bool32;
        self
    }

    #[inline]
    pub fn stippled_rectangular_lines(mut self, stippled_rectangular_lines: bool) -> Self {
        self.value.stippled_rectangular_lines = stippled_rectangular_lines as Bool32;
        self
    }

    #[inline]
    pub fn stippled_bresenham_lines(mut self, stippled_bresenham_lines: bool) -> Self {
        self.value.stippled_bresenham_lines = stippled_bresenham_lines as Bool32;
        self
    }

    #[inline]
    pub fn stippled_smooth_lines(mut self, stippled_smooth_lines: bool) -> Self {
        self.value.stippled_smooth_lines = stippled_smooth_lines as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceLineRasterizationFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceLineRasterizationFeaturesEXTBuilder {
    type Target = PhysicalDeviceLineRasterizationFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceLineRasterizationFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceLineRasterizationFeaturesEXTBuilder {
    type Target = PhysicalDeviceLineRasterizationFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceLineRasterizationPropertiesEXT {
    type Target = PhysicalDeviceLineRasterizationPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceLineRasterizationPropertiesEXT {
    type Builder = PhysicalDeviceLineRasterizationPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceLineRasterizationPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceLineRasterizationPropertiesEXTBuilder {
    value: PhysicalDeviceLineRasterizationPropertiesEXT,
}

impl PhysicalDeviceLineRasterizationPropertiesEXTBuilder {
    #[inline]
    pub fn line_sub_pixel_precision_bits(mut self, line_sub_pixel_precision_bits: u32) -> Self {
        self.value.line_sub_pixel_precision_bits = line_sub_pixel_precision_bits;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceLineRasterizationPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceLineRasterizationPropertiesEXTBuilder {
    type Target = PhysicalDeviceLineRasterizationPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceLineRasterizationPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceLineRasterizationPropertiesEXTBuilder {
    type Target = PhysicalDeviceLineRasterizationPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMaintenance3Properties {
    type Target = PhysicalDeviceMaintenance3Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMaintenance3Properties {
    type Builder = PhysicalDeviceMaintenance3PropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceMaintenance3Properties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMaintenance3PropertiesBuilder {
    value: PhysicalDeviceMaintenance3Properties,
}

impl PhysicalDeviceMaintenance3PropertiesBuilder {
    #[inline]
    pub fn max_per_set_descriptors(mut self, max_per_set_descriptors: u32) -> Self {
        self.value.max_per_set_descriptors = max_per_set_descriptors;
        self
    }

    #[inline]
    pub fn max_memory_allocation_size(mut self, max_memory_allocation_size: DeviceSize) -> Self {
        self.value.max_memory_allocation_size = max_memory_allocation_size;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMaintenance3Properties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMaintenance3PropertiesBuilder {
    type Target = PhysicalDeviceMaintenance3Properties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMaintenance3PropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMaintenance3PropertiesBuilder {
    type Target = PhysicalDeviceMaintenance3Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryBudgetPropertiesEXT {
    type Target = PhysicalDeviceMemoryBudgetPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMemoryBudgetPropertiesEXT {
    type Builder = PhysicalDeviceMemoryBudgetPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceMemoryBudgetPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMemoryBudgetPropertiesEXTBuilder {
    value: PhysicalDeviceMemoryBudgetPropertiesEXT,
}

impl PhysicalDeviceMemoryBudgetPropertiesEXTBuilder {
    #[inline]
    pub fn heap_budget(mut self, heap_budget: [DeviceSize; MAX_MEMORY_HEAPS]) -> Self {
        self.value.heap_budget = heap_budget;
        self
    }

    #[inline]
    pub fn heap_usage(mut self, heap_usage: [DeviceSize; MAX_MEMORY_HEAPS]) -> Self {
        self.value.heap_usage = heap_usage;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMemoryBudgetPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMemoryBudgetPropertiesEXTBuilder {
    type Target = PhysicalDeviceMemoryBudgetPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMemoryBudgetPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryBudgetPropertiesEXTBuilder {
    type Target = PhysicalDeviceMemoryBudgetPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryPriorityFeaturesEXT {
    type Target = PhysicalDeviceMemoryPriorityFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMemoryPriorityFeaturesEXT {
    type Builder = PhysicalDeviceMemoryPriorityFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceMemoryPriorityFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMemoryPriorityFeaturesEXTBuilder {
    value: PhysicalDeviceMemoryPriorityFeaturesEXT,
}

impl PhysicalDeviceMemoryPriorityFeaturesEXTBuilder {
    #[inline]
    pub fn memory_priority(mut self, memory_priority: bool) -> Self {
        self.value.memory_priority = memory_priority as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMemoryPriorityFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMemoryPriorityFeaturesEXTBuilder {
    type Target = PhysicalDeviceMemoryPriorityFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMemoryPriorityFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryPriorityFeaturesEXTBuilder {
    type Target = PhysicalDeviceMemoryPriorityFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryProperties {
    type Target = PhysicalDeviceMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMemoryProperties {
    type Builder = PhysicalDeviceMemoryPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceMemoryProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMemoryPropertiesBuilder {
    value: PhysicalDeviceMemoryProperties,
}

impl PhysicalDeviceMemoryPropertiesBuilder {
    #[inline]
    pub fn memory_type_count(mut self, memory_type_count: u32) -> Self {
        self.value.memory_type_count = memory_type_count;
        self
    }

    #[inline]
    pub fn memory_types(mut self, memory_types: [MemoryType; MAX_MEMORY_TYPES]) -> Self {
        self.value.memory_types = memory_types;
        self
    }

    #[inline]
    pub fn memory_heap_count(mut self, memory_heap_count: u32) -> Self {
        self.value.memory_heap_count = memory_heap_count;
        self
    }

    #[inline]
    pub fn memory_heaps(mut self, memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS]) -> Self {
        self.value.memory_heaps = memory_heaps;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMemoryProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMemoryPropertiesBuilder {
    type Target = PhysicalDeviceMemoryProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMemoryPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMemoryPropertiesBuilder {
    type Target = PhysicalDeviceMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceMemoryProperties2`].
pub unsafe trait ExtendsPhysicalDeviceMemoryProperties2: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceMemoryProperties2 for PhysicalDeviceMemoryBudgetPropertiesEXT {}

unsafe impl Cast for PhysicalDeviceMemoryProperties2 {
    type Target = PhysicalDeviceMemoryProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceMemoryProperties2 {
    type Builder = PhysicalDeviceMemoryProperties2Builder<'b>;
}

/// A builder for a [`PhysicalDeviceMemoryProperties2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMemoryProperties2Builder<'b> {
    value: PhysicalDeviceMemoryProperties2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceMemoryProperties2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceMemoryProperties2,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceMemoryProperties2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn memory_properties(
        mut self,
        memory_properties: impl Cast<Target = PhysicalDeviceMemoryProperties>,
    ) -> Self {
        self.value.memory_properties = memory_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMemoryProperties2 {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceMemoryProperties2Builder<'b> {
    type Target = PhysicalDeviceMemoryProperties2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceMemoryProperties2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceMemoryProperties2Builder<'b> {
    type Target = PhysicalDeviceMemoryProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMeshShaderFeaturesNV {
    type Target = PhysicalDeviceMeshShaderFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMeshShaderFeaturesNV {
    type Builder = PhysicalDeviceMeshShaderFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceMeshShaderFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMeshShaderFeaturesNVBuilder {
    value: PhysicalDeviceMeshShaderFeaturesNV,
}

impl PhysicalDeviceMeshShaderFeaturesNVBuilder {
    #[inline]
    pub fn task_shader(mut self, task_shader: bool) -> Self {
        self.value.task_shader = task_shader as Bool32;
        self
    }

    #[inline]
    pub fn mesh_shader(mut self, mesh_shader: bool) -> Self {
        self.value.mesh_shader = mesh_shader as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMeshShaderFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMeshShaderFeaturesNVBuilder {
    type Target = PhysicalDeviceMeshShaderFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMeshShaderFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMeshShaderFeaturesNVBuilder {
    type Target = PhysicalDeviceMeshShaderFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMeshShaderPropertiesNV {
    type Target = PhysicalDeviceMeshShaderPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMeshShaderPropertiesNV {
    type Builder = PhysicalDeviceMeshShaderPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceMeshShaderPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMeshShaderPropertiesNVBuilder {
    value: PhysicalDeviceMeshShaderPropertiesNV,
}

impl PhysicalDeviceMeshShaderPropertiesNVBuilder {
    #[inline]
    pub fn max_draw_mesh_tasks_count(mut self, max_draw_mesh_tasks_count: u32) -> Self {
        self.value.max_draw_mesh_tasks_count = max_draw_mesh_tasks_count;
        self
    }

    #[inline]
    pub fn max_task_work_group_invocations(mut self, max_task_work_group_invocations: u32) -> Self {
        self.value.max_task_work_group_invocations = max_task_work_group_invocations;
        self
    }

    #[inline]
    pub fn max_task_work_group_size(mut self, max_task_work_group_size: [u32; 3]) -> Self {
        self.value.max_task_work_group_size = max_task_work_group_size;
        self
    }

    #[inline]
    pub fn max_task_total_memory_size(mut self, max_task_total_memory_size: u32) -> Self {
        self.value.max_task_total_memory_size = max_task_total_memory_size;
        self
    }

    #[inline]
    pub fn max_task_output_count(mut self, max_task_output_count: u32) -> Self {
        self.value.max_task_output_count = max_task_output_count;
        self
    }

    #[inline]
    pub fn max_mesh_work_group_invocations(mut self, max_mesh_work_group_invocations: u32) -> Self {
        self.value.max_mesh_work_group_invocations = max_mesh_work_group_invocations;
        self
    }

    #[inline]
    pub fn max_mesh_work_group_size(mut self, max_mesh_work_group_size: [u32; 3]) -> Self {
        self.value.max_mesh_work_group_size = max_mesh_work_group_size;
        self
    }

    #[inline]
    pub fn max_mesh_total_memory_size(mut self, max_mesh_total_memory_size: u32) -> Self {
        self.value.max_mesh_total_memory_size = max_mesh_total_memory_size;
        self
    }

    #[inline]
    pub fn max_mesh_output_vertices(mut self, max_mesh_output_vertices: u32) -> Self {
        self.value.max_mesh_output_vertices = max_mesh_output_vertices;
        self
    }

    #[inline]
    pub fn max_mesh_output_primitives(mut self, max_mesh_output_primitives: u32) -> Self {
        self.value.max_mesh_output_primitives = max_mesh_output_primitives;
        self
    }

    #[inline]
    pub fn max_mesh_multiview_view_count(mut self, max_mesh_multiview_view_count: u32) -> Self {
        self.value.max_mesh_multiview_view_count = max_mesh_multiview_view_count;
        self
    }

    #[inline]
    pub fn mesh_output_per_vertex_granularity(
        mut self,
        mesh_output_per_vertex_granularity: u32,
    ) -> Self {
        self.value.mesh_output_per_vertex_granularity = mesh_output_per_vertex_granularity;
        self
    }

    #[inline]
    pub fn mesh_output_per_primitive_granularity(
        mut self,
        mesh_output_per_primitive_granularity: u32,
    ) -> Self {
        self.value.mesh_output_per_primitive_granularity = mesh_output_per_primitive_granularity;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMeshShaderPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMeshShaderPropertiesNVBuilder {
    type Target = PhysicalDeviceMeshShaderPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMeshShaderPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMeshShaderPropertiesNVBuilder {
    type Target = PhysicalDeviceMeshShaderPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiDrawFeaturesEXT {
    type Target = PhysicalDeviceMultiDrawFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMultiDrawFeaturesEXT {
    type Builder = PhysicalDeviceMultiDrawFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceMultiDrawFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMultiDrawFeaturesEXTBuilder {
    value: PhysicalDeviceMultiDrawFeaturesEXT,
}

impl PhysicalDeviceMultiDrawFeaturesEXTBuilder {
    #[inline]
    pub fn multi_draw(mut self, multi_draw: bool) -> Self {
        self.value.multi_draw = multi_draw as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMultiDrawFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMultiDrawFeaturesEXTBuilder {
    type Target = PhysicalDeviceMultiDrawFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMultiDrawFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiDrawFeaturesEXTBuilder {
    type Target = PhysicalDeviceMultiDrawFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiDrawPropertiesEXT {
    type Target = PhysicalDeviceMultiDrawPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMultiDrawPropertiesEXT {
    type Builder = PhysicalDeviceMultiDrawPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceMultiDrawPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMultiDrawPropertiesEXTBuilder {
    value: PhysicalDeviceMultiDrawPropertiesEXT,
}

impl PhysicalDeviceMultiDrawPropertiesEXTBuilder {
    #[inline]
    pub fn max_multi_draw_count(mut self, max_multi_draw_count: u32) -> Self {
        self.value.max_multi_draw_count = max_multi_draw_count;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMultiDrawPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMultiDrawPropertiesEXTBuilder {
    type Target = PhysicalDeviceMultiDrawPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMultiDrawPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiDrawPropertiesEXTBuilder {
    type Target = PhysicalDeviceMultiDrawPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewFeatures {
    type Target = PhysicalDeviceMultiviewFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMultiviewFeatures {
    type Builder = PhysicalDeviceMultiviewFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceMultiviewFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMultiviewFeaturesBuilder {
    value: PhysicalDeviceMultiviewFeatures,
}

impl PhysicalDeviceMultiviewFeaturesBuilder {
    #[inline]
    pub fn multiview(mut self, multiview: bool) -> Self {
        self.value.multiview = multiview as Bool32;
        self
    }

    #[inline]
    pub fn multiview_geometry_shader(mut self, multiview_geometry_shader: bool) -> Self {
        self.value.multiview_geometry_shader = multiview_geometry_shader as Bool32;
        self
    }

    #[inline]
    pub fn multiview_tessellation_shader(mut self, multiview_tessellation_shader: bool) -> Self {
        self.value.multiview_tessellation_shader = multiview_tessellation_shader as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMultiviewFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMultiviewFeaturesBuilder {
    type Target = PhysicalDeviceMultiviewFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMultiviewFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewFeaturesBuilder {
    type Target = PhysicalDeviceMultiviewFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    type Target = PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    type Builder = PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder;
}

/// A builder for a [`PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
    value: PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX,
}

impl PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
    #[inline]
    pub fn per_view_position_all_components(
        mut self,
        per_view_position_all_components: bool,
    ) -> Self {
        self.value.per_view_position_all_components = per_view_position_all_components as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
    type Target = PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
    type Target = PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewProperties {
    type Target = PhysicalDeviceMultiviewProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMultiviewProperties {
    type Builder = PhysicalDeviceMultiviewPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceMultiviewProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMultiviewPropertiesBuilder {
    value: PhysicalDeviceMultiviewProperties,
}

impl PhysicalDeviceMultiviewPropertiesBuilder {
    #[inline]
    pub fn max_multiview_view_count(mut self, max_multiview_view_count: u32) -> Self {
        self.value.max_multiview_view_count = max_multiview_view_count;
        self
    }

    #[inline]
    pub fn max_multiview_instance_index(mut self, max_multiview_instance_index: u32) -> Self {
        self.value.max_multiview_instance_index = max_multiview_instance_index;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMultiviewProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMultiviewPropertiesBuilder {
    type Target = PhysicalDeviceMultiviewProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMultiviewPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMultiviewPropertiesBuilder {
    type Target = PhysicalDeviceMultiviewProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    type Target = PhysicalDeviceMutableDescriptorTypeFeaturesVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    type Builder = PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder;
}

/// A builder for a [`PhysicalDeviceMutableDescriptorTypeFeaturesVALVE`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder {
    value: PhysicalDeviceMutableDescriptorTypeFeaturesVALVE,
}

impl PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder {
    #[inline]
    pub fn mutable_descriptor_type(mut self, mutable_descriptor_type: bool) -> Self {
        self.value.mutable_descriptor_type = mutable_descriptor_type as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder {
    type Target = PhysicalDeviceMutableDescriptorTypeFeaturesVALVE;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceMutableDescriptorTypeFeaturesVALVEBuilder {
    type Target = PhysicalDeviceMutableDescriptorTypeFeaturesVALVE;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePCIBusInfoPropertiesEXT {
    type Target = PhysicalDevicePCIBusInfoPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePCIBusInfoPropertiesEXT {
    type Builder = PhysicalDevicePCIBusInfoPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDevicePCIBusInfoPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePCIBusInfoPropertiesEXTBuilder {
    value: PhysicalDevicePCIBusInfoPropertiesEXT,
}

impl PhysicalDevicePCIBusInfoPropertiesEXTBuilder {
    #[inline]
    pub fn pci_domain(mut self, pci_domain: u32) -> Self {
        self.value.pci_domain = pci_domain;
        self
    }

    #[inline]
    pub fn pci_bus(mut self, pci_bus: u32) -> Self {
        self.value.pci_bus = pci_bus;
        self
    }

    #[inline]
    pub fn pci_device(mut self, pci_device: u32) -> Self {
        self.value.pci_device = pci_device;
        self
    }

    #[inline]
    pub fn pci_function(mut self, pci_function: u32) -> Self {
        self.value.pci_function = pci_function;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePCIBusInfoPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePCIBusInfoPropertiesEXTBuilder {
    type Target = PhysicalDevicePCIBusInfoPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePCIBusInfoPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePCIBusInfoPropertiesEXTBuilder {
    type Target = PhysicalDevicePCIBusInfoPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePerformanceQueryFeaturesKHR {
    type Target = PhysicalDevicePerformanceQueryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePerformanceQueryFeaturesKHR {
    type Builder = PhysicalDevicePerformanceQueryFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePerformanceQueryFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePerformanceQueryFeaturesKHRBuilder {
    value: PhysicalDevicePerformanceQueryFeaturesKHR,
}

impl PhysicalDevicePerformanceQueryFeaturesKHRBuilder {
    #[inline]
    pub fn performance_counter_query_pools(
        mut self,
        performance_counter_query_pools: bool,
    ) -> Self {
        self.value.performance_counter_query_pools = performance_counter_query_pools as Bool32;
        self
    }

    #[inline]
    pub fn performance_counter_multiple_query_pools(
        mut self,
        performance_counter_multiple_query_pools: bool,
    ) -> Self {
        self.value.performance_counter_multiple_query_pools =
            performance_counter_multiple_query_pools as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePerformanceQueryFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePerformanceQueryFeaturesKHRBuilder {
    type Target = PhysicalDevicePerformanceQueryFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePerformanceQueryFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePerformanceQueryFeaturesKHRBuilder {
    type Target = PhysicalDevicePerformanceQueryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePerformanceQueryPropertiesKHR {
    type Target = PhysicalDevicePerformanceQueryPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePerformanceQueryPropertiesKHR {
    type Builder = PhysicalDevicePerformanceQueryPropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePerformanceQueryPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePerformanceQueryPropertiesKHRBuilder {
    value: PhysicalDevicePerformanceQueryPropertiesKHR,
}

impl PhysicalDevicePerformanceQueryPropertiesKHRBuilder {
    #[inline]
    pub fn allow_command_buffer_query_copies(
        mut self,
        allow_command_buffer_query_copies: bool,
    ) -> Self {
        self.value.allow_command_buffer_query_copies = allow_command_buffer_query_copies as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePerformanceQueryPropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePerformanceQueryPropertiesKHRBuilder {
    type Target = PhysicalDevicePerformanceQueryPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePerformanceQueryPropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePerformanceQueryPropertiesKHRBuilder {
    type Target = PhysicalDevicePerformanceQueryPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePipelineCreationCacheControlFeaturesEXT {
    type Target = PhysicalDevicePipelineCreationCacheControlFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePipelineCreationCacheControlFeaturesEXT {
    type Builder = PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDevicePipelineCreationCacheControlFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder {
    value: PhysicalDevicePipelineCreationCacheControlFeaturesEXT,
}

impl PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder {
    #[inline]
    pub fn pipeline_creation_cache_control(
        mut self,
        pipeline_creation_cache_control: bool,
    ) -> Self {
        self.value.pipeline_creation_cache_control = pipeline_creation_cache_control as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePipelineCreationCacheControlFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder {
    type Target = PhysicalDevicePipelineCreationCacheControlFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePipelineCreationCacheControlFeaturesEXTBuilder {
    type Target = PhysicalDevicePipelineCreationCacheControlFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    type Target = PhysicalDevicePipelineExecutablePropertiesFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    type Builder = PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePipelineExecutablePropertiesFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder {
    value: PhysicalDevicePipelineExecutablePropertiesFeaturesKHR,
}

impl PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder {
    #[inline]
    pub fn pipeline_executable_info(mut self, pipeline_executable_info: bool) -> Self {
        self.value.pipeline_executable_info = pipeline_executable_info as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder {
    type Target = PhysicalDevicePipelineExecutablePropertiesFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePipelineExecutablePropertiesFeaturesKHRBuilder {
    type Target = PhysicalDevicePipelineExecutablePropertiesFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePointClippingProperties {
    type Target = PhysicalDevicePointClippingProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePointClippingProperties {
    type Builder = PhysicalDevicePointClippingPropertiesBuilder;
}

/// A builder for a [`PhysicalDevicePointClippingProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePointClippingPropertiesBuilder {
    value: PhysicalDevicePointClippingProperties,
}

impl PhysicalDevicePointClippingPropertiesBuilder {
    #[inline]
    pub fn point_clipping_behavior(
        mut self,
        point_clipping_behavior: PointClippingBehavior,
    ) -> Self {
        self.value.point_clipping_behavior = point_clipping_behavior;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePointClippingProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePointClippingPropertiesBuilder {
    type Target = PhysicalDevicePointClippingProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePointClippingPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePointClippingPropertiesBuilder {
    type Target = PhysicalDevicePointClippingProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePortabilitySubsetFeaturesKHR {
    type Target = PhysicalDevicePortabilitySubsetFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePortabilitySubsetFeaturesKHR {
    type Builder = PhysicalDevicePortabilitySubsetFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePortabilitySubsetFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePortabilitySubsetFeaturesKHRBuilder {
    value: PhysicalDevicePortabilitySubsetFeaturesKHR,
}

impl PhysicalDevicePortabilitySubsetFeaturesKHRBuilder {
    #[inline]
    pub fn constant_alpha_color_blend_factors(
        mut self,
        constant_alpha_color_blend_factors: bool,
    ) -> Self {
        self.value.constant_alpha_color_blend_factors =
            constant_alpha_color_blend_factors as Bool32;
        self
    }

    #[inline]
    pub fn events(mut self, events: bool) -> Self {
        self.value.events = events as Bool32;
        self
    }

    #[inline]
    pub fn image_view_format_reinterpretation(
        mut self,
        image_view_format_reinterpretation: bool,
    ) -> Self {
        self.value.image_view_format_reinterpretation =
            image_view_format_reinterpretation as Bool32;
        self
    }

    #[inline]
    pub fn image_view_format_swizzle(mut self, image_view_format_swizzle: bool) -> Self {
        self.value.image_view_format_swizzle = image_view_format_swizzle as Bool32;
        self
    }

    #[inline]
    pub fn image_view_2d_on_3d_image(mut self, image_view_2d_on_3d_image: bool) -> Self {
        self.value.image_view_2d_on_3d_image = image_view_2d_on_3d_image as Bool32;
        self
    }

    #[inline]
    pub fn multisample_array_image(mut self, multisample_array_image: bool) -> Self {
        self.value.multisample_array_image = multisample_array_image as Bool32;
        self
    }

    #[inline]
    pub fn mutable_comparison_samplers(mut self, mutable_comparison_samplers: bool) -> Self {
        self.value.mutable_comparison_samplers = mutable_comparison_samplers as Bool32;
        self
    }

    #[inline]
    pub fn point_polygons(mut self, point_polygons: bool) -> Self {
        self.value.point_polygons = point_polygons as Bool32;
        self
    }

    #[inline]
    pub fn sampler_mip_lod_bias(mut self, sampler_mip_lod_bias: bool) -> Self {
        self.value.sampler_mip_lod_bias = sampler_mip_lod_bias as Bool32;
        self
    }

    #[inline]
    pub fn separate_stencil_mask_ref(mut self, separate_stencil_mask_ref: bool) -> Self {
        self.value.separate_stencil_mask_ref = separate_stencil_mask_ref as Bool32;
        self
    }

    #[inline]
    pub fn shader_sample_rate_interpolation_functions(
        mut self,
        shader_sample_rate_interpolation_functions: bool,
    ) -> Self {
        self.value.shader_sample_rate_interpolation_functions =
            shader_sample_rate_interpolation_functions as Bool32;
        self
    }

    #[inline]
    pub fn tessellation_isolines(mut self, tessellation_isolines: bool) -> Self {
        self.value.tessellation_isolines = tessellation_isolines as Bool32;
        self
    }

    #[inline]
    pub fn tessellation_point_mode(mut self, tessellation_point_mode: bool) -> Self {
        self.value.tessellation_point_mode = tessellation_point_mode as Bool32;
        self
    }

    #[inline]
    pub fn triangle_fans(mut self, triangle_fans: bool) -> Self {
        self.value.triangle_fans = triangle_fans as Bool32;
        self
    }

    #[inline]
    pub fn vertex_attribute_access_beyond_stride(
        mut self,
        vertex_attribute_access_beyond_stride: bool,
    ) -> Self {
        self.value.vertex_attribute_access_beyond_stride =
            vertex_attribute_access_beyond_stride as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePortabilitySubsetFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePortabilitySubsetFeaturesKHRBuilder {
    type Target = PhysicalDevicePortabilitySubsetFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePortabilitySubsetFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePortabilitySubsetFeaturesKHRBuilder {
    type Target = PhysicalDevicePortabilitySubsetFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePortabilitySubsetPropertiesKHR {
    type Target = PhysicalDevicePortabilitySubsetPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePortabilitySubsetPropertiesKHR {
    type Builder = PhysicalDevicePortabilitySubsetPropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePortabilitySubsetPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePortabilitySubsetPropertiesKHRBuilder {
    value: PhysicalDevicePortabilitySubsetPropertiesKHR,
}

impl PhysicalDevicePortabilitySubsetPropertiesKHRBuilder {
    #[inline]
    pub fn min_vertex_input_binding_stride_alignment(
        mut self,
        min_vertex_input_binding_stride_alignment: u32,
    ) -> Self {
        self.value.min_vertex_input_binding_stride_alignment =
            min_vertex_input_binding_stride_alignment;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePortabilitySubsetPropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePortabilitySubsetPropertiesKHRBuilder {
    type Target = PhysicalDevicePortabilitySubsetPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePortabilitySubsetPropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePortabilitySubsetPropertiesKHRBuilder {
    type Target = PhysicalDevicePortabilitySubsetPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePresentIdFeaturesKHR {
    type Target = PhysicalDevicePresentIdFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePresentIdFeaturesKHR {
    type Builder = PhysicalDevicePresentIdFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePresentIdFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePresentIdFeaturesKHRBuilder {
    value: PhysicalDevicePresentIdFeaturesKHR,
}

impl PhysicalDevicePresentIdFeaturesKHRBuilder {
    #[inline]
    pub fn present_id(mut self, present_id: bool) -> Self {
        self.value.present_id = present_id as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePresentIdFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePresentIdFeaturesKHRBuilder {
    type Target = PhysicalDevicePresentIdFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePresentIdFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePresentIdFeaturesKHRBuilder {
    type Target = PhysicalDevicePresentIdFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePresentWaitFeaturesKHR {
    type Target = PhysicalDevicePresentWaitFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePresentWaitFeaturesKHR {
    type Builder = PhysicalDevicePresentWaitFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePresentWaitFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePresentWaitFeaturesKHRBuilder {
    value: PhysicalDevicePresentWaitFeaturesKHR,
}

impl PhysicalDevicePresentWaitFeaturesKHRBuilder {
    #[inline]
    pub fn present_wait(mut self, present_wait: bool) -> Self {
        self.value.present_wait = present_wait as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePresentWaitFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePresentWaitFeaturesKHRBuilder {
    type Target = PhysicalDevicePresentWaitFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePresentWaitFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePresentWaitFeaturesKHRBuilder {
    type Target = PhysicalDevicePresentWaitFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    type Target = PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    type Builder = PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder {
    value: PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT,
}

impl PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder {
    #[inline]
    pub fn primitive_topology_list_restart(
        mut self,
        primitive_topology_list_restart: bool,
    ) -> Self {
        self.value.primitive_topology_list_restart = primitive_topology_list_restart as Bool32;
        self
    }

    #[inline]
    pub fn primitive_topology_patch_list_restart(
        mut self,
        primitive_topology_patch_list_restart: bool,
    ) -> Self {
        self.value.primitive_topology_patch_list_restart =
            primitive_topology_patch_list_restart as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder {
    type Target = PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXTBuilder {
    type Target = PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePrivateDataFeaturesEXT {
    type Target = PhysicalDevicePrivateDataFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePrivateDataFeaturesEXT {
    type Builder = PhysicalDevicePrivateDataFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDevicePrivateDataFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePrivateDataFeaturesEXTBuilder {
    value: PhysicalDevicePrivateDataFeaturesEXT,
}

impl PhysicalDevicePrivateDataFeaturesEXTBuilder {
    #[inline]
    pub fn private_data(mut self, private_data: bool) -> Self {
        self.value.private_data = private_data as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePrivateDataFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePrivateDataFeaturesEXTBuilder {
    type Target = PhysicalDevicePrivateDataFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePrivateDataFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePrivateDataFeaturesEXTBuilder {
    type Target = PhysicalDevicePrivateDataFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceProperties {
    type Target = PhysicalDeviceProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceProperties {
    type Builder = PhysicalDevicePropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePropertiesBuilder {
    value: PhysicalDeviceProperties,
}

impl PhysicalDevicePropertiesBuilder {
    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.value.api_version = api_version;
        self
    }

    #[inline]
    pub fn driver_version(mut self, driver_version: u32) -> Self {
        self.value.driver_version = driver_version;
        self
    }

    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.value.vendor_id = vendor_id;
        self
    }

    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.value.device_id = device_id;
        self
    }

    #[inline]
    pub fn device_type(mut self, device_type: PhysicalDeviceType) -> Self {
        self.value.device_type = device_type;
        self
    }

    #[inline]
    pub fn device_name(
        mut self,
        device_name: impl Into<StringArray<MAX_PHYSICAL_DEVICE_NAME_SIZE>>,
    ) -> Self {
        self.value.device_name = device_name.into();
        self
    }

    #[inline]
    pub fn pipeline_cache_uuid(
        mut self,
        pipeline_cache_uuid: impl Into<ByteArray<UUID_SIZE>>,
    ) -> Self {
        self.value.pipeline_cache_uuid = pipeline_cache_uuid.into();
        self
    }

    #[inline]
    pub fn limits(mut self, limits: impl Cast<Target = PhysicalDeviceLimits>) -> Self {
        self.value.limits = limits.into();
        self
    }

    #[inline]
    pub fn sparse_properties(
        mut self,
        sparse_properties: impl Cast<Target = PhysicalDeviceSparseProperties>,
    ) -> Self {
        self.value.sparse_properties = sparse_properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePropertiesBuilder {
    type Target = PhysicalDeviceProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePropertiesBuilder {
    type Target = PhysicalDeviceProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceProperties2`].
pub unsafe trait ExtendsPhysicalDeviceProperties2: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceAccelerationStructurePropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceConservativeRasterizationPropertiesEXT
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceCooperativeMatrixPropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceCustomBorderColorPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDepthStencilResolveProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDescriptorIndexingProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDiscardRectanglePropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDrmPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceExternalMemoryHostPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceFloatControlsProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceFragmentDensityMap2PropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceFragmentDensityMapPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceFragmentShadingRateEnumsPropertiesNV
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceFragmentShadingRatePropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceInlineUniformBlockPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceLineRasterizationPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance3Properties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMeshShaderPropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiDrawPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiviewProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePCIBusInfoPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePerformanceQueryPropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePointClippingProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePortabilitySubsetPropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceProtectedMemoryProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceProvokingVertexPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePushDescriptorPropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceRayTracingPipelinePropertiesKHR {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceRayTracingPropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceRobustness2PropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSampleLocationsPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSamplerFilterMinmaxProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShaderCoreProperties2AMD {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShaderCorePropertiesAMD {}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceShaderIntegerDotProductPropertiesKHR
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShaderSMBuiltinsPropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShadingRateImagePropertiesNV {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubgroupProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubgroupSizeControlPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubpassShadingPropertiesHUAWEI {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceTexelBufferAlignmentPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceTimelineSemaphoreProperties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceTransformFeedbackPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceVertexAttributeDivisorPropertiesEXT {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceVulkan11Properties {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceVulkan12Properties {}

unsafe impl Cast for PhysicalDeviceProperties2 {
    type Target = PhysicalDeviceProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceProperties2 {
    type Builder = PhysicalDeviceProperties2Builder<'b>;
}

/// A builder for a [`PhysicalDeviceProperties2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceProperties2Builder<'b> {
    value: PhysicalDeviceProperties2,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceProperties2Builder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceProperties2,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceProperties2>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn properties(mut self, properties: impl Cast<Target = PhysicalDeviceProperties>) -> Self {
        self.value.properties = properties.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProperties2 {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceProperties2Builder<'b> {
    type Target = PhysicalDeviceProperties2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceProperties2Builder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceProperties2Builder<'b> {
    type Target = PhysicalDeviceProperties2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceProtectedMemoryFeatures {
    type Target = PhysicalDeviceProtectedMemoryFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceProtectedMemoryFeatures {
    type Builder = PhysicalDeviceProtectedMemoryFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceProtectedMemoryFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceProtectedMemoryFeaturesBuilder {
    value: PhysicalDeviceProtectedMemoryFeatures,
}

impl PhysicalDeviceProtectedMemoryFeaturesBuilder {
    #[inline]
    pub fn protected_memory(mut self, protected_memory: bool) -> Self {
        self.value.protected_memory = protected_memory as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProtectedMemoryFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceProtectedMemoryFeaturesBuilder {
    type Target = PhysicalDeviceProtectedMemoryFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceProtectedMemoryFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceProtectedMemoryFeaturesBuilder {
    type Target = PhysicalDeviceProtectedMemoryFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceProtectedMemoryProperties {
    type Target = PhysicalDeviceProtectedMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceProtectedMemoryProperties {
    type Builder = PhysicalDeviceProtectedMemoryPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceProtectedMemoryProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceProtectedMemoryPropertiesBuilder {
    value: PhysicalDeviceProtectedMemoryProperties,
}

impl PhysicalDeviceProtectedMemoryPropertiesBuilder {
    #[inline]
    pub fn protected_no_fault(mut self, protected_no_fault: bool) -> Self {
        self.value.protected_no_fault = protected_no_fault as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProtectedMemoryProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceProtectedMemoryPropertiesBuilder {
    type Target = PhysicalDeviceProtectedMemoryProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceProtectedMemoryPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceProtectedMemoryPropertiesBuilder {
    type Target = PhysicalDeviceProtectedMemoryProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceProvokingVertexFeaturesEXT {
    type Target = PhysicalDeviceProvokingVertexFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceProvokingVertexFeaturesEXT {
    type Builder = PhysicalDeviceProvokingVertexFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceProvokingVertexFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceProvokingVertexFeaturesEXTBuilder {
    value: PhysicalDeviceProvokingVertexFeaturesEXT,
}

impl PhysicalDeviceProvokingVertexFeaturesEXTBuilder {
    #[inline]
    pub fn provoking_vertex_last(mut self, provoking_vertex_last: bool) -> Self {
        self.value.provoking_vertex_last = provoking_vertex_last as Bool32;
        self
    }

    #[inline]
    pub fn transform_feedback_preserves_provoking_vertex(
        mut self,
        transform_feedback_preserves_provoking_vertex: bool,
    ) -> Self {
        self.value.transform_feedback_preserves_provoking_vertex =
            transform_feedback_preserves_provoking_vertex as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProvokingVertexFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceProvokingVertexFeaturesEXTBuilder {
    type Target = PhysicalDeviceProvokingVertexFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceProvokingVertexFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceProvokingVertexFeaturesEXTBuilder {
    type Target = PhysicalDeviceProvokingVertexFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceProvokingVertexPropertiesEXT {
    type Target = PhysicalDeviceProvokingVertexPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceProvokingVertexPropertiesEXT {
    type Builder = PhysicalDeviceProvokingVertexPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceProvokingVertexPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceProvokingVertexPropertiesEXTBuilder {
    value: PhysicalDeviceProvokingVertexPropertiesEXT,
}

impl PhysicalDeviceProvokingVertexPropertiesEXTBuilder {
    #[inline]
    pub fn provoking_vertex_mode_per_pipeline(
        mut self,
        provoking_vertex_mode_per_pipeline: bool,
    ) -> Self {
        self.value.provoking_vertex_mode_per_pipeline =
            provoking_vertex_mode_per_pipeline as Bool32;
        self
    }

    #[inline]
    pub fn transform_feedback_preserves_triangle_fan_provoking_vertex(
        mut self,
        transform_feedback_preserves_triangle_fan_provoking_vertex: bool,
    ) -> Self {
        self.value
            .transform_feedback_preserves_triangle_fan_provoking_vertex =
            transform_feedback_preserves_triangle_fan_provoking_vertex as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceProvokingVertexPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceProvokingVertexPropertiesEXTBuilder {
    type Target = PhysicalDeviceProvokingVertexPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceProvokingVertexPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceProvokingVertexPropertiesEXTBuilder {
    type Target = PhysicalDeviceProvokingVertexPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDevicePushDescriptorPropertiesKHR {
    type Target = PhysicalDevicePushDescriptorPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDevicePushDescriptorPropertiesKHR {
    type Builder = PhysicalDevicePushDescriptorPropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDevicePushDescriptorPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDevicePushDescriptorPropertiesKHRBuilder {
    value: PhysicalDevicePushDescriptorPropertiesKHR,
}

impl PhysicalDevicePushDescriptorPropertiesKHRBuilder {
    #[inline]
    pub fn max_push_descriptors(mut self, max_push_descriptors: u32) -> Self {
        self.value.max_push_descriptors = max_push_descriptors;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDevicePushDescriptorPropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDevicePushDescriptorPropertiesKHRBuilder {
    type Target = PhysicalDevicePushDescriptorPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDevicePushDescriptorPropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDevicePushDescriptorPropertiesKHRBuilder {
    type Target = PhysicalDevicePushDescriptorPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayQueryFeaturesKHR {
    type Target = PhysicalDeviceRayQueryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRayQueryFeaturesKHR {
    type Builder = PhysicalDeviceRayQueryFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceRayQueryFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRayQueryFeaturesKHRBuilder {
    value: PhysicalDeviceRayQueryFeaturesKHR,
}

impl PhysicalDeviceRayQueryFeaturesKHRBuilder {
    #[inline]
    pub fn ray_query(mut self, ray_query: bool) -> Self {
        self.value.ray_query = ray_query as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRayQueryFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRayQueryFeaturesKHRBuilder {
    type Target = PhysicalDeviceRayQueryFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRayQueryFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayQueryFeaturesKHRBuilder {
    type Target = PhysicalDeviceRayQueryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingMotionBlurFeaturesNV {
    type Target = PhysicalDeviceRayTracingMotionBlurFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRayTracingMotionBlurFeaturesNV {
    type Builder = PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceRayTracingMotionBlurFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder {
    value: PhysicalDeviceRayTracingMotionBlurFeaturesNV,
}

impl PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder {
    #[inline]
    pub fn ray_tracing_motion_blur(mut self, ray_tracing_motion_blur: bool) -> Self {
        self.value.ray_tracing_motion_blur = ray_tracing_motion_blur as Bool32;
        self
    }

    #[inline]
    pub fn ray_tracing_motion_blur_pipeline_trace_rays_indirect(
        mut self,
        ray_tracing_motion_blur_pipeline_trace_rays_indirect: bool,
    ) -> Self {
        self.value
            .ray_tracing_motion_blur_pipeline_trace_rays_indirect =
            ray_tracing_motion_blur_pipeline_trace_rays_indirect as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRayTracingMotionBlurFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder {
    type Target = PhysicalDeviceRayTracingMotionBlurFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingMotionBlurFeaturesNVBuilder {
    type Target = PhysicalDeviceRayTracingMotionBlurFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPipelineFeaturesKHR {
    type Target = PhysicalDeviceRayTracingPipelineFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRayTracingPipelineFeaturesKHR {
    type Builder = PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceRayTracingPipelineFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder {
    value: PhysicalDeviceRayTracingPipelineFeaturesKHR,
}

impl PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder {
    #[inline]
    pub fn ray_tracing_pipeline(mut self, ray_tracing_pipeline: bool) -> Self {
        self.value.ray_tracing_pipeline = ray_tracing_pipeline as Bool32;
        self
    }

    #[inline]
    pub fn ray_tracing_pipeline_shader_group_handle_capture_replay(
        mut self,
        ray_tracing_pipeline_shader_group_handle_capture_replay: bool,
    ) -> Self {
        self.value
            .ray_tracing_pipeline_shader_group_handle_capture_replay =
            ray_tracing_pipeline_shader_group_handle_capture_replay as Bool32;
        self
    }

    #[inline]
    pub fn ray_tracing_pipeline_shader_group_handle_capture_replay_mixed(
        mut self,
        ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: bool,
    ) -> Self {
        self.value
            .ray_tracing_pipeline_shader_group_handle_capture_replay_mixed =
            ray_tracing_pipeline_shader_group_handle_capture_replay_mixed as Bool32;
        self
    }

    #[inline]
    pub fn ray_tracing_pipeline_trace_rays_indirect(
        mut self,
        ray_tracing_pipeline_trace_rays_indirect: bool,
    ) -> Self {
        self.value.ray_tracing_pipeline_trace_rays_indirect =
            ray_tracing_pipeline_trace_rays_indirect as Bool32;
        self
    }

    #[inline]
    pub fn ray_traversal_primitive_culling(
        mut self,
        ray_traversal_primitive_culling: bool,
    ) -> Self {
        self.value.ray_traversal_primitive_culling = ray_traversal_primitive_culling as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRayTracingPipelineFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder {
    type Target = PhysicalDeviceRayTracingPipelineFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPipelineFeaturesKHRBuilder {
    type Target = PhysicalDeviceRayTracingPipelineFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPipelinePropertiesKHR {
    type Target = PhysicalDeviceRayTracingPipelinePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRayTracingPipelinePropertiesKHR {
    type Builder = PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceRayTracingPipelinePropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder {
    value: PhysicalDeviceRayTracingPipelinePropertiesKHR,
}

impl PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder {
    #[inline]
    pub fn shader_group_handle_size(mut self, shader_group_handle_size: u32) -> Self {
        self.value.shader_group_handle_size = shader_group_handle_size;
        self
    }

    #[inline]
    pub fn max_ray_recursion_depth(mut self, max_ray_recursion_depth: u32) -> Self {
        self.value.max_ray_recursion_depth = max_ray_recursion_depth;
        self
    }

    #[inline]
    pub fn max_shader_group_stride(mut self, max_shader_group_stride: u32) -> Self {
        self.value.max_shader_group_stride = max_shader_group_stride;
        self
    }

    #[inline]
    pub fn shader_group_base_alignment(mut self, shader_group_base_alignment: u32) -> Self {
        self.value.shader_group_base_alignment = shader_group_base_alignment;
        self
    }

    #[inline]
    pub fn shader_group_handle_capture_replay_size(
        mut self,
        shader_group_handle_capture_replay_size: u32,
    ) -> Self {
        self.value.shader_group_handle_capture_replay_size =
            shader_group_handle_capture_replay_size;
        self
    }

    #[inline]
    pub fn max_ray_dispatch_invocation_count(
        mut self,
        max_ray_dispatch_invocation_count: u32,
    ) -> Self {
        self.value.max_ray_dispatch_invocation_count = max_ray_dispatch_invocation_count;
        self
    }

    #[inline]
    pub fn shader_group_handle_alignment(mut self, shader_group_handle_alignment: u32) -> Self {
        self.value.shader_group_handle_alignment = shader_group_handle_alignment;
        self
    }

    #[inline]
    pub fn max_ray_hit_attribute_size(mut self, max_ray_hit_attribute_size: u32) -> Self {
        self.value.max_ray_hit_attribute_size = max_ray_hit_attribute_size;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRayTracingPipelinePropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder {
    type Target = PhysicalDeviceRayTracingPipelinePropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPipelinePropertiesKHRBuilder {
    type Target = PhysicalDeviceRayTracingPipelinePropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPropertiesNV {
    type Target = PhysicalDeviceRayTracingPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRayTracingPropertiesNV {
    type Builder = PhysicalDeviceRayTracingPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceRayTracingPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRayTracingPropertiesNVBuilder {
    value: PhysicalDeviceRayTracingPropertiesNV,
}

impl PhysicalDeviceRayTracingPropertiesNVBuilder {
    #[inline]
    pub fn shader_group_handle_size(mut self, shader_group_handle_size: u32) -> Self {
        self.value.shader_group_handle_size = shader_group_handle_size;
        self
    }

    #[inline]
    pub fn max_recursion_depth(mut self, max_recursion_depth: u32) -> Self {
        self.value.max_recursion_depth = max_recursion_depth;
        self
    }

    #[inline]
    pub fn max_shader_group_stride(mut self, max_shader_group_stride: u32) -> Self {
        self.value.max_shader_group_stride = max_shader_group_stride;
        self
    }

    #[inline]
    pub fn shader_group_base_alignment(mut self, shader_group_base_alignment: u32) -> Self {
        self.value.shader_group_base_alignment = shader_group_base_alignment;
        self
    }

    #[inline]
    pub fn max_geometry_count(mut self, max_geometry_count: u64) -> Self {
        self.value.max_geometry_count = max_geometry_count;
        self
    }

    #[inline]
    pub fn max_instance_count(mut self, max_instance_count: u64) -> Self {
        self.value.max_instance_count = max_instance_count;
        self
    }

    #[inline]
    pub fn max_triangle_count(mut self, max_triangle_count: u64) -> Self {
        self.value.max_triangle_count = max_triangle_count;
        self
    }

    #[inline]
    pub fn max_descriptor_set_acceleration_structures(
        mut self,
        max_descriptor_set_acceleration_structures: u32,
    ) -> Self {
        self.value.max_descriptor_set_acceleration_structures =
            max_descriptor_set_acceleration_structures;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRayTracingPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRayTracingPropertiesNVBuilder {
    type Target = PhysicalDeviceRayTracingPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRayTracingPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRayTracingPropertiesNVBuilder {
    type Target = PhysicalDeviceRayTracingPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    type Target = PhysicalDeviceRepresentativeFragmentTestFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    type Builder = PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceRepresentativeFragmentTestFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder {
    value: PhysicalDeviceRepresentativeFragmentTestFeaturesNV,
}

impl PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder {
    #[inline]
    pub fn representative_fragment_test(mut self, representative_fragment_test: bool) -> Self {
        self.value.representative_fragment_test = representative_fragment_test as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder {
    type Target = PhysicalDeviceRepresentativeFragmentTestFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRepresentativeFragmentTestFeaturesNVBuilder {
    type Target = PhysicalDeviceRepresentativeFragmentTestFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRobustness2FeaturesEXT {
    type Target = PhysicalDeviceRobustness2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRobustness2FeaturesEXT {
    type Builder = PhysicalDeviceRobustness2FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceRobustness2FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRobustness2FeaturesEXTBuilder {
    value: PhysicalDeviceRobustness2FeaturesEXT,
}

impl PhysicalDeviceRobustness2FeaturesEXTBuilder {
    #[inline]
    pub fn robust_buffer_access2(mut self, robust_buffer_access2: bool) -> Self {
        self.value.robust_buffer_access2 = robust_buffer_access2 as Bool32;
        self
    }

    #[inline]
    pub fn robust_image_access2(mut self, robust_image_access2: bool) -> Self {
        self.value.robust_image_access2 = robust_image_access2 as Bool32;
        self
    }

    #[inline]
    pub fn null_descriptor(mut self, null_descriptor: bool) -> Self {
        self.value.null_descriptor = null_descriptor as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRobustness2FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRobustness2FeaturesEXTBuilder {
    type Target = PhysicalDeviceRobustness2FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRobustness2FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRobustness2FeaturesEXTBuilder {
    type Target = PhysicalDeviceRobustness2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceRobustness2PropertiesEXT {
    type Target = PhysicalDeviceRobustness2PropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceRobustness2PropertiesEXT {
    type Builder = PhysicalDeviceRobustness2PropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceRobustness2PropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceRobustness2PropertiesEXTBuilder {
    value: PhysicalDeviceRobustness2PropertiesEXT,
}

impl PhysicalDeviceRobustness2PropertiesEXTBuilder {
    #[inline]
    pub fn robust_storage_buffer_access_size_alignment(
        mut self,
        robust_storage_buffer_access_size_alignment: DeviceSize,
    ) -> Self {
        self.value.robust_storage_buffer_access_size_alignment =
            robust_storage_buffer_access_size_alignment;
        self
    }

    #[inline]
    pub fn robust_uniform_buffer_access_size_alignment(
        mut self,
        robust_uniform_buffer_access_size_alignment: DeviceSize,
    ) -> Self {
        self.value.robust_uniform_buffer_access_size_alignment =
            robust_uniform_buffer_access_size_alignment;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceRobustness2PropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceRobustness2PropertiesEXTBuilder {
    type Target = PhysicalDeviceRobustness2PropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceRobustness2PropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceRobustness2PropertiesEXTBuilder {
    type Target = PhysicalDeviceRobustness2PropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSampleLocationsPropertiesEXT {
    type Target = PhysicalDeviceSampleLocationsPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSampleLocationsPropertiesEXT {
    type Builder = PhysicalDeviceSampleLocationsPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceSampleLocationsPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
    value: PhysicalDeviceSampleLocationsPropertiesEXT,
}

impl PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
    #[inline]
    pub fn sample_location_sample_counts(
        mut self,
        sample_location_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.sample_location_sample_counts = sample_location_sample_counts;
        self
    }

    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.max_sample_location_grid_size = max_sample_location_grid_size.into();
        self
    }

    #[inline]
    pub fn sample_location_coordinate_range(
        mut self,
        sample_location_coordinate_range: [f32; 2],
    ) -> Self {
        self.value.sample_location_coordinate_range = sample_location_coordinate_range;
        self
    }

    #[inline]
    pub fn sample_location_sub_pixel_bits(mut self, sample_location_sub_pixel_bits: u32) -> Self {
        self.value.sample_location_sub_pixel_bits = sample_location_sub_pixel_bits;
        self
    }

    #[inline]
    pub fn variable_sample_locations(mut self, variable_sample_locations: bool) -> Self {
        self.value.variable_sample_locations = variable_sample_locations as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSampleLocationsPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
    type Target = PhysicalDeviceSampleLocationsPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
    type Target = PhysicalDeviceSampleLocationsPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSamplerFilterMinmaxProperties {
    type Target = PhysicalDeviceSamplerFilterMinmaxProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSamplerFilterMinmaxProperties {
    type Builder = PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceSamplerFilterMinmaxProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
    value: PhysicalDeviceSamplerFilterMinmaxProperties,
}

impl PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
    #[inline]
    pub fn filter_minmax_single_component_formats(
        mut self,
        filter_minmax_single_component_formats: bool,
    ) -> Self {
        self.value.filter_minmax_single_component_formats =
            filter_minmax_single_component_formats as Bool32;
        self
    }

    #[inline]
    pub fn filter_minmax_image_component_mapping(
        mut self,
        filter_minmax_image_component_mapping: bool,
    ) -> Self {
        self.value.filter_minmax_image_component_mapping =
            filter_minmax_image_component_mapping as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSamplerFilterMinmaxProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
    type Target = PhysicalDeviceSamplerFilterMinmaxProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
    type Target = PhysicalDeviceSamplerFilterMinmaxProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSamplerYcbcrConversionFeatures {
    type Target = PhysicalDeviceSamplerYcbcrConversionFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSamplerYcbcrConversionFeatures {
    type Builder = PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceSamplerYcbcrConversionFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
    value: PhysicalDeviceSamplerYcbcrConversionFeatures,
}

impl PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
    #[inline]
    pub fn sampler_ycbcr_conversion(mut self, sampler_ycbcr_conversion: bool) -> Self {
        self.value.sampler_ycbcr_conversion = sampler_ycbcr_conversion as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSamplerYcbcrConversionFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
    type Target = PhysicalDeviceSamplerYcbcrConversionFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
    type Target = PhysicalDeviceSamplerYcbcrConversionFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceScalarBlockLayoutFeatures {
    type Target = PhysicalDeviceScalarBlockLayoutFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceScalarBlockLayoutFeatures {
    type Builder = PhysicalDeviceScalarBlockLayoutFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceScalarBlockLayoutFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceScalarBlockLayoutFeaturesBuilder {
    value: PhysicalDeviceScalarBlockLayoutFeatures,
}

impl PhysicalDeviceScalarBlockLayoutFeaturesBuilder {
    #[inline]
    pub fn scalar_block_layout(mut self, scalar_block_layout: bool) -> Self {
        self.value.scalar_block_layout = scalar_block_layout as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceScalarBlockLayoutFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceScalarBlockLayoutFeaturesBuilder {
    type Target = PhysicalDeviceScalarBlockLayoutFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceScalarBlockLayoutFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceScalarBlockLayoutFeaturesBuilder {
    type Target = PhysicalDeviceScalarBlockLayoutFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    type Target = PhysicalDeviceSeparateDepthStencilLayoutsFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    type Builder = PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceSeparateDepthStencilLayoutsFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder {
    value: PhysicalDeviceSeparateDepthStencilLayoutsFeatures,
}

impl PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder {
    #[inline]
    pub fn separate_depth_stencil_layouts(mut self, separate_depth_stencil_layouts: bool) -> Self {
        self.value.separate_depth_stencil_layouts = separate_depth_stencil_layouts as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder {
    type Target = PhysicalDeviceSeparateDepthStencilLayoutsFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSeparateDepthStencilLayoutsFeaturesBuilder {
    type Target = PhysicalDeviceSeparateDepthStencilLayoutsFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    type Target = PhysicalDeviceShaderAtomicFloat2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    type Builder = PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceShaderAtomicFloat2FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder {
    value: PhysicalDeviceShaderAtomicFloat2FeaturesEXT,
}

impl PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder {
    #[inline]
    pub fn shader_buffer_float16_atomics(mut self, shader_buffer_float16_atomics: bool) -> Self {
        self.value.shader_buffer_float16_atomics = shader_buffer_float16_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float16_atomic_add(
        mut self,
        shader_buffer_float16_atomic_add: bool,
    ) -> Self {
        self.value.shader_buffer_float16_atomic_add = shader_buffer_float16_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float16_atomic_min_max(
        mut self,
        shader_buffer_float16_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_buffer_float16_atomic_min_max =
            shader_buffer_float16_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float32_atomic_min_max(
        mut self,
        shader_buffer_float32_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_buffer_float32_atomic_min_max =
            shader_buffer_float32_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float64_atomic_min_max(
        mut self,
        shader_buffer_float64_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_buffer_float64_atomic_min_max =
            shader_buffer_float64_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float16_atomics(mut self, shader_shared_float16_atomics: bool) -> Self {
        self.value.shader_shared_float16_atomics = shader_shared_float16_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float16_atomic_add(
        mut self,
        shader_shared_float16_atomic_add: bool,
    ) -> Self {
        self.value.shader_shared_float16_atomic_add = shader_shared_float16_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float16_atomic_min_max(
        mut self,
        shader_shared_float16_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_shared_float16_atomic_min_max =
            shader_shared_float16_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float32_atomic_min_max(
        mut self,
        shader_shared_float32_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_shared_float32_atomic_min_max =
            shader_shared_float32_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float64_atomic_min_max(
        mut self,
        shader_shared_float64_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_shared_float64_atomic_min_max =
            shader_shared_float64_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn shader_image_float32_atomic_min_max(
        mut self,
        shader_image_float32_atomic_min_max: bool,
    ) -> Self {
        self.value.shader_image_float32_atomic_min_max =
            shader_image_float32_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn sparse_image_float32_atomic_min_max(
        mut self,
        sparse_image_float32_atomic_min_max: bool,
    ) -> Self {
        self.value.sparse_image_float32_atomic_min_max =
            sparse_image_float32_atomic_min_max as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderAtomicFloat2FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicFloat2FeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderAtomicFloat2FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicFloatFeaturesEXT {
    type Target = PhysicalDeviceShaderAtomicFloatFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderAtomicFloatFeaturesEXT {
    type Builder = PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceShaderAtomicFloatFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder {
    value: PhysicalDeviceShaderAtomicFloatFeaturesEXT,
}

impl PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder {
    #[inline]
    pub fn shader_buffer_float32_atomics(mut self, shader_buffer_float32_atomics: bool) -> Self {
        self.value.shader_buffer_float32_atomics = shader_buffer_float32_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float32_atomic_add(
        mut self,
        shader_buffer_float32_atomic_add: bool,
    ) -> Self {
        self.value.shader_buffer_float32_atomic_add = shader_buffer_float32_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float64_atomics(mut self, shader_buffer_float64_atomics: bool) -> Self {
        self.value.shader_buffer_float64_atomics = shader_buffer_float64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_float64_atomic_add(
        mut self,
        shader_buffer_float64_atomic_add: bool,
    ) -> Self {
        self.value.shader_buffer_float64_atomic_add = shader_buffer_float64_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float32_atomics(mut self, shader_shared_float32_atomics: bool) -> Self {
        self.value.shader_shared_float32_atomics = shader_shared_float32_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float32_atomic_add(
        mut self,
        shader_shared_float32_atomic_add: bool,
    ) -> Self {
        self.value.shader_shared_float32_atomic_add = shader_shared_float32_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float64_atomics(mut self, shader_shared_float64_atomics: bool) -> Self {
        self.value.shader_shared_float64_atomics = shader_shared_float64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_float64_atomic_add(
        mut self,
        shader_shared_float64_atomic_add: bool,
    ) -> Self {
        self.value.shader_shared_float64_atomic_add = shader_shared_float64_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn shader_image_float32_atomics(mut self, shader_image_float32_atomics: bool) -> Self {
        self.value.shader_image_float32_atomics = shader_image_float32_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_image_float32_atomic_add(
        mut self,
        shader_image_float32_atomic_add: bool,
    ) -> Self {
        self.value.shader_image_float32_atomic_add = shader_image_float32_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn sparse_image_float32_atomics(mut self, sparse_image_float32_atomics: bool) -> Self {
        self.value.sparse_image_float32_atomics = sparse_image_float32_atomics as Bool32;
        self
    }

    #[inline]
    pub fn sparse_image_float32_atomic_add(
        mut self,
        sparse_image_float32_atomic_add: bool,
    ) -> Self {
        self.value.sparse_image_float32_atomic_add = sparse_image_float32_atomic_add as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderAtomicFloatFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderAtomicFloatFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicFloatFeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderAtomicFloatFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicInt64Features {
    type Target = PhysicalDeviceShaderAtomicInt64Features;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderAtomicInt64Features {
    type Builder = PhysicalDeviceShaderAtomicInt64FeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceShaderAtomicInt64Features`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderAtomicInt64FeaturesBuilder {
    value: PhysicalDeviceShaderAtomicInt64Features,
}

impl PhysicalDeviceShaderAtomicInt64FeaturesBuilder {
    #[inline]
    pub fn shader_buffer_int64_atomics(mut self, shader_buffer_int64_atomics: bool) -> Self {
        self.value.shader_buffer_int64_atomics = shader_buffer_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_int64_atomics(mut self, shader_shared_int64_atomics: bool) -> Self {
        self.value.shader_shared_int64_atomics = shader_shared_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderAtomicInt64Features {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderAtomicInt64FeaturesBuilder {
    type Target = PhysicalDeviceShaderAtomicInt64Features;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderAtomicInt64FeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderAtomicInt64FeaturesBuilder {
    type Target = PhysicalDeviceShaderAtomicInt64Features;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderClockFeaturesKHR {
    type Target = PhysicalDeviceShaderClockFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderClockFeaturesKHR {
    type Builder = PhysicalDeviceShaderClockFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceShaderClockFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderClockFeaturesKHRBuilder {
    value: PhysicalDeviceShaderClockFeaturesKHR,
}

impl PhysicalDeviceShaderClockFeaturesKHRBuilder {
    #[inline]
    pub fn shader_subgroup_clock(mut self, shader_subgroup_clock: bool) -> Self {
        self.value.shader_subgroup_clock = shader_subgroup_clock as Bool32;
        self
    }

    #[inline]
    pub fn shader_device_clock(mut self, shader_device_clock: bool) -> Self {
        self.value.shader_device_clock = shader_device_clock as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderClockFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderClockFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderClockFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderClockFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderClockFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderClockFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderCoreProperties2AMD {
    type Target = PhysicalDeviceShaderCoreProperties2AMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderCoreProperties2AMD {
    type Builder = PhysicalDeviceShaderCoreProperties2AMDBuilder;
}

/// A builder for a [`PhysicalDeviceShaderCoreProperties2AMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderCoreProperties2AMDBuilder {
    value: PhysicalDeviceShaderCoreProperties2AMD,
}

impl PhysicalDeviceShaderCoreProperties2AMDBuilder {
    #[inline]
    pub fn shader_core_features(
        mut self,
        shader_core_features: ShaderCorePropertiesFlagsAMD,
    ) -> Self {
        self.value.shader_core_features = shader_core_features;
        self
    }

    #[inline]
    pub fn active_compute_unit_count(mut self, active_compute_unit_count: u32) -> Self {
        self.value.active_compute_unit_count = active_compute_unit_count;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderCoreProperties2AMD {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderCoreProperties2AMDBuilder {
    type Target = PhysicalDeviceShaderCoreProperties2AMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderCoreProperties2AMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderCoreProperties2AMDBuilder {
    type Target = PhysicalDeviceShaderCoreProperties2AMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderCorePropertiesAMD {
    type Target = PhysicalDeviceShaderCorePropertiesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderCorePropertiesAMD {
    type Builder = PhysicalDeviceShaderCorePropertiesAMDBuilder;
}

/// A builder for a [`PhysicalDeviceShaderCorePropertiesAMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderCorePropertiesAMDBuilder {
    value: PhysicalDeviceShaderCorePropertiesAMD,
}

impl PhysicalDeviceShaderCorePropertiesAMDBuilder {
    #[inline]
    pub fn shader_engine_count(mut self, shader_engine_count: u32) -> Self {
        self.value.shader_engine_count = shader_engine_count;
        self
    }

    #[inline]
    pub fn shader_arrays_per_engine_count(mut self, shader_arrays_per_engine_count: u32) -> Self {
        self.value.shader_arrays_per_engine_count = shader_arrays_per_engine_count;
        self
    }

    #[inline]
    pub fn compute_units_per_shader_array(mut self, compute_units_per_shader_array: u32) -> Self {
        self.value.compute_units_per_shader_array = compute_units_per_shader_array;
        self
    }

    #[inline]
    pub fn simd_per_compute_unit(mut self, simd_per_compute_unit: u32) -> Self {
        self.value.simd_per_compute_unit = simd_per_compute_unit;
        self
    }

    #[inline]
    pub fn wavefronts_per_simd(mut self, wavefronts_per_simd: u32) -> Self {
        self.value.wavefronts_per_simd = wavefronts_per_simd;
        self
    }

    #[inline]
    pub fn wavefront_size(mut self, wavefront_size: u32) -> Self {
        self.value.wavefront_size = wavefront_size;
        self
    }

    #[inline]
    pub fn sgprs_per_simd(mut self, sgprs_per_simd: u32) -> Self {
        self.value.sgprs_per_simd = sgprs_per_simd;
        self
    }

    #[inline]
    pub fn min_sgpr_allocation(mut self, min_sgpr_allocation: u32) -> Self {
        self.value.min_sgpr_allocation = min_sgpr_allocation;
        self
    }

    #[inline]
    pub fn max_sgpr_allocation(mut self, max_sgpr_allocation: u32) -> Self {
        self.value.max_sgpr_allocation = max_sgpr_allocation;
        self
    }

    #[inline]
    pub fn sgpr_allocation_granularity(mut self, sgpr_allocation_granularity: u32) -> Self {
        self.value.sgpr_allocation_granularity = sgpr_allocation_granularity;
        self
    }

    #[inline]
    pub fn vgprs_per_simd(mut self, vgprs_per_simd: u32) -> Self {
        self.value.vgprs_per_simd = vgprs_per_simd;
        self
    }

    #[inline]
    pub fn min_vgpr_allocation(mut self, min_vgpr_allocation: u32) -> Self {
        self.value.min_vgpr_allocation = min_vgpr_allocation;
        self
    }

    #[inline]
    pub fn max_vgpr_allocation(mut self, max_vgpr_allocation: u32) -> Self {
        self.value.max_vgpr_allocation = max_vgpr_allocation;
        self
    }

    #[inline]
    pub fn vgpr_allocation_granularity(mut self, vgpr_allocation_granularity: u32) -> Self {
        self.value.vgpr_allocation_granularity = vgpr_allocation_granularity;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderCorePropertiesAMD {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderCorePropertiesAMDBuilder {
    type Target = PhysicalDeviceShaderCorePropertiesAMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderCorePropertiesAMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderCorePropertiesAMDBuilder {
    type Target = PhysicalDeviceShaderCorePropertiesAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
    type Target = PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
    type Builder = PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder {
    value: PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT,
}

impl PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder {
    #[inline]
    pub fn shader_demote_to_helper_invocation(
        mut self,
        shader_demote_to_helper_invocation: bool,
    ) -> Self {
        self.value.shader_demote_to_helper_invocation =
            shader_demote_to_helper_invocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderDrawParametersFeatures {
    type Target = PhysicalDeviceShaderDrawParametersFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderDrawParametersFeatures {
    type Builder = PhysicalDeviceShaderDrawParametersFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceShaderDrawParametersFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderDrawParametersFeaturesBuilder {
    value: PhysicalDeviceShaderDrawParametersFeatures,
}

impl PhysicalDeviceShaderDrawParametersFeaturesBuilder {
    #[inline]
    pub fn shader_draw_parameters(mut self, shader_draw_parameters: bool) -> Self {
        self.value.shader_draw_parameters = shader_draw_parameters as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderDrawParametersFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderDrawParametersFeaturesBuilder {
    type Target = PhysicalDeviceShaderDrawParametersFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderDrawParametersFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderDrawParametersFeaturesBuilder {
    type Target = PhysicalDeviceShaderDrawParametersFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderFloat16Int8Features {
    type Target = PhysicalDeviceShaderFloat16Int8Features;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderFloat16Int8Features {
    type Builder = PhysicalDeviceShaderFloat16Int8FeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceShaderFloat16Int8Features`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderFloat16Int8FeaturesBuilder {
    value: PhysicalDeviceShaderFloat16Int8Features,
}

impl PhysicalDeviceShaderFloat16Int8FeaturesBuilder {
    #[inline]
    pub fn shader_float16(mut self, shader_float16: bool) -> Self {
        self.value.shader_float16 = shader_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_int8(mut self, shader_int8: bool) -> Self {
        self.value.shader_int8 = shader_int8 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderFloat16Int8Features {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderFloat16Int8FeaturesBuilder {
    type Target = PhysicalDeviceShaderFloat16Int8Features;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderFloat16Int8FeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderFloat16Int8FeaturesBuilder {
    type Target = PhysicalDeviceShaderFloat16Int8Features;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    type Target = PhysicalDeviceShaderImageAtomicInt64FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    type Builder = PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceShaderImageAtomicInt64FeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder {
    value: PhysicalDeviceShaderImageAtomicInt64FeaturesEXT,
}

impl PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder {
    #[inline]
    pub fn shader_image_int64_atomics(mut self, shader_image_int64_atomics: bool) -> Self {
        self.value.shader_image_int64_atomics = shader_image_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn sparse_image_int64_atomics(mut self, sparse_image_int64_atomics: bool) -> Self {
        self.value.sparse_image_int64_atomics = sparse_image_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderImageAtomicInt64FeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderImageAtomicInt64FeaturesEXTBuilder {
    type Target = PhysicalDeviceShaderImageAtomicInt64FeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderImageFootprintFeaturesNV {
    type Target = PhysicalDeviceShaderImageFootprintFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderImageFootprintFeaturesNV {
    type Builder = PhysicalDeviceShaderImageFootprintFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceShaderImageFootprintFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderImageFootprintFeaturesNVBuilder {
    value: PhysicalDeviceShaderImageFootprintFeaturesNV,
}

impl PhysicalDeviceShaderImageFootprintFeaturesNVBuilder {
    #[inline]
    pub fn image_footprint(mut self, image_footprint: bool) -> Self {
        self.value.image_footprint = image_footprint as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderImageFootprintFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderImageFootprintFeaturesNVBuilder {
    type Target = PhysicalDeviceShaderImageFootprintFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderImageFootprintFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderImageFootprintFeaturesNVBuilder {
    type Target = PhysicalDeviceShaderImageFootprintFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerDotProductFeaturesKHR {
    type Target = PhysicalDeviceShaderIntegerDotProductFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderIntegerDotProductFeaturesKHR {
    type Builder = PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceShaderIntegerDotProductFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder {
    value: PhysicalDeviceShaderIntegerDotProductFeaturesKHR,
}

impl PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder {
    #[inline]
    pub fn shader_integer_dot_product(mut self, shader_integer_dot_product: bool) -> Self {
        self.value.shader_integer_dot_product = shader_integer_dot_product as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderIntegerDotProductFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderIntegerDotProductFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerDotProductFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderIntegerDotProductFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerDotProductPropertiesKHR {
    type Target = PhysicalDeviceShaderIntegerDotProductPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderIntegerDotProductPropertiesKHR {
    type Builder = PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceShaderIntegerDotProductPropertiesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder {
    value: PhysicalDeviceShaderIntegerDotProductPropertiesKHR,
}

impl PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder {
    #[inline]
    pub fn integer_dot_product_8bit_unsigned_accelerated(
        mut self,
        integer_dot_product_8bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_8bit_unsigned_accelerated =
            integer_dot_product_8bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_8bit_signed_accelerated(
        mut self,
        integer_dot_product_8bit_signed_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_8bit_signed_accelerated =
            integer_dot_product_8bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_8bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_8bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_8bit_mixed_signedness_accelerated =
            integer_dot_product_8bit_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product4x_8bit_packed_unsigned_accelerated(
        mut self,
        integer_dot_product4x_8bit_packed_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product4x_8bit_packed_unsigned_accelerated =
            integer_dot_product4x_8bit_packed_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product4x_8bit_packed_signed_accelerated(
        mut self,
        integer_dot_product4x_8bit_packed_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product4x_8bit_packed_signed_accelerated =
            integer_dot_product4x_8bit_packed_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product4x_8bit_packed_mixed_signedness_accelerated(
        mut self,
        integer_dot_product4x_8bit_packed_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product4x_8bit_packed_mixed_signedness_accelerated =
            integer_dot_product4x_8bit_packed_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_16bit_unsigned_accelerated(
        mut self,
        integer_dot_product_16bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_16bit_unsigned_accelerated =
            integer_dot_product_16bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_16bit_signed_accelerated(
        mut self,
        integer_dot_product_16bit_signed_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_16bit_signed_accelerated =
            integer_dot_product_16bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_16bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_16bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_16bit_mixed_signedness_accelerated =
            integer_dot_product_16bit_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_32bit_unsigned_accelerated(
        mut self,
        integer_dot_product_32bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_32bit_unsigned_accelerated =
            integer_dot_product_32bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_32bit_signed_accelerated(
        mut self,
        integer_dot_product_32bit_signed_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_32bit_signed_accelerated =
            integer_dot_product_32bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_32bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_32bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_32bit_mixed_signedness_accelerated =
            integer_dot_product_32bit_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_64bit_unsigned_accelerated(
        mut self,
        integer_dot_product_64bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_64bit_unsigned_accelerated =
            integer_dot_product_64bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_64bit_signed_accelerated(
        mut self,
        integer_dot_product_64bit_signed_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_64bit_signed_accelerated =
            integer_dot_product_64bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_64bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_64bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_64bit_mixed_signedness_accelerated =
            integer_dot_product_64bit_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated =
            integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_8bit_signed_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_8bit_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_8bit_signed_accelerated =
            integer_dot_product_accumulating_saturating_8bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated =
            integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated =
            integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated
                as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated =
            integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value.integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated = integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated =
            integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_16bit_signed_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_16bit_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_16bit_signed_accelerated =
            integer_dot_product_accumulating_saturating_16bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated =
            integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated
                as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated =
            integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_32bit_signed_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_32bit_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_32bit_signed_accelerated =
            integer_dot_product_accumulating_saturating_32bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated =
            integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated
                as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated =
            integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_64bit_signed_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_64bit_signed_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_64bit_signed_accelerated =
            integer_dot_product_accumulating_saturating_64bit_signed_accelerated as Bool32;
        self
    }

    #[inline]
    pub fn integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated(
        mut self,
        integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated: bool,
    ) -> Self {
        self.value
            .integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated =
            integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated
                as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderIntegerDotProductPropertiesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder {
    type Target = PhysicalDeviceShaderIntegerDotProductPropertiesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerDotProductPropertiesKHRBuilder {
    type Target = PhysicalDeviceShaderIntegerDotProductPropertiesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    type Target = PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    type Builder = PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder;
}

/// A builder for a [`PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder {
    value: PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL,
}

impl PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder {
    #[inline]
    pub fn shader_integer_functions2(mut self, shader_integer_functions2: bool) -> Self {
        self.value.shader_integer_functions2 = shader_integer_functions2 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder {
    type Target = PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderIntegerFunctions2FeaturesINTELBuilder {
    type Target = PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSMBuiltinsFeaturesNV {
    type Target = PhysicalDeviceShaderSMBuiltinsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderSMBuiltinsFeaturesNV {
    type Builder = PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceShaderSMBuiltinsFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder {
    value: PhysicalDeviceShaderSMBuiltinsFeaturesNV,
}

impl PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder {
    #[inline]
    pub fn shader_sm_builtins(mut self, shader_sm_builtins: bool) -> Self {
        self.value.shader_sm_builtins = shader_sm_builtins as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderSMBuiltinsFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder {
    type Target = PhysicalDeviceShaderSMBuiltinsFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSMBuiltinsFeaturesNVBuilder {
    type Target = PhysicalDeviceShaderSMBuiltinsFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSMBuiltinsPropertiesNV {
    type Target = PhysicalDeviceShaderSMBuiltinsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderSMBuiltinsPropertiesNV {
    type Builder = PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceShaderSMBuiltinsPropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder {
    value: PhysicalDeviceShaderSMBuiltinsPropertiesNV,
}

impl PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder {
    #[inline]
    pub fn shader_sm_count(mut self, shader_sm_count: u32) -> Self {
        self.value.shader_sm_count = shader_sm_count;
        self
    }

    #[inline]
    pub fn shader_warps_per_sm(mut self, shader_warps_per_sm: u32) -> Self {
        self.value.shader_warps_per_sm = shader_warps_per_sm;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderSMBuiltinsPropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder {
    type Target = PhysicalDeviceShaderSMBuiltinsPropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSMBuiltinsPropertiesNVBuilder {
    type Target = PhysicalDeviceShaderSMBuiltinsPropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    type Target = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    type Builder = PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceShaderSubgroupExtendedTypesFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
    value: PhysicalDeviceShaderSubgroupExtendedTypesFeatures,
}

impl PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
    #[inline]
    pub fn shader_subgroup_extended_types(mut self, shader_subgroup_extended_types: bool) -> Self {
        self.value.shader_subgroup_extended_types = shader_subgroup_extended_types as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
    type Target = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
    type Target = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    type Target = PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    type Builder = PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder {
    value: PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR,
}

impl PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder {
    #[inline]
    pub fn shader_subgroup_uniform_control_flow(
        mut self,
        shader_subgroup_uniform_control_flow: bool,
    ) -> Self {
        self.value.shader_subgroup_uniform_control_flow =
            shader_subgroup_uniform_control_flow as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderTerminateInvocationFeaturesKHR {
    type Target = PhysicalDeviceShaderTerminateInvocationFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShaderTerminateInvocationFeaturesKHR {
    type Builder = PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceShaderTerminateInvocationFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder {
    value: PhysicalDeviceShaderTerminateInvocationFeaturesKHR,
}

impl PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder {
    #[inline]
    pub fn shader_terminate_invocation(mut self, shader_terminate_invocation: bool) -> Self {
        self.value.shader_terminate_invocation = shader_terminate_invocation as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShaderTerminateInvocationFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderTerminateInvocationFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShaderTerminateInvocationFeaturesKHRBuilder {
    type Target = PhysicalDeviceShaderTerminateInvocationFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShadingRateImageFeaturesNV {
    type Target = PhysicalDeviceShadingRateImageFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShadingRateImageFeaturesNV {
    type Builder = PhysicalDeviceShadingRateImageFeaturesNVBuilder;
}

/// A builder for a [`PhysicalDeviceShadingRateImageFeaturesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShadingRateImageFeaturesNVBuilder {
    value: PhysicalDeviceShadingRateImageFeaturesNV,
}

impl PhysicalDeviceShadingRateImageFeaturesNVBuilder {
    #[inline]
    pub fn shading_rate_image(mut self, shading_rate_image: bool) -> Self {
        self.value.shading_rate_image = shading_rate_image as Bool32;
        self
    }

    #[inline]
    pub fn shading_rate_coarse_sample_order(
        mut self,
        shading_rate_coarse_sample_order: bool,
    ) -> Self {
        self.value.shading_rate_coarse_sample_order = shading_rate_coarse_sample_order as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShadingRateImageFeaturesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShadingRateImageFeaturesNVBuilder {
    type Target = PhysicalDeviceShadingRateImageFeaturesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShadingRateImageFeaturesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShadingRateImageFeaturesNVBuilder {
    type Target = PhysicalDeviceShadingRateImageFeaturesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceShadingRateImagePropertiesNV {
    type Target = PhysicalDeviceShadingRateImagePropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceShadingRateImagePropertiesNV {
    type Builder = PhysicalDeviceShadingRateImagePropertiesNVBuilder;
}

/// A builder for a [`PhysicalDeviceShadingRateImagePropertiesNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceShadingRateImagePropertiesNVBuilder {
    value: PhysicalDeviceShadingRateImagePropertiesNV,
}

impl PhysicalDeviceShadingRateImagePropertiesNVBuilder {
    #[inline]
    pub fn shading_rate_texel_size(
        mut self,
        shading_rate_texel_size: impl Cast<Target = Extent2D>,
    ) -> Self {
        self.value.shading_rate_texel_size = shading_rate_texel_size.into();
        self
    }

    #[inline]
    pub fn shading_rate_palette_size(mut self, shading_rate_palette_size: u32) -> Self {
        self.value.shading_rate_palette_size = shading_rate_palette_size;
        self
    }

    #[inline]
    pub fn shading_rate_max_coarse_samples(mut self, shading_rate_max_coarse_samples: u32) -> Self {
        self.value.shading_rate_max_coarse_samples = shading_rate_max_coarse_samples;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceShadingRateImagePropertiesNV {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceShadingRateImagePropertiesNVBuilder {
    type Target = PhysicalDeviceShadingRateImagePropertiesNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceShadingRateImagePropertiesNVBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceShadingRateImagePropertiesNVBuilder {
    type Target = PhysicalDeviceShadingRateImagePropertiesNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSparseImageFormatInfo2 {
    type Target = PhysicalDeviceSparseImageFormatInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSparseImageFormatInfo2 {
    type Builder = PhysicalDeviceSparseImageFormatInfo2Builder;
}

/// A builder for a [`PhysicalDeviceSparseImageFormatInfo2`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSparseImageFormatInfo2Builder {
    value: PhysicalDeviceSparseImageFormatInfo2,
}

impl PhysicalDeviceSparseImageFormatInfo2Builder {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.value.format = format;
        self
    }

    #[inline]
    pub fn type_(mut self, type_: ImageType) -> Self {
        self.value.type_ = type_;
        self
    }

    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.value.samples = samples;
        self
    }

    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.value.usage = usage;
        self
    }

    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.value.tiling = tiling;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSparseImageFormatInfo2 {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSparseImageFormatInfo2Builder {
    type Target = PhysicalDeviceSparseImageFormatInfo2;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSparseImageFormatInfo2Builder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSparseImageFormatInfo2Builder {
    type Target = PhysicalDeviceSparseImageFormatInfo2;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSparseProperties {
    type Target = PhysicalDeviceSparseProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSparseProperties {
    type Builder = PhysicalDeviceSparsePropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceSparseProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSparsePropertiesBuilder {
    value: PhysicalDeviceSparseProperties,
}

impl PhysicalDeviceSparsePropertiesBuilder {
    #[inline]
    pub fn residency_standard_2d_block_shape(
        mut self,
        residency_standard_2d_block_shape: bool,
    ) -> Self {
        self.value.residency_standard_2d_block_shape = residency_standard_2d_block_shape as Bool32;
        self
    }

    #[inline]
    pub fn residency_standard_2d_multisample_block_shape(
        mut self,
        residency_standard_2d_multisample_block_shape: bool,
    ) -> Self {
        self.value.residency_standard_2d_multisample_block_shape =
            residency_standard_2d_multisample_block_shape as Bool32;
        self
    }

    #[inline]
    pub fn residency_standard_3d_block_shape(
        mut self,
        residency_standard_3d_block_shape: bool,
    ) -> Self {
        self.value.residency_standard_3d_block_shape = residency_standard_3d_block_shape as Bool32;
        self
    }

    #[inline]
    pub fn residency_aligned_mip_size(mut self, residency_aligned_mip_size: bool) -> Self {
        self.value.residency_aligned_mip_size = residency_aligned_mip_size as Bool32;
        self
    }

    #[inline]
    pub fn residency_non_resident_strict(mut self, residency_non_resident_strict: bool) -> Self {
        self.value.residency_non_resident_strict = residency_non_resident_strict as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSparseProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSparsePropertiesBuilder {
    type Target = PhysicalDeviceSparseProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSparsePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSparsePropertiesBuilder {
    type Target = PhysicalDeviceSparseProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupProperties {
    type Target = PhysicalDeviceSubgroupProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSubgroupProperties {
    type Builder = PhysicalDeviceSubgroupPropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceSubgroupProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSubgroupPropertiesBuilder {
    value: PhysicalDeviceSubgroupProperties,
}

impl PhysicalDeviceSubgroupPropertiesBuilder {
    #[inline]
    pub fn subgroup_size(mut self, subgroup_size: u32) -> Self {
        self.value.subgroup_size = subgroup_size;
        self
    }

    #[inline]
    pub fn supported_stages(mut self, supported_stages: ShaderStageFlags) -> Self {
        self.value.supported_stages = supported_stages;
        self
    }

    #[inline]
    pub fn supported_operations(mut self, supported_operations: SubgroupFeatureFlags) -> Self {
        self.value.supported_operations = supported_operations;
        self
    }

    #[inline]
    pub fn quad_operations_in_all_stages(mut self, quad_operations_in_all_stages: bool) -> Self {
        self.value.quad_operations_in_all_stages = quad_operations_in_all_stages as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSubgroupProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSubgroupPropertiesBuilder {
    type Target = PhysicalDeviceSubgroupProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSubgroupPropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupPropertiesBuilder {
    type Target = PhysicalDeviceSubgroupProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupSizeControlFeaturesEXT {
    type Target = PhysicalDeviceSubgroupSizeControlFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSubgroupSizeControlFeaturesEXT {
    type Builder = PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceSubgroupSizeControlFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder {
    value: PhysicalDeviceSubgroupSizeControlFeaturesEXT,
}

impl PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder {
    #[inline]
    pub fn subgroup_size_control(mut self, subgroup_size_control: bool) -> Self {
        self.value.subgroup_size_control = subgroup_size_control as Bool32;
        self
    }

    #[inline]
    pub fn compute_full_subgroups(mut self, compute_full_subgroups: bool) -> Self {
        self.value.compute_full_subgroups = compute_full_subgroups as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSubgroupSizeControlFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder {
    type Target = PhysicalDeviceSubgroupSizeControlFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupSizeControlFeaturesEXTBuilder {
    type Target = PhysicalDeviceSubgroupSizeControlFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupSizeControlPropertiesEXT {
    type Target = PhysicalDeviceSubgroupSizeControlPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSubgroupSizeControlPropertiesEXT {
    type Builder = PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceSubgroupSizeControlPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder {
    value: PhysicalDeviceSubgroupSizeControlPropertiesEXT,
}

impl PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder {
    #[inline]
    pub fn min_subgroup_size(mut self, min_subgroup_size: u32) -> Self {
        self.value.min_subgroup_size = min_subgroup_size;
        self
    }

    #[inline]
    pub fn max_subgroup_size(mut self, max_subgroup_size: u32) -> Self {
        self.value.max_subgroup_size = max_subgroup_size;
        self
    }

    #[inline]
    pub fn max_compute_workgroup_subgroups(mut self, max_compute_workgroup_subgroups: u32) -> Self {
        self.value.max_compute_workgroup_subgroups = max_compute_workgroup_subgroups;
        self
    }

    #[inline]
    pub fn required_subgroup_size_stages(
        mut self,
        required_subgroup_size_stages: ShaderStageFlags,
    ) -> Self {
        self.value.required_subgroup_size_stages = required_subgroup_size_stages;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSubgroupSizeControlPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder {
    type Target = PhysicalDeviceSubgroupSizeControlPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubgroupSizeControlPropertiesEXTBuilder {
    type Target = PhysicalDeviceSubgroupSizeControlPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubpassShadingFeaturesHUAWEI {
    type Target = PhysicalDeviceSubpassShadingFeaturesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSubpassShadingFeaturesHUAWEI {
    type Builder = PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder;
}

/// A builder for a [`PhysicalDeviceSubpassShadingFeaturesHUAWEI`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder {
    value: PhysicalDeviceSubpassShadingFeaturesHUAWEI,
}

impl PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder {
    #[inline]
    pub fn subpass_shading(mut self, subpass_shading: bool) -> Self {
        self.value.subpass_shading = subpass_shading as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSubpassShadingFeaturesHUAWEI {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder {
    type Target = PhysicalDeviceSubpassShadingFeaturesHUAWEI;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubpassShadingFeaturesHUAWEIBuilder {
    type Target = PhysicalDeviceSubpassShadingFeaturesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubpassShadingPropertiesHUAWEI {
    type Target = PhysicalDeviceSubpassShadingPropertiesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSubpassShadingPropertiesHUAWEI {
    type Builder = PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder;
}

/// A builder for a [`PhysicalDeviceSubpassShadingPropertiesHUAWEI`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder {
    value: PhysicalDeviceSubpassShadingPropertiesHUAWEI,
}

impl PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder {
    #[inline]
    pub fn max_subpass_shading_workgroup_size_aspect_ratio(
        mut self,
        max_subpass_shading_workgroup_size_aspect_ratio: u32,
    ) -> Self {
        self.value.max_subpass_shading_workgroup_size_aspect_ratio =
            max_subpass_shading_workgroup_size_aspect_ratio;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSubpassShadingPropertiesHUAWEI {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder {
    type Target = PhysicalDeviceSubpassShadingPropertiesHUAWEI;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSubpassShadingPropertiesHUAWEIBuilder {
    type Target = PhysicalDeviceSubpassShadingPropertiesHUAWEI;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PhysicalDeviceSurfaceInfo2KHR`].
pub unsafe trait ExtendsPhysicalDeviceSurfaceInfo2KHR: fmt::Debug {}
unsafe impl ExtendsPhysicalDeviceSurfaceInfo2KHR for SurfaceFullScreenExclusiveInfoEXT {}
unsafe impl ExtendsPhysicalDeviceSurfaceInfo2KHR for SurfaceFullScreenExclusiveWin32InfoEXT {}

unsafe impl Cast for PhysicalDeviceSurfaceInfo2KHR {
    type Target = PhysicalDeviceSurfaceInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PhysicalDeviceSurfaceInfo2KHR {
    type Builder = PhysicalDeviceSurfaceInfo2KHRBuilder<'b>;
}

/// A builder for a [`PhysicalDeviceSurfaceInfo2KHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSurfaceInfo2KHRBuilder<'b> {
    value: PhysicalDeviceSurfaceInfo2KHR,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PhysicalDeviceSurfaceInfo2KHRBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPhysicalDeviceSurfaceInfo2KHR,
    {
        let next = (next.as_mut() as *mut T).cast::<PhysicalDeviceSurfaceInfo2KHR>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn surface(mut self, surface: SurfaceKHR) -> Self {
        self.value.surface = surface;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSurfaceInfo2KHR {
        self.value
    }
}

impl<'b> ops::Deref for PhysicalDeviceSurfaceInfo2KHRBuilder<'b> {
    type Target = PhysicalDeviceSurfaceInfo2KHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PhysicalDeviceSurfaceInfo2KHRBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PhysicalDeviceSurfaceInfo2KHRBuilder<'b> {
    type Target = PhysicalDeviceSurfaceInfo2KHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceSynchronization2FeaturesKHR {
    type Target = PhysicalDeviceSynchronization2FeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceSynchronization2FeaturesKHR {
    type Builder = PhysicalDeviceSynchronization2FeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceSynchronization2FeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceSynchronization2FeaturesKHRBuilder {
    value: PhysicalDeviceSynchronization2FeaturesKHR,
}

impl PhysicalDeviceSynchronization2FeaturesKHRBuilder {
    #[inline]
    pub fn synchronization2(mut self, synchronization2: bool) -> Self {
        self.value.synchronization2 = synchronization2 as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceSynchronization2FeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceSynchronization2FeaturesKHRBuilder {
    type Target = PhysicalDeviceSynchronization2FeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceSynchronization2FeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceSynchronization2FeaturesKHRBuilder {
    type Target = PhysicalDeviceSynchronization2FeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    type Target = PhysicalDeviceTexelBufferAlignmentFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    type Builder = PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceTexelBufferAlignmentFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder {
    value: PhysicalDeviceTexelBufferAlignmentFeaturesEXT,
}

impl PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder {
    #[inline]
    pub fn texel_buffer_alignment(mut self, texel_buffer_alignment: bool) -> Self {
        self.value.texel_buffer_alignment = texel_buffer_alignment as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder {
    type Target = PhysicalDeviceTexelBufferAlignmentFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTexelBufferAlignmentFeaturesEXTBuilder {
    type Target = PhysicalDeviceTexelBufferAlignmentFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTexelBufferAlignmentPropertiesEXT {
    type Target = PhysicalDeviceTexelBufferAlignmentPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTexelBufferAlignmentPropertiesEXT {
    type Builder = PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceTexelBufferAlignmentPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder {
    value: PhysicalDeviceTexelBufferAlignmentPropertiesEXT,
}

impl PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder {
    #[inline]
    pub fn storage_texel_buffer_offset_alignment_bytes(
        mut self,
        storage_texel_buffer_offset_alignment_bytes: DeviceSize,
    ) -> Self {
        self.value.storage_texel_buffer_offset_alignment_bytes =
            storage_texel_buffer_offset_alignment_bytes;
        self
    }

    #[inline]
    pub fn storage_texel_buffer_offset_single_texel_alignment(
        mut self,
        storage_texel_buffer_offset_single_texel_alignment: bool,
    ) -> Self {
        self.value
            .storage_texel_buffer_offset_single_texel_alignment =
            storage_texel_buffer_offset_single_texel_alignment as Bool32;
        self
    }

    #[inline]
    pub fn uniform_texel_buffer_offset_alignment_bytes(
        mut self,
        uniform_texel_buffer_offset_alignment_bytes: DeviceSize,
    ) -> Self {
        self.value.uniform_texel_buffer_offset_alignment_bytes =
            uniform_texel_buffer_offset_alignment_bytes;
        self
    }

    #[inline]
    pub fn uniform_texel_buffer_offset_single_texel_alignment(
        mut self,
        uniform_texel_buffer_offset_single_texel_alignment: bool,
    ) -> Self {
        self.value
            .uniform_texel_buffer_offset_single_texel_alignment =
            uniform_texel_buffer_offset_single_texel_alignment as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTexelBufferAlignmentPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder {
    type Target = PhysicalDeviceTexelBufferAlignmentPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTexelBufferAlignmentPropertiesEXTBuilder {
    type Target = PhysicalDeviceTexelBufferAlignmentPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    type Target = PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    type Builder = PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder {
    value: PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT,
}

impl PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder {
    #[inline]
    pub fn texture_compression_astc_hdr(mut self, texture_compression_astc_hdr: bool) -> Self {
        self.value.texture_compression_astc_hdr = texture_compression_astc_hdr as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder {
    type Target = PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXTBuilder {
    type Target = PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTimelineSemaphoreFeatures {
    type Target = PhysicalDeviceTimelineSemaphoreFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTimelineSemaphoreFeatures {
    type Builder = PhysicalDeviceTimelineSemaphoreFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceTimelineSemaphoreFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTimelineSemaphoreFeaturesBuilder {
    value: PhysicalDeviceTimelineSemaphoreFeatures,
}

impl PhysicalDeviceTimelineSemaphoreFeaturesBuilder {
    #[inline]
    pub fn timeline_semaphore(mut self, timeline_semaphore: bool) -> Self {
        self.value.timeline_semaphore = timeline_semaphore as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTimelineSemaphoreFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTimelineSemaphoreFeaturesBuilder {
    type Target = PhysicalDeviceTimelineSemaphoreFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTimelineSemaphoreFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTimelineSemaphoreFeaturesBuilder {
    type Target = PhysicalDeviceTimelineSemaphoreFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTimelineSemaphoreProperties {
    type Target = PhysicalDeviceTimelineSemaphoreProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTimelineSemaphoreProperties {
    type Builder = PhysicalDeviceTimelineSemaphorePropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceTimelineSemaphoreProperties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTimelineSemaphorePropertiesBuilder {
    value: PhysicalDeviceTimelineSemaphoreProperties,
}

impl PhysicalDeviceTimelineSemaphorePropertiesBuilder {
    #[inline]
    pub fn max_timeline_semaphore_value_difference(
        mut self,
        max_timeline_semaphore_value_difference: u64,
    ) -> Self {
        self.value.max_timeline_semaphore_value_difference =
            max_timeline_semaphore_value_difference;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTimelineSemaphoreProperties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTimelineSemaphorePropertiesBuilder {
    type Target = PhysicalDeviceTimelineSemaphoreProperties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTimelineSemaphorePropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTimelineSemaphorePropertiesBuilder {
    type Target = PhysicalDeviceTimelineSemaphoreProperties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceToolPropertiesEXT {
    type Target = PhysicalDeviceToolPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceToolPropertiesEXT {
    type Builder = PhysicalDeviceToolPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceToolPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceToolPropertiesEXTBuilder {
    value: PhysicalDeviceToolPropertiesEXT,
}

impl PhysicalDeviceToolPropertiesEXTBuilder {
    #[inline]
    pub fn name(mut self, name: impl Into<StringArray<MAX_EXTENSION_NAME_SIZE>>) -> Self {
        self.value.name = name.into();
        self
    }

    #[inline]
    pub fn version(mut self, version: impl Into<StringArray<MAX_EXTENSION_NAME_SIZE>>) -> Self {
        self.value.version = version.into();
        self
    }

    #[inline]
    pub fn purposes(mut self, purposes: ToolPurposeFlagsEXT) -> Self {
        self.value.purposes = purposes;
        self
    }

    #[inline]
    pub fn description(
        mut self,
        description: impl Into<StringArray<MAX_DESCRIPTION_SIZE>>,
    ) -> Self {
        self.value.description = description.into();
        self
    }

    #[inline]
    pub fn layer(mut self, layer: impl Into<StringArray<MAX_EXTENSION_NAME_SIZE>>) -> Self {
        self.value.layer = layer.into();
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceToolPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceToolPropertiesEXTBuilder {
    type Target = PhysicalDeviceToolPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceToolPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceToolPropertiesEXTBuilder {
    type Target = PhysicalDeviceToolPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTransformFeedbackFeaturesEXT {
    type Target = PhysicalDeviceTransformFeedbackFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTransformFeedbackFeaturesEXT {
    type Builder = PhysicalDeviceTransformFeedbackFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceTransformFeedbackFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTransformFeedbackFeaturesEXTBuilder {
    value: PhysicalDeviceTransformFeedbackFeaturesEXT,
}

impl PhysicalDeviceTransformFeedbackFeaturesEXTBuilder {
    #[inline]
    pub fn transform_feedback(mut self, transform_feedback: bool) -> Self {
        self.value.transform_feedback = transform_feedback as Bool32;
        self
    }

    #[inline]
    pub fn geometry_streams(mut self, geometry_streams: bool) -> Self {
        self.value.geometry_streams = geometry_streams as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTransformFeedbackFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTransformFeedbackFeaturesEXTBuilder {
    type Target = PhysicalDeviceTransformFeedbackFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTransformFeedbackFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTransformFeedbackFeaturesEXTBuilder {
    type Target = PhysicalDeviceTransformFeedbackFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceTransformFeedbackPropertiesEXT {
    type Target = PhysicalDeviceTransformFeedbackPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceTransformFeedbackPropertiesEXT {
    type Builder = PhysicalDeviceTransformFeedbackPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceTransformFeedbackPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceTransformFeedbackPropertiesEXTBuilder {
    value: PhysicalDeviceTransformFeedbackPropertiesEXT,
}

impl PhysicalDeviceTransformFeedbackPropertiesEXTBuilder {
    #[inline]
    pub fn max_transform_feedback_streams(mut self, max_transform_feedback_streams: u32) -> Self {
        self.value.max_transform_feedback_streams = max_transform_feedback_streams;
        self
    }

    #[inline]
    pub fn max_transform_feedback_buffers(mut self, max_transform_feedback_buffers: u32) -> Self {
        self.value.max_transform_feedback_buffers = max_transform_feedback_buffers;
        self
    }

    #[inline]
    pub fn max_transform_feedback_buffer_size(
        mut self,
        max_transform_feedback_buffer_size: DeviceSize,
    ) -> Self {
        self.value.max_transform_feedback_buffer_size = max_transform_feedback_buffer_size;
        self
    }

    #[inline]
    pub fn max_transform_feedback_stream_data_size(
        mut self,
        max_transform_feedback_stream_data_size: u32,
    ) -> Self {
        self.value.max_transform_feedback_stream_data_size =
            max_transform_feedback_stream_data_size;
        self
    }

    #[inline]
    pub fn max_transform_feedback_buffer_data_size(
        mut self,
        max_transform_feedback_buffer_data_size: u32,
    ) -> Self {
        self.value.max_transform_feedback_buffer_data_size =
            max_transform_feedback_buffer_data_size;
        self
    }

    #[inline]
    pub fn max_transform_feedback_buffer_data_stride(
        mut self,
        max_transform_feedback_buffer_data_stride: u32,
    ) -> Self {
        self.value.max_transform_feedback_buffer_data_stride =
            max_transform_feedback_buffer_data_stride;
        self
    }

    #[inline]
    pub fn transform_feedback_queries(mut self, transform_feedback_queries: bool) -> Self {
        self.value.transform_feedback_queries = transform_feedback_queries as Bool32;
        self
    }

    #[inline]
    pub fn transform_feedback_streams_lines_triangles(
        mut self,
        transform_feedback_streams_lines_triangles: bool,
    ) -> Self {
        self.value.transform_feedback_streams_lines_triangles =
            transform_feedback_streams_lines_triangles as Bool32;
        self
    }

    #[inline]
    pub fn transform_feedback_rasterization_stream_select(
        mut self,
        transform_feedback_rasterization_stream_select: bool,
    ) -> Self {
        self.value.transform_feedback_rasterization_stream_select =
            transform_feedback_rasterization_stream_select as Bool32;
        self
    }

    #[inline]
    pub fn transform_feedback_draw(mut self, transform_feedback_draw: bool) -> Self {
        self.value.transform_feedback_draw = transform_feedback_draw as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceTransformFeedbackPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceTransformFeedbackPropertiesEXTBuilder {
    type Target = PhysicalDeviceTransformFeedbackPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceTransformFeedbackPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceTransformFeedbackPropertiesEXTBuilder {
    type Target = PhysicalDeviceTransformFeedbackPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceUniformBufferStandardLayoutFeatures {
    type Target = PhysicalDeviceUniformBufferStandardLayoutFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceUniformBufferStandardLayoutFeatures {
    type Builder = PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceUniformBufferStandardLayoutFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder {
    value: PhysicalDeviceUniformBufferStandardLayoutFeatures,
}

impl PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder {
    #[inline]
    pub fn uniform_buffer_standard_layout(mut self, uniform_buffer_standard_layout: bool) -> Self {
        self.value.uniform_buffer_standard_layout = uniform_buffer_standard_layout as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceUniformBufferStandardLayoutFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder {
    type Target = PhysicalDeviceUniformBufferStandardLayoutFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceUniformBufferStandardLayoutFeaturesBuilder {
    type Target = PhysicalDeviceUniformBufferStandardLayoutFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVariablePointersFeatures {
    type Target = PhysicalDeviceVariablePointersFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVariablePointersFeatures {
    type Builder = PhysicalDeviceVariablePointersFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceVariablePointersFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVariablePointersFeaturesBuilder {
    value: PhysicalDeviceVariablePointersFeatures,
}

impl PhysicalDeviceVariablePointersFeaturesBuilder {
    #[inline]
    pub fn variable_pointers_storage_buffer(
        mut self,
        variable_pointers_storage_buffer: bool,
    ) -> Self {
        self.value.variable_pointers_storage_buffer = variable_pointers_storage_buffer as Bool32;
        self
    }

    #[inline]
    pub fn variable_pointers(mut self, variable_pointers: bool) -> Self {
        self.value.variable_pointers = variable_pointers as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVariablePointersFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVariablePointersFeaturesBuilder {
    type Target = PhysicalDeviceVariablePointersFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVariablePointersFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVariablePointersFeaturesBuilder {
    type Target = PhysicalDeviceVariablePointersFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    type Target = PhysicalDeviceVertexAttributeDivisorFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    type Builder = PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceVertexAttributeDivisorFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder {
    value: PhysicalDeviceVertexAttributeDivisorFeaturesEXT,
}

impl PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder {
    #[inline]
    pub fn vertex_attribute_instance_rate_divisor(
        mut self,
        vertex_attribute_instance_rate_divisor: bool,
    ) -> Self {
        self.value.vertex_attribute_instance_rate_divisor =
            vertex_attribute_instance_rate_divisor as Bool32;
        self
    }

    #[inline]
    pub fn vertex_attribute_instance_rate_zero_divisor(
        mut self,
        vertex_attribute_instance_rate_zero_divisor: bool,
    ) -> Self {
        self.value.vertex_attribute_instance_rate_zero_divisor =
            vertex_attribute_instance_rate_zero_divisor as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder {
    type Target = PhysicalDeviceVertexAttributeDivisorFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexAttributeDivisorFeaturesEXTBuilder {
    type Target = PhysicalDeviceVertexAttributeDivisorFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    type Target = PhysicalDeviceVertexAttributeDivisorPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    type Builder = PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceVertexAttributeDivisorPropertiesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder {
    value: PhysicalDeviceVertexAttributeDivisorPropertiesEXT,
}

impl PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder {
    #[inline]
    pub fn max_vertex_attrib_divisor(mut self, max_vertex_attrib_divisor: u32) -> Self {
        self.value.max_vertex_attrib_divisor = max_vertex_attrib_divisor;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder {
    type Target = PhysicalDeviceVertexAttributeDivisorPropertiesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexAttributeDivisorPropertiesEXTBuilder {
    type Target = PhysicalDeviceVertexAttributeDivisorPropertiesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    type Target = PhysicalDeviceVertexInputDynamicStateFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    type Builder = PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceVertexInputDynamicStateFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder {
    value: PhysicalDeviceVertexInputDynamicStateFeaturesEXT,
}

impl PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder {
    #[inline]
    pub fn vertex_input_dynamic_state(mut self, vertex_input_dynamic_state: bool) -> Self {
        self.value.vertex_input_dynamic_state = vertex_input_dynamic_state as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder {
    type Target = PhysicalDeviceVertexInputDynamicStateFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVertexInputDynamicStateFeaturesEXTBuilder {
    type Target = PhysicalDeviceVertexInputDynamicStateFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan11Features {
    type Target = PhysicalDeviceVulkan11Features;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVulkan11Features {
    type Builder = PhysicalDeviceVulkan11FeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceVulkan11Features`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVulkan11FeaturesBuilder {
    value: PhysicalDeviceVulkan11Features,
}

impl PhysicalDeviceVulkan11FeaturesBuilder {
    #[inline]
    pub fn storage_buffer_16bit_access(mut self, storage_buffer_16bit_access: bool) -> Self {
        self.value.storage_buffer_16bit_access = storage_buffer_16bit_access as Bool32;
        self
    }

    #[inline]
    pub fn uniform_and_storage_buffer_16bit_access(
        mut self,
        uniform_and_storage_buffer_16bit_access: bool,
    ) -> Self {
        self.value.uniform_and_storage_buffer_16bit_access =
            uniform_and_storage_buffer_16bit_access as Bool32;
        self
    }

    #[inline]
    pub fn storage_push_constant16(mut self, storage_push_constant16: bool) -> Self {
        self.value.storage_push_constant16 = storage_push_constant16 as Bool32;
        self
    }

    #[inline]
    pub fn storage_input_output16(mut self, storage_input_output16: bool) -> Self {
        self.value.storage_input_output16 = storage_input_output16 as Bool32;
        self
    }

    #[inline]
    pub fn multiview(mut self, multiview: bool) -> Self {
        self.value.multiview = multiview as Bool32;
        self
    }

    #[inline]
    pub fn multiview_geometry_shader(mut self, multiview_geometry_shader: bool) -> Self {
        self.value.multiview_geometry_shader = multiview_geometry_shader as Bool32;
        self
    }

    #[inline]
    pub fn multiview_tessellation_shader(mut self, multiview_tessellation_shader: bool) -> Self {
        self.value.multiview_tessellation_shader = multiview_tessellation_shader as Bool32;
        self
    }

    #[inline]
    pub fn variable_pointers_storage_buffer(
        mut self,
        variable_pointers_storage_buffer: bool,
    ) -> Self {
        self.value.variable_pointers_storage_buffer = variable_pointers_storage_buffer as Bool32;
        self
    }

    #[inline]
    pub fn variable_pointers(mut self, variable_pointers: bool) -> Self {
        self.value.variable_pointers = variable_pointers as Bool32;
        self
    }

    #[inline]
    pub fn protected_memory(mut self, protected_memory: bool) -> Self {
        self.value.protected_memory = protected_memory as Bool32;
        self
    }

    #[inline]
    pub fn sampler_ycbcr_conversion(mut self, sampler_ycbcr_conversion: bool) -> Self {
        self.value.sampler_ycbcr_conversion = sampler_ycbcr_conversion as Bool32;
        self
    }

    #[inline]
    pub fn shader_draw_parameters(mut self, shader_draw_parameters: bool) -> Self {
        self.value.shader_draw_parameters = shader_draw_parameters as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVulkan11Features {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVulkan11FeaturesBuilder {
    type Target = PhysicalDeviceVulkan11Features;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVulkan11FeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan11FeaturesBuilder {
    type Target = PhysicalDeviceVulkan11Features;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan11Properties {
    type Target = PhysicalDeviceVulkan11Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVulkan11Properties {
    type Builder = PhysicalDeviceVulkan11PropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceVulkan11Properties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVulkan11PropertiesBuilder {
    value: PhysicalDeviceVulkan11Properties,
}

impl PhysicalDeviceVulkan11PropertiesBuilder {
    #[inline]
    pub fn device_uuid(mut self, device_uuid: impl Into<ByteArray<UUID_SIZE>>) -> Self {
        self.value.device_uuid = device_uuid.into();
        self
    }

    #[inline]
    pub fn driver_uuid(mut self, driver_uuid: impl Into<ByteArray<UUID_SIZE>>) -> Self {
        self.value.driver_uuid = driver_uuid.into();
        self
    }

    #[inline]
    pub fn device_luid(mut self, device_luid: impl Into<ByteArray<LUID_SIZE>>) -> Self {
        self.value.device_luid = device_luid.into();
        self
    }

    #[inline]
    pub fn device_node_mask(mut self, device_node_mask: u32) -> Self {
        self.value.device_node_mask = device_node_mask;
        self
    }

    #[inline]
    pub fn device_luid_valid(mut self, device_luid_valid: bool) -> Self {
        self.value.device_luid_valid = device_luid_valid as Bool32;
        self
    }

    #[inline]
    pub fn subgroup_size(mut self, subgroup_size: u32) -> Self {
        self.value.subgroup_size = subgroup_size;
        self
    }

    #[inline]
    pub fn subgroup_supported_stages(
        mut self,
        subgroup_supported_stages: ShaderStageFlags,
    ) -> Self {
        self.value.subgroup_supported_stages = subgroup_supported_stages;
        self
    }

    #[inline]
    pub fn subgroup_supported_operations(
        mut self,
        subgroup_supported_operations: SubgroupFeatureFlags,
    ) -> Self {
        self.value.subgroup_supported_operations = subgroup_supported_operations;
        self
    }

    #[inline]
    pub fn subgroup_quad_operations_in_all_stages(
        mut self,
        subgroup_quad_operations_in_all_stages: bool,
    ) -> Self {
        self.value.subgroup_quad_operations_in_all_stages =
            subgroup_quad_operations_in_all_stages as Bool32;
        self
    }

    #[inline]
    pub fn point_clipping_behavior(
        mut self,
        point_clipping_behavior: PointClippingBehavior,
    ) -> Self {
        self.value.point_clipping_behavior = point_clipping_behavior;
        self
    }

    #[inline]
    pub fn max_multiview_view_count(mut self, max_multiview_view_count: u32) -> Self {
        self.value.max_multiview_view_count = max_multiview_view_count;
        self
    }

    #[inline]
    pub fn max_multiview_instance_index(mut self, max_multiview_instance_index: u32) -> Self {
        self.value.max_multiview_instance_index = max_multiview_instance_index;
        self
    }

    #[inline]
    pub fn protected_no_fault(mut self, protected_no_fault: bool) -> Self {
        self.value.protected_no_fault = protected_no_fault as Bool32;
        self
    }

    #[inline]
    pub fn max_per_set_descriptors(mut self, max_per_set_descriptors: u32) -> Self {
        self.value.max_per_set_descriptors = max_per_set_descriptors;
        self
    }

    #[inline]
    pub fn max_memory_allocation_size(mut self, max_memory_allocation_size: DeviceSize) -> Self {
        self.value.max_memory_allocation_size = max_memory_allocation_size;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVulkan11Properties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVulkan11PropertiesBuilder {
    type Target = PhysicalDeviceVulkan11Properties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVulkan11PropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan11PropertiesBuilder {
    type Target = PhysicalDeviceVulkan11Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan12Features {
    type Target = PhysicalDeviceVulkan12Features;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVulkan12Features {
    type Builder = PhysicalDeviceVulkan12FeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceVulkan12Features`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVulkan12FeaturesBuilder {
    value: PhysicalDeviceVulkan12Features,
}

impl PhysicalDeviceVulkan12FeaturesBuilder {
    #[inline]
    pub fn sampler_mirror_clamp_to_edge(mut self, sampler_mirror_clamp_to_edge: bool) -> Self {
        self.value.sampler_mirror_clamp_to_edge = sampler_mirror_clamp_to_edge as Bool32;
        self
    }

    #[inline]
    pub fn draw_indirect_count(mut self, draw_indirect_count: bool) -> Self {
        self.value.draw_indirect_count = draw_indirect_count as Bool32;
        self
    }

    #[inline]
    pub fn storage_buffer_8bit_access(mut self, storage_buffer_8bit_access: bool) -> Self {
        self.value.storage_buffer_8bit_access = storage_buffer_8bit_access as Bool32;
        self
    }

    #[inline]
    pub fn uniform_and_storage_buffer_8bit_access(
        mut self,
        uniform_and_storage_buffer_8bit_access: bool,
    ) -> Self {
        self.value.uniform_and_storage_buffer_8bit_access =
            uniform_and_storage_buffer_8bit_access as Bool32;
        self
    }

    #[inline]
    pub fn storage_push_constant8(mut self, storage_push_constant8: bool) -> Self {
        self.value.storage_push_constant8 = storage_push_constant8 as Bool32;
        self
    }

    #[inline]
    pub fn shader_buffer_int64_atomics(mut self, shader_buffer_int64_atomics: bool) -> Self {
        self.value.shader_buffer_int64_atomics = shader_buffer_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_shared_int64_atomics(mut self, shader_shared_int64_atomics: bool) -> Self {
        self.value.shader_shared_int64_atomics = shader_shared_int64_atomics as Bool32;
        self
    }

    #[inline]
    pub fn shader_float16(mut self, shader_float16: bool) -> Self {
        self.value.shader_float16 = shader_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_int8(mut self, shader_int8: bool) -> Self {
        self.value.shader_int8 = shader_int8 as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_indexing(mut self, descriptor_indexing: bool) -> Self {
        self.value.descriptor_indexing = descriptor_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_input_attachment_array_dynamic_indexing(
        mut self,
        shader_input_attachment_array_dynamic_indexing: bool,
    ) -> Self {
        self.value.shader_input_attachment_array_dynamic_indexing =
            shader_input_attachment_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value
            .shader_uniform_texel_buffer_array_dynamic_indexing =
            shader_uniform_texel_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.value
            .shader_storage_texel_buffer_array_dynamic_indexing =
            shader_storage_texel_buffer_array_dynamic_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_uniform_buffer_array_non_uniform_indexing =
            shader_uniform_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing(
        mut self,
        shader_sampled_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_sampled_image_array_non_uniform_indexing =
            shader_sampled_image_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_storage_buffer_array_non_uniform_indexing =
            shader_storage_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing(
        mut self,
        shader_storage_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value.shader_storage_image_array_non_uniform_indexing =
            shader_storage_image_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing(
        mut self,
        shader_input_attachment_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_input_attachment_array_non_uniform_indexing =
            shader_input_attachment_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_uniform_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_uniform_texel_buffer_array_non_uniform_indexing =
            shader_uniform_texel_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.value
            .shader_storage_texel_buffer_array_non_uniform_indexing =
            shader_storage_texel_buffer_array_non_uniform_indexing as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_uniform_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_uniform_buffer_update_after_bind =
            descriptor_binding_uniform_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_sampled_image_update_after_bind(
        mut self,
        descriptor_binding_sampled_image_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_sampled_image_update_after_bind =
            descriptor_binding_sampled_image_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_image_update_after_bind(
        mut self,
        descriptor_binding_storage_image_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_image_update_after_bind =
            descriptor_binding_storage_image_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_buffer_update_after_bind =
            descriptor_binding_storage_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_uniform_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_uniform_texel_buffer_update_after_bind =
            descriptor_binding_uniform_texel_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_storage_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.value
            .descriptor_binding_storage_texel_buffer_update_after_bind =
            descriptor_binding_storage_texel_buffer_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_update_unused_while_pending(
        mut self,
        descriptor_binding_update_unused_while_pending: bool,
    ) -> Self {
        self.value.descriptor_binding_update_unused_while_pending =
            descriptor_binding_update_unused_while_pending as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_partially_bound(
        mut self,
        descriptor_binding_partially_bound: bool,
    ) -> Self {
        self.value.descriptor_binding_partially_bound =
            descriptor_binding_partially_bound as Bool32;
        self
    }

    #[inline]
    pub fn descriptor_binding_variable_descriptor_count(
        mut self,
        descriptor_binding_variable_descriptor_count: bool,
    ) -> Self {
        self.value.descriptor_binding_variable_descriptor_count =
            descriptor_binding_variable_descriptor_count as Bool32;
        self
    }

    #[inline]
    pub fn runtime_descriptor_array(mut self, runtime_descriptor_array: bool) -> Self {
        self.value.runtime_descriptor_array = runtime_descriptor_array as Bool32;
        self
    }

    #[inline]
    pub fn sampler_filter_minmax(mut self, sampler_filter_minmax: bool) -> Self {
        self.value.sampler_filter_minmax = sampler_filter_minmax as Bool32;
        self
    }

    #[inline]
    pub fn scalar_block_layout(mut self, scalar_block_layout: bool) -> Self {
        self.value.scalar_block_layout = scalar_block_layout as Bool32;
        self
    }

    #[inline]
    pub fn imageless_framebuffer(mut self, imageless_framebuffer: bool) -> Self {
        self.value.imageless_framebuffer = imageless_framebuffer as Bool32;
        self
    }

    #[inline]
    pub fn uniform_buffer_standard_layout(mut self, uniform_buffer_standard_layout: bool) -> Self {
        self.value.uniform_buffer_standard_layout = uniform_buffer_standard_layout as Bool32;
        self
    }

    #[inline]
    pub fn shader_subgroup_extended_types(mut self, shader_subgroup_extended_types: bool) -> Self {
        self.value.shader_subgroup_extended_types = shader_subgroup_extended_types as Bool32;
        self
    }

    #[inline]
    pub fn separate_depth_stencil_layouts(mut self, separate_depth_stencil_layouts: bool) -> Self {
        self.value.separate_depth_stencil_layouts = separate_depth_stencil_layouts as Bool32;
        self
    }

    #[inline]
    pub fn host_query_reset(mut self, host_query_reset: bool) -> Self {
        self.value.host_query_reset = host_query_reset as Bool32;
        self
    }

    #[inline]
    pub fn timeline_semaphore(mut self, timeline_semaphore: bool) -> Self {
        self.value.timeline_semaphore = timeline_semaphore as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address(mut self, buffer_device_address: bool) -> Self {
        self.value.buffer_device_address = buffer_device_address as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_capture_replay(
        mut self,
        buffer_device_address_capture_replay: bool,
    ) -> Self {
        self.value.buffer_device_address_capture_replay =
            buffer_device_address_capture_replay as Bool32;
        self
    }

    #[inline]
    pub fn buffer_device_address_multi_device(
        mut self,
        buffer_device_address_multi_device: bool,
    ) -> Self {
        self.value.buffer_device_address_multi_device =
            buffer_device_address_multi_device as Bool32;
        self
    }

    #[inline]
    pub fn vulkan_memory_model(mut self, vulkan_memory_model: bool) -> Self {
        self.value.vulkan_memory_model = vulkan_memory_model as Bool32;
        self
    }

    #[inline]
    pub fn vulkan_memory_model_device_scope(
        mut self,
        vulkan_memory_model_device_scope: bool,
    ) -> Self {
        self.value.vulkan_memory_model_device_scope = vulkan_memory_model_device_scope as Bool32;
        self
    }

    #[inline]
    pub fn vulkan_memory_model_availability_visibility_chains(
        mut self,
        vulkan_memory_model_availability_visibility_chains: bool,
    ) -> Self {
        self.value
            .vulkan_memory_model_availability_visibility_chains =
            vulkan_memory_model_availability_visibility_chains as Bool32;
        self
    }

    #[inline]
    pub fn shader_output_viewport_index(mut self, shader_output_viewport_index: bool) -> Self {
        self.value.shader_output_viewport_index = shader_output_viewport_index as Bool32;
        self
    }

    #[inline]
    pub fn shader_output_layer(mut self, shader_output_layer: bool) -> Self {
        self.value.shader_output_layer = shader_output_layer as Bool32;
        self
    }

    #[inline]
    pub fn subgroup_broadcast_dynamic_id(mut self, subgroup_broadcast_dynamic_id: bool) -> Self {
        self.value.subgroup_broadcast_dynamic_id = subgroup_broadcast_dynamic_id as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVulkan12Features {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVulkan12FeaturesBuilder {
    type Target = PhysicalDeviceVulkan12Features;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVulkan12FeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan12FeaturesBuilder {
    type Target = PhysicalDeviceVulkan12Features;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan12Properties {
    type Target = PhysicalDeviceVulkan12Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVulkan12Properties {
    type Builder = PhysicalDeviceVulkan12PropertiesBuilder;
}

/// A builder for a [`PhysicalDeviceVulkan12Properties`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVulkan12PropertiesBuilder {
    value: PhysicalDeviceVulkan12Properties,
}

impl PhysicalDeviceVulkan12PropertiesBuilder {
    #[inline]
    pub fn driver_id(mut self, driver_id: DriverId) -> Self {
        self.value.driver_id = driver_id;
        self
    }

    #[inline]
    pub fn driver_name(
        mut self,
        driver_name: impl Into<StringArray<MAX_DRIVER_NAME_SIZE>>,
    ) -> Self {
        self.value.driver_name = driver_name.into();
        self
    }

    #[inline]
    pub fn driver_info(
        mut self,
        driver_info: impl Into<StringArray<MAX_DRIVER_INFO_SIZE>>,
    ) -> Self {
        self.value.driver_info = driver_info.into();
        self
    }

    #[inline]
    pub fn conformance_version(
        mut self,
        conformance_version: impl Cast<Target = ConformanceVersion>,
    ) -> Self {
        self.value.conformance_version = conformance_version.into();
        self
    }

    #[inline]
    pub fn denorm_behavior_independence(
        mut self,
        denorm_behavior_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.value.denorm_behavior_independence = denorm_behavior_independence;
        self
    }

    #[inline]
    pub fn rounding_mode_independence(
        mut self,
        rounding_mode_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.value.rounding_mode_independence = rounding_mode_independence;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float16(
        mut self,
        shader_signed_zero_inf_nan_preserve_float16: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float16 =
            shader_signed_zero_inf_nan_preserve_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float32(
        mut self,
        shader_signed_zero_inf_nan_preserve_float32: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float32 =
            shader_signed_zero_inf_nan_preserve_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float64(
        mut self,
        shader_signed_zero_inf_nan_preserve_float64: bool,
    ) -> Self {
        self.value.shader_signed_zero_inf_nan_preserve_float64 =
            shader_signed_zero_inf_nan_preserve_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float16(mut self, shader_denorm_preserve_float16: bool) -> Self {
        self.value.shader_denorm_preserve_float16 = shader_denorm_preserve_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float32(mut self, shader_denorm_preserve_float32: bool) -> Self {
        self.value.shader_denorm_preserve_float32 = shader_denorm_preserve_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_preserve_float64(mut self, shader_denorm_preserve_float64: bool) -> Self {
        self.value.shader_denorm_preserve_float64 = shader_denorm_preserve_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float16(
        mut self,
        shader_denorm_flush_to_zero_float16: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float16 =
            shader_denorm_flush_to_zero_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float32(
        mut self,
        shader_denorm_flush_to_zero_float32: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float32 =
            shader_denorm_flush_to_zero_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_denorm_flush_to_zero_float64(
        mut self,
        shader_denorm_flush_to_zero_float64: bool,
    ) -> Self {
        self.value.shader_denorm_flush_to_zero_float64 =
            shader_denorm_flush_to_zero_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float16(
        mut self,
        shader_rounding_mode_rte_float16: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float16 = shader_rounding_mode_rte_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float32(
        mut self,
        shader_rounding_mode_rte_float32: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float32 = shader_rounding_mode_rte_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rte_float64(
        mut self,
        shader_rounding_mode_rte_float64: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rte_float64 = shader_rounding_mode_rte_float64 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float16(
        mut self,
        shader_rounding_mode_rtz_float16: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float16 = shader_rounding_mode_rtz_float16 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float32(
        mut self,
        shader_rounding_mode_rtz_float32: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float32 = shader_rounding_mode_rtz_float32 as Bool32;
        self
    }

    #[inline]
    pub fn shader_rounding_mode_rtz_float64(
        mut self,
        shader_rounding_mode_rtz_float64: bool,
    ) -> Self {
        self.value.shader_rounding_mode_rtz_float64 = shader_rounding_mode_rtz_float64 as Bool32;
        self
    }

    #[inline]
    pub fn max_update_after_bind_descriptors_in_all_pools(
        mut self,
        max_update_after_bind_descriptors_in_all_pools: u32,
    ) -> Self {
        self.value.max_update_after_bind_descriptors_in_all_pools =
            max_update_after_bind_descriptors_in_all_pools;
        self
    }

    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_uniform_buffer_array_non_uniform_indexing_native =
            shader_uniform_buffer_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing_native(
        mut self,
        shader_sampled_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_sampled_image_array_non_uniform_indexing_native =
            shader_sampled_image_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_storage_buffer_array_non_uniform_indexing_native =
            shader_storage_buffer_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing_native(
        mut self,
        shader_storage_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_storage_image_array_non_uniform_indexing_native =
            shader_storage_image_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing_native(
        mut self,
        shader_input_attachment_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.value
            .shader_input_attachment_array_non_uniform_indexing_native =
            shader_input_attachment_array_non_uniform_indexing_native as Bool32;
        self
    }

    #[inline]
    pub fn robust_buffer_access_update_after_bind(
        mut self,
        robust_buffer_access_update_after_bind: bool,
    ) -> Self {
        self.value.robust_buffer_access_update_after_bind =
            robust_buffer_access_update_after_bind as Bool32;
        self
    }

    #[inline]
    pub fn quad_divergent_implicit_lod(mut self, quad_divergent_implicit_lod: bool) -> Self {
        self.value.quad_divergent_implicit_lod = quad_divergent_implicit_lod as Bool32;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_samplers(
        mut self,
        max_per_stage_descriptor_update_after_bind_samplers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_samplers =
            max_per_stage_descriptor_update_after_bind_samplers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_uniform_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_uniform_buffers =
            max_per_stage_descriptor_update_after_bind_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_storage_buffers =
            max_per_stage_descriptor_update_after_bind_storage_buffers;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_sampled_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_sampled_images =
            max_per_stage_descriptor_update_after_bind_sampled_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_images: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_storage_images =
            max_per_stage_descriptor_update_after_bind_storage_images;
        self
    }

    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_input_attachments(
        mut self,
        max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.value
            .max_per_stage_descriptor_update_after_bind_input_attachments =
            max_per_stage_descriptor_update_after_bind_input_attachments;
        self
    }

    #[inline]
    pub fn max_per_stage_update_after_bind_resources(
        mut self,
        max_per_stage_update_after_bind_resources: u32,
    ) -> Self {
        self.value.max_per_stage_update_after_bind_resources =
            max_per_stage_update_after_bind_resources;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_samplers(
        mut self,
        max_descriptor_set_update_after_bind_samplers: u32,
    ) -> Self {
        self.value.max_descriptor_set_update_after_bind_samplers =
            max_descriptor_set_update_after_bind_samplers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_uniform_buffers =
            max_descriptor_set_update_after_bind_uniform_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_uniform_buffers_dynamic =
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_buffers =
            max_descriptor_set_update_after_bind_storage_buffers;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_buffers_dynamic =
            max_descriptor_set_update_after_bind_storage_buffers_dynamic;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_sampled_images(
        mut self,
        max_descriptor_set_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_sampled_images =
            max_descriptor_set_update_after_bind_sampled_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_images(
        mut self,
        max_descriptor_set_update_after_bind_storage_images: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_storage_images =
            max_descriptor_set_update_after_bind_storage_images;
        self
    }

    #[inline]
    pub fn max_descriptor_set_update_after_bind_input_attachments(
        mut self,
        max_descriptor_set_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.value
            .max_descriptor_set_update_after_bind_input_attachments =
            max_descriptor_set_update_after_bind_input_attachments;
        self
    }

    #[inline]
    pub fn supported_depth_resolve_modes(
        mut self,
        supported_depth_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.value.supported_depth_resolve_modes = supported_depth_resolve_modes;
        self
    }

    #[inline]
    pub fn supported_stencil_resolve_modes(
        mut self,
        supported_stencil_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.value.supported_stencil_resolve_modes = supported_stencil_resolve_modes;
        self
    }

    #[inline]
    pub fn independent_resolve_none(mut self, independent_resolve_none: bool) -> Self {
        self.value.independent_resolve_none = independent_resolve_none as Bool32;
        self
    }

    #[inline]
    pub fn independent_resolve(mut self, independent_resolve: bool) -> Self {
        self.value.independent_resolve = independent_resolve as Bool32;
        self
    }

    #[inline]
    pub fn filter_minmax_single_component_formats(
        mut self,
        filter_minmax_single_component_formats: bool,
    ) -> Self {
        self.value.filter_minmax_single_component_formats =
            filter_minmax_single_component_formats as Bool32;
        self
    }

    #[inline]
    pub fn filter_minmax_image_component_mapping(
        mut self,
        filter_minmax_image_component_mapping: bool,
    ) -> Self {
        self.value.filter_minmax_image_component_mapping =
            filter_minmax_image_component_mapping as Bool32;
        self
    }

    #[inline]
    pub fn max_timeline_semaphore_value_difference(
        mut self,
        max_timeline_semaphore_value_difference: u64,
    ) -> Self {
        self.value.max_timeline_semaphore_value_difference =
            max_timeline_semaphore_value_difference;
        self
    }

    #[inline]
    pub fn framebuffer_integer_color_sample_counts(
        mut self,
        framebuffer_integer_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.value.framebuffer_integer_color_sample_counts =
            framebuffer_integer_color_sample_counts;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVulkan12Properties {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVulkan12PropertiesBuilder {
    type Target = PhysicalDeviceVulkan12Properties;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVulkan12PropertiesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkan12PropertiesBuilder {
    type Target = PhysicalDeviceVulkan12Properties;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkanMemoryModelFeatures {
    type Target = PhysicalDeviceVulkanMemoryModelFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceVulkanMemoryModelFeatures {
    type Builder = PhysicalDeviceVulkanMemoryModelFeaturesBuilder;
}

/// A builder for a [`PhysicalDeviceVulkanMemoryModelFeatures`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceVulkanMemoryModelFeaturesBuilder {
    value: PhysicalDeviceVulkanMemoryModelFeatures,
}

impl PhysicalDeviceVulkanMemoryModelFeaturesBuilder {
    #[inline]
    pub fn vulkan_memory_model(mut self, vulkan_memory_model: bool) -> Self {
        self.value.vulkan_memory_model = vulkan_memory_model as Bool32;
        self
    }

    #[inline]
    pub fn vulkan_memory_model_device_scope(
        mut self,
        vulkan_memory_model_device_scope: bool,
    ) -> Self {
        self.value.vulkan_memory_model_device_scope = vulkan_memory_model_device_scope as Bool32;
        self
    }

    #[inline]
    pub fn vulkan_memory_model_availability_visibility_chains(
        mut self,
        vulkan_memory_model_availability_visibility_chains: bool,
    ) -> Self {
        self.value
            .vulkan_memory_model_availability_visibility_chains =
            vulkan_memory_model_availability_visibility_chains as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceVulkanMemoryModelFeatures {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceVulkanMemoryModelFeaturesBuilder {
    type Target = PhysicalDeviceVulkanMemoryModelFeatures;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceVulkanMemoryModelFeaturesBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceVulkanMemoryModelFeaturesBuilder {
    type Target = PhysicalDeviceVulkanMemoryModelFeatures;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    type Target = PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    type Builder = PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder {
    value: PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR,
}

impl PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder {
    #[inline]
    pub fn workgroup_memory_explicit_layout(
        mut self,
        workgroup_memory_explicit_layout: bool,
    ) -> Self {
        self.value.workgroup_memory_explicit_layout = workgroup_memory_explicit_layout as Bool32;
        self
    }

    #[inline]
    pub fn workgroup_memory_explicit_layout_scalar_block_layout(
        mut self,
        workgroup_memory_explicit_layout_scalar_block_layout: bool,
    ) -> Self {
        self.value
            .workgroup_memory_explicit_layout_scalar_block_layout =
            workgroup_memory_explicit_layout_scalar_block_layout as Bool32;
        self
    }

    #[inline]
    pub fn workgroup_memory_explicit_layout_8bit_access(
        mut self,
        workgroup_memory_explicit_layout_8bit_access: bool,
    ) -> Self {
        self.value.workgroup_memory_explicit_layout_8bit_access =
            workgroup_memory_explicit_layout_8bit_access as Bool32;
        self
    }

    #[inline]
    pub fn workgroup_memory_explicit_layout_16bit_access(
        mut self,
        workgroup_memory_explicit_layout_16bit_access: bool,
    ) -> Self {
        self.value.workgroup_memory_explicit_layout_16bit_access =
            workgroup_memory_explicit_layout_16bit_access as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder {
    type Target = PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHRBuilder {
    type Target = PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    type Target = PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    type Builder = PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder {
    value: PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT,
}

impl PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder {
    #[inline]
    pub fn ycbcr2plane444_formats(mut self, ycbcr2plane444_formats: bool) -> Self {
        self.value.ycbcr2plane444_formats = ycbcr2plane444_formats as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder {
    type Target = PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXTBuilder {
    type Target = PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceYcbcrImageArraysFeaturesEXT {
    type Target = PhysicalDeviceYcbcrImageArraysFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceYcbcrImageArraysFeaturesEXT {
    type Builder = PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder;
}

/// A builder for a [`PhysicalDeviceYcbcrImageArraysFeaturesEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder {
    value: PhysicalDeviceYcbcrImageArraysFeaturesEXT,
}

impl PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder {
    #[inline]
    pub fn ycbcr_image_arrays(mut self, ycbcr_image_arrays: bool) -> Self {
        self.value.ycbcr_image_arrays = ycbcr_image_arrays as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceYcbcrImageArraysFeaturesEXT {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder {
    type Target = PhysicalDeviceYcbcrImageArraysFeaturesEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceYcbcrImageArraysFeaturesEXTBuilder {
    type Target = PhysicalDeviceYcbcrImageArraysFeaturesEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
    type Target = PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
    type Builder = PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder;
}

/// A builder for a [`PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder {
    value: PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR,
}

impl PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder {
    #[inline]
    pub fn shader_zero_initialize_workgroup_memory(
        mut self,
        shader_zero_initialize_workgroup_memory: bool,
    ) -> Self {
        self.value.shader_zero_initialize_workgroup_memory =
            shader_zero_initialize_workgroup_memory as Bool32;
        self
    }

    #[inline]
    pub fn build(self) -> PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
        self.value
    }
}

impl ops::Deref for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder {
    type Target = PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHRBuilder {
    type Target = PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineCacheCreateInfo {
    type Target = PipelineCacheCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PipelineCacheCreateInfo {
    type Builder = PipelineCacheCreateInfoBuilder<'b>;
}

/// A builder for a [`PipelineCacheCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineCacheCreateInfoBuilder<'b> {
    value: PipelineCacheCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PipelineCacheCreateInfoBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCacheCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn initial_data(mut self, initial_data: &'b [u8]) -> Self {
        self.value.initial_data_size = initial_data.len() as usize;
        self.value.initial_data = initial_data.as_ptr().cast();
        self
    }

    #[inline]
    pub fn build(self) -> PipelineCacheCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for PipelineCacheCreateInfoBuilder<'b> {
    type Target = PipelineCacheCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PipelineCacheCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PipelineCacheCreateInfoBuilder<'b> {
    type Target = PipelineCacheCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineCacheHeaderVersionOne {
    type Target = PipelineCacheHeaderVersionOne;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PipelineCacheHeaderVersionOne {
    type Builder = PipelineCacheHeaderVersionOneBuilder;
}

/// A builder for a [`PipelineCacheHeaderVersionOne`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineCacheHeaderVersionOneBuilder {
    value: PipelineCacheHeaderVersionOne,
}

impl PipelineCacheHeaderVersionOneBuilder {
    #[inline]
    pub fn header_size(mut self, header_size: u32) -> Self {
        self.value.header_size = header_size;
        self
    }

    #[inline]
    pub fn header_version(mut self, header_version: PipelineCacheHeaderVersion) -> Self {
        self.value.header_version = header_version;
        self
    }

    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.value.vendor_id = vendor_id;
        self
    }

    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.value.device_id = device_id;
        self
    }

    #[inline]
    pub fn pipeline_cache_uuid(
        mut self,
        pipeline_cache_uuid: impl Into<ByteArray<UUID_SIZE>>,
    ) -> Self {
        self.value.pipeline_cache_uuid = pipeline_cache_uuid.into();
        self
    }

    #[inline]
    pub fn build(self) -> PipelineCacheHeaderVersionOne {
        self.value
    }
}

impl ops::Deref for PipelineCacheHeaderVersionOneBuilder {
    type Target = PipelineCacheHeaderVersionOne;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PipelineCacheHeaderVersionOneBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PipelineCacheHeaderVersionOneBuilder {
    type Target = PipelineCacheHeaderVersionOne;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineColorBlendAdvancedStateCreateInfoEXT {
    type Target = PipelineColorBlendAdvancedStateCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PipelineColorBlendAdvancedStateCreateInfoEXT {
    type Builder = PipelineColorBlendAdvancedStateCreateInfoEXTBuilder;
}

/// A builder for a [`PipelineColorBlendAdvancedStateCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
    value: PipelineColorBlendAdvancedStateCreateInfoEXT,
}

impl PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
    #[inline]
    pub fn src_premultiplied(mut self, src_premultiplied: bool) -> Self {
        self.value.src_premultiplied = src_premultiplied as Bool32;
        self
    }

    #[inline]
    pub fn dst_premultiplied(mut self, dst_premultiplied: bool) -> Self {
        self.value.dst_premultiplied = dst_premultiplied as Bool32;
        self
    }

    #[inline]
    pub fn blend_overlap(mut self, blend_overlap: BlendOverlapEXT) -> Self {
        self.value.blend_overlap = blend_overlap;
        self
    }

    #[inline]
    pub fn build(self) -> PipelineColorBlendAdvancedStateCreateInfoEXT {
        self.value
    }
}

impl ops::Deref for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
    type Target = PipelineColorBlendAdvancedStateCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
    type Target = PipelineColorBlendAdvancedStateCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineColorBlendAttachmentState {
    type Target = PipelineColorBlendAttachmentState;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PipelineColorBlendAttachmentState {
    type Builder = PipelineColorBlendAttachmentStateBuilder;
}

/// A builder for a [`PipelineColorBlendAttachmentState`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineColorBlendAttachmentStateBuilder {
    value: PipelineColorBlendAttachmentState,
}

impl PipelineColorBlendAttachmentStateBuilder {
    #[inline]
    pub fn blend_enable(mut self, blend_enable: bool) -> Self {
        self.value.blend_enable = blend_enable as Bool32;
        self
    }

    #[inline]
    pub fn src_color_blend_factor(mut self, src_color_blend_factor: BlendFactor) -> Self {
        self.value.src_color_blend_factor = src_color_blend_factor;
        self
    }

    #[inline]
    pub fn dst_color_blend_factor(mut self, dst_color_blend_factor: BlendFactor) -> Self {
        self.value.dst_color_blend_factor = dst_color_blend_factor;
        self
    }

    #[inline]
    pub fn color_blend_op(mut self, color_blend_op: BlendOp) -> Self {
        self.value.color_blend_op = color_blend_op;
        self
    }

    #[inline]
    pub fn src_alpha_blend_factor(mut self, src_alpha_blend_factor: BlendFactor) -> Self {
        self.value.src_alpha_blend_factor = src_alpha_blend_factor;
        self
    }

    #[inline]
    pub fn dst_alpha_blend_factor(mut self, dst_alpha_blend_factor: BlendFactor) -> Self {
        self.value.dst_alpha_blend_factor = dst_alpha_blend_factor;
        self
    }

    #[inline]
    pub fn alpha_blend_op(mut self, alpha_blend_op: BlendOp) -> Self {
        self.value.alpha_blend_op = alpha_blend_op;
        self
    }

    #[inline]
    pub fn color_write_mask(mut self, color_write_mask: ColorComponentFlags) -> Self {
        self.value.color_write_mask = color_write_mask;
        self
    }

    #[inline]
    pub fn build(self) -> PipelineColorBlendAttachmentState {
        self.value
    }
}

impl ops::Deref for PipelineColorBlendAttachmentStateBuilder {
    type Target = PipelineColorBlendAttachmentState;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PipelineColorBlendAttachmentStateBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PipelineColorBlendAttachmentStateBuilder {
    type Target = PipelineColorBlendAttachmentState;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

/// A Vulkan struct that can be used to extend a [`PipelineColorBlendStateCreateInfo`].
pub unsafe trait ExtendsPipelineColorBlendStateCreateInfo: fmt::Debug {}
unsafe impl ExtendsPipelineColorBlendStateCreateInfo
    for PipelineColorBlendAdvancedStateCreateInfoEXT
{
}
unsafe impl ExtendsPipelineColorBlendStateCreateInfo for PipelineColorWriteCreateInfoEXT {}

unsafe impl Cast for PipelineColorBlendStateCreateInfo {
    type Target = PipelineColorBlendStateCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PipelineColorBlendStateCreateInfo {
    type Builder = PipelineColorBlendStateCreateInfoBuilder<'b>;
}

/// A builder for a [`PipelineColorBlendStateCreateInfo`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineColorBlendStateCreateInfoBuilder<'b> {
    value: PipelineColorBlendStateCreateInfo,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PipelineColorBlendStateCreateInfoBuilder<'b> {
    #[inline]
    pub fn push_next<T>(mut self, next: &'b mut impl Cast<Target = T>) -> Self
    where
        T: ExtendsPipelineColorBlendStateCreateInfo,
    {
        let next = (next.as_mut() as *mut T).cast::<PipelineColorBlendStateCreateInfo>();
        unsafe { *next }.next = self.next;
        self.next = next.cast();
        self
    }

    #[inline]
    pub fn flags(mut self, flags: PipelineColorBlendStateCreateFlags) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn logic_op_enable(mut self, logic_op_enable: bool) -> Self {
        self.value.logic_op_enable = logic_op_enable as Bool32;
        self
    }

    #[inline]
    pub fn logic_op(mut self, logic_op: LogicOp) -> Self {
        self.value.logic_op = logic_op;
        self
    }

    #[inline]
    pub fn attachments(
        mut self,
        attachments: &'b [impl Cast<Target = PipelineColorBlendAttachmentState>],
    ) -> Self {
        self.value.attachment_count = attachments.len() as u32;
        self.value.attachments = attachments.as_ptr().cast();
        self
    }

    #[inline]
    pub fn blend_constants(mut self, blend_constants: [f32; 4]) -> Self {
        self.value.blend_constants = blend_constants;
        self
    }

    #[inline]
    pub fn build(self) -> PipelineColorBlendStateCreateInfo {
        self.value
    }
}

impl<'b> ops::Deref for PipelineColorBlendStateCreateInfoBuilder<'b> {
    type Target = PipelineColorBlendStateCreateInfo;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PipelineColorBlendStateCreateInfoBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PipelineColorBlendStateCreateInfoBuilder<'b> {
    type Target = PipelineColorBlendStateCreateInfo;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineColorWriteCreateInfoEXT {
    type Target = PipelineColorWriteCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PipelineColorWriteCreateInfoEXT {
    type Builder = PipelineColorWriteCreateInfoEXTBuilder<'b>;
}

/// A builder for a [`PipelineColorWriteCreateInfoEXT`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineColorWriteCreateInfoEXTBuilder<'b> {
    value: PipelineColorWriteCreateInfoEXT,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PipelineColorWriteCreateInfoEXTBuilder<'b> {
    #[inline]
    pub fn color_write_enables(mut self, color_write_enables: &'b [Bool32]) -> Self {
        self.value.attachment_count = color_write_enables.len() as u32;
        self.value.color_write_enables = color_write_enables.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> PipelineColorWriteCreateInfoEXT {
        self.value
    }
}

impl<'b> ops::Deref for PipelineColorWriteCreateInfoEXTBuilder<'b> {
    type Target = PipelineColorWriteCreateInfoEXT;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PipelineColorWriteCreateInfoEXTBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PipelineColorWriteCreateInfoEXTBuilder<'b> {
    type Target = PipelineColorWriteCreateInfoEXT;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineCompilerControlCreateInfoAMD {
    type Target = PipelineCompilerControlCreateInfoAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PipelineCompilerControlCreateInfoAMD {
    type Builder = PipelineCompilerControlCreateInfoAMDBuilder;
}

/// A builder for a [`PipelineCompilerControlCreateInfoAMD`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineCompilerControlCreateInfoAMDBuilder {
    value: PipelineCompilerControlCreateInfoAMD,
}

impl PipelineCompilerControlCreateInfoAMDBuilder {
    #[inline]
    pub fn compiler_control_flags(
        mut self,
        compiler_control_flags: PipelineCompilerControlFlagsAMD,
    ) -> Self {
        self.value.compiler_control_flags = compiler_control_flags;
        self
    }

    #[inline]
    pub fn build(self) -> PipelineCompilerControlCreateInfoAMD {
        self.value
    }
}

impl ops::Deref for PipelineCompilerControlCreateInfoAMDBuilder {
    type Target = PipelineCompilerControlCreateInfoAMD;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl ops::DerefMut for PipelineCompilerControlCreateInfoAMDBuilder {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl Cast for PipelineCompilerControlCreateInfoAMDBuilder {
    type Target = PipelineCompilerControlCreateInfoAMD;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineCoverageModulationStateCreateInfoNV {
    type Target = PipelineCoverageModulationStateCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl<'b> HasBuilder<'b> for PipelineCoverageModulationStateCreateInfoNV {
    type Builder = PipelineCoverageModulationStateCreateInfoNVBuilder<'b>;
}

/// A builder for a [`PipelineCoverageModulationStateCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineCoverageModulationStateCreateInfoNVBuilder<'b> {
    value: PipelineCoverageModulationStateCreateInfoNV,
    _marker: PhantomData<&'b ()>,
}

impl<'b> PipelineCoverageModulationStateCreateInfoNVBuilder<'b> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageModulationStateCreateFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn coverage_modulation_mode(
        mut self,
        coverage_modulation_mode: CoverageModulationModeNV,
    ) -> Self {
        self.value.coverage_modulation_mode = coverage_modulation_mode;
        self
    }

    #[inline]
    pub fn coverage_modulation_table_enable(
        mut self,
        coverage_modulation_table_enable: bool,
    ) -> Self {
        self.value.coverage_modulation_table_enable = coverage_modulation_table_enable as Bool32;
        self
    }

    #[inline]
    pub fn coverage_modulation_table_count(mut self, coverage_modulation_table_count: u32) -> Self {
        self.value.coverage_modulation_table_count = coverage_modulation_table_count;
        self
    }

    #[inline]
    pub fn coverage_modulation_table(mut self, coverage_modulation_table: &'b [f32]) -> Self {
        self.value.coverage_modulation_table_count = coverage_modulation_table.len() as u32;
        self.value.coverage_modulation_table = coverage_modulation_table.as_ptr();
        self
    }

    #[inline]
    pub fn build(self) -> PipelineCoverageModulationStateCreateInfoNV {
        self.value
    }
}

impl<'b> ops::Deref for PipelineCoverageModulationStateCreateInfoNVBuilder<'b> {
    type Target = PipelineCoverageModulationStateCreateInfoNV;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}

impl<'b> ops::DerefMut for PipelineCoverageModulationStateCreateInfoNVBuilder<'b> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}

unsafe impl<'b> Cast for PipelineCoverageModulationStateCreateInfoNVBuilder<'b> {
    type Target = PipelineCoverageModulationStateCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self.value
    }
}

unsafe impl Cast for PipelineCoverageReductionStateCreateInfoNV {
    type Target = PipelineCoverageReductionStateCreateInfoNV;

    #[inline]
    fn into(self) -> Self::Target {
        self
    }
}

impl HasBuilder<'static> for PipelineCoverageReductionStateCreateInfoNV {
    type Builder = PipelineCoverageReductionStateCreateInfoNVBuilder;
}

/// A builder for a [`PipelineCoverageReductionStateCreateInfoNV`].
#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default)]
pub struct PipelineCoverageReductionStateCreateInfoNVBuilder {
    value: PipelineCoverageReductionStateCreateInfoNV,
}

impl PipelineCoverageReductionStateCreateInfoNVBuilder {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageReductionStateCreateFlagsNV) -> Self {
        self.value.flags = flags;
        self
    }

    #[inline]
    pub fn coverage_reduction_mode(
        mut self,
        coverage_reduction_mode: CoverageReductionModeNV,
    ) -> Self {
        self.value.coverage_reduction_mode = coverage_reduction_mode;
        self
    }

    #[inline]
    pub fn build(self) -> PipelineCoverageReductionStateCreateInfoNV {
        self.value
    }
}

impl ops::Deref for PipelineCoverageReductionStateCreateInfoNVBuilder {
    type Target = PipelineCoverageReductionState