// SPDX-License-Identifier: Apache-2.0

// DO NOT EDIT.
//
// This file has been generated by the Kotlin project in the `generator`
// directory from a Vulkan API registry.

#![allow(
    non_camel_case_types,
    non_snake_case,
    clippy::missing_safety_doc,
    clippy::too_many_arguments,
    clippy::type_complexity,
    clippy::upper_case_acronyms
)]

use std::ffi::CStr;
use std::mem::MaybeUninit;
use std::os::raw::{c_int, c_void};
use std::ptr::{self, copy_nonoverlapping as memcpy};

use super::*;

/// A Vulkan type that can be converted to or from a borrowed C string.
pub trait ConvertCStr {
    /// Converts a borrowed C string into a value.
    fn from_cstr(string: &CStr) -> Self;

    /// Converts this value into a borrowed C string.
    fn to_cstr(&self) -> &CStr;
}

impl ConvertCStr for ExtensionName {
    #[inline]
    fn from_cstr(string: &CStr) -> Self {
        let mut name = [0; MAX_EXTENSION_NAME_SIZE];
        let count = string.to_bytes().len();
        unsafe { memcpy(string.as_ptr(), name.as_mut_ptr(), count) };
        name
    }

    #[inline]
    fn to_cstr(&self) -> &CStr {
        unsafe { CStr::from_ptr(self.as_ptr()) }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_buffer_marker.html>
pub trait AmdBufferMarkerExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_BUFFER_MARKER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteBufferMarkerAMD.html>
    #[inline]
    unsafe fn cmd_write_buffer_marker_amd(
        &self,
        command_buffer: CommandBuffer,
        pipeline_stage: PipelineStageFlags,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        marker: u32,
    ) {
        let __result = (self.commands().cmd_write_buffer_marker_amd)(
            command_buffer,
            pipeline_stage,
            dst_buffer,
            dst_offset,
            marker,
        );
    }
}

impl AmdBufferMarkerExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_device_coherent_memory.html>
pub trait AmdDeviceCoherentMemoryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_DEVICE_COHERENT_MEMORY_EXTENSION;
}

impl AmdDeviceCoherentMemoryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_display_native_hdr.html>
pub trait AmdDisplayNativeHdrExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_DISPLAY_NATIVE_HDR_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetLocalDimmingAMD.html>
    #[inline]
    unsafe fn set_local_dimming_amd(&self, swap_chain: SwapchainKHR, local_dimming_enable: bool) {
        let __result = (self.commands().set_local_dimming_amd)(
            self.handle(),
            swap_chain,
            local_dimming_enable as Bool32,
        );
    }
}

impl AmdDisplayNativeHdrExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_draw_indirect_count.html>
pub trait AmdDrawIndirectCountExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_DRAW_INDIRECT_COUNT_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndexedIndirectCountAMD.html>
    #[inline]
    unsafe fn cmd_draw_indexed_indirect_count_amd(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_indexed_indirect_count_amd)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndirectCountAMD.html>
    #[inline]
    unsafe fn cmd_draw_indirect_count_amd(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_indirect_count_amd)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        );
    }
}

impl AmdDrawIndirectCountExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_gcn_shader.html>
pub trait AmdGcnShaderExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_GCN_SHADER_EXTENSION;
}

impl AmdGcnShaderExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_gpu_shader_half_float.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_shader_float16_int8`")]
pub trait AmdGpuShaderHalfFloatExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_GPU_SHADER_HALF_FLOAT_EXTENSION;
}

#[allow(deprecated)]
impl AmdGpuShaderHalfFloatExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_gpu_shader_int16.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_shader_float16_int8`")]
pub trait AmdGpuShaderInt16Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_GPU_SHADER_INT16_EXTENSION;
}

#[allow(deprecated)]
impl AmdGpuShaderInt16Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_memory_overallocation_behavior.html>
pub trait AmdMemoryOverallocationBehaviorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION;
}

impl AmdMemoryOverallocationBehaviorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_mixed_attachment_samples.html>
pub trait AmdMixedAttachmentSamplesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION;
}

impl AmdMixedAttachmentSamplesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_negative_viewport_height.html>
pub trait AmdNegativeViewportHeightExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION;
}

impl AmdNegativeViewportHeightExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_pipeline_compiler_control.html>
pub trait AmdPipelineCompilerControlExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_PIPELINE_COMPILER_CONTROL_EXTENSION;
}

impl AmdPipelineCompilerControlExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_rasterization_order.html>
pub trait AmdRasterizationOrderExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_RASTERIZATION_ORDER_EXTENSION;
}

impl AmdRasterizationOrderExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_ballot.html>
pub trait AmdShaderBallotExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_BALLOT_EXTENSION;
}

impl AmdShaderBallotExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_core_properties.html>
pub trait AmdShaderCorePropertiesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_CORE_PROPERTIES_EXTENSION;
}

impl AmdShaderCorePropertiesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_core_properties2.html>
pub trait AmdShaderCoreProperties2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_CORE_PROPERTIES2_EXTENSION;
}

impl AmdShaderCoreProperties2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_explicit_vertex_parameter.html>
pub trait AmdShaderExplicitVertexParameterExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION;
}

impl AmdShaderExplicitVertexParameterExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_fragment_mask.html>
pub trait AmdShaderFragmentMaskExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_FRAGMENT_MASK_EXTENSION;
}

impl AmdShaderFragmentMaskExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_image_load_store_lod.html>
pub trait AmdShaderImageLoadStoreLodExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION;
}

impl AmdShaderImageLoadStoreLodExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_info.html>
pub trait AmdShaderInfoExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_INFO_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetShaderInfoAMD.html>
    #[inline]
    unsafe fn get_shader_info_amd(
        &self,
        pipeline: Pipeline,
        shader_stage: ShaderStageFlags,
        info_type: ShaderInfoTypeAMD,
    ) -> crate::VkResult<Vec<u8>> {
        let mut info_size = 0;

        (self.commands().get_shader_info_amd)(
            self.handle(),
            pipeline,
            shader_stage,
            info_type,
            &mut info_size,
            ptr::null_mut(),
        );

        let mut info = Vec::with_capacity(info_size as usize);

        let __result = (self.commands().get_shader_info_amd)(
            self.handle(),
            pipeline,
            shader_stage,
            info_type,
            &mut info_size,
            info.as_mut_ptr() as *mut c_void,
        );

        debug_assert!(info.capacity() == info_size as usize);
        info.set_len(info_size as usize);

        if __result == Result::SUCCESS {
            Ok(info)
        } else {
            Err(__result.into())
        }
    }
}

impl AmdShaderInfoExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_shader_trinary_minmax.html>
pub trait AmdShaderTrinaryMinmaxExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_SHADER_TRINARY_MINMAX_EXTENSION;
}

impl AmdShaderTrinaryMinmaxExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_AMD_texture_gather_bias_lod.html>
pub trait AmdTextureGatherBiasLodExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION;
}

impl AmdTextureGatherBiasLodExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_ANDROID_external_memory_android_hardware_buffer.html>
pub trait AndroidExternalMemoryAndroidHardwareBufferExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = ANDROID_EXTERNAL_MEMORY_ANDROID_HARDWARE_BUFFER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html>
    #[inline]
    unsafe fn get_android_hardware_buffer_properties_android(
        &self,
        buffer: &AHardwareBuffer,
        properties: &mut AndroidHardwareBufferPropertiesANDROID,
    ) -> crate::VkResult<()> {
        let __result = (self
            .commands()
            .get_android_hardware_buffer_properties_android)(
            self.handle(), buffer, properties
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryAndroidHardwareBufferANDROID.html>
    #[inline]
    unsafe fn get_memory_android_hardware_buffer_android(
        &self,
        info: &MemoryGetAndroidHardwareBufferInfoANDROID,
    ) -> crate::VkResult<*mut AHardwareBuffer> {
        let mut buffer = MaybeUninit::<*mut AHardwareBuffer>::uninit();

        let __result = (self.commands().get_memory_android_hardware_buffer_android)(
            self.handle(),
            info,
            buffer.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(buffer.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl AndroidExternalMemoryAndroidHardwareBufferExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_4444_formats.html>
pub trait Ext4444FormatsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_4444_FORMATS_EXTENSION;
}

impl Ext4444FormatsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_acquire_drm_display.html>
pub trait ExtAcquireDrmDisplayExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_ACQUIRE_DRM_DISPLAY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireDrmDisplayEXT.html>
    #[inline]
    unsafe fn acquire_drm_display_ext(
        &self,
        physical_device: PhysicalDevice,
        drm_fd: i32,
        display: DisplayKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().acquire_drm_display_ext)(physical_device, drm_fd, display);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDrmDisplayEXT.html>
    #[inline]
    unsafe fn get_drm_display_ext(
        &self,
        physical_device: PhysicalDevice,
        drm_fd: i32,
        connector_id: u32,
    ) -> crate::VkResult<DisplayKHR> {
        let mut display = MaybeUninit::<DisplayKHR>::uninit();

        let __result = (self.commands().get_drm_display_ext)(
            physical_device,
            drm_fd,
            connector_id,
            display.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(display.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtAcquireDrmDisplayExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_acquire_xlib_display.html>
pub trait ExtAcquireXlibDisplayExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_ACQUIRE_XLIB_DISPLAY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireXlibDisplayEXT.html>
    #[inline]
    unsafe fn acquire_xlib_display_ext(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
    ) -> crate::VkResult<Display> {
        let mut dpy = MaybeUninit::<Display>::uninit();

        let __result =
            (self.commands().acquire_xlib_display_ext)(physical_device, dpy.as_mut_ptr(), display);

        if __result == Result::SUCCESS {
            Ok(dpy.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRandROutputDisplayEXT.html>
    #[inline]
    unsafe fn get_rand_r_output_display_ext(
        &self,
        physical_device: PhysicalDevice,
        rr_output: RROutput,
    ) -> crate::VkResult<(Display, DisplayKHR)> {
        let mut dpy = MaybeUninit::<Display>::uninit();
        let mut display = MaybeUninit::<DisplayKHR>::uninit();

        let __result = (self.commands().get_rand_r_output_display_ext)(
            physical_device,
            dpy.as_mut_ptr(),
            rr_output,
            display.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok((dpy.assume_init(), display.assume_init()))
        } else {
            Err(__result.into())
        }
    }
}

impl ExtAcquireXlibDisplayExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_astc_decode_mode.html>
pub trait ExtAstcDecodeModeExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_ASTC_DECODE_MODE_EXTENSION;
}

impl ExtAstcDecodeModeExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_blend_operation_advanced.html>
pub trait ExtBlendOperationAdvancedExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_BLEND_OPERATION_ADVANCED_EXTENSION;
}

impl ExtBlendOperationAdvancedExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_buffer_device_address.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_buffer_device_address`")]
pub trait ExtBufferDeviceAddressExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_BUFFER_DEVICE_ADDRESS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferDeviceAddressEXT.html>
    #[inline]
    unsafe fn get_buffer_device_address_ext(&self, info: &BufferDeviceAddressInfo) {
        let __result = (self.commands().get_buffer_device_address_ext)(self.handle(), info);
    }
}

#[allow(deprecated)]
impl ExtBufferDeviceAddressExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_calibrated_timestamps.html>
pub trait ExtCalibratedTimestampsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_CALIBRATED_TIMESTAMPS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetCalibratedTimestampsEXT.html>
    #[inline]
    unsafe fn get_calibrated_timestamps_ext(
        &self,
        timestamp_infos: &[impl Cast<Target = CalibratedTimestampInfoEXT>],
    ) -> crate::VkResult<(Vec<u64>, u64)> {
        let mut timestamps = Vec::with_capacity(timestamp_infos.len() as usize);
        let mut max_deviation = MaybeUninit::<u64>::uninit();

        let __result = (self.commands().get_calibrated_timestamps_ext)(
            self.handle(),
            timestamp_infos.len() as u32,
            timestamp_infos.as_ptr().cast(),
            timestamps.as_mut_ptr(),
            max_deviation.as_mut_ptr(),
        );

        debug_assert!(timestamps.capacity() == timestamp_infos.len() as usize);
        timestamps.set_len(timestamp_infos.len() as usize);

        if __result == Result::SUCCESS {
            Ok((timestamps, max_deviation.assume_init()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceCalibrateableTimeDomainsEXT.html>
    #[inline]
    unsafe fn get_physical_device_calibrateable_time_domains_ext(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<TimeDomainEXT>> {
        let mut time_domain_count = 0;

        (self
            .commands()
            .get_physical_device_calibrateable_time_domains_ext)(
            physical_device,
            &mut time_domain_count,
            ptr::null_mut(),
        );

        let mut time_domains = Vec::with_capacity(time_domain_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_calibrateable_time_domains_ext)(
            physical_device,
            &mut time_domain_count,
            time_domains.as_mut_ptr(),
        );

        debug_assert!(time_domains.capacity() == time_domain_count as usize);
        time_domains.set_len(time_domain_count as usize);

        if __result == Result::SUCCESS {
            Ok(time_domains)
        } else {
            Err(__result.into())
        }
    }
}

impl ExtCalibratedTimestampsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_color_write_enable.html>
pub trait ExtColorWriteEnableExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_COLOR_WRITE_ENABLE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetColorWriteEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_color_write_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        color_write_enables: &[Bool32],
    ) {
        let __result = (self.commands().cmd_set_color_write_enable_ext)(
            command_buffer,
            color_write_enables.len() as u32,
            color_write_enables.as_ptr(),
        );
    }
}

impl ExtColorWriteEnableExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_conditional_rendering.html>
pub trait ExtConditionalRenderingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_CONDITIONAL_RENDERING_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginConditionalRenderingEXT.html>
    #[inline]
    unsafe fn cmd_begin_conditional_rendering_ext(
        &self,
        command_buffer: CommandBuffer,
        conditional_rendering_begin: &ConditionalRenderingBeginInfoEXT,
    ) {
        let __result = (self.commands().cmd_begin_conditional_rendering_ext)(
            command_buffer,
            conditional_rendering_begin,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndConditionalRenderingEXT.html>
    #[inline]
    unsafe fn cmd_end_conditional_rendering_ext(&self, command_buffer: CommandBuffer) {
        let __result = (self.commands().cmd_end_conditional_rendering_ext)(command_buffer);
    }
}

impl ExtConditionalRenderingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_conservative_rasterization.html>
pub trait ExtConservativeRasterizationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_CONSERVATIVE_RASTERIZATION_EXTENSION;
}

impl ExtConservativeRasterizationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_custom_border_color.html>
pub trait ExtCustomBorderColorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_CUSTOM_BORDER_COLOR_EXTENSION;
}

impl ExtCustomBorderColorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_debug_marker.html>
pub trait ExtDebugMarkerExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEBUG_MARKER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDebugMarkerBeginEXT.html>
    #[inline]
    unsafe fn cmd_debug_marker_begin_ext(
        &self,
        command_buffer: CommandBuffer,
        marker_info: &DebugMarkerMarkerInfoEXT,
    ) {
        let __result = (self.commands().cmd_debug_marker_begin_ext)(command_buffer, marker_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDebugMarkerEndEXT.html>
    #[inline]
    unsafe fn cmd_debug_marker_end_ext(&self, command_buffer: CommandBuffer) {
        let __result = (self.commands().cmd_debug_marker_end_ext)(command_buffer);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDebugMarkerInsertEXT.html>
    #[inline]
    unsafe fn cmd_debug_marker_insert_ext(
        &self,
        command_buffer: CommandBuffer,
        marker_info: &DebugMarkerMarkerInfoEXT,
    ) {
        let __result = (self.commands().cmd_debug_marker_insert_ext)(command_buffer, marker_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDebugMarkerSetObjectNameEXT.html>
    #[inline]
    unsafe fn debug_marker_set_object_name_ext(
        &self,
        name_info: &DebugMarkerObjectNameInfoEXT,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().debug_marker_set_object_name_ext)(self.handle(), name_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDebugMarkerSetObjectTagEXT.html>
    #[inline]
    unsafe fn debug_marker_set_object_tag_ext(
        &self,
        tag_info: &DebugMarkerObjectTagInfoEXT,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().debug_marker_set_object_tag_ext)(self.handle(), tag_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtDebugMarkerExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_debug_report.html>
#[deprecated(note = "deprecated in favor of `VK_EXT_debug_utils`")]
pub trait ExtDebugReportExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEBUG_REPORT_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDebugReportCallbackEXT.html>
    #[inline]
    unsafe fn create_debug_report_callback_ext(
        &self,
        create_info: &DebugReportCallbackCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<DebugReportCallbackEXT> {
        let mut callback = MaybeUninit::<DebugReportCallbackEXT>::uninit();

        let __result = (self.commands().create_debug_report_callback_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            callback.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(callback.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDebugReportMessageEXT.html>
    #[inline]
    unsafe fn debug_report_message_ext(
        &self,
        flags: DebugReportFlagsEXT,
        object_type: DebugReportObjectTypeEXT,
        object: u64,
        location: usize,
        message_code: i32,
        layer_prefix: &[u8],
        message: &[u8],
    ) {
        let __result = (self.commands().debug_report_message_ext)(
            self.handle(),
            flags,
            object_type,
            object,
            location,
            message_code,
            layer_prefix.as_ptr().cast(),
            message.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDebugReportCallbackEXT.html>
    #[inline]
    unsafe fn destroy_debug_report_callback_ext(
        &self,
        callback: DebugReportCallbackEXT,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_debug_report_callback_ext)(
            self.handle(),
            callback,
            allocator.map_or(ptr::null(), |v| v),
        );
    }
}

#[allow(deprecated)]
impl ExtDebugReportExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_debug_utils.html>
pub trait ExtDebugUtilsExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEBUG_UTILS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn cmd_begin_debug_utils_label_ext(
        &self,
        command_buffer: CommandBuffer,
        label_info: &DebugUtilsLabelEXT,
    ) {
        let __result =
            (self.commands().cmd_begin_debug_utils_label_ext)(command_buffer, label_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn cmd_end_debug_utils_label_ext(&self, command_buffer: CommandBuffer) {
        let __result = (self.commands().cmd_end_debug_utils_label_ext)(command_buffer);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdInsertDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn cmd_insert_debug_utils_label_ext(
        &self,
        command_buffer: CommandBuffer,
        label_info: &DebugUtilsLabelEXT,
    ) {
        let __result =
            (self.commands().cmd_insert_debug_utils_label_ext)(command_buffer, label_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDebugUtilsMessengerEXT.html>
    #[inline]
    unsafe fn create_debug_utils_messenger_ext(
        &self,
        create_info: &DebugUtilsMessengerCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<DebugUtilsMessengerEXT> {
        let mut messenger = MaybeUninit::<DebugUtilsMessengerEXT>::uninit();

        let __result = (self.commands().create_debug_utils_messenger_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            messenger.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(messenger.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDebugUtilsMessengerEXT.html>
    #[inline]
    unsafe fn destroy_debug_utils_messenger_ext(
        &self,
        messenger: DebugUtilsMessengerEXT,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_debug_utils_messenger_ext)(
            self.handle(),
            messenger,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueBeginDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn queue_begin_debug_utils_label_ext(
        &self,
        queue: Queue,
        label_info: &DebugUtilsLabelEXT,
    ) {
        let __result = (self.commands().queue_begin_debug_utils_label_ext)(queue, label_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueEndDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn queue_end_debug_utils_label_ext(&self, queue: Queue) {
        let __result = (self.commands().queue_end_debug_utils_label_ext)(queue);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueInsertDebugUtilsLabelEXT.html>
    #[inline]
    unsafe fn queue_insert_debug_utils_label_ext(
        &self,
        queue: Queue,
        label_info: &DebugUtilsLabelEXT,
    ) {
        let __result = (self.commands().queue_insert_debug_utils_label_ext)(queue, label_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetDebugUtilsObjectNameEXT.html>
    #[inline]
    unsafe fn set_debug_utils_object_name_ext(
        &self,
        device: Device,
        name_info: &DebugUtilsObjectNameInfoEXT,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().set_debug_utils_object_name_ext)(device, name_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetDebugUtilsObjectTagEXT.html>
    #[inline]
    unsafe fn set_debug_utils_object_tag_ext(
        &self,
        device: Device,
        tag_info: &DebugUtilsObjectTagInfoEXT,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().set_debug_utils_object_tag_ext)(device, tag_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSubmitDebugUtilsMessageEXT.html>
    #[inline]
    unsafe fn submit_debug_utils_message_ext(
        &self,
        message_severity: DebugUtilsMessageSeverityFlagsEXT,
        message_types: DebugUtilsMessageTypeFlagsEXT,
        callback_data: &DebugUtilsMessengerCallbackDataEXT,
    ) {
        let __result = (self.commands().submit_debug_utils_message_ext)(
            self.handle(),
            message_severity,
            message_types,
            callback_data,
        );
    }
}

impl ExtDebugUtilsExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_depth_clip_enable.html>
pub trait ExtDepthClipEnableExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEPTH_CLIP_ENABLE_EXTENSION;
}

impl ExtDepthClipEnableExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_depth_range_unrestricted.html>
pub trait ExtDepthRangeUnrestrictedExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION;
}

impl ExtDepthRangeUnrestrictedExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_descriptor_indexing.html>
pub trait ExtDescriptorIndexingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DESCRIPTOR_INDEXING_EXTENSION;
}

impl ExtDescriptorIndexingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_device_memory_report.html>
pub trait ExtDeviceMemoryReportExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DEVICE_MEMORY_REPORT_EXTENSION;
}

impl ExtDeviceMemoryReportExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_direct_mode_display.html>
pub trait ExtDirectModeDisplayExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DIRECT_MODE_DISPLAY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkReleaseDisplayEXT.html>
    #[inline]
    unsafe fn release_display_ext(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().release_display_ext)(physical_device, display);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtDirectModeDisplayExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_directfb_surface.html>
pub trait ExtDirectfbSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DIRECTFB_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDirectFBSurfaceEXT.html>
    #[inline]
    unsafe fn create_direct_fb_surface_ext(
        &self,
        create_info: &DirectFBSurfaceCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_direct_fb_surface_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceDirectFBPresentationSupportEXT.html>
    #[inline]
    unsafe fn get_physical_device_direct_fb_presentation_support_ext<T_IDirectFB>(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
    ) -> T_IDirectFB {
        let mut dfb = MaybeUninit::<T_IDirectFB>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_direct_fb_presentation_support_ext)(
            physical_device,
            queue_family_index,
            dfb.as_mut_ptr().cast::<c_void>(),
        );

        dfb.assume_init()
    }
}

impl ExtDirectfbSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_discard_rectangles.html>
pub trait ExtDiscardRectanglesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DISCARD_RECTANGLES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDiscardRectangleEXT.html>
    #[inline]
    unsafe fn cmd_set_discard_rectangle_ext(
        &self,
        command_buffer: CommandBuffer,
        first_discard_rectangle: u32,
        discard_rectangles: &[impl Cast<Target = Rect2D>],
    ) {
        let __result = (self.commands().cmd_set_discard_rectangle_ext)(
            command_buffer,
            first_discard_rectangle,
            discard_rectangles.len() as u32,
            discard_rectangles.as_ptr().cast(),
        );
    }
}

impl ExtDiscardRectanglesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_display_control.html>
pub trait ExtDisplayControlExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DISPLAY_CONTROL_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDisplayPowerControlEXT.html>
    #[inline]
    unsafe fn display_power_control_ext(
        &self,
        display: DisplayKHR,
        display_power_info: &DisplayPowerInfoEXT,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().display_power_control_ext)(self.handle(), display, display_power_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSwapchainCounterEXT.html>
    #[inline]
    unsafe fn get_swapchain_counter_ext(
        &self,
        swapchain: SwapchainKHR,
        counter: SurfaceCounterFlagsEXT,
    ) -> crate::VkResult<u64> {
        let mut counter_value = MaybeUninit::<u64>::uninit();

        let __result = (self.commands().get_swapchain_counter_ext)(
            self.handle(),
            swapchain,
            counter,
            counter_value.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(counter_value.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkRegisterDeviceEventEXT.html>
    #[inline]
    unsafe fn register_device_event_ext(
        &self,
        device_event_info: &DeviceEventInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<Fence> {
        let mut fence = MaybeUninit::<Fence>::uninit();

        let __result = (self.commands().register_device_event_ext)(
            self.handle(),
            device_event_info,
            allocator.map_or(ptr::null(), |v| v),
            fence.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(fence.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkRegisterDisplayEventEXT.html>
    #[inline]
    unsafe fn register_display_event_ext(
        &self,
        display: DisplayKHR,
        display_event_info: &DisplayEventInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<Fence> {
        let mut fence = MaybeUninit::<Fence>::uninit();

        let __result = (self.commands().register_display_event_ext)(
            self.handle(),
            display,
            display_event_info,
            allocator.map_or(ptr::null(), |v| v),
            fence.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(fence.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtDisplayControlExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_display_surface_counter.html>
pub trait ExtDisplaySurfaceCounterExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_DISPLAY_SURFACE_COUNTER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceCapabilities2EXT.html>
    #[inline]
    unsafe fn get_physical_device_surface_capabilities2_ext(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<SurfaceCapabilities2EXT> {
        let mut surface_capabilities = MaybeUninit::<SurfaceCapabilities2EXT>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_surface_capabilities2_ext)(
            physical_device,
            surface,
            surface_capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface_capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtDisplaySurfaceCounterExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_extended_dynamic_state.html>
pub trait ExtExtendedDynamicStateExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_EXTENDED_DYNAMIC_STATE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindVertexBuffers2EXT.html>
    #[inline]
    unsafe fn cmd_bind_vertex_buffers2_ext(
        &self,
        command_buffer: CommandBuffer,
        first_binding: u32,
        buffers: &[Buffer],
        offsets: &[DeviceSize],
        sizes: &[DeviceSize],
        strides: &[DeviceSize],
    ) {
        let __result = (self.commands().cmd_bind_vertex_buffers2_ext)(
            command_buffer,
            first_binding,
            buffers.len() as u32,
            buffers.as_ptr(),
            offsets.as_ptr(),
            sizes.as_ptr(),
            strides.as_ptr(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetCullModeEXT.html>
    #[inline]
    unsafe fn cmd_set_cull_mode_ext(
        &self,
        command_buffer: CommandBuffer,
        cull_mode: CullModeFlags,
    ) {
        let __result = (self.commands().cmd_set_cull_mode_ext)(command_buffer, cull_mode);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthBoundsTestEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_depth_bounds_test_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        depth_bounds_test_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_depth_bounds_test_enable_ext)(
            command_buffer,
            depth_bounds_test_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthCompareOpEXT.html>
    #[inline]
    unsafe fn cmd_set_depth_compare_op_ext(
        &self,
        command_buffer: CommandBuffer,
        depth_compare_op: CompareOp,
    ) {
        let __result =
            (self.commands().cmd_set_depth_compare_op_ext)(command_buffer, depth_compare_op);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthTestEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_depth_test_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        depth_test_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_depth_test_enable_ext)(
            command_buffer,
            depth_test_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthWriteEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_depth_write_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        depth_write_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_depth_write_enable_ext)(
            command_buffer,
            depth_write_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetFrontFaceEXT.html>
    #[inline]
    unsafe fn cmd_set_front_face_ext(&self, command_buffer: CommandBuffer, front_face: FrontFace) {
        let __result = (self.commands().cmd_set_front_face_ext)(command_buffer, front_face);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPrimitiveTopologyEXT.html>
    #[inline]
    unsafe fn cmd_set_primitive_topology_ext(
        &self,
        command_buffer: CommandBuffer,
        primitive_topology: PrimitiveTopology,
    ) {
        let __result =
            (self.commands().cmd_set_primitive_topology_ext)(command_buffer, primitive_topology);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetScissorWithCountEXT.html>
    #[inline]
    unsafe fn cmd_set_scissor_with_count_ext(
        &self,
        command_buffer: CommandBuffer,
        scissors: &[impl Cast<Target = Rect2D>],
    ) {
        let __result = (self.commands().cmd_set_scissor_with_count_ext)(
            command_buffer,
            scissors.len() as u32,
            scissors.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetStencilOpEXT.html>
    #[inline]
    unsafe fn cmd_set_stencil_op_ext(
        &self,
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        fail_op: StencilOp,
        pass_op: StencilOp,
        depth_fail_op: StencilOp,
        compare_op: CompareOp,
    ) {
        let __result = (self.commands().cmd_set_stencil_op_ext)(
            command_buffer,
            face_mask,
            fail_op,
            pass_op,
            depth_fail_op,
            compare_op,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetStencilTestEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_stencil_test_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        stencil_test_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_stencil_test_enable_ext)(
            command_buffer,
            stencil_test_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetViewportWithCountEXT.html>
    #[inline]
    unsafe fn cmd_set_viewport_with_count_ext(
        &self,
        command_buffer: CommandBuffer,
        viewports: &[impl Cast<Target = Viewport>],
    ) {
        let __result = (self.commands().cmd_set_viewport_with_count_ext)(
            command_buffer,
            viewports.len() as u32,
            viewports.as_ptr().cast(),
        );
    }
}

impl ExtExtendedDynamicStateExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_extended_dynamic_state2.html>
pub trait ExtExtendedDynamicState2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_EXTENDED_DYNAMIC_STATE2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthBiasEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_depth_bias_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        depth_bias_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_depth_bias_enable_ext)(
            command_buffer,
            depth_bias_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetLogicOpEXT.html>
    #[inline]
    unsafe fn cmd_set_logic_op_ext(&self, command_buffer: CommandBuffer, logic_op: LogicOp) {
        let __result = (self.commands().cmd_set_logic_op_ext)(command_buffer, logic_op);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPatchControlPointsEXT.html>
    #[inline]
    unsafe fn cmd_set_patch_control_points_ext(
        &self,
        command_buffer: CommandBuffer,
        patch_control_points: u32,
    ) {
        let __result = (self.commands().cmd_set_patch_control_points_ext)(
            command_buffer,
            patch_control_points,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPrimitiveRestartEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_primitive_restart_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        primitive_restart_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_primitive_restart_enable_ext)(
            command_buffer,
            primitive_restart_enable as Bool32,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetRasterizerDiscardEnableEXT.html>
    #[inline]
    unsafe fn cmd_set_rasterizer_discard_enable_ext(
        &self,
        command_buffer: CommandBuffer,
        rasterizer_discard_enable: bool,
    ) {
        let __result = (self.commands().cmd_set_rasterizer_discard_enable_ext)(
            command_buffer,
            rasterizer_discard_enable as Bool32,
        );
    }
}

impl ExtExtendedDynamicState2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_external_memory_dma_buf.html>
pub trait ExtExternalMemoryDmaBufExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION;
}

impl ExtExternalMemoryDmaBufExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_external_memory_host.html>
pub trait ExtExternalMemoryHostExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_EXTERNAL_MEMORY_HOST_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryHostPointerPropertiesEXT.html>
    #[inline]
    unsafe fn get_memory_host_pointer_properties_ext(
        &self,
        handle_type: ExternalMemoryHandleTypeFlags,
        host_pointer: &c_void,
    ) -> crate::VkResult<MemoryHostPointerPropertiesEXT> {
        let mut memory_host_pointer_properties =
            MaybeUninit::<MemoryHostPointerPropertiesEXT>::uninit();

        let __result = (self.commands().get_memory_host_pointer_properties_ext)(
            self.handle(),
            handle_type,
            host_pointer,
            memory_host_pointer_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(memory_host_pointer_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtExternalMemoryHostExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_filter_cubic.html>
pub trait ExtFilterCubicExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_FILTER_CUBIC_EXTENSION;
}

impl ExtFilterCubicExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_fragment_density_map.html>
pub trait ExtFragmentDensityMapExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_FRAGMENT_DENSITY_MAP_EXTENSION;
}

impl ExtFragmentDensityMapExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_fragment_density_map2.html>
pub trait ExtFragmentDensityMap2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_FRAGMENT_DENSITY_MAP2_EXTENSION;
}

impl ExtFragmentDensityMap2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_fragment_shader_interlock.html>
pub trait ExtFragmentShaderInterlockExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION;
}

impl ExtFragmentShaderInterlockExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_full_screen_exclusive.html>
pub trait ExtFullScreenExclusiveExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_FULL_SCREEN_EXCLUSIVE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireFullScreenExclusiveModeEXT.html>
    #[inline]
    unsafe fn acquire_full_screen_exclusive_mode_ext(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().acquire_full_screen_exclusive_mode_ext)(self.handle(), swapchain);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupSurfacePresentModes2EXT.html>
    #[inline]
    unsafe fn get_device_group_surface_present_modes2_ext(
        &self,
        surface_info: &PhysicalDeviceSurfaceInfo2KHR,
    ) -> crate::VkResult<DeviceGroupPresentModeFlagsKHR> {
        let mut modes = MaybeUninit::<DeviceGroupPresentModeFlagsKHR>::uninit();

        let __result = (self.commands().get_device_group_surface_present_modes2_ext)(
            self.handle(),
            surface_info,
            modes.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(modes.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfacePresentModes2EXT.html>
    #[inline]
    unsafe fn get_physical_device_surface_present_modes2_ext(
        &self,
        physical_device: PhysicalDevice,
        surface_info: &PhysicalDeviceSurfaceInfo2KHR,
    ) -> crate::VkResult<Vec<PresentModeKHR>> {
        let mut present_mode_count = 0;

        (self
            .commands()
            .get_physical_device_surface_present_modes2_ext)(
            physical_device,
            surface_info,
            &mut present_mode_count,
            ptr::null_mut(),
        );

        let mut present_modes = Vec::with_capacity(present_mode_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_surface_present_modes2_ext)(
            physical_device,
            surface_info,
            &mut present_mode_count,
            present_modes.as_mut_ptr(),
        );

        debug_assert!(present_modes.capacity() == present_mode_count as usize);
        present_modes.set_len(present_mode_count as usize);

        if __result == Result::SUCCESS {
            Ok(present_modes)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkReleaseFullScreenExclusiveModeEXT.html>
    #[inline]
    unsafe fn release_full_screen_exclusive_mode_ext(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().release_full_screen_exclusive_mode_ext)(self.handle(), swapchain);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtFullScreenExclusiveExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_global_priority.html>
pub trait ExtGlobalPriorityExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_GLOBAL_PRIORITY_EXTENSION;
}

impl ExtGlobalPriorityExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_global_priority_query.html>
pub trait ExtGlobalPriorityQueryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_GLOBAL_PRIORITY_QUERY_EXTENSION;
}

impl ExtGlobalPriorityQueryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_hdr_metadata.html>
pub trait ExtHdrMetadataExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_HDR_METADATA_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetHdrMetadataEXT.html>
    #[inline]
    unsafe fn set_hdr_metadata_ext(
        &self,
        swapchains: &[SwapchainKHR],
        metadata: &[impl Cast<Target = HdrMetadataEXT>],
    ) {
        let __result = (self.commands().set_hdr_metadata_ext)(
            self.handle(),
            swapchains.len() as u32,
            swapchains.as_ptr(),
            metadata.as_ptr().cast(),
        );
    }
}

impl ExtHdrMetadataExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_headless_surface.html>
pub trait ExtHeadlessSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_HEADLESS_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateHeadlessSurfaceEXT.html>
    #[inline]
    unsafe fn create_headless_surface_ext(
        &self,
        create_info: &HeadlessSurfaceCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_headless_surface_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtHeadlessSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_host_query_reset.html>
pub trait ExtHostQueryResetExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_HOST_QUERY_RESET_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetQueryPoolEXT.html>
    #[inline]
    unsafe fn reset_query_pool_ext(
        &self,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
    ) {
        let __result = (self.commands().reset_query_pool_ext)(
            self.handle(),
            query_pool,
            first_query,
            query_count,
        );
    }
}

impl ExtHostQueryResetExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_image_drm_format_modifier.html>
pub trait ExtImageDrmFormatModifierExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageDrmFormatModifierPropertiesEXT.html>
    #[inline]
    unsafe fn get_image_drm_format_modifier_properties_ext(
        &self,
        image: Image,
    ) -> crate::VkResult<ImageDrmFormatModifierPropertiesEXT> {
        let mut properties = MaybeUninit::<ImageDrmFormatModifierPropertiesEXT>::uninit();

        let __result = (self.commands().get_image_drm_format_modifier_properties_ext)(
            self.handle(),
            image,
            properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtImageDrmFormatModifierExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_image_robustness.html>
pub trait ExtImageRobustnessExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_IMAGE_ROBUSTNESS_EXTENSION;
}

impl ExtImageRobustnessExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_index_type_uint8.html>
pub trait ExtIndexTypeUint8Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_INDEX_TYPE_UINT8_EXTENSION;
}

impl ExtIndexTypeUint8Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_inline_uniform_block.html>
pub trait ExtInlineUniformBlockExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_INLINE_UNIFORM_BLOCK_EXTENSION;
}

impl ExtInlineUniformBlockExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_line_rasterization.html>
pub trait ExtLineRasterizationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_LINE_RASTERIZATION_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetLineStippleEXT.html>
    #[inline]
    unsafe fn cmd_set_line_stipple_ext(
        &self,
        command_buffer: CommandBuffer,
        line_stipple_factor: u32,
        line_stipple_pattern: u16,
    ) {
        let __result = (self.commands().cmd_set_line_stipple_ext)(
            command_buffer,
            line_stipple_factor,
            line_stipple_pattern,
        );
    }
}

impl ExtLineRasterizationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_memory_budget.html>
pub trait ExtMemoryBudgetExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_MEMORY_BUDGET_EXTENSION;
}

impl ExtMemoryBudgetExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_memory_priority.html>
pub trait ExtMemoryPriorityExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_MEMORY_PRIORITY_EXTENSION;
}

impl ExtMemoryPriorityExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_metal_surface.html>
pub trait ExtMetalSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_METAL_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateMetalSurfaceEXT.html>
    #[inline]
    unsafe fn create_metal_surface_ext(
        &self,
        create_info: &MetalSurfaceCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_metal_surface_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtMetalSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_multi_draw.html>
pub trait ExtMultiDrawExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_MULTI_DRAW_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawMultiEXT.html>
    #[inline]
    unsafe fn cmd_draw_multi_ext(
        &self,
        command_buffer: CommandBuffer,
        vertex_info: &[impl Cast<Target = MultiDrawInfoEXT>],
        instance_count: u32,
        first_instance: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_multi_ext)(
            command_buffer,
            vertex_info.len() as u32,
            vertex_info.as_ptr().cast(),
            instance_count,
            first_instance,
            stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawMultiIndexedEXT.html>
    #[inline]
    unsafe fn cmd_draw_multi_indexed_ext(
        &self,
        command_buffer: CommandBuffer,
        index_info: &[impl Cast<Target = MultiDrawIndexedInfoEXT>],
        instance_count: u32,
        first_instance: u32,
        stride: u32,
        vertex_offset: Option<&i32>,
    ) {
        let __result = (self.commands().cmd_draw_multi_indexed_ext)(
            command_buffer,
            index_info.len() as u32,
            index_info.as_ptr().cast(),
            instance_count,
            first_instance,
            stride,
            vertex_offset.map_or(ptr::null(), |v| v),
        );
    }
}

impl ExtMultiDrawExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_pci_bus_info.html>
pub trait ExtPciBusInfoExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PCI_BUS_INFO_EXTENSION;
}

impl ExtPciBusInfoExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_physical_device_drm.html>
pub trait ExtPhysicalDeviceDrmExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PHYSICAL_DEVICE_DRM_EXTENSION;
}

impl ExtPhysicalDeviceDrmExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_pipeline_creation_cache_control.html>
pub trait ExtPipelineCreationCacheControlExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION;
}

impl ExtPipelineCreationCacheControlExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_pipeline_creation_feedback.html>
pub trait ExtPipelineCreationFeedbackExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION;
}

impl ExtPipelineCreationFeedbackExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_post_depth_coverage.html>
pub trait ExtPostDepthCoverageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_POST_DEPTH_COVERAGE_EXTENSION;
}

impl ExtPostDepthCoverageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_private_data.html>
pub trait ExtPrivateDataExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PRIVATE_DATA_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreatePrivateDataSlotEXT.html>
    #[inline]
    unsafe fn create_private_data_slot_ext(
        &self,
        create_info: &PrivateDataSlotCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<PrivateDataSlotEXT> {
        let mut private_data_slot = MaybeUninit::<PrivateDataSlotEXT>::uninit();

        let __result = (self.commands().create_private_data_slot_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            private_data_slot.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(private_data_slot.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyPrivateDataSlotEXT.html>
    #[inline]
    unsafe fn destroy_private_data_slot_ext(
        &self,
        private_data_slot: PrivateDataSlotEXT,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_private_data_slot_ext)(
            self.handle(),
            private_data_slot,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPrivateDataEXT.html>
    #[inline]
    unsafe fn get_private_data_ext(
        &self,
        object_type: ObjectType,
        object_handle: u64,
        private_data_slot: PrivateDataSlotEXT,
    ) -> u64 {
        let mut data = MaybeUninit::<u64>::uninit();

        let __result = (self.commands().get_private_data_ext)(
            self.handle(),
            object_type,
            object_handle,
            private_data_slot,
            data.as_mut_ptr(),
        );

        data.assume_init()
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetPrivateDataEXT.html>
    #[inline]
    unsafe fn set_private_data_ext(
        &self,
        object_type: ObjectType,
        object_handle: u64,
        private_data_slot: PrivateDataSlotEXT,
        data: u64,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().set_private_data_ext)(
            self.handle(),
            object_type,
            object_handle,
            private_data_slot,
            data,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtPrivateDataExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_provoking_vertex.html>
pub trait ExtProvokingVertexExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_PROVOKING_VERTEX_EXTENSION;
}

impl ExtProvokingVertexExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_queue_family_foreign.html>
pub trait ExtQueueFamilyForeignExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_QUEUE_FAMILY_FOREIGN_EXTENSION;
}

impl ExtQueueFamilyForeignExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_robustness2.html>
pub trait ExtRobustness2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_ROBUSTNESS2_EXTENSION;
}

impl ExtRobustness2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_sample_locations.html>
pub trait ExtSampleLocationsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SAMPLE_LOCATIONS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetSampleLocationsEXT.html>
    #[inline]
    unsafe fn cmd_set_sample_locations_ext(
        &self,
        command_buffer: CommandBuffer,
        sample_locations_info: &SampleLocationsInfoEXT,
    ) {
        let __result =
            (self.commands().cmd_set_sample_locations_ext)(command_buffer, sample_locations_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceMultisamplePropertiesEXT.html>
    #[inline]
    unsafe fn get_physical_device_multisample_properties_ext(
        &self,
        physical_device: PhysicalDevice,
        samples: SampleCountFlags,
    ) -> MultisamplePropertiesEXT {
        let mut multisample_properties = MaybeUninit::<MultisamplePropertiesEXT>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_multisample_properties_ext)(
            physical_device,
            samples,
            multisample_properties.as_mut_ptr(),
        );

        multisample_properties.assume_init()
    }
}

impl ExtSampleLocationsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_sampler_filter_minmax.html>
pub trait ExtSamplerFilterMinmaxExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SAMPLER_FILTER_MINMAX_EXTENSION;
}

impl ExtSamplerFilterMinmaxExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_scalar_block_layout.html>
pub trait ExtScalarBlockLayoutExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SCALAR_BLOCK_LAYOUT_EXTENSION;
}

impl ExtScalarBlockLayoutExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_separate_stencil_usage.html>
pub trait ExtSeparateStencilUsageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SEPARATE_STENCIL_USAGE_EXTENSION;
}

impl ExtSeparateStencilUsageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_atomic_float.html>
pub trait ExtShaderAtomicFloatExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_ATOMIC_FLOAT_EXTENSION;
}

impl ExtShaderAtomicFloatExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_demote_to_helper_invocation.html>
pub trait ExtShaderDemoteToHelperInvocationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION;
}

impl ExtShaderDemoteToHelperInvocationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_image_atomic_int64.html>
pub trait ExtShaderImageAtomicInt64Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION;
}

impl ExtShaderImageAtomicInt64Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_stencil_export.html>
pub trait ExtShaderStencilExportExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_STENCIL_EXPORT_EXTENSION;
}

impl ExtShaderStencilExportExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_subgroup_ballot.html>
#[deprecated(note = "deprecated in favor of `VK_VERSION_1_2`")]
pub trait ExtShaderSubgroupBallotExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_SUBGROUP_BALLOT_EXTENSION;
}

#[allow(deprecated)]
impl ExtShaderSubgroupBallotExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_subgroup_vote.html>
#[deprecated(note = "deprecated in favor of `VK_VERSION_1_1`")]
pub trait ExtShaderSubgroupVoteExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_SUBGROUP_VOTE_EXTENSION;
}

#[allow(deprecated)]
impl ExtShaderSubgroupVoteExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_shader_viewport_index_layer.html>
pub trait ExtShaderViewportIndexLayerExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION;
}

impl ExtShaderViewportIndexLayerExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_subgroup_size_control.html>
pub trait ExtSubgroupSizeControlExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SUBGROUP_SIZE_CONTROL_EXTENSION;
}

impl ExtSubgroupSizeControlExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_swapchain_colorspace.html>
pub trait ExtSwapchainColorspaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_SWAPCHAIN_COLORSPACE_EXTENSION;
}

impl ExtSwapchainColorspaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_texel_buffer_alignment.html>
pub trait ExtTexelBufferAlignmentExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION;
}

impl ExtTexelBufferAlignmentExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_texture_compression_astc_hdr.html>
pub trait ExtTextureCompressionAstcHdrExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION;
}

impl ExtTextureCompressionAstcHdrExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_tooling_info.html>
pub trait ExtToolingInfoExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_TOOLING_INFO_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceToolPropertiesEXT.html>
    #[inline]
    unsafe fn get_physical_device_tool_properties_ext(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<PhysicalDeviceToolPropertiesEXT>> {
        let mut tool_count = 0;

        (self.commands().get_physical_device_tool_properties_ext)(
            physical_device,
            &mut tool_count,
            ptr::null_mut(),
        );

        let mut tool_properties = Vec::with_capacity(tool_count as usize);

        let __result = (self.commands().get_physical_device_tool_properties_ext)(
            physical_device,
            &mut tool_count,
            tool_properties.as_mut_ptr(),
        );

        debug_assert!(tool_properties.capacity() == tool_count as usize);
        tool_properties.set_len(tool_count as usize);

        if __result == Result::SUCCESS {
            Ok(tool_properties)
        } else {
            Err(__result.into())
        }
    }
}

impl ExtToolingInfoExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_transform_feedback.html>
pub trait ExtTransformFeedbackExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_TRANSFORM_FEEDBACK_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginQueryIndexedEXT.html>
    #[inline]
    unsafe fn cmd_begin_query_indexed_ext(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
        flags: QueryControlFlags,
        index: u32,
    ) {
        let __result = (self.commands().cmd_begin_query_indexed_ext)(
            command_buffer,
            query_pool,
            query,
            flags,
            index,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginTransformFeedbackEXT.html>
    #[inline]
    unsafe fn cmd_begin_transform_feedback_ext(
        &self,
        command_buffer: CommandBuffer,
        first_counter_buffer: u32,
        counter_buffers: &[Buffer],
        counter_buffer_offsets: &[DeviceSize],
    ) {
        let __result = (self.commands().cmd_begin_transform_feedback_ext)(
            command_buffer,
            first_counter_buffer,
            counter_buffers.len() as u32,
            counter_buffers.as_ptr(),
            counter_buffer_offsets.as_ptr(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindTransformFeedbackBuffersEXT.html>
    #[inline]
    unsafe fn cmd_bind_transform_feedback_buffers_ext(
        &self,
        command_buffer: CommandBuffer,
        first_binding: u32,
        buffers: &[Buffer],
        offsets: &[DeviceSize],
        sizes: &[DeviceSize],
    ) {
        let __result = (self.commands().cmd_bind_transform_feedback_buffers_ext)(
            command_buffer,
            first_binding,
            buffers.len() as u32,
            buffers.as_ptr(),
            offsets.as_ptr(),
            sizes.as_ptr(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndirectByteCountEXT.html>
    #[inline]
    unsafe fn cmd_draw_indirect_byte_count_ext(
        &self,
        command_buffer: CommandBuffer,
        instance_count: u32,
        first_instance: u32,
        counter_buffer: Buffer,
        counter_buffer_offset: DeviceSize,
        counter_offset: u32,
        vertex_stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_indirect_byte_count_ext)(
            command_buffer,
            instance_count,
            first_instance,
            counter_buffer,
            counter_buffer_offset,
            counter_offset,
            vertex_stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndQueryIndexedEXT.html>
    #[inline]
    unsafe fn cmd_end_query_indexed_ext(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
        index: u32,
    ) {
        let __result =
            (self.commands().cmd_end_query_indexed_ext)(command_buffer, query_pool, query, index);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndTransformFeedbackEXT.html>
    #[inline]
    unsafe fn cmd_end_transform_feedback_ext(
        &self,
        command_buffer: CommandBuffer,
        first_counter_buffer: u32,
        counter_buffers: &[Buffer],
        counter_buffer_offsets: &[DeviceSize],
    ) {
        let __result = (self.commands().cmd_end_transform_feedback_ext)(
            command_buffer,
            first_counter_buffer,
            counter_buffers.len() as u32,
            counter_buffers.as_ptr(),
            counter_buffer_offsets.as_ptr(),
        );
    }
}

impl ExtTransformFeedbackExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_validation_cache.html>
pub trait ExtValidationCacheExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_VALIDATION_CACHE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateValidationCacheEXT.html>
    #[inline]
    unsafe fn create_validation_cache_ext(
        &self,
        create_info: &ValidationCacheCreateInfoEXT,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<ValidationCacheEXT> {
        let mut validation_cache = MaybeUninit::<ValidationCacheEXT>::uninit();

        let __result = (self.commands().create_validation_cache_ext)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            validation_cache.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(validation_cache.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyValidationCacheEXT.html>
    #[inline]
    unsafe fn destroy_validation_cache_ext(
        &self,
        validation_cache: ValidationCacheEXT,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_validation_cache_ext)(
            self.handle(),
            validation_cache,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetValidationCacheDataEXT.html>
    #[inline]
    unsafe fn get_validation_cache_data_ext(
        &self,
        validation_cache: ValidationCacheEXT,
    ) -> crate::VkResult<Vec<u8>> {
        let mut data_size = 0;

        (self.commands().get_validation_cache_data_ext)(
            self.handle(),
            validation_cache,
            &mut data_size,
            ptr::null_mut(),
        );

        let mut data = Vec::with_capacity(data_size as usize);

        let __result = (self.commands().get_validation_cache_data_ext)(
            self.handle(),
            validation_cache,
            &mut data_size,
            data.as_mut_ptr() as *mut c_void,
        );

        debug_assert!(data.capacity() == data_size as usize);
        data.set_len(data_size as usize);

        if __result == Result::SUCCESS {
            Ok(data)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkMergeValidationCachesEXT.html>
    #[inline]
    unsafe fn merge_validation_caches_ext(
        &self,
        dst_cache: ValidationCacheEXT,
        src_caches: &[ValidationCacheEXT],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().merge_validation_caches_ext)(
            self.handle(),
            dst_cache,
            src_caches.len() as u32,
            src_caches.as_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl ExtValidationCacheExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_validation_features.html>
pub trait ExtValidationFeaturesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_VALIDATION_FEATURES_EXTENSION;
}

impl ExtValidationFeaturesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_validation_flags.html>
#[deprecated(note = "deprecated in favor of `VK_EXT_validation_features`")]
pub trait ExtValidationFlagsExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_VALIDATION_FLAGS_EXTENSION;
}

#[allow(deprecated)]
impl ExtValidationFlagsExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_vertex_attribute_divisor.html>
pub trait ExtVertexAttributeDivisorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION;
}

impl ExtVertexAttributeDivisorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_vertex_input_dynamic_state.html>
pub trait ExtVertexInputDynamicStateExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_VERTEX_INPUT_DYNAMIC_STATE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetVertexInputEXT.html>
    #[inline]
    unsafe fn cmd_set_vertex_input_ext(
        &self,
        command_buffer: CommandBuffer,
        vertex_binding_descriptions: &[impl Cast<Target = VertexInputBindingDescription2EXT>],
        vertex_attribute_descriptions: &[impl Cast<Target = VertexInputAttributeDescription2EXT>],
    ) {
        let __result = (self.commands().cmd_set_vertex_input_ext)(
            command_buffer,
            vertex_binding_descriptions.len() as u32,
            vertex_binding_descriptions.as_ptr().cast(),
            vertex_attribute_descriptions.len() as u32,
            vertex_attribute_descriptions.as_ptr().cast(),
        );
    }
}

impl ExtVertexInputDynamicStateExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_ycbcr_2plane_444_formats.html>
pub trait ExtYcbcr2plane444FormatsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_YCBCR_2PLANE_444_FORMATS_EXTENSION;
}

impl ExtYcbcr2plane444FormatsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_EXT_ycbcr_image_arrays.html>
pub trait ExtYcbcrImageArraysExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = EXT_YCBCR_IMAGE_ARRAYS_EXTENSION;
}

impl ExtYcbcrImageArraysExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_FUCHSIA_external_memory.html>
pub trait FuchsiaExternalMemoryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = FUCHSIA_EXTERNAL_MEMORY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryZirconHandleFUCHSIA.html>
    #[inline]
    unsafe fn get_memory_zircon_handle_fuchsia(
        &self,
        get_zircon_handle_info: &MemoryGetZirconHandleInfoFUCHSIA,
    ) -> crate::VkResult<zx_handle_t> {
        let mut zircon_handle = MaybeUninit::<zx_handle_t>::uninit();

        let __result = (self.commands().get_memory_zircon_handle_fuchsia)(
            self.handle(),
            get_zircon_handle_info,
            zircon_handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(zircon_handle.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryZirconHandlePropertiesFUCHSIA.html>
    #[inline]
    unsafe fn get_memory_zircon_handle_properties_fuchsia(
        &self,
        handle_type: ExternalMemoryHandleTypeFlags,
        zircon_handle: zx_handle_t,
    ) -> crate::VkResult<MemoryZirconHandlePropertiesFUCHSIA> {
        let mut memory_zircon_handle_properties =
            MaybeUninit::<MemoryZirconHandlePropertiesFUCHSIA>::uninit();

        let __result = (self.commands().get_memory_zircon_handle_properties_fuchsia)(
            self.handle(),
            handle_type,
            zircon_handle,
            memory_zircon_handle_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(memory_zircon_handle_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl FuchsiaExternalMemoryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_FUCHSIA_external_semaphore.html>
pub trait FuchsiaExternalSemaphoreExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = FUCHSIA_EXTERNAL_SEMAPHORE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSemaphoreZirconHandleFUCHSIA.html>
    #[inline]
    unsafe fn get_semaphore_zircon_handle_fuchsia(
        &self,
        get_zircon_handle_info: &SemaphoreGetZirconHandleInfoFUCHSIA,
    ) -> crate::VkResult<zx_handle_t> {
        let mut zircon_handle = MaybeUninit::<zx_handle_t>::uninit();

        let __result = (self.commands().get_semaphore_zircon_handle_fuchsia)(
            self.handle(),
            get_zircon_handle_info,
            zircon_handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(zircon_handle.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkImportSemaphoreZirconHandleFUCHSIA.html>
    #[inline]
    unsafe fn import_semaphore_zircon_handle_fuchsia(
        &self,
        import_semaphore_zircon_handle_info: &ImportSemaphoreZirconHandleInfoFUCHSIA,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().import_semaphore_zircon_handle_fuchsia)(
            self.handle(),
            import_semaphore_zircon_handle_info,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl FuchsiaExternalSemaphoreExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_FUCHSIA_imagepipe_surface.html>
pub trait FuchsiaImagepipeSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = FUCHSIA_IMAGEPIPE_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateImagePipeSurfaceFUCHSIA.html>
    #[inline]
    unsafe fn create_image_pipe_surface_fuchsia(
        &self,
        create_info: &ImagePipeSurfaceCreateInfoFUCHSIA,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_image_pipe_surface_fuchsia)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl FuchsiaImagepipeSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GGP_frame_token.html>
pub trait GgpFrameTokenExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GGP_FRAME_TOKEN_EXTENSION;
}

impl GgpFrameTokenExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GGP_stream_descriptor_surface.html>
pub trait GgpStreamDescriptorSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GGP_STREAM_DESCRIPTOR_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateStreamDescriptorSurfaceGGP.html>
    #[inline]
    unsafe fn create_stream_descriptor_surface_ggp(
        &self,
        create_info: &StreamDescriptorSurfaceCreateInfoGGP,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_stream_descriptor_surface_ggp)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl GgpStreamDescriptorSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GOOGLE_decorate_string.html>
pub trait GoogleDecorateStringExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GOOGLE_DECORATE_STRING_EXTENSION;
}

impl GoogleDecorateStringExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GOOGLE_display_timing.html>
pub trait GoogleDisplayTimingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GOOGLE_DISPLAY_TIMING_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPastPresentationTimingGOOGLE.html>
    #[inline]
    unsafe fn get_past_presentation_timing_google(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<Vec<PastPresentationTimingGOOGLE>> {
        let mut presentation_timing_count = 0;

        (self.commands().get_past_presentation_timing_google)(
            self.handle(),
            swapchain,
            &mut presentation_timing_count,
            ptr::null_mut(),
        );

        let mut presentation_timings = Vec::with_capacity(presentation_timing_count as usize);

        let __result = (self.commands().get_past_presentation_timing_google)(
            self.handle(),
            swapchain,
            &mut presentation_timing_count,
            presentation_timings.as_mut_ptr(),
        );

        debug_assert!(presentation_timings.capacity() == presentation_timing_count as usize);
        presentation_timings.set_len(presentation_timing_count as usize);

        if __result == Result::SUCCESS {
            Ok(presentation_timings)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRefreshCycleDurationGOOGLE.html>
    #[inline]
    unsafe fn get_refresh_cycle_duration_google(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<RefreshCycleDurationGOOGLE> {
        let mut display_timing_properties = MaybeUninit::<RefreshCycleDurationGOOGLE>::uninit();

        let __result = (self.commands().get_refresh_cycle_duration_google)(
            self.handle(),
            swapchain,
            display_timing_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(display_timing_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl GoogleDisplayTimingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GOOGLE_hlsl_functionality1.html>
pub trait GoogleHlslFunctionality1Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GOOGLE_HLSL_FUNCTIONALITY1_EXTENSION;
}

impl GoogleHlslFunctionality1Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_GOOGLE_user_type.html>
pub trait GoogleUserTypeExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = GOOGLE_USER_TYPE_EXTENSION;
}

impl GoogleUserTypeExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_HUAWEI_subpass_shading.html>
pub trait HuaweiSubpassShadingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = HUAWEI_SUBPASS_SHADING_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSubpassShadingHUAWEI.html>
    #[inline]
    unsafe fn cmd_subpass_shading_huawei(&self, command_buffer: CommandBuffer) {
        let __result = (self.commands().cmd_subpass_shading_huawei)(command_buffer);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI.html>
    #[inline]
    unsafe fn get_device_subpass_shading_max_workgroup_size_huawei(
        &self,
        renderpass: RenderPass,
    ) -> crate::VkResult<Extent2D> {
        let mut max_workgroup_size = MaybeUninit::<Extent2D>::uninit();

        let __result = (self
            .commands()
            .get_device_subpass_shading_max_workgroup_size_huawei)(
            self.handle(),
            renderpass,
            max_workgroup_size.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(max_workgroup_size.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl HuaweiSubpassShadingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_IMG_filter_cubic.html>
pub trait ImgFilterCubicExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = IMG_FILTER_CUBIC_EXTENSION;
}

impl ImgFilterCubicExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_IMG_format_pvrtc.html>
pub trait ImgFormatPvrtcExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = IMG_FORMAT_PVRTC_EXTENSION;
}

impl ImgFormatPvrtcExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_INTEL_performance_query.html>
pub trait IntelPerformanceQueryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = INTEL_PERFORMANCE_QUERY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquirePerformanceConfigurationINTEL.html>
    #[inline]
    unsafe fn acquire_performance_configuration_intel(
        &self,
        acquire_info: &PerformanceConfigurationAcquireInfoINTEL,
    ) -> crate::VkResult<PerformanceConfigurationINTEL> {
        let mut configuration = MaybeUninit::<PerformanceConfigurationINTEL>::uninit();

        let __result = (self.commands().acquire_performance_configuration_intel)(
            self.handle(),
            acquire_info,
            configuration.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(configuration.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPerformanceMarkerINTEL.html>
    #[inline]
    unsafe fn cmd_set_performance_marker_intel(
        &self,
        command_buffer: CommandBuffer,
        marker_info: &PerformanceMarkerInfoINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().cmd_set_performance_marker_intel)(command_buffer, marker_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPerformanceOverrideINTEL.html>
    #[inline]
    unsafe fn cmd_set_performance_override_intel(
        &self,
        command_buffer: CommandBuffer,
        override_info: &PerformanceOverrideInfoINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().cmd_set_performance_override_intel)(command_buffer, override_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetPerformanceStreamMarkerINTEL.html>
    #[inline]
    unsafe fn cmd_set_performance_stream_marker_intel(
        &self,
        command_buffer: CommandBuffer,
        marker_info: &PerformanceStreamMarkerInfoINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().cmd_set_performance_stream_marker_intel)(command_buffer, marker_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPerformanceParameterINTEL.html>
    #[inline]
    unsafe fn get_performance_parameter_intel(
        &self,
        parameter: PerformanceParameterTypeINTEL,
    ) -> crate::VkResult<PerformanceValueINTEL> {
        let mut value = MaybeUninit::<PerformanceValueINTEL>::uninit();

        let __result = (self.commands().get_performance_parameter_intel)(
            self.handle(),
            parameter,
            value.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(value.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkInitializePerformanceApiINTEL.html>
    #[inline]
    unsafe fn initialize_performance_api_intel(
        &self,
        initialize_info: &InitializePerformanceApiInfoINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().initialize_performance_api_intel)(self.handle(), initialize_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueSetPerformanceConfigurationINTEL.html>
    #[inline]
    unsafe fn queue_set_performance_configuration_intel(
        &self,
        queue: Queue,
        configuration: PerformanceConfigurationINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().queue_set_performance_configuration_intel)(queue, configuration);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkReleasePerformanceConfigurationINTEL.html>
    #[inline]
    unsafe fn release_performance_configuration_intel(
        &self,
        configuration: PerformanceConfigurationINTEL,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().release_performance_configuration_intel)(self.handle(), configuration);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkUninitializePerformanceApiINTEL.html>
    #[inline]
    unsafe fn uninitialize_performance_api_intel(&self) {
        let __result = (self.commands().uninitialize_performance_api_intel)(self.handle());
    }
}

impl IntelPerformanceQueryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_INTEL_shader_integer_functions2.html>
pub trait IntelShaderIntegerFunctions2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = INTEL_SHADER_INTEGER_FUNCTIONS2_EXTENSION;
}

impl IntelShaderIntegerFunctions2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_16bit_storage.html>
pub trait Khr16bitStorageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_16BIT_STORAGE_EXTENSION;
}

impl Khr16bitStorageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_8bit_storage.html>
pub trait Khr8bitStorageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_8BIT_STORAGE_EXTENSION;
}

impl Khr8bitStorageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_acceleration_structure.html>
pub trait KhrAccelerationStructureExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_ACCELERATION_STRUCTURE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBuildAccelerationStructuresKHR.html>
    #[inline]
    unsafe fn build_acceleration_structures_khr(
        &self,
        deferred_operation: DeferredOperationKHR,
        infos: &[impl Cast<Target = AccelerationStructureBuildGeometryInfoKHR>],
        build_range_infos: &[&AccelerationStructureBuildRangeInfoKHR],
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().build_acceleration_structures_khr)(
            self.handle(),
            deferred_operation,
            infos.len() as u32,
            infos.as_ptr().cast(),
            build_range_infos.as_ptr().cast(),
        );

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBuildAccelerationStructuresIndirectKHR.html>
    #[inline]
    unsafe fn cmd_build_acceleration_structures_indirect_khr(
        &self,
        command_buffer: CommandBuffer,
        infos: &[impl Cast<Target = AccelerationStructureBuildGeometryInfoKHR>],
        indirect_device_addresses: &[DeviceAddress],
        indirect_strides: &[u32],
        max_primitive_counts: &[&u32],
    ) {
        let __result = (self
            .commands()
            .cmd_build_acceleration_structures_indirect_khr)(
            command_buffer,
            infos.len() as u32,
            infos.as_ptr().cast(),
            indirect_device_addresses.as_ptr(),
            indirect_strides.as_ptr(),
            max_primitive_counts.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBuildAccelerationStructuresKHR.html>
    #[inline]
    unsafe fn cmd_build_acceleration_structures_khr(
        &self,
        command_buffer: CommandBuffer,
        infos: &[impl Cast<Target = AccelerationStructureBuildGeometryInfoKHR>],
        build_range_infos: &[&AccelerationStructureBuildRangeInfoKHR],
    ) {
        let __result = (self.commands().cmd_build_acceleration_structures_khr)(
            command_buffer,
            infos.len() as u32,
            infos.as_ptr().cast(),
            build_range_infos.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyAccelerationStructureKHR.html>
    #[inline]
    unsafe fn cmd_copy_acceleration_structure_khr(
        &self,
        command_buffer: CommandBuffer,
        info: &CopyAccelerationStructureInfoKHR,
    ) {
        let __result = (self.commands().cmd_copy_acceleration_structure_khr)(command_buffer, info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyAccelerationStructureToMemoryKHR.html>
    #[inline]
    unsafe fn cmd_copy_acceleration_structure_to_memory_khr(
        &self,
        command_buffer: CommandBuffer,
        info: &CopyAccelerationStructureToMemoryInfoKHR,
    ) {
        let __result =
            (self
                .commands()
                .cmd_copy_acceleration_structure_to_memory_khr)(command_buffer, info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyMemoryToAccelerationStructureKHR.html>
    #[inline]
    unsafe fn cmd_copy_memory_to_acceleration_structure_khr(
        &self,
        command_buffer: CommandBuffer,
        info: &CopyMemoryToAccelerationStructureInfoKHR,
    ) {
        let __result =
            (self
                .commands()
                .cmd_copy_memory_to_acceleration_structure_khr)(command_buffer, info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteAccelerationStructuresPropertiesKHR.html>
    #[inline]
    unsafe fn cmd_write_acceleration_structures_properties_khr(
        &self,
        command_buffer: CommandBuffer,
        acceleration_structures: &[AccelerationStructureKHR],
        query_type: QueryType,
        query_pool: QueryPool,
        first_query: u32,
    ) {
        let __result = (self
            .commands()
            .cmd_write_acceleration_structures_properties_khr)(
            command_buffer,
            acceleration_structures.len() as u32,
            acceleration_structures.as_ptr(),
            query_type,
            query_pool,
            first_query,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCopyAccelerationStructureKHR.html>
    #[inline]
    unsafe fn copy_acceleration_structure_khr(
        &self,
        deferred_operation: DeferredOperationKHR,
        info: &CopyAccelerationStructureInfoKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().copy_acceleration_structure_khr)(
            self.handle(),
            deferred_operation,
            info,
        );

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCopyAccelerationStructureToMemoryKHR.html>
    #[inline]
    unsafe fn copy_acceleration_structure_to_memory_khr(
        &self,
        deferred_operation: DeferredOperationKHR,
        info: &CopyAccelerationStructureToMemoryInfoKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().copy_acceleration_structure_to_memory_khr)(
            self.handle(),
            deferred_operation,
            info,
        );

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCopyMemoryToAccelerationStructureKHR.html>
    #[inline]
    unsafe fn copy_memory_to_acceleration_structure_khr(
        &self,
        deferred_operation: DeferredOperationKHR,
        info: &CopyMemoryToAccelerationStructureInfoKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().copy_memory_to_acceleration_structure_khr)(
            self.handle(),
            deferred_operation,
            info,
        );

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateAccelerationStructureKHR.html>
    #[inline]
    unsafe fn create_acceleration_structure_khr(
        &self,
        create_info: &AccelerationStructureCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<AccelerationStructureKHR> {
        let mut acceleration_structure = MaybeUninit::<AccelerationStructureKHR>::uninit();

        let __result = (self.commands().create_acceleration_structure_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            acceleration_structure.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(acceleration_structure.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyAccelerationStructureKHR.html>
    #[inline]
    unsafe fn destroy_acceleration_structure_khr(
        &self,
        acceleration_structure: AccelerationStructureKHR,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_acceleration_structure_khr)(
            self.handle(),
            acceleration_structure,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetAccelerationStructureBuildSizesKHR.html>
    #[inline]
    unsafe fn get_acceleration_structure_build_sizes_khr(
        &self,
        build_type: AccelerationStructureBuildTypeKHR,
        build_info: &AccelerationStructureBuildGeometryInfoKHR,
    ) -> (Vec<u32>, AccelerationStructureBuildSizesInfoKHR) {
        let mut max_primitive_counts =
            Vec::with_capacity(build_info.as_ref().geometry_count as usize);
        let mut size_info = MaybeUninit::<AccelerationStructureBuildSizesInfoKHR>::uninit();

        let __result = (self.commands().get_acceleration_structure_build_sizes_khr)(
            self.handle(),
            build_type,
            build_info,
            max_primitive_counts.as_mut_ptr(),
            size_info.as_mut_ptr(),
        );

        max_primitive_counts.set_len(build_info.as_ref().geometry_count as usize);

        (max_primitive_counts, size_info.assume_init())
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetAccelerationStructureDeviceAddressKHR.html>
    #[inline]
    unsafe fn get_acceleration_structure_device_address_khr(
        &self,
        info: &AccelerationStructureDeviceAddressInfoKHR,
    ) {
        let __result =
            (self
                .commands()
                .get_acceleration_structure_device_address_khr)(self.handle(), info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceAccelerationStructureCompatibilityKHR.html>
    #[inline]
    unsafe fn get_device_acceleration_structure_compatibility_khr(
        &self,
        version_info: &AccelerationStructureVersionInfoKHR,
    ) -> AccelerationStructureCompatibilityKHR {
        let mut compatibility = MaybeUninit::<AccelerationStructureCompatibilityKHR>::uninit();

        let __result = (self
            .commands()
            .get_device_acceleration_structure_compatibility_khr)(
            self.handle(),
            version_info,
            compatibility.as_mut_ptr(),
        );

        compatibility.assume_init()
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkWriteAccelerationStructuresPropertiesKHR.html>
    #[inline]
    unsafe fn write_acceleration_structures_properties_khr(
        &self,
        acceleration_structures: &[AccelerationStructureKHR],
        query_type: QueryType,
        data: &mut [u8],
        stride: usize,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().write_acceleration_structures_properties_khr)(
            self.handle(),
            acceleration_structures.len() as u32,
            acceleration_structures.as_ptr(),
            query_type,
            data.len() as usize,
            data.as_ptr() as *mut c_void,
            stride,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrAccelerationStructureExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_android_surface.html>
pub trait KhrAndroidSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_ANDROID_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateAndroidSurfaceKHR.html>
    #[inline]
    unsafe fn create_android_surface_khr(
        &self,
        create_info: &AndroidSurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_android_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrAndroidSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_bind_memory2.html>
pub trait KhrBindMemory2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_BIND_MEMORY2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindBufferMemory2KHR.html>
    #[inline]
    unsafe fn bind_buffer_memory2_khr(
        &self,
        bind_infos: &[impl Cast<Target = BindBufferMemoryInfo>],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().bind_buffer_memory2_khr)(
            self.handle(),
            bind_infos.len() as u32,
            bind_infos.as_ptr().cast(),
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindImageMemory2KHR.html>
    #[inline]
    unsafe fn bind_image_memory2_khr(
        &self,
        bind_infos: &[impl Cast<Target = BindImageMemoryInfo>],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().bind_image_memory2_khr)(
            self.handle(),
            bind_infos.len() as u32,
            bind_infos.as_ptr().cast(),
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrBindMemory2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_buffer_device_address.html>
pub trait KhrBufferDeviceAddressExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_BUFFER_DEVICE_ADDRESS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferDeviceAddressKHR.html>
    #[inline]
    unsafe fn get_buffer_device_address_khr(&self, info: &BufferDeviceAddressInfo) {
        let __result = (self.commands().get_buffer_device_address_khr)(self.handle(), info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferOpaqueCaptureAddressKHR.html>
    #[inline]
    unsafe fn get_buffer_opaque_capture_address_khr(&self, info: &BufferDeviceAddressInfo) {
        let __result = (self.commands().get_buffer_opaque_capture_address_khr)(self.handle(), info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceMemoryOpaqueCaptureAddressKHR.html>
    #[inline]
    unsafe fn get_device_memory_opaque_capture_address_khr(
        &self,
        info: &DeviceMemoryOpaqueCaptureAddressInfo,
    ) {
        let __result =
            (self.commands().get_device_memory_opaque_capture_address_khr)(self.handle(), info);
    }
}

impl KhrBufferDeviceAddressExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_copy_commands2.html>
pub trait KhrCopyCommands2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_COPY_COMMANDS2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBlitImage2KHR.html>
    #[inline]
    unsafe fn cmd_blit_image2_khr(
        &self,
        command_buffer: CommandBuffer,
        blit_image_info: &BlitImageInfo2KHR,
    ) {
        let __result = (self.commands().cmd_blit_image2_khr)(command_buffer, blit_image_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyBuffer2KHR.html>
    #[inline]
    unsafe fn cmd_copy_buffer2_khr(
        &self,
        command_buffer: CommandBuffer,
        copy_buffer_info: &CopyBufferInfo2KHR,
    ) {
        let __result = (self.commands().cmd_copy_buffer2_khr)(command_buffer, copy_buffer_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyBufferToImage2KHR.html>
    #[inline]
    unsafe fn cmd_copy_buffer_to_image2_khr(
        &self,
        command_buffer: CommandBuffer,
        copy_buffer_to_image_info: &CopyBufferToImageInfo2KHR,
    ) {
        let __result = (self.commands().cmd_copy_buffer_to_image2_khr)(
            command_buffer,
            copy_buffer_to_image_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyImage2KHR.html>
    #[inline]
    unsafe fn cmd_copy_image2_khr(
        &self,
        command_buffer: CommandBuffer,
        copy_image_info: &CopyImageInfo2KHR,
    ) {
        let __result = (self.commands().cmd_copy_image2_khr)(command_buffer, copy_image_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyImageToBuffer2KHR.html>
    #[inline]
    unsafe fn cmd_copy_image_to_buffer2_khr(
        &self,
        command_buffer: CommandBuffer,
        copy_image_to_buffer_info: &CopyImageToBufferInfo2KHR,
    ) {
        let __result = (self.commands().cmd_copy_image_to_buffer2_khr)(
            command_buffer,
            copy_image_to_buffer_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdResolveImage2KHR.html>
    #[inline]
    unsafe fn cmd_resolve_image2_khr(
        &self,
        command_buffer: CommandBuffer,
        resolve_image_info: &ResolveImageInfo2KHR,
    ) {
        let __result = (self.commands().cmd_resolve_image2_khr)(command_buffer, resolve_image_info);
    }
}

impl KhrCopyCommands2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_create_renderpass2.html>
pub trait KhrCreateRenderpass2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_CREATE_RENDERPASS2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginRenderPass2KHR.html>
    #[inline]
    unsafe fn cmd_begin_render_pass2_khr(
        &self,
        command_buffer: CommandBuffer,
        render_pass_begin: &RenderPassBeginInfo,
        subpass_begin_info: &SubpassBeginInfo,
    ) {
        let __result = (self.commands().cmd_begin_render_pass2_khr)(
            command_buffer,
            render_pass_begin,
            subpass_begin_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndRenderPass2KHR.html>
    #[inline]
    unsafe fn cmd_end_render_pass2_khr(
        &self,
        command_buffer: CommandBuffer,
        subpass_end_info: &SubpassEndInfo,
    ) {
        let __result = (self.commands().cmd_end_render_pass2_khr)(command_buffer, subpass_end_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdNextSubpass2KHR.html>
    #[inline]
    unsafe fn cmd_next_subpass2_khr(
        &self,
        command_buffer: CommandBuffer,
        subpass_begin_info: &SubpassBeginInfo,
        subpass_end_info: &SubpassEndInfo,
    ) {
        let __result = (self.commands().cmd_next_subpass2_khr)(
            command_buffer,
            subpass_begin_info,
            subpass_end_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateRenderPass2KHR.html>
    #[inline]
    unsafe fn create_render_pass2_khr(
        &self,
        create_info: &RenderPassCreateInfo2,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<RenderPass> {
        let mut render_pass = MaybeUninit::<RenderPass>::uninit();

        let __result = (self.commands().create_render_pass2_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            render_pass.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(render_pass.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrCreateRenderpass2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_dedicated_allocation.html>
pub trait KhrDedicatedAllocationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DEDICATED_ALLOCATION_EXTENSION;
}

impl KhrDedicatedAllocationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_deferred_host_operations.html>
pub trait KhrDeferredHostOperationsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DEFERRED_HOST_OPERATIONS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDeferredOperationKHR.html>
    #[inline]
    unsafe fn create_deferred_operation_khr(
        &self,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<DeferredOperationKHR> {
        let mut deferred_operation = MaybeUninit::<DeferredOperationKHR>::uninit();

        let __result = (self.commands().create_deferred_operation_khr)(
            self.handle(),
            allocator.map_or(ptr::null(), |v| v),
            deferred_operation.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(deferred_operation.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDeferredOperationJoinKHR.html>
    #[inline]
    unsafe fn deferred_operation_join_khr(
        &self,
        operation: DeferredOperationKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().deferred_operation_join_khr)(self.handle(), operation);

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDeferredOperationKHR.html>
    #[inline]
    unsafe fn destroy_deferred_operation_khr(
        &self,
        operation: DeferredOperationKHR,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_deferred_operation_khr)(
            self.handle(),
            operation,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeferredOperationMaxConcurrencyKHR.html>
    #[inline]
    unsafe fn get_deferred_operation_max_concurrency_khr(&self, operation: DeferredOperationKHR) {
        let __result =
            (self.commands().get_deferred_operation_max_concurrency_khr)(self.handle(), operation);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeferredOperationResultKHR.html>
    #[inline]
    unsafe fn get_deferred_operation_result_khr(
        &self,
        operation: DeferredOperationKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result =
            (self.commands().get_deferred_operation_result_khr)(self.handle(), operation);

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrDeferredHostOperationsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_depth_stencil_resolve.html>
pub trait KhrDepthStencilResolveExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DEPTH_STENCIL_RESOLVE_EXTENSION;
}

impl KhrDepthStencilResolveExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_descriptor_update_template.html>
pub trait KhrDescriptorUpdateTemplateExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPushDescriptorSetWithTemplateKHR.html>
    #[inline]
    unsafe fn cmd_push_descriptor_set_with_template_khr(
        &self,
        command_buffer: CommandBuffer,
        descriptor_update_template: DescriptorUpdateTemplate,
        layout: PipelineLayout,
        set: u32,
        data: &c_void,
    ) {
        let __result = (self.commands().cmd_push_descriptor_set_with_template_khr)(
            command_buffer,
            descriptor_update_template,
            layout,
            set,
            data,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDescriptorUpdateTemplateKHR.html>
    #[inline]
    unsafe fn create_descriptor_update_template_khr(
        &self,
        create_info: &DescriptorUpdateTemplateCreateInfo,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<DescriptorUpdateTemplate> {
        let mut descriptor_update_template = MaybeUninit::<DescriptorUpdateTemplate>::uninit();

        let __result = (self.commands().create_descriptor_update_template_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            descriptor_update_template.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(descriptor_update_template.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDescriptorUpdateTemplateKHR.html>
    #[inline]
    unsafe fn destroy_descriptor_update_template_khr(
        &self,
        descriptor_update_template: DescriptorUpdateTemplate,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_descriptor_update_template_khr)(
            self.handle(),
            descriptor_update_template,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkUpdateDescriptorSetWithTemplateKHR.html>
    #[inline]
    unsafe fn update_descriptor_set_with_template_khr(
        &self,
        descriptor_set: DescriptorSet,
        descriptor_update_template: DescriptorUpdateTemplate,
        data: &c_void,
    ) {
        let __result = (self.commands().update_descriptor_set_with_template_khr)(
            self.handle(),
            descriptor_set,
            descriptor_update_template,
            data,
        );
    }
}

impl KhrDescriptorUpdateTemplateExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_device_group.html>
pub trait KhrDeviceGroupExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DEVICE_GROUP_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireNextImage2KHR.html>
    #[inline]
    unsafe fn acquire_next_image2_khr(
        &self,
        acquire_info: &AcquireNextImageInfoKHR,
    ) -> crate::VkSuccessResult<u32> {
        let mut image_index = MaybeUninit::<u32>::uninit();

        let __result = (self.commands().acquire_next_image2_khr)(
            self.handle(),
            acquire_info,
            image_index.as_mut_ptr(),
        );

        if __result >= Result::SUCCESS {
            Ok((image_index.assume_init(), __result.into()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatchBaseKHR.html>
    #[inline]
    unsafe fn cmd_dispatch_base_khr(
        &self,
        command_buffer: CommandBuffer,
        base_group_x: u32,
        base_group_y: u32,
        base_group_z: u32,
        group_count_x: u32,
        group_count_y: u32,
        group_count_z: u32,
    ) {
        let __result = (self.commands().cmd_dispatch_base_khr)(
            command_buffer,
            base_group_x,
            base_group_y,
            base_group_z,
            group_count_x,
            group_count_y,
            group_count_z,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDeviceMaskKHR.html>
    #[inline]
    unsafe fn cmd_set_device_mask_khr(&self, command_buffer: CommandBuffer, device_mask: u32) {
        let __result = (self.commands().cmd_set_device_mask_khr)(command_buffer, device_mask);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html>
    #[inline]
    unsafe fn get_device_group_peer_memory_features_khr(
        &self,
        heap_index: u32,
        local_device_index: u32,
        remote_device_index: u32,
    ) -> PeerMemoryFeatureFlags {
        let mut peer_memory_features = MaybeUninit::<PeerMemoryFeatureFlags>::uninit();

        let __result = (self.commands().get_device_group_peer_memory_features_khr)(
            self.handle(),
            heap_index,
            local_device_index,
            remote_device_index,
            peer_memory_features.as_mut_ptr(),
        );

        peer_memory_features.assume_init()
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPresentCapabilitiesKHR.html>
    #[inline]
    unsafe fn get_device_group_present_capabilities_khr(
        &self,
    ) -> crate::VkResult<DeviceGroupPresentCapabilitiesKHR> {
        let mut device_group_present_capabilities =
            MaybeUninit::<DeviceGroupPresentCapabilitiesKHR>::uninit();

        let __result = (self.commands().get_device_group_present_capabilities_khr)(
            self.handle(),
            device_group_present_capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(device_group_present_capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupSurfacePresentModesKHR.html>
    #[inline]
    unsafe fn get_device_group_surface_present_modes_khr(
        &self,
        surface: SurfaceKHR,
    ) -> crate::VkResult<DeviceGroupPresentModeFlagsKHR> {
        let mut modes = MaybeUninit::<DeviceGroupPresentModeFlagsKHR>::uninit();

        let __result = (self.commands().get_device_group_surface_present_modes_khr)(
            self.handle(),
            surface,
            modes.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(modes.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDevicePresentRectanglesKHR.html>
    #[inline]
    unsafe fn get_physical_device_present_rectangles_khr(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<Vec<Rect2D>> {
        let mut rect_count = 0;

        (self.commands().get_physical_device_present_rectangles_khr)(
            physical_device,
            surface,
            &mut rect_count,
            ptr::null_mut(),
        );

        let mut rects = Vec::with_capacity(rect_count as usize);

        let __result = (self.commands().get_physical_device_present_rectangles_khr)(
            physical_device,
            surface,
            &mut rect_count,
            rects.as_mut_ptr(),
        );

        debug_assert!(rects.capacity() == rect_count as usize);
        rects.set_len(rect_count as usize);

        if __result == Result::SUCCESS {
            Ok(rects)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrDeviceGroupExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_device_group_creation.html>
pub trait KhrDeviceGroupCreationExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DEVICE_GROUP_CREATION_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumeratePhysicalDeviceGroupsKHR.html>
    #[inline]
    unsafe fn enumerate_physical_device_groups_khr(
        &self,
    ) -> crate::VkResult<Vec<PhysicalDeviceGroupProperties>> {
        let mut physical_device_group_count = 0;

        (self.commands().enumerate_physical_device_groups_khr)(
            self.handle(),
            &mut physical_device_group_count,
            ptr::null_mut(),
        );

        let mut physical_device_group_properties =
            Vec::with_capacity(physical_device_group_count as usize);

        let __result = (self.commands().enumerate_physical_device_groups_khr)(
            self.handle(),
            &mut physical_device_group_count,
            physical_device_group_properties.as_mut_ptr(),
        );

        debug_assert!(
            physical_device_group_properties.capacity() == physical_device_group_count as usize
        );
        physical_device_group_properties.set_len(physical_device_group_count as usize);

        if __result == Result::SUCCESS {
            Ok(physical_device_group_properties)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrDeviceGroupCreationExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_display.html>
pub trait KhrDisplayExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DISPLAY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDisplayModeKHR.html>
    #[inline]
    unsafe fn create_display_mode_khr(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
        create_info: &DisplayModeCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<DisplayModeKHR> {
        let mut mode = MaybeUninit::<DisplayModeKHR>::uninit();

        let __result = (self.commands().create_display_mode_khr)(
            physical_device,
            display,
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            mode.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(mode.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDisplayPlaneSurfaceKHR.html>
    #[inline]
    unsafe fn create_display_plane_surface_khr(
        &self,
        create_info: &DisplaySurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_display_plane_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDisplayModePropertiesKHR.html>
    #[inline]
    unsafe fn get_display_mode_properties_khr(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
    ) -> crate::VkResult<Vec<DisplayModePropertiesKHR>> {
        let mut property_count = 0;

        (self.commands().get_display_mode_properties_khr)(
            physical_device,
            display,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self.commands().get_display_mode_properties_khr)(
            physical_device,
            display,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDisplayPlaneCapabilitiesKHR.html>
    #[inline]
    unsafe fn get_display_plane_capabilities_khr(
        &self,
        physical_device: PhysicalDevice,
        mode: DisplayModeKHR,
        plane_index: u32,
    ) -> crate::VkResult<DisplayPlaneCapabilitiesKHR> {
        let mut capabilities = MaybeUninit::<DisplayPlaneCapabilitiesKHR>::uninit();

        let __result = (self.commands().get_display_plane_capabilities_khr)(
            physical_device,
            mode,
            plane_index,
            capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDisplayPlaneSupportedDisplaysKHR.html>
    #[inline]
    unsafe fn get_display_plane_supported_displays_khr(
        &self,
        physical_device: PhysicalDevice,
        plane_index: u32,
    ) -> crate::VkResult<Vec<DisplayKHR>> {
        let mut display_count = 0;

        (self.commands().get_display_plane_supported_displays_khr)(
            physical_device,
            plane_index,
            &mut display_count,
            ptr::null_mut(),
        );

        let mut displays = Vec::with_capacity(display_count as usize);

        let __result = (self.commands().get_display_plane_supported_displays_khr)(
            physical_device,
            plane_index,
            &mut display_count,
            displays.as_mut_ptr(),
        );

        debug_assert!(displays.capacity() == display_count as usize);
        displays.set_len(display_count as usize);

        if __result == Result::SUCCESS {
            Ok(displays)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceDisplayPlanePropertiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_display_plane_properties_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<DisplayPlanePropertiesKHR>> {
        let mut property_count = 0;

        (self
            .commands()
            .get_physical_device_display_plane_properties_khr)(
            physical_device,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_display_plane_properties_khr)(
            physical_device,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceDisplayPropertiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_display_properties_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<DisplayPropertiesKHR>> {
        let mut property_count = 0;

        (self.commands().get_physical_device_display_properties_khr)(
            physical_device,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self.commands().get_physical_device_display_properties_khr)(
            physical_device,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrDisplayExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_display_swapchain.html>
pub trait KhrDisplaySwapchainExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DISPLAY_SWAPCHAIN_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSharedSwapchainsKHR.html>
    #[inline]
    unsafe fn create_shared_swapchains_khr(
        &self,
        create_infos: &[impl Cast<Target = SwapchainCreateInfoKHR>],
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SwapchainKHR> {
        let mut swapchains = MaybeUninit::<SwapchainKHR>::uninit();

        let __result = (self.commands().create_shared_swapchains_khr)(
            self.handle(),
            create_infos.len() as u32,
            create_infos.as_ptr().cast(),
            allocator.map_or(ptr::null(), |v| v),
            swapchains.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(swapchains.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrDisplaySwapchainExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_draw_indirect_count.html>
pub trait KhrDrawIndirectCountExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DRAW_INDIRECT_COUNT_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndexedIndirectCountKHR.html>
    #[inline]
    unsafe fn cmd_draw_indexed_indirect_count_khr(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_indexed_indirect_count_khr)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndirectCountKHR.html>
    #[inline]
    unsafe fn cmd_draw_indirect_count_khr(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_indirect_count_khr)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        );
    }
}

impl KhrDrawIndirectCountExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_driver_properties.html>
pub trait KhrDriverPropertiesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_DRIVER_PROPERTIES_EXTENSION;
}

impl KhrDriverPropertiesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_fence.html>
pub trait KhrExternalFenceExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_FENCE_EXTENSION;
}

impl KhrExternalFenceExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_fence_capabilities.html>
pub trait KhrExternalFenceCapabilitiesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalFencePropertiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_external_fence_properties_khr(
        &self,
        physical_device: PhysicalDevice,
        external_fence_info: &PhysicalDeviceExternalFenceInfo,
    ) -> ExternalFenceProperties {
        let mut external_fence_properties = MaybeUninit::<ExternalFenceProperties>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_external_fence_properties_khr)(
            physical_device,
            external_fence_info,
            external_fence_properties.as_mut_ptr(),
        );

        external_fence_properties.assume_init()
    }
}

impl KhrExternalFenceCapabilitiesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_fence_fd.html>
pub trait KhrExternalFenceFdExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_FENCE_FD_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetFenceFdKHR.html>
    #[inline]
    unsafe fn get_fence_fd_khr(&self, get_fd_info: &FenceGetFdInfoKHR) -> crate::VkResult<c_int> {
        let mut fd = MaybeUninit::<c_int>::uninit();

        let __result =
            (self.commands().get_fence_fd_khr)(self.handle(), get_fd_info, fd.as_mut_ptr());

        if __result == Result::SUCCESS {
            Ok(fd.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkImportFenceFdKHR.html>
    #[inline]
    unsafe fn import_fence_fd_khr(
        &self,
        import_fence_fd_info: &ImportFenceFdInfoKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().import_fence_fd_khr)(self.handle(), import_fence_fd_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalFenceFdExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_fence_win32.html>
pub trait KhrExternalFenceWin32Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_FENCE_WIN32_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetFenceWin32HandleKHR.html>
    #[inline]
    unsafe fn get_fence_win32_handle_khr(
        &self,
        get_win32_handle_info: &FenceGetWin32HandleInfoKHR,
    ) -> crate::VkResult<HANDLE> {
        let mut handle = MaybeUninit::<HANDLE>::uninit();

        let __result = (self.commands().get_fence_win32_handle_khr)(
            self.handle(),
            get_win32_handle_info,
            handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(handle.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkImportFenceWin32HandleKHR.html>
    #[inline]
    unsafe fn import_fence_win32_handle_khr(
        &self,
        import_fence_win32_handle_info: &ImportFenceWin32HandleInfoKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().import_fence_win32_handle_khr)(
            self.handle(),
            import_fence_win32_handle_info,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalFenceWin32Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_memory.html>
pub trait KhrExternalMemoryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_MEMORY_EXTENSION;
}

impl KhrExternalMemoryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_memory_capabilities.html>
pub trait KhrExternalMemoryCapabilitiesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalBufferPropertiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_external_buffer_properties_khr(
        &self,
        physical_device: PhysicalDevice,
        external_buffer_info: &PhysicalDeviceExternalBufferInfo,
    ) -> ExternalBufferProperties {
        let mut external_buffer_properties = MaybeUninit::<ExternalBufferProperties>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_external_buffer_properties_khr)(
            physical_device,
            external_buffer_info,
            external_buffer_properties.as_mut_ptr(),
        );

        external_buffer_properties.assume_init()
    }
}

impl KhrExternalMemoryCapabilitiesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_memory_fd.html>
pub trait KhrExternalMemoryFdExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_MEMORY_FD_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryFdKHR.html>
    #[inline]
    unsafe fn get_memory_fd_khr(&self, get_fd_info: &MemoryGetFdInfoKHR) -> crate::VkResult<c_int> {
        let mut fd = MaybeUninit::<c_int>::uninit();

        let __result =
            (self.commands().get_memory_fd_khr)(self.handle(), get_fd_info, fd.as_mut_ptr());

        if __result == Result::SUCCESS {
            Ok(fd.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryFdPropertiesKHR.html>
    #[inline]
    unsafe fn get_memory_fd_properties_khr(
        &self,
        handle_type: ExternalMemoryHandleTypeFlags,
        fd: c_int,
    ) -> crate::VkResult<MemoryFdPropertiesKHR> {
        let mut memory_fd_properties = MaybeUninit::<MemoryFdPropertiesKHR>::uninit();

        let __result = (self.commands().get_memory_fd_properties_khr)(
            self.handle(),
            handle_type,
            fd,
            memory_fd_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(memory_fd_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalMemoryFdExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_memory_win32.html>
pub trait KhrExternalMemoryWin32Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_MEMORY_WIN32_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryWin32HandleKHR.html>
    #[inline]
    unsafe fn get_memory_win32_handle_khr(
        &self,
        get_win32_handle_info: &MemoryGetWin32HandleInfoKHR,
    ) -> crate::VkResult<HANDLE> {
        let mut handle = MaybeUninit::<HANDLE>::uninit();

        let __result = (self.commands().get_memory_win32_handle_khr)(
            self.handle(),
            get_win32_handle_info,
            handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(handle.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryWin32HandlePropertiesKHR.html>
    #[inline]
    unsafe fn get_memory_win32_handle_properties_khr(
        &self,
        handle_type: ExternalMemoryHandleTypeFlags,
        handle: HANDLE,
    ) -> crate::VkResult<MemoryWin32HandlePropertiesKHR> {
        let mut memory_win32_handle_properties =
            MaybeUninit::<MemoryWin32HandlePropertiesKHR>::uninit();

        let __result = (self.commands().get_memory_win32_handle_properties_khr)(
            self.handle(),
            handle_type,
            handle,
            memory_win32_handle_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(memory_win32_handle_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalMemoryWin32Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_semaphore.html>
pub trait KhrExternalSemaphoreExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_SEMAPHORE_EXTENSION;
}

impl KhrExternalSemaphoreExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_semaphore_capabilities.html>
pub trait KhrExternalSemaphoreCapabilitiesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalSemaphorePropertiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_external_semaphore_properties_khr(
        &self,
        physical_device: PhysicalDevice,
        external_semaphore_info: &PhysicalDeviceExternalSemaphoreInfo,
    ) -> ExternalSemaphoreProperties {
        let mut external_semaphore_properties =
            MaybeUninit::<ExternalSemaphoreProperties>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_external_semaphore_properties_khr)(
            physical_device,
            external_semaphore_info,
            external_semaphore_properties.as_mut_ptr(),
        );

        external_semaphore_properties.assume_init()
    }
}

impl KhrExternalSemaphoreCapabilitiesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_semaphore_fd.html>
pub trait KhrExternalSemaphoreFdExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSemaphoreFdKHR.html>
    #[inline]
    unsafe fn get_semaphore_fd_khr(
        &self,
        get_fd_info: &SemaphoreGetFdInfoKHR,
    ) -> crate::VkResult<c_int> {
        let mut fd = MaybeUninit::<c_int>::uninit();

        let __result =
            (self.commands().get_semaphore_fd_khr)(self.handle(), get_fd_info, fd.as_mut_ptr());

        if __result == Result::SUCCESS {
            Ok(fd.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkImportSemaphoreFdKHR.html>
    #[inline]
    unsafe fn import_semaphore_fd_khr(
        &self,
        import_semaphore_fd_info: &ImportSemaphoreFdInfoKHR,
    ) -> crate::VkResult<()> {
        let __result =
            (self.commands().import_semaphore_fd_khr)(self.handle(), import_semaphore_fd_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalSemaphoreFdExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_external_semaphore_win32.html>
pub trait KhrExternalSemaphoreWin32Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSemaphoreWin32HandleKHR.html>
    #[inline]
    unsafe fn get_semaphore_win32_handle_khr(
        &self,
        get_win32_handle_info: &SemaphoreGetWin32HandleInfoKHR,
    ) -> crate::VkResult<HANDLE> {
        let mut handle = MaybeUninit::<HANDLE>::uninit();

        let __result = (self.commands().get_semaphore_win32_handle_khr)(
            self.handle(),
            get_win32_handle_info,
            handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(handle.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkImportSemaphoreWin32HandleKHR.html>
    #[inline]
    unsafe fn import_semaphore_win32_handle_khr(
        &self,
        import_semaphore_win32_handle_info: &ImportSemaphoreWin32HandleInfoKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().import_semaphore_win32_handle_khr)(
            self.handle(),
            import_semaphore_win32_handle_info,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrExternalSemaphoreWin32Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_fragment_shading_rate.html>
pub trait KhrFragmentShadingRateExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_FRAGMENT_SHADING_RATE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetFragmentShadingRateKHR.html>
    #[inline]
    unsafe fn cmd_set_fragment_shading_rate_khr(
        &self,
        command_buffer: CommandBuffer,
        fragment_size: &Extent2D,
        combiner_ops: [FragmentShadingRateCombinerOpKHR; 2],
    ) {
        let __result = (self.commands().cmd_set_fragment_shading_rate_khr)(
            command_buffer,
            fragment_size,
            combiner_ops.as_ptr(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFragmentShadingRatesKHR.html>
    #[inline]
    unsafe fn get_physical_device_fragment_shading_rates_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<PhysicalDeviceFragmentShadingRateKHR>> {
        let mut fragment_shading_rate_count = 0;

        (self
            .commands()
            .get_physical_device_fragment_shading_rates_khr)(
            physical_device,
            &mut fragment_shading_rate_count,
            ptr::null_mut(),
        );

        let mut fragment_shading_rates = Vec::with_capacity(fragment_shading_rate_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_fragment_shading_rates_khr)(
            physical_device,
            &mut fragment_shading_rate_count,
            fragment_shading_rates.as_mut_ptr(),
        );

        debug_assert!(fragment_shading_rates.capacity() == fragment_shading_rate_count as usize);
        fragment_shading_rates.set_len(fragment_shading_rate_count as usize);

        if __result == Result::SUCCESS {
            Ok(fragment_shading_rates)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrFragmentShadingRateExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_get_display_properties2.html>
pub trait KhrGetDisplayProperties2Extension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_GET_DISPLAY_PROPERTIES2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDisplayModeProperties2KHR.html>
    #[inline]
    unsafe fn get_display_mode_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
    ) -> crate::VkResult<Vec<DisplayModeProperties2KHR>> {
        let mut property_count = 0;

        (self.commands().get_display_mode_properties2_khr)(
            physical_device,
            display,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self.commands().get_display_mode_properties2_khr)(
            physical_device,
            display,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDisplayPlaneCapabilities2KHR.html>
    #[inline]
    unsafe fn get_display_plane_capabilities2_khr(
        &self,
        physical_device: PhysicalDevice,
        display_plane_info: &DisplayPlaneInfo2KHR,
    ) -> crate::VkResult<DisplayPlaneCapabilities2KHR> {
        let mut capabilities = MaybeUninit::<DisplayPlaneCapabilities2KHR>::uninit();

        let __result = (self.commands().get_display_plane_capabilities2_khr)(
            physical_device,
            display_plane_info,
            capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceDisplayPlaneProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_display_plane_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<DisplayPlaneProperties2KHR>> {
        let mut property_count = 0;

        (self
            .commands()
            .get_physical_device_display_plane_properties2_khr)(
            physical_device,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_display_plane_properties2_khr)(
            physical_device,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceDisplayProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_display_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<DisplayProperties2KHR>> {
        let mut property_count = 0;

        (self.commands().get_physical_device_display_properties2_khr)(
            physical_device,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self.commands().get_physical_device_display_properties2_khr)(
            physical_device,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrGetDisplayProperties2Extension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_get_memory_requirements2.html>
pub trait KhrGetMemoryRequirements2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_GET_MEMORY_REQUIREMENTS2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferMemoryRequirements2KHR.html>
    #[inline]
    unsafe fn get_buffer_memory_requirements2_khr(
        &self,
        info: &BufferMemoryRequirementsInfo2,
        memory_requirements: &mut MemoryRequirements2,
    ) {
        let __result = (self.commands().get_buffer_memory_requirements2_khr)(
            self.handle(),
            info,
            memory_requirements,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageMemoryRequirements2KHR.html>
    #[inline]
    unsafe fn get_image_memory_requirements2_khr(
        &self,
        info: &ImageMemoryRequirementsInfo2,
        memory_requirements: &mut MemoryRequirements2,
    ) {
        let __result = (self.commands().get_image_memory_requirements2_khr)(
            self.handle(),
            info,
            memory_requirements,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageSparseMemoryRequirements2KHR.html>
    #[inline]
    unsafe fn get_image_sparse_memory_requirements2_khr(
        &self,
        info: &ImageSparseMemoryRequirementsInfo2,
    ) -> Vec<SparseImageMemoryRequirements2> {
        let mut sparse_memory_requirement_count = 0;

        (self.commands().get_image_sparse_memory_requirements2_khr)(
            self.handle(),
            info,
            &mut sparse_memory_requirement_count,
            ptr::null_mut(),
        );

        let mut sparse_memory_requirements =
            Vec::with_capacity(sparse_memory_requirement_count as usize);

        let __result = (self.commands().get_image_sparse_memory_requirements2_khr)(
            self.handle(),
            info,
            &mut sparse_memory_requirement_count,
            sparse_memory_requirements.as_mut_ptr(),
        );

        debug_assert!(
            sparse_memory_requirements.capacity() == sparse_memory_requirement_count as usize
        );
        sparse_memory_requirements.set_len(sparse_memory_requirement_count as usize);

        sparse_memory_requirements
    }
}

impl KhrGetMemoryRequirements2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_get_physical_device_properties2.html>
pub trait KhrGetPhysicalDeviceProperties2Extension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_GET_PHYSICAL_DEVICE_PROPERTIES2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFeatures2KHR.html>
    #[inline]
    unsafe fn get_physical_device_features2_khr(
        &self,
        physical_device: PhysicalDevice,
        features: &mut PhysicalDeviceFeatures2,
    ) {
        let __result =
            (self.commands().get_physical_device_features2_khr)(physical_device, features);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFormatProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_format_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        format_properties: &mut FormatProperties2,
    ) {
        let __result = (self.commands().get_physical_device_format_properties2_khr)(
            physical_device,
            format,
            format_properties,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceImageFormatProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_image_format_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        image_format_info: &PhysicalDeviceImageFormatInfo2,
        image_format_properties: &mut ImageFormatProperties2,
    ) -> crate::VkResult<()> {
        let __result = (self
            .commands()
            .get_physical_device_image_format_properties2_khr)(
            physical_device,
            image_format_info,
            image_format_properties,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceMemoryProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_memory_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        memory_properties: &mut PhysicalDeviceMemoryProperties2,
    ) {
        let __result = (self.commands().get_physical_device_memory_properties2_khr)(
            physical_device,
            memory_properties,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        properties: &mut PhysicalDeviceProperties2,
    ) {
        let __result =
            (self.commands().get_physical_device_properties2_khr)(physical_device, properties);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceQueueFamilyProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_queue_family_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
    ) -> Vec<QueueFamilyProperties2> {
        let mut queue_family_property_count = 0;

        (self
            .commands()
            .get_physical_device_queue_family_properties2_khr)(
            physical_device,
            &mut queue_family_property_count,
            ptr::null_mut(),
        );

        let mut queue_family_properties = Vec::with_capacity(queue_family_property_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_queue_family_properties2_khr)(
            physical_device,
            &mut queue_family_property_count,
            queue_family_properties.as_mut_ptr(),
        );

        debug_assert!(queue_family_properties.capacity() == queue_family_property_count as usize);
        queue_family_properties.set_len(queue_family_property_count as usize);

        queue_family_properties
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSparseImageFormatProperties2KHR.html>
    #[inline]
    unsafe fn get_physical_device_sparse_image_format_properties2_khr(
        &self,
        physical_device: PhysicalDevice,
        format_info: &PhysicalDeviceSparseImageFormatInfo2,
    ) -> Vec<SparseImageFormatProperties2> {
        let mut property_count = 0;

        (self
            .commands()
            .get_physical_device_sparse_image_format_properties2_khr)(
            physical_device,
            format_info,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_sparse_image_format_properties2_khr)(
            physical_device,
            format_info,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        properties
    }
}

impl KhrGetPhysicalDeviceProperties2Extension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_get_surface_capabilities2.html>
pub trait KhrGetSurfaceCapabilities2Extension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_GET_SURFACE_CAPABILITIES2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceCapabilities2KHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_capabilities2_khr(
        &self,
        physical_device: PhysicalDevice,
        surface_info: &PhysicalDeviceSurfaceInfo2KHR,
        surface_capabilities: &mut SurfaceCapabilities2KHR,
    ) -> crate::VkResult<()> {
        let __result = (self
            .commands()
            .get_physical_device_surface_capabilities2_khr)(
            physical_device,
            surface_info,
            surface_capabilities,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceFormats2KHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_formats2_khr(
        &self,
        physical_device: PhysicalDevice,
        surface_info: &PhysicalDeviceSurfaceInfo2KHR,
    ) -> crate::VkResult<Vec<SurfaceFormat2KHR>> {
        let mut surface_format_count = 0;

        (self.commands().get_physical_device_surface_formats2_khr)(
            physical_device,
            surface_info,
            &mut surface_format_count,
            ptr::null_mut(),
        );

        let mut surface_formats = Vec::with_capacity(surface_format_count as usize);

        let __result = (self.commands().get_physical_device_surface_formats2_khr)(
            physical_device,
            surface_info,
            &mut surface_format_count,
            surface_formats.as_mut_ptr(),
        );

        debug_assert!(surface_formats.capacity() == surface_format_count as usize);
        surface_formats.set_len(surface_format_count as usize);

        if __result == Result::SUCCESS {
            Ok(surface_formats)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrGetSurfaceCapabilities2Extension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_image_format_list.html>
pub trait KhrImageFormatListExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_IMAGE_FORMAT_LIST_EXTENSION;
}

impl KhrImageFormatListExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_imageless_framebuffer.html>
pub trait KhrImagelessFramebufferExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_IMAGELESS_FRAMEBUFFER_EXTENSION;
}

impl KhrImagelessFramebufferExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_incremental_present.html>
pub trait KhrIncrementalPresentExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_INCREMENTAL_PRESENT_EXTENSION;
}

impl KhrIncrementalPresentExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_maintenance1.html>
pub trait KhrMaintenance1Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_MAINTENANCE1_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkTrimCommandPoolKHR.html>
    #[inline]
    unsafe fn trim_command_pool_khr(&self, command_pool: CommandPool, flags: CommandPoolTrimFlags) {
        let __result = (self.commands().trim_command_pool_khr)(self.handle(), command_pool, flags);
    }
}

impl KhrMaintenance1Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_maintenance2.html>
pub trait KhrMaintenance2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_MAINTENANCE2_EXTENSION;
}

impl KhrMaintenance2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_maintenance3.html>
pub trait KhrMaintenance3Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_MAINTENANCE3_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDescriptorSetLayoutSupportKHR.html>
    #[inline]
    unsafe fn get_descriptor_set_layout_support_khr(
        &self,
        create_info: &DescriptorSetLayoutCreateInfo,
        support: &mut DescriptorSetLayoutSupport,
    ) {
        let __result = (self.commands().get_descriptor_set_layout_support_khr)(
            self.handle(),
            create_info,
            support,
        );
    }
}

impl KhrMaintenance3Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_multiview.html>
pub trait KhrMultiviewExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_MULTIVIEW_EXTENSION;
}

impl KhrMultiviewExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_performance_query.html>
pub trait KhrPerformanceQueryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_PERFORMANCE_QUERY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireProfilingLockKHR.html>
    #[inline]
    unsafe fn acquire_profiling_lock_khr(
        &self,
        info: &AcquireProfilingLockInfoKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().acquire_profiling_lock_khr)(self.handle(), info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR.html>
    #[inline]
    unsafe fn enumerate_physical_device_queue_family_performance_query_counters_khr(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
    ) -> crate::VkResult<(
        Vec<PerformanceCounterKHR>,
        Vec<PerformanceCounterDescriptionKHR>,
    )> {
        let mut counter_count = 0;

        (self
            .commands()
            .enumerate_physical_device_queue_family_performance_query_counters_khr)(
            physical_device,
            queue_family_index,
            &mut counter_count,
            ptr::null_mut(),
            ptr::null_mut(),
        );

        let mut counters = Vec::with_capacity(counter_count as usize);
        let mut counter_descriptions = Vec::with_capacity(counter_count as usize);

        let __result = (self
            .commands()
            .enumerate_physical_device_queue_family_performance_query_counters_khr)(
            physical_device,
            queue_family_index,
            &mut counter_count,
            counters.as_mut_ptr(),
            counter_descriptions.as_mut_ptr(),
        );

        debug_assert!(counters.capacity() == counter_count as usize);
        counters.set_len(counter_count as usize);
        debug_assert!(counter_descriptions.capacity() == counter_count as usize);
        counter_descriptions.set_len(counter_count as usize);

        if __result == Result::SUCCESS {
            Ok((counters, counter_descriptions))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR.html>
    #[inline]
    unsafe fn get_physical_device_queue_family_performance_query_passes_khr(
        &self,
        physical_device: PhysicalDevice,
        performance_query_create_info: &QueryPoolPerformanceCreateInfoKHR,
    ) -> u32 {
        let mut num_passes = MaybeUninit::<u32>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_queue_family_performance_query_passes_khr)(
            physical_device,
            performance_query_create_info,
            num_passes.as_mut_ptr(),
        );

        num_passes.assume_init()
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkReleaseProfilingLockKHR.html>
    #[inline]
    unsafe fn release_profiling_lock_khr(&self) {
        let __result = (self.commands().release_profiling_lock_khr)(self.handle());
    }
}

impl KhrPerformanceQueryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_pipeline_executable_properties.html>
pub trait KhrPipelineExecutablePropertiesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPipelineExecutableInternalRepresentationsKHR.html>
    #[inline]
    unsafe fn get_pipeline_executable_internal_representations_khr(
        &self,
        executable_info: &PipelineExecutableInfoKHR,
    ) -> crate::VkResult<Vec<PipelineExecutableInternalRepresentationKHR>> {
        let mut internal_representation_count = 0;

        (self
            .commands()
            .get_pipeline_executable_internal_representations_khr)(
            self.handle(),
            executable_info,
            &mut internal_representation_count,
            ptr::null_mut(),
        );

        let mut internal_representations =
            Vec::with_capacity(internal_representation_count as usize);

        let __result = (self
            .commands()
            .get_pipeline_executable_internal_representations_khr)(
            self.handle(),
            executable_info,
            &mut internal_representation_count,
            internal_representations.as_mut_ptr(),
        );

        debug_assert!(
            internal_representations.capacity() == internal_representation_count as usize
        );
        internal_representations.set_len(internal_representation_count as usize);

        if __result == Result::SUCCESS {
            Ok(internal_representations)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPipelineExecutablePropertiesKHR.html>
    #[inline]
    unsafe fn get_pipeline_executable_properties_khr(
        &self,
        pipeline_info: &PipelineInfoKHR,
    ) -> crate::VkResult<Vec<PipelineExecutablePropertiesKHR>> {
        let mut executable_count = 0;

        (self.commands().get_pipeline_executable_properties_khr)(
            self.handle(),
            pipeline_info,
            &mut executable_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(executable_count as usize);

        let __result = (self.commands().get_pipeline_executable_properties_khr)(
            self.handle(),
            pipeline_info,
            &mut executable_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == executable_count as usize);
        properties.set_len(executable_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPipelineExecutableStatisticsKHR.html>
    #[inline]
    unsafe fn get_pipeline_executable_statistics_khr(
        &self,
        executable_info: &PipelineExecutableInfoKHR,
    ) -> crate::VkResult<Vec<PipelineExecutableStatisticKHR>> {
        let mut statistic_count = 0;

        (self.commands().get_pipeline_executable_statistics_khr)(
            self.handle(),
            executable_info,
            &mut statistic_count,
            ptr::null_mut(),
        );

        let mut statistics = Vec::with_capacity(statistic_count as usize);

        let __result = (self.commands().get_pipeline_executable_statistics_khr)(
            self.handle(),
            executable_info,
            &mut statistic_count,
            statistics.as_mut_ptr(),
        );

        debug_assert!(statistics.capacity() == statistic_count as usize);
        statistics.set_len(statistic_count as usize);

        if __result == Result::SUCCESS {
            Ok(statistics)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrPipelineExecutablePropertiesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_pipeline_library.html>
pub trait KhrPipelineLibraryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_PIPELINE_LIBRARY_EXTENSION;
}

impl KhrPipelineLibraryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_portability_subset.html>
///
/// ## WARNING
///
/// This is a
/// [provisional extension](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/provisional-headers.html).
/// Provisional extensions are not guaranteed to be backwards compatible and are
/// not intended to be used in production applications.
#[cfg(feature = "provisional")]
pub trait KhrPortabilitySubsetExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_PORTABILITY_SUBSET_EXTENSION;
}

#[cfg(feature = "provisional")]
impl KhrPortabilitySubsetExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_push_descriptor.html>
pub trait KhrPushDescriptorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_PUSH_DESCRIPTOR_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPushDescriptorSetKHR.html>
    #[inline]
    unsafe fn cmd_push_descriptor_set_khr(
        &self,
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        layout: PipelineLayout,
        set: u32,
        descriptor_writes: &[impl Cast<Target = WriteDescriptorSet>],
    ) {
        let __result = (self.commands().cmd_push_descriptor_set_khr)(
            command_buffer,
            pipeline_bind_point,
            layout,
            set,
            descriptor_writes.len() as u32,
            descriptor_writes.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPushDescriptorSetWithTemplateKHR.html>
    #[inline]
    unsafe fn cmd_push_descriptor_set_with_template_khr(
        &self,
        command_buffer: CommandBuffer,
        descriptor_update_template: DescriptorUpdateTemplate,
        layout: PipelineLayout,
        set: u32,
        data: &c_void,
    ) {
        let __result = (self.commands().cmd_push_descriptor_set_with_template_khr)(
            command_buffer,
            descriptor_update_template,
            layout,
            set,
            data,
        );
    }
}

impl KhrPushDescriptorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_ray_query.html>
pub trait KhrRayQueryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_RAY_QUERY_EXTENSION;
}

impl KhrRayQueryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_ray_tracing_pipeline.html>
pub trait KhrRayTracingPipelineExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_RAY_TRACING_PIPELINE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetRayTracingPipelineStackSizeKHR.html>
    #[inline]
    unsafe fn cmd_set_ray_tracing_pipeline_stack_size_khr(
        &self,
        command_buffer: CommandBuffer,
        pipeline_stack_size: u32,
    ) {
        let __result = (self.commands().cmd_set_ray_tracing_pipeline_stack_size_khr)(
            command_buffer,
            pipeline_stack_size,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdTraceRaysIndirectKHR.html>
    #[inline]
    unsafe fn cmd_trace_rays_indirect_khr(
        &self,
        command_buffer: CommandBuffer,
        raygen_shader_binding_table: &StridedDeviceAddressRegionKHR,
        miss_shader_binding_table: &StridedDeviceAddressRegionKHR,
        hit_shader_binding_table: &StridedDeviceAddressRegionKHR,
        callable_shader_binding_table: &StridedDeviceAddressRegionKHR,
        indirect_device_address: DeviceAddress,
    ) {
        let __result = (self.commands().cmd_trace_rays_indirect_khr)(
            command_buffer,
            raygen_shader_binding_table,
            miss_shader_binding_table,
            hit_shader_binding_table,
            callable_shader_binding_table,
            indirect_device_address,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdTraceRaysKHR.html>
    #[inline]
    unsafe fn cmd_trace_rays_khr(
        &self,
        command_buffer: CommandBuffer,
        raygen_shader_binding_table: &StridedDeviceAddressRegionKHR,
        miss_shader_binding_table: &StridedDeviceAddressRegionKHR,
        hit_shader_binding_table: &StridedDeviceAddressRegionKHR,
        callable_shader_binding_table: &StridedDeviceAddressRegionKHR,
        width: u32,
        height: u32,
        depth: u32,
    ) {
        let __result = (self.commands().cmd_trace_rays_khr)(
            command_buffer,
            raygen_shader_binding_table,
            miss_shader_binding_table,
            hit_shader_binding_table,
            callable_shader_binding_table,
            width,
            height,
            depth,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateRayTracingPipelinesKHR.html>
    #[inline]
    unsafe fn create_ray_tracing_pipelines_khr(
        &self,
        deferred_operation: DeferredOperationKHR,
        pipeline_cache: PipelineCache,
        create_infos: &[impl Cast<Target = RayTracingPipelineCreateInfoKHR>],
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkSuccessResult<Pipeline> {
        let mut pipelines = MaybeUninit::<Pipeline>::uninit();

        let __result = (self.commands().create_ray_tracing_pipelines_khr)(
            self.handle(),
            deferred_operation,
            pipeline_cache,
            create_infos.len() as u32,
            create_infos.as_ptr().cast(),
            allocator.map_or(ptr::null(), |v| v),
            pipelines.as_mut_ptr(),
        );

        if __result >= Result::SUCCESS {
            Ok((pipelines.assume_init(), __result.into()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html>
    #[inline]
    unsafe fn get_ray_tracing_capture_replay_shader_group_handles_khr(
        &self,
        pipeline: Pipeline,
        first_group: u32,
        group_count: u32,
        data: &mut [u8],
    ) -> crate::VkResult<()> {
        let __result = (self
            .commands()
            .get_ray_tracing_capture_replay_shader_group_handles_khr)(
            self.handle(),
            pipeline,
            first_group,
            group_count,
            data.len() as usize,
            data.as_ptr() as *mut c_void,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRayTracingShaderGroupHandlesKHR.html>
    #[inline]
    unsafe fn get_ray_tracing_shader_group_handles_khr(
        &self,
        pipeline: Pipeline,
        first_group: u32,
        group_count: u32,
        data: &mut [u8],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().get_ray_tracing_shader_group_handles_khr)(
            self.handle(),
            pipeline,
            first_group,
            group_count,
            data.len() as usize,
            data.as_ptr() as *mut c_void,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRayTracingShaderGroupStackSizeKHR.html>
    #[inline]
    unsafe fn get_ray_tracing_shader_group_stack_size_khr(
        &self,
        pipeline: Pipeline,
        group: u32,
        group_shader: ShaderGroupShaderKHR,
    ) {
        let __result = (self.commands().get_ray_tracing_shader_group_stack_size_khr)(
            self.handle(),
            pipeline,
            group,
            group_shader,
        );
    }
}

impl KhrRayTracingPipelineExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_relaxed_block_layout.html>
pub trait KhrRelaxedBlockLayoutExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_RELAXED_BLOCK_LAYOUT_EXTENSION;
}

impl KhrRelaxedBlockLayoutExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_sampler_mirror_clamp_to_edge.html>
pub trait KhrSamplerMirrorClampToEdgeExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION;
}

impl KhrSamplerMirrorClampToEdgeExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_sampler_ycbcr_conversion.html>
pub trait KhrSamplerYcbcrConversionExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSamplerYcbcrConversionKHR.html>
    #[inline]
    unsafe fn create_sampler_ycbcr_conversion_khr(
        &self,
        create_info: &SamplerYcbcrConversionCreateInfo,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SamplerYcbcrConversion> {
        let mut ycbcr_conversion = MaybeUninit::<SamplerYcbcrConversion>::uninit();

        let __result = (self.commands().create_sampler_ycbcr_conversion_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            ycbcr_conversion.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(ycbcr_conversion.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySamplerYcbcrConversionKHR.html>
    #[inline]
    unsafe fn destroy_sampler_ycbcr_conversion_khr(
        &self,
        ycbcr_conversion: SamplerYcbcrConversion,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_sampler_ycbcr_conversion_khr)(
            self.handle(),
            ycbcr_conversion,
            allocator.map_or(ptr::null(), |v| v),
        );
    }
}

impl KhrSamplerYcbcrConversionExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_separate_depth_stencil_layouts.html>
pub trait KhrSeparateDepthStencilLayoutsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION;
}

impl KhrSeparateDepthStencilLayoutsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_atomic_int64.html>
pub trait KhrShaderAtomicInt64Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_ATOMIC_INT64_EXTENSION;
}

impl KhrShaderAtomicInt64Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_clock.html>
pub trait KhrShaderClockExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_CLOCK_EXTENSION;
}

impl KhrShaderClockExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_draw_parameters.html>
pub trait KhrShaderDrawParametersExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_DRAW_PARAMETERS_EXTENSION;
}

impl KhrShaderDrawParametersExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_float16_int8.html>
pub trait KhrShaderFloat16Int8Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_FLOAT16_INT8_EXTENSION;
}

impl KhrShaderFloat16Int8Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_float_controls.html>
pub trait KhrShaderFloatControlsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_FLOAT_CONTROLS_EXTENSION;
}

impl KhrShaderFloatControlsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_non_semantic_info.html>
pub trait KhrShaderNonSemanticInfoExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION;
}

impl KhrShaderNonSemanticInfoExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_subgroup_extended_types.html>
pub trait KhrShaderSubgroupExtendedTypesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION;
}

impl KhrShaderSubgroupExtendedTypesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_subgroup_uniform_control_flow.html>
pub trait KhrShaderSubgroupUniformControlFlowExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_EXTENSION;
}

impl KhrShaderSubgroupUniformControlFlowExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shader_terminate_invocation.html>
pub trait KhrShaderTerminateInvocationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHADER_TERMINATE_INVOCATION_EXTENSION;
}

impl KhrShaderTerminateInvocationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_shared_presentable_image.html>
pub trait KhrSharedPresentableImageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSwapchainStatusKHR.html>
    #[inline]
    unsafe fn get_swapchain_status_khr(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().get_swapchain_status_khr)(self.handle(), swapchain);

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrSharedPresentableImageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_spirv_1_4.html>
pub trait KhrSpirv14Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SPIRV_1_4_EXTENSION;
}

impl KhrSpirv14Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_storage_buffer_storage_class.html>
pub trait KhrStorageBufferStorageClassExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION;
}

impl KhrStorageBufferStorageClassExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_surface.html>
pub trait KhrSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySurfaceKHR.html>
    #[inline]
    unsafe fn destroy_surface_khr(
        &self,
        surface: SurfaceKHR,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_surface_khr)(
            self.handle(),
            surface,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceCapabilitiesKHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_capabilities_khr(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<SurfaceCapabilitiesKHR> {
        let mut surface_capabilities = MaybeUninit::<SurfaceCapabilitiesKHR>::uninit();

        let __result = (self.commands().get_physical_device_surface_capabilities_khr)(
            physical_device,
            surface,
            surface_capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface_capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceFormatsKHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_formats_khr(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<Vec<SurfaceFormatKHR>> {
        let mut surface_format_count = 0;

        (self.commands().get_physical_device_surface_formats_khr)(
            physical_device,
            surface,
            &mut surface_format_count,
            ptr::null_mut(),
        );

        let mut surface_formats = Vec::with_capacity(surface_format_count as usize);

        let __result = (self.commands().get_physical_device_surface_formats_khr)(
            physical_device,
            surface,
            &mut surface_format_count,
            surface_formats.as_mut_ptr(),
        );

        debug_assert!(surface_formats.capacity() == surface_format_count as usize);
        surface_formats.set_len(surface_format_count as usize);

        if __result == Result::SUCCESS {
            Ok(surface_formats)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfacePresentModesKHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_present_modes_khr(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<Vec<PresentModeKHR>> {
        let mut present_mode_count = 0;

        (self
            .commands()
            .get_physical_device_surface_present_modes_khr)(
            physical_device,
            surface,
            &mut present_mode_count,
            ptr::null_mut(),
        );

        let mut present_modes = Vec::with_capacity(present_mode_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_surface_present_modes_khr)(
            physical_device,
            surface,
            &mut present_mode_count,
            present_modes.as_mut_ptr(),
        );

        debug_assert!(present_modes.capacity() == present_mode_count as usize);
        present_modes.set_len(present_mode_count as usize);

        if __result == Result::SUCCESS {
            Ok(present_modes)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSurfaceSupportKHR.html>
    #[inline]
    unsafe fn get_physical_device_surface_support_khr(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
        surface: SurfaceKHR,
    ) -> crate::VkResult<bool> {
        let mut supported = MaybeUninit::<Bool32>::uninit();

        let __result = (self.commands().get_physical_device_surface_support_khr)(
            physical_device,
            queue_family_index,
            surface,
            supported.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(supported.assume_init() == TRUE)
        } else {
            Err(__result.into())
        }
    }
}

impl KhrSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_surface_protected_capabilities.html>
pub trait KhrSurfaceProtectedCapabilitiesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION;
}

impl KhrSurfaceProtectedCapabilitiesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_swapchain.html>
pub trait KhrSwapchainExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SWAPCHAIN_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireNextImage2KHR.html>
    #[inline]
    unsafe fn acquire_next_image2_khr(
        &self,
        acquire_info: &AcquireNextImageInfoKHR,
    ) -> crate::VkSuccessResult<u32> {
        let mut image_index = MaybeUninit::<u32>::uninit();

        let __result = (self.commands().acquire_next_image2_khr)(
            self.handle(),
            acquire_info,
            image_index.as_mut_ptr(),
        );

        if __result >= Result::SUCCESS {
            Ok((image_index.assume_init(), __result.into()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireNextImageKHR.html>
    #[inline]
    unsafe fn acquire_next_image_khr(
        &self,
        swapchain: SwapchainKHR,
        timeout: u64,
        semaphore: Semaphore,
        fence: Fence,
    ) -> crate::VkSuccessResult<u32> {
        let mut image_index = MaybeUninit::<u32>::uninit();

        let __result = (self.commands().acquire_next_image_khr)(
            self.handle(),
            swapchain,
            timeout,
            semaphore,
            fence,
            image_index.as_mut_ptr(),
        );

        if __result >= Result::SUCCESS {
            Ok((image_index.assume_init(), __result.into()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSwapchainKHR.html>
    #[inline]
    unsafe fn create_swapchain_khr(
        &self,
        create_info: &SwapchainCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SwapchainKHR> {
        let mut swapchain = MaybeUninit::<SwapchainKHR>::uninit();

        let __result = (self.commands().create_swapchain_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            swapchain.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(swapchain.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySwapchainKHR.html>
    #[inline]
    unsafe fn destroy_swapchain_khr(
        &self,
        swapchain: SwapchainKHR,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_swapchain_khr)(
            self.handle(),
            swapchain,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPresentCapabilitiesKHR.html>
    #[inline]
    unsafe fn get_device_group_present_capabilities_khr(
        &self,
    ) -> crate::VkResult<DeviceGroupPresentCapabilitiesKHR> {
        let mut device_group_present_capabilities =
            MaybeUninit::<DeviceGroupPresentCapabilitiesKHR>::uninit();

        let __result = (self.commands().get_device_group_present_capabilities_khr)(
            self.handle(),
            device_group_present_capabilities.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(device_group_present_capabilities.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupSurfacePresentModesKHR.html>
    #[inline]
    unsafe fn get_device_group_surface_present_modes_khr(
        &self,
        surface: SurfaceKHR,
    ) -> crate::VkResult<DeviceGroupPresentModeFlagsKHR> {
        let mut modes = MaybeUninit::<DeviceGroupPresentModeFlagsKHR>::uninit();

        let __result = (self.commands().get_device_group_surface_present_modes_khr)(
            self.handle(),
            surface,
            modes.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(modes.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDevicePresentRectanglesKHR.html>
    #[inline]
    unsafe fn get_physical_device_present_rectangles_khr(
        &self,
        physical_device: PhysicalDevice,
        surface: SurfaceKHR,
    ) -> crate::VkResult<Vec<Rect2D>> {
        let mut rect_count = 0;

        (self.commands().get_physical_device_present_rectangles_khr)(
            physical_device,
            surface,
            &mut rect_count,
            ptr::null_mut(),
        );

        let mut rects = Vec::with_capacity(rect_count as usize);

        let __result = (self.commands().get_physical_device_present_rectangles_khr)(
            physical_device,
            surface,
            &mut rect_count,
            rects.as_mut_ptr(),
        );

        debug_assert!(rects.capacity() == rect_count as usize);
        rects.set_len(rect_count as usize);

        if __result == Result::SUCCESS {
            Ok(rects)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSwapchainImagesKHR.html>
    #[inline]
    unsafe fn get_swapchain_images_khr(
        &self,
        swapchain: SwapchainKHR,
    ) -> crate::VkResult<Vec<Image>> {
        let mut swapchain_image_count = 0;

        (self.commands().get_swapchain_images_khr)(
            self.handle(),
            swapchain,
            &mut swapchain_image_count,
            ptr::null_mut(),
        );

        let mut swapchain_images = Vec::with_capacity(swapchain_image_count as usize);

        let __result = (self.commands().get_swapchain_images_khr)(
            self.handle(),
            swapchain,
            &mut swapchain_image_count,
            swapchain_images.as_mut_ptr(),
        );

        debug_assert!(swapchain_images.capacity() == swapchain_image_count as usize);
        swapchain_images.set_len(swapchain_image_count as usize);

        if __result == Result::SUCCESS {
            Ok(swapchain_images)
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueuePresentKHR.html>
    #[inline]
    unsafe fn queue_present_khr(
        &self,
        queue: Queue,
        present_info: &PresentInfoKHR,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().queue_present_khr)(queue, present_info);

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrSwapchainExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_swapchain_mutable_format.html>
pub trait KhrSwapchainMutableFormatExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION;
}

impl KhrSwapchainMutableFormatExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_synchronization2.html>
pub trait KhrSynchronization2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_SYNCHRONIZATION2_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPipelineBarrier2KHR.html>
    #[inline]
    unsafe fn cmd_pipeline_barrier2_khr(
        &self,
        command_buffer: CommandBuffer,
        dependency_info: &DependencyInfoKHR,
    ) {
        let __result = (self.commands().cmd_pipeline_barrier2_khr)(command_buffer, dependency_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdResetEvent2KHR.html>
    #[inline]
    unsafe fn cmd_reset_event2_khr(
        &self,
        command_buffer: CommandBuffer,
        event: Event,
        stage_mask: PipelineStageFlags2KHR,
    ) {
        let __result = (self.commands().cmd_reset_event2_khr)(command_buffer, event, stage_mask);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetEvent2KHR.html>
    #[inline]
    unsafe fn cmd_set_event2_khr(
        &self,
        command_buffer: CommandBuffer,
        event: Event,
        dependency_info: &DependencyInfoKHR,
    ) {
        let __result = (self.commands().cmd_set_event2_khr)(command_buffer, event, dependency_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWaitEvents2KHR.html>
    #[inline]
    unsafe fn cmd_wait_events2_khr(
        &self,
        command_buffer: CommandBuffer,
        events: &[Event],
        dependency_infos: &[impl Cast<Target = DependencyInfoKHR>],
    ) {
        let __result = (self.commands().cmd_wait_events2_khr)(
            command_buffer,
            events.len() as u32,
            events.as_ptr(),
            dependency_infos.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteBufferMarker2AMD.html>
    #[inline]
    unsafe fn cmd_write_buffer_marker2_amd(
        &self,
        command_buffer: CommandBuffer,
        stage: PipelineStageFlags2KHR,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        marker: u32,
    ) {
        let __result = (self.commands().cmd_write_buffer_marker2_amd)(
            command_buffer,
            stage,
            dst_buffer,
            dst_offset,
            marker,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteTimestamp2KHR.html>
    #[inline]
    unsafe fn cmd_write_timestamp2_khr(
        &self,
        command_buffer: CommandBuffer,
        stage: PipelineStageFlags2KHR,
        query_pool: QueryPool,
        query: u32,
    ) {
        let __result =
            (self.commands().cmd_write_timestamp2_khr)(command_buffer, stage, query_pool, query);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetQueueCheckpointData2NV.html>
    #[inline]
    unsafe fn get_queue_checkpoint_data2_nv(&self, queue: Queue) -> Vec<CheckpointData2NV> {
        let mut checkpoint_data_count = 0;

        (self.commands().get_queue_checkpoint_data2_nv)(
            queue,
            &mut checkpoint_data_count,
            ptr::null_mut(),
        );

        let mut checkpoint_data = Vec::with_capacity(checkpoint_data_count as usize);

        let __result = (self.commands().get_queue_checkpoint_data2_nv)(
            queue,
            &mut checkpoint_data_count,
            checkpoint_data.as_mut_ptr(),
        );

        debug_assert!(checkpoint_data.capacity() == checkpoint_data_count as usize);
        checkpoint_data.set_len(checkpoint_data_count as usize);

        checkpoint_data
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueSubmit2KHR.html>
    #[inline]
    unsafe fn queue_submit2_khr(
        &self,
        queue: Queue,
        submits: &[impl Cast<Target = SubmitInfo2KHR>],
        fence: Fence,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().queue_submit2_khr)(
            queue,
            submits.len() as u32,
            submits.as_ptr().cast(),
            fence,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrSynchronization2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_timeline_semaphore.html>
pub trait KhrTimelineSemaphoreExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_TIMELINE_SEMAPHORE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSemaphoreCounterValueKHR.html>
    #[inline]
    unsafe fn get_semaphore_counter_value_khr(&self, semaphore: Semaphore) -> crate::VkResult<u64> {
        let mut value = MaybeUninit::<u64>::uninit();

        let __result = (self.commands().get_semaphore_counter_value_khr)(
            self.handle(),
            semaphore,
            value.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(value.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSignalSemaphoreKHR.html>
    #[inline]
    unsafe fn signal_semaphore_khr(
        &self,
        signal_info: &SemaphoreSignalInfo,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().signal_semaphore_khr)(self.handle(), signal_info);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkWaitSemaphoresKHR.html>
    #[inline]
    unsafe fn wait_semaphores_khr(
        &self,
        wait_info: &SemaphoreWaitInfo,
        timeout: u64,
    ) -> crate::VkResult<SuccessCode> {
        let __result = (self.commands().wait_semaphores_khr)(self.handle(), wait_info, timeout);

        if __result >= Result::SUCCESS {
            Ok(__result.into())
        } else {
            Err(__result.into())
        }
    }
}

impl KhrTimelineSemaphoreExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_uniform_buffer_standard_layout.html>
pub trait KhrUniformBufferStandardLayoutExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION;
}

impl KhrUniformBufferStandardLayoutExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_variable_pointers.html>
pub trait KhrVariablePointersExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_VARIABLE_POINTERS_EXTENSION;
}

impl KhrVariablePointersExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_vulkan_memory_model.html>
pub trait KhrVulkanMemoryModelExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_VULKAN_MEMORY_MODEL_EXTENSION;
}

impl KhrVulkanMemoryModelExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_wayland_surface.html>
pub trait KhrWaylandSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_WAYLAND_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateWaylandSurfaceKHR.html>
    #[inline]
    unsafe fn create_wayland_surface_khr(
        &self,
        create_info: &WaylandSurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_wayland_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceWaylandPresentationSupportKHR.html>
    #[inline]
    unsafe fn get_physical_device_wayland_presentation_support_khr<T_wl_display>(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
    ) -> T_wl_display {
        let mut display = MaybeUninit::<T_wl_display>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_wayland_presentation_support_khr)(
            physical_device,
            queue_family_index,
            display.as_mut_ptr().cast::<c_void>(),
        );

        display.assume_init()
    }
}

impl KhrWaylandSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_win32_keyed_mutex.html>
pub trait KhrWin32KeyedMutexExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_WIN32_KEYED_MUTEX_EXTENSION;
}

impl KhrWin32KeyedMutexExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_win32_surface.html>
pub trait KhrWin32SurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_WIN32_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateWin32SurfaceKHR.html>
    #[inline]
    unsafe fn create_win32_surface_khr(
        &self,
        create_info: &Win32SurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_win32_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceWin32PresentationSupportKHR.html>
    #[inline]
    unsafe fn get_physical_device_win32_presentation_support_khr(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
    ) {
        let __result = (self
            .commands()
            .get_physical_device_win32_presentation_support_khr)(
            physical_device,
            queue_family_index,
        );
    }
}

impl KhrWin32SurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_workgroup_memory_explicit_layout.html>
pub trait KhrWorkgroupMemoryExplicitLayoutExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION;
}

impl KhrWorkgroupMemoryExplicitLayoutExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_xcb_surface.html>
pub trait KhrXcbSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_XCB_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateXcbSurfaceKHR.html>
    #[inline]
    unsafe fn create_xcb_surface_khr(
        &self,
        create_info: &XcbSurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_xcb_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceXcbPresentationSupportKHR.html>
    #[inline]
    unsafe fn get_physical_device_xcb_presentation_support_khr<T_xcb_connection_t>(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
        visual_id: xcb_visualid_t,
    ) -> T_xcb_connection_t {
        let mut connection = MaybeUninit::<T_xcb_connection_t>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_xcb_presentation_support_khr)(
            physical_device,
            queue_family_index,
            connection.as_mut_ptr().cast::<c_void>(),
            visual_id,
        );

        connection.assume_init()
    }
}

impl KhrXcbSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_xlib_surface.html>
pub trait KhrXlibSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_XLIB_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateXlibSurfaceKHR.html>
    #[inline]
    unsafe fn create_xlib_surface_khr(
        &self,
        create_info: &XlibSurfaceCreateInfoKHR,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_xlib_surface_khr)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceXlibPresentationSupportKHR.html>
    #[inline]
    unsafe fn get_physical_device_xlib_presentation_support_khr(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
        visual_id: VisualID,
    ) -> Display {
        let mut dpy = MaybeUninit::<Display>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_xlib_presentation_support_khr)(
            physical_device,
            queue_family_index,
            dpy.as_mut_ptr(),
            visual_id,
        );

        dpy.assume_init()
    }
}

impl KhrXlibSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_KHR_zero_initialize_workgroup_memory.html>
pub trait KhrZeroInitializeWorkgroupMemoryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION;
}

impl KhrZeroInitializeWorkgroupMemoryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_MVK_ios_surface.html>
#[deprecated(note = "deprecated in favor of `VK_EXT_metal_surface`")]
pub trait MvkIosSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = MVK_IOS_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateIOSSurfaceMVK.html>
    #[inline]
    unsafe fn create_ios_surface_mvk(
        &self,
        create_info: &IOSSurfaceCreateInfoMVK,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_ios_surface_mvk)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

#[allow(deprecated)]
impl MvkIosSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_MVK_macos_surface.html>
#[deprecated(note = "deprecated in favor of `VK_EXT_metal_surface`")]
pub trait MvkMacosSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = MVK_MACOS_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateMacOSSurfaceMVK.html>
    #[inline]
    unsafe fn create_mac_os_surface_mvk(
        &self,
        create_info: &MacOSSurfaceCreateInfoMVK,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_mac_os_surface_mvk)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

#[allow(deprecated)]
impl MvkMacosSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NN_vi_surface.html>
pub trait NnViSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NN_VI_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateViSurfaceNN.html>
    #[inline]
    unsafe fn create_vi_surface_nn(
        &self,
        create_info: &ViSurfaceCreateInfoNN,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_vi_surface_nn)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl NnViSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NVX_binary_import.html>
pub trait NvxBinaryImportExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NVX_BINARY_IMPORT_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCuLaunchKernelNVX.html>
    #[inline]
    unsafe fn cmd_cu_launch_kernel_nvx(
        &self,
        command_buffer: CommandBuffer,
        launch_info: &CuLaunchInfoNVX,
    ) {
        let __result = (self.commands().cmd_cu_launch_kernel_nvx)(command_buffer, launch_info);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateCuFunctionNVX.html>
    #[inline]
    unsafe fn create_cu_function_nvx(
        &self,
        create_info: &CuFunctionCreateInfoNVX,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<CuFunctionNVX> {
        let mut function = MaybeUninit::<CuFunctionNVX>::uninit();

        let __result = (self.commands().create_cu_function_nvx)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            function.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(function.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateCuModuleNVX.html>
    #[inline]
    unsafe fn create_cu_module_nvx(
        &self,
        create_info: &CuModuleCreateInfoNVX,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<CuModuleNVX> {
        let mut module = MaybeUninit::<CuModuleNVX>::uninit();

        let __result = (self.commands().create_cu_module_nvx)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            module.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(module.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyCuFunctionNVX.html>
    #[inline]
    unsafe fn destroy_cu_function_nvx(
        &self,
        function: CuFunctionNVX,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_cu_function_nvx)(
            self.handle(),
            function,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyCuModuleNVX.html>
    #[inline]
    unsafe fn destroy_cu_module_nvx(
        &self,
        module: CuModuleNVX,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_cu_module_nvx)(
            self.handle(),
            module,
            allocator.map_or(ptr::null(), |v| v),
        );
    }
}

impl NvxBinaryImportExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NVX_image_view_handle.html>
pub trait NvxImageViewHandleExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NVX_IMAGE_VIEW_HANDLE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageViewAddressNVX.html>
    #[inline]
    unsafe fn get_image_view_address_nvx(
        &self,
        image_view: ImageView,
    ) -> crate::VkResult<ImageViewAddressPropertiesNVX> {
        let mut properties = MaybeUninit::<ImageViewAddressPropertiesNVX>::uninit();

        let __result = (self.commands().get_image_view_address_nvx)(
            self.handle(),
            image_view,
            properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(properties.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageViewHandleNVX.html>
    #[inline]
    unsafe fn get_image_view_handle_nvx(&self, info: &ImageViewHandleInfoNVX) {
        let __result = (self.commands().get_image_view_handle_nvx)(self.handle(), info);
    }
}

impl NvxImageViewHandleExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NVX_multiview_per_view_attributes.html>
pub trait NvxMultiviewPerViewAttributesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION;
}

impl NvxMultiviewPerViewAttributesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_acquire_winrt_display.html>
pub trait NvAcquireWinrtDisplayExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_ACQUIRE_WINRT_DISPLAY_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAcquireWinrtDisplayNV.html>
    #[inline]
    unsafe fn acquire_winrt_display_nv(
        &self,
        physical_device: PhysicalDevice,
        display: DisplayKHR,
    ) -> crate::VkResult<()> {
        let __result = (self.commands().acquire_winrt_display_nv)(physical_device, display);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetWinrtDisplayNV.html>
    #[inline]
    unsafe fn get_winrt_display_nv(
        &self,
        physical_device: PhysicalDevice,
        device_relative_id: u32,
    ) -> crate::VkResult<DisplayKHR> {
        let mut display = MaybeUninit::<DisplayKHR>::uninit();

        let __result = (self.commands().get_winrt_display_nv)(
            physical_device,
            device_relative_id,
            display.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(display.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl NvAcquireWinrtDisplayExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_clip_space_w_scaling.html>
pub trait NvClipSpaceWScalingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_CLIP_SPACE_W_SCALING_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetViewportWScalingNV.html>
    #[inline]
    unsafe fn cmd_set_viewport_w_scaling_nv(
        &self,
        command_buffer: CommandBuffer,
        first_viewport: u32,
        viewport_w_scalings: &[impl Cast<Target = ViewportWScalingNV>],
    ) {
        let __result = (self.commands().cmd_set_viewport_w_scaling_nv)(
            command_buffer,
            first_viewport,
            viewport_w_scalings.len() as u32,
            viewport_w_scalings.as_ptr().cast(),
        );
    }
}

impl NvClipSpaceWScalingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_compute_shader_derivatives.html>
pub trait NvComputeShaderDerivativesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION;
}

impl NvComputeShaderDerivativesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_cooperative_matrix.html>
pub trait NvCooperativeMatrixExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_COOPERATIVE_MATRIX_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceCooperativeMatrixPropertiesNV.html>
    #[inline]
    unsafe fn get_physical_device_cooperative_matrix_properties_nv(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<CooperativeMatrixPropertiesNV>> {
        let mut property_count = 0;

        (self
            .commands()
            .get_physical_device_cooperative_matrix_properties_nv)(
            physical_device,
            &mut property_count,
            ptr::null_mut(),
        );

        let mut properties = Vec::with_capacity(property_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_cooperative_matrix_properties_nv)(
            physical_device,
            &mut property_count,
            properties.as_mut_ptr(),
        );

        debug_assert!(properties.capacity() == property_count as usize);
        properties.set_len(property_count as usize);

        if __result == Result::SUCCESS {
            Ok(properties)
        } else {
            Err(__result.into())
        }
    }
}

impl NvCooperativeMatrixExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_corner_sampled_image.html>
pub trait NvCornerSampledImageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_CORNER_SAMPLED_IMAGE_EXTENSION;
}

impl NvCornerSampledImageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_coverage_reduction_mode.html>
pub trait NvCoverageReductionModeExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_COVERAGE_REDUCTION_MODE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV.html>
    #[inline]
    unsafe fn get_physical_device_supported_framebuffer_mixed_samples_combinations_nv(
        &self,
        physical_device: PhysicalDevice,
    ) -> crate::VkResult<Vec<FramebufferMixedSamplesCombinationNV>> {
        let mut combination_count = 0;

        (self
            .commands()
            .get_physical_device_supported_framebuffer_mixed_samples_combinations_nv)(
            physical_device,
            &mut combination_count,
            ptr::null_mut(),
        );

        let mut combinations = Vec::with_capacity(combination_count as usize);

        let __result = (self
            .commands()
            .get_physical_device_supported_framebuffer_mixed_samples_combinations_nv)(
            physical_device,
            &mut combination_count,
            combinations.as_mut_ptr(),
        );

        debug_assert!(combinations.capacity() == combination_count as usize);
        combinations.set_len(combination_count as usize);

        if __result == Result::SUCCESS {
            Ok(combinations)
        } else {
            Err(__result.into())
        }
    }
}

impl NvCoverageReductionModeExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_dedicated_allocation.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_dedicated_allocation`")]
pub trait NvDedicatedAllocationExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_DEDICATED_ALLOCATION_EXTENSION;
}

#[allow(deprecated)]
impl NvDedicatedAllocationExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_dedicated_allocation_image_aliasing.html>
pub trait NvDedicatedAllocationImageAliasingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION;
}

impl NvDedicatedAllocationImageAliasingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_device_diagnostic_checkpoints.html>
pub trait NvDeviceDiagnosticCheckpointsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetCheckpointNV.html>
    #[inline]
    unsafe fn cmd_set_checkpoint_nv(
        &self,
        command_buffer: CommandBuffer,
        checkpoint_marker: &c_void,
    ) {
        let __result = (self.commands().cmd_set_checkpoint_nv)(command_buffer, checkpoint_marker);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetQueueCheckpointDataNV.html>
    #[inline]
    unsafe fn get_queue_checkpoint_data_nv(&self, queue: Queue) -> Vec<CheckpointDataNV> {
        let mut checkpoint_data_count = 0;

        (self.commands().get_queue_checkpoint_data_nv)(
            queue,
            &mut checkpoint_data_count,
            ptr::null_mut(),
        );

        let mut checkpoint_data = Vec::with_capacity(checkpoint_data_count as usize);

        let __result = (self.commands().get_queue_checkpoint_data_nv)(
            queue,
            &mut checkpoint_data_count,
            checkpoint_data.as_mut_ptr(),
        );

        debug_assert!(checkpoint_data.capacity() == checkpoint_data_count as usize);
        checkpoint_data.set_len(checkpoint_data_count as usize);

        checkpoint_data
    }
}

impl NvDeviceDiagnosticCheckpointsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_device_diagnostics_config.html>
pub trait NvDeviceDiagnosticsConfigExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION;
}

impl NvDeviceDiagnosticsConfigExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_device_generated_commands.html>
pub trait NvDeviceGeneratedCommandsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_DEVICE_GENERATED_COMMANDS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindPipelineShaderGroupNV.html>
    #[inline]
    unsafe fn cmd_bind_pipeline_shader_group_nv(
        &self,
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        pipeline: Pipeline,
        group_index: u32,
    ) {
        let __result = (self.commands().cmd_bind_pipeline_shader_group_nv)(
            command_buffer,
            pipeline_bind_point,
            pipeline,
            group_index,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdExecuteGeneratedCommandsNV.html>
    #[inline]
    unsafe fn cmd_execute_generated_commands_nv(
        &self,
        command_buffer: CommandBuffer,
        is_preprocessed: bool,
        generated_commands_info: &GeneratedCommandsInfoNV,
    ) {
        let __result = (self.commands().cmd_execute_generated_commands_nv)(
            command_buffer,
            is_preprocessed as Bool32,
            generated_commands_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPreprocessGeneratedCommandsNV.html>
    #[inline]
    unsafe fn cmd_preprocess_generated_commands_nv(
        &self,
        command_buffer: CommandBuffer,
        generated_commands_info: &GeneratedCommandsInfoNV,
    ) {
        let __result = (self.commands().cmd_preprocess_generated_commands_nv)(
            command_buffer,
            generated_commands_info,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateIndirectCommandsLayoutNV.html>
    #[inline]
    unsafe fn create_indirect_commands_layout_nv(
        &self,
        create_info: &IndirectCommandsLayoutCreateInfoNV,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<IndirectCommandsLayoutNV> {
        let mut indirect_commands_layout = MaybeUninit::<IndirectCommandsLayoutNV>::uninit();

        let __result = (self.commands().create_indirect_commands_layout_nv)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            indirect_commands_layout.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(indirect_commands_layout.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyIndirectCommandsLayoutNV.html>
    #[inline]
    unsafe fn destroy_indirect_commands_layout_nv(
        &self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_indirect_commands_layout_nv)(
            self.handle(),
            indirect_commands_layout,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetGeneratedCommandsMemoryRequirementsNV.html>
    #[inline]
    unsafe fn get_generated_commands_memory_requirements_nv(
        &self,
        info: &GeneratedCommandsMemoryRequirementsInfoNV,
        memory_requirements: &mut MemoryRequirements2,
    ) {
        let __result = (self
            .commands()
            .get_generated_commands_memory_requirements_nv)(
            self.handle(),
            info,
            memory_requirements,
        );
    }
}

impl NvDeviceGeneratedCommandsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_external_memory.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_external_memory`")]
pub trait NvExternalMemoryExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_EXTERNAL_MEMORY_EXTENSION;
}

#[allow(deprecated)]
impl NvExternalMemoryExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_external_memory_capabilities.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_external_memory_capabilities`")]
pub trait NvExternalMemoryCapabilitiesExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalImageFormatPropertiesNV.html>
    #[inline]
    unsafe fn get_physical_device_external_image_format_properties_nv(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        type_: ImageType,
        tiling: ImageTiling,
        usage: ImageUsageFlags,
        flags: ImageCreateFlags,
        external_handle_type: ExternalMemoryHandleTypeFlagsNV,
    ) -> crate::VkResult<ExternalImageFormatPropertiesNV> {
        let mut external_image_format_properties =
            MaybeUninit::<ExternalImageFormatPropertiesNV>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_external_image_format_properties_nv)(
            physical_device,
            format,
            type_,
            tiling,
            usage,
            flags,
            external_handle_type,
            external_image_format_properties.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(external_image_format_properties.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

#[allow(deprecated)]
impl NvExternalMemoryCapabilitiesExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_external_memory_rdma.html>
pub trait NvExternalMemoryRdmaExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_EXTERNAL_MEMORY_RDMA_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryRemoteAddressNV.html>
    #[inline]
    unsafe fn get_memory_remote_address_nv(
        &self,
        get_memory_remote_address_info: &MemoryGetRemoteAddressInfoNV,
    ) -> crate::VkResult<RemoteAddressNV> {
        let mut address = MaybeUninit::<RemoteAddressNV>::uninit();

        let __result = (self.commands().get_memory_remote_address_nv)(
            self.handle(),
            get_memory_remote_address_info,
            address.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(address.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

impl NvExternalMemoryRdmaExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_external_memory_win32.html>
#[deprecated(note = "deprecated in favor of `VK_KHR_external_memory_win32`")]
pub trait NvExternalMemoryWin32Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_EXTERNAL_MEMORY_WIN32_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetMemoryWin32HandleNV.html>
    #[inline]
    unsafe fn get_memory_win32_handle_nv(
        &self,
        memory: DeviceMemory,
        handle_type: ExternalMemoryHandleTypeFlagsNV,
    ) -> crate::VkResult<HANDLE> {
        let mut handle = MaybeUninit::<HANDLE>::uninit();

        let __result = (self.commands().get_memory_win32_handle_nv)(
            self.handle(),
            memory,
            handle_type,
            handle.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(handle.assume_init())
        } else {
            Err(__result.into())
        }
    }
}

#[allow(deprecated)]
impl NvExternalMemoryWin32Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_fill_rectangle.html>
pub trait NvFillRectangleExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_FILL_RECTANGLE_EXTENSION;
}

impl NvFillRectangleExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_fragment_coverage_to_color.html>
pub trait NvFragmentCoverageToColorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION;
}

impl NvFragmentCoverageToColorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_fragment_shader_barycentric.html>
pub trait NvFragmentShaderBarycentricExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION;
}

impl NvFragmentShaderBarycentricExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_fragment_shading_rate_enums.html>
pub trait NvFragmentShadingRateEnumsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetFragmentShadingRateEnumNV.html>
    #[inline]
    unsafe fn cmd_set_fragment_shading_rate_enum_nv(
        &self,
        command_buffer: CommandBuffer,
        shading_rate: FragmentShadingRateNV,
        combiner_ops: [FragmentShadingRateCombinerOpKHR; 2],
    ) {
        let __result = (self.commands().cmd_set_fragment_shading_rate_enum_nv)(
            command_buffer,
            shading_rate,
            combiner_ops.as_ptr(),
        );
    }
}

impl NvFragmentShadingRateEnumsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_framebuffer_mixed_samples.html>
pub trait NvFramebufferMixedSamplesExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION;
}

impl NvFramebufferMixedSamplesExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_geometry_shader_passthrough.html>
pub trait NvGeometryShaderPassthroughExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION;
}

impl NvGeometryShaderPassthroughExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_glsl_shader.html>
#[deprecated]
pub trait NvGlslShaderExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_GLSL_SHADER_EXTENSION;
}

#[allow(deprecated)]
impl NvGlslShaderExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_inherited_viewport_scissor.html>
pub trait NvInheritedViewportScissorExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_INHERITED_VIEWPORT_SCISSOR_EXTENSION;
}

impl NvInheritedViewportScissorExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_mesh_shader.html>
pub trait NvMeshShaderExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_MESH_SHADER_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawMeshTasksIndirectCountNV.html>
    #[inline]
    unsafe fn cmd_draw_mesh_tasks_indirect_count_nv(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_mesh_tasks_indirect_count_nv)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawMeshTasksIndirectNV.html>
    #[inline]
    unsafe fn cmd_draw_mesh_tasks_indirect_nv(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        draw_count: u32,
        stride: u32,
    ) {
        let __result = (self.commands().cmd_draw_mesh_tasks_indirect_nv)(
            command_buffer,
            buffer,
            offset,
            draw_count,
            stride,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawMeshTasksNV.html>
    #[inline]
    unsafe fn cmd_draw_mesh_tasks_nv(
        &self,
        command_buffer: CommandBuffer,
        task_count: u32,
        first_task: u32,
    ) {
        let __result =
            (self.commands().cmd_draw_mesh_tasks_nv)(command_buffer, task_count, first_task);
    }
}

impl NvMeshShaderExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_ray_tracing.html>
pub trait NvRayTracingExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_RAY_TRACING_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindAccelerationStructureMemoryNV.html>
    #[inline]
    unsafe fn bind_acceleration_structure_memory_nv(
        &self,
        bind_infos: &[impl Cast<Target = BindAccelerationStructureMemoryInfoNV>],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().bind_acceleration_structure_memory_nv)(
            self.handle(),
            bind_infos.len() as u32,
            bind_infos.as_ptr().cast(),
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBuildAccelerationStructureNV.html>
    #[inline]
    unsafe fn cmd_build_acceleration_structure_nv(
        &self,
        command_buffer: CommandBuffer,
        info: &AccelerationStructureInfoNV,
        instance_data: Buffer,
        instance_offset: DeviceSize,
        update: bool,
        dst: AccelerationStructureNV,
        src: AccelerationStructureNV,
        scratch: Buffer,
        scratch_offset: DeviceSize,
    ) {
        let __result = (self.commands().cmd_build_acceleration_structure_nv)(
            command_buffer,
            info,
            instance_data,
            instance_offset,
            update as Bool32,
            dst,
            src,
            scratch,
            scratch_offset,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyAccelerationStructureNV.html>
    #[inline]
    unsafe fn cmd_copy_acceleration_structure_nv(
        &self,
        command_buffer: CommandBuffer,
        dst: AccelerationStructureNV,
        src: AccelerationStructureNV,
        mode: CopyAccelerationStructureModeKHR,
    ) {
        let __result =
            (self.commands().cmd_copy_acceleration_structure_nv)(command_buffer, dst, src, mode);
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdTraceRaysNV.html>
    #[inline]
    unsafe fn cmd_trace_rays_nv(
        &self,
        command_buffer: CommandBuffer,
        raygen_shader_binding_table_buffer: Buffer,
        raygen_shader_binding_offset: DeviceSize,
        miss_shader_binding_table_buffer: Buffer,
        miss_shader_binding_offset: DeviceSize,
        miss_shader_binding_stride: DeviceSize,
        hit_shader_binding_table_buffer: Buffer,
        hit_shader_binding_offset: DeviceSize,
        hit_shader_binding_stride: DeviceSize,
        callable_shader_binding_table_buffer: Buffer,
        callable_shader_binding_offset: DeviceSize,
        callable_shader_binding_stride: DeviceSize,
        width: u32,
        height: u32,
        depth: u32,
    ) {
        let __result = (self.commands().cmd_trace_rays_nv)(
            command_buffer,
            raygen_shader_binding_table_buffer,
            raygen_shader_binding_offset,
            miss_shader_binding_table_buffer,
            miss_shader_binding_offset,
            miss_shader_binding_stride,
            hit_shader_binding_table_buffer,
            hit_shader_binding_offset,
            hit_shader_binding_stride,
            callable_shader_binding_table_buffer,
            callable_shader_binding_offset,
            callable_shader_binding_stride,
            width,
            height,
            depth,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteAccelerationStructuresPropertiesNV.html>
    #[inline]
    unsafe fn cmd_write_acceleration_structures_properties_nv(
        &self,
        command_buffer: CommandBuffer,
        acceleration_structures: &[AccelerationStructureNV],
        query_type: QueryType,
        query_pool: QueryPool,
        first_query: u32,
    ) {
        let __result = (self
            .commands()
            .cmd_write_acceleration_structures_properties_nv)(
            command_buffer,
            acceleration_structures.len() as u32,
            acceleration_structures.as_ptr(),
            query_type,
            query_pool,
            first_query,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCompileDeferredNV.html>
    #[inline]
    unsafe fn compile_deferred_nv(&self, pipeline: Pipeline, shader: u32) -> crate::VkResult<()> {
        let __result = (self.commands().compile_deferred_nv)(self.handle(), pipeline, shader);

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateAccelerationStructureNV.html>
    #[inline]
    unsafe fn create_acceleration_structure_nv(
        &self,
        create_info: &AccelerationStructureCreateInfoNV,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<AccelerationStructureNV> {
        let mut acceleration_structure = MaybeUninit::<AccelerationStructureNV>::uninit();

        let __result = (self.commands().create_acceleration_structure_nv)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            acceleration_structure.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(acceleration_structure.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateRayTracingPipelinesNV.html>
    #[inline]
    unsafe fn create_ray_tracing_pipelines_nv(
        &self,
        pipeline_cache: PipelineCache,
        create_infos: &[impl Cast<Target = RayTracingPipelineCreateInfoNV>],
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkSuccessResult<Pipeline> {
        let mut pipelines = MaybeUninit::<Pipeline>::uninit();

        let __result = (self.commands().create_ray_tracing_pipelines_nv)(
            self.handle(),
            pipeline_cache,
            create_infos.len() as u32,
            create_infos.as_ptr().cast(),
            allocator.map_or(ptr::null(), |v| v),
            pipelines.as_mut_ptr(),
        );

        if __result >= Result::SUCCESS {
            Ok((pipelines.assume_init(), __result.into()))
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyAccelerationStructureNV.html>
    #[inline]
    unsafe fn destroy_acceleration_structure_nv(
        &self,
        acceleration_structure: AccelerationStructureNV,
        allocator: Option<&AllocationCallbacks>,
    ) {
        let __result = (self.commands().destroy_acceleration_structure_nv)(
            self.handle(),
            acceleration_structure,
            allocator.map_or(ptr::null(), |v| v),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetAccelerationStructureHandleNV.html>
    #[inline]
    unsafe fn get_acceleration_structure_handle_nv(
        &self,
        acceleration_structure: AccelerationStructureNV,
        data: &mut [u8],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().get_acceleration_structure_handle_nv)(
            self.handle(),
            acceleration_structure,
            data.len() as usize,
            data.as_ptr() as *mut c_void,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetAccelerationStructureMemoryRequirementsNV.html>
    #[inline]
    unsafe fn get_acceleration_structure_memory_requirements_nv(
        &self,
        info: &AccelerationStructureMemoryRequirementsInfoNV,
    ) -> MemoryRequirements2KHR {
        let mut memory_requirements = MaybeUninit::<MemoryRequirements2KHR>::uninit();

        let __result = (self
            .commands()
            .get_acceleration_structure_memory_requirements_nv)(
            self.handle(),
            info,
            memory_requirements.as_mut_ptr(),
        );

        memory_requirements.assume_init()
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRayTracingShaderGroupHandlesNV.html>
    #[inline]
    unsafe fn get_ray_tracing_shader_group_handles_nv(
        &self,
        pipeline: Pipeline,
        first_group: u32,
        group_count: u32,
        data: &mut [u8],
    ) -> crate::VkResult<()> {
        let __result = (self.commands().get_ray_tracing_shader_group_handles_nv)(
            self.handle(),
            pipeline,
            first_group,
            group_count,
            data.len() as usize,
            data.as_ptr() as *mut c_void,
        );

        if __result == Result::SUCCESS {
            Ok(())
        } else {
            Err(__result.into())
        }
    }
}

impl NvRayTracingExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_ray_tracing_motion_blur.html>
pub trait NvRayTracingMotionBlurExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_RAY_TRACING_MOTION_BLUR_EXTENSION;
}

impl NvRayTracingMotionBlurExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_representative_fragment_test.html>
pub trait NvRepresentativeFragmentTestExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION;
}

impl NvRepresentativeFragmentTestExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_sample_mask_override_coverage.html>
pub trait NvSampleMaskOverrideCoverageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION;
}

impl NvSampleMaskOverrideCoverageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_scissor_exclusive.html>
pub trait NvScissorExclusiveExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SCISSOR_EXCLUSIVE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetExclusiveScissorNV.html>
    #[inline]
    unsafe fn cmd_set_exclusive_scissor_nv(
        &self,
        command_buffer: CommandBuffer,
        first_exclusive_scissor: u32,
        exclusive_scissors: &[impl Cast<Target = Rect2D>],
    ) {
        let __result = (self.commands().cmd_set_exclusive_scissor_nv)(
            command_buffer,
            first_exclusive_scissor,
            exclusive_scissors.len() as u32,
            exclusive_scissors.as_ptr().cast(),
        );
    }
}

impl NvScissorExclusiveExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_shader_image_footprint.html>
pub trait NvShaderImageFootprintExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SHADER_IMAGE_FOOTPRINT_EXTENSION;
}

impl NvShaderImageFootprintExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_shader_sm_builtins.html>
pub trait NvShaderSmBuiltinsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SHADER_SM_BUILTINS_EXTENSION;
}

impl NvShaderSmBuiltinsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_shader_subgroup_partitioned.html>
pub trait NvShaderSubgroupPartitionedExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION;
}

impl NvShaderSubgroupPartitionedExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_shading_rate_image.html>
pub trait NvShadingRateImageExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_SHADING_RATE_IMAGE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindShadingRateImageNV.html>
    #[inline]
    unsafe fn cmd_bind_shading_rate_image_nv(
        &self,
        command_buffer: CommandBuffer,
        image_view: ImageView,
        image_layout: ImageLayout,
    ) {
        let __result = (self.commands().cmd_bind_shading_rate_image_nv)(
            command_buffer,
            image_view,
            image_layout,
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetCoarseSampleOrderNV.html>
    #[inline]
    unsafe fn cmd_set_coarse_sample_order_nv(
        &self,
        command_buffer: CommandBuffer,
        sample_order_type: CoarseSampleOrderTypeNV,
        custom_sample_orders: &[impl Cast<Target = CoarseSampleOrderCustomNV>],
    ) {
        let __result = (self.commands().cmd_set_coarse_sample_order_nv)(
            command_buffer,
            sample_order_type,
            custom_sample_orders.len() as u32,
            custom_sample_orders.as_ptr().cast(),
        );
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetViewportShadingRatePaletteNV.html>
    #[inline]
    unsafe fn cmd_set_viewport_shading_rate_palette_nv(
        &self,
        command_buffer: CommandBuffer,
        first_viewport: u32,
        shading_rate_palettes: &[impl Cast<Target = ShadingRatePaletteNV>],
    ) {
        let __result = (self.commands().cmd_set_viewport_shading_rate_palette_nv)(
            command_buffer,
            first_viewport,
            shading_rate_palettes.len() as u32,
            shading_rate_palettes.as_ptr().cast(),
        );
    }
}

impl NvShadingRateImageExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_viewport_array2.html>
pub trait NvViewportArray2Extension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_VIEWPORT_ARRAY2_EXTENSION;
}

impl NvViewportArray2Extension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_viewport_swizzle.html>
pub trait NvViewportSwizzleExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_VIEWPORT_SWIZZLE_EXTENSION;
}

impl NvViewportSwizzleExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_NV_win32_keyed_mutex.html>
pub trait NvWin32KeyedMutexExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = NV_WIN32_KEYED_MUTEX_EXTENSION;
}

impl NvWin32KeyedMutexExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_QCOM_render_pass_shader_resolve.html>
pub trait QcomRenderPassShaderResolveExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = QCOM_RENDER_PASS_SHADER_RESOLVE_EXTENSION;
}

impl QcomRenderPassShaderResolveExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_QCOM_render_pass_store_ops.html>
pub trait QcomRenderPassStoreOpsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = QCOM_RENDER_PASS_STORE_OPS_EXTENSION;
}

impl QcomRenderPassStoreOpsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_QCOM_render_pass_transform.html>
pub trait QcomRenderPassTransformExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = QCOM_RENDER_PASS_TRANSFORM_EXTENSION;
}

impl QcomRenderPassTransformExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_QCOM_rotated_copy_commands.html>
pub trait QcomRotatedCopyCommandsExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = QCOM_ROTATED_COPY_COMMANDS_EXTENSION;
}

impl QcomRotatedCopyCommandsExtension for crate::Device {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_QNX_screen_surface.html>
pub trait QnxScreenSurfaceExtension: InstanceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = QNX_SCREEN_SURFACE_EXTENSION;

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateScreenSurfaceQNX.html>
    #[inline]
    unsafe fn create_screen_surface_qnx(
        &self,
        create_info: &ScreenSurfaceCreateInfoQNX,
        allocator: Option<&AllocationCallbacks>,
    ) -> crate::VkResult<SurfaceKHR> {
        let mut surface = MaybeUninit::<SurfaceKHR>::uninit();

        let __result = (self.commands().create_screen_surface_qnx)(
            self.handle(),
            create_info,
            allocator.map_or(ptr::null(), |v| v),
            surface.as_mut_ptr(),
        );

        if __result == Result::SUCCESS {
            Ok(surface.assume_init())
        } else {
            Err(__result.into())
        }
    }

    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceScreenPresentationSupportQNX.html>
    #[inline]
    unsafe fn get_physical_device_screen_presentation_support_qnx(
        &self,
        physical_device: PhysicalDevice,
        queue_family_index: u32,
    ) -> _screen_window {
        let mut window = MaybeUninit::<_screen_window>::uninit();

        let __result = (self
            .commands()
            .get_physical_device_screen_presentation_support_qnx)(
            physical_device,
            queue_family_index,
            window.as_mut_ptr(),
        );

        window.assume_init()
    }
}

impl QnxScreenSurfaceExtension for crate::Instance {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_VALVE_mutable_descriptor_type.html>
pub trait ValveMutableDescriptorTypeExtension: DeviceV1_0 {
    /// The metadata for this extension.
    #[allow(deprecated)]
    const METADATA: Extension = VALVE_MUTABLE_DESCRIPTOR_TYPE_EXTENSION;
}

impl ValveMutableDescriptorTypeExtension for crate::Device {}
