// SPDX-License-Identifier: Apache-2.0

// DO NOT EDIT.
//
// This file has been generated by the Kotlin project in the `generator`
// directory from a Vulkan API registry.

#![allow(
    non_camel_case_types,
    non_snake_case,
    clippy::missing_safety_doc,
    clippy::too_many_arguments,
    clippy::type_complexity,
    clippy::upper_case_acronyms
)]

use std::error;
use std::fmt;

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureBuildTypeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AccelerationStructureBuildTypeKHR(i32);

impl AccelerationStructureBuildTypeKHR {
    pub const HOST: Self = Self(0);
    pub const DEVICE: Self = Self(1);
    pub const HOST_OR_DEVICE: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AccelerationStructureBuildTypeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "HOST"),
            1 => write!(f, "DEVICE"),
            2 => write!(f, "HOST_OR_DEVICE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureCompatibilityKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AccelerationStructureCompatibilityKHR(i32);

impl AccelerationStructureCompatibilityKHR {
    pub const COMPATIBLE: Self = Self(0);
    pub const INCOMPATIBLE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AccelerationStructureCompatibilityKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COMPATIBLE"),
            1 => write!(f, "INCOMPATIBLE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMemoryRequirementsTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AccelerationStructureMemoryRequirementsTypeNV(i32);

impl AccelerationStructureMemoryRequirementsTypeNV {
    pub const OBJECT: Self = Self(0);
    pub const BUILD_SCRATCH: Self = Self(1);
    pub const UPDATE_SCRATCH: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AccelerationStructureMemoryRequirementsTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "OBJECT"),
            1 => write!(f, "BUILD_SCRATCH"),
            2 => write!(f, "UPDATE_SCRATCH"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMotionInstanceTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AccelerationStructureMotionInstanceTypeNV(i32);

impl AccelerationStructureMotionInstanceTypeNV {
    pub const STATIC: Self = Self(0);
    pub const MATRIX_MOTION: Self = Self(1);
    pub const SRT_MOTION: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AccelerationStructureMotionInstanceTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "STATIC"),
            1 => write!(f, "MATRIX_MOTION"),
            2 => write!(f, "SRT_MOTION"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureTypeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AccelerationStructureTypeKHR(i32);

impl AccelerationStructureTypeKHR {
    pub const TOP_LEVEL: Self = Self(0);
    pub const BOTTOM_LEVEL: Self = Self(1);
    pub const GENERIC: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AccelerationStructureTypeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "TOP_LEVEL"),
            1 => write!(f, "BOTTOM_LEVEL"),
            2 => write!(f, "GENERIC"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentLoadOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AttachmentLoadOp(i32);

impl AttachmentLoadOp {
    pub const LOAD: Self = Self(0);
    pub const CLEAR: Self = Self(1);
    pub const DONT_CARE: Self = Self(2);
    pub const NONE_EXT: Self = Self(1000400000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AttachmentLoadOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "LOAD"),
            1 => write!(f, "CLEAR"),
            2 => write!(f, "DONT_CARE"),
            1000400000 => write!(f, "NONE_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentStoreOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct AttachmentStoreOp(i32);

impl AttachmentStoreOp {
    pub const STORE: Self = Self(0);
    pub const DONT_CARE: Self = Self(1);
    pub const NONE_KHR: Self = Self(1000301000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for AttachmentStoreOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "STORE"),
            1 => write!(f, "DONT_CARE"),
            1000301000 => write!(f, "NONE_KHR"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBlendFactor.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct BlendFactor(i32);

impl BlendFactor {
    pub const ZERO: Self = Self(0);
    pub const ONE: Self = Self(1);
    pub const SRC_COLOR: Self = Self(2);
    pub const ONE_MINUS_SRC_COLOR: Self = Self(3);
    pub const DST_COLOR: Self = Self(4);
    pub const ONE_MINUS_DST_COLOR: Self = Self(5);
    pub const SRC_ALPHA: Self = Self(6);
    pub const ONE_MINUS_SRC_ALPHA: Self = Self(7);
    pub const DST_ALPHA: Self = Self(8);
    pub const ONE_MINUS_DST_ALPHA: Self = Self(9);
    pub const CONSTANT_COLOR: Self = Self(10);
    pub const ONE_MINUS_CONSTANT_COLOR: Self = Self(11);
    pub const CONSTANT_ALPHA: Self = Self(12);
    pub const ONE_MINUS_CONSTANT_ALPHA: Self = Self(13);
    pub const SRC_ALPHA_SATURATE: Self = Self(14);
    pub const SRC1_COLOR: Self = Self(15);
    pub const ONE_MINUS_SRC1_COLOR: Self = Self(16);
    pub const SRC1_ALPHA: Self = Self(17);
    pub const ONE_MINUS_SRC1_ALPHA: Self = Self(18);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for BlendFactor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ZERO"),
            1 => write!(f, "ONE"),
            2 => write!(f, "SRC_COLOR"),
            3 => write!(f, "ONE_MINUS_SRC_COLOR"),
            4 => write!(f, "DST_COLOR"),
            5 => write!(f, "ONE_MINUS_DST_COLOR"),
            6 => write!(f, "SRC_ALPHA"),
            7 => write!(f, "ONE_MINUS_SRC_ALPHA"),
            8 => write!(f, "DST_ALPHA"),
            9 => write!(f, "ONE_MINUS_DST_ALPHA"),
            10 => write!(f, "CONSTANT_COLOR"),
            11 => write!(f, "ONE_MINUS_CONSTANT_COLOR"),
            12 => write!(f, "CONSTANT_ALPHA"),
            13 => write!(f, "ONE_MINUS_CONSTANT_ALPHA"),
            14 => write!(f, "SRC_ALPHA_SATURATE"),
            15 => write!(f, "SRC1_COLOR"),
            16 => write!(f, "ONE_MINUS_SRC1_COLOR"),
            17 => write!(f, "SRC1_ALPHA"),
            18 => write!(f, "ONE_MINUS_SRC1_ALPHA"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBlendOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct BlendOp(i32);

impl BlendOp {
    pub const ADD: Self = Self(0);
    pub const SUBTRACT: Self = Self(1);
    pub const REVERSE_SUBTRACT: Self = Self(2);
    pub const MIN: Self = Self(3);
    pub const MAX: Self = Self(4);
    pub const ZERO_EXT: Self = Self(1000148000);
    pub const SRC_EXT: Self = Self(1000148001);
    pub const DST_EXT: Self = Self(1000148002);
    pub const SRC_OVER_EXT: Self = Self(1000148003);
    pub const DST_OVER_EXT: Self = Self(1000148004);
    pub const SRC_IN_EXT: Self = Self(1000148005);
    pub const DST_IN_EXT: Self = Self(1000148006);
    pub const SRC_OUT_EXT: Self = Self(1000148007);
    pub const DST_OUT_EXT: Self = Self(1000148008);
    pub const SRC_ATOP_EXT: Self = Self(1000148009);
    pub const DST_ATOP_EXT: Self = Self(1000148010);
    pub const XOR_EXT: Self = Self(1000148011);
    pub const MULTIPLY_EXT: Self = Self(1000148012);
    pub const SCREEN_EXT: Self = Self(1000148013);
    pub const OVERLAY_EXT: Self = Self(1000148014);
    pub const DARKEN_EXT: Self = Self(1000148015);
    pub const LIGHTEN_EXT: Self = Self(1000148016);
    pub const COLORDODGE_EXT: Self = Self(1000148017);
    pub const COLORBURN_EXT: Self = Self(1000148018);
    pub const HARDLIGHT_EXT: Self = Self(1000148019);
    pub const SOFTLIGHT_EXT: Self = Self(1000148020);
    pub const DIFFERENCE_EXT: Self = Self(1000148021);
    pub const EXCLUSION_EXT: Self = Self(1000148022);
    pub const INVERT_EXT: Self = Self(1000148023);
    pub const INVERT_RGB_EXT: Self = Self(1000148024);
    pub const LINEARDODGE_EXT: Self = Self(1000148025);
    pub const LINEARBURN_EXT: Self = Self(1000148026);
    pub const VIVIDLIGHT_EXT: Self = Self(1000148027);
    pub const LINEARLIGHT_EXT: Self = Self(1000148028);
    pub const PINLIGHT_EXT: Self = Self(1000148029);
    pub const HARDMIX_EXT: Self = Self(1000148030);
    pub const HSL_HUE_EXT: Self = Self(1000148031);
    pub const HSL_SATURATION_EXT: Self = Self(1000148032);
    pub const HSL_COLOR_EXT: Self = Self(1000148033);
    pub const HSL_LUMINOSITY_EXT: Self = Self(1000148034);
    pub const PLUS_EXT: Self = Self(1000148035);
    pub const PLUS_CLAMPED_EXT: Self = Self(1000148036);
    pub const PLUS_CLAMPED_ALPHA_EXT: Self = Self(1000148037);
    pub const PLUS_DARKER_EXT: Self = Self(1000148038);
    pub const MINUS_EXT: Self = Self(1000148039);
    pub const MINUS_CLAMPED_EXT: Self = Self(1000148040);
    pub const CONTRAST_EXT: Self = Self(1000148041);
    pub const INVERT_OVG_EXT: Self = Self(1000148042);
    pub const RED_EXT: Self = Self(1000148043);
    pub const GREEN_EXT: Self = Self(1000148044);
    pub const BLUE_EXT: Self = Self(1000148045);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for BlendOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ADD"),
            1 => write!(f, "SUBTRACT"),
            2 => write!(f, "REVERSE_SUBTRACT"),
            3 => write!(f, "MIN"),
            4 => write!(f, "MAX"),
            1000148000 => write!(f, "ZERO_EXT"),
            1000148001 => write!(f, "SRC_EXT"),
            1000148002 => write!(f, "DST_EXT"),
            1000148003 => write!(f, "SRC_OVER_EXT"),
            1000148004 => write!(f, "DST_OVER_EXT"),
            1000148005 => write!(f, "SRC_IN_EXT"),
            1000148006 => write!(f, "DST_IN_EXT"),
            1000148007 => write!(f, "SRC_OUT_EXT"),
            1000148008 => write!(f, "DST_OUT_EXT"),
            1000148009 => write!(f, "SRC_ATOP_EXT"),
            1000148010 => write!(f, "DST_ATOP_EXT"),
            1000148011 => write!(f, "XOR_EXT"),
            1000148012 => write!(f, "MULTIPLY_EXT"),
            1000148013 => write!(f, "SCREEN_EXT"),
            1000148014 => write!(f, "OVERLAY_EXT"),
            1000148015 => write!(f, "DARKEN_EXT"),
            1000148016 => write!(f, "LIGHTEN_EXT"),
            1000148017 => write!(f, "COLORDODGE_EXT"),
            1000148018 => write!(f, "COLORBURN_EXT"),
            1000148019 => write!(f, "HARDLIGHT_EXT"),
            1000148020 => write!(f, "SOFTLIGHT_EXT"),
            1000148021 => write!(f, "DIFFERENCE_EXT"),
            1000148022 => write!(f, "EXCLUSION_EXT"),
            1000148023 => write!(f, "INVERT_EXT"),
            1000148024 => write!(f, "INVERT_RGB_EXT"),
            1000148025 => write!(f, "LINEARDODGE_EXT"),
            1000148026 => write!(f, "LINEARBURN_EXT"),
            1000148027 => write!(f, "VIVIDLIGHT_EXT"),
            1000148028 => write!(f, "LINEARLIGHT_EXT"),
            1000148029 => write!(f, "PINLIGHT_EXT"),
            1000148030 => write!(f, "HARDMIX_EXT"),
            1000148031 => write!(f, "HSL_HUE_EXT"),
            1000148032 => write!(f, "HSL_SATURATION_EXT"),
            1000148033 => write!(f, "HSL_COLOR_EXT"),
            1000148034 => write!(f, "HSL_LUMINOSITY_EXT"),
            1000148035 => write!(f, "PLUS_EXT"),
            1000148036 => write!(f, "PLUS_CLAMPED_EXT"),
            1000148037 => write!(f, "PLUS_CLAMPED_ALPHA_EXT"),
            1000148038 => write!(f, "PLUS_DARKER_EXT"),
            1000148039 => write!(f, "MINUS_EXT"),
            1000148040 => write!(f, "MINUS_CLAMPED_EXT"),
            1000148041 => write!(f, "CONTRAST_EXT"),
            1000148042 => write!(f, "INVERT_OVG_EXT"),
            1000148043 => write!(f, "RED_EXT"),
            1000148044 => write!(f, "GREEN_EXT"),
            1000148045 => write!(f, "BLUE_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBlendOverlapEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct BlendOverlapEXT(i32);

impl BlendOverlapEXT {
    pub const UNCORRELATED: Self = Self(0);
    pub const DISJOINT: Self = Self(1);
    pub const CONJOINT: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for BlendOverlapEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UNCORRELATED"),
            1 => write!(f, "DISJOINT"),
            2 => write!(f, "CONJOINT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBorderColor.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct BorderColor(i32);

impl BorderColor {
    pub const FLOAT_TRANSPARENT_BLACK: Self = Self(0);
    pub const INT_TRANSPARENT_BLACK: Self = Self(1);
    pub const FLOAT_OPAQUE_BLACK: Self = Self(2);
    pub const INT_OPAQUE_BLACK: Self = Self(3);
    pub const FLOAT_OPAQUE_WHITE: Self = Self(4);
    pub const INT_OPAQUE_WHITE: Self = Self(5);
    pub const FLOAT_CUSTOM_EXT: Self = Self(1000287003);
    pub const INT_CUSTOM_EXT: Self = Self(1000287004);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for BorderColor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FLOAT_TRANSPARENT_BLACK"),
            1 => write!(f, "INT_TRANSPARENT_BLACK"),
            2 => write!(f, "FLOAT_OPAQUE_BLACK"),
            3 => write!(f, "INT_OPAQUE_BLACK"),
            4 => write!(f, "FLOAT_OPAQUE_WHITE"),
            5 => write!(f, "INT_OPAQUE_WHITE"),
            1000287003 => write!(f, "FLOAT_CUSTOM_EXT"),
            1000287004 => write!(f, "INT_CUSTOM_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBuildAccelerationStructureModeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct BuildAccelerationStructureModeKHR(i32);

impl BuildAccelerationStructureModeKHR {
    pub const BUILD: Self = Self(0);
    pub const UPDATE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for BuildAccelerationStructureModeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "BUILD"),
            1 => write!(f, "UPDATE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkChromaLocation.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ChromaLocation(i32);

impl ChromaLocation {
    pub const COSITED_EVEN: Self = Self(0);
    pub const MIDPOINT: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ChromaLocation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COSITED_EVEN"),
            1 => write!(f, "MIDPOINT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCoarseSampleOrderTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CoarseSampleOrderTypeNV(i32);

impl CoarseSampleOrderTypeNV {
    pub const DEFAULT: Self = Self(0);
    pub const CUSTOM: Self = Self(1);
    pub const PIXEL_MAJOR: Self = Self(2);
    pub const SAMPLE_MAJOR: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CoarseSampleOrderTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DEFAULT"),
            1 => write!(f, "CUSTOM"),
            2 => write!(f, "PIXEL_MAJOR"),
            3 => write!(f, "SAMPLE_MAJOR"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkColorSpaceKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ColorSpaceKHR(i32);

impl ColorSpaceKHR {
    pub const SRGB_NONLINEAR: Self = Self(0);
    pub const DISPLAY_P3_NONLINEAR_EXT: Self = Self(1000104001);
    pub const EXTENDED_SRGB_LINEAR_EXT: Self = Self(1000104002);
    pub const DISPLAY_P3_LINEAR_EXT: Self = Self(1000104003);
    pub const DCI_P3_NONLINEAR_EXT: Self = Self(1000104004);
    pub const BT709_LINEAR_EXT: Self = Self(1000104005);
    pub const BT709_NONLINEAR_EXT: Self = Self(1000104006);
    pub const BT2020_LINEAR_EXT: Self = Self(1000104007);
    pub const HDR10_ST2084_EXT: Self = Self(1000104008);
    pub const DOLBYVISION_EXT: Self = Self(1000104009);
    pub const HDR10_HLG_EXT: Self = Self(1000104010);
    pub const ADOBERGB_LINEAR_EXT: Self = Self(1000104011);
    pub const ADOBERGB_NONLINEAR_EXT: Self = Self(1000104012);
    pub const PASS_THROUGH_EXT: Self = Self(1000104013);
    pub const EXTENDED_SRGB_NONLINEAR_EXT: Self = Self(1000104014);
    pub const DISPLAY_NATIVE_AMD: Self = Self(1000213000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ColorSpaceKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "SRGB_NONLINEAR"),
            1000104001 => write!(f, "DISPLAY_P3_NONLINEAR_EXT"),
            1000104002 => write!(f, "EXTENDED_SRGB_LINEAR_EXT"),
            1000104003 => write!(f, "DISPLAY_P3_LINEAR_EXT"),
            1000104004 => write!(f, "DCI_P3_NONLINEAR_EXT"),
            1000104005 => write!(f, "BT709_LINEAR_EXT"),
            1000104006 => write!(f, "BT709_NONLINEAR_EXT"),
            1000104007 => write!(f, "BT2020_LINEAR_EXT"),
            1000104008 => write!(f, "HDR10_ST2084_EXT"),
            1000104009 => write!(f, "DOLBYVISION_EXT"),
            1000104010 => write!(f, "HDR10_HLG_EXT"),
            1000104011 => write!(f, "ADOBERGB_LINEAR_EXT"),
            1000104012 => write!(f, "ADOBERGB_NONLINEAR_EXT"),
            1000104013 => write!(f, "PASS_THROUGH_EXT"),
            1000104014 => write!(f, "EXTENDED_SRGB_NONLINEAR_EXT"),
            1000213000 => write!(f, "DISPLAY_NATIVE_AMD"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferLevel.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CommandBufferLevel(i32);

impl CommandBufferLevel {
    pub const PRIMARY: Self = Self(0);
    pub const SECONDARY: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CommandBufferLevel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "PRIMARY"),
            1 => write!(f, "SECONDARY"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCompareOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CompareOp(i32);

impl CompareOp {
    pub const NEVER: Self = Self(0);
    pub const LESS: Self = Self(1);
    pub const EQUAL: Self = Self(2);
    pub const LESS_OR_EQUAL: Self = Self(3);
    pub const GREATER: Self = Self(4);
    pub const NOT_EQUAL: Self = Self(5);
    pub const GREATER_OR_EQUAL: Self = Self(6);
    pub const ALWAYS: Self = Self(7);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CompareOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NEVER"),
            1 => write!(f, "LESS"),
            2 => write!(f, "EQUAL"),
            3 => write!(f, "LESS_OR_EQUAL"),
            4 => write!(f, "GREATER"),
            5 => write!(f, "NOT_EQUAL"),
            6 => write!(f, "GREATER_OR_EQUAL"),
            7 => write!(f, "ALWAYS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComponentSwizzle.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ComponentSwizzle(i32);

impl ComponentSwizzle {
    pub const IDENTITY: Self = Self(0);
    pub const ZERO: Self = Self(1);
    pub const ONE: Self = Self(2);
    pub const R: Self = Self(3);
    pub const G: Self = Self(4);
    pub const B: Self = Self(5);
    pub const A: Self = Self(6);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ComponentSwizzle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "IDENTITY"),
            1 => write!(f, "ZERO"),
            2 => write!(f, "ONE"),
            3 => write!(f, "R"),
            4 => write!(f, "G"),
            5 => write!(f, "B"),
            6 => write!(f, "A"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComponentTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ComponentTypeNV(i32);

impl ComponentTypeNV {
    pub const FLOAT16: Self = Self(0);
    pub const FLOAT32: Self = Self(1);
    pub const FLOAT64: Self = Self(2);
    pub const SINT8: Self = Self(3);
    pub const SINT16: Self = Self(4);
    pub const SINT32: Self = Self(5);
    pub const SINT64: Self = Self(6);
    pub const UINT8: Self = Self(7);
    pub const UINT16: Self = Self(8);
    pub const UINT32: Self = Self(9);
    pub const UINT64: Self = Self(10);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ComponentTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FLOAT16"),
            1 => write!(f, "FLOAT32"),
            2 => write!(f, "FLOAT64"),
            3 => write!(f, "SINT8"),
            4 => write!(f, "SINT16"),
            5 => write!(f, "SINT32"),
            6 => write!(f, "SINT64"),
            7 => write!(f, "UINT8"),
            8 => write!(f, "UINT16"),
            9 => write!(f, "UINT32"),
            10 => write!(f, "UINT64"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConservativeRasterizationModeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ConservativeRasterizationModeEXT(i32);

impl ConservativeRasterizationModeEXT {
    pub const DISABLED: Self = Self(0);
    pub const OVERESTIMATE: Self = Self(1);
    pub const UNDERESTIMATE: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ConservativeRasterizationModeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DISABLED"),
            1 => write!(f, "OVERESTIMATE"),
            2 => write!(f, "UNDERESTIMATE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyAccelerationStructureModeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CopyAccelerationStructureModeKHR(i32);

impl CopyAccelerationStructureModeKHR {
    pub const CLONE: Self = Self(0);
    pub const COMPACT: Self = Self(1);
    pub const SERIALIZE: Self = Self(2);
    pub const DESERIALIZE: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CopyAccelerationStructureModeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "CLONE"),
            1 => write!(f, "COMPACT"),
            2 => write!(f, "SERIALIZE"),
            3 => write!(f, "DESERIALIZE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCoverageModulationModeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CoverageModulationModeNV(i32);

impl CoverageModulationModeNV {
    pub const NONE: Self = Self(0);
    pub const RGB: Self = Self(1);
    pub const ALPHA: Self = Self(2);
    pub const RGBA: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CoverageModulationModeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NONE"),
            1 => write!(f, "RGB"),
            2 => write!(f, "ALPHA"),
            3 => write!(f, "RGBA"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCoverageReductionModeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct CoverageReductionModeNV(i32);

impl CoverageReductionModeNV {
    pub const MERGE: Self = Self(0);
    pub const TRUNCATE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for CoverageReductionModeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "MERGE"),
            1 => write!(f, "TRUNCATE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugReportObjectTypeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DebugReportObjectTypeEXT(i32);

impl DebugReportObjectTypeEXT {
    pub const UNKNOWN: Self = Self(0);
    pub const INSTANCE: Self = Self(1);
    pub const PHYSICAL_DEVICE: Self = Self(2);
    pub const DEVICE: Self = Self(3);
    pub const QUEUE: Self = Self(4);
    pub const SEMAPHORE: Self = Self(5);
    pub const COMMAND_BUFFER: Self = Self(6);
    pub const FENCE: Self = Self(7);
    pub const DEVICE_MEMORY: Self = Self(8);
    pub const BUFFER: Self = Self(9);
    pub const IMAGE: Self = Self(10);
    pub const EVENT: Self = Self(11);
    pub const QUERY_POOL: Self = Self(12);
    pub const BUFFER_VIEW: Self = Self(13);
    pub const IMAGE_VIEW: Self = Self(14);
    pub const SHADER_MODULE: Self = Self(15);
    pub const PIPELINE_CACHE: Self = Self(16);
    pub const PIPELINE_LAYOUT: Self = Self(17);
    pub const RENDER_PASS: Self = Self(18);
    pub const PIPELINE: Self = Self(19);
    pub const DESCRIPTOR_SET_LAYOUT: Self = Self(20);
    pub const SAMPLER: Self = Self(21);
    pub const DESCRIPTOR_POOL: Self = Self(22);
    pub const DESCRIPTOR_SET: Self = Self(23);
    pub const FRAMEBUFFER: Self = Self(24);
    pub const COMMAND_POOL: Self = Self(25);
    pub const SURFACE_KHR: Self = Self(26);
    pub const SWAPCHAIN_KHR: Self = Self(27);
    pub const DEBUG_REPORT_CALLBACK_EXT: Self = Self(28);
    pub const DISPLAY_KHR: Self = Self(29);
    pub const DISPLAY_MODE_KHR: Self = Self(30);
    pub const VALIDATION_CACHE_EXT: Self = Self(33);
    pub const SAMPLER_YCBCR_CONVERSION: Self = Self(1000156000);
    pub const DESCRIPTOR_UPDATE_TEMPLATE: Self = Self(1000085000);
    pub const CU_MODULE_NVX: Self = Self(1000029000);
    pub const CU_FUNCTION_NVX: Self = Self(1000029001);
    pub const ACCELERATION_STRUCTURE_KHR: Self = Self(1000150000);
    pub const ACCELERATION_STRUCTURE_NV: Self = Self(1000165000);
    pub const BUFFER_COLLECTION_FUCHSIA: Self = Self(1000366000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DebugReportObjectTypeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UNKNOWN"),
            1 => write!(f, "INSTANCE"),
            2 => write!(f, "PHYSICAL_DEVICE"),
            3 => write!(f, "DEVICE"),
            4 => write!(f, "QUEUE"),
            5 => write!(f, "SEMAPHORE"),
            6 => write!(f, "COMMAND_BUFFER"),
            7 => write!(f, "FENCE"),
            8 => write!(f, "DEVICE_MEMORY"),
            9 => write!(f, "BUFFER"),
            10 => write!(f, "IMAGE"),
            11 => write!(f, "EVENT"),
            12 => write!(f, "QUERY_POOL"),
            13 => write!(f, "BUFFER_VIEW"),
            14 => write!(f, "IMAGE_VIEW"),
            15 => write!(f, "SHADER_MODULE"),
            16 => write!(f, "PIPELINE_CACHE"),
            17 => write!(f, "PIPELINE_LAYOUT"),
            18 => write!(f, "RENDER_PASS"),
            19 => write!(f, "PIPELINE"),
            20 => write!(f, "DESCRIPTOR_SET_LAYOUT"),
            21 => write!(f, "SAMPLER"),
            22 => write!(f, "DESCRIPTOR_POOL"),
            23 => write!(f, "DESCRIPTOR_SET"),
            24 => write!(f, "FRAMEBUFFER"),
            25 => write!(f, "COMMAND_POOL"),
            26 => write!(f, "SURFACE_KHR"),
            27 => write!(f, "SWAPCHAIN_KHR"),
            28 => write!(f, "DEBUG_REPORT_CALLBACK_EXT"),
            29 => write!(f, "DISPLAY_KHR"),
            30 => write!(f, "DISPLAY_MODE_KHR"),
            33 => write!(f, "VALIDATION_CACHE_EXT"),
            1000156000 => write!(f, "SAMPLER_YCBCR_CONVERSION"),
            1000085000 => write!(f, "DESCRIPTOR_UPDATE_TEMPLATE"),
            1000029000 => write!(f, "CU_MODULE_NVX"),
            1000029001 => write!(f, "CU_FUNCTION_NVX"),
            1000150000 => write!(f, "ACCELERATION_STRUCTURE_KHR"),
            1000165000 => write!(f, "ACCELERATION_STRUCTURE_NV"),
            1000366000 => write!(f, "BUFFER_COLLECTION_FUCHSIA"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DescriptorType(i32);

impl DescriptorType {
    pub const SAMPLER: Self = Self(0);
    pub const COMBINED_IMAGE_SAMPLER: Self = Self(1);
    pub const SAMPLED_IMAGE: Self = Self(2);
    pub const STORAGE_IMAGE: Self = Self(3);
    pub const UNIFORM_TEXEL_BUFFER: Self = Self(4);
    pub const STORAGE_TEXEL_BUFFER: Self = Self(5);
    pub const UNIFORM_BUFFER: Self = Self(6);
    pub const STORAGE_BUFFER: Self = Self(7);
    pub const UNIFORM_BUFFER_DYNAMIC: Self = Self(8);
    pub const STORAGE_BUFFER_DYNAMIC: Self = Self(9);
    pub const INPUT_ATTACHMENT: Self = Self(10);
    pub const INLINE_UNIFORM_BLOCK_EXT: Self = Self(1000138000);
    pub const ACCELERATION_STRUCTURE_KHR: Self = Self(1000150000);
    pub const ACCELERATION_STRUCTURE_NV: Self = Self(1000165000);
    pub const MUTABLE_VALVE: Self = Self(1000351000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DescriptorType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "SAMPLER"),
            1 => write!(f, "COMBINED_IMAGE_SAMPLER"),
            2 => write!(f, "SAMPLED_IMAGE"),
            3 => write!(f, "STORAGE_IMAGE"),
            4 => write!(f, "UNIFORM_TEXEL_BUFFER"),
            5 => write!(f, "STORAGE_TEXEL_BUFFER"),
            6 => write!(f, "UNIFORM_BUFFER"),
            7 => write!(f, "STORAGE_BUFFER"),
            8 => write!(f, "UNIFORM_BUFFER_DYNAMIC"),
            9 => write!(f, "STORAGE_BUFFER_DYNAMIC"),
            10 => write!(f, "INPUT_ATTACHMENT"),
            1000138000 => write!(f, "INLINE_UNIFORM_BLOCK_EXT"),
            1000150000 => write!(f, "ACCELERATION_STRUCTURE_KHR"),
            1000165000 => write!(f, "ACCELERATION_STRUCTURE_NV"),
            1000351000 => write!(f, "MUTABLE_VALVE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DescriptorUpdateTemplateType(i32);

impl DescriptorUpdateTemplateType {
    pub const DESCRIPTOR_SET: Self = Self(0);
    pub const PUSH_DESCRIPTORS_KHR: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DescriptorUpdateTemplateType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DESCRIPTOR_SET"),
            1 => write!(f, "PUSH_DESCRIPTORS_KHR"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceEventTypeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DeviceEventTypeEXT(i32);

impl DeviceEventTypeEXT {
    pub const DISPLAY_HOTPLUG: Self = Self(0);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DeviceEventTypeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DISPLAY_HOTPLUG"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryReportEventTypeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DeviceMemoryReportEventTypeEXT(i32);

impl DeviceMemoryReportEventTypeEXT {
    pub const ALLOCATE: Self = Self(0);
    pub const FREE: Self = Self(1);
    pub const IMPORT: Self = Self(2);
    pub const UNIMPORT: Self = Self(3);
    pub const ALLOCATION_FAILED: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DeviceMemoryReportEventTypeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ALLOCATE"),
            1 => write!(f, "FREE"),
            2 => write!(f, "IMPORT"),
            3 => write!(f, "UNIMPORT"),
            4 => write!(f, "ALLOCATION_FAILED"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDiscardRectangleModeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DiscardRectangleModeEXT(i32);

impl DiscardRectangleModeEXT {
    pub const INCLUSIVE: Self = Self(0);
    pub const EXCLUSIVE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DiscardRectangleModeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "INCLUSIVE"),
            1 => write!(f, "EXCLUSIVE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayEventTypeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DisplayEventTypeEXT(i32);

impl DisplayEventTypeEXT {
    pub const FIRST_PIXEL_OUT: Self = Self(0);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DisplayEventTypeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FIRST_PIXEL_OUT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPowerStateEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DisplayPowerStateEXT(i32);

impl DisplayPowerStateEXT {
    pub const OFF: Self = Self(0);
    pub const SUSPEND: Self = Self(1);
    pub const ON: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DisplayPowerStateEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "OFF"),
            1 => write!(f, "SUSPEND"),
            2 => write!(f, "ON"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDriverId.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DriverId(i32);

impl DriverId {
    pub const AMD_PROPRIETARY: Self = Self(1);
    pub const AMD_OPEN_SOURCE: Self = Self(2);
    pub const MESA_RADV: Self = Self(3);
    pub const NVIDIA_PROPRIETARY: Self = Self(4);
    pub const INTEL_PROPRIETARY_WINDOWS: Self = Self(5);
    pub const INTEL_OPEN_SOURCE_MESA: Self = Self(6);
    pub const IMAGINATION_PROPRIETARY: Self = Self(7);
    pub const QUALCOMM_PROPRIETARY: Self = Self(8);
    pub const ARM_PROPRIETARY: Self = Self(9);
    pub const GOOGLE_SWIFTSHADER: Self = Self(10);
    pub const GGP_PROPRIETARY: Self = Self(11);
    pub const BROADCOM_PROPRIETARY: Self = Self(12);
    pub const MESA_LLVMPIPE: Self = Self(13);
    pub const MOLTENVK: Self = Self(14);
    pub const COREAVI_PROPRIETARY: Self = Self(15);
    pub const JUICE_PROPRIETARY: Self = Self(16);
    pub const VERISILICON_PROPRIETARY: Self = Self(17);
    pub const MESA_TURNIP: Self = Self(18);
    pub const MESA_V3DV: Self = Self(19);
    pub const MESA_PANVK: Self = Self(20);
    pub const SAMSUNG_PROPRIETARY: Self = Self(21);
    pub const MESA_VENUS: Self = Self(22);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DriverId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            1 => write!(f, "AMD_PROPRIETARY"),
            2 => write!(f, "AMD_OPEN_SOURCE"),
            3 => write!(f, "MESA_RADV"),
            4 => write!(f, "NVIDIA_PROPRIETARY"),
            5 => write!(f, "INTEL_PROPRIETARY_WINDOWS"),
            6 => write!(f, "INTEL_OPEN_SOURCE_MESA"),
            7 => write!(f, "IMAGINATION_PROPRIETARY"),
            8 => write!(f, "QUALCOMM_PROPRIETARY"),
            9 => write!(f, "ARM_PROPRIETARY"),
            10 => write!(f, "GOOGLE_SWIFTSHADER"),
            11 => write!(f, "GGP_PROPRIETARY"),
            12 => write!(f, "BROADCOM_PROPRIETARY"),
            13 => write!(f, "MESA_LLVMPIPE"),
            14 => write!(f, "MOLTENVK"),
            15 => write!(f, "COREAVI_PROPRIETARY"),
            16 => write!(f, "JUICE_PROPRIETARY"),
            17 => write!(f, "VERISILICON_PROPRIETARY"),
            18 => write!(f, "MESA_TURNIP"),
            19 => write!(f, "MESA_V3DV"),
            20 => write!(f, "MESA_PANVK"),
            21 => write!(f, "SAMSUNG_PROPRIETARY"),
            22 => write!(f, "MESA_VENUS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDynamicState.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct DynamicState(i32);

impl DynamicState {
    pub const VIEWPORT: Self = Self(0);
    pub const SCISSOR: Self = Self(1);
    pub const LINE_WIDTH: Self = Self(2);
    pub const DEPTH_BIAS: Self = Self(3);
    pub const BLEND_CONSTANTS: Self = Self(4);
    pub const DEPTH_BOUNDS: Self = Self(5);
    pub const STENCIL_COMPARE_MASK: Self = Self(6);
    pub const STENCIL_WRITE_MASK: Self = Self(7);
    pub const STENCIL_REFERENCE: Self = Self(8);
    pub const VIEWPORT_W_SCALING_NV: Self = Self(1000087000);
    pub const DISCARD_RECTANGLE_EXT: Self = Self(1000099000);
    pub const SAMPLE_LOCATIONS_EXT: Self = Self(1000143000);
    pub const RAY_TRACING_PIPELINE_STACK_SIZE_KHR: Self = Self(1000347000);
    pub const VIEWPORT_SHADING_RATE_PALETTE_NV: Self = Self(1000164004);
    pub const VIEWPORT_COARSE_SAMPLE_ORDER_NV: Self = Self(1000164006);
    pub const EXCLUSIVE_SCISSOR_NV: Self = Self(1000205001);
    pub const FRAGMENT_SHADING_RATE_KHR: Self = Self(1000226000);
    pub const LINE_STIPPLE_EXT: Self = Self(1000259000);
    pub const CULL_MODE_EXT: Self = Self(1000267000);
    pub const FRONT_FACE_EXT: Self = Self(1000267001);
    pub const PRIMITIVE_TOPOLOGY_EXT: Self = Self(1000267002);
    pub const VIEWPORT_WITH_COUNT_EXT: Self = Self(1000267003);
    pub const SCISSOR_WITH_COUNT_EXT: Self = Self(1000267004);
    pub const VERTEX_INPUT_BINDING_STRIDE_EXT: Self = Self(1000267005);
    pub const DEPTH_TEST_ENABLE_EXT: Self = Self(1000267006);
    pub const DEPTH_WRITE_ENABLE_EXT: Self = Self(1000267007);
    pub const DEPTH_COMPARE_OP_EXT: Self = Self(1000267008);
    pub const DEPTH_BOUNDS_TEST_ENABLE_EXT: Self = Self(1000267009);
    pub const STENCIL_TEST_ENABLE_EXT: Self = Self(1000267010);
    pub const STENCIL_OP_EXT: Self = Self(1000267011);
    pub const VERTEX_INPUT_EXT: Self = Self(1000352000);
    pub const PATCH_CONTROL_POINTS_EXT: Self = Self(1000377000);
    pub const RASTERIZER_DISCARD_ENABLE_EXT: Self = Self(1000377001);
    pub const DEPTH_BIAS_ENABLE_EXT: Self = Self(1000377002);
    pub const LOGIC_OP_EXT: Self = Self(1000377003);
    pub const PRIMITIVE_RESTART_ENABLE_EXT: Self = Self(1000377004);
    pub const COLOR_WRITE_ENABLE_EXT: Self = Self(1000381000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for DynamicState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "VIEWPORT"),
            1 => write!(f, "SCISSOR"),
            2 => write!(f, "LINE_WIDTH"),
            3 => write!(f, "DEPTH_BIAS"),
            4 => write!(f, "BLEND_CONSTANTS"),
            5 => write!(f, "DEPTH_BOUNDS"),
            6 => write!(f, "STENCIL_COMPARE_MASK"),
            7 => write!(f, "STENCIL_WRITE_MASK"),
            8 => write!(f, "STENCIL_REFERENCE"),
            1000087000 => write!(f, "VIEWPORT_W_SCALING_NV"),
            1000099000 => write!(f, "DISCARD_RECTANGLE_EXT"),
            1000143000 => write!(f, "SAMPLE_LOCATIONS_EXT"),
            1000347000 => write!(f, "RAY_TRACING_PIPELINE_STACK_SIZE_KHR"),
            1000164004 => write!(f, "VIEWPORT_SHADING_RATE_PALETTE_NV"),
            1000164006 => write!(f, "VIEWPORT_COARSE_SAMPLE_ORDER_NV"),
            1000205001 => write!(f, "EXCLUSIVE_SCISSOR_NV"),
            1000226000 => write!(f, "FRAGMENT_SHADING_RATE_KHR"),
            1000259000 => write!(f, "LINE_STIPPLE_EXT"),
            1000267000 => write!(f, "CULL_MODE_EXT"),
            1000267001 => write!(f, "FRONT_FACE_EXT"),
            1000267002 => write!(f, "PRIMITIVE_TOPOLOGY_EXT"),
            1000267003 => write!(f, "VIEWPORT_WITH_COUNT_EXT"),
            1000267004 => write!(f, "SCISSOR_WITH_COUNT_EXT"),
            1000267005 => write!(f, "VERTEX_INPUT_BINDING_STRIDE_EXT"),
            1000267006 => write!(f, "DEPTH_TEST_ENABLE_EXT"),
            1000267007 => write!(f, "DEPTH_WRITE_ENABLE_EXT"),
            1000267008 => write!(f, "DEPTH_COMPARE_OP_EXT"),
            1000267009 => write!(f, "DEPTH_BOUNDS_TEST_ENABLE_EXT"),
            1000267010 => write!(f, "STENCIL_TEST_ENABLE_EXT"),
            1000267011 => write!(f, "STENCIL_OP_EXT"),
            1000352000 => write!(f, "VERTEX_INPUT_EXT"),
            1000377000 => write!(f, "PATCH_CONTROL_POINTS_EXT"),
            1000377001 => write!(f, "RASTERIZER_DISCARD_ENABLE_EXT"),
            1000377002 => write!(f, "DEPTH_BIAS_ENABLE_EXT"),
            1000377003 => write!(f, "LOGIC_OP_EXT"),
            1000377004 => write!(f, "PRIMITIVE_RESTART_ENABLE_EXT"),
            1000381000 => write!(f, "COLOR_WRITE_ENABLE_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFilter.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct Filter(i32);

impl Filter {
    pub const NEAREST: Self = Self(0);
    pub const LINEAR: Self = Self(1);
    pub const CUBIC_IMG: Self = Self(1000015000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for Filter {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NEAREST"),
            1 => write!(f, "LINEAR"),
            1000015000 => write!(f, "CUBIC_IMG"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormat.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct Format(i32);

impl Format {
    pub const UNDEFINED: Self = Self(0);
    pub const R4G4_UNORM_PACK8: Self = Self(1);
    pub const R4G4B4A4_UNORM_PACK16: Self = Self(2);
    pub const B4G4R4A4_UNORM_PACK16: Self = Self(3);
    pub const R5G6B5_UNORM_PACK16: Self = Self(4);
    pub const B5G6R5_UNORM_PACK16: Self = Self(5);
    pub const R5G5B5A1_UNORM_PACK16: Self = Self(6);
    pub const B5G5R5A1_UNORM_PACK16: Self = Self(7);
    pub const A1R5G5B5_UNORM_PACK16: Self = Self(8);
    pub const R8_UNORM: Self = Self(9);
    pub const R8_SNORM: Self = Self(10);
    pub const R8_USCALED: Self = Self(11);
    pub const R8_SSCALED: Self = Self(12);
    pub const R8_UINT: Self = Self(13);
    pub const R8_SINT: Self = Self(14);
    pub const R8_SRGB: Self = Self(15);
    pub const R8G8_UNORM: Self = Self(16);
    pub const R8G8_SNORM: Self = Self(17);
    pub const R8G8_USCALED: Self = Self(18);
    pub const R8G8_SSCALED: Self = Self(19);
    pub const R8G8_UINT: Self = Self(20);
    pub const R8G8_SINT: Self = Self(21);
    pub const R8G8_SRGB: Self = Self(22);
    pub const R8G8B8_UNORM: Self = Self(23);
    pub const R8G8B8_SNORM: Self = Self(24);
    pub const R8G8B8_USCALED: Self = Self(25);
    pub const R8G8B8_SSCALED: Self = Self(26);
    pub const R8G8B8_UINT: Self = Self(27);
    pub const R8G8B8_SINT: Self = Self(28);
    pub const R8G8B8_SRGB: Self = Self(29);
    pub const B8G8R8_UNORM: Self = Self(30);
    pub const B8G8R8_SNORM: Self = Self(31);
    pub const B8G8R8_USCALED: Self = Self(32);
    pub const B8G8R8_SSCALED: Self = Self(33);
    pub const B8G8R8_UINT: Self = Self(34);
    pub const B8G8R8_SINT: Self = Self(35);
    pub const B8G8R8_SRGB: Self = Self(36);
    pub const R8G8B8A8_UNORM: Self = Self(37);
    pub const R8G8B8A8_SNORM: Self = Self(38);
    pub const R8G8B8A8_USCALED: Self = Self(39);
    pub const R8G8B8A8_SSCALED: Self = Self(40);
    pub const R8G8B8A8_UINT: Self = Self(41);
    pub const R8G8B8A8_SINT: Self = Self(42);
    pub const R8G8B8A8_SRGB: Self = Self(43);
    pub const B8G8R8A8_UNORM: Self = Self(44);
    pub const B8G8R8A8_SNORM: Self = Self(45);
    pub const B8G8R8A8_USCALED: Self = Self(46);
    pub const B8G8R8A8_SSCALED: Self = Self(47);
    pub const B8G8R8A8_UINT: Self = Self(48);
    pub const B8G8R8A8_SINT: Self = Self(49);
    pub const B8G8R8A8_SRGB: Self = Self(50);
    pub const A8B8G8R8_UNORM_PACK32: Self = Self(51);
    pub const A8B8G8R8_SNORM_PACK32: Self = Self(52);
    pub const A8B8G8R8_USCALED_PACK32: Self = Self(53);
    pub const A8B8G8R8_SSCALED_PACK32: Self = Self(54);
    pub const A8B8G8R8_UINT_PACK32: Self = Self(55);
    pub const A8B8G8R8_SINT_PACK32: Self = Self(56);
    pub const A8B8G8R8_SRGB_PACK32: Self = Self(57);
    pub const A2R10G10B10_UNORM_PACK32: Self = Self(58);
    pub const A2R10G10B10_SNORM_PACK32: Self = Self(59);
    pub const A2R10G10B10_USCALED_PACK32: Self = Self(60);
    pub const A2R10G10B10_SSCALED_PACK32: Self = Self(61);
    pub const A2R10G10B10_UINT_PACK32: Self = Self(62);
    pub const A2R10G10B10_SINT_PACK32: Self = Self(63);
    pub const A2B10G10R10_UNORM_PACK32: Self = Self(64);
    pub const A2B10G10R10_SNORM_PACK32: Self = Self(65);
    pub const A2B10G10R10_USCALED_PACK32: Self = Self(66);
    pub const A2B10G10R10_SSCALED_PACK32: Self = Self(67);
    pub const A2B10G10R10_UINT_PACK32: Self = Self(68);
    pub const A2B10G10R10_SINT_PACK32: Self = Self(69);
    pub const R16_UNORM: Self = Self(70);
    pub const R16_SNORM: Self = Self(71);
    pub const R16_USCALED: Self = Self(72);
    pub const R16_SSCALED: Self = Self(73);
    pub const R16_UINT: Self = Self(74);
    pub const R16_SINT: Self = Self(75);
    pub const R16_SFLOAT: Self = Self(76);
    pub const R16G16_UNORM: Self = Self(77);
    pub const R16G16_SNORM: Self = Self(78);
    pub const R16G16_USCALED: Self = Self(79);
    pub const R16G16_SSCALED: Self = Self(80);
    pub const R16G16_UINT: Self = Self(81);
    pub const R16G16_SINT: Self = Self(82);
    pub const R16G16_SFLOAT: Self = Self(83);
    pub const R16G16B16_UNORM: Self = Self(84);
    pub const R16G16B16_SNORM: Self = Self(85);
    pub const R16G16B16_USCALED: Self = Self(86);
    pub const R16G16B16_SSCALED: Self = Self(87);
    pub const R16G16B16_UINT: Self = Self(88);
    pub const R16G16B16_SINT: Self = Self(89);
    pub const R16G16B16_SFLOAT: Self = Self(90);
    pub const R16G16B16A16_UNORM: Self = Self(91);
    pub const R16G16B16A16_SNORM: Self = Self(92);
    pub const R16G16B16A16_USCALED: Self = Self(93);
    pub const R16G16B16A16_SSCALED: Self = Self(94);
    pub const R16G16B16A16_UINT: Self = Self(95);
    pub const R16G16B16A16_SINT: Self = Self(96);
    pub const R16G16B16A16_SFLOAT: Self = Self(97);
    pub const R32_UINT: Self = Self(98);
    pub const R32_SINT: Self = Self(99);
    pub const R32_SFLOAT: Self = Self(100);
    pub const R32G32_UINT: Self = Self(101);
    pub const R32G32_SINT: Self = Self(102);
    pub const R32G32_SFLOAT: Self = Self(103);
    pub const R32G32B32_UINT: Self = Self(104);
    pub const R32G32B32_SINT: Self = Self(105);
    pub const R32G32B32_SFLOAT: Self = Self(106);
    pub const R32G32B32A32_UINT: Self = Self(107);
    pub const R32G32B32A32_SINT: Self = Self(108);
    pub const R32G32B32A32_SFLOAT: Self = Self(109);
    pub const R64_UINT: Self = Self(110);
    pub const R64_SINT: Self = Self(111);
    pub const R64_SFLOAT: Self = Self(112);
    pub const R64G64_UINT: Self = Self(113);
    pub const R64G64_SINT: Self = Self(114);
    pub const R64G64_SFLOAT: Self = Self(115);
    pub const R64G64B64_UINT: Self = Self(116);
    pub const R64G64B64_SINT: Self = Self(117);
    pub const R64G64B64_SFLOAT: Self = Self(118);
    pub const R64G64B64A64_UINT: Self = Self(119);
    pub const R64G64B64A64_SINT: Self = Self(120);
    pub const R64G64B64A64_SFLOAT: Self = Self(121);
    pub const B10G11R11_UFLOAT_PACK32: Self = Self(122);
    pub const E5B9G9R9_UFLOAT_PACK32: Self = Self(123);
    pub const D16_UNORM: Self = Self(124);
    pub const X8_D24_UNORM_PACK32: Self = Self(125);
    pub const D32_SFLOAT: Self = Self(126);
    pub const S8_UINT: Self = Self(127);
    pub const D16_UNORM_S8_UINT: Self = Self(128);
    pub const D24_UNORM_S8_UINT: Self = Self(129);
    pub const D32_SFLOAT_S8_UINT: Self = Self(130);
    pub const BC1_RGB_UNORM_BLOCK: Self = Self(131);
    pub const BC1_RGB_SRGB_BLOCK: Self = Self(132);
    pub const BC1_RGBA_UNORM_BLOCK: Self = Self(133);
    pub const BC1_RGBA_SRGB_BLOCK: Self = Self(134);
    pub const BC2_UNORM_BLOCK: Self = Self(135);
    pub const BC2_SRGB_BLOCK: Self = Self(136);
    pub const BC3_UNORM_BLOCK: Self = Self(137);
    pub const BC3_SRGB_BLOCK: Self = Self(138);
    pub const BC4_UNORM_BLOCK: Self = Self(139);
    pub const BC4_SNORM_BLOCK: Self = Self(140);
    pub const BC5_UNORM_BLOCK: Self = Self(141);
    pub const BC5_SNORM_BLOCK: Self = Self(142);
    pub const BC6H_UFLOAT_BLOCK: Self = Self(143);
    pub const BC6H_SFLOAT_BLOCK: Self = Self(144);
    pub const BC7_UNORM_BLOCK: Self = Self(145);
    pub const BC7_SRGB_BLOCK: Self = Self(146);
    pub const ETC2_R8G8B8_UNORM_BLOCK: Self = Self(147);
    pub const ETC2_R8G8B8_SRGB_BLOCK: Self = Self(148);
    pub const ETC2_R8G8B8A1_UNORM_BLOCK: Self = Self(149);
    pub const ETC2_R8G8B8A1_SRGB_BLOCK: Self = Self(150);
    pub const ETC2_R8G8B8A8_UNORM_BLOCK: Self = Self(151);
    pub const ETC2_R8G8B8A8_SRGB_BLOCK: Self = Self(152);
    pub const EAC_R11_UNORM_BLOCK: Self = Self(153);
    pub const EAC_R11_SNORM_BLOCK: Self = Self(154);
    pub const EAC_R11G11_UNORM_BLOCK: Self = Self(155);
    pub const EAC_R11G11_SNORM_BLOCK: Self = Self(156);
    pub const ASTC_4X4_UNORM_BLOCK: Self = Self(157);
    pub const ASTC_4X4_SRGB_BLOCK: Self = Self(158);
    pub const ASTC_5X4_UNORM_BLOCK: Self = Self(159);
    pub const ASTC_5X4_SRGB_BLOCK: Self = Self(160);
    pub const ASTC_5X5_UNORM_BLOCK: Self = Self(161);
    pub const ASTC_5X5_SRGB_BLOCK: Self = Self(162);
    pub const ASTC_6X5_UNORM_BLOCK: Self = Self(163);
    pub const ASTC_6X5_SRGB_BLOCK: Self = Self(164);
    pub const ASTC_6X6_UNORM_BLOCK: Self = Self(165);
    pub const ASTC_6X6_SRGB_BLOCK: Self = Self(166);
    pub const ASTC_8X5_UNORM_BLOCK: Self = Self(167);
    pub const ASTC_8X5_SRGB_BLOCK: Self = Self(168);
    pub const ASTC_8X6_UNORM_BLOCK: Self = Self(169);
    pub const ASTC_8X6_SRGB_BLOCK: Self = Self(170);
    pub const ASTC_8X8_UNORM_BLOCK: Self = Self(171);
    pub const ASTC_8X8_SRGB_BLOCK: Self = Self(172);
    pub const ASTC_10X5_UNORM_BLOCK: Self = Self(173);
    pub const ASTC_10X5_SRGB_BLOCK: Self = Self(174);
    pub const ASTC_10X6_UNORM_BLOCK: Self = Self(175);
    pub const ASTC_10X6_SRGB_BLOCK: Self = Self(176);
    pub const ASTC_10X8_UNORM_BLOCK: Self = Self(177);
    pub const ASTC_10X8_SRGB_BLOCK: Self = Self(178);
    pub const ASTC_10X10_UNORM_BLOCK: Self = Self(179);
    pub const ASTC_10X10_SRGB_BLOCK: Self = Self(180);
    pub const ASTC_12X10_UNORM_BLOCK: Self = Self(181);
    pub const ASTC_12X10_SRGB_BLOCK: Self = Self(182);
    pub const ASTC_12X12_UNORM_BLOCK: Self = Self(183);
    pub const ASTC_12X12_SRGB_BLOCK: Self = Self(184);
    pub const G8B8G8R8_422_UNORM: Self = Self(1000156000);
    pub const B8G8R8G8_422_UNORM: Self = Self(1000156001);
    pub const G8_B8_R8_3PLANE_420_UNORM: Self = Self(1000156002);
    pub const G8_B8R8_2PLANE_420_UNORM: Self = Self(1000156003);
    pub const G8_B8_R8_3PLANE_422_UNORM: Self = Self(1000156004);
    pub const G8_B8R8_2PLANE_422_UNORM: Self = Self(1000156005);
    pub const G8_B8_R8_3PLANE_444_UNORM: Self = Self(1000156006);
    pub const R10X6_UNORM_PACK16: Self = Self(1000156007);
    pub const R10X6G10X6_UNORM_2PACK16: Self = Self(1000156008);
    pub const R10X6G10X6B10X6A10X6_UNORM_4PACK16: Self = Self(1000156009);
    pub const G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: Self = Self(1000156010);
    pub const B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: Self = Self(1000156011);
    pub const G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: Self = Self(1000156012);
    pub const G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: Self = Self(1000156013);
    pub const G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: Self = Self(1000156014);
    pub const G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: Self = Self(1000156015);
    pub const G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: Self = Self(1000156016);
    pub const R12X4_UNORM_PACK16: Self = Self(1000156017);
    pub const R12X4G12X4_UNORM_2PACK16: Self = Self(1000156018);
    pub const R12X4G12X4B12X4A12X4_UNORM_4PACK16: Self = Self(1000156019);
    pub const G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: Self = Self(1000156020);
    pub const B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: Self = Self(1000156021);
    pub const G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: Self = Self(1000156022);
    pub const G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: Self = Self(1000156023);
    pub const G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: Self = Self(1000156024);
    pub const G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: Self = Self(1000156025);
    pub const G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: Self = Self(1000156026);
    pub const G16B16G16R16_422_UNORM: Self = Self(1000156027);
    pub const B16G16R16G16_422_UNORM: Self = Self(1000156028);
    pub const G16_B16_R16_3PLANE_420_UNORM: Self = Self(1000156029);
    pub const G16_B16R16_2PLANE_420_UNORM: Self = Self(1000156030);
    pub const G16_B16_R16_3PLANE_422_UNORM: Self = Self(1000156031);
    pub const G16_B16R16_2PLANE_422_UNORM: Self = Self(1000156032);
    pub const G16_B16_R16_3PLANE_444_UNORM: Self = Self(1000156033);
    pub const PVRTC1_2BPP_UNORM_BLOCK_IMG: Self = Self(1000054000);
    pub const PVRTC1_4BPP_UNORM_BLOCK_IMG: Self = Self(1000054001);
    pub const PVRTC2_2BPP_UNORM_BLOCK_IMG: Self = Self(1000054002);
    pub const PVRTC2_4BPP_UNORM_BLOCK_IMG: Self = Self(1000054003);
    pub const PVRTC1_2BPP_SRGB_BLOCK_IMG: Self = Self(1000054004);
    pub const PVRTC1_4BPP_SRGB_BLOCK_IMG: Self = Self(1000054005);
    pub const PVRTC2_2BPP_SRGB_BLOCK_IMG: Self = Self(1000054006);
    pub const PVRTC2_4BPP_SRGB_BLOCK_IMG: Self = Self(1000054007);
    pub const ASTC_4X4_SFLOAT_BLOCK_EXT: Self = Self(1000066000);
    pub const ASTC_5X4_SFLOAT_BLOCK_EXT: Self = Self(1000066001);
    pub const ASTC_5X5_SFLOAT_BLOCK_EXT: Self = Self(1000066002);
    pub const ASTC_6X5_SFLOAT_BLOCK_EXT: Self = Self(1000066003);
    pub const ASTC_6X6_SFLOAT_BLOCK_EXT: Self = Self(1000066004);
    pub const ASTC_8X5_SFLOAT_BLOCK_EXT: Self = Self(1000066005);
    pub const ASTC_8X6_SFLOAT_BLOCK_EXT: Self = Self(1000066006);
    pub const ASTC_8X8_SFLOAT_BLOCK_EXT: Self = Self(1000066007);
    pub const ASTC_10X5_SFLOAT_BLOCK_EXT: Self = Self(1000066008);
    pub const ASTC_10X6_SFLOAT_BLOCK_EXT: Self = Self(1000066009);
    pub const ASTC_10X8_SFLOAT_BLOCK_EXT: Self = Self(1000066010);
    pub const ASTC_10X10_SFLOAT_BLOCK_EXT: Self = Self(1000066011);
    pub const ASTC_12X10_SFLOAT_BLOCK_EXT: Self = Self(1000066012);
    pub const ASTC_12X12_SFLOAT_BLOCK_EXT: Self = Self(1000066013);
    pub const G8_B8R8_2PLANE_444_UNORM_EXT: Self = Self(1000330000);
    pub const G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT: Self = Self(1000330001);
    pub const G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT: Self = Self(1000330002);
    pub const G16_B16R16_2PLANE_444_UNORM_EXT: Self = Self(1000330003);
    pub const A4R4G4B4_UNORM_PACK16_EXT: Self = Self(1000340000);
    pub const A4B4G4R4_UNORM_PACK16_EXT: Self = Self(1000340001);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for Format {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UNDEFINED"),
            1 => write!(f, "R4G4_UNORM_PACK8"),
            2 => write!(f, "R4G4B4A4_UNORM_PACK16"),
            3 => write!(f, "B4G4R4A4_UNORM_PACK16"),
            4 => write!(f, "R5G6B5_UNORM_PACK16"),
            5 => write!(f, "B5G6R5_UNORM_PACK16"),
            6 => write!(f, "R5G5B5A1_UNORM_PACK16"),
            7 => write!(f, "B5G5R5A1_UNORM_PACK16"),
            8 => write!(f, "A1R5G5B5_UNORM_PACK16"),
            9 => write!(f, "R8_UNORM"),
            10 => write!(f, "R8_SNORM"),
            11 => write!(f, "R8_USCALED"),
            12 => write!(f, "R8_SSCALED"),
            13 => write!(f, "R8_UINT"),
            14 => write!(f, "R8_SINT"),
            15 => write!(f, "R8_SRGB"),
            16 => write!(f, "R8G8_UNORM"),
            17 => write!(f, "R8G8_SNORM"),
            18 => write!(f, "R8G8_USCALED"),
            19 => write!(f, "R8G8_SSCALED"),
            20 => write!(f, "R8G8_UINT"),
            21 => write!(f, "R8G8_SINT"),
            22 => write!(f, "R8G8_SRGB"),
            23 => write!(f, "R8G8B8_UNORM"),
            24 => write!(f, "R8G8B8_SNORM"),
            25 => write!(f, "R8G8B8_USCALED"),
            26 => write!(f, "R8G8B8_SSCALED"),
            27 => write!(f, "R8G8B8_UINT"),
            28 => write!(f, "R8G8B8_SINT"),
            29 => write!(f, "R8G8B8_SRGB"),
            30 => write!(f, "B8G8R8_UNORM"),
            31 => write!(f, "B8G8R8_SNORM"),
            32 => write!(f, "B8G8R8_USCALED"),
            33 => write!(f, "B8G8R8_SSCALED"),
            34 => write!(f, "B8G8R8_UINT"),
            35 => write!(f, "B8G8R8_SINT"),
            36 => write!(f, "B8G8R8_SRGB"),
            37 => write!(f, "R8G8B8A8_UNORM"),
            38 => write!(f, "R8G8B8A8_SNORM"),
            39 => write!(f, "R8G8B8A8_USCALED"),
            40 => write!(f, "R8G8B8A8_SSCALED"),
            41 => write!(f, "R8G8B8A8_UINT"),
            42 => write!(f, "R8G8B8A8_SINT"),
            43 => write!(f, "R8G8B8A8_SRGB"),
            44 => write!(f, "B8G8R8A8_UNORM"),
            45 => write!(f, "B8G8R8A8_SNORM"),
            46 => write!(f, "B8G8R8A8_USCALED"),
            47 => write!(f, "B8G8R8A8_SSCALED"),
            48 => write!(f, "B8G8R8A8_UINT"),
            49 => write!(f, "B8G8R8A8_SINT"),
            50 => write!(f, "B8G8R8A8_SRGB"),
            51 => write!(f, "A8B8G8R8_UNORM_PACK32"),
            52 => write!(f, "A8B8G8R8_SNORM_PACK32"),
            53 => write!(f, "A8B8G8R8_USCALED_PACK32"),
            54 => write!(f, "A8B8G8R8_SSCALED_PACK32"),
            55 => write!(f, "A8B8G8R8_UINT_PACK32"),
            56 => write!(f, "A8B8G8R8_SINT_PACK32"),
            57 => write!(f, "A8B8G8R8_SRGB_PACK32"),
            58 => write!(f, "A2R10G10B10_UNORM_PACK32"),
            59 => write!(f, "A2R10G10B10_SNORM_PACK32"),
            60 => write!(f, "A2R10G10B10_USCALED_PACK32"),
            61 => write!(f, "A2R10G10B10_SSCALED_PACK32"),
            62 => write!(f, "A2R10G10B10_UINT_PACK32"),
            63 => write!(f, "A2R10G10B10_SINT_PACK32"),
            64 => write!(f, "A2B10G10R10_UNORM_PACK32"),
            65 => write!(f, "A2B10G10R10_SNORM_PACK32"),
            66 => write!(f, "A2B10G10R10_USCALED_PACK32"),
            67 => write!(f, "A2B10G10R10_SSCALED_PACK32"),
            68 => write!(f, "A2B10G10R10_UINT_PACK32"),
            69 => write!(f, "A2B10G10R10_SINT_PACK32"),
            70 => write!(f, "R16_UNORM"),
            71 => write!(f, "R16_SNORM"),
            72 => write!(f, "R16_USCALED"),
            73 => write!(f, "R16_SSCALED"),
            74 => write!(f, "R16_UINT"),
            75 => write!(f, "R16_SINT"),
            76 => write!(f, "R16_SFLOAT"),
            77 => write!(f, "R16G16_UNORM"),
            78 => write!(f, "R16G16_SNORM"),
            79 => write!(f, "R16G16_USCALED"),
            80 => write!(f, "R16G16_SSCALED"),
            81 => write!(f, "R16G16_UINT"),
            82 => write!(f, "R16G16_SINT"),
            83 => write!(f, "R16G16_SFLOAT"),
            84 => write!(f, "R16G16B16_UNORM"),
            85 => write!(f, "R16G16B16_SNORM"),
            86 => write!(f, "R16G16B16_USCALED"),
            87 => write!(f, "R16G16B16_SSCALED"),
            88 => write!(f, "R16G16B16_UINT"),
            89 => write!(f, "R16G16B16_SINT"),
            90 => write!(f, "R16G16B16_SFLOAT"),
            91 => write!(f, "R16G16B16A16_UNORM"),
            92 => write!(f, "R16G16B16A16_SNORM"),
            93 => write!(f, "R16G16B16A16_USCALED"),
            94 => write!(f, "R16G16B16A16_SSCALED"),
            95 => write!(f, "R16G16B16A16_UINT"),
            96 => write!(f, "R16G16B16A16_SINT"),
            97 => write!(f, "R16G16B16A16_SFLOAT"),
            98 => write!(f, "R32_UINT"),
            99 => write!(f, "R32_SINT"),
            100 => write!(f, "R32_SFLOAT"),
            101 => write!(f, "R32G32_UINT"),
            102 => write!(f, "R32G32_SINT"),
            103 => write!(f, "R32G32_SFLOAT"),
            104 => write!(f, "R32G32B32_UINT"),
            105 => write!(f, "R32G32B32_SINT"),
            106 => write!(f, "R32G32B32_SFLOAT"),
            107 => write!(f, "R32G32B32A32_UINT"),
            108 => write!(f, "R32G32B32A32_SINT"),
            109 => write!(f, "R32G32B32A32_SFLOAT"),
            110 => write!(f, "R64_UINT"),
            111 => write!(f, "R64_SINT"),
            112 => write!(f, "R64_SFLOAT"),
            113 => write!(f, "R64G64_UINT"),
            114 => write!(f, "R64G64_SINT"),
            115 => write!(f, "R64G64_SFLOAT"),
            116 => write!(f, "R64G64B64_UINT"),
            117 => write!(f, "R64G64B64_SINT"),
            118 => write!(f, "R64G64B64_SFLOAT"),
            119 => write!(f, "R64G64B64A64_UINT"),
            120 => write!(f, "R64G64B64A64_SINT"),
            121 => write!(f, "R64G64B64A64_SFLOAT"),
            122 => write!(f, "B10G11R11_UFLOAT_PACK32"),
            123 => write!(f, "E5B9G9R9_UFLOAT_PACK32"),
            124 => write!(f, "D16_UNORM"),
            125 => write!(f, "X8_D24_UNORM_PACK32"),
            126 => write!(f, "D32_SFLOAT"),
            127 => write!(f, "S8_UINT"),
            128 => write!(f, "D16_UNORM_S8_UINT"),
            129 => write!(f, "D24_UNORM_S8_UINT"),
            130 => write!(f, "D32_SFLOAT_S8_UINT"),
            131 => write!(f, "BC1_RGB_UNORM_BLOCK"),
            132 => write!(f, "BC1_RGB_SRGB_BLOCK"),
            133 => write!(f, "BC1_RGBA_UNORM_BLOCK"),
            134 => write!(f, "BC1_RGBA_SRGB_BLOCK"),
            135 => write!(f, "BC2_UNORM_BLOCK"),
            136 => write!(f, "BC2_SRGB_BLOCK"),
            137 => write!(f, "BC3_UNORM_BLOCK"),
            138 => write!(f, "BC3_SRGB_BLOCK"),
            139 => write!(f, "BC4_UNORM_BLOCK"),
            140 => write!(f, "BC4_SNORM_BLOCK"),
            141 => write!(f, "BC5_UNORM_BLOCK"),
            142 => write!(f, "BC5_SNORM_BLOCK"),
            143 => write!(f, "BC6H_UFLOAT_BLOCK"),
            144 => write!(f, "BC6H_SFLOAT_BLOCK"),
            145 => write!(f, "BC7_UNORM_BLOCK"),
            146 => write!(f, "BC7_SRGB_BLOCK"),
            147 => write!(f, "ETC2_R8G8B8_UNORM_BLOCK"),
            148 => write!(f, "ETC2_R8G8B8_SRGB_BLOCK"),
            149 => write!(f, "ETC2_R8G8B8A1_UNORM_BLOCK"),
            150 => write!(f, "ETC2_R8G8B8A1_SRGB_BLOCK"),
            151 => write!(f, "ETC2_R8G8B8A8_UNORM_BLOCK"),
            152 => write!(f, "ETC2_R8G8B8A8_SRGB_BLOCK"),
            153 => write!(f, "EAC_R11_UNORM_BLOCK"),
            154 => write!(f, "EAC_R11_SNORM_BLOCK"),
            155 => write!(f, "EAC_R11G11_UNORM_BLOCK"),
            156 => write!(f, "EAC_R11G11_SNORM_BLOCK"),
            157 => write!(f, "ASTC_4X4_UNORM_BLOCK"),
            158 => write!(f, "ASTC_4X4_SRGB_BLOCK"),
            159 => write!(f, "ASTC_5X4_UNORM_BLOCK"),
            160 => write!(f, "ASTC_5X4_SRGB_BLOCK"),
            161 => write!(f, "ASTC_5X5_UNORM_BLOCK"),
            162 => write!(f, "ASTC_5X5_SRGB_BLOCK"),
            163 => write!(f, "ASTC_6X5_UNORM_BLOCK"),
            164 => write!(f, "ASTC_6X5_SRGB_BLOCK"),
            165 => write!(f, "ASTC_6X6_UNORM_BLOCK"),
            166 => write!(f, "ASTC_6X6_SRGB_BLOCK"),
            167 => write!(f, "ASTC_8X5_UNORM_BLOCK"),
            168 => write!(f, "ASTC_8X5_SRGB_BLOCK"),
            169 => write!(f, "ASTC_8X6_UNORM_BLOCK"),
            170 => write!(f, "ASTC_8X6_SRGB_BLOCK"),
            171 => write!(f, "ASTC_8X8_UNORM_BLOCK"),
            172 => write!(f, "ASTC_8X8_SRGB_BLOCK"),
            173 => write!(f, "ASTC_10X5_UNORM_BLOCK"),
            174 => write!(f, "ASTC_10X5_SRGB_BLOCK"),
            175 => write!(f, "ASTC_10X6_UNORM_BLOCK"),
            176 => write!(f, "ASTC_10X6_SRGB_BLOCK"),
            177 => write!(f, "ASTC_10X8_UNORM_BLOCK"),
            178 => write!(f, "ASTC_10X8_SRGB_BLOCK"),
            179 => write!(f, "ASTC_10X10_UNORM_BLOCK"),
            180 => write!(f, "ASTC_10X10_SRGB_BLOCK"),
            181 => write!(f, "ASTC_12X10_UNORM_BLOCK"),
            182 => write!(f, "ASTC_12X10_SRGB_BLOCK"),
            183 => write!(f, "ASTC_12X12_UNORM_BLOCK"),
            184 => write!(f, "ASTC_12X12_SRGB_BLOCK"),
            1000156000 => write!(f, "G8B8G8R8_422_UNORM"),
            1000156001 => write!(f, "B8G8R8G8_422_UNORM"),
            1000156002 => write!(f, "G8_B8_R8_3PLANE_420_UNORM"),
            1000156003 => write!(f, "G8_B8R8_2PLANE_420_UNORM"),
            1000156004 => write!(f, "G8_B8_R8_3PLANE_422_UNORM"),
            1000156005 => write!(f, "G8_B8R8_2PLANE_422_UNORM"),
            1000156006 => write!(f, "G8_B8_R8_3PLANE_444_UNORM"),
            1000156007 => write!(f, "R10X6_UNORM_PACK16"),
            1000156008 => write!(f, "R10X6G10X6_UNORM_2PACK16"),
            1000156009 => write!(f, "R10X6G10X6B10X6A10X6_UNORM_4PACK16"),
            1000156010 => write!(f, "G10X6B10X6G10X6R10X6_422_UNORM_4PACK16"),
            1000156011 => write!(f, "B10X6G10X6R10X6G10X6_422_UNORM_4PACK16"),
            1000156012 => write!(f, "G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16"),
            1000156013 => write!(f, "G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16"),
            1000156014 => write!(f, "G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16"),
            1000156015 => write!(f, "G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16"),
            1000156016 => write!(f, "G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16"),
            1000156017 => write!(f, "R12X4_UNORM_PACK16"),
            1000156018 => write!(f, "R12X4G12X4_UNORM_2PACK16"),
            1000156019 => write!(f, "R12X4G12X4B12X4A12X4_UNORM_4PACK16"),
            1000156020 => write!(f, "G12X4B12X4G12X4R12X4_422_UNORM_4PACK16"),
            1000156021 => write!(f, "B12X4G12X4R12X4G12X4_422_UNORM_4PACK16"),
            1000156022 => write!(f, "G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16"),
            1000156023 => write!(f, "G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16"),
            1000156024 => write!(f, "G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16"),
            1000156025 => write!(f, "G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16"),
            1000156026 => write!(f, "G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16"),
            1000156027 => write!(f, "G16B16G16R16_422_UNORM"),
            1000156028 => write!(f, "B16G16R16G16_422_UNORM"),
            1000156029 => write!(f, "G16_B16_R16_3PLANE_420_UNORM"),
            1000156030 => write!(f, "G16_B16R16_2PLANE_420_UNORM"),
            1000156031 => write!(f, "G16_B16_R16_3PLANE_422_UNORM"),
            1000156032 => write!(f, "G16_B16R16_2PLANE_422_UNORM"),
            1000156033 => write!(f, "G16_B16_R16_3PLANE_444_UNORM"),
            1000054000 => write!(f, "PVRTC1_2BPP_UNORM_BLOCK_IMG"),
            1000054001 => write!(f, "PVRTC1_4BPP_UNORM_BLOCK_IMG"),
            1000054002 => write!(f, "PVRTC2_2BPP_UNORM_BLOCK_IMG"),
            1000054003 => write!(f, "PVRTC2_4BPP_UNORM_BLOCK_IMG"),
            1000054004 => write!(f, "PVRTC1_2BPP_SRGB_BLOCK_IMG"),
            1000054005 => write!(f, "PVRTC1_4BPP_SRGB_BLOCK_IMG"),
            1000054006 => write!(f, "PVRTC2_2BPP_SRGB_BLOCK_IMG"),
            1000054007 => write!(f, "PVRTC2_4BPP_SRGB_BLOCK_IMG"),
            1000066000 => write!(f, "ASTC_4X4_SFLOAT_BLOCK_EXT"),
            1000066001 => write!(f, "ASTC_5X4_SFLOAT_BLOCK_EXT"),
            1000066002 => write!(f, "ASTC_5X5_SFLOAT_BLOCK_EXT"),
            1000066003 => write!(f, "ASTC_6X5_SFLOAT_BLOCK_EXT"),
            1000066004 => write!(f, "ASTC_6X6_SFLOAT_BLOCK_EXT"),
            1000066005 => write!(f, "ASTC_8X5_SFLOAT_BLOCK_EXT"),
            1000066006 => write!(f, "ASTC_8X6_SFLOAT_BLOCK_EXT"),
            1000066007 => write!(f, "ASTC_8X8_SFLOAT_BLOCK_EXT"),
            1000066008 => write!(f, "ASTC_10X5_SFLOAT_BLOCK_EXT"),
            1000066009 => write!(f, "ASTC_10X6_SFLOAT_BLOCK_EXT"),
            1000066010 => write!(f, "ASTC_10X8_SFLOAT_BLOCK_EXT"),
            1000066011 => write!(f, "ASTC_10X10_SFLOAT_BLOCK_EXT"),
            1000066012 => write!(f, "ASTC_12X10_SFLOAT_BLOCK_EXT"),
            1000066013 => write!(f, "ASTC_12X12_SFLOAT_BLOCK_EXT"),
            1000330000 => write!(f, "G8_B8R8_2PLANE_444_UNORM_EXT"),
            1000330001 => write!(f, "G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT"),
            1000330002 => write!(f, "G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT"),
            1000330003 => write!(f, "G16_B16R16_2PLANE_444_UNORM_EXT"),
            1000340000 => write!(f, "A4R4G4B4_UNORM_PACK16_EXT"),
            1000340001 => write!(f, "A4B4G4R4_UNORM_PACK16_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFragmentShadingRateCombinerOpKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct FragmentShadingRateCombinerOpKHR(i32);

impl FragmentShadingRateCombinerOpKHR {
    pub const KEEP: Self = Self(0);
    pub const REPLACE: Self = Self(1);
    pub const MIN: Self = Self(2);
    pub const MAX: Self = Self(3);
    pub const MUL: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for FragmentShadingRateCombinerOpKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "KEEP"),
            1 => write!(f, "REPLACE"),
            2 => write!(f, "MIN"),
            3 => write!(f, "MAX"),
            4 => write!(f, "MUL"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFragmentShadingRateNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct FragmentShadingRateNV(i32);

impl FragmentShadingRateNV {
    pub const _1_INVOCATION_PER_PIXEL: Self = Self(0);
    pub const _1_INVOCATION_PER_1X2_PIXELS: Self = Self(1);
    pub const _1_INVOCATION_PER_2X1_PIXELS: Self = Self(4);
    pub const _1_INVOCATION_PER_2X2_PIXELS: Self = Self(5);
    pub const _1_INVOCATION_PER_2X4_PIXELS: Self = Self(6);
    pub const _1_INVOCATION_PER_4X2_PIXELS: Self = Self(9);
    pub const _1_INVOCATION_PER_4X4_PIXELS: Self = Self(10);
    pub const _2_INVOCATIONS_PER_PIXEL: Self = Self(11);
    pub const _4_INVOCATIONS_PER_PIXEL: Self = Self(12);
    pub const _8_INVOCATIONS_PER_PIXEL: Self = Self(13);
    pub const _16_INVOCATIONS_PER_PIXEL: Self = Self(14);
    pub const NO_INVOCATIONS: Self = Self(15);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for FragmentShadingRateNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "_1_INVOCATION_PER_PIXEL"),
            1 => write!(f, "_1_INVOCATION_PER_1X2_PIXELS"),
            4 => write!(f, "_1_INVOCATION_PER_2X1_PIXELS"),
            5 => write!(f, "_1_INVOCATION_PER_2X2_PIXELS"),
            6 => write!(f, "_1_INVOCATION_PER_2X4_PIXELS"),
            9 => write!(f, "_1_INVOCATION_PER_4X2_PIXELS"),
            10 => write!(f, "_1_INVOCATION_PER_4X4_PIXELS"),
            11 => write!(f, "_2_INVOCATIONS_PER_PIXEL"),
            12 => write!(f, "_4_INVOCATIONS_PER_PIXEL"),
            13 => write!(f, "_8_INVOCATIONS_PER_PIXEL"),
            14 => write!(f, "_16_INVOCATIONS_PER_PIXEL"),
            15 => write!(f, "NO_INVOCATIONS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFragmentShadingRateTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct FragmentShadingRateTypeNV(i32);

impl FragmentShadingRateTypeNV {
    pub const FRAGMENT_SIZE: Self = Self(0);
    pub const ENUMS: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for FragmentShadingRateTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FRAGMENT_SIZE"),
            1 => write!(f, "ENUMS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFrontFace.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct FrontFace(i32);

impl FrontFace {
    pub const COUNTER_CLOCKWISE: Self = Self(0);
    pub const CLOCKWISE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for FrontFace {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COUNTER_CLOCKWISE"),
            1 => write!(f, "CLOCKWISE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFullScreenExclusiveEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct FullScreenExclusiveEXT(i32);

impl FullScreenExclusiveEXT {
    pub const DEFAULT: Self = Self(0);
    pub const ALLOWED: Self = Self(1);
    pub const DISALLOWED: Self = Self(2);
    pub const APPLICATION_CONTROLLED: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for FullScreenExclusiveEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DEFAULT"),
            1 => write!(f, "ALLOWED"),
            2 => write!(f, "DISALLOWED"),
            3 => write!(f, "APPLICATION_CONTROLLED"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryTypeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct GeometryTypeKHR(i32);

impl GeometryTypeKHR {
    pub const TRIANGLES: Self = Self(0);
    pub const AABBS: Self = Self(1);
    pub const INSTANCES: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for GeometryTypeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "TRIANGLES"),
            1 => write!(f, "AABBS"),
            2 => write!(f, "INSTANCES"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageLayout.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ImageLayout(i32);

impl ImageLayout {
    pub const UNDEFINED: Self = Self(0);
    pub const GENERAL: Self = Self(1);
    pub const COLOR_ATTACHMENT_OPTIMAL: Self = Self(2);
    pub const DEPTH_STENCIL_ATTACHMENT_OPTIMAL: Self = Self(3);
    pub const DEPTH_STENCIL_READ_ONLY_OPTIMAL: Self = Self(4);
    pub const SHADER_READ_ONLY_OPTIMAL: Self = Self(5);
    pub const TRANSFER_SRC_OPTIMAL: Self = Self(6);
    pub const TRANSFER_DST_OPTIMAL: Self = Self(7);
    pub const PREINITIALIZED: Self = Self(8);
    pub const DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL: Self = Self(1000117000);
    pub const DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL: Self = Self(1000117001);
    pub const DEPTH_ATTACHMENT_OPTIMAL: Self = Self(1000241000);
    pub const DEPTH_READ_ONLY_OPTIMAL: Self = Self(1000241001);
    pub const STENCIL_ATTACHMENT_OPTIMAL: Self = Self(1000241002);
    pub const STENCIL_READ_ONLY_OPTIMAL: Self = Self(1000241003);
    pub const PRESENT_SRC_KHR: Self = Self(1000001002);
    pub const SHARED_PRESENT_KHR: Self = Self(1000111000);
    pub const FRAGMENT_DENSITY_MAP_OPTIMAL_EXT: Self = Self(1000218000);
    pub const FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR: Self = Self(1000164003);
    pub const READ_ONLY_OPTIMAL_KHR: Self = Self(1000314000);
    pub const ATTACHMENT_OPTIMAL_KHR: Self = Self(1000314001);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ImageLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UNDEFINED"),
            1 => write!(f, "GENERAL"),
            2 => write!(f, "COLOR_ATTACHMENT_OPTIMAL"),
            3 => write!(f, "DEPTH_STENCIL_ATTACHMENT_OPTIMAL"),
            4 => write!(f, "DEPTH_STENCIL_READ_ONLY_OPTIMAL"),
            5 => write!(f, "SHADER_READ_ONLY_OPTIMAL"),
            6 => write!(f, "TRANSFER_SRC_OPTIMAL"),
            7 => write!(f, "TRANSFER_DST_OPTIMAL"),
            8 => write!(f, "PREINITIALIZED"),
            1000117000 => write!(f, "DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL"),
            1000117001 => write!(f, "DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL"),
            1000241000 => write!(f, "DEPTH_ATTACHMENT_OPTIMAL"),
            1000241001 => write!(f, "DEPTH_READ_ONLY_OPTIMAL"),
            1000241002 => write!(f, "STENCIL_ATTACHMENT_OPTIMAL"),
            1000241003 => write!(f, "STENCIL_READ_ONLY_OPTIMAL"),
            1000001002 => write!(f, "PRESENT_SRC_KHR"),
            1000111000 => write!(f, "SHARED_PRESENT_KHR"),
            1000218000 => write!(f, "FRAGMENT_DENSITY_MAP_OPTIMAL_EXT"),
            1000164003 => write!(f, "FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR"),
            1000314000 => write!(f, "READ_ONLY_OPTIMAL_KHR"),
            1000314001 => write!(f, "ATTACHMENT_OPTIMAL_KHR"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageTiling.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ImageTiling(i32);

impl ImageTiling {
    pub const OPTIMAL: Self = Self(0);
    pub const LINEAR: Self = Self(1);
    pub const DRM_FORMAT_MODIFIER_EXT: Self = Self(1000158000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ImageTiling {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "OPTIMAL"),
            1 => write!(f, "LINEAR"),
            1000158000 => write!(f, "DRM_FORMAT_MODIFIER_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ImageType(i32);

impl ImageType {
    pub const _1D: Self = Self(0);
    pub const _2D: Self = Self(1);
    pub const _3D: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ImageType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "_1D"),
            1 => write!(f, "_2D"),
            2 => write!(f, "_3D"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ImageViewType(i32);

impl ImageViewType {
    pub const _1D: Self = Self(0);
    pub const _2D: Self = Self(1);
    pub const _3D: Self = Self(2);
    pub const CUBE: Self = Self(3);
    pub const _1D_ARRAY: Self = Self(4);
    pub const _2D_ARRAY: Self = Self(5);
    pub const CUBE_ARRAY: Self = Self(6);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ImageViewType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "_1D"),
            1 => write!(f, "_2D"),
            2 => write!(f, "_3D"),
            3 => write!(f, "CUBE"),
            4 => write!(f, "_1D_ARRAY"),
            5 => write!(f, "_2D_ARRAY"),
            6 => write!(f, "CUBE_ARRAY"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndexType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct IndexType(i32);

impl IndexType {
    pub const UINT16: Self = Self(0);
    pub const UINT32: Self = Self(1);
    pub const NONE_KHR: Self = Self(1000165000);
    pub const UINT8_EXT: Self = Self(1000265000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for IndexType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UINT16"),
            1 => write!(f, "UINT32"),
            1000165000 => write!(f, "NONE_KHR"),
            1000265000 => write!(f, "UINT8_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsTokenTypeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct IndirectCommandsTokenTypeNV(i32);

impl IndirectCommandsTokenTypeNV {
    pub const SHADER_GROUP: Self = Self(0);
    pub const STATE_FLAGS: Self = Self(1);
    pub const INDEX_BUFFER: Self = Self(2);
    pub const VERTEX_BUFFER: Self = Self(3);
    pub const PUSH_CONSTANT: Self = Self(4);
    pub const DRAW_INDEXED: Self = Self(5);
    pub const DRAW: Self = Self(6);
    pub const DRAW_TASKS: Self = Self(7);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for IndirectCommandsTokenTypeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "SHADER_GROUP"),
            1 => write!(f, "STATE_FLAGS"),
            2 => write!(f, "INDEX_BUFFER"),
            3 => write!(f, "VERTEX_BUFFER"),
            4 => write!(f, "PUSH_CONSTANT"),
            5 => write!(f, "DRAW_INDEXED"),
            6 => write!(f, "DRAW"),
            7 => write!(f, "DRAW_TASKS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInternalAllocationType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct InternalAllocationType(i32);

impl InternalAllocationType {
    pub const EXECUTABLE: Self = Self(0);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for InternalAllocationType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "EXECUTABLE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkLineRasterizationModeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct LineRasterizationModeEXT(i32);

impl LineRasterizationModeEXT {
    pub const DEFAULT: Self = Self(0);
    pub const RECTANGULAR: Self = Self(1);
    pub const BRESENHAM: Self = Self(2);
    pub const RECTANGULAR_SMOOTH: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for LineRasterizationModeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DEFAULT"),
            1 => write!(f, "RECTANGULAR"),
            2 => write!(f, "BRESENHAM"),
            3 => write!(f, "RECTANGULAR_SMOOTH"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkLogicOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct LogicOp(i32);

impl LogicOp {
    pub const CLEAR: Self = Self(0);
    pub const AND: Self = Self(1);
    pub const AND_REVERSE: Self = Self(2);
    pub const COPY: Self = Self(3);
    pub const AND_INVERTED: Self = Self(4);
    pub const NO_OP: Self = Self(5);
    pub const XOR: Self = Self(6);
    pub const OR: Self = Self(7);
    pub const NOR: Self = Self(8);
    pub const EQUIVALENT: Self = Self(9);
    pub const INVERT: Self = Self(10);
    pub const OR_REVERSE: Self = Self(11);
    pub const COPY_INVERTED: Self = Self(12);
    pub const OR_INVERTED: Self = Self(13);
    pub const NAND: Self = Self(14);
    pub const SET: Self = Self(15);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for LogicOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "CLEAR"),
            1 => write!(f, "AND"),
            2 => write!(f, "AND_REVERSE"),
            3 => write!(f, "COPY"),
            4 => write!(f, "AND_INVERTED"),
            5 => write!(f, "NO_OP"),
            6 => write!(f, "XOR"),
            7 => write!(f, "OR"),
            8 => write!(f, "NOR"),
            9 => write!(f, "EQUIVALENT"),
            10 => write!(f, "INVERT"),
            11 => write!(f, "OR_REVERSE"),
            12 => write!(f, "COPY_INVERTED"),
            13 => write!(f, "OR_INVERTED"),
            14 => write!(f, "NAND"),
            15 => write!(f, "SET"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryOverallocationBehaviorAMD.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct MemoryOverallocationBehaviorAMD(i32);

impl MemoryOverallocationBehaviorAMD {
    pub const DEFAULT: Self = Self(0);
    pub const ALLOWED: Self = Self(1);
    pub const DISALLOWED: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for MemoryOverallocationBehaviorAMD {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DEFAULT"),
            1 => write!(f, "ALLOWED"),
            2 => write!(f, "DISALLOWED"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkObjectType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ObjectType(i32);

impl ObjectType {
    pub const UNKNOWN: Self = Self(0);
    pub const INSTANCE: Self = Self(1);
    pub const PHYSICAL_DEVICE: Self = Self(2);
    pub const DEVICE: Self = Self(3);
    pub const QUEUE: Self = Self(4);
    pub const SEMAPHORE: Self = Self(5);
    pub const COMMAND_BUFFER: Self = Self(6);
    pub const FENCE: Self = Self(7);
    pub const DEVICE_MEMORY: Self = Self(8);
    pub const BUFFER: Self = Self(9);
    pub const IMAGE: Self = Self(10);
    pub const EVENT: Self = Self(11);
    pub const QUERY_POOL: Self = Self(12);
    pub const BUFFER_VIEW: Self = Self(13);
    pub const IMAGE_VIEW: Self = Self(14);
    pub const SHADER_MODULE: Self = Self(15);
    pub const PIPELINE_CACHE: Self = Self(16);
    pub const PIPELINE_LAYOUT: Self = Self(17);
    pub const RENDER_PASS: Self = Self(18);
    pub const PIPELINE: Self = Self(19);
    pub const DESCRIPTOR_SET_LAYOUT: Self = Self(20);
    pub const SAMPLER: Self = Self(21);
    pub const DESCRIPTOR_POOL: Self = Self(22);
    pub const DESCRIPTOR_SET: Self = Self(23);
    pub const FRAMEBUFFER: Self = Self(24);
    pub const COMMAND_POOL: Self = Self(25);
    pub const SAMPLER_YCBCR_CONVERSION: Self = Self(1000156000);
    pub const DESCRIPTOR_UPDATE_TEMPLATE: Self = Self(1000085000);
    pub const SURFACE_KHR: Self = Self(1000000000);
    pub const SWAPCHAIN_KHR: Self = Self(1000001000);
    pub const DISPLAY_KHR: Self = Self(1000002000);
    pub const DISPLAY_MODE_KHR: Self = Self(1000002001);
    pub const DEBUG_REPORT_CALLBACK_EXT: Self = Self(1000011000);
    pub const CU_MODULE_NVX: Self = Self(1000029000);
    pub const CU_FUNCTION_NVX: Self = Self(1000029001);
    pub const DEBUG_UTILS_MESSENGER_EXT: Self = Self(1000128000);
    pub const ACCELERATION_STRUCTURE_KHR: Self = Self(1000150000);
    pub const VALIDATION_CACHE_EXT: Self = Self(1000160000);
    pub const ACCELERATION_STRUCTURE_NV: Self = Self(1000165000);
    pub const PERFORMANCE_CONFIGURATION_INTEL: Self = Self(1000210000);
    pub const DEFERRED_OPERATION_KHR: Self = Self(1000268000);
    pub const INDIRECT_COMMANDS_LAYOUT_NV: Self = Self(1000277000);
    pub const PRIVATE_DATA_SLOT_EXT: Self = Self(1000295000);
    pub const BUFFER_COLLECTION_FUCHSIA: Self = Self(1000366000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ObjectType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UNKNOWN"),
            1 => write!(f, "INSTANCE"),
            2 => write!(f, "PHYSICAL_DEVICE"),
            3 => write!(f, "DEVICE"),
            4 => write!(f, "QUEUE"),
            5 => write!(f, "SEMAPHORE"),
            6 => write!(f, "COMMAND_BUFFER"),
            7 => write!(f, "FENCE"),
            8 => write!(f, "DEVICE_MEMORY"),
            9 => write!(f, "BUFFER"),
            10 => write!(f, "IMAGE"),
            11 => write!(f, "EVENT"),
            12 => write!(f, "QUERY_POOL"),
            13 => write!(f, "BUFFER_VIEW"),
            14 => write!(f, "IMAGE_VIEW"),
            15 => write!(f, "SHADER_MODULE"),
            16 => write!(f, "PIPELINE_CACHE"),
            17 => write!(f, "PIPELINE_LAYOUT"),
            18 => write!(f, "RENDER_PASS"),
            19 => write!(f, "PIPELINE"),
            20 => write!(f, "DESCRIPTOR_SET_LAYOUT"),
            21 => write!(f, "SAMPLER"),
            22 => write!(f, "DESCRIPTOR_POOL"),
            23 => write!(f, "DESCRIPTOR_SET"),
            24 => write!(f, "FRAMEBUFFER"),
            25 => write!(f, "COMMAND_POOL"),
            1000156000 => write!(f, "SAMPLER_YCBCR_CONVERSION"),
            1000085000 => write!(f, "DESCRIPTOR_UPDATE_TEMPLATE"),
            1000000000 => write!(f, "SURFACE_KHR"),
            1000001000 => write!(f, "SWAPCHAIN_KHR"),
            1000002000 => write!(f, "DISPLAY_KHR"),
            1000002001 => write!(f, "DISPLAY_MODE_KHR"),
            1000011000 => write!(f, "DEBUG_REPORT_CALLBACK_EXT"),
            1000029000 => write!(f, "CU_MODULE_NVX"),
            1000029001 => write!(f, "CU_FUNCTION_NVX"),
            1000128000 => write!(f, "DEBUG_UTILS_MESSENGER_EXT"),
            1000150000 => write!(f, "ACCELERATION_STRUCTURE_KHR"),
            1000160000 => write!(f, "VALIDATION_CACHE_EXT"),
            1000165000 => write!(f, "ACCELERATION_STRUCTURE_NV"),
            1000210000 => write!(f, "PERFORMANCE_CONFIGURATION_INTEL"),
            1000268000 => write!(f, "DEFERRED_OPERATION_KHR"),
            1000277000 => write!(f, "INDIRECT_COMMANDS_LAYOUT_NV"),
            1000295000 => write!(f, "PRIVATE_DATA_SLOT_EXT"),
            1000366000 => write!(f, "BUFFER_COLLECTION_FUCHSIA"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceConfigurationTypeINTEL.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceConfigurationTypeINTEL(i32);

impl PerformanceConfigurationTypeINTEL {
    pub const COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED: Self = Self(0);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceConfigurationTypeINTEL {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterScopeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceCounterScopeKHR(i32);

impl PerformanceCounterScopeKHR {
    pub const COMMAND_BUFFER: Self = Self(0);
    pub const RENDER_PASS: Self = Self(1);
    pub const COMMAND: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceCounterScopeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COMMAND_BUFFER"),
            1 => write!(f, "RENDER_PASS"),
            2 => write!(f, "COMMAND"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterStorageKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceCounterStorageKHR(i32);

impl PerformanceCounterStorageKHR {
    pub const INT32: Self = Self(0);
    pub const INT64: Self = Self(1);
    pub const UINT32: Self = Self(2);
    pub const UINT64: Self = Self(3);
    pub const FLOAT32: Self = Self(4);
    pub const FLOAT64: Self = Self(5);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceCounterStorageKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "INT32"),
            1 => write!(f, "INT64"),
            2 => write!(f, "UINT32"),
            3 => write!(f, "UINT64"),
            4 => write!(f, "FLOAT32"),
            5 => write!(f, "FLOAT64"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterUnitKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceCounterUnitKHR(i32);

impl PerformanceCounterUnitKHR {
    pub const GENERIC: Self = Self(0);
    pub const PERCENTAGE: Self = Self(1);
    pub const NANOSECONDS: Self = Self(2);
    pub const BYTES: Self = Self(3);
    pub const BYTES_PER_SECOND: Self = Self(4);
    pub const KELVIN: Self = Self(5);
    pub const WATTS: Self = Self(6);
    pub const VOLTS: Self = Self(7);
    pub const AMPS: Self = Self(8);
    pub const HERTZ: Self = Self(9);
    pub const CYCLES: Self = Self(10);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceCounterUnitKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "GENERIC"),
            1 => write!(f, "PERCENTAGE"),
            2 => write!(f, "NANOSECONDS"),
            3 => write!(f, "BYTES"),
            4 => write!(f, "BYTES_PER_SECOND"),
            5 => write!(f, "KELVIN"),
            6 => write!(f, "WATTS"),
            7 => write!(f, "VOLTS"),
            8 => write!(f, "AMPS"),
            9 => write!(f, "HERTZ"),
            10 => write!(f, "CYCLES"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceOverrideTypeINTEL.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceOverrideTypeINTEL(i32);

impl PerformanceOverrideTypeINTEL {
    pub const NULL_HARDWARE: Self = Self(0);
    pub const FLUSH_GPU_CACHES: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceOverrideTypeINTEL {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NULL_HARDWARE"),
            1 => write!(f, "FLUSH_GPU_CACHES"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceParameterTypeINTEL.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceParameterTypeINTEL(i32);

impl PerformanceParameterTypeINTEL {
    pub const HW_COUNTERS_SUPPORTED: Self = Self(0);
    pub const STREAM_MARKER_VALID_BITS: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceParameterTypeINTEL {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "HW_COUNTERS_SUPPORTED"),
            1 => write!(f, "STREAM_MARKER_VALID_BITS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceValueTypeINTEL.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PerformanceValueTypeINTEL(i32);

impl PerformanceValueTypeINTEL {
    pub const UINT32: Self = Self(0);
    pub const UINT64: Self = Self(1);
    pub const FLOAT: Self = Self(2);
    pub const BOOL: Self = Self(3);
    pub const STRING: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PerformanceValueTypeINTEL {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UINT32"),
            1 => write!(f, "UINT64"),
            2 => write!(f, "FLOAT"),
            3 => write!(f, "BOOL"),
            4 => write!(f, "STRING"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PhysicalDeviceType(i32);

impl PhysicalDeviceType {
    pub const OTHER: Self = Self(0);
    pub const INTEGRATED_GPU: Self = Self(1);
    pub const DISCRETE_GPU: Self = Self(2);
    pub const VIRTUAL_GPU: Self = Self(3);
    pub const CPU: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PhysicalDeviceType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "OTHER"),
            1 => write!(f, "INTEGRATED_GPU"),
            2 => write!(f, "DISCRETE_GPU"),
            3 => write!(f, "VIRTUAL_GPU"),
            4 => write!(f, "CPU"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineBindPoint.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PipelineBindPoint(i32);

impl PipelineBindPoint {
    pub const GRAPHICS: Self = Self(0);
    pub const COMPUTE: Self = Self(1);
    pub const RAY_TRACING_KHR: Self = Self(1000165000);
    pub const SUBPASS_SHADING_HUAWEI: Self = Self(1000369003);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PipelineBindPoint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "GRAPHICS"),
            1 => write!(f, "COMPUTE"),
            1000165000 => write!(f, "RAY_TRACING_KHR"),
            1000369003 => write!(f, "SUBPASS_SHADING_HUAWEI"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCacheHeaderVersion.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PipelineCacheHeaderVersion(i32);

impl PipelineCacheHeaderVersion {
    pub const ONE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PipelineCacheHeaderVersion {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            1 => write!(f, "ONE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineExecutableStatisticFormatKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PipelineExecutableStatisticFormatKHR(i32);

impl PipelineExecutableStatisticFormatKHR {
    pub const BOOL32: Self = Self(0);
    pub const INT64: Self = Self(1);
    pub const UINT64: Self = Self(2);
    pub const FLOAT64: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PipelineExecutableStatisticFormatKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "BOOL32"),
            1 => write!(f, "INT64"),
            2 => write!(f, "UINT64"),
            3 => write!(f, "FLOAT64"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPointClippingBehavior.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PointClippingBehavior(i32);

impl PointClippingBehavior {
    pub const ALL_CLIP_PLANES: Self = Self(0);
    pub const USER_CLIP_PLANES_ONLY: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PointClippingBehavior {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ALL_CLIP_PLANES"),
            1 => write!(f, "USER_CLIP_PLANES_ONLY"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPolygonMode.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PolygonMode(i32);

impl PolygonMode {
    pub const FILL: Self = Self(0);
    pub const LINE: Self = Self(1);
    pub const POINT: Self = Self(2);
    pub const FILL_RECTANGLE_NV: Self = Self(1000153000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PolygonMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FILL"),
            1 => write!(f, "LINE"),
            2 => write!(f, "POINT"),
            1000153000 => write!(f, "FILL_RECTANGLE_NV"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentModeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PresentModeKHR(i32);

impl PresentModeKHR {
    pub const IMMEDIATE: Self = Self(0);
    pub const MAILBOX: Self = Self(1);
    pub const FIFO: Self = Self(2);
    pub const FIFO_RELAXED: Self = Self(3);
    pub const SHARED_DEMAND_REFRESH: Self = Self(1000111000);
    pub const SHARED_CONTINUOUS_REFRESH: Self = Self(1000111001);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PresentModeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "IMMEDIATE"),
            1 => write!(f, "MAILBOX"),
            2 => write!(f, "FIFO"),
            3 => write!(f, "FIFO_RELAXED"),
            1000111000 => write!(f, "SHARED_DEMAND_REFRESH"),
            1000111001 => write!(f, "SHARED_CONTINUOUS_REFRESH"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPrimitiveTopology.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct PrimitiveTopology(i32);

impl PrimitiveTopology {
    pub const POINT_LIST: Self = Self(0);
    pub const LINE_LIST: Self = Self(1);
    pub const LINE_STRIP: Self = Self(2);
    pub const TRIANGLE_LIST: Self = Self(3);
    pub const TRIANGLE_STRIP: Self = Self(4);
    pub const TRIANGLE_FAN: Self = Self(5);
    pub const LINE_LIST_WITH_ADJACENCY: Self = Self(6);
    pub const LINE_STRIP_WITH_ADJACENCY: Self = Self(7);
    pub const TRIANGLE_LIST_WITH_ADJACENCY: Self = Self(8);
    pub const TRIANGLE_STRIP_WITH_ADJACENCY: Self = Self(9);
    pub const PATCH_LIST: Self = Self(10);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for PrimitiveTopology {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "POINT_LIST"),
            1 => write!(f, "LINE_LIST"),
            2 => write!(f, "LINE_STRIP"),
            3 => write!(f, "TRIANGLE_LIST"),
            4 => write!(f, "TRIANGLE_STRIP"),
            5 => write!(f, "TRIANGLE_FAN"),
            6 => write!(f, "LINE_LIST_WITH_ADJACENCY"),
            7 => write!(f, "LINE_STRIP_WITH_ADJACENCY"),
            8 => write!(f, "TRIANGLE_LIST_WITH_ADJACENCY"),
            9 => write!(f, "TRIANGLE_STRIP_WITH_ADJACENCY"),
            10 => write!(f, "PATCH_LIST"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkProvokingVertexModeEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ProvokingVertexModeEXT(i32);

impl ProvokingVertexModeEXT {
    pub const FIRST_VERTEX: Self = Self(0);
    pub const LAST_VERTEX: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ProvokingVertexModeEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "FIRST_VERTEX"),
            1 => write!(f, "LAST_VERTEX"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolSamplingModeINTEL.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct QueryPoolSamplingModeINTEL(i32);

impl QueryPoolSamplingModeINTEL {
    pub const MANUAL: Self = Self(0);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for QueryPoolSamplingModeINTEL {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "MANUAL"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct QueryType(i32);

impl QueryType {
    pub const OCCLUSION: Self = Self(0);
    pub const PIPELINE_STATISTICS: Self = Self(1);
    pub const TIMESTAMP: Self = Self(2);
    pub const TRANSFORM_FEEDBACK_STREAM_EXT: Self = Self(1000028004);
    pub const PERFORMANCE_QUERY_KHR: Self = Self(1000116000);
    pub const ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR: Self = Self(1000150000);
    pub const ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR: Self = Self(1000150001);
    pub const ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV: Self = Self(1000165000);
    pub const PERFORMANCE_QUERY_INTEL: Self = Self(1000210000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for QueryType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "OCCLUSION"),
            1 => write!(f, "PIPELINE_STATISTICS"),
            2 => write!(f, "TIMESTAMP"),
            1000028004 => write!(f, "TRANSFORM_FEEDBACK_STREAM_EXT"),
            1000116000 => write!(f, "PERFORMANCE_QUERY_KHR"),
            1000150000 => write!(f, "ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR"),
            1000150001 => write!(f, "ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR"),
            1000165000 => write!(f, "ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV"),
            1000210000 => write!(f, "PERFORMANCE_QUERY_INTEL"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueGlobalPriorityEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct QueueGlobalPriorityEXT(i32);

impl QueueGlobalPriorityEXT {
    pub const LOW: Self = Self(128);
    pub const MEDIUM: Self = Self(256);
    pub const HIGH: Self = Self(512);
    pub const REALTIME: Self = Self(1024);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for QueueGlobalPriorityEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            128 => write!(f, "LOW"),
            256 => write!(f, "MEDIUM"),
            512 => write!(f, "HIGH"),
            1024 => write!(f, "REALTIME"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRasterizationOrderAMD.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct RasterizationOrderAMD(i32);

impl RasterizationOrderAMD {
    pub const STRICT: Self = Self(0);
    pub const RELAXED: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for RasterizationOrderAMD {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "STRICT"),
            1 => write!(f, "RELAXED"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingShaderGroupTypeKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct RayTracingShaderGroupTypeKHR(i32);

impl RayTracingShaderGroupTypeKHR {
    pub const GENERAL: Self = Self(0);
    pub const TRIANGLES_HIT_GROUP: Self = Self(1);
    pub const PROCEDURAL_HIT_GROUP: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for RayTracingShaderGroupTypeKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "GENERAL"),
            1 => write!(f, "TRIANGLES_HIT_GROUP"),
            2 => write!(f, "PROCEDURAL_HIT_GROUP"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkResult.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct Result(i32);

impl Result {
    pub const SUCCESS: Self = Self(0);
    pub const NOT_READY: Self = Self(1);
    pub const TIMEOUT: Self = Self(2);
    pub const EVENT_SET: Self = Self(3);
    pub const EVENT_RESET: Self = Self(4);
    pub const INCOMPLETE: Self = Self(5);
    pub const ERROR_OUT_OF_HOST_MEMORY: Self = Self(-1);
    pub const ERROR_OUT_OF_DEVICE_MEMORY: Self = Self(-2);
    pub const ERROR_INITIALIZATION_FAILED: Self = Self(-3);
    pub const ERROR_DEVICE_LOST: Self = Self(-4);
    pub const ERROR_MEMORY_MAP_FAILED: Self = Self(-5);
    pub const ERROR_LAYER_NOT_PRESENT: Self = Self(-6);
    pub const ERROR_EXTENSION_NOT_PRESENT: Self = Self(-7);
    pub const ERROR_FEATURE_NOT_PRESENT: Self = Self(-8);
    pub const ERROR_INCOMPATIBLE_DRIVER: Self = Self(-9);
    pub const ERROR_TOO_MANY_OBJECTS: Self = Self(-10);
    pub const ERROR_FORMAT_NOT_SUPPORTED: Self = Self(-11);
    pub const ERROR_FRAGMENTED_POOL: Self = Self(-12);
    pub const ERROR_UNKNOWN: Self = Self(-13);
    pub const ERROR_OUT_OF_POOL_MEMORY: Self = Self(-1000069000);
    pub const ERROR_INVALID_EXTERNAL_HANDLE: Self = Self(-1000072003);
    pub const ERROR_FRAGMENTATION: Self = Self(-1000161000);
    pub const ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: Self = Self(-1000257000);
    pub const ERROR_SURFACE_LOST_KHR: Self = Self(-1000000000);
    pub const ERROR_NATIVE_WINDOW_IN_USE_KHR: Self = Self(-1000000001);
    pub const SUBOPTIMAL_KHR: Self = Self(1000001003);
    pub const ERROR_OUT_OF_DATE_KHR: Self = Self(-1000001004);
    pub const ERROR_INCOMPATIBLE_DISPLAY_KHR: Self = Self(-1000003001);
    pub const ERROR_VALIDATION_FAILED_EXT: Self = Self(-1000011001);
    pub const ERROR_INVALID_SHADER_NV: Self = Self(-1000012000);
    pub const ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: Self = Self(-1000158000);
    pub const ERROR_NOT_PERMITTED_EXT: Self = Self(-1000174001);
    pub const ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT: Self = Self(-1000255000);
    pub const THREAD_IDLE_KHR: Self = Self(1000268000);
    pub const THREAD_DONE_KHR: Self = Self(1000268001);
    pub const OPERATION_DEFERRED_KHR: Self = Self(1000268002);
    pub const OPERATION_NOT_DEFERRED_KHR: Self = Self(1000268003);
    pub const PIPELINE_COMPILE_REQUIRED_EXT: Self = Self(1000297000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for Result {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "SUCCESS"),
            1 => write!(f, "NOT_READY"),
            2 => write!(f, "TIMEOUT"),
            3 => write!(f, "EVENT_SET"),
            4 => write!(f, "EVENT_RESET"),
            5 => write!(f, "INCOMPLETE"),
            -1 => write!(f, "ERROR_OUT_OF_HOST_MEMORY"),
            -2 => write!(f, "ERROR_OUT_OF_DEVICE_MEMORY"),
            -3 => write!(f, "ERROR_INITIALIZATION_FAILED"),
            -4 => write!(f, "ERROR_DEVICE_LOST"),
            -5 => write!(f, "ERROR_MEMORY_MAP_FAILED"),
            -6 => write!(f, "ERROR_LAYER_NOT_PRESENT"),
            -7 => write!(f, "ERROR_EXTENSION_NOT_PRESENT"),
            -8 => write!(f, "ERROR_FEATURE_NOT_PRESENT"),
            -9 => write!(f, "ERROR_INCOMPATIBLE_DRIVER"),
            -10 => write!(f, "ERROR_TOO_MANY_OBJECTS"),
            -11 => write!(f, "ERROR_FORMAT_NOT_SUPPORTED"),
            -12 => write!(f, "ERROR_FRAGMENTED_POOL"),
            -13 => write!(f, "ERROR_UNKNOWN"),
            -1000069000 => write!(f, "ERROR_OUT_OF_POOL_MEMORY"),
            -1000072003 => write!(f, "ERROR_INVALID_EXTERNAL_HANDLE"),
            -1000161000 => write!(f, "ERROR_FRAGMENTATION"),
            -1000257000 => write!(f, "ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS"),
            -1000000000 => write!(f, "ERROR_SURFACE_LOST_KHR"),
            -1000000001 => write!(f, "ERROR_NATIVE_WINDOW_IN_USE_KHR"),
            1000001003 => write!(f, "SUBOPTIMAL_KHR"),
            -1000001004 => write!(f, "ERROR_OUT_OF_DATE_KHR"),
            -1000003001 => write!(f, "ERROR_INCOMPATIBLE_DISPLAY_KHR"),
            -1000011001 => write!(f, "ERROR_VALIDATION_FAILED_EXT"),
            -1000012000 => write!(f, "ERROR_INVALID_SHADER_NV"),
            -1000158000 => write!(f, "ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT"),
            -1000174001 => write!(f, "ERROR_NOT_PERMITTED_EXT"),
            -1000255000 => write!(f, "ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT"),
            1000268000 => write!(f, "THREAD_IDLE_KHR"),
            1000268001 => write!(f, "THREAD_DONE_KHR"),
            1000268002 => write!(f, "OPERATION_DEFERRED_KHR"),
            1000268003 => write!(f, "OPERATION_NOT_DEFERRED_KHR"),
            1000297000 => write!(f, "PIPELINE_COMPILE_REQUIRED_EXT"),
            _ => self.0.fmt(f),
        }
    }
}

impl fmt::Display for Result {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "Command successfully completed."),
            1 => write!(f, "A fence or query has not yet completed."),
            2 => write!(f, "A wait operation has not completed in the specified time."),
            3 => write!(f, "An event is signaled."),
            4 => write!(f, "An event is unsignaled."),
            5 => write!(f, "A return array was too small for the result."),
            -1 => write!(f, "A host memory allocation has failed."),
            -2 => write!(f, "A device memory allocation has failed."),
            -3 => write!(f, "Initialization of an object could not be completed for implementation-specific reasons."),
            -4 => write!(f, "The logical or physical device has been lost. See Lost Device."),
            -5 => write!(f, "Mapping of a memory object has failed."),
            -6 => write!(f, "A requested layer is not present or could not be loaded."),
            -7 => write!(f, "A requested extension is not supported."),
            -8 => write!(f, "A requested feature is not supported."),
            -9 => write!(f, "The requested version of Vulkan is not supported by the driver or is otherwise incompatible for implementation-specific reasons."),
            -10 => write!(f, "Too many objects of the type have already been created."),
            -11 => write!(f, "A requested format is not supported on this device."),
            -12 => write!(f, "A pool allocation has failed due to fragmentation of the pool's memory. This must only be returned if no attempt to allocate host or device memory was made to accommodate the new allocation. This should be returned in preference to VK_ERROR_OUT_OF_POOL_MEMORY, but only if the implementation is certain that the pool allocation failure was due to fragmentation."),
            -13 => write!(f, "An unknown error has occurred; either the application has provided invalid input, or an implementation failure has occurred."),
            -1000069000 => write!(f, "A pool memory allocation has failed. This must only be returned if no attempt to allocate host or device memory was made to accommodate the new allocation. If the failure was definitely due to fragmentation of the pool, VK_ERROR_FRAGMENTED_POOL should be returned instead."),
            -1000072003 => write!(f, "An external handle is not a valid handle of the specified type."),
            -1000161000 => write!(f, "A descriptor pool creation has failed due to fragmentation."),
            -1000257000 => write!(f, "A buffer creation or memory allocation failed because the requested address is not available. A shader group handle assignment failed because the requested shader group handle information is no longer valid."),
            -1000000000 => write!(f, "A surface is no longer available."),
            -1000000001 => write!(f, "The requested window is already in use by Vulkan or another API in a manner which prevents it from being used again."),
            1000001003 => write!(f, "A swapchain no longer matches the surface properties exactly, but can still be used to present to the surface successfully."),
            -1000001004 => write!(f, "A surface has changed in such a way that it is no longer compatible with the swapchain, and further presentation requests using the swapchain will fail. Applications must query the new surface properties and recreate their swapchain if they wish to continue presenting to the surface."),
            -1000003001 => write!(f, "The display used by a swapchain does not use the same presentable image layout, or is incompatible in a way that prevents sharing an image."),
            -1000011001 => write!(f, "ERROR_VALIDATION_FAILED_EXT"),
            -1000012000 => write!(f, "One or more shaders failed to compile or link. More details are reported back to the application via VK_EXT_debug_report if enabled."),
            -1000158000 => write!(f, "ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT"),
            -1000174001 => write!(f, "ERROR_NOT_PERMITTED_EXT"),
            -1000255000 => write!(f, "An operation on a swapchain created with VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT failed as it did not have exclusive full-screen access. This may occur due to implementation-dependent reasons, outside of the application's control."),
            1000268000 => write!(f, "A deferred operation is not complete but there is currently no work for this thread to do at the time of this call."),
            1000268001 => write!(f, "A deferred operation is not complete but there is no work remaining to assign to additional threads."),
            1000268002 => write!(f, "A deferred operation was requested and at least some of the work was deferred."),
            1000268003 => write!(f, "A deferred operation was requested and no operations were deferred."),
            1000297000 => write!(f, "A requested pipeline creation would have required compilation, but the application requested compilation to not be performed."),
            _ => write!(f, "unknown Vulkan result (code = {})", self.0),
        }
    }
}

impl error::Error for Result {}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerAddressMode.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SamplerAddressMode(i32);

impl SamplerAddressMode {
    pub const REPEAT: Self = Self(0);
    pub const MIRRORED_REPEAT: Self = Self(1);
    pub const CLAMP_TO_EDGE: Self = Self(2);
    pub const CLAMP_TO_BORDER: Self = Self(3);
    pub const MIRROR_CLAMP_TO_EDGE: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SamplerAddressMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "REPEAT"),
            1 => write!(f, "MIRRORED_REPEAT"),
            2 => write!(f, "CLAMP_TO_EDGE"),
            3 => write!(f, "CLAMP_TO_BORDER"),
            4 => write!(f, "MIRROR_CLAMP_TO_EDGE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerMipmapMode.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SamplerMipmapMode(i32);

impl SamplerMipmapMode {
    pub const NEAREST: Self = Self(0);
    pub const LINEAR: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SamplerMipmapMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NEAREST"),
            1 => write!(f, "LINEAR"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerReductionMode.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SamplerReductionMode(i32);

impl SamplerReductionMode {
    pub const WEIGHTED_AVERAGE: Self = Self(0);
    pub const MIN: Self = Self(1);
    pub const MAX: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SamplerReductionMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "WEIGHTED_AVERAGE"),
            1 => write!(f, "MIN"),
            2 => write!(f, "MAX"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrModelConversion.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SamplerYcbcrModelConversion(i32);

impl SamplerYcbcrModelConversion {
    pub const RGB_IDENTITY: Self = Self(0);
    pub const YCBCR_IDENTITY: Self = Self(1);
    pub const YCBCR_709: Self = Self(2);
    pub const YCBCR_601: Self = Self(3);
    pub const YCBCR_2020: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SamplerYcbcrModelConversion {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "RGB_IDENTITY"),
            1 => write!(f, "YCBCR_IDENTITY"),
            2 => write!(f, "YCBCR_709"),
            3 => write!(f, "YCBCR_601"),
            4 => write!(f, "YCBCR_2020"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrRange.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SamplerYcbcrRange(i32);

impl SamplerYcbcrRange {
    pub const ITU_FULL: Self = Self(0);
    pub const ITU_NARROW: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SamplerYcbcrRange {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ITU_FULL"),
            1 => write!(f, "ITU_NARROW"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkScopeNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ScopeNV(i32);

impl ScopeNV {
    pub const DEVICE: Self = Self(1);
    pub const WORKGROUP: Self = Self(2);
    pub const SUBGROUP: Self = Self(3);
    pub const QUEUE_FAMILY: Self = Self(5);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ScopeNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            1 => write!(f, "DEVICE"),
            2 => write!(f, "WORKGROUP"),
            3 => write!(f, "SUBGROUP"),
            5 => write!(f, "QUEUE_FAMILY"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SemaphoreType(i32);

impl SemaphoreType {
    pub const BINARY: Self = Self(0);
    pub const TIMELINE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SemaphoreType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "BINARY"),
            1 => write!(f, "TIMELINE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderFloatControlsIndependence.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ShaderFloatControlsIndependence(i32);

impl ShaderFloatControlsIndependence {
    pub const _32_BIT_ONLY: Self = Self(0);
    pub const ALL: Self = Self(1);
    pub const NONE: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ShaderFloatControlsIndependence {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "_32_BIT_ONLY"),
            1 => write!(f, "ALL"),
            2 => write!(f, "NONE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderGroupShaderKHR.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ShaderGroupShaderKHR(i32);

impl ShaderGroupShaderKHR {
    pub const GENERAL: Self = Self(0);
    pub const CLOSEST_HIT: Self = Self(1);
    pub const ANY_HIT: Self = Self(2);
    pub const INTERSECTION: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ShaderGroupShaderKHR {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "GENERAL"),
            1 => write!(f, "CLOSEST_HIT"),
            2 => write!(f, "ANY_HIT"),
            3 => write!(f, "INTERSECTION"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderInfoTypeAMD.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ShaderInfoTypeAMD(i32);

impl ShaderInfoTypeAMD {
    pub const STATISTICS: Self = Self(0);
    pub const BINARY: Self = Self(1);
    pub const DISASSEMBLY: Self = Self(2);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ShaderInfoTypeAMD {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "STATISTICS"),
            1 => write!(f, "BINARY"),
            2 => write!(f, "DISASSEMBLY"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShadingRatePaletteEntryNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ShadingRatePaletteEntryNV(i32);

impl ShadingRatePaletteEntryNV {
    pub const NO_INVOCATIONS: Self = Self(0);
    pub const _16_INVOCATIONS_PER_PIXEL: Self = Self(1);
    pub const _8_INVOCATIONS_PER_PIXEL: Self = Self(2);
    pub const _4_INVOCATIONS_PER_PIXEL: Self = Self(3);
    pub const _2_INVOCATIONS_PER_PIXEL: Self = Self(4);
    pub const _1_INVOCATION_PER_PIXEL: Self = Self(5);
    pub const _1_INVOCATION_PER_2X1_PIXELS: Self = Self(6);
    pub const _1_INVOCATION_PER_1X2_PIXELS: Self = Self(7);
    pub const _1_INVOCATION_PER_2X2_PIXELS: Self = Self(8);
    pub const _1_INVOCATION_PER_4X2_PIXELS: Self = Self(9);
    pub const _1_INVOCATION_PER_2X4_PIXELS: Self = Self(10);
    pub const _1_INVOCATION_PER_4X4_PIXELS: Self = Self(11);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ShadingRatePaletteEntryNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "NO_INVOCATIONS"),
            1 => write!(f, "_16_INVOCATIONS_PER_PIXEL"),
            2 => write!(f, "_8_INVOCATIONS_PER_PIXEL"),
            3 => write!(f, "_4_INVOCATIONS_PER_PIXEL"),
            4 => write!(f, "_2_INVOCATIONS_PER_PIXEL"),
            5 => write!(f, "_1_INVOCATION_PER_PIXEL"),
            6 => write!(f, "_1_INVOCATION_PER_2X1_PIXELS"),
            7 => write!(f, "_1_INVOCATION_PER_1X2_PIXELS"),
            8 => write!(f, "_1_INVOCATION_PER_2X2_PIXELS"),
            9 => write!(f, "_1_INVOCATION_PER_4X2_PIXELS"),
            10 => write!(f, "_1_INVOCATION_PER_2X4_PIXELS"),
            11 => write!(f, "_1_INVOCATION_PER_4X4_PIXELS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSharingMode.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SharingMode(i32);

impl SharingMode {
    pub const EXCLUSIVE: Self = Self(0);
    pub const CONCURRENT: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SharingMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "EXCLUSIVE"),
            1 => write!(f, "CONCURRENT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStencilOp.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct StencilOp(i32);

impl StencilOp {
    pub const KEEP: Self = Self(0);
    pub const ZERO: Self = Self(1);
    pub const REPLACE: Self = Self(2);
    pub const INCREMENT_AND_CLAMP: Self = Self(3);
    pub const DECREMENT_AND_CLAMP: Self = Self(4);
    pub const INVERT: Self = Self(5);
    pub const INCREMENT_AND_WRAP: Self = Self(6);
    pub const DECREMENT_AND_WRAP: Self = Self(7);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for StencilOp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "KEEP"),
            1 => write!(f, "ZERO"),
            2 => write!(f, "REPLACE"),
            3 => write!(f, "INCREMENT_AND_CLAMP"),
            4 => write!(f, "DECREMENT_AND_CLAMP"),
            5 => write!(f, "INVERT"),
            6 => write!(f, "INCREMENT_AND_WRAP"),
            7 => write!(f, "DECREMENT_AND_WRAP"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStructureType.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct StructureType(i32);

impl StructureType {
    pub const APPLICATION_INFO: Self = Self(0);
    pub const INSTANCE_CREATE_INFO: Self = Self(1);
    pub const DEVICE_QUEUE_CREATE_INFO: Self = Self(2);
    pub const DEVICE_CREATE_INFO: Self = Self(3);
    pub const SUBMIT_INFO: Self = Self(4);
    pub const MEMORY_ALLOCATE_INFO: Self = Self(5);
    pub const MAPPED_MEMORY_RANGE: Self = Self(6);
    pub const BIND_SPARSE_INFO: Self = Self(7);
    pub const FENCE_CREATE_INFO: Self = Self(8);
    pub const SEMAPHORE_CREATE_INFO: Self = Self(9);
    pub const EVENT_CREATE_INFO: Self = Self(10);
    pub const QUERY_POOL_CREATE_INFO: Self = Self(11);
    pub const BUFFER_CREATE_INFO: Self = Self(12);
    pub const BUFFER_VIEW_CREATE_INFO: Self = Self(13);
    pub const IMAGE_CREATE_INFO: Self = Self(14);
    pub const IMAGE_VIEW_CREATE_INFO: Self = Self(15);
    pub const SHADER_MODULE_CREATE_INFO: Self = Self(16);
    pub const PIPELINE_CACHE_CREATE_INFO: Self = Self(17);
    pub const PIPELINE_SHADER_STAGE_CREATE_INFO: Self = Self(18);
    pub const PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO: Self = Self(19);
    pub const PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO: Self = Self(20);
    pub const PIPELINE_TESSELLATION_STATE_CREATE_INFO: Self = Self(21);
    pub const PIPELINE_VIEWPORT_STATE_CREATE_INFO: Self = Self(22);
    pub const PIPELINE_RASTERIZATION_STATE_CREATE_INFO: Self = Self(23);
    pub const PIPELINE_MULTISAMPLE_STATE_CREATE_INFO: Self = Self(24);
    pub const PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO: Self = Self(25);
    pub const PIPELINE_COLOR_BLEND_STATE_CREATE_INFO: Self = Self(26);
    pub const PIPELINE_DYNAMIC_STATE_CREATE_INFO: Self = Self(27);
    pub const GRAPHICS_PIPELINE_CREATE_INFO: Self = Self(28);
    pub const COMPUTE_PIPELINE_CREATE_INFO: Self = Self(29);
    pub const PIPELINE_LAYOUT_CREATE_INFO: Self = Self(30);
    pub const SAMPLER_CREATE_INFO: Self = Self(31);
    pub const DESCRIPTOR_SET_LAYOUT_CREATE_INFO: Self = Self(32);
    pub const DESCRIPTOR_POOL_CREATE_INFO: Self = Self(33);
    pub const DESCRIPTOR_SET_ALLOCATE_INFO: Self = Self(34);
    pub const WRITE_DESCRIPTOR_SET: Self = Self(35);
    pub const COPY_DESCRIPTOR_SET: Self = Self(36);
    pub const FRAMEBUFFER_CREATE_INFO: Self = Self(37);
    pub const RENDER_PASS_CREATE_INFO: Self = Self(38);
    pub const COMMAND_POOL_CREATE_INFO: Self = Self(39);
    pub const COMMAND_BUFFER_ALLOCATE_INFO: Self = Self(40);
    pub const COMMAND_BUFFER_INHERITANCE_INFO: Self = Self(41);
    pub const COMMAND_BUFFER_BEGIN_INFO: Self = Self(42);
    pub const RENDER_PASS_BEGIN_INFO: Self = Self(43);
    pub const BUFFER_MEMORY_BARRIER: Self = Self(44);
    pub const IMAGE_MEMORY_BARRIER: Self = Self(45);
    pub const MEMORY_BARRIER: Self = Self(46);
    pub const LOADER_INSTANCE_CREATE_INFO: Self = Self(47);
    pub const LOADER_DEVICE_CREATE_INFO: Self = Self(48);
    pub const PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: Self = Self(1000094000);
    pub const BIND_BUFFER_MEMORY_INFO: Self = Self(1000157000);
    pub const BIND_IMAGE_MEMORY_INFO: Self = Self(1000157001);
    pub const PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: Self = Self(1000083000);
    pub const MEMORY_DEDICATED_REQUIREMENTS: Self = Self(1000127000);
    pub const MEMORY_DEDICATED_ALLOCATE_INFO: Self = Self(1000127001);
    pub const MEMORY_ALLOCATE_FLAGS_INFO: Self = Self(1000060000);
    pub const DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: Self = Self(1000060003);
    pub const DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: Self = Self(1000060004);
    pub const DEVICE_GROUP_SUBMIT_INFO: Self = Self(1000060005);
    pub const DEVICE_GROUP_BIND_SPARSE_INFO: Self = Self(1000060006);
    pub const BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: Self = Self(1000060013);
    pub const BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: Self = Self(1000060014);
    pub const PHYSICAL_DEVICE_GROUP_PROPERTIES: Self = Self(1000070000);
    pub const DEVICE_GROUP_DEVICE_CREATE_INFO: Self = Self(1000070001);
    pub const BUFFER_MEMORY_REQUIREMENTS_INFO_2: Self = Self(1000146000);
    pub const IMAGE_MEMORY_REQUIREMENTS_INFO_2: Self = Self(1000146001);
    pub const IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2: Self = Self(1000146002);
    pub const MEMORY_REQUIREMENTS_2: Self = Self(1000146003);
    pub const SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: Self = Self(1000146004);
    pub const PHYSICAL_DEVICE_FEATURES_2: Self = Self(1000059000);
    pub const PHYSICAL_DEVICE_PROPERTIES_2: Self = Self(1000059001);
    pub const FORMAT_PROPERTIES_2: Self = Self(1000059002);
    pub const IMAGE_FORMAT_PROPERTIES_2: Self = Self(1000059003);
    pub const PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: Self = Self(1000059004);
    pub const QUEUE_FAMILY_PROPERTIES_2: Self = Self(1000059005);
    pub const PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: Self = Self(1000059006);
    pub const SPARSE_IMAGE_FORMAT_PROPERTIES_2: Self = Self(1000059007);
    pub const PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2: Self = Self(1000059008);
    pub const PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: Self = Self(1000117000);
    pub const RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: Self = Self(1000117001);
    pub const IMAGE_VIEW_USAGE_CREATE_INFO: Self = Self(1000117002);
    pub const PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: Self = Self(1000117003);
    pub const RENDER_PASS_MULTIVIEW_CREATE_INFO: Self = Self(1000053000);
    pub const PHYSICAL_DEVICE_MULTIVIEW_FEATURES: Self = Self(1000053001);
    pub const PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: Self = Self(1000053002);
    pub const PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: Self = Self(1000120000);
    pub const PROTECTED_SUBMIT_INFO: Self = Self(1000145000);
    pub const PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: Self = Self(1000145001);
    pub const PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: Self = Self(1000145002);
    pub const DEVICE_QUEUE_INFO_2: Self = Self(1000145003);
    pub const SAMPLER_YCBCR_CONVERSION_CREATE_INFO: Self = Self(1000156000);
    pub const SAMPLER_YCBCR_CONVERSION_INFO: Self = Self(1000156001);
    pub const BIND_IMAGE_PLANE_MEMORY_INFO: Self = Self(1000156002);
    pub const IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: Self = Self(1000156003);
    pub const PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: Self = Self(1000156004);
    pub const SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: Self = Self(1000156005);
    pub const DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO: Self = Self(1000085000);
    pub const PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: Self = Self(1000071000);
    pub const EXTERNAL_IMAGE_FORMAT_PROPERTIES: Self = Self(1000071001);
    pub const PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: Self = Self(1000071002);
    pub const EXTERNAL_BUFFER_PROPERTIES: Self = Self(1000071003);
    pub const PHYSICAL_DEVICE_ID_PROPERTIES: Self = Self(1000071004);
    pub const EXTERNAL_MEMORY_BUFFER_CREATE_INFO: Self = Self(1000072000);
    pub const EXTERNAL_MEMORY_IMAGE_CREATE_INFO: Self = Self(1000072001);
    pub const EXPORT_MEMORY_ALLOCATE_INFO: Self = Self(1000072002);
    pub const PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: Self = Self(1000112000);
    pub const EXTERNAL_FENCE_PROPERTIES: Self = Self(1000112001);
    pub const EXPORT_FENCE_CREATE_INFO: Self = Self(1000113000);
    pub const EXPORT_SEMAPHORE_CREATE_INFO: Self = Self(1000077000);
    pub const PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO: Self = Self(1000076000);
    pub const EXTERNAL_SEMAPHORE_PROPERTIES: Self = Self(1000076001);
    pub const PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: Self = Self(1000168000);
    pub const DESCRIPTOR_SET_LAYOUT_SUPPORT: Self = Self(1000168001);
    pub const PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: Self = Self(1000063000);
    pub const PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: Self = Self(49);
    pub const PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: Self = Self(50);
    pub const PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: Self = Self(51);
    pub const PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: Self = Self(52);
    pub const IMAGE_FORMAT_LIST_CREATE_INFO: Self = Self(1000147000);
    pub const ATTACHMENT_DESCRIPTION_2: Self = Self(1000109000);
    pub const ATTACHMENT_REFERENCE_2: Self = Self(1000109001);
    pub const SUBPASS_DESCRIPTION_2: Self = Self(1000109002);
    pub const SUBPASS_DEPENDENCY_2: Self = Self(1000109003);
    pub const RENDER_PASS_CREATE_INFO_2: Self = Self(1000109004);
    pub const SUBPASS_BEGIN_INFO: Self = Self(1000109005);
    pub const SUBPASS_END_INFO: Self = Self(1000109006);
    pub const PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: Self = Self(1000177000);
    pub const PHYSICAL_DEVICE_DRIVER_PROPERTIES: Self = Self(1000196000);
    pub const PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: Self = Self(1000180000);
    pub const PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: Self = Self(1000082000);
    pub const PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: Self = Self(1000197000);
    pub const DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: Self = Self(1000161000);
    pub const PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: Self = Self(1000161001);
    pub const PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: Self = Self(1000161002);
    pub const DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: Self = Self(1000161003);
    pub const DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: Self = Self(1000161004);
    pub const PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: Self = Self(1000199000);
    pub const SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: Self = Self(1000199001);
    pub const PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: Self = Self(1000221000);
    pub const IMAGE_STENCIL_USAGE_CREATE_INFO: Self = Self(1000246000);
    pub const PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: Self = Self(1000130000);
    pub const SAMPLER_REDUCTION_MODE_CREATE_INFO: Self = Self(1000130001);
    pub const PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: Self = Self(1000211000);
    pub const PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: Self = Self(1000108000);
    pub const FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: Self = Self(1000108001);
    pub const FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: Self = Self(1000108002);
    pub const RENDER_PASS_ATTACHMENT_BEGIN_INFO: Self = Self(1000108003);
    pub const PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: Self = Self(1000253000);
    pub const PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: Self = Self(1000175000);
    pub const PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: Self = Self(1000241000);
    pub const ATTACHMENT_REFERENCE_STENCIL_LAYOUT: Self = Self(1000241001);
    pub const ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: Self = Self(1000241002);
    pub const PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: Self = Self(1000261000);
    pub const PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: Self = Self(1000207000);
    pub const PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: Self = Self(1000207001);
    pub const SEMAPHORE_TYPE_CREATE_INFO: Self = Self(1000207002);
    pub const TIMELINE_SEMAPHORE_SUBMIT_INFO: Self = Self(1000207003);
    pub const SEMAPHORE_WAIT_INFO: Self = Self(1000207004);
    pub const SEMAPHORE_SIGNAL_INFO: Self = Self(1000207005);
    pub const PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: Self = Self(1000257000);
    pub const BUFFER_DEVICE_ADDRESS_INFO: Self = Self(1000244001);
    pub const BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: Self = Self(1000257002);
    pub const MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: Self = Self(1000257003);
    pub const DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO: Self = Self(1000257004);
    pub const SWAPCHAIN_CREATE_INFO_KHR: Self = Self(1000001000);
    pub const PRESENT_INFO_KHR: Self = Self(1000001001);
    pub const DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: Self = Self(1000060007);
    pub const IMAGE_SWAPCHAIN_CREATE_INFO_KHR: Self = Self(1000060008);
    pub const BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: Self = Self(1000060009);
    pub const ACQUIRE_NEXT_IMAGE_INFO_KHR: Self = Self(1000060010);
    pub const DEVICE_GROUP_PRESENT_INFO_KHR: Self = Self(1000060011);
    pub const DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: Self = Self(1000060012);
    pub const DISPLAY_MODE_CREATE_INFO_KHR: Self = Self(1000002000);
    pub const DISPLAY_SURFACE_CREATE_INFO_KHR: Self = Self(1000002001);
    pub const DISPLAY_PRESENT_INFO_KHR: Self = Self(1000003000);
    pub const XLIB_SURFACE_CREATE_INFO_KHR: Self = Self(1000004000);
    pub const XCB_SURFACE_CREATE_INFO_KHR: Self = Self(1000005000);
    pub const WAYLAND_SURFACE_CREATE_INFO_KHR: Self = Self(1000006000);
    pub const ANDROID_SURFACE_CREATE_INFO_KHR: Self = Self(1000008000);
    pub const WIN32_SURFACE_CREATE_INFO_KHR: Self = Self(1000009000);
    pub const DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: Self = Self(1000011000);
    pub const PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: Self = Self(1000018000);
    pub const DEBUG_MARKER_OBJECT_NAME_INFO_EXT: Self = Self(1000022000);
    pub const DEBUG_MARKER_OBJECT_TAG_INFO_EXT: Self = Self(1000022001);
    pub const DEBUG_MARKER_MARKER_INFO_EXT: Self = Self(1000022002);
    pub const DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: Self = Self(1000026000);
    pub const DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: Self = Self(1000026001);
    pub const DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV: Self = Self(1000026002);
    pub const PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: Self = Self(1000028000);
    pub const PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: Self = Self(1000028001);
    pub const PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: Self = Self(1000028002);
    pub const CU_MODULE_CREATE_INFO_NVX: Self = Self(1000029000);
    pub const CU_FUNCTION_CREATE_INFO_NVX: Self = Self(1000029001);
    pub const CU_LAUNCH_INFO_NVX: Self = Self(1000029002);
    pub const IMAGE_VIEW_HANDLE_INFO_NVX: Self = Self(1000030000);
    pub const IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: Self = Self(1000030001);
    pub const TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD: Self = Self(1000041000);
    pub const RENDERING_INFO_KHR: Self = Self(1000044000);
    pub const RENDERING_ATTACHMENT_INFO_KHR: Self = Self(1000044001);
    pub const PIPELINE_RENDERING_CREATE_INFO_KHR: Self = Self(1000044002);
    pub const PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR: Self = Self(1000044003);
    pub const COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR: Self = Self(1000044004);
    pub const RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: Self = Self(1000044006);
    pub const RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: Self = Self(1000044007);
    pub const ATTACHMENT_SAMPLE_COUNT_INFO_AMD: Self = Self(1000044008);
    pub const MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: Self = Self(1000044009);
    pub const STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP: Self = Self(1000049000);
    pub const PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: Self = Self(1000050000);
    pub const EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: Self = Self(1000056000);
    pub const EXPORT_MEMORY_ALLOCATE_INFO_NV: Self = Self(1000056001);
    pub const IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: Self = Self(1000057000);
    pub const EXPORT_MEMORY_WIN32_HANDLE_INFO_NV: Self = Self(1000057001);
    pub const WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV: Self = Self(1000058000);
    pub const VALIDATION_FLAGS_EXT: Self = Self(1000061000);
    pub const VI_SURFACE_CREATE_INFO_NN: Self = Self(1000062000);
    pub const PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT: Self = Self(1000066000);
    pub const IMAGE_VIEW_ASTC_DECODE_MODE_EXT: Self = Self(1000067000);
    pub const PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: Self = Self(1000067001);
    pub const IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: Self = Self(1000073000);
    pub const EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR: Self = Self(1000073001);
    pub const MEMORY_WIN32_HANDLE_PROPERTIES_KHR: Self = Self(1000073002);
    pub const MEMORY_GET_WIN32_HANDLE_INFO_KHR: Self = Self(1000073003);
    pub const IMPORT_MEMORY_FD_INFO_KHR: Self = Self(1000074000);
    pub const MEMORY_FD_PROPERTIES_KHR: Self = Self(1000074001);
    pub const MEMORY_GET_FD_INFO_KHR: Self = Self(1000074002);
    pub const WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR: Self = Self(1000075000);
    pub const IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR: Self = Self(1000078000);
    pub const EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR: Self = Self(1000078001);
    pub const D3D12_FENCE_SUBMIT_INFO_KHR: Self = Self(1000078002);
    pub const SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR: Self = Self(1000078003);
    pub const IMPORT_SEMAPHORE_FD_INFO_KHR: Self = Self(1000079000);
    pub const SEMAPHORE_GET_FD_INFO_KHR: Self = Self(1000079001);
    pub const PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR: Self = Self(1000080000);
    pub const COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: Self = Self(1000081000);
    pub const PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: Self = Self(1000081001);
    pub const CONDITIONAL_RENDERING_BEGIN_INFO_EXT: Self = Self(1000081002);
    pub const PRESENT_REGIONS_KHR: Self = Self(1000084000);
    pub const PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: Self = Self(1000087000);
    pub const SURFACE_CAPABILITIES_2_EXT: Self = Self(1000090000);
    pub const DISPLAY_POWER_INFO_EXT: Self = Self(1000091000);
    pub const DEVICE_EVENT_INFO_EXT: Self = Self(1000091001);
    pub const DISPLAY_EVENT_INFO_EXT: Self = Self(1000091002);
    pub const SWAPCHAIN_COUNTER_CREATE_INFO_EXT: Self = Self(1000091003);
    pub const PRESENT_TIMES_INFO_GOOGLE: Self = Self(1000092000);
    pub const PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX: Self = Self(1000097000);
    pub const PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: Self = Self(1000098000);
    pub const PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT: Self = Self(1000099000);
    pub const PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: Self = Self(1000099001);
    pub const PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT: Self = Self(1000101000);
    pub const PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: Self = Self(1000101001);
    pub const PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: Self = Self(1000102000);
    pub const PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: Self = Self(1000102001);
    pub const HDR_METADATA_EXT: Self = Self(1000105000);
    pub const SHARED_PRESENT_SURFACE_CAPABILITIES_KHR: Self = Self(1000111000);
    pub const IMPORT_FENCE_WIN32_HANDLE_INFO_KHR: Self = Self(1000114000);
    pub const EXPORT_FENCE_WIN32_HANDLE_INFO_KHR: Self = Self(1000114001);
    pub const FENCE_GET_WIN32_HANDLE_INFO_KHR: Self = Self(1000114002);
    pub const IMPORT_FENCE_FD_INFO_KHR: Self = Self(1000115000);
    pub const FENCE_GET_FD_INFO_KHR: Self = Self(1000115001);
    pub const PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: Self = Self(1000116000);
    pub const PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR: Self = Self(1000116001);
    pub const QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: Self = Self(1000116002);
    pub const PERFORMANCE_QUERY_SUBMIT_INFO_KHR: Self = Self(1000116003);
    pub const ACQUIRE_PROFILING_LOCK_INFO_KHR: Self = Self(1000116004);
    pub const PERFORMANCE_COUNTER_KHR: Self = Self(1000116005);
    pub const PERFORMANCE_COUNTER_DESCRIPTION_KHR: Self = Self(1000116006);
    pub const PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: Self = Self(1000119000);
    pub const SURFACE_CAPABILITIES_2_KHR: Self = Self(1000119001);
    pub const SURFACE_FORMAT_2_KHR: Self = Self(1000119002);
    pub const DISPLAY_PROPERTIES_2_KHR: Self = Self(1000121000);
    pub const DISPLAY_PLANE_PROPERTIES_2_KHR: Self = Self(1000121001);
    pub const DISPLAY_MODE_PROPERTIES_2_KHR: Self = Self(1000121002);
    pub const DISPLAY_PLANE_INFO_2_KHR: Self = Self(1000121003);
    pub const DISPLAY_PLANE_CAPABILITIES_2_KHR: Self = Self(1000121004);
    pub const IOS_SURFACE_CREATE_INFO_MVK: Self = Self(1000122000);
    pub const MACOS_SURFACE_CREATE_INFO_MVK: Self = Self(1000123000);
    pub const DEBUG_UTILS_OBJECT_NAME_INFO_EXT: Self = Self(1000128000);
    pub const DEBUG_UTILS_OBJECT_TAG_INFO_EXT: Self = Self(1000128001);
    pub const DEBUG_UTILS_LABEL_EXT: Self = Self(1000128002);
    pub const DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT: Self = Self(1000128003);
    pub const DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: Self = Self(1000128004);
    pub const ANDROID_HARDWARE_BUFFER_USAGE_ANDROID: Self = Self(1000129000);
    pub const ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID: Self = Self(1000129001);
    pub const ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID: Self = Self(1000129002);
    pub const IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: Self = Self(1000129003);
    pub const MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: Self = Self(1000129004);
    pub const EXTERNAL_FORMAT_ANDROID: Self = Self(1000129005);
    pub const ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID: Self = Self(1000129006);
    pub const PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT: Self = Self(1000138000);
    pub const PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT: Self = Self(1000138001);
    pub const WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT: Self = Self(1000138002);
    pub const DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT: Self = Self(1000138003);
    pub const SAMPLE_LOCATIONS_INFO_EXT: Self = Self(1000143000);
    pub const RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: Self = Self(1000143001);
    pub const PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: Self = Self(1000143002);
    pub const PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT: Self = Self(1000143003);
    pub const MULTISAMPLE_PROPERTIES_EXT: Self = Self(1000143004);
    pub const PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: Self = Self(1000148000);
    pub const PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT: Self = Self(1000148001);
    pub const PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: Self = Self(1000148002);
    pub const PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: Self = Self(1000149000);
    pub const WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: Self = Self(1000150007);
    pub const ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR: Self = Self(1000150000);
    pub const ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR: Self = Self(1000150002);
    pub const ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR: Self = Self(1000150003);
    pub const ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR: Self = Self(1000150004);
    pub const ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR: Self = Self(1000150005);
    pub const ACCELERATION_STRUCTURE_GEOMETRY_KHR: Self = Self(1000150006);
    pub const ACCELERATION_STRUCTURE_VERSION_INFO_KHR: Self = Self(1000150009);
    pub const COPY_ACCELERATION_STRUCTURE_INFO_KHR: Self = Self(1000150010);
    pub const COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR: Self = Self(1000150011);
    pub const COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR: Self = Self(1000150012);
    pub const PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: Self = Self(1000150013);
    pub const PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR: Self = Self(1000150014);
    pub const ACCELERATION_STRUCTURE_CREATE_INFO_KHR: Self = Self(1000150017);
    pub const ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR: Self = Self(1000150020);
    pub const PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: Self = Self(1000347000);
    pub const PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR: Self = Self(1000347001);
    pub const RAY_TRACING_PIPELINE_CREATE_INFO_KHR: Self = Self(1000150015);
    pub const RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR: Self = Self(1000150016);
    pub const RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR: Self = Self(1000150018);
    pub const PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: Self = Self(1000348013);
    pub const PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: Self = Self(1000152000);
    pub const PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: Self = Self(1000154000);
    pub const PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV: Self = Self(1000154001);
    pub const DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT: Self = Self(1000158000);
    pub const PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: Self = Self(1000158002);
    pub const IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: Self = Self(1000158003);
    pub const IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: Self = Self(1000158004);
    pub const IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT: Self = Self(1000158005);
    pub const DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT: Self = Self(1000158006);
    pub const VALIDATION_CACHE_CREATE_INFO_EXT: Self = Self(1000160000);
    pub const SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: Self = Self(1000160001);
    pub const PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR: Self = Self(1000163000);
    pub const PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR: Self = Self(1000163001);
    pub const PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: Self = Self(1000164000);
    pub const PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: Self = Self(1000164001);
    pub const PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV: Self = Self(1000164002);
    pub const PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: Self = Self(1000164005);
    pub const RAY_TRACING_PIPELINE_CREATE_INFO_NV: Self = Self(1000165000);
    pub const ACCELERATION_STRUCTURE_CREATE_INFO_NV: Self = Self(1000165001);
    pub const GEOMETRY_NV: Self = Self(1000165003);
    pub const GEOMETRY_TRIANGLES_NV: Self = Self(1000165004);
    pub const GEOMETRY_AABB_NV: Self = Self(1000165005);
    pub const BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV: Self = Self(1000165006);
    pub const WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: Self = Self(1000165007);
    pub const ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV: Self = Self(1000165008);
    pub const PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV: Self = Self(1000165009);
    pub const RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV: Self = Self(1000165011);
    pub const ACCELERATION_STRUCTURE_INFO_NV: Self = Self(1000165012);
    pub const PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: Self = Self(1000166000);
    pub const PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: Self = Self(1000166001);
    pub const PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: Self = Self(1000170000);
    pub const FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT: Self = Self(1000170001);
    pub const DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT: Self = Self(1000174000);
    pub const IMPORT_MEMORY_HOST_POINTER_INFO_EXT: Self = Self(1000178000);
    pub const MEMORY_HOST_POINTER_PROPERTIES_EXT: Self = Self(1000178001);
    pub const PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT: Self = Self(1000178002);
    pub const PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: Self = Self(1000181000);
    pub const PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: Self = Self(1000183000);
    pub const CALIBRATED_TIMESTAMP_INFO_EXT: Self = Self(1000184000);
    pub const PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD: Self = Self(1000185000);
    pub const DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: Self = Self(1000189000);
    pub const PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT: Self = Self(1000190000);
    pub const PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT: Self = Self(1000190001);
    pub const PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT: Self = Self(1000190002);
    pub const PRESENT_FRAME_TOKEN_GGP: Self = Self(1000191000);
    pub const PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT: Self = Self(1000192000);
    pub const PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV: Self = Self(1000201000);
    pub const PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: Self = Self(1000202000);
    pub const PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV: Self = Self(1000202001);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV: Self = Self(1000203000);
    pub const PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: Self = Self(1000204000);
    pub const PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV: Self = Self(1000205000);
    pub const PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: Self = Self(1000205002);
    pub const CHECKPOINT_DATA_NV: Self = Self(1000206000);
    pub const QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: Self = Self(1000206001);
    pub const PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: Self = Self(1000209000);
    pub const QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: Self = Self(1000210000);
    pub const INITIALIZE_PERFORMANCE_API_INFO_INTEL: Self = Self(1000210001);
    pub const PERFORMANCE_MARKER_INFO_INTEL: Self = Self(1000210002);
    pub const PERFORMANCE_STREAM_MARKER_INFO_INTEL: Self = Self(1000210003);
    pub const PERFORMANCE_OVERRIDE_INFO_INTEL: Self = Self(1000210004);
    pub const PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL: Self = Self(1000210005);
    pub const PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT: Self = Self(1000212000);
    pub const DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD: Self = Self(1000213000);
    pub const SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: Self = Self(1000213001);
    pub const IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA: Self = Self(1000214000);
    pub const PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR: Self = Self(1000215000);
    pub const METAL_SURFACE_CREATE_INFO_EXT: Self = Self(1000217000);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: Self = Self(1000218000);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT: Self = Self(1000218001);
    pub const RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: Self = Self(1000218002);
    pub const PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT: Self = Self(1000225000);
    pub const PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT: Self = Self(1000225001);
    pub const PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT: Self = Self(1000225002);
    pub const FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: Self = Self(1000226000);
    pub const PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR: Self = Self(1000226001);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR: Self = Self(1000226002);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: Self = Self(1000226003);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR: Self = Self(1000226004);
    pub const PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD: Self = Self(1000227000);
    pub const PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: Self = Self(1000229000);
    pub const PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: Self = Self(1000234000);
    pub const PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT: Self = Self(1000237000);
    pub const PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: Self = Self(1000238000);
    pub const MEMORY_PRIORITY_ALLOCATE_INFO_EXT: Self = Self(1000238001);
    pub const SURFACE_PROTECTED_CAPABILITIES_KHR: Self = Self(1000239000);
    pub const PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: Self =
        Self(1000240000);
    pub const PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: Self = Self(1000244000);
    pub const BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: Self = Self(1000244002);
    pub const PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: Self = Self(1000245000);
    pub const VALIDATION_FEATURES_EXT: Self = Self(1000247000);
    pub const PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: Self = Self(1000248000);
    pub const PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: Self = Self(1000249000);
    pub const COOPERATIVE_MATRIX_PROPERTIES_NV: Self = Self(1000249001);
    pub const PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV: Self = Self(1000249002);
    pub const PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: Self = Self(1000250000);
    pub const PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: Self = Self(1000250001);
    pub const FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV: Self = Self(1000250002);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: Self = Self(1000251000);
    pub const PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: Self = Self(1000252000);
    pub const PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: Self = Self(1000254000);
    pub const PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: Self =
        Self(1000254001);
    pub const PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: Self = Self(1000254002);
    pub const SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT: Self = Self(1000255000);
    pub const SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT: Self = Self(1000255002);
    pub const SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT: Self = Self(1000255001);
    pub const HEADLESS_SURFACE_CREATE_INFO_EXT: Self = Self(1000256000);
    pub const PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: Self = Self(1000259000);
    pub const PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: Self = Self(1000259001);
    pub const PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: Self = Self(1000259002);
    pub const PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: Self = Self(1000260000);
    pub const PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: Self = Self(1000265000);
    pub const PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: Self = Self(1000267000);
    pub const PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: Self = Self(1000269000);
    pub const PIPELINE_INFO_KHR: Self = Self(1000269001);
    pub const PIPELINE_EXECUTABLE_PROPERTIES_KHR: Self = Self(1000269002);
    pub const PIPELINE_EXECUTABLE_INFO_KHR: Self = Self(1000269003);
    pub const PIPELINE_EXECUTABLE_STATISTIC_KHR: Self = Self(1000269004);
    pub const PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR: Self = Self(1000269005);
    pub const PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: Self = Self(1000273000);
    pub const PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT: Self =
        Self(1000276000);
    pub const PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV: Self = Self(1000277000);
    pub const GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: Self = Self(1000277001);
    pub const GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: Self = Self(1000277002);
    pub const INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: Self = Self(1000277003);
    pub const INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV: Self = Self(1000277004);
    pub const GENERATED_COMMANDS_INFO_NV: Self = Self(1000277005);
    pub const GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV: Self = Self(1000277006);
    pub const PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: Self = Self(1000277007);
    pub const PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: Self = Self(1000278000);
    pub const COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV: Self = Self(1000278001);
    pub const PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR: Self = Self(1000280000);
    pub const PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR: Self = Self(1000280001);
    pub const PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: Self = Self(1000281000);
    pub const PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT: Self = Self(1000281001);
    pub const COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM: Self = Self(1000282000);
    pub const RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: Self = Self(1000282001);
    pub const PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: Self = Self(1000284000);
    pub const DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: Self = Self(1000284001);
    pub const DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT: Self = Self(1000284002);
    pub const PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: Self = Self(1000286000);
    pub const PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT: Self = Self(1000286001);
    pub const SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: Self = Self(1000287000);
    pub const PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: Self = Self(1000287001);
    pub const PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: Self = Self(1000287002);
    pub const PIPELINE_LIBRARY_CREATE_INFO_KHR: Self = Self(1000290000);
    pub const PRESENT_ID_KHR: Self = Self(1000294000);
    pub const PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: Self = Self(1000294001);
    pub const PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT: Self = Self(1000295000);
    pub const DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: Self = Self(1000295001);
    pub const PRIVATE_DATA_SLOT_CREATE_INFO_EXT: Self = Self(1000295002);
    pub const PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT: Self = Self(1000297000);
    pub const PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: Self = Self(1000300000);
    pub const DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: Self = Self(1000300001);
    pub const MEMORY_BARRIER_2_KHR: Self = Self(1000314000);
    pub const BUFFER_MEMORY_BARRIER_2_KHR: Self = Self(1000314001);
    pub const IMAGE_MEMORY_BARRIER_2_KHR: Self = Self(1000314002);
    pub const DEPENDENCY_INFO_KHR: Self = Self(1000314003);
    pub const SUBMIT_INFO_2_KHR: Self = Self(1000314004);
    pub const SEMAPHORE_SUBMIT_INFO_KHR: Self = Self(1000314005);
    pub const COMMAND_BUFFER_SUBMIT_INFO_KHR: Self = Self(1000314006);
    pub const PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR: Self = Self(1000314007);
    pub const QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: Self = Self(1000314008);
    pub const CHECKPOINT_DATA_2_NV: Self = Self(1000314009);
    pub const PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: Self =
        Self(1000323000);
    pub const PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR: Self =
        Self(1000325000);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV: Self = Self(1000326000);
    pub const PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: Self = Self(1000326001);
    pub const PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV: Self = Self(1000326002);
    pub const ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV: Self = Self(1000327000);
    pub const PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: Self = Self(1000327001);
    pub const ACCELERATION_STRUCTURE_MOTION_INFO_NV: Self = Self(1000327002);
    pub const PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: Self = Self(1000330000);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: Self = Self(1000332000);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT: Self = Self(1000332001);
    pub const COPY_COMMAND_TRANSFORM_INFO_QCOM: Self = Self(1000333000);
    pub const PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT: Self = Self(1000335000);
    pub const PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: Self =
        Self(1000336000);
    pub const COPY_BUFFER_INFO_2_KHR: Self = Self(1000337000);
    pub const COPY_IMAGE_INFO_2_KHR: Self = Self(1000337001);
    pub const COPY_BUFFER_TO_IMAGE_INFO_2_KHR: Self = Self(1000337002);
    pub const COPY_IMAGE_TO_BUFFER_INFO_2_KHR: Self = Self(1000337003);
    pub const BLIT_IMAGE_INFO_2_KHR: Self = Self(1000337004);
    pub const RESOLVE_IMAGE_INFO_2_KHR: Self = Self(1000337005);
    pub const BUFFER_COPY_2_KHR: Self = Self(1000337006);
    pub const IMAGE_COPY_2_KHR: Self = Self(1000337007);
    pub const IMAGE_BLIT_2_KHR: Self = Self(1000337008);
    pub const BUFFER_IMAGE_COPY_2_KHR: Self = Self(1000337009);
    pub const IMAGE_RESOLVE_2_KHR: Self = Self(1000337010);
    pub const PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: Self = Self(1000340000);
    pub const PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_ARM: Self =
        Self(1000342000);
    pub const PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: Self = Self(1000344000);
    pub const DIRECTFB_SURFACE_CREATE_INFO_EXT: Self = Self(1000346000);
    pub const PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE: Self = Self(1000351000);
    pub const MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE: Self = Self(1000351002);
    pub const PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: Self = Self(1000352000);
    pub const VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT: Self = Self(1000352001);
    pub const VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT: Self = Self(1000352002);
    pub const PHYSICAL_DEVICE_DRM_PROPERTIES_EXT: Self = Self(1000353000);
    pub const PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: Self = Self(1000355000);
    pub const PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT: Self = Self(1000355001);
    pub const PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: Self = Self(1000356000);
    pub const FORMAT_PROPERTIES_3_KHR: Self = Self(1000360000);
    pub const IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA: Self = Self(1000364000);
    pub const MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA: Self = Self(1000364001);
    pub const MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA: Self = Self(1000364002);
    pub const IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA: Self = Self(1000365000);
    pub const SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA: Self = Self(1000365001);
    pub const BUFFER_COLLECTION_CREATE_INFO_FUCHSIA: Self = Self(1000366000);
    pub const IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA: Self = Self(1000366001);
    pub const BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA: Self = Self(1000366002);
    pub const BUFFER_COLLECTION_PROPERTIES_FUCHSIA: Self = Self(1000366003);
    pub const BUFFER_CONSTRAINTS_INFO_FUCHSIA: Self = Self(1000366004);
    pub const BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA: Self = Self(1000366005);
    pub const IMAGE_CONSTRAINTS_INFO_FUCHSIA: Self = Self(1000366006);
    pub const IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA: Self = Self(1000366007);
    pub const SYSMEM_COLOR_SPACE_FUCHSIA: Self = Self(1000366008);
    pub const BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA: Self = Self(1000366009);
    pub const SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI: Self = Self(1000369000);
    pub const PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: Self = Self(1000369001);
    pub const PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI: Self = Self(1000369002);
    pub const PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: Self = Self(1000370000);
    pub const MEMORY_GET_REMOTE_ADDRESS_INFO_NV: Self = Self(1000371000);
    pub const PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: Self = Self(1000371001);
    pub const PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: Self = Self(1000377000);
    pub const SCREEN_SURFACE_CREATE_INFO_QNX: Self = Self(1000378000);
    pub const PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: Self = Self(1000381000);
    pub const PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: Self = Self(1000381001);
    pub const PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT: Self = Self(1000388000);
    pub const QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT: Self = Self(1000388001);
    pub const PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: Self = Self(1000391000);
    pub const IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT: Self = Self(1000391001);
    pub const PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: Self = Self(1000392000);
    pub const PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT: Self = Self(1000392001);
    pub const PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: Self = Self(1000411000);
    pub const SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT: Self = Self(1000411001);
    pub const PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: Self = Self(1000412000);
    pub const PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR: Self = Self(1000413000);
    pub const PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR: Self = Self(1000413001);
    pub const DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR: Self = Self(1000413002);
    pub const DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR: Self = Self(1000413003);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: Self = Self(1000425000);
    pub const PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM: Self = Self(1000425001);
    pub const SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM: Self = Self(1000425002);
    pub const PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: Self = Self(1000430000);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for StructureType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "APPLICATION_INFO"),
            1 => write!(f, "INSTANCE_CREATE_INFO"),
            2 => write!(f, "DEVICE_QUEUE_CREATE_INFO"),
            3 => write!(f, "DEVICE_CREATE_INFO"),
            4 => write!(f, "SUBMIT_INFO"),
            5 => write!(f, "MEMORY_ALLOCATE_INFO"),
            6 => write!(f, "MAPPED_MEMORY_RANGE"),
            7 => write!(f, "BIND_SPARSE_INFO"),
            8 => write!(f, "FENCE_CREATE_INFO"),
            9 => write!(f, "SEMAPHORE_CREATE_INFO"),
            10 => write!(f, "EVENT_CREATE_INFO"),
            11 => write!(f, "QUERY_POOL_CREATE_INFO"),
            12 => write!(f, "BUFFER_CREATE_INFO"),
            13 => write!(f, "BUFFER_VIEW_CREATE_INFO"),
            14 => write!(f, "IMAGE_CREATE_INFO"),
            15 => write!(f, "IMAGE_VIEW_CREATE_INFO"),
            16 => write!(f, "SHADER_MODULE_CREATE_INFO"),
            17 => write!(f, "PIPELINE_CACHE_CREATE_INFO"),
            18 => write!(f, "PIPELINE_SHADER_STAGE_CREATE_INFO"),
            19 => write!(f, "PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO"),
            20 => write!(f, "PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO"),
            21 => write!(f, "PIPELINE_TESSELLATION_STATE_CREATE_INFO"),
            22 => write!(f, "PIPELINE_VIEWPORT_STATE_CREATE_INFO"),
            23 => write!(f, "PIPELINE_RASTERIZATION_STATE_CREATE_INFO"),
            24 => write!(f, "PIPELINE_MULTISAMPLE_STATE_CREATE_INFO"),
            25 => write!(f, "PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO"),
            26 => write!(f, "PIPELINE_COLOR_BLEND_STATE_CREATE_INFO"),
            27 => write!(f, "PIPELINE_DYNAMIC_STATE_CREATE_INFO"),
            28 => write!(f, "GRAPHICS_PIPELINE_CREATE_INFO"),
            29 => write!(f, "COMPUTE_PIPELINE_CREATE_INFO"),
            30 => write!(f, "PIPELINE_LAYOUT_CREATE_INFO"),
            31 => write!(f, "SAMPLER_CREATE_INFO"),
            32 => write!(f, "DESCRIPTOR_SET_LAYOUT_CREATE_INFO"),
            33 => write!(f, "DESCRIPTOR_POOL_CREATE_INFO"),
            34 => write!(f, "DESCRIPTOR_SET_ALLOCATE_INFO"),
            35 => write!(f, "WRITE_DESCRIPTOR_SET"),
            36 => write!(f, "COPY_DESCRIPTOR_SET"),
            37 => write!(f, "FRAMEBUFFER_CREATE_INFO"),
            38 => write!(f, "RENDER_PASS_CREATE_INFO"),
            39 => write!(f, "COMMAND_POOL_CREATE_INFO"),
            40 => write!(f, "COMMAND_BUFFER_ALLOCATE_INFO"),
            41 => write!(f, "COMMAND_BUFFER_INHERITANCE_INFO"),
            42 => write!(f, "COMMAND_BUFFER_BEGIN_INFO"),
            43 => write!(f, "RENDER_PASS_BEGIN_INFO"),
            44 => write!(f, "BUFFER_MEMORY_BARRIER"),
            45 => write!(f, "IMAGE_MEMORY_BARRIER"),
            46 => write!(f, "MEMORY_BARRIER"),
            47 => write!(f, "LOADER_INSTANCE_CREATE_INFO"),
            48 => write!(f, "LOADER_DEVICE_CREATE_INFO"),
            1000094000 => write!(f, "PHYSICAL_DEVICE_SUBGROUP_PROPERTIES"),
            1000157000 => write!(f, "BIND_BUFFER_MEMORY_INFO"),
            1000157001 => write!(f, "BIND_IMAGE_MEMORY_INFO"),
            1000083000 => write!(f, "PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES"),
            1000127000 => write!(f, "MEMORY_DEDICATED_REQUIREMENTS"),
            1000127001 => write!(f, "MEMORY_DEDICATED_ALLOCATE_INFO"),
            1000060000 => write!(f, "MEMORY_ALLOCATE_FLAGS_INFO"),
            1000060003 => write!(f, "DEVICE_GROUP_RENDER_PASS_BEGIN_INFO"),
            1000060004 => write!(f, "DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO"),
            1000060005 => write!(f, "DEVICE_GROUP_SUBMIT_INFO"),
            1000060006 => write!(f, "DEVICE_GROUP_BIND_SPARSE_INFO"),
            1000060013 => write!(f, "BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO"),
            1000060014 => write!(f, "BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO"),
            1000070000 => write!(f, "PHYSICAL_DEVICE_GROUP_PROPERTIES"),
            1000070001 => write!(f, "DEVICE_GROUP_DEVICE_CREATE_INFO"),
            1000146000 => write!(f, "BUFFER_MEMORY_REQUIREMENTS_INFO_2"),
            1000146001 => write!(f, "IMAGE_MEMORY_REQUIREMENTS_INFO_2"),
            1000146002 => write!(f, "IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2"),
            1000146003 => write!(f, "MEMORY_REQUIREMENTS_2"),
            1000146004 => write!(f, "SPARSE_IMAGE_MEMORY_REQUIREMENTS_2"),
            1000059000 => write!(f, "PHYSICAL_DEVICE_FEATURES_2"),
            1000059001 => write!(f, "PHYSICAL_DEVICE_PROPERTIES_2"),
            1000059002 => write!(f, "FORMAT_PROPERTIES_2"),
            1000059003 => write!(f, "IMAGE_FORMAT_PROPERTIES_2"),
            1000059004 => write!(f, "PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2"),
            1000059005 => write!(f, "QUEUE_FAMILY_PROPERTIES_2"),
            1000059006 => write!(f, "PHYSICAL_DEVICE_MEMORY_PROPERTIES_2"),
            1000059007 => write!(f, "SPARSE_IMAGE_FORMAT_PROPERTIES_2"),
            1000059008 => write!(f, "PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2"),
            1000117000 => write!(f, "PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES"),
            1000117001 => write!(f, "RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO"),
            1000117002 => write!(f, "IMAGE_VIEW_USAGE_CREATE_INFO"),
            1000117003 => write!(f, "PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO"),
            1000053000 => write!(f, "RENDER_PASS_MULTIVIEW_CREATE_INFO"),
            1000053001 => write!(f, "PHYSICAL_DEVICE_MULTIVIEW_FEATURES"),
            1000053002 => write!(f, "PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES"),
            1000120000 => write!(f, "PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES"),
            1000145000 => write!(f, "PROTECTED_SUBMIT_INFO"),
            1000145001 => write!(f, "PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES"),
            1000145002 => write!(f, "PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES"),
            1000145003 => write!(f, "DEVICE_QUEUE_INFO_2"),
            1000156000 => write!(f, "SAMPLER_YCBCR_CONVERSION_CREATE_INFO"),
            1000156001 => write!(f, "SAMPLER_YCBCR_CONVERSION_INFO"),
            1000156002 => write!(f, "BIND_IMAGE_PLANE_MEMORY_INFO"),
            1000156003 => write!(f, "IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO"),
            1000156004 => write!(f, "PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES"),
            1000156005 => write!(f, "SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES"),
            1000085000 => write!(f, "DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO"),
            1000071000 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO"),
            1000071001 => write!(f, "EXTERNAL_IMAGE_FORMAT_PROPERTIES"),
            1000071002 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO"),
            1000071003 => write!(f, "EXTERNAL_BUFFER_PROPERTIES"),
            1000071004 => write!(f, "PHYSICAL_DEVICE_ID_PROPERTIES"),
            1000072000 => write!(f, "EXTERNAL_MEMORY_BUFFER_CREATE_INFO"),
            1000072001 => write!(f, "EXTERNAL_MEMORY_IMAGE_CREATE_INFO"),
            1000072002 => write!(f, "EXPORT_MEMORY_ALLOCATE_INFO"),
            1000112000 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO"),
            1000112001 => write!(f, "EXTERNAL_FENCE_PROPERTIES"),
            1000113000 => write!(f, "EXPORT_FENCE_CREATE_INFO"),
            1000077000 => write!(f, "EXPORT_SEMAPHORE_CREATE_INFO"),
            1000076000 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO"),
            1000076001 => write!(f, "EXTERNAL_SEMAPHORE_PROPERTIES"),
            1000168000 => write!(f, "PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES"),
            1000168001 => write!(f, "DESCRIPTOR_SET_LAYOUT_SUPPORT"),
            1000063000 => write!(f, "PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES"),
            49 => write!(f, "PHYSICAL_DEVICE_VULKAN_1_1_FEATURES"),
            50 => write!(f, "PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES"),
            51 => write!(f, "PHYSICAL_DEVICE_VULKAN_1_2_FEATURES"),
            52 => write!(f, "PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES"),
            1000147000 => write!(f, "IMAGE_FORMAT_LIST_CREATE_INFO"),
            1000109000 => write!(f, "ATTACHMENT_DESCRIPTION_2"),
            1000109001 => write!(f, "ATTACHMENT_REFERENCE_2"),
            1000109002 => write!(f, "SUBPASS_DESCRIPTION_2"),
            1000109003 => write!(f, "SUBPASS_DEPENDENCY_2"),
            1000109004 => write!(f, "RENDER_PASS_CREATE_INFO_2"),
            1000109005 => write!(f, "SUBPASS_BEGIN_INFO"),
            1000109006 => write!(f, "SUBPASS_END_INFO"),
            1000177000 => write!(f, "PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES"),
            1000196000 => write!(f, "PHYSICAL_DEVICE_DRIVER_PROPERTIES"),
            1000180000 => write!(f, "PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES"),
            1000082000 => write!(f, "PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES"),
            1000197000 => write!(f, "PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES"),
            1000161000 => write!(f, "DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO"),
            1000161001 => write!(f, "PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES"),
            1000161002 => write!(f, "PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES"),
            1000161003 => write!(f, "DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO"),
            1000161004 => write!(f, "DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT"),
            1000199000 => write!(f, "PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES"),
            1000199001 => write!(f, "SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE"),
            1000221000 => write!(f, "PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES"),
            1000246000 => write!(f, "IMAGE_STENCIL_USAGE_CREATE_INFO"),
            1000130000 => write!(f, "PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES"),
            1000130001 => write!(f, "SAMPLER_REDUCTION_MODE_CREATE_INFO"),
            1000211000 => write!(f, "PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES"),
            1000108000 => write!(f, "PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES"),
            1000108001 => write!(f, "FRAMEBUFFER_ATTACHMENTS_CREATE_INFO"),
            1000108002 => write!(f, "FRAMEBUFFER_ATTACHMENT_IMAGE_INFO"),
            1000108003 => write!(f, "RENDER_PASS_ATTACHMENT_BEGIN_INFO"),
            1000253000 => write!(f, "PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES"),
            1000175000 => write!(f, "PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES"),
            1000241000 => write!(f, "PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES"),
            1000241001 => write!(f, "ATTACHMENT_REFERENCE_STENCIL_LAYOUT"),
            1000241002 => write!(f, "ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT"),
            1000261000 => write!(f, "PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES"),
            1000207000 => write!(f, "PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES"),
            1000207001 => write!(f, "PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES"),
            1000207002 => write!(f, "SEMAPHORE_TYPE_CREATE_INFO"),
            1000207003 => write!(f, "TIMELINE_SEMAPHORE_SUBMIT_INFO"),
            1000207004 => write!(f, "SEMAPHORE_WAIT_INFO"),
            1000207005 => write!(f, "SEMAPHORE_SIGNAL_INFO"),
            1000257000 => write!(f, "PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES"),
            1000244001 => write!(f, "BUFFER_DEVICE_ADDRESS_INFO"),
            1000257002 => write!(f, "BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO"),
            1000257003 => write!(f, "MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO"),
            1000257004 => write!(f, "DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO"),
            1000001000 => write!(f, "SWAPCHAIN_CREATE_INFO_KHR"),
            1000001001 => write!(f, "PRESENT_INFO_KHR"),
            1000060007 => write!(f, "DEVICE_GROUP_PRESENT_CAPABILITIES_KHR"),
            1000060008 => write!(f, "IMAGE_SWAPCHAIN_CREATE_INFO_KHR"),
            1000060009 => write!(f, "BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR"),
            1000060010 => write!(f, "ACQUIRE_NEXT_IMAGE_INFO_KHR"),
            1000060011 => write!(f, "DEVICE_GROUP_PRESENT_INFO_KHR"),
            1000060012 => write!(f, "DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR"),
            1000002000 => write!(f, "DISPLAY_MODE_CREATE_INFO_KHR"),
            1000002001 => write!(f, "DISPLAY_SURFACE_CREATE_INFO_KHR"),
            1000003000 => write!(f, "DISPLAY_PRESENT_INFO_KHR"),
            1000004000 => write!(f, "XLIB_SURFACE_CREATE_INFO_KHR"),
            1000005000 => write!(f, "XCB_SURFACE_CREATE_INFO_KHR"),
            1000006000 => write!(f, "WAYLAND_SURFACE_CREATE_INFO_KHR"),
            1000008000 => write!(f, "ANDROID_SURFACE_CREATE_INFO_KHR"),
            1000009000 => write!(f, "WIN32_SURFACE_CREATE_INFO_KHR"),
            1000011000 => write!(f, "DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT"),
            1000018000 => write!(f, "PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD"),
            1000022000 => write!(f, "DEBUG_MARKER_OBJECT_NAME_INFO_EXT"),
            1000022001 => write!(f, "DEBUG_MARKER_OBJECT_TAG_INFO_EXT"),
            1000022002 => write!(f, "DEBUG_MARKER_MARKER_INFO_EXT"),
            1000026000 => write!(f, "DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV"),
            1000026001 => write!(f, "DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV"),
            1000026002 => write!(f, "DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV"),
            1000028000 => write!(f, "PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT"),
            1000028001 => write!(f, "PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT"),
            1000028002 => write!(f, "PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT"),
            1000029000 => write!(f, "CU_MODULE_CREATE_INFO_NVX"),
            1000029001 => write!(f, "CU_FUNCTION_CREATE_INFO_NVX"),
            1000029002 => write!(f, "CU_LAUNCH_INFO_NVX"),
            1000030000 => write!(f, "IMAGE_VIEW_HANDLE_INFO_NVX"),
            1000030001 => write!(f, "IMAGE_VIEW_ADDRESS_PROPERTIES_NVX"),
            1000041000 => write!(f, "TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD"),
            1000044000 => write!(f, "RENDERING_INFO_KHR"),
            1000044001 => write!(f, "RENDERING_ATTACHMENT_INFO_KHR"),
            1000044002 => write!(f, "PIPELINE_RENDERING_CREATE_INFO_KHR"),
            1000044003 => write!(f, "PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR"),
            1000044004 => write!(f, "COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR"),
            1000044006 => write!(f, "RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR"),
            1000044007 => write!(f, "RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT"),
            1000044008 => write!(f, "ATTACHMENT_SAMPLE_COUNT_INFO_AMD"),
            1000044009 => write!(f, "MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX"),
            1000049000 => write!(f, "STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP"),
            1000050000 => write!(f, "PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV"),
            1000056000 => write!(f, "EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV"),
            1000056001 => write!(f, "EXPORT_MEMORY_ALLOCATE_INFO_NV"),
            1000057000 => write!(f, "IMPORT_MEMORY_WIN32_HANDLE_INFO_NV"),
            1000057001 => write!(f, "EXPORT_MEMORY_WIN32_HANDLE_INFO_NV"),
            1000058000 => write!(f, "WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV"),
            1000061000 => write!(f, "VALIDATION_FLAGS_EXT"),
            1000062000 => write!(f, "VI_SURFACE_CREATE_INFO_NN"),
            1000066000 => write!(
                f,
                "PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT"
            ),
            1000067000 => write!(f, "IMAGE_VIEW_ASTC_DECODE_MODE_EXT"),
            1000067001 => write!(f, "PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT"),
            1000073000 => write!(f, "IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR"),
            1000073001 => write!(f, "EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR"),
            1000073002 => write!(f, "MEMORY_WIN32_HANDLE_PROPERTIES_KHR"),
            1000073003 => write!(f, "MEMORY_GET_WIN32_HANDLE_INFO_KHR"),
            1000074000 => write!(f, "IMPORT_MEMORY_FD_INFO_KHR"),
            1000074001 => write!(f, "MEMORY_FD_PROPERTIES_KHR"),
            1000074002 => write!(f, "MEMORY_GET_FD_INFO_KHR"),
            1000075000 => write!(f, "WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR"),
            1000078000 => write!(f, "IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR"),
            1000078001 => write!(f, "EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR"),
            1000078002 => write!(f, "D3D12_FENCE_SUBMIT_INFO_KHR"),
            1000078003 => write!(f, "SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR"),
            1000079000 => write!(f, "IMPORT_SEMAPHORE_FD_INFO_KHR"),
            1000079001 => write!(f, "SEMAPHORE_GET_FD_INFO_KHR"),
            1000080000 => write!(f, "PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR"),
            1000081000 => write!(
                f,
                "COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT"
            ),
            1000081001 => write!(f, "PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT"),
            1000081002 => write!(f, "CONDITIONAL_RENDERING_BEGIN_INFO_EXT"),
            1000084000 => write!(f, "PRESENT_REGIONS_KHR"),
            1000087000 => write!(f, "PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV"),
            1000090000 => write!(f, "SURFACE_CAPABILITIES_2_EXT"),
            1000091000 => write!(f, "DISPLAY_POWER_INFO_EXT"),
            1000091001 => write!(f, "DEVICE_EVENT_INFO_EXT"),
            1000091002 => write!(f, "DISPLAY_EVENT_INFO_EXT"),
            1000091003 => write!(f, "SWAPCHAIN_COUNTER_CREATE_INFO_EXT"),
            1000092000 => write!(f, "PRESENT_TIMES_INFO_GOOGLE"),
            1000097000 => write!(
                f,
                "PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX"
            ),
            1000098000 => write!(f, "PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV"),
            1000099000 => write!(f, "PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT"),
            1000099001 => write!(f, "PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT"),
            1000101000 => write!(
                f,
                "PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT"
            ),
            1000101001 => write!(
                f,
                "PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT"
            ),
            1000102000 => write!(f, "PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT"),
            1000102001 => write!(f, "PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT"),
            1000105000 => write!(f, "HDR_METADATA_EXT"),
            1000111000 => write!(f, "SHARED_PRESENT_SURFACE_CAPABILITIES_KHR"),
            1000114000 => write!(f, "IMPORT_FENCE_WIN32_HANDLE_INFO_KHR"),
            1000114001 => write!(f, "EXPORT_FENCE_WIN32_HANDLE_INFO_KHR"),
            1000114002 => write!(f, "FENCE_GET_WIN32_HANDLE_INFO_KHR"),
            1000115000 => write!(f, "IMPORT_FENCE_FD_INFO_KHR"),
            1000115001 => write!(f, "FENCE_GET_FD_INFO_KHR"),
            1000116000 => write!(f, "PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR"),
            1000116001 => write!(f, "PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR"),
            1000116002 => write!(f, "QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR"),
            1000116003 => write!(f, "PERFORMANCE_QUERY_SUBMIT_INFO_KHR"),
            1000116004 => write!(f, "ACQUIRE_PROFILING_LOCK_INFO_KHR"),
            1000116005 => write!(f, "PERFORMANCE_COUNTER_KHR"),
            1000116006 => write!(f, "PERFORMANCE_COUNTER_DESCRIPTION_KHR"),
            1000119000 => write!(f, "PHYSICAL_DEVICE_SURFACE_INFO_2_KHR"),
            1000119001 => write!(f, "SURFACE_CAPABILITIES_2_KHR"),
            1000119002 => write!(f, "SURFACE_FORMAT_2_KHR"),
            1000121000 => write!(f, "DISPLAY_PROPERTIES_2_KHR"),
            1000121001 => write!(f, "DISPLAY_PLANE_PROPERTIES_2_KHR"),
            1000121002 => write!(f, "DISPLAY_MODE_PROPERTIES_2_KHR"),
            1000121003 => write!(f, "DISPLAY_PLANE_INFO_2_KHR"),
            1000121004 => write!(f, "DISPLAY_PLANE_CAPABILITIES_2_KHR"),
            1000122000 => write!(f, "IOS_SURFACE_CREATE_INFO_MVK"),
            1000123000 => write!(f, "MACOS_SURFACE_CREATE_INFO_MVK"),
            1000128000 => write!(f, "DEBUG_UTILS_OBJECT_NAME_INFO_EXT"),
            1000128001 => write!(f, "DEBUG_UTILS_OBJECT_TAG_INFO_EXT"),
            1000128002 => write!(f, "DEBUG_UTILS_LABEL_EXT"),
            1000128003 => write!(f, "DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT"),
            1000128004 => write!(f, "DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT"),
            1000129000 => write!(f, "ANDROID_HARDWARE_BUFFER_USAGE_ANDROID"),
            1000129001 => write!(f, "ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID"),
            1000129002 => write!(f, "ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID"),
            1000129003 => write!(f, "IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID"),
            1000129004 => write!(f, "MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID"),
            1000129005 => write!(f, "EXTERNAL_FORMAT_ANDROID"),
            1000129006 => write!(f, "ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID"),
            1000138000 => write!(f, "PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT"),
            1000138001 => write!(f, "PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT"),
            1000138002 => write!(f, "WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT"),
            1000138003 => write!(f, "DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT"),
            1000143000 => write!(f, "SAMPLE_LOCATIONS_INFO_EXT"),
            1000143001 => write!(f, "RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT"),
            1000143002 => write!(f, "PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT"),
            1000143003 => write!(f, "PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT"),
            1000143004 => write!(f, "MULTISAMPLE_PROPERTIES_EXT"),
            1000148000 => write!(f, "PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT"),
            1000148001 => write!(f, "PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT"),
            1000148002 => write!(f, "PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT"),
            1000149000 => write!(f, "PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV"),
            1000150007 => write!(f, "WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR"),
            1000150000 => write!(f, "ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR"),
            1000150002 => write!(f, "ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR"),
            1000150003 => write!(f, "ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR"),
            1000150004 => write!(f, "ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR"),
            1000150005 => write!(f, "ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR"),
            1000150006 => write!(f, "ACCELERATION_STRUCTURE_GEOMETRY_KHR"),
            1000150009 => write!(f, "ACCELERATION_STRUCTURE_VERSION_INFO_KHR"),
            1000150010 => write!(f, "COPY_ACCELERATION_STRUCTURE_INFO_KHR"),
            1000150011 => write!(f, "COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR"),
            1000150012 => write!(f, "COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR"),
            1000150013 => write!(f, "PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR"),
            1000150014 => write!(f, "PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR"),
            1000150017 => write!(f, "ACCELERATION_STRUCTURE_CREATE_INFO_KHR"),
            1000150020 => write!(f, "ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR"),
            1000347000 => write!(f, "PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR"),
            1000347001 => write!(f, "PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR"),
            1000150015 => write!(f, "RAY_TRACING_PIPELINE_CREATE_INFO_KHR"),
            1000150016 => write!(f, "RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR"),
            1000150018 => write!(f, "RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR"),
            1000348013 => write!(f, "PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR"),
            1000152000 => write!(f, "PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV"),
            1000154000 => write!(f, "PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV"),
            1000154001 => write!(f, "PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV"),
            1000158000 => write!(f, "DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT"),
            1000158002 => write!(f, "PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT"),
            1000158003 => write!(f, "IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT"),
            1000158004 => write!(f, "IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT"),
            1000158005 => write!(f, "IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT"),
            1000158006 => write!(f, "DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT"),
            1000160000 => write!(f, "VALIDATION_CACHE_CREATE_INFO_EXT"),
            1000160001 => write!(f, "SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT"),
            1000163000 => write!(f, "PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR"),
            1000163001 => write!(f, "PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR"),
            1000164000 => write!(
                f,
                "PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV"
            ),
            1000164001 => write!(f, "PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV"),
            1000164002 => write!(f, "PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV"),
            1000164005 => write!(
                f,
                "PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV"
            ),
            1000165000 => write!(f, "RAY_TRACING_PIPELINE_CREATE_INFO_NV"),
            1000165001 => write!(f, "ACCELERATION_STRUCTURE_CREATE_INFO_NV"),
            1000165003 => write!(f, "GEOMETRY_NV"),
            1000165004 => write!(f, "GEOMETRY_TRIANGLES_NV"),
            1000165005 => write!(f, "GEOMETRY_AABB_NV"),
            1000165006 => write!(f, "BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV"),
            1000165007 => write!(f, "WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV"),
            1000165008 => write!(f, "ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV"),
            1000165009 => write!(f, "PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV"),
            1000165011 => write!(f, "RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV"),
            1000165012 => write!(f, "ACCELERATION_STRUCTURE_INFO_NV"),
            1000166000 => write!(
                f,
                "PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV"
            ),
            1000166001 => write!(
                f,
                "PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV"
            ),
            1000170000 => write!(f, "PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT"),
            1000170001 => write!(f, "FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT"),
            1000174000 => write!(f, "DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT"),
            1000178000 => write!(f, "IMPORT_MEMORY_HOST_POINTER_INFO_EXT"),
            1000178001 => write!(f, "MEMORY_HOST_POINTER_PROPERTIES_EXT"),
            1000178002 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT"),
            1000181000 => write!(f, "PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR"),
            1000183000 => write!(f, "PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD"),
            1000184000 => write!(f, "CALIBRATED_TIMESTAMP_INFO_EXT"),
            1000185000 => write!(f, "PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD"),
            1000189000 => write!(f, "DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD"),
            1000190000 => write!(f, "PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT"),
            1000190001 => write!(f, "PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT"),
            1000190002 => write!(f, "PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT"),
            1000191000 => write!(f, "PRESENT_FRAME_TOKEN_GGP"),
            1000192000 => write!(f, "PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT"),
            1000201000 => write!(f, "PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV"),
            1000202000 => write!(f, "PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV"),
            1000202001 => write!(f, "PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV"),
            1000203000 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV"),
            1000204000 => write!(f, "PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV"),
            1000205000 => write!(
                f,
                "PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV"
            ),
            1000205002 => write!(f, "PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV"),
            1000206000 => write!(f, "CHECKPOINT_DATA_NV"),
            1000206001 => write!(f, "QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV"),
            1000209000 => write!(
                f,
                "PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL"
            ),
            1000210000 => write!(f, "QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL"),
            1000210001 => write!(f, "INITIALIZE_PERFORMANCE_API_INFO_INTEL"),
            1000210002 => write!(f, "PERFORMANCE_MARKER_INFO_INTEL"),
            1000210003 => write!(f, "PERFORMANCE_STREAM_MARKER_INFO_INTEL"),
            1000210004 => write!(f, "PERFORMANCE_OVERRIDE_INFO_INTEL"),
            1000210005 => write!(f, "PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL"),
            1000212000 => write!(f, "PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT"),
            1000213000 => write!(f, "DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD"),
            1000213001 => write!(f, "SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD"),
            1000214000 => write!(f, "IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA"),
            1000215000 => write!(
                f,
                "PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR"
            ),
            1000217000 => write!(f, "METAL_SURFACE_CREATE_INFO_EXT"),
            1000218000 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT"),
            1000218001 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT"),
            1000218002 => write!(f, "RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT"),
            1000225000 => write!(f, "PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT"),
            1000225001 => write!(
                f,
                "PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT"
            ),
            1000225002 => write!(f, "PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT"),
            1000226000 => write!(f, "FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR"),
            1000226001 => write!(f, "PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR"),
            1000226002 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR"),
            1000226003 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR"),
            1000226004 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR"),
            1000227000 => write!(f, "PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD"),
            1000229000 => write!(f, "PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD"),
            1000234000 => write!(f, "PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT"),
            1000237000 => write!(f, "PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT"),
            1000238000 => write!(f, "PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT"),
            1000238001 => write!(f, "MEMORY_PRIORITY_ALLOCATE_INFO_EXT"),
            1000239000 => write!(f, "SURFACE_PROTECTED_CAPABILITIES_KHR"),
            1000240000 => write!(
                f,
                "PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV"
            ),
            1000244000 => write!(f, "PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT"),
            1000244002 => write!(f, "BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT"),
            1000245000 => write!(f, "PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT"),
            1000247000 => write!(f, "VALIDATION_FEATURES_EXT"),
            1000248000 => write!(f, "PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR"),
            1000249000 => write!(f, "PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV"),
            1000249001 => write!(f, "COOPERATIVE_MATRIX_PROPERTIES_NV"),
            1000249002 => write!(f, "PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV"),
            1000250000 => write!(f, "PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV"),
            1000250001 => write!(f, "PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV"),
            1000250002 => write!(f, "FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV"),
            1000251000 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT"),
            1000252000 => write!(f, "PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT"),
            1000254000 => write!(f, "PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT"),
            1000254001 => write!(
                f,
                "PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT"
            ),
            1000254002 => write!(f, "PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT"),
            1000255000 => write!(f, "SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT"),
            1000255002 => write!(f, "SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT"),
            1000255001 => write!(f, "SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT"),
            1000256000 => write!(f, "HEADLESS_SURFACE_CREATE_INFO_EXT"),
            1000259000 => write!(f, "PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT"),
            1000259001 => write!(f, "PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT"),
            1000259002 => write!(f, "PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT"),
            1000260000 => write!(f, "PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT"),
            1000265000 => write!(f, "PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT"),
            1000267000 => write!(f, "PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT"),
            1000269000 => write!(
                f,
                "PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR"
            ),
            1000269001 => write!(f, "PIPELINE_INFO_KHR"),
            1000269002 => write!(f, "PIPELINE_EXECUTABLE_PROPERTIES_KHR"),
            1000269003 => write!(f, "PIPELINE_EXECUTABLE_INFO_KHR"),
            1000269004 => write!(f, "PIPELINE_EXECUTABLE_STATISTIC_KHR"),
            1000269005 => write!(f, "PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR"),
            1000273000 => write!(f, "PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT"),
            1000276000 => write!(
                f,
                "PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT"
            ),
            1000277000 => write!(f, "PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV"),
            1000277001 => write!(f, "GRAPHICS_SHADER_GROUP_CREATE_INFO_NV"),
            1000277002 => write!(f, "GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV"),
            1000277003 => write!(f, "INDIRECT_COMMANDS_LAYOUT_TOKEN_NV"),
            1000277004 => write!(f, "INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV"),
            1000277005 => write!(f, "GENERATED_COMMANDS_INFO_NV"),
            1000277006 => write!(f, "GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV"),
            1000277007 => write!(f, "PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV"),
            1000278000 => write!(f, "PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV"),
            1000278001 => write!(f, "COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV"),
            1000280000 => write!(f, "PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR"),
            1000280001 => write!(
                f,
                "PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR"
            ),
            1000281000 => write!(f, "PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT"),
            1000281001 => write!(f, "PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT"),
            1000282000 => write!(
                f,
                "COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM"
            ),
            1000282001 => write!(f, "RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM"),
            1000284000 => write!(f, "PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT"),
            1000284001 => write!(f, "DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT"),
            1000284002 => write!(f, "DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT"),
            1000286000 => write!(f, "PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT"),
            1000286001 => write!(f, "PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT"),
            1000287000 => write!(f, "SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT"),
            1000287001 => write!(f, "PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT"),
            1000287002 => write!(f, "PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT"),
            1000290000 => write!(f, "PIPELINE_LIBRARY_CREATE_INFO_KHR"),
            1000294000 => write!(f, "PRESENT_ID_KHR"),
            1000294001 => write!(f, "PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR"),
            1000295000 => write!(f, "PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT"),
            1000295001 => write!(f, "DEVICE_PRIVATE_DATA_CREATE_INFO_EXT"),
            1000295002 => write!(f, "PRIVATE_DATA_SLOT_CREATE_INFO_EXT"),
            1000297000 => write!(
                f,
                "PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT"
            ),
            1000300000 => write!(f, "PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV"),
            1000300001 => write!(f, "DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV"),
            1000314000 => write!(f, "MEMORY_BARRIER_2_KHR"),
            1000314001 => write!(f, "BUFFER_MEMORY_BARRIER_2_KHR"),
            1000314002 => write!(f, "IMAGE_MEMORY_BARRIER_2_KHR"),
            1000314003 => write!(f, "DEPENDENCY_INFO_KHR"),
            1000314004 => write!(f, "SUBMIT_INFO_2_KHR"),
            1000314005 => write!(f, "SEMAPHORE_SUBMIT_INFO_KHR"),
            1000314006 => write!(f, "COMMAND_BUFFER_SUBMIT_INFO_KHR"),
            1000314007 => write!(f, "PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR"),
            1000314008 => write!(f, "QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV"),
            1000314009 => write!(f, "CHECKPOINT_DATA_2_NV"),
            1000323000 => write!(
                f,
                "PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR"
            ),
            1000325000 => write!(
                f,
                "PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR"
            ),
            1000326000 => write!(
                f,
                "PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV"
            ),
            1000326001 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV"),
            1000326002 => write!(
                f,
                "PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV"
            ),
            1000327000 => write!(
                f,
                "ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV"
            ),
            1000327001 => write!(f, "PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV"),
            1000327002 => write!(f, "ACCELERATION_STRUCTURE_MOTION_INFO_NV"),
            1000330000 => write!(f, "PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT"),
            1000332000 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT"),
            1000332001 => write!(f, "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT"),
            1000333000 => write!(f, "COPY_COMMAND_TRANSFORM_INFO_QCOM"),
            1000335000 => write!(f, "PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT"),
            1000336000 => write!(
                f,
                "PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR"
            ),
            1000337000 => write!(f, "COPY_BUFFER_INFO_2_KHR"),
            1000337001 => write!(f, "COPY_IMAGE_INFO_2_KHR"),
            1000337002 => write!(f, "COPY_BUFFER_TO_IMAGE_INFO_2_KHR"),
            1000337003 => write!(f, "COPY_IMAGE_TO_BUFFER_INFO_2_KHR"),
            1000337004 => write!(f, "BLIT_IMAGE_INFO_2_KHR"),
            1000337005 => write!(f, "RESOLVE_IMAGE_INFO_2_KHR"),
            1000337006 => write!(f, "BUFFER_COPY_2_KHR"),
            1000337007 => write!(f, "IMAGE_COPY_2_KHR"),
            1000337008 => write!(f, "IMAGE_BLIT_2_KHR"),
            1000337009 => write!(f, "BUFFER_IMAGE_COPY_2_KHR"),
            1000337010 => write!(f, "IMAGE_RESOLVE_2_KHR"),
            1000340000 => write!(f, "PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT"),
            1000342000 => write!(
                f,
                "PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_ARM"
            ),
            1000344000 => write!(f, "PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT"),
            1000346000 => write!(f, "DIRECTFB_SURFACE_CREATE_INFO_EXT"),
            1000351000 => write!(f, "PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE"),
            1000351002 => write!(f, "MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE"),
            1000352000 => write!(f, "PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT"),
            1000352001 => write!(f, "VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT"),
            1000352002 => write!(f, "VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT"),
            1000353000 => write!(f, "PHYSICAL_DEVICE_DRM_PROPERTIES_EXT"),
            1000355000 => write!(f, "PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT"),
            1000355001 => write!(f, "PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT"),
            1000356000 => write!(
                f,
                "PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT"
            ),
            1000360000 => write!(f, "FORMAT_PROPERTIES_3_KHR"),
            1000364000 => write!(f, "IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA"),
            1000364001 => write!(f, "MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA"),
            1000364002 => write!(f, "MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA"),
            1000365000 => write!(f, "IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA"),
            1000365001 => write!(f, "SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA"),
            1000366000 => write!(f, "BUFFER_COLLECTION_CREATE_INFO_FUCHSIA"),
            1000366001 => write!(f, "IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA"),
            1000366002 => write!(f, "BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA"),
            1000366003 => write!(f, "BUFFER_COLLECTION_PROPERTIES_FUCHSIA"),
            1000366004 => write!(f, "BUFFER_CONSTRAINTS_INFO_FUCHSIA"),
            1000366005 => write!(f, "BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA"),
            1000366006 => write!(f, "IMAGE_CONSTRAINTS_INFO_FUCHSIA"),
            1000366007 => write!(f, "IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA"),
            1000366008 => write!(f, "SYSMEM_COLOR_SPACE_FUCHSIA"),
            1000366009 => write!(f, "BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA"),
            1000369000 => write!(f, "SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI"),
            1000369001 => write!(f, "PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI"),
            1000369002 => write!(f, "PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI"),
            1000370000 => write!(f, "PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI"),
            1000371000 => write!(f, "MEMORY_GET_REMOTE_ADDRESS_INFO_NV"),
            1000371001 => write!(f, "PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV"),
            1000377000 => write!(f, "PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT"),
            1000378000 => write!(f, "SCREEN_SURFACE_CREATE_INFO_QNX"),
            1000381000 => write!(f, "PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT"),
            1000381001 => write!(f, "PIPELINE_COLOR_WRITE_CREATE_INFO_EXT"),
            1000388000 => write!(f, "PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT"),
            1000388001 => write!(f, "QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT"),
            1000391000 => write!(f, "PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT"),
            1000391001 => write!(f, "IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT"),
            1000392000 => write!(f, "PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT"),
            1000392001 => write!(f, "PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT"),
            1000411000 => write!(f, "PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT"),
            1000411001 => write!(f, "SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT"),
            1000412000 => write!(
                f,
                "PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT"
            ),
            1000413000 => write!(f, "PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR"),
            1000413001 => write!(f, "PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR"),
            1000413002 => write!(f, "DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR"),
            1000413003 => write!(f, "DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR"),
            1000425000 => write!(
                f,
                "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM"
            ),
            1000425001 => write!(
                f,
                "PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM"
            ),
            1000425002 => write!(f, "SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM"),
            1000430000 => write!(f, "PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassContents.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SubpassContents(i32);

impl SubpassContents {
    pub const INLINE: Self = Self(0);
    pub const SECONDARY_COMMAND_BUFFERS: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SubpassContents {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "INLINE"),
            1 => write!(f, "SECONDARY_COMMAND_BUFFERS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSystemAllocationScope.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct SystemAllocationScope(i32);

impl SystemAllocationScope {
    pub const COMMAND: Self = Self(0);
    pub const OBJECT: Self = Self(1);
    pub const CACHE: Self = Self(2);
    pub const DEVICE: Self = Self(3);
    pub const INSTANCE: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for SystemAllocationScope {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "COMMAND"),
            1 => write!(f, "OBJECT"),
            2 => write!(f, "CACHE"),
            3 => write!(f, "DEVICE"),
            4 => write!(f, "INSTANCE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTessellationDomainOrigin.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct TessellationDomainOrigin(i32);

impl TessellationDomainOrigin {
    pub const UPPER_LEFT: Self = Self(0);
    pub const LOWER_LEFT: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for TessellationDomainOrigin {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "UPPER_LEFT"),
            1 => write!(f, "LOWER_LEFT"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTimeDomainEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct TimeDomainEXT(i32);

impl TimeDomainEXT {
    pub const DEVICE: Self = Self(0);
    pub const CLOCK_MONOTONIC: Self = Self(1);
    pub const CLOCK_MONOTONIC_RAW: Self = Self(2);
    pub const QUERY_PERFORMANCE_COUNTER: Self = Self(3);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for TimeDomainEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "DEVICE"),
            1 => write!(f, "CLOCK_MONOTONIC"),
            2 => write!(f, "CLOCK_MONOTONIC_RAW"),
            3 => write!(f, "QUERY_PERFORMANCE_COUNTER"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCacheHeaderVersionEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ValidationCacheHeaderVersionEXT(i32);

impl ValidationCacheHeaderVersionEXT {
    pub const ONE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ValidationCacheHeaderVersionEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            1 => write!(f, "ONE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCheckEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ValidationCheckEXT(i32);

impl ValidationCheckEXT {
    pub const ALL: Self = Self(0);
    pub const SHADERS: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ValidationCheckEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ALL"),
            1 => write!(f, "SHADERS"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFeatureDisableEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ValidationFeatureDisableEXT(i32);

impl ValidationFeatureDisableEXT {
    pub const ALL: Self = Self(0);
    pub const SHADERS: Self = Self(1);
    pub const THREAD_SAFETY: Self = Self(2);
    pub const API_PARAMETERS: Self = Self(3);
    pub const OBJECT_LIFETIMES: Self = Self(4);
    pub const CORE_CHECKS: Self = Self(5);
    pub const UNIQUE_HANDLES: Self = Self(6);
    pub const SHADER_VALIDATION_CACHE: Self = Self(7);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ValidationFeatureDisableEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "ALL"),
            1 => write!(f, "SHADERS"),
            2 => write!(f, "THREAD_SAFETY"),
            3 => write!(f, "API_PARAMETERS"),
            4 => write!(f, "OBJECT_LIFETIMES"),
            5 => write!(f, "CORE_CHECKS"),
            6 => write!(f, "UNIQUE_HANDLES"),
            7 => write!(f, "SHADER_VALIDATION_CACHE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFeatureEnableEXT.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ValidationFeatureEnableEXT(i32);

impl ValidationFeatureEnableEXT {
    pub const GPU_ASSISTED: Self = Self(0);
    pub const GPU_ASSISTED_RESERVE_BINDING_SLOT: Self = Self(1);
    pub const BEST_PRACTICES: Self = Self(2);
    pub const DEBUG_PRINTF: Self = Self(3);
    pub const SYNCHRONIZATION_VALIDATION: Self = Self(4);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ValidationFeatureEnableEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "GPU_ASSISTED"),
            1 => write!(f, "GPU_ASSISTED_RESERVE_BINDING_SLOT"),
            2 => write!(f, "BEST_PRACTICES"),
            3 => write!(f, "DEBUG_PRINTF"),
            4 => write!(f, "SYNCHRONIZATION_VALIDATION"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVendorId.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct VendorId(i32);

impl VendorId {
    pub const VIV: Self = Self(65537);
    pub const VSI: Self = Self(65538);
    pub const KAZAN: Self = Self(65539);
    pub const CODEPLAY: Self = Self(65540);
    pub const MESA: Self = Self(65541);
    pub const POCL: Self = Self(65542);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for VendorId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            65537 => write!(f, "VIV"),
            65538 => write!(f, "VSI"),
            65539 => write!(f, "KAZAN"),
            65540 => write!(f, "CODEPLAY"),
            65541 => write!(f, "MESA"),
            65542 => write!(f, "POCL"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputRate.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct VertexInputRate(i32);

impl VertexInputRate {
    pub const VERTEX: Self = Self(0);
    pub const INSTANCE: Self = Self(1);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for VertexInputRate {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "VERTEX"),
            1 => write!(f, "INSTANCE"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViewportCoordinateSwizzleNV.html>
#[repr(transparent)]
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
pub struct ViewportCoordinateSwizzleNV(i32);

impl ViewportCoordinateSwizzleNV {
    pub const POSITIVE_X: Self = Self(0);
    pub const NEGATIVE_X: Self = Self(1);
    pub const POSITIVE_Y: Self = Self(2);
    pub const NEGATIVE_Y: Self = Self(3);
    pub const POSITIVE_Z: Self = Self(4);
    pub const NEGATIVE_Z: Self = Self(5);
    pub const POSITIVE_W: Self = Self(6);
    pub const NEGATIVE_W: Self = Self(7);

    /// Constructs an instance of this enum with the supplied underlying value.
    #[inline]
    pub const fn from_raw(value: i32) -> Self {
        Self(value)
    }

    /// Gets the underlying value for this enum instance.
    #[inline]
    pub const fn as_raw(self) -> i32 {
        self.0
    }
}

impl fmt::Debug for ViewportCoordinateSwizzleNV {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self.0 {
            0 => write!(f, "POSITIVE_X"),
            1 => write!(f, "NEGATIVE_X"),
            2 => write!(f, "POSITIVE_Y"),
            3 => write!(f, "NEGATIVE_Y"),
            4 => write!(f, "POSITIVE_Z"),
            5 => write!(f, "NEGATIVE_Z"),
            6 => write!(f, "POSITIVE_W"),
            7 => write!(f, "NEGATIVE_W"),
            _ => self.0.fmt(f),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureTypeNV.html>
pub type AccelerationStructureTypeNV = AccelerationStructureTypeKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkChromaLocationKHR.html>
pub type ChromaLocationKHR = ChromaLocation;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyAccelerationStructureModeNV.html>
pub type CopyAccelerationStructureModeNV = CopyAccelerationStructureModeKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateTypeKHR.html>
pub type DescriptorUpdateTemplateTypeKHR = DescriptorUpdateTemplateType;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDriverIdKHR.html>
pub type DriverIdKHR = DriverId;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryTypeNV.html>
pub type GeometryTypeNV = GeometryTypeKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPointClippingBehaviorKHR.html>
pub type PointClippingBehaviorKHR = PointClippingBehavior;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingShaderGroupTypeNV.html>
pub type RayTracingShaderGroupTypeNV = RayTracingShaderGroupTypeKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerReductionModeEXT.html>
pub type SamplerReductionModeEXT = SamplerReductionMode;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrModelConversionKHR.html>
pub type SamplerYcbcrModelConversionKHR = SamplerYcbcrModelConversion;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrRangeKHR.html>
pub type SamplerYcbcrRangeKHR = SamplerYcbcrRange;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreTypeKHR.html>
pub type SemaphoreTypeKHR = SemaphoreType;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderFloatControlsIndependenceKHR.html>
pub type ShaderFloatControlsIndependenceKHR = ShaderFloatControlsIndependence;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTessellationDomainOriginKHR.html>
pub type TessellationDomainOriginKHR = TessellationDomainOrigin;
