// SPDX-License-Identifier: Apache-2.0

// DO NOT EDIT.
//
// This file has been generated by the Kotlin project in the `generator`
// directory from a Vulkan API registry.

#![allow(
    non_camel_case_types,
    non_snake_case,
    clippy::missing_safety_doc,
    clippy::too_many_arguments,
    clippy::type_complexity,
    clippy::upper_case_acronyms
)]

use bitflags::bitflags;

use crate::{Flags, Flags64};

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AccelerationStructureCreateFlagsKHR: Flags {
        const DEVICE_ADDRESS_CAPTURE_REPLAY = 1;
        const MOTION_NV = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMotionInfoFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AccelerationStructureMotionInfoFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMotionInstanceFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AccelerationStructureMotionInstanceFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccessFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AccessFlags: Flags {
        const INDIRECT_COMMAND_READ = 1;
        const INDEX_READ = 1 << 1;
        const VERTEX_ATTRIBUTE_READ = 1 << 2;
        const UNIFORM_READ = 1 << 3;
        const INPUT_ATTACHMENT_READ = 1 << 4;
        const SHADER_READ = 1 << 5;
        const SHADER_WRITE = 1 << 6;
        const COLOR_ATTACHMENT_READ = 1 << 7;
        const COLOR_ATTACHMENT_WRITE = 1 << 8;
        const DEPTH_STENCIL_ATTACHMENT_READ = 1 << 9;
        const DEPTH_STENCIL_ATTACHMENT_WRITE = 1 << 10;
        const TRANSFER_READ = 1 << 11;
        const TRANSFER_WRITE = 1 << 12;
        const HOST_READ = 1 << 13;
        const HOST_WRITE = 1 << 14;
        const MEMORY_READ = 1 << 15;
        const MEMORY_WRITE = 1 << 16;
        const COMMAND_PREPROCESS_READ_NV = 1 << 17;
        const COMMAND_PREPROCESS_WRITE_NV = 1 << 18;
        const COLOR_ATTACHMENT_READ_NONCOHERENT_EXT = 1 << 19;
        const CONDITIONAL_RENDERING_READ_EXT = 1 << 20;
        const ACCELERATION_STRUCTURE_READ_KHR = 1 << 21;
        const ACCELERATION_STRUCTURE_WRITE_KHR = 1 << 22;
        const FRAGMENT_SHADING_RATE_ATTACHMENT_READ_KHR = 1 << 23;
        const FRAGMENT_DENSITY_MAP_READ_EXT = 1 << 24;
        const TRANSFORM_FEEDBACK_WRITE_EXT = 1 << 25;
        const TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 1 << 26;
        const TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT = 1 << 27;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccessFlags2KHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AccessFlags2KHR: Flags64 {
        const NONE = 0;
        const INDIRECT_COMMAND_READ = 1;
        const INDEX_READ = 1 << 1;
        const VERTEX_ATTRIBUTE_READ = 1 << 2;
        const UNIFORM_READ = 1 << 3;
        const INPUT_ATTACHMENT_READ = 1 << 4;
        const SHADER_READ = 1 << 5;
        const SHADER_WRITE = 1 << 6;
        const COLOR_ATTACHMENT_READ = 1 << 7;
        const COLOR_ATTACHMENT_WRITE = 1 << 8;
        const DEPTH_STENCIL_ATTACHMENT_READ = 1 << 9;
        const DEPTH_STENCIL_ATTACHMENT_WRITE = 1 << 10;
        const TRANSFER_READ = 1 << 11;
        const TRANSFER_WRITE = 1 << 12;
        const HOST_READ = 1 << 13;
        const HOST_WRITE = 1 << 14;
        const MEMORY_READ = 1 << 15;
        const MEMORY_WRITE = 1 << 16;
        const COMMAND_PREPROCESS_READ_NV = 1 << 17;
        const COMMAND_PREPROCESS_WRITE_NV = 1 << 18;
        const COLOR_ATTACHMENT_READ_NONCOHERENT_EXT = 1 << 19;
        const CONDITIONAL_RENDERING_READ_EXT = 1 << 20;
        const ACCELERATION_STRUCTURE_READ = 1 << 21;
        const ACCELERATION_STRUCTURE_WRITE = 1 << 22;
        const FRAGMENT_SHADING_RATE_ATTACHMENT_READ = 1 << 23;
        const FRAGMENT_DENSITY_MAP_READ_EXT = 1 << 24;
        const TRANSFORM_FEEDBACK_WRITE_EXT = 1 << 25;
        const TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 1 << 26;
        const TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT = 1 << 27;
        const SHADER_SAMPLED_READ = 1 << 32;
        const SHADER_STORAGE_READ = 1 << 33;
        const SHADER_STORAGE_WRITE = 1 << 34;
        const INVOCATION_MASK_READ_HUAWEI = 1 << 39;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAcquireProfilingLockFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AcquireProfilingLockFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidSurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AndroidSurfaceCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescriptionFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct AttachmentDescriptionFlags: Flags {
        const MAY_ALIAS = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct BufferCreateFlags: Flags {
        const SPARSE_BINDING = 1;
        const SPARSE_RESIDENCY = 1 << 1;
        const SPARSE_ALIASED = 1 << 2;
        const PROTECTED = 1 << 3;
        const DEVICE_ADDRESS_CAPTURE_REPLAY = 1 << 4;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferUsageFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct BufferUsageFlags: Flags {
        const TRANSFER_SRC = 1;
        const TRANSFER_DST = 1 << 1;
        const UNIFORM_TEXEL_BUFFER = 1 << 2;
        const STORAGE_TEXEL_BUFFER = 1 << 3;
        const UNIFORM_BUFFER = 1 << 4;
        const STORAGE_BUFFER = 1 << 5;
        const INDEX_BUFFER = 1 << 6;
        const VERTEX_BUFFER = 1 << 7;
        const INDIRECT_BUFFER = 1 << 8;
        const CONDITIONAL_RENDERING_EXT = 1 << 9;
        const SHADER_BINDING_TABLE_KHR = 1 << 10;
        const TRANSFORM_FEEDBACK_BUFFER_EXT = 1 << 11;
        const TRANSFORM_FEEDBACK_COUNTER_BUFFER_EXT = 1 << 12;
        const SHADER_DEVICE_ADDRESS = 1 << 17;
        const ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_KHR = 1 << 19;
        const ACCELERATION_STRUCTURE_STORAGE_KHR = 1 << 20;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferViewCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct BufferViewCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBuildAccelerationStructureFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct BuildAccelerationStructureFlagsKHR: Flags {
        const ALLOW_UPDATE = 1;
        const ALLOW_COMPACTION = 1 << 1;
        const PREFER_FAST_TRACE = 1 << 2;
        const PREFER_FAST_BUILD = 1 << 3;
        const LOW_MEMORY = 1 << 4;
        const MOTION_NV = 1 << 5;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkColorComponentFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ColorComponentFlags: Flags {
        const R = 1;
        const G = 1 << 1;
        const B = 1 << 2;
        const A = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferResetFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CommandBufferResetFlags: Flags {
        const RELEASE_RESOURCES = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferUsageFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CommandBufferUsageFlags: Flags {
        const ONE_TIME_SUBMIT = 1;
        const RENDER_PASS_CONTINUE = 1 << 1;
        const SIMULTANEOUS_USE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CommandPoolCreateFlags: Flags {
        const TRANSIENT = 1;
        const RESET_COMMAND_BUFFER = 1 << 1;
        const PROTECTED = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolResetFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CommandPoolResetFlags: Flags {
        const RELEASE_RESOURCES = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolTrimFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CommandPoolTrimFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCompositeAlphaFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CompositeAlphaFlagsKHR: Flags {
        const OPAQUE = 1;
        const PRE_MULTIPLIED = 1 << 1;
        const POST_MULTIPLIED = 1 << 2;
        const INHERIT = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConditionalRenderingFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ConditionalRenderingFlagsEXT: Flags {
        const INVERTED = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCullModeFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct CullModeFlags: Flags {
        const NONE = 0;
        const FRONT = 1;
        const BACK = 1 << 1;
        const FRONT_AND_BACK = Self::FRONT.bits | Self::BACK.bits;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugReportFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DebugReportFlagsEXT: Flags {
        const INFORMATION = 1;
        const WARNING = 1 << 1;
        const PERFORMANCE_WARNING = 1 << 2;
        const ERROR = 1 << 3;
        const DEBUG = 1 << 4;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessageSeverityFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DebugUtilsMessageSeverityFlagsEXT: Flags {
        const VERBOSE = 1;
        const INFO = 1 << 4;
        const WARNING = 1 << 8;
        const ERROR = 1 << 12;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessageTypeFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DebugUtilsMessageTypeFlagsEXT: Flags {
        const GENERAL = 1;
        const VALIDATION = 1 << 1;
        const PERFORMANCE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCallbackDataFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DebugUtilsMessengerCallbackDataFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DebugUtilsMessengerCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDependencyFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DependencyFlags: Flags {
        const BY_REGION = 1;
        const VIEW_LOCAL = 1 << 1;
        const DEVICE_GROUP = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorBindingFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DescriptorBindingFlags: Flags {
        const UPDATE_AFTER_BIND = 1;
        const UPDATE_UNUSED_WHILE_PENDING = 1 << 1;
        const PARTIALLY_BOUND = 1 << 2;
        const VARIABLE_DESCRIPTOR_COUNT = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DescriptorPoolCreateFlags: Flags {
        const FREE_DESCRIPTOR_SET = 1;
        const UPDATE_AFTER_BIND = 1 << 1;
        const HOST_ONLY_VALVE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolResetFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DescriptorPoolResetFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DescriptorSetLayoutCreateFlags: Flags {
        const PUSH_DESCRIPTOR_KHR = 1;
        const UPDATE_AFTER_BIND_POOL = 1 << 1;
        const HOST_ONLY_POOL_VALVE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DescriptorUpdateTemplateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DeviceCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceDiagnosticsConfigFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DeviceDiagnosticsConfigFlagsNV: Flags {
        const ENABLE_SHADER_DEBUG_INFO = 1;
        const ENABLE_RESOURCE_TRACKING = 1 << 1;
        const ENABLE_AUTOMATIC_CHECKPOINTS = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupPresentModeFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DeviceGroupPresentModeFlagsKHR: Flags {
        const LOCAL = 1;
        const REMOTE = 1 << 1;
        const SUM = 1 << 2;
        const LOCAL_MULTI_DEVICE = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryReportFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DeviceMemoryReportFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceQueueCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DeviceQueueCreateFlags: Flags {
        const PROTECTED = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDirectFBSurfaceCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DirectFBSurfaceCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DisplayModeCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneAlphaFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DisplayPlaneAlphaFlagsKHR: Flags {
        const OPAQUE = 1;
        const GLOBAL = 1 << 1;
        const PER_PIXEL = 1 << 2;
        const PER_PIXEL_PREMULTIPLIED = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplaySurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct DisplaySurfaceCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkEventCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct EventCreateFlags: Flags {
        const DEVICE_ONLY_KHR = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalFenceFeatureFlags: Flags {
        const EXPORTABLE = 1;
        const IMPORTABLE = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceHandleTypeFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalFenceHandleTypeFlags: Flags {
        const OPAQUE_FD = 1;
        const OPAQUE_WIN32 = 1 << 1;
        const OPAQUE_WIN32_KMT = 1 << 2;
        const SYNC_FD = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalMemoryFeatureFlags: Flags {
        const DEDICATED_ONLY = 1;
        const EXPORTABLE = 1 << 1;
        const IMPORTABLE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryFeatureFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalMemoryFeatureFlagsNV: Flags {
        const DEDICATED_ONLY = 1;
        const EXPORTABLE = 1 << 1;
        const IMPORTABLE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryHandleTypeFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalMemoryHandleTypeFlags: Flags {
        const OPAQUE_FD = 1;
        const OPAQUE_WIN32 = 1 << 1;
        const OPAQUE_WIN32_KMT = 1 << 2;
        const D3D11_TEXTURE = 1 << 3;
        const D3D11_TEXTURE_KMT = 1 << 4;
        const D3D12_HEAP = 1 << 5;
        const D3D12_RESOURCE = 1 << 6;
        const HOST_ALLOCATION_EXT = 1 << 7;
        const HOST_MAPPED_FOREIGN_MEMORY_EXT = 1 << 8;
        const DMA_BUF_EXT = 1 << 9;
        const ANDROID_HARDWARE_BUFFER_ANDROID = 1 << 10;
        const ZIRCON_VMO_FUCHSIA = 1 << 11;
        const RDMA_ADDRESS_NV = 1 << 12;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryHandleTypeFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalMemoryHandleTypeFlagsNV: Flags {
        const OPAQUE_WIN32 = 1;
        const OPAQUE_WIN32_KMT = 1 << 1;
        const D3D11_IMAGE = 1 << 2;
        const D3D11_IMAGE_KMT = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalSemaphoreFeatureFlags: Flags {
        const EXPORTABLE = 1;
        const IMPORTABLE = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreHandleTypeFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ExternalSemaphoreHandleTypeFlags: Flags {
        const OPAQUE_FD = 1;
        const OPAQUE_WIN32 = 1 << 1;
        const OPAQUE_WIN32_KMT = 1 << 2;
        const D3D12_FENCE = 1 << 3;
        const SYNC_FD = 1 << 4;
        const ZIRCON_EVENT_FUCHSIA = 1 << 7;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct FenceCreateFlags: Flags {
        const SIGNALED = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceImportFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct FenceImportFlags: Flags {
        const TEMPORARY = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct FormatFeatureFlags: Flags {
        const SAMPLED_IMAGE = 1;
        const STORAGE_IMAGE = 1 << 1;
        const STORAGE_IMAGE_ATOMIC = 1 << 2;
        const UNIFORM_TEXEL_BUFFER = 1 << 3;
        const STORAGE_TEXEL_BUFFER = 1 << 4;
        const STORAGE_TEXEL_BUFFER_ATOMIC = 1 << 5;
        const VERTEX_BUFFER = 1 << 6;
        const COLOR_ATTACHMENT = 1 << 7;
        const COLOR_ATTACHMENT_BLEND = 1 << 8;
        const DEPTH_STENCIL_ATTACHMENT = 1 << 9;
        const BLIT_SRC = 1 << 10;
        const BLIT_DST = 1 << 11;
        const SAMPLED_IMAGE_FILTER_LINEAR = 1 << 12;
        const SAMPLED_IMAGE_FILTER_CUBIC_IMG = 1 << 13;
        const TRANSFER_SRC = 1 << 14;
        const TRANSFER_DST = 1 << 15;
        const SAMPLED_IMAGE_FILTER_MINMAX = 1 << 16;
        const MIDPOINT_CHROMA_SAMPLES = 1 << 17;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER = 1 << 18;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER = 1 << 19;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT = 1 << 20;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE = 1 << 21;
        const DISJOINT = 1 << 22;
        const COSITED_CHROMA_SAMPLES = 1 << 23;
        const FRAGMENT_DENSITY_MAP_EXT = 1 << 24;
        const ACCELERATION_STRUCTURE_VERTEX_BUFFER_KHR = 1 << 29;
        const FRAGMENT_SHADING_RATE_ATTACHMENT_KHR = 1 << 30;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatFeatureFlags2KHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct FormatFeatureFlags2KHR: Flags64 {
        const SAMPLED_IMAGE = 1;
        const STORAGE_IMAGE = 1 << 1;
        const STORAGE_IMAGE_ATOMIC = 1 << 2;
        const UNIFORM_TEXEL_BUFFER = 1 << 3;
        const STORAGE_TEXEL_BUFFER = 1 << 4;
        const STORAGE_TEXEL_BUFFER_ATOMIC = 1 << 5;
        const VERTEX_BUFFER = 1 << 6;
        const COLOR_ATTACHMENT = 1 << 7;
        const COLOR_ATTACHMENT_BLEND = 1 << 8;
        const DEPTH_STENCIL_ATTACHMENT = 1 << 9;
        const BLIT_SRC = 1 << 10;
        const BLIT_DST = 1 << 11;
        const SAMPLED_IMAGE_FILTER_LINEAR = 1 << 12;
        const SAMPLED_IMAGE_FILTER_CUBIC_EXT = 1 << 13;
        const TRANSFER_SRC = 1 << 14;
        const TRANSFER_DST = 1 << 15;
        const SAMPLED_IMAGE_FILTER_MINMAX = 1 << 16;
        const MIDPOINT_CHROMA_SAMPLES = 1 << 17;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER = 1 << 18;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER = 1 << 19;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT = 1 << 20;
        const SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE = 1 << 21;
        const DISJOINT = 1 << 22;
        const COSITED_CHROMA_SAMPLES = 1 << 23;
        const FRAGMENT_DENSITY_MAP_EXT = 1 << 24;
        const ACCELERATION_STRUCTURE_VERTEX_BUFFER = 1 << 29;
        const FRAGMENT_SHADING_RATE_ATTACHMENT = 1 << 30;
        const STORAGE_READ_WITHOUT_FORMAT = 1 << 31;
        const STORAGE_WRITE_WITHOUT_FORMAT = 1 << 32;
        const SAMPLED_IMAGE_DEPTH_COMPARISON = 1 << 33;
        const LINEAR_COLOR_ATTACHMENT_NV = 1 << 38;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct FramebufferCreateFlags: Flags {
        const IMAGELESS = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct GeometryFlagsKHR: Flags {
        const OPAQUE = 1;
        const NO_DUPLICATE_ANY_HIT_INVOCATION = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryInstanceFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct GeometryInstanceFlagsKHR: Flags {
        const TRIANGLE_FACING_CULL_DISABLE = 1;
        const TRIANGLE_FLIP_FACING = 1 << 1;
        const FORCE_OPAQUE = 1 << 2;
        const FORCE_NO_OPAQUE = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkHeadlessSurfaceCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct HeadlessSurfaceCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIOSSurfaceCreateFlagsMVK.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct IOSSurfaceCreateFlagsMVK: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageAspectFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageAspectFlags: Flags {
        const COLOR = 1;
        const DEPTH = 1 << 1;
        const STENCIL = 1 << 2;
        const METADATA = 1 << 3;
        const PLANE_0 = 1 << 4;
        const PLANE_1 = 1 << 5;
        const PLANE_2 = 1 << 6;
        const MEMORY_PLANE_0_EXT = 1 << 7;
        const MEMORY_PLANE_1_EXT = 1 << 8;
        const MEMORY_PLANE_2_EXT = 1 << 9;
        const MEMORY_PLANE_3_EXT = 1 << 10;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageConstraintsInfoFlagsFUCHSIA.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageConstraintsInfoFlagsFUCHSIA: Flags {
        const CPU_READ_RARELY = 1;
        const CPU_READ_OFTEN = 1 << 1;
        const CPU_WRITE_RARELY = 1 << 2;
        const CPU_WRITE_OFTEN = 1 << 3;
        const PROTECTED_OPTIONAL = 1 << 4;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageCreateFlags: Flags {
        const SPARSE_BINDING = 1;
        const SPARSE_RESIDENCY = 1 << 1;
        const SPARSE_ALIASED = 1 << 2;
        const MUTABLE_FORMAT = 1 << 3;
        const CUBE_COMPATIBLE = 1 << 4;
        const _2D_ARRAY_COMPATIBLE = 1 << 5;
        const SPLIT_INSTANCE_BIND_REGIONS = 1 << 6;
        const BLOCK_TEXEL_VIEW_COMPATIBLE = 1 << 7;
        const EXTENDED_USAGE = 1 << 8;
        const DISJOINT = 1 << 9;
        const ALIAS = 1 << 10;
        const PROTECTED = 1 << 11;
        const SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_EXT = 1 << 12;
        const CORNER_SAMPLED_NV = 1 << 13;
        const SUBSAMPLED_EXT = 1 << 14;
        const FRAGMENT_DENSITY_MAP_OFFSET_QCOM = 1 << 15;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatConstraintsFlagsFUCHSIA.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageFormatConstraintsFlagsFUCHSIA: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePipeSurfaceCreateFlagsFUCHSIA.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImagePipeSurfaceCreateFlagsFUCHSIA: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageUsageFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageUsageFlags: Flags {
        const TRANSFER_SRC = 1;
        const TRANSFER_DST = 1 << 1;
        const SAMPLED = 1 << 2;
        const STORAGE = 1 << 3;
        const COLOR_ATTACHMENT = 1 << 4;
        const DEPTH_STENCIL_ATTACHMENT = 1 << 5;
        const TRANSIENT_ATTACHMENT = 1 << 6;
        const INPUT_ATTACHMENT = 1 << 7;
        const FRAGMENT_SHADING_RATE_ATTACHMENT_KHR = 1 << 8;
        const FRAGMENT_DENSITY_MAP_EXT = 1 << 9;
        const INVOCATION_MASK_HUAWEI = 1 << 18;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ImageViewCreateFlags: Flags {
        const FRAGMENT_DENSITY_MAP_DYNAMIC_EXT = 1;
        const FRAGMENT_DENSITY_MAP_DEFERRED_EXT = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutUsageFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct IndirectCommandsLayoutUsageFlagsNV: Flags {
        const EXPLICIT_PREPROCESS = 1;
        const INDEXED_SEQUENCES = 1 << 1;
        const UNORDERED_SEQUENCES = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectStateFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct IndirectStateFlagsNV: Flags {
        const FLAG_FRONTFACE = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInstanceCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct InstanceCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMacOSSurfaceCreateFlagsMVK.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MacOSSurfaceCreateFlagsMVK: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MemoryAllocateFlags: Flags {
        const DEVICE_MASK = 1;
        const DEVICE_ADDRESS = 1 << 1;
        const DEVICE_ADDRESS_CAPTURE_REPLAY = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryHeapFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MemoryHeapFlags: Flags {
        const DEVICE_LOCAL = 1;
        const MULTI_INSTANCE = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryMapFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MemoryMapFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryPropertyFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MemoryPropertyFlags: Flags {
        const DEVICE_LOCAL = 1;
        const HOST_VISIBLE = 1 << 1;
        const HOST_COHERENT = 1 << 2;
        const HOST_CACHED = 1 << 3;
        const LAZILY_ALLOCATED = 1 << 4;
        const PROTECTED = 1 << 5;
        const DEVICE_COHERENT_AMD = 1 << 6;
        const DEVICE_UNCACHED_AMD = 1 << 7;
        const RDMA_CAPABLE_NV = 1 << 8;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMetalSurfaceCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct MetalSurfaceCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPeerMemoryFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PeerMemoryFeatureFlags: Flags {
        const COPY_SRC = 1;
        const COPY_DST = 1 << 1;
        const GENERIC_SRC = 1 << 2;
        const GENERIC_DST = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterDescriptionFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PerformanceCounterDescriptionFlagsKHR: Flags {
        const PERFORMANCE_IMPACTING = 1;
        const CONCURRENTLY_IMPACTED = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCacheCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCacheCreateFlags: Flags {
        const EXTERNALLY_SYNCHRONIZED_EXT = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineColorBlendStateCreateFlags: Flags {
        const RASTERIZATION_ORDER_ATTACHMENT_ACCESS_ARM = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCompilerControlFlagsAMD.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCompilerControlFlagsAMD: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageModulationStateCreateFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCoverageModulationStateCreateFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageReductionStateCreateFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCoverageReductionStateCreateFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageToColorStateCreateFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCoverageToColorStateCreateFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCreateFlags: Flags {
        const DISABLE_OPTIMIZATION = 1;
        const ALLOW_DERIVATIVES = 1 << 1;
        const DERIVATIVE = 1 << 2;
        const VIEW_INDEX_FROM_DEVICE_INDEX = 1 << 3;
        const DISPATCH_BASE = 1 << 4;
        const DEFER_COMPILE_NV = 1 << 5;
        const CAPTURE_STATISTICS_KHR = 1 << 6;
        const CAPTURE_INTERNAL_REPRESENTATIONS_KHR = 1 << 7;
        const FAIL_ON_PIPELINE_COMPILE_REQUIRED_EXT = 1 << 8;
        const EARLY_RETURN_ON_FAILURE_EXT = 1 << 9;
        const LIBRARY_KHR = 1 << 11;
        const RAY_TRACING_SKIP_TRIANGLES_KHR = 1 << 12;
        const RAY_TRACING_SKIP_AABBS_KHR = 1 << 13;
        const RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_KHR = 1 << 14;
        const RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_KHR = 1 << 15;
        const RAY_TRACING_NO_NULL_MISS_SHADERS_KHR = 1 << 16;
        const RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_KHR = 1 << 17;
        const INDIRECT_BINDABLE_NV = 1 << 18;
        const RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_KHR = 1 << 19;
        const RAY_TRACING_ALLOW_MOTION_NV = 1 << 20;
        const RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_KHR = 1 << 21;
        const RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_EXT = 1 << 22;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCreationFeedbackFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineCreationFeedbackFlagsEXT: Flags {
        const VALID = 1;
        const APPLICATION_PIPELINE_CACHE_HIT = 1 << 1;
        const BASE_PIPELINE_ACCELERATION = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDepthStencilStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineDepthStencilStateCreateFlags: Flags {
        const RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_ARM = 1;
        const RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_ARM = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDiscardRectangleStateCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineDiscardRectangleStateCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDynamicStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineDynamicStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineInputAssemblyStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineInputAssemblyStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLayoutCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineLayoutCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineMultisampleStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineMultisampleStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationConservativeStateCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineRasterizationConservativeStateCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationDepthClipStateCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineRasterizationDepthClipStateCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineRasterizationStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateStreamCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineRasterizationStateStreamCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineShaderStageCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineShaderStageCreateFlags: Flags {
        const ALLOW_VARYING_SUBGROUP_SIZE_EXT = 1;
        const REQUIRE_FULL_SUBGROUPS_EXT = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineStageFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineStageFlags: Flags {
        const TOP_OF_PIPE = 1;
        const DRAW_INDIRECT = 1 << 1;
        const VERTEX_INPUT = 1 << 2;
        const VERTEX_SHADER = 1 << 3;
        const TESSELLATION_CONTROL_SHADER = 1 << 4;
        const TESSELLATION_EVALUATION_SHADER = 1 << 5;
        const GEOMETRY_SHADER = 1 << 6;
        const FRAGMENT_SHADER = 1 << 7;
        const EARLY_FRAGMENT_TESTS = 1 << 8;
        const LATE_FRAGMENT_TESTS = 1 << 9;
        const COLOR_ATTACHMENT_OUTPUT = 1 << 10;
        const COMPUTE_SHADER = 1 << 11;
        const TRANSFER = 1 << 12;
        const BOTTOM_OF_PIPE = 1 << 13;
        const HOST = 1 << 14;
        const ALL_GRAPHICS = 1 << 15;
        const ALL_COMMANDS = 1 << 16;
        const COMMAND_PREPROCESS_NV = 1 << 17;
        const CONDITIONAL_RENDERING_EXT = 1 << 18;
        const TASK_SHADER_NV = 1 << 19;
        const MESH_SHADER_NV = 1 << 20;
        const RAY_TRACING_SHADER_KHR = 1 << 21;
        const FRAGMENT_SHADING_RATE_ATTACHMENT_KHR = 1 << 22;
        const FRAGMENT_DENSITY_PROCESS_EXT = 1 << 23;
        const TRANSFORM_FEEDBACK_EXT = 1 << 24;
        const ACCELERATION_STRUCTURE_BUILD_KHR = 1 << 25;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineStageFlags2KHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineStageFlags2KHR: Flags64 {
        const NONE = 0;
        const TOP_OF_PIPE = 1;
        const DRAW_INDIRECT = 1 << 1;
        const VERTEX_INPUT = 1 << 2;
        const VERTEX_SHADER = 1 << 3;
        const TESSELLATION_CONTROL_SHADER = 1 << 4;
        const TESSELLATION_EVALUATION_SHADER = 1 << 5;
        const GEOMETRY_SHADER = 1 << 6;
        const FRAGMENT_SHADER = 1 << 7;
        const EARLY_FRAGMENT_TESTS = 1 << 8;
        const LATE_FRAGMENT_TESTS = 1 << 9;
        const COLOR_ATTACHMENT_OUTPUT = 1 << 10;
        const COMPUTE_SHADER = 1 << 11;
        const ALL_TRANSFER = 1 << 12;
        const BOTTOM_OF_PIPE = 1 << 13;
        const HOST = 1 << 14;
        const ALL_GRAPHICS = 1 << 15;
        const ALL_COMMANDS = 1 << 16;
        const COMMAND_PREPROCESS_NV = 1 << 17;
        const CONDITIONAL_RENDERING_EXT = 1 << 18;
        const TASK_SHADER_NV = 1 << 19;
        const MESH_SHADER_NV = 1 << 20;
        const RAY_TRACING_SHADER = 1 << 21;
        const FRAGMENT_SHADING_RATE_ATTACHMENT = 1 << 22;
        const FRAGMENT_DENSITY_PROCESS_EXT = 1 << 23;
        const TRANSFORM_FEEDBACK_EXT = 1 << 24;
        const ACCELERATION_STRUCTURE_BUILD = 1 << 25;
        const COPY = 1 << 32;
        const RESOLVE = 1 << 33;
        const BLIT = 1 << 34;
        const CLEAR = 1 << 35;
        const INDEX_INPUT = 1 << 36;
        const VERTEX_ATTRIBUTE_INPUT = 1 << 37;
        const PRE_RASTERIZATION_SHADERS = 1 << 38;
        const SUBPASS_SHADING_HUAWEI = 1 << 39;
        const INVOCATION_MASK_HUAWEI = 1 << 40;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineTessellationStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineVertexInputStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineVertexInputStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportStateCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineViewportStateCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportSwizzleStateCreateFlagsNV.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PipelineViewportSwizzleStateCreateFlagsNV: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPrivateDataSlotCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct PrivateDataSlotCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryControlFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct QueryControlFlags: Flags {
        const PRECISE = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPipelineStatisticFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct QueryPipelineStatisticFlags: Flags {
        const INPUT_ASSEMBLY_VERTICES = 1;
        const INPUT_ASSEMBLY_PRIMITIVES = 1 << 1;
        const VERTEX_SHADER_INVOCATIONS = 1 << 2;
        const GEOMETRY_SHADER_INVOCATIONS = 1 << 3;
        const GEOMETRY_SHADER_PRIMITIVES = 1 << 4;
        const CLIPPING_INVOCATIONS = 1 << 5;
        const CLIPPING_PRIMITIVES = 1 << 6;
        const FRAGMENT_SHADER_INVOCATIONS = 1 << 7;
        const TESSELLATION_CONTROL_SHADER_PATCHES = 1 << 8;
        const TESSELLATION_EVALUATION_SHADER_INVOCATIONS = 1 << 9;
        const COMPUTE_SHADER_INVOCATIONS = 1 << 10;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct QueryPoolCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryResultFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct QueryResultFlags: Flags {
        const _64 = 1;
        const WAIT = 1 << 1;
        const WITH_AVAILABILITY = 1 << 2;
        const PARTIAL = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct QueueFlags: Flags {
        const GRAPHICS = 1;
        const COMPUTE = 1 << 1;
        const TRANSFER = 1 << 2;
        const SPARSE_BINDING = 1 << 3;
        const PROTECTED = 1 << 4;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct RenderPassCreateFlags: Flags {
        const TRANSFORM_QCOM = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderingFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct RenderingFlagsKHR: Flags {
        const CONTENTS_SECONDARY_COMMAND_BUFFERS = 1;
        const SUSPENDING = 1 << 1;
        const RESUMING = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkResolveModeFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ResolveModeFlags: Flags {
        const NONE = 0;
        const SAMPLE_ZERO = 1;
        const AVERAGE = 1 << 1;
        const MIN = 1 << 2;
        const MAX = 1 << 3;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSampleCountFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SampleCountFlags: Flags {
        const _1 = 1;
        const _2 = 1 << 1;
        const _4 = 1 << 2;
        const _8 = 1 << 3;
        const _16 = 1 << 4;
        const _32 = 1 << 5;
        const _64 = 1 << 6;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SamplerCreateFlags: Flags {
        const SUBSAMPLED_EXT = 1;
        const SUBSAMPLED_COARSE_RECONSTRUCTION_EXT = 1 << 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkScreenSurfaceCreateFlagsQNX.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ScreenSurfaceCreateFlagsQNX: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SemaphoreCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreImportFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SemaphoreImportFlags: Flags {
        const TEMPORARY = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreWaitFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SemaphoreWaitFlags: Flags {
        const ANY = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderCorePropertiesFlagsAMD.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ShaderCorePropertiesFlagsAMD: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderModuleCreateFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ShaderModuleCreateFlags: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderStageFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ShaderStageFlags: Flags {
        const VERTEX = 1;
        const TESSELLATION_CONTROL = 1 << 1;
        const TESSELLATION_EVALUATION = 1 << 2;
        const GEOMETRY = 1 << 3;
        const FRAGMENT = 1 << 4;
        const ALL_GRAPHICS = Self::VERTEX.bits | Self::TESSELLATION_CONTROL.bits | Self::TESSELLATION_EVALUATION.bits | Self::GEOMETRY.bits | Self::FRAGMENT.bits;
        const COMPUTE = 1 << 5;
        const TASK_NV = 1 << 6;
        const MESH_NV = 1 << 7;
        const RAYGEN_KHR = 1 << 8;
        const ANY_HIT_KHR = 1 << 9;
        const CLOSEST_HIT_KHR = 1 << 10;
        const MISS_KHR = 1 << 11;
        const INTERSECTION_KHR = 1 << 12;
        const CALLABLE_KHR = 1 << 13;
        const SUBPASS_SHADING_HUAWEI = 1 << 14;
        const ALL = i32::MAX as u32;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SparseImageFormatFlags: Flags {
        const SINGLE_MIPTAIL = 1;
        const ALIGNED_MIP_SIZE = 1 << 1;
        const NONSTANDARD_BLOCK_SIZE = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseMemoryBindFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SparseMemoryBindFlags: Flags {
        const METADATA = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStencilFaceFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct StencilFaceFlags: Flags {
        const FRONT = 1;
        const BACK = 1 << 1;
        const FRONT_AND_BACK = Self::FRONT.bits | Self::BACK.bits;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStreamDescriptorSurfaceCreateFlagsGGP.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct StreamDescriptorSurfaceCreateFlagsGGP: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubgroupFeatureFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SubgroupFeatureFlags: Flags {
        const BASIC = 1;
        const VOTE = 1 << 1;
        const ARITHMETIC = 1 << 2;
        const BALLOT = 1 << 3;
        const SHUFFLE = 1 << 4;
        const SHUFFLE_RELATIVE = 1 << 5;
        const CLUSTERED = 1 << 6;
        const QUAD = 1 << 7;
        const PARTITIONED_NV = 1 << 8;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubmitFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SubmitFlagsKHR: Flags {
        const PROTECTED = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescriptionFlags.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SubpassDescriptionFlags: Flags {
        const PER_VIEW_ATTRIBUTES_NVX = 1;
        const PER_VIEW_POSITION_X_ONLY_NVX = 1 << 1;
        const FRAGMENT_REGION_QCOM = 1 << 2;
        const SHADER_RESOLVE_QCOM = 1 << 3;
        const RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_ARM = 1 << 4;
        const RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_ARM = 1 << 5;
        const RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_ARM = 1 << 6;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCounterFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SurfaceCounterFlagsEXT: Flags {
        const VBLANK = 1;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceTransformFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SurfaceTransformFlagsKHR: Flags {
        const IDENTITY = 1;
        const ROTATE_90 = 1 << 1;
        const ROTATE_180 = 1 << 2;
        const ROTATE_270 = 1 << 3;
        const HORIZONTAL_MIRROR = 1 << 4;
        const HORIZONTAL_MIRROR_ROTATE_90 = 1 << 5;
        const HORIZONTAL_MIRROR_ROTATE_180 = 1 << 6;
        const HORIZONTAL_MIRROR_ROTATE_270 = 1 << 7;
        const INHERIT = 1 << 8;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct SwapchainCreateFlagsKHR: Flags {
        const SPLIT_INSTANCE_BIND_REGIONS = 1;
        const PROTECTED = 1 << 1;
        const MUTABLE_FORMAT = 1 << 2;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkToolPurposeFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ToolPurposeFlagsEXT: Flags {
        const VALIDATION = 1;
        const PROFILING = 1 << 1;
        const TRACING = 1 << 2;
        const ADDITIONAL_FEATURES = 1 << 3;
        const MODIFYING_FEATURES = 1 << 4;
        const DEBUG_REPORTING = 1 << 5;
        const DEBUG_MARKERS = 1 << 6;
    }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCacheCreateFlagsEXT.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ValidationCacheCreateFlagsEXT: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViSurfaceCreateFlagsNN.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct ViSurfaceCreateFlagsNN: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWaylandSurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct WaylandSurfaceCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32SurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct Win32SurfaceCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXcbSurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct XcbSurfaceCreateFlagsKHR: Flags { }
}

bitflags! {
    /// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXlibSurfaceCreateFlagsKHR.html>
    #[repr(transparent)]
    #[derive(Default)]
    pub struct XlibSurfaceCreateFlagsKHR: Flags { }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBuildAccelerationStructureFlagsNV.html>
pub type BuildAccelerationStructureFlagsNV = BuildAccelerationStructureFlagsKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolTrimFlagsKHR.html>
pub type CommandPoolTrimFlagsKHR = CommandPoolTrimFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorBindingFlagsEXT.html>
pub type DescriptorBindingFlagsEXT = DescriptorBindingFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateCreateFlagsKHR.html>
pub type DescriptorUpdateTemplateCreateFlagsKHR = DescriptorUpdateTemplateCreateFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceFeatureFlagsKHR.html>
pub type ExternalFenceFeatureFlagsKHR = ExternalFenceFeatureFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceHandleTypeFlagsKHR.html>
pub type ExternalFenceHandleTypeFlagsKHR = ExternalFenceHandleTypeFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryFeatureFlagsKHR.html>
pub type ExternalMemoryFeatureFlagsKHR = ExternalMemoryFeatureFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryHandleTypeFlagsKHR.html>
pub type ExternalMemoryHandleTypeFlagsKHR = ExternalMemoryHandleTypeFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreFeatureFlagsKHR.html>
pub type ExternalSemaphoreFeatureFlagsKHR = ExternalSemaphoreFeatureFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreHandleTypeFlagsKHR.html>
pub type ExternalSemaphoreHandleTypeFlagsKHR = ExternalSemaphoreHandleTypeFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceImportFlagsKHR.html>
pub type FenceImportFlagsKHR = FenceImportFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryFlagsNV.html>
pub type GeometryFlagsNV = GeometryFlagsKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryInstanceFlagsNV.html>
pub type GeometryInstanceFlagsNV = GeometryInstanceFlagsKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsKHR.html>
pub type MemoryAllocateFlagsKHR = MemoryAllocateFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPeerMemoryFeatureFlagsKHR.html>
pub type PeerMemoryFeatureFlagsKHR = PeerMemoryFeatureFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkResolveModeFlagsKHR.html>
pub type ResolveModeFlagsKHR = ResolveModeFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreImportFlagsKHR.html>
pub type SemaphoreImportFlagsKHR = SemaphoreImportFlags;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreWaitFlagsKHR.html>
pub type SemaphoreWaitFlagsKHR = SemaphoreWaitFlags;
