// SPDX-License-Identifier: Apache-2.0

// DO NOT EDIT.
//
// This file has been generated by the Kotlin project in the `generator`
// directory from a Vulkan API registry.

#![allow(
    non_camel_case_types,
    non_snake_case,
    clippy::missing_safety_doc,
    clippy::too_many_arguments,
    clippy::type_complexity,
    clippy::upper_case_acronyms
)]

use std::fmt;
use std::os::raw::{c_char, c_int, c_void};
use std::ptr;

use crate::*;

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAabbPositionsKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct AabbPositionsKHR {
    pub min_x: f32,
    pub min_y: f32,
    pub min_z: f32,
    pub max_x: f32,
    pub max_y: f32,
    pub max_z: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureBuildGeometryInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureBuildGeometryInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: AccelerationStructureTypeKHR,
    pub flags: BuildAccelerationStructureFlagsKHR,
    pub mode: BuildAccelerationStructureModeKHR,
    pub src_acceleration_structure: AccelerationStructureKHR,
    pub dst_acceleration_structure: AccelerationStructureKHR,
    pub geometry_count: u32,
    pub geometries: *const AccelerationStructureGeometryKHR,
    pub pointer_geometries: *const *const AccelerationStructureGeometryKHR,
    pub scratch_data: DeviceOrHostAddressKHR,
}

impl Default for AccelerationStructureBuildGeometryInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR,
            next: ptr::null(),
            type_: AccelerationStructureTypeKHR::default(),
            flags: BuildAccelerationStructureFlagsKHR::default(),
            mode: BuildAccelerationStructureModeKHR::default(),
            src_acceleration_structure: AccelerationStructureKHR::default(),
            dst_acceleration_structure: AccelerationStructureKHR::default(),
            geometry_count: u32::default(),
            geometries: ptr::null(),
            pointer_geometries: ptr::null(),
            scratch_data: DeviceOrHostAddressKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureBuildRangeInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureBuildRangeInfoKHR {
    pub primitive_count: u32,
    pub primitive_offset: u32,
    pub first_vertex: u32,
    pub transform_offset: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureBuildSizesInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureBuildSizesInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acceleration_structure_size: DeviceSize,
    pub update_scratch_size: DeviceSize,
    pub build_scratch_size: DeviceSize,
}

impl Default for AccelerationStructureBuildSizesInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR,
            next: ptr::null(),
            acceleration_structure_size: DeviceSize::default(),
            update_scratch_size: DeviceSize::default(),
            build_scratch_size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub create_flags: AccelerationStructureCreateFlagsKHR,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub type_: AccelerationStructureTypeKHR,
    pub device_address: DeviceAddress,
}

impl Default for AccelerationStructureCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_CREATE_INFO_KHR,
            next: ptr::null(),
            create_flags: AccelerationStructureCreateFlagsKHR::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
            type_: AccelerationStructureTypeKHR::default(),
            device_address: DeviceAddress::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub compacted_size: DeviceSize,
    pub info: AccelerationStructureInfoNV,
}

impl Default for AccelerationStructureCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_CREATE_INFO_NV,
            next: ptr::null(),
            compacted_size: DeviceSize::default(),
            info: AccelerationStructureInfoNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureDeviceAddressInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureDeviceAddressInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acceleration_structure: AccelerationStructureKHR,
}

impl Default for AccelerationStructureDeviceAddressInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR,
            next: ptr::null(),
            acceleration_structure: AccelerationStructureKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureGeometryAabbsDataKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureGeometryAabbsDataKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub data: DeviceOrHostAddressConstKHR,
    pub stride: DeviceSize,
}

impl Default for AccelerationStructureGeometryAabbsDataKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR,
            next: ptr::null(),
            data: DeviceOrHostAddressConstKHR::default(),
            stride: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureGeometryInstancesDataKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureGeometryInstancesDataKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub array_of_pointers: Bool32,
    pub data: DeviceOrHostAddressConstKHR,
}

impl Default for AccelerationStructureGeometryInstancesDataKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR,
            next: ptr::null(),
            array_of_pointers: Bool32::default(),
            data: DeviceOrHostAddressConstKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureGeometryKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureGeometryKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub geometry_type: GeometryTypeKHR,
    pub geometry: AccelerationStructureGeometryDataKHR,
    pub flags: GeometryFlagsKHR,
}

impl Default for AccelerationStructureGeometryKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_GEOMETRY_KHR,
            next: ptr::null(),
            geometry_type: GeometryTypeKHR::default(),
            geometry: AccelerationStructureGeometryDataKHR::default(),
            flags: GeometryFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureGeometryMotionTrianglesDataNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureGeometryMotionTrianglesDataNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub vertex_data: DeviceOrHostAddressConstKHR,
}

impl Default for AccelerationStructureGeometryMotionTrianglesDataNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV,
            next: ptr::null(),
            vertex_data: DeviceOrHostAddressConstKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureGeometryTrianglesDataKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AccelerationStructureGeometryTrianglesDataKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub vertex_format: Format,
    pub vertex_data: DeviceOrHostAddressConstKHR,
    pub vertex_stride: DeviceSize,
    pub max_vertex: u32,
    pub index_type: IndexType,
    pub index_data: DeviceOrHostAddressConstKHR,
    pub transform_data: DeviceOrHostAddressConstKHR,
}

impl Default for AccelerationStructureGeometryTrianglesDataKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR,
            next: ptr::null(),
            vertex_format: Format::default(),
            vertex_data: DeviceOrHostAddressConstKHR::default(),
            vertex_stride: DeviceSize::default(),
            max_vertex: u32::default(),
            index_type: IndexType::default(),
            index_data: DeviceOrHostAddressConstKHR::default(),
            transform_data: DeviceOrHostAddressConstKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: AccelerationStructureTypeNV,
    pub flags: BuildAccelerationStructureFlagsNV,
    pub instance_count: u32,
    pub geometry_count: u32,
    pub geometries: *const GeometryNV,
}

impl Default for AccelerationStructureInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_INFO_NV,
            next: ptr::null(),
            type_: AccelerationStructureTypeNV::default(),
            flags: BuildAccelerationStructureFlagsNV::default(),
            instance_count: u32::default(),
            geometry_count: u32::default(),
            geometries: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureInstanceKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct AccelerationStructureInstanceKHR {
    pub transform: TransformMatrixKHR,
    pub instance_custom_index: u32,
    pub mask: u32,
    pub instance_shader_binding_table_record_offset: u32,
    pub flags: GeometryInstanceFlagsKHR,
    pub acceleration_structure_reference: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMatrixMotionInstanceNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct AccelerationStructureMatrixMotionInstanceNV {
    pub transform_t0: TransformMatrixKHR,
    pub transform_t1: TransformMatrixKHR,
    pub instance_custom_index: u32,
    pub mask: u32,
    pub instance_shader_binding_table_record_offset: u32,
    pub flags: GeometryInstanceFlagsKHR,
    pub acceleration_structure_reference: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMemoryRequirementsInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureMemoryRequirementsInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: AccelerationStructureMemoryRequirementsTypeNV,
    pub acceleration_structure: AccelerationStructureNV,
}

impl Default for AccelerationStructureMemoryRequirementsInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV,
            next: ptr::null(),
            type_: AccelerationStructureMemoryRequirementsTypeNV::default(),
            acceleration_structure: AccelerationStructureNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMotionInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureMotionInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub max_instances: u32,
    pub flags: AccelerationStructureMotionInfoFlagsNV,
}

impl Default for AccelerationStructureMotionInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_MOTION_INFO_NV,
            next: ptr::null(),
            max_instances: u32::default(),
            flags: AccelerationStructureMotionInfoFlagsNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureMotionInstanceNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
pub struct AccelerationStructureMotionInstanceNV {
    pub type_: AccelerationStructureMotionInstanceTypeNV,
    pub flags: AccelerationStructureMotionInstanceFlagsNV,
    pub data: AccelerationStructureMotionInstanceDataNV,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureSRTMotionInstanceNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct AccelerationStructureSRTMotionInstanceNV {
    pub transform_t0: SRTDataNV,
    pub transform_t1: SRTDataNV,
    pub instance_custom_index: u32,
    pub mask: u32,
    pub instance_shader_binding_table_record_offset: u32,
    pub flags: GeometryInstanceFlagsKHR,
    pub acceleration_structure_reference: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureVersionInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AccelerationStructureVersionInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub version_data: *const u8,
}

impl Default for AccelerationStructureVersionInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACCELERATION_STRUCTURE_VERSION_INFO_KHR,
            next: ptr::null(),
            version_data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAcquireNextImageInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AcquireNextImageInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub timeout: u64,
    pub semaphore: Semaphore,
    pub fence: Fence,
    pub device_mask: u32,
}

impl Default for AcquireNextImageInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACQUIRE_NEXT_IMAGE_INFO_KHR,
            next: ptr::null(),
            swapchain: SwapchainKHR::default(),
            timeout: u64::default(),
            semaphore: Semaphore::default(),
            fence: Fence::default(),
            device_mask: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAcquireProfilingLockInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AcquireProfilingLockInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: AcquireProfilingLockFlagsKHR,
    pub timeout: u64,
}

impl Default for AcquireProfilingLockInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ACQUIRE_PROFILING_LOCK_INFO_KHR,
            next: ptr::null(),
            flags: AcquireProfilingLockFlagsKHR::default(),
            timeout: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAllocationCallbacks.html>
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AllocationCallbacks {
    pub user_data: *mut c_void,
    pub allocation: PFN_vkAllocationFunction,
    pub reallocation: PFN_vkReallocationFunction,
    pub free: PFN_vkFreeFunction,
    pub internal_allocation: PFN_vkInternalAllocationNotification,
    pub internal_free: PFN_vkInternalFreeNotification,
}

impl fmt::Debug for AllocationCallbacks {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("AllocationCallbacks")
            .field("user_data", &self.user_data)
            .field("allocation", &(self.allocation.map(|f| f as *const u8)))
            .field("reallocation", &(self.reallocation.map(|f| f as *const u8)))
            .field("free", &(self.free.map(|f| f as *const u8)))
            .field(
                "internal_allocation",
                &(self.internal_allocation.map(|f| f as *const u8)),
            )
            .field(
                "internal_free",
                &(self.internal_free.map(|f| f as *const u8)),
            )
            .finish()
    }
}

impl Default for AllocationCallbacks {
    #[inline]
    fn default() -> Self {
        Self {
            user_data: ptr::null_mut(),
            allocation: PFN_vkAllocationFunction::default(),
            reallocation: PFN_vkReallocationFunction::default(),
            free: PFN_vkFreeFunction::default(),
            internal_allocation: PFN_vkInternalAllocationNotification::default(),
            internal_free: PFN_vkInternalFreeNotification::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidHardwareBufferFormatProperties2ANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AndroidHardwareBufferFormatProperties2ANDROID {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub format: Format,
    pub external_format: u64,
    pub format_features: FormatFeatureFlags2KHR,
    pub sampler_ycbcr_conversion_components: ComponentMapping,
    pub suggested_ycbcr_model: SamplerYcbcrModelConversion,
    pub suggested_ycbcr_range: SamplerYcbcrRange,
    pub suggested_x_chroma_offset: ChromaLocation,
    pub suggested_y_chroma_offset: ChromaLocation,
}

impl Default for AndroidHardwareBufferFormatProperties2ANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID,
            next: ptr::null_mut(),
            format: Format::default(),
            external_format: u64::default(),
            format_features: FormatFeatureFlags2KHR::default(),
            sampler_ycbcr_conversion_components: ComponentMapping::default(),
            suggested_ycbcr_model: SamplerYcbcrModelConversion::default(),
            suggested_ycbcr_range: SamplerYcbcrRange::default(),
            suggested_x_chroma_offset: ChromaLocation::default(),
            suggested_y_chroma_offset: ChromaLocation::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidHardwareBufferFormatPropertiesANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AndroidHardwareBufferFormatPropertiesANDROID {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub format: Format,
    pub external_format: u64,
    pub format_features: FormatFeatureFlags,
    pub sampler_ycbcr_conversion_components: ComponentMapping,
    pub suggested_ycbcr_model: SamplerYcbcrModelConversion,
    pub suggested_ycbcr_range: SamplerYcbcrRange,
    pub suggested_x_chroma_offset: ChromaLocation,
    pub suggested_y_chroma_offset: ChromaLocation,
}

impl Default for AndroidHardwareBufferFormatPropertiesANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID,
            next: ptr::null_mut(),
            format: Format::default(),
            external_format: u64::default(),
            format_features: FormatFeatureFlags::default(),
            sampler_ycbcr_conversion_components: ComponentMapping::default(),
            suggested_ycbcr_model: SamplerYcbcrModelConversion::default(),
            suggested_ycbcr_range: SamplerYcbcrRange::default(),
            suggested_x_chroma_offset: ChromaLocation::default(),
            suggested_y_chroma_offset: ChromaLocation::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidHardwareBufferPropertiesANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AndroidHardwareBufferPropertiesANDROID {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_bits: u32,
}

impl Default for AndroidHardwareBufferPropertiesANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID,
            next: ptr::null_mut(),
            allocation_size: DeviceSize::default(),
            memory_type_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidHardwareBufferUsageANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AndroidHardwareBufferUsageANDROID {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub android_hardware_buffer_usage: u64,
}

impl Default for AndroidHardwareBufferUsageANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ANDROID_HARDWARE_BUFFER_USAGE_ANDROID,
            next: ptr::null_mut(),
            android_hardware_buffer_usage: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidSurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AndroidSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: AndroidSurfaceCreateFlagsKHR,
    pub window: *mut ANativeWindow,
}

impl Default for AndroidSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ANDROID_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: AndroidSurfaceCreateFlagsKHR::default(),
            window: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkApplicationInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ApplicationInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub application_name: *const c_char,
    pub application_version: u32,
    pub engine_name: *const c_char,
    pub engine_version: u32,
    pub api_version: u32,
}

impl Default for ApplicationInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::APPLICATION_INFO,
            next: ptr::null(),
            application_name: ptr::null(),
            application_version: u32::default(),
            engine_name: ptr::null(),
            engine_version: u32::default(),
            api_version: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescription.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescription2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentDescription2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
}

impl Default for AttachmentDescription2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ATTACHMENT_DESCRIPTION_2,
            next: ptr::null(),
            flags: AttachmentDescriptionFlags::default(),
            format: Format::default(),
            samples: SampleCountFlags::default(),
            load_op: AttachmentLoadOp::default(),
            store_op: AttachmentStoreOp::default(),
            stencil_load_op: AttachmentLoadOp::default(),
            stencil_store_op: AttachmentStoreOp::default(),
            initial_layout: ImageLayout::default(),
            final_layout: ImageLayout::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescriptionStencilLayout.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentDescriptionStencilLayout {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub stencil_initial_layout: ImageLayout,
    pub stencil_final_layout: ImageLayout,
}

impl Default for AttachmentDescriptionStencilLayout {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT,
            next: ptr::null_mut(),
            stencil_initial_layout: ImageLayout::default(),
            stencil_final_layout: ImageLayout::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReference.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReference2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentReference2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attachment: u32,
    pub layout: ImageLayout,
    pub aspect_mask: ImageAspectFlags,
}

impl Default for AttachmentReference2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ATTACHMENT_REFERENCE_2,
            next: ptr::null(),
            attachment: u32::default(),
            layout: ImageLayout::default(),
            aspect_mask: ImageAspectFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReferenceStencilLayout.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentReferenceStencilLayout {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub stencil_layout: ImageLayout,
}

impl Default for AttachmentReferenceStencilLayout {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::ATTACHMENT_REFERENCE_STENCIL_LAYOUT,
            next: ptr::null_mut(),
            stencil_layout: ImageLayout::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentSampleLocationsEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct AttachmentSampleLocationsEXT {
    pub attachment_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBaseInStructure.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BaseInStructure {
    pub s_type: StructureType,
    pub next: *const BaseInStructure,
}

impl Default for BaseInStructure {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::default(),
            next: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBaseOutStructure.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BaseOutStructure {
    pub s_type: StructureType,
    pub next: *mut BaseOutStructure,
}

impl Default for BaseOutStructure {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::default(),
            next: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindAccelerationStructureMemoryInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindAccelerationStructureMemoryInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acceleration_structure: AccelerationStructureNV,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub device_index_count: u32,
    pub device_indices: *const u32,
}

impl Default for BindAccelerationStructureMemoryInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV,
            next: ptr::null(),
            acceleration_structure: AccelerationStructureNV::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
            device_index_count: u32::default(),
            device_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryDeviceGroupInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindBufferMemoryDeviceGroupInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_index_count: u32,
    pub device_indices: *const u32,
}

impl Default for BindBufferMemoryDeviceGroupInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO,
            next: ptr::null(),
            device_index_count: u32::default(),
            device_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindBufferMemoryInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer: Buffer,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
}

impl Default for BindBufferMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_BUFFER_MEMORY_INFO,
            next: ptr::null(),
            buffer: Buffer::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryDeviceGroupInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindImageMemoryDeviceGroupInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_index_count: u32,
    pub device_indices: *const u32,
    pub split_instance_bind_region_count: u32,
    pub split_instance_bind_regions: *const Rect2D,
}

impl Default for BindImageMemoryDeviceGroupInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO,
            next: ptr::null(),
            device_index_count: u32::default(),
            device_indices: ptr::null(),
            split_instance_bind_region_count: u32::default(),
            split_instance_bind_regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindImageMemoryInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image: Image,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
}

impl Default for BindImageMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_IMAGE_MEMORY_INFO,
            next: ptr::null(),
            image: Image::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemorySwapchainInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindImageMemorySwapchainInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub image_index: u32,
}

impl Default for BindImageMemorySwapchainInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR,
            next: ptr::null(),
            swapchain: SwapchainKHR::default(),
            image_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImagePlaneMemoryInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindImagePlaneMemoryInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
}

impl Default for BindImagePlaneMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_IMAGE_PLANE_MEMORY_INFO,
            next: ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindIndexBufferIndirectCommandNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct BindIndexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub index_type: IndexType,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindShaderGroupIndirectCommandNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct BindShaderGroupIndirectCommandNV {
    pub group_index: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindSparseInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BindSparseInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_count: u32,
    pub wait_semaphores: *const Semaphore,
    pub buffer_bind_count: u32,
    pub buffer_binds: *const SparseBufferMemoryBindInfo,
    pub image_opaque_bind_count: u32,
    pub image_opaque_binds: *const SparseImageOpaqueMemoryBindInfo,
    pub image_bind_count: u32,
    pub image_binds: *const SparseImageMemoryBindInfo,
    pub signal_semaphore_count: u32,
    pub signal_semaphores: *const Semaphore,
}

impl Default for BindSparseInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BIND_SPARSE_INFO,
            next: ptr::null(),
            wait_semaphore_count: u32::default(),
            wait_semaphores: ptr::null(),
            buffer_bind_count: u32::default(),
            buffer_binds: ptr::null(),
            image_opaque_bind_count: u32::default(),
            image_opaque_binds: ptr::null(),
            image_bind_count: u32::default(),
            image_binds: ptr::null(),
            signal_semaphore_count: u32::default(),
            signal_semaphores: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindVertexBufferIndirectCommandNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct BindVertexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub stride: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBlitImageInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BlitImageInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_image: Image,
    pub src_image_layout: ImageLayout,
    pub dst_image: Image,
    pub dst_image_layout: ImageLayout,
    pub region_count: u32,
    pub regions: *const ImageBlit2KHR,
    pub filter: Filter,
}

impl Default for BlitImageInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BLIT_IMAGE_INFO_2_KHR,
            next: ptr::null(),
            src_image: Image::default(),
            src_image_layout: ImageLayout::default(),
            dst_image: Image::default(),
            dst_image_layout: ImageLayout::default(),
            region_count: u32::default(),
            regions: ptr::null(),
            filter: Filter::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCollectionBufferCreateInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCollectionBufferCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub collection: BufferCollectionFUCHSIA,
    pub index: u32,
}

impl Default for BufferCollectionBufferCreateInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA,
            next: ptr::null(),
            collection: BufferCollectionFUCHSIA::default(),
            index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCollectionConstraintsInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCollectionConstraintsInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub min_buffer_count: u32,
    pub max_buffer_count: u32,
    pub min_buffer_count_for_camping: u32,
    pub min_buffer_count_for_dedicated_slack: u32,
    pub min_buffer_count_for_shared_slack: u32,
}

impl Default for BufferCollectionConstraintsInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA,
            next: ptr::null(),
            min_buffer_count: u32::default(),
            max_buffer_count: u32::default(),
            min_buffer_count_for_camping: u32::default(),
            min_buffer_count_for_dedicated_slack: u32::default(),
            min_buffer_count_for_shared_slack: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCollectionCreateInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCollectionCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub collection_token: zx_handle_t,
}

impl Default for BufferCollectionCreateInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COLLECTION_CREATE_INFO_FUCHSIA,
            next: ptr::null(),
            collection_token: zx_handle_t::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCollectionImageCreateInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCollectionImageCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub collection: BufferCollectionFUCHSIA,
    pub index: u32,
}

impl Default for BufferCollectionImageCreateInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA,
            next: ptr::null(),
            collection: BufferCollectionFUCHSIA::default(),
            index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCollectionPropertiesFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCollectionPropertiesFUCHSIA {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_type_bits: u32,
    pub buffer_count: u32,
    pub create_info_index: u32,
    pub sysmem_pixel_format: u64,
    pub format_features: FormatFeatureFlags,
    pub sysmem_color_space_index: SysmemColorSpaceFUCHSIA,
    pub sampler_ycbcr_conversion_components: ComponentMapping,
    pub suggested_ycbcr_model: SamplerYcbcrModelConversion,
    pub suggested_ycbcr_range: SamplerYcbcrRange,
    pub suggested_x_chroma_offset: ChromaLocation,
    pub suggested_y_chroma_offset: ChromaLocation,
}

impl Default for BufferCollectionPropertiesFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COLLECTION_PROPERTIES_FUCHSIA,
            next: ptr::null_mut(),
            memory_type_bits: u32::default(),
            buffer_count: u32::default(),
            create_info_index: u32::default(),
            sysmem_pixel_format: u64::default(),
            format_features: FormatFeatureFlags::default(),
            sysmem_color_space_index: SysmemColorSpaceFUCHSIA::default(),
            sampler_ycbcr_conversion_components: ComponentMapping::default(),
            suggested_ycbcr_model: SamplerYcbcrModelConversion::default(),
            suggested_ycbcr_range: SamplerYcbcrRange::default(),
            suggested_x_chroma_offset: ChromaLocation::default(),
            suggested_y_chroma_offset: ChromaLocation::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferConstraintsInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferConstraintsInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub create_info: BufferCreateInfo,
    pub required_format_features: FormatFeatureFlags,
    pub buffer_collection_constraints: BufferCollectionConstraintsInfoFUCHSIA,
}

impl Default for BufferConstraintsInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_CONSTRAINTS_INFO_FUCHSIA,
            next: ptr::null(),
            create_info: BufferCreateInfo::default(),
            required_format_features: FormatFeatureFlags::default(),
            buffer_collection_constraints: BufferCollectionConstraintsInfoFUCHSIA::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCopy.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct BufferCopy {
    pub src_offset: DeviceSize,
    pub dst_offset: DeviceSize,
    pub size: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCopy2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCopy2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_offset: DeviceSize,
    pub dst_offset: DeviceSize,
    pub size: DeviceSize,
}

impl Default for BufferCopy2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_COPY_2_KHR,
            next: ptr::null(),
            src_offset: DeviceSize::default(),
            dst_offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: BufferCreateFlags,
    pub size: DeviceSize,
    pub usage: BufferUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub queue_family_indices: *const u32,
}

impl Default for BufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_CREATE_INFO,
            next: ptr::null(),
            flags: BufferCreateFlags::default(),
            size: DeviceSize::default(),
            usage: BufferUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            queue_family_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferDeviceAddressCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferDeviceAddressCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_address: DeviceAddress,
}

impl Default for BufferDeviceAddressCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT,
            next: ptr::null(),
            device_address: DeviceAddress::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferDeviceAddressInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferDeviceAddressInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer: Buffer,
}

impl Default for BufferDeviceAddressInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_DEVICE_ADDRESS_INFO,
            next: ptr::null(),
            buffer: Buffer::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferImageCopy.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct BufferImageCopy {
    pub buffer_offset: DeviceSize,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferImageCopy2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferImageCopy2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer_offset: DeviceSize,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}

impl Default for BufferImageCopy2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_IMAGE_COPY_2_KHR,
            next: ptr::null(),
            buffer_offset: DeviceSize::default(),
            buffer_row_length: u32::default(),
            buffer_image_height: u32::default(),
            image_subresource: ImageSubresourceLayers::default(),
            image_offset: Offset3D::default(),
            image_extent: Extent3D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferMemoryBarrier.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferMemoryBarrier {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

impl Default for BufferMemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_MEMORY_BARRIER,
            next: ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferMemoryBarrier2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferMemoryBarrier2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_stage_mask: PipelineStageFlags2KHR,
    pub src_access_mask: AccessFlags2KHR,
    pub dst_stage_mask: PipelineStageFlags2KHR,
    pub dst_access_mask: AccessFlags2KHR,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

impl Default for BufferMemoryBarrier2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_MEMORY_BARRIER_2_KHR,
            next: ptr::null(),
            src_stage_mask: PipelineStageFlags2KHR::default(),
            src_access_mask: AccessFlags2KHR::default(),
            dst_stage_mask: PipelineStageFlags2KHR::default(),
            dst_access_mask: AccessFlags2KHR::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferMemoryRequirementsInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer: Buffer,
}

impl Default for BufferMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_MEMORY_REQUIREMENTS_INFO_2,
            next: ptr::null(),
            buffer: Buffer::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferOpaqueCaptureAddressCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferOpaqueCaptureAddressCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub opaque_capture_address: u64,
}

impl Default for BufferOpaqueCaptureAddressCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO,
            next: ptr::null(),
            opaque_capture_address: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferViewCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct BufferViewCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}

impl Default for BufferViewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::BUFFER_VIEW_CREATE_INFO,
            next: ptr::null(),
            flags: BufferViewCreateFlags::default(),
            buffer: Buffer::default(),
            format: Format::default(),
            offset: DeviceSize::default(),
            range: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCalibratedTimestampInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CalibratedTimestampInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub time_domain: TimeDomainEXT,
}

impl Default for CalibratedTimestampInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CALIBRATED_TIMESTAMP_INFO_EXT,
            next: ptr::null(),
            time_domain: TimeDomainEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCheckpointData2NV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CheckpointData2NV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub stage: PipelineStageFlags2KHR,
    pub checkpoint_marker: *mut c_void,
}

impl Default for CheckpointData2NV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CHECKPOINT_DATA_2_NV,
            next: ptr::null_mut(),
            stage: PipelineStageFlags2KHR::default(),
            checkpoint_marker: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCheckpointDataNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CheckpointDataNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub stage: PipelineStageFlags,
    pub checkpoint_marker: *mut c_void,
}

impl Default for CheckpointDataNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CHECKPOINT_DATA_NV,
            next: ptr::null_mut(),
            stage: PipelineStageFlags::default(),
            checkpoint_marker: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearAttachment.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
pub struct ClearAttachment {
    pub aspect_mask: ImageAspectFlags,
    pub color_attachment: u32,
    pub clear_value: ClearValue,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearDepthStencilValue.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearRect.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ClearRect {
    pub rect: Rect2D,
    pub base_array_layer: u32,
    pub layer_count: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCoarseSampleLocationNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct CoarseSampleLocationNV {
    pub pixel_x: u32,
    pub pixel_y: u32,
    pub sample: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCoarseSampleOrderCustomNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CoarseSampleOrderCustomNV {
    pub shading_rate: ShadingRatePaletteEntryNV,
    pub sample_count: u32,
    pub sample_location_count: u32,
    pub sample_locations: *const CoarseSampleLocationNV,
}

impl Default for CoarseSampleOrderCustomNV {
    #[inline]
    fn default() -> Self {
        Self {
            shading_rate: ShadingRatePaletteEntryNV::default(),
            sample_count: u32::default(),
            sample_location_count: u32::default(),
            sample_locations: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub command_pool: CommandPool,
    pub level: CommandBufferLevel,
    pub command_buffer_count: u32,
}

impl Default for CommandBufferAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_ALLOCATE_INFO,
            next: ptr::null(),
            command_pool: CommandPool::default(),
            level: CommandBufferLevel::default(),
            command_buffer_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: CommandBufferUsageFlags,
    pub inheritance_info: *const CommandBufferInheritanceInfo,
}

impl Default for CommandBufferBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_BEGIN_INFO,
            next: ptr::null(),
            flags: CommandBufferUsageFlags::default(),
            inheritance_info: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferInheritanceConditionalRenderingInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferInheritanceConditionalRenderingInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub conditional_rendering_enable: Bool32,
}

impl Default for CommandBufferInheritanceConditionalRenderingInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT,
            next: ptr::null(),
            conditional_rendering_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferInheritanceInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferInheritanceInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub framebuffer: Framebuffer,
    pub occlusion_query_enable: Bool32,
    pub query_flags: QueryControlFlags,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}

impl Default for CommandBufferInheritanceInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_INHERITANCE_INFO,
            next: ptr::null(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            framebuffer: Framebuffer::default(),
            occlusion_query_enable: Bool32::default(),
            query_flags: QueryControlFlags::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferInheritanceRenderPassTransformInfoQCOM.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferInheritanceRenderPassTransformInfoQCOM {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub transform: SurfaceTransformFlagsKHR,
    pub render_area: Rect2D,
}

impl Default for CommandBufferInheritanceRenderPassTransformInfoQCOM {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM,
            next: ptr::null_mut(),
            transform: SurfaceTransformFlagsKHR::default(),
            render_area: Rect2D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferInheritanceViewportScissorInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferInheritanceViewportScissorInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub viewport_scissor_2d: Bool32,
    pub viewport_depth_count: u32,
    pub viewport_depths: *const Viewport,
}

impl Default for CommandBufferInheritanceViewportScissorInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV,
            next: ptr::null(),
            viewport_scissor_2d: Bool32::default(),
            viewport_depth_count: u32::default(),
            viewport_depths: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferSubmitInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandBufferSubmitInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub command_buffer: CommandBuffer,
    pub device_mask: u32,
}

impl Default for CommandBufferSubmitInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_BUFFER_SUBMIT_INFO_KHR,
            next: ptr::null(),
            command_buffer: CommandBuffer::default(),
            device_mask: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CommandPoolCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: CommandPoolCreateFlags,
    pub queue_family_index: u32,
}

impl Default for CommandPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMMAND_POOL_CREATE_INFO,
            next: ptr::null(),
            flags: CommandPoolCreateFlags::default(),
            queue_family_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComponentMapping.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComputePipelineCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ComputePipelineCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage: PipelineShaderStageCreateInfo,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}

impl Default for ComputePipelineCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COMPUTE_PIPELINE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage: PipelineShaderStageCreateInfo::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConditionalRenderingBeginInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ConditionalRenderingBeginInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub flags: ConditionalRenderingFlagsEXT,
}

impl Default for ConditionalRenderingBeginInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CONDITIONAL_RENDERING_BEGIN_INFO_EXT,
            next: ptr::null(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            flags: ConditionalRenderingFlagsEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConformanceVersion.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCooperativeMatrixPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CooperativeMatrixPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub m_size: u32,
    pub n_size: u32,
    pub k_size: u32,
    pub a_type: ComponentTypeNV,
    pub b_type: ComponentTypeNV,
    pub c_type: ComponentTypeNV,
    pub d_type: ComponentTypeNV,
    pub scope: ScopeNV,
}

impl Default for CooperativeMatrixPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COOPERATIVE_MATRIX_PROPERTIES_NV,
            next: ptr::null_mut(),
            m_size: u32::default(),
            n_size: u32::default(),
            k_size: u32::default(),
            a_type: ComponentTypeNV::default(),
            b_type: ComponentTypeNV::default(),
            c_type: ComponentTypeNV::default(),
            d_type: ComponentTypeNV::default(),
            scope: ScopeNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyAccelerationStructureInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyAccelerationStructureInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src: AccelerationStructureKHR,
    pub dst: AccelerationStructureKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

impl Default for CopyAccelerationStructureInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_ACCELERATION_STRUCTURE_INFO_KHR,
            next: ptr::null(),
            src: AccelerationStructureKHR::default(),
            dst: AccelerationStructureKHR::default(),
            mode: CopyAccelerationStructureModeKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyAccelerationStructureToMemoryInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct CopyAccelerationStructureToMemoryInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src: AccelerationStructureKHR,
    pub dst: DeviceOrHostAddressKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

impl Default for CopyAccelerationStructureToMemoryInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR,
            next: ptr::null(),
            src: AccelerationStructureKHR::default(),
            dst: DeviceOrHostAddressKHR::default(),
            mode: CopyAccelerationStructureModeKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyBufferInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyBufferInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_buffer: Buffer,
    pub dst_buffer: Buffer,
    pub region_count: u32,
    pub regions: *const BufferCopy2KHR,
}

impl Default for CopyBufferInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_BUFFER_INFO_2_KHR,
            next: ptr::null(),
            src_buffer: Buffer::default(),
            dst_buffer: Buffer::default(),
            region_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyBufferToImageInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyBufferToImageInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_buffer: Buffer,
    pub dst_image: Image,
    pub dst_image_layout: ImageLayout,
    pub region_count: u32,
    pub regions: *const BufferImageCopy2KHR,
}

impl Default for CopyBufferToImageInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_BUFFER_TO_IMAGE_INFO_2_KHR,
            next: ptr::null(),
            src_buffer: Buffer::default(),
            dst_image: Image::default(),
            dst_image_layout: ImageLayout::default(),
            region_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyCommandTransformInfoQCOM.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyCommandTransformInfoQCOM {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub transform: SurfaceTransformFlagsKHR,
}

impl Default for CopyCommandTransformInfoQCOM {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_COMMAND_TRANSFORM_INFO_QCOM,
            next: ptr::null(),
            transform: SurfaceTransformFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyDescriptorSet.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyDescriptorSet {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_set: DescriptorSet,
    pub src_binding: u32,
    pub src_array_element: u32,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
}

impl Default for CopyDescriptorSet {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_DESCRIPTOR_SET,
            next: ptr::null(),
            src_set: DescriptorSet::default(),
            src_binding: u32::default(),
            src_array_element: u32::default(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyImageInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyImageInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_image: Image,
    pub src_image_layout: ImageLayout,
    pub dst_image: Image,
    pub dst_image_layout: ImageLayout,
    pub region_count: u32,
    pub regions: *const ImageCopy2KHR,
}

impl Default for CopyImageInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_IMAGE_INFO_2_KHR,
            next: ptr::null(),
            src_image: Image::default(),
            src_image_layout: ImageLayout::default(),
            dst_image: Image::default(),
            dst_image_layout: ImageLayout::default(),
            region_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyImageToBufferInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CopyImageToBufferInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_image: Image,
    pub src_image_layout: ImageLayout,
    pub dst_buffer: Buffer,
    pub region_count: u32,
    pub regions: *const BufferImageCopy2KHR,
}

impl Default for CopyImageToBufferInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_IMAGE_TO_BUFFER_INFO_2_KHR,
            next: ptr::null(),
            src_image: Image::default(),
            src_image_layout: ImageLayout::default(),
            dst_buffer: Buffer::default(),
            region_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyMemoryToAccelerationStructureInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct CopyMemoryToAccelerationStructureInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src: DeviceOrHostAddressConstKHR,
    pub dst: AccelerationStructureKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

impl Default for CopyMemoryToAccelerationStructureInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR,
            next: ptr::null(),
            src: DeviceOrHostAddressConstKHR::default(),
            dst: AccelerationStructureKHR::default(),
            mode: CopyAccelerationStructureModeKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCuFunctionCreateInfoNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CuFunctionCreateInfoNVX {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub module: CuModuleNVX,
    pub name: *const c_char,
}

impl Default for CuFunctionCreateInfoNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CU_FUNCTION_CREATE_INFO_NVX,
            next: ptr::null(),
            module: CuModuleNVX::default(),
            name: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCuLaunchInfoNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CuLaunchInfoNVX {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub function: CuFunctionNVX,
    pub grid_dim_x: u32,
    pub grid_dim_y: u32,
    pub grid_dim_z: u32,
    pub block_dim_x: u32,
    pub block_dim_y: u32,
    pub block_dim_z: u32,
    pub shared_mem_bytes: u32,
    pub param_count: usize,
    pub params: *const c_void,
    pub extra_count: usize,
    pub extras: *const c_void,
}

impl Default for CuLaunchInfoNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CU_LAUNCH_INFO_NVX,
            next: ptr::null(),
            function: CuFunctionNVX::default(),
            grid_dim_x: u32::default(),
            grid_dim_y: u32::default(),
            grid_dim_z: u32::default(),
            block_dim_x: u32::default(),
            block_dim_y: u32::default(),
            block_dim_z: u32::default(),
            shared_mem_bytes: u32::default(),
            param_count: usize::default(),
            params: ptr::null(),
            extra_count: usize::default(),
            extras: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCuModuleCreateInfoNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct CuModuleCreateInfoNVX {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub data_size: usize,
    pub data: *const c_void,
}

impl Default for CuModuleCreateInfoNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::CU_MODULE_CREATE_INFO_NVX,
            next: ptr::null(),
            data_size: usize::default(),
            data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkD3D12FenceSubmitInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct D3D12FenceSubmitInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_values_count: u32,
    pub wait_semaphore_values: *const u64,
    pub signal_semaphore_values_count: u32,
    pub signal_semaphore_values: *const u64,
}

impl Default for D3D12FenceSubmitInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::D3D12_FENCE_SUBMIT_INFO_KHR,
            next: ptr::null(),
            wait_semaphore_values_count: u32::default(),
            wait_semaphore_values: ptr::null(),
            signal_semaphore_values_count: u32::default(),
            signal_semaphore_values: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerMarkerInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DebugMarkerMarkerInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub marker_name: *const c_char,
    pub color: [f32; 4],
}

impl Default for DebugMarkerMarkerInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_MARKER_MARKER_INFO_EXT,
            next: ptr::null(),
            marker_name: ptr::null(),
            color: [f32::default(); 4],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerObjectNameInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DebugMarkerObjectNameInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub object_name: *const c_char,
}

impl Default for DebugMarkerObjectNameInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_MARKER_OBJECT_NAME_INFO_EXT,
            next: ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            object_name: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerObjectTagInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DebugMarkerObjectTagInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub tag: *const c_void,
}

impl Default for DebugMarkerObjectTagInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_MARKER_OBJECT_TAG_INFO_EXT,
            next: ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            tag: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugReportCallbackCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugReportCallbackCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DebugReportFlagsEXT,
    pub callback: PFN_vkDebugReportCallbackEXT,
    pub user_data: *mut c_void,
}

impl fmt::Debug for DebugReportCallbackCreateInfoEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("DebugReportCallbackCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("next", &self.next)
            .field("flags", &self.flags)
            .field("callback", &(self.callback.map(|f| f as *const u8)))
            .field("user_data", &self.user_data)
            .finish()
    }
}

impl Default for DebugReportCallbackCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: DebugReportFlagsEXT::default(),
            callback: PFN_vkDebugReportCallbackEXT::default(),
            user_data: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsLabelEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DebugUtilsLabelEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub label_name: *const c_char,
    pub color: [f32; 4],
}

impl Default for DebugUtilsLabelEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_UTILS_LABEL_EXT,
            next: ptr::null(),
            label_name: ptr::null(),
            color: [f32::default(); 4],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCallbackDataEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DebugUtilsMessengerCallbackDataEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DebugUtilsMessengerCallbackDataFlagsEXT,
    pub message_id_name: *const c_char,
    pub message_id_number: i32,
    pub message: *const c_char,
    pub queue_label_count: u32,
    pub queue_labels: *const DebugUtilsLabelEXT,
    pub cmd_buf_label_count: u32,
    pub cmd_buf_labels: *const DebugUtilsLabelEXT,
    pub object_count: u32,
    pub objects: *const DebugUtilsObjectNameInfoEXT,
}

impl Default for DebugUtilsMessengerCallbackDataEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT,
            next: ptr::null(),
            flags: DebugUtilsMessengerCallbackDataFlagsEXT::default(),
            message_id_name: ptr::null(),
            message_id_number: i32::default(),
            message: ptr::null(),
            queue_label_count: u32::default(),
            queue_labels: ptr::null(),
            cmd_buf_label_count: u32::default(),
            cmd_buf_labels: ptr::null(),
            object_count: u32::default(),
            objects: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsMessengerCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DebugUtilsMessengerCreateFlagsEXT,
    pub message_severity: DebugUtilsMessageSeverityFlagsEXT,
    pub message_type: DebugUtilsMessageTypeFlagsEXT,
    pub user_callback: PFN_vkDebugUtilsMessengerCallbackEXT,
    pub user_data: *mut c_void,
}

impl fmt::Debug for DebugUtilsMessengerCreateInfoEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("DebugUtilsMessengerCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("next", &self.next)
            .field("flags", &self.flags)
            .field("message_severity", &self.message_severity)
            .field("message_type", &self.message_type)
            .field(
                "user_callback",
                &(self.user_callback.map(|f| f as *const u8)),
            )
            .field("user_data", &self.user_data)
            .finish()
    }
}

impl Default for DebugUtilsMessengerCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: DebugUtilsMessengerCreateFlagsEXT::default(),
            message_severity: DebugUtilsMessageSeverityFlagsEXT::default(),
            message_type: DebugUtilsMessageTypeFlagsEXT::default(),
            user_callback: PFN_vkDebugUtilsMessengerCallbackEXT::default(),
            user_data: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsObjectNameInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DebugUtilsObjectNameInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub object_name: *const c_char,
}

impl Default for DebugUtilsObjectNameInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_UTILS_OBJECT_NAME_INFO_EXT,
            next: ptr::null(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            object_name: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsObjectTagInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DebugUtilsObjectTagInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub tag: *const c_void,
}

impl Default for DebugUtilsObjectTagInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEBUG_UTILS_OBJECT_TAG_INFO_EXT,
            next: ptr::null(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            tag: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationBufferCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DedicatedAllocationBufferCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub dedicated_allocation: Bool32,
}

impl Default for DedicatedAllocationBufferCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV,
            next: ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationImageCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DedicatedAllocationImageCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub dedicated_allocation: Bool32,
}

impl Default for DedicatedAllocationImageCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV,
            next: ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationMemoryAllocateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DedicatedAllocationMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}

impl Default for DedicatedAllocationMemoryAllocateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV,
            next: ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDependencyInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DependencyInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub dependency_flags: DependencyFlags,
    pub memory_barrier_count: u32,
    pub memory_barriers: *const MemoryBarrier2KHR,
    pub buffer_memory_barrier_count: u32,
    pub buffer_memory_barriers: *const BufferMemoryBarrier2KHR,
    pub image_memory_barrier_count: u32,
    pub image_memory_barriers: *const ImageMemoryBarrier2KHR,
}

impl Default for DependencyInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEPENDENCY_INFO_KHR,
            next: ptr::null(),
            dependency_flags: DependencyFlags::default(),
            memory_barrier_count: u32::default(),
            memory_barriers: ptr::null(),
            buffer_memory_barrier_count: u32::default(),
            buffer_memory_barriers: ptr::null(),
            image_memory_barrier_count: u32::default(),
            image_memory_barriers: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorBufferInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorImageInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorImageInfo {
    pub sampler: Sampler,
    pub image_view: ImageView,
    pub image_layout: ImageLayout,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorPoolCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub max_sets: u32,
    pub pool_size_count: u32,
    pub pool_sizes: *const DescriptorPoolSize,
}

impl Default for DescriptorPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_POOL_CREATE_INFO,
            next: ptr::null(),
            flags: DescriptorPoolCreateFlags::default(),
            max_sets: u32::default(),
            pool_size_count: u32::default(),
            pool_sizes: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolInlineUniformBlockCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorPoolInlineUniformBlockCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub max_inline_uniform_block_bindings: u32,
}

impl Default for DescriptorPoolInlineUniformBlockCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT,
            next: ptr::null(),
            max_inline_uniform_block_bindings: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolSize.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorPoolSize {
    pub type_: DescriptorType,
    pub descriptor_count: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub descriptor_pool: DescriptorPool,
    pub descriptor_set_count: u32,
    pub set_layouts: *const DescriptorSetLayout,
}

impl Default for DescriptorSetAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_ALLOCATE_INFO,
            next: ptr::null(),
            descriptor_pool: DescriptorPool::default(),
            descriptor_set_count: u32::default(),
            set_layouts: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutBinding.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptor_type: DescriptorType,
    pub descriptor_count: u32,
    pub stage_flags: ShaderStageFlags,
    pub immutable_samplers: *const Sampler,
}

impl Default for DescriptorSetLayoutBinding {
    #[inline]
    fn default() -> Self {
        Self {
            binding: u32::default(),
            descriptor_type: DescriptorType::default(),
            descriptor_count: u32::default(),
            stage_flags: ShaderStageFlags::default(),
            immutable_samplers: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutBindingFlagsCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetLayoutBindingFlagsCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub binding_count: u32,
    pub binding_flags: *const DescriptorBindingFlags,
}

impl Default for DescriptorSetLayoutBindingFlagsCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO,
            next: ptr::null(),
            binding_count: u32::default(),
            binding_flags: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetLayoutCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub binding_count: u32,
    pub bindings: *const DescriptorSetLayoutBinding,
}

impl Default for DescriptorSetLayoutCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_LAYOUT_CREATE_INFO,
            next: ptr::null(),
            flags: DescriptorSetLayoutCreateFlags::default(),
            binding_count: u32::default(),
            bindings: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutSupport.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetLayoutSupport {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub supported: Bool32,
}

impl Default for DescriptorSetLayoutSupport {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_LAYOUT_SUPPORT,
            next: ptr::null_mut(),
            supported: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetVariableDescriptorCountAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetVariableDescriptorCountAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub descriptor_set_count: u32,
    pub descriptor_counts: *const u32,
}

impl Default for DescriptorSetVariableDescriptorCountAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO,
            next: ptr::null(),
            descriptor_set_count: u32::default(),
            descriptor_counts: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetVariableDescriptorCountLayoutSupport.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorSetVariableDescriptorCountLayoutSupport {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_variable_descriptor_count: u32,
}

impl Default for DescriptorSetVariableDescriptorCountLayoutSupport {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT,
            next: ptr::null_mut(),
            max_variable_descriptor_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorUpdateTemplateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DescriptorUpdateTemplateCreateFlags,
    pub descriptor_update_entry_count: u32,
    pub descriptor_update_entries: *const DescriptorUpdateTemplateEntry,
    pub template_type: DescriptorUpdateTemplateType,
    pub descriptor_set_layout: DescriptorSetLayout,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline_layout: PipelineLayout,
    pub set: u32,
}

impl Default for DescriptorUpdateTemplateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO,
            next: ptr::null(),
            flags: DescriptorUpdateTemplateCreateFlags::default(),
            descriptor_update_entry_count: u32::default(),
            descriptor_update_entries: ptr::null(),
            template_type: DescriptorUpdateTemplateType::default(),
            descriptor_set_layout: DescriptorSetLayout::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline_layout: PipelineLayout::default(),
            set: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateEntry.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DescriptorUpdateTemplateEntry {
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub offset: usize,
    pub stride: usize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceBufferMemoryRequirementsKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceBufferMemoryRequirementsKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub create_info: *const BufferCreateInfo,
}

impl Default for DeviceBufferMemoryRequirementsKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR,
            next: ptr::null(),
            create_info: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queue_create_info_count: u32,
    pub queue_create_infos: *const DeviceQueueCreateInfo,
    pub enabled_layer_count: u32,
    pub enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub enabled_extension_names: *const *const c_char,
    pub enabled_features: *const PhysicalDeviceFeatures,
}

impl Default for DeviceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_CREATE_INFO,
            next: ptr::null(),
            flags: DeviceCreateFlags::default(),
            queue_create_info_count: u32::default(),
            queue_create_infos: ptr::null(),
            enabled_layer_count: u32::default(),
            enabled_layer_names: ptr::null(),
            enabled_extension_count: u32::default(),
            enabled_extension_names: ptr::null(),
            enabled_features: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceDeviceMemoryReportCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceDeviceMemoryReportCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub user_callback: PFN_vkDeviceMemoryReportCallbackEXT,
    pub user_data: *mut c_void,
}

impl fmt::Debug for DeviceDeviceMemoryReportCreateInfoEXT {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("DeviceDeviceMemoryReportCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("next", &self.next)
            .field("flags", &self.flags)
            .field(
                "user_callback",
                &(self.user_callback.map(|f| f as *const u8)),
            )
            .field("user_data", &self.user_data)
            .finish()
    }
}

impl Default for DeviceDeviceMemoryReportCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: DeviceMemoryReportFlagsEXT::default(),
            user_callback: PFN_vkDeviceMemoryReportCallbackEXT::default(),
            user_data: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceDiagnosticsConfigCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceDiagnosticsConfigCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DeviceDiagnosticsConfigFlagsNV,
}

impl Default for DeviceDiagnosticsConfigCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV,
            next: ptr::null(),
            flags: DeviceDiagnosticsConfigFlagsNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceEventInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceEventInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_event: DeviceEventTypeEXT,
}

impl Default for DeviceEventInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_EVENT_INFO_EXT,
            next: ptr::null(),
            device_event: DeviceEventTypeEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupBindSparseInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupBindSparseInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub resource_device_index: u32,
    pub memory_device_index: u32,
}

impl Default for DeviceGroupBindSparseInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_BIND_SPARSE_INFO,
            next: ptr::null(),
            resource_device_index: u32::default(),
            memory_device_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupCommandBufferBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupCommandBufferBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_mask: u32,
}

impl Default for DeviceGroupCommandBufferBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO,
            next: ptr::null(),
            device_mask: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupDeviceCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupDeviceCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub physical_device_count: u32,
    pub physical_devices: *const PhysicalDevice,
}

impl Default for DeviceGroupDeviceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_DEVICE_CREATE_INFO,
            next: ptr::null(),
            physical_device_count: u32::default(),
            physical_devices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupPresentCapabilitiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupPresentCapabilitiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub present_mask: [u32; MAX_DEVICE_GROUP_SIZE],
    pub modes: DeviceGroupPresentModeFlagsKHR,
}

impl Default for DeviceGroupPresentCapabilitiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_PRESENT_CAPABILITIES_KHR,
            next: ptr::null_mut(),
            present_mask: [u32::default(); MAX_DEVICE_GROUP_SIZE],
            modes: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupPresentInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupPresentInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain_count: u32,
    pub device_masks: *const u32,
    pub mode: DeviceGroupPresentModeFlagsKHR,
}

impl Default for DeviceGroupPresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_PRESENT_INFO_KHR,
            next: ptr::null(),
            swapchain_count: u32::default(),
            device_masks: ptr::null(),
            mode: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupRenderPassBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupRenderPassBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub device_mask: u32,
    pub device_render_area_count: u32,
    pub device_render_areas: *const Rect2D,
}

impl Default for DeviceGroupRenderPassBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_RENDER_PASS_BEGIN_INFO,
            next: ptr::null(),
            device_mask: u32::default(),
            device_render_area_count: u32::default(),
            device_render_areas: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupSubmitInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupSubmitInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_count: u32,
    pub wait_semaphore_device_indices: *const u32,
    pub command_buffer_count: u32,
    pub command_buffer_device_masks: *const u32,
    pub signal_semaphore_count: u32,
    pub signal_semaphore_device_indices: *const u32,
}

impl Default for DeviceGroupSubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_SUBMIT_INFO,
            next: ptr::null(),
            wait_semaphore_count: u32::default(),
            wait_semaphore_device_indices: ptr::null(),
            command_buffer_count: u32::default(),
            command_buffer_device_masks: ptr::null(),
            signal_semaphore_count: u32::default(),
            signal_semaphore_device_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupSwapchainCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceGroupSwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub modes: DeviceGroupPresentModeFlagsKHR,
}

impl Default for DeviceGroupSwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR,
            next: ptr::null(),
            modes: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceImageMemoryRequirementsKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceImageMemoryRequirementsKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub create_info: *const ImageCreateInfo,
    pub plane_aspect: ImageAspectFlags,
}

impl Default for DeviceImageMemoryRequirementsKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR,
            next: ptr::null(),
            create_info: ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryOpaqueCaptureAddressInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceMemoryOpaqueCaptureAddressInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
}

impl Default for DeviceMemoryOpaqueCaptureAddressInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO,
            next: ptr::null(),
            memory: DeviceMemory::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryOverallocationCreateInfoAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceMemoryOverallocationCreateInfoAMD {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub overallocation_behavior: MemoryOverallocationBehaviorAMD,
}

impl Default for DeviceMemoryOverallocationCreateInfoAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD,
            next: ptr::null(),
            overallocation_behavior: MemoryOverallocationBehaviorAMD::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryReportCallbackDataEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceMemoryReportCallbackDataEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub type_: DeviceMemoryReportEventTypeEXT,
    pub memory_object_id: u64,
    pub size: DeviceSize,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub heap_index: u32,
}

impl Default for DeviceMemoryReportCallbackDataEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT,
            next: ptr::null_mut(),
            flags: DeviceMemoryReportFlagsEXT::default(),
            type_: DeviceMemoryReportEventTypeEXT::default(),
            memory_object_id: u64::default(),
            size: DeviceSize::default(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            heap_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDevicePrivateDataCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DevicePrivateDataCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub private_data_slot_request_count: u32,
}

impl Default for DevicePrivateDataCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_PRIVATE_DATA_CREATE_INFO_EXT,
            next: ptr::null(),
            private_data_slot_request_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceQueueCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceQueueCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_count: u32,
    pub queue_priorities: *const f32,
}

impl Default for DeviceQueueCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_QUEUE_CREATE_INFO,
            next: ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_count: u32::default(),
            queue_priorities: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceQueueGlobalPriorityCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceQueueGlobalPriorityCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub global_priority: QueueGlobalPriorityEXT,
}

impl Default for DeviceQueueGlobalPriorityCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT,
            next: ptr::null(),
            global_priority: QueueGlobalPriorityEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceQueueInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DeviceQueueInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_index: u32,
}

impl Default for DeviceQueueInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DEVICE_QUEUE_INFO_2,
            next: ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDirectFBSurfaceCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DirectFBSurfaceCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DirectFBSurfaceCreateFlagsEXT,
    pub dfb: *mut IDirectFB,
    pub surface: *mut IDirectFBSurface,
}

impl Default for DirectFBSurfaceCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DIRECTFB_SURFACE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: DirectFBSurfaceCreateFlagsEXT::default(),
            dfb: ptr::null_mut(),
            surface: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDispatchIndirectCommand.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayEventInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayEventInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub display_event: DisplayEventTypeEXT,
}

impl Default for DisplayEventInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_EVENT_INFO_EXT,
            next: ptr::null(),
            display_event: DisplayEventTypeEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayModeCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR,
}

impl Default for DisplayModeCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_MODE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: DisplayModeCreateFlagsKHR::default(),
            parameters: DisplayModeParametersKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeParametersKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DisplayModeParametersKHR {
    pub visible_region: Extent2D,
    pub refresh_rate: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeProperties2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayModeProperties2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub display_mode_properties: DisplayModePropertiesKHR,
}

impl Default for DisplayModeProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_MODE_PROPERTIES_2_KHR,
            next: ptr::null_mut(),
            display_mode_properties: DisplayModePropertiesKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DisplayModePropertiesKHR {
    pub display_mode: DisplayModeKHR,
    pub parameters: DisplayModeParametersKHR,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayNativeHdrSurfaceCapabilitiesAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMD {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub local_dimming_support: Bool32,
}

impl Default for DisplayNativeHdrSurfaceCapabilitiesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD,
            next: ptr::null_mut(),
            local_dimming_support: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneCapabilities2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPlaneCapabilities2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub capabilities: DisplayPlaneCapabilitiesKHR,
}

impl Default for DisplayPlaneCapabilities2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_PLANE_CAPABILITIES_2_KHR,
            next: ptr::null_mut(),
            capabilities: DisplayPlaneCapabilitiesKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneCapabilitiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supported_alpha: DisplayPlaneAlphaFlagsKHR,
    pub min_src_position: Offset2D,
    pub max_src_position: Offset2D,
    pub min_src_extent: Extent2D,
    pub max_src_extent: Extent2D,
    pub min_dst_position: Offset2D,
    pub max_dst_position: Offset2D,
    pub min_dst_extent: Extent2D,
    pub max_dst_extent: Extent2D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPlaneInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub mode: DisplayModeKHR,
    pub plane_index: u32,
}

impl Default for DisplayPlaneInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_PLANE_INFO_2_KHR,
            next: ptr::null(),
            mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneProperties2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPlaneProperties2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub display_plane_properties: DisplayPlanePropertiesKHR,
}

impl Default for DisplayPlaneProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_PLANE_PROPERTIES_2_KHR,
            next: ptr::null_mut(),
            display_plane_properties: DisplayPlanePropertiesKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlanePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPlanePropertiesKHR {
    pub current_display: DisplayKHR,
    pub current_stack_index: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPowerInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPowerInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub power_state: DisplayPowerStateEXT,
}

impl Default for DisplayPowerInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_POWER_INFO_EXT,
            next: ptr::null(),
            power_state: DisplayPowerStateEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPresentInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPresentInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_rect: Rect2D,
    pub dst_rect: Rect2D,
    pub persistent: Bool32,
}

impl Default for DisplayPresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_PRESENT_INFO_KHR,
            next: ptr::null(),
            src_rect: Rect2D::default(),
            dst_rect: Rect2D::default(),
            persistent: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayProperties2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayProperties2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub display_properties: DisplayPropertiesKHR,
}

impl Default for DisplayProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_PROPERTIES_2_KHR,
            next: ptr::null_mut(),
            display_properties: DisplayPropertiesKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DisplayPropertiesKHR {
    pub display: DisplayKHR,
    pub display_name: *const c_char,
    pub physical_dimensions: Extent2D,
    pub physical_resolution: Extent2D,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub plane_reorder_possible: Bool32,
    pub persistent_content: Bool32,
}

impl Default for DisplayPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            display: DisplayKHR::default(),
            display_name: ptr::null(),
            physical_dimensions: Extent2D::default(),
            physical_resolution: Extent2D::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            plane_reorder_possible: Bool32::default(),
            persistent_content: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplaySurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DisplaySurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub display_mode: DisplayModeKHR,
    pub plane_index: u32,
    pub plane_stack_index: u32,
    pub transform: SurfaceTransformFlagsKHR,
    pub global_alpha: f32,
    pub alpha_mode: DisplayPlaneAlphaFlagsKHR,
    pub image_extent: Extent2D,
}

impl Default for DisplaySurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DISPLAY_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: DisplaySurfaceCreateFlagsKHR::default(),
            display_mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
            plane_stack_index: u32::default(),
            transform: SurfaceTransformFlagsKHR::default(),
            global_alpha: f32::default(),
            alpha_mode: DisplayPlaneAlphaFlagsKHR::default(),
            image_extent: Extent2D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrawIndexedIndirectCommand.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DrawIndexedIndirectCommand {
    pub index_count: u32,
    pub instance_count: u32,
    pub first_index: u32,
    pub vertex_offset: i32,
    pub first_instance: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrawIndirectCommand.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DrawIndirectCommand {
    pub vertex_count: u32,
    pub instance_count: u32,
    pub first_vertex: u32,
    pub first_instance: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrawMeshTasksIndirectCommandNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DrawMeshTasksIndirectCommandNV {
    pub task_count: u32,
    pub first_task: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrmFormatModifierProperties2EXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DrmFormatModifierProperties2EXT {
    pub drm_format_modifier: u64,
    pub drm_format_modifier_plane_count: u32,
    pub drm_format_modifier_tiling_features: FormatFeatureFlags2KHR,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrmFormatModifierPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct DrmFormatModifierPropertiesEXT {
    pub drm_format_modifier: u64,
    pub drm_format_modifier_plane_count: u32,
    pub drm_format_modifier_tiling_features: FormatFeatureFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrmFormatModifierPropertiesList2EXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DrmFormatModifierPropertiesList2EXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub drm_format_modifier_count: u32,
    pub drm_format_modifier_properties: *mut DrmFormatModifierProperties2EXT,
}

impl Default for DrmFormatModifierPropertiesList2EXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT,
            next: ptr::null_mut(),
            drm_format_modifier_count: u32::default(),
            drm_format_modifier_properties: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrmFormatModifierPropertiesListEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct DrmFormatModifierPropertiesListEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub drm_format_modifier_count: u32,
    pub drm_format_modifier_properties: *mut DrmFormatModifierPropertiesEXT,
}

impl Default for DrmFormatModifierPropertiesListEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT,
            next: ptr::null_mut(),
            drm_format_modifier_count: u32::default(),
            drm_format_modifier_properties: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkEventCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct EventCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: EventCreateFlags,
}

impl Default for EventCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EVENT_CREATE_INFO,
            next: ptr::null(),
            flags: EventCreateFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportFenceCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportFenceCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalFenceHandleTypeFlags,
}

impl Default for ExportFenceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_FENCE_CREATE_INFO,
            next: ptr::null(),
            handle_types: ExternalFenceHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportFenceWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportFenceWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}

impl Default for ExportFenceWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_FENCE_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            attributes: ptr::null(),
            dw_access: DWORD::default(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportMemoryAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}

impl Default for ExportMemoryAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_MEMORY_ALLOCATE_INFO,
            next: ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryAllocateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}

impl Default for ExportMemoryAllocateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_MEMORY_ALLOCATE_INFO_NV,
            next: ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}

impl Default for ExportMemoryWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            attributes: ptr::null(),
            dw_access: DWORD::default(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryWin32HandleInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
}

impl Default for ExportMemoryWin32HandleInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_NV,
            next: ptr::null(),
            attributes: ptr::null(),
            dw_access: DWORD::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportSemaphoreCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportSemaphoreCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalSemaphoreHandleTypeFlags,
}

impl Default for ExportSemaphoreCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_SEMAPHORE_CREATE_INFO,
            next: ptr::null(),
            handle_types: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportSemaphoreWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}

impl Default for ExportSemaphoreWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            attributes: ptr::null(),
            dw_access: DWORD::default(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtensionProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExtensionProperties {
    pub extension_name: StringArray<MAX_EXTENSION_NAME_SIZE>,
    pub spec_version: u32,
}

impl Default for ExtensionProperties {
    #[inline]
    fn default() -> Self {
        Self {
            extension_name: StringArray::default(),
            spec_version: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtent2D.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtent3D.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalBufferProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalBufferProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}

impl Default for ExternalBufferProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_BUFFER_PROPERTIES,
            next: ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalFenceProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    pub compatible_handle_types: ExternalFenceHandleTypeFlags,
    pub external_fence_features: ExternalFenceFeatureFlags,
}

impl Default for ExternalFenceProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_FENCE_PROPERTIES,
            next: ptr::null_mut(),
            export_from_imported_handle_types: ExternalFenceHandleTypeFlags::default(),
            compatible_handle_types: ExternalFenceHandleTypeFlags::default(),
            external_fence_features: ExternalFenceFeatureFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFormatANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalFormatANDROID {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub external_format: u64,
}

impl Default for ExternalFormatANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_FORMAT_ANDROID,
            next: ptr::null_mut(),
            external_format: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalImageFormatProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalImageFormatProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}

impl Default for ExternalImageFormatProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_IMAGE_FORMAT_PROPERTIES,
            next: ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalImageFormatPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ExternalImageFormatPropertiesNV {
    pub image_format_properties: ImageFormatProperties,
    pub external_memory_features: ExternalMemoryFeatureFlagsNV,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryBufferCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalMemoryBufferCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}

impl Default for ExternalMemoryBufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_MEMORY_BUFFER_CREATE_INFO,
            next: ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryImageCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalMemoryImageCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}

impl Default for ExternalMemoryImageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO,
            next: ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryImageCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalMemoryImageCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}

impl Default for ExternalMemoryImageCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV,
            next: ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ExternalMemoryProperties {
    pub external_memory_features: ExternalMemoryFeatureFlags,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ExternalSemaphoreProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub external_semaphore_features: ExternalSemaphoreFeatureFlags,
}

impl Default for ExternalSemaphoreProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::EXTERNAL_SEMAPHORE_PROPERTIES,
            next: ptr::null_mut(),
            export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            compatible_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            external_semaphore_features: ExternalSemaphoreFeatureFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FenceCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: FenceCreateFlags,
}

impl Default for FenceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FENCE_CREATE_INFO,
            next: ptr::null(),
            flags: FenceCreateFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceGetFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FenceGetFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
}

impl Default for FenceGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FENCE_GET_FD_INFO_KHR,
            next: ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceGetWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FenceGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
}

impl Default for FenceGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FENCE_GET_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFilterCubicImageViewImageFormatPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FilterCubicImageViewImageFormatPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub filter_cubic: Bool32,
    pub filter_cubic_minmax: Bool32,
}

impl Default for FilterCubicImageViewImageFormatPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT,
            next: ptr::null_mut(),
            filter_cubic: Bool32::default(),
            filter_cubic_minmax: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct FormatProperties {
    pub linear_tiling_features: FormatFeatureFlags,
    pub optimal_tiling_features: FormatFeatureFlags,
    pub buffer_features: FormatFeatureFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FormatProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub format_properties: FormatProperties,
}

impl Default for FormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FORMAT_PROPERTIES_2,
            next: ptr::null_mut(),
            format_properties: FormatProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties3KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FormatProperties3KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub linear_tiling_features: FormatFeatureFlags2KHR,
    pub optimal_tiling_features: FormatFeatureFlags2KHR,
    pub buffer_features: FormatFeatureFlags2KHR,
}

impl Default for FormatProperties3KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FORMAT_PROPERTIES_3_KHR,
            next: ptr::null_mut(),
            linear_tiling_features: FormatFeatureFlags2KHR::default(),
            optimal_tiling_features: FormatFeatureFlags2KHR::default(),
            buffer_features: FormatFeatureFlags2KHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFragmentShadingRateAttachmentInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FragmentShadingRateAttachmentInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fragment_shading_rate_attachment: *const AttachmentReference2,
    pub shading_rate_attachment_texel_size: Extent2D,
}

impl Default for FragmentShadingRateAttachmentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR,
            next: ptr::null(),
            fragment_shading_rate_attachment: ptr::null(),
            shading_rate_attachment_texel_size: Extent2D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferAttachmentImageInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FramebufferAttachmentImageInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ImageCreateFlags,
    pub usage: ImageUsageFlags,
    pub width: u32,
    pub height: u32,
    pub layer_count: u32,
    pub view_format_count: u32,
    pub view_formats: *const Format,
}

impl Default for FramebufferAttachmentImageInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FRAMEBUFFER_ATTACHMENT_IMAGE_INFO,
            next: ptr::null(),
            flags: ImageCreateFlags::default(),
            usage: ImageUsageFlags::default(),
            width: u32::default(),
            height: u32::default(),
            layer_count: u32::default(),
            view_format_count: u32::default(),
            view_formats: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferAttachmentsCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FramebufferAttachmentsCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attachment_image_info_count: u32,
    pub attachment_image_infos: *const FramebufferAttachmentImageInfo,
}

impl Default for FramebufferAttachmentsCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FRAMEBUFFER_ATTACHMENTS_CREATE_INFO,
            next: ptr::null(),
            attachment_image_info_count: u32::default(),
            attachment_image_infos: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FramebufferCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub render_pass: RenderPass,
    pub attachment_count: u32,
    pub attachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}

impl Default for FramebufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FRAMEBUFFER_CREATE_INFO,
            next: ptr::null(),
            flags: FramebufferCreateFlags::default(),
            render_pass: RenderPass::default(),
            attachment_count: u32::default(),
            attachments: ptr::null(),
            width: u32::default(),
            height: u32::default(),
            layers: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferMixedSamplesCombinationNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct FramebufferMixedSamplesCombinationNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub coverage_reduction_mode: CoverageReductionModeNV,
    pub rasterization_samples: SampleCountFlags,
    pub depth_stencil_samples: SampleCountFlags,
    pub color_samples: SampleCountFlags,
}

impl Default for FramebufferMixedSamplesCombinationNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV,
            next: ptr::null_mut(),
            coverage_reduction_mode: CoverageReductionModeNV::default(),
            rasterization_samples: SampleCountFlags::default(),
            depth_stencil_samples: SampleCountFlags::default(),
            color_samples: SampleCountFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeneratedCommandsInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GeneratedCommandsInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub stream_count: u32,
    pub streams: *const IndirectCommandsStreamNV,
    pub sequences_count: u32,
    pub preprocess_buffer: Buffer,
    pub preprocess_offset: DeviceSize,
    pub preprocess_size: DeviceSize,
    pub sequences_count_buffer: Buffer,
    pub sequences_count_offset: DeviceSize,
    pub sequences_index_buffer: Buffer,
    pub sequences_index_offset: DeviceSize,
}

impl Default for GeneratedCommandsInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GENERATED_COMMANDS_INFO_NV,
            next: ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            stream_count: u32::default(),
            streams: ptr::null(),
            sequences_count: u32::default(),
            preprocess_buffer: Buffer::default(),
            preprocess_offset: DeviceSize::default(),
            preprocess_size: DeviceSize::default(),
            sequences_count_buffer: Buffer::default(),
            sequences_count_offset: DeviceSize::default(),
            sequences_index_buffer: Buffer::default(),
            sequences_index_offset: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeneratedCommandsMemoryRequirementsInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GeneratedCommandsMemoryRequirementsInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub max_sequences_count: u32,
}

impl Default for GeneratedCommandsMemoryRequirementsInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV,
            next: ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            max_sequences_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryAABBNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GeometryAABBNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub aabb_data: Buffer,
    pub num_aab_bs: u32,
    pub stride: u32,
    pub offset: DeviceSize,
}

impl Default for GeometryAABBNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GEOMETRY_AABB_NV,
            next: ptr::null(),
            aabb_data: Buffer::default(),
            num_aab_bs: u32::default(),
            stride: u32::default(),
            offset: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryDataNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct GeometryDataNV {
    pub triangles: GeometryTrianglesNV,
    pub aabbs: GeometryAABBNV,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GeometryNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub geometry_type: GeometryTypeKHR,
    pub geometry: GeometryDataNV,
    pub flags: GeometryFlagsKHR,
}

impl Default for GeometryNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GEOMETRY_NV,
            next: ptr::null(),
            geometry_type: GeometryTypeKHR::default(),
            geometry: GeometryDataNV::default(),
            flags: GeometryFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeometryTrianglesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GeometryTrianglesNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub vertex_data: Buffer,
    pub vertex_offset: DeviceSize,
    pub vertex_count: u32,
    pub vertex_stride: DeviceSize,
    pub vertex_format: Format,
    pub index_data: Buffer,
    pub index_offset: DeviceSize,
    pub index_count: u32,
    pub index_type: IndexType,
    pub transform_data: Buffer,
    pub transform_offset: DeviceSize,
}

impl Default for GeometryTrianglesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GEOMETRY_TRIANGLES_NV,
            next: ptr::null(),
            vertex_data: Buffer::default(),
            vertex_offset: DeviceSize::default(),
            vertex_count: u32::default(),
            vertex_stride: DeviceSize::default(),
            vertex_format: Format::default(),
            index_data: Buffer::default(),
            index_offset: DeviceSize::default(),
            index_count: u32::default(),
            index_type: IndexType::default(),
            transform_data: Buffer::default(),
            transform_offset: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsPipelineCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GraphicsPipelineCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub stages: *const PipelineShaderStageCreateInfo,
    pub vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub input_assembly_state: *const PipelineInputAssemblyStateCreateInfo,
    pub tessellation_state: *const PipelineTessellationStateCreateInfo,
    pub viewport_state: *const PipelineViewportStateCreateInfo,
    pub rasterization_state: *const PipelineRasterizationStateCreateInfo,
    pub multisample_state: *const PipelineMultisampleStateCreateInfo,
    pub depth_stencil_state: *const PipelineDepthStencilStateCreateInfo,
    pub color_blend_state: *const PipelineColorBlendStateCreateInfo,
    pub dynamic_state: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}

impl Default for GraphicsPipelineCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GRAPHICS_PIPELINE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            stages: ptr::null(),
            vertex_input_state: ptr::null(),
            input_assembly_state: ptr::null(),
            tessellation_state: ptr::null(),
            viewport_state: ptr::null(),
            rasterization_state: ptr::null(),
            multisample_state: ptr::null(),
            depth_stencil_state: ptr::null(),
            color_blend_state: ptr::null(),
            dynamic_state: ptr::null(),
            layout: PipelineLayout::default(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsPipelineShaderGroupsCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GraphicsPipelineShaderGroupsCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub group_count: u32,
    pub groups: *const GraphicsShaderGroupCreateInfoNV,
    pub pipeline_count: u32,
    pub pipelines: *const Pipeline,
}

impl Default for GraphicsPipelineShaderGroupsCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV,
            next: ptr::null(),
            group_count: u32::default(),
            groups: ptr::null(),
            pipeline_count: u32::default(),
            pipelines: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsShaderGroupCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct GraphicsShaderGroupCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub stage_count: u32,
    pub stages: *const PipelineShaderStageCreateInfo,
    pub vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub tessellation_state: *const PipelineTessellationStateCreateInfo,
}

impl Default for GraphicsShaderGroupCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::GRAPHICS_SHADER_GROUP_CREATE_INFO_NV,
            next: ptr::null(),
            stage_count: u32::default(),
            stages: ptr::null(),
            vertex_input_state: ptr::null(),
            tessellation_state: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkHdrMetadataEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct HdrMetadataEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub display_primary_red: XYColorEXT,
    pub display_primary_green: XYColorEXT,
    pub display_primary_blue: XYColorEXT,
    pub white_point: XYColorEXT,
    pub max_luminance: f32,
    pub min_luminance: f32,
    pub max_content_light_level: f32,
    pub max_frame_average_light_level: f32,
}

impl Default for HdrMetadataEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::HDR_METADATA_EXT,
            next: ptr::null(),
            display_primary_red: XYColorEXT::default(),
            display_primary_green: XYColorEXT::default(),
            display_primary_blue: XYColorEXT::default(),
            white_point: XYColorEXT::default(),
            max_luminance: f32::default(),
            min_luminance: f32::default(),
            max_content_light_level: f32::default(),
            max_frame_average_light_level: f32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkHeadlessSurfaceCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct HeadlessSurfaceCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: HeadlessSurfaceCreateFlagsEXT,
}

impl Default for HeadlessSurfaceCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::HEADLESS_SURFACE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: HeadlessSurfaceCreateFlagsEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIOSSurfaceCreateInfoMVK.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct IOSSurfaceCreateInfoMVK {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: IOSSurfaceCreateFlagsMVK,
    pub view: *const c_void,
}

impl Default for IOSSurfaceCreateInfoMVK {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IOS_SURFACE_CREATE_INFO_MVK,
            next: ptr::null(),
            flags: IOSSurfaceCreateFlagsMVK::default(),
            view: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageBlit.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageBlit {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offsets: [Offset3D; 2],
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offsets: [Offset3D; 2],
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageBlit2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageBlit2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_subresource: ImageSubresourceLayers,
    pub src_offsets: [Offset3D; 2],
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offsets: [Offset3D; 2],
}

impl Default for ImageBlit2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_BLIT_2_KHR,
            next: ptr::null(),
            src_subresource: ImageSubresourceLayers::default(),
            src_offsets: [Offset3D::default(); 2],
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offsets: [Offset3D::default(); 2],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageConstraintsInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageConstraintsInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub format_constraints_count: u32,
    pub format_constraints: *const ImageFormatConstraintsInfoFUCHSIA,
    pub buffer_collection_constraints: BufferCollectionConstraintsInfoFUCHSIA,
    pub flags: ImageConstraintsInfoFlagsFUCHSIA,
}

impl Default for ImageConstraintsInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_CONSTRAINTS_INFO_FUCHSIA,
            next: ptr::null(),
            format_constraints_count: u32::default(),
            format_constraints: ptr::null(),
            buffer_collection_constraints: BufferCollectionConstraintsInfoFUCHSIA::default(),
            flags: ImageConstraintsInfoFlagsFUCHSIA::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCopy.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageCopy {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCopy2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageCopy2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}

impl Default for ImageCopy2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_COPY_2_KHR,
            next: ptr::null(),
            src_subresource: ImageSubresourceLayers::default(),
            src_offset: Offset3D::default(),
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offset: Offset3D::default(),
            extent: Extent3D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ImageCreateFlags,
    pub image_type: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mip_levels: u32,
    pub array_layers: u32,
    pub samples: SampleCountFlags,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub queue_family_indices: *const u32,
    pub initial_layout: ImageLayout,
}

impl Default for ImageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_CREATE_INFO,
            next: ptr::null(),
            flags: ImageCreateFlags::default(),
            image_type: ImageType::default(),
            format: Format::default(),
            extent: Extent3D::default(),
            mip_levels: u32::default(),
            array_layers: u32::default(),
            samples: SampleCountFlags::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            queue_family_indices: ptr::null(),
            initial_layout: ImageLayout::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageDrmFormatModifierExplicitCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageDrmFormatModifierExplicitCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub drm_format_modifier: u64,
    pub drm_format_modifier_plane_count: u32,
    pub plane_layouts: *const SubresourceLayout,
}

impl Default for ImageDrmFormatModifierExplicitCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT,
            next: ptr::null(),
            drm_format_modifier: u64::default(),
            drm_format_modifier_plane_count: u32::default(),
            plane_layouts: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageDrmFormatModifierListCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageDrmFormatModifierListCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub drm_format_modifier_count: u32,
    pub drm_format_modifiers: *const u64,
}

impl Default for ImageDrmFormatModifierListCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT,
            next: ptr::null(),
            drm_format_modifier_count: u32::default(),
            drm_format_modifiers: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageDrmFormatModifierPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageDrmFormatModifierPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub drm_format_modifier: u64,
}

impl Default for ImageDrmFormatModifierPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT,
            next: ptr::null_mut(),
            drm_format_modifier: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatConstraintsInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageFormatConstraintsInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image_create_info: ImageCreateInfo,
    pub required_format_features: FormatFeatureFlags,
    pub flags: ImageFormatConstraintsFlagsFUCHSIA,
    pub sysmem_pixel_format: u64,
    pub color_space_count: u32,
    pub color_spaces: *const SysmemColorSpaceFUCHSIA,
}

impl Default for ImageFormatConstraintsInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA,
            next: ptr::null(),
            image_create_info: ImageCreateInfo::default(),
            required_format_features: FormatFeatureFlags::default(),
            flags: ImageFormatConstraintsFlagsFUCHSIA::default(),
            sysmem_pixel_format: u64::default(),
            color_space_count: u32::default(),
            color_spaces: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatListCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageFormatListCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub view_format_count: u32,
    pub view_formats: *const Format,
}

impl Default for ImageFormatListCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_FORMAT_LIST_CREATE_INFO,
            next: ptr::null(),
            view_format_count: u32::default(),
            view_formats: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageFormatProperties {
    pub max_extent: Extent3D,
    pub max_mip_levels: u32,
    pub max_array_layers: u32,
    pub sample_counts: SampleCountFlags,
    pub max_resource_size: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageFormatProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub image_format_properties: ImageFormatProperties,
}

impl Default for ImageFormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_FORMAT_PROPERTIES_2,
            next: ptr::null_mut(),
            image_format_properties: ImageFormatProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageMemoryBarrier.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageMemoryBarrier {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub old_layout: ImageLayout,
    pub new_layout: ImageLayout,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub image: Image,
    pub subresource_range: ImageSubresourceRange,
}

impl Default for ImageMemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_MEMORY_BARRIER,
            next: ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            old_layout: ImageLayout::default(),
            new_layout: ImageLayout::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            image: Image::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageMemoryBarrier2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageMemoryBarrier2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_stage_mask: PipelineStageFlags2KHR,
    pub src_access_mask: AccessFlags2KHR,
    pub dst_stage_mask: PipelineStageFlags2KHR,
    pub dst_access_mask: AccessFlags2KHR,
    pub old_layout: ImageLayout,
    pub new_layout: ImageLayout,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub image: Image,
    pub subresource_range: ImageSubresourceRange,
}

impl Default for ImageMemoryBarrier2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_MEMORY_BARRIER_2_KHR,
            next: ptr::null(),
            src_stage_mask: PipelineStageFlags2KHR::default(),
            src_access_mask: AccessFlags2KHR::default(),
            dst_stage_mask: PipelineStageFlags2KHR::default(),
            dst_access_mask: AccessFlags2KHR::default(),
            old_layout: ImageLayout::default(),
            new_layout: ImageLayout::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            image: Image::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageMemoryRequirementsInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image: Image,
}

impl Default for ImageMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_MEMORY_REQUIREMENTS_INFO_2,
            next: ptr::null(),
            image: Image::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePipeSurfaceCreateInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImagePipeSurfaceCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ImagePipeSurfaceCreateFlagsFUCHSIA,
    pub image_pipe_handle: zx_handle_t,
}

impl Default for ImagePipeSurfaceCreateInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA,
            next: ptr::null(),
            flags: ImagePipeSurfaceCreateFlagsFUCHSIA::default(),
            image_pipe_handle: zx_handle_t::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePlaneMemoryRequirementsInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImagePlaneMemoryRequirementsInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
}

impl Default for ImagePlaneMemoryRequirementsInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO,
            next: ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageResolve.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageResolve {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageResolve2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageResolve2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}

impl Default for ImageResolve2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_RESOLVE_2_KHR,
            next: ptr::null(),
            src_subresource: ImageSubresourceLayers::default(),
            src_offset: Offset3D::default(),
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offset: Offset3D::default(),
            extent: Extent3D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSparseMemoryRequirementsInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageSparseMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image: Image,
}

impl Default for ImageSparseMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2,
            next: ptr::null(),
            image: Image::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageStencilUsageCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageStencilUsageCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub stencil_usage: ImageUsageFlags,
}

impl Default for ImageStencilUsageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_STENCIL_USAGE_CREATE_INFO,
            next: ptr::null(),
            stencil_usage: ImageUsageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresource.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageSubresource {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub array_layer: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresourceLayers.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageSubresourceLayers {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresourceRange.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ImageSubresourceRange {
    pub aspect_mask: ImageAspectFlags,
    pub base_mip_level: u32,
    pub level_count: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSwapchainCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageSwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain: SwapchainKHR,
}

impl Default for ImageSwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_SWAPCHAIN_CREATE_INFO_KHR,
            next: ptr::null(),
            swapchain: SwapchainKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewASTCDecodeModeEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageViewASTCDecodeModeEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub decode_mode: Format,
}

impl Default for ImageViewASTCDecodeModeEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_VIEW_ASTC_DECODE_MODE_EXT,
            next: ptr::null(),
            decode_mode: Format::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewAddressPropertiesNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageViewAddressPropertiesNVX {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_address: DeviceAddress,
    pub size: DeviceSize,
}

impl Default for ImageViewAddressPropertiesNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_VIEW_ADDRESS_PROPERTIES_NVX,
            next: ptr::null_mut(),
            device_address: DeviceAddress::default(),
            size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageViewCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub view_type: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresource_range: ImageSubresourceRange,
}

impl Default for ImageViewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_VIEW_CREATE_INFO,
            next: ptr::null(),
            flags: ImageViewCreateFlags::default(),
            image: Image::default(),
            view_type: ImageViewType::default(),
            format: Format::default(),
            components: ComponentMapping::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewHandleInfoNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageViewHandleInfoNVX {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image_view: ImageView,
    pub descriptor_type: DescriptorType,
    pub sampler: Sampler,
}

impl Default for ImageViewHandleInfoNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_VIEW_HANDLE_INFO_NVX,
            next: ptr::null(),
            image_view: ImageView::default(),
            descriptor_type: DescriptorType::default(),
            sampler: Sampler::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewUsageCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImageViewUsageCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub usage: ImageUsageFlags,
}

impl Default for ImageViewUsageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMAGE_VIEW_USAGE_CREATE_INFO,
            next: ptr::null(),
            usage: ImageUsageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportAndroidHardwareBufferInfoANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportAndroidHardwareBufferInfoANDROID {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub buffer: *mut AHardwareBuffer,
}

impl Default for ImportAndroidHardwareBufferInfoANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID,
            next: ptr::null(),
            buffer: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportFenceFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportFenceFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub fd: c_int,
}

impl Default for ImportFenceFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_FENCE_FD_INFO_KHR,
            next: ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportFenceWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportFenceWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}

impl Default for ImportFenceWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_FENCE_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            handle: ptr::null_mut(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryBufferCollectionFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryBufferCollectionFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub collection: BufferCollectionFUCHSIA,
    pub index: u32,
}

impl Default for ImportMemoryBufferCollectionFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA,
            next: ptr::null(),
            collection: BufferCollectionFUCHSIA::default(),
            index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub fd: c_int,
}

impl Default for ImportMemoryFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_FD_INFO_KHR,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryHostPointerInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryHostPointerInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub host_pointer: *mut c_void,
}

impl Default for ImportMemoryHostPointerInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_HOST_POINTER_INFO_EXT,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            host_pointer: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}

impl Default for ImportMemoryWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: ptr::null_mut(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryWin32HandleInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlagsNV,
    pub handle: HANDLE,
}

impl Default for ImportMemoryWin32HandleInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_NV,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlagsNV::default(),
            handle: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryZirconHandleInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportMemoryZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: zx_handle_t,
}

impl Default for ImportMemoryZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: zx_handle_t::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportSemaphoreFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportSemaphoreFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub fd: c_int,
}

impl Default for ImportSemaphoreFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_SEMAPHORE_FD_INFO_KHR,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportSemaphoreWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}

impl Default for ImportSemaphoreWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            handle: ptr::null_mut(),
            name: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportSemaphoreZirconHandleInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ImportSemaphoreZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub zircon_handle: zx_handle_t,
}

impl Default for ImportSemaphoreZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            zircon_handle: zx_handle_t::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct IndirectCommandsLayoutCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: IndirectCommandsLayoutUsageFlagsNV,
    pub pipeline_bind_point: PipelineBindPoint,
    pub token_count: u32,
    pub tokens: *const IndirectCommandsLayoutTokenNV,
    pub stream_count: u32,
    pub stream_strides: *const u32,
}

impl Default for IndirectCommandsLayoutCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV,
            next: ptr::null(),
            flags: IndirectCommandsLayoutUsageFlagsNV::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            token_count: u32::default(),
            tokens: ptr::null(),
            stream_count: u32::default(),
            stream_strides: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutTokenNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct IndirectCommandsLayoutTokenNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub token_type: IndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertex_binding_unit: u32,
    pub vertex_dynamic_stride: Bool32,
    pub pushconstant_pipeline_layout: PipelineLayout,
    pub pushconstant_shader_stage_flags: ShaderStageFlags,
    pub pushconstant_offset: u32,
    pub pushconstant_size: u32,
    pub indirect_state_flags: IndirectStateFlagsNV,
    pub index_type_count: u32,
    pub index_types: *const IndexType,
    pub index_type_values: *const u32,
}

impl Default for IndirectCommandsLayoutTokenNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::INDIRECT_COMMANDS_LAYOUT_TOKEN_NV,
            next: ptr::null(),
            token_type: IndirectCommandsTokenTypeNV::default(),
            stream: u32::default(),
            offset: u32::default(),
            vertex_binding_unit: u32::default(),
            vertex_dynamic_stride: Bool32::default(),
            pushconstant_pipeline_layout: PipelineLayout::default(),
            pushconstant_shader_stage_flags: ShaderStageFlags::default(),
            pushconstant_offset: u32::default(),
            pushconstant_size: u32::default(),
            indirect_state_flags: IndirectStateFlagsNV::default(),
            index_type_count: u32::default(),
            index_types: ptr::null(),
            index_type_values: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsStreamNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct IndirectCommandsStreamNV {
    pub buffer: Buffer,
    pub offset: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInitializePerformanceApiInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct InitializePerformanceApiInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub user_data: *mut c_void,
}

impl Default for InitializePerformanceApiInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::INITIALIZE_PERFORMANCE_API_INFO_INTEL,
            next: ptr::null(),
            user_data: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInputAttachmentAspectReference.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct InputAttachmentAspectReference {
    pub subpass: u32,
    pub input_attachment_index: u32,
    pub aspect_mask: ImageAspectFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInstanceCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct InstanceCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: InstanceCreateFlags,
    pub application_info: *const ApplicationInfo,
    pub enabled_layer_count: u32,
    pub enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub enabled_extension_names: *const *const c_char,
}

impl Default for InstanceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::INSTANCE_CREATE_INFO,
            next: ptr::null(),
            flags: InstanceCreateFlags::default(),
            application_info: ptr::null(),
            enabled_layer_count: u32::default(),
            enabled_layer_names: ptr::null(),
            enabled_extension_count: u32::default(),
            enabled_extension_names: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkLayerProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct LayerProperties {
    pub layer_name: StringArray<MAX_EXTENSION_NAME_SIZE>,
    pub spec_version: u32,
    pub implementation_version: u32,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
}

impl Default for LayerProperties {
    #[inline]
    fn default() -> Self {
        Self {
            layer_name: StringArray::default(),
            spec_version: u32::default(),
            implementation_version: u32::default(),
            description: StringArray::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMacOSSurfaceCreateInfoMVK.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MacOSSurfaceCreateInfoMVK {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: MacOSSurfaceCreateFlagsMVK,
    pub view: *const c_void,
}

impl Default for MacOSSurfaceCreateInfoMVK {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MACOS_SURFACE_CREATE_INFO_MVK,
            next: ptr::null(),
            flags: MacOSSurfaceCreateFlagsMVK::default(),
            view: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMappedMemoryRange.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MappedMemoryRange {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

impl Default for MappedMemoryRange {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MAPPED_MEMORY_RANGE,
            next: ptr::null(),
            memory: DeviceMemory::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryAllocateFlagsInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: MemoryAllocateFlags,
    pub device_mask: u32,
}

impl Default for MemoryAllocateFlagsInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_ALLOCATE_FLAGS_INFO,
            next: ptr::null(),
            flags: MemoryAllocateFlags::default(),
            device_mask: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_index: u32,
}

impl Default for MemoryAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_ALLOCATE_INFO,
            next: ptr::null(),
            allocation_size: DeviceSize::default(),
            memory_type_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryBarrier.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryBarrier {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
}

impl Default for MemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_BARRIER,
            next: ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryBarrier2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryBarrier2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_stage_mask: PipelineStageFlags2KHR,
    pub src_access_mask: AccessFlags2KHR,
    pub dst_stage_mask: PipelineStageFlags2KHR,
    pub dst_access_mask: AccessFlags2KHR,
}

impl Default for MemoryBarrier2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_BARRIER_2_KHR,
            next: ptr::null(),
            src_stage_mask: PipelineStageFlags2KHR::default(),
            src_access_mask: AccessFlags2KHR::default(),
            dst_stage_mask: PipelineStageFlags2KHR::default(),
            dst_access_mask: AccessFlags2KHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryDedicatedAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryDedicatedAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}

impl Default for MemoryDedicatedAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_DEDICATED_ALLOCATE_INFO,
            next: ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryDedicatedRequirements.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryDedicatedRequirements {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub prefers_dedicated_allocation: Bool32,
    pub requires_dedicated_allocation: Bool32,
}

impl Default for MemoryDedicatedRequirements {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_DEDICATED_REQUIREMENTS,
            next: ptr::null_mut(),
            prefers_dedicated_allocation: Bool32::default(),
            requires_dedicated_allocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryFdPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryFdPropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_type_bits: u32,
}

impl Default for MemoryFdPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_FD_PROPERTIES_KHR,
            next: ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetAndroidHardwareBufferInfoANDROID.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryGetAndroidHardwareBufferInfoANDROID {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
}

impl Default for MemoryGetAndroidHardwareBufferInfoANDROID {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID,
            next: ptr::null(),
            memory: DeviceMemory::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryGetFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for MemoryGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_GET_FD_INFO_KHR,
            next: ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetRemoteAddressInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryGetRemoteAddressInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for MemoryGetRemoteAddressInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_GET_REMOTE_ADDRESS_INFO_NV,
            next: ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for MemoryGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_GET_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetZirconHandleInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryGetZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for MemoryGetZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA,
            next: ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryHeap.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct MemoryHeap {
    pub size: DeviceSize,
    pub flags: MemoryHeapFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryHostPointerPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryHostPointerPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_type_bits: u32,
}

impl Default for MemoryHostPointerPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_HOST_POINTER_PROPERTIES_EXT,
            next: ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryOpaqueCaptureAddressAllocateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryOpaqueCaptureAddressAllocateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub opaque_capture_address: u64,
}

impl Default for MemoryOpaqueCaptureAddressAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO,
            next: ptr::null(),
            opaque_capture_address: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryPriorityAllocateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MemoryPriorityAllocateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub priority: f32,
}

impl Default for MemoryPriorityAllocateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_PRIORITY_ALLOCATE_INFO_EXT,
            next: ptr::null(),
            priority: f32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryRequirements.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct MemoryRequirements {
    pub size: DeviceSize,
    pub alignment: DeviceSize,
    pub memory_type_bits: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryRequirements2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryRequirements2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_requirements: MemoryRequirements,
}

impl Default for MemoryRequirements2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_REQUIREMENTS_2,
            next: ptr::null_mut(),
            memory_requirements: MemoryRequirements::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryType.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct MemoryType {
    pub property_flags: MemoryPropertyFlags,
    pub heap_index: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryWin32HandlePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryWin32HandlePropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_type_bits: u32,
}

impl Default for MemoryWin32HandlePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_WIN32_HANDLE_PROPERTIES_KHR,
            next: ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryZirconHandlePropertiesFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MemoryZirconHandlePropertiesFUCHSIA {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_type_bits: u32,
}

impl Default for MemoryZirconHandlePropertiesFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA,
            next: ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMetalSurfaceCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MetalSurfaceCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: MetalSurfaceCreateFlagsEXT,
    pub layer: *const CAMetalLayer,
}

impl Default for MetalSurfaceCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::METAL_SURFACE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: MetalSurfaceCreateFlagsEXT::default(),
            layer: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMultiDrawIndexedInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct MultiDrawIndexedInfoEXT {
    pub first_index: u32,
    pub index_count: u32,
    pub vertex_offset: i32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMultiDrawInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct MultiDrawInfoEXT {
    pub first_vertex: u32,
    pub vertex_count: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMultisamplePropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MultisamplePropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_sample_location_grid_size: Extent2D,
}

impl Default for MultisamplePropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MULTISAMPLE_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_sample_location_grid_size: Extent2D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMutableDescriptorTypeCreateInfoVALVE.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MutableDescriptorTypeCreateInfoVALVE {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub mutable_descriptor_type_list_count: u32,
    pub mutable_descriptor_type_lists: *const MutableDescriptorTypeListVALVE,
}

impl Default for MutableDescriptorTypeCreateInfoVALVE {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE,
            next: ptr::null(),
            mutable_descriptor_type_list_count: u32::default(),
            mutable_descriptor_type_lists: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMutableDescriptorTypeListVALVE.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct MutableDescriptorTypeListVALVE {
    pub descriptor_type_count: u32,
    pub descriptor_types: *const DescriptorType,
}

impl Default for MutableDescriptorTypeListVALVE {
    #[inline]
    fn default() -> Self {
        Self {
            descriptor_type_count: u32::default(),
            descriptor_types: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkOffset2D.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkOffset3D.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPastPresentationTimingGOOGLE.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PastPresentationTimingGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
    pub actual_present_time: u64,
    pub earliest_present_time: u64,
    pub present_margin: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceConfigurationAcquireInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceConfigurationAcquireInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: PerformanceConfigurationTypeINTEL,
}

impl Default for PerformanceConfigurationAcquireInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL,
            next: ptr::null(),
            type_: PerformanceConfigurationTypeINTEL::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterDescriptionKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceCounterDescriptionKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub flags: PerformanceCounterDescriptionFlagsKHR,
    pub name: StringArray<MAX_DESCRIPTION_SIZE>,
    pub category: StringArray<MAX_DESCRIPTION_SIZE>,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
}

impl Default for PerformanceCounterDescriptionKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_COUNTER_DESCRIPTION_KHR,
            next: ptr::null_mut(),
            flags: PerformanceCounterDescriptionFlagsKHR::default(),
            name: StringArray::default(),
            category: StringArray::default(),
            description: StringArray::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceCounterKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceCounterKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub unit: PerformanceCounterUnitKHR,
    pub scope: PerformanceCounterScopeKHR,
    pub storage: PerformanceCounterStorageKHR,
    pub uuid: ByteArray<UUID_SIZE>,
}

impl Default for PerformanceCounterKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_COUNTER_KHR,
            next: ptr::null_mut(),
            unit: PerformanceCounterUnitKHR::default(),
            scope: PerformanceCounterScopeKHR::default(),
            storage: PerformanceCounterStorageKHR::default(),
            uuid: ByteArray::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceMarkerInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceMarkerInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub marker: u64,
}

impl Default for PerformanceMarkerInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_MARKER_INFO_INTEL,
            next: ptr::null(),
            marker: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceOverrideInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceOverrideInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: PerformanceOverrideTypeINTEL,
    pub enable: Bool32,
    pub parameter: u64,
}

impl Default for PerformanceOverrideInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_OVERRIDE_INFO_INTEL,
            next: ptr::null(),
            type_: PerformanceOverrideTypeINTEL::default(),
            enable: Bool32::default(),
            parameter: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceQuerySubmitInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceQuerySubmitInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub counter_pass_index: u32,
}

impl Default for PerformanceQuerySubmitInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_QUERY_SUBMIT_INFO_KHR,
            next: ptr::null(),
            counter_pass_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceStreamMarkerInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PerformanceStreamMarkerInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub marker: u32,
}

impl Default for PerformanceStreamMarkerInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PERFORMANCE_STREAM_MARKER_INFO_INTEL,
            next: ptr::null(),
            marker: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceValueINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
pub struct PerformanceValueINTEL {
    pub type_: PerformanceValueTypeINTEL,
    pub data: PerformanceValueDataINTEL,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice16BitStorageFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevice16BitStorageFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub storage_buffer_16bit_access: Bool32,
    pub uniform_and_storage_buffer_16bit_access: Bool32,
    pub storage_push_constant16: Bool32,
    pub storage_input_output16: Bool32,
}

impl Default for PhysicalDevice16BitStorageFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES,
            next: ptr::null_mut(),
            storage_buffer_16bit_access: Bool32::default(),
            uniform_and_storage_buffer_16bit_access: Bool32::default(),
            storage_push_constant16: Bool32::default(),
            storage_input_output16: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice4444FormatsFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevice4444FormatsFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub format_a4_r4_g4_b4: Bool32,
    pub format_a4_b4_g4_r4: Bool32,
}

impl Default for PhysicalDevice4444FormatsFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT,
            next: ptr::null_mut(),
            format_a4_r4_g4_b4: Bool32::default(),
            format_a4_b4_g4_r4: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice8BitStorageFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevice8BitStorageFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub storage_buffer_8bit_access: Bool32,
    pub uniform_and_storage_buffer_8bit_access: Bool32,
    pub storage_push_constant8: Bool32,
}

impl Default for PhysicalDevice8BitStorageFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES,
            next: ptr::null_mut(),
            storage_buffer_8bit_access: Bool32::default(),
            uniform_and_storage_buffer_8bit_access: Bool32::default(),
            storage_push_constant8: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceASTCDecodeFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceASTCDecodeFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub decode_mode_shared_exponent: Bool32,
}

impl Default for PhysicalDeviceASTCDecodeFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT,
            next: ptr::null_mut(),
            decode_mode_shared_exponent: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceAccelerationStructureFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceAccelerationStructureFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub acceleration_structure: Bool32,
    pub acceleration_structure_capture_replay: Bool32,
    pub acceleration_structure_indirect_build: Bool32,
    pub acceleration_structure_host_commands: Bool32,
    pub descriptor_binding_acceleration_structure_update_after_bind: Bool32,
}

impl Default for PhysicalDeviceAccelerationStructureFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR,
            next: ptr::null_mut(),
            acceleration_structure: Bool32::default(),
            acceleration_structure_capture_replay: Bool32::default(),
            acceleration_structure_indirect_build: Bool32::default(),
            acceleration_structure_host_commands: Bool32::default(),
            descriptor_binding_acceleration_structure_update_after_bind: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceAccelerationStructurePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceAccelerationStructurePropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_geometry_count: u64,
    pub max_instance_count: u64,
    pub max_primitive_count: u64,
    pub max_per_stage_descriptor_acceleration_structures: u32,
    pub max_per_stage_descriptor_update_after_bind_acceleration_structures: u32,
    pub max_descriptor_set_acceleration_structures: u32,
    pub max_descriptor_set_update_after_bind_acceleration_structures: u32,
    pub min_acceleration_structure_scratch_offset_alignment: u32,
}

impl Default for PhysicalDeviceAccelerationStructurePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR,
            next: ptr::null_mut(),
            max_geometry_count: u64::default(),
            max_instance_count: u64::default(),
            max_primitive_count: u64::default(),
            max_per_stage_descriptor_acceleration_structures: u32::default(),
            max_per_stage_descriptor_update_after_bind_acceleration_structures: u32::default(),
            max_descriptor_set_acceleration_structures: u32::default(),
            max_descriptor_set_update_after_bind_acceleration_structures: u32::default(),
            min_acceleration_structure_scratch_offset_alignment: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub advanced_blend_coherent_operations: Bool32,
}

impl Default for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT,
            next: ptr::null_mut(),
            advanced_blend_coherent_operations: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub advanced_blend_max_color_attachments: u32,
    pub advanced_blend_independent_blend: Bool32,
    pub advanced_blend_non_premultiplied_src_color: Bool32,
    pub advanced_blend_non_premultiplied_dst_color: Bool32,
    pub advanced_blend_correlated_overlap: Bool32,
    pub advanced_blend_all_operations: Bool32,
}

impl Default for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT,
            next: ptr::null_mut(),
            advanced_blend_max_color_attachments: u32::default(),
            advanced_blend_independent_blend: Bool32::default(),
            advanced_blend_non_premultiplied_src_color: Bool32::default(),
            advanced_blend_non_premultiplied_dst_color: Bool32::default(),
            advanced_blend_correlated_overlap: Bool32::default(),
            advanced_blend_all_operations: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBorderColorSwizzleFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceBorderColorSwizzleFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub border_color_swizzle: Bool32,
    pub border_color_swizzle_from_image: Bool32,
}

impl Default for PhysicalDeviceBorderColorSwizzleFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT,
            next: ptr::null_mut(),
            border_color_swizzle: Bool32::default(),
            border_color_swizzle_from_image: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBufferDeviceAddressFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceBufferDeviceAddressFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub buffer_device_address: Bool32,
    pub buffer_device_address_capture_replay: Bool32,
    pub buffer_device_address_multi_device: Bool32,
}

impl Default for PhysicalDeviceBufferDeviceAddressFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES,
            next: ptr::null_mut(),
            buffer_device_address: Bool32::default(),
            buffer_device_address_capture_replay: Bool32::default(),
            buffer_device_address_multi_device: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBufferDeviceAddressFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceBufferDeviceAddressFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub buffer_device_address: Bool32,
    pub buffer_device_address_capture_replay: Bool32,
    pub buffer_device_address_multi_device: Bool32,
}

impl Default for PhysicalDeviceBufferDeviceAddressFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT,
            next: ptr::null_mut(),
            buffer_device_address: Bool32::default(),
            buffer_device_address_capture_replay: Bool32::default(),
            buffer_device_address_multi_device: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCoherentMemoryFeaturesAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCoherentMemoryFeaturesAMD {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_coherent_memory: Bool32,
}

impl Default for PhysicalDeviceCoherentMemoryFeaturesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD,
            next: ptr::null_mut(),
            device_coherent_memory: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceColorWriteEnableFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceColorWriteEnableFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub color_write_enable: Bool32,
}

impl Default for PhysicalDeviceColorWriteEnableFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT,
            next: ptr::null_mut(),
            color_write_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceComputeShaderDerivativesFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceComputeShaderDerivativesFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub compute_derivative_group_quads: Bool32,
    pub compute_derivative_group_linear: Bool32,
}

impl Default for PhysicalDeviceComputeShaderDerivativesFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV,
            next: ptr::null_mut(),
            compute_derivative_group_quads: Bool32::default(),
            compute_derivative_group_linear: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceConditionalRenderingFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceConditionalRenderingFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub conditional_rendering: Bool32,
    pub inherited_conditional_rendering: Bool32,
}

impl Default for PhysicalDeviceConditionalRenderingFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT,
            next: ptr::null_mut(),
            conditional_rendering: Bool32::default(),
            inherited_conditional_rendering: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceConservativeRasterizationPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PhysicalDeviceConservativeRasterizationPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub primitive_overestimation_size: f32,
    pub max_extra_primitive_overestimation_size: f32,
    pub extra_primitive_overestimation_size_granularity: f32,
    pub primitive_underestimation: Bool32,
    pub conservative_point_and_line_rasterization: Bool32,
    pub degenerate_triangles_rasterized: Bool32,
    pub degenerate_lines_rasterized: Bool32,
    pub fully_covered_fragment_shader_input_variable: Bool32,
    pub conservative_rasterization_post_depth_coverage: Bool32,
}

impl Default for PhysicalDeviceConservativeRasterizationPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT,
            next: ptr::null_mut(),
            primitive_overestimation_size: f32::default(),
            max_extra_primitive_overestimation_size: f32::default(),
            extra_primitive_overestimation_size_granularity: f32::default(),
            primitive_underestimation: Bool32::default(),
            conservative_point_and_line_rasterization: Bool32::default(),
            degenerate_triangles_rasterized: Bool32::default(),
            degenerate_lines_rasterized: Bool32::default(),
            fully_covered_fragment_shader_input_variable: Bool32::default(),
            conservative_rasterization_post_depth_coverage: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCooperativeMatrixFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCooperativeMatrixFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub cooperative_matrix: Bool32,
    pub cooperative_matrix_robust_buffer_access: Bool32,
}

impl Default for PhysicalDeviceCooperativeMatrixFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV,
            next: ptr::null_mut(),
            cooperative_matrix: Bool32::default(),
            cooperative_matrix_robust_buffer_access: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCooperativeMatrixPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCooperativeMatrixPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub cooperative_matrix_supported_stages: ShaderStageFlags,
}

impl Default for PhysicalDeviceCooperativeMatrixPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV,
            next: ptr::null_mut(),
            cooperative_matrix_supported_stages: ShaderStageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCornerSampledImageFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCornerSampledImageFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub corner_sampled_image: Bool32,
}

impl Default for PhysicalDeviceCornerSampledImageFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV,
            next: ptr::null_mut(),
            corner_sampled_image: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCoverageReductionModeFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCoverageReductionModeFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub coverage_reduction_mode: Bool32,
}

impl Default for PhysicalDeviceCoverageReductionModeFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV,
            next: ptr::null_mut(),
            coverage_reduction_mode: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCustomBorderColorFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCustomBorderColorFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub custom_border_colors: Bool32,
    pub custom_border_color_without_format: Bool32,
}

impl Default for PhysicalDeviceCustomBorderColorFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT,
            next: ptr::null_mut(),
            custom_border_colors: Bool32::default(),
            custom_border_color_without_format: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceCustomBorderColorPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceCustomBorderColorPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_custom_border_color_samplers: u32,
}

impl Default for PhysicalDeviceCustomBorderColorPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_custom_border_color_samplers: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub dedicated_allocation_image_aliasing: Bool32,
}

impl Default for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV,
            next: ptr::null_mut(),
            dedicated_allocation_image_aliasing: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDepthClipEnableFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDepthClipEnableFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub depth_clip_enable: Bool32,
}

impl Default for PhysicalDeviceDepthClipEnableFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT,
            next: ptr::null_mut(),
            depth_clip_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDepthStencilResolveProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDepthStencilResolveProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub supported_depth_resolve_modes: ResolveModeFlags,
    pub supported_stencil_resolve_modes: ResolveModeFlags,
    pub independent_resolve_none: Bool32,
    pub independent_resolve: Bool32,
}

impl Default for PhysicalDeviceDepthStencilResolveProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES,
            next: ptr::null_mut(),
            supported_depth_resolve_modes: ResolveModeFlags::default(),
            supported_stencil_resolve_modes: ResolveModeFlags::default(),
            independent_resolve_none: Bool32::default(),
            independent_resolve: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDescriptorIndexingFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_input_attachment_array_dynamic_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_uniform_buffer_array_non_uniform_indexing: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_image_array_non_uniform_indexing: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_texel_buffer_array_non_uniform_indexing: Bool32,
    pub descriptor_binding_uniform_buffer_update_after_bind: Bool32,
    pub descriptor_binding_sampled_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_buffer_update_after_bind: Bool32,
    pub descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_storage_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_update_unused_while_pending: Bool32,
    pub descriptor_binding_partially_bound: Bool32,
    pub descriptor_binding_variable_descriptor_count: Bool32,
    pub runtime_descriptor_array: Bool32,
}

impl Default for PhysicalDeviceDescriptorIndexingFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES,
            next: ptr::null_mut(),
            shader_input_attachment_array_dynamic_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_uniform_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            descriptor_binding_uniform_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_sampled_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_storage_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_update_unused_while_pending: Bool32::default(),
            descriptor_binding_partially_bound: Bool32::default(),
            descriptor_binding_variable_descriptor_count: Bool32::default(),
            runtime_descriptor_array: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDescriptorIndexingProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_update_after_bind_descriptors_in_all_pools: u32,
    pub shader_uniform_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_image_array_non_uniform_indexing_native: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing_native: Bool32,
    pub robust_buffer_access_update_after_bind: Bool32,
    pub quad_divergent_implicit_lod: Bool32,
    pub max_per_stage_descriptor_update_after_bind_samplers: u32,
    pub max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_images: u32,
    pub max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    pub max_per_stage_update_after_bind_resources: u32,
    pub max_descriptor_set_update_after_bind_samplers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_sampled_images: u32,
    pub max_descriptor_set_update_after_bind_storage_images: u32,
    pub max_descriptor_set_update_after_bind_input_attachments: u32,
}

impl Default for PhysicalDeviceDescriptorIndexingProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES,
            next: ptr::null_mut(),
            max_update_after_bind_descriptors_in_all_pools: u32::default(),
            shader_uniform_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing_native: Bool32::default(),
            robust_buffer_access_update_after_bind: Bool32::default(),
            quad_divergent_implicit_lod: Bool32::default(),
            max_per_stage_descriptor_update_after_bind_samplers: u32::default(),
            max_per_stage_descriptor_update_after_bind_uniform_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_sampled_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_input_attachments: u32::default(),
            max_per_stage_update_after_bind_resources: u32::default(),
            max_descriptor_set_update_after_bind_samplers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_sampled_images: u32::default(),
            max_descriptor_set_update_after_bind_storage_images: u32::default(),
            max_descriptor_set_update_after_bind_input_attachments: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_generated_commands: Bool32,
}

impl Default for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV,
            next: ptr::null_mut(),
            device_generated_commands: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_graphics_shader_group_count: u32,
    pub max_indirect_sequence_count: u32,
    pub max_indirect_commands_token_count: u32,
    pub max_indirect_commands_stream_count: u32,
    pub max_indirect_commands_token_offset: u32,
    pub max_indirect_commands_stream_stride: u32,
    pub min_sequences_count_buffer_offset_alignment: u32,
    pub min_sequences_index_buffer_offset_alignment: u32,
    pub min_indirect_commands_buffer_offset_alignment: u32,
}

impl Default for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV,
            next: ptr::null_mut(),
            max_graphics_shader_group_count: u32::default(),
            max_indirect_sequence_count: u32::default(),
            max_indirect_commands_token_count: u32::default(),
            max_indirect_commands_stream_count: u32::default(),
            max_indirect_commands_token_offset: u32::default(),
            max_indirect_commands_stream_stride: u32::default(),
            min_sequences_count_buffer_offset_alignment: u32::default(),
            min_sequences_index_buffer_offset_alignment: u32::default(),
            min_indirect_commands_buffer_offset_alignment: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDeviceMemoryReportFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDeviceMemoryReportFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_memory_report: Bool32,
}

impl Default for PhysicalDeviceDeviceMemoryReportFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT,
            next: ptr::null_mut(),
            device_memory_report: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDiagnosticsConfigFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDiagnosticsConfigFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub diagnostics_config: Bool32,
}

impl Default for PhysicalDeviceDiagnosticsConfigFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV,
            next: ptr::null_mut(),
            diagnostics_config: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDiscardRectanglePropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_discard_rectangles: u32,
}

impl Default for PhysicalDeviceDiscardRectanglePropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_discard_rectangles: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDriverProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDriverProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub driver_id: DriverId,
    pub driver_name: StringArray<MAX_DRIVER_NAME_SIZE>,
    pub driver_info: StringArray<MAX_DRIVER_INFO_SIZE>,
    pub conformance_version: ConformanceVersion,
}

impl Default for PhysicalDeviceDriverProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DRIVER_PROPERTIES,
            next: ptr::null_mut(),
            driver_id: DriverId::default(),
            driver_name: StringArray::default(),
            driver_info: StringArray::default(),
            conformance_version: ConformanceVersion::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDrmPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceDrmPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub has_primary: Bool32,
    pub has_render: Bool32,
    pub primary_major: i64,
    pub primary_minor: i64,
    pub render_major: i64,
    pub render_minor: i64,
}

impl Default for PhysicalDeviceDrmPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_DRM_PROPERTIES_EXT,
            next: ptr::null_mut(),
            has_primary: Bool32::default(),
            has_render: Bool32::default(),
            primary_major: i64::default(),
            primary_minor: i64::default(),
            render_major: i64::default(),
            render_minor: i64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExclusiveScissorFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExclusiveScissorFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub exclusive_scissor: Bool32,
}

impl Default for PhysicalDeviceExclusiveScissorFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV,
            next: ptr::null_mut(),
            exclusive_scissor: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExtendedDynamicState2FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExtendedDynamicState2FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub extended_dynamic_state2: Bool32,
    pub extended_dynamic_state2_logic_op: Bool32,
    pub extended_dynamic_state2_patch_control_points: Bool32,
}

impl Default for PhysicalDeviceExtendedDynamicState2FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT,
            next: ptr::null_mut(),
            extended_dynamic_state2: Bool32::default(),
            extended_dynamic_state2_logic_op: Bool32::default(),
            extended_dynamic_state2_patch_control_points: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExtendedDynamicStateFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExtendedDynamicStateFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub extended_dynamic_state: Bool32,
}

impl Default for PhysicalDeviceExtendedDynamicStateFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT,
            next: ptr::null_mut(),
            extended_dynamic_state: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalBufferInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalBufferInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: BufferCreateFlags,
    pub usage: BufferUsageFlags,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for PhysicalDeviceExternalBufferInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO,
            next: ptr::null(),
            flags: BufferCreateFlags::default(),
            usage: BufferUsageFlags::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalFenceInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalFenceInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalFenceHandleTypeFlags,
}

impl Default for PhysicalDeviceExternalFenceInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO,
            next: ptr::null(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalImageFormatInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalImageFormatInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}

impl Default for PhysicalDeviceExternalImageFormatInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO,
            next: ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalMemoryHostPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalMemoryHostPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_imported_host_pointer_alignment: DeviceSize,
}

impl Default for PhysicalDeviceExternalMemoryHostPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT,
            next: ptr::null_mut(),
            min_imported_host_pointer_alignment: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalMemoryRDMAFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalMemoryRDMAFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub external_memory_rdma: Bool32,
}

impl Default for PhysicalDeviceExternalMemoryRDMAFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV,
            next: ptr::null_mut(),
            external_memory_rdma: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalSemaphoreInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceExternalSemaphoreInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}

impl Default for PhysicalDeviceExternalSemaphoreInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO,
            next: ptr::null(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFeatures {
    pub robust_buffer_access: Bool32,
    pub full_draw_index_uint32: Bool32,
    pub image_cube_array: Bool32,
    pub independent_blend: Bool32,
    pub geometry_shader: Bool32,
    pub tessellation_shader: Bool32,
    pub sample_rate_shading: Bool32,
    pub dual_src_blend: Bool32,
    pub logic_op: Bool32,
    pub multi_draw_indirect: Bool32,
    pub draw_indirect_first_instance: Bool32,
    pub depth_clamp: Bool32,
    pub depth_bias_clamp: Bool32,
    pub fill_mode_non_solid: Bool32,
    pub depth_bounds: Bool32,
    pub wide_lines: Bool32,
    pub large_points: Bool32,
    pub alpha_to_one: Bool32,
    pub multi_viewport: Bool32,
    pub sampler_anisotropy: Bool32,
    pub texture_compression_etc2: Bool32,
    pub texture_compression_astc_ldr: Bool32,
    pub texture_compression_bc: Bool32,
    pub occlusion_query_precise: Bool32,
    pub pipeline_statistics_query: Bool32,
    pub vertex_pipeline_stores_and_atomics: Bool32,
    pub fragment_stores_and_atomics: Bool32,
    pub shader_tessellation_and_geometry_point_size: Bool32,
    pub shader_image_gather_extended: Bool32,
    pub shader_storage_image_extended_formats: Bool32,
    pub shader_storage_image_multisample: Bool32,
    pub shader_storage_image_read_without_format: Bool32,
    pub shader_storage_image_write_without_format: Bool32,
    pub shader_uniform_buffer_array_dynamic_indexing: Bool32,
    pub shader_sampled_image_array_dynamic_indexing: Bool32,
    pub shader_storage_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_image_array_dynamic_indexing: Bool32,
    pub shader_clip_distance: Bool32,
    pub shader_cull_distance: Bool32,
    pub shader_float64: Bool32,
    pub shader_int64: Bool32,
    pub shader_int16: Bool32,
    pub shader_resource_residency: Bool32,
    pub shader_resource_min_lod: Bool32,
    pub sparse_binding: Bool32,
    pub sparse_residency_buffer: Bool32,
    pub sparse_residency_image_2d: Bool32,
    pub sparse_residency_image_3d: Bool32,
    pub sparse_residency2_samples: Bool32,
    pub sparse_residency4_samples: Bool32,
    pub sparse_residency8_samples: Bool32,
    pub sparse_residency16_samples: Bool32,
    pub sparse_residency_aliased: Bool32,
    pub variable_multisample_rate: Bool32,
    pub inherited_queries: Bool32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFeatures2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFeatures2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub features: PhysicalDeviceFeatures,
}

impl Default for PhysicalDeviceFeatures2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FEATURES_2,
            next: ptr::null_mut(),
            features: PhysicalDeviceFeatures::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFloatControlsProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub denorm_behavior_independence: ShaderFloatControlsIndependence,
    pub rounding_mode_independence: ShaderFloatControlsIndependence,
    pub shader_signed_zero_inf_nan_preserve_float16: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float32: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float64: Bool32,
    pub shader_denorm_preserve_float16: Bool32,
    pub shader_denorm_preserve_float32: Bool32,
    pub shader_denorm_preserve_float64: Bool32,
    pub shader_denorm_flush_to_zero_float16: Bool32,
    pub shader_denorm_flush_to_zero_float32: Bool32,
    pub shader_denorm_flush_to_zero_float64: Bool32,
    pub shader_rounding_mode_rte_float16: Bool32,
    pub shader_rounding_mode_rte_float32: Bool32,
    pub shader_rounding_mode_rte_float64: Bool32,
    pub shader_rounding_mode_rtz_float16: Bool32,
    pub shader_rounding_mode_rtz_float32: Bool32,
    pub shader_rounding_mode_rtz_float64: Bool32,
}

impl Default for PhysicalDeviceFloatControlsProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES,
            next: ptr::null_mut(),
            denorm_behavior_independence: ShaderFloatControlsIndependence::default(),
            rounding_mode_independence: ShaderFloatControlsIndependence::default(),
            shader_signed_zero_inf_nan_preserve_float16: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float32: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float64: Bool32::default(),
            shader_denorm_preserve_float16: Bool32::default(),
            shader_denorm_preserve_float32: Bool32::default(),
            shader_denorm_preserve_float64: Bool32::default(),
            shader_denorm_flush_to_zero_float16: Bool32::default(),
            shader_denorm_flush_to_zero_float32: Bool32::default(),
            shader_denorm_flush_to_zero_float64: Bool32::default(),
            shader_rounding_mode_rte_float16: Bool32::default(),
            shader_rounding_mode_rte_float32: Bool32::default(),
            shader_rounding_mode_rte_float64: Bool32::default(),
            shader_rounding_mode_rtz_float16: Bool32::default(),
            shader_rounding_mode_rtz_float32: Bool32::default(),
            shader_rounding_mode_rtz_float64: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentDensityMap2FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentDensityMap2FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub fragment_density_map_deferred: Bool32,
}

impl Default for PhysicalDeviceFragmentDensityMap2FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT,
            next: ptr::null_mut(),
            fragment_density_map_deferred: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentDensityMap2PropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentDensityMap2PropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub subsampled_loads: Bool32,
    pub subsampled_coarse_reconstruction_early_access: Bool32,
    pub max_subsampled_array_layers: u32,
    pub max_descriptor_set_subsampled_samplers: u32,
}

impl Default for PhysicalDeviceFragmentDensityMap2PropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT,
            next: ptr::null_mut(),
            subsampled_loads: Bool32::default(),
            subsampled_coarse_reconstruction_early_access: Bool32::default(),
            max_subsampled_array_layers: u32::default(),
            max_descriptor_set_subsampled_samplers: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentDensityMapFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentDensityMapFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub fragment_density_map: Bool32,
    pub fragment_density_map_dynamic: Bool32,
    pub fragment_density_map_non_subsampled_images: Bool32,
}

impl Default for PhysicalDeviceFragmentDensityMapFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT,
            next: ptr::null_mut(),
            fragment_density_map: Bool32::default(),
            fragment_density_map_dynamic: Bool32::default(),
            fragment_density_map_non_subsampled_images: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentDensityMapPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentDensityMapPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_fragment_density_texel_size: Extent2D,
    pub max_fragment_density_texel_size: Extent2D,
    pub fragment_density_invocations: Bool32,
}

impl Default for PhysicalDeviceFragmentDensityMapPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT,
            next: ptr::null_mut(),
            min_fragment_density_texel_size: Extent2D::default(),
            max_fragment_density_texel_size: Extent2D::default(),
            fragment_density_invocations: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub fragment_shader_barycentric: Bool32,
}

impl Default for PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV,
            next: ptr::null_mut(),
            fragment_shader_barycentric: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub fragment_shader_sample_interlock: Bool32,
    pub fragment_shader_pixel_interlock: Bool32,
    pub fragment_shader_shading_rate_interlock: Bool32,
}

impl Default for PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT,
            next: ptr::null_mut(),
            fragment_shader_sample_interlock: Bool32::default(),
            fragment_shader_pixel_interlock: Bool32::default(),
            fragment_shader_shading_rate_interlock: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub fragment_shading_rate_enums: Bool32,
    pub supersample_fragment_shading_rates: Bool32,
    pub no_invocation_fragment_shading_rates: Bool32,
}

impl Default for PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV,
            next: ptr::null_mut(),
            fragment_shading_rate_enums: Bool32::default(),
            supersample_fragment_shading_rates: Bool32::default(),
            no_invocation_fragment_shading_rates: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_fragment_shading_rate_invocation_count: SampleCountFlags,
}

impl Default for PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV,
            next: ptr::null_mut(),
            max_fragment_shading_rate_invocation_count: SampleCountFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShadingRateFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShadingRateFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub pipeline_fragment_shading_rate: Bool32,
    pub primitive_fragment_shading_rate: Bool32,
    pub attachment_fragment_shading_rate: Bool32,
}

impl Default for PhysicalDeviceFragmentShadingRateFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR,
            next: ptr::null_mut(),
            pipeline_fragment_shading_rate: Bool32::default(),
            primitive_fragment_shading_rate: Bool32::default(),
            attachment_fragment_shading_rate: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShadingRateKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShadingRateKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub sample_counts: SampleCountFlags,
    pub fragment_size: Extent2D,
}

impl Default for PhysicalDeviceFragmentShadingRateKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR,
            next: ptr::null_mut(),
            sample_counts: SampleCountFlags::default(),
            fragment_size: Extent2D::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFragmentShadingRatePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceFragmentShadingRatePropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_fragment_shading_rate_attachment_texel_size: Extent2D,
    pub max_fragment_shading_rate_attachment_texel_size: Extent2D,
    pub max_fragment_shading_rate_attachment_texel_size_aspect_ratio: u32,
    pub primitive_fragment_shading_rate_with_multiple_viewports: Bool32,
    pub layered_shading_rate_attachments: Bool32,
    pub fragment_shading_rate_non_trivial_combiner_ops: Bool32,
    pub max_fragment_size: Extent2D,
    pub max_fragment_size_aspect_ratio: u32,
    pub max_fragment_shading_rate_coverage_samples: u32,
    pub max_fragment_shading_rate_rasterization_samples: SampleCountFlags,
    pub fragment_shading_rate_with_shader_depth_stencil_writes: Bool32,
    pub fragment_shading_rate_with_sample_mask: Bool32,
    pub fragment_shading_rate_with_shader_sample_mask: Bool32,
    pub fragment_shading_rate_with_conservative_rasterization: Bool32,
    pub fragment_shading_rate_with_fragment_shader_interlock: Bool32,
    pub fragment_shading_rate_with_custom_sample_locations: Bool32,
    pub fragment_shading_rate_strict_multiply_combiner: Bool32,
}

impl Default for PhysicalDeviceFragmentShadingRatePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR,
            next: ptr::null_mut(),
            min_fragment_shading_rate_attachment_texel_size: Extent2D::default(),
            max_fragment_shading_rate_attachment_texel_size: Extent2D::default(),
            max_fragment_shading_rate_attachment_texel_size_aspect_ratio: u32::default(),
            primitive_fragment_shading_rate_with_multiple_viewports: Bool32::default(),
            layered_shading_rate_attachments: Bool32::default(),
            fragment_shading_rate_non_trivial_combiner_ops: Bool32::default(),
            max_fragment_size: Extent2D::default(),
            max_fragment_size_aspect_ratio: u32::default(),
            max_fragment_shading_rate_coverage_samples: u32::default(),
            max_fragment_shading_rate_rasterization_samples: SampleCountFlags::default(),
            fragment_shading_rate_with_shader_depth_stencil_writes: Bool32::default(),
            fragment_shading_rate_with_sample_mask: Bool32::default(),
            fragment_shading_rate_with_shader_sample_mask: Bool32::default(),
            fragment_shading_rate_with_conservative_rasterization: Bool32::default(),
            fragment_shading_rate_with_fragment_shader_interlock: Bool32::default(),
            fragment_shading_rate_with_custom_sample_locations: Bool32::default(),
            fragment_shading_rate_strict_multiply_combiner: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceGlobalPriorityQueryFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub global_priority_query: Bool32,
}

impl Default for PhysicalDeviceGlobalPriorityQueryFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT,
            next: ptr::null_mut(),
            global_priority_query: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceGroupProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceGroupProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub physical_device_count: u32,
    pub physical_devices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE],
    pub subset_allocation: Bool32,
}

impl Default for PhysicalDeviceGroupProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_GROUP_PROPERTIES,
            next: ptr::null_mut(),
            physical_device_count: u32::default(),
            physical_devices: [PhysicalDevice::default(); MAX_DEVICE_GROUP_SIZE],
            subset_allocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceHostQueryResetFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceHostQueryResetFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub host_query_reset: Bool32,
}

impl Default for PhysicalDeviceHostQueryResetFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES,
            next: ptr::null_mut(),
            host_query_reset: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceIDProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceIDProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_uuid: ByteArray<UUID_SIZE>,
    pub driver_uuid: ByteArray<UUID_SIZE>,
    pub device_luid: ByteArray<LUID_SIZE>,
    pub device_node_mask: u32,
    pub device_luid_valid: Bool32,
}

impl Default for PhysicalDeviceIDProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ID_PROPERTIES,
            next: ptr::null_mut(),
            device_uuid: ByteArray::default(),
            driver_uuid: ByteArray::default(),
            device_luid: ByteArray::default(),
            device_node_mask: u32::default(),
            device_luid_valid: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageDrmFormatModifierInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceImageDrmFormatModifierInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub drm_format_modifier: u64,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub queue_family_indices: *const u32,
}

impl Default for PhysicalDeviceImageDrmFormatModifierInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT,
            next: ptr::null(),
            drm_format_modifier: u64::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            queue_family_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageFormatInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceImageFormatInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub format: Format,
    pub type_: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
}

impl Default for PhysicalDeviceImageFormatInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2,
            next: ptr::null(),
            format: Format::default(),
            type_: ImageType::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            flags: ImageCreateFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageRobustnessFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceImageRobustnessFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub robust_image_access: Bool32,
}

impl Default for PhysicalDeviceImageRobustnessFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT,
            next: ptr::null_mut(),
            robust_image_access: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageViewImageFormatInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceImageViewImageFormatInfoEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub image_view_type: ImageViewType,
}

impl Default for PhysicalDeviceImageViewImageFormatInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT,
            next: ptr::null_mut(),
            image_view_type: ImageViewType::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImagelessFramebufferFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceImagelessFramebufferFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub imageless_framebuffer: Bool32,
}

impl Default for PhysicalDeviceImagelessFramebufferFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES,
            next: ptr::null_mut(),
            imageless_framebuffer: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceIndexTypeUint8FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceIndexTypeUint8FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub index_type_uint8: Bool32,
}

impl Default for PhysicalDeviceIndexTypeUint8FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT,
            next: ptr::null_mut(),
            index_type_uint8: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceInheritedViewportScissorFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceInheritedViewportScissorFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub inherited_viewport_scissor_2d: Bool32,
}

impl Default for PhysicalDeviceInheritedViewportScissorFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV,
            next: ptr::null_mut(),
            inherited_viewport_scissor_2d: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceInlineUniformBlockFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceInlineUniformBlockFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub inline_uniform_block: Bool32,
    pub descriptor_binding_inline_uniform_block_update_after_bind: Bool32,
}

impl Default for PhysicalDeviceInlineUniformBlockFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT,
            next: ptr::null_mut(),
            inline_uniform_block: Bool32::default(),
            descriptor_binding_inline_uniform_block_update_after_bind: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceInlineUniformBlockPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceInlineUniformBlockPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_inline_uniform_block_size: u32,
    pub max_per_stage_descriptor_inline_uniform_blocks: u32,
    pub max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    pub max_descriptor_set_inline_uniform_blocks: u32,
    pub max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
}

impl Default for PhysicalDeviceInlineUniformBlockPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_inline_uniform_block_size: u32::default(),
            max_per_stage_descriptor_inline_uniform_blocks: u32::default(),
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32::default(),
            max_descriptor_set_inline_uniform_blocks: u32::default(),
            max_descriptor_set_update_after_bind_inline_uniform_blocks: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceInvocationMaskFeaturesHUAWEI.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceInvocationMaskFeaturesHUAWEI {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub invocation_mask: Bool32,
}

impl Default for PhysicalDeviceInvocationMaskFeaturesHUAWEI {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI,
            next: ptr::null_mut(),
            invocation_mask: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceLimits.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct PhysicalDeviceLimits {
    pub max_image_dimension_1d: u32,
    pub max_image_dimension_2d: u32,
    pub max_image_dimension_3d: u32,
    pub max_image_dimension_cube: u32,
    pub max_image_array_layers: u32,
    pub max_texel_buffer_elements: u32,
    pub max_uniform_buffer_range: u32,
    pub max_storage_buffer_range: u32,
    pub max_push_constants_size: u32,
    pub max_memory_allocation_count: u32,
    pub max_sampler_allocation_count: u32,
    pub buffer_image_granularity: DeviceSize,
    pub sparse_address_space_size: DeviceSize,
    pub max_bound_descriptor_sets: u32,
    pub max_per_stage_descriptor_samplers: u32,
    pub max_per_stage_descriptor_uniform_buffers: u32,
    pub max_per_stage_descriptor_storage_buffers: u32,
    pub max_per_stage_descriptor_sampled_images: u32,
    pub max_per_stage_descriptor_storage_images: u32,
    pub max_per_stage_descriptor_input_attachments: u32,
    pub max_per_stage_resources: u32,
    pub max_descriptor_set_samplers: u32,
    pub max_descriptor_set_uniform_buffers: u32,
    pub max_descriptor_set_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_storage_buffers: u32,
    pub max_descriptor_set_storage_buffers_dynamic: u32,
    pub max_descriptor_set_sampled_images: u32,
    pub max_descriptor_set_storage_images: u32,
    pub max_descriptor_set_input_attachments: u32,
    pub max_vertex_input_attributes: u32,
    pub max_vertex_input_bindings: u32,
    pub max_vertex_input_attribute_offset: u32,
    pub max_vertex_input_binding_stride: u32,
    pub max_vertex_output_components: u32,
    pub max_tessellation_generation_level: u32,
    pub max_tessellation_patch_size: u32,
    pub max_tessellation_control_per_vertex_input_components: u32,
    pub max_tessellation_control_per_vertex_output_components: u32,
    pub max_tessellation_control_per_patch_output_components: u32,
    pub max_tessellation_control_total_output_components: u32,
    pub max_tessellation_evaluation_input_components: u32,
    pub max_tessellation_evaluation_output_components: u32,
    pub max_geometry_shader_invocations: u32,
    pub max_geometry_input_components: u32,
    pub max_geometry_output_components: u32,
    pub max_geometry_output_vertices: u32,
    pub max_geometry_total_output_components: u32,
    pub max_fragment_input_components: u32,
    pub max_fragment_output_attachments: u32,
    pub max_fragment_dual_src_attachments: u32,
    pub max_fragment_combined_output_resources: u32,
    pub max_compute_shared_memory_size: u32,
    pub max_compute_work_group_count: [u32; 3],
    pub max_compute_work_group_invocations: u32,
    pub max_compute_work_group_size: [u32; 3],
    pub sub_pixel_precision_bits: u32,
    pub sub_texel_precision_bits: u32,
    pub mipmap_precision_bits: u32,
    pub max_draw_indexed_index_value: u32,
    pub max_draw_indirect_count: u32,
    pub max_sampler_lod_bias: f32,
    pub max_sampler_anisotropy: f32,
    pub max_viewports: u32,
    pub max_viewport_dimensions: [u32; 2],
    pub viewport_bounds_range: [f32; 2],
    pub viewport_sub_pixel_bits: u32,
    pub min_memory_map_alignment: usize,
    pub min_texel_buffer_offset_alignment: DeviceSize,
    pub min_uniform_buffer_offset_alignment: DeviceSize,
    pub min_storage_buffer_offset_alignment: DeviceSize,
    pub min_texel_offset: i32,
    pub max_texel_offset: u32,
    pub min_texel_gather_offset: i32,
    pub max_texel_gather_offset: u32,
    pub min_interpolation_offset: f32,
    pub max_interpolation_offset: f32,
    pub sub_pixel_interpolation_offset_bits: u32,
    pub max_framebuffer_width: u32,
    pub max_framebuffer_height: u32,
    pub max_framebuffer_layers: u32,
    pub framebuffer_color_sample_counts: SampleCountFlags,
    pub framebuffer_depth_sample_counts: SampleCountFlags,
    pub framebuffer_stencil_sample_counts: SampleCountFlags,
    pub framebuffer_no_attachments_sample_counts: SampleCountFlags,
    pub max_color_attachments: u32,
    pub sampled_image_color_sample_counts: SampleCountFlags,
    pub sampled_image_integer_sample_counts: SampleCountFlags,
    pub sampled_image_depth_sample_counts: SampleCountFlags,
    pub sampled_image_stencil_sample_counts: SampleCountFlags,
    pub storage_image_sample_counts: SampleCountFlags,
    pub max_sample_mask_words: u32,
    pub timestamp_compute_and_graphics: Bool32,
    pub timestamp_period: f32,
    pub max_clip_distances: u32,
    pub max_cull_distances: u32,
    pub max_combined_clip_and_cull_distances: u32,
    pub discrete_queue_priorities: u32,
    pub point_size_range: [f32; 2],
    pub line_width_range: [f32; 2],
    pub point_size_granularity: f32,
    pub line_width_granularity: f32,
    pub strict_lines: Bool32,
    pub standard_sample_locations: Bool32,
    pub optimal_buffer_copy_offset_alignment: DeviceSize,
    pub optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    pub non_coherent_atom_size: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceLineRasterizationFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceLineRasterizationFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub rectangular_lines: Bool32,
    pub bresenham_lines: Bool32,
    pub smooth_lines: Bool32,
    pub stippled_rectangular_lines: Bool32,
    pub stippled_bresenham_lines: Bool32,
    pub stippled_smooth_lines: Bool32,
}

impl Default for PhysicalDeviceLineRasterizationFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT,
            next: ptr::null_mut(),
            rectangular_lines: Bool32::default(),
            bresenham_lines: Bool32::default(),
            smooth_lines: Bool32::default(),
            stippled_rectangular_lines: Bool32::default(),
            stippled_bresenham_lines: Bool32::default(),
            stippled_smooth_lines: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceLineRasterizationPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceLineRasterizationPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub line_sub_pixel_precision_bits: u32,
}

impl Default for PhysicalDeviceLineRasterizationPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT,
            next: ptr::null_mut(),
            line_sub_pixel_precision_bits: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMaintenance3Properties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMaintenance3Properties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_per_set_descriptors: u32,
    pub max_memory_allocation_size: DeviceSize,
}

impl Default for PhysicalDeviceMaintenance3Properties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES,
            next: ptr::null_mut(),
            max_per_set_descriptors: u32::default(),
            max_memory_allocation_size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMaintenance4FeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMaintenance4FeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub maintenance4: Bool32,
}

impl Default for PhysicalDeviceMaintenance4FeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR,
            next: ptr::null_mut(),
            maintenance4: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMaintenance4PropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMaintenance4PropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_buffer_size: DeviceSize,
}

impl Default for PhysicalDeviceMaintenance4PropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR,
            next: ptr::null_mut(),
            max_buffer_size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryBudgetPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMemoryBudgetPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub heap_budget: [DeviceSize; MAX_MEMORY_HEAPS],
    pub heap_usage: [DeviceSize; MAX_MEMORY_HEAPS],
}

impl Default for PhysicalDeviceMemoryBudgetPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT,
            next: ptr::null_mut(),
            heap_budget: [DeviceSize::default(); MAX_MEMORY_HEAPS],
            heap_usage: [DeviceSize::default(); MAX_MEMORY_HEAPS],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryPriorityFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMemoryPriorityFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_priority: Bool32,
}

impl Default for PhysicalDeviceMemoryPriorityFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT,
            next: ptr::null_mut(),
            memory_priority: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMemoryProperties {
    pub memory_type_count: u32,
    pub memory_types: [MemoryType; MAX_MEMORY_TYPES],
    pub memory_heap_count: u32,
    pub memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS],
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMemoryProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_properties: PhysicalDeviceMemoryProperties,
}

impl Default for PhysicalDeviceMemoryProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MEMORY_PROPERTIES_2,
            next: ptr::null_mut(),
            memory_properties: PhysicalDeviceMemoryProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMeshShaderFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub task_shader: Bool32,
    pub mesh_shader: Bool32,
}

impl Default for PhysicalDeviceMeshShaderFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV,
            next: ptr::null_mut(),
            task_shader: Bool32::default(),
            mesh_shader: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMeshShaderPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMeshShaderPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_draw_mesh_tasks_count: u32,
    pub max_task_work_group_invocations: u32,
    pub max_task_work_group_size: [u32; 3],
    pub max_task_total_memory_size: u32,
    pub max_task_output_count: u32,
    pub max_mesh_work_group_invocations: u32,
    pub max_mesh_work_group_size: [u32; 3],
    pub max_mesh_total_memory_size: u32,
    pub max_mesh_output_vertices: u32,
    pub max_mesh_output_primitives: u32,
    pub max_mesh_multiview_view_count: u32,
    pub mesh_output_per_vertex_granularity: u32,
    pub mesh_output_per_primitive_granularity: u32,
}

impl Default for PhysicalDeviceMeshShaderPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV,
            next: ptr::null_mut(),
            max_draw_mesh_tasks_count: u32::default(),
            max_task_work_group_invocations: u32::default(),
            max_task_work_group_size: [u32::default(); 3],
            max_task_total_memory_size: u32::default(),
            max_task_output_count: u32::default(),
            max_mesh_work_group_invocations: u32::default(),
            max_mesh_work_group_size: [u32::default(); 3],
            max_mesh_total_memory_size: u32::default(),
            max_mesh_output_vertices: u32::default(),
            max_mesh_output_primitives: u32::default(),
            max_mesh_multiview_view_count: u32::default(),
            mesh_output_per_vertex_granularity: u32::default(),
            mesh_output_per_primitive_granularity: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiDrawFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMultiDrawFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub multi_draw: Bool32,
}

impl Default for PhysicalDeviceMultiDrawFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT,
            next: ptr::null_mut(),
            multi_draw: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiDrawPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMultiDrawPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_multi_draw_count: u32,
}

impl Default for PhysicalDeviceMultiDrawPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_multi_draw_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiviewFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMultiviewFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub multiview: Bool32,
    pub multiview_geometry_shader: Bool32,
    pub multiview_tessellation_shader: Bool32,
}

impl Default for PhysicalDeviceMultiviewFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MULTIVIEW_FEATURES,
            next: ptr::null_mut(),
            multiview: Bool32::default(),
            multiview_geometry_shader: Bool32::default(),
            multiview_tessellation_shader: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub per_view_position_all_components: Bool32,
}

impl Default for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX,
            next: ptr::null_mut(),
            per_view_position_all_components: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiviewProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMultiviewProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_multiview_view_count: u32,
    pub max_multiview_instance_index: u32,
}

impl Default for PhysicalDeviceMultiviewProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES,
            next: ptr::null_mut(),
            max_multiview_view_count: u32::default(),
            max_multiview_instance_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub mutable_descriptor_type: Bool32,
}

impl Default for PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE,
            next: ptr::null_mut(),
            mutable_descriptor_type: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePCIBusInfoPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePCIBusInfoPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub pci_domain: u32,
    pub pci_bus: u32,
    pub pci_device: u32,
    pub pci_function: u32,
}

impl Default for PhysicalDevicePCIBusInfoPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT,
            next: ptr::null_mut(),
            pci_domain: u32::default(),
            pci_bus: u32::default(),
            pci_device: u32::default(),
            pci_function: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePageableDeviceLocalMemoryFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub pageable_device_local_memory: Bool32,
}

impl Default for PhysicalDevicePageableDeviceLocalMemoryFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT,
            next: ptr::null_mut(),
            pageable_device_local_memory: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePerformanceQueryFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePerformanceQueryFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub performance_counter_query_pools: Bool32,
    pub performance_counter_multiple_query_pools: Bool32,
}

impl Default for PhysicalDevicePerformanceQueryFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR,
            next: ptr::null_mut(),
            performance_counter_query_pools: Bool32::default(),
            performance_counter_multiple_query_pools: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePerformanceQueryPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePerformanceQueryPropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub allow_command_buffer_query_copies: Bool32,
}

impl Default for PhysicalDevicePerformanceQueryPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR,
            next: ptr::null_mut(),
            allow_command_buffer_query_copies: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePipelineCreationCacheControlFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub pipeline_creation_cache_control: Bool32,
}

impl Default for PhysicalDevicePipelineCreationCacheControlFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT,
            next: ptr::null_mut(),
            pipeline_creation_cache_control: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub pipeline_executable_info: Bool32,
}

impl Default for PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR,
            next: ptr::null_mut(),
            pipeline_executable_info: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePointClippingProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePointClippingProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub point_clipping_behavior: PointClippingBehavior,
}

impl Default for PhysicalDevicePointClippingProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES,
            next: ptr::null_mut(),
            point_clipping_behavior: PointClippingBehavior::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePortabilitySubsetFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePortabilitySubsetFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub constant_alpha_color_blend_factors: Bool32,
    pub events: Bool32,
    pub image_view_format_reinterpretation: Bool32,
    pub image_view_format_swizzle: Bool32,
    pub image_view_2d_on_3d_image: Bool32,
    pub multisample_array_image: Bool32,
    pub mutable_comparison_samplers: Bool32,
    pub point_polygons: Bool32,
    pub sampler_mip_lod_bias: Bool32,
    pub separate_stencil_mask_ref: Bool32,
    pub shader_sample_rate_interpolation_functions: Bool32,
    pub tessellation_isolines: Bool32,
    pub tessellation_point_mode: Bool32,
    pub triangle_fans: Bool32,
    pub vertex_attribute_access_beyond_stride: Bool32,
}

impl Default for PhysicalDevicePortabilitySubsetFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR,
            next: ptr::null_mut(),
            constant_alpha_color_blend_factors: Bool32::default(),
            events: Bool32::default(),
            image_view_format_reinterpretation: Bool32::default(),
            image_view_format_swizzle: Bool32::default(),
            image_view_2d_on_3d_image: Bool32::default(),
            multisample_array_image: Bool32::default(),
            mutable_comparison_samplers: Bool32::default(),
            point_polygons: Bool32::default(),
            sampler_mip_lod_bias: Bool32::default(),
            separate_stencil_mask_ref: Bool32::default(),
            shader_sample_rate_interpolation_functions: Bool32::default(),
            tessellation_isolines: Bool32::default(),
            tessellation_point_mode: Bool32::default(),
            triangle_fans: Bool32::default(),
            vertex_attribute_access_beyond_stride: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePortabilitySubsetPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePortabilitySubsetPropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_vertex_input_binding_stride_alignment: u32,
}

impl Default for PhysicalDevicePortabilitySubsetPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR,
            next: ptr::null_mut(),
            min_vertex_input_binding_stride_alignment: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePresentIdFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePresentIdFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub present_id: Bool32,
}

impl Default for PhysicalDevicePresentIdFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR,
            next: ptr::null_mut(),
            present_id: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePresentWaitFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePresentWaitFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub present_wait: Bool32,
}

impl Default for PhysicalDevicePresentWaitFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR,
            next: ptr::null_mut(),
            present_wait: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub primitive_topology_list_restart: Bool32,
    pub primitive_topology_patch_list_restart: Bool32,
}

impl Default for PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT,
            next: ptr::null_mut(),
            primitive_topology_list_restart: Bool32::default(),
            primitive_topology_patch_list_restart: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePrivateDataFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePrivateDataFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub private_data: Bool32,
}

impl Default for PhysicalDevicePrivateDataFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT,
            next: ptr::null_mut(),
            private_data: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PhysicalDeviceProperties {
    pub api_version: u32,
    pub driver_version: u32,
    pub vendor_id: u32,
    pub device_id: u32,
    pub device_type: PhysicalDeviceType,
    pub device_name: StringArray<MAX_PHYSICAL_DEVICE_NAME_SIZE>,
    pub pipeline_cache_uuid: ByteArray<UUID_SIZE>,
    pub limits: PhysicalDeviceLimits,
    pub sparse_properties: PhysicalDeviceSparseProperties,
}

impl Default for PhysicalDeviceProperties {
    #[inline]
    fn default() -> Self {
        Self {
            api_version: u32::default(),
            driver_version: u32::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            device_type: PhysicalDeviceType::default(),
            device_name: StringArray::default(),
            pipeline_cache_uuid: ByteArray::default(),
            limits: PhysicalDeviceLimits::default(),
            sparse_properties: PhysicalDeviceSparseProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PhysicalDeviceProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub properties: PhysicalDeviceProperties,
}

impl Default for PhysicalDeviceProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PROPERTIES_2,
            next: ptr::null_mut(),
            properties: PhysicalDeviceProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProtectedMemoryFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceProtectedMemoryFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub protected_memory: Bool32,
}

impl Default for PhysicalDeviceProtectedMemoryFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES,
            next: ptr::null_mut(),
            protected_memory: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProtectedMemoryProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceProtectedMemoryProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub protected_no_fault: Bool32,
}

impl Default for PhysicalDeviceProtectedMemoryProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES,
            next: ptr::null_mut(),
            protected_no_fault: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProvokingVertexFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceProvokingVertexFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub provoking_vertex_last: Bool32,
    pub transform_feedback_preserves_provoking_vertex: Bool32,
}

impl Default for PhysicalDeviceProvokingVertexFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT,
            next: ptr::null_mut(),
            provoking_vertex_last: Bool32::default(),
            transform_feedback_preserves_provoking_vertex: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProvokingVertexPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceProvokingVertexPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub provoking_vertex_mode_per_pipeline: Bool32,
    pub transform_feedback_preserves_triangle_fan_provoking_vertex: Bool32,
}

impl Default for PhysicalDeviceProvokingVertexPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT,
            next: ptr::null_mut(),
            provoking_vertex_mode_per_pipeline: Bool32::default(),
            transform_feedback_preserves_triangle_fan_provoking_vertex: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePushDescriptorPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDevicePushDescriptorPropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_push_descriptors: u32,
}

impl Default for PhysicalDevicePushDescriptorPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR,
            next: ptr::null_mut(),
            max_push_descriptors: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRGBA10X6FormatsFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub format_rgba10x6_without_y_cb_cr_sampler: Bool32,
}

impl Default for PhysicalDeviceRGBA10X6FormatsFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT,
            next: ptr::null_mut(),
            format_rgba10x6_without_y_cb_cr_sampler: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRayQueryFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRayQueryFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub ray_query: Bool32,
}

impl Default for PhysicalDeviceRayQueryFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR,
            next: ptr::null_mut(),
            ray_query: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRayTracingMotionBlurFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRayTracingMotionBlurFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub ray_tracing_motion_blur: Bool32,
    pub ray_tracing_motion_blur_pipeline_trace_rays_indirect: Bool32,
}

impl Default for PhysicalDeviceRayTracingMotionBlurFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV,
            next: ptr::null_mut(),
            ray_tracing_motion_blur: Bool32::default(),
            ray_tracing_motion_blur_pipeline_trace_rays_indirect: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRayTracingPipelineFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRayTracingPipelineFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub ray_tracing_pipeline: Bool32,
    pub ray_tracing_pipeline_shader_group_handle_capture_replay: Bool32,
    pub ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: Bool32,
    pub ray_tracing_pipeline_trace_rays_indirect: Bool32,
    pub ray_traversal_primitive_culling: Bool32,
}

impl Default for PhysicalDeviceRayTracingPipelineFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR,
            next: ptr::null_mut(),
            ray_tracing_pipeline: Bool32::default(),
            ray_tracing_pipeline_shader_group_handle_capture_replay: Bool32::default(),
            ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: Bool32::default(),
            ray_tracing_pipeline_trace_rays_indirect: Bool32::default(),
            ray_traversal_primitive_culling: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRayTracingPipelinePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRayTracingPipelinePropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_group_handle_size: u32,
    pub max_ray_recursion_depth: u32,
    pub max_shader_group_stride: u32,
    pub shader_group_base_alignment: u32,
    pub shader_group_handle_capture_replay_size: u32,
    pub max_ray_dispatch_invocation_count: u32,
    pub shader_group_handle_alignment: u32,
    pub max_ray_hit_attribute_size: u32,
}

impl Default for PhysicalDeviceRayTracingPipelinePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR,
            next: ptr::null_mut(),
            shader_group_handle_size: u32::default(),
            max_ray_recursion_depth: u32::default(),
            max_shader_group_stride: u32::default(),
            shader_group_base_alignment: u32::default(),
            shader_group_handle_capture_replay_size: u32::default(),
            max_ray_dispatch_invocation_count: u32::default(),
            shader_group_handle_alignment: u32::default(),
            max_ray_hit_attribute_size: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRayTracingPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRayTracingPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_group_handle_size: u32,
    pub max_recursion_depth: u32,
    pub max_shader_group_stride: u32,
    pub shader_group_base_alignment: u32,
    pub max_geometry_count: u64,
    pub max_instance_count: u64,
    pub max_triangle_count: u64,
    pub max_descriptor_set_acceleration_structures: u32,
}

impl Default for PhysicalDeviceRayTracingPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV,
            next: ptr::null_mut(),
            shader_group_handle_size: u32::default(),
            max_recursion_depth: u32::default(),
            max_shader_group_stride: u32::default(),
            shader_group_base_alignment: u32::default(),
            max_geometry_count: u64::default(),
            max_instance_count: u64::default(),
            max_triangle_count: u64::default(),
            max_descriptor_set_acceleration_structures: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub representative_fragment_test: Bool32,
}

impl Default for PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV,
            next: ptr::null_mut(),
            representative_fragment_test: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRobustness2FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRobustness2FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub robust_buffer_access2: Bool32,
    pub robust_image_access2: Bool32,
    pub null_descriptor: Bool32,
}

impl Default for PhysicalDeviceRobustness2FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT,
            next: ptr::null_mut(),
            robust_buffer_access2: Bool32::default(),
            robust_image_access2: Bool32::default(),
            null_descriptor: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceRobustness2PropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceRobustness2PropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub robust_storage_buffer_access_size_alignment: DeviceSize,
    pub robust_uniform_buffer_access_size_alignment: DeviceSize,
}

impl Default for PhysicalDeviceRobustness2PropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT,
            next: ptr::null_mut(),
            robust_storage_buffer_access_size_alignment: DeviceSize::default(),
            robust_uniform_buffer_access_size_alignment: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSampleLocationsPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PhysicalDeviceSampleLocationsPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub sample_location_sample_counts: SampleCountFlags,
    pub max_sample_location_grid_size: Extent2D,
    pub sample_location_coordinate_range: [f32; 2],
    pub sample_location_sub_pixel_bits: u32,
    pub variable_sample_locations: Bool32,
}

impl Default for PhysicalDeviceSampleLocationsPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT,
            next: ptr::null_mut(),
            sample_location_sample_counts: SampleCountFlags::default(),
            max_sample_location_grid_size: Extent2D::default(),
            sample_location_coordinate_range: [f32::default(); 2],
            sample_location_sub_pixel_bits: u32::default(),
            variable_sample_locations: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSamplerFilterMinmaxProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub filter_minmax_single_component_formats: Bool32,
    pub filter_minmax_image_component_mapping: Bool32,
}

impl Default for PhysicalDeviceSamplerFilterMinmaxProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES,
            next: ptr::null_mut(),
            filter_minmax_single_component_formats: Bool32::default(),
            filter_minmax_image_component_mapping: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSamplerYcbcrConversionFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSamplerYcbcrConversionFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub sampler_ycbcr_conversion: Bool32,
}

impl Default for PhysicalDeviceSamplerYcbcrConversionFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES,
            next: ptr::null_mut(),
            sampler_ycbcr_conversion: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceScalarBlockLayoutFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceScalarBlockLayoutFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub scalar_block_layout: Bool32,
}

impl Default for PhysicalDeviceScalarBlockLayoutFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES,
            next: ptr::null_mut(),
            scalar_block_layout: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub separate_depth_stencil_layouts: Bool32,
}

impl Default for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES,
            next: ptr::null_mut(),
            separate_depth_stencil_layouts: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_buffer_float16_atomics: Bool32,
    pub shader_buffer_float16_atomic_add: Bool32,
    pub shader_buffer_float16_atomic_min_max: Bool32,
    pub shader_buffer_float32_atomic_min_max: Bool32,
    pub shader_buffer_float64_atomic_min_max: Bool32,
    pub shader_shared_float16_atomics: Bool32,
    pub shader_shared_float16_atomic_add: Bool32,
    pub shader_shared_float16_atomic_min_max: Bool32,
    pub shader_shared_float32_atomic_min_max: Bool32,
    pub shader_shared_float64_atomic_min_max: Bool32,
    pub shader_image_float32_atomic_min_max: Bool32,
    pub sparse_image_float32_atomic_min_max: Bool32,
}

impl Default for PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT,
            next: ptr::null_mut(),
            shader_buffer_float16_atomics: Bool32::default(),
            shader_buffer_float16_atomic_add: Bool32::default(),
            shader_buffer_float16_atomic_min_max: Bool32::default(),
            shader_buffer_float32_atomic_min_max: Bool32::default(),
            shader_buffer_float64_atomic_min_max: Bool32::default(),
            shader_shared_float16_atomics: Bool32::default(),
            shader_shared_float16_atomic_add: Bool32::default(),
            shader_shared_float16_atomic_min_max: Bool32::default(),
            shader_shared_float32_atomic_min_max: Bool32::default(),
            shader_shared_float64_atomic_min_max: Bool32::default(),
            shader_image_float32_atomic_min_max: Bool32::default(),
            sparse_image_float32_atomic_min_max: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderAtomicFloatFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderAtomicFloatFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_buffer_float32_atomics: Bool32,
    pub shader_buffer_float32_atomic_add: Bool32,
    pub shader_buffer_float64_atomics: Bool32,
    pub shader_buffer_float64_atomic_add: Bool32,
    pub shader_shared_float32_atomics: Bool32,
    pub shader_shared_float32_atomic_add: Bool32,
    pub shader_shared_float64_atomics: Bool32,
    pub shader_shared_float64_atomic_add: Bool32,
    pub shader_image_float32_atomics: Bool32,
    pub shader_image_float32_atomic_add: Bool32,
    pub sparse_image_float32_atomics: Bool32,
    pub sparse_image_float32_atomic_add: Bool32,
}

impl Default for PhysicalDeviceShaderAtomicFloatFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT,
            next: ptr::null_mut(),
            shader_buffer_float32_atomics: Bool32::default(),
            shader_buffer_float32_atomic_add: Bool32::default(),
            shader_buffer_float64_atomics: Bool32::default(),
            shader_buffer_float64_atomic_add: Bool32::default(),
            shader_shared_float32_atomics: Bool32::default(),
            shader_shared_float32_atomic_add: Bool32::default(),
            shader_shared_float64_atomics: Bool32::default(),
            shader_shared_float64_atomic_add: Bool32::default(),
            shader_image_float32_atomics: Bool32::default(),
            shader_image_float32_atomic_add: Bool32::default(),
            sparse_image_float32_atomics: Bool32::default(),
            sparse_image_float32_atomic_add: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderAtomicInt64Features {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_buffer_int64_atomics: Bool32,
    pub shader_shared_int64_atomics: Bool32,
}

impl Default for PhysicalDeviceShaderAtomicInt64Features {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES,
            next: ptr::null_mut(),
            shader_buffer_int64_atomics: Bool32::default(),
            shader_shared_int64_atomics: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderClockFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderClockFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_subgroup_clock: Bool32,
    pub shader_device_clock: Bool32,
}

impl Default for PhysicalDeviceShaderClockFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR,
            next: ptr::null_mut(),
            shader_subgroup_clock: Bool32::default(),
            shader_device_clock: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderCoreProperties2AMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderCoreProperties2AMD {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_core_features: ShaderCorePropertiesFlagsAMD,
    pub active_compute_unit_count: u32,
}

impl Default for PhysicalDeviceShaderCoreProperties2AMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD,
            next: ptr::null_mut(),
            shader_core_features: ShaderCorePropertiesFlagsAMD::default(),
            active_compute_unit_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderCorePropertiesAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderCorePropertiesAMD {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_engine_count: u32,
    pub shader_arrays_per_engine_count: u32,
    pub compute_units_per_shader_array: u32,
    pub simd_per_compute_unit: u32,
    pub wavefronts_per_simd: u32,
    pub wavefront_size: u32,
    pub sgprs_per_simd: u32,
    pub min_sgpr_allocation: u32,
    pub max_sgpr_allocation: u32,
    pub sgpr_allocation_granularity: u32,
    pub vgprs_per_simd: u32,
    pub min_vgpr_allocation: u32,
    pub max_vgpr_allocation: u32,
    pub vgpr_allocation_granularity: u32,
}

impl Default for PhysicalDeviceShaderCorePropertiesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD,
            next: ptr::null_mut(),
            shader_engine_count: u32::default(),
            shader_arrays_per_engine_count: u32::default(),
            compute_units_per_shader_array: u32::default(),
            simd_per_compute_unit: u32::default(),
            wavefronts_per_simd: u32::default(),
            wavefront_size: u32::default(),
            sgprs_per_simd: u32::default(),
            min_sgpr_allocation: u32::default(),
            max_sgpr_allocation: u32::default(),
            sgpr_allocation_granularity: u32::default(),
            vgprs_per_simd: u32::default(),
            min_vgpr_allocation: u32::default(),
            max_vgpr_allocation: u32::default(),
            vgpr_allocation_granularity: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_demote_to_helper_invocation: Bool32,
}

impl Default for PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT,
            next: ptr::null_mut(),
            shader_demote_to_helper_invocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderDrawParametersFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderDrawParametersFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_draw_parameters: Bool32,
}

impl Default for PhysicalDeviceShaderDrawParametersFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES,
            next: ptr::null_mut(),
            shader_draw_parameters: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderFloat16Int8Features {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_float16: Bool32,
    pub shader_int8: Bool32,
}

impl Default for PhysicalDeviceShaderFloat16Int8Features {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES,
            next: ptr::null_mut(),
            shader_float16: Bool32::default(),
            shader_int8: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_image_int64_atomics: Bool32,
    pub sparse_image_int64_atomics: Bool32,
}

impl Default for PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT,
            next: ptr::null_mut(),
            shader_image_int64_atomics: Bool32::default(),
            sparse_image_int64_atomics: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderImageFootprintFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderImageFootprintFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub image_footprint: Bool32,
}

impl Default for PhysicalDeviceShaderImageFootprintFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV,
            next: ptr::null_mut(),
            image_footprint: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderIntegerDotProductFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_integer_dot_product: Bool32,
}

impl Default for PhysicalDeviceShaderIntegerDotProductFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR,
            next: ptr::null_mut(),
            shader_integer_dot_product: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderIntegerDotProductPropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub integer_dot_product_8bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_8bit_signed_accelerated: Bool32,
    pub integer_dot_product_8bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product4x_8bit_packed_unsigned_accelerated: Bool32,
    pub integer_dot_product4x_8bit_packed_signed_accelerated: Bool32,
    pub integer_dot_product4x_8bit_packed_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_16bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_16bit_signed_accelerated: Bool32,
    pub integer_dot_product_16bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_32bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_32bit_signed_accelerated: Bool32,
    pub integer_dot_product_32bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_64bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_64bit_signed_accelerated: Bool32,
    pub integer_dot_product_64bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_8bit_signed_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated:
        Bool32,
    pub integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_16bit_signed_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_32bit_signed_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_64bit_signed_accelerated: Bool32,
    pub integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated: Bool32,
}

impl Default for PhysicalDeviceShaderIntegerDotProductPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self { s_type: StructureType::PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR, next: ptr::null_mut(), integer_dot_product_8bit_unsigned_accelerated: Bool32::default(), integer_dot_product_8bit_signed_accelerated: Bool32::default(), integer_dot_product_8bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product4x_8bit_packed_unsigned_accelerated: Bool32::default(), integer_dot_product4x_8bit_packed_signed_accelerated: Bool32::default(), integer_dot_product4x_8bit_packed_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_16bit_unsigned_accelerated: Bool32::default(), integer_dot_product_16bit_signed_accelerated: Bool32::default(), integer_dot_product_16bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_32bit_unsigned_accelerated: Bool32::default(), integer_dot_product_32bit_signed_accelerated: Bool32::default(), integer_dot_product_32bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_64bit_unsigned_accelerated: Bool32::default(), integer_dot_product_64bit_signed_accelerated: Bool32::default(), integer_dot_product_64bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_8bit_unsigned_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_8bit_signed_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_8bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating4x_8bit_packed_unsigned_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating4x_8bit_packed_signed_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating4x_8bit_packed_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_16bit_unsigned_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_16bit_signed_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_16bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_32bit_unsigned_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_32bit_signed_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_32bit_mixed_signedness_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_64bit_unsigned_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_64bit_signed_accelerated: Bool32::default(), integer_dot_product_accumulating_saturating_64bit_mixed_signedness_accelerated: Bool32::default() }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_integer_functions2: Bool32,
}

impl Default for PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL,
            next: ptr::null_mut(),
            shader_integer_functions2: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderSMBuiltinsFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderSMBuiltinsFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_sm_builtins: Bool32,
}

impl Default for PhysicalDeviceShaderSMBuiltinsFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV,
            next: ptr::null_mut(),
            shader_sm_builtins: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderSMBuiltinsPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderSMBuiltinsPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_sm_count: u32,
    pub shader_warps_per_sm: u32,
}

impl Default for PhysicalDeviceShaderSMBuiltinsPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV,
            next: ptr::null_mut(),
            shader_sm_count: u32::default(),
            shader_warps_per_sm: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_subgroup_extended_types: Bool32,
}

impl Default for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES,
            next: ptr::null_mut(),
            shader_subgroup_extended_types: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_subgroup_uniform_control_flow: Bool32,
}

impl Default for PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type:
                StructureType::PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR,
            next: ptr::null_mut(),
            shader_subgroup_uniform_control_flow: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShaderTerminateInvocationFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_terminate_invocation: Bool32,
}

impl Default for PhysicalDeviceShaderTerminateInvocationFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR,
            next: ptr::null_mut(),
            shader_terminate_invocation: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShadingRateImageFeaturesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShadingRateImageFeaturesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shading_rate_image: Bool32,
    pub shading_rate_coarse_sample_order: Bool32,
}

impl Default for PhysicalDeviceShadingRateImageFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV,
            next: ptr::null_mut(),
            shading_rate_image: Bool32::default(),
            shading_rate_coarse_sample_order: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShadingRateImagePropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceShadingRateImagePropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shading_rate_texel_size: Extent2D,
    pub shading_rate_palette_size: u32,
    pub shading_rate_max_coarse_samples: u32,
}

impl Default for PhysicalDeviceShadingRateImagePropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV,
            next: ptr::null_mut(),
            shading_rate_texel_size: Extent2D::default(),
            shading_rate_palette_size: u32::default(),
            shading_rate_max_coarse_samples: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSparseImageFormatInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSparseImageFormatInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub format: Format,
    pub type_: ImageType,
    pub samples: SampleCountFlags,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
}

impl Default for PhysicalDeviceSparseImageFormatInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2,
            next: ptr::null(),
            format: Format::default(),
            type_: ImageType::default(),
            samples: SampleCountFlags::default(),
            usage: ImageUsageFlags::default(),
            tiling: ImageTiling::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSparseProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSparseProperties {
    pub residency_standard_2d_block_shape: Bool32,
    pub residency_standard_2d_multisample_block_shape: Bool32,
    pub residency_standard_3d_block_shape: Bool32,
    pub residency_aligned_mip_size: Bool32,
    pub residency_non_resident_strict: Bool32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSubgroupProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSubgroupProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub subgroup_size: u32,
    pub supported_stages: ShaderStageFlags,
    pub supported_operations: SubgroupFeatureFlags,
    pub quad_operations_in_all_stages: Bool32,
}

impl Default for PhysicalDeviceSubgroupProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SUBGROUP_PROPERTIES,
            next: ptr::null_mut(),
            subgroup_size: u32::default(),
            supported_stages: ShaderStageFlags::default(),
            supported_operations: SubgroupFeatureFlags::default(),
            quad_operations_in_all_stages: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSubgroupSizeControlFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub subgroup_size_control: Bool32,
    pub compute_full_subgroups: Bool32,
}

impl Default for PhysicalDeviceSubgroupSizeControlFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT,
            next: ptr::null_mut(),
            subgroup_size_control: Bool32::default(),
            compute_full_subgroups: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSubgroupSizeControlPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_subgroup_size: u32,
    pub max_subgroup_size: u32,
    pub max_compute_workgroup_subgroups: u32,
    pub required_subgroup_size_stages: ShaderStageFlags,
}

impl Default for PhysicalDeviceSubgroupSizeControlPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT,
            next: ptr::null_mut(),
            min_subgroup_size: u32::default(),
            max_subgroup_size: u32::default(),
            max_compute_workgroup_subgroups: u32::default(),
            required_subgroup_size_stages: ShaderStageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSubpassShadingFeaturesHUAWEI.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSubpassShadingFeaturesHUAWEI {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub subpass_shading: Bool32,
}

impl Default for PhysicalDeviceSubpassShadingFeaturesHUAWEI {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI,
            next: ptr::null_mut(),
            subpass_shading: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSubpassShadingPropertiesHUAWEI.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSubpassShadingPropertiesHUAWEI {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_subpass_shading_workgroup_size_aspect_ratio: u32,
}

impl Default for PhysicalDeviceSubpassShadingPropertiesHUAWEI {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI,
            next: ptr::null_mut(),
            max_subpass_shading_workgroup_size_aspect_ratio: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSurfaceInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSurfaceInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub surface: SurfaceKHR,
}

impl Default for PhysicalDeviceSurfaceInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SURFACE_INFO_2_KHR,
            next: ptr::null(),
            surface: SurfaceKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSynchronization2FeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceSynchronization2FeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub synchronization2: Bool32,
}

impl Default for PhysicalDeviceSynchronization2FeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR,
            next: ptr::null_mut(),
            synchronization2: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub texel_buffer_alignment: Bool32,
}

impl Default for PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT,
            next: ptr::null_mut(),
            texel_buffer_alignment: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTexelBufferAlignmentPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub storage_texel_buffer_offset_alignment_bytes: DeviceSize,
    pub storage_texel_buffer_offset_single_texel_alignment: Bool32,
    pub uniform_texel_buffer_offset_alignment_bytes: DeviceSize,
    pub uniform_texel_buffer_offset_single_texel_alignment: Bool32,
}

impl Default for PhysicalDeviceTexelBufferAlignmentPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT,
            next: ptr::null_mut(),
            storage_texel_buffer_offset_alignment_bytes: DeviceSize::default(),
            storage_texel_buffer_offset_single_texel_alignment: Bool32::default(),
            uniform_texel_buffer_offset_alignment_bytes: DeviceSize::default(),
            uniform_texel_buffer_offset_single_texel_alignment: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub texture_compression_astc_hdr: Bool32,
}

impl Default for PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT,
            next: ptr::null_mut(),
            texture_compression_astc_hdr: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTimelineSemaphoreFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub timeline_semaphore: Bool32,
}

impl Default for PhysicalDeviceTimelineSemaphoreFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES,
            next: ptr::null_mut(),
            timeline_semaphore: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTimelineSemaphoreProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_timeline_semaphore_value_difference: u64,
}

impl Default for PhysicalDeviceTimelineSemaphoreProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES,
            next: ptr::null_mut(),
            max_timeline_semaphore_value_difference: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceToolPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceToolPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub name: StringArray<MAX_EXTENSION_NAME_SIZE>,
    pub version: StringArray<MAX_EXTENSION_NAME_SIZE>,
    pub purposes: ToolPurposeFlagsEXT,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
    pub layer: StringArray<MAX_EXTENSION_NAME_SIZE>,
}

impl Default for PhysicalDeviceToolPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT,
            next: ptr::null_mut(),
            name: StringArray::default(),
            version: StringArray::default(),
            purposes: ToolPurposeFlagsEXT::default(),
            description: StringArray::default(),
            layer: StringArray::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTransformFeedbackFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTransformFeedbackFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub transform_feedback: Bool32,
    pub geometry_streams: Bool32,
}

impl Default for PhysicalDeviceTransformFeedbackFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT,
            next: ptr::null_mut(),
            transform_feedback: Bool32::default(),
            geometry_streams: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceTransformFeedbackPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_transform_feedback_streams: u32,
    pub max_transform_feedback_buffers: u32,
    pub max_transform_feedback_buffer_size: DeviceSize,
    pub max_transform_feedback_stream_data_size: u32,
    pub max_transform_feedback_buffer_data_size: u32,
    pub max_transform_feedback_buffer_data_stride: u32,
    pub transform_feedback_queries: Bool32,
    pub transform_feedback_streams_lines_triangles: Bool32,
    pub transform_feedback_rasterization_stream_select: Bool32,
    pub transform_feedback_draw: Bool32,
}

impl Default for PhysicalDeviceTransformFeedbackPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_transform_feedback_streams: u32::default(),
            max_transform_feedback_buffers: u32::default(),
            max_transform_feedback_buffer_size: DeviceSize::default(),
            max_transform_feedback_stream_data_size: u32::default(),
            max_transform_feedback_buffer_data_size: u32::default(),
            max_transform_feedback_buffer_data_stride: u32::default(),
            transform_feedback_queries: Bool32::default(),
            transform_feedback_streams_lines_triangles: Bool32::default(),
            transform_feedback_rasterization_stream_select: Bool32::default(),
            transform_feedback_draw: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceUniformBufferStandardLayoutFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub uniform_buffer_standard_layout: Bool32,
}

impl Default for PhysicalDeviceUniformBufferStandardLayoutFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES,
            next: ptr::null_mut(),
            uniform_buffer_standard_layout: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVariablePointersFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVariablePointersFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub variable_pointers_storage_buffer: Bool32,
    pub variable_pointers: Bool32,
}

impl Default for PhysicalDeviceVariablePointersFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES,
            next: ptr::null_mut(),
            variable_pointers_storage_buffer: Bool32::default(),
            variable_pointers: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub vertex_attribute_instance_rate_divisor: Bool32,
    pub vertex_attribute_instance_rate_zero_divisor: Bool32,
}

impl Default for PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT,
            next: ptr::null_mut(),
            vertex_attribute_instance_rate_divisor: Bool32::default(),
            vertex_attribute_instance_rate_zero_divisor: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub max_vertex_attrib_divisor: u32,
}

impl Default for PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT,
            next: ptr::null_mut(),
            max_vertex_attrib_divisor: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub vertex_input_dynamic_state: Bool32,
}

impl Default for PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT,
            next: ptr::null_mut(),
            vertex_input_dynamic_state: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkan11Features.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVulkan11Features {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub storage_buffer_16bit_access: Bool32,
    pub uniform_and_storage_buffer_16bit_access: Bool32,
    pub storage_push_constant16: Bool32,
    pub storage_input_output16: Bool32,
    pub multiview: Bool32,
    pub multiview_geometry_shader: Bool32,
    pub multiview_tessellation_shader: Bool32,
    pub variable_pointers_storage_buffer: Bool32,
    pub variable_pointers: Bool32,
    pub protected_memory: Bool32,
    pub sampler_ycbcr_conversion: Bool32,
    pub shader_draw_parameters: Bool32,
}

impl Default for PhysicalDeviceVulkan11Features {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VULKAN_1_1_FEATURES,
            next: ptr::null_mut(),
            storage_buffer_16bit_access: Bool32::default(),
            uniform_and_storage_buffer_16bit_access: Bool32::default(),
            storage_push_constant16: Bool32::default(),
            storage_input_output16: Bool32::default(),
            multiview: Bool32::default(),
            multiview_geometry_shader: Bool32::default(),
            multiview_tessellation_shader: Bool32::default(),
            variable_pointers_storage_buffer: Bool32::default(),
            variable_pointers: Bool32::default(),
            protected_memory: Bool32::default(),
            sampler_ycbcr_conversion: Bool32::default(),
            shader_draw_parameters: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkan11Properties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVulkan11Properties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub device_uuid: ByteArray<UUID_SIZE>,
    pub driver_uuid: ByteArray<UUID_SIZE>,
    pub device_luid: ByteArray<LUID_SIZE>,
    pub device_node_mask: u32,
    pub device_luid_valid: Bool32,
    pub subgroup_size: u32,
    pub subgroup_supported_stages: ShaderStageFlags,
    pub subgroup_supported_operations: SubgroupFeatureFlags,
    pub subgroup_quad_operations_in_all_stages: Bool32,
    pub point_clipping_behavior: PointClippingBehavior,
    pub max_multiview_view_count: u32,
    pub max_multiview_instance_index: u32,
    pub protected_no_fault: Bool32,
    pub max_per_set_descriptors: u32,
    pub max_memory_allocation_size: DeviceSize,
}

impl Default for PhysicalDeviceVulkan11Properties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES,
            next: ptr::null_mut(),
            device_uuid: ByteArray::default(),
            driver_uuid: ByteArray::default(),
            device_luid: ByteArray::default(),
            device_node_mask: u32::default(),
            device_luid_valid: Bool32::default(),
            subgroup_size: u32::default(),
            subgroup_supported_stages: ShaderStageFlags::default(),
            subgroup_supported_operations: SubgroupFeatureFlags::default(),
            subgroup_quad_operations_in_all_stages: Bool32::default(),
            point_clipping_behavior: PointClippingBehavior::default(),
            max_multiview_view_count: u32::default(),
            max_multiview_instance_index: u32::default(),
            protected_no_fault: Bool32::default(),
            max_per_set_descriptors: u32::default(),
            max_memory_allocation_size: DeviceSize::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkan12Features.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVulkan12Features {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub sampler_mirror_clamp_to_edge: Bool32,
    pub draw_indirect_count: Bool32,
    pub storage_buffer_8bit_access: Bool32,
    pub uniform_and_storage_buffer_8bit_access: Bool32,
    pub storage_push_constant8: Bool32,
    pub shader_buffer_int64_atomics: Bool32,
    pub shader_shared_int64_atomics: Bool32,
    pub shader_float16: Bool32,
    pub shader_int8: Bool32,
    pub descriptor_indexing: Bool32,
    pub shader_input_attachment_array_dynamic_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_uniform_buffer_array_non_uniform_indexing: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_image_array_non_uniform_indexing: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_texel_buffer_array_non_uniform_indexing: Bool32,
    pub descriptor_binding_uniform_buffer_update_after_bind: Bool32,
    pub descriptor_binding_sampled_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_buffer_update_after_bind: Bool32,
    pub descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_storage_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_update_unused_while_pending: Bool32,
    pub descriptor_binding_partially_bound: Bool32,
    pub descriptor_binding_variable_descriptor_count: Bool32,
    pub runtime_descriptor_array: Bool32,
    pub sampler_filter_minmax: Bool32,
    pub scalar_block_layout: Bool32,
    pub imageless_framebuffer: Bool32,
    pub uniform_buffer_standard_layout: Bool32,
    pub shader_subgroup_extended_types: Bool32,
    pub separate_depth_stencil_layouts: Bool32,
    pub host_query_reset: Bool32,
    pub timeline_semaphore: Bool32,
    pub buffer_device_address: Bool32,
    pub buffer_device_address_capture_replay: Bool32,
    pub buffer_device_address_multi_device: Bool32,
    pub vulkan_memory_model: Bool32,
    pub vulkan_memory_model_device_scope: Bool32,
    pub vulkan_memory_model_availability_visibility_chains: Bool32,
    pub shader_output_viewport_index: Bool32,
    pub shader_output_layer: Bool32,
    pub subgroup_broadcast_dynamic_id: Bool32,
}

impl Default for PhysicalDeviceVulkan12Features {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VULKAN_1_2_FEATURES,
            next: ptr::null_mut(),
            sampler_mirror_clamp_to_edge: Bool32::default(),
            draw_indirect_count: Bool32::default(),
            storage_buffer_8bit_access: Bool32::default(),
            uniform_and_storage_buffer_8bit_access: Bool32::default(),
            storage_push_constant8: Bool32::default(),
            shader_buffer_int64_atomics: Bool32::default(),
            shader_shared_int64_atomics: Bool32::default(),
            shader_float16: Bool32::default(),
            shader_int8: Bool32::default(),
            descriptor_indexing: Bool32::default(),
            shader_input_attachment_array_dynamic_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_uniform_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            descriptor_binding_uniform_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_sampled_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_storage_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_update_unused_while_pending: Bool32::default(),
            descriptor_binding_partially_bound: Bool32::default(),
            descriptor_binding_variable_descriptor_count: Bool32::default(),
            runtime_descriptor_array: Bool32::default(),
            sampler_filter_minmax: Bool32::default(),
            scalar_block_layout: Bool32::default(),
            imageless_framebuffer: Bool32::default(),
            uniform_buffer_standard_layout: Bool32::default(),
            shader_subgroup_extended_types: Bool32::default(),
            separate_depth_stencil_layouts: Bool32::default(),
            host_query_reset: Bool32::default(),
            timeline_semaphore: Bool32::default(),
            buffer_device_address: Bool32::default(),
            buffer_device_address_capture_replay: Bool32::default(),
            buffer_device_address_multi_device: Bool32::default(),
            vulkan_memory_model: Bool32::default(),
            vulkan_memory_model_device_scope: Bool32::default(),
            vulkan_memory_model_availability_visibility_chains: Bool32::default(),
            shader_output_viewport_index: Bool32::default(),
            shader_output_layer: Bool32::default(),
            subgroup_broadcast_dynamic_id: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkan12Properties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVulkan12Properties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub driver_id: DriverId,
    pub driver_name: StringArray<MAX_DRIVER_NAME_SIZE>,
    pub driver_info: StringArray<MAX_DRIVER_INFO_SIZE>,
    pub conformance_version: ConformanceVersion,
    pub denorm_behavior_independence: ShaderFloatControlsIndependence,
    pub rounding_mode_independence: ShaderFloatControlsIndependence,
    pub shader_signed_zero_inf_nan_preserve_float16: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float32: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float64: Bool32,
    pub shader_denorm_preserve_float16: Bool32,
    pub shader_denorm_preserve_float32: Bool32,
    pub shader_denorm_preserve_float64: Bool32,
    pub shader_denorm_flush_to_zero_float16: Bool32,
    pub shader_denorm_flush_to_zero_float32: Bool32,
    pub shader_denorm_flush_to_zero_float64: Bool32,
    pub shader_rounding_mode_rte_float16: Bool32,
    pub shader_rounding_mode_rte_float32: Bool32,
    pub shader_rounding_mode_rte_float64: Bool32,
    pub shader_rounding_mode_rtz_float16: Bool32,
    pub shader_rounding_mode_rtz_float32: Bool32,
    pub shader_rounding_mode_rtz_float64: Bool32,
    pub max_update_after_bind_descriptors_in_all_pools: u32,
    pub shader_uniform_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_image_array_non_uniform_indexing_native: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing_native: Bool32,
    pub robust_buffer_access_update_after_bind: Bool32,
    pub quad_divergent_implicit_lod: Bool32,
    pub max_per_stage_descriptor_update_after_bind_samplers: u32,
    pub max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_images: u32,
    pub max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    pub max_per_stage_update_after_bind_resources: u32,
    pub max_descriptor_set_update_after_bind_samplers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_sampled_images: u32,
    pub max_descriptor_set_update_after_bind_storage_images: u32,
    pub max_descriptor_set_update_after_bind_input_attachments: u32,
    pub supported_depth_resolve_modes: ResolveModeFlags,
    pub supported_stencil_resolve_modes: ResolveModeFlags,
    pub independent_resolve_none: Bool32,
    pub independent_resolve: Bool32,
    pub filter_minmax_single_component_formats: Bool32,
    pub filter_minmax_image_component_mapping: Bool32,
    pub max_timeline_semaphore_value_difference: u64,
    pub framebuffer_integer_color_sample_counts: SampleCountFlags,
}

impl Default for PhysicalDeviceVulkan12Properties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES,
            next: ptr::null_mut(),
            driver_id: DriverId::default(),
            driver_name: StringArray::default(),
            driver_info: StringArray::default(),
            conformance_version: ConformanceVersion::default(),
            denorm_behavior_independence: ShaderFloatControlsIndependence::default(),
            rounding_mode_independence: ShaderFloatControlsIndependence::default(),
            shader_signed_zero_inf_nan_preserve_float16: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float32: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float64: Bool32::default(),
            shader_denorm_preserve_float16: Bool32::default(),
            shader_denorm_preserve_float32: Bool32::default(),
            shader_denorm_preserve_float64: Bool32::default(),
            shader_denorm_flush_to_zero_float16: Bool32::default(),
            shader_denorm_flush_to_zero_float32: Bool32::default(),
            shader_denorm_flush_to_zero_float64: Bool32::default(),
            shader_rounding_mode_rte_float16: Bool32::default(),
            shader_rounding_mode_rte_float32: Bool32::default(),
            shader_rounding_mode_rte_float64: Bool32::default(),
            shader_rounding_mode_rtz_float16: Bool32::default(),
            shader_rounding_mode_rtz_float32: Bool32::default(),
            shader_rounding_mode_rtz_float64: Bool32::default(),
            max_update_after_bind_descriptors_in_all_pools: u32::default(),
            shader_uniform_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing_native: Bool32::default(),
            robust_buffer_access_update_after_bind: Bool32::default(),
            quad_divergent_implicit_lod: Bool32::default(),
            max_per_stage_descriptor_update_after_bind_samplers: u32::default(),
            max_per_stage_descriptor_update_after_bind_uniform_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_sampled_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_input_attachments: u32::default(),
            max_per_stage_update_after_bind_resources: u32::default(),
            max_descriptor_set_update_after_bind_samplers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_sampled_images: u32::default(),
            max_descriptor_set_update_after_bind_storage_images: u32::default(),
            max_descriptor_set_update_after_bind_input_attachments: u32::default(),
            supported_depth_resolve_modes: ResolveModeFlags::default(),
            supported_stencil_resolve_modes: ResolveModeFlags::default(),
            independent_resolve_none: Bool32::default(),
            independent_resolve: Bool32::default(),
            filter_minmax_single_component_formats: Bool32::default(),
            filter_minmax_image_component_mapping: Bool32::default(),
            max_timeline_semaphore_value_difference: u64::default(),
            framebuffer_integer_color_sample_counts: SampleCountFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceVulkanMemoryModelFeatures {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub vulkan_memory_model: Bool32,
    pub vulkan_memory_model_device_scope: Bool32,
    pub vulkan_memory_model_availability_visibility_chains: Bool32,
}

impl Default for PhysicalDeviceVulkanMemoryModelFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES,
            next: ptr::null_mut(),
            vulkan_memory_model: Bool32::default(),
            vulkan_memory_model_device_scope: Bool32::default(),
            vulkan_memory_model_availability_visibility_chains: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub workgroup_memory_explicit_layout: Bool32,
    pub workgroup_memory_explicit_layout_scalar_block_layout: Bool32,
    pub workgroup_memory_explicit_layout_8bit_access: Bool32,
    pub workgroup_memory_explicit_layout_16bit_access: Bool32,
}

impl Default for PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR,
            next: ptr::null_mut(),
            workgroup_memory_explicit_layout: Bool32::default(),
            workgroup_memory_explicit_layout_scalar_block_layout: Bool32::default(),
            workgroup_memory_explicit_layout_8bit_access: Bool32::default(),
            workgroup_memory_explicit_layout_16bit_access: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub ycbcr2plane444_formats: Bool32,
}

impl Default for PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT,
            next: ptr::null_mut(),
            ycbcr2plane444_formats: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceYcbcrImageArraysFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceYcbcrImageArraysFeaturesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub ycbcr_image_arrays: Bool32,
}

impl Default for PhysicalDeviceYcbcrImageArraysFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT,
            next: ptr::null_mut(),
            ycbcr_image_arrays: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shader_zero_initialize_workgroup_memory: Bool32,
}

impl Default for PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR,
            next: ptr::null_mut(),
            shader_zero_initialize_workgroup_memory: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCacheCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCacheCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initial_data_size: usize,
    pub initial_data: *const c_void,
}

impl Default for PipelineCacheCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_CACHE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineCacheCreateFlags::default(),
            initial_data_size: usize::default(),
            initial_data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCacheHeaderVersionOne.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCacheHeaderVersionOne {
    pub header_size: u32,
    pub header_version: PipelineCacheHeaderVersion,
    pub vendor_id: u32,
    pub device_id: u32,
    pub pipeline_cache_uuid: ByteArray<UUID_SIZE>,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendAdvancedStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_premultiplied: Bool32,
    pub dst_premultiplied: Bool32,
    pub blend_overlap: BlendOverlapEXT,
}

impl Default for PipelineColorBlendAdvancedStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            src_premultiplied: Bool32::default(),
            dst_premultiplied: Bool32::default(),
            blend_overlap: BlendOverlapEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendAttachmentState.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PipelineColorBlendAttachmentState {
    pub blend_enable: Bool32,
    pub src_color_blend_factor: BlendFactor,
    pub dst_color_blend_factor: BlendFactor,
    pub color_blend_op: BlendOp,
    pub src_alpha_blend_factor: BlendFactor,
    pub dst_alpha_blend_factor: BlendFactor,
    pub alpha_blend_op: BlendOp,
    pub color_write_mask: ColorComponentFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipelineColorBlendStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logic_op_enable: Bool32,
    pub logic_op: LogicOp,
    pub attachment_count: u32,
    pub attachments: *const PipelineColorBlendAttachmentState,
    pub blend_constants: [f32; 4],
}

impl Default for PipelineColorBlendStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COLOR_BLEND_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineColorBlendStateCreateFlags::default(),
            logic_op_enable: Bool32::default(),
            logic_op: LogicOp::default(),
            attachment_count: u32::default(),
            attachments: ptr::null(),
            blend_constants: [f32::default(); 4],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorWriteCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineColorWriteCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attachment_count: u32,
    pub color_write_enables: *const Bool32,
}

impl Default for PipelineColorWriteCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COLOR_WRITE_CREATE_INFO_EXT,
            next: ptr::null(),
            attachment_count: u32::default(),
            color_write_enables: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCompilerControlCreateInfoAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCompilerControlCreateInfoAMD {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub compiler_control_flags: PipelineCompilerControlFlagsAMD,
}

impl Default for PipelineCompilerControlCreateInfoAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD,
            next: ptr::null(),
            compiler_control_flags: PipelineCompilerControlFlagsAMD::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageModulationStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCoverageModulationStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCoverageModulationStateCreateFlagsNV,
    pub coverage_modulation_mode: CoverageModulationModeNV,
    pub coverage_modulation_table_enable: Bool32,
    pub coverage_modulation_table_count: u32,
    pub coverage_modulation_table: *const f32,
}

impl Default for PipelineCoverageModulationStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            flags: PipelineCoverageModulationStateCreateFlagsNV::default(),
            coverage_modulation_mode: CoverageModulationModeNV::default(),
            coverage_modulation_table_enable: Bool32::default(),
            coverage_modulation_table_count: u32::default(),
            coverage_modulation_table: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageReductionStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCoverageReductionStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCoverageReductionStateCreateFlagsNV,
    pub coverage_reduction_mode: CoverageReductionModeNV,
}

impl Default for PipelineCoverageReductionStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            flags: PipelineCoverageReductionStateCreateFlagsNV::default(),
            coverage_reduction_mode: CoverageReductionModeNV::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageToColorStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCoverageToColorStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCoverageToColorStateCreateFlagsNV,
    pub coverage_to_color_enable: Bool32,
    pub coverage_to_color_location: u32,
}

impl Default for PipelineCoverageToColorStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            flags: PipelineCoverageToColorStateCreateFlagsNV::default(),
            coverage_to_color_enable: Bool32::default(),
            coverage_to_color_location: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCreationFeedbackCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCreationFeedbackCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub pipeline_creation_feedback: *mut PipelineCreationFeedbackEXT,
    pub pipeline_stage_creation_feedback_count: u32,
    pub pipeline_stage_creation_feedbacks: *mut PipelineCreationFeedbackEXT,
}

impl Default for PipelineCreationFeedbackCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT,
            next: ptr::null(),
            pipeline_creation_feedback: ptr::null_mut(),
            pipeline_stage_creation_feedback_count: u32::default(),
            pipeline_stage_creation_feedbacks: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCreationFeedbackEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PipelineCreationFeedbackEXT {
    pub flags: PipelineCreationFeedbackFlagsEXT,
    pub duration: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDepthStencilStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipelineDepthStencilStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depth_test_enable: Bool32,
    pub depth_write_enable: Bool32,
    pub depth_compare_op: CompareOp,
    pub depth_bounds_test_enable: Bool32,
    pub stencil_test_enable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub min_depth_bounds: f32,
    pub max_depth_bounds: f32,
}

impl Default for PipelineDepthStencilStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineDepthStencilStateCreateFlags::default(),
            depth_test_enable: Bool32::default(),
            depth_write_enable: Bool32::default(),
            depth_compare_op: CompareOp::default(),
            depth_bounds_test_enable: Bool32::default(),
            stencil_test_enable: Bool32::default(),
            front: StencilOpState::default(),
            back: StencilOpState::default(),
            min_depth_bounds: f32::default(),
            max_depth_bounds: f32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDiscardRectangleStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineDiscardRectangleStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineDiscardRectangleStateCreateFlagsEXT,
    pub discard_rectangle_mode: DiscardRectangleModeEXT,
    pub discard_rectangle_count: u32,
    pub discard_rectangles: *const Rect2D,
}

impl Default for PipelineDiscardRectangleStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: PipelineDiscardRectangleStateCreateFlagsEXT::default(),
            discard_rectangle_mode: DiscardRectangleModeEXT::default(),
            discard_rectangle_count: u32::default(),
            discard_rectangles: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDynamicStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineDynamicStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamic_state_count: u32,
    pub dynamic_states: *const DynamicState,
}

impl Default for PipelineDynamicStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_DYNAMIC_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineDynamicStateCreateFlags::default(),
            dynamic_state_count: u32::default(),
            dynamic_states: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineExecutableInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineExecutableInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub pipeline: Pipeline,
    pub executable_index: u32,
}

impl Default for PipelineExecutableInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_EXECUTABLE_INFO_KHR,
            next: ptr::null(),
            pipeline: Pipeline::default(),
            executable_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineExecutableInternalRepresentationKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineExecutableInternalRepresentationKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub name: StringArray<MAX_DESCRIPTION_SIZE>,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
    pub is_text: Bool32,
    pub data_size: usize,
    pub data: *mut c_void,
}

impl Default for PipelineExecutableInternalRepresentationKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR,
            next: ptr::null_mut(),
            name: StringArray::default(),
            description: StringArray::default(),
            is_text: Bool32::default(),
            data_size: usize::default(),
            data: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineExecutablePropertiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineExecutablePropertiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub stages: ShaderStageFlags,
    pub name: StringArray<MAX_DESCRIPTION_SIZE>,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
    pub subgroup_size: u32,
}

impl Default for PipelineExecutablePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_EXECUTABLE_PROPERTIES_KHR,
            next: ptr::null_mut(),
            stages: ShaderStageFlags::default(),
            name: StringArray::default(),
            description: StringArray::default(),
            subgroup_size: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineExecutableStatisticKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct PipelineExecutableStatisticKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub name: StringArray<MAX_DESCRIPTION_SIZE>,
    pub description: StringArray<MAX_DESCRIPTION_SIZE>,
    pub format: PipelineExecutableStatisticFormatKHR,
    pub value: PipelineExecutableStatisticValueKHR,
}

impl Default for PipelineExecutableStatisticKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_EXECUTABLE_STATISTIC_KHR,
            next: ptr::null_mut(),
            name: StringArray::default(),
            description: StringArray::default(),
            format: PipelineExecutableStatisticFormatKHR::default(),
            value: PipelineExecutableStatisticValueKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineFragmentShadingRateEnumStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineFragmentShadingRateEnumStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub shading_rate_type: FragmentShadingRateTypeNV,
    pub shading_rate: FragmentShadingRateNV,
    pub combiner_ops: [FragmentShadingRateCombinerOpKHR; 2],
}

impl Default for PipelineFragmentShadingRateEnumStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            shading_rate_type: FragmentShadingRateTypeNV::default(),
            shading_rate: FragmentShadingRateNV::default(),
            combiner_ops: [FragmentShadingRateCombinerOpKHR::default(); 2],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineFragmentShadingRateStateCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineFragmentShadingRateStateCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fragment_size: Extent2D,
    pub combiner_ops: [FragmentShadingRateCombinerOpKHR; 2],
}

impl Default for PipelineFragmentShadingRateStateCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR,
            next: ptr::null(),
            fragment_size: Extent2D::default(),
            combiner_ops: [FragmentShadingRateCombinerOpKHR::default(); 2],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub pipeline: Pipeline,
}

impl Default for PipelineInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_INFO_KHR,
            next: ptr::null(),
            pipeline: Pipeline::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineInputAssemblyStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineInputAssemblyStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitive_restart_enable: Bool32,
}

impl Default for PipelineInputAssemblyStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineInputAssemblyStateCreateFlags::default(),
            topology: PrimitiveTopology::default(),
            primitive_restart_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLayoutCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineLayoutCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub set_layout_count: u32,
    pub set_layouts: *const DescriptorSetLayout,
    pub push_constant_range_count: u32,
    pub push_constant_ranges: *const PushConstantRange,
}

impl Default for PipelineLayoutCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_LAYOUT_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineLayoutCreateFlags::default(),
            set_layout_count: u32::default(),
            set_layouts: ptr::null(),
            push_constant_range_count: u32::default(),
            push_constant_ranges: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLibraryCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineLibraryCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub library_count: u32,
    pub libraries: *const Pipeline,
}

impl Default for PipelineLibraryCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_LIBRARY_CREATE_INFO_KHR,
            next: ptr::null(),
            library_count: u32::default(),
            libraries: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipelineMultisampleStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterization_samples: SampleCountFlags,
    pub sample_shading_enable: Bool32,
    pub min_sample_shading: f32,
    pub sample_mask: *const SampleMask,
    pub alpha_to_coverage_enable: Bool32,
    pub alpha_to_one_enable: Bool32,
}

impl Default for PipelineMultisampleStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_MULTISAMPLE_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineMultisampleStateCreateFlags::default(),
            rasterization_samples: SampleCountFlags::default(),
            sample_shading_enable: Bool32::default(),
            min_sample_shading: f32::default(),
            sample_mask: ptr::null(),
            alpha_to_coverage_enable: Bool32::default(),
            alpha_to_one_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationConservativeStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipelineRasterizationConservativeStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineRasterizationConservativeStateCreateFlagsEXT,
    pub conservative_rasterization_mode: ConservativeRasterizationModeEXT,
    pub extra_primitive_overestimation_size: f32,
}

impl Default for PipelineRasterizationConservativeStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: PipelineRasterizationConservativeStateCreateFlagsEXT::default(),
            conservative_rasterization_mode: ConservativeRasterizationModeEXT::default(),
            extra_primitive_overestimation_size: f32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationDepthClipStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRasterizationDepthClipStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineRasterizationDepthClipStateCreateFlagsEXT,
    pub depth_clip_enable: Bool32,
}

impl Default for PipelineRasterizationDepthClipStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: PipelineRasterizationDepthClipStateCreateFlagsEXT::default(),
            depth_clip_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationLineStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRasterizationLineStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub line_rasterization_mode: LineRasterizationModeEXT,
    pub stippled_line_enable: Bool32,
    pub line_stipple_factor: u32,
    pub line_stipple_pattern: u16,
}

impl Default for PipelineRasterizationLineStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            line_rasterization_mode: LineRasterizationModeEXT::default(),
            stippled_line_enable: Bool32::default(),
            line_stipple_factor: u32::default(),
            line_stipple_pattern: u16::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationProvokingVertexStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRasterizationProvokingVertexStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub provoking_vertex_mode: ProvokingVertexModeEXT,
}

impl Default for PipelineRasterizationProvokingVertexStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            provoking_vertex_mode: ProvokingVertexModeEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipelineRasterizationStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depth_clamp_enable: Bool32,
    pub rasterizer_discard_enable: Bool32,
    pub polygon_mode: PolygonMode,
    pub cull_mode: CullModeFlags,
    pub front_face: FrontFace,
    pub depth_bias_enable: Bool32,
    pub depth_bias_constant_factor: f32,
    pub depth_bias_clamp: f32,
    pub depth_bias_slope_factor: f32,
    pub line_width: f32,
}

impl Default for PipelineRasterizationStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineRasterizationStateCreateFlags::default(),
            depth_clamp_enable: Bool32::default(),
            rasterizer_discard_enable: Bool32::default(),
            polygon_mode: PolygonMode::default(),
            cull_mode: CullModeFlags::default(),
            front_face: FrontFace::default(),
            depth_bias_enable: Bool32::default(),
            depth_bias_constant_factor: f32::default(),
            depth_bias_clamp: f32::default(),
            depth_bias_slope_factor: f32::default(),
            line_width: f32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateRasterizationOrderAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRasterizationStateRasterizationOrderAMD {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub rasterization_order: RasterizationOrderAMD,
}

impl Default for PipelineRasterizationStateRasterizationOrderAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD,
            next: ptr::null(),
            rasterization_order: RasterizationOrderAMD::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateStreamCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRasterizationStateStreamCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineRasterizationStateStreamCreateFlagsEXT,
    pub rasterization_stream: u32,
}

impl Default for PipelineRasterizationStateStreamCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: PipelineRasterizationStateStreamCreateFlagsEXT::default(),
            rasterization_stream: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRepresentativeFragmentTestStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineRepresentativeFragmentTestStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub representative_fragment_test_enable: Bool32,
}

impl Default for PipelineRepresentativeFragmentTestStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            representative_fragment_test_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineSampleLocationsStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineSampleLocationsStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub sample_locations_enable: Bool32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}

impl Default for PipelineSampleLocationsStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            sample_locations_enable: Bool32::default(),
            sample_locations_info: SampleLocationsInfoEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineShaderStageCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineShaderStageCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlags,
    pub module: ShaderModule,
    pub name: *const c_char,
    pub specialization_info: *const SpecializationInfo,
}

impl Default for PipelineShaderStageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_SHADER_STAGE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineShaderStageCreateFlags::default(),
            stage: ShaderStageFlags::default(),
            module: ShaderModule::default(),
            name: ptr::null(),
            specialization_info: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineShaderStageRequiredSubgroupSizeCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub required_subgroup_size: u32,
}

impl Default for PipelineShaderStageRequiredSubgroupSizeCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT,
            next: ptr::null_mut(),
            required_subgroup_size: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationDomainOriginStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineTessellationDomainOriginStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub domain_origin: TessellationDomainOrigin,
}

impl Default for PipelineTessellationDomainOriginStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO,
            next: ptr::null(),
            domain_origin: TessellationDomainOrigin::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineTessellationStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patch_control_points: u32,
}

impl Default for PipelineTessellationStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_TESSELLATION_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineTessellationStateCreateFlags::default(),
            patch_control_points: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineVertexInputDivisorStateCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineVertexInputDivisorStateCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub vertex_binding_divisor_count: u32,
    pub vertex_binding_divisors: *const VertexInputBindingDivisorDescriptionEXT,
}

impl Default for PipelineVertexInputDivisorStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT,
            next: ptr::null(),
            vertex_binding_divisor_count: u32::default(),
            vertex_binding_divisors: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineVertexInputStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineVertexInputStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertex_binding_description_count: u32,
    pub vertex_binding_descriptions: *const VertexInputBindingDescription,
    pub vertex_attribute_description_count: u32,
    pub vertex_attribute_descriptions: *const VertexInputAttributeDescription,
}

impl Default for PipelineVertexInputStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineVertexInputStateCreateFlags::default(),
            vertex_binding_description_count: u32::default(),
            vertex_binding_descriptions: ptr::null(),
            vertex_attribute_description_count: u32::default(),
            vertex_attribute_descriptions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportCoarseSampleOrderStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportCoarseSampleOrderStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub sample_order_type: CoarseSampleOrderTypeNV,
    pub custom_sample_order_count: u32,
    pub custom_sample_orders: *const CoarseSampleOrderCustomNV,
}

impl Default for PipelineViewportCoarseSampleOrderStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            sample_order_type: CoarseSampleOrderTypeNV::default(),
            custom_sample_order_count: u32::default(),
            custom_sample_orders: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportExclusiveScissorStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportExclusiveScissorStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub exclusive_scissor_count: u32,
    pub exclusive_scissors: *const Rect2D,
}

impl Default for PipelineViewportExclusiveScissorStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            exclusive_scissor_count: u32::default(),
            exclusive_scissors: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportShadingRateImageStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportShadingRateImageStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub shading_rate_image_enable: Bool32,
    pub viewport_count: u32,
    pub shading_rate_palettes: *const ShadingRatePaletteNV,
}

impl Default for PipelineViewportShadingRateImageStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            shading_rate_image_enable: Bool32::default(),
            viewport_count: u32::default(),
            shading_rate_palettes: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportStateCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportStateCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewport_count: u32,
    pub viewports: *const Viewport,
    pub scissor_count: u32,
    pub scissors: *const Rect2D,
}

impl Default for PipelineViewportStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_STATE_CREATE_INFO,
            next: ptr::null(),
            flags: PipelineViewportStateCreateFlags::default(),
            viewport_count: u32::default(),
            viewports: ptr::null(),
            scissor_count: u32::default(),
            scissors: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportSwizzleStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportSwizzleStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineViewportSwizzleStateCreateFlagsNV,
    pub viewport_count: u32,
    pub viewport_swizzles: *const ViewportSwizzleNV,
}

impl Default for PipelineViewportSwizzleStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            flags: PipelineViewportSwizzleStateCreateFlagsNV::default(),
            viewport_count: u32::default(),
            viewport_swizzles: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportWScalingStateCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PipelineViewportWScalingStateCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub viewport_w_scaling_enable: Bool32,
    pub viewport_count: u32,
    pub viewport_w_scalings: *const ViewportWScalingNV,
}

impl Default for PipelineViewportWScalingStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV,
            next: ptr::null(),
            viewport_w_scaling_enable: Bool32::default(),
            viewport_count: u32::default(),
            viewport_w_scalings: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentFrameTokenGGP.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentFrameTokenGGP {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub frame_token: GgpFrameToken,
}

impl Default for PresentFrameTokenGGP {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRESENT_FRAME_TOKEN_GGP,
            next: ptr::null(),
            frame_token: GgpFrameToken::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentIdKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentIdKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain_count: u32,
    pub present_ids: *const u64,
}

impl Default for PresentIdKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRESENT_ID_KHR,
            next: ptr::null(),
            swapchain_count: u32::default(),
            present_ids: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_count: u32,
    pub wait_semaphores: *const Semaphore,
    pub swapchain_count: u32,
    pub swapchains: *const SwapchainKHR,
    pub image_indices: *const u32,
    pub results: *mut Result,
}

impl Default for PresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRESENT_INFO_KHR,
            next: ptr::null(),
            wait_semaphore_count: u32::default(),
            wait_semaphores: ptr::null(),
            swapchain_count: u32::default(),
            swapchains: ptr::null(),
            image_indices: ptr::null(),
            results: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentRegionKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentRegionKHR {
    pub rectangle_count: u32,
    pub rectangles: *const RectLayerKHR,
}

impl Default for PresentRegionKHR {
    #[inline]
    fn default() -> Self {
        Self {
            rectangle_count: u32::default(),
            rectangles: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentRegionsKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentRegionsKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain_count: u32,
    pub regions: *const PresentRegionKHR,
}

impl Default for PresentRegionsKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRESENT_REGIONS_KHR,
            next: ptr::null(),
            swapchain_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentTimeGOOGLE.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PresentTimeGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentTimesInfoGOOGLE.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PresentTimesInfoGOOGLE {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub swapchain_count: u32,
    pub times: *const PresentTimeGOOGLE,
}

impl Default for PresentTimesInfoGOOGLE {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRESENT_TIMES_INFO_GOOGLE,
            next: ptr::null(),
            swapchain_count: u32::default(),
            times: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPrivateDataSlotCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct PrivateDataSlotCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PrivateDataSlotCreateFlagsEXT,
}

impl Default for PrivateDataSlotCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PRIVATE_DATA_SLOT_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: PrivateDataSlotCreateFlagsEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkProtectedSubmitInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ProtectedSubmitInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub protected_submit: Bool32,
}

impl Default for ProtectedSubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::PROTECTED_SUBMIT_INFO,
            next: ptr::null(),
            protected_submit: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPushConstantRange.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct PushConstantRange {
    pub stage_flags: ShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueryPoolCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub query_type: QueryType,
    pub query_count: u32,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}

impl Default for QueryPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUERY_POOL_CREATE_INFO,
            next: ptr::null(),
            flags: QueryPoolCreateFlags::default(),
            query_type: QueryType::default(),
            query_count: u32::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolPerformanceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueryPoolPerformanceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub queue_family_index: u32,
    pub counter_index_count: u32,
    pub counter_indices: *const u32,
}

impl Default for QueryPoolPerformanceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR,
            next: ptr::null(),
            queue_family_index: u32::default(),
            counter_index_count: u32::default(),
            counter_indices: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolPerformanceQueryCreateInfoINTEL.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueryPoolPerformanceQueryCreateInfoINTEL {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub performance_counters_sampling: QueryPoolSamplingModeINTEL,
}

impl Default for QueryPoolPerformanceQueryCreateInfoINTEL {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL,
            next: ptr::null(),
            performance_counters_sampling: QueryPoolSamplingModeINTEL::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyCheckpointProperties2NV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueueFamilyCheckpointProperties2NV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub checkpoint_execution_stage_mask: PipelineStageFlags2KHR,
}

impl Default for QueueFamilyCheckpointProperties2NV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV,
            next: ptr::null_mut(),
            checkpoint_execution_stage_mask: PipelineStageFlags2KHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyCheckpointPropertiesNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueueFamilyCheckpointPropertiesNV {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub checkpoint_execution_stage_mask: PipelineStageFlags,
}

impl Default for QueueFamilyCheckpointPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV,
            next: ptr::null_mut(),
            checkpoint_execution_stage_mask: PipelineStageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyGlobalPriorityPropertiesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueueFamilyGlobalPriorityPropertiesEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub priority_count: u32,
    pub priorities: [QueueGlobalPriorityEXT; MAX_GLOBAL_PRIORITY_SIZE_EXT],
}

impl Default for QueueFamilyGlobalPriorityPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT,
            next: ptr::null_mut(),
            priority_count: u32::default(),
            priorities: [QueueGlobalPriorityEXT::default(); MAX_GLOBAL_PRIORITY_SIZE_EXT],
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct QueueFamilyProperties {
    pub queue_flags: QueueFlags,
    pub queue_count: u32,
    pub timestamp_valid_bits: u32,
    pub min_image_transfer_granularity: Extent3D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct QueueFamilyProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub queue_family_properties: QueueFamilyProperties,
}

impl Default for QueueFamilyProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::QUEUE_FAMILY_PROPERTIES_2,
            next: ptr::null_mut(),
            queue_family_properties: QueueFamilyProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingPipelineCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RayTracingPipelineCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub stages: *const PipelineShaderStageCreateInfo,
    pub group_count: u32,
    pub groups: *const RayTracingShaderGroupCreateInfoKHR,
    pub max_pipeline_ray_recursion_depth: u32,
    pub library_info: *const PipelineLibraryCreateInfoKHR,
    pub library_interface: *const RayTracingPipelineInterfaceCreateInfoKHR,
    pub dynamic_state: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}

impl Default for RayTracingPipelineCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RAY_TRACING_PIPELINE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            stages: ptr::null(),
            group_count: u32::default(),
            groups: ptr::null(),
            max_pipeline_ray_recursion_depth: u32::default(),
            library_info: ptr::null(),
            library_interface: ptr::null(),
            dynamic_state: ptr::null(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingPipelineCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RayTracingPipelineCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub stages: *const PipelineShaderStageCreateInfo,
    pub group_count: u32,
    pub groups: *const RayTracingShaderGroupCreateInfoNV,
    pub max_recursion_depth: u32,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}

impl Default for RayTracingPipelineCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RAY_TRACING_PIPELINE_CREATE_INFO_NV,
            next: ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            stages: ptr::null(),
            group_count: u32::default(),
            groups: ptr::null(),
            max_recursion_depth: u32::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingPipelineInterfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RayTracingPipelineInterfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub max_pipeline_ray_payload_size: u32,
    pub max_pipeline_ray_hit_attribute_size: u32,
}

impl Default for RayTracingPipelineInterfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            max_pipeline_ray_payload_size: u32::default(),
            max_pipeline_ray_hit_attribute_size: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingShaderGroupCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RayTracingShaderGroupCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: RayTracingShaderGroupTypeKHR,
    pub general_shader: u32,
    pub closest_hit_shader: u32,
    pub any_hit_shader: u32,
    pub intersection_shader: u32,
    pub shader_group_capture_replay_handle: *const c_void,
}

impl Default for RayTracingShaderGroupCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR,
            next: ptr::null(),
            type_: RayTracingShaderGroupTypeKHR::default(),
            general_shader: u32::default(),
            closest_hit_shader: u32::default(),
            any_hit_shader: u32::default(),
            intersection_shader: u32::default(),
            shader_group_capture_replay_handle: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRayTracingShaderGroupCreateInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RayTracingShaderGroupCreateInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub type_: RayTracingShaderGroupTypeKHR,
    pub general_shader: u32,
    pub closest_hit_shader: u32,
    pub any_hit_shader: u32,
    pub intersection_shader: u32,
}

impl Default for RayTracingShaderGroupCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV,
            next: ptr::null(),
            type_: RayTracingShaderGroupTypeKHR::default(),
            general_shader: u32::default(),
            closest_hit_shader: u32::default(),
            any_hit_shader: u32::default(),
            intersection_shader: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRect2D.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRectLayerKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct RectLayerKHR {
    pub offset: Offset2D,
    pub extent: Extent2D,
    pub layer: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRefreshCycleDurationGOOGLE.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct RefreshCycleDurationGOOGLE {
    pub refresh_duration: u64,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassAttachmentBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassAttachmentBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attachment_count: u32,
    pub attachments: *const ImageView,
}

impl Default for RenderPassAttachmentBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_ATTACHMENT_BEGIN_INFO,
            next: ptr::null(),
            attachment_count: u32::default(),
            attachments: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub render_pass: RenderPass,
    pub framebuffer: Framebuffer,
    pub render_area: Rect2D,
    pub clear_value_count: u32,
    pub clear_values: *const ClearValue,
}

impl Default for RenderPassBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_BEGIN_INFO,
            next: ptr::null(),
            render_pass: RenderPass::default(),
            framebuffer: Framebuffer::default(),
            render_area: Rect2D::default(),
            clear_value_count: u32::default(),
            clear_values: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub attachments: *const AttachmentDescription,
    pub subpass_count: u32,
    pub subpasses: *const SubpassDescription,
    pub dependency_count: u32,
    pub dependencies: *const SubpassDependency,
}

impl Default for RenderPassCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_CREATE_INFO,
            next: ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            attachments: ptr::null(),
            subpass_count: u32::default(),
            subpasses: ptr::null(),
            dependency_count: u32::default(),
            dependencies: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassCreateInfo2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassCreateInfo2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub attachments: *const AttachmentDescription2,
    pub subpass_count: u32,
    pub subpasses: *const SubpassDescription2,
    pub dependency_count: u32,
    pub dependencies: *const SubpassDependency2,
    pub correlated_view_mask_count: u32,
    pub correlated_view_masks: *const u32,
}

impl Default for RenderPassCreateInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_CREATE_INFO_2,
            next: ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            attachments: ptr::null(),
            subpass_count: u32::default(),
            subpasses: ptr::null(),
            dependency_count: u32::default(),
            dependencies: ptr::null(),
            correlated_view_mask_count: u32::default(),
            correlated_view_masks: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassFragmentDensityMapCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassFragmentDensityMapCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub fragment_density_map_attachment: AttachmentReference,
}

impl Default for RenderPassFragmentDensityMapCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT,
            next: ptr::null(),
            fragment_density_map_attachment: AttachmentReference::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassInputAttachmentAspectCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassInputAttachmentAspectCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub aspect_reference_count: u32,
    pub aspect_references: *const InputAttachmentAspectReference,
}

impl Default for RenderPassInputAttachmentAspectCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO,
            next: ptr::null(),
            aspect_reference_count: u32::default(),
            aspect_references: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassMultiviewCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassMultiviewCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub subpass_count: u32,
    pub view_masks: *const u32,
    pub dependency_count: u32,
    pub view_offsets: *const i32,
    pub correlation_mask_count: u32,
    pub correlation_masks: *const u32,
}

impl Default for RenderPassMultiviewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_MULTIVIEW_CREATE_INFO,
            next: ptr::null(),
            subpass_count: u32::default(),
            view_masks: ptr::null(),
            dependency_count: u32::default(),
            view_offsets: ptr::null(),
            correlation_mask_count: u32::default(),
            correlation_masks: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassSampleLocationsBeginInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassSampleLocationsBeginInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub attachment_initial_sample_locations_count: u32,
    pub attachment_initial_sample_locations: *const AttachmentSampleLocationsEXT,
    pub post_subpass_sample_locations_count: u32,
    pub post_subpass_sample_locations: *const SubpassSampleLocationsEXT,
}

impl Default for RenderPassSampleLocationsBeginInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT,
            next: ptr::null(),
            attachment_initial_sample_locations_count: u32::default(),
            attachment_initial_sample_locations: ptr::null(),
            post_subpass_sample_locations_count: u32::default(),
            post_subpass_sample_locations: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassTransformBeginInfoQCOM.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct RenderPassTransformBeginInfoQCOM {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub transform: SurfaceTransformFlagsKHR,
}

impl Default for RenderPassTransformBeginInfoQCOM {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM,
            next: ptr::null_mut(),
            transform: SurfaceTransformFlagsKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkResolveImageInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ResolveImageInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_image: Image,
    pub src_image_layout: ImageLayout,
    pub dst_image: Image,
    pub dst_image_layout: ImageLayout,
    pub region_count: u32,
    pub regions: *const ImageResolve2KHR,
}

impl Default for ResolveImageInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::RESOLVE_IMAGE_INFO_2_KHR,
            next: ptr::null(),
            src_image: Image::default(),
            src_image_layout: ImageLayout::default(),
            dst_image: Image::default(),
            dst_image_layout: ImageLayout::default(),
            region_count: u32::default(),
            regions: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSRTDataNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct SRTDataNV {
    pub sx: f32,
    pub a: f32,
    pub b: f32,
    pub pvx: f32,
    pub sy: f32,
    pub c: f32,
    pub pvy: f32,
    pub sz: f32,
    pub pvz: f32,
    pub qx: f32,
    pub qy: f32,
    pub qz: f32,
    pub qw: f32,
    pub tx: f32,
    pub ty: f32,
    pub tz: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSampleLocationEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct SampleLocationEXT {
    pub x: f32,
    pub y: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSampleLocationsInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SampleLocationsInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub sample_locations_per_pixel: SampleCountFlags,
    pub sample_location_grid_size: Extent2D,
    pub sample_locations_count: u32,
    pub sample_locations: *const SampleLocationEXT,
}

impl Default for SampleLocationsInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLE_LOCATIONS_INFO_EXT,
            next: ptr::null(),
            sample_locations_per_pixel: SampleCountFlags::default(),
            sample_location_grid_size: Extent2D::default(),
            sample_locations_count: u32::default(),
            sample_locations: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerBorderColorComponentMappingCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SamplerBorderColorComponentMappingCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub components: ComponentMapping,
    pub srgb: Bool32,
}

impl Default for SamplerBorderColorComponentMappingCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT,
            next: ptr::null(),
            components: ComponentMapping::default(),
            srgb: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SamplerCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SamplerCreateFlags,
    pub mag_filter: Filter,
    pub min_filter: Filter,
    pub mipmap_mode: SamplerMipmapMode,
    pub address_mode_u: SamplerAddressMode,
    pub address_mode_v: SamplerAddressMode,
    pub address_mode_w: SamplerAddressMode,
    pub mip_lod_bias: f32,
    pub anisotropy_enable: Bool32,
    pub max_anisotropy: f32,
    pub compare_enable: Bool32,
    pub compare_op: CompareOp,
    pub min_lod: f32,
    pub max_lod: f32,
    pub border_color: BorderColor,
    pub unnormalized_coordinates: Bool32,
}

impl Default for SamplerCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_CREATE_INFO,
            next: ptr::null(),
            flags: SamplerCreateFlags::default(),
            mag_filter: Filter::default(),
            min_filter: Filter::default(),
            mipmap_mode: SamplerMipmapMode::default(),
            address_mode_u: SamplerAddressMode::default(),
            address_mode_v: SamplerAddressMode::default(),
            address_mode_w: SamplerAddressMode::default(),
            mip_lod_bias: f32::default(),
            anisotropy_enable: Bool32::default(),
            max_anisotropy: f32::default(),
            compare_enable: Bool32::default(),
            compare_op: CompareOp::default(),
            min_lod: f32::default(),
            max_lod: f32::default(),
            border_color: BorderColor::default(),
            unnormalized_coordinates: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerCustomBorderColorCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct SamplerCustomBorderColorCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub custom_border_color: ClearColorValue,
    pub format: Format,
}

impl Default for SamplerCustomBorderColorCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT,
            next: ptr::null(),
            custom_border_color: ClearColorValue::default(),
            format: Format::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerReductionModeCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SamplerReductionModeCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub reduction_mode: SamplerReductionMode,
}

impl Default for SamplerReductionModeCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_REDUCTION_MODE_CREATE_INFO,
            next: ptr::null(),
            reduction_mode: SamplerReductionMode::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SamplerYcbcrConversionCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub format: Format,
    pub ycbcr_model: SamplerYcbcrModelConversion,
    pub ycbcr_range: SamplerYcbcrRange,
    pub components: ComponentMapping,
    pub x_chroma_offset: ChromaLocation,
    pub y_chroma_offset: ChromaLocation,
    pub chroma_filter: Filter,
    pub force_explicit_reconstruction: Bool32,
}

impl Default for SamplerYcbcrConversionCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_YCBCR_CONVERSION_CREATE_INFO,
            next: ptr::null(),
            format: Format::default(),
            ycbcr_model: SamplerYcbcrModelConversion::default(),
            ycbcr_range: SamplerYcbcrRange::default(),
            components: ComponentMapping::default(),
            x_chroma_offset: ChromaLocation::default(),
            y_chroma_offset: ChromaLocation::default(),
            chroma_filter: Filter::default(),
            force_explicit_reconstruction: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionImageFormatProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SamplerYcbcrConversionImageFormatProperties {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub combined_image_sampler_descriptor_count: u32,
}

impl Default for SamplerYcbcrConversionImageFormatProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES,
            next: ptr::null_mut(),
            combined_image_sampler_descriptor_count: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SamplerYcbcrConversionInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub conversion: SamplerYcbcrConversion,
}

impl Default for SamplerYcbcrConversionInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SAMPLER_YCBCR_CONVERSION_INFO,
            next: ptr::null(),
            conversion: SamplerYcbcrConversion::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkScreenSurfaceCreateInfoQNX.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ScreenSurfaceCreateInfoQNX {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ScreenSurfaceCreateFlagsQNX,
    pub context: *mut _screen_context,
    pub window: *mut _screen_window,
}

impl Default for ScreenSurfaceCreateInfoQNX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SCREEN_SURFACE_CREATE_INFO_QNX,
            next: ptr::null(),
            flags: ScreenSurfaceCreateFlagsQNX::default(),
            context: ptr::null_mut(),
            window: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SemaphoreCreateFlags,
}

impl Default for SemaphoreCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_CREATE_INFO,
            next: ptr::null(),
            flags: SemaphoreCreateFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreGetFdInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreGetFdInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}

impl Default for SemaphoreGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_GET_FD_INFO_KHR,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreGetWin32HandleInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}

impl Default for SemaphoreGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreGetZirconHandleInfoFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreGetZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}

impl Default for SemaphoreGetZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreSignalInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreSignalInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub value: u64,
}

impl Default for SemaphoreSignalInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_SIGNAL_INFO,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            value: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreSubmitInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreSubmitInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore: Semaphore,
    pub value: u64,
    pub stage_mask: PipelineStageFlags2KHR,
    pub device_index: u32,
}

impl Default for SemaphoreSubmitInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_SUBMIT_INFO_KHR,
            next: ptr::null(),
            semaphore: Semaphore::default(),
            value: u64::default(),
            stage_mask: PipelineStageFlags2KHR::default(),
            device_index: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreTypeCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreTypeCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub semaphore_type: SemaphoreType,
    pub initial_value: u64,
}

impl Default for SemaphoreTypeCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_TYPE_CREATE_INFO,
            next: ptr::null(),
            semaphore_type: SemaphoreType::default(),
            initial_value: u64::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreWaitInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SemaphoreWaitInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SemaphoreWaitFlags,
    pub semaphore_count: u32,
    pub semaphores: *const Semaphore,
    pub values: *const u64,
}

impl Default for SemaphoreWaitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SEMAPHORE_WAIT_INFO,
            next: ptr::null(),
            flags: SemaphoreWaitFlags::default(),
            semaphore_count: u32::default(),
            semaphores: ptr::null(),
            values: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSetStateFlagsIndirectCommandNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SetStateFlagsIndirectCommandNV {
    pub data: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderModuleCreateInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ShaderModuleCreateInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub code_size: usize,
    pub code: *const u32,
}

impl Default for ShaderModuleCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SHADER_MODULE_CREATE_INFO,
            next: ptr::null(),
            flags: ShaderModuleCreateFlags::default(),
            code_size: usize::default(),
            code: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderModuleValidationCacheCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ShaderModuleValidationCacheCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub validation_cache: ValidationCacheEXT,
}

impl Default for ShaderModuleValidationCacheCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT,
            next: ptr::null(),
            validation_cache: ValidationCacheEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderResourceUsageAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ShaderResourceUsageAMD {
    pub num_used_vgprs: u32,
    pub num_used_sgprs: u32,
    pub lds_size_per_local_work_group: u32,
    pub lds_usage_size_in_bytes: usize,
    pub scratch_mem_usage_in_bytes: usize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderStatisticsInfoAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ShaderStatisticsInfoAMD {
    pub shader_stage_mask: ShaderStageFlags,
    pub resource_usage: ShaderResourceUsageAMD,
    pub num_physical_vgprs: u32,
    pub num_physical_sgprs: u32,
    pub num_available_vgprs: u32,
    pub num_available_sgprs: u32,
    pub compute_work_group_size: [u32; 3],
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShadingRatePaletteNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ShadingRatePaletteNV {
    pub shading_rate_palette_entry_count: u32,
    pub shading_rate_palette_entries: *const ShadingRatePaletteEntryNV,
}

impl Default for ShadingRatePaletteNV {
    #[inline]
    fn default() -> Self {
        Self {
            shading_rate_palette_entry_count: u32::default(),
            shading_rate_palette_entries: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSharedPresentSurfaceCapabilitiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SharedPresentSurfaceCapabilitiesKHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub shared_present_supported_usage_flags: ImageUsageFlags,
}

impl Default for SharedPresentSurfaceCapabilitiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SHARED_PRESENT_SURFACE_CAPABILITIES_KHR,
            next: ptr::null_mut(),
            shared_present_supported_usage_flags: ImageUsageFlags::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseBufferMemoryBindInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SparseBufferMemoryBindInfo {
    pub buffer: Buffer,
    pub bind_count: u32,
    pub binds: *const SparseMemoryBind,
}

impl Default for SparseBufferMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            buffer: Buffer::default(),
            bind_count: u32::default(),
            binds: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatProperties.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageFormatProperties {
    pub aspect_mask: ImageAspectFlags,
    pub image_granularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatProperties2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageFormatProperties2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub properties: SparseImageFormatProperties,
}

impl Default for SparseImageFormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SPARSE_IMAGE_FORMAT_PROPERTIES_2,
            next: ptr::null_mut(),
            properties: SparseImageFormatProperties::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryBind.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryBindInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub binds: *const SparseImageMemoryBind,
}

impl Default for SparseImageMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            binds: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryRequirements.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageMemoryRequirements {
    pub format_properties: SparseImageFormatProperties,
    pub image_mip_tail_first_lod: u32,
    pub image_mip_tail_size: DeviceSize,
    pub image_mip_tail_offset: DeviceSize,
    pub image_mip_tail_stride: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryRequirements2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageMemoryRequirements2 {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub memory_requirements: SparseImageMemoryRequirements,
}

impl Default for SparseImageMemoryRequirements2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SPARSE_IMAGE_MEMORY_REQUIREMENTS_2,
            next: ptr::null_mut(),
            memory_requirements: SparseImageMemoryRequirements::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageOpaqueMemoryBindInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SparseImageOpaqueMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub binds: *const SparseMemoryBind,
}

impl Default for SparseImageOpaqueMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            binds: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseMemoryBind.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SparseMemoryBind {
    pub resource_offset: DeviceSize,
    pub size: DeviceSize,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSpecializationInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SpecializationInfo {
    pub map_entry_count: u32,
    pub map_entries: *const SpecializationMapEntry,
    pub data_size: usize,
    pub data: *const c_void,
}

impl Default for SpecializationInfo {
    #[inline]
    fn default() -> Self {
        Self {
            map_entry_count: u32::default(),
            map_entries: ptr::null(),
            data_size: usize::default(),
            data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSpecializationMapEntry.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SpecializationMapEntry {
    pub constant_id: u32,
    pub offset: u32,
    pub size: usize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStencilOpState.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct StencilOpState {
    pub fail_op: StencilOp,
    pub pass_op: StencilOp,
    pub depth_fail_op: StencilOp,
    pub compare_op: CompareOp,
    pub compare_mask: u32,
    pub write_mask: u32,
    pub reference: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStreamDescriptorSurfaceCreateInfoGGP.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct StreamDescriptorSurfaceCreateInfoGGP {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: StreamDescriptorSurfaceCreateFlagsGGP,
    pub stream_descriptor: GgpStreamDescriptor,
}

impl Default for StreamDescriptorSurfaceCreateInfoGGP {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP,
            next: ptr::null(),
            flags: StreamDescriptorSurfaceCreateFlagsGGP::default(),
            stream_descriptor: GgpStreamDescriptor::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStridedDeviceAddressRegionKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct StridedDeviceAddressRegionKHR {
    pub device_address: DeviceAddress,
    pub stride: DeviceSize,
    pub size: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubmitInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubmitInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_count: u32,
    pub wait_semaphores: *const Semaphore,
    pub wait_dst_stage_mask: *const PipelineStageFlags,
    pub command_buffer_count: u32,
    pub command_buffers: *const CommandBuffer,
    pub signal_semaphore_count: u32,
    pub signal_semaphores: *const Semaphore,
}

impl Default for SubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBMIT_INFO,
            next: ptr::null(),
            wait_semaphore_count: u32::default(),
            wait_semaphores: ptr::null(),
            wait_dst_stage_mask: ptr::null(),
            command_buffer_count: u32::default(),
            command_buffers: ptr::null(),
            signal_semaphore_count: u32::default(),
            signal_semaphores: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubmitInfo2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubmitInfo2KHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SubmitFlagsKHR,
    pub wait_semaphore_info_count: u32,
    pub wait_semaphore_infos: *const SemaphoreSubmitInfoKHR,
    pub command_buffer_info_count: u32,
    pub command_buffer_infos: *const CommandBufferSubmitInfoKHR,
    pub signal_semaphore_info_count: u32,
    pub signal_semaphore_infos: *const SemaphoreSubmitInfoKHR,
}

impl Default for SubmitInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBMIT_INFO_2_KHR,
            next: ptr::null(),
            flags: SubmitFlagsKHR::default(),
            wait_semaphore_info_count: u32::default(),
            wait_semaphore_infos: ptr::null(),
            command_buffer_info_count: u32::default(),
            command_buffer_infos: ptr::null(),
            signal_semaphore_info_count: u32::default(),
            signal_semaphore_infos: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassBeginInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassBeginInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub contents: SubpassContents,
}

impl Default for SubpassBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_BEGIN_INFO,
            next: ptr::null(),
            contents: SubpassContents::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDependency.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SubpassDependency {
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDependency2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassDependency2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
    pub view_offset: i32,
}

impl Default for SubpassDependency2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_DEPENDENCY_2,
            next: ptr::null(),
            src_subpass: u32::default(),
            dst_subpass: u32::default(),
            src_stage_mask: PipelineStageFlags::default(),
            dst_stage_mask: PipelineStageFlags::default(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            dependency_flags: DependencyFlags::default(),
            view_offset: i32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescription.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassDescription {
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub input_attachment_count: u32,
    pub input_attachments: *const AttachmentReference,
    pub color_attachment_count: u32,
    pub color_attachments: *const AttachmentReference,
    pub resolve_attachments: *const AttachmentReference,
    pub depth_stencil_attachment: *const AttachmentReference,
    pub preserve_attachment_count: u32,
    pub preserve_attachments: *const u32,
}

impl Default for SubpassDescription {
    #[inline]
    fn default() -> Self {
        Self {
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            input_attachment_count: u32::default(),
            input_attachments: ptr::null(),
            color_attachment_count: u32::default(),
            color_attachments: ptr::null(),
            resolve_attachments: ptr::null(),
            depth_stencil_attachment: ptr::null(),
            preserve_attachment_count: u32::default(),
            preserve_attachments: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescription2.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassDescription2 {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub view_mask: u32,
    pub input_attachment_count: u32,
    pub input_attachments: *const AttachmentReference2,
    pub color_attachment_count: u32,
    pub color_attachments: *const AttachmentReference2,
    pub resolve_attachments: *const AttachmentReference2,
    pub depth_stencil_attachment: *const AttachmentReference2,
    pub preserve_attachment_count: u32,
    pub preserve_attachments: *const u32,
}

impl Default for SubpassDescription2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_DESCRIPTION_2,
            next: ptr::null(),
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            view_mask: u32::default(),
            input_attachment_count: u32::default(),
            input_attachments: ptr::null(),
            color_attachment_count: u32::default(),
            color_attachments: ptr::null(),
            resolve_attachments: ptr::null(),
            depth_stencil_attachment: ptr::null(),
            preserve_attachment_count: u32::default(),
            preserve_attachments: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescriptionDepthStencilResolve.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassDescriptionDepthStencilResolve {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub depth_resolve_mode: ResolveModeFlags,
    pub stencil_resolve_mode: ResolveModeFlags,
    pub depth_stencil_resolve_attachment: *const AttachmentReference2,
}

impl Default for SubpassDescriptionDepthStencilResolve {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE,
            next: ptr::null(),
            depth_resolve_mode: ResolveModeFlags::default(),
            stencil_resolve_mode: ResolveModeFlags::default(),
            depth_stencil_resolve_attachment: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassEndInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassEndInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
}

impl Default for SubpassEndInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_END_INFO,
            next: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassSampleLocationsEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SubpassSampleLocationsEXT {
    pub subpass_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassShadingPipelineCreateInfoHUAWEI.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SubpassShadingPipelineCreateInfoHUAWEI {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub render_pass: RenderPass,
    pub subpass: u32,
}

impl Default for SubpassShadingPipelineCreateInfoHUAWEI {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI,
            next: ptr::null_mut(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubresourceLayout.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SubresourceLayout {
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub row_pitch: DeviceSize,
    pub array_pitch: DeviceSize,
    pub depth_pitch: DeviceSize,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCapabilities2EXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceCapabilities2EXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
    pub supported_surface_counters: SurfaceCounterFlagsEXT,
}

impl Default for SurfaceCapabilities2EXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_CAPABILITIES_2_EXT,
            next: ptr::null_mut(),
            min_image_count: u32::default(),
            max_image_count: u32::default(),
            current_extent: Extent2D::default(),
            min_image_extent: Extent2D::default(),
            max_image_extent: Extent2D::default(),
            max_image_array_layers: u32::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            current_transform: SurfaceTransformFlagsKHR::default(),
            supported_composite_alpha: CompositeAlphaFlagsKHR::default(),
            supported_usage_flags: ImageUsageFlags::default(),
            supported_surface_counters: SurfaceCounterFlagsEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCapabilities2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceCapabilities2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub surface_capabilities: SurfaceCapabilitiesKHR,
}

impl Default for SurfaceCapabilities2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_CAPABILITIES_2_KHR,
            next: ptr::null_mut(),
            surface_capabilities: SurfaceCapabilitiesKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCapabilitiesFullScreenExclusiveEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceCapabilitiesFullScreenExclusiveEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub full_screen_exclusive_supported: Bool32,
}

impl Default for SurfaceCapabilitiesFullScreenExclusiveEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT,
            next: ptr::null_mut(),
            full_screen_exclusive_supported: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCapabilitiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceCapabilitiesKHR {
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceFormat2KHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceFormat2KHR {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub surface_format: SurfaceFormatKHR,
}

impl Default for SurfaceFormat2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_FORMAT_2_KHR,
            next: ptr::null_mut(),
            surface_format: SurfaceFormatKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceFormatKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceFormatKHR {
    pub format: Format,
    pub color_space: ColorSpaceKHR,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceFullScreenExclusiveInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceFullScreenExclusiveInfoEXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub full_screen_exclusive: FullScreenExclusiveEXT,
}

impl Default for SurfaceFullScreenExclusiveInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT,
            next: ptr::null_mut(),
            full_screen_exclusive: FullScreenExclusiveEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceFullScreenExclusiveWin32InfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceFullScreenExclusiveWin32InfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub hmonitor: HMONITOR,
}

impl Default for SurfaceFullScreenExclusiveWin32InfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT,
            next: ptr::null(),
            hmonitor: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceProtectedCapabilitiesKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SurfaceProtectedCapabilitiesKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub supports_protected: Bool32,
}

impl Default for SurfaceProtectedCapabilitiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SURFACE_PROTECTED_CAPABILITIES_KHR,
            next: ptr::null(),
            supports_protected: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainCounterCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SwapchainCounterCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub surface_counters: SurfaceCounterFlagsEXT,
}

impl Default for SwapchainCounterCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SWAPCHAIN_COUNTER_CREATE_INFO_EXT,
            next: ptr::null(),
            surface_counters: SurfaceCounterFlagsEXT::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR,
    pub min_image_count: u32,
    pub image_format: Format,
    pub image_color_space: ColorSpaceKHR,
    pub image_extent: Extent2D,
    pub image_array_layers: u32,
    pub image_usage: ImageUsageFlags,
    pub image_sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub queue_family_indices: *const u32,
    pub pre_transform: SurfaceTransformFlagsKHR,
    pub composite_alpha: CompositeAlphaFlagsKHR,
    pub present_mode: PresentModeKHR,
    pub clipped: Bool32,
    pub old_swapchain: SwapchainKHR,
}

impl Default for SwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SWAPCHAIN_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: SwapchainCreateFlagsKHR::default(),
            surface: SurfaceKHR::default(),
            min_image_count: u32::default(),
            image_format: Format::default(),
            image_color_space: ColorSpaceKHR::default(),
            image_extent: Extent2D::default(),
            image_array_layers: u32::default(),
            image_usage: ImageUsageFlags::default(),
            image_sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            queue_family_indices: ptr::null(),
            pre_transform: SurfaceTransformFlagsKHR::default(),
            composite_alpha: CompositeAlphaFlagsKHR::default(),
            present_mode: PresentModeKHR::default(),
            clipped: Bool32::default(),
            old_swapchain: SwapchainKHR::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainDisplayNativeHdrCreateInfoAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SwapchainDisplayNativeHdrCreateInfoAMD {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub local_dimming_enable: Bool32,
}

impl Default for SwapchainDisplayNativeHdrCreateInfoAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD,
            next: ptr::null(),
            local_dimming_enable: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSysmemColorSpaceFUCHSIA.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct SysmemColorSpaceFUCHSIA {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub color_space: u32,
}

impl Default for SysmemColorSpaceFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::SYSMEM_COLOR_SPACE_FUCHSIA,
            next: ptr::null(),
            color_space: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTextureLODGatherFormatPropertiesAMD.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct TextureLODGatherFormatPropertiesAMD {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub supports_texture_gather_lod_bias_amd: Bool32,
}

impl Default for TextureLODGatherFormatPropertiesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD,
            next: ptr::null_mut(),
            supports_texture_gather_lod_bias_amd: Bool32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTimelineSemaphoreSubmitInfo.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct TimelineSemaphoreSubmitInfo {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub wait_semaphore_value_count: u32,
    pub wait_semaphore_values: *const u64,
    pub signal_semaphore_value_count: u32,
    pub signal_semaphore_values: *const u64,
}

impl Default for TimelineSemaphoreSubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::TIMELINE_SEMAPHORE_SUBMIT_INFO,
            next: ptr::null(),
            wait_semaphore_value_count: u32::default(),
            wait_semaphore_values: ptr::null(),
            signal_semaphore_value_count: u32::default(),
            signal_semaphore_values: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTraceRaysIndirectCommandKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct TraceRaysIndirectCommandKHR {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTransformMatrixKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct TransformMatrixKHR {
    pub matrix: [[f32; 3]; 4],
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCacheCreateInfoEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ValidationCacheCreateInfoEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ValidationCacheCreateFlagsEXT,
    pub initial_data_size: usize,
    pub initial_data: *const c_void,
}

impl Default for ValidationCacheCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VALIDATION_CACHE_CREATE_INFO_EXT,
            next: ptr::null(),
            flags: ValidationCacheCreateFlagsEXT::default(),
            initial_data_size: usize::default(),
            initial_data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFeaturesEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ValidationFeaturesEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub enabled_validation_feature_count: u32,
    pub enabled_validation_features: *const ValidationFeatureEnableEXT,
    pub disabled_validation_feature_count: u32,
    pub disabled_validation_features: *const ValidationFeatureDisableEXT,
}

impl Default for ValidationFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VALIDATION_FEATURES_EXT,
            next: ptr::null(),
            enabled_validation_feature_count: u32::default(),
            enabled_validation_features: ptr::null(),
            disabled_validation_feature_count: u32::default(),
            disabled_validation_features: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFlagsEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ValidationFlagsEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub disabled_validation_check_count: u32,
    pub disabled_validation_checks: *const ValidationCheckEXT,
}

impl Default for ValidationFlagsEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VALIDATION_FLAGS_EXT,
            next: ptr::null(),
            disabled_validation_check_count: u32::default(),
            disabled_validation_checks: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputAttributeDescription.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct VertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputAttributeDescription2EXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct VertexInputAttributeDescription2EXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}

impl Default for VertexInputAttributeDescription2EXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT,
            next: ptr::null_mut(),
            location: u32::default(),
            binding: u32::default(),
            format: Format::default(),
            offset: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputBindingDescription.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct VertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub input_rate: VertexInputRate,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputBindingDescription2EXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct VertexInputBindingDescription2EXT {
    pub s_type: StructureType,
    pub next: *mut c_void,
    pub binding: u32,
    pub stride: u32,
    pub input_rate: VertexInputRate,
    pub divisor: u32,
}

impl Default for VertexInputBindingDescription2EXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT,
            next: ptr::null_mut(),
            binding: u32::default(),
            stride: u32::default(),
            input_rate: VertexInputRate::default(),
            divisor: u32::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputBindingDivisorDescriptionEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct VertexInputBindingDivisorDescriptionEXT {
    pub binding: u32,
    pub divisor: u32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViSurfaceCreateInfoNN.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct ViSurfaceCreateInfoNN {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: ViSurfaceCreateFlagsNN,
    pub window: *mut c_void,
}

impl Default for ViSurfaceCreateInfoNN {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::VI_SURFACE_CREATE_INFO_NN,
            next: ptr::null(),
            flags: ViSurfaceCreateFlagsNN::default(),
            window: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViewport.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub min_depth: f32,
    pub max_depth: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViewportSwizzleNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, Eq, Hash, PartialEq)]
pub struct ViewportSwizzleNV {
    pub x: ViewportCoordinateSwizzleNV,
    pub y: ViewportCoordinateSwizzleNV,
    pub z: ViewportCoordinateSwizzleNV,
    pub w: ViewportCoordinateSwizzleNV,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViewportWScalingNV.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct ViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWaylandSurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct WaylandSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: WaylandSurfaceCreateFlagsKHR,
    pub display: *mut wl_display,
    pub surface: *mut wl_surface,
}

impl Default for WaylandSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WAYLAND_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: WaylandSurfaceCreateFlagsKHR::default(),
            display: ptr::null_mut(),
            surface: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct Win32KeyedMutexAcquireReleaseInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acquire_count: u32,
    pub acquire_syncs: *const DeviceMemory,
    pub acquire_keys: *const u64,
    pub acquire_timeouts: *const u32,
    pub release_count: u32,
    pub release_syncs: *const DeviceMemory,
    pub release_keys: *const u64,
}

impl Default for Win32KeyedMutexAcquireReleaseInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR,
            next: ptr::null(),
            acquire_count: u32::default(),
            acquire_syncs: ptr::null(),
            acquire_keys: ptr::null(),
            acquire_timeouts: ptr::null(),
            release_count: u32::default(),
            release_syncs: ptr::null(),
            release_keys: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct Win32KeyedMutexAcquireReleaseInfoNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acquire_count: u32,
    pub acquire_syncs: *const DeviceMemory,
    pub acquire_keys: *const u64,
    pub acquire_timeout_milliseconds: *const u32,
    pub release_count: u32,
    pub release_syncs: *const DeviceMemory,
    pub release_keys: *const u64,
}

impl Default for Win32KeyedMutexAcquireReleaseInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV,
            next: ptr::null(),
            acquire_count: u32::default(),
            acquire_syncs: ptr::null(),
            acquire_keys: ptr::null(),
            acquire_timeout_milliseconds: ptr::null(),
            release_count: u32::default(),
            release_syncs: ptr::null(),
            release_keys: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32SurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct Win32SurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: Win32SurfaceCreateFlagsKHR,
    pub hinstance: HINSTANCE,
    pub hwnd: HWND,
}

impl Default for Win32SurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WIN32_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: Win32SurfaceCreateFlagsKHR::default(),
            hinstance: ptr::null_mut(),
            hwnd: ptr::null_mut(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWriteDescriptorSet.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct WriteDescriptorSet {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub image_info: *const DescriptorImageInfo,
    pub buffer_info: *const DescriptorBufferInfo,
    pub texel_buffer_view: *const BufferView,
}

impl Default for WriteDescriptorSet {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WRITE_DESCRIPTOR_SET,
            next: ptr::null(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
            descriptor_type: DescriptorType::default(),
            image_info: ptr::null(),
            buffer_info: ptr::null(),
            texel_buffer_view: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWriteDescriptorSetAccelerationStructureKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct WriteDescriptorSetAccelerationStructureKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acceleration_structure_count: u32,
    pub acceleration_structures: *const AccelerationStructureKHR,
}

impl Default for WriteDescriptorSetAccelerationStructureKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR,
            next: ptr::null(),
            acceleration_structure_count: u32::default(),
            acceleration_structures: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWriteDescriptorSetAccelerationStructureNV.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct WriteDescriptorSetAccelerationStructureNV {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub acceleration_structure_count: u32,
    pub acceleration_structures: *const AccelerationStructureNV,
}

impl Default for WriteDescriptorSetAccelerationStructureNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV,
            next: ptr::null(),
            acceleration_structure_count: u32::default(),
            acceleration_structures: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWriteDescriptorSetInlineUniformBlockEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct WriteDescriptorSetInlineUniformBlockEXT {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub data_size: u32,
    pub data: *const c_void,
}

impl Default for WriteDescriptorSetInlineUniformBlockEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT,
            next: ptr::null(),
            data_size: u32::default(),
            data: ptr::null(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXYColorEXT.html>
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq)]
pub struct XYColorEXT {
    pub x: f32,
    pub y: f32,
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXcbSurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct XcbSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: XcbSurfaceCreateFlagsKHR,
    pub connection: *mut xcb_connection_t,
    pub window: xcb_window_t,
}

impl Default for XcbSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::XCB_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: XcbSurfaceCreateFlagsKHR::default(),
            connection: ptr::null_mut(),
            window: xcb_window_t::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXlibSurfaceCreateInfoKHR.html>
#[repr(C)]
#[derive(Copy, Clone, Debug, Eq, Hash, PartialEq)]
pub struct XlibSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub next: *const c_void,
    pub flags: XlibSurfaceCreateFlagsKHR,
    pub dpy: *mut Display,
    pub window: Window,
}

impl Default for XlibSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: StructureType::XLIB_SURFACE_CREATE_INFO_KHR,
            next: ptr::null(),
            flags: XlibSurfaceCreateFlagsKHR::default(),
            dpy: ptr::null_mut(),
            window: Window::default(),
        }
    }
}

/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAabbPositionsNV.html>
pub type AabbPositionsNV = AabbPositionsKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureInstanceNV.html>
pub type AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescription2KHR.html>
pub type AttachmentDescription2KHR = AttachmentDescription2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescriptionStencilLayoutKHR.html>
pub type AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReference2KHR.html>
pub type AttachmentReference2KHR = AttachmentReference2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReferenceStencilLayoutKHR.html>
pub type AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryDeviceGroupInfoKHR.html>
pub type BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryInfoKHR.html>
pub type BindBufferMemoryInfoKHR = BindBufferMemoryInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryDeviceGroupInfoKHR.html>
pub type BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryInfoKHR.html>
pub type BindImageMemoryInfoKHR = BindImageMemoryInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImagePlaneMemoryInfoKHR.html>
pub type BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferDeviceAddressInfoEXT.html>
pub type BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferDeviceAddressInfoKHR.html>
pub type BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferMemoryRequirementsInfo2KHR.html>
pub type BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferOpaqueCaptureAddressCreateInfoKHR.html>
pub type BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConformanceVersionKHR.html>
pub type ConformanceVersionKHR = ConformanceVersion;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.html>
pub type DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutSupportKHR.html>
pub type DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetVariableDescriptorCountAllocateInfoEXT.html>
pub type DescriptorSetVariableDescriptorCountAllocateInfoEXT =
    DescriptorSetVariableDescriptorCountAllocateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetVariableDescriptorCountLayoutSupportEXT.html>
pub type DescriptorSetVariableDescriptorCountLayoutSupportEXT =
    DescriptorSetVariableDescriptorCountLayoutSupport;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateCreateInfoKHR.html>
pub type DescriptorUpdateTemplateCreateInfoKHR = DescriptorUpdateTemplateCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateEntryKHR.html>
pub type DescriptorUpdateTemplateEntryKHR = DescriptorUpdateTemplateEntry;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupBindSparseInfoKHR.html>
pub type DeviceGroupBindSparseInfoKHR = DeviceGroupBindSparseInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupCommandBufferBeginInfoKHR.html>
pub type DeviceGroupCommandBufferBeginInfoKHR = DeviceGroupCommandBufferBeginInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupDeviceCreateInfoKHR.html>
pub type DeviceGroupDeviceCreateInfoKHR = DeviceGroupDeviceCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupRenderPassBeginInfoKHR.html>
pub type DeviceGroupRenderPassBeginInfoKHR = DeviceGroupRenderPassBeginInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupSubmitInfoKHR.html>
pub type DeviceGroupSubmitInfoKHR = DeviceGroupSubmitInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemoryOpaqueCaptureAddressInfoKHR.html>
pub type DeviceMemoryOpaqueCaptureAddressInfoKHR = DeviceMemoryOpaqueCaptureAddressInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportFenceCreateInfoKHR.html>
pub type ExportFenceCreateInfoKHR = ExportFenceCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryAllocateInfoKHR.html>
pub type ExportMemoryAllocateInfoKHR = ExportMemoryAllocateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportSemaphoreCreateInfoKHR.html>
pub type ExportSemaphoreCreateInfoKHR = ExportSemaphoreCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalBufferPropertiesKHR.html>
pub type ExternalBufferPropertiesKHR = ExternalBufferProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFencePropertiesKHR.html>
pub type ExternalFencePropertiesKHR = ExternalFenceProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalImageFormatPropertiesKHR.html>
pub type ExternalImageFormatPropertiesKHR = ExternalImageFormatProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryBufferCreateInfoKHR.html>
pub type ExternalMemoryBufferCreateInfoKHR = ExternalMemoryBufferCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryImageCreateInfoKHR.html>
pub type ExternalMemoryImageCreateInfoKHR = ExternalMemoryImageCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryPropertiesKHR.html>
pub type ExternalMemoryPropertiesKHR = ExternalMemoryProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphorePropertiesKHR.html>
pub type ExternalSemaphorePropertiesKHR = ExternalSemaphoreProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties2KHR.html>
pub type FormatProperties2KHR = FormatProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferAttachmentImageInfoKHR.html>
pub type FramebufferAttachmentImageInfoKHR = FramebufferAttachmentImageInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferAttachmentsCreateInfoKHR.html>
pub type FramebufferAttachmentsCreateInfoKHR = FramebufferAttachmentsCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatListCreateInfoKHR.html>
pub type ImageFormatListCreateInfoKHR = ImageFormatListCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatProperties2KHR.html>
pub type ImageFormatProperties2KHR = ImageFormatProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageMemoryRequirementsInfo2KHR.html>
pub type ImageMemoryRequirementsInfo2KHR = ImageMemoryRequirementsInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePlaneMemoryRequirementsInfoKHR.html>
pub type ImagePlaneMemoryRequirementsInfoKHR = ImagePlaneMemoryRequirementsInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSparseMemoryRequirementsInfo2KHR.html>
pub type ImageSparseMemoryRequirementsInfo2KHR = ImageSparseMemoryRequirementsInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageStencilUsageCreateInfoEXT.html>
pub type ImageStencilUsageCreateInfoEXT = ImageStencilUsageCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewUsageCreateInfoKHR.html>
pub type ImageViewUsageCreateInfoKHR = ImageViewUsageCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInputAttachmentAspectReferenceKHR.html>
pub type InputAttachmentAspectReferenceKHR = InputAttachmentAspectReference;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsInfoKHR.html>
pub type MemoryAllocateFlagsInfoKHR = MemoryAllocateFlagsInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryDedicatedAllocateInfoKHR.html>
pub type MemoryDedicatedAllocateInfoKHR = MemoryDedicatedAllocateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryDedicatedRequirementsKHR.html>
pub type MemoryDedicatedRequirementsKHR = MemoryDedicatedRequirements;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryOpaqueCaptureAddressAllocateInfoKHR.html>
pub type MemoryOpaqueCaptureAddressAllocateInfoKHR = MemoryOpaqueCaptureAddressAllocateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryRequirements2KHR.html>
pub type MemoryRequirements2KHR = MemoryRequirements2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice16BitStorageFeaturesKHR.html>
pub type PhysicalDevice16BitStorageFeaturesKHR = PhysicalDevice16BitStorageFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice8BitStorageFeaturesKHR.html>
pub type PhysicalDevice8BitStorageFeaturesKHR = PhysicalDevice8BitStorageFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBufferAddressFeaturesEXT.html>
pub type PhysicalDeviceBufferAddressFeaturesEXT = PhysicalDeviceBufferDeviceAddressFeaturesEXT;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceBufferDeviceAddressFeaturesKHR.html>
pub type PhysicalDeviceBufferDeviceAddressFeaturesKHR = PhysicalDeviceBufferDeviceAddressFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDepthStencilResolvePropertiesKHR.html>
pub type PhysicalDeviceDepthStencilResolvePropertiesKHR =
    PhysicalDeviceDepthStencilResolveProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeaturesEXT.html>
pub type PhysicalDeviceDescriptorIndexingFeaturesEXT = PhysicalDeviceDescriptorIndexingFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDescriptorIndexingPropertiesEXT.html>
pub type PhysicalDeviceDescriptorIndexingPropertiesEXT = PhysicalDeviceDescriptorIndexingProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDriverPropertiesKHR.html>
pub type PhysicalDeviceDriverPropertiesKHR = PhysicalDeviceDriverProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalBufferInfoKHR.html>
pub type PhysicalDeviceExternalBufferInfoKHR = PhysicalDeviceExternalBufferInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalFenceInfoKHR.html>
pub type PhysicalDeviceExternalFenceInfoKHR = PhysicalDeviceExternalFenceInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalImageFormatInfoKHR.html>
pub type PhysicalDeviceExternalImageFormatInfoKHR = PhysicalDeviceExternalImageFormatInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalSemaphoreInfoKHR.html>
pub type PhysicalDeviceExternalSemaphoreInfoKHR = PhysicalDeviceExternalSemaphoreInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFeatures2KHR.html>
pub type PhysicalDeviceFeatures2KHR = PhysicalDeviceFeatures2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFloat16Int8FeaturesKHR.html>
pub type PhysicalDeviceFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFloatControlsPropertiesKHR.html>
pub type PhysicalDeviceFloatControlsPropertiesKHR = PhysicalDeviceFloatControlsProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceGroupPropertiesKHR.html>
pub type PhysicalDeviceGroupPropertiesKHR = PhysicalDeviceGroupProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceHostQueryResetFeaturesEXT.html>
pub type PhysicalDeviceHostQueryResetFeaturesEXT = PhysicalDeviceHostQueryResetFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceIDPropertiesKHR.html>
pub type PhysicalDeviceIDPropertiesKHR = PhysicalDeviceIDProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageFormatInfo2KHR.html>
pub type PhysicalDeviceImageFormatInfo2KHR = PhysicalDeviceImageFormatInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImagelessFramebufferFeaturesKHR.html>
pub type PhysicalDeviceImagelessFramebufferFeaturesKHR = PhysicalDeviceImagelessFramebufferFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMaintenance3PropertiesKHR.html>
pub type PhysicalDeviceMaintenance3PropertiesKHR = PhysicalDeviceMaintenance3Properties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryProperties2KHR.html>
pub type PhysicalDeviceMemoryProperties2KHR = PhysicalDeviceMemoryProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiviewFeaturesKHR.html>
pub type PhysicalDeviceMultiviewFeaturesKHR = PhysicalDeviceMultiviewFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMultiviewPropertiesKHR.html>
pub type PhysicalDeviceMultiviewPropertiesKHR = PhysicalDeviceMultiviewProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePointClippingPropertiesKHR.html>
pub type PhysicalDevicePointClippingPropertiesKHR = PhysicalDevicePointClippingProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProperties2KHR.html>
pub type PhysicalDeviceProperties2KHR = PhysicalDeviceProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT.html>
pub type PhysicalDeviceSamplerFilterMinmaxPropertiesEXT =
    PhysicalDeviceSamplerFilterMinmaxProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR.html>
pub type PhysicalDeviceSamplerYcbcrConversionFeaturesKHR =
    PhysicalDeviceSamplerYcbcrConversionFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceScalarBlockLayoutFeaturesEXT.html>
pub type PhysicalDeviceScalarBlockLayoutFeaturesEXT = PhysicalDeviceScalarBlockLayoutFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR.html>
pub type PhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR =
    PhysicalDeviceSeparateDepthStencilLayoutsFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64FeaturesKHR.html>
pub type PhysicalDeviceShaderAtomicInt64FeaturesKHR = PhysicalDeviceShaderAtomicInt64Features;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderDrawParameterFeatures.html>
pub type PhysicalDeviceShaderDrawParameterFeatures = PhysicalDeviceShaderDrawParametersFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8FeaturesKHR.html>
pub type PhysicalDeviceShaderFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR.html>
pub type PhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR =
    PhysicalDeviceShaderSubgroupExtendedTypesFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSparseImageFormatInfo2KHR.html>
pub type PhysicalDeviceSparseImageFormatInfo2KHR = PhysicalDeviceSparseImageFormatInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreFeaturesKHR.html>
pub type PhysicalDeviceTimelineSemaphoreFeaturesKHR = PhysicalDeviceTimelineSemaphoreFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceTimelineSemaphorePropertiesKHR.html>
pub type PhysicalDeviceTimelineSemaphorePropertiesKHR = PhysicalDeviceTimelineSemaphoreProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR.html>
pub type PhysicalDeviceUniformBufferStandardLayoutFeaturesKHR =
    PhysicalDeviceUniformBufferStandardLayoutFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVariablePointerFeatures.html>
pub type PhysicalDeviceVariablePointerFeatures = PhysicalDeviceVariablePointersFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVariablePointerFeaturesKHR.html>
pub type PhysicalDeviceVariablePointerFeaturesKHR = PhysicalDeviceVariablePointersFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVariablePointersFeaturesKHR.html>
pub type PhysicalDeviceVariablePointersFeaturesKHR = PhysicalDeviceVariablePointersFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeaturesKHR.html>
pub type PhysicalDeviceVulkanMemoryModelFeaturesKHR = PhysicalDeviceVulkanMemoryModelFeatures;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationDomainOriginStateCreateInfoKHR.html>
pub type PipelineTessellationDomainOriginStateCreateInfoKHR =
    PipelineTessellationDomainOriginStateCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolCreateInfoINTEL.html>
pub type QueryPoolCreateInfoINTEL = QueryPoolPerformanceQueryCreateInfoINTEL;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyProperties2KHR.html>
pub type QueueFamilyProperties2KHR = QueueFamilyProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassAttachmentBeginInfoKHR.html>
pub type RenderPassAttachmentBeginInfoKHR = RenderPassAttachmentBeginInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassCreateInfo2KHR.html>
pub type RenderPassCreateInfo2KHR = RenderPassCreateInfo2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassInputAttachmentAspectCreateInfoKHR.html>
pub type RenderPassInputAttachmentAspectCreateInfoKHR = RenderPassInputAttachmentAspectCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassMultiviewCreateInfoKHR.html>
pub type RenderPassMultiviewCreateInfoKHR = RenderPassMultiviewCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerReductionModeCreateInfoEXT.html>
pub type SamplerReductionModeCreateInfoEXT = SamplerReductionModeCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionCreateInfoKHR.html>
pub type SamplerYcbcrConversionCreateInfoKHR = SamplerYcbcrConversionCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionImageFormatPropertiesKHR.html>
pub type SamplerYcbcrConversionImageFormatPropertiesKHR =
    SamplerYcbcrConversionImageFormatProperties;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversionInfoKHR.html>
pub type SamplerYcbcrConversionInfoKHR = SamplerYcbcrConversionInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreSignalInfoKHR.html>
pub type SemaphoreSignalInfoKHR = SemaphoreSignalInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreTypeCreateInfoKHR.html>
pub type SemaphoreTypeCreateInfoKHR = SemaphoreTypeCreateInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreWaitInfoKHR.html>
pub type SemaphoreWaitInfoKHR = SemaphoreWaitInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatProperties2KHR.html>
pub type SparseImageFormatProperties2KHR = SparseImageFormatProperties2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryRequirements2KHR.html>
pub type SparseImageMemoryRequirements2KHR = SparseImageMemoryRequirements2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassBeginInfoKHR.html>
pub type SubpassBeginInfoKHR = SubpassBeginInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDependency2KHR.html>
pub type SubpassDependency2KHR = SubpassDependency2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescription2KHR.html>
pub type SubpassDescription2KHR = SubpassDescription2;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescriptionDepthStencilResolveKHR.html>
pub type SubpassDescriptionDepthStencilResolveKHR = SubpassDescriptionDepthStencilResolve;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassEndInfoKHR.html>
pub type SubpassEndInfoKHR = SubpassEndInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTimelineSemaphoreSubmitInfoKHR.html>
pub type TimelineSemaphoreSubmitInfoKHR = TimelineSemaphoreSubmitInfo;
/// <https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkTransformMatrixNV.html>
pub type TransformMatrixNV = TransformMatrixKHR;
