// auto generated by vulkan-bindgen
// vulkan spec: 1.3.211

#![allow(non_upper_case_globals)]
#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(dead_code)]

use std::mem;
use std::os::raw::{c_char, c_int, c_void};

pub const fn make_version(major: u32, minor: u32, patch: u32) -> u32 {
    (major << 22) | (minor << 12) | patch
}

pub const fn get_version(ver: u32) -> (u32, u32, u32) {
    (ver >> 22, (ver >> 12) & 0x3ff, ver & 0xfff)
}


// API Constants

pub const MAX_PHYSICAL_DEVICE_NAME_SIZE: u32 = 256;
pub const UUID_SIZE: u32 = 16;
pub const LUID_SIZE: u32 = 8;
pub const LUID_SIZE_KHR: u32 = LUID_SIZE;
pub const MAX_EXTENSION_NAME_SIZE: u32 = 256;
pub const MAX_DESCRIPTION_SIZE: u32 = 256;
pub const MAX_MEMORY_TYPES: u32 = 32;
pub const MAX_MEMORY_HEAPS: u32 = 16;
pub const LOD_CLAMP_NONE: f32 = 1000.0;
pub const REMAINING_MIP_LEVELS: u32 = !0u32;
pub const REMAINING_ARRAY_LAYERS: u32 = !0u32;
pub const WHOLE_SIZE: u64 = !0u64;
pub const ATTACHMENT_UNUSED: u32 = !0u32;
pub const TRUE: u32 = 1;
pub const FALSE: u32 = 0;
pub const QUEUE_FAMILY_IGNORED: u32 = !0u32;
pub const QUEUE_FAMILY_EXTERNAL: u32 = !1u32;
pub const QUEUE_FAMILY_EXTERNAL_KHR: u32 = QUEUE_FAMILY_EXTERNAL;
pub const QUEUE_FAMILY_FOREIGN_EXT: u32 = !2u32;
pub const SUBPASS_EXTERNAL: u32 = !0u32;
pub const MAX_DEVICE_GROUP_SIZE: u32 = 32;
pub const MAX_DEVICE_GROUP_SIZE_KHR: u32 = MAX_DEVICE_GROUP_SIZE;
pub const MAX_DRIVER_NAME_SIZE: u32 = 256;
pub const MAX_DRIVER_NAME_SIZE_KHR: u32 = MAX_DRIVER_NAME_SIZE;
pub const MAX_DRIVER_INFO_SIZE: u32 = 256;
pub const MAX_DRIVER_INFO_SIZE_KHR: u32 = MAX_DRIVER_INFO_SIZE;
pub const SHADER_UNUSED_KHR: u32 = !0u32;
pub const SHADER_UNUSED_NV: u32 = SHADER_UNUSED_KHR;
pub const MAX_GLOBAL_PRIORITY_SIZE_KHR: u32 = 16;
pub const MAX_GLOBAL_PRIORITY_SIZE_EXT: u32 = MAX_GLOBAL_PRIORITY_SIZE_KHR;

// defines

pub const NULL_HANDLE: u64 = 0;

// base types

pub type SampleMask = u32;
pub type Bool32 = u32;
pub type Flags = u32;
pub type Flags64 = u64;
pub type DeviceSize = u64;
pub type DeviceAddress = u64;
pub type RemoteAddressNV = *mut c_void;

// object handles

pub type Instance = u64;
pub type PhysicalDevice = u64;
pub type Device = u64;
pub type Queue = u64;
pub type CommandBuffer = u64;
pub type DeviceMemory = u64;
pub type CommandPool = u64;
pub type Buffer = u64;
pub type BufferView = u64;
pub type Image = u64;
pub type ImageView = u64;
pub type ShaderModule = u64;
pub type Pipeline = u64;
pub type PipelineLayout = u64;
pub type Sampler = u64;
pub type DescriptorSet = u64;
pub type DescriptorSetLayout = u64;
pub type DescriptorPool = u64;
pub type Fence = u64;
pub type Semaphore = u64;
pub type Event = u64;
pub type QueryPool = u64;
pub type Framebuffer = u64;
pub type RenderPass = u64;
pub type PipelineCache = u64;
pub type IndirectCommandsLayoutNV = u64;
pub type DescriptorUpdateTemplate = u64;
pub type DescriptorUpdateTemplateKHR = DescriptorUpdateTemplate;
pub type SamplerYcbcrConversion = u64;
pub type SamplerYcbcrConversionKHR = SamplerYcbcrConversion;
pub type ValidationCacheEXT = u64;
pub type AccelerationStructureKHR = u64;
pub type AccelerationStructureNV = u64;
pub type PerformanceConfigurationINTEL = u64;
pub type BufferCollectionFUCHSIA = u64;
pub type DeferredOperationKHR = u64;
pub type PrivateDataSlot = u64;
pub type PrivateDataSlotEXT = PrivateDataSlot;
pub type CuModuleNVX = u64;
pub type CuFunctionNVX = u64;
pub type DisplayKHR = u64;
pub type DisplayModeKHR = u64;
pub type SurfaceKHR = u64;
pub type SwapchainKHR = u64;
pub type DebugReportCallbackEXT = u64;
pub type DebugUtilsMessengerEXT = u64;
pub type VideoSessionKHR = u64;
pub type VideoSessionParametersKHR = u64;

// bitmasks

pub type FramebufferCreateFlags = Flags;
pub type FramebufferCreateFlagBits = u32;
pub const FRAMEBUFFER_CREATE_IMAGELESS_BIT: u32 = 1;
pub const FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR: u32 = FRAMEBUFFER_CREATE_IMAGELESS_BIT;

pub type QueryPoolCreateFlags = Flags;

pub type RenderPassCreateFlags = Flags;
pub type RenderPassCreateFlagBits = u32;
pub const RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM: u32 = 2;

pub type SamplerCreateFlags = Flags;
pub type SamplerCreateFlagBits = u32;
pub const SAMPLER_CREATE_SUBSAMPLED_BIT_EXT: u32 = 1;
pub const SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT: u32 = 2;

pub type PipelineLayoutCreateFlags = Flags;
pub type PipelineLayoutCreateFlagBits = u32;
pub const PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT: u32 = 2;

pub type PipelineCacheCreateFlags = Flags;
pub type PipelineCacheCreateFlagBits = u32;
pub const PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT: u32 = 1;
pub const PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT: u32 = PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT;

pub type PipelineDepthStencilStateCreateFlags = Flags;
pub type PipelineDepthStencilStateCreateFlagBits = u32;
pub const PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_ARM: u32 = 1;
pub const PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_ARM: u32 = 2;

pub type PipelineDynamicStateCreateFlags = Flags;

pub type PipelineColorBlendStateCreateFlags = Flags;
pub type PipelineColorBlendStateCreateFlagBits = u32;
pub const PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_ARM: u32 = 1;

pub type PipelineMultisampleStateCreateFlags = Flags;

pub type PipelineRasterizationStateCreateFlags = Flags;

pub type PipelineViewportStateCreateFlags = Flags;

pub type PipelineTessellationStateCreateFlags = Flags;

pub type PipelineInputAssemblyStateCreateFlags = Flags;

pub type PipelineVertexInputStateCreateFlags = Flags;

pub type PipelineShaderStageCreateFlags = Flags;
pub type PipelineShaderStageCreateFlagBits = u32;
pub const PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT: u32 = 1;
pub const PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT: u32 = 2;
pub const PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT: u32 = PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT;
pub const PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT: u32 = PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT;

pub type DescriptorSetLayoutCreateFlags = Flags;
pub type DescriptorSetLayoutCreateFlagBits = u32;
pub const DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT: u32 = 2;
pub const DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR: u32 = 1; // Descriptors are pushed via flink:vkCmdPushDescriptorSetKHR
pub const DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT: u32 = DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT;
pub const DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE: u32 = 4;

pub type BufferViewCreateFlags = Flags;

pub type InstanceCreateFlags = Flags;
pub type InstanceCreateFlagBits = u32;
pub const INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR: u32 = 1;

pub type DeviceCreateFlags = Flags;

pub type DeviceQueueCreateFlags = Flags;
pub type DeviceQueueCreateFlagBits = u32;
pub const DEVICE_QUEUE_CREATE_PROTECTED_BIT: u32 = 1; // Queue is a protected-capable device queue

pub type QueueFlags = Flags;
pub type QueueFlagBits = u32;
pub const QUEUE_GRAPHICS_BIT: u32 = 1; // Queue supports graphics operations
pub const QUEUE_COMPUTE_BIT: u32 = 2; // Queue supports compute operations
pub const QUEUE_TRANSFER_BIT: u32 = 4; // Queue supports transfer operations
pub const QUEUE_SPARSE_BINDING_BIT: u32 = 8; // Queue supports sparse resource memory management operations
pub const QUEUE_PROTECTED_BIT: u32 = 16; // Queues may support protected operations
pub const QUEUE_VIDEO_DECODE_BIT_KHR: u32 = 32;
pub const QUEUE_VIDEO_ENCODE_BIT_KHR: u32 = 64;

pub type MemoryPropertyFlags = Flags;
pub type MemoryPropertyFlagBits = u32;
pub const MEMORY_PROPERTY_DEVICE_LOCAL_BIT: u32 = 1; // If otherwise stated, then allocate memory on device
pub const MEMORY_PROPERTY_HOST_VISIBLE_BIT: u32 = 2; // Memory is mappable by host
pub const MEMORY_PROPERTY_HOST_COHERENT_BIT: u32 = 4; // Memory will have i/o coherency. If not set, application may need to use vkFlushMappedMemoryRanges and vkInvalidateMappedMemoryRanges to flush/invalidate host cache
pub const MEMORY_PROPERTY_HOST_CACHED_BIT: u32 = 8; // Memory will be cached by the host
pub const MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT: u32 = 16; // Memory may be allocated by the driver when it is required
pub const MEMORY_PROPERTY_PROTECTED_BIT: u32 = 32; // Memory is protected
pub const MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD: u32 = 64;
pub const MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD: u32 = 128;
pub const MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV: u32 = 256;

pub type MemoryHeapFlags = Flags;
pub type MemoryHeapFlagBits = u32;
pub const MEMORY_HEAP_DEVICE_LOCAL_BIT: u32 = 1; // If set, heap represents device memory
pub const MEMORY_HEAP_MULTI_INSTANCE_BIT: u32 = 2; // If set, heap allocations allocate multiple instances by default
pub const MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR: u32 = MEMORY_HEAP_MULTI_INSTANCE_BIT;

pub type AccessFlags = Flags;
pub type AccessFlagBits = u32;
pub const ACCESS_INDIRECT_COMMAND_READ_BIT: u32 = 1; // Controls coherency of indirect command reads
pub const ACCESS_INDEX_READ_BIT: u32 = 2; // Controls coherency of index reads
pub const ACCESS_VERTEX_ATTRIBUTE_READ_BIT: u32 = 4; // Controls coherency of vertex attribute reads
pub const ACCESS_UNIFORM_READ_BIT: u32 = 8; // Controls coherency of uniform buffer reads
pub const ACCESS_INPUT_ATTACHMENT_READ_BIT: u32 = 16; // Controls coherency of input attachment reads
pub const ACCESS_SHADER_READ_BIT: u32 = 32; // Controls coherency of shader reads
pub const ACCESS_SHADER_WRITE_BIT: u32 = 64; // Controls coherency of shader writes
pub const ACCESS_COLOR_ATTACHMENT_READ_BIT: u32 = 128; // Controls coherency of color attachment reads
pub const ACCESS_COLOR_ATTACHMENT_WRITE_BIT: u32 = 256; // Controls coherency of color attachment writes
pub const ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT: u32 = 512; // Controls coherency of depth/stencil attachment reads
pub const ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: u32 = 1024; // Controls coherency of depth/stencil attachment writes
pub const ACCESS_TRANSFER_READ_BIT: u32 = 2048; // Controls coherency of transfer reads
pub const ACCESS_TRANSFER_WRITE_BIT: u32 = 4096; // Controls coherency of transfer writes
pub const ACCESS_HOST_READ_BIT: u32 = 8192; // Controls coherency of host reads
pub const ACCESS_HOST_WRITE_BIT: u32 = 16384; // Controls coherency of host writes
pub const ACCESS_MEMORY_READ_BIT: u32 = 32768; // Controls coherency of memory reads
pub const ACCESS_MEMORY_WRITE_BIT: u32 = 65536; // Controls coherency of memory writes
pub const ACCESS_NONE: u32 = 0;
pub const ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: u32 = 33554432;
pub const ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: u32 = 67108864;
pub const ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: u32 = 134217728;
pub const ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT: u32 = 1048576; // read access flag for reading conditional rendering predicate
pub const ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: u32 = 524288;
pub const ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR: u32 = 2097152;
pub const ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: u32 = 4194304;
pub const ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV: u32 = ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR;
pub const ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV: u32 = ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR;
pub const ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV: u32 = ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR;
pub const ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: u32 = 16777216;
pub const ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR: u32 = 8388608;
pub const ACCESS_COMMAND_PREPROCESS_READ_BIT_NV: u32 = 131072;
pub const ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV: u32 = 262144;
pub const ACCESS_NONE_KHR: u32 = ACCESS_NONE;

pub type BufferUsageFlags = Flags;
pub type BufferUsageFlagBits = u32;
pub const BUFFER_USAGE_TRANSFER_SRC_BIT: u32 = 1; // Can be used as a source of transfer operations
pub const BUFFER_USAGE_TRANSFER_DST_BIT: u32 = 2; // Can be used as a destination of transfer operations
pub const BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT: u32 = 4; // Can be used as TBO
pub const BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT: u32 = 8; // Can be used as IBO
pub const BUFFER_USAGE_UNIFORM_BUFFER_BIT: u32 = 16; // Can be used as UBO
pub const BUFFER_USAGE_STORAGE_BUFFER_BIT: u32 = 32; // Can be used as SSBO
pub const BUFFER_USAGE_INDEX_BUFFER_BIT: u32 = 64; // Can be used as source of fixed-function index fetch (index buffer)
pub const BUFFER_USAGE_VERTEX_BUFFER_BIT: u32 = 128; // Can be used as source of fixed-function vertex fetch (VBO)
pub const BUFFER_USAGE_INDIRECT_BUFFER_BIT: u32 = 256; // Can be the source of indirect parameters (e.g. indirect buffer, parameter buffer)
pub const BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT: u32 = 131072;
pub const BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR: u32 = 8192;
pub const BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR: u32 = 16384;
pub const BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT: u32 = 2048;
pub const BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT: u32 = 4096;
pub const BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT: u32 = 512; // Specifies the buffer can be used as predicate in conditional rendering
pub const BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR: u32 = 524288;
pub const BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR: u32 = 1048576;
pub const BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR: u32 = 1024;
pub const BUFFER_USAGE_RAY_TRACING_BIT_NV: u32 = BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR;
pub const BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT: u32 = BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT;
pub const BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR: u32 = BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT;
pub const BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR: u32 = 32768;
pub const BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR: u32 = 65536;

pub type BufferCreateFlags = Flags;
pub type BufferCreateFlagBits = u32;
pub const BUFFER_CREATE_SPARSE_BINDING_BIT: u32 = 1; // Buffer should support sparse backing
pub const BUFFER_CREATE_SPARSE_RESIDENCY_BIT: u32 = 2; // Buffer should support sparse backing with partial residency
pub const BUFFER_CREATE_SPARSE_ALIASED_BIT: u32 = 4; // Buffer should support constant data access to physical memory ranges mapped into multiple locations of sparse buffers
pub const BUFFER_CREATE_PROTECTED_BIT: u32 = 8; // Buffer requires protected memory
pub const BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT: u32 = 16;
pub const BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT: u32 = BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT;
pub const BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR: u32 = BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT;

pub type ShaderStageFlags = Flags;
pub type ShaderStageFlagBits = u32;
pub const SHADER_STAGE_VERTEX_BIT: u32 = 1;
pub const SHADER_STAGE_TESSELLATION_CONTROL_BIT: u32 = 2;
pub const SHADER_STAGE_TESSELLATION_EVALUATION_BIT: u32 = 4;
pub const SHADER_STAGE_GEOMETRY_BIT: u32 = 8;
pub const SHADER_STAGE_FRAGMENT_BIT: u32 = 16;
pub const SHADER_STAGE_COMPUTE_BIT: u32 = 32;
pub const SHADER_STAGE_ALL_GRAPHICS: u32 = 0x0000001F;
pub const SHADER_STAGE_ALL: u32 = 0x7FFFFFFF;
pub const SHADER_STAGE_RAYGEN_BIT_KHR: u32 = 256;
pub const SHADER_STAGE_ANY_HIT_BIT_KHR: u32 = 512;
pub const SHADER_STAGE_CLOSEST_HIT_BIT_KHR: u32 = 1024;
pub const SHADER_STAGE_MISS_BIT_KHR: u32 = 2048;
pub const SHADER_STAGE_INTERSECTION_BIT_KHR: u32 = 4096;
pub const SHADER_STAGE_CALLABLE_BIT_KHR: u32 = 8192;
pub const SHADER_STAGE_RAYGEN_BIT_NV: u32 = SHADER_STAGE_RAYGEN_BIT_KHR;
pub const SHADER_STAGE_ANY_HIT_BIT_NV: u32 = SHADER_STAGE_ANY_HIT_BIT_KHR;
pub const SHADER_STAGE_CLOSEST_HIT_BIT_NV: u32 = SHADER_STAGE_CLOSEST_HIT_BIT_KHR;
pub const SHADER_STAGE_MISS_BIT_NV: u32 = SHADER_STAGE_MISS_BIT_KHR;
pub const SHADER_STAGE_INTERSECTION_BIT_NV: u32 = SHADER_STAGE_INTERSECTION_BIT_KHR;
pub const SHADER_STAGE_CALLABLE_BIT_NV: u32 = SHADER_STAGE_CALLABLE_BIT_KHR;
pub const SHADER_STAGE_TASK_BIT_NV: u32 = 64;
pub const SHADER_STAGE_MESH_BIT_NV: u32 = 128;
pub const SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI: u32 = 16384;

pub type ImageUsageFlags = Flags;
pub type ImageUsageFlagBits = u32;
pub const IMAGE_USAGE_TRANSFER_SRC_BIT: u32 = 1; // Can be used as a source of transfer operations
pub const IMAGE_USAGE_TRANSFER_DST_BIT: u32 = 2; // Can be used as a destination of transfer operations
pub const IMAGE_USAGE_SAMPLED_BIT: u32 = 4; // Can be sampled from (SAMPLED_IMAGE and COMBINED_IMAGE_SAMPLER descriptor types)
pub const IMAGE_USAGE_STORAGE_BIT: u32 = 8; // Can be used as storage image (STORAGE_IMAGE descriptor type)
pub const IMAGE_USAGE_COLOR_ATTACHMENT_BIT: u32 = 16; // Can be used as framebuffer color attachment
pub const IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: u32 = 32; // Can be used as framebuffer depth/stencil attachment
pub const IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT: u32 = 64; // Image data not needed outside of rendering
pub const IMAGE_USAGE_INPUT_ATTACHMENT_BIT: u32 = 128; // Can be used as framebuffer input attachment
pub const IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR: u32 = 1024;
pub const IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR: u32 = 2048;
pub const IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR: u32 = 4096;
pub const IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV: u32 = IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR;
pub const IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT: u32 = 512;
pub const IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: u32 = 256;
pub const IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR: u32 = 8192;
pub const IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR: u32 = 16384;
pub const IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR: u32 = 32768;
pub const IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI: u32 = 262144;

pub type ImageCreateFlags = Flags;
pub type ImageCreateFlagBits = u32;
pub const IMAGE_CREATE_SPARSE_BINDING_BIT: u32 = 1; // Image should support sparse backing
pub const IMAGE_CREATE_SPARSE_RESIDENCY_BIT: u32 = 2; // Image should support sparse backing with partial residency
pub const IMAGE_CREATE_SPARSE_ALIASED_BIT: u32 = 4; // Image should support constant data access to physical memory ranges mapped into multiple locations of sparse images
pub const IMAGE_CREATE_MUTABLE_FORMAT_BIT: u32 = 8; // Allows image views to have different format than the base image
pub const IMAGE_CREATE_CUBE_COMPATIBLE_BIT: u32 = 16; // Allows creating image views with cube type from the created image
pub const IMAGE_CREATE_ALIAS_BIT: u32 = 1024;
pub const IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT: u32 = 64; // Allows using VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions when binding memory to the image
pub const IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT: u32 = 32; // The 3D image can be viewed as a 2D or 2D array image
pub const IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT: u32 = 128;
pub const IMAGE_CREATE_EXTENDED_USAGE_BIT: u32 = 256;
pub const IMAGE_CREATE_PROTECTED_BIT: u32 = 2048; // Image requires protected memory
pub const IMAGE_CREATE_DISJOINT_BIT: u32 = 512;
pub const IMAGE_CREATE_CORNER_SAMPLED_BIT_NV: u32 = 8192;
pub const IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR: u32 = IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT;
pub const IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR: u32 = IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT;
pub const IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR: u32 = IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT;
pub const IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR: u32 = IMAGE_CREATE_EXTENDED_USAGE_BIT;
pub const IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT: u32 = 4096;
pub const IMAGE_CREATE_DISJOINT_BIT_KHR: u32 = IMAGE_CREATE_DISJOINT_BIT;
pub const IMAGE_CREATE_ALIAS_BIT_KHR: u32 = IMAGE_CREATE_ALIAS_BIT;
pub const IMAGE_CREATE_SUBSAMPLED_BIT_EXT: u32 = 16384;
pub const IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT: u32 = 131072; // Image is created with a layout where individual slices are capable of being used as 2D images
pub const IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM: u32 = 32768;

pub type ImageViewCreateFlags = Flags;
pub type ImageViewCreateFlagBits = u32;
pub const IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT: u32 = 1;
pub const IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT: u32 = 2;

pub type PipelineCreateFlags = Flags;
pub type PipelineCreateFlagBits = u32;
pub const PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT: u32 = 1;
pub const PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT: u32 = 2;
pub const PIPELINE_CREATE_DERIVATIVE_BIT: u32 = 4;
pub const PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT: u32 = 8;
pub const PIPELINE_CREATE_DISPATCH_BASE_BIT: u32 = 16;
pub const PIPELINE_CREATE_DISPATCH_BASE: u32 = PIPELINE_CREATE_DISPATCH_BASE_BIT;
pub const PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT: u32 = 256;
pub const PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT: u32 = 512;
pub const PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: u32 = 2097152;
pub const PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: u32 = PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR; // Backwards-compatible alias containing a typo
pub const PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT: u32 = 4194304;
pub const PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT: u32 = PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT; // Backwards-compatible alias containing a typo
pub const PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR: u32 = PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT;
pub const PIPELINE_CREATE_DISPATCH_BASE_KHR: u32 = PIPELINE_CREATE_DISPATCH_BASE;
pub const PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR: u32 = 16384;
pub const PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR: u32 = 32768;
pub const PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR: u32 = 65536;
pub const PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR: u32 = 131072;
pub const PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR: u32 = 4096;
pub const PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR: u32 = 8192;
pub const PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR: u32 = 524288;
pub const PIPELINE_CREATE_DEFER_COMPILE_BIT_NV: u32 = 32;
pub const PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR: u32 = 64;
pub const PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR: u32 = 128;
pub const PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV: u32 = 262144;
pub const PIPELINE_CREATE_LIBRARY_BIT_KHR: u32 = 2048;
pub const PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT: u32 = PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT;
pub const PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT: u32 = PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT;
pub const PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT: u32 = 8388608;
pub const PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT: u32 = 1024;
pub const PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV: u32 = 1048576;

pub type ColorComponentFlags = Flags;
pub type ColorComponentFlagBits = u32;
pub const COLOR_COMPONENT_R_BIT: u32 = 1;
pub const COLOR_COMPONENT_G_BIT: u32 = 2;
pub const COLOR_COMPONENT_B_BIT: u32 = 4;
pub const COLOR_COMPONENT_A_BIT: u32 = 8;

pub type FenceCreateFlags = Flags;
pub type FenceCreateFlagBits = u32;
pub const FENCE_CREATE_SIGNALED_BIT: u32 = 1;

pub type SemaphoreCreateFlags = Flags;

pub type FormatFeatureFlags = Flags;
pub type FormatFeatureFlagBits = u32;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_BIT: u32 = 1; // Format can be used for sampled images (SAMPLED_IMAGE and COMBINED_IMAGE_SAMPLER descriptor types)
pub const FORMAT_FEATURE_STORAGE_IMAGE_BIT: u32 = 2; // Format can be used for storage images (STORAGE_IMAGE descriptor type)
pub const FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT: u32 = 4; // Format supports atomic operations in case it is used for storage images
pub const FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT: u32 = 8; // Format can be used for uniform texel buffers (TBOs)
pub const FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT: u32 = 16; // Format can be used for storage texel buffers (IBOs)
pub const FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT: u32 = 32; // Format supports atomic operations in case it is used for storage texel buffers
pub const FORMAT_FEATURE_VERTEX_BUFFER_BIT: u32 = 64; // Format can be used for vertex buffers (VBOs)
pub const FORMAT_FEATURE_COLOR_ATTACHMENT_BIT: u32 = 128; // Format can be used for color attachment images
pub const FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT: u32 = 256; // Format supports blending in case it is used for color attachment images
pub const FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT: u32 = 512; // Format can be used for depth/stencil attachment images
pub const FORMAT_FEATURE_BLIT_SRC_BIT: u32 = 1024; // Format can be used as the source image of blits with vkCmdBlitImage
pub const FORMAT_FEATURE_BLIT_DST_BIT: u32 = 2048; // Format can be used as the destination image of blits with vkCmdBlitImage
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT: u32 = 4096; // Format can be filtered with VK_FILTER_LINEAR when being sampled
pub const FORMAT_FEATURE_TRANSFER_SRC_BIT: u32 = 16384; // Format can be used as the source image of image transfer commands
pub const FORMAT_FEATURE_TRANSFER_DST_BIT: u32 = 32768; // Format can be used as the destination image of image transfer commands
pub const FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT: u32 = 131072; // Format can have midpoint rather than cosited chroma samples
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT: u32 = 262144; // Format can be used with linear filtering whilst color conversion is enabled
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT: u32 = 524288; // Format can have different chroma, min and mag filters
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT: u32 = 1048576;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT: u32 = 2097152;
pub const FORMAT_FEATURE_DISJOINT_BIT: u32 = 4194304; // Format supports disjoint planes
pub const FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT: u32 = 8388608; // Format can have cosited rather than midpoint chroma samples
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT: u32 = 65536; // Format can be used with min/max reduction filtering
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG: u32 = 8192; // Format can be filtered with VK_FILTER_CUBIC_IMG when being sampled
pub const FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR: u32 = 33554432;
pub const FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR: u32 = 67108864;
pub const FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR: u32 = FORMAT_FEATURE_TRANSFER_SRC_BIT;
pub const FORMAT_FEATURE_TRANSFER_DST_BIT_KHR: u32 = FORMAT_FEATURE_TRANSFER_DST_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT;
pub const FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR: u32 = 536870912;
pub const FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR: u32 = FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT;
pub const FORMAT_FEATURE_DISJOINT_BIT_KHR: u32 = FORMAT_FEATURE_DISJOINT_BIT;
pub const FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR: u32 = FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG;
pub const FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT: u32 = 16777216;
pub const FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: u32 = 1073741824;
pub const FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR: u32 = 134217728;
pub const FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR: u32 = 268435456;

pub type QueryControlFlags = Flags;
pub type QueryControlFlagBits = u32;
pub const QUERY_CONTROL_PRECISE_BIT: u32 = 1; // Require precise results to be collected by the query

pub type QueryResultFlags = Flags;
pub type QueryResultFlagBits = u32;
pub const QUERY_RESULT_64_BIT: u32 = 1; // Results of the queries are written to the destination buffer as 64-bit values
pub const QUERY_RESULT_WAIT_BIT: u32 = 2; // Results of the queries are waited on before proceeding with the result copy
pub const QUERY_RESULT_WITH_AVAILABILITY_BIT: u32 = 4; // Besides the results of the query, the availability of the results is also written
pub const QUERY_RESULT_PARTIAL_BIT: u32 = 8; // Copy the partial results of the query even if the final results are not available
pub const QUERY_RESULT_WITH_STATUS_BIT_KHR: u32 = 16;

pub type ShaderModuleCreateFlags = Flags;

pub type EventCreateFlags = Flags;
pub type EventCreateFlagBits = u32;
pub const EVENT_CREATE_DEVICE_ONLY_BIT: u32 = 1;
pub const EVENT_CREATE_DEVICE_ONLY_BIT_KHR: u32 = EVENT_CREATE_DEVICE_ONLY_BIT;

pub type CommandPoolCreateFlags = Flags;
pub type CommandPoolCreateFlagBits = u32;
pub const COMMAND_POOL_CREATE_TRANSIENT_BIT: u32 = 1; // Command buffers have a short lifetime
pub const COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT: u32 = 2; // Command buffers may release their memory individually
pub const COMMAND_POOL_CREATE_PROTECTED_BIT: u32 = 4; // Command buffers allocated from pool are protected command buffers

pub type CommandPoolResetFlags = Flags;
pub type CommandPoolResetFlagBits = u32;
pub const COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT: u32 = 1; // Release resources owned by the pool

pub type CommandBufferResetFlags = Flags;
pub type CommandBufferResetFlagBits = u32;
pub const COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT: u32 = 1; // Release resources owned by the buffer

pub type CommandBufferUsageFlags = Flags;
pub type CommandBufferUsageFlagBits = u32;
pub const COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT: u32 = 1;
pub const COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT: u32 = 2;
pub const COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT: u32 = 4; // Command buffer may be submitted/executed more than once simultaneously

pub type QueryPipelineStatisticFlags = Flags;
pub type QueryPipelineStatisticFlagBits = u32;
pub const QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT: u32 = 1; // Optional
pub const QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT: u32 = 2; // Optional
pub const QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT: u32 = 4; // Optional
pub const QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT: u32 = 8; // Optional
pub const QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT: u32 = 16; // Optional
pub const QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT: u32 = 32; // Optional
pub const QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT: u32 = 64; // Optional
pub const QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT: u32 = 128; // Optional
pub const QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT: u32 = 256; // Optional
pub const QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT: u32 = 512; // Optional
pub const QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT: u32 = 1024; // Optional

pub type MemoryMapFlags = Flags;

pub type ImageAspectFlags = Flags;
pub type ImageAspectFlagBits = u32;
pub const IMAGE_ASPECT_COLOR_BIT: u32 = 1;
pub const IMAGE_ASPECT_DEPTH_BIT: u32 = 2;
pub const IMAGE_ASPECT_STENCIL_BIT: u32 = 4;
pub const IMAGE_ASPECT_METADATA_BIT: u32 = 8;
pub const IMAGE_ASPECT_PLANE_0_BIT: u32 = 16;
pub const IMAGE_ASPECT_PLANE_1_BIT: u32 = 32;
pub const IMAGE_ASPECT_PLANE_2_BIT: u32 = 64;
pub const IMAGE_ASPECT_NONE: u32 = 0;
pub const IMAGE_ASPECT_PLANE_0_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_0_BIT;
pub const IMAGE_ASPECT_PLANE_1_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_1_BIT;
pub const IMAGE_ASPECT_PLANE_2_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_2_BIT;
pub const IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT: u32 = 128;
pub const IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT: u32 = 256;
pub const IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT: u32 = 512;
pub const IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT: u32 = 1024;
pub const IMAGE_ASPECT_NONE_KHR: u32 = IMAGE_ASPECT_NONE;

pub type SparseMemoryBindFlags = Flags;
pub type SparseMemoryBindFlagBits = u32;
pub const SPARSE_MEMORY_BIND_METADATA_BIT: u32 = 1; // Operation binds resource metadata to memory

pub type SparseImageFormatFlags = Flags;
pub type SparseImageFormatFlagBits = u32;
pub const SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT: u32 = 1; // Image uses a single mip tail region for all array layers
pub const SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT: u32 = 2; // Image requires mip level dimensions to be an integer multiple of the sparse image block dimensions for non-tail mip levels.
pub const SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT: u32 = 4; // Image uses a non-standard sparse image block dimensions

pub type SubpassDescriptionFlags = Flags;
pub type SubpassDescriptionFlagBits = u32;
pub const SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX: u32 = 1;
pub const SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX: u32 = 2;
pub const SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM: u32 = 4;
pub const SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM: u32 = 8;
pub const SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_ARM: u32 = 16;
pub const SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_ARM: u32 = 32;
pub const SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_ARM: u32 = 64;

pub type PipelineStageFlags = Flags;
pub type PipelineStageFlagBits = u32;
pub const PIPELINE_STAGE_TOP_OF_PIPE_BIT: u32 = 1; // Before subsequent commands are processed
pub const PIPELINE_STAGE_DRAW_INDIRECT_BIT: u32 = 2; // Draw/DispatchIndirect command fetch
pub const PIPELINE_STAGE_VERTEX_INPUT_BIT: u32 = 4; // Vertex/index fetch
pub const PIPELINE_STAGE_VERTEX_SHADER_BIT: u32 = 8; // Vertex shading
pub const PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT: u32 = 16; // Tessellation control shading
pub const PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT: u32 = 32; // Tessellation evaluation shading
pub const PIPELINE_STAGE_GEOMETRY_SHADER_BIT: u32 = 64; // Geometry shading
pub const PIPELINE_STAGE_FRAGMENT_SHADER_BIT: u32 = 128; // Fragment shading
pub const PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT: u32 = 256; // Early fragment (depth and stencil) tests
pub const PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT: u32 = 512; // Late fragment (depth and stencil) tests
pub const PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT: u32 = 1024; // Color attachment writes
pub const PIPELINE_STAGE_COMPUTE_SHADER_BIT: u32 = 2048; // Compute shading
pub const PIPELINE_STAGE_TRANSFER_BIT: u32 = 4096; // Transfer/copy operations
pub const PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT: u32 = 8192; // After previous commands have completed
pub const PIPELINE_STAGE_HOST_BIT: u32 = 16384; // Indicates host (CPU) is a source/sink of the dependency
pub const PIPELINE_STAGE_ALL_GRAPHICS_BIT: u32 = 32768; // All stages of the graphics pipeline
pub const PIPELINE_STAGE_ALL_COMMANDS_BIT: u32 = 65536; // All stages supported on the queue
pub const PIPELINE_STAGE_NONE: u32 = 0;
pub const PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT: u32 = 16777216;
pub const PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT: u32 = 262144; // A pipeline stage for conditional rendering predicate fetch
pub const PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR: u32 = 33554432;
pub const PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR: u32 = 2097152;
pub const PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV: u32 = PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR;
pub const PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV: u32 = PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR;
pub const PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV: u32 = PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR;
pub const PIPELINE_STAGE_TASK_SHADER_BIT_NV: u32 = 524288;
pub const PIPELINE_STAGE_MESH_SHADER_BIT_NV: u32 = 1048576;
pub const PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT: u32 = 8388608;
pub const PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: u32 = 4194304;
pub const PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV: u32 = 131072;
pub const PIPELINE_STAGE_NONE_KHR: u32 = PIPELINE_STAGE_NONE;

pub type SampleCountFlags = Flags;
pub type SampleCountFlagBits = u32;
pub const SAMPLE_COUNT_1_BIT: u32 = 1; // Sample count 1 supported
pub const SAMPLE_COUNT_2_BIT: u32 = 2; // Sample count 2 supported
pub const SAMPLE_COUNT_4_BIT: u32 = 4; // Sample count 4 supported
pub const SAMPLE_COUNT_8_BIT: u32 = 8; // Sample count 8 supported
pub const SAMPLE_COUNT_16_BIT: u32 = 16; // Sample count 16 supported
pub const SAMPLE_COUNT_32_BIT: u32 = 32; // Sample count 32 supported
pub const SAMPLE_COUNT_64_BIT: u32 = 64; // Sample count 64 supported

pub type AttachmentDescriptionFlags = Flags;
pub type AttachmentDescriptionFlagBits = u32;
pub const ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT: u32 = 1; // The attachment may alias physical memory of another attachment in the same render pass

pub type StencilFaceFlags = Flags;
pub type StencilFaceFlagBits = u32;
pub const STENCIL_FACE_FRONT_BIT: u32 = 1; // Front face
pub const STENCIL_FACE_BACK_BIT: u32 = 2; // Back face
pub const STENCIL_FACE_FRONT_AND_BACK: u32 = 0x00000003; // Front and back faces
pub const STENCIL_FRONT_AND_BACK: u32 = STENCIL_FACE_FRONT_AND_BACK; // Backwards-compatible alias containing a typo

pub type CullModeFlags = Flags;
pub type CullModeFlagBits = u32;
pub const CULL_MODE_NONE: u32 = 0;
pub const CULL_MODE_FRONT_BIT: u32 = 1;
pub const CULL_MODE_BACK_BIT: u32 = 2;
pub const CULL_MODE_FRONT_AND_BACK: u32 = 0x00000003;

pub type DescriptorPoolCreateFlags = Flags;
pub type DescriptorPoolCreateFlagBits = u32;
pub const DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT: u32 = 1; // Descriptor sets may be freed individually
pub const DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT: u32 = 2;
pub const DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT: u32 = DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT;
pub const DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE: u32 = 4;

pub type DescriptorPoolResetFlags = Flags;

pub type DependencyFlags = Flags;
pub type DependencyFlagBits = u32;
pub const DEPENDENCY_BY_REGION_BIT: u32 = 1; // Dependency is per pixel region 
pub const DEPENDENCY_DEVICE_GROUP_BIT: u32 = 4; // Dependency is across devices
pub const DEPENDENCY_VIEW_LOCAL_BIT: u32 = 2;
pub const DEPENDENCY_VIEW_LOCAL_BIT_KHR: u32 = DEPENDENCY_VIEW_LOCAL_BIT;
pub const DEPENDENCY_DEVICE_GROUP_BIT_KHR: u32 = DEPENDENCY_DEVICE_GROUP_BIT;

pub type SubgroupFeatureFlags = Flags;
pub type SubgroupFeatureFlagBits = u32;
pub const SUBGROUP_FEATURE_BASIC_BIT: u32 = 1; // Basic subgroup operations
pub const SUBGROUP_FEATURE_VOTE_BIT: u32 = 2; // Vote subgroup operations
pub const SUBGROUP_FEATURE_ARITHMETIC_BIT: u32 = 4; // Arithmetic subgroup operations
pub const SUBGROUP_FEATURE_BALLOT_BIT: u32 = 8; // Ballot subgroup operations
pub const SUBGROUP_FEATURE_SHUFFLE_BIT: u32 = 16; // Shuffle subgroup operations
pub const SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT: u32 = 32; // Shuffle relative subgroup operations
pub const SUBGROUP_FEATURE_CLUSTERED_BIT: u32 = 64; // Clustered subgroup operations
pub const SUBGROUP_FEATURE_QUAD_BIT: u32 = 128; // Quad subgroup operations
pub const SUBGROUP_FEATURE_PARTITIONED_BIT_NV: u32 = 256;

pub type IndirectCommandsLayoutUsageFlagsNV = Flags;
pub type IndirectCommandsLayoutUsageFlagBitsNV = u32;
pub const INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV: u32 = 1;
pub const INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV: u32 = 2;
pub const INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV: u32 = 4;

pub type IndirectStateFlagsNV = Flags;
pub type IndirectStateFlagBitsNV = u32;
pub const INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV: u32 = 1;

pub type GeometryFlagsKHR = Flags;
pub type GeometryFlagBitsKHR = u32;
pub const GEOMETRY_OPAQUE_BIT_KHR: u32 = 1;
pub const GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR: u32 = 2;
pub const GEOMETRY_OPAQUE_BIT_NV: u32 = GEOMETRY_OPAQUE_BIT_KHR;
pub const GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV: u32 = GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR;

pub type GeometryFlagsNV = GeometryFlagsKHR;

pub type GeometryInstanceFlagsKHR = Flags;
pub type GeometryInstanceFlagBitsKHR = u32;
pub const GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR: u32 = 1;
pub const GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR: u32 = 2;
pub const GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR: u32 = 4;
pub const GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR: u32 = 8;
pub const GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR: u32 = GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR;
pub const GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV: u32 = GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR;
pub const GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV: u32 = GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR;
pub const GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV: u32 = GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR;
pub const GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV: u32 = GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR;

pub type GeometryInstanceFlagsNV = GeometryInstanceFlagsKHR;

pub type BuildAccelerationStructureFlagsKHR = Flags;
pub type BuildAccelerationStructureFlagBitsKHR = u32;
pub const BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR: u32 = 1;
pub const BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR: u32 = 2;
pub const BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR: u32 = 4;
pub const BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR: u32 = 8;
pub const BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR: u32 = 16;
pub const BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV: u32 = BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR;
pub const BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV: u32 = BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR;
pub const BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV: u32 = BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR;
pub const BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV: u32 = BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR;
pub const BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV: u32 = BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR;
pub const BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV: u32 = 32;

pub type BuildAccelerationStructureFlagsNV = BuildAccelerationStructureFlagsKHR;

pub type PrivateDataSlotCreateFlags = Flags;

pub type PrivateDataSlotCreateFlagsEXT = PrivateDataSlotCreateFlags;

pub type AccelerationStructureCreateFlagsKHR = Flags;
pub type AccelerationStructureCreateFlagBitsKHR = u32;
pub const ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR: u32 = 1;
pub const ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV: u32 = 4;

pub type DescriptorUpdateTemplateCreateFlags = Flags;

pub type DescriptorUpdateTemplateCreateFlagsKHR = DescriptorUpdateTemplateCreateFlags;

pub type PipelineCreationFeedbackFlags = Flags;
pub type PipelineCreationFeedbackFlagBits = u32;
pub const PIPELINE_CREATION_FEEDBACK_VALID_BIT: u32 = 1;
pub const PIPELINE_CREATION_FEEDBACK_VALID_BIT_EXT: u32 = PIPELINE_CREATION_FEEDBACK_VALID_BIT;
pub const PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT: u32 = 2;
pub const PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT_EXT: u32 = PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT;
pub const PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT: u32 = 4;
pub const PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT_EXT: u32 = PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT;

pub type PipelineCreationFeedbackFlagsEXT = PipelineCreationFeedbackFlags;

pub type PerformanceCounterDescriptionFlagsKHR = Flags;
pub type PerformanceCounterDescriptionFlagBitsKHR = u32;
pub const PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR: u32 = 1;
pub const PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR: u32 = PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR; // Backwards-compatible alias containing a typo
pub const PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR: u32 = 2;
pub const PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR: u32 = PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR; // Backwards-compatible alias containing a typo

pub type AcquireProfilingLockFlagsKHR = Flags;
pub type AcquireProfilingLockFlagBitsKHR = u32;

pub type SemaphoreWaitFlags = Flags;
pub type SemaphoreWaitFlagBits = u32;
pub const SEMAPHORE_WAIT_ANY_BIT: u32 = 1;
pub const SEMAPHORE_WAIT_ANY_BIT_KHR: u32 = SEMAPHORE_WAIT_ANY_BIT;

pub type SemaphoreWaitFlagsKHR = SemaphoreWaitFlags;

pub type PipelineCompilerControlFlagsAMD = Flags;
pub type PipelineCompilerControlFlagBitsAMD = u32;

pub type ShaderCorePropertiesFlagsAMD = Flags;
pub type ShaderCorePropertiesFlagBitsAMD = u32;

pub type DeviceDiagnosticsConfigFlagsNV = Flags;
pub type DeviceDiagnosticsConfigFlagBitsNV = u32;
pub const DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV: u32 = 1;
pub const DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV: u32 = 2;
pub const DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV: u32 = 4;

pub type AccessFlags2 = Flags64;

pub type AccessFlags2KHR = AccessFlags2;

pub type PipelineStageFlags2 = Flags64;

pub type PipelineStageFlags2KHR = PipelineStageFlags2;

pub type AccelerationStructureMotionInfoFlagsNV = Flags;

pub type AccelerationStructureMotionInstanceFlagsNV = Flags;

pub type FormatFeatureFlags2 = Flags64;

pub type FormatFeatureFlags2KHR = FormatFeatureFlags2;

pub type RenderingFlags = Flags;
pub type RenderingFlagBits = u32;
pub const RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT: u32 = 1;
pub const RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT_KHR: u32 = RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT;
pub const RENDERING_SUSPENDING_BIT: u32 = 2;
pub const RENDERING_SUSPENDING_BIT_KHR: u32 = RENDERING_SUSPENDING_BIT;
pub const RENDERING_RESUMING_BIT: u32 = 4;
pub const RENDERING_RESUMING_BIT_KHR: u32 = RENDERING_RESUMING_BIT;

pub type RenderingFlagsKHR = RenderingFlags;

pub type CompositeAlphaFlagsKHR = Flags;
pub type CompositeAlphaFlagBitsKHR = u32;
pub const COMPOSITE_ALPHA_OPAQUE_BIT_KHR: u32 = 1;
pub const COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR: u32 = 2;
pub const COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR: u32 = 4;
pub const COMPOSITE_ALPHA_INHERIT_BIT_KHR: u32 = 8;

pub type DisplayPlaneAlphaFlagsKHR = Flags;
pub type DisplayPlaneAlphaFlagBitsKHR = u32;
pub const DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR: u32 = 1;
pub const DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR: u32 = 2;
pub const DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR: u32 = 4;
pub const DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR: u32 = 8;

pub type SurfaceTransformFlagsKHR = Flags;
pub type SurfaceTransformFlagBitsKHR = u32;
pub const SURFACE_TRANSFORM_IDENTITY_BIT_KHR: u32 = 1;
pub const SURFACE_TRANSFORM_ROTATE_90_BIT_KHR: u32 = 2;
pub const SURFACE_TRANSFORM_ROTATE_180_BIT_KHR: u32 = 4;
pub const SURFACE_TRANSFORM_ROTATE_270_BIT_KHR: u32 = 8;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR: u32 = 16;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR: u32 = 32;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR: u32 = 64;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR: u32 = 128;
pub const SURFACE_TRANSFORM_INHERIT_BIT_KHR: u32 = 256;

pub type SwapchainCreateFlagsKHR = Flags;
pub type SwapchainCreateFlagBitsKHR = u32;
pub const SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR: u32 = 1; // Allow images with VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT
pub const SWAPCHAIN_CREATE_PROTECTED_BIT_KHR: u32 = 2; // Swapchain is protected
pub const SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR: u32 = 4;

pub type DisplayModeCreateFlagsKHR = Flags;

pub type DisplaySurfaceCreateFlagsKHR = Flags;

pub type AndroidSurfaceCreateFlagsKHR = Flags;

pub type ViSurfaceCreateFlagsNN = Flags;

pub type WaylandSurfaceCreateFlagsKHR = Flags;

pub type Win32SurfaceCreateFlagsKHR = Flags;

pub type XlibSurfaceCreateFlagsKHR = Flags;

pub type XcbSurfaceCreateFlagsKHR = Flags;

pub type DirectFBSurfaceCreateFlagsEXT = Flags;

pub type IOSSurfaceCreateFlagsMVK = Flags;

pub type MacOSSurfaceCreateFlagsMVK = Flags;

pub type MetalSurfaceCreateFlagsEXT = Flags;

pub type ImagePipeSurfaceCreateFlagsFUCHSIA = Flags;

pub type StreamDescriptorSurfaceCreateFlagsGGP = Flags;

pub type HeadlessSurfaceCreateFlagsEXT = Flags;

pub type ScreenSurfaceCreateFlagsQNX = Flags;

pub type PeerMemoryFeatureFlags = Flags;
pub type PeerMemoryFeatureFlagBits = u32;
pub const PEER_MEMORY_FEATURE_COPY_SRC_BIT: u32 = 1; // Can read with vkCmdCopy commands
pub const PEER_MEMORY_FEATURE_COPY_DST_BIT: u32 = 2; // Can write with vkCmdCopy commands
pub const PEER_MEMORY_FEATURE_GENERIC_SRC_BIT: u32 = 4; // Can read with any access type/command
pub const PEER_MEMORY_FEATURE_GENERIC_DST_BIT: u32 = 8; // Can write with and access type/command
pub const PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR: u32 = PEER_MEMORY_FEATURE_COPY_SRC_BIT;
pub const PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR: u32 = PEER_MEMORY_FEATURE_COPY_DST_BIT;
pub const PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR: u32 = PEER_MEMORY_FEATURE_GENERIC_SRC_BIT;
pub const PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR: u32 = PEER_MEMORY_FEATURE_GENERIC_DST_BIT;

pub type PeerMemoryFeatureFlagsKHR = PeerMemoryFeatureFlags;

pub type MemoryAllocateFlags = Flags;
pub type MemoryAllocateFlagBits = u32;
pub const MEMORY_ALLOCATE_DEVICE_MASK_BIT: u32 = 1; // Force allocation on specific devices
pub const MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT: u32 = 2;
pub const MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT: u32 = 4;
pub const MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR: u32 = MEMORY_ALLOCATE_DEVICE_MASK_BIT;
pub const MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR: u32 = MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT;
pub const MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR: u32 = MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT;

pub type MemoryAllocateFlagsKHR = MemoryAllocateFlags;

pub type DeviceGroupPresentModeFlagsKHR = Flags;
pub type DeviceGroupPresentModeFlagBitsKHR = u32;
pub const DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR: u32 = 1; // Present from local memory
pub const DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR: u32 = 2; // Present from remote memory
pub const DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR: u32 = 4; // Present sum of local and/or remote memory
pub const DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR: u32 = 8; // Each physical device presents from local memory

pub type DebugReportFlagsEXT = Flags;
pub type DebugReportFlagBitsEXT = u32;
pub const DEBUG_REPORT_INFORMATION_BIT_EXT: u32 = 1;
pub const DEBUG_REPORT_WARNING_BIT_EXT: u32 = 2;
pub const DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT: u32 = 4;
pub const DEBUG_REPORT_ERROR_BIT_EXT: u32 = 8;
pub const DEBUG_REPORT_DEBUG_BIT_EXT: u32 = 16;

pub type CommandPoolTrimFlags = Flags;

pub type CommandPoolTrimFlagsKHR = CommandPoolTrimFlags;

pub type ExternalMemoryHandleTypeFlagsNV = Flags;
pub type ExternalMemoryHandleTypeFlagBitsNV = u32;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV: u32 = 1;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV: u32 = 2;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV: u32 = 4;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV: u32 = 8;

pub type ExternalMemoryFeatureFlagsNV = Flags;
pub type ExternalMemoryFeatureFlagBitsNV = u32;
pub const EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV: u32 = 1;
pub const EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV: u32 = 2;
pub const EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV: u32 = 4;

pub type ExternalMemoryHandleTypeFlags = Flags;
pub type ExternalMemoryHandleTypeFlagBits = u32;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT: u32 = 1;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT: u32 = 2;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT: u32 = 4;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT: u32 = 8;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT: u32 = 16;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT: u32 = 32;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT: u32 = 64;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR: u32 = EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT: u32 = 512;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT: u32 = 128;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT: u32 = 256;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV: u32 = 4096;

pub type ExternalMemoryHandleTypeFlagsKHR = ExternalMemoryHandleTypeFlags;

pub type ExternalMemoryFeatureFlags = Flags;
pub type ExternalMemoryFeatureFlagBits = u32;
pub const EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT: u32 = 1;
pub const EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT: u32 = 2;
pub const EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT: u32 = 4;
pub const EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR: u32 = EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT;
pub const EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR: u32 = EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT;
pub const EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR: u32 = EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT;

pub type ExternalMemoryFeatureFlagsKHR = ExternalMemoryFeatureFlags;

pub type ExternalSemaphoreHandleTypeFlags = Flags;
pub type ExternalSemaphoreHandleTypeFlagBits = u32;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT: u32 = 1;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT: u32 = 2;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT: u32 = 4;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT: u32 = 8;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT: u32 = 16;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT;
pub const EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT;

pub type ExternalSemaphoreHandleTypeFlagsKHR = ExternalSemaphoreHandleTypeFlags;

pub type ExternalSemaphoreFeatureFlags = Flags;
pub type ExternalSemaphoreFeatureFlagBits = u32;
pub const EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT: u32 = 1;
pub const EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT: u32 = 2;
pub const EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT;
pub const EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR: u32 = EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT;

pub type ExternalSemaphoreFeatureFlagsKHR = ExternalSemaphoreFeatureFlags;

pub type SemaphoreImportFlags = Flags;
pub type SemaphoreImportFlagBits = u32;
pub const SEMAPHORE_IMPORT_TEMPORARY_BIT: u32 = 1;
pub const SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR: u32 = SEMAPHORE_IMPORT_TEMPORARY_BIT;

pub type SemaphoreImportFlagsKHR = SemaphoreImportFlags;

pub type ExternalFenceHandleTypeFlags = Flags;
pub type ExternalFenceHandleTypeFlagBits = u32;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT: u32 = 1;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT: u32 = 2;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT: u32 = 4;
pub const EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT: u32 = 8;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR: u32 = EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR: u32 = EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT;
pub const EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR: u32 = EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT;
pub const EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR: u32 = EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT;

pub type ExternalFenceHandleTypeFlagsKHR = ExternalFenceHandleTypeFlags;

pub type ExternalFenceFeatureFlags = Flags;
pub type ExternalFenceFeatureFlagBits = u32;
pub const EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT: u32 = 1;
pub const EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT: u32 = 2;
pub const EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR: u32 = EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT;
pub const EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR: u32 = EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT;

pub type ExternalFenceFeatureFlagsKHR = ExternalFenceFeatureFlags;

pub type FenceImportFlags = Flags;
pub type FenceImportFlagBits = u32;
pub const FENCE_IMPORT_TEMPORARY_BIT: u32 = 1;
pub const FENCE_IMPORT_TEMPORARY_BIT_KHR: u32 = FENCE_IMPORT_TEMPORARY_BIT;

pub type FenceImportFlagsKHR = FenceImportFlags;

pub type SurfaceCounterFlagsEXT = Flags;
pub type SurfaceCounterFlagBitsEXT = u32;
pub const SURFACE_COUNTER_VBLANK_BIT_EXT: u32 = 1;
pub const SURFACE_COUNTER_VBLANK_EXT: u32 = SURFACE_COUNTER_VBLANK_BIT_EXT; // Backwards-compatible alias containing a typo

pub type PipelineViewportSwizzleStateCreateFlagsNV = Flags;

pub type PipelineDiscardRectangleStateCreateFlagsEXT = Flags;

pub type PipelineCoverageToColorStateCreateFlagsNV = Flags;

pub type PipelineCoverageModulationStateCreateFlagsNV = Flags;

pub type PipelineCoverageReductionStateCreateFlagsNV = Flags;

pub type ValidationCacheCreateFlagsEXT = Flags;

pub type DebugUtilsMessageSeverityFlagsEXT = Flags;
pub type DebugUtilsMessageSeverityFlagBitsEXT = u32;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT: u32 = 1;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT: u32 = 16;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT: u32 = 256;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT: u32 = 4096;

pub type DebugUtilsMessageTypeFlagsEXT = Flags;
pub type DebugUtilsMessageTypeFlagBitsEXT = u32;
pub const DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT: u32 = 1;
pub const DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT: u32 = 2;
pub const DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT: u32 = 4;

pub type DebugUtilsMessengerCreateFlagsEXT = Flags;

pub type DebugUtilsMessengerCallbackDataFlagsEXT = Flags;

pub type DeviceMemoryReportFlagsEXT = Flags;

pub type PipelineRasterizationConservativeStateCreateFlagsEXT = Flags;

pub type DescriptorBindingFlags = Flags;
pub type DescriptorBindingFlagBits = u32;
pub const DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT: u32 = 1;
pub const DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT: u32 = 2;
pub const DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT: u32 = 4;
pub const DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT: u32 = 8;
pub const DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT: u32 = DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT;
pub const DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT: u32 = DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT;
pub const DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT: u32 = DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT;
pub const DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT: u32 = DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT;

pub type DescriptorBindingFlagsEXT = DescriptorBindingFlags;

pub type ConditionalRenderingFlagsEXT = Flags;
pub type ConditionalRenderingFlagBitsEXT = u32;
pub const CONDITIONAL_RENDERING_INVERTED_BIT_EXT: u32 = 1;

pub type ResolveModeFlags = Flags;
pub type ResolveModeFlagBits = u32;
pub const RESOLVE_MODE_NONE: u32 = 0;
pub const RESOLVE_MODE_SAMPLE_ZERO_BIT: u32 = 1;
pub const RESOLVE_MODE_AVERAGE_BIT: u32 = 2;
pub const RESOLVE_MODE_MIN_BIT: u32 = 4;
pub const RESOLVE_MODE_MAX_BIT: u32 = 8;
pub const RESOLVE_MODE_NONE_KHR: u32 = RESOLVE_MODE_NONE;
pub const RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR: u32 = RESOLVE_MODE_SAMPLE_ZERO_BIT;
pub const RESOLVE_MODE_AVERAGE_BIT_KHR: u32 = RESOLVE_MODE_AVERAGE_BIT;
pub const RESOLVE_MODE_MIN_BIT_KHR: u32 = RESOLVE_MODE_MIN_BIT;
pub const RESOLVE_MODE_MAX_BIT_KHR: u32 = RESOLVE_MODE_MAX_BIT;

pub type ResolveModeFlagsKHR = ResolveModeFlags;

pub type PipelineRasterizationStateStreamCreateFlagsEXT = Flags;

pub type PipelineRasterizationDepthClipStateCreateFlagsEXT = Flags;

pub type SwapchainImageUsageFlagsANDROID = Flags;
pub type SwapchainImageUsageFlagBitsANDROID = u32;
pub const SWAPCHAIN_IMAGE_USAGE_SHARED_BIT_ANDROID: u32 = 1;

pub type ToolPurposeFlags = Flags;
pub type ToolPurposeFlagBits = u32;
pub const TOOL_PURPOSE_VALIDATION_BIT: u32 = 1;
pub const TOOL_PURPOSE_VALIDATION_BIT_EXT: u32 = TOOL_PURPOSE_VALIDATION_BIT;
pub const TOOL_PURPOSE_PROFILING_BIT: u32 = 2;
pub const TOOL_PURPOSE_PROFILING_BIT_EXT: u32 = TOOL_PURPOSE_PROFILING_BIT;
pub const TOOL_PURPOSE_TRACING_BIT: u32 = 4;
pub const TOOL_PURPOSE_TRACING_BIT_EXT: u32 = TOOL_PURPOSE_TRACING_BIT;
pub const TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT: u32 = 8;
pub const TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT: u32 = TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT;
pub const TOOL_PURPOSE_MODIFYING_FEATURES_BIT: u32 = 16;
pub const TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT: u32 = TOOL_PURPOSE_MODIFYING_FEATURES_BIT;
pub const TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT: u32 = 32;
pub const TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT: u32 = 64;

pub type ToolPurposeFlagsEXT = ToolPurposeFlags;

pub type SubmitFlags = Flags;
pub type SubmitFlagBits = u32;
pub const SUBMIT_PROTECTED_BIT: u32 = 1;
pub const SUBMIT_PROTECTED_BIT_KHR: u32 = SUBMIT_PROTECTED_BIT;

pub type SubmitFlagsKHR = SubmitFlags;

pub type ImageFormatConstraintsFlagsFUCHSIA = Flags;

pub type ImageConstraintsInfoFlagsFUCHSIA = Flags;
pub type ImageConstraintsInfoFlagBitsFUCHSIA = u32;
pub const IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA: u32 = 1;
pub const IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA: u32 = 2;
pub const IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA: u32 = 4;
pub const IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA: u32 = 8;
pub const IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA: u32 = 16;

pub type GraphicsPipelineLibraryFlagsEXT = Flags;
pub type GraphicsPipelineLibraryFlagBitsEXT = u32;
pub const GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT: u32 = 1;
pub const GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT: u32 = 2;
pub const GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT: u32 = 4;
pub const GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT: u32 = 8;

pub type VideoCodecOperationFlagsKHR = Flags;
pub type VideoCodecOperationFlagBitsKHR = u32;
pub const VIDEO_CODEC_OPERATION_INVALID_BIT_KHR: u32 = 0;

pub type VideoCapabilityFlagsKHR = Flags;
pub type VideoCapabilityFlagBitsKHR = u32;
pub const VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR: u32 = 1;
pub const VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR: u32 = 2;

pub type VideoSessionCreateFlagsKHR = Flags;
pub type VideoSessionCreateFlagBitsKHR = u32;
pub const VIDEO_SESSION_CREATE_DEFAULT_KHR: u32 = 0;
pub const VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR: u32 = 1;

pub type VideoBeginCodingFlagsKHR = Flags;

pub type VideoEndCodingFlagsKHR = Flags;

pub type VideoCodingQualityPresetFlagsKHR = Flags;
pub type VideoCodingQualityPresetFlagBitsKHR = u32;
pub const VIDEO_CODING_QUALITY_PRESET_NORMAL_BIT_KHR: u32 = 1;
pub const VIDEO_CODING_QUALITY_PRESET_POWER_BIT_KHR: u32 = 2;
pub const VIDEO_CODING_QUALITY_PRESET_QUALITY_BIT_KHR: u32 = 4;

pub type VideoCodingControlFlagsKHR = Flags;
pub type VideoCodingControlFlagBitsKHR = u32;
pub const VIDEO_CODING_CONTROL_DEFAULT_KHR: u32 = 0;
pub const VIDEO_CODING_CONTROL_RESET_BIT_KHR: u32 = 1;

pub type VideoDecodeCapabilityFlagsKHR = Flags;
pub type VideoDecodeCapabilityFlagBitsKHR = u32;
pub const VIDEO_DECODE_CAPABILITY_DEFAULT_KHR: u32 = 0;
pub const VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR: u32 = 1;
pub const VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR: u32 = 2;

pub type VideoDecodeFlagsKHR = Flags;
pub type VideoDecodeFlagBitsKHR = u32;
pub const VIDEO_DECODE_DEFAULT_KHR: u32 = 0;
pub const VIDEO_DECODE_RESERVED_0_BIT_KHR: u32 = 1;

pub type VideoDecodeH264PictureLayoutFlagsEXT = Flags;
pub type VideoDecodeH264PictureLayoutFlagBitsEXT = u32;
pub const VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_EXT: u32 = 0;
pub const VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_EXT: u32 = 1;
pub const VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_EXT: u32 = 2;

pub type VideoEncodeFlagsKHR = Flags;
pub type VideoEncodeFlagBitsKHR = u32;
pub const VIDEO_ENCODE_DEFAULT_KHR: u32 = 0;
pub const VIDEO_ENCODE_RESERVED_0_BIT_KHR: u32 = 1;

pub type VideoEncodeCapabilityFlagsKHR = Flags;
pub type VideoEncodeCapabilityFlagBitsKHR = u32;
pub const VIDEO_ENCODE_CAPABILITY_DEFAULT_KHR: u32 = 0;
pub const VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR: u32 = 1;

pub type VideoEncodeRateControlFlagsKHR = Flags;
pub type VideoEncodeRateControlFlagBitsKHR = u32;
pub const VIDEO_ENCODE_RATE_CONTROL_DEFAULT_KHR: u32 = 0;
pub const VIDEO_ENCODE_RATE_CONTROL_RESERVED_0_BIT_KHR: u32 = 1;

pub type VideoEncodeRateControlModeFlagsKHR = Flags;
pub type VideoEncodeRateControlModeFlagBitsKHR = u32;
pub const VIDEO_ENCODE_RATE_CONTROL_MODE_NONE_BIT_KHR: u32 = 0;
pub const VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR: u32 = 1;
pub const VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR: u32 = 2;

pub type VideoChromaSubsamplingFlagsKHR = Flags;
pub type VideoChromaSubsamplingFlagBitsKHR = u32;
pub const VIDEO_CHROMA_SUBSAMPLING_INVALID_BIT_KHR: u32 = 0;
pub const VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR: u32 = 1;
pub const VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR: u32 = 2;
pub const VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR: u32 = 4;
pub const VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR: u32 = 8;

pub type VideoComponentBitDepthFlagsKHR = Flags;
pub type VideoComponentBitDepthFlagBitsKHR = u32;
pub const VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR: u32 = 0;
pub const VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR: u32 = 1;
pub const VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR: u32 = 4;
pub const VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR: u32 = 16;

pub type VideoEncodeH264CapabilityFlagsEXT = Flags;
pub type VideoEncodeH264CapabilityFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H264_CAPABILITY_DIRECT_8X8_INFERENCE_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H264_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H264_CAPABILITY_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_BIT_EXT: u32 = 4;
pub const VIDEO_ENCODE_H264_CAPABILITY_SCALING_LISTS_BIT_EXT: u32 = 8;
pub const VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_EXT: u32 = 16;
pub const VIDEO_ENCODE_H264_CAPABILITY_CHROMA_QP_OFFSET_BIT_EXT: u32 = 32;
pub const VIDEO_ENCODE_H264_CAPABILITY_SECOND_CHROMA_QP_OFFSET_BIT_EXT: u32 = 64;
pub const VIDEO_ENCODE_H264_CAPABILITY_PIC_INIT_QP_MINUS26_BIT_EXT: u32 = 128;
pub const VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_BIT_EXT: u32 = 256;
pub const VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_EXPLICIT_BIT_EXT: u32 = 512;
pub const VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_IMPLICIT_BIT_EXT: u32 = 1024;
pub const VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT: u32 = 2048;
pub const VIDEO_ENCODE_H264_CAPABILITY_TRANSFORM_8X8_BIT_EXT: u32 = 4096;
pub const VIDEO_ENCODE_H264_CAPABILITY_CABAC_BIT_EXT: u32 = 8192;
pub const VIDEO_ENCODE_H264_CAPABILITY_CAVLC_BIT_EXT: u32 = 16384;
pub const VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_DISABLED_BIT_EXT: u32 = 32768;
pub const VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_ENABLED_BIT_EXT: u32 = 65536;
pub const VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_PARTIAL_BIT_EXT: u32 = 131072;
pub const VIDEO_ENCODE_H264_CAPABILITY_DISABLE_DIRECT_SPATIAL_MV_PRED_BIT_EXT: u32 = 262144;
pub const VIDEO_ENCODE_H264_CAPABILITY_MULTIPLE_SLICE_PER_FRAME_BIT_EXT: u32 = 524288;
pub const VIDEO_ENCODE_H264_CAPABILITY_SLICE_MB_COUNT_BIT_EXT: u32 = 1048576;
pub const VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_EXT: u32 = 2097152;
pub const VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT: u32 = 4194304;

pub type VideoEncodeH264InputModeFlagsEXT = Flags;
pub type VideoEncodeH264InputModeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H264_INPUT_MODE_FRAME_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H264_INPUT_MODE_SLICE_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H264_INPUT_MODE_NON_VCL_BIT_EXT: u32 = 4;

pub type VideoEncodeH264OutputModeFlagsEXT = Flags;
pub type VideoEncodeH264OutputModeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H264_OUTPUT_MODE_FRAME_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H264_OUTPUT_MODE_SLICE_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H264_OUTPUT_MODE_NON_VCL_BIT_EXT: u32 = 4;

pub type VideoEncodeH264RateControlStructureFlagsEXT = Flags;
pub type VideoEncodeH264RateControlStructureFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT: u32 = 0;
pub const VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_FLAT_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_DYADIC_BIT_EXT: u32 = 2;

pub type VideoEncodeH265CapabilityFlagsEXT = Flags;
pub type VideoEncodeH265CapabilityFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_CAPABILITY_SCALING_LISTS_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H265_CAPABILITY_SAMPLE_ADAPTIVE_OFFSET_ENABLED_BIT_EXT: u32 = 4;
pub const VIDEO_ENCODE_H265_CAPABILITY_PCM_ENABLE_BIT_EXT: u32 = 8;
pub const VIDEO_ENCODE_H265_CAPABILITY_SPS_TEMPORAL_MVP_ENABLED_BIT_EXT: u32 = 16;
pub const VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_EXT: u32 = 32;
pub const VIDEO_ENCODE_H265_CAPABILITY_INIT_QP_MINUS26_BIT_EXT: u32 = 64;
pub const VIDEO_ENCODE_H265_CAPABILITY_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_EXT: u32 = 128;
pub const VIDEO_ENCODE_H265_CAPABILITY_SIGN_DATA_HIDING_ENABLED_BIT_EXT: u32 = 256;
pub const VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_ENABLED_BIT_EXT: u32 = 512;
pub const VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_DISABLED_BIT_EXT: u32 = 1024;
pub const VIDEO_ENCODE_H265_CAPABILITY_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_BIT_EXT: u32 = 2048;
pub const VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_BIT_EXT: u32 = 4096;
pub const VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_BIPRED_BIT_EXT: u32 = 8192;
pub const VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT: u32 = 16384;
pub const VIDEO_ENCODE_H265_CAPABILITY_TRANSQUANT_BYPASS_ENABLED_BIT_EXT: u32 = 32768;
pub const VIDEO_ENCODE_H265_CAPABILITY_ENTROPY_CODING_SYNC_ENABLED_BIT_EXT: u32 = 65536;
pub const VIDEO_ENCODE_H265_CAPABILITY_DEBLOCKING_FILTER_OVERRIDE_ENABLED_BIT_EXT: u32 = 131072;
pub const VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_FRAME_BIT_EXT: u32 = 262144;
pub const VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_PER_TILE_BIT_EXT: u32 = 524288;
pub const VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_SLICE_BIT_EXT: u32 = 1048576;
pub const VIDEO_ENCODE_H265_CAPABILITY_SLICE_SEGMENT_CTB_COUNT_BIT_EXT: u32 = 2097152;
pub const VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_EXT: u32 = 4194304;
pub const VIDEO_ENCODE_H265_CAPABILITY_DEPENDENT_SLICE_SEGMENT_BIT_EXT: u32 = 8388608;
pub const VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT: u32 = 16777216;
pub const VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_EXT: u32 = 33554432;

pub type VideoEncodeH265InputModeFlagsEXT = Flags;
pub type VideoEncodeH265InputModeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_INPUT_MODE_FRAME_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_INPUT_MODE_SLICE_SEGMENT_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H265_INPUT_MODE_NON_VCL_BIT_EXT: u32 = 4;

pub type VideoEncodeH265OutputModeFlagsEXT = Flags;
pub type VideoEncodeH265OutputModeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_OUTPUT_MODE_FRAME_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_OUTPUT_MODE_SLICE_SEGMENT_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H265_OUTPUT_MODE_NON_VCL_BIT_EXT: u32 = 4;

pub type VideoEncodeH265RateControlStructureFlagsEXT = Flags;
pub type VideoEncodeH265RateControlStructureFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT: u32 = 0;
pub const VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_FLAT_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_DYADIC_BIT_EXT: u32 = 2;

pub type VideoEncodeH265CtbSizeFlagsEXT = Flags;
pub type VideoEncodeH265CtbSizeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_EXT: u32 = 4;

pub type VideoEncodeH265TransformBlockSizeFlagsEXT = Flags;
pub type VideoEncodeH265TransformBlockSizeFlagBitsEXT = u32;
pub const VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_EXT: u32 = 1;
pub const VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_EXT: u32 = 2;
pub const VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_EXT: u32 = 4;
pub const VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_EXT: u32 = 8;


// enums

pub type ImageLayout = i32;
pub const IMAGE_LAYOUT_UNDEFINED: i32 = 0; // Implicit layout an image is when its contents are undefined due to various reasons (e.g. right after creation)
pub const IMAGE_LAYOUT_GENERAL: i32 = 1; // General layout when image can be used for any kind of access
pub const IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL: i32 = 2; // Optimal layout when image is only used for color attachment read/write
pub const IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL: i32 = 3; // Optimal layout when image is only used for depth/stencil attachment read/write
pub const IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL: i32 = 4; // Optimal layout when image is used for read only depth/stencil attachment and shader access
pub const IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL: i32 = 5; // Optimal layout when image is used for read only shader access
pub const IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL: i32 = 6; // Optimal layout when image is used only as source of transfer operations
pub const IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL: i32 = 7; // Optimal layout when image is used only as destination of transfer operations
pub const IMAGE_LAYOUT_PREINITIALIZED: i32 = 8; // Initial layout used when the data is populated by the CPU
pub const IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL: i32 = 1000117000;
pub const IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL: i32 = 1000117001;
pub const IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL: i32 = 1000241000;
pub const IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL: i32 = 1000241001;
pub const IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL: i32 = 1000241002;
pub const IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL: i32 = 1000241003;
pub const IMAGE_LAYOUT_READ_ONLY_OPTIMAL: i32 = 1000314000;
pub const IMAGE_LAYOUT_ATTACHMENT_OPTIMAL: i32 = 1000314001;
pub const IMAGE_LAYOUT_PRESENT_SRC_KHR: i32 = 1000001002;
pub const IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR: i32 = 1000024000;
pub const IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR: i32 = 1000024001;
pub const IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR: i32 = 1000024002;
pub const IMAGE_LAYOUT_SHARED_PRESENT_KHR: i32 = 1000111000;
pub const IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL;
pub const IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL;
pub const IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV: i32 = IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR;
pub const IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT: i32 = 1000218000;
pub const IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR: i32 = 1000164003;
pub const IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL;
pub const IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL;
pub const IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL;
pub const IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL;
pub const IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR: i32 = 1000299000;
pub const IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR: i32 = 1000299001;
pub const IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR: i32 = 1000299002;
pub const IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_READ_ONLY_OPTIMAL;
pub const IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR: i32 = IMAGE_LAYOUT_ATTACHMENT_OPTIMAL;

pub type AttachmentLoadOp = i32;
pub const ATTACHMENT_LOAD_OP_LOAD: i32 = 0;
pub const ATTACHMENT_LOAD_OP_CLEAR: i32 = 1;
pub const ATTACHMENT_LOAD_OP_DONT_CARE: i32 = 2;
pub const ATTACHMENT_LOAD_OP_NONE_EXT: i32 = 1000400000;

pub type AttachmentStoreOp = i32;
pub const ATTACHMENT_STORE_OP_STORE: i32 = 0;
pub const ATTACHMENT_STORE_OP_DONT_CARE: i32 = 1;
pub const ATTACHMENT_STORE_OP_NONE: i32 = 1000301000;
pub const ATTACHMENT_STORE_OP_NONE_KHR: i32 = ATTACHMENT_STORE_OP_NONE;
pub const ATTACHMENT_STORE_OP_NONE_QCOM: i32 = ATTACHMENT_STORE_OP_NONE;
pub const ATTACHMENT_STORE_OP_NONE_EXT: i32 = ATTACHMENT_STORE_OP_NONE;

pub type ImageType = i32;
pub const IMAGE_TYPE_1D: i32 = 0;
pub const IMAGE_TYPE_2D: i32 = 1;
pub const IMAGE_TYPE_3D: i32 = 2;

pub type ImageTiling = i32;
pub const IMAGE_TILING_OPTIMAL: i32 = 0;
pub const IMAGE_TILING_LINEAR: i32 = 1;
pub const IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT: i32 = 1000158000;

pub type ImageViewType = i32;
pub const IMAGE_VIEW_TYPE_1D: i32 = 0;
pub const IMAGE_VIEW_TYPE_2D: i32 = 1;
pub const IMAGE_VIEW_TYPE_3D: i32 = 2;
pub const IMAGE_VIEW_TYPE_CUBE: i32 = 3;
pub const IMAGE_VIEW_TYPE_1D_ARRAY: i32 = 4;
pub const IMAGE_VIEW_TYPE_2D_ARRAY: i32 = 5;
pub const IMAGE_VIEW_TYPE_CUBE_ARRAY: i32 = 6;

pub type CommandBufferLevel = i32;
pub const COMMAND_BUFFER_LEVEL_PRIMARY: i32 = 0;
pub const COMMAND_BUFFER_LEVEL_SECONDARY: i32 = 1;

pub type ComponentSwizzle = i32;
pub const COMPONENT_SWIZZLE_IDENTITY: i32 = 0;
pub const COMPONENT_SWIZZLE_ZERO: i32 = 1;
pub const COMPONENT_SWIZZLE_ONE: i32 = 2;
pub const COMPONENT_SWIZZLE_R: i32 = 3;
pub const COMPONENT_SWIZZLE_G: i32 = 4;
pub const COMPONENT_SWIZZLE_B: i32 = 5;
pub const COMPONENT_SWIZZLE_A: i32 = 6;

pub type DescriptorType = i32;
pub const DESCRIPTOR_TYPE_SAMPLER: i32 = 0;
pub const DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER: i32 = 1;
pub const DESCRIPTOR_TYPE_SAMPLED_IMAGE: i32 = 2;
pub const DESCRIPTOR_TYPE_STORAGE_IMAGE: i32 = 3;
pub const DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER: i32 = 4;
pub const DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER: i32 = 5;
pub const DESCRIPTOR_TYPE_UNIFORM_BUFFER: i32 = 6;
pub const DESCRIPTOR_TYPE_STORAGE_BUFFER: i32 = 7;
pub const DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC: i32 = 8;
pub const DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC: i32 = 9;
pub const DESCRIPTOR_TYPE_INPUT_ATTACHMENT: i32 = 10;
pub const DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK: i32 = 1000138000;
pub const DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT: i32 = DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK;
pub const DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR: i32 = 1000150000;
pub const DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV: i32 = 1000165000;
pub const DESCRIPTOR_TYPE_MUTABLE_VALVE: i32 = 1000351000;

pub type QueryType = i32;
pub const QUERY_TYPE_OCCLUSION: i32 = 0;
pub const QUERY_TYPE_PIPELINE_STATISTICS: i32 = 1; // Optional
pub const QUERY_TYPE_TIMESTAMP: i32 = 2;
pub const QUERY_TYPE_RESULT_STATUS_ONLY_KHR: i32 = 1000023000;
pub const QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT: i32 = 1000028004;
pub const QUERY_TYPE_PERFORMANCE_QUERY_KHR: i32 = 1000116000;
pub const QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR: i32 = 1000150000;
pub const QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR: i32 = 1000150001;
pub const QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV: i32 = 1000165000;
pub const QUERY_TYPE_PERFORMANCE_QUERY_INTEL: i32 = 1000210000;
pub const QUERY_TYPE_VIDEO_ENCODE_BITSTREAM_BUFFER_RANGE_KHR: i32 = 1000299000;
pub const QUERY_TYPE_PRIMITIVES_GENERATED_EXT: i32 = 1000382000;

pub type BorderColor = i32;
pub const BORDER_COLOR_FLOAT_TRANSPARENT_BLACK: i32 = 0;
pub const BORDER_COLOR_INT_TRANSPARENT_BLACK: i32 = 1;
pub const BORDER_COLOR_FLOAT_OPAQUE_BLACK: i32 = 2;
pub const BORDER_COLOR_INT_OPAQUE_BLACK: i32 = 3;
pub const BORDER_COLOR_FLOAT_OPAQUE_WHITE: i32 = 4;
pub const BORDER_COLOR_INT_OPAQUE_WHITE: i32 = 5;
pub const BORDER_COLOR_FLOAT_CUSTOM_EXT: i32 = 1000287003;
pub const BORDER_COLOR_INT_CUSTOM_EXT: i32 = 1000287004;

pub type PipelineBindPoint = i32;
pub const PIPELINE_BIND_POINT_GRAPHICS: i32 = 0;
pub const PIPELINE_BIND_POINT_COMPUTE: i32 = 1;
pub const PIPELINE_BIND_POINT_RAY_TRACING_KHR: i32 = 1000165000;
pub const PIPELINE_BIND_POINT_RAY_TRACING_NV: i32 = PIPELINE_BIND_POINT_RAY_TRACING_KHR;
pub const PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI: i32 = 1000369003;

pub type PipelineCacheHeaderVersion = i32;
pub const PIPELINE_CACHE_HEADER_VERSION_ONE: i32 = 1;

pub type PrimitiveTopology = i32;
pub const PRIMITIVE_TOPOLOGY_POINT_LIST: i32 = 0;
pub const PRIMITIVE_TOPOLOGY_LINE_LIST: i32 = 1;
pub const PRIMITIVE_TOPOLOGY_LINE_STRIP: i32 = 2;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_LIST: i32 = 3;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP: i32 = 4;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_FAN: i32 = 5;
pub const PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY: i32 = 6;
pub const PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY: i32 = 7;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY: i32 = 8;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY: i32 = 9;
pub const PRIMITIVE_TOPOLOGY_PATCH_LIST: i32 = 10;

pub type SharingMode = i32;
pub const SHARING_MODE_EXCLUSIVE: i32 = 0;
pub const SHARING_MODE_CONCURRENT: i32 = 1;

pub type IndexType = i32;
pub const INDEX_TYPE_UINT16: i32 = 0;
pub const INDEX_TYPE_UINT32: i32 = 1;
pub const INDEX_TYPE_NONE_KHR: i32 = 1000165000;
pub const INDEX_TYPE_NONE_NV: i32 = INDEX_TYPE_NONE_KHR;
pub const INDEX_TYPE_UINT8_EXT: i32 = 1000265000;

pub type Filter = i32;
pub const FILTER_NEAREST: i32 = 0;
pub const FILTER_LINEAR: i32 = 1;
pub const FILTER_CUBIC_IMG: i32 = 1000015000;
pub const FILTER_CUBIC_EXT: i32 = FILTER_CUBIC_IMG;

pub type SamplerMipmapMode = i32;
pub const SAMPLER_MIPMAP_MODE_NEAREST: i32 = 0; // Choose nearest mip level
pub const SAMPLER_MIPMAP_MODE_LINEAR: i32 = 1; // Linear filter between mip levels

pub type SamplerAddressMode = i32;
pub const SAMPLER_ADDRESS_MODE_REPEAT: i32 = 0;
pub const SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT: i32 = 1;
pub const SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE: i32 = 2;
pub const SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER: i32 = 3;
pub const SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE: i32 = 4; // No need to add an extnumber attribute, since this uses a core enum value
pub const SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR: i32 = SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE; // Alias introduced for consistency with extension suffixing rules

pub type CompareOp = i32;
pub const COMPARE_OP_NEVER: i32 = 0;
pub const COMPARE_OP_LESS: i32 = 1;
pub const COMPARE_OP_EQUAL: i32 = 2;
pub const COMPARE_OP_LESS_OR_EQUAL: i32 = 3;
pub const COMPARE_OP_GREATER: i32 = 4;
pub const COMPARE_OP_NOT_EQUAL: i32 = 5;
pub const COMPARE_OP_GREATER_OR_EQUAL: i32 = 6;
pub const COMPARE_OP_ALWAYS: i32 = 7;

pub type PolygonMode = i32;
pub const POLYGON_MODE_FILL: i32 = 0;
pub const POLYGON_MODE_LINE: i32 = 1;
pub const POLYGON_MODE_POINT: i32 = 2;
pub const POLYGON_MODE_FILL_RECTANGLE_NV: i32 = 1000153000;

pub type FrontFace = i32;
pub const FRONT_FACE_COUNTER_CLOCKWISE: i32 = 0;
pub const FRONT_FACE_CLOCKWISE: i32 = 1;

pub type BlendFactor = i32;
pub const BLEND_FACTOR_ZERO: i32 = 0;
pub const BLEND_FACTOR_ONE: i32 = 1;
pub const BLEND_FACTOR_SRC_COLOR: i32 = 2;
pub const BLEND_FACTOR_ONE_MINUS_SRC_COLOR: i32 = 3;
pub const BLEND_FACTOR_DST_COLOR: i32 = 4;
pub const BLEND_FACTOR_ONE_MINUS_DST_COLOR: i32 = 5;
pub const BLEND_FACTOR_SRC_ALPHA: i32 = 6;
pub const BLEND_FACTOR_ONE_MINUS_SRC_ALPHA: i32 = 7;
pub const BLEND_FACTOR_DST_ALPHA: i32 = 8;
pub const BLEND_FACTOR_ONE_MINUS_DST_ALPHA: i32 = 9;
pub const BLEND_FACTOR_CONSTANT_COLOR: i32 = 10;
pub const BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR: i32 = 11;
pub const BLEND_FACTOR_CONSTANT_ALPHA: i32 = 12;
pub const BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA: i32 = 13;
pub const BLEND_FACTOR_SRC_ALPHA_SATURATE: i32 = 14;
pub const BLEND_FACTOR_SRC1_COLOR: i32 = 15;
pub const BLEND_FACTOR_ONE_MINUS_SRC1_COLOR: i32 = 16;
pub const BLEND_FACTOR_SRC1_ALPHA: i32 = 17;
pub const BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA: i32 = 18;

pub type BlendOp = i32;
pub const BLEND_OP_ADD: i32 = 0;
pub const BLEND_OP_SUBTRACT: i32 = 1;
pub const BLEND_OP_REVERSE_SUBTRACT: i32 = 2;
pub const BLEND_OP_MIN: i32 = 3;
pub const BLEND_OP_MAX: i32 = 4;
pub const BLEND_OP_ZERO_EXT: i32 = 1000148000;
pub const BLEND_OP_SRC_EXT: i32 = 1000148001;
pub const BLEND_OP_DST_EXT: i32 = 1000148002;
pub const BLEND_OP_SRC_OVER_EXT: i32 = 1000148003;
pub const BLEND_OP_DST_OVER_EXT: i32 = 1000148004;
pub const BLEND_OP_SRC_IN_EXT: i32 = 1000148005;
pub const BLEND_OP_DST_IN_EXT: i32 = 1000148006;
pub const BLEND_OP_SRC_OUT_EXT: i32 = 1000148007;
pub const BLEND_OP_DST_OUT_EXT: i32 = 1000148008;
pub const BLEND_OP_SRC_ATOP_EXT: i32 = 1000148009;
pub const BLEND_OP_DST_ATOP_EXT: i32 = 1000148010;
pub const BLEND_OP_XOR_EXT: i32 = 1000148011;
pub const BLEND_OP_MULTIPLY_EXT: i32 = 1000148012;
pub const BLEND_OP_SCREEN_EXT: i32 = 1000148013;
pub const BLEND_OP_OVERLAY_EXT: i32 = 1000148014;
pub const BLEND_OP_DARKEN_EXT: i32 = 1000148015;
pub const BLEND_OP_LIGHTEN_EXT: i32 = 1000148016;
pub const BLEND_OP_COLORDODGE_EXT: i32 = 1000148017;
pub const BLEND_OP_COLORBURN_EXT: i32 = 1000148018;
pub const BLEND_OP_HARDLIGHT_EXT: i32 = 1000148019;
pub const BLEND_OP_SOFTLIGHT_EXT: i32 = 1000148020;
pub const BLEND_OP_DIFFERENCE_EXT: i32 = 1000148021;
pub const BLEND_OP_EXCLUSION_EXT: i32 = 1000148022;
pub const BLEND_OP_INVERT_EXT: i32 = 1000148023;
pub const BLEND_OP_INVERT_RGB_EXT: i32 = 1000148024;
pub const BLEND_OP_LINEARDODGE_EXT: i32 = 1000148025;
pub const BLEND_OP_LINEARBURN_EXT: i32 = 1000148026;
pub const BLEND_OP_VIVIDLIGHT_EXT: i32 = 1000148027;
pub const BLEND_OP_LINEARLIGHT_EXT: i32 = 1000148028;
pub const BLEND_OP_PINLIGHT_EXT: i32 = 1000148029;
pub const BLEND_OP_HARDMIX_EXT: i32 = 1000148030;
pub const BLEND_OP_HSL_HUE_EXT: i32 = 1000148031;
pub const BLEND_OP_HSL_SATURATION_EXT: i32 = 1000148032;
pub const BLEND_OP_HSL_COLOR_EXT: i32 = 1000148033;
pub const BLEND_OP_HSL_LUMINOSITY_EXT: i32 = 1000148034;
pub const BLEND_OP_PLUS_EXT: i32 = 1000148035;
pub const BLEND_OP_PLUS_CLAMPED_EXT: i32 = 1000148036;
pub const BLEND_OP_PLUS_CLAMPED_ALPHA_EXT: i32 = 1000148037;
pub const BLEND_OP_PLUS_DARKER_EXT: i32 = 1000148038;
pub const BLEND_OP_MINUS_EXT: i32 = 1000148039;
pub const BLEND_OP_MINUS_CLAMPED_EXT: i32 = 1000148040;
pub const BLEND_OP_CONTRAST_EXT: i32 = 1000148041;
pub const BLEND_OP_INVERT_OVG_EXT: i32 = 1000148042;
pub const BLEND_OP_RED_EXT: i32 = 1000148043;
pub const BLEND_OP_GREEN_EXT: i32 = 1000148044;
pub const BLEND_OP_BLUE_EXT: i32 = 1000148045;

pub type StencilOp = i32;
pub const STENCIL_OP_KEEP: i32 = 0;
pub const STENCIL_OP_ZERO: i32 = 1;
pub const STENCIL_OP_REPLACE: i32 = 2;
pub const STENCIL_OP_INCREMENT_AND_CLAMP: i32 = 3;
pub const STENCIL_OP_DECREMENT_AND_CLAMP: i32 = 4;
pub const STENCIL_OP_INVERT: i32 = 5;
pub const STENCIL_OP_INCREMENT_AND_WRAP: i32 = 6;
pub const STENCIL_OP_DECREMENT_AND_WRAP: i32 = 7;

pub type LogicOp = i32;
pub const LOGIC_OP_CLEAR: i32 = 0;
pub const LOGIC_OP_AND: i32 = 1;
pub const LOGIC_OP_AND_REVERSE: i32 = 2;
pub const LOGIC_OP_COPY: i32 = 3;
pub const LOGIC_OP_AND_INVERTED: i32 = 4;
pub const LOGIC_OP_NO_OP: i32 = 5;
pub const LOGIC_OP_XOR: i32 = 6;
pub const LOGIC_OP_OR: i32 = 7;
pub const LOGIC_OP_NOR: i32 = 8;
pub const LOGIC_OP_EQUIVALENT: i32 = 9;
pub const LOGIC_OP_INVERT: i32 = 10;
pub const LOGIC_OP_OR_REVERSE: i32 = 11;
pub const LOGIC_OP_COPY_INVERTED: i32 = 12;
pub const LOGIC_OP_OR_INVERTED: i32 = 13;
pub const LOGIC_OP_NAND: i32 = 14;
pub const LOGIC_OP_SET: i32 = 15;

pub type InternalAllocationType = i32;
pub const INTERNAL_ALLOCATION_TYPE_EXECUTABLE: i32 = 0;

pub type SystemAllocationScope = i32;
pub const SYSTEM_ALLOCATION_SCOPE_COMMAND: i32 = 0;
pub const SYSTEM_ALLOCATION_SCOPE_OBJECT: i32 = 1;
pub const SYSTEM_ALLOCATION_SCOPE_CACHE: i32 = 2;
pub const SYSTEM_ALLOCATION_SCOPE_DEVICE: i32 = 3;
pub const SYSTEM_ALLOCATION_SCOPE_INSTANCE: i32 = 4;

pub type PhysicalDeviceType = i32;
pub const PHYSICAL_DEVICE_TYPE_OTHER: i32 = 0;
pub const PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU: i32 = 1;
pub const PHYSICAL_DEVICE_TYPE_DISCRETE_GPU: i32 = 2;
pub const PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU: i32 = 3;
pub const PHYSICAL_DEVICE_TYPE_CPU: i32 = 4;

pub type VertexInputRate = i32;
pub const VERTEX_INPUT_RATE_VERTEX: i32 = 0;
pub const VERTEX_INPUT_RATE_INSTANCE: i32 = 1;

// Vulkan format definitions
pub type Format = i32;
pub const FORMAT_UNDEFINED: i32 = 0;
pub const FORMAT_R4G4_UNORM_PACK8: i32 = 1;
pub const FORMAT_R4G4B4A4_UNORM_PACK16: i32 = 2;
pub const FORMAT_B4G4R4A4_UNORM_PACK16: i32 = 3;
pub const FORMAT_R5G6B5_UNORM_PACK16: i32 = 4;
pub const FORMAT_B5G6R5_UNORM_PACK16: i32 = 5;
pub const FORMAT_R5G5B5A1_UNORM_PACK16: i32 = 6;
pub const FORMAT_B5G5R5A1_UNORM_PACK16: i32 = 7;
pub const FORMAT_A1R5G5B5_UNORM_PACK16: i32 = 8;
pub const FORMAT_R8_UNORM: i32 = 9;
pub const FORMAT_R8_SNORM: i32 = 10;
pub const FORMAT_R8_USCALED: i32 = 11;
pub const FORMAT_R8_SSCALED: i32 = 12;
pub const FORMAT_R8_UINT: i32 = 13;
pub const FORMAT_R8_SINT: i32 = 14;
pub const FORMAT_R8_SRGB: i32 = 15;
pub const FORMAT_R8G8_UNORM: i32 = 16;
pub const FORMAT_R8G8_SNORM: i32 = 17;
pub const FORMAT_R8G8_USCALED: i32 = 18;
pub const FORMAT_R8G8_SSCALED: i32 = 19;
pub const FORMAT_R8G8_UINT: i32 = 20;
pub const FORMAT_R8G8_SINT: i32 = 21;
pub const FORMAT_R8G8_SRGB: i32 = 22;
pub const FORMAT_R8G8B8_UNORM: i32 = 23;
pub const FORMAT_R8G8B8_SNORM: i32 = 24;
pub const FORMAT_R8G8B8_USCALED: i32 = 25;
pub const FORMAT_R8G8B8_SSCALED: i32 = 26;
pub const FORMAT_R8G8B8_UINT: i32 = 27;
pub const FORMAT_R8G8B8_SINT: i32 = 28;
pub const FORMAT_R8G8B8_SRGB: i32 = 29;
pub const FORMAT_B8G8R8_UNORM: i32 = 30;
pub const FORMAT_B8G8R8_SNORM: i32 = 31;
pub const FORMAT_B8G8R8_USCALED: i32 = 32;
pub const FORMAT_B8G8R8_SSCALED: i32 = 33;
pub const FORMAT_B8G8R8_UINT: i32 = 34;
pub const FORMAT_B8G8R8_SINT: i32 = 35;
pub const FORMAT_B8G8R8_SRGB: i32 = 36;
pub const FORMAT_R8G8B8A8_UNORM: i32 = 37;
pub const FORMAT_R8G8B8A8_SNORM: i32 = 38;
pub const FORMAT_R8G8B8A8_USCALED: i32 = 39;
pub const FORMAT_R8G8B8A8_SSCALED: i32 = 40;
pub const FORMAT_R8G8B8A8_UINT: i32 = 41;
pub const FORMAT_R8G8B8A8_SINT: i32 = 42;
pub const FORMAT_R8G8B8A8_SRGB: i32 = 43;
pub const FORMAT_B8G8R8A8_UNORM: i32 = 44;
pub const FORMAT_B8G8R8A8_SNORM: i32 = 45;
pub const FORMAT_B8G8R8A8_USCALED: i32 = 46;
pub const FORMAT_B8G8R8A8_SSCALED: i32 = 47;
pub const FORMAT_B8G8R8A8_UINT: i32 = 48;
pub const FORMAT_B8G8R8A8_SINT: i32 = 49;
pub const FORMAT_B8G8R8A8_SRGB: i32 = 50;
pub const FORMAT_A8B8G8R8_UNORM_PACK32: i32 = 51;
pub const FORMAT_A8B8G8R8_SNORM_PACK32: i32 = 52;
pub const FORMAT_A8B8G8R8_USCALED_PACK32: i32 = 53;
pub const FORMAT_A8B8G8R8_SSCALED_PACK32: i32 = 54;
pub const FORMAT_A8B8G8R8_UINT_PACK32: i32 = 55;
pub const FORMAT_A8B8G8R8_SINT_PACK32: i32 = 56;
pub const FORMAT_A8B8G8R8_SRGB_PACK32: i32 = 57;
pub const FORMAT_A2R10G10B10_UNORM_PACK32: i32 = 58;
pub const FORMAT_A2R10G10B10_SNORM_PACK32: i32 = 59;
pub const FORMAT_A2R10G10B10_USCALED_PACK32: i32 = 60;
pub const FORMAT_A2R10G10B10_SSCALED_PACK32: i32 = 61;
pub const FORMAT_A2R10G10B10_UINT_PACK32: i32 = 62;
pub const FORMAT_A2R10G10B10_SINT_PACK32: i32 = 63;
pub const FORMAT_A2B10G10R10_UNORM_PACK32: i32 = 64;
pub const FORMAT_A2B10G10R10_SNORM_PACK32: i32 = 65;
pub const FORMAT_A2B10G10R10_USCALED_PACK32: i32 = 66;
pub const FORMAT_A2B10G10R10_SSCALED_PACK32: i32 = 67;
pub const FORMAT_A2B10G10R10_UINT_PACK32: i32 = 68;
pub const FORMAT_A2B10G10R10_SINT_PACK32: i32 = 69;
pub const FORMAT_R16_UNORM: i32 = 70;
pub const FORMAT_R16_SNORM: i32 = 71;
pub const FORMAT_R16_USCALED: i32 = 72;
pub const FORMAT_R16_SSCALED: i32 = 73;
pub const FORMAT_R16_UINT: i32 = 74;
pub const FORMAT_R16_SINT: i32 = 75;
pub const FORMAT_R16_SFLOAT: i32 = 76;
pub const FORMAT_R16G16_UNORM: i32 = 77;
pub const FORMAT_R16G16_SNORM: i32 = 78;
pub const FORMAT_R16G16_USCALED: i32 = 79;
pub const FORMAT_R16G16_SSCALED: i32 = 80;
pub const FORMAT_R16G16_UINT: i32 = 81;
pub const FORMAT_R16G16_SINT: i32 = 82;
pub const FORMAT_R16G16_SFLOAT: i32 = 83;
pub const FORMAT_R16G16B16_UNORM: i32 = 84;
pub const FORMAT_R16G16B16_SNORM: i32 = 85;
pub const FORMAT_R16G16B16_USCALED: i32 = 86;
pub const FORMAT_R16G16B16_SSCALED: i32 = 87;
pub const FORMAT_R16G16B16_UINT: i32 = 88;
pub const FORMAT_R16G16B16_SINT: i32 = 89;
pub const FORMAT_R16G16B16_SFLOAT: i32 = 90;
pub const FORMAT_R16G16B16A16_UNORM: i32 = 91;
pub const FORMAT_R16G16B16A16_SNORM: i32 = 92;
pub const FORMAT_R16G16B16A16_USCALED: i32 = 93;
pub const FORMAT_R16G16B16A16_SSCALED: i32 = 94;
pub const FORMAT_R16G16B16A16_UINT: i32 = 95;
pub const FORMAT_R16G16B16A16_SINT: i32 = 96;
pub const FORMAT_R16G16B16A16_SFLOAT: i32 = 97;
pub const FORMAT_R32_UINT: i32 = 98;
pub const FORMAT_R32_SINT: i32 = 99;
pub const FORMAT_R32_SFLOAT: i32 = 100;
pub const FORMAT_R32G32_UINT: i32 = 101;
pub const FORMAT_R32G32_SINT: i32 = 102;
pub const FORMAT_R32G32_SFLOAT: i32 = 103;
pub const FORMAT_R32G32B32_UINT: i32 = 104;
pub const FORMAT_R32G32B32_SINT: i32 = 105;
pub const FORMAT_R32G32B32_SFLOAT: i32 = 106;
pub const FORMAT_R32G32B32A32_UINT: i32 = 107;
pub const FORMAT_R32G32B32A32_SINT: i32 = 108;
pub const FORMAT_R32G32B32A32_SFLOAT: i32 = 109;
pub const FORMAT_R64_UINT: i32 = 110;
pub const FORMAT_R64_SINT: i32 = 111;
pub const FORMAT_R64_SFLOAT: i32 = 112;
pub const FORMAT_R64G64_UINT: i32 = 113;
pub const FORMAT_R64G64_SINT: i32 = 114;
pub const FORMAT_R64G64_SFLOAT: i32 = 115;
pub const FORMAT_R64G64B64_UINT: i32 = 116;
pub const FORMAT_R64G64B64_SINT: i32 = 117;
pub const FORMAT_R64G64B64_SFLOAT: i32 = 118;
pub const FORMAT_R64G64B64A64_UINT: i32 = 119;
pub const FORMAT_R64G64B64A64_SINT: i32 = 120;
pub const FORMAT_R64G64B64A64_SFLOAT: i32 = 121;
pub const FORMAT_B10G11R11_UFLOAT_PACK32: i32 = 122;
pub const FORMAT_E5B9G9R9_UFLOAT_PACK32: i32 = 123;
pub const FORMAT_D16_UNORM: i32 = 124;
pub const FORMAT_X8_D24_UNORM_PACK32: i32 = 125;
pub const FORMAT_D32_SFLOAT: i32 = 126;
pub const FORMAT_S8_UINT: i32 = 127;
pub const FORMAT_D16_UNORM_S8_UINT: i32 = 128;
pub const FORMAT_D24_UNORM_S8_UINT: i32 = 129;
pub const FORMAT_D32_SFLOAT_S8_UINT: i32 = 130;
pub const FORMAT_BC1_RGB_UNORM_BLOCK: i32 = 131;
pub const FORMAT_BC1_RGB_SRGB_BLOCK: i32 = 132;
pub const FORMAT_BC1_RGBA_UNORM_BLOCK: i32 = 133;
pub const FORMAT_BC1_RGBA_SRGB_BLOCK: i32 = 134;
pub const FORMAT_BC2_UNORM_BLOCK: i32 = 135;
pub const FORMAT_BC2_SRGB_BLOCK: i32 = 136;
pub const FORMAT_BC3_UNORM_BLOCK: i32 = 137;
pub const FORMAT_BC3_SRGB_BLOCK: i32 = 138;
pub const FORMAT_BC4_UNORM_BLOCK: i32 = 139;
pub const FORMAT_BC4_SNORM_BLOCK: i32 = 140;
pub const FORMAT_BC5_UNORM_BLOCK: i32 = 141;
pub const FORMAT_BC5_SNORM_BLOCK: i32 = 142;
pub const FORMAT_BC6H_UFLOAT_BLOCK: i32 = 143;
pub const FORMAT_BC6H_SFLOAT_BLOCK: i32 = 144;
pub const FORMAT_BC7_UNORM_BLOCK: i32 = 145;
pub const FORMAT_BC7_SRGB_BLOCK: i32 = 146;
pub const FORMAT_ETC2_R8G8B8_UNORM_BLOCK: i32 = 147;
pub const FORMAT_ETC2_R8G8B8_SRGB_BLOCK: i32 = 148;
pub const FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: i32 = 149;
pub const FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: i32 = 150;
pub const FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: i32 = 151;
pub const FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: i32 = 152;
pub const FORMAT_EAC_R11_UNORM_BLOCK: i32 = 153;
pub const FORMAT_EAC_R11_SNORM_BLOCK: i32 = 154;
pub const FORMAT_EAC_R11G11_UNORM_BLOCK: i32 = 155;
pub const FORMAT_EAC_R11G11_SNORM_BLOCK: i32 = 156;
pub const FORMAT_ASTC_4x4_UNORM_BLOCK: i32 = 157;
pub const FORMAT_ASTC_4x4_SRGB_BLOCK: i32 = 158;
pub const FORMAT_ASTC_5x4_UNORM_BLOCK: i32 = 159;
pub const FORMAT_ASTC_5x4_SRGB_BLOCK: i32 = 160;
pub const FORMAT_ASTC_5x5_UNORM_BLOCK: i32 = 161;
pub const FORMAT_ASTC_5x5_SRGB_BLOCK: i32 = 162;
pub const FORMAT_ASTC_6x5_UNORM_BLOCK: i32 = 163;
pub const FORMAT_ASTC_6x5_SRGB_BLOCK: i32 = 164;
pub const FORMAT_ASTC_6x6_UNORM_BLOCK: i32 = 165;
pub const FORMAT_ASTC_6x6_SRGB_BLOCK: i32 = 166;
pub const FORMAT_ASTC_8x5_UNORM_BLOCK: i32 = 167;
pub const FORMAT_ASTC_8x5_SRGB_BLOCK: i32 = 168;
pub const FORMAT_ASTC_8x6_UNORM_BLOCK: i32 = 169;
pub const FORMAT_ASTC_8x6_SRGB_BLOCK: i32 = 170;
pub const FORMAT_ASTC_8x8_UNORM_BLOCK: i32 = 171;
pub const FORMAT_ASTC_8x8_SRGB_BLOCK: i32 = 172;
pub const FORMAT_ASTC_10x5_UNORM_BLOCK: i32 = 173;
pub const FORMAT_ASTC_10x5_SRGB_BLOCK: i32 = 174;
pub const FORMAT_ASTC_10x6_UNORM_BLOCK: i32 = 175;
pub const FORMAT_ASTC_10x6_SRGB_BLOCK: i32 = 176;
pub const FORMAT_ASTC_10x8_UNORM_BLOCK: i32 = 177;
pub const FORMAT_ASTC_10x8_SRGB_BLOCK: i32 = 178;
pub const FORMAT_ASTC_10x10_UNORM_BLOCK: i32 = 179;
pub const FORMAT_ASTC_10x10_SRGB_BLOCK: i32 = 180;
pub const FORMAT_ASTC_12x10_UNORM_BLOCK: i32 = 181;
pub const FORMAT_ASTC_12x10_SRGB_BLOCK: i32 = 182;
pub const FORMAT_ASTC_12x12_UNORM_BLOCK: i32 = 183;
pub const FORMAT_ASTC_12x12_SRGB_BLOCK: i32 = 184;
pub const FORMAT_G8B8G8R8_422_UNORM: i32 = 1000156000;
pub const FORMAT_B8G8R8G8_422_UNORM: i32 = 1000156001;
pub const FORMAT_G8_B8_R8_3PLANE_420_UNORM: i32 = 1000156002;
pub const FORMAT_G8_B8R8_2PLANE_420_UNORM: i32 = 1000156003;
pub const FORMAT_G8_B8_R8_3PLANE_422_UNORM: i32 = 1000156004;
pub const FORMAT_G8_B8R8_2PLANE_422_UNORM: i32 = 1000156005;
pub const FORMAT_G8_B8_R8_3PLANE_444_UNORM: i32 = 1000156006;
pub const FORMAT_R10X6_UNORM_PACK16: i32 = 1000156007;
pub const FORMAT_R10X6G10X6_UNORM_2PACK16: i32 = 1000156008;
pub const FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: i32 = 1000156009;
pub const FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: i32 = 1000156010;
pub const FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: i32 = 1000156011;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: i32 = 1000156012;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: i32 = 1000156013;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: i32 = 1000156014;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: i32 = 1000156015;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: i32 = 1000156016;
pub const FORMAT_R12X4_UNORM_PACK16: i32 = 1000156017;
pub const FORMAT_R12X4G12X4_UNORM_2PACK16: i32 = 1000156018;
pub const FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: i32 = 1000156019;
pub const FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: i32 = 1000156020;
pub const FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: i32 = 1000156021;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: i32 = 1000156022;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: i32 = 1000156023;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: i32 = 1000156024;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: i32 = 1000156025;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: i32 = 1000156026;
pub const FORMAT_G16B16G16R16_422_UNORM: i32 = 1000156027;
pub const FORMAT_B16G16R16G16_422_UNORM: i32 = 1000156028;
pub const FORMAT_G16_B16_R16_3PLANE_420_UNORM: i32 = 1000156029;
pub const FORMAT_G16_B16R16_2PLANE_420_UNORM: i32 = 1000156030;
pub const FORMAT_G16_B16_R16_3PLANE_422_UNORM: i32 = 1000156031;
pub const FORMAT_G16_B16R16_2PLANE_422_UNORM: i32 = 1000156032;
pub const FORMAT_G16_B16_R16_3PLANE_444_UNORM: i32 = 1000156033;
pub const FORMAT_G8_B8R8_2PLANE_444_UNORM: i32 = 1000330000;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16: i32 = 1000330001;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16: i32 = 1000330002;
pub const FORMAT_G16_B16R16_2PLANE_444_UNORM: i32 = 1000330003;
pub const FORMAT_A4R4G4B4_UNORM_PACK16: i32 = 1000340000;
pub const FORMAT_A4B4G4R4_UNORM_PACK16: i32 = 1000340001;
pub const FORMAT_ASTC_4x4_SFLOAT_BLOCK: i32 = 1000066000;
pub const FORMAT_ASTC_5x4_SFLOAT_BLOCK: i32 = 1000066001;
pub const FORMAT_ASTC_5x5_SFLOAT_BLOCK: i32 = 1000066002;
pub const FORMAT_ASTC_6x5_SFLOAT_BLOCK: i32 = 1000066003;
pub const FORMAT_ASTC_6x6_SFLOAT_BLOCK: i32 = 1000066004;
pub const FORMAT_ASTC_8x5_SFLOAT_BLOCK: i32 = 1000066005;
pub const FORMAT_ASTC_8x6_SFLOAT_BLOCK: i32 = 1000066006;
pub const FORMAT_ASTC_8x8_SFLOAT_BLOCK: i32 = 1000066007;
pub const FORMAT_ASTC_10x5_SFLOAT_BLOCK: i32 = 1000066008;
pub const FORMAT_ASTC_10x6_SFLOAT_BLOCK: i32 = 1000066009;
pub const FORMAT_ASTC_10x8_SFLOAT_BLOCK: i32 = 1000066010;
pub const FORMAT_ASTC_10x10_SFLOAT_BLOCK: i32 = 1000066011;
pub const FORMAT_ASTC_12x10_SFLOAT_BLOCK: i32 = 1000066012;
pub const FORMAT_ASTC_12x12_SFLOAT_BLOCK: i32 = 1000066013;
pub const FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: i32 = 1000054000;
pub const FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: i32 = 1000054001;
pub const FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: i32 = 1000054002;
pub const FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: i32 = 1000054003;
pub const FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: i32 = 1000054004;
pub const FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: i32 = 1000054005;
pub const FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: i32 = 1000054006;
pub const FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: i32 = 1000054007;
pub const FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_4x4_SFLOAT_BLOCK;
pub const FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_5x4_SFLOAT_BLOCK;
pub const FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_5x5_SFLOAT_BLOCK;
pub const FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_6x5_SFLOAT_BLOCK;
pub const FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_6x6_SFLOAT_BLOCK;
pub const FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_8x5_SFLOAT_BLOCK;
pub const FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_8x6_SFLOAT_BLOCK;
pub const FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_8x8_SFLOAT_BLOCK;
pub const FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_10x5_SFLOAT_BLOCK;
pub const FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_10x6_SFLOAT_BLOCK;
pub const FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_10x8_SFLOAT_BLOCK;
pub const FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_10x10_SFLOAT_BLOCK;
pub const FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_12x10_SFLOAT_BLOCK;
pub const FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT: i32 = FORMAT_ASTC_12x12_SFLOAT_BLOCK;
pub const FORMAT_G8B8G8R8_422_UNORM_KHR: i32 = FORMAT_G8B8G8R8_422_UNORM;
pub const FORMAT_B8G8R8G8_422_UNORM_KHR: i32 = FORMAT_B8G8R8G8_422_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR: i32 = FORMAT_G8_B8_R8_3PLANE_420_UNORM;
pub const FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR: i32 = FORMAT_G8_B8R8_2PLANE_420_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR: i32 = FORMAT_G8_B8_R8_3PLANE_422_UNORM;
pub const FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR: i32 = FORMAT_G8_B8R8_2PLANE_422_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR: i32 = FORMAT_G8_B8_R8_3PLANE_444_UNORM;
pub const FORMAT_R10X6_UNORM_PACK16_KHR: i32 = FORMAT_R10X6_UNORM_PACK16;
pub const FORMAT_R10X6G10X6_UNORM_2PACK16_KHR: i32 = FORMAT_R10X6G10X6_UNORM_2PACK16;
pub const FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR: i32 = FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16;
pub const FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR: i32 = FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16;
pub const FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR: i32 = FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR: i32 = FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR: i32 = FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR: i32 = FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR: i32 = FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR: i32 = FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16;
pub const FORMAT_R12X4_UNORM_PACK16_KHR: i32 = FORMAT_R12X4_UNORM_PACK16;
pub const FORMAT_R12X4G12X4_UNORM_2PACK16_KHR: i32 = FORMAT_R12X4G12X4_UNORM_2PACK16;
pub const FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR: i32 = FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16;
pub const FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR: i32 = FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16;
pub const FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR: i32 = FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR: i32 = FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR: i32 = FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR: i32 = FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR: i32 = FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR: i32 = FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16;
pub const FORMAT_G16B16G16R16_422_UNORM_KHR: i32 = FORMAT_G16B16G16R16_422_UNORM;
pub const FORMAT_B16G16R16G16_422_UNORM_KHR: i32 = FORMAT_B16G16R16G16_422_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR: i32 = FORMAT_G16_B16_R16_3PLANE_420_UNORM;
pub const FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR: i32 = FORMAT_G16_B16R16_2PLANE_420_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR: i32 = FORMAT_G16_B16_R16_3PLANE_422_UNORM;
pub const FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR: i32 = FORMAT_G16_B16R16_2PLANE_422_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR: i32 = FORMAT_G16_B16_R16_3PLANE_444_UNORM;
pub const FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT: i32 = FORMAT_G8_B8R8_2PLANE_444_UNORM;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT: i32 = FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT: i32 = FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16;
pub const FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT: i32 = FORMAT_G16_B16R16_2PLANE_444_UNORM;
pub const FORMAT_A4R4G4B4_UNORM_PACK16_EXT: i32 = FORMAT_A4R4G4B4_UNORM_PACK16;
pub const FORMAT_A4B4G4R4_UNORM_PACK16_EXT: i32 = FORMAT_A4B4G4R4_UNORM_PACK16;

// Structure type enumerant
pub type StructureType = i32;
pub const STRUCTURE_TYPE_APPLICATION_INFO: i32 = 0;
pub const STRUCTURE_TYPE_INSTANCE_CREATE_INFO: i32 = 1;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: i32 = 2;
pub const STRUCTURE_TYPE_DEVICE_CREATE_INFO: i32 = 3;
pub const STRUCTURE_TYPE_SUBMIT_INFO: i32 = 4;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: i32 = 5;
pub const STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: i32 = 6;
pub const STRUCTURE_TYPE_BIND_SPARSE_INFO: i32 = 7;
pub const STRUCTURE_TYPE_FENCE_CREATE_INFO: i32 = 8;
pub const STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: i32 = 9;
pub const STRUCTURE_TYPE_EVENT_CREATE_INFO: i32 = 10;
pub const STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: i32 = 11;
pub const STRUCTURE_TYPE_BUFFER_CREATE_INFO: i32 = 12;
pub const STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: i32 = 13;
pub const STRUCTURE_TYPE_IMAGE_CREATE_INFO: i32 = 14;
pub const STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: i32 = 15;
pub const STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: i32 = 16;
pub const STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: i32 = 17;
pub const STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: i32 = 18;
pub const STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO: i32 = 19;
pub const STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO: i32 = 20;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO: i32 = 21;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: i32 = 22;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO: i32 = 23;
pub const STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO: i32 = 24;
pub const STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO: i32 = 25;
pub const STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO: i32 = 26;
pub const STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: i32 = 27;
pub const STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: i32 = 28;
pub const STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: i32 = 29;
pub const STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: i32 = 30;
pub const STRUCTURE_TYPE_SAMPLER_CREATE_INFO: i32 = 31;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: i32 = 32;
pub const STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: i32 = 33;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: i32 = 34;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: i32 = 35;
pub const STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: i32 = 36;
pub const STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: i32 = 37;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: i32 = 38;
pub const STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: i32 = 39;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: i32 = 40;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: i32 = 41;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: i32 = 42;
pub const STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: i32 = 43;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: i32 = 44;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: i32 = 45;
pub const STRUCTURE_TYPE_MEMORY_BARRIER: i32 = 46;
pub const STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO: i32 = 47; // Reserved for internal use by the loader, layers, and ICDs
pub const STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO: i32 = 48; // Reserved for internal use by the loader, layers, and ICDs
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: i32 = 1000094000;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: i32 = 1000157000;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: i32 = 1000157001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: i32 = 1000083000;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: i32 = 1000127000;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: i32 = 1000127001;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: i32 = 1000060000;
pub const STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: i32 = 1000060003;
pub const STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: i32 = 1000060004;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: i32 = 1000060005;
pub const STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: i32 = 1000060006;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: i32 = 1000060013;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: i32 = 1000060014;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: i32 = 1000070000;
pub const STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: i32 = 1000070001;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: i32 = 1000146000;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: i32 = 1000146001;
pub const STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2: i32 = 1000146002;
pub const STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: i32 = 1000146003;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: i32 = 1000146004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: i32 = 1000059000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: i32 = 1000059001;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_2: i32 = 1000059002;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: i32 = 1000059003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: i32 = 1000059004;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: i32 = 1000059005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: i32 = 1000059006;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: i32 = 1000059007;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2: i32 = 1000059008;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: i32 = 1000117000;
pub const STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: i32 = 1000117001;
pub const STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: i32 = 1000117002;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: i32 = 1000117003;
pub const STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: i32 = 1000053000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: i32 = 1000053001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: i32 = 1000053002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: i32 = 1000120000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
pub const STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: i32 = 1000145000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: i32 = 1000145001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: i32 = 1000145002;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: i32 = 1000145003;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: i32 = 1000156000;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: i32 = 1000156001;
pub const STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: i32 = 1000156002;
pub const STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: i32 = 1000156003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: i32 = 1000156004;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: i32 = 1000156005;
pub const STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO: i32 = 1000085000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: i32 = 1000071000;
pub const STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: i32 = 1000071001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: i32 = 1000071002;
pub const STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: i32 = 1000071003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: i32 = 1000071004;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: i32 = 1000072000;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: i32 = 1000072001;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: i32 = 1000072002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: i32 = 1000112000;
pub const STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: i32 = 1000112001;
pub const STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: i32 = 1000113000;
pub const STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: i32 = 1000077000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO: i32 = 1000076000;
pub const STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: i32 = 1000076001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: i32 = 1000168000;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: i32 = 1000168001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: i32 = 1000063000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: i32 = 49;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: i32 = 50;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: i32 = 51;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: i32 = 52;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: i32 = 1000147000;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: i32 = 1000109000;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: i32 = 1000109001;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: i32 = 1000109002;
pub const STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: i32 = 1000109003;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: i32 = 1000109004;
pub const STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: i32 = 1000109005;
pub const STRUCTURE_TYPE_SUBPASS_END_INFO: i32 = 1000109006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: i32 = 1000177000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: i32 = 1000196000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: i32 = 1000180000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: i32 = 1000082000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: i32 = 1000197000;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: i32 = 1000161000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: i32 = 1000161001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: i32 = 1000161002;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: i32 = 1000161003;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: i32 = 1000161004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: i32 = 1000199000;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: i32 = 1000199001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: i32 = 1000221000;
pub const STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: i32 = 1000246000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: i32 = 1000130000;
pub const STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: i32 = 1000130001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: i32 = 1000211000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: i32 = 1000108000;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: i32 = 1000108001;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: i32 = 1000108002;
pub const STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: i32 = 1000108003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: i32 = 1000253000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: i32 = 1000175000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: i32 = 1000241000;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: i32 = 1000241001;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: i32 = 1000241002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: i32 = 1000261000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: i32 = 1000207000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: i32 = 1000207001;
pub const STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: i32 = 1000207002;
pub const STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: i32 = 1000207003;
pub const STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: i32 = 1000207004;
pub const STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: i32 = 1000207005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: i32 = 1000257000;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: i32 = 1000244001;
pub const STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: i32 = 1000257002;
pub const STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: i32 = 1000257003;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO: i32 = 1000257004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: i32 = 53;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: i32 = 54;
pub const STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: i32 = 1000192000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: i32 = 1000215000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES: i32 = 1000245000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: i32 = 1000276000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: i32 = 1000295000;
pub const STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: i32 = 1000295001;
pub const STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO: i32 = 1000295002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: i32 = 1000297000;
pub const STRUCTURE_TYPE_MEMORY_BARRIER_2: i32 = 1000314000;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2: i32 = 1000314001;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2: i32 = 1000314002;
pub const STRUCTURE_TYPE_DEPENDENCY_INFO: i32 = 1000314003;
pub const STRUCTURE_TYPE_SUBMIT_INFO_2: i32 = 1000314004;
pub const STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO: i32 = 1000314005;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO: i32 = 1000314006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: i32 = 1000314007;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: i32 = 1000325000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: i32 = 1000335000;
pub const STRUCTURE_TYPE_COPY_BUFFER_INFO_2: i32 = 1000337000;
pub const STRUCTURE_TYPE_COPY_IMAGE_INFO_2: i32 = 1000337001;
pub const STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2: i32 = 1000337002;
pub const STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2: i32 = 1000337003;
pub const STRUCTURE_TYPE_BLIT_IMAGE_INFO_2: i32 = 1000337004;
pub const STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2: i32 = 1000337005;
pub const STRUCTURE_TYPE_BUFFER_COPY_2: i32 = 1000337006;
pub const STRUCTURE_TYPE_IMAGE_COPY_2: i32 = 1000337007;
pub const STRUCTURE_TYPE_IMAGE_BLIT_2: i32 = 1000337008;
pub const STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2: i32 = 1000337009;
pub const STRUCTURE_TYPE_IMAGE_RESOLVE_2: i32 = 1000337010;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: i32 = 1000225000;
pub const STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: i32 = 1000225001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: i32 = 1000225002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: i32 = 1000138000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: i32 = 1000138001;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: i32 = 1000138002;
pub const STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: i32 = 1000138003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: i32 = 1000066000;
pub const STRUCTURE_TYPE_RENDERING_INFO: i32 = 1000044000;
pub const STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO: i32 = 1000044001;
pub const STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: i32 = 1000044002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: i32 = 1000044003;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: i32 = 1000044004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: i32 = 1000280000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: i32 = 1000280001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: i32 = 1000281001;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_3: i32 = 1000360000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: i32 = 1000413000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: i32 = 1000413001;
pub const STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS: i32 = 1000413002;
pub const STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS: i32 = 1000413003;
pub const STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: i32 = 1000001000;
pub const STRUCTURE_TYPE_PRESENT_INFO_KHR: i32 = 1000001001;
pub const STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: i32 = 1000060007;
pub const STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: i32 = 1000060008;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: i32 = 1000060009;
pub const STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: i32 = 1000060010;
pub const STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: i32 = 1000060011;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: i32 = 1000060012;
pub const STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: i32 = 1000002000;
pub const STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: i32 = 1000002001;
pub const STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: i32 = 1000003000;
pub const STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: i32 = 1000011000;
pub const STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT; // Backwards-compatible alias containing a typo
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: i32 = 1000018000;
pub const STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: i32 = 1000022000;
pub const STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: i32 = 1000022001;
pub const STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: i32 = 1000022002;
pub const STRUCTURE_TYPE_VIDEO_PROFILE_KHR: i32 = 1000023000;
pub const STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR: i32 = 1000023001;
pub const STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_KHR: i32 = 1000023002;
pub const STRUCTURE_TYPE_VIDEO_GET_MEMORY_PROPERTIES_KHR: i32 = 1000023003;
pub const STRUCTURE_TYPE_VIDEO_BIND_MEMORY_KHR: i32 = 1000023004;
pub const STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR: i32 = 1000023005;
pub const STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR: i32 = 1000023006;
pub const STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR: i32 = 1000023007;
pub const STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR: i32 = 1000023008;
pub const STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR: i32 = 1000023009;
pub const STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR: i32 = 1000023010;
pub const STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_KHR: i32 = 1000023011;
pub const STRUCTURE_TYPE_VIDEO_QUEUE_FAMILY_PROPERTIES_2_KHR: i32 = 1000023012;
pub const STRUCTURE_TYPE_VIDEO_PROFILES_KHR: i32 = 1000023013;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR: i32 = 1000023014;
pub const STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR: i32 = 1000023015;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_2_KHR: i32 = 1000023016;
pub const STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR: i32 = 1000024000;
pub const STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR: i32 = 1000024001;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: i32 = 1000026000;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: i32 = 1000026001;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV: i32 = 1000026002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: i32 = 1000028000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: i32 = 1000028001;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: i32 = 1000028002;
pub const STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX: i32 = 1000029000;
pub const STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX: i32 = 1000029001;
pub const STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX: i32 = 1000029002;
pub const STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: i32 = 1000030000;
pub const STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: i32 = 1000030001;
pub const STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD: i32 = 1000041000;
pub const STRUCTURE_TYPE_RENDERING_INFO_KHR: i32 = STRUCTURE_TYPE_RENDERING_INFO;
pub const STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO_KHR: i32 = STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO;
pub const STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR: i32 = STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO;
pub const STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: i32 = 1000044006;
pub const STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: i32 = 1000044007;
pub const STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: i32 = 1000044008;
pub const STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_NV: i32 = STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD;
pub const STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: i32 = 1000044009;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: i32 = 1000050000;
pub const STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: i32 = 1000056000;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: i32 = 1000056001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR: i32 = STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR: i32 = STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR: i32 = STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR: i32 = STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO;
pub const STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: i32 = 1000061000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES;
pub const STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: i32 = 1000067000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: i32 = 1000067001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES;
pub const STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR: i32 = STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: i32 = 1000074000;
pub const STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: i32 = 1000074001;
pub const STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: i32 = 1000074002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES;
pub const STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO;
pub const STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: i32 = 1000079000;
pub const STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: i32 = 1000079001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR: i32 = 1000080000;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: i32 = 1000081000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: i32 = 1000081001;
pub const STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: i32 = 1000081002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES;
pub const STRUCTURE_TYPE_PRESENT_REGIONS_KHR: i32 = 1000084000;
pub const STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: i32 = 1000087000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: i32 = 1000090000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT: i32 = STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT; // Backwards-compatible alias containing a typo
pub const STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: i32 = 1000091000;
pub const STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: i32 = 1000091001;
pub const STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: i32 = 1000091002;
pub const STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: i32 = 1000091003;
pub const STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: i32 = 1000092000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX: i32 = 1000097000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: i32 = 1000098000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT: i32 = 1000099000;
pub const STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: i32 = 1000099001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT: i32 = 1000101000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: i32 = 1000101001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: i32 = 1000102000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: i32 = 1000102001;
pub const STRUCTURE_TYPE_HDR_METADATA_EXT: i32 = 1000105000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR: i32 = STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO;
pub const STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR: i32 = STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR: i32 = STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR: i32 = STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR: i32 = STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2;
pub const STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR: i32 = STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR: i32 = STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2;
pub const STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR: i32 = STRUCTURE_TYPE_SUBPASS_BEGIN_INFO;
pub const STRUCTURE_TYPE_SUBPASS_END_INFO_KHR: i32 = STRUCTURE_TYPE_SUBPASS_END_INFO;
pub const STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR: i32 = 1000111000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES;
pub const STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO;
pub const STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: i32 = 1000115000;
pub const STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: i32 = 1000115001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: i32 = 1000116000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR: i32 = 1000116001;
pub const STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: i32 = 1000116002;
pub const STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: i32 = 1000116003;
pub const STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: i32 = 1000116004;
pub const STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: i32 = 1000116005;
pub const STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: i32 = 1000116006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES;
pub const STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO;
pub const STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: i32 = 1000119000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: i32 = 1000119001;
pub const STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: i32 = 1000119002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR;
pub const STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: i32 = 1000121000;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: i32 = 1000121001;
pub const STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: i32 = 1000121002;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: i32 = 1000121003;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: i32 = 1000121004;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR: i32 = STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR: i32 = STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: i32 = 1000128000;
pub const STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: i32 = 1000128001;
pub const STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: i32 = 1000128002;
pub const STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT: i32 = 1000128003;
pub const STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: i32 = 1000128004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES;
pub const STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT: i32 = STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK;
pub const STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO;
pub const STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: i32 = 1000143000;
pub const STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: i32 = 1000143001;
pub const STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: i32 = 1000143002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT: i32 = 1000143003;
pub const STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: i32 = 1000143004;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR: i32 = STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR: i32 = STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR: i32 = STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: i32 = 1000148000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT: i32 = 1000148001;
pub const STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: i32 = 1000148002;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: i32 = 1000149000;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: i32 = 1000150007;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR: i32 = 1000150000;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR: i32 = 1000150002;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR: i32 = 1000150003;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR: i32 = 1000150004;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR: i32 = 1000150005;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: i32 = 1000150006;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR: i32 = 1000150009;
pub const STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: i32 = 1000150010;
pub const STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR: i32 = 1000150011;
pub const STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR: i32 = 1000150012;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: i32 = 1000150013;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR: i32 = 1000150014;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR: i32 = 1000150017;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR: i32 = 1000150020;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: i32 = 1000347000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR: i32 = 1000347001;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: i32 = 1000150015;
pub const STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR: i32 = 1000150016;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR: i32 = 1000150018;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: i32 = 1000348013;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: i32 = 1000152000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: i32 = 1000154000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV: i32 = 1000154001;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR: i32 = STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR: i32 = STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO;
pub const STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR: i32 = STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR: i32 = STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR: i32 = STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO;
pub const STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT: i32 = 1000158000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: i32 = 1000158002;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: i32 = 1000158003;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: i32 = 1000158004;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT: i32 = 1000158005;
pub const STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT: i32 = 1000158006;
pub const STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: i32 = 1000160000;
pub const STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: i32 = 1000160001;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT: i32 = STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT: i32 = STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR: i32 = 1000163000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR: i32 = 1000163001;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: i32 = 1000164000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: i32 = 1000164001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV: i32 = 1000164002;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: i32 = 1000164005;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: i32 = 1000165000;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: i32 = 1000165001;
pub const STRUCTURE_TYPE_GEOMETRY_NV: i32 = 1000165003;
pub const STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: i32 = 1000165004;
pub const STRUCTURE_TYPE_GEOMETRY_AABB_NV: i32 = 1000165005;
pub const STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV: i32 = 1000165006;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: i32 = 1000165007;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV: i32 = 1000165008;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV: i32 = 1000165009;
pub const STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV: i32 = 1000165011;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: i32 = 1000165012;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: i32 = 1000166000;
pub const STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: i32 = 1000166001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR: i32 = STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: i32 = 1000170000;
pub const STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT: i32 = 1000170001;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: i32 = 1000178000;
pub const STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: i32 = 1000178001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT: i32 = 1000178002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: i32 = 1000181000;
pub const STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: i32 = 1000183000;
pub const STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT: i32 = 1000184000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD: i32 = 1000185000;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR: i32 = 1000174000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR: i32 = 1000388000;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR: i32 = 1000388001;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: i32 = 1000189000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT: i32 = 1000190000;
pub const STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT: i32 = 1000190001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT: i32 = 1000190002;
pub const STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR: i32 = STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV: i32 = 1000201000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: i32 = 1000202000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV: i32 = 1000202001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV: i32 = 1000203000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: i32 = 1000204000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV: i32 = 1000205000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: i32 = 1000205002;
pub const STRUCTURE_TYPE_CHECKPOINT_DATA_NV: i32 = 1000206000;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: i32 = 1000206001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES;
pub const STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO;
pub const STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR: i32 = STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO;
pub const STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR: i32 = STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO;
pub const STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR: i32 = STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: i32 = 1000209000;
pub const STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: i32 = 1000210000;
pub const STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL: i32 = STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL; // Backwards-compatible alias containing a typo
pub const STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: i32 = 1000210001;
pub const STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: i32 = 1000210002;
pub const STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: i32 = 1000210003;
pub const STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: i32 = 1000210004;
pub const STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL: i32 = 1000210005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT: i32 = 1000212000;
pub const STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD: i32 = 1000213000;
pub const STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: i32 = 1000213001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: i32 = 1000218000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT: i32 = 1000218001;
pub const STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: i32 = 1000218002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES;
pub const STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES;
pub const STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: i32 = 1000226000;
pub const STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR: i32 = 1000226001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR: i32 = 1000226002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: i32 = 1000226003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR: i32 = 1000226004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD: i32 = 1000227000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: i32 = 1000229000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: i32 = 1000234000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT: i32 = 1000237000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: i32 = 1000238000;
pub const STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: i32 = 1000238001;
pub const STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: i32 = 1000239000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: i32 = 1000240000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR: i32 = STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR: i32 = STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: i32 = 1000244000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT: i32 = STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: i32 = 1000244002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES;
pub const STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: i32 = 1000247000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: i32 = 1000248000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: i32 = 1000249000;
pub const STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: i32 = 1000249001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV: i32 = 1000249002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: i32 = 1000250000;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: i32 = 1000250001;
pub const STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV: i32 = 1000250002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: i32 = 1000251000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: i32 = 1000252000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: i32 = 1000254000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: i32 = 1000254001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: i32 = 1000254002;
pub const STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: i32 = 1000256000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR: i32 = STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR: i32 = STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO;
pub const STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR: i32 = STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR: i32 = STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: i32 = 1000259000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: i32 = 1000259001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: i32 = 1000259002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: i32 = 1000260000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: i32 = 1000265000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: i32 = 1000267000; // Not promoted to 1.3
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: i32 = 1000269000;
pub const STRUCTURE_TYPE_PIPELINE_INFO_KHR: i32 = 1000269001;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: i32 = 1000269002;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: i32 = 1000269003;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: i32 = 1000269004;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR: i32 = 1000269005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: i32 = 1000273000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV: i32 = 1000277000;
pub const STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: i32 = 1000277001;
pub const STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: i32 = 1000277002;
pub const STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: i32 = 1000277003;
pub const STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV: i32 = 1000277004;
pub const STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: i32 = 1000277005;
pub const STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV: i32 = 1000277006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: i32 = 1000277007;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: i32 = 1000278000;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV: i32 = 1000278001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: i32 = 1000281000; // Not promoted to 1.3
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM: i32 = 1000282000;
pub const STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: i32 = 1000282001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: i32 = 1000284000;
pub const STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: i32 = 1000284001;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT: i32 = 1000284002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: i32 = 1000286000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT: i32 = 1000286001;
pub const STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: i32 = 1000287000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: i32 = 1000287001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: i32 = 1000287002;
pub const STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: i32 = 1000290000;
pub const STRUCTURE_TYPE_PRESENT_ID_KHR: i32 = 1000294000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: i32 = 1000294001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES;
pub const STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO;
pub const STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT: i32 = STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES;
pub const STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR: i32 = 1000299000;
pub const STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR: i32 = 1000299001;
pub const STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR: i32 = 1000299002;
pub const STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR: i32 = 1000299003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: i32 = 1000300000;
pub const STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: i32 = 1000300001;
pub const STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR: i32 = STRUCTURE_TYPE_MEMORY_BARRIER_2;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR: i32 = STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2;
pub const STRUCTURE_TYPE_DEPENDENCY_INFO_KHR: i32 = STRUCTURE_TYPE_DEPENDENCY_INFO;
pub const STRUCTURE_TYPE_SUBMIT_INFO_2_KHR: i32 = STRUCTURE_TYPE_SUBMIT_INFO_2;
pub const STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR: i32 = STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR: i32 = STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: i32 = 1000314008;
pub const STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV: i32 = 1000314009;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT: i32 = 1000320000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT: i32 = 1000320001;
pub const STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT: i32 = 1000320002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: i32 = 1000323000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV: i32 = 1000326000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: i32 = 1000326001;
pub const STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV: i32 = 1000326002;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV: i32 = 1000327000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: i32 = 1000327001;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV: i32 = 1000327002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: i32 = 1000330000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: i32 = 1000332000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT: i32 = 1000332001;
pub const STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM: i32 = 1000333000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: i32 = 1000336000;
pub const STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR: i32 = STRUCTURE_TYPE_COPY_BUFFER_INFO_2;
pub const STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR: i32 = STRUCTURE_TYPE_COPY_IMAGE_INFO_2;
pub const STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR: i32 = STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2;
pub const STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR: i32 = STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2;
pub const STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR: i32 = STRUCTURE_TYPE_BLIT_IMAGE_INFO_2;
pub const STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR: i32 = STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2;
pub const STRUCTURE_TYPE_BUFFER_COPY_2_KHR: i32 = STRUCTURE_TYPE_BUFFER_COPY_2;
pub const STRUCTURE_TYPE_IMAGE_COPY_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_COPY_2;
pub const STRUCTURE_TYPE_IMAGE_BLIT_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_BLIT_2;
pub const STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR: i32 = STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2;
pub const STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR: i32 = STRUCTURE_TYPE_IMAGE_RESOLVE_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: i32 = 1000340000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_ARM: i32 = 1000342000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: i32 = 1000344000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE: i32 = 1000351000;
pub const STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE: i32 = 1000351002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: i32 = 1000352000;
pub const STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT: i32 = 1000352001;
pub const STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT: i32 = 1000352002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT: i32 = 1000353000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: i32 = 1000355000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT: i32 = 1000355001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: i32 = 1000356000;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_3_KHR: i32 = STRUCTURE_TYPE_FORMAT_PROPERTIES_3;
pub const STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI: i32 = 1000369000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: i32 = 1000369001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI: i32 = 1000369002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: i32 = 1000370000;
pub const STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV: i32 = 1000371000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: i32 = 1000371001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: i32 = 1000377000; // Not promoted to 1.3
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: i32 = 1000381000;
pub const STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: i32 = 1000381001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT: i32 = 1000382000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT: i32 = STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: i32 = 1000391000;
pub const STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT: i32 = 1000391001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: i32 = 1000392000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT: i32 = 1000392001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT: i32 = 1000393000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: i32 = 1000411000;
pub const STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT: i32 = 1000411001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: i32 = 1000412000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR: i32 = STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES;
pub const STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR: i32 = STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS;
pub const STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR: i32 = STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE: i32 = 1000420000;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE: i32 = 1000420001;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE: i32 = 1000420002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: i32 = 1000425000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM: i32 = 1000425001;
pub const STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM: i32 = 1000425002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: i32 = 1000430000;

pub type SubpassContents = i32;
pub const SUBPASS_CONTENTS_INLINE: i32 = 0;
pub const SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS: i32 = 1;

// API result codes
pub type Result = i32;
pub const SUCCESS: i32 = 0; // Command completed successfully
pub const NOT_READY: i32 = 1; // A fence or query has not yet completed
pub const TIMEOUT: i32 = 2; // A wait operation has not completed in the specified time
pub const EVENT_SET: i32 = 3; // An event is signaled
pub const EVENT_RESET: i32 = 4; // An event is unsignaled
pub const INCOMPLETE: i32 = 5; // A return array was too small for the result
pub const ERROR_OUT_OF_HOST_MEMORY: i32 = -1; // A host memory allocation has failed
pub const ERROR_OUT_OF_DEVICE_MEMORY: i32 = -2; // A device memory allocation has failed
pub const ERROR_INITIALIZATION_FAILED: i32 = -3; // Initialization of a object has failed
pub const ERROR_DEVICE_LOST: i32 = -4; // The logical device has been lost. See <<devsandqueues-lost-device>>
pub const ERROR_MEMORY_MAP_FAILED: i32 = -5; // Mapping of a memory object has failed
pub const ERROR_LAYER_NOT_PRESENT: i32 = -6; // Layer specified does not exist
pub const ERROR_EXTENSION_NOT_PRESENT: i32 = -7; // Extension specified does not exist
pub const ERROR_FEATURE_NOT_PRESENT: i32 = -8; // Requested feature is not available on this device
pub const ERROR_INCOMPATIBLE_DRIVER: i32 = -9; // Unable to find a Vulkan driver
pub const ERROR_TOO_MANY_OBJECTS: i32 = -10; // Too many objects of the type have already been created
pub const ERROR_FORMAT_NOT_SUPPORTED: i32 = -11; // Requested format is not supported on this device
pub const ERROR_FRAGMENTED_POOL: i32 = -12; // A requested pool allocation has failed due to fragmentation of the pool's memory
pub const ERROR_UNKNOWN: i32 = -13; // An unknown error has occurred, due to an implementation or application bug
pub const ERROR_OUT_OF_POOL_MEMORY: i32 = -1000069000;
pub const ERROR_INVALID_EXTERNAL_HANDLE: i32 = -1000072003;
pub const ERROR_FRAGMENTATION: i32 = -1000161000;
pub const ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: i32 = -1000257000;
pub const PIPELINE_COMPILE_REQUIRED: i32 = 1000297000;
pub const ERROR_SURFACE_LOST_KHR: i32 = -1000000000;
pub const ERROR_NATIVE_WINDOW_IN_USE_KHR: i32 = -1000000001;
pub const SUBOPTIMAL_KHR: i32 = 1000001003;
pub const ERROR_OUT_OF_DATE_KHR: i32 = -1000001004;
pub const ERROR_INCOMPATIBLE_DISPLAY_KHR: i32 = -1000003001;
pub const ERROR_VALIDATION_FAILED_EXT: i32 = -1000011001;
pub const ERROR_INVALID_SHADER_NV: i32 = -1000012000;
pub const ERROR_OUT_OF_POOL_MEMORY_KHR: i32 = ERROR_OUT_OF_POOL_MEMORY;
pub const ERROR_INVALID_EXTERNAL_HANDLE_KHR: i32 = ERROR_INVALID_EXTERNAL_HANDLE;
pub const ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: i32 = -1000158000;
pub const ERROR_FRAGMENTATION_EXT: i32 = ERROR_FRAGMENTATION;
pub const ERROR_NOT_PERMITTED_EXT: i32 = ERROR_NOT_PERMITTED_KHR;
pub const ERROR_NOT_PERMITTED_KHR: i32 = -1000174001;
pub const ERROR_INVALID_DEVICE_ADDRESS_EXT: i32 = ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS;
pub const ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR: i32 = ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS;
pub const THREAD_IDLE_KHR: i32 = 1000268000;
pub const THREAD_DONE_KHR: i32 = 1000268001;
pub const OPERATION_DEFERRED_KHR: i32 = 1000268002;
pub const OPERATION_NOT_DEFERRED_KHR: i32 = 1000268003;
pub const PIPELINE_COMPILE_REQUIRED_EXT: i32 = PIPELINE_COMPILE_REQUIRED;
pub const ERROR_PIPELINE_COMPILE_REQUIRED_EXT: i32 = PIPELINE_COMPILE_REQUIRED;

pub type DynamicState = i32;
pub const DYNAMIC_STATE_VIEWPORT: i32 = 0;
pub const DYNAMIC_STATE_SCISSOR: i32 = 1;
pub const DYNAMIC_STATE_LINE_WIDTH: i32 = 2;
pub const DYNAMIC_STATE_DEPTH_BIAS: i32 = 3;
pub const DYNAMIC_STATE_BLEND_CONSTANTS: i32 = 4;
pub const DYNAMIC_STATE_DEPTH_BOUNDS: i32 = 5;
pub const DYNAMIC_STATE_STENCIL_COMPARE_MASK: i32 = 6;
pub const DYNAMIC_STATE_STENCIL_WRITE_MASK: i32 = 7;
pub const DYNAMIC_STATE_STENCIL_REFERENCE: i32 = 8;
pub const DYNAMIC_STATE_CULL_MODE: i32 = 1000267000;
pub const DYNAMIC_STATE_FRONT_FACE: i32 = 1000267001;
pub const DYNAMIC_STATE_PRIMITIVE_TOPOLOGY: i32 = 1000267002;
pub const DYNAMIC_STATE_VIEWPORT_WITH_COUNT: i32 = 1000267003;
pub const DYNAMIC_STATE_SCISSOR_WITH_COUNT: i32 = 1000267004;
pub const DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE: i32 = 1000267005;
pub const DYNAMIC_STATE_DEPTH_TEST_ENABLE: i32 = 1000267006;
pub const DYNAMIC_STATE_DEPTH_WRITE_ENABLE: i32 = 1000267007;
pub const DYNAMIC_STATE_DEPTH_COMPARE_OP: i32 = 1000267008;
pub const DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE: i32 = 1000267009;
pub const DYNAMIC_STATE_STENCIL_TEST_ENABLE: i32 = 1000267010;
pub const DYNAMIC_STATE_STENCIL_OP: i32 = 1000267011;
pub const DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE: i32 = 1000377001;
pub const DYNAMIC_STATE_DEPTH_BIAS_ENABLE: i32 = 1000377002;
pub const DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE: i32 = 1000377004;
pub const DYNAMIC_STATE_VIEWPORT_W_SCALING_NV: i32 = 1000087000;
pub const DYNAMIC_STATE_DISCARD_RECTANGLE_EXT: i32 = 1000099000;
pub const DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT: i32 = 1000143000;
pub const DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR: i32 = 1000347000;
pub const DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV: i32 = 1000164004;
pub const DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV: i32 = 1000164006;
pub const DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV: i32 = 1000205001;
pub const DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR: i32 = 1000226000;
pub const DYNAMIC_STATE_LINE_STIPPLE_EXT: i32 = 1000259000;
pub const DYNAMIC_STATE_CULL_MODE_EXT: i32 = DYNAMIC_STATE_CULL_MODE;
pub const DYNAMIC_STATE_FRONT_FACE_EXT: i32 = DYNAMIC_STATE_FRONT_FACE;
pub const DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT: i32 = DYNAMIC_STATE_PRIMITIVE_TOPOLOGY;
pub const DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT: i32 = DYNAMIC_STATE_VIEWPORT_WITH_COUNT;
pub const DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT: i32 = DYNAMIC_STATE_SCISSOR_WITH_COUNT;
pub const DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT: i32 = DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE;
pub const DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT: i32 = DYNAMIC_STATE_DEPTH_TEST_ENABLE;
pub const DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT: i32 = DYNAMIC_STATE_DEPTH_WRITE_ENABLE;
pub const DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT: i32 = DYNAMIC_STATE_DEPTH_COMPARE_OP;
pub const DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT: i32 = DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE;
pub const DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT: i32 = DYNAMIC_STATE_STENCIL_TEST_ENABLE;
pub const DYNAMIC_STATE_STENCIL_OP_EXT: i32 = DYNAMIC_STATE_STENCIL_OP;
pub const DYNAMIC_STATE_VERTEX_INPUT_EXT: i32 = 1000352000;
pub const DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT: i32 = 1000377000; // Not promoted to 1.3
pub const DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT: i32 = DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE;
pub const DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT: i32 = DYNAMIC_STATE_DEPTH_BIAS_ENABLE;
pub const DYNAMIC_STATE_LOGIC_OP_EXT: i32 = 1000377003; // Not promoted to 1.3
pub const DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT: i32 = DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE;
pub const DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT: i32 = 1000381000;

pub type DescriptorUpdateTemplateType = i32;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET: i32 = 0; // Create descriptor update template for descriptor set updates
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR: i32 = 1; // Create descriptor update template for pushed descriptor updates
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR: i32 = DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET;

// Enums to track objects of various types - also see objtypeenum attributes on type tags
pub type ObjectType = i32;
pub const OBJECT_TYPE_UNKNOWN: i32 = 0;
pub const OBJECT_TYPE_INSTANCE: i32 = 1;
pub const OBJECT_TYPE_PHYSICAL_DEVICE: i32 = 2;
pub const OBJECT_TYPE_DEVICE: i32 = 3;
pub const OBJECT_TYPE_QUEUE: i32 = 4;
pub const OBJECT_TYPE_SEMAPHORE: i32 = 5;
pub const OBJECT_TYPE_COMMAND_BUFFER: i32 = 6;
pub const OBJECT_TYPE_FENCE: i32 = 7;
pub const OBJECT_TYPE_DEVICE_MEMORY: i32 = 8;
pub const OBJECT_TYPE_BUFFER: i32 = 9;
pub const OBJECT_TYPE_IMAGE: i32 = 10;
pub const OBJECT_TYPE_EVENT: i32 = 11;
pub const OBJECT_TYPE_QUERY_POOL: i32 = 12;
pub const OBJECT_TYPE_BUFFER_VIEW: i32 = 13;
pub const OBJECT_TYPE_IMAGE_VIEW: i32 = 14;
pub const OBJECT_TYPE_SHADER_MODULE: i32 = 15;
pub const OBJECT_TYPE_PIPELINE_CACHE: i32 = 16;
pub const OBJECT_TYPE_PIPELINE_LAYOUT: i32 = 17;
pub const OBJECT_TYPE_RENDER_PASS: i32 = 18;
pub const OBJECT_TYPE_PIPELINE: i32 = 19;
pub const OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: i32 = 20;
pub const OBJECT_TYPE_SAMPLER: i32 = 21;
pub const OBJECT_TYPE_DESCRIPTOR_POOL: i32 = 22;
pub const OBJECT_TYPE_DESCRIPTOR_SET: i32 = 23;
pub const OBJECT_TYPE_FRAMEBUFFER: i32 = 24;
pub const OBJECT_TYPE_COMMAND_POOL: i32 = 25;
pub const OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: i32 = 1000156000;
pub const OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: i32 = 1000085000;
pub const OBJECT_TYPE_PRIVATE_DATA_SLOT: i32 = 1000295000;
pub const OBJECT_TYPE_SURFACE_KHR: i32 = 1000000000;
pub const OBJECT_TYPE_SWAPCHAIN_KHR: i32 = 1000001000;
pub const OBJECT_TYPE_DISPLAY_KHR: i32 = 1000002000;
pub const OBJECT_TYPE_DISPLAY_MODE_KHR: i32 = 1000002001;
pub const OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT: i32 = 1000011000;
pub const OBJECT_TYPE_VIDEO_SESSION_KHR: i32 = 1000023000; // VkVideoSessionKHR
pub const OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR: i32 = 1000023001; // VkVideoSessionParametersKHR
pub const OBJECT_TYPE_CU_MODULE_NVX: i32 = 1000029000;
pub const OBJECT_TYPE_CU_FUNCTION_NVX: i32 = 1000029001;
pub const OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR: i32 = OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE;
pub const OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: i32 = 1000128000;
pub const OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR: i32 = 1000150000;
pub const OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR: i32 = OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION;
pub const OBJECT_TYPE_VALIDATION_CACHE_EXT: i32 = 1000160000;
pub const OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: i32 = 1000165000;
pub const OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: i32 = 1000210000;
pub const OBJECT_TYPE_DEFERRED_OPERATION_KHR: i32 = 1000268000;
pub const OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV: i32 = 1000277000;
pub const OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT: i32 = OBJECT_TYPE_PRIVATE_DATA_SLOT;

pub type SemaphoreCreateFlagBits = u32;

pub type SemaphoreType = i32;
pub const SEMAPHORE_TYPE_BINARY: i32 = 0;
pub const SEMAPHORE_TYPE_TIMELINE: i32 = 1;
pub const SEMAPHORE_TYPE_BINARY_KHR: i32 = SEMAPHORE_TYPE_BINARY;
pub const SEMAPHORE_TYPE_TIMELINE_KHR: i32 = SEMAPHORE_TYPE_TIMELINE;

pub type PresentModeKHR = i32;
pub const PRESENT_MODE_IMMEDIATE_KHR: i32 = 0;
pub const PRESENT_MODE_MAILBOX_KHR: i32 = 1;
pub const PRESENT_MODE_FIFO_KHR: i32 = 2;
pub const PRESENT_MODE_FIFO_RELAXED_KHR: i32 = 3;
pub const PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR: i32 = 1000111000;
pub const PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR: i32 = 1000111001;

pub type ColorSpaceKHR = i32;
pub const COLOR_SPACE_SRGB_NONLINEAR_KHR: i32 = 0;
pub const COLORSPACE_SRGB_NONLINEAR_KHR: i32 = COLOR_SPACE_SRGB_NONLINEAR_KHR; // Backwards-compatible alias containing a typo
pub const COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT: i32 = 1000104001;
pub const COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT: i32 = 1000104002;
pub const COLOR_SPACE_DISPLAY_P3_LINEAR_EXT: i32 = 1000104003;
pub const COLOR_SPACE_DCI_P3_NONLINEAR_EXT: i32 = 1000104004;
pub const COLOR_SPACE_BT709_LINEAR_EXT: i32 = 1000104005;
pub const COLOR_SPACE_BT709_NONLINEAR_EXT: i32 = 1000104006;
pub const COLOR_SPACE_BT2020_LINEAR_EXT: i32 = 1000104007;
pub const COLOR_SPACE_HDR10_ST2084_EXT: i32 = 1000104008;
pub const COLOR_SPACE_DOLBYVISION_EXT: i32 = 1000104009;
pub const COLOR_SPACE_HDR10_HLG_EXT: i32 = 1000104010;
pub const COLOR_SPACE_ADOBERGB_LINEAR_EXT: i32 = 1000104011;
pub const COLOR_SPACE_ADOBERGB_NONLINEAR_EXT: i32 = 1000104012;
pub const COLOR_SPACE_PASS_THROUGH_EXT: i32 = 1000104013;
pub const COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT: i32 = 1000104014;
pub const COLOR_SPACE_DCI_P3_LINEAR_EXT: i32 = COLOR_SPACE_DISPLAY_P3_LINEAR_EXT; // Backwards-compatible alias containing a typo
pub const COLOR_SPACE_DISPLAY_NATIVE_AMD: i32 = 1000213000;

pub type TimeDomainEXT = i32;
pub const TIME_DOMAIN_DEVICE_EXT: i32 = 0;
pub const TIME_DOMAIN_CLOCK_MONOTONIC_EXT: i32 = 1;
pub const TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT: i32 = 2;
pub const TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT: i32 = 3;

pub type DebugReportObjectTypeEXT = i32;
pub const DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT: i32 = 0;
pub const DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT: i32 = 1;
pub const DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT: i32 = 2;
pub const DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT: i32 = 3;
pub const DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT: i32 = 4;
pub const DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT: i32 = 5;
pub const DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT: i32 = 6;
pub const DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT: i32 = 7;
pub const DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT: i32 = 8;
pub const DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT: i32 = 9;
pub const DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT: i32 = 10;
pub const DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT: i32 = 11;
pub const DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT: i32 = 12;
pub const DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT: i32 = 13;
pub const DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT: i32 = 14;
pub const DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT: i32 = 15;
pub const DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT: i32 = 16;
pub const DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT: i32 = 17;
pub const DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT: i32 = 18;
pub const DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT: i32 = 19;
pub const DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT: i32 = 20;
pub const DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT: i32 = 21;
pub const DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT: i32 = 22;
pub const DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT: i32 = 23;
pub const DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT: i32 = 24;
pub const DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT: i32 = 25;
pub const DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT: i32 = 26;
pub const DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT: i32 = 27;
pub const DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT: i32 = 28;
pub const DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT: i32 = DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT; // Backwards-compatible alias containing a typo
pub const DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT: i32 = 29;
pub const DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT: i32 = 30;
pub const DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT: i32 = 33;
pub const DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT: i32 = DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT; // Backwards-compatible alias containing a typo
pub const DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT: i32 = 1000156000;
pub const DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT: i32 = 1000085000;
pub const DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT: i32 = 1000029000;
pub const DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT: i32 = 1000029001;
pub const DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT: i32 = DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT;
pub const DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT: i32 = 1000150000;
pub const DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR_EXT: i32 = DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT;
pub const DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT: i32 = 1000165000;

pub type DeviceMemoryReportEventTypeEXT = i32;
pub const DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT: i32 = 0;
pub const DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT: i32 = 1;
pub const DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT: i32 = 2;
pub const DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT: i32 = 3;
pub const DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT: i32 = 4;

pub type RasterizationOrderAMD = i32;
pub const RASTERIZATION_ORDER_STRICT_AMD: i32 = 0;
pub const RASTERIZATION_ORDER_RELAXED_AMD: i32 = 1;

pub type ValidationCheckEXT = i32;
pub const VALIDATION_CHECK_ALL_EXT: i32 = 0;
pub const VALIDATION_CHECK_SHADERS_EXT: i32 = 1;

pub type ValidationFeatureEnableEXT = i32;
pub const VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT: i32 = 0;
pub const VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT: i32 = 1;
pub const VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT: i32 = 2;
pub const VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT: i32 = 3;
pub const VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT: i32 = 4;

pub type ValidationFeatureDisableEXT = i32;
pub const VALIDATION_FEATURE_DISABLE_ALL_EXT: i32 = 0;
pub const VALIDATION_FEATURE_DISABLE_SHADERS_EXT: i32 = 1;
pub const VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT: i32 = 2;
pub const VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT: i32 = 3;
pub const VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT: i32 = 4;
pub const VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT: i32 = 5;
pub const VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT: i32 = 6;
pub const VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT: i32 = 7;

pub type IndirectCommandsTokenTypeNV = i32;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV: i32 = 0;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV: i32 = 1;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV: i32 = 2;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV: i32 = 3;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV: i32 = 4;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV: i32 = 5;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV: i32 = 6;
pub const INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV: i32 = 7;

pub type PrivateDataSlotCreateFlagBits = u32;

pub type DisplayPowerStateEXT = i32;
pub const DISPLAY_POWER_STATE_OFF_EXT: i32 = 0;
pub const DISPLAY_POWER_STATE_SUSPEND_EXT: i32 = 1;
pub const DISPLAY_POWER_STATE_ON_EXT: i32 = 2;

pub type DeviceEventTypeEXT = i32;
pub const DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT: i32 = 0;

pub type DisplayEventTypeEXT = i32;
pub const DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT: i32 = 0;

pub type ViewportCoordinateSwizzleNV = i32;
pub const VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV: i32 = 0;
pub const VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV: i32 = 1;
pub const VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV: i32 = 2;
pub const VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV: i32 = 3;
pub const VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV: i32 = 4;
pub const VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV: i32 = 5;
pub const VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV: i32 = 6;
pub const VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV: i32 = 7;

pub type DiscardRectangleModeEXT = i32;
pub const DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT: i32 = 0;
pub const DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT: i32 = 1;

pub type PointClippingBehavior = i32;
pub const POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES: i32 = 0;
pub const POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY: i32 = 1;
pub const POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR: i32 = POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES;
pub const POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR: i32 = POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY;

pub type SamplerReductionMode = i32;
pub const SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE: i32 = 0;
pub const SAMPLER_REDUCTION_MODE_MIN: i32 = 1;
pub const SAMPLER_REDUCTION_MODE_MAX: i32 = 2;
pub const SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT: i32 = SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE;
pub const SAMPLER_REDUCTION_MODE_MIN_EXT: i32 = SAMPLER_REDUCTION_MODE_MIN;
pub const SAMPLER_REDUCTION_MODE_MAX_EXT: i32 = SAMPLER_REDUCTION_MODE_MAX;

pub type TessellationDomainOrigin = i32;
pub const TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT: i32 = 0;
pub const TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT: i32 = 1;
pub const TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR: i32 = TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT;
pub const TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR: i32 = TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT;

pub type SamplerYcbcrModelConversion = i32;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY: i32 = 0;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY: i32 = 1; // just range expansion
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709: i32 = 2; // aka HD YUV
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601: i32 = 3; // aka SD YUV
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020: i32 = 4; // aka UHD YUV
pub const SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR: i32 = SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR: i32 = SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR: i32 = SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR: i32 = SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601;
pub const SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR: i32 = SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020;

pub type SamplerYcbcrRange = i32;
pub const SAMPLER_YCBCR_RANGE_ITU_FULL: i32 = 0; // Luma 0..1 maps to 0..255, chroma -0.5..0.5 to 1..255 (clamped)
pub const SAMPLER_YCBCR_RANGE_ITU_NARROW: i32 = 1; // Luma 0..1 maps to 16..235, chroma -0.5..0.5 to 16..240
pub const SAMPLER_YCBCR_RANGE_ITU_FULL_KHR: i32 = SAMPLER_YCBCR_RANGE_ITU_FULL;
pub const SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR: i32 = SAMPLER_YCBCR_RANGE_ITU_NARROW;

pub type ChromaLocation = i32;
pub const CHROMA_LOCATION_COSITED_EVEN: i32 = 0;
pub const CHROMA_LOCATION_MIDPOINT: i32 = 1;
pub const CHROMA_LOCATION_COSITED_EVEN_KHR: i32 = CHROMA_LOCATION_COSITED_EVEN;
pub const CHROMA_LOCATION_MIDPOINT_KHR: i32 = CHROMA_LOCATION_MIDPOINT;

pub type BlendOverlapEXT = i32;
pub const BLEND_OVERLAP_UNCORRELATED_EXT: i32 = 0;
pub const BLEND_OVERLAP_DISJOINT_EXT: i32 = 1;
pub const BLEND_OVERLAP_CONJOINT_EXT: i32 = 2;

pub type CoverageModulationModeNV = i32;
pub const COVERAGE_MODULATION_MODE_NONE_NV: i32 = 0;
pub const COVERAGE_MODULATION_MODE_RGB_NV: i32 = 1;
pub const COVERAGE_MODULATION_MODE_ALPHA_NV: i32 = 2;
pub const COVERAGE_MODULATION_MODE_RGBA_NV: i32 = 3;

pub type CoverageReductionModeNV = i32;
pub const COVERAGE_REDUCTION_MODE_MERGE_NV: i32 = 0;
pub const COVERAGE_REDUCTION_MODE_TRUNCATE_NV: i32 = 1;

pub type ValidationCacheHeaderVersionEXT = i32;
pub const VALIDATION_CACHE_HEADER_VERSION_ONE_EXT: i32 = 1;

pub type ShaderInfoTypeAMD = i32;
pub const SHADER_INFO_TYPE_STATISTICS_AMD: i32 = 0;
pub const SHADER_INFO_TYPE_BINARY_AMD: i32 = 1;
pub const SHADER_INFO_TYPE_DISASSEMBLY_AMD: i32 = 2;

pub type QueueGlobalPriorityKHR = i32;
pub const QUEUE_GLOBAL_PRIORITY_LOW_KHR: i32 = 128;
pub const QUEUE_GLOBAL_PRIORITY_MEDIUM_KHR: i32 = 256;
pub const QUEUE_GLOBAL_PRIORITY_HIGH_KHR: i32 = 512;
pub const QUEUE_GLOBAL_PRIORITY_REALTIME_KHR: i32 = 1024;
pub const QUEUE_GLOBAL_PRIORITY_LOW_EXT: i32 = QUEUE_GLOBAL_PRIORITY_LOW_KHR;
pub const QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT: i32 = QUEUE_GLOBAL_PRIORITY_MEDIUM_KHR;
pub const QUEUE_GLOBAL_PRIORITY_HIGH_EXT: i32 = QUEUE_GLOBAL_PRIORITY_HIGH_KHR;
pub const QUEUE_GLOBAL_PRIORITY_REALTIME_EXT: i32 = QUEUE_GLOBAL_PRIORITY_REALTIME_KHR;

pub type ConservativeRasterizationModeEXT = i32;
pub const CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT: i32 = 0;
pub const CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT: i32 = 1;
pub const CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT: i32 = 2;

pub type VendorId = i32;
pub const VENDOR_ID_VIV: i32 = 0x10001; // Vivante vendor ID
pub const VENDOR_ID_VSI: i32 = 0x10002; // VeriSilicon vendor ID
pub const VENDOR_ID_KAZAN: i32 = 0x10003; // Kazan Software Renderer
pub const VENDOR_ID_CODEPLAY: i32 = 0x10004; // Codeplay Software Ltd. vendor ID
pub const VENDOR_ID_MESA: i32 = 0x10005; // Mesa vendor ID
pub const VENDOR_ID_POCL: i32 = 0x10006; // PoCL vendor ID

pub type DriverId = i32;
pub const DRIVER_ID_AMD_PROPRIETARY: i32 = 1; // Advanced Micro Devices, Inc.
pub const DRIVER_ID_AMD_OPEN_SOURCE: i32 = 2; // Advanced Micro Devices, Inc.
pub const DRIVER_ID_MESA_RADV: i32 = 3; // Mesa open source project
pub const DRIVER_ID_NVIDIA_PROPRIETARY: i32 = 4; // NVIDIA Corporation
pub const DRIVER_ID_INTEL_PROPRIETARY_WINDOWS: i32 = 5; // Intel Corporation
pub const DRIVER_ID_INTEL_OPEN_SOURCE_MESA: i32 = 6; // Intel Corporation
pub const DRIVER_ID_IMAGINATION_PROPRIETARY: i32 = 7; // Imagination Technologies
pub const DRIVER_ID_QUALCOMM_PROPRIETARY: i32 = 8; // Qualcomm Technologies, Inc.
pub const DRIVER_ID_ARM_PROPRIETARY: i32 = 9; // Arm Limited
pub const DRIVER_ID_GOOGLE_SWIFTSHADER: i32 = 10; // Google LLC
pub const DRIVER_ID_GGP_PROPRIETARY: i32 = 11; // Google LLC
pub const DRIVER_ID_BROADCOM_PROPRIETARY: i32 = 12; // Broadcom Inc.
pub const DRIVER_ID_MESA_LLVMPIPE: i32 = 13; // Mesa
pub const DRIVER_ID_MOLTENVK: i32 = 14; // MoltenVK
pub const DRIVER_ID_COREAVI_PROPRIETARY: i32 = 15; // Core Avionics & Industrial Inc.
pub const DRIVER_ID_JUICE_PROPRIETARY: i32 = 16; // Juice Technologies, Inc.
pub const DRIVER_ID_VERISILICON_PROPRIETARY: i32 = 17; // Verisilicon, Inc.
pub const DRIVER_ID_MESA_TURNIP: i32 = 18; // Mesa open source project
pub const DRIVER_ID_MESA_V3DV: i32 = 19; // Mesa open source project
pub const DRIVER_ID_MESA_PANVK: i32 = 20; // Mesa open source project
pub const DRIVER_ID_SAMSUNG_PROPRIETARY: i32 = 21; // Samsung Electronics Co., Ltd.
pub const DRIVER_ID_MESA_VENUS: i32 = 22; // Mesa open source project
pub const DRIVER_ID_AMD_PROPRIETARY_KHR: i32 = DRIVER_ID_AMD_PROPRIETARY;
pub const DRIVER_ID_AMD_OPEN_SOURCE_KHR: i32 = DRIVER_ID_AMD_OPEN_SOURCE;
pub const DRIVER_ID_MESA_RADV_KHR: i32 = DRIVER_ID_MESA_RADV;
pub const DRIVER_ID_NVIDIA_PROPRIETARY_KHR: i32 = DRIVER_ID_NVIDIA_PROPRIETARY;
pub const DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR: i32 = DRIVER_ID_INTEL_PROPRIETARY_WINDOWS;
pub const DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR: i32 = DRIVER_ID_INTEL_OPEN_SOURCE_MESA;
pub const DRIVER_ID_IMAGINATION_PROPRIETARY_KHR: i32 = DRIVER_ID_IMAGINATION_PROPRIETARY;
pub const DRIVER_ID_QUALCOMM_PROPRIETARY_KHR: i32 = DRIVER_ID_QUALCOMM_PROPRIETARY;
pub const DRIVER_ID_ARM_PROPRIETARY_KHR: i32 = DRIVER_ID_ARM_PROPRIETARY;
pub const DRIVER_ID_GOOGLE_SWIFTSHADER_KHR: i32 = DRIVER_ID_GOOGLE_SWIFTSHADER;
pub const DRIVER_ID_GGP_PROPRIETARY_KHR: i32 = DRIVER_ID_GGP_PROPRIETARY;
pub const DRIVER_ID_BROADCOM_PROPRIETARY_KHR: i32 = DRIVER_ID_BROADCOM_PROPRIETARY;

pub type ShadingRatePaletteEntryNV = i32;
pub const SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV: i32 = 0;
pub const SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV: i32 = 1;
pub const SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV: i32 = 2;
pub const SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV: i32 = 3;
pub const SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV: i32 = 4;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV: i32 = 5;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV: i32 = 6;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV: i32 = 7;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV: i32 = 8;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV: i32 = 9;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV: i32 = 10;
pub const SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV: i32 = 11;

pub type CoarseSampleOrderTypeNV = i32;
pub const COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV: i32 = 0;
pub const COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV: i32 = 1;
pub const COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV: i32 = 2;
pub const COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV: i32 = 3;

pub type CopyAccelerationStructureModeKHR = i32;
pub const COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR: i32 = 0;
pub const COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR: i32 = 1;
pub const COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR: i32 = 2;
pub const COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR: i32 = 3;
pub const COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV: i32 = COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR;
pub const COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV: i32 = COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR;

pub type BuildAccelerationStructureModeKHR = i32;
pub const BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR: i32 = 0;
pub const BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR: i32 = 1;

pub type AccelerationStructureTypeKHR = i32;
pub const ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR: i32 = 0;
pub const ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR: i32 = 1;
pub const ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR: i32 = 2;
pub const ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV: i32 = ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR;
pub const ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV: i32 = ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR;

pub type GeometryTypeKHR = i32;
pub const GEOMETRY_TYPE_TRIANGLES_KHR: i32 = 0;
pub const GEOMETRY_TYPE_AABBS_KHR: i32 = 1;
pub const GEOMETRY_TYPE_INSTANCES_KHR: i32 = 2;
pub const GEOMETRY_TYPE_TRIANGLES_NV: i32 = GEOMETRY_TYPE_TRIANGLES_KHR;
pub const GEOMETRY_TYPE_AABBS_NV: i32 = GEOMETRY_TYPE_AABBS_KHR;

pub type AccelerationStructureMemoryRequirementsTypeNV = i32;
pub const ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV: i32 = 0;
pub const ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV: i32 = 1;
pub const ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV: i32 = 2;

pub type AccelerationStructureBuildTypeKHR = i32;
pub const ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR: i32 = 0;
pub const ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR: i32 = 1;
pub const ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR: i32 = 2;

pub type RayTracingShaderGroupTypeKHR = i32;
pub const RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR: i32 = 0;
pub const RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR: i32 = 1;
pub const RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR: i32 = 2;
pub const RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV: i32 = RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR;
pub const RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV: i32 = RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR;
pub const RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV: i32 = RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR;

pub type AccelerationStructureCompatibilityKHR = i32;
pub const ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR: i32 = 0;
pub const ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR: i32 = 1;

pub type ShaderGroupShaderKHR = i32;
pub const SHADER_GROUP_SHADER_GENERAL_KHR: i32 = 0;
pub const SHADER_GROUP_SHADER_CLOSEST_HIT_KHR: i32 = 1;
pub const SHADER_GROUP_SHADER_ANY_HIT_KHR: i32 = 2;
pub const SHADER_GROUP_SHADER_INTERSECTION_KHR: i32 = 3;

pub type MemoryOverallocationBehaviorAMD = i32;
pub const MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD: i32 = 0;
pub const MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD: i32 = 1;
pub const MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD: i32 = 2;

pub type ScopeNV = i32;
pub const SCOPE_DEVICE_NV: i32 = 1;
pub const SCOPE_WORKGROUP_NV: i32 = 2;
pub const SCOPE_SUBGROUP_NV: i32 = 3;
pub const SCOPE_QUEUE_FAMILY_NV: i32 = 5;

pub type ComponentTypeNV = i32;
pub const COMPONENT_TYPE_FLOAT16_NV: i32 = 0;
pub const COMPONENT_TYPE_FLOAT32_NV: i32 = 1;
pub const COMPONENT_TYPE_FLOAT64_NV: i32 = 2;
pub const COMPONENT_TYPE_SINT8_NV: i32 = 3;
pub const COMPONENT_TYPE_SINT16_NV: i32 = 4;
pub const COMPONENT_TYPE_SINT32_NV: i32 = 5;
pub const COMPONENT_TYPE_SINT64_NV: i32 = 6;
pub const COMPONENT_TYPE_UINT8_NV: i32 = 7;
pub const COMPONENT_TYPE_UINT16_NV: i32 = 8;
pub const COMPONENT_TYPE_UINT32_NV: i32 = 9;
pub const COMPONENT_TYPE_UINT64_NV: i32 = 10;

pub type FullScreenExclusiveEXT = i32;
pub const FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT: i32 = 0;
pub const FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT: i32 = 1;
pub const FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT: i32 = 2;
pub const FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT: i32 = 3;

pub type PerformanceCounterScopeKHR = i32;
pub const PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR: i32 = 0;
pub const PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR: i32 = 1;
pub const PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR: i32 = 2;
pub const QUERY_SCOPE_COMMAND_BUFFER_KHR: i32 = PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR; // Backwards-compatible alias containing a typo
pub const QUERY_SCOPE_RENDER_PASS_KHR: i32 = PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR; // Backwards-compatible alias containing a typo
pub const QUERY_SCOPE_COMMAND_KHR: i32 = PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR; // Backwards-compatible alias containing a typo

pub type PerformanceCounterUnitKHR = i32;
pub const PERFORMANCE_COUNTER_UNIT_GENERIC_KHR: i32 = 0;
pub const PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR: i32 = 1;
pub const PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR: i32 = 2;
pub const PERFORMANCE_COUNTER_UNIT_BYTES_KHR: i32 = 3;
pub const PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR: i32 = 4;
pub const PERFORMANCE_COUNTER_UNIT_KELVIN_KHR: i32 = 5;
pub const PERFORMANCE_COUNTER_UNIT_WATTS_KHR: i32 = 6;
pub const PERFORMANCE_COUNTER_UNIT_VOLTS_KHR: i32 = 7;
pub const PERFORMANCE_COUNTER_UNIT_AMPS_KHR: i32 = 8;
pub const PERFORMANCE_COUNTER_UNIT_HERTZ_KHR: i32 = 9;
pub const PERFORMANCE_COUNTER_UNIT_CYCLES_KHR: i32 = 10;

pub type PerformanceCounterStorageKHR = i32;
pub const PERFORMANCE_COUNTER_STORAGE_INT32_KHR: i32 = 0;
pub const PERFORMANCE_COUNTER_STORAGE_INT64_KHR: i32 = 1;
pub const PERFORMANCE_COUNTER_STORAGE_UINT32_KHR: i32 = 2;
pub const PERFORMANCE_COUNTER_STORAGE_UINT64_KHR: i32 = 3;
pub const PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR: i32 = 4;
pub const PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR: i32 = 5;

pub type PerformanceConfigurationTypeINTEL = i32;
pub const PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL: i32 = 0;

pub type QueryPoolSamplingModeINTEL = i32;
pub const QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL: i32 = 0;

pub type PerformanceOverrideTypeINTEL = i32;
pub const PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL: i32 = 0;
pub const PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL: i32 = 1;

pub type PerformanceParameterTypeINTEL = i32;
pub const PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL: i32 = 0;
pub const PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL: i32 = 1;

pub type PerformanceValueTypeINTEL = i32;
pub const PERFORMANCE_VALUE_TYPE_UINT32_INTEL: i32 = 0;
pub const PERFORMANCE_VALUE_TYPE_UINT64_INTEL: i32 = 1;
pub const PERFORMANCE_VALUE_TYPE_FLOAT_INTEL: i32 = 2;
pub const PERFORMANCE_VALUE_TYPE_BOOL_INTEL: i32 = 3;
pub const PERFORMANCE_VALUE_TYPE_STRING_INTEL: i32 = 4;

pub type ShaderFloatControlsIndependence = i32;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY: i32 = 0;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL: i32 = 1;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE: i32 = 2;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR: i32 = SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR: i32 = SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL;
pub const SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR: i32 = SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE;

pub type PipelineExecutableStatisticFormatKHR = i32;
pub const PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR: i32 = 0;
pub const PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR: i32 = 1;
pub const PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR: i32 = 2;
pub const PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR: i32 = 3;

pub type LineRasterizationModeEXT = i32;
pub const LINE_RASTERIZATION_MODE_DEFAULT_EXT: i32 = 0;
pub const LINE_RASTERIZATION_MODE_RECTANGULAR_EXT: i32 = 1;
pub const LINE_RASTERIZATION_MODE_BRESENHAM_EXT: i32 = 2;
pub const LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT: i32 = 3;

pub type ShaderModuleCreateFlagBits = u32;

pub type FragmentShadingRateCombinerOpKHR = i32;
pub const FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR: i32 = 0;
pub const FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR: i32 = 1;
pub const FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR: i32 = 2;
pub const FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR: i32 = 3;
pub const FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR: i32 = 4;

pub type FragmentShadingRateNV = i32;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV: i32 = 0;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV: i32 = 1;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV: i32 = 4;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV: i32 = 5;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV: i32 = 6;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV: i32 = 9;
pub const FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV: i32 = 10;
pub const FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV: i32 = 11;
pub const FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV: i32 = 12;
pub const FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV: i32 = 13;
pub const FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV: i32 = 14;
pub const FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV: i32 = 15;

pub type FragmentShadingRateTypeNV = i32;
pub const FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV: i32 = 0;
pub const FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV: i32 = 1;

pub type AccessFlagBits2 = u32;

pub type PipelineStageFlagBits2 = u32;

pub type ProvokingVertexModeEXT = i32;
pub const PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT: i32 = 0;
pub const PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT: i32 = 1;

pub type AccelerationStructureMotionInstanceTypeNV = i32;
pub const ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV: i32 = 0;
pub const ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV: i32 = 1;
pub const ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV: i32 = 2;

pub type QueryResultStatusKHR = i32;
pub const QUERY_RESULT_STATUS_ERROR_KHR: i32 = -1;
pub const QUERY_RESULT_STATUS_NOT_READY_KHR: i32 = 0;
pub const QUERY_RESULT_STATUS_COMPLETE_KHR: i32 = 1;

pub type ImageFormatConstraintsFlagBitsFUCHSIA = u32;

pub type FormatFeatureFlagBits2 = u32;


// enum aliases
pub type PrivateDataSlotCreateFlagBitsEXT = PrivateDataSlotCreateFlagBits;

pub type DescriptorUpdateTemplateTypeKHR = DescriptorUpdateTemplateType;

pub type PointClippingBehaviorKHR = PointClippingBehavior;

pub type QueueGlobalPriorityEXT = QueueGlobalPriorityKHR;

pub type ResolveModeFlagBitsKHR = ResolveModeFlagBits;

pub type DescriptorBindingFlagBitsEXT = DescriptorBindingFlagBits;

pub type SemaphoreTypeKHR = SemaphoreType;

pub type GeometryFlagBitsNV = GeometryFlagBitsKHR;

pub type GeometryInstanceFlagBitsNV = GeometryInstanceFlagBitsKHR;

pub type BuildAccelerationStructureFlagBitsNV = BuildAccelerationStructureFlagBitsKHR;

pub type CopyAccelerationStructureModeNV = CopyAccelerationStructureModeKHR;

pub type AccelerationStructureTypeNV = AccelerationStructureTypeKHR;

pub type GeometryTypeNV = GeometryTypeKHR;

pub type RayTracingShaderGroupTypeNV = RayTracingShaderGroupTypeKHR;

pub type PipelineCreationFeedbackFlagBitsEXT = PipelineCreationFeedbackFlagBits;

pub type SemaphoreWaitFlagBitsKHR = SemaphoreWaitFlagBits;

pub type ToolPurposeFlagBitsEXT = ToolPurposeFlagBits;

pub type AccessFlagBits2KHR = AccessFlagBits2;

pub type PipelineStageFlagBits2KHR = PipelineStageFlagBits2;

pub type FormatFeatureFlagBits2KHR = FormatFeatureFlagBits2;

pub type RenderingFlagBitsKHR = RenderingFlagBits;

pub type ExternalMemoryHandleTypeFlagBitsKHR = ExternalMemoryHandleTypeFlagBits;

pub type ExternalMemoryFeatureFlagBitsKHR = ExternalMemoryFeatureFlagBits;

pub type ExternalSemaphoreHandleTypeFlagBitsKHR = ExternalSemaphoreHandleTypeFlagBits;

pub type ExternalSemaphoreFeatureFlagBitsKHR = ExternalSemaphoreFeatureFlagBits;

pub type SemaphoreImportFlagBitsKHR = SemaphoreImportFlagBits;

pub type ExternalFenceHandleTypeFlagBitsKHR = ExternalFenceHandleTypeFlagBits;

pub type ExternalFenceFeatureFlagBitsKHR = ExternalFenceFeatureFlagBits;

pub type FenceImportFlagBitsKHR = FenceImportFlagBits;

pub type PeerMemoryFeatureFlagBitsKHR = PeerMemoryFeatureFlagBits;

pub type MemoryAllocateFlagBitsKHR = MemoryAllocateFlagBits;

pub type TessellationDomainOriginKHR = TessellationDomainOrigin;

pub type SamplerYcbcrModelConversionKHR = SamplerYcbcrModelConversion;

pub type SamplerYcbcrRangeKHR = SamplerYcbcrRange;

pub type ChromaLocationKHR = ChromaLocation;

pub type SamplerReductionModeEXT = SamplerReductionMode;

pub type ShaderFloatControlsIndependenceKHR = ShaderFloatControlsIndependence;

pub type SubmitFlagBitsKHR = SubmitFlagBits;

pub type DriverIdKHR = DriverId;

// unions

// // Union allowing specification of floating point, integer, or unsigned integer color data. Actual value selected is based on image/attachment being cleared.
#[repr(C)]
#[derive(Copy, Clone)]
pub union ClearColorValue {
    pub float32: [f32; 4],
    pub int32: [i32; 4],
    pub uint32: [u32; 4],
}

// // Union allowing specification of color or depth and stencil values. Actual value selected is based on attachment being cleared.
#[repr(C)]
#[derive(Copy, Clone)]
pub union ClearValue {
    pub color: ClearColorValue,
    pub depthStencil: ClearDepthStencilValue,
}

// // Union of all the possible return types a counter result could return
#[repr(C)]
#[derive(Copy, Clone)]
pub union PerformanceCounterResultKHR {
    pub int32: i32,
    pub int64: i64,
    pub uint32: u32,
    pub uint64: u64,
    pub float32: f32,
    pub float64: f64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union PerformanceValueDataINTEL {
    pub value32: u32,
    pub value64: u64,
    pub valueFloat: f32,
    pub valueBool: Bool32,
    pub valueString: *const c_char,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union PipelineExecutableStatisticValueKHR {
    pub b32: Bool32,
    pub i64: i64,
    pub u64: u64,
    pub f64: f64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union DeviceOrHostAddressKHR {
    pub deviceAddress: DeviceAddress,
    pub hostAddress: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union DeviceOrHostAddressConstKHR {
    pub deviceAddress: DeviceAddress,
    pub hostAddress: *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union AccelerationStructureGeometryDataKHR {
    pub triangles: AccelerationStructureGeometryTrianglesDataKHR,
    pub aabbs: AccelerationStructureGeometryAabbsDataKHR,
    pub instances: AccelerationStructureGeometryInstancesDataKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union AccelerationStructureMotionInstanceDataNV {
    pub staticInstance: AccelerationStructureInstanceKHR,
    pub matrixMotionInstance: AccelerationStructureMatrixMotionInstanceNV,
    pub srtMotionInstance: AccelerationStructureSRTMotionInstanceNV,
}

// structs

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BaseOutStructure {
    pub sType: StructureType,
    pub pNext: *mut BaseOutStructure,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BaseInStructure {
    pub sType: StructureType,
    pub pNext: *const BaseInStructure,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub minDepth: f32,
    pub maxDepth: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ClearRect {
    pub rect: Rect2D,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProperties {
    pub apiVersion: u32,
    pub driverVersion: u32,
    pub vendorID: u32,
    pub deviceID: u32,
    pub deviceType: PhysicalDeviceType,
    pub deviceName: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE as usize],
    pub pipelineCacheUUID: [u8; UUID_SIZE as usize],
    pub limits: PhysicalDeviceLimits,
    pub sparseProperties: PhysicalDeviceSparseProperties,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExtensionProperties {
    pub extensionName: [c_char; MAX_EXTENSION_NAME_SIZE as usize], // extension name
    pub specVersion: u32, // version of the extension specification implemented
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct LayerProperties {
    pub layerName: [c_char; MAX_EXTENSION_NAME_SIZE as usize], // layer name
    pub specVersion: u32, // version of the layer specification implemented
    pub implementationVersion: u32, // build or release version of the layer's library
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize], // Free-form description of the layer
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ApplicationInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pApplicationName: *const c_char,
    pub applicationVersion: u32,
    pub pEngineName: *const c_char,
    pub engineVersion: u32,
    pub apiVersion: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AllocationCallbacks {
    pub pUserData: *mut c_void,
    pub pfnAllocation: FnAllocationFunction,
    pub pfnReallocation: FnReallocationFunction,
    pub pfnFree: FnFreeFunction,
    pub pfnInternalAllocation: FnInternalAllocationNotification,
    pub pfnInternalFree: FnInternalFreeNotification,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceQueueCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueCount: u32,
    pub pQueuePriorities: *const f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queueCreateInfoCount: u32,
    pub pQueueCreateInfos: *const DeviceQueueCreateInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const c_char, // Ordered list of layer names to be enabled
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const c_char,
    pub pEnabledFeatures: *const PhysicalDeviceFeatures,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct InstanceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: InstanceCreateFlags,
    pub pApplicationInfo: *const ApplicationInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const c_char, // Ordered list of layer names to be enabled
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const c_char, // Extension names to be enabled
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyProperties {
    pub queueFlags: QueueFlags, // Queue flags
    pub queueCount: u32,
    pub timestampValidBits: u32,
    pub minImageTransferGranularity: Extent3D, // Minimum alignment requirement for image transfers
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMemoryProperties {
    pub memoryTypeCount: u32,
    pub memoryTypes: [MemoryType; MAX_MEMORY_TYPES as usize],
    pub memoryHeapCount: u32,
    pub memoryHeaps: [MemoryHeap; MAX_MEMORY_HEAPS as usize],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub allocationSize: DeviceSize, // Size of memory allocation
    pub memoryTypeIndex: u32, // Index of the of the memory type to allocate from
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryRequirements {
    pub size: DeviceSize, // Specified in bytes
    pub alignment: DeviceSize, // Specified in bytes
    pub memoryTypeBits: u32, // Bitmask of the allowed memory type indices into memoryTypes[] for this object
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageFormatProperties {
    pub aspectMask: ImageAspectFlags,
    pub imageGranularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageMemoryRequirements {
    pub formatProperties: SparseImageFormatProperties,
    pub imageMipTailFirstLod: u32,
    pub imageMipTailSize: DeviceSize, // Specified in bytes, must be a multiple of sparse block size in bytes / alignment
    pub imageMipTailOffset: DeviceSize, // Specified in bytes, must be a multiple of sparse block size in bytes / alignment
    pub imageMipTailStride: DeviceSize, // Specified in bytes, must be a multiple of sparse block size in bytes / alignment
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryType {
    pub propertyFlags: MemoryPropertyFlags, // Memory properties of this memory type
    pub heapIndex: u32, // Index of the memory heap allocations of this memory type are taken from
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryHeap {
    pub size: DeviceSize, // Available memory in the heap
    pub flags: MemoryHeapFlags, // Flags for the heap
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MappedMemoryRange {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory, // Mapped memory object
    pub offset: DeviceSize, // Offset within the memory object where the range starts
    pub size: DeviceSize, // Size of the range within the memory object
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FormatProperties {
    pub linearTilingFeatures: FormatFeatureFlags, // Format features in case of linear tiling
    pub optimalTilingFeatures: FormatFeatureFlags, // Format features in case of optimal tiling
    pub bufferFeatures: FormatFeatureFlags, // Format features supported by buffers
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageFormatProperties {
    pub maxExtent: Extent3D, // max image dimensions for this resource type
    pub maxMipLevels: u32, // max number of mipmap levels for this resource type
    pub maxArrayLayers: u32, // max array size for this resource type
    pub sampleCounts: SampleCountFlags, // supported sample counts for this resource type
    pub maxResourceSize: DeviceSize, // max size (in bytes) of this resource type
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer, // Buffer used for this descriptor slot.
    pub offset: DeviceSize, // Base offset from buffer start in bytes to update in the descriptor set.
    pub range: DeviceSize, // Size in bytes of the buffer resource for this descriptor update.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorImageInfo {
    pub sampler: Sampler, // Sampler to write to the descriptor in case it is a SAMPLER or COMBINED_IMAGE_SAMPLER descriptor. Ignored otherwise.
    pub imageView: ImageView, // Image view to write to the descriptor in case it is a SAMPLED_IMAGE, STORAGE_IMAGE, COMBINED_IMAGE_SAMPLER, or INPUT_ATTACHMENT descriptor. Ignored otherwise.
    pub imageLayout: ImageLayout, // Layout the image is expected to be in when accessed using this descriptor (only used if imageView is not VK_NULL_HANDLE).
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct WriteDescriptorSet {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dstSet: DescriptorSet, // Destination descriptor set
    pub dstBinding: u32, // Binding within the destination descriptor set to write
    pub dstArrayElement: u32, // Array element within the destination binding to write
    pub descriptorCount: u32, // Number of descriptors to write (determines the size of the array pointed by pDescriptors)
    pub descriptorType: DescriptorType, // Descriptor type to write (determines which members of the array pointed by pDescriptors are going to be used)
    pub pImageInfo: *const DescriptorImageInfo, // Sampler, image view, and layout for SAMPLER, COMBINED_IMAGE_SAMPLER, {SAMPLED,STORAGE}_IMAGE, and INPUT_ATTACHMENT descriptor types.
    pub pBufferInfo: *const DescriptorBufferInfo, // Raw buffer, size, and offset for {UNIFORM,STORAGE}_BUFFER[_DYNAMIC] descriptor types.
    pub pTexelBufferView: *const BufferView, // Buffer view to write to the descriptor for {UNIFORM,STORAGE}_TEXEL_BUFFER descriptor types.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyDescriptorSet {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSet: DescriptorSet, // Source descriptor set
    pub srcBinding: u32, // Binding within the source descriptor set to copy from
    pub srcArrayElement: u32, // Array element within the source binding to copy from
    pub dstSet: DescriptorSet, // Destination descriptor set
    pub dstBinding: u32, // Binding within the destination descriptor set to copy to
    pub dstArrayElement: u32, // Array element within the destination binding to copy to
    pub descriptorCount: u32, // Number of descriptors to write (determines the size of the array pointed by pDescriptors)
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: BufferCreateFlags, // Buffer creation flags
    pub size: DeviceSize, // Specified in bytes
    pub usage: BufferUsageFlags, // Buffer usage flags
    pub sharingMode: SharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferViewCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format, // Optionally specifies format of elements
    pub offset: DeviceSize, // Specified in bytes
    pub range: DeviceSize, // View size specified in bytes
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageSubresource {
    pub aspectMask: ImageAspectFlags,
    pub mipLevel: u32,
    pub arrayLayer: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageSubresourceLayers {
    pub aspectMask: ImageAspectFlags,
    pub mipLevel: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageSubresourceRange {
    pub aspectMask: ImageAspectFlags,
    pub baseMipLevel: u32,
    pub levelCount: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags, // Memory accesses from the source of the dependency to synchronize
    pub dstAccessMask: AccessFlags, // Memory accesses from the destination of the dependency to synchronize
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferMemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags, // Memory accesses from the source of the dependency to synchronize
    pub dstAccessMask: AccessFlags, // Memory accesses from the destination of the dependency to synchronize
    pub srcQueueFamilyIndex: u32, // Queue family to transition ownership from
    pub dstQueueFamilyIndex: u32, // Queue family to transition ownership to
    pub buffer: Buffer, // Buffer to sync
    pub offset: DeviceSize, // Offset within the buffer to sync
    pub size: DeviceSize, // Amount of bytes to sync
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageMemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags, // Memory accesses from the source of the dependency to synchronize
    pub dstAccessMask: AccessFlags, // Memory accesses from the destination of the dependency to synchronize
    pub oldLayout: ImageLayout, // Current layout of the image
    pub newLayout: ImageLayout, // New layout to transition the image to
    pub srcQueueFamilyIndex: u32, // Queue family to transition ownership from
    pub dstQueueFamilyIndex: u32, // Queue family to transition ownership to
    pub image: Image, // Image to sync
    pub subresourceRange: ImageSubresourceRange, // Subresource range to sync
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ImageCreateFlags, // Image creation flags
    pub imageType: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mipLevels: u32,
    pub arrayLayers: u32,
    pub samples: SampleCountFlagBits,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags, // Image usage flags
    pub sharingMode: SharingMode, // Cross-queue-family sharing mode
    pub queueFamilyIndexCount: u32, // Number of queue families to share across
    pub pQueueFamilyIndices: *const u32, // Array of queue family indices to share across
    pub initialLayout: ImageLayout, // Initial image layout for all subresources
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubresourceLayout {
    pub offset: DeviceSize, // Specified in bytes
    pub size: DeviceSize, // Specified in bytes
    pub rowPitch: DeviceSize, // Specified in bytes
    pub arrayPitch: DeviceSize, // Specified in bytes
    pub depthPitch: DeviceSize, // Specified in bytes
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub viewType: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresourceRange: ImageSubresourceRange,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferCopy {
    pub srcOffset: DeviceSize, // Specified in bytes
    pub dstOffset: DeviceSize, // Specified in bytes
    pub size: DeviceSize, // Specified in bytes
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseMemoryBind {
    pub resourceOffset: DeviceSize, // Specified in bytes
    pub size: DeviceSize, // Specified in bytes
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize, // Specified in bytes
    pub flags: SparseMemoryBindFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize, // Specified in bytes
    pub flags: SparseMemoryBindFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseBufferMemoryBindInfo {
    pub buffer: Buffer,
    pub bindCount: u32,
    pub pBinds: *const SparseMemoryBind,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageOpaqueMemoryBindInfo {
    pub image: Image,
    pub bindCount: u32,
    pub pBinds: *const SparseMemoryBind,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageMemoryBindInfo {
    pub image: Image,
    pub bindCount: u32,
    pub pBinds: *const SparseImageMemoryBind,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindSparseInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const Semaphore,
    pub bufferBindCount: u32,
    pub pBufferBinds: *const SparseBufferMemoryBindInfo,
    pub imageOpaqueBindCount: u32,
    pub pImageOpaqueBinds: *const SparseImageOpaqueMemoryBindInfo,
    pub imageBindCount: u32,
    pub pImageBinds: *const SparseImageMemoryBindInfo,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const Semaphore,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageCopy {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub extent: Extent3D, // Specified in pixels for both compressed and uncompressed images
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageBlit {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffsets: [Offset3D; 2], // Specified in pixels for both compressed and uncompressed images
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffsets: [Offset3D; 2], // Specified in pixels for both compressed and uncompressed images
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferImageCopy {
    pub bufferOffset: DeviceSize, // Specified in bytes
    pub bufferRowLength: u32, // Specified in texels
    pub bufferImageHeight: u32,
    pub imageSubresource: ImageSubresourceLayers,
    pub imageOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub imageExtent: Extent3D, // Specified in pixels for both compressed and uncompressed images
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageResolve {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D,
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D,
    pub extent: Extent3D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShaderModuleCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub codeSize: usize, // Specified in bytes
    pub pCode: *const u32, // Binary code of size codeSize
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetLayoutBinding {
    pub binding: u32, // Binding number for this entry
    pub descriptorType: DescriptorType, // Type of the descriptors in this binding
    pub descriptorCount: u32, // Number of descriptors in this binding
    pub stageFlags: ShaderStageFlags, // Shader stages this binding is visible to
    pub pImmutableSamplers: *const Sampler, // Immutable samplers (used if descriptor type is SAMPLER or COMBINED_IMAGE_SAMPLER, is either NULL or contains count number of elements)
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetLayoutCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub bindingCount: u32, // Number of bindings in the descriptor set layout
    pub pBindings: *const DescriptorSetLayoutBinding, // Array of descriptor set layout bindings
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorPoolSize {
    pub typ: DescriptorType,
    pub descriptorCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub maxSets: u32,
    pub poolSizeCount: u32,
    pub pPoolSizes: *const DescriptorPoolSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub descriptorPool: DescriptorPool,
    pub descriptorSetCount: u32,
    pub pSetLayouts: *const DescriptorSetLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpecializationMapEntry {
    pub constantID: u32, // The SpecConstant ID specified in the BIL
    pub offset: u32, // Offset of the value in the data block
    pub size: usize, // Size in bytes of the SpecConstant
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpecializationInfo {
    pub mapEntryCount: u32, // Number of entries in the map
    pub pMapEntries: *const SpecializationMapEntry, // Array of map entries
    pub dataSize: usize, // Size in bytes of pData
    pub pData: *const c_void, // Pointer to SpecConstant data
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineShaderStageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlagBits, // Shader stage
    pub module: ShaderModule, // Module containing entry point
    pub pName: *const c_char, // Null-terminated entry point name
    pub pSpecializationInfo: *const SpecializationInfo,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ComputePipelineCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags, // Pipeline creation flags
    pub stage: PipelineShaderStageCreateInfo,
    pub layout: PipelineLayout, // Interface layout of the pipeline
    pub basePipelineHandle: Pipeline, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is nonzero, it specifies the handle of the base pipeline this is a derivative of
    pub basePipelineIndex: i32, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is not -1, it specifies an index into pCreateInfos of the base pipeline this is a derivative of
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VertexInputBindingDescription {
    pub binding: u32, // Vertex buffer binding id
    pub stride: u32, // Distance between vertices in bytes (0 = no advancement)
    pub inputRate: VertexInputRate, // The rate at which the vertex data is consumed
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VertexInputAttributeDescription {
    pub location: u32, // location of the shader vertex attrib
    pub binding: u32, // Vertex buffer binding id
    pub format: Format, // format of source data
    pub offset: u32, // Offset of first element in bytes from base of vertex
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineVertexInputStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertexBindingDescriptionCount: u32, // number of bindings
    pub pVertexBindingDescriptions: *const VertexInputBindingDescription,
    pub vertexAttributeDescriptionCount: u32, // number of attributes
    pub pVertexAttributeDescriptions: *const VertexInputAttributeDescription,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineInputAssemblyStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitiveRestartEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineTessellationStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patchControlPoints: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewportCount: u32,
    pub pViewports: *const Viewport,
    pub scissorCount: u32,
    pub pScissors: *const Rect2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depthClampEnable: Bool32,
    pub rasterizerDiscardEnable: Bool32,
    pub polygonMode: PolygonMode, // optional (GL45)
    pub cullMode: CullModeFlags,
    pub frontFace: FrontFace,
    pub depthBiasEnable: Bool32,
    pub depthBiasConstantFactor: f32,
    pub depthBiasClamp: f32,
    pub depthBiasSlopeFactor: f32,
    pub lineWidth: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineMultisampleStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterizationSamples: SampleCountFlagBits, // Number of samples used for rasterization
    pub sampleShadingEnable: Bool32, // optional (GL45)
    pub minSampleShading: f32, // optional (GL45)
    pub pSampleMask: *const SampleMask, // Array of sampleMask words
    pub alphaToCoverageEnable: Bool32,
    pub alphaToOneEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineColorBlendAttachmentState {
    pub blendEnable: Bool32,
    pub srcColorBlendFactor: BlendFactor,
    pub dstColorBlendFactor: BlendFactor,
    pub colorBlendOp: BlendOp,
    pub srcAlphaBlendFactor: BlendFactor,
    pub dstAlphaBlendFactor: BlendFactor,
    pub alphaBlendOp: BlendOp,
    pub colorWriteMask: ColorComponentFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineColorBlendStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logicOpEnable: Bool32,
    pub logicOp: LogicOp,
    pub attachmentCount: u32, // # of pAttachments
    pub pAttachments: *const PipelineColorBlendAttachmentState,
    pub blendConstants: [f32; 4],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineDynamicStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamicStateCount: u32,
    pub pDynamicStates: *const DynamicState,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct StencilOpState {
    pub failOp: StencilOp,
    pub passOp: StencilOp,
    pub depthFailOp: StencilOp,
    pub compareOp: CompareOp,
    pub compareMask: u32,
    pub writeMask: u32,
    pub reference: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineDepthStencilStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depthTestEnable: Bool32,
    pub depthWriteEnable: Bool32,
    pub depthCompareOp: CompareOp,
    pub depthBoundsTestEnable: Bool32, // optional (depth_bounds_test)
    pub stencilTestEnable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub minDepthBounds: f32,
    pub maxDepthBounds: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GraphicsPipelineCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags, // Pipeline creation flags
    pub stageCount: u32,
    pub pStages: *const PipelineShaderStageCreateInfo, // One entry for each active shader stage
    pub pVertexInputState: *const PipelineVertexInputStateCreateInfo,
    pub pInputAssemblyState: *const PipelineInputAssemblyStateCreateInfo,
    pub pTessellationState: *const PipelineTessellationStateCreateInfo,
    pub pViewportState: *const PipelineViewportStateCreateInfo,
    pub pRasterizationState: *const PipelineRasterizationStateCreateInfo,
    pub pMultisampleState: *const PipelineMultisampleStateCreateInfo,
    pub pDepthStencilState: *const PipelineDepthStencilStateCreateInfo,
    pub pColorBlendState: *const PipelineColorBlendStateCreateInfo,
    pub pDynamicState: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout, // Interface layout of the pipeline
    pub renderPass: RenderPass,
    pub subpass: u32,
    pub basePipelineHandle: Pipeline, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is nonzero, it specifies the handle of the base pipeline this is a derivative of
    pub basePipelineIndex: i32, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is not -1, it specifies an index into pCreateInfos of the base pipeline this is a derivative of
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCacheCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initialDataSize: usize, // Size of initial data to populate cache, in bytes
    pub pInitialData: *const c_void, // Initial data to populate cache
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCacheHeaderVersionOne {
    // The fields in this structure are non-normative since structure packing is implementation-defined in C. The specification defines the normative layout.
    pub headerSize: u32,
    pub headerVersion: PipelineCacheHeaderVersion,
    pub vendorID: u32,
    pub deviceID: u32,
    pub pipelineCacheUUID: [u8; UUID_SIZE as usize],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PushConstantRange {
    pub stageFlags: ShaderStageFlags, // Which stages use the range
    pub offset: u32, // Start of the range, in bytes
    pub size: u32, // Size of the range, in bytes
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineLayoutCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub setLayoutCount: u32, // Number of descriptor sets interfaced by the pipeline
    pub pSetLayouts: *const DescriptorSetLayout, // Array of setCount number of descriptor set layout objects defining the layout of the
    pub pushConstantRangeCount: u32, // Number of push-constant ranges used by the pipeline
    pub pPushConstantRanges: *const PushConstantRange, // Array of pushConstantRangeCount number of ranges used by various shader stages
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SamplerCreateFlags,
    pub magFilter: Filter, // Filter mode for magnification
    pub minFilter: Filter, // Filter mode for minifiation
    pub mipmapMode: SamplerMipmapMode, // Mipmap selection mode
    pub addressModeU: SamplerAddressMode,
    pub addressModeV: SamplerAddressMode,
    pub addressModeW: SamplerAddressMode,
    pub mipLodBias: f32,
    pub anisotropyEnable: Bool32,
    pub maxAnisotropy: f32,
    pub compareEnable: Bool32,
    pub compareOp: CompareOp,
    pub minLod: f32,
    pub maxLod: f32,
    pub borderColor: BorderColor,
    pub unnormalizedCoordinates: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: CommandPoolCreateFlags, // Command pool creation flags
    pub queueFamilyIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub commandPool: CommandPool,
    pub level: CommandBufferLevel,
    pub commandBufferCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferInheritanceInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub renderPass: RenderPass, // Render pass for secondary command buffers
    pub subpass: u32,
    pub framebuffer: Framebuffer, // Framebuffer for secondary command buffers
    pub occlusionQueryEnable: Bool32, // Whether this secondary command buffer may be executed during an occlusion query
    pub queryFlags: QueryControlFlags, // Query flags used by this secondary command buffer, if executed during an occlusion query
    pub pipelineStatistics: QueryPipelineStatisticFlags, // Pipeline statistics that may be counted for this secondary command buffer
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: CommandBufferUsageFlags, // Command buffer usage flags
    pub pInheritanceInfo: *const CommandBufferInheritanceInfo, // Pointer to inheritance info for secondary command buffers
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub renderPass: RenderPass,
    pub framebuffer: Framebuffer,
    pub renderArea: Rect2D,
    pub clearValueCount: u32,
    pub pClearValues: *const ClearValue,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ClearAttachment {
    pub aspectMask: ImageAspectFlags,
    pub colorAttachment: u32,
    pub clearValue: ClearValue,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlagBits,
    pub loadOp: AttachmentLoadOp, // Load operation for color or depth data
    pub storeOp: AttachmentStoreOp, // Store operation for color or depth data
    pub stencilLoadOp: AttachmentLoadOp, // Load operation for stencil data
    pub stencilStoreOp: AttachmentStoreOp, // Store operation for stencil data
    pub initialLayout: ImageLayout,
    pub finalLayout: ImageLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassDescription {
    pub flags: SubpassDescriptionFlags,
    pub pipelineBindPoint: PipelineBindPoint, // Must be VK_PIPELINE_BIND_POINT_GRAPHICS for now
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const AttachmentReference,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const AttachmentReference,
    pub pResolveAttachments: *const AttachmentReference,
    pub pDepthStencilAttachment: *const AttachmentReference,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassDependency {
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: PipelineStageFlags,
    pub dstStageMask: PipelineStageFlags,
    pub srcAccessMask: AccessFlags, // Memory accesses from the source of the dependency to synchronize
    pub dstAccessMask: AccessFlags, // Memory accesses from the destination of the dependency to synchronize
    pub dependencyFlags: DependencyFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const AttachmentDescription,
    pub subpassCount: u32,
    pub pSubpasses: *const SubpassDescription,
    pub dependencyCount: u32,
    pub pDependencies: *const SubpassDependency,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct EventCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: EventCreateFlags, // Event creation flags
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FenceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: FenceCreateFlags, // Fence creation flags
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFeatures {
    pub robustBufferAccess: Bool32, // out of bounds buffer accesses are well defined
    pub fullDrawIndexUint32: Bool32, // full 32-bit range of indices for indexed draw calls
    pub imageCubeArray: Bool32, // image views which are arrays of cube maps
    pub independentBlend: Bool32, // blending operations are controlled per-attachment
    pub geometryShader: Bool32, // geometry stage
    pub tessellationShader: Bool32, // tessellation control and evaluation stage
    pub sampleRateShading: Bool32, // per-sample shading and interpolation
    pub dualSrcBlend: Bool32, // blend operations which take two sources
    pub logicOp: Bool32, // logic operations
    pub multiDrawIndirect: Bool32, // multi draw indirect
    pub drawIndirectFirstInstance: Bool32, // indirect drawing can use non-zero firstInstance
    pub depthClamp: Bool32, // depth clamping
    pub depthBiasClamp: Bool32, // depth bias clamping
    pub fillModeNonSolid: Bool32, // point and wireframe fill modes
    pub depthBounds: Bool32, // depth bounds test
    pub wideLines: Bool32, // lines with width greater than 1
    pub largePoints: Bool32, // points with size greater than 1
    pub alphaToOne: Bool32, // the fragment alpha component can be forced to maximum representable alpha value
    pub multiViewport: Bool32, // viewport arrays
    pub samplerAnisotropy: Bool32, // anisotropic sampler filtering
    pub textureCompressionETC2: Bool32, // ETC texture compression formats
    pub textureCompressionASTC_LDR: Bool32, // ASTC LDR texture compression formats
    pub textureCompressionBC: Bool32, // BC1-7 texture compressed formats
    pub occlusionQueryPrecise: Bool32, // precise occlusion queries returning actual sample counts
    pub pipelineStatisticsQuery: Bool32, // pipeline statistics query
    pub vertexPipelineStoresAndAtomics: Bool32, // stores and atomic ops on storage buffers and images are supported in vertex, tessellation, and geometry stages
    pub fragmentStoresAndAtomics: Bool32, // stores and atomic ops on storage buffers and images are supported in the fragment stage
    pub shaderTessellationAndGeometryPointSize: Bool32, // tessellation and geometry stages can export point size
    pub shaderImageGatherExtended: Bool32, // image gather with run-time values and independent offsets
    pub shaderStorageImageExtendedFormats: Bool32, // the extended set of formats can be used for storage images
    pub shaderStorageImageMultisample: Bool32, // multisample images can be used for storage images
    pub shaderStorageImageReadWithoutFormat: Bool32, // read from storage image does not require format qualifier
    pub shaderStorageImageWriteWithoutFormat: Bool32, // write to storage image does not require format qualifier
    pub shaderUniformBufferArrayDynamicIndexing: Bool32, // arrays of uniform buffers can be accessed with dynamically uniform indices
    pub shaderSampledImageArrayDynamicIndexing: Bool32, // arrays of sampled images can be accessed with dynamically uniform indices
    pub shaderStorageBufferArrayDynamicIndexing: Bool32, // arrays of storage buffers can be accessed with dynamically uniform indices
    pub shaderStorageImageArrayDynamicIndexing: Bool32, // arrays of storage images can be accessed with dynamically uniform indices
    pub shaderClipDistance: Bool32, // clip distance in shaders
    pub shaderCullDistance: Bool32, // cull distance in shaders
    pub shaderFloat64: Bool32, // 64-bit floats (doubles) in shaders
    pub shaderInt64: Bool32, // 64-bit integers in shaders
    pub shaderInt16: Bool32, // 16-bit integers in shaders
    pub shaderResourceResidency: Bool32, // shader can use texture operations that return resource residency information (requires sparseNonResident support)
    pub shaderResourceMinLod: Bool32, // shader can use texture operations that specify minimum resource LOD
    pub sparseBinding: Bool32, // Sparse resources support: Resource memory can be managed at opaque page level rather than object level
    pub sparseResidencyBuffer: Bool32, // Sparse resources support: GPU can access partially resident buffers
    pub sparseResidencyImage2D: Bool32, // Sparse resources support: GPU can access partially resident 2D (non-MSAA non-depth/stencil) images
    pub sparseResidencyImage3D: Bool32, // Sparse resources support: GPU can access partially resident 3D images
    pub sparseResidency2Samples: Bool32, // Sparse resources support: GPU can access partially resident MSAA 2D images with 2 samples
    pub sparseResidency4Samples: Bool32, // Sparse resources support: GPU can access partially resident MSAA 2D images with 4 samples
    pub sparseResidency8Samples: Bool32, // Sparse resources support: GPU can access partially resident MSAA 2D images with 8 samples
    pub sparseResidency16Samples: Bool32, // Sparse resources support: GPU can access partially resident MSAA 2D images with 16 samples
    pub sparseResidencyAliased: Bool32, // Sparse resources support: GPU can correctly access data aliased into multiple locations (opt-in)
    pub variableMultisampleRate: Bool32, // multisample rate must be the same for all pipelines in a subpass
    pub inheritedQueries: Bool32, // Queries may be inherited from primary to secondary command buffers
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSparseProperties {
    pub residencyStandard2DBlockShape: Bool32, // Sparse resources support: GPU will access all 2D (single sample) sparse resources using the standard sparse image block shapes (based on pixel format)
    pub residencyStandard2DMultisampleBlockShape: Bool32, // Sparse resources support: GPU will access all 2D (multisample) sparse resources using the standard sparse image block shapes (based on pixel format)
    pub residencyStandard3DBlockShape: Bool32, // Sparse resources support: GPU will access all 3D sparse resources using the standard sparse image block shapes (based on pixel format)
    pub residencyAlignedMipSize: Bool32, // Sparse resources support: Images with mip level dimensions that are NOT a multiple of the sparse image block dimensions will be placed in the mip tail
    pub residencyNonResidentStrict: Bool32, // Sparse resources support: GPU can consistently access non-resident regions of a resource, all reads return as if data is 0, writes are discarded
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceLimits {
    // resource maximum sizes
    pub maxImageDimension1D: u32, // max 1D image dimension
    pub maxImageDimension2D: u32, // max 2D image dimension
    pub maxImageDimension3D: u32, // max 3D image dimension
    pub maxImageDimensionCube: u32, // max cubemap image dimension
    pub maxImageArrayLayers: u32, // max layers for image arrays
    pub maxTexelBufferElements: u32, // max texel buffer size (fstexels)
    pub maxUniformBufferRange: u32, // max uniform buffer range (bytes)
    pub maxStorageBufferRange: u32, // max storage buffer range (bytes)
    pub maxPushConstantsSize: u32, // max size of the push constants pool (bytes)
    // memory limits
    pub maxMemoryAllocationCount: u32, // max number of device memory allocations supported
    pub maxSamplerAllocationCount: u32, // max number of samplers that can be allocated on a device
    pub bufferImageGranularity: DeviceSize, // Granularity (in bytes) at which buffers and images can be bound to adjacent memory for simultaneous usage
    pub sparseAddressSpaceSize: DeviceSize, // Total address space available for sparse allocations (bytes)
    // descriptor set limits
    pub maxBoundDescriptorSets: u32, // max number of descriptors sets that can be bound to a pipeline
    pub maxPerStageDescriptorSamplers: u32, // max number of samplers allowed per-stage in a descriptor set
    pub maxPerStageDescriptorUniformBuffers: u32, // max number of uniform buffers allowed per-stage in a descriptor set
    pub maxPerStageDescriptorStorageBuffers: u32, // max number of storage buffers allowed per-stage in a descriptor set
    pub maxPerStageDescriptorSampledImages: u32, // max number of sampled images allowed per-stage in a descriptor set
    pub maxPerStageDescriptorStorageImages: u32, // max number of storage images allowed per-stage in a descriptor set
    pub maxPerStageDescriptorInputAttachments: u32, // max number of input attachments allowed per-stage in a descriptor set
    pub maxPerStageResources: u32, // max number of resources allowed by a single stage
    pub maxDescriptorSetSamplers: u32, // max number of samplers allowed in all stages in a descriptor set
    pub maxDescriptorSetUniformBuffers: u32, // max number of uniform buffers allowed in all stages in a descriptor set
    pub maxDescriptorSetUniformBuffersDynamic: u32, // max number of dynamic uniform buffers allowed in all stages in a descriptor set
    pub maxDescriptorSetStorageBuffers: u32, // max number of storage buffers allowed in all stages in a descriptor set
    pub maxDescriptorSetStorageBuffersDynamic: u32, // max number of dynamic storage buffers allowed in all stages in a descriptor set
    pub maxDescriptorSetSampledImages: u32, // max number of sampled images allowed in all stages in a descriptor set
    pub maxDescriptorSetStorageImages: u32, // max number of storage images allowed in all stages in a descriptor set
    pub maxDescriptorSetInputAttachments: u32, // max number of input attachments allowed in all stages in a descriptor set
    // vertex stage limits
    pub maxVertexInputAttributes: u32, // max number of vertex input attribute slots
    pub maxVertexInputBindings: u32, // max number of vertex input binding slots
    pub maxVertexInputAttributeOffset: u32, // max vertex input attribute offset added to vertex buffer offset
    pub maxVertexInputBindingStride: u32, // max vertex input binding stride
    pub maxVertexOutputComponents: u32, // max number of output components written by vertex shader
    // tessellation control stage limits
    pub maxTessellationGenerationLevel: u32, // max level supported by tessellation primitive generator
    pub maxTessellationPatchSize: u32, // max patch size (vertices)
    pub maxTessellationControlPerVertexInputComponents: u32, // max number of input components per-vertex in TCS
    pub maxTessellationControlPerVertexOutputComponents: u32, // max number of output components per-vertex in TCS
    pub maxTessellationControlPerPatchOutputComponents: u32, // max number of output components per-patch in TCS
    pub maxTessellationControlTotalOutputComponents: u32, // max total number of per-vertex and per-patch output components in TCS
    // tessellation evaluation stage limits
    pub maxTessellationEvaluationInputComponents: u32, // max number of input components per vertex in TES
    pub maxTessellationEvaluationOutputComponents: u32, // max number of output components per vertex in TES
    // geometry stage limits
    pub maxGeometryShaderInvocations: u32, // max invocation count supported in geometry shader
    pub maxGeometryInputComponents: u32, // max number of input components read in geometry stage
    pub maxGeometryOutputComponents: u32, // max number of output components written in geometry stage
    pub maxGeometryOutputVertices: u32, // max number of vertices that can be emitted in geometry stage
    pub maxGeometryTotalOutputComponents: u32, // max total number of components (all vertices) written in geometry stage
    // fragment stage limits
    pub maxFragmentInputComponents: u32, // max number of input components read in fragment stage
    pub maxFragmentOutputAttachments: u32, // max number of output attachments written in fragment stage
    pub maxFragmentDualSrcAttachments: u32, // max number of output attachments written when using dual source blending
    pub maxFragmentCombinedOutputResources: u32, // max total number of storage buffers, storage images and output buffers
    // compute stage limits
    pub maxComputeSharedMemorySize: u32, // max total storage size of work group local storage (bytes)
    pub maxComputeWorkGroupCount: [u32; 3], // max num of compute work groups that may be dispatched by a single command (x,y,z)
    pub maxComputeWorkGroupInvocations: u32, // max total compute invocations in a single local work group
    pub maxComputeWorkGroupSize: [u32; 3], // max local size of a compute work group (x,y,z)
    pub subPixelPrecisionBits: u32, // number bits of subpixel precision in screen x and y
    pub subTexelPrecisionBits: u32, // number bits of precision for selecting texel weights
    pub mipmapPrecisionBits: u32, // number bits of precision for selecting mipmap weights
    pub maxDrawIndexedIndexValue: u32, // max index value for indexed draw calls (for 32-bit indices)
    pub maxDrawIndirectCount: u32, // max draw count for indirect drawing calls
    pub maxSamplerLodBias: f32, // max absolute sampler LOD bias
    pub maxSamplerAnisotropy: f32, // max degree of sampler anisotropy
    pub maxViewports: u32, // max number of active viewports
    pub maxViewportDimensions: [u32; 2], // max viewport dimensions (x,y)
    pub viewportBoundsRange: [f32; 2], // viewport bounds range (min,max)
    pub viewportSubPixelBits: u32, // number bits of subpixel precision for viewport
    pub minMemoryMapAlignment: usize, // min required alignment of pointers returned by MapMemory (bytes)
    pub minTexelBufferOffsetAlignment: DeviceSize, // min required alignment for texel buffer offsets (bytes)
    pub minUniformBufferOffsetAlignment: DeviceSize, // min required alignment for uniform buffer sizes and offsets (bytes)
    pub minStorageBufferOffsetAlignment: DeviceSize, // min required alignment for storage buffer offsets (bytes)
    pub minTexelOffset: i32, // min texel offset for OpTextureSampleOffset
    pub maxTexelOffset: u32, // max texel offset for OpTextureSampleOffset
    pub minTexelGatherOffset: i32, // min texel offset for OpTextureGatherOffset
    pub maxTexelGatherOffset: u32, // max texel offset for OpTextureGatherOffset
    pub minInterpolationOffset: f32, // furthest negative offset for interpolateAtOffset
    pub maxInterpolationOffset: f32, // furthest positive offset for interpolateAtOffset
    pub subPixelInterpolationOffsetBits: u32, // number of subpixel bits for interpolateAtOffset
    pub maxFramebufferWidth: u32, // max width for a framebuffer
    pub maxFramebufferHeight: u32, // max height for a framebuffer
    pub maxFramebufferLayers: u32, // max layer count for a layered framebuffer
    pub framebufferColorSampleCounts: SampleCountFlags, // supported color sample counts for a framebuffer
    pub framebufferDepthSampleCounts: SampleCountFlags, // supported depth sample counts for a framebuffer
    pub framebufferStencilSampleCounts: SampleCountFlags, // supported stencil sample counts for a framebuffer
    pub framebufferNoAttachmentsSampleCounts: SampleCountFlags, // supported sample counts for a subpass which uses no attachments
    pub maxColorAttachments: u32, // max number of color attachments per subpass
    pub sampledImageColorSampleCounts: SampleCountFlags, // supported color sample counts for a non-integer sampled image
    pub sampledImageIntegerSampleCounts: SampleCountFlags, // supported sample counts for an integer image
    pub sampledImageDepthSampleCounts: SampleCountFlags, // supported depth sample counts for a sampled image
    pub sampledImageStencilSampleCounts: SampleCountFlags, // supported stencil sample counts for a sampled image
    pub storageImageSampleCounts: SampleCountFlags, // supported sample counts for a storage image
    pub maxSampleMaskWords: u32, // max number of sample mask words
    pub timestampComputeAndGraphics: Bool32, // timestamps on graphics and compute queues
    pub timestampPeriod: f32, // number of nanoseconds it takes for timestamp query value to increment by 1
    pub maxClipDistances: u32, // max number of clip distances
    pub maxCullDistances: u32, // max number of cull distances
    pub maxCombinedClipAndCullDistances: u32, // max combined number of user clipping
    pub discreteQueuePriorities: u32, // distinct queue priorities available
    pub pointSizeRange: [f32; 2], // range (min,max) of supported point sizes
    pub lineWidthRange: [f32; 2], // range (min,max) of supported line widths
    pub pointSizeGranularity: f32, // granularity of supported point sizes
    pub lineWidthGranularity: f32, // granularity of supported line widths
    pub strictLines: Bool32, // line rasterization follows preferred rules
    pub standardSampleLocations: Bool32, // supports standard sample locations for all supported sample counts
    pub optimalBufferCopyOffsetAlignment: DeviceSize, // optimal offset of buffer copies
    pub optimalBufferCopyRowPitchAlignment: DeviceSize, // optimal pitch of buffer copies
    pub nonCoherentAtomSize: DeviceSize, // minimum size and alignment for non-coherent host-mapped device memory access
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SemaphoreCreateFlags, // Semaphore creation flags
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueryPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub queryType: QueryType,
    pub queryCount: u32,
    pub pipelineStatistics: QueryPipelineStatisticFlags, // Optional
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FramebufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub renderPass: RenderPass,
    pub attachmentCount: u32,
    pub pAttachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrawIndirectCommand {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub firstVertex: u32,
    pub firstInstance: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrawIndexedIndirectCommand {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub firstIndex: u32,
    pub vertexOffset: i32,
    pub firstInstance: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MultiDrawInfoEXT {
    pub firstVertex: u32,
    pub vertexCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MultiDrawIndexedInfoEXT {
    pub firstIndex: u32,
    pub indexCount: u32,
    pub vertexOffset: i32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const Semaphore,
    pub pWaitDstStageMask: *const PipelineStageFlags,
    pub commandBufferCount: u32,
    pub pCommandBuffers: *const CommandBuffer,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const Semaphore,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPropertiesKHR {
    pub display: DisplayKHR, // Handle of the display object
    pub displayName: *const c_char, // Name of the display
    pub physicalDimensions: Extent2D, // In millimeters?
    pub physicalResolution: Extent2D, // Max resolution for CRT?
    pub supportedTransforms: SurfaceTransformFlagsKHR, // one or more bits from VkSurfaceTransformFlagsKHR
    pub planeReorderPossible: Bool32, // VK_TRUE if the overlay plane's z-order can be changed on this display.
    pub persistentContent: Bool32, // VK_TRUE if this is a "smart" display that supports self-refresh/internal buffering.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPlanePropertiesKHR {
    pub currentDisplay: DisplayKHR, // Display the plane is currently associated with.  Will be VK_NULL_HANDLE if the plane is not in use.
    pub currentStackIndex: u32, // Current z-order of the plane.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayModeParametersKHR {
    pub visibleRegion: Extent2D, // Visible scanout region.
    pub refreshRate: u32, // Number of times per second the display is updated.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayModePropertiesKHR {
    pub displayMode: DisplayModeKHR, // Handle of this display mode.
    pub parameters: DisplayModeParametersKHR, // The parameters this mode uses.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayModeCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR, // The parameters this mode uses.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supportedAlpha: DisplayPlaneAlphaFlagsKHR, // Types of alpha blending supported, if any.
    pub minSrcPosition: Offset2D, // Does the plane have any position and extent restrictions?
    pub maxSrcPosition: Offset2D,
    pub minSrcExtent: Extent2D,
    pub maxSrcExtent: Extent2D,
    pub minDstPosition: Offset2D,
    pub maxDstPosition: Offset2D,
    pub minDstExtent: Extent2D,
    pub maxDstExtent: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplaySurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub displayMode: DisplayModeKHR, // The mode to use when displaying this surface
    pub planeIndex: u32, // The plane on which this surface appears.  Must be between 0 and the value returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR() in pPropertyCount.
    pub planeStackIndex: u32, // The z-order of the plane.
    pub transform: SurfaceTransformFlagBitsKHR, // Transform to apply to the images as part of the scanout operation
    pub globalAlpha: f32, // Global alpha value.  Must be between 0 and 1, inclusive.  Ignored if alphaMode is not VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR
    pub alphaMode: DisplayPlaneAlphaFlagBitsKHR, // What type of alpha blending to use.  Must be a bit from vkGetDisplayPlanePropertiesKHR::supportedAlpha.
    pub imageExtent: Extent2D, // size of the images to use with this surface
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPresentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcRect: Rect2D, // Rectangle within the presentable image to read pixel data from when presenting to the display.
    pub dstRect: Rect2D, // Rectangle within the current display mode's visible region to display srcRectangle in.
    pub persistent: Bool32, // For smart displays, use buffered mode.  If the display properties member "persistentMode" is VK_FALSE, this member must always be VK_FALSE.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceCapabilitiesKHR {
    pub minImageCount: u32, // Supported minimum number of images for the surface
    pub maxImageCount: u32, // Supported maximum number of images for the surface, 0 for unlimited
    pub currentExtent: Extent2D, // Current image width and height for the surface, (0, 0) if undefined
    pub minImageExtent: Extent2D, // Supported minimum image width and height for the surface
    pub maxImageExtent: Extent2D, // Supported maximum image width and height for the surface
    pub maxImageArrayLayers: u32, // Supported maximum number of image layers for the surface
    pub supportedTransforms: SurfaceTransformFlagsKHR, // 1 or more bits representing the transforms supported
    pub currentTransform: SurfaceTransformFlagBitsKHR, // The surface's current transform relative to the device's natural orientation
    pub supportedCompositeAlpha: CompositeAlphaFlagsKHR, // 1 or more bits representing the alpha compositing modes supported
    pub supportedUsageFlags: ImageUsageFlags, // Supported image usage flags for the surface
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceFormatKHR {
    pub format: Format, // Supported pair of rendering format
    pub colorSpace: ColorSpaceKHR, // and color space for the surface
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SwapchainCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR, // The swapchain's target surface
    pub minImageCount: u32, // Minimum number of presentation images the application needs
    pub imageFormat: Format, // Format of the presentation images
    pub imageColorSpace: ColorSpaceKHR, // Colorspace of the presentation images
    pub imageExtent: Extent2D, // Dimensions of the presentation images
    pub imageArrayLayers: u32, // Determines the number of views for multiview/stereo presentation
    pub imageUsage: ImageUsageFlags, // Bits indicating how the presentation images will be used
    pub imageSharingMode: SharingMode, // Sharing mode used for the presentation images
    pub queueFamilyIndexCount: u32, // Number of queue families having access to the images in case of concurrent sharing mode
    pub pQueueFamilyIndices: *const u32, // Array of queue family indices having access to the images in case of concurrent sharing mode
    pub preTransform: SurfaceTransformFlagBitsKHR, // The transform, relative to the device's natural orientation, applied to the image content prior to presentation
    pub compositeAlpha: CompositeAlphaFlagBitsKHR, // The alpha blending mode used when compositing this surface with other surfaces in the window system
    pub presentMode: PresentModeKHR, // Which presentation mode to use for presents on this swap chain
    pub clipped: Bool32, // Specifies whether presentable images may be affected by window clip regions
    pub oldSwapchain: SwapchainKHR, // Existing swap chain to replace, if any
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32, // Number of semaphores to wait for before presenting
    pub pWaitSemaphores: *const Semaphore, // Semaphores to wait for before presenting
    pub swapchainCount: u32, // Number of swapchains to present in this call
    pub pSwapchains: *const SwapchainKHR, // Swapchains to present an image from
    pub pImageIndices: *const u32, // Indices of which presentable images to present
    pub pResults: *mut Result, // Optional (i.e. if non-NULL) VkResult for each swapchain
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugReportCallbackCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DebugReportFlagsEXT, // Indicates which events call this callback
    pub pfnCallback: FnDebugReportCallbackEXT, // Function pointer of a callback function
    pub pUserData: *mut c_void, // User data provided to callback function
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ValidationFlagsEXT {
    pub sType: StructureType, // Must be VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT
    pub pNext: *const c_void,
    pub disabledValidationCheckCount: u32, // Number of validation checks to disable
    pub pDisabledValidationChecks: *const ValidationCheckEXT, // Validation checks to disable
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ValidationFeaturesEXT {
    pub sType: StructureType, // Must be VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT
    pub pNext: *const c_void,
    pub enabledValidationFeatureCount: u32, // Number of validation features to enable
    pub pEnabledValidationFeatures: *const ValidationFeatureEnableEXT, // Validation features to enable
    pub disabledValidationFeatureCount: u32, // Number of validation features to disable
    pub pDisabledValidationFeatures: *const ValidationFeatureDisableEXT, // Validation features to disable
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationStateRasterizationOrderAMD {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub rasterizationOrder: RasterizationOrderAMD, // Rasterization order to use for the pipeline
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugMarkerObjectNameInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub objectType: DebugReportObjectTypeEXT, // The type of the object
    pub object: u64, // The handle of the object, cast to uint64_t
    pub pObjectName: *const c_char, // Name to apply to the object
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugMarkerObjectTagInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub objectType: DebugReportObjectTypeEXT, // The type of the object
    pub object: u64, // The handle of the object, cast to uint64_t
    pub tagName: u64, // The name of the tag to set on the object
    pub tagSize: usize, // The length in bytes of the tag data
    pub pTag: *const c_void, // Tag data to attach to the object
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugMarkerMarkerInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pMarkerName: *const c_char, // Name of the debug marker
    pub color: [f32; 4], // Optional color for debug marker
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DedicatedAllocationImageCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dedicatedAllocation: Bool32, // Whether this image uses a dedicated allocation
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DedicatedAllocationBufferCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dedicatedAllocation: Bool32, // Whether this buffer uses a dedicated allocation
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DedicatedAllocationMemoryAllocateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image, // Image that this allocation will be bound to
    pub buffer: Buffer, // Buffer that this allocation will be bound to
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalImageFormatPropertiesNV {
    pub imageFormatProperties: ImageFormatProperties,
    pub externalMemoryFeatures: ExternalMemoryFeatureFlagsNV,
    pub exportFromImportedHandleTypes: ExternalMemoryHandleTypeFlagsNV,
    pub compatibleHandleTypes: ExternalMemoryHandleTypeFlagsNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalMemoryImageCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlagsNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExportMemoryAllocateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlagsNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceGeneratedCommands: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DevicePrivateDataCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub privateDataSlotRequestCount: u32,
}

pub type DevicePrivateDataCreateInfoEXT = DevicePrivateDataCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PrivateDataSlotCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PrivateDataSlotCreateFlags,
}

pub type PrivateDataSlotCreateInfoEXT = PrivateDataSlotCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePrivateDataFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub privateData: Bool32,
}

pub type PhysicalDevicePrivateDataFeaturesEXT = PhysicalDevicePrivateDataFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxGraphicsShaderGroupCount: u32,
    pub maxIndirectSequenceCount: u32,
    pub maxIndirectCommandsTokenCount: u32,
    pub maxIndirectCommandsStreamCount: u32,
    pub maxIndirectCommandsTokenOffset: u32,
    pub maxIndirectCommandsStreamStride: u32,
    pub minSequencesCountBufferOffsetAlignment: u32,
    pub minSequencesIndexBufferOffsetAlignment: u32,
    pub minIndirectCommandsBufferOffsetAlignment: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMultiDrawPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxMultiDrawCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GraphicsShaderGroupCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub stageCount: u32,
    pub pStages: *const PipelineShaderStageCreateInfo,
    pub pVertexInputState: *const PipelineVertexInputStateCreateInfo,
    pub pTessellationState: *const PipelineTessellationStateCreateInfo,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GraphicsPipelineShaderGroupsCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub groupCount: u32,
    pub pGroups: *const GraphicsShaderGroupCreateInfoNV,
    pub pipelineCount: u32,
    pub pPipelines: *const Pipeline,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindShaderGroupIndirectCommandNV {
    pub groupIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindIndexBufferIndirectCommandNV {
    pub bufferAddress: DeviceAddress,
    pub size: u32,
    pub indexType: IndexType,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindVertexBufferIndirectCommandNV {
    pub bufferAddress: DeviceAddress,
    pub size: u32,
    pub stride: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SetStateFlagsIndirectCommandNV {
    pub data: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct IndirectCommandsStreamNV {
    pub buffer: Buffer,
    pub offset: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct IndirectCommandsLayoutTokenNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub tokenType: IndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertexBindingUnit: u32,
    pub vertexDynamicStride: Bool32,
    pub pushconstantPipelineLayout: PipelineLayout,
    pub pushconstantShaderStageFlags: ShaderStageFlags,
    pub pushconstantOffset: u32,
    pub pushconstantSize: u32,
    pub indirectStateFlags: IndirectStateFlagsNV,
    pub indexTypeCount: u32,
    pub pIndexTypes: *const IndexType,
    pub pIndexTypeValues: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct IndirectCommandsLayoutCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: IndirectCommandsLayoutUsageFlagsNV,
    pub pipelineBindPoint: PipelineBindPoint,
    pub tokenCount: u32,
    pub pTokens: *const IndirectCommandsLayoutTokenNV,
    pub streamCount: u32,
    pub pStreamStrides: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeneratedCommandsInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pipelineBindPoint: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirectCommandsLayout: IndirectCommandsLayoutNV,
    pub streamCount: u32,
    pub pStreams: *const IndirectCommandsStreamNV,
    pub sequencesCount: u32,
    pub preprocessBuffer: Buffer,
    pub preprocessOffset: DeviceSize,
    pub preprocessSize: DeviceSize,
    pub sequencesCountBuffer: Buffer,
    pub sequencesCountOffset: DeviceSize,
    pub sequencesIndexBuffer: Buffer,
    pub sequencesIndexOffset: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeneratedCommandsMemoryRequirementsInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pipelineBindPoint: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirectCommandsLayout: IndirectCommandsLayoutNV,
    pub maxSequencesCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFeatures2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub features: PhysicalDeviceFeatures,
}

pub type PhysicalDeviceFeatures2KHR = PhysicalDeviceFeatures2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub properties: PhysicalDeviceProperties,
}

pub type PhysicalDeviceProperties2KHR = PhysicalDeviceProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FormatProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub formatProperties: FormatProperties,
}

pub type FormatProperties2KHR = FormatProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageFormatProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imageFormatProperties: ImageFormatProperties,
}

pub type ImageFormatProperties2KHR = ImageFormatProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImageFormatInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub format: Format,
    pub typ: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
}

pub type PhysicalDeviceImageFormatInfo2KHR = PhysicalDeviceImageFormatInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub queueFamilyProperties: QueueFamilyProperties,
}

pub type QueueFamilyProperties2KHR = QueueFamilyProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMemoryProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryProperties: PhysicalDeviceMemoryProperties,
}

pub type PhysicalDeviceMemoryProperties2KHR = PhysicalDeviceMemoryProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageFormatProperties2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub properties: SparseImageFormatProperties,
}

pub type SparseImageFormatProperties2KHR = SparseImageFormatProperties2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSparseImageFormatInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub format: Format,
    pub typ: ImageType,
    pub samples: SampleCountFlagBits,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
}

pub type PhysicalDeviceSparseImageFormatInfo2KHR = PhysicalDeviceSparseImageFormatInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePushDescriptorPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxPushDescriptors: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}

pub type ConformanceVersionKHR = ConformanceVersion;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDriverProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub driverID: DriverId,
    pub driverName: [c_char; MAX_DRIVER_NAME_SIZE as usize],
    pub driverInfo: [c_char; MAX_DRIVER_INFO_SIZE as usize],
    pub conformanceVersion: ConformanceVersion,
}

pub type PhysicalDeviceDriverPropertiesKHR = PhysicalDeviceDriverProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentRegionsKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchainCount: u32, // Copy of VkPresentInfoKHR::swapchainCount
    pub pRegions: *const PresentRegionKHR, // The regions that have changed
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentRegionKHR {
    pub rectangleCount: u32, // Number of rectangles in pRectangles
    pub pRectangles: *const RectLayerKHR, // Array of rectangles that have changed in a swapchain's image(s)
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RectLayerKHR {
    pub offset: Offset2D, // upper-left corner of a rectangle that has not changed, in pixels of a presentation images
    pub extent: Extent2D, // Dimensions of a rectangle that has not changed, in pixels of a presentation images
    pub layer: u32, // Layer of a swapchain's image(s), for stereoscopic-3D images
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVariablePointersFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub variablePointersStorageBuffer: Bool32,
    pub variablePointers: Bool32,
}

pub type PhysicalDeviceVariablePointersFeaturesKHR = PhysicalDeviceVariablePointersFeatures;

pub type PhysicalDeviceVariablePointerFeaturesKHR = PhysicalDeviceVariablePointersFeatures;

pub type PhysicalDeviceVariablePointerFeatures = PhysicalDeviceVariablePointersFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalMemoryProperties {
    pub externalMemoryFeatures: ExternalMemoryFeatureFlags,
    pub exportFromImportedHandleTypes: ExternalMemoryHandleTypeFlags,
    pub compatibleHandleTypes: ExternalMemoryHandleTypeFlags,
}

pub type ExternalMemoryPropertiesKHR = ExternalMemoryProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalImageFormatInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
}

pub type PhysicalDeviceExternalImageFormatInfoKHR = PhysicalDeviceExternalImageFormatInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalImageFormatProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub externalMemoryProperties: ExternalMemoryProperties,
}

pub type ExternalImageFormatPropertiesKHR = ExternalImageFormatProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalBufferInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: BufferCreateFlags,
    pub usage: BufferUsageFlags,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
}

pub type PhysicalDeviceExternalBufferInfoKHR = PhysicalDeviceExternalBufferInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalBufferProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub externalMemoryProperties: ExternalMemoryProperties,
}

pub type ExternalBufferPropertiesKHR = ExternalBufferProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceIDProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceUUID: [u8; UUID_SIZE as usize],
    pub driverUUID: [u8; UUID_SIZE as usize],
    pub deviceLUID: [u8; LUID_SIZE as usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: Bool32,
}

pub type PhysicalDeviceIDPropertiesKHR = PhysicalDeviceIDProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalMemoryImageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlags,
}

pub type ExternalMemoryImageCreateInfoKHR = ExternalMemoryImageCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalMemoryBufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlags,
}

pub type ExternalMemoryBufferCreateInfoKHR = ExternalMemoryBufferCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExportMemoryAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlags,
}

pub type ExportMemoryAllocateInfoKHR = ExportMemoryAllocateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImportMemoryFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
    pub fd: c_int,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryFdPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryTypeBits: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryGetFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalSemaphoreInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalSemaphoreHandleTypeFlagBits,
}

pub type PhysicalDeviceExternalSemaphoreInfoKHR = PhysicalDeviceExternalSemaphoreInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalSemaphoreProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub exportFromImportedHandleTypes: ExternalSemaphoreHandleTypeFlags,
    pub compatibleHandleTypes: ExternalSemaphoreHandleTypeFlags,
    pub externalSemaphoreFeatures: ExternalSemaphoreFeatureFlags,
}

pub type ExternalSemaphorePropertiesKHR = ExternalSemaphoreProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExportSemaphoreCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalSemaphoreHandleTypeFlags,
}

pub type ExportSemaphoreCreateInfoKHR = ExportSemaphoreCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImportSemaphoreFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handleType: ExternalSemaphoreHandleTypeFlagBits,
    pub fd: c_int,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreGetFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub semaphore: Semaphore,
    pub handleType: ExternalSemaphoreHandleTypeFlagBits,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalFenceInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalFenceHandleTypeFlagBits,
}

pub type PhysicalDeviceExternalFenceInfoKHR = PhysicalDeviceExternalFenceInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExternalFenceProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub exportFromImportedHandleTypes: ExternalFenceHandleTypeFlags,
    pub compatibleHandleTypes: ExternalFenceHandleTypeFlags,
    pub externalFenceFeatures: ExternalFenceFeatureFlags,
}

pub type ExternalFencePropertiesKHR = ExternalFenceProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExportFenceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalFenceHandleTypeFlags,
}

pub type ExportFenceCreateInfoKHR = ExportFenceCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImportFenceFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handleType: ExternalFenceHandleTypeFlagBits,
    pub fd: c_int,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FenceGetFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub fence: Fence,
    pub handleType: ExternalFenceHandleTypeFlagBits,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMultiviewFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub multiview: Bool32, // Multiple views in a renderpass
    pub multiviewGeometryShader: Bool32, // Multiple views in a renderpass w/ geometry shader
    pub multiviewTessellationShader: Bool32, // Multiple views in a renderpass w/ tessellation shader
}

pub type PhysicalDeviceMultiviewFeaturesKHR = PhysicalDeviceMultiviewFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMultiviewProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxMultiviewViewCount: u32, // max number of views in a subpass
    pub maxMultiviewInstanceIndex: u32, // max instance index for a draw in a multiview subpass
}

pub type PhysicalDeviceMultiviewPropertiesKHR = PhysicalDeviceMultiviewProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassMultiviewCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub subpassCount: u32,
    pub pViewMasks: *const u32,
    pub dependencyCount: u32,
    pub pViewOffsets: *const i32,
    pub correlationMaskCount: u32,
    pub pCorrelationMasks: *const u32,
}

pub type RenderPassMultiviewCreateInfoKHR = RenderPassMultiviewCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceCapabilities2EXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minImageCount: u32, // Supported minimum number of images for the surface
    pub maxImageCount: u32, // Supported maximum number of images for the surface, 0 for unlimited
    pub currentExtent: Extent2D, // Current image width and height for the surface, (0, 0) if undefined
    pub minImageExtent: Extent2D, // Supported minimum image width and height for the surface
    pub maxImageExtent: Extent2D, // Supported maximum image width and height for the surface
    pub maxImageArrayLayers: u32, // Supported maximum number of image layers for the surface
    pub supportedTransforms: SurfaceTransformFlagsKHR, // 1 or more bits representing the transforms supported
    pub currentTransform: SurfaceTransformFlagBitsKHR, // The surface's current transform relative to the device's natural orientation
    pub supportedCompositeAlpha: CompositeAlphaFlagsKHR, // 1 or more bits representing the alpha compositing modes supported
    pub supportedUsageFlags: ImageUsageFlags, // Supported image usage flags for the surface
    pub supportedSurfaceCounters: SurfaceCounterFlagsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPowerInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub powerState: DisplayPowerStateEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceEventInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceEvent: DeviceEventTypeEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayEventInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub displayEvent: DisplayEventTypeEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SwapchainCounterCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub surfaceCounters: SurfaceCounterFlagsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceGroupProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub physicalDeviceCount: u32,
    pub physicalDevices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE as usize],
    pub subsetAllocation: Bool32,
}

pub type PhysicalDeviceGroupPropertiesKHR = PhysicalDeviceGroupProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryAllocateFlagsInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: MemoryAllocateFlags,
    pub deviceMask: u32,
}

pub type MemoryAllocateFlagsInfoKHR = MemoryAllocateFlagsInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindBufferMemoryInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
}

pub type BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindBufferMemoryDeviceGroupInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}

pub type BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindImageMemoryInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
}

pub type BindImageMemoryInfoKHR = BindImageMemoryInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindImageMemoryDeviceGroupInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
    pub splitInstanceBindRegionCount: u32,
    pub pSplitInstanceBindRegions: *const Rect2D,
}

pub type BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupRenderPassBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceMask: u32,
    pub deviceRenderAreaCount: u32,
    pub pDeviceRenderAreas: *const Rect2D,
}

pub type DeviceGroupRenderPassBeginInfoKHR = DeviceGroupRenderPassBeginInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupCommandBufferBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceMask: u32,
}

pub type DeviceGroupCommandBufferBeginInfoKHR = DeviceGroupCommandBufferBeginInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupSubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphoreDeviceIndices: *const u32,
    pub commandBufferCount: u32,
    pub pCommandBufferDeviceMasks: *const u32,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphoreDeviceIndices: *const u32,
}

pub type DeviceGroupSubmitInfoKHR = DeviceGroupSubmitInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupBindSparseInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub resourceDeviceIndex: u32,
    pub memoryDeviceIndex: u32,
}

pub type DeviceGroupBindSparseInfoKHR = DeviceGroupBindSparseInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupPresentCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub presentMask: [u32; MAX_DEVICE_GROUP_SIZE as usize],
    pub modes: DeviceGroupPresentModeFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageSwapchainCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchain: SwapchainKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindImageMemorySwapchainInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchain: SwapchainKHR,
    pub imageIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AcquireNextImageInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchain: SwapchainKHR,
    pub timeout: u64,
    pub semaphore: Semaphore,
    pub fence: Fence,
    pub deviceMask: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupPresentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchainCount: u32,
    pub pDeviceMasks: *const u32,
    pub mode: DeviceGroupPresentModeFlagBitsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupDeviceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub physicalDeviceCount: u32,
    pub pPhysicalDevices: *const PhysicalDevice,
}

pub type DeviceGroupDeviceCreateInfoKHR = DeviceGroupDeviceCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceGroupSwapchainCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub modes: DeviceGroupPresentModeFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorUpdateTemplateEntry {
    pub dstBinding: u32, // Binding within the destination descriptor set to write
    pub dstArrayElement: u32, // Array element within the destination binding to write
    pub descriptorCount: u32, // Number of descriptors to write
    pub descriptorType: DescriptorType, // Descriptor type to write
    pub offset: usize, // Offset into pData where the descriptors to update are stored
    pub stride: usize, // Stride between two descriptors in pData when writing more than one descriptor
}

pub type DescriptorUpdateTemplateEntryKHR = DescriptorUpdateTemplateEntry;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorUpdateTemplateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorUpdateTemplateCreateFlags,
    pub descriptorUpdateEntryCount: u32, // Number of descriptor update entries to use for the update template
    pub pDescriptorUpdateEntries: *const DescriptorUpdateTemplateEntry, // Descriptor update entries for the template
    pub templateType: DescriptorUpdateTemplateType,
    pub descriptorSetLayout: DescriptorSetLayout,
    pub pipelineBindPoint: PipelineBindPoint,
    pub pipelineLayout: PipelineLayout, // If used for push descriptors, this is the only allowed layout
    pub set: u32,
}

pub type DescriptorUpdateTemplateCreateInfoKHR = DescriptorUpdateTemplateCreateInfo;

// Chromaticity coordinate
#[repr(C)]
#[derive(Copy, Clone)]
pub struct XYColorEXT {
    pub x: f32,
    pub y: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePresentIdFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub presentId: Bool32, // Present ID in VkPresentInfoKHR
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentIdKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchainCount: u32, // Copy of VkPresentInfoKHR::swapchainCount
    pub pPresentIds: *const u64, // Present ID values for each swapchain
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePresentWaitFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub presentWait: Bool32, // vkWaitForPresentKHR is supported
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct HdrMetadataEXT {
    // Display primary in chromaticity coordinates
    pub sType: StructureType,
    pub pNext: *const c_void,
    // From SMPTE 2086
    pub displayPrimaryRed: XYColorEXT, // Display primary's Red
    pub displayPrimaryGreen: XYColorEXT, // Display primary's Green
    pub displayPrimaryBlue: XYColorEXT, // Display primary's Blue
    pub whitePoint: XYColorEXT, // Display primary's Blue
    pub maxLuminance: f32, // Display maximum luminance
    pub minLuminance: f32, // Display minimum luminance
    // From CTA 861.3
    pub maxContentLightLevel: f32, // Content maximum luminance
    pub maxFrameAverageLightLevel: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMD {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub localDimmingSupport: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SwapchainDisplayNativeHdrCreateInfoAMD {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub localDimmingEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RefreshCycleDurationGOOGLE {
    pub refreshDuration: u64, // Number of nanoseconds from the start of one refresh cycle to the next
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PastPresentationTimingGOOGLE {
    pub presentID: u32, // Application-provided identifier, previously given to vkQueuePresentKHR
    pub desiredPresentTime: u64, // Earliest time an image should have been presented, previously given to vkQueuePresentKHR
    pub actualPresentTime: u64, // Time the image was actually displayed
    pub earliestPresentTime: u64, // Earliest time the image could have been displayed
    pub presentMargin: u64, // How early vkQueuePresentKHR was processed vs. how soon it needed to be and make earliestPresentTime
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentTimesInfoGOOGLE {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchainCount: u32, // Copy of VkPresentInfoKHR::swapchainCount
    pub pTimes: *const PresentTimeGOOGLE, // The earliest times to present images
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PresentTimeGOOGLE {
    pub presentID: u32, // Application-provided identifier
    pub desiredPresentTime: u64, // Earliest time an image should be presented
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportWScalingStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub viewportWScalingEnable: Bool32,
    pub viewportCount: u32,
    pub pViewportWScalings: *const ViewportWScalingNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ViewportSwizzleNV {
    pub x: ViewportCoordinateSwizzleNV,
    pub y: ViewportCoordinateSwizzleNV,
    pub z: ViewportCoordinateSwizzleNV,
    pub w: ViewportCoordinateSwizzleNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportSwizzleStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineViewportSwizzleStateCreateFlagsNV,
    pub viewportCount: u32,
    pub pViewportSwizzles: *const ViewportSwizzleNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxDiscardRectangles: u32, // max number of active discard rectangles
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineDiscardRectangleStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineDiscardRectangleStateCreateFlagsEXT,
    pub discardRectangleMode: DiscardRectangleModeEXT,
    pub discardRectangleCount: u32,
    pub pDiscardRectangles: *const Rect2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub perViewPositionAllComponents: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct InputAttachmentAspectReference {
    pub subpass: u32,
    pub inputAttachmentIndex: u32,
    pub aspectMask: ImageAspectFlags,
}

pub type InputAttachmentAspectReferenceKHR = InputAttachmentAspectReference;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassInputAttachmentAspectCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub aspectReferenceCount: u32,
    pub pAspectReferences: *const InputAttachmentAspectReference,
}

pub type RenderPassInputAttachmentAspectCreateInfoKHR = RenderPassInputAttachmentAspectCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSurfaceInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub surface: SurfaceKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceCapabilities2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub surfaceCapabilities: SurfaceCapabilitiesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceFormat2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub surfaceFormat: SurfaceFormatKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub displayProperties: DisplayPropertiesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPlaneProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub displayPlaneProperties: DisplayPlanePropertiesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayModeProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub displayModeProperties: DisplayModePropertiesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPlaneInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub mode: DisplayModeKHR,
    pub planeIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DisplayPlaneCapabilities2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub capabilities: DisplayPlaneCapabilitiesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SharedPresentSurfaceCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub sharedPresentSupportedUsageFlags: ImageUsageFlags, // Supported image usage flags if swapchain created using a shared present mode
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevice16BitStorageFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer16BitAccess: Bool32, // 16-bit integer/floating-point variables supported in BufferBlock
    pub uniformAndStorageBuffer16BitAccess: Bool32, // 16-bit integer/floating-point variables supported in BufferBlock and Block
    pub storagePushConstant16: Bool32, // 16-bit integer/floating-point variables supported in PushConstant
    pub storageInputOutput16: Bool32, // 16-bit integer/floating-point variables supported in shader inputs and outputs
}

pub type PhysicalDevice16BitStorageFeaturesKHR = PhysicalDevice16BitStorageFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSubgroupProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub subgroupSize: u32, // The size of a subgroup for this queue.
    pub supportedStages: ShaderStageFlags, // Bitfield of what shader stages support subgroup operations
    pub supportedOperations: SubgroupFeatureFlags, // Bitfield of what subgroup operations are supported.
    pub quadOperationsInAllStages: Bool32, // Flag to specify whether quad operations are available in all stages.
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSubgroupExtendedTypes: Bool32, // Flag to specify whether subgroup operations with extended types are supported
}

pub type PhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferMemoryRequirementsInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
}

pub type BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceBufferMemoryRequirements {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pCreateInfo: *const BufferCreateInfo,
}

pub type DeviceBufferMemoryRequirementsKHR = DeviceBufferMemoryRequirements;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageMemoryRequirementsInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image,
}

pub type ImageMemoryRequirementsInfo2KHR = ImageMemoryRequirementsInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageSparseMemoryRequirementsInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image,
}

pub type ImageSparseMemoryRequirementsInfo2KHR = ImageSparseMemoryRequirementsInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceImageMemoryRequirements {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pCreateInfo: *const ImageCreateInfo,
    pub planeAspect: ImageAspectFlagBits,
}

pub type DeviceImageMemoryRequirementsKHR = DeviceImageMemoryRequirements;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryRequirements2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryRequirements: MemoryRequirements,
}

pub type MemoryRequirements2KHR = MemoryRequirements2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SparseImageMemoryRequirements2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryRequirements: SparseImageMemoryRequirements,
}

pub type SparseImageMemoryRequirements2KHR = SparseImageMemoryRequirements2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePointClippingProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pointClippingBehavior: PointClippingBehavior,
}

pub type PhysicalDevicePointClippingPropertiesKHR = PhysicalDevicePointClippingProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryDedicatedRequirements {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub prefersDedicatedAllocation: Bool32,
    pub requiresDedicatedAllocation: Bool32,
}

pub type MemoryDedicatedRequirementsKHR = MemoryDedicatedRequirements;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryDedicatedAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image, // Image that this allocation will be bound to
    pub buffer: Buffer, // Buffer that this allocation will be bound to
}

pub type MemoryDedicatedAllocateInfoKHR = MemoryDedicatedAllocateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewUsageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub usage: ImageUsageFlags,
}

pub type ImageViewUsageCreateInfoKHR = ImageViewUsageCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineTessellationDomainOriginStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub domainOrigin: TessellationDomainOrigin,
}

pub type PipelineTessellationDomainOriginStateCreateInfoKHR = PipelineTessellationDomainOriginStateCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerYcbcrConversionInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub conversion: SamplerYcbcrConversion,
}

pub type SamplerYcbcrConversionInfoKHR = SamplerYcbcrConversionInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerYcbcrConversionCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub format: Format,
    pub ycbcrModel: SamplerYcbcrModelConversion,
    pub ycbcrRange: SamplerYcbcrRange,
    pub components: ComponentMapping,
    pub xChromaOffset: ChromaLocation,
    pub yChromaOffset: ChromaLocation,
    pub chromaFilter: Filter,
    pub forceExplicitReconstruction: Bool32,
}

pub type SamplerYcbcrConversionCreateInfoKHR = SamplerYcbcrConversionCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindImagePlaneMemoryInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub planeAspect: ImageAspectFlagBits,
}

pub type BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImagePlaneMemoryRequirementsInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub planeAspect: ImageAspectFlagBits,
}

pub type ImagePlaneMemoryRequirementsInfoKHR = ImagePlaneMemoryRequirementsInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSamplerYcbcrConversionFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub samplerYcbcrConversion: Bool32, // Sampler color conversion supported
}

pub type PhysicalDeviceSamplerYcbcrConversionFeaturesKHR = PhysicalDeviceSamplerYcbcrConversionFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerYcbcrConversionImageFormatProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub combinedImageSamplerDescriptorCount: u32,
}

pub type SamplerYcbcrConversionImageFormatPropertiesKHR = SamplerYcbcrConversionImageFormatProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct TextureLODGatherFormatPropertiesAMD {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub supportsTextureGatherLODBiasAMD: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ConditionalRenderingBeginInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub flags: ConditionalRenderingFlagsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ProtectedSubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub protectedSubmit: Bool32, // Submit protected command buffers
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProtectedMemoryFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub protectedMemory: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProtectedMemoryProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub protectedNoFault: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceQueueInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCoverageToColorStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCoverageToColorStateCreateFlagsNV,
    pub coverageToColorEnable: Bool32,
    pub coverageToColorLocation: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSamplerFilterMinmaxProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub filterMinmaxSingleComponentFormats: Bool32,
    pub filterMinmaxImageComponentMapping: Bool32,
}

pub type PhysicalDeviceSamplerFilterMinmaxPropertiesEXT = PhysicalDeviceSamplerFilterMinmaxProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SampleLocationEXT {
    pub x: f32,
    pub y: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SampleLocationsInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub sampleLocationsPerPixel: SampleCountFlagBits,
    pub sampleLocationGridSize: Extent2D,
    pub sampleLocationsCount: u32,
    pub pSampleLocations: *const SampleLocationEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentSampleLocationsEXT {
    pub attachmentIndex: u32,
    pub sampleLocationsInfo: SampleLocationsInfoEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassSampleLocationsEXT {
    pub subpassIndex: u32,
    pub sampleLocationsInfo: SampleLocationsInfoEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassSampleLocationsBeginInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub attachmentInitialSampleLocationsCount: u32,
    pub pAttachmentInitialSampleLocations: *const AttachmentSampleLocationsEXT,
    pub postSubpassSampleLocationsCount: u32,
    pub pPostSubpassSampleLocations: *const SubpassSampleLocationsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineSampleLocationsStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub sampleLocationsEnable: Bool32,
    pub sampleLocationsInfo: SampleLocationsInfoEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSampleLocationsPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub sampleLocationSampleCounts: SampleCountFlags,
    pub maxSampleLocationGridSize: Extent2D,
    pub sampleLocationCoordinateRange: [f32; 2],
    pub sampleLocationSubPixelBits: u32,
    pub variableSampleLocations: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MultisamplePropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxSampleLocationGridSize: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerReductionModeCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub reductionMode: SamplerReductionMode,
}

pub type SamplerReductionModeCreateInfoEXT = SamplerReductionModeCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub advancedBlendCoherentOperations: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMultiDrawFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub multiDraw: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub advancedBlendMaxColorAttachments: u32,
    pub advancedBlendIndependentBlend: Bool32,
    pub advancedBlendNonPremultipliedSrcColor: Bool32,
    pub advancedBlendNonPremultipliedDstColor: Bool32,
    pub advancedBlendCorrelatedOverlap: Bool32,
    pub advancedBlendAllOperations: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcPremultiplied: Bool32,
    pub dstPremultiplied: Bool32,
    pub blendOverlap: BlendOverlapEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceInlineUniformBlockFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub inlineUniformBlock: Bool32,
    pub descriptorBindingInlineUniformBlockUpdateAfterBind: Bool32,
}

pub type PhysicalDeviceInlineUniformBlockFeaturesEXT = PhysicalDeviceInlineUniformBlockFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceInlineUniformBlockProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxInlineUniformBlockSize: u32,
    pub maxPerStageDescriptorInlineUniformBlocks: u32,
    pub maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks: u32,
    pub maxDescriptorSetInlineUniformBlocks: u32,
    pub maxDescriptorSetUpdateAfterBindInlineUniformBlocks: u32,
}

pub type PhysicalDeviceInlineUniformBlockPropertiesEXT = PhysicalDeviceInlineUniformBlockProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct WriteDescriptorSetInlineUniformBlock {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dataSize: u32,
    pub pData: *const c_void,
}

pub type WriteDescriptorSetInlineUniformBlockEXT = WriteDescriptorSetInlineUniformBlock;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorPoolInlineUniformBlockCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub maxInlineUniformBlockBindings: u32,
}

pub type DescriptorPoolInlineUniformBlockCreateInfoEXT = DescriptorPoolInlineUniformBlockCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCoverageModulationStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCoverageModulationStateCreateFlagsNV,
    pub coverageModulationMode: CoverageModulationModeNV,
    pub coverageModulationTableEnable: Bool32,
    pub coverageModulationTableCount: u32,
    pub pCoverageModulationTable: *const f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageFormatListCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub viewFormatCount: u32,
    pub pViewFormats: *const Format,
}

pub type ImageFormatListCreateInfoKHR = ImageFormatListCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ValidationCacheCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ValidationCacheCreateFlagsEXT,
    pub initialDataSize: usize,
    pub pInitialData: *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShaderModuleValidationCacheCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub validationCache: ValidationCacheEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMaintenance3Properties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: DeviceSize,
}

pub type PhysicalDeviceMaintenance3PropertiesKHR = PhysicalDeviceMaintenance3Properties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMaintenance4Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maintenance4: Bool32,
}

pub type PhysicalDeviceMaintenance4FeaturesKHR = PhysicalDeviceMaintenance4Features;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMaintenance4Properties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxBufferSize: DeviceSize,
}

pub type PhysicalDeviceMaintenance4PropertiesKHR = PhysicalDeviceMaintenance4Properties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetLayoutSupport {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub supported: Bool32,
}

pub type DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderDrawParametersFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderDrawParameters: Bool32,
}

pub type PhysicalDeviceShaderDrawParameterFeatures = PhysicalDeviceShaderDrawParametersFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderFloat16Int8Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderFloat16: Bool32, // 16-bit floats (halfs) in shaders
    pub shaderInt8: Bool32, // 8-bit integers in shaders
}

pub type PhysicalDeviceShaderFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;

pub type PhysicalDeviceFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFloatControlsProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub denormBehaviorIndependence: ShaderFloatControlsIndependence,
    pub roundingModeIndependence: ShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderSignedZeroInfNanPreserveFloat32: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderSignedZeroInfNanPreserveFloat64: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderDenormPreserveFloat16: Bool32, // An implementation can preserve  denormals
    pub shaderDenormPreserveFloat32: Bool32, // An implementation can preserve  denormals
    pub shaderDenormPreserveFloat64: Bool32, // An implementation can preserve  denormals
    pub shaderDenormFlushToZeroFloat16: Bool32, // An implementation can flush to zero  denormals
    pub shaderDenormFlushToZeroFloat32: Bool32, // An implementation can flush to zero  denormals
    pub shaderDenormFlushToZeroFloat64: Bool32, // An implementation can flush to zero  denormals
    pub shaderRoundingModeRTEFloat16: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTEFloat32: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTEFloat64: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTZFloat16: Bool32, // An implementation can support RTZ
    pub shaderRoundingModeRTZFloat32: Bool32, // An implementation can support RTZ
    pub shaderRoundingModeRTZFloat64: Bool32, // An implementation can support RTZ
}

pub type PhysicalDeviceFloatControlsPropertiesKHR = PhysicalDeviceFloatControlsProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceHostQueryResetFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub hostQueryReset: Bool32,
}

pub type PhysicalDeviceHostQueryResetFeaturesEXT = PhysicalDeviceHostQueryResetFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShaderResourceUsageAMD {
    pub numUsedVgprs: u32,
    pub numUsedSgprs: u32,
    pub ldsSizePerLocalWorkGroup: u32,
    pub ldsUsageSizeInBytes: usize,
    pub scratchMemUsageInBytes: usize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShaderStatisticsInfoAMD {
    pub shaderStageMask: ShaderStageFlags,
    pub resourceUsage: ShaderResourceUsageAMD,
    pub numPhysicalVgprs: u32,
    pub numPhysicalSgprs: u32,
    pub numAvailableVgprs: u32,
    pub numAvailableSgprs: u32,
    pub computeWorkGroupSize: [u32; 3],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceQueueGlobalPriorityCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub globalPriority: QueueGlobalPriorityKHR,
}

pub type DeviceQueueGlobalPriorityCreateInfoEXT = DeviceQueueGlobalPriorityCreateInfoKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceGlobalPriorityQueryFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub globalPriorityQuery: Bool32,
}

pub type PhysicalDeviceGlobalPriorityQueryFeaturesEXT = PhysicalDeviceGlobalPriorityQueryFeaturesKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyGlobalPriorityPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub priorityCount: u32,
    pub priorities: [QueueGlobalPriorityKHR; MAX_GLOBAL_PRIORITY_SIZE_KHR as usize],
}

pub type QueueFamilyGlobalPriorityPropertiesEXT = QueueFamilyGlobalPriorityPropertiesKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsObjectNameInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub objectType: ObjectType,
    pub objectHandle: u64,
    pub pObjectName: *const c_char,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsObjectTagInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub objectType: ObjectType,
    pub objectHandle: u64,
    pub tagName: u64,
    pub tagSize: usize,
    pub pTag: *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsLabelEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pLabelName: *const c_char,
    pub color: [f32; 4],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsMessengerCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DebugUtilsMessengerCreateFlagsEXT,
    pub messageSeverity: DebugUtilsMessageSeverityFlagsEXT,
    pub messageType: DebugUtilsMessageTypeFlagsEXT,
    pub pfnUserCallback: FnDebugUtilsMessengerCallbackEXT,
    pub pUserData: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DebugUtilsMessengerCallbackDataEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DebugUtilsMessengerCallbackDataFlagsEXT,
    pub pMessageIdName: *const c_char,
    pub messageIdNumber: i32,
    pub pMessage: *const c_char,
    pub queueLabelCount: u32,
    pub pQueueLabels: *const DebugUtilsLabelEXT,
    pub cmdBufLabelCount: u32,
    pub pCmdBufLabels: *const DebugUtilsLabelEXT,
    pub objectCount: u32,
    pub pObjects: *const DebugUtilsObjectNameInfoEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDeviceMemoryReportFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceMemoryReport: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceDeviceMemoryReportCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub pfnUserCallback: FnDeviceMemoryReportCallbackEXT,
    pub pUserData: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceMemoryReportCallbackDataEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub typ: DeviceMemoryReportEventTypeEXT,
    pub memoryObjectId: u64,
    pub size: DeviceSize,
    pub objectType: ObjectType,
    pub objectHandle: u64,
    pub heapIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImportMemoryHostPointerInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
    pub pHostPointer: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryHostPointerPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryTypeBits: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalMemoryHostPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minImportedHostPointerAlignment: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceConservativeRasterizationPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub primitiveOverestimationSize: f32, // The size in pixels the primitive is enlarged at each edge during conservative rasterization
    pub maxExtraPrimitiveOverestimationSize: f32, // The maximum additional overestimation the client can specify in the pipeline state
    pub extraPrimitiveOverestimationSizeGranularity: f32, // The granularity of extra overestimation sizes the implementations supports between 0 and maxExtraOverestimationSize
    pub primitiveUnderestimation: Bool32, // true if the implementation supports conservative rasterization underestimation mode
    pub conservativePointAndLineRasterization: Bool32, // true if conservative rasterization also applies to points and lines
    pub degenerateTrianglesRasterized: Bool32, // true if degenerate triangles (those with zero area after snap) are rasterized
    pub degenerateLinesRasterized: Bool32, // true if degenerate lines (those with zero length after snap) are rasterized
    pub fullyCoveredFragmentShaderInputVariable: Bool32, // true if the implementation supports the FullyCoveredEXT SPIR-V builtin fragment shader input variable
    pub conservativeRasterizationPostDepthCoverage: Bool32, // true if the implementation supports both conservative rasterization and post depth coverage sample coverage mask
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CalibratedTimestampInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub timeDomain: TimeDomainEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderCorePropertiesAMD {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderEngineCount: u32, // number of shader engines
    pub shaderArraysPerEngineCount: u32, // number of shader arrays
    pub computeUnitsPerShaderArray: u32, // number of physical CUs per shader array
    pub simdPerComputeUnit: u32, // number of SIMDs per compute unit
    pub wavefrontsPerSimd: u32, // number of wavefront slots in each SIMD
    pub wavefrontSize: u32, // maximum number of threads per wavefront
    pub sgprsPerSimd: u32, // number of physical SGPRs per SIMD
    pub minSgprAllocation: u32, // minimum number of SGPRs that can be allocated by a wave
    pub maxSgprAllocation: u32, // number of available SGPRs
    pub sgprAllocationGranularity: u32, // SGPRs are allocated in groups of this size
    pub vgprsPerSimd: u32, // number of physical VGPRs per SIMD
    pub minVgprAllocation: u32, // minimum number of VGPRs that can be allocated by a wave
    pub maxVgprAllocation: u32, // number of available VGPRs
    pub vgprAllocationGranularity: u32, // VGPRs are allocated in groups of this size
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderCoreProperties2AMD {
    pub sType: StructureType,
    pub pNext: *mut c_void, // Pointer to next structure
    pub shaderCoreFeatures: ShaderCorePropertiesFlagsAMD, // features supported by the shader core
    pub activeComputeUnitCount: u32, // number of active compute units across all shader engines/arrays
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationConservativeStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineRasterizationConservativeStateCreateFlagsEXT, // Reserved
    pub conservativeRasterizationMode: ConservativeRasterizationModeEXT, // Conservative rasterization mode
    pub extraPrimitiveOverestimationSize: f32, // Extra overestimation to add to the primitive
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDescriptorIndexingFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderInputAttachmentArrayDynamicIndexing: Bool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderUniformBufferArrayNonUniformIndexing: Bool32,
    pub shaderSampledImageArrayNonUniformIndexing: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageImageArrayNonUniformIndexing: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: Bool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: Bool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: Bool32,
    pub descriptorBindingSampledImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUpdateUnusedWhilePending: Bool32,
    pub descriptorBindingPartiallyBound: Bool32,
    pub descriptorBindingVariableDescriptorCount: Bool32,
    pub runtimeDescriptorArray: Bool32,
}

pub type PhysicalDeviceDescriptorIndexingFeaturesEXT = PhysicalDeviceDescriptorIndexingFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDescriptorIndexingProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: Bool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: Bool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: Bool32,
    pub robustBufferAccessUpdateAfterBind: Bool32,
    pub quadDivergentImplicitLod: Bool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
}

pub type PhysicalDeviceDescriptorIndexingPropertiesEXT = PhysicalDeviceDescriptorIndexingProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetLayoutBindingFlagsCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub bindingCount: u32,
    pub pBindingFlags: *const DescriptorBindingFlags,
}

pub type DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetVariableDescriptorCountAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub descriptorSetCount: u32,
    pub pDescriptorCounts: *const u32,
}

pub type DescriptorSetVariableDescriptorCountAllocateInfoEXT = DescriptorSetVariableDescriptorCountAllocateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetVariableDescriptorCountLayoutSupport {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxVariableDescriptorCount: u32,
}

pub type DescriptorSetVariableDescriptorCountLayoutSupportEXT = DescriptorSetVariableDescriptorCountLayoutSupport;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentDescription2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlagBits,
    pub loadOp: AttachmentLoadOp, // Load operation for color or depth data
    pub storeOp: AttachmentStoreOp, // Store operation for color or depth data
    pub stencilLoadOp: AttachmentLoadOp, // Load operation for stencil data
    pub stencilStoreOp: AttachmentStoreOp, // Store operation for stencil data
    pub initialLayout: ImageLayout,
    pub finalLayout: ImageLayout,
}

pub type AttachmentDescription2KHR = AttachmentDescription2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentReference2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub attachment: u32,
    pub layout: ImageLayout,
    pub aspectMask: ImageAspectFlags,
}

pub type AttachmentReference2KHR = AttachmentReference2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassDescription2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SubpassDescriptionFlags,
    pub pipelineBindPoint: PipelineBindPoint,
    pub viewMask: u32,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const AttachmentReference2,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const AttachmentReference2,
    pub pResolveAttachments: *const AttachmentReference2,
    pub pDepthStencilAttachment: *const AttachmentReference2,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}

pub type SubpassDescription2KHR = SubpassDescription2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassDependency2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: PipelineStageFlags,
    pub dstStageMask: PipelineStageFlags,
    pub srcAccessMask: AccessFlags,
    pub dstAccessMask: AccessFlags,
    pub dependencyFlags: DependencyFlags,
    pub viewOffset: i32,
}

pub type SubpassDependency2KHR = SubpassDependency2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassCreateInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const AttachmentDescription2,
    pub subpassCount: u32,
    pub pSubpasses: *const SubpassDescription2,
    pub dependencyCount: u32,
    pub pDependencies: *const SubpassDependency2,
    pub correlatedViewMaskCount: u32,
    pub pCorrelatedViewMasks: *const u32,
}

pub type RenderPassCreateInfo2KHR = RenderPassCreateInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub contents: SubpassContents,
}

pub type SubpassBeginInfoKHR = SubpassBeginInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassEndInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
}

pub type SubpassEndInfoKHR = SubpassEndInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTimelineSemaphoreFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub timelineSemaphore: Bool32,
}

pub type PhysicalDeviceTimelineSemaphoreFeaturesKHR = PhysicalDeviceTimelineSemaphoreFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTimelineSemaphoreProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxTimelineSemaphoreValueDifference: u64,
}

pub type PhysicalDeviceTimelineSemaphorePropertiesKHR = PhysicalDeviceTimelineSemaphoreProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreTypeCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub semaphoreType: SemaphoreType,
    pub initialValue: u64,
}

pub type SemaphoreTypeCreateInfoKHR = SemaphoreTypeCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct TimelineSemaphoreSubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreValueCount: u32,
    pub pWaitSemaphoreValues: *const u64,
    pub signalSemaphoreValueCount: u32,
    pub pSignalSemaphoreValues: *const u64,
}

pub type TimelineSemaphoreSubmitInfoKHR = TimelineSemaphoreSubmitInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreWaitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SemaphoreWaitFlags,
    pub semaphoreCount: u32,
    pub pSemaphores: *const Semaphore,
    pub pValues: *const u64,
}

pub type SemaphoreWaitInfoKHR = SemaphoreWaitInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreSignalInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub semaphore: Semaphore,
    pub value: u64,
}

pub type SemaphoreSignalInfoKHR = SemaphoreSignalInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VertexInputBindingDivisorDescriptionEXT {
    pub binding: u32,
    pub divisor: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineVertexInputDivisorStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub vertexBindingDivisorCount: u32,
    pub pVertexBindingDivisors: *const VertexInputBindingDivisorDescriptionEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxVertexAttribDivisor: u32, // max value of vertex attribute divisor
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePCIBusInfoPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pciDomain: u32,
    pub pciBus: u32,
    pub pciDevice: u32,
    pub pciFunction: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferInheritanceConditionalRenderingInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub conditionalRenderingEnable: Bool32, // Whether this secondary command buffer may be executed during an active conditional rendering
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevice8BitStorageFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer8BitAccess: Bool32, // 8-bit integer variables supported in StorageBuffer
    pub uniformAndStorageBuffer8BitAccess: Bool32, // 8-bit integer variables supported in StorageBuffer and Uniform
    pub storagePushConstant8: Bool32, // 8-bit integer variables supported in PushConstant
}

pub type PhysicalDevice8BitStorageFeaturesKHR = PhysicalDevice8BitStorageFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceConditionalRenderingFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub conditionalRendering: Bool32,
    pub inheritedConditionalRendering: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkanMemoryModelFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub vulkanMemoryModel: Bool32,
    pub vulkanMemoryModelDeviceScope: Bool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: Bool32,
}

pub type PhysicalDeviceVulkanMemoryModelFeaturesKHR = PhysicalDeviceVulkanMemoryModelFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderAtomicInt64Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderBufferInt64Atomics: Bool32,
    pub shaderSharedInt64Atomics: Bool32,
}

pub type PhysicalDeviceShaderAtomicInt64FeaturesKHR = PhysicalDeviceShaderAtomicInt64Features;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderAtomicFloatFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderBufferFloat32Atomics: Bool32,
    pub shaderBufferFloat32AtomicAdd: Bool32,
    pub shaderBufferFloat64Atomics: Bool32,
    pub shaderBufferFloat64AtomicAdd: Bool32,
    pub shaderSharedFloat32Atomics: Bool32,
    pub shaderSharedFloat32AtomicAdd: Bool32,
    pub shaderSharedFloat64Atomics: Bool32,
    pub shaderSharedFloat64AtomicAdd: Bool32,
    pub shaderImageFloat32Atomics: Bool32,
    pub shaderImageFloat32AtomicAdd: Bool32,
    pub sparseImageFloat32Atomics: Bool32,
    pub sparseImageFloat32AtomicAdd: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderBufferFloat16Atomics: Bool32,
    pub shaderBufferFloat16AtomicAdd: Bool32,
    pub shaderBufferFloat16AtomicMinMax: Bool32,
    pub shaderBufferFloat32AtomicMinMax: Bool32,
    pub shaderBufferFloat64AtomicMinMax: Bool32,
    pub shaderSharedFloat16Atomics: Bool32,
    pub shaderSharedFloat16AtomicAdd: Bool32,
    pub shaderSharedFloat16AtomicMinMax: Bool32,
    pub shaderSharedFloat32AtomicMinMax: Bool32,
    pub shaderSharedFloat64AtomicMinMax: Bool32,
    pub shaderImageFloat32AtomicMinMax: Bool32,
    pub sparseImageFloat32AtomicMinMax: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub vertexAttributeInstanceRateDivisor: Bool32,
    pub vertexAttributeInstanceRateZeroDivisor: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyCheckpointPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub checkpointExecutionStageMask: PipelineStageFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CheckpointDataNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub stage: PipelineStageFlagBits,
    pub pCheckpointMarker: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDepthStencilResolveProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub supportedDepthResolveModes: ResolveModeFlags, // supported depth resolve modes
    pub supportedStencilResolveModes: ResolveModeFlags, // supported stencil resolve modes
    pub independentResolveNone: Bool32, // depth and stencil resolve modes can be set independently if one of them is none
    pub independentResolve: Bool32, // depth and stencil resolve modes can be set independently
}

pub type PhysicalDeviceDepthStencilResolvePropertiesKHR = PhysicalDeviceDepthStencilResolveProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassDescriptionDepthStencilResolve {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub depthResolveMode: ResolveModeFlagBits, // depth resolve mode
    pub stencilResolveMode: ResolveModeFlagBits, // stencil resolve mode
    pub pDepthStencilResolveAttachment: *const AttachmentReference2, // depth/stencil resolve attachment
}

pub type SubpassDescriptionDepthStencilResolveKHR = SubpassDescriptionDepthStencilResolve;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewASTCDecodeModeEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub decodeMode: Format,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceASTCDecodeFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub decodeModeSharedExponent: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTransformFeedbackFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub transformFeedback: Bool32,
    pub geometryStreams: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTransformFeedbackPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxTransformFeedbackStreams: u32,
    pub maxTransformFeedbackBuffers: u32,
    pub maxTransformFeedbackBufferSize: DeviceSize,
    pub maxTransformFeedbackStreamDataSize: u32,
    pub maxTransformFeedbackBufferDataSize: u32,
    pub maxTransformFeedbackBufferDataStride: u32,
    pub transformFeedbackQueries: Bool32,
    pub transformFeedbackStreamsLinesTriangles: Bool32,
    pub transformFeedbackRasterizationStreamSelect: Bool32,
    pub transformFeedbackDraw: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationStateStreamCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineRasterizationStateStreamCreateFlagsEXT,
    pub rasterizationStream: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub representativeFragmentTest: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRepresentativeFragmentTestStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub representativeFragmentTestEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExclusiveScissorFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub exclusiveScissor: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportExclusiveScissorStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub exclusiveScissorCount: u32,
    pub pExclusiveScissors: *const Rect2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCornerSampledImageFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub cornerSampledImage: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceComputeShaderDerivativesFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub computeDerivativeGroupQuads: Bool32,
    pub computeDerivativeGroupLinear: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentShaderBarycentric: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderImageFootprintFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imageFootprint: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub dedicatedAllocationImageAliasing: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShadingRatePaletteNV {
    pub shadingRatePaletteEntryCount: u32,
    pub pShadingRatePaletteEntries: *const ShadingRatePaletteEntryNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportShadingRateImageStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub shadingRateImageEnable: Bool32,
    pub viewportCount: u32,
    pub pShadingRatePalettes: *const ShadingRatePaletteNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShadingRateImageFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shadingRateImage: Bool32,
    pub shadingRateCoarseSampleOrder: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShadingRateImagePropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shadingRateTexelSize: Extent2D,
    pub shadingRatePaletteSize: u32,
    pub shadingRateMaxCoarseSamples: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceInvocationMaskFeaturesHUAWEI {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub invocationMask: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CoarseSampleLocationNV {
    pub pixelX: u32,
    pub pixelY: u32,
    pub sample: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CoarseSampleOrderCustomNV {
    pub shadingRate: ShadingRatePaletteEntryNV,
    pub sampleCount: u32,
    pub sampleLocationCount: u32,
    pub pSampleLocations: *const CoarseSampleLocationNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportCoarseSampleOrderStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub sampleOrderType: CoarseSampleOrderTypeNV,
    pub customSampleOrderCount: u32,
    pub pCustomSampleOrders: *const CoarseSampleOrderCustomNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMeshShaderFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub taskShader: Bool32,
    pub meshShader: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMeshShaderPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxDrawMeshTasksCount: u32,
    pub maxTaskWorkGroupInvocations: u32,
    pub maxTaskWorkGroupSize: [u32; 3],
    pub maxTaskTotalMemorySize: u32,
    pub maxTaskOutputCount: u32,
    pub maxMeshWorkGroupInvocations: u32,
    pub maxMeshWorkGroupSize: [u32; 3],
    pub maxMeshTotalMemorySize: u32,
    pub maxMeshOutputVertices: u32,
    pub maxMeshOutputPrimitives: u32,
    pub maxMeshMultiviewViewCount: u32,
    pub meshOutputPerVertexGranularity: u32,
    pub meshOutputPerPrimitiveGranularity: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrawMeshTasksIndirectCommandNV {
    pub taskCount: u32,
    pub firstTask: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RayTracingShaderGroupCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: RayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RayTracingShaderGroupCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: RayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
    pub pShaderGroupCaptureReplayHandle: *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RayTracingPipelineCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags, // Pipeline creation flags
    pub stageCount: u32,
    pub pStages: *const PipelineShaderStageCreateInfo, // One entry for each active shader stage
    pub groupCount: u32,
    pub pGroups: *const RayTracingShaderGroupCreateInfoNV,
    pub maxRecursionDepth: u32,
    pub layout: PipelineLayout, // Interface layout of the pipeline
    pub basePipelineHandle: Pipeline, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is nonzero, it specifies the handle of the base pipeline this is a derivative of
    pub basePipelineIndex: i32, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is not -1, it specifies an index into pCreateInfos of the base pipeline this is a derivative of
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RayTracingPipelineCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags, // Pipeline creation flags
    pub stageCount: u32,
    pub pStages: *const PipelineShaderStageCreateInfo, // One entry for each active shader stage
    pub groupCount: u32,
    pub pGroups: *const RayTracingShaderGroupCreateInfoKHR,
    pub maxPipelineRayRecursionDepth: u32,
    pub pLibraryInfo: *const PipelineLibraryCreateInfoKHR,
    pub pLibraryInterface: *const RayTracingPipelineInterfaceCreateInfoKHR,
    pub pDynamicState: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout, // Interface layout of the pipeline
    pub basePipelineHandle: Pipeline, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is nonzero, it specifies the handle of the base pipeline this is a derivative of
    pub basePipelineIndex: i32, // If VK_PIPELINE_CREATE_DERIVATIVE_BIT is set and this value is not -1, it specifies an index into pCreateInfos of the base pipeline this is a derivative of
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeometryTrianglesNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub vertexData: Buffer,
    pub vertexOffset: DeviceSize,
    pub vertexCount: u32,
    pub vertexStride: DeviceSize,
    pub vertexFormat: Format,
    pub indexData: Buffer,
    pub indexOffset: DeviceSize,
    pub indexCount: u32,
    pub indexType: IndexType,
    pub transformData: Buffer, // Optional reference to array of floats representing a 3x4 row major affine transformation matrix.
    pub transformOffset: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeometryAABBNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub aabbData: Buffer,
    pub numAABBs: u32,
    pub stride: u32, // Stride in bytes between AABBs
    pub offset: DeviceSize, // Offset in bytes of the first AABB in aabbData
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeometryDataNV {
    pub triangles: GeometryTrianglesNV,
    pub aabbs: GeometryAABBNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GeometryNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub geometryType: GeometryTypeKHR,
    pub geometry: GeometryDataNV,
    pub flags: GeometryFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: AccelerationStructureTypeNV,
    pub flags: BuildAccelerationStructureFlagsNV,
    pub instanceCount: u32,
    pub geometryCount: u32,
    pub pGeometries: *const GeometryNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub compactedSize: DeviceSize,
    pub info: AccelerationStructureInfoNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BindAccelerationStructureMemoryInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub accelerationStructure: AccelerationStructureNV,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct WriteDescriptorSetAccelerationStructureKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const AccelerationStructureKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct WriteDescriptorSetAccelerationStructureNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const AccelerationStructureNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureMemoryRequirementsInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: AccelerationStructureMemoryRequirementsTypeNV,
    pub accelerationStructure: AccelerationStructureNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceAccelerationStructureFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub accelerationStructure: Bool32,
    pub accelerationStructureCaptureReplay: Bool32,
    pub accelerationStructureIndirectBuild: Bool32,
    pub accelerationStructureHostCommands: Bool32,
    pub descriptorBindingAccelerationStructureUpdateAfterBind: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRayTracingPipelineFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub rayTracingPipeline: Bool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplay: Bool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplayMixed: Bool32,
    pub rayTracingPipelineTraceRaysIndirect: Bool32,
    pub rayTraversalPrimitiveCulling: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRayQueryFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub rayQuery: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceAccelerationStructurePropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxPrimitiveCount: u64,
    pub maxPerStageDescriptorAccelerationStructures: u32,
    pub maxPerStageDescriptorUpdateAfterBindAccelerationStructures: u32,
    pub maxDescriptorSetAccelerationStructures: u32,
    pub maxDescriptorSetUpdateAfterBindAccelerationStructures: u32,
    pub minAccelerationStructureScratchOffsetAlignment: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRayTracingPipelinePropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRayRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub shaderGroupHandleCaptureReplaySize: u32,
    pub maxRayDispatchInvocationCount: u32,
    pub shaderGroupHandleAlignment: u32,
    pub maxRayHitAttributeSize: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRayTracingPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxTriangleCount: u64,
    pub maxDescriptorSetAccelerationStructures: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct StridedDeviceAddressRegionKHR {
    pub deviceAddress: DeviceAddress,
    pub stride: DeviceSize,
    pub size: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct TraceRaysIndirectCommandKHR {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrmFormatModifierPropertiesListEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifierProperties: *mut DrmFormatModifierPropertiesEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrmFormatModifierPropertiesEXT {
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub drmFormatModifierTilingFeatures: FormatFeatureFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImageDrmFormatModifierInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub drmFormatModifier: u64,
    pub sharingMode: SharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageDrmFormatModifierListCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifiers: *const u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageDrmFormatModifierExplicitCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub pPlaneLayouts: *const SubresourceLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageDrmFormatModifierPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub drmFormatModifier: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageStencilUsageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub stencilUsage: ImageUsageFlags,
}

pub type ImageStencilUsageCreateInfoEXT = ImageStencilUsageCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceMemoryOverallocationCreateInfoAMD {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub overallocationBehavior: MemoryOverallocationBehaviorAMD,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMapFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentDensityMap: Bool32,
    pub fragmentDensityMapDynamic: Bool32,
    pub fragmentDensityMapNonSubsampledImages: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMap2FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentDensityMapDeferred: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentDensityMapOffset: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMapPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minFragmentDensityTexelSize: Extent2D,
    pub maxFragmentDensityTexelSize: Extent2D,
    pub fragmentDensityInvocations: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMap2PropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub subsampledLoads: Bool32,
    pub subsampledCoarseReconstructionEarlyAccess: Bool32,
    pub maxSubsampledArrayLayers: u32,
    pub maxDescriptorSetSubsampledSamplers: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentDensityOffsetGranularity: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassFragmentDensityMapCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub fragmentDensityMapAttachment: AttachmentReference,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassFragmentDensityMapOffsetEndInfoQCOM {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub fragmentDensityOffsetCount: u32,
    pub pFragmentDensityOffsets: *const Offset2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceScalarBlockLayoutFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub scalarBlockLayout: Bool32,
}

pub type PhysicalDeviceScalarBlockLayoutFeaturesEXT = PhysicalDeviceScalarBlockLayoutFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SurfaceProtectedCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub supportsProtected: Bool32, // Represents if surface can be protected
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub uniformBufferStandardLayout: Bool32,
}

pub type PhysicalDeviceUniformBufferStandardLayoutFeaturesKHR = PhysicalDeviceUniformBufferStandardLayoutFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDepthClipEnableFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub depthClipEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationDepthClipStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineRasterizationDepthClipStateCreateFlagsEXT, // Reserved
    pub depthClipEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMemoryBudgetPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub heapBudget: [DeviceSize; MAX_MEMORY_HEAPS as usize],
    pub heapUsage: [DeviceSize; MAX_MEMORY_HEAPS as usize],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMemoryPriorityFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryPriority: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryPriorityAllocateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub priority: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePageableDeviceLocalMemoryFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pageableDeviceLocalMemory: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceBufferDeviceAddressFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
}

pub type PhysicalDeviceBufferDeviceAddressFeaturesKHR = PhysicalDeviceBufferDeviceAddressFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceBufferDeviceAddressFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
}

pub type PhysicalDeviceBufferAddressFeaturesEXT = PhysicalDeviceBufferDeviceAddressFeaturesEXT;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferDeviceAddressInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
}

pub type BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

pub type BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferOpaqueCaptureAddressCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub opaqueCaptureAddress: u64,
}

pub type BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferDeviceAddressCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub deviceAddress: DeviceAddress,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImageViewImageFormatInfoEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imageViewType: ImageViewType,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FilterCubicImageViewImageFormatPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub filterCubic: Bool32, // The combinations of format, image type (and image view type if provided) can be filtered with VK_FILTER_CUBIC_EXT
    pub filterCubicMinmax: Bool32, // The combination of format, image type (and image view type if provided) can be filtered with VK_FILTER_CUBIC_EXT and ReductionMode of Min or Max
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImagelessFramebufferFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imagelessFramebuffer: Bool32,
}

pub type PhysicalDeviceImagelessFramebufferFeaturesKHR = PhysicalDeviceImagelessFramebufferFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FramebufferAttachmentsCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub attachmentImageInfoCount: u32,
    pub pAttachmentImageInfos: *const FramebufferAttachmentImageInfo,
}

pub type FramebufferAttachmentsCreateInfoKHR = FramebufferAttachmentsCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FramebufferAttachmentImageInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ImageCreateFlags, // Image creation flags
    pub usage: ImageUsageFlags, // Image usage flags
    pub width: u32,
    pub height: u32,
    pub layerCount: u32,
    pub viewFormatCount: u32,
    pub pViewFormats: *const Format,
}

pub type FramebufferAttachmentImageInfoKHR = FramebufferAttachmentImageInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassAttachmentBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub attachmentCount: u32,
    pub pAttachments: *const ImageView,
}

pub type RenderPassAttachmentBeginInfoKHR = RenderPassAttachmentBeginInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTextureCompressionASTCHDRFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub textureCompressionASTC_HDR: Bool32,
}

pub type PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT = PhysicalDeviceTextureCompressionASTCHDRFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCooperativeMatrixFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub cooperativeMatrix: Bool32,
    pub cooperativeMatrixRobustBufferAccess: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCooperativeMatrixPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub cooperativeMatrixSupportedStages: ShaderStageFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CooperativeMatrixPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub MSize: u32,
    pub NSize: u32,
    pub KSize: u32,
    pub AType: ComponentTypeNV,
    pub BType: ComponentTypeNV,
    pub CType: ComponentTypeNV,
    pub DType: ComponentTypeNV,
    pub scope: ScopeNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceYcbcrImageArraysFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub ycbcrImageArrays: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewHandleInfoNVX {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub imageView: ImageView,
    pub descriptorType: DescriptorType,
    pub sampler: Sampler,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewAddressPropertiesNVX {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceAddress: DeviceAddress,
    pub size: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCreationFeedback {
    pub flags: PipelineCreationFeedbackFlags,
    pub duration: u64,
}

pub type PipelineCreationFeedbackEXT = PipelineCreationFeedback;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCreationFeedbackCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pPipelineCreationFeedback: *mut PipelineCreationFeedback, // Output pipeline creation feedback.
    pub pipelineStageCreationFeedbackCount: u32,
    pub pPipelineStageCreationFeedbacks: *mut PipelineCreationFeedback, // One entry for each shader stage specified in the parent Vk*PipelineCreateInfo struct
}

pub type PipelineCreationFeedbackCreateInfoEXT = PipelineCreationFeedbackCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePerformanceQueryFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub performanceCounterQueryPools: Bool32, // performance counters supported in query pools
    pub performanceCounterMultipleQueryPools: Bool32, // performance counters from multiple query pools can be accessed in the same primary command buffer
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePerformanceQueryPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub allowCommandBufferQueryCopies: Bool32, // Flag to specify whether performance queries are allowed to be used in vkCmdCopyQueryPoolResults
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceCounterKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub unit: PerformanceCounterUnitKHR,
    pub scope: PerformanceCounterScopeKHR,
    pub storage: PerformanceCounterStorageKHR,
    pub uuid: [u8; UUID_SIZE as usize],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceCounterDescriptionKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub flags: PerformanceCounterDescriptionFlagsKHR,
    pub name: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub category: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueryPoolPerformanceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub queueFamilyIndex: u32,
    pub counterIndexCount: u32,
    pub pCounterIndices: *const u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AcquireProfilingLockInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: AcquireProfilingLockFlagsKHR, // Acquire profiling lock flags
    pub timeout: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceQuerySubmitInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub counterPassIndex: u32, // Index for which counter pass to submit
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeadlessSurfaceCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: HeadlessSurfaceCreateFlagsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCoverageReductionModeFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub coverageReductionMode: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCoverageReductionStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCoverageReductionStateCreateFlagsNV,
    pub coverageReductionMode: CoverageReductionModeNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FramebufferMixedSamplesCombinationNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub coverageReductionMode: CoverageReductionModeNV,
    pub rasterizationSamples: SampleCountFlagBits,
    pub depthStencilSamples: SampleCountFlags,
    pub colorSamples: SampleCountFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderIntegerFunctions2: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceValueINTEL {
    pub typ: PerformanceValueTypeINTEL,
    pub data: PerformanceValueDataINTEL,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct InitializePerformanceApiInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pUserData: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueryPoolPerformanceQueryCreateInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub performanceCountersSampling: QueryPoolSamplingModeINTEL,
}

pub type QueryPoolCreateInfoINTEL = QueryPoolPerformanceQueryCreateInfoINTEL;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceMarkerInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub marker: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceStreamMarkerInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub marker: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceOverrideInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: PerformanceOverrideTypeINTEL,
    pub enable: Bool32,
    pub parameter: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PerformanceConfigurationAcquireInfoINTEL {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: PerformanceConfigurationTypeINTEL,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderClockFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSubgroupClock: Bool32,
    pub shaderDeviceClock: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceIndexTypeUint8FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub indexTypeUint8: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderSMBuiltinsPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSMCount: u32,
    pub shaderWarpsPerSM: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderSMBuiltinsFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSMBuiltins: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void, // Pointer to next structure
    pub fragmentShaderSampleInterlock: Bool32,
    pub fragmentShaderPixelInterlock: Bool32,
    pub fragmentShaderShadingRateInterlock: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub separateDepthStencilLayouts: Bool32,
}

pub type PhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR = PhysicalDeviceSeparateDepthStencilLayoutsFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentReferenceStencilLayout {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub stencilLayout: ImageLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub primitiveTopologyListRestart: Bool32,
    pub primitiveTopologyPatchListRestart: Bool32,
}

pub type AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentDescriptionStencilLayout {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub stencilInitialLayout: ImageLayout,
    pub stencilFinalLayout: ImageLayout,
}

pub type AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pipelineExecutableInfo: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pipeline: Pipeline,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineExecutablePropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub stages: ShaderStageFlags,
    pub name: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub subgroupSize: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineExecutableInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pipeline: Pipeline,
    pub executableIndex: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineExecutableStatisticKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub name: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub format: PipelineExecutableStatisticFormatKHR,
    pub value: PipelineExecutableStatisticValueKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineExecutableInternalRepresentationKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub name: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub isText: Bool32,
    pub dataSize: usize,
    pub pData: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderDemoteToHelperInvocationFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderDemoteToHelperInvocation: Bool32,
}

pub type PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT = PhysicalDeviceShaderDemoteToHelperInvocationFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub texelBufferAlignment: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceTexelBufferAlignmentProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageTexelBufferOffsetAlignmentBytes: DeviceSize,
    pub storageTexelBufferOffsetSingleTexelAlignment: Bool32,
    pub uniformTexelBufferOffsetAlignmentBytes: DeviceSize,
    pub uniformTexelBufferOffsetSingleTexelAlignment: Bool32,
}

pub type PhysicalDeviceTexelBufferAlignmentPropertiesEXT = PhysicalDeviceTexelBufferAlignmentProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSubgroupSizeControlFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub subgroupSizeControl: Bool32,
    pub computeFullSubgroups: Bool32,
}

pub type PhysicalDeviceSubgroupSizeControlFeaturesEXT = PhysicalDeviceSubgroupSizeControlFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSubgroupSizeControlProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minSubgroupSize: u32, // The minimum subgroup size supported by this device
    pub maxSubgroupSize: u32, // The maximum subgroup size supported by this device
    pub maxComputeWorkgroupSubgroups: u32, // The maximum number of subgroups supported in a workgroup
    pub requiredSubgroupSizeStages: ShaderStageFlags, // The shader stages that support specifying a subgroup size
}

pub type PhysicalDeviceSubgroupSizeControlPropertiesEXT = PhysicalDeviceSubgroupSizeControlProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineShaderStageRequiredSubgroupSizeCreateInfo {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub requiredSubgroupSize: u32,
}

pub type PipelineShaderStageRequiredSubgroupSizeCreateInfoEXT = PipelineShaderStageRequiredSubgroupSizeCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubpassShadingPipelineCreateInfoHUAWEI {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub renderPass: RenderPass,
    pub subpass: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSubpassShadingPropertiesHUAWEI {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxSubpassShadingWorkgroupSizeAspectRatio: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryOpaqueCaptureAddressAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub opaqueCaptureAddress: u64,
}

pub type MemoryOpaqueCaptureAddressAllocateInfoKHR = MemoryOpaqueCaptureAddressAllocateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceMemoryOpaqueCaptureAddressInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory,
}

pub type DeviceMemoryOpaqueCaptureAddressInfoKHR = DeviceMemoryOpaqueCaptureAddressInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceLineRasterizationFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub rectangularLines: Bool32,
    pub bresenhamLines: Bool32,
    pub smoothLines: Bool32,
    pub stippledRectangularLines: Bool32,
    pub stippledBresenhamLines: Bool32,
    pub stippledSmoothLines: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceLineRasterizationPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub lineSubPixelPrecisionBits: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationLineStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub lineRasterizationMode: LineRasterizationModeEXT,
    pub stippledLineEnable: Bool32,
    pub lineStippleFactor: u32,
    pub lineStipplePattern: u16,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePipelineCreationCacheControlFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pipelineCreationCacheControl: Bool32,
}

pub type PhysicalDevicePipelineCreationCacheControlFeaturesEXT = PhysicalDevicePipelineCreationCacheControlFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan11Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer16BitAccess: Bool32, // 16-bit integer/floating-point variables supported in BufferBlock
    pub uniformAndStorageBuffer16BitAccess: Bool32, // 16-bit integer/floating-point variables supported in BufferBlock and Block
    pub storagePushConstant16: Bool32, // 16-bit integer/floating-point variables supported in PushConstant
    pub storageInputOutput16: Bool32, // 16-bit integer/floating-point variables supported in shader inputs and outputs
    pub multiview: Bool32, // Multiple views in a renderpass
    pub multiviewGeometryShader: Bool32, // Multiple views in a renderpass w/ geometry shader
    pub multiviewTessellationShader: Bool32, // Multiple views in a renderpass w/ tessellation shader
    pub variablePointersStorageBuffer: Bool32,
    pub variablePointers: Bool32,
    pub protectedMemory: Bool32,
    pub samplerYcbcrConversion: Bool32, // Sampler color conversion supported
    pub shaderDrawParameters: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan11Properties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceUUID: [u8; UUID_SIZE as usize],
    pub driverUUID: [u8; UUID_SIZE as usize],
    pub deviceLUID: [u8; LUID_SIZE as usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: Bool32,
    pub subgroupSize: u32, // The size of a subgroup for this queue.
    pub subgroupSupportedStages: ShaderStageFlags, // Bitfield of what shader stages support subgroup operations
    pub subgroupSupportedOperations: SubgroupFeatureFlags, // Bitfield of what subgroup operations are supported.
    pub subgroupQuadOperationsInAllStages: Bool32, // Flag to specify whether quad operations are available in all stages.
    pub pointClippingBehavior: PointClippingBehavior,
    pub maxMultiviewViewCount: u32, // max number of views in a subpass
    pub maxMultiviewInstanceIndex: u32, // max instance index for a draw in a multiview subpass
    pub protectedNoFault: Bool32,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan12Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub samplerMirrorClampToEdge: Bool32,
    pub drawIndirectCount: Bool32,
    pub storageBuffer8BitAccess: Bool32, // 8-bit integer variables supported in StorageBuffer
    pub uniformAndStorageBuffer8BitAccess: Bool32, // 8-bit integer variables supported in StorageBuffer and Uniform
    pub storagePushConstant8: Bool32, // 8-bit integer variables supported in PushConstant
    pub shaderBufferInt64Atomics: Bool32,
    pub shaderSharedInt64Atomics: Bool32,
    pub shaderFloat16: Bool32, // 16-bit floats (halfs) in shaders
    pub shaderInt8: Bool32, // 8-bit integers in shaders
    pub descriptorIndexing: Bool32,
    pub shaderInputAttachmentArrayDynamicIndexing: Bool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderUniformBufferArrayNonUniformIndexing: Bool32,
    pub shaderSampledImageArrayNonUniformIndexing: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageImageArrayNonUniformIndexing: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: Bool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: Bool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: Bool32,
    pub descriptorBindingSampledImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUpdateUnusedWhilePending: Bool32,
    pub descriptorBindingPartiallyBound: Bool32,
    pub descriptorBindingVariableDescriptorCount: Bool32,
    pub runtimeDescriptorArray: Bool32,
    pub samplerFilterMinmax: Bool32,
    pub scalarBlockLayout: Bool32,
    pub imagelessFramebuffer: Bool32,
    pub uniformBufferStandardLayout: Bool32,
    pub shaderSubgroupExtendedTypes: Bool32,
    pub separateDepthStencilLayouts: Bool32,
    pub hostQueryReset: Bool32,
    pub timelineSemaphore: Bool32,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
    pub vulkanMemoryModel: Bool32,
    pub vulkanMemoryModelDeviceScope: Bool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: Bool32,
    pub shaderOutputViewportIndex: Bool32,
    pub shaderOutputLayer: Bool32,
    pub subgroupBroadcastDynamicId: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan12Properties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub driverID: DriverId,
    pub driverName: [c_char; MAX_DRIVER_NAME_SIZE as usize],
    pub driverInfo: [c_char; MAX_DRIVER_INFO_SIZE as usize],
    pub conformanceVersion: ConformanceVersion,
    pub denormBehaviorIndependence: ShaderFloatControlsIndependence,
    pub roundingModeIndependence: ShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderSignedZeroInfNanPreserveFloat32: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderSignedZeroInfNanPreserveFloat64: Bool32, // An implementation can preserve signed zero, nan, inf
    pub shaderDenormPreserveFloat16: Bool32, // An implementation can preserve  denormals
    pub shaderDenormPreserveFloat32: Bool32, // An implementation can preserve  denormals
    pub shaderDenormPreserveFloat64: Bool32, // An implementation can preserve  denormals
    pub shaderDenormFlushToZeroFloat16: Bool32, // An implementation can flush to zero  denormals
    pub shaderDenormFlushToZeroFloat32: Bool32, // An implementation can flush to zero  denormals
    pub shaderDenormFlushToZeroFloat64: Bool32, // An implementation can flush to zero  denormals
    pub shaderRoundingModeRTEFloat16: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTEFloat32: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTEFloat64: Bool32, // An implementation can support RTE
    pub shaderRoundingModeRTZFloat16: Bool32, // An implementation can support RTZ
    pub shaderRoundingModeRTZFloat32: Bool32, // An implementation can support RTZ
    pub shaderRoundingModeRTZFloat64: Bool32, // An implementation can support RTZ
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: Bool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: Bool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: Bool32,
    pub robustBufferAccessUpdateAfterBind: Bool32,
    pub quadDivergentImplicitLod: Bool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
    pub supportedDepthResolveModes: ResolveModeFlags, // supported depth resolve modes
    pub supportedStencilResolveModes: ResolveModeFlags, // supported stencil resolve modes
    pub independentResolveNone: Bool32, // depth and stencil resolve modes can be set independently if one of them is none
    pub independentResolve: Bool32, // depth and stencil resolve modes can be set independently
    pub filterMinmaxSingleComponentFormats: Bool32,
    pub filterMinmaxImageComponentMapping: Bool32,
    pub maxTimelineSemaphoreValueDifference: u64,
    pub framebufferIntegerColorSampleCounts: SampleCountFlags,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan13Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub robustImageAccess: Bool32,
    pub inlineUniformBlock: Bool32,
    pub descriptorBindingInlineUniformBlockUpdateAfterBind: Bool32,
    pub pipelineCreationCacheControl: Bool32,
    pub privateData: Bool32,
    pub shaderDemoteToHelperInvocation: Bool32,
    pub shaderTerminateInvocation: Bool32,
    pub subgroupSizeControl: Bool32,
    pub computeFullSubgroups: Bool32,
    pub synchronization2: Bool32,
    pub textureCompressionASTC_HDR: Bool32,
    pub shaderZeroInitializeWorkgroupMemory: Bool32,
    pub dynamicRendering: Bool32,
    pub shaderIntegerDotProduct: Bool32,
    pub maintenance4: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVulkan13Properties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minSubgroupSize: u32, // The minimum subgroup size supported by this device
    pub maxSubgroupSize: u32, // The maximum subgroup size supported by this device
    pub maxComputeWorkgroupSubgroups: u32, // The maximum number of subgroups supported in a workgroup
    pub requiredSubgroupSizeStages: ShaderStageFlags, // The shader stages that support specifying a subgroup size
    pub maxInlineUniformBlockSize: u32,
    pub maxPerStageDescriptorInlineUniformBlocks: u32,
    pub maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks: u32,
    pub maxDescriptorSetInlineUniformBlocks: u32,
    pub maxDescriptorSetUpdateAfterBindInlineUniformBlocks: u32,
    pub maxInlineUniformTotalSize: u32,
    pub integerDotProduct8BitUnsignedAccelerated: Bool32,
    pub integerDotProduct8BitSignedAccelerated: Bool32,
    pub integerDotProduct8BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedUnsignedAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedSignedAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedMixedSignednessAccelerated: Bool32,
    pub integerDotProduct16BitUnsignedAccelerated: Bool32,
    pub integerDotProduct16BitSignedAccelerated: Bool32,
    pub integerDotProduct16BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct32BitUnsignedAccelerated: Bool32,
    pub integerDotProduct32BitSignedAccelerated: Bool32,
    pub integerDotProduct32BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct64BitUnsignedAccelerated: Bool32,
    pub integerDotProduct64BitSignedAccelerated: Bool32,
    pub integerDotProduct64BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated: Bool32,
    pub storageTexelBufferOffsetAlignmentBytes: DeviceSize,
    pub storageTexelBufferOffsetSingleTexelAlignment: Bool32,
    pub uniformTexelBufferOffsetAlignmentBytes: DeviceSize,
    pub uniformTexelBufferOffsetSingleTexelAlignment: Bool32,
    pub maxBufferSize: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineCompilerControlCreateInfoAMD {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub compilerControlFlags: PipelineCompilerControlFlagsAMD,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCoherentMemoryFeaturesAMD {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub deviceCoherentMemory: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceToolProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub name: [c_char; MAX_EXTENSION_NAME_SIZE as usize],
    pub version: [c_char; MAX_EXTENSION_NAME_SIZE as usize],
    pub purposes: ToolPurposeFlags,
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
    pub layer: [c_char; MAX_EXTENSION_NAME_SIZE as usize],
}

pub type PhysicalDeviceToolPropertiesEXT = PhysicalDeviceToolProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerCustomBorderColorCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub customBorderColor: ClearColorValue,
    pub format: Format,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCustomBorderColorPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxCustomBorderColorSamplers: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceCustomBorderColorFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub customBorderColors: Bool32,
    pub customBorderColorWithoutFormat: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SamplerBorderColorComponentMappingCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub components: ComponentMapping,
    pub srgb: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceBorderColorSwizzleFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub borderColorSwizzle: Bool32,
    pub borderColorSwizzleFromImage: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureGeometryTrianglesDataKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub vertexFormat: Format,
    pub vertexData: DeviceOrHostAddressConstKHR,
    pub vertexStride: DeviceSize,
    pub maxVertex: u32,
    pub indexType: IndexType,
    pub indexData: DeviceOrHostAddressConstKHR,
    pub transformData: DeviceOrHostAddressConstKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureGeometryAabbsDataKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub data: DeviceOrHostAddressConstKHR,
    pub stride: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureGeometryInstancesDataKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub arrayOfPointers: Bool32,
    pub data: DeviceOrHostAddressConstKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureGeometryKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub geometryType: GeometryTypeKHR,
    pub geometry: AccelerationStructureGeometryDataKHR,
    pub flags: GeometryFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureBuildGeometryInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub typ: AccelerationStructureTypeKHR,
    pub flags: BuildAccelerationStructureFlagsKHR,
    pub mode: BuildAccelerationStructureModeKHR,
    pub srcAccelerationStructure: AccelerationStructureKHR,
    pub dstAccelerationStructure: AccelerationStructureKHR,
    pub geometryCount: u32,
    pub pGeometries: *const AccelerationStructureGeometryKHR,
    pub ppGeometries: *const *const AccelerationStructureGeometryKHR,
    pub scratchData: DeviceOrHostAddressKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureBuildRangeInfoKHR {
    pub primitiveCount: u32,
    pub primitiveOffset: u32,
    pub firstVertex: u32,
    pub transformOffset: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub createFlags: AccelerationStructureCreateFlagsKHR,
    pub buffer: Buffer,
    pub offset: DeviceSize, // Specified in bytes
    pub size: DeviceSize,
    pub typ: AccelerationStructureTypeKHR,
    pub deviceAddress: DeviceAddress,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AabbPositionsKHR {
    pub minX: f32,
    pub minY: f32,
    pub minZ: f32,
    pub maxX: f32,
    pub maxY: f32,
    pub maxZ: f32,
}

pub type AabbPositionsNV = AabbPositionsKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct TransformMatrixKHR {
    pub matrix: [[f32; 4]; 3],
}

pub type TransformMatrixNV = TransformMatrixKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureInstanceKHR {
    pub transform: TransformMatrixKHR,
    pub instanceCustomIndex: u32, // 24 bits, 8 bits for mask
    pub instanceShaderBindingTableRecordOffset: u32, // 24 bits, 8 bits for flags
    pub accelerationStructureReference: u64,
}

pub type AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureDeviceAddressInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub accelerationStructure: AccelerationStructureKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureVersionInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pVersionData: *const u8,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyAccelerationStructureInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub src: AccelerationStructureKHR,
    pub dst: AccelerationStructureKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyAccelerationStructureToMemoryInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub src: AccelerationStructureKHR,
    pub dst: DeviceOrHostAddressKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyMemoryToAccelerationStructureInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub src: DeviceOrHostAddressConstKHR,
    pub dst: AccelerationStructureKHR,
    pub mode: CopyAccelerationStructureModeKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RayTracingPipelineInterfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub maxPipelineRayPayloadSize: u32,
    pub maxPipelineRayHitAttributeSize: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineLibraryCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub libraryCount: u32,
    pub pLibraries: *const Pipeline,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExtendedDynamicStateFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub extendedDynamicState: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExtendedDynamicState2FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub extendedDynamicState2: Bool32,
    pub extendedDynamicState2LogicOp: Bool32,
    pub extendedDynamicState2PatchControlPoints: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderPassTransformBeginInfoQCOM {
    pub sType: StructureType,
    pub pNext: *mut c_void, // Pointer to next structure
    pub transform: SurfaceTransformFlagBitsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyCommandTransformInfoQCOM {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub transform: SurfaceTransformFlagBitsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferInheritanceRenderPassTransformInfoQCOM {
    pub sType: StructureType,
    pub pNext: *mut c_void, // Pointer to next structure
    pub transform: SurfaceTransformFlagBitsKHR,
    pub renderArea: Rect2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDiagnosticsConfigFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub diagnosticsConfig: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DeviceDiagnosticsConfigCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceDiagnosticsConfigFlagsNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceZeroInitializeWorkgroupMemoryFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderZeroInitializeWorkgroupMemory: Bool32,
}

pub type PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR = PhysicalDeviceZeroInitializeWorkgroupMemoryFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSubgroupUniformControlFlow: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRobustness2FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub robustBufferAccess2: Bool32,
    pub robustImageAccess2: Bool32,
    pub nullDescriptor: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRobustness2PropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub robustStorageBufferAccessSizeAlignment: DeviceSize,
    pub robustUniformBufferAccessSizeAlignment: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImageRobustnessFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub robustImageAccess: Bool32,
}

pub type PhysicalDeviceImageRobustnessFeaturesEXT = PhysicalDeviceImageRobustnessFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub workgroupMemoryExplicitLayout: Bool32,
    pub workgroupMemoryExplicitLayoutScalarBlockLayout: Bool32,
    pub workgroupMemoryExplicitLayout8BitAccess: Bool32,
    pub workgroupMemoryExplicitLayout16BitAccess: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePortabilitySubsetFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub constantAlphaColorBlendFactors: Bool32,
    pub events: Bool32,
    pub imageViewFormatReinterpretation: Bool32,
    pub imageViewFormatSwizzle: Bool32,
    pub imageView2DOn3DImage: Bool32,
    pub multisampleArrayImage: Bool32,
    pub mutableComparisonSamplers: Bool32,
    pub pointPolygons: Bool32,
    pub samplerMipLodBias: Bool32,
    pub separateStencilMaskRef: Bool32,
    pub shaderSampleRateInterpolationFunctions: Bool32,
    pub tessellationIsolines: Bool32,
    pub tessellationPointMode: Bool32,
    pub triangleFans: Bool32,
    pub vertexAttributeAccessBeyondStride: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePortabilitySubsetPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minVertexInputBindingStrideAlignment: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevice4444FormatsFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub formatA4R4G4B4: Bool32,
    pub formatA4B4G4R4: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSubpassShadingFeaturesHUAWEI {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub subpassShading: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferCopy2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcOffset: DeviceSize, // Specified in bytes
    pub dstOffset: DeviceSize, // Specified in bytes
    pub size: DeviceSize, // Specified in bytes
}

pub type BufferCopy2KHR = BufferCopy2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageCopy2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub extent: Extent3D, // Specified in pixels for both compressed and uncompressed images
}

pub type ImageCopy2KHR = ImageCopy2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageBlit2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffsets: [Offset3D; 2], // Specified in pixels for both compressed and uncompressed images
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffsets: [Offset3D; 2], // Specified in pixels for both compressed and uncompressed images
}

pub type ImageBlit2KHR = ImageBlit2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferImageCopy2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub bufferOffset: DeviceSize, // Specified in bytes
    pub bufferRowLength: u32, // Specified in texels
    pub bufferImageHeight: u32,
    pub imageSubresource: ImageSubresourceLayers,
    pub imageOffset: Offset3D, // Specified in pixels for both compressed and uncompressed images
    pub imageExtent: Extent3D, // Specified in pixels for both compressed and uncompressed images
}

pub type BufferImageCopy2KHR = BufferImageCopy2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageResolve2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D,
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D,
    pub extent: Extent3D,
}

pub type ImageResolve2KHR = ImageResolve2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyBufferInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcBuffer: Buffer,
    pub dstBuffer: Buffer,
    pub regionCount: u32,
    pub pRegions: *const BufferCopy2,
}

pub type CopyBufferInfo2KHR = CopyBufferInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyImageInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcImage: Image,
    pub srcImageLayout: ImageLayout,
    pub dstImage: Image,
    pub dstImageLayout: ImageLayout,
    pub regionCount: u32,
    pub pRegions: *const ImageCopy2,
}

pub type CopyImageInfo2KHR = CopyImageInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BlitImageInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcImage: Image,
    pub srcImageLayout: ImageLayout,
    pub dstImage: Image,
    pub dstImageLayout: ImageLayout,
    pub regionCount: u32,
    pub pRegions: *const ImageBlit2,
    pub filter: Filter,
}

pub type BlitImageInfo2KHR = BlitImageInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyBufferToImageInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcBuffer: Buffer,
    pub dstImage: Image,
    pub dstImageLayout: ImageLayout,
    pub regionCount: u32,
    pub pRegions: *const BufferImageCopy2,
}

pub type CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CopyImageToBufferInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcImage: Image,
    pub srcImageLayout: ImageLayout,
    pub dstBuffer: Buffer,
    pub regionCount: u32,
    pub pRegions: *const BufferImageCopy2,
}

pub type CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ResolveImageInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcImage: Image,
    pub srcImageLayout: ImageLayout,
    pub dstImage: Image,
    pub dstImageLayout: ImageLayout,
    pub regionCount: u32,
    pub pRegions: *const ImageResolve2,
}

pub type ResolveImageInfo2KHR = ResolveImageInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderImageInt64Atomics: Bool32,
    pub sparseImageInt64Atomics: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FragmentShadingRateAttachmentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pFragmentShadingRateAttachment: *const AttachmentReference2,
    pub shadingRateAttachmentTexelSize: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineFragmentShadingRateStateCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub fragmentSize: Extent2D,
    pub combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShadingRateFeaturesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub pipelineFragmentShadingRate: Bool32,
    pub primitiveFragmentShadingRate: Bool32,
    pub attachmentFragmentShadingRate: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShadingRatePropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minFragmentShadingRateAttachmentTexelSize: Extent2D,
    pub maxFragmentShadingRateAttachmentTexelSize: Extent2D,
    pub maxFragmentShadingRateAttachmentTexelSizeAspectRatio: u32,
    pub primitiveFragmentShadingRateWithMultipleViewports: Bool32,
    pub layeredShadingRateAttachments: Bool32,
    pub fragmentShadingRateNonTrivialCombinerOps: Bool32,
    pub maxFragmentSize: Extent2D,
    pub maxFragmentSizeAspectRatio: u32,
    pub maxFragmentShadingRateCoverageSamples: u32,
    pub maxFragmentShadingRateRasterizationSamples: SampleCountFlagBits,
    pub fragmentShadingRateWithShaderDepthStencilWrites: Bool32,
    pub fragmentShadingRateWithSampleMask: Bool32,
    pub fragmentShadingRateWithShaderSampleMask: Bool32,
    pub fragmentShadingRateWithConservativeRasterization: Bool32,
    pub fragmentShadingRateWithFragmentShaderInterlock: Bool32,
    pub fragmentShadingRateWithCustomSampleLocations: Bool32,
    pub fragmentShadingRateStrictMultiplyCombiner: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShadingRateKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub sampleCounts: SampleCountFlags,
    pub fragmentSize: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderTerminateInvocationFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderTerminateInvocation: Bool32,
}

pub type PhysicalDeviceShaderTerminateInvocationFeaturesKHR = PhysicalDeviceShaderTerminateInvocationFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fragmentShadingRateEnums: Bool32,
    pub supersampleFragmentShadingRates: Bool32,
    pub noInvocationFragmentShadingRates: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub maxFragmentShadingRateInvocationCount: SampleCountFlagBits,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineFragmentShadingRateEnumStateCreateInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub shadingRateType: FragmentShadingRateTypeNV,
    pub shadingRate: FragmentShadingRateNV,
    pub combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureBuildSizesInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub accelerationStructureSize: DeviceSize,
    pub updateScratchSize: DeviceSize,
    pub buildScratchSize: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImage2DViewOf3DFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub image2DViewOf3D: Bool32,
    pub sampler2DViewOf3D: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub mutableDescriptorType: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MutableDescriptorTypeListVALVE {
    pub descriptorTypeCount: u32,
    pub pDescriptorTypes: *const DescriptorType,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MutableDescriptorTypeCreateInfoVALVE {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub mutableDescriptorTypeListCount: u32,
    pub pMutableDescriptorTypeLists: *const MutableDescriptorTypeListVALVE,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDepthClipControlFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub depthClipControl: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineViewportDepthClipControlCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub negativeOneToOne: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub vertexInputDynamicState: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceExternalMemoryRDMAFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub externalMemoryRDMA: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VertexInputBindingDescription2EXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VertexInputRate,
    pub divisor: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VertexInputAttributeDescription2EXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub location: u32, // location of the shader vertex attrib
    pub binding: u32, // Vertex buffer binding id
    pub format: Format, // format of source data
    pub offset: u32, // Offset of first element in bytes from base of vertex
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceColorWriteEnableFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub colorWriteEnable: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineColorWriteCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub attachmentCount: u32, // # of pAttachments
    pub pColorWriteEnables: *const Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryBarrier2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcStageMask: PipelineStageFlags2,
    pub srcAccessMask: AccessFlags2,
    pub dstStageMask: PipelineStageFlags2,
    pub dstAccessMask: AccessFlags2,
}

pub type MemoryBarrier2KHR = MemoryBarrier2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageMemoryBarrier2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcStageMask: PipelineStageFlags2,
    pub srcAccessMask: AccessFlags2,
    pub dstStageMask: PipelineStageFlags2,
    pub dstAccessMask: AccessFlags2,
    pub oldLayout: ImageLayout,
    pub newLayout: ImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: Image,
    pub subresourceRange: ImageSubresourceRange,
}

pub type ImageMemoryBarrier2KHR = ImageMemoryBarrier2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct BufferMemoryBarrier2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcStageMask: PipelineStageFlags2,
    pub srcAccessMask: AccessFlags2,
    pub dstStageMask: PipelineStageFlags2,
    pub dstAccessMask: AccessFlags2,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

pub type BufferMemoryBarrier2KHR = BufferMemoryBarrier2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DependencyInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dependencyFlags: DependencyFlags,
    pub memoryBarrierCount: u32,
    pub pMemoryBarriers: *const MemoryBarrier2,
    pub bufferMemoryBarrierCount: u32,
    pub pBufferMemoryBarriers: *const BufferMemoryBarrier2,
    pub imageMemoryBarrierCount: u32,
    pub pImageMemoryBarriers: *const ImageMemoryBarrier2,
}

pub type DependencyInfoKHR = DependencyInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SemaphoreSubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub semaphore: Semaphore,
    pub value: u64,
    pub stageMask: PipelineStageFlags2,
    pub deviceIndex: u32,
}

pub type SemaphoreSubmitInfoKHR = SemaphoreSubmitInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferSubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub commandBuffer: CommandBuffer,
    pub deviceMask: u32,
}

pub type CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubmitInfo2 {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SubmitFlags,
    pub waitSemaphoreInfoCount: u32,
    pub pWaitSemaphoreInfos: *const SemaphoreSubmitInfo,
    pub commandBufferInfoCount: u32,
    pub pCommandBufferInfos: *const CommandBufferSubmitInfo,
    pub signalSemaphoreInfoCount: u32,
    pub pSignalSemaphoreInfos: *const SemaphoreSubmitInfo,
}

pub type SubmitInfo2KHR = SubmitInfo2;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyCheckpointProperties2NV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub checkpointExecutionStageMask: PipelineStageFlags2,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CheckpointData2NV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub stage: PipelineStageFlags2,
    pub pCheckpointMarker: *mut c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceSynchronization2Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub synchronization2: Bool32,
}

pub type PhysicalDeviceSynchronization2FeaturesKHR = PhysicalDeviceSynchronization2Features;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDevicePrimitivesGeneratedQueryFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub primitivesGeneratedQuery: Bool32,
    pub primitivesGeneratedQueryWithRasterizerDiscard: Bool32,
    pub primitivesGeneratedQueryWithNonZeroStreams: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoQueueFamilyProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub videoCodecOperations: VideoCodecOperationFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct QueueFamilyQueryResultStatusProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub supported: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoProfilesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub profileCount: u32,
    pub pProfiles: *const VideoProfileKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceVideoFormatInfoKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imageUsage: ImageUsageFlags,
    pub pVideoProfiles: *const VideoProfilesKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoFormatPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub format: Format,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoProfileKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub videoCodecOperation: VideoCodecOperationFlagBitsKHR,
    pub chromaSubsampling: VideoChromaSubsamplingFlagsKHR,
    pub lumaBitDepth: VideoComponentBitDepthFlagsKHR,
    pub chromaBitDepth: VideoComponentBitDepthFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub capabilityFlags: VideoCapabilityFlagsKHR,
    pub minBitstreamBufferOffsetAlignment: DeviceSize,
    pub minBitstreamBufferSizeAlignment: DeviceSize,
    pub videoPictureExtentGranularity: Extent2D,
    pub minExtent: Extent2D,
    pub maxExtent: Extent2D,
    pub maxReferencePicturesSlotsCount: u32,
    pub maxReferencePicturesActiveCount: u32,
    pub stdHeaderVersion: ExtensionProperties,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoGetMemoryPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memoryBindIndex: u32,
    pub pMemoryRequirements: *mut MemoryRequirements2,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoBindMemoryKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memoryBindIndex: u32,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
    pub memorySize: DeviceSize,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoPictureResourceKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub codedOffset: Offset2D, // The offset to be used for the picture resource, currently only used in field mode
    pub codedExtent: Extent2D, // The extent to be used for the picture resource
    pub baseArrayLayer: u32, // TThe first array layer to be accessed for the Decode or Encode Operations
    pub imageViewBinding: ImageView, // The ImageView binding of the resource
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoReferenceSlotKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub slotIndex: i8, // The reference slot index
    pub pPictureResource: *const VideoPictureResourceKHR, // The reference picture resource
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoDecodeCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub flags: VideoDecodeCapabilityFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoDecodeInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoDecodeFlagsKHR,
    pub srcBuffer: Buffer,
    pub srcBufferOffset: DeviceSize,
    pub srcBufferRange: DeviceSize,
    pub dstPictureResource: VideoPictureResourceKHR,
    pub pSetupReferenceSlot: *const VideoReferenceSlotKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VideoReferenceSlotKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoSessionCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub queueFamilyIndex: u32,
    pub flags: VideoSessionCreateFlagsKHR,
    pub pVideoProfile: *const VideoProfileKHR,
    pub pictureFormat: Format,
    pub maxCodedExtent: Extent2D,
    pub referencePicturesFormat: Format,
    pub maxReferencePicturesSlotsCount: u32,
    pub maxReferencePicturesActiveCount: u32,
    pub pStdHeaderVersion: *const ExtensionProperties,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoSessionParametersCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub videoSessionParametersTemplate: VideoSessionParametersKHR,
    pub videoSession: VideoSessionKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoSessionParametersUpdateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub updateSequenceCount: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoBeginCodingInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoBeginCodingFlagsKHR,
    pub codecQualityPreset: VideoCodingQualityPresetFlagsKHR,
    pub videoSession: VideoSessionKHR,
    pub videoSessionParameters: VideoSessionParametersKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VideoReferenceSlotKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoEndCodingInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoEndCodingFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoCodingControlInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoCodingControlFlagsKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoEncodeInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoEncodeFlagsKHR,
    pub qualityLevel: u32,
    pub dstBitstreamBuffer: Buffer,
    pub dstBitstreamBufferOffset: DeviceSize,
    pub dstBitstreamBufferMaxRange: DeviceSize,
    pub srcPictureResource: VideoPictureResourceKHR,
    pub pSetupReferenceSlot: *const VideoReferenceSlotKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VideoReferenceSlotKHR,
    pub precedingExternallyEncodedBytes: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoEncodeRateControlInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: VideoEncodeRateControlFlagsKHR,
    pub rateControlMode: VideoEncodeRateControlModeFlagBitsKHR,
    pub layerCount: u8,
    pub pLayerConfigs: *const VideoEncodeRateControlLayerInfoKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoEncodeRateControlLayerInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub averageBitrate: u32,
    pub maxBitrate: u32,
    pub frameRateNumerator: u32,
    pub frameRateDenominator: u32,
    pub virtualBufferSizeInMs: u32,
    pub initialVirtualBufferSizeInMs: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct VideoEncodeCapabilitiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub flags: VideoEncodeCapabilityFlagsKHR,
    pub rateControlModes: VideoEncodeRateControlModeFlagsKHR,
    pub rateControlLayerCount: u8,
    pub qualityLevelCount: u8,
    pub inputImageDataFillAlignment: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceInheritedViewportScissorFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub inheritedViewportScissor2D: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferInheritanceViewportScissorInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub viewportScissor2D: Bool32,
    pub viewportDepthCount: u32,
    pub pViewportDepths: *const Viewport,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub ycbcr2plane444Formats: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProvokingVertexFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub provokingVertexLast: Bool32,
    pub transformFeedbackPreservesProvokingVertex: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceProvokingVertexPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub provokingVertexModePerPipeline: Bool32,
    pub transformFeedbackPreservesTriangleFanProvokingVertex: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRasterizationProvokingVertexStateCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub provokingVertexMode: ProvokingVertexModeEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CuModuleCreateInfoNVX {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dataSize: usize,
    pub pData: *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CuFunctionCreateInfoNVX {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub module: CuModuleNVX,
    pub pName: *const c_char,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CuLaunchInfoNVX {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub function: CuFunctionNVX,
    pub gridDimX: u32,
    pub gridDimY: u32,
    pub gridDimZ: u32,
    pub blockDimX: u32,
    pub blockDimY: u32,
    pub blockDimZ: u32,
    pub sharedMemBytes: u32,
    pub paramCount: usize,
    pub pParams: *const *const c_void,
    pub extraCount: usize,
    pub pExtras: *const *const c_void,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderIntegerDotProductFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderIntegerDotProduct: Bool32,
}

pub type PhysicalDeviceShaderIntegerDotProductFeaturesKHR = PhysicalDeviceShaderIntegerDotProductFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceShaderIntegerDotProductProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub integerDotProduct8BitUnsignedAccelerated: Bool32,
    pub integerDotProduct8BitSignedAccelerated: Bool32,
    pub integerDotProduct8BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedUnsignedAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedSignedAccelerated: Bool32,
    pub integerDotProduct4x8BitPackedMixedSignednessAccelerated: Bool32,
    pub integerDotProduct16BitUnsignedAccelerated: Bool32,
    pub integerDotProduct16BitSignedAccelerated: Bool32,
    pub integerDotProduct16BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct32BitUnsignedAccelerated: Bool32,
    pub integerDotProduct32BitSignedAccelerated: Bool32,
    pub integerDotProduct32BitMixedSignednessAccelerated: Bool32,
    pub integerDotProduct64BitUnsignedAccelerated: Bool32,
    pub integerDotProduct64BitSignedAccelerated: Bool32,
    pub integerDotProduct64BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitUnsignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitSignedAccelerated: Bool32,
    pub integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated: Bool32,
}

pub type PhysicalDeviceShaderIntegerDotProductPropertiesKHR = PhysicalDeviceShaderIntegerDotProductProperties;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDrmPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub hasPrimary: Bool32,
    pub hasRender: Bool32,
    pub primaryMajor: i64,
    pub primaryMinor: i64,
    pub renderMajor: i64,
    pub renderMinor: i64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRayTracingMotionBlurFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub rayTracingMotionBlur: Bool32,
    pub rayTracingMotionBlurPipelineTraceRaysIndirect: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureGeometryMotionTrianglesDataNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub vertexData: DeviceOrHostAddressConstKHR,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureMotionInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub maxInstances: u32,
    pub flags: AccelerationStructureMotionInfoFlagsNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SRTDataNV {
    pub sx: f32,
    pub a: f32,
    pub b: f32,
    pub pvx: f32,
    pub sy: f32,
    pub c: f32,
    pub pvy: f32,
    pub sz: f32,
    pub pvz: f32,
    pub qx: f32,
    pub qy: f32,
    pub qz: f32,
    pub qw: f32,
    pub tx: f32,
    pub ty: f32,
    pub tz: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureSRTMotionInstanceNV {
    pub transformT0: SRTDataNV,
    pub transformT1: SRTDataNV,
    pub instanceCustomIndex: u32, // 24 bits, 8 bits for mask
    pub instanceShaderBindingTableRecordOffset: u32, // 24 bits, 8 bits for flags
    pub accelerationStructureReference: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureMatrixMotionInstanceNV {
    pub transformT0: TransformMatrixKHR,
    pub transformT1: TransformMatrixKHR,
    pub instanceCustomIndex: u32, // 24 bits, 8 bits for mask
    pub instanceShaderBindingTableRecordOffset: u32, // 24 bits, 8 bits for flags
    pub accelerationStructureReference: u64,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AccelerationStructureMotionInstanceNV {
    pub typ: AccelerationStructureMotionInstanceTypeNV,
    pub flags: AccelerationStructureMotionInstanceFlagsNV,
    pub data: AccelerationStructureMotionInstanceDataNV,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryGetRemoteAddressInfoNV {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRGBA10X6FormatsFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub formatRgba10x6WithoutYCbCrSampler: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FormatProperties3 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub linearTilingFeatures: FormatFeatureFlags2,
    pub optimalTilingFeatures: FormatFeatureFlags2,
    pub bufferFeatures: FormatFeatureFlags2,
}

pub type FormatProperties3KHR = FormatProperties3;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrmFormatModifierPropertiesList2EXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifierProperties: *mut DrmFormatModifierProperties2EXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DrmFormatModifierProperties2EXT {
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub drmFormatModifierTilingFeatures: FormatFeatureFlags2,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PipelineRenderingCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentFormats: *const Format,
    pub depthAttachmentFormat: Format,
    pub stencilAttachmentFormat: Format,
}

pub type PipelineRenderingCreateInfoKHR = PipelineRenderingCreateInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderingInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: RenderingFlags,
    pub renderArea: Rect2D,
    pub layerCount: u32,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const RenderingAttachmentInfo,
    pub pDepthAttachment: *const RenderingAttachmentInfo,
    pub pStencilAttachment: *const RenderingAttachmentInfo,
}

pub type RenderingInfoKHR = RenderingInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderingAttachmentInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub imageView: ImageView,
    pub imageLayout: ImageLayout,
    pub resolveMode: ResolveModeFlagBits,
    pub resolveImageView: ImageView,
    pub resolveImageLayout: ImageLayout,
    pub loadOp: AttachmentLoadOp,
    pub storeOp: AttachmentStoreOp,
    pub clearValue: ClearValue,
}

pub type RenderingAttachmentInfoKHR = RenderingAttachmentInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderingFragmentShadingRateAttachmentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub imageView: ImageView,
    pub imageLayout: ImageLayout,
    pub shadingRateAttachmentTexelSize: Extent2D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct RenderingFragmentDensityMapAttachmentInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub imageView: ImageView,
    pub imageLayout: ImageLayout,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDynamicRenderingFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub dynamicRendering: Bool32,
}

pub type PhysicalDeviceDynamicRenderingFeaturesKHR = PhysicalDeviceDynamicRenderingFeatures;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct CommandBufferInheritanceRenderingInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: RenderingFlags,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentFormats: *const Format,
    pub depthAttachmentFormat: Format,
    pub stencilAttachmentFormat: Format,
    pub rasterizationSamples: SampleCountFlagBits,
}

pub type CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AttachmentSampleCountInfoAMD {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentSamples: *const SampleCountFlagBits,
    pub depthStencilAttachmentSamples: SampleCountFlagBits,
}

pub type AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MultiviewPerViewAttributesInfoNVX {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub perViewAttributes: Bool32,
    pub perViewAttributesPositionXOnly: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceImageViewMinLodFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub minLod: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageViewMinLodCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub minLod: f32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub rasterizationOrderColorAttachmentAccess: Bool32,
    pub rasterizationOrderDepthAttachmentAccess: Bool32,
    pub rasterizationOrderStencilAttachmentAccess: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceLinearColorAttachmentFeaturesNV {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub linearColorAttachment: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceGraphicsPipelineLibraryFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub graphicsPipelineLibrary: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceGraphicsPipelineLibraryPropertiesEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub graphicsPipelineLibraryFastLinking: Bool32,
    pub graphicsPipelineLibraryIndependentInterpolationDecoration: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct GraphicsPipelineLibraryCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub flags: GraphicsPipelineLibraryFlagsEXT,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct PhysicalDeviceDescriptorSetHostMappingFeaturesVALVE {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub descriptorSetHostMapping: Bool32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetBindingReferenceVALVE {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub descriptorSetLayout: DescriptorSetLayout,
    pub binding: u32,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct DescriptorSetLayoutHostMappingInfoVALVE {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub descriptorOffset: usize,
    pub descriptorSize: u32,
}

// function pointer types

pub type FnInternalAllocationNotification = extern "system" fn(
    pUserData: *mut c_void,
    size: usize,
    allocationType: InternalAllocationType,
    allocationScope: SystemAllocationScope,
) -> ();
pub type FnInternalFreeNotification = extern "system" fn(
    pUserData: *mut c_void,
    size: usize,
    allocationType: InternalAllocationType,
    allocationScope: SystemAllocationScope,
) -> ();
pub type FnReallocationFunction = extern "system" fn(
    pUserData: *mut c_void,
    pOriginal: *mut c_void,
    size: usize,
    alignment: usize,
    allocationScope: SystemAllocationScope,
) -> *mut c_void;
pub type FnAllocationFunction = extern "system" fn(
    pUserData: *mut c_void,
    size: usize,
    alignment: usize,
    allocationScope: SystemAllocationScope,
) -> *mut c_void;
pub type FnFreeFunction = extern "system" fn(
    pUserData: *mut c_void,
    pMemory: *mut c_void,
) -> ();
pub type FnVoidFunction = extern "system" fn() -> ();
pub type FnDebugReportCallbackEXT = extern "system" fn(
    flags: DebugReportFlagsEXT,
    objectType: DebugReportObjectTypeEXT,
    object: u64,
    location: usize,
    messageCode: i32,
    pLayerPrefix: *const c_char,
    pMessage: *const c_char,
    pUserData: *mut c_void,
) -> Bool32;
pub type FnDebugUtilsMessengerCallbackEXT = extern "system" fn(
    messageSeverity: DebugUtilsMessageSeverityFlagBitsEXT,
    messageTypes: DebugUtilsMessageTypeFlagsEXT,
    pCallbackData: *const DebugUtilsMessengerCallbackDataEXT,
    pUserData: *mut c_void,
) -> Bool32;
pub type FnDeviceMemoryReportCallbackEXT = extern "system" fn(
    pCallbackData: *const DeviceMemoryReportCallbackDataEXT,
    pUserData: *mut c_void,
) -> ();

// static commands

pub type FnCreateInstance = extern "system" fn(
    pCreateInfo: *const InstanceCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pInstance: *mut Instance,
) -> Result;

pub type FnGetInstanceProcAddr = extern "system" fn(
    instance: Instance,
    pName: *const c_char,
) -> FnVoidFunction;

pub type FnEnumerateInstanceExtensionProperties = extern "system" fn(
    pLayerName: *const c_char,
    pPropertyCount: *mut u32,
    pProperties: *mut ExtensionProperties,
) -> Result;

pub type FnEnumerateInstanceLayerProperties = extern "system" fn(
    pPropertyCount: *mut u32,
    pProperties: *mut LayerProperties,
) -> Result;

pub type FnEnumerateInstanceVersion = extern "system" fn(
    pApiVersion: *mut u32,
) -> Result;

// instance commands

pub type FnDestroyInstance = extern "system" fn(
    instance: Instance,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnEnumeratePhysicalDevices = extern "system" fn(
    instance: Instance,
    pPhysicalDeviceCount: *mut u32,
    pPhysicalDevices: *mut PhysicalDevice,
) -> Result;

pub type FnGetPhysicalDeviceFeatures = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pFeatures: *mut PhysicalDeviceFeatures,
) -> ();

pub type FnGetPhysicalDeviceFormatProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    format: Format,
    pFormatProperties: *mut FormatProperties,
) -> ();

pub type FnGetPhysicalDeviceImageFormatProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    format: Format,
    typ: ImageType,
    tiling: ImageTiling,
    usage: ImageUsageFlags,
    flags: ImageCreateFlags,
    pImageFormatProperties: *mut ImageFormatProperties,
) -> Result;

pub type FnGetPhysicalDeviceProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pProperties: *mut PhysicalDeviceProperties,
) -> ();

pub type FnGetPhysicalDeviceQueueFamilyProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pQueueFamilyPropertyCount: *mut u32,
    pQueueFamilyProperties: *mut QueueFamilyProperties,
) -> ();

pub type FnGetPhysicalDeviceMemoryProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pMemoryProperties: *mut PhysicalDeviceMemoryProperties,
) -> ();

pub type FnGetDeviceProcAddr = extern "system" fn(
    device: Device,
    pName: *const c_char,
) -> FnVoidFunction;

pub type FnCreateDevice = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pCreateInfo: *const DeviceCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pDevice: *mut Device,
) -> Result;

pub type FnEnumerateDeviceExtensionProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pLayerName: *const c_char,
    pPropertyCount: *mut u32,
    pProperties: *mut ExtensionProperties,
) -> Result;

pub type FnEnumerateDeviceLayerProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut LayerProperties,
) -> Result;

pub type FnGetPhysicalDeviceSparseImageFormatProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    format: Format,
    typ: ImageType,
    samples: SampleCountFlagBits,
    usage: ImageUsageFlags,
    tiling: ImageTiling,
    pPropertyCount: *mut u32,
    pProperties: *mut SparseImageFormatProperties,
) -> ();

pub type FnEnumeratePhysicalDeviceGroups = extern "system" fn(
    instance: Instance,
    pPhysicalDeviceGroupCount: *mut u32,
    pPhysicalDeviceGroupProperties: *mut PhysicalDeviceGroupProperties,
) -> Result;

pub type FnGetPhysicalDeviceFeatures2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pFeatures: *mut PhysicalDeviceFeatures2,
) -> ();

pub type FnGetPhysicalDeviceProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pProperties: *mut PhysicalDeviceProperties2,
) -> ();

pub type FnGetPhysicalDeviceFormatProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    format: Format,
    pFormatProperties: *mut FormatProperties2,
) -> ();

pub type FnGetPhysicalDeviceImageFormatProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pImageFormatInfo: *const PhysicalDeviceImageFormatInfo2,
    pImageFormatProperties: *mut ImageFormatProperties2,
) -> Result;

pub type FnGetPhysicalDeviceQueueFamilyProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pQueueFamilyPropertyCount: *mut u32,
    pQueueFamilyProperties: *mut QueueFamilyProperties2,
) -> ();

pub type FnGetPhysicalDeviceMemoryProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pMemoryProperties: *mut PhysicalDeviceMemoryProperties2,
) -> ();

pub type FnGetPhysicalDeviceSparseImageFormatProperties2 = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pFormatInfo: *const PhysicalDeviceSparseImageFormatInfo2,
    pPropertyCount: *mut u32,
    pProperties: *mut SparseImageFormatProperties2,
) -> ();

pub type FnGetPhysicalDeviceExternalBufferProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pExternalBufferInfo: *const PhysicalDeviceExternalBufferInfo,
    pExternalBufferProperties: *mut ExternalBufferProperties,
) -> ();

pub type FnGetPhysicalDeviceExternalFenceProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pExternalFenceInfo: *const PhysicalDeviceExternalFenceInfo,
    pExternalFenceProperties: *mut ExternalFenceProperties,
) -> ();

pub type FnGetPhysicalDeviceExternalSemaphoreProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pExternalSemaphoreInfo: *const PhysicalDeviceExternalSemaphoreInfo,
    pExternalSemaphoreProperties: *mut ExternalSemaphoreProperties,
) -> ();

pub type FnGetPhysicalDeviceToolProperties = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pToolCount: *mut u32,
    pToolProperties: *mut PhysicalDeviceToolProperties,
) -> Result;

pub type FnDestroySurfaceKHR = extern "system" fn(
    instance: Instance,
    surface: SurfaceKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetPhysicalDeviceSurfaceSupportKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    queueFamilyIndex: u32,
    surface: SurfaceKHR,
    pSupported: *mut Bool32,
) -> Result;

pub type FnGetPhysicalDeviceSurfaceCapabilitiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    surface: SurfaceKHR,
    pSurfaceCapabilities: *mut SurfaceCapabilitiesKHR,
) -> Result;

pub type FnGetPhysicalDeviceSurfaceFormatsKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    surface: SurfaceKHR,
    pSurfaceFormatCount: *mut u32,
    pSurfaceFormats: *mut SurfaceFormatKHR,
) -> Result;

pub type FnGetPhysicalDeviceSurfacePresentModesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    surface: SurfaceKHR,
    pPresentModeCount: *mut u32,
    pPresentModes: *mut PresentModeKHR,
) -> Result;

pub type FnGetPhysicalDevicePresentRectanglesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    surface: SurfaceKHR,
    pRectCount: *mut u32,
    pRects: *mut Rect2D,
) -> Result;

pub type FnGetPhysicalDeviceDisplayPropertiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayPropertiesKHR,
) -> Result;

pub type FnGetPhysicalDeviceDisplayPlanePropertiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayPlanePropertiesKHR,
) -> Result;

pub type FnGetDisplayPlaneSupportedDisplaysKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    planeIndex: u32,
    pDisplayCount: *mut u32,
    pDisplays: *mut DisplayKHR,
) -> Result;

pub type FnGetDisplayModePropertiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    display: DisplayKHR,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayModePropertiesKHR,
) -> Result;

pub type FnCreateDisplayModeKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    display: DisplayKHR,
    pCreateInfo: *const DisplayModeCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pMode: *mut DisplayModeKHR,
) -> Result;

pub type FnGetDisplayPlaneCapabilitiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    mode: DisplayModeKHR,
    planeIndex: u32,
    pCapabilities: *mut DisplayPlaneCapabilitiesKHR,
) -> Result;

pub type FnCreateDisplayPlaneSurfaceKHR = extern "system" fn(
    instance: Instance,
    pCreateInfo: *const DisplaySurfaceCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pSurface: *mut SurfaceKHR,
) -> Result;

pub type FnCreateDebugReportCallbackEXT = extern "system" fn(
    instance: Instance,
    pCreateInfo: *const DebugReportCallbackCreateInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pCallback: *mut DebugReportCallbackEXT,
) -> Result;

pub type FnDestroyDebugReportCallbackEXT = extern "system" fn(
    instance: Instance,
    callback: DebugReportCallbackEXT,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnDebugReportMessageEXT = extern "system" fn(
    instance: Instance,
    flags: DebugReportFlagsEXT,
    objectType: DebugReportObjectTypeEXT,
    object: u64,
    location: usize,
    messageCode: i32,
    pLayerPrefix: *const c_char,
    pMessage: *const c_char,
) -> ();

pub type FnGetPhysicalDeviceVideoCapabilitiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pVideoProfile: *const VideoProfileKHR,
    pCapabilities: *mut VideoCapabilitiesKHR,
) -> Result;

pub type FnGetPhysicalDeviceVideoFormatPropertiesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pVideoFormatInfo: *const PhysicalDeviceVideoFormatInfoKHR,
    pVideoFormatPropertyCount: *mut u32,
    pVideoFormatProperties: *mut VideoFormatPropertiesKHR,
) -> Result;

pub type FnGetPhysicalDeviceExternalImageFormatPropertiesNV = extern "system" fn(
    physicalDevice: PhysicalDevice,
    format: Format,
    typ: ImageType,
    tiling: ImageTiling,
    usage: ImageUsageFlags,
    flags: ImageCreateFlags,
    externalHandleType: ExternalMemoryHandleTypeFlagsNV,
    pExternalImageFormatProperties: *mut ExternalImageFormatPropertiesNV,
) -> Result;

pub type FnGetPhysicalDeviceFeatures2KHR = FnGetPhysicalDeviceFeatures2;

pub type FnGetPhysicalDeviceProperties2KHR = FnGetPhysicalDeviceProperties2;

pub type FnGetPhysicalDeviceFormatProperties2KHR = FnGetPhysicalDeviceFormatProperties2;

pub type FnGetPhysicalDeviceImageFormatProperties2KHR = FnGetPhysicalDeviceImageFormatProperties2;

pub type FnGetPhysicalDeviceQueueFamilyProperties2KHR = FnGetPhysicalDeviceQueueFamilyProperties2;

pub type FnGetPhysicalDeviceMemoryProperties2KHR = FnGetPhysicalDeviceMemoryProperties2;

pub type FnGetPhysicalDeviceSparseImageFormatProperties2KHR = FnGetPhysicalDeviceSparseImageFormatProperties2;

pub type FnEnumeratePhysicalDeviceGroupsKHR = FnEnumeratePhysicalDeviceGroups;

pub type FnGetPhysicalDeviceExternalBufferPropertiesKHR = FnGetPhysicalDeviceExternalBufferProperties;

pub type FnGetPhysicalDeviceExternalSemaphorePropertiesKHR = FnGetPhysicalDeviceExternalSemaphoreProperties;

pub type FnReleaseDisplayEXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    display: DisplayKHR,
) -> Result;

pub type FnGetPhysicalDeviceSurfaceCapabilities2EXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    surface: SurfaceKHR,
    pSurfaceCapabilities: *mut SurfaceCapabilities2EXT,
) -> Result;

pub type FnGetPhysicalDeviceExternalFencePropertiesKHR = FnGetPhysicalDeviceExternalFenceProperties;

pub type FnEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    queueFamilyIndex: u32,
    pCounterCount: *mut u32,
    pCounters: *mut PerformanceCounterKHR,
    pCounterDescriptions: *mut PerformanceCounterDescriptionKHR,
) -> Result;

pub type FnGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPerformanceQueryCreateInfo: *const QueryPoolPerformanceCreateInfoKHR,
    pNumPasses: *mut u32,
) -> ();

pub type FnGetPhysicalDeviceSurfaceCapabilities2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pSurfaceInfo: *const PhysicalDeviceSurfaceInfo2KHR,
    pSurfaceCapabilities: *mut SurfaceCapabilities2KHR,
) -> Result;

pub type FnGetPhysicalDeviceSurfaceFormats2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pSurfaceInfo: *const PhysicalDeviceSurfaceInfo2KHR,
    pSurfaceFormatCount: *mut u32,
    pSurfaceFormats: *mut SurfaceFormat2KHR,
) -> Result;

pub type FnGetPhysicalDeviceDisplayProperties2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayProperties2KHR,
) -> Result;

pub type FnGetPhysicalDeviceDisplayPlaneProperties2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayPlaneProperties2KHR,
) -> Result;

pub type FnGetDisplayModeProperties2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    display: DisplayKHR,
    pPropertyCount: *mut u32,
    pProperties: *mut DisplayModeProperties2KHR,
) -> Result;

pub type FnGetDisplayPlaneCapabilities2KHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pDisplayPlaneInfo: *const DisplayPlaneInfo2KHR,
    pCapabilities: *mut DisplayPlaneCapabilities2KHR,
) -> Result;

pub type FnCreateDebugUtilsMessengerEXT = extern "system" fn(
    instance: Instance,
    pCreateInfo: *const DebugUtilsMessengerCreateInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pMessenger: *mut DebugUtilsMessengerEXT,
) -> Result;

pub type FnDestroyDebugUtilsMessengerEXT = extern "system" fn(
    instance: Instance,
    messenger: DebugUtilsMessengerEXT,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnSubmitDebugUtilsMessageEXT = extern "system" fn(
    instance: Instance,
    messageSeverity: DebugUtilsMessageSeverityFlagBitsEXT,
    messageTypes: DebugUtilsMessageTypeFlagsEXT,
    pCallbackData: *const DebugUtilsMessengerCallbackDataEXT,
) -> ();

pub type FnGetPhysicalDeviceMultisamplePropertiesEXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    samples: SampleCountFlagBits,
    pMultisampleProperties: *mut MultisamplePropertiesEXT,
) -> ();

pub type FnGetPhysicalDeviceCalibrateableTimeDomainsEXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pTimeDomainCount: *mut u32,
    pTimeDomains: *mut TimeDomainEXT,
) -> Result;

pub type FnGetPhysicalDeviceFragmentShadingRatesKHR = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pFragmentShadingRateCount: *mut u32,
    pFragmentShadingRates: *mut PhysicalDeviceFragmentShadingRateKHR,
) -> Result;

pub type FnGetPhysicalDeviceToolPropertiesEXT = FnGetPhysicalDeviceToolProperties;

pub type FnGetPhysicalDeviceCooperativeMatrixPropertiesNV = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pPropertyCount: *mut u32,
    pProperties: *mut CooperativeMatrixPropertiesNV,
) -> Result;

pub type FnGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = extern "system" fn(
    physicalDevice: PhysicalDevice,
    pCombinationCount: *mut u32,
    pCombinations: *mut FramebufferMixedSamplesCombinationNV,
) -> Result;

pub type FnCreateHeadlessSurfaceEXT = extern "system" fn(
    instance: Instance,
    pCreateInfo: *const HeadlessSurfaceCreateInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pSurface: *mut SurfaceKHR,
) -> Result;

pub type FnAcquireDrmDisplayEXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    drmFd: i32,
    display: DisplayKHR,
) -> Result;

pub type FnGetDrmDisplayEXT = extern "system" fn(
    physicalDevice: PhysicalDevice,
    drmFd: i32,
    connectorId: u32,
    display: *mut DisplayKHR,
) -> Result;

// device commands

pub type FnDestroyDevice = extern "system" fn(
    device: Device,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetDeviceQueue = extern "system" fn(
    device: Device,
    queueFamilyIndex: u32,
    queueIndex: u32,
    pQueue: *mut Queue,
) -> ();

pub type FnQueueSubmit = extern "system" fn(
    queue: Queue,
    submitCount: u32,
    pSubmits: *const SubmitInfo,
    fence: Fence,
) -> Result;

pub type FnQueueWaitIdle = extern "system" fn(
    queue: Queue,
) -> Result;

pub type FnDeviceWaitIdle = extern "system" fn(
    device: Device,
) -> Result;

pub type FnAllocateMemory = extern "system" fn(
    device: Device,
    pAllocateInfo: *const MemoryAllocateInfo,
    pAllocator: *const AllocationCallbacks,
    pMemory: *mut DeviceMemory,
) -> Result;

pub type FnFreeMemory = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnMapMemory = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    offset: DeviceSize,
    size: DeviceSize,
    flags: MemoryMapFlags,
    ppData: *mut *mut c_void,
) -> Result;

pub type FnUnmapMemory = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
) -> ();

pub type FnFlushMappedMemoryRanges = extern "system" fn(
    device: Device,
    memoryRangeCount: u32,
    pMemoryRanges: *const MappedMemoryRange,
) -> Result;

pub type FnInvalidateMappedMemoryRanges = extern "system" fn(
    device: Device,
    memoryRangeCount: u32,
    pMemoryRanges: *const MappedMemoryRange,
) -> Result;

pub type FnGetDeviceMemoryCommitment = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    pCommittedMemoryInBytes: *mut DeviceSize,
) -> ();

pub type FnBindBufferMemory = extern "system" fn(
    device: Device,
    buffer: Buffer,
    memory: DeviceMemory,
    memoryOffset: DeviceSize,
) -> Result;

pub type FnBindImageMemory = extern "system" fn(
    device: Device,
    image: Image,
    memory: DeviceMemory,
    memoryOffset: DeviceSize,
) -> Result;

pub type FnGetBufferMemoryRequirements = extern "system" fn(
    device: Device,
    buffer: Buffer,
    pMemoryRequirements: *mut MemoryRequirements,
) -> ();

pub type FnGetImageMemoryRequirements = extern "system" fn(
    device: Device,
    image: Image,
    pMemoryRequirements: *mut MemoryRequirements,
) -> ();

pub type FnGetImageSparseMemoryRequirements = extern "system" fn(
    device: Device,
    image: Image,
    pSparseMemoryRequirementCount: *mut u32,
    pSparseMemoryRequirements: *mut SparseImageMemoryRequirements,
) -> ();

pub type FnQueueBindSparse = extern "system" fn(
    queue: Queue,
    bindInfoCount: u32,
    pBindInfo: *const BindSparseInfo,
    fence: Fence,
) -> Result;

pub type FnCreateFence = extern "system" fn(
    device: Device,
    pCreateInfo: *const FenceCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pFence: *mut Fence,
) -> Result;

pub type FnDestroyFence = extern "system" fn(
    device: Device,
    fence: Fence,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnResetFences = extern "system" fn(
    device: Device,
    fenceCount: u32,
    pFences: *const Fence,
) -> Result;

pub type FnGetFenceStatus = extern "system" fn(
    device: Device,
    fence: Fence,
) -> Result;

pub type FnWaitForFences = extern "system" fn(
    device: Device,
    fenceCount: u32,
    pFences: *const Fence,
    waitAll: Bool32,
    timeout: u64,
) -> Result;

pub type FnCreateSemaphore = extern "system" fn(
    device: Device,
    pCreateInfo: *const SemaphoreCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pSemaphore: *mut Semaphore,
) -> Result;

pub type FnDestroySemaphore = extern "system" fn(
    device: Device,
    semaphore: Semaphore,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateEvent = extern "system" fn(
    device: Device,
    pCreateInfo: *const EventCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pEvent: *mut Event,
) -> Result;

pub type FnDestroyEvent = extern "system" fn(
    device: Device,
    event: Event,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetEventStatus = extern "system" fn(
    device: Device,
    event: Event,
) -> Result;

pub type FnSetEvent = extern "system" fn(
    device: Device,
    event: Event,
) -> Result;

pub type FnResetEvent = extern "system" fn(
    device: Device,
    event: Event,
) -> Result;

pub type FnCreateQueryPool = extern "system" fn(
    device: Device,
    pCreateInfo: *const QueryPoolCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pQueryPool: *mut QueryPool,
) -> Result;

pub type FnDestroyQueryPool = extern "system" fn(
    device: Device,
    queryPool: QueryPool,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetQueryPoolResults = extern "system" fn(
    device: Device,
    queryPool: QueryPool,
    firstQuery: u32,
    queryCount: u32,
    dataSize: usize,
    pData: *mut c_void,
    stride: DeviceSize,
    flags: QueryResultFlags,
) -> Result;

pub type FnCreateBuffer = extern "system" fn(
    device: Device,
    pCreateInfo: *const BufferCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pBuffer: *mut Buffer,
) -> Result;

pub type FnDestroyBuffer = extern "system" fn(
    device: Device,
    buffer: Buffer,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateBufferView = extern "system" fn(
    device: Device,
    pCreateInfo: *const BufferViewCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pView: *mut BufferView,
) -> Result;

pub type FnDestroyBufferView = extern "system" fn(
    device: Device,
    bufferView: BufferView,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateImage = extern "system" fn(
    device: Device,
    pCreateInfo: *const ImageCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pImage: *mut Image,
) -> Result;

pub type FnDestroyImage = extern "system" fn(
    device: Device,
    image: Image,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetImageSubresourceLayout = extern "system" fn(
    device: Device,
    image: Image,
    pSubresource: *const ImageSubresource,
    pLayout: *mut SubresourceLayout,
) -> ();

pub type FnCreateImageView = extern "system" fn(
    device: Device,
    pCreateInfo: *const ImageViewCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pView: *mut ImageView,
) -> Result;

pub type FnDestroyImageView = extern "system" fn(
    device: Device,
    imageView: ImageView,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateShaderModule = extern "system" fn(
    device: Device,
    pCreateInfo: *const ShaderModuleCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pShaderModule: *mut ShaderModule,
) -> Result;

pub type FnDestroyShaderModule = extern "system" fn(
    device: Device,
    shaderModule: ShaderModule,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreatePipelineCache = extern "system" fn(
    device: Device,
    pCreateInfo: *const PipelineCacheCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pPipelineCache: *mut PipelineCache,
) -> Result;

pub type FnDestroyPipelineCache = extern "system" fn(
    device: Device,
    pipelineCache: PipelineCache,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetPipelineCacheData = extern "system" fn(
    device: Device,
    pipelineCache: PipelineCache,
    pDataSize: *mut usize,
    pData: *mut c_void,
) -> Result;

pub type FnMergePipelineCaches = extern "system" fn(
    device: Device,
    dstCache: PipelineCache,
    srcCacheCount: u32,
    pSrcCaches: *const PipelineCache,
) -> Result;

pub type FnCreateGraphicsPipelines = extern "system" fn(
    device: Device,
    pipelineCache: PipelineCache,
    createInfoCount: u32,
    pCreateInfos: *const GraphicsPipelineCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pPipelines: *mut Pipeline,
) -> Result;

pub type FnCreateComputePipelines = extern "system" fn(
    device: Device,
    pipelineCache: PipelineCache,
    createInfoCount: u32,
    pCreateInfos: *const ComputePipelineCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pPipelines: *mut Pipeline,
) -> Result;

pub type FnDestroyPipeline = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreatePipelineLayout = extern "system" fn(
    device: Device,
    pCreateInfo: *const PipelineLayoutCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pPipelineLayout: *mut PipelineLayout,
) -> Result;

pub type FnDestroyPipelineLayout = extern "system" fn(
    device: Device,
    pipelineLayout: PipelineLayout,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateSampler = extern "system" fn(
    device: Device,
    pCreateInfo: *const SamplerCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pSampler: *mut Sampler,
) -> Result;

pub type FnDestroySampler = extern "system" fn(
    device: Device,
    sampler: Sampler,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateDescriptorSetLayout = extern "system" fn(
    device: Device,
    pCreateInfo: *const DescriptorSetLayoutCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pSetLayout: *mut DescriptorSetLayout,
) -> Result;

pub type FnDestroyDescriptorSetLayout = extern "system" fn(
    device: Device,
    descriptorSetLayout: DescriptorSetLayout,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateDescriptorPool = extern "system" fn(
    device: Device,
    pCreateInfo: *const DescriptorPoolCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pDescriptorPool: *mut DescriptorPool,
) -> Result;

pub type FnDestroyDescriptorPool = extern "system" fn(
    device: Device,
    descriptorPool: DescriptorPool,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnResetDescriptorPool = extern "system" fn(
    device: Device,
    descriptorPool: DescriptorPool,
    flags: DescriptorPoolResetFlags,
) -> Result;

pub type FnAllocateDescriptorSets = extern "system" fn(
    device: Device,
    pAllocateInfo: *const DescriptorSetAllocateInfo,
    pDescriptorSets: *mut DescriptorSet,
) -> Result;

pub type FnFreeDescriptorSets = extern "system" fn(
    device: Device,
    descriptorPool: DescriptorPool,
    descriptorSetCount: u32,
    pDescriptorSets: *const DescriptorSet,
) -> Result;

pub type FnUpdateDescriptorSets = extern "system" fn(
    device: Device,
    descriptorWriteCount: u32,
    pDescriptorWrites: *const WriteDescriptorSet,
    descriptorCopyCount: u32,
    pDescriptorCopies: *const CopyDescriptorSet,
) -> ();

pub type FnCreateFramebuffer = extern "system" fn(
    device: Device,
    pCreateInfo: *const FramebufferCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pFramebuffer: *mut Framebuffer,
) -> Result;

pub type FnDestroyFramebuffer = extern "system" fn(
    device: Device,
    framebuffer: Framebuffer,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateRenderPass = extern "system" fn(
    device: Device,
    pCreateInfo: *const RenderPassCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pRenderPass: *mut RenderPass,
) -> Result;

pub type FnDestroyRenderPass = extern "system" fn(
    device: Device,
    renderPass: RenderPass,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetRenderAreaGranularity = extern "system" fn(
    device: Device,
    renderPass: RenderPass,
    pGranularity: *mut Extent2D,
) -> ();

pub type FnCreateCommandPool = extern "system" fn(
    device: Device,
    pCreateInfo: *const CommandPoolCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pCommandPool: *mut CommandPool,
) -> Result;

pub type FnDestroyCommandPool = extern "system" fn(
    device: Device,
    commandPool: CommandPool,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnResetCommandPool = extern "system" fn(
    device: Device,
    commandPool: CommandPool,
    flags: CommandPoolResetFlags,
) -> Result;

pub type FnAllocateCommandBuffers = extern "system" fn(
    device: Device,
    pAllocateInfo: *const CommandBufferAllocateInfo,
    pCommandBuffers: *mut CommandBuffer,
) -> Result;

pub type FnFreeCommandBuffers = extern "system" fn(
    device: Device,
    commandPool: CommandPool,
    commandBufferCount: u32,
    pCommandBuffers: *const CommandBuffer,
) -> ();

pub type FnBeginCommandBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    pBeginInfo: *const CommandBufferBeginInfo,
) -> Result;

pub type FnEndCommandBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> Result;

pub type FnResetCommandBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    flags: CommandBufferResetFlags,
) -> Result;

pub type FnCmdBindPipeline = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineBindPoint: PipelineBindPoint,
    pipeline: Pipeline,
) -> ();

pub type FnCmdSetViewport = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstViewport: u32,
    viewportCount: u32,
    pViewports: *const Viewport,
) -> ();

pub type FnCmdSetScissor = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstScissor: u32,
    scissorCount: u32,
    pScissors: *const Rect2D,
) -> ();

pub type FnCmdSetLineWidth = extern "system" fn(
    commandBuffer: CommandBuffer,
    lineWidth: f32,
) -> ();

pub type FnCmdSetDepthBias = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthBiasConstantFactor: f32,
    depthBiasClamp: f32,
    depthBiasSlopeFactor: f32,
) -> ();

pub type FnCmdSetBlendConstants = extern "system" fn(
    commandBuffer: CommandBuffer,
    blendConstants: [f32; 4],
) -> ();

pub type FnCmdSetDepthBounds = extern "system" fn(
    commandBuffer: CommandBuffer,
    minDepthBounds: f32,
    maxDepthBounds: f32,
) -> ();

pub type FnCmdSetStencilCompareMask = extern "system" fn(
    commandBuffer: CommandBuffer,
    faceMask: StencilFaceFlags,
    compareMask: u32,
) -> ();

pub type FnCmdSetStencilWriteMask = extern "system" fn(
    commandBuffer: CommandBuffer,
    faceMask: StencilFaceFlags,
    writeMask: u32,
) -> ();

pub type FnCmdSetStencilReference = extern "system" fn(
    commandBuffer: CommandBuffer,
    faceMask: StencilFaceFlags,
    reference: u32,
) -> ();

pub type FnCmdBindDescriptorSets = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineBindPoint: PipelineBindPoint,
    layout: PipelineLayout,
    firstSet: u32,
    descriptorSetCount: u32,
    pDescriptorSets: *const DescriptorSet,
    dynamicOffsetCount: u32,
    pDynamicOffsets: *const u32,
) -> ();

pub type FnCmdBindIndexBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    indexType: IndexType,
) -> ();

pub type FnCmdBindVertexBuffers = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstBinding: u32,
    bindingCount: u32,
    pBuffers: *const Buffer,
    pOffsets: *const DeviceSize,
) -> ();

pub type FnCmdDraw = extern "system" fn(
    commandBuffer: CommandBuffer,
    vertexCount: u32,
    instanceCount: u32,
    firstVertex: u32,
    firstInstance: u32,
) -> ();

pub type FnCmdDrawIndexed = extern "system" fn(
    commandBuffer: CommandBuffer,
    indexCount: u32,
    instanceCount: u32,
    firstIndex: u32,
    vertexOffset: i32,
    firstInstance: u32,
) -> ();

pub type FnCmdDrawIndirect = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    drawCount: u32,
    stride: u32,
) -> ();

pub type FnCmdDrawIndexedIndirect = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    drawCount: u32,
    stride: u32,
) -> ();

pub type FnCmdDispatch = extern "system" fn(
    commandBuffer: CommandBuffer,
    groupCountX: u32,
    groupCountY: u32,
    groupCountZ: u32,
) -> ();

pub type FnCmdDispatchIndirect = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
) -> ();

pub type FnCmdCopyBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcBuffer: Buffer,
    dstBuffer: Buffer,
    regionCount: u32,
    pRegions: *const BufferCopy,
) -> ();

pub type FnCmdCopyImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcImage: Image,
    srcImageLayout: ImageLayout,
    dstImage: Image,
    dstImageLayout: ImageLayout,
    regionCount: u32,
    pRegions: *const ImageCopy,
) -> ();

pub type FnCmdBlitImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcImage: Image,
    srcImageLayout: ImageLayout,
    dstImage: Image,
    dstImageLayout: ImageLayout,
    regionCount: u32,
    pRegions: *const ImageBlit,
    filter: Filter,
) -> ();

pub type FnCmdCopyBufferToImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcBuffer: Buffer,
    dstImage: Image,
    dstImageLayout: ImageLayout,
    regionCount: u32,
    pRegions: *const BufferImageCopy,
) -> ();

pub type FnCmdCopyImageToBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcImage: Image,
    srcImageLayout: ImageLayout,
    dstBuffer: Buffer,
    regionCount: u32,
    pRegions: *const BufferImageCopy,
) -> ();

pub type FnCmdUpdateBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    dstBuffer: Buffer,
    dstOffset: DeviceSize,
    dataSize: DeviceSize,
    pData: *const c_void,
) -> ();

pub type FnCmdFillBuffer = extern "system" fn(
    commandBuffer: CommandBuffer,
    dstBuffer: Buffer,
    dstOffset: DeviceSize,
    size: DeviceSize,
    data: u32,
) -> ();

pub type FnCmdClearColorImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    image: Image,
    imageLayout: ImageLayout,
    pColor: *const ClearColorValue,
    rangeCount: u32,
    pRanges: *const ImageSubresourceRange,
) -> ();

pub type FnCmdClearDepthStencilImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    image: Image,
    imageLayout: ImageLayout,
    pDepthStencil: *const ClearDepthStencilValue,
    rangeCount: u32,
    pRanges: *const ImageSubresourceRange,
) -> ();

pub type FnCmdClearAttachments = extern "system" fn(
    commandBuffer: CommandBuffer,
    attachmentCount: u32,
    pAttachments: *const ClearAttachment,
    rectCount: u32,
    pRects: *const ClearRect,
) -> ();

pub type FnCmdResolveImage = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcImage: Image,
    srcImageLayout: ImageLayout,
    dstImage: Image,
    dstImageLayout: ImageLayout,
    regionCount: u32,
    pRegions: *const ImageResolve,
) -> ();

pub type FnCmdSetEvent = extern "system" fn(
    commandBuffer: CommandBuffer,
    event: Event,
    stageMask: PipelineStageFlags,
) -> ();

pub type FnCmdResetEvent = extern "system" fn(
    commandBuffer: CommandBuffer,
    event: Event,
    stageMask: PipelineStageFlags,
) -> ();

pub type FnCmdWaitEvents = extern "system" fn(
    commandBuffer: CommandBuffer,
    eventCount: u32,
    pEvents: *const Event,
    srcStageMask: PipelineStageFlags,
    dstStageMask: PipelineStageFlags,
    memoryBarrierCount: u32,
    pMemoryBarriers: *const MemoryBarrier,
    bufferMemoryBarrierCount: u32,
    pBufferMemoryBarriers: *const BufferMemoryBarrier,
    imageMemoryBarrierCount: u32,
    pImageMemoryBarriers: *const ImageMemoryBarrier,
) -> ();

pub type FnCmdPipelineBarrier = extern "system" fn(
    commandBuffer: CommandBuffer,
    srcStageMask: PipelineStageFlags,
    dstStageMask: PipelineStageFlags,
    dependencyFlags: DependencyFlags,
    memoryBarrierCount: u32,
    pMemoryBarriers: *const MemoryBarrier,
    bufferMemoryBarrierCount: u32,
    pBufferMemoryBarriers: *const BufferMemoryBarrier,
    imageMemoryBarrierCount: u32,
    pImageMemoryBarriers: *const ImageMemoryBarrier,
) -> ();

pub type FnCmdBeginQuery = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    query: u32,
    flags: QueryControlFlags,
) -> ();

pub type FnCmdEndQuery = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    query: u32,
) -> ();

pub type FnCmdResetQueryPool = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    firstQuery: u32,
    queryCount: u32,
) -> ();

pub type FnCmdWriteTimestamp = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineStage: PipelineStageFlagBits,
    queryPool: QueryPool,
    query: u32,
) -> ();

pub type FnCmdCopyQueryPoolResults = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    firstQuery: u32,
    queryCount: u32,
    dstBuffer: Buffer,
    dstOffset: DeviceSize,
    stride: DeviceSize,
    flags: QueryResultFlags,
) -> ();

pub type FnCmdPushConstants = extern "system" fn(
    commandBuffer: CommandBuffer,
    layout: PipelineLayout,
    stageFlags: ShaderStageFlags,
    offset: u32,
    size: u32,
    pValues: *const c_void,
) -> ();

pub type FnCmdBeginRenderPass = extern "system" fn(
    commandBuffer: CommandBuffer,
    pRenderPassBegin: *const RenderPassBeginInfo,
    contents: SubpassContents,
) -> ();

pub type FnCmdNextSubpass = extern "system" fn(
    commandBuffer: CommandBuffer,
    contents: SubpassContents,
) -> ();

pub type FnCmdEndRenderPass = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCmdExecuteCommands = extern "system" fn(
    commandBuffer: CommandBuffer,
    commandBufferCount: u32,
    pCommandBuffers: *const CommandBuffer,
) -> ();

pub type FnBindBufferMemory2 = extern "system" fn(
    device: Device,
    bindInfoCount: u32,
    pBindInfos: *const BindBufferMemoryInfo,
) -> Result;

pub type FnBindImageMemory2 = extern "system" fn(
    device: Device,
    bindInfoCount: u32,
    pBindInfos: *const BindImageMemoryInfo,
) -> Result;

pub type FnGetDeviceGroupPeerMemoryFeatures = extern "system" fn(
    device: Device,
    heapIndex: u32,
    localDeviceIndex: u32,
    remoteDeviceIndex: u32,
    pPeerMemoryFeatures: *mut PeerMemoryFeatureFlags,
) -> ();

pub type FnCmdSetDeviceMask = extern "system" fn(
    commandBuffer: CommandBuffer,
    deviceMask: u32,
) -> ();

pub type FnCmdDispatchBase = extern "system" fn(
    commandBuffer: CommandBuffer,
    baseGroupX: u32,
    baseGroupY: u32,
    baseGroupZ: u32,
    groupCountX: u32,
    groupCountY: u32,
    groupCountZ: u32,
) -> ();

pub type FnGetImageMemoryRequirements2 = extern "system" fn(
    device: Device,
    pInfo: *const ImageMemoryRequirementsInfo2,
    pMemoryRequirements: *mut MemoryRequirements2,
) -> ();

pub type FnGetBufferMemoryRequirements2 = extern "system" fn(
    device: Device,
    pInfo: *const BufferMemoryRequirementsInfo2,
    pMemoryRequirements: *mut MemoryRequirements2,
) -> ();

pub type FnGetImageSparseMemoryRequirements2 = extern "system" fn(
    device: Device,
    pInfo: *const ImageSparseMemoryRequirementsInfo2,
    pSparseMemoryRequirementCount: *mut u32,
    pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
) -> ();

pub type FnTrimCommandPool = extern "system" fn(
    device: Device,
    commandPool: CommandPool,
    flags: CommandPoolTrimFlags,
) -> ();

pub type FnGetDeviceQueue2 = extern "system" fn(
    device: Device,
    pQueueInfo: *const DeviceQueueInfo2,
    pQueue: *mut Queue,
) -> ();

pub type FnCreateSamplerYcbcrConversion = extern "system" fn(
    device: Device,
    pCreateInfo: *const SamplerYcbcrConversionCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pYcbcrConversion: *mut SamplerYcbcrConversion,
) -> Result;

pub type FnDestroySamplerYcbcrConversion = extern "system" fn(
    device: Device,
    ycbcrConversion: SamplerYcbcrConversion,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreateDescriptorUpdateTemplate = extern "system" fn(
    device: Device,
    pCreateInfo: *const DescriptorUpdateTemplateCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pDescriptorUpdateTemplate: *mut DescriptorUpdateTemplate,
) -> Result;

pub type FnDestroyDescriptorUpdateTemplate = extern "system" fn(
    device: Device,
    descriptorUpdateTemplate: DescriptorUpdateTemplate,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnUpdateDescriptorSetWithTemplate = extern "system" fn(
    device: Device,
    descriptorSet: DescriptorSet,
    descriptorUpdateTemplate: DescriptorUpdateTemplate,
    pData: *const c_void,
) -> ();

pub type FnGetDescriptorSetLayoutSupport = extern "system" fn(
    device: Device,
    pCreateInfo: *const DescriptorSetLayoutCreateInfo,
    pSupport: *mut DescriptorSetLayoutSupport,
) -> ();

pub type FnCmdDrawIndirectCount = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    countBuffer: Buffer,
    countBufferOffset: DeviceSize,
    maxDrawCount: u32,
    stride: u32,
) -> ();

pub type FnCmdDrawIndexedIndirectCount = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    countBuffer: Buffer,
    countBufferOffset: DeviceSize,
    maxDrawCount: u32,
    stride: u32,
) -> ();

pub type FnCreateRenderPass2 = extern "system" fn(
    device: Device,
    pCreateInfo: *const RenderPassCreateInfo2,
    pAllocator: *const AllocationCallbacks,
    pRenderPass: *mut RenderPass,
) -> Result;

pub type FnCmdBeginRenderPass2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pRenderPassBegin: *const RenderPassBeginInfo,
    pSubpassBeginInfo: *const SubpassBeginInfo,
) -> ();

pub type FnCmdNextSubpass2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pSubpassBeginInfo: *const SubpassBeginInfo,
    pSubpassEndInfo: *const SubpassEndInfo,
) -> ();

pub type FnCmdEndRenderPass2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pSubpassEndInfo: *const SubpassEndInfo,
) -> ();

pub type FnResetQueryPool = extern "system" fn(
    device: Device,
    queryPool: QueryPool,
    firstQuery: u32,
    queryCount: u32,
) -> ();

pub type FnGetSemaphoreCounterValue = extern "system" fn(
    device: Device,
    semaphore: Semaphore,
    pValue: *mut u64,
) -> Result;

pub type FnWaitSemaphores = extern "system" fn(
    device: Device,
    pWaitInfo: *const SemaphoreWaitInfo,
    timeout: u64,
) -> Result;

pub type FnSignalSemaphore = extern "system" fn(
    device: Device,
    pSignalInfo: *const SemaphoreSignalInfo,
) -> Result;

pub type FnGetBufferDeviceAddress = extern "system" fn(
    device: Device,
    pInfo: *const BufferDeviceAddressInfo,
) -> DeviceAddress;

pub type FnGetBufferOpaqueCaptureAddress = extern "system" fn(
    device: Device,
    pInfo: *const BufferDeviceAddressInfo,
) -> u64;

pub type FnGetDeviceMemoryOpaqueCaptureAddress = extern "system" fn(
    device: Device,
    pInfo: *const DeviceMemoryOpaqueCaptureAddressInfo,
) -> u64;

pub type FnCreatePrivateDataSlot = extern "system" fn(
    device: Device,
    pCreateInfo: *const PrivateDataSlotCreateInfo,
    pAllocator: *const AllocationCallbacks,
    pPrivateDataSlot: *mut PrivateDataSlot,
) -> Result;

pub type FnDestroyPrivateDataSlot = extern "system" fn(
    device: Device,
    privateDataSlot: PrivateDataSlot,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnSetPrivateData = extern "system" fn(
    device: Device,
    objectType: ObjectType,
    objectHandle: u64,
    privateDataSlot: PrivateDataSlot,
    data: u64,
) -> Result;

pub type FnGetPrivateData = extern "system" fn(
    device: Device,
    objectType: ObjectType,
    objectHandle: u64,
    privateDataSlot: PrivateDataSlot,
    pData: *mut u64,
) -> ();

pub type FnCmdSetEvent2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    event: Event,
    pDependencyInfo: *const DependencyInfo,
) -> ();

pub type FnCmdResetEvent2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    event: Event,
    stageMask: PipelineStageFlags2,
) -> ();

pub type FnCmdWaitEvents2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    eventCount: u32,
    pEvents: *const Event,
    pDependencyInfos: *const DependencyInfo,
) -> ();

pub type FnCmdPipelineBarrier2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pDependencyInfo: *const DependencyInfo,
) -> ();

pub type FnCmdWriteTimestamp2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    stage: PipelineStageFlags2,
    queryPool: QueryPool,
    query: u32,
) -> ();

pub type FnQueueSubmit2 = extern "system" fn(
    queue: Queue,
    submitCount: u32,
    pSubmits: *const SubmitInfo2,
    fence: Fence,
) -> Result;

pub type FnCmdCopyBuffer2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCopyBufferInfo: *const CopyBufferInfo2,
) -> ();

pub type FnCmdCopyImage2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCopyImageInfo: *const CopyImageInfo2,
) -> ();

pub type FnCmdCopyBufferToImage2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCopyBufferToImageInfo: *const CopyBufferToImageInfo2,
) -> ();

pub type FnCmdCopyImageToBuffer2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCopyImageToBufferInfo: *const CopyImageToBufferInfo2,
) -> ();

pub type FnCmdBlitImage2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pBlitImageInfo: *const BlitImageInfo2,
) -> ();

pub type FnCmdResolveImage2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    pResolveImageInfo: *const ResolveImageInfo2,
) -> ();

pub type FnCmdBeginRendering = extern "system" fn(
    commandBuffer: CommandBuffer,
    pRenderingInfo: *const RenderingInfo,
) -> ();

pub type FnCmdEndRendering = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCmdSetCullMode = extern "system" fn(
    commandBuffer: CommandBuffer,
    cullMode: CullModeFlags,
) -> ();

pub type FnCmdSetFrontFace = extern "system" fn(
    commandBuffer: CommandBuffer,
    frontFace: FrontFace,
) -> ();

pub type FnCmdSetPrimitiveTopology = extern "system" fn(
    commandBuffer: CommandBuffer,
    primitiveTopology: PrimitiveTopology,
) -> ();

pub type FnCmdSetViewportWithCount = extern "system" fn(
    commandBuffer: CommandBuffer,
    viewportCount: u32,
    pViewports: *const Viewport,
) -> ();

pub type FnCmdSetScissorWithCount = extern "system" fn(
    commandBuffer: CommandBuffer,
    scissorCount: u32,
    pScissors: *const Rect2D,
) -> ();

pub type FnCmdBindVertexBuffers2 = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstBinding: u32,
    bindingCount: u32,
    pBuffers: *const Buffer,
    pOffsets: *const DeviceSize,
    pSizes: *const DeviceSize,
    pStrides: *const DeviceSize,
) -> ();

pub type FnCmdSetDepthTestEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthTestEnable: Bool32,
) -> ();

pub type FnCmdSetDepthWriteEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthWriteEnable: Bool32,
) -> ();

pub type FnCmdSetDepthCompareOp = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthCompareOp: CompareOp,
) -> ();

pub type FnCmdSetDepthBoundsTestEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthBoundsTestEnable: Bool32,
) -> ();

pub type FnCmdSetStencilTestEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    stencilTestEnable: Bool32,
) -> ();

pub type FnCmdSetStencilOp = extern "system" fn(
    commandBuffer: CommandBuffer,
    faceMask: StencilFaceFlags,
    failOp: StencilOp,
    passOp: StencilOp,
    depthFailOp: StencilOp,
    compareOp: CompareOp,
) -> ();

pub type FnCmdSetRasterizerDiscardEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    rasterizerDiscardEnable: Bool32,
) -> ();

pub type FnCmdSetDepthBiasEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    depthBiasEnable: Bool32,
) -> ();

pub type FnCmdSetPrimitiveRestartEnable = extern "system" fn(
    commandBuffer: CommandBuffer,
    primitiveRestartEnable: Bool32,
) -> ();

pub type FnGetDeviceBufferMemoryRequirements = extern "system" fn(
    device: Device,
    pInfo: *const DeviceBufferMemoryRequirements,
    pMemoryRequirements: *mut MemoryRequirements2,
) -> ();

pub type FnGetDeviceImageMemoryRequirements = extern "system" fn(
    device: Device,
    pInfo: *const DeviceImageMemoryRequirements,
    pMemoryRequirements: *mut MemoryRequirements2,
) -> ();

pub type FnGetDeviceImageSparseMemoryRequirements = extern "system" fn(
    device: Device,
    pInfo: *const DeviceImageMemoryRequirements,
    pSparseMemoryRequirementCount: *mut u32,
    pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
) -> ();

pub type FnCreateSwapchainKHR = extern "system" fn(
    device: Device,
    pCreateInfo: *const SwapchainCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pSwapchain: *mut SwapchainKHR,
) -> Result;

pub type FnDestroySwapchainKHR = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetSwapchainImagesKHR = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    pSwapchainImageCount: *mut u32,
    pSwapchainImages: *mut Image,
) -> Result;

pub type FnAcquireNextImageKHR = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    timeout: u64,
    semaphore: Semaphore,
    fence: Fence,
    pImageIndex: *mut u32,
) -> Result;

pub type FnQueuePresentKHR = extern "system" fn(
    queue: Queue,
    pPresentInfo: *const PresentInfoKHR,
) -> Result;

pub type FnGetDeviceGroupPresentCapabilitiesKHR = extern "system" fn(
    device: Device,
    pDeviceGroupPresentCapabilities: *mut DeviceGroupPresentCapabilitiesKHR,
) -> Result;

pub type FnGetDeviceGroupSurfacePresentModesKHR = extern "system" fn(
    device: Device,
    surface: SurfaceKHR,
    pModes: *mut DeviceGroupPresentModeFlagsKHR,
) -> Result;

pub type FnAcquireNextImage2KHR = extern "system" fn(
    device: Device,
    pAcquireInfo: *const AcquireNextImageInfoKHR,
    pImageIndex: *mut u32,
) -> Result;

pub type FnCreateSharedSwapchainsKHR = extern "system" fn(
    device: Device,
    swapchainCount: u32,
    pCreateInfos: *const SwapchainCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pSwapchains: *mut SwapchainKHR,
) -> Result;

pub type FnDebugMarkerSetObjectTagEXT = extern "system" fn(
    device: Device,
    pTagInfo: *const DebugMarkerObjectTagInfoEXT,
) -> Result;

pub type FnDebugMarkerSetObjectNameEXT = extern "system" fn(
    device: Device,
    pNameInfo: *const DebugMarkerObjectNameInfoEXT,
) -> Result;

pub type FnCmdDebugMarkerBeginEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pMarkerInfo: *const DebugMarkerMarkerInfoEXT,
) -> ();

pub type FnCmdDebugMarkerEndEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCmdDebugMarkerInsertEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pMarkerInfo: *const DebugMarkerMarkerInfoEXT,
) -> ();

pub type FnCreateVideoSessionKHR = extern "system" fn(
    device: Device,
    pCreateInfo: *const VideoSessionCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pVideoSession: *mut VideoSessionKHR,
) -> Result;

pub type FnDestroyVideoSessionKHR = extern "system" fn(
    device: Device,
    videoSession: VideoSessionKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetVideoSessionMemoryRequirementsKHR = extern "system" fn(
    device: Device,
    videoSession: VideoSessionKHR,
    pVideoSessionMemoryRequirementsCount: *mut u32,
    pVideoSessionMemoryRequirements: *mut VideoGetMemoryPropertiesKHR,
) -> Result;

pub type FnBindVideoSessionMemoryKHR = extern "system" fn(
    device: Device,
    videoSession: VideoSessionKHR,
    videoSessionBindMemoryCount: u32,
    pVideoSessionBindMemories: *const VideoBindMemoryKHR,
) -> Result;

pub type FnCreateVideoSessionParametersKHR = extern "system" fn(
    device: Device,
    pCreateInfo: *const VideoSessionParametersCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pVideoSessionParameters: *mut VideoSessionParametersKHR,
) -> Result;

pub type FnUpdateVideoSessionParametersKHR = extern "system" fn(
    device: Device,
    videoSessionParameters: VideoSessionParametersKHR,
    pUpdateInfo: *const VideoSessionParametersUpdateInfoKHR,
) -> Result;

pub type FnDestroyVideoSessionParametersKHR = extern "system" fn(
    device: Device,
    videoSessionParameters: VideoSessionParametersKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCmdBeginVideoCodingKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pBeginInfo: *const VideoBeginCodingInfoKHR,
) -> ();

pub type FnCmdEndVideoCodingKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pEndCodingInfo: *const VideoEndCodingInfoKHR,
) -> ();

pub type FnCmdControlVideoCodingKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCodingControlInfo: *const VideoCodingControlInfoKHR,
) -> ();

pub type FnCmdDecodeVideoKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pFrameInfo: *const VideoDecodeInfoKHR,
) -> ();

pub type FnCmdBindTransformFeedbackBuffersEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstBinding: u32,
    bindingCount: u32,
    pBuffers: *const Buffer,
    pOffsets: *const DeviceSize,
    pSizes: *const DeviceSize,
) -> ();

pub type FnCmdBeginTransformFeedbackEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstCounterBuffer: u32,
    counterBufferCount: u32,
    pCounterBuffers: *const Buffer,
    pCounterBufferOffsets: *const DeviceSize,
) -> ();

pub type FnCmdEndTransformFeedbackEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstCounterBuffer: u32,
    counterBufferCount: u32,
    pCounterBuffers: *const Buffer,
    pCounterBufferOffsets: *const DeviceSize,
) -> ();

pub type FnCmdBeginQueryIndexedEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    query: u32,
    flags: QueryControlFlags,
    index: u32,
) -> ();

pub type FnCmdEndQueryIndexedEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    queryPool: QueryPool,
    query: u32,
    index: u32,
) -> ();

pub type FnCmdDrawIndirectByteCountEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    instanceCount: u32,
    firstInstance: u32,
    counterBuffer: Buffer,
    counterBufferOffset: DeviceSize,
    counterOffset: u32,
    vertexStride: u32,
) -> ();

pub type FnCreateCuModuleNVX = extern "system" fn(
    device: Device,
    pCreateInfo: *const CuModuleCreateInfoNVX,
    pAllocator: *const AllocationCallbacks,
    pModule: *mut CuModuleNVX,
) -> Result;

pub type FnCreateCuFunctionNVX = extern "system" fn(
    device: Device,
    pCreateInfo: *const CuFunctionCreateInfoNVX,
    pAllocator: *const AllocationCallbacks,
    pFunction: *mut CuFunctionNVX,
) -> Result;

pub type FnDestroyCuModuleNVX = extern "system" fn(
    device: Device,
    module: CuModuleNVX,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnDestroyCuFunctionNVX = extern "system" fn(
    device: Device,
    function: CuFunctionNVX,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCmdCuLaunchKernelNVX = extern "system" fn(
    commandBuffer: CommandBuffer,
    pLaunchInfo: *const CuLaunchInfoNVX,
) -> ();

pub type FnGetImageViewHandleNVX = extern "system" fn(
    device: Device,
    pInfo: *const ImageViewHandleInfoNVX,
) -> u32;

pub type FnGetImageViewAddressNVX = extern "system" fn(
    device: Device,
    imageView: ImageView,
    pProperties: *mut ImageViewAddressPropertiesNVX,
) -> Result;

pub type FnCmdDrawIndirectCountAMD = FnCmdDrawIndirectCount;

pub type FnCmdDrawIndexedIndirectCountAMD = FnCmdDrawIndexedIndirectCount;

pub type FnGetShaderInfoAMD = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    shaderStage: ShaderStageFlagBits,
    infoType: ShaderInfoTypeAMD,
    pInfoSize: *mut usize,
    pInfo: *mut c_void,
) -> Result;

pub type FnCmdBeginRenderingKHR = FnCmdBeginRendering;

pub type FnCmdEndRenderingKHR = FnCmdEndRendering;

pub type FnGetDeviceGroupPeerMemoryFeaturesKHR = FnGetDeviceGroupPeerMemoryFeatures;

pub type FnCmdSetDeviceMaskKHR = FnCmdSetDeviceMask;

pub type FnCmdDispatchBaseKHR = FnCmdDispatchBase;

pub type FnTrimCommandPoolKHR = FnTrimCommandPool;

pub type FnGetMemoryFdKHR = extern "system" fn(
    device: Device,
    pGetFdInfo: *const MemoryGetFdInfoKHR,
    pFd: *mut c_int,
) -> Result;

pub type FnGetMemoryFdPropertiesKHR = extern "system" fn(
    device: Device,
    handleType: ExternalMemoryHandleTypeFlagBits,
    fd: c_int,
    pMemoryFdProperties: *mut MemoryFdPropertiesKHR,
) -> Result;

pub type FnImportSemaphoreFdKHR = extern "system" fn(
    device: Device,
    pImportSemaphoreFdInfo: *const ImportSemaphoreFdInfoKHR,
) -> Result;

pub type FnGetSemaphoreFdKHR = extern "system" fn(
    device: Device,
    pGetFdInfo: *const SemaphoreGetFdInfoKHR,
    pFd: *mut c_int,
) -> Result;

pub type FnCmdPushDescriptorSetKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineBindPoint: PipelineBindPoint,
    layout: PipelineLayout,
    set: u32,
    descriptorWriteCount: u32,
    pDescriptorWrites: *const WriteDescriptorSet,
) -> ();

pub type FnCmdPushDescriptorSetWithTemplateKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    descriptorUpdateTemplate: DescriptorUpdateTemplate,
    layout: PipelineLayout,
    set: u32,
    pData: *const c_void,
) -> ();

pub type FnCmdBeginConditionalRenderingEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pConditionalRenderingBegin: *const ConditionalRenderingBeginInfoEXT,
) -> ();

pub type FnCmdEndConditionalRenderingEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCreateDescriptorUpdateTemplateKHR = FnCreateDescriptorUpdateTemplate;

pub type FnDestroyDescriptorUpdateTemplateKHR = FnDestroyDescriptorUpdateTemplate;

pub type FnUpdateDescriptorSetWithTemplateKHR = FnUpdateDescriptorSetWithTemplate;

pub type FnCmdSetViewportWScalingNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstViewport: u32,
    viewportCount: u32,
    pViewportWScalings: *const ViewportWScalingNV,
) -> ();

pub type FnDisplayPowerControlEXT = extern "system" fn(
    device: Device,
    display: DisplayKHR,
    pDisplayPowerInfo: *const DisplayPowerInfoEXT,
) -> Result;

pub type FnRegisterDeviceEventEXT = extern "system" fn(
    device: Device,
    pDeviceEventInfo: *const DeviceEventInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pFence: *mut Fence,
) -> Result;

pub type FnRegisterDisplayEventEXT = extern "system" fn(
    device: Device,
    display: DisplayKHR,
    pDisplayEventInfo: *const DisplayEventInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pFence: *mut Fence,
) -> Result;

pub type FnGetSwapchainCounterEXT = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    counter: SurfaceCounterFlagBitsEXT,
    pCounterValue: *mut u64,
) -> Result;

pub type FnGetRefreshCycleDurationGOOGLE = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    pDisplayTimingProperties: *mut RefreshCycleDurationGOOGLE,
) -> Result;

pub type FnGetPastPresentationTimingGOOGLE = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    pPresentationTimingCount: *mut u32,
    pPresentationTimings: *mut PastPresentationTimingGOOGLE,
) -> Result;

pub type FnCmdSetDiscardRectangleEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstDiscardRectangle: u32,
    discardRectangleCount: u32,
    pDiscardRectangles: *const Rect2D,
) -> ();

pub type FnSetHdrMetadataEXT = extern "system" fn(
    device: Device,
    swapchainCount: u32,
    pSwapchains: *const SwapchainKHR,
    pMetadata: *const HdrMetadataEXT,
) -> ();

pub type FnCreateRenderPass2KHR = FnCreateRenderPass2;

pub type FnCmdBeginRenderPass2KHR = FnCmdBeginRenderPass2;

pub type FnCmdNextSubpass2KHR = FnCmdNextSubpass2;

pub type FnCmdEndRenderPass2KHR = FnCmdEndRenderPass2;

pub type FnGetSwapchainStatusKHR = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
) -> Result;

pub type FnImportFenceFdKHR = extern "system" fn(
    device: Device,
    pImportFenceFdInfo: *const ImportFenceFdInfoKHR,
) -> Result;

pub type FnGetFenceFdKHR = extern "system" fn(
    device: Device,
    pGetFdInfo: *const FenceGetFdInfoKHR,
    pFd: *mut c_int,
) -> Result;

pub type FnAcquireProfilingLockKHR = extern "system" fn(
    device: Device,
    pInfo: *const AcquireProfilingLockInfoKHR,
) -> Result;

pub type FnReleaseProfilingLockKHR = extern "system" fn(
    device: Device,
) -> ();

pub type FnSetDebugUtilsObjectNameEXT = extern "system" fn(
    device: Device,
    pNameInfo: *const DebugUtilsObjectNameInfoEXT,
) -> Result;

pub type FnSetDebugUtilsObjectTagEXT = extern "system" fn(
    device: Device,
    pTagInfo: *const DebugUtilsObjectTagInfoEXT,
) -> Result;

pub type FnQueueBeginDebugUtilsLabelEXT = extern "system" fn(
    queue: Queue,
    pLabelInfo: *const DebugUtilsLabelEXT,
) -> ();

pub type FnQueueEndDebugUtilsLabelEXT = extern "system" fn(
    queue: Queue,
) -> ();

pub type FnQueueInsertDebugUtilsLabelEXT = extern "system" fn(
    queue: Queue,
    pLabelInfo: *const DebugUtilsLabelEXT,
) -> ();

pub type FnCmdBeginDebugUtilsLabelEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pLabelInfo: *const DebugUtilsLabelEXT,
) -> ();

pub type FnCmdEndDebugUtilsLabelEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCmdInsertDebugUtilsLabelEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pLabelInfo: *const DebugUtilsLabelEXT,
) -> ();

pub type FnCmdSetSampleLocationsEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    pSampleLocationsInfo: *const SampleLocationsInfoEXT,
) -> ();

pub type FnGetImageMemoryRequirements2KHR = FnGetImageMemoryRequirements2;

pub type FnGetBufferMemoryRequirements2KHR = FnGetBufferMemoryRequirements2;

pub type FnGetImageSparseMemoryRequirements2KHR = FnGetImageSparseMemoryRequirements2;

pub type FnCreateAccelerationStructureKHR = extern "system" fn(
    device: Device,
    pCreateInfo: *const AccelerationStructureCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pAccelerationStructure: *mut AccelerationStructureKHR,
) -> Result;

pub type FnDestroyAccelerationStructureKHR = extern "system" fn(
    device: Device,
    accelerationStructure: AccelerationStructureKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCmdBuildAccelerationStructuresKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    infoCount: u32,
    pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
    ppBuildRangeInfos: *const *const AccelerationStructureBuildRangeInfoKHR,
) -> ();

pub type FnCmdBuildAccelerationStructuresIndirectKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    infoCount: u32,
    pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
    pIndirectDeviceAddresses: *const DeviceAddress,
    pIndirectStrides: *const u32,
    ppMaxPrimitiveCounts: *const *const u32,
) -> ();

pub type FnBuildAccelerationStructuresKHR = extern "system" fn(
    device: Device,
    deferredOperation: DeferredOperationKHR,
    infoCount: u32,
    pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
    ppBuildRangeInfos: *const *const AccelerationStructureBuildRangeInfoKHR,
) -> Result;

pub type FnCopyAccelerationStructureKHR = extern "system" fn(
    device: Device,
    deferredOperation: DeferredOperationKHR,
    pInfo: *const CopyAccelerationStructureInfoKHR,
) -> Result;

pub type FnCopyAccelerationStructureToMemoryKHR = extern "system" fn(
    device: Device,
    deferredOperation: DeferredOperationKHR,
    pInfo: *const CopyAccelerationStructureToMemoryInfoKHR,
) -> Result;

pub type FnCopyMemoryToAccelerationStructureKHR = extern "system" fn(
    device: Device,
    deferredOperation: DeferredOperationKHR,
    pInfo: *const CopyMemoryToAccelerationStructureInfoKHR,
) -> Result;

pub type FnWriteAccelerationStructuresPropertiesKHR = extern "system" fn(
    device: Device,
    accelerationStructureCount: u32,
    pAccelerationStructures: *const AccelerationStructureKHR,
    queryType: QueryType,
    dataSize: usize,
    pData: *mut c_void,
    stride: usize,
) -> Result;

pub type FnCmdCopyAccelerationStructureKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pInfo: *const CopyAccelerationStructureInfoKHR,
) -> ();

pub type FnCmdCopyAccelerationStructureToMemoryKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pInfo: *const CopyAccelerationStructureToMemoryInfoKHR,
) -> ();

pub type FnCmdCopyMemoryToAccelerationStructureKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pInfo: *const CopyMemoryToAccelerationStructureInfoKHR,
) -> ();

pub type FnGetAccelerationStructureDeviceAddressKHR = extern "system" fn(
    device: Device,
    pInfo: *const AccelerationStructureDeviceAddressInfoKHR,
) -> DeviceAddress;

pub type FnCmdWriteAccelerationStructuresPropertiesKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    accelerationStructureCount: u32,
    pAccelerationStructures: *const AccelerationStructureKHR,
    queryType: QueryType,
    queryPool: QueryPool,
    firstQuery: u32,
) -> ();

pub type FnGetDeviceAccelerationStructureCompatibilityKHR = extern "system" fn(
    device: Device,
    pVersionInfo: *const AccelerationStructureVersionInfoKHR,
    pCompatibility: *mut AccelerationStructureCompatibilityKHR,
) -> ();

pub type FnGetAccelerationStructureBuildSizesKHR = extern "system" fn(
    device: Device,
    buildType: AccelerationStructureBuildTypeKHR,
    pBuildInfo: *const AccelerationStructureBuildGeometryInfoKHR,
    pMaxPrimitiveCounts: *const u32,
    pSizeInfo: *mut AccelerationStructureBuildSizesInfoKHR,
) -> ();

pub type FnCmdTraceRaysKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pRaygenShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pMissShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pHitShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pCallableShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    width: u32,
    height: u32,
    depth: u32,
) -> ();

pub type FnCreateRayTracingPipelinesKHR = extern "system" fn(
    device: Device,
    deferredOperation: DeferredOperationKHR,
    pipelineCache: PipelineCache,
    createInfoCount: u32,
    pCreateInfos: *const RayTracingPipelineCreateInfoKHR,
    pAllocator: *const AllocationCallbacks,
    pPipelines: *mut Pipeline,
) -> Result;

pub type FnGetRayTracingShaderGroupHandlesKHR = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    firstGroup: u32,
    groupCount: u32,
    dataSize: usize,
    pData: *mut c_void,
) -> Result;

pub type FnGetRayTracingCaptureReplayShaderGroupHandlesKHR = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    firstGroup: u32,
    groupCount: u32,
    dataSize: usize,
    pData: *mut c_void,
) -> Result;

pub type FnCmdTraceRaysIndirectKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pRaygenShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pMissShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pHitShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    pCallableShaderBindingTable: *const StridedDeviceAddressRegionKHR,
    indirectDeviceAddress: DeviceAddress,
) -> ();

pub type FnGetRayTracingShaderGroupStackSizeKHR = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    group: u32,
    groupShader: ShaderGroupShaderKHR,
) -> DeviceSize;

pub type FnCmdSetRayTracingPipelineStackSizeKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineStackSize: u32,
) -> ();

pub type FnCreateSamplerYcbcrConversionKHR = FnCreateSamplerYcbcrConversion;

pub type FnDestroySamplerYcbcrConversionKHR = FnDestroySamplerYcbcrConversion;

pub type FnBindBufferMemory2KHR = FnBindBufferMemory2;

pub type FnBindImageMemory2KHR = FnBindImageMemory2;

pub type FnGetImageDrmFormatModifierPropertiesEXT = extern "system" fn(
    device: Device,
    image: Image,
    pProperties: *mut ImageDrmFormatModifierPropertiesEXT,
) -> Result;

pub type FnCreateValidationCacheEXT = extern "system" fn(
    device: Device,
    pCreateInfo: *const ValidationCacheCreateInfoEXT,
    pAllocator: *const AllocationCallbacks,
    pValidationCache: *mut ValidationCacheEXT,
) -> Result;

pub type FnDestroyValidationCacheEXT = extern "system" fn(
    device: Device,
    validationCache: ValidationCacheEXT,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnMergeValidationCachesEXT = extern "system" fn(
    device: Device,
    dstCache: ValidationCacheEXT,
    srcCacheCount: u32,
    pSrcCaches: *const ValidationCacheEXT,
) -> Result;

pub type FnGetValidationCacheDataEXT = extern "system" fn(
    device: Device,
    validationCache: ValidationCacheEXT,
    pDataSize: *mut usize,
    pData: *mut c_void,
) -> Result;

pub type FnCmdBindShadingRateImageNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    imageView: ImageView,
    imageLayout: ImageLayout,
) -> ();

pub type FnCmdSetViewportShadingRatePaletteNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstViewport: u32,
    viewportCount: u32,
    pShadingRatePalettes: *const ShadingRatePaletteNV,
) -> ();

pub type FnCmdSetCoarseSampleOrderNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    sampleOrderType: CoarseSampleOrderTypeNV,
    customSampleOrderCount: u32,
    pCustomSampleOrders: *const CoarseSampleOrderCustomNV,
) -> ();

pub type FnCreateAccelerationStructureNV = extern "system" fn(
    device: Device,
    pCreateInfo: *const AccelerationStructureCreateInfoNV,
    pAllocator: *const AllocationCallbacks,
    pAccelerationStructure: *mut AccelerationStructureNV,
) -> Result;

pub type FnDestroyAccelerationStructureNV = extern "system" fn(
    device: Device,
    accelerationStructure: AccelerationStructureNV,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetAccelerationStructureMemoryRequirementsNV = extern "system" fn(
    device: Device,
    pInfo: *const AccelerationStructureMemoryRequirementsInfoNV,
    pMemoryRequirements: *mut MemoryRequirements2KHR,
) -> ();

pub type FnBindAccelerationStructureMemoryNV = extern "system" fn(
    device: Device,
    bindInfoCount: u32,
    pBindInfos: *const BindAccelerationStructureMemoryInfoNV,
) -> Result;

pub type FnCmdBuildAccelerationStructureNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    pInfo: *const AccelerationStructureInfoNV,
    instanceData: Buffer,
    instanceOffset: DeviceSize,
    update: Bool32,
    dst: AccelerationStructureNV,
    src: AccelerationStructureNV,
    scratch: Buffer,
    scratchOffset: DeviceSize,
) -> ();

pub type FnCmdCopyAccelerationStructureNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    dst: AccelerationStructureNV,
    src: AccelerationStructureNV,
    mode: CopyAccelerationStructureModeKHR,
) -> ();

pub type FnCmdTraceRaysNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    raygenShaderBindingTableBuffer: Buffer,
    raygenShaderBindingOffset: DeviceSize,
    missShaderBindingTableBuffer: Buffer,
    missShaderBindingOffset: DeviceSize,
    missShaderBindingStride: DeviceSize,
    hitShaderBindingTableBuffer: Buffer,
    hitShaderBindingOffset: DeviceSize,
    hitShaderBindingStride: DeviceSize,
    callableShaderBindingTableBuffer: Buffer,
    callableShaderBindingOffset: DeviceSize,
    callableShaderBindingStride: DeviceSize,
    width: u32,
    height: u32,
    depth: u32,
) -> ();

pub type FnCreateRayTracingPipelinesNV = extern "system" fn(
    device: Device,
    pipelineCache: PipelineCache,
    createInfoCount: u32,
    pCreateInfos: *const RayTracingPipelineCreateInfoNV,
    pAllocator: *const AllocationCallbacks,
    pPipelines: *mut Pipeline,
) -> Result;

pub type FnGetRayTracingShaderGroupHandlesNV = FnGetRayTracingShaderGroupHandlesKHR;

pub type FnGetAccelerationStructureHandleNV = extern "system" fn(
    device: Device,
    accelerationStructure: AccelerationStructureNV,
    dataSize: usize,
    pData: *mut c_void,
) -> Result;

pub type FnCmdWriteAccelerationStructuresPropertiesNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    accelerationStructureCount: u32,
    pAccelerationStructures: *const AccelerationStructureNV,
    queryType: QueryType,
    queryPool: QueryPool,
    firstQuery: u32,
) -> ();

pub type FnCompileDeferredNV = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    shader: u32,
) -> Result;

pub type FnGetDescriptorSetLayoutSupportKHR = FnGetDescriptorSetLayoutSupport;

pub type FnCmdDrawIndirectCountKHR = FnCmdDrawIndirectCount;

pub type FnCmdDrawIndexedIndirectCountKHR = FnCmdDrawIndexedIndirectCount;

pub type FnGetMemoryHostPointerPropertiesEXT = extern "system" fn(
    device: Device,
    handleType: ExternalMemoryHandleTypeFlagBits,
    pHostPointer: *const c_void,
    pMemoryHostPointerProperties: *mut MemoryHostPointerPropertiesEXT,
) -> Result;

pub type FnCmdWriteBufferMarkerAMD = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineStage: PipelineStageFlagBits,
    dstBuffer: Buffer,
    dstOffset: DeviceSize,
    marker: u32,
) -> ();

pub type FnGetCalibratedTimestampsEXT = extern "system" fn(
    device: Device,
    timestampCount: u32,
    pTimestampInfos: *const CalibratedTimestampInfoEXT,
    pTimestamps: *mut u64,
    pMaxDeviation: *mut u64,
) -> Result;

pub type FnCmdDrawMeshTasksNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    taskCount: u32,
    firstTask: u32,
) -> ();

pub type FnCmdDrawMeshTasksIndirectNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    drawCount: u32,
    stride: u32,
) -> ();

pub type FnCmdDrawMeshTasksIndirectCountNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    countBuffer: Buffer,
    countBufferOffset: DeviceSize,
    maxDrawCount: u32,
    stride: u32,
) -> ();

pub type FnCmdSetExclusiveScissorNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    firstExclusiveScissor: u32,
    exclusiveScissorCount: u32,
    pExclusiveScissors: *const Rect2D,
) -> ();

pub type FnCmdSetCheckpointNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    pCheckpointMarker: *const c_void,
) -> ();

pub type FnGetQueueCheckpointDataNV = extern "system" fn(
    queue: Queue,
    pCheckpointDataCount: *mut u32,
    pCheckpointData: *mut CheckpointDataNV,
) -> ();

pub type FnGetSemaphoreCounterValueKHR = FnGetSemaphoreCounterValue;

pub type FnWaitSemaphoresKHR = FnWaitSemaphores;

pub type FnSignalSemaphoreKHR = FnSignalSemaphore;

pub type FnInitializePerformanceApiINTEL = extern "system" fn(
    device: Device,
    pInitializeInfo: *const InitializePerformanceApiInfoINTEL,
) -> Result;

pub type FnUninitializePerformanceApiINTEL = extern "system" fn(
    device: Device,
) -> ();

pub type FnCmdSetPerformanceMarkerINTEL = extern "system" fn(
    commandBuffer: CommandBuffer,
    pMarkerInfo: *const PerformanceMarkerInfoINTEL,
) -> Result;

pub type FnCmdSetPerformanceStreamMarkerINTEL = extern "system" fn(
    commandBuffer: CommandBuffer,
    pMarkerInfo: *const PerformanceStreamMarkerInfoINTEL,
) -> Result;

pub type FnCmdSetPerformanceOverrideINTEL = extern "system" fn(
    commandBuffer: CommandBuffer,
    pOverrideInfo: *const PerformanceOverrideInfoINTEL,
) -> Result;

pub type FnAcquirePerformanceConfigurationINTEL = extern "system" fn(
    device: Device,
    pAcquireInfo: *const PerformanceConfigurationAcquireInfoINTEL,
    pConfiguration: *mut PerformanceConfigurationINTEL,
) -> Result;

pub type FnReleasePerformanceConfigurationINTEL = extern "system" fn(
    device: Device,
    configuration: PerformanceConfigurationINTEL,
) -> Result;

pub type FnQueueSetPerformanceConfigurationINTEL = extern "system" fn(
    queue: Queue,
    configuration: PerformanceConfigurationINTEL,
) -> Result;

pub type FnGetPerformanceParameterINTEL = extern "system" fn(
    device: Device,
    parameter: PerformanceParameterTypeINTEL,
    pValue: *mut PerformanceValueINTEL,
) -> Result;

pub type FnSetLocalDimmingAMD = extern "system" fn(
    device: Device,
    swapChain: SwapchainKHR,
    localDimmingEnable: Bool32,
) -> ();

pub type FnCmdSetFragmentShadingRateKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pFragmentSize: *const Extent2D,
    combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
) -> ();

pub type FnGetBufferDeviceAddressEXT = FnGetBufferDeviceAddress;

pub type FnWaitForPresentKHR = extern "system" fn(
    device: Device,
    swapchain: SwapchainKHR,
    presentId: u64,
    timeout: u64,
) -> Result;

pub type FnGetBufferDeviceAddressKHR = FnGetBufferDeviceAddress;

pub type FnGetBufferOpaqueCaptureAddressKHR = FnGetBufferOpaqueCaptureAddress;

pub type FnGetDeviceMemoryOpaqueCaptureAddressKHR = FnGetDeviceMemoryOpaqueCaptureAddress;

pub type FnCmdSetLineStippleEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    lineStippleFactor: u32,
    lineStipplePattern: u16,
) -> ();

pub type FnResetQueryPoolEXT = FnResetQueryPool;

pub type FnCmdSetCullModeEXT = FnCmdSetCullMode;

pub type FnCmdSetFrontFaceEXT = FnCmdSetFrontFace;

pub type FnCmdSetPrimitiveTopologyEXT = FnCmdSetPrimitiveTopology;

pub type FnCmdSetViewportWithCountEXT = FnCmdSetViewportWithCount;

pub type FnCmdSetScissorWithCountEXT = FnCmdSetScissorWithCount;

pub type FnCmdBindVertexBuffers2EXT = FnCmdBindVertexBuffers2;

pub type FnCmdSetDepthTestEnableEXT = FnCmdSetDepthTestEnable;

pub type FnCmdSetDepthWriteEnableEXT = FnCmdSetDepthWriteEnable;

pub type FnCmdSetDepthCompareOpEXT = FnCmdSetDepthCompareOp;

pub type FnCmdSetDepthBoundsTestEnableEXT = FnCmdSetDepthBoundsTestEnable;

pub type FnCmdSetStencilTestEnableEXT = FnCmdSetStencilTestEnable;

pub type FnCmdSetStencilOpEXT = FnCmdSetStencilOp;

pub type FnCreateDeferredOperationKHR = extern "system" fn(
    device: Device,
    pAllocator: *const AllocationCallbacks,
    pDeferredOperation: *mut DeferredOperationKHR,
) -> Result;

pub type FnDestroyDeferredOperationKHR = extern "system" fn(
    device: Device,
    operation: DeferredOperationKHR,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnGetDeferredOperationMaxConcurrencyKHR = extern "system" fn(
    device: Device,
    operation: DeferredOperationKHR,
) -> u32;

pub type FnGetDeferredOperationResultKHR = extern "system" fn(
    device: Device,
    operation: DeferredOperationKHR,
) -> Result;

pub type FnDeferredOperationJoinKHR = extern "system" fn(
    device: Device,
    operation: DeferredOperationKHR,
) -> Result;

pub type FnGetPipelineExecutablePropertiesKHR = extern "system" fn(
    device: Device,
    pPipelineInfo: *const PipelineInfoKHR,
    pExecutableCount: *mut u32,
    pProperties: *mut PipelineExecutablePropertiesKHR,
) -> Result;

pub type FnGetPipelineExecutableStatisticsKHR = extern "system" fn(
    device: Device,
    pExecutableInfo: *const PipelineExecutableInfoKHR,
    pStatisticCount: *mut u32,
    pStatistics: *mut PipelineExecutableStatisticKHR,
) -> Result;

pub type FnGetPipelineExecutableInternalRepresentationsKHR = extern "system" fn(
    device: Device,
    pExecutableInfo: *const PipelineExecutableInfoKHR,
    pInternalRepresentationCount: *mut u32,
    pInternalRepresentations: *mut PipelineExecutableInternalRepresentationKHR,
) -> Result;

pub type FnGetGeneratedCommandsMemoryRequirementsNV = extern "system" fn(
    device: Device,
    pInfo: *const GeneratedCommandsMemoryRequirementsInfoNV,
    pMemoryRequirements: *mut MemoryRequirements2,
) -> ();

pub type FnCmdPreprocessGeneratedCommandsNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    pGeneratedCommandsInfo: *const GeneratedCommandsInfoNV,
) -> ();

pub type FnCmdExecuteGeneratedCommandsNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    isPreprocessed: Bool32,
    pGeneratedCommandsInfo: *const GeneratedCommandsInfoNV,
) -> ();

pub type FnCmdBindPipelineShaderGroupNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    pipelineBindPoint: PipelineBindPoint,
    pipeline: Pipeline,
    groupIndex: u32,
) -> ();

pub type FnCreateIndirectCommandsLayoutNV = extern "system" fn(
    device: Device,
    pCreateInfo: *const IndirectCommandsLayoutCreateInfoNV,
    pAllocator: *const AllocationCallbacks,
    pIndirectCommandsLayout: *mut IndirectCommandsLayoutNV,
) -> Result;

pub type FnDestroyIndirectCommandsLayoutNV = extern "system" fn(
    device: Device,
    indirectCommandsLayout: IndirectCommandsLayoutNV,
    pAllocator: *const AllocationCallbacks,
) -> ();

pub type FnCreatePrivateDataSlotEXT = FnCreatePrivateDataSlot;

pub type FnDestroyPrivateDataSlotEXT = FnDestroyPrivateDataSlot;

pub type FnSetPrivateDataEXT = FnSetPrivateData;

pub type FnGetPrivateDataEXT = FnGetPrivateData;

pub type FnCmdEncodeVideoKHR = extern "system" fn(
    commandBuffer: CommandBuffer,
    pEncodeInfo: *const VideoEncodeInfoKHR,
) -> ();

pub type FnCmdSetEvent2KHR = FnCmdSetEvent2;

pub type FnCmdResetEvent2KHR = FnCmdResetEvent2;

pub type FnCmdWaitEvents2KHR = FnCmdWaitEvents2;

pub type FnCmdPipelineBarrier2KHR = FnCmdPipelineBarrier2;

pub type FnCmdWriteTimestamp2KHR = FnCmdWriteTimestamp2;

pub type FnQueueSubmit2KHR = FnQueueSubmit2;

pub type FnCmdWriteBufferMarker2AMD = extern "system" fn(
    commandBuffer: CommandBuffer,
    stage: PipelineStageFlags2,
    dstBuffer: Buffer,
    dstOffset: DeviceSize,
    marker: u32,
) -> ();

pub type FnGetQueueCheckpointData2NV = extern "system" fn(
    queue: Queue,
    pCheckpointDataCount: *mut u32,
    pCheckpointData: *mut CheckpointData2NV,
) -> ();

pub type FnCmdSetFragmentShadingRateEnumNV = extern "system" fn(
    commandBuffer: CommandBuffer,
    shadingRate: FragmentShadingRateNV,
    combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
) -> ();

pub type FnCmdCopyBuffer2KHR = FnCmdCopyBuffer2;

pub type FnCmdCopyImage2KHR = FnCmdCopyImage2;

pub type FnCmdCopyBufferToImage2KHR = FnCmdCopyBufferToImage2;

pub type FnCmdCopyImageToBuffer2KHR = FnCmdCopyImageToBuffer2;

pub type FnCmdBlitImage2KHR = FnCmdBlitImage2;

pub type FnCmdResolveImage2KHR = FnCmdResolveImage2;

pub type FnCmdSetVertexInputEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    vertexBindingDescriptionCount: u32,
    pVertexBindingDescriptions: *const VertexInputBindingDescription2EXT,
    vertexAttributeDescriptionCount: u32,
    pVertexAttributeDescriptions: *const VertexInputAttributeDescription2EXT,
) -> ();

pub type FnGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = extern "system" fn(
    device: Device,
    renderpass: RenderPass,
    pMaxWorkgroupSize: *mut Extent2D,
) -> Result;

pub type FnCmdSubpassShadingHUAWEI = extern "system" fn(
    commandBuffer: CommandBuffer,
) -> ();

pub type FnCmdBindInvocationMaskHUAWEI = extern "system" fn(
    commandBuffer: CommandBuffer,
    imageView: ImageView,
    imageLayout: ImageLayout,
) -> ();

pub type FnGetMemoryRemoteAddressNV = extern "system" fn(
    device: Device,
    pMemoryGetRemoteAddressInfo: *const MemoryGetRemoteAddressInfoNV,
    pAddress: *mut RemoteAddressNV,
) -> Result;

pub type FnCmdSetPatchControlPointsEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    patchControlPoints: u32,
) -> ();

pub type FnCmdSetRasterizerDiscardEnableEXT = FnCmdSetRasterizerDiscardEnable;

pub type FnCmdSetDepthBiasEnableEXT = FnCmdSetDepthBiasEnable;

pub type FnCmdSetLogicOpEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    logicOp: LogicOp,
) -> ();

pub type FnCmdSetPrimitiveRestartEnableEXT = FnCmdSetPrimitiveRestartEnable;

pub type FnCmdSetColorWriteEnableEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    attachmentCount: u32,
    pColorWriteEnables: *const Bool32,
) -> ();

pub type FnCmdDrawMultiEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    drawCount: u32,
    pVertexInfo: *const MultiDrawInfoEXT,
    instanceCount: u32,
    firstInstance: u32,
    stride: u32,
) -> ();

pub type FnCmdDrawMultiIndexedEXT = extern "system" fn(
    commandBuffer: CommandBuffer,
    drawCount: u32,
    pIndexInfo: *const MultiDrawIndexedInfoEXT,
    instanceCount: u32,
    firstInstance: u32,
    stride: u32,
    pVertexOffset: *const i32,
) -> ();

pub type FnSetDeviceMemoryPriorityEXT = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    priority: f32,
) -> ();

pub type FnGetDeviceBufferMemoryRequirementsKHR = FnGetDeviceBufferMemoryRequirements;

pub type FnGetDeviceImageMemoryRequirementsKHR = FnGetDeviceImageMemoryRequirements;

pub type FnGetDeviceImageSparseMemoryRequirementsKHR = FnGetDeviceImageSparseMemoryRequirements;

pub type FnGetDescriptorSetLayoutHostMappingInfoVALVE = extern "system" fn(
    device: Device,
    pBindingReference: *const DescriptorSetBindingReferenceVALVE,
    pHostMapping: *mut DescriptorSetLayoutHostMappingInfoVALVE,
) -> ();

pub type FnGetDescriptorSetHostMappingVALVE = extern "system" fn(
    device: Device,
    descriptorSet: DescriptorSet,
    ppData: *mut *mut c_void,
) -> ();

// command struct macros
macro_rules! ptrs {
    ($struct_name:ident,
        ($create_fn:ident: $create_fn_type:ty, $fn_param:ident: $fn_param_type:ty),
        { $($name:ident => ($($param_n:ident: $param_ty:ty),+ $(,)+) -> $ret:ty,)+ }) => (
        pub struct $struct_name {
            $(
                pub $name: extern "system" fn($($param_ty),*) -> $ret,
            )+
        }
        
        unsafe impl Send for $struct_name {}
        unsafe impl Sync for $struct_name {}

        impl $struct_name {
            pub fn new($create_fn: $create_fn_type, $fn_param: $fn_param_type) -> Self {
                $struct_name {
                    $(
                        $name: unsafe {
                            mem::transmute(
                                ($create_fn)($fn_param, concat!("vk", stringify!($name), "\0").as_ptr() as _)
                            )
                        },
                    )+
                }
            }

            $(
                #[inline]
                pub unsafe fn $name(&self $(, $param_n: $param_ty)*) -> $ret {
                    let ptr = self.$name;
                    ptr($($param_n),*)
                }
            )+
        }
    )
}

// library commands
ptrs!(LibraryCommands, (GetInstanceProcAddr: FnGetInstanceProcAddr, instance: Instance), {
    CreateInstance => (
        pCreateInfo: *const InstanceCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pInstance: *mut Instance,
    ) -> Result,
    EnumerateInstanceExtensionProperties => (
        pLayerName: *const c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut ExtensionProperties,
    ) -> Result,
    EnumerateInstanceLayerProperties => (
        pPropertyCount: *mut u32,
        pProperties: *mut LayerProperties,
    ) -> Result,
    EnumerateInstanceVersion => (
        pApiVersion: *mut u32,
    ) -> Result,
});

// instance commands
ptrs!(InstanceCommands, (GetInstanceProcAddr: FnGetInstanceProcAddr, instance: Instance), {
    DestroyInstance => (
        instance: Instance,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    EnumeratePhysicalDevices => (
        instance: Instance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut PhysicalDevice,
    ) -> Result,
    GetPhysicalDeviceFeatures => (
        physicalDevice: PhysicalDevice,
        pFeatures: *mut PhysicalDeviceFeatures,
    ) -> (),
    GetPhysicalDeviceFormatProperties => (
        physicalDevice: PhysicalDevice,
        format: Format,
        pFormatProperties: *mut FormatProperties,
    ) -> (),
    GetPhysicalDeviceImageFormatProperties => (
        physicalDevice: PhysicalDevice,
        format: Format,
        typ: ImageType,
        tiling: ImageTiling,
        usage: ImageUsageFlags,
        flags: ImageCreateFlags,
        pImageFormatProperties: *mut ImageFormatProperties,
    ) -> Result,
    GetPhysicalDeviceProperties => (
        physicalDevice: PhysicalDevice,
        pProperties: *mut PhysicalDeviceProperties,
    ) -> (),
    GetPhysicalDeviceQueueFamilyProperties => (
        physicalDevice: PhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut QueueFamilyProperties,
    ) -> (),
    GetPhysicalDeviceMemoryProperties => (
        physicalDevice: PhysicalDevice,
        pMemoryProperties: *mut PhysicalDeviceMemoryProperties,
    ) -> (),
    GetDeviceProcAddr => (
        device: Device,
        pName: *const c_char,
    ) -> FnVoidFunction,
    CreateDevice => (
        physicalDevice: PhysicalDevice,
        pCreateInfo: *const DeviceCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pDevice: *mut Device,
    ) -> Result,
    EnumerateDeviceExtensionProperties => (
        physicalDevice: PhysicalDevice,
        pLayerName: *const c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut ExtensionProperties,
    ) -> Result,
    EnumerateDeviceLayerProperties => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut LayerProperties,
    ) -> Result,
    GetPhysicalDeviceSparseImageFormatProperties => (
        physicalDevice: PhysicalDevice,
        format: Format,
        typ: ImageType,
        samples: SampleCountFlagBits,
        usage: ImageUsageFlags,
        tiling: ImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut SparseImageFormatProperties,
    ) -> (),
    EnumeratePhysicalDeviceGroups => (
        instance: Instance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut PhysicalDeviceGroupProperties,
    ) -> Result,
    GetPhysicalDeviceFeatures2 => (
        physicalDevice: PhysicalDevice,
        pFeatures: *mut PhysicalDeviceFeatures2,
    ) -> (),
    GetPhysicalDeviceProperties2 => (
        physicalDevice: PhysicalDevice,
        pProperties: *mut PhysicalDeviceProperties2,
    ) -> (),
    GetPhysicalDeviceFormatProperties2 => (
        physicalDevice: PhysicalDevice,
        format: Format,
        pFormatProperties: *mut FormatProperties2,
    ) -> (),
    GetPhysicalDeviceImageFormatProperties2 => (
        physicalDevice: PhysicalDevice,
        pImageFormatInfo: *const PhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut ImageFormatProperties2,
    ) -> Result,
    GetPhysicalDeviceQueueFamilyProperties2 => (
        physicalDevice: PhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut QueueFamilyProperties2,
    ) -> (),
    GetPhysicalDeviceMemoryProperties2 => (
        physicalDevice: PhysicalDevice,
        pMemoryProperties: *mut PhysicalDeviceMemoryProperties2,
    ) -> (),
    GetPhysicalDeviceSparseImageFormatProperties2 => (
        physicalDevice: PhysicalDevice,
        pFormatInfo: *const PhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut SparseImageFormatProperties2,
    ) -> (),
    GetPhysicalDeviceExternalBufferProperties => (
        physicalDevice: PhysicalDevice,
        pExternalBufferInfo: *const PhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut ExternalBufferProperties,
    ) -> (),
    GetPhysicalDeviceExternalFenceProperties => (
        physicalDevice: PhysicalDevice,
        pExternalFenceInfo: *const PhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut ExternalFenceProperties,
    ) -> (),
    GetPhysicalDeviceExternalSemaphoreProperties => (
        physicalDevice: PhysicalDevice,
        pExternalSemaphoreInfo: *const PhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut ExternalSemaphoreProperties,
    ) -> (),
    GetPhysicalDeviceToolProperties => (
        physicalDevice: PhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut PhysicalDeviceToolProperties,
    ) -> Result,
    DestroySurfaceKHR => (
        instance: Instance,
        surface: SurfaceKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetPhysicalDeviceSurfaceSupportKHR => (
        physicalDevice: PhysicalDevice,
        queueFamilyIndex: u32,
        surface: SurfaceKHR,
        pSupported: *mut Bool32,
    ) -> Result,
    GetPhysicalDeviceSurfaceCapabilitiesKHR => (
        physicalDevice: PhysicalDevice,
        surface: SurfaceKHR,
        pSurfaceCapabilities: *mut SurfaceCapabilitiesKHR,
    ) -> Result,
    GetPhysicalDeviceSurfaceFormatsKHR => (
        physicalDevice: PhysicalDevice,
        surface: SurfaceKHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut SurfaceFormatKHR,
    ) -> Result,
    GetPhysicalDeviceSurfacePresentModesKHR => (
        physicalDevice: PhysicalDevice,
        surface: SurfaceKHR,
        pPresentModeCount: *mut u32,
        pPresentModes: *mut PresentModeKHR,
    ) -> Result,
    GetPhysicalDevicePresentRectanglesKHR => (
        physicalDevice: PhysicalDevice,
        surface: SurfaceKHR,
        pRectCount: *mut u32,
        pRects: *mut Rect2D,
    ) -> Result,
    GetPhysicalDeviceDisplayPropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayPropertiesKHR,
    ) -> Result,
    GetPhysicalDeviceDisplayPlanePropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayPlanePropertiesKHR,
    ) -> Result,
    GetDisplayPlaneSupportedDisplaysKHR => (
        physicalDevice: PhysicalDevice,
        planeIndex: u32,
        pDisplayCount: *mut u32,
        pDisplays: *mut DisplayKHR,
    ) -> Result,
    GetDisplayModePropertiesKHR => (
        physicalDevice: PhysicalDevice,
        display: DisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayModePropertiesKHR,
    ) -> Result,
    CreateDisplayModeKHR => (
        physicalDevice: PhysicalDevice,
        display: DisplayKHR,
        pCreateInfo: *const DisplayModeCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pMode: *mut DisplayModeKHR,
    ) -> Result,
    GetDisplayPlaneCapabilitiesKHR => (
        physicalDevice: PhysicalDevice,
        mode: DisplayModeKHR,
        planeIndex: u32,
        pCapabilities: *mut DisplayPlaneCapabilitiesKHR,
    ) -> Result,
    CreateDisplayPlaneSurfaceKHR => (
        instance: Instance,
        pCreateInfo: *const DisplaySurfaceCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pSurface: *mut SurfaceKHR,
    ) -> Result,
    CreateDebugReportCallbackEXT => (
        instance: Instance,
        pCreateInfo: *const DebugReportCallbackCreateInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pCallback: *mut DebugReportCallbackEXT,
    ) -> Result,
    DestroyDebugReportCallbackEXT => (
        instance: Instance,
        callback: DebugReportCallbackEXT,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    DebugReportMessageEXT => (
        instance: Instance,
        flags: DebugReportFlagsEXT,
        objectType: DebugReportObjectTypeEXT,
        object: u64,
        location: usize,
        messageCode: i32,
        pLayerPrefix: *const c_char,
        pMessage: *const c_char,
    ) -> (),
    GetPhysicalDeviceVideoCapabilitiesKHR => (
        physicalDevice: PhysicalDevice,
        pVideoProfile: *const VideoProfileKHR,
        pCapabilities: *mut VideoCapabilitiesKHR,
    ) -> Result,
    GetPhysicalDeviceVideoFormatPropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pVideoFormatInfo: *const PhysicalDeviceVideoFormatInfoKHR,
        pVideoFormatPropertyCount: *mut u32,
        pVideoFormatProperties: *mut VideoFormatPropertiesKHR,
    ) -> Result,
    GetPhysicalDeviceExternalImageFormatPropertiesNV => (
        physicalDevice: PhysicalDevice,
        format: Format,
        typ: ImageType,
        tiling: ImageTiling,
        usage: ImageUsageFlags,
        flags: ImageCreateFlags,
        externalHandleType: ExternalMemoryHandleTypeFlagsNV,
        pExternalImageFormatProperties: *mut ExternalImageFormatPropertiesNV,
    ) -> Result,
    GetPhysicalDeviceFeatures2KHR => (
        physicalDevice: PhysicalDevice,
        pFeatures: *mut PhysicalDeviceFeatures2,
    ) -> (),
    GetPhysicalDeviceProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pProperties: *mut PhysicalDeviceProperties2,
    ) -> (),
    GetPhysicalDeviceFormatProperties2KHR => (
        physicalDevice: PhysicalDevice,
        format: Format,
        pFormatProperties: *mut FormatProperties2,
    ) -> (),
    GetPhysicalDeviceImageFormatProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pImageFormatInfo: *const PhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut ImageFormatProperties2,
    ) -> Result,
    GetPhysicalDeviceQueueFamilyProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut QueueFamilyProperties2,
    ) -> (),
    GetPhysicalDeviceMemoryProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pMemoryProperties: *mut PhysicalDeviceMemoryProperties2,
    ) -> (),
    GetPhysicalDeviceSparseImageFormatProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pFormatInfo: *const PhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut SparseImageFormatProperties2,
    ) -> (),
    EnumeratePhysicalDeviceGroupsKHR => (
        instance: Instance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut PhysicalDeviceGroupProperties,
    ) -> Result,
    GetPhysicalDeviceExternalBufferPropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pExternalBufferInfo: *const PhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut ExternalBufferProperties,
    ) -> (),
    GetPhysicalDeviceExternalSemaphorePropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pExternalSemaphoreInfo: *const PhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut ExternalSemaphoreProperties,
    ) -> (),
    ReleaseDisplayEXT => (
        physicalDevice: PhysicalDevice,
        display: DisplayKHR,
    ) -> Result,
    GetPhysicalDeviceSurfaceCapabilities2EXT => (
        physicalDevice: PhysicalDevice,
        surface: SurfaceKHR,
        pSurfaceCapabilities: *mut SurfaceCapabilities2EXT,
    ) -> Result,
    GetPhysicalDeviceExternalFencePropertiesKHR => (
        physicalDevice: PhysicalDevice,
        pExternalFenceInfo: *const PhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut ExternalFenceProperties,
    ) -> (),
    EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR => (
        physicalDevice: PhysicalDevice,
        queueFamilyIndex: u32,
        pCounterCount: *mut u32,
        pCounters: *mut PerformanceCounterKHR,
        pCounterDescriptions: *mut PerformanceCounterDescriptionKHR,
    ) -> Result,
    GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR => (
        physicalDevice: PhysicalDevice,
        pPerformanceQueryCreateInfo: *const QueryPoolPerformanceCreateInfoKHR,
        pNumPasses: *mut u32,
    ) -> (),
    GetPhysicalDeviceSurfaceCapabilities2KHR => (
        physicalDevice: PhysicalDevice,
        pSurfaceInfo: *const PhysicalDeviceSurfaceInfo2KHR,
        pSurfaceCapabilities: *mut SurfaceCapabilities2KHR,
    ) -> Result,
    GetPhysicalDeviceSurfaceFormats2KHR => (
        physicalDevice: PhysicalDevice,
        pSurfaceInfo: *const PhysicalDeviceSurfaceInfo2KHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut SurfaceFormat2KHR,
    ) -> Result,
    GetPhysicalDeviceDisplayProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayProperties2KHR,
    ) -> Result,
    GetPhysicalDeviceDisplayPlaneProperties2KHR => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayPlaneProperties2KHR,
    ) -> Result,
    GetDisplayModeProperties2KHR => (
        physicalDevice: PhysicalDevice,
        display: DisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut DisplayModeProperties2KHR,
    ) -> Result,
    GetDisplayPlaneCapabilities2KHR => (
        physicalDevice: PhysicalDevice,
        pDisplayPlaneInfo: *const DisplayPlaneInfo2KHR,
        pCapabilities: *mut DisplayPlaneCapabilities2KHR,
    ) -> Result,
    CreateDebugUtilsMessengerEXT => (
        instance: Instance,
        pCreateInfo: *const DebugUtilsMessengerCreateInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pMessenger: *mut DebugUtilsMessengerEXT,
    ) -> Result,
    DestroyDebugUtilsMessengerEXT => (
        instance: Instance,
        messenger: DebugUtilsMessengerEXT,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    SubmitDebugUtilsMessageEXT => (
        instance: Instance,
        messageSeverity: DebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: DebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const DebugUtilsMessengerCallbackDataEXT,
    ) -> (),
    GetPhysicalDeviceMultisamplePropertiesEXT => (
        physicalDevice: PhysicalDevice,
        samples: SampleCountFlagBits,
        pMultisampleProperties: *mut MultisamplePropertiesEXT,
    ) -> (),
    GetPhysicalDeviceCalibrateableTimeDomainsEXT => (
        physicalDevice: PhysicalDevice,
        pTimeDomainCount: *mut u32,
        pTimeDomains: *mut TimeDomainEXT,
    ) -> Result,
    GetPhysicalDeviceFragmentShadingRatesKHR => (
        physicalDevice: PhysicalDevice,
        pFragmentShadingRateCount: *mut u32,
        pFragmentShadingRates: *mut PhysicalDeviceFragmentShadingRateKHR,
    ) -> Result,
    GetPhysicalDeviceToolPropertiesEXT => (
        physicalDevice: PhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut PhysicalDeviceToolProperties,
    ) -> Result,
    GetPhysicalDeviceCooperativeMatrixPropertiesNV => (
        physicalDevice: PhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut CooperativeMatrixPropertiesNV,
    ) -> Result,
    GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV => (
        physicalDevice: PhysicalDevice,
        pCombinationCount: *mut u32,
        pCombinations: *mut FramebufferMixedSamplesCombinationNV,
    ) -> Result,
    CreateHeadlessSurfaceEXT => (
        instance: Instance,
        pCreateInfo: *const HeadlessSurfaceCreateInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pSurface: *mut SurfaceKHR,
    ) -> Result,
    AcquireDrmDisplayEXT => (
        physicalDevice: PhysicalDevice,
        drmFd: i32,
        display: DisplayKHR,
    ) -> Result,
    GetDrmDisplayEXT => (
        physicalDevice: PhysicalDevice,
        drmFd: i32,
        connectorId: u32,
        display: *mut DisplayKHR,
    ) -> Result,
});

// device commands
ptrs!(DeviceCommands, (GetDeviceProcAddr: FnGetDeviceProcAddr, device: Device), {
    DestroyDevice => (
        device: Device,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetDeviceQueue => (
        device: Device,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut Queue,
    ) -> (),
    QueueSubmit => (
        queue: Queue,
        submitCount: u32,
        pSubmits: *const SubmitInfo,
        fence: Fence,
    ) -> Result,
    QueueWaitIdle => (
        queue: Queue,
    ) -> Result,
    DeviceWaitIdle => (
        device: Device,
    ) -> Result,
    AllocateMemory => (
        device: Device,
        pAllocateInfo: *const MemoryAllocateInfo,
        pAllocator: *const AllocationCallbacks,
        pMemory: *mut DeviceMemory,
    ) -> Result,
    FreeMemory => (
        device: Device,
        memory: DeviceMemory,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    MapMemory => (
        device: Device,
        memory: DeviceMemory,
        offset: DeviceSize,
        size: DeviceSize,
        flags: MemoryMapFlags,
        ppData: *mut *mut c_void,
    ) -> Result,
    UnmapMemory => (
        device: Device,
        memory: DeviceMemory,
    ) -> (),
    FlushMappedMemoryRanges => (
        device: Device,
        memoryRangeCount: u32,
        pMemoryRanges: *const MappedMemoryRange,
    ) -> Result,
    InvalidateMappedMemoryRanges => (
        device: Device,
        memoryRangeCount: u32,
        pMemoryRanges: *const MappedMemoryRange,
    ) -> Result,
    GetDeviceMemoryCommitment => (
        device: Device,
        memory: DeviceMemory,
        pCommittedMemoryInBytes: *mut DeviceSize,
    ) -> (),
    BindBufferMemory => (
        device: Device,
        buffer: Buffer,
        memory: DeviceMemory,
        memoryOffset: DeviceSize,
    ) -> Result,
    BindImageMemory => (
        device: Device,
        image: Image,
        memory: DeviceMemory,
        memoryOffset: DeviceSize,
    ) -> Result,
    GetBufferMemoryRequirements => (
        device: Device,
        buffer: Buffer,
        pMemoryRequirements: *mut MemoryRequirements,
    ) -> (),
    GetImageMemoryRequirements => (
        device: Device,
        image: Image,
        pMemoryRequirements: *mut MemoryRequirements,
    ) -> (),
    GetImageSparseMemoryRequirements => (
        device: Device,
        image: Image,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut SparseImageMemoryRequirements,
    ) -> (),
    QueueBindSparse => (
        queue: Queue,
        bindInfoCount: u32,
        pBindInfo: *const BindSparseInfo,
        fence: Fence,
    ) -> Result,
    CreateFence => (
        device: Device,
        pCreateInfo: *const FenceCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pFence: *mut Fence,
    ) -> Result,
    DestroyFence => (
        device: Device,
        fence: Fence,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    ResetFences => (
        device: Device,
        fenceCount: u32,
        pFences: *const Fence,
    ) -> Result,
    GetFenceStatus => (
        device: Device,
        fence: Fence,
    ) -> Result,
    WaitForFences => (
        device: Device,
        fenceCount: u32,
        pFences: *const Fence,
        waitAll: Bool32,
        timeout: u64,
    ) -> Result,
    CreateSemaphore => (
        device: Device,
        pCreateInfo: *const SemaphoreCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pSemaphore: *mut Semaphore,
    ) -> Result,
    DestroySemaphore => (
        device: Device,
        semaphore: Semaphore,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateEvent => (
        device: Device,
        pCreateInfo: *const EventCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pEvent: *mut Event,
    ) -> Result,
    DestroyEvent => (
        device: Device,
        event: Event,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetEventStatus => (
        device: Device,
        event: Event,
    ) -> Result,
    SetEvent => (
        device: Device,
        event: Event,
    ) -> Result,
    ResetEvent => (
        device: Device,
        event: Event,
    ) -> Result,
    CreateQueryPool => (
        device: Device,
        pCreateInfo: *const QueryPoolCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pQueryPool: *mut QueryPool,
    ) -> Result,
    DestroyQueryPool => (
        device: Device,
        queryPool: QueryPool,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetQueryPoolResults => (
        device: Device,
        queryPool: QueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: usize,
        pData: *mut c_void,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> Result,
    CreateBuffer => (
        device: Device,
        pCreateInfo: *const BufferCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pBuffer: *mut Buffer,
    ) -> Result,
    DestroyBuffer => (
        device: Device,
        buffer: Buffer,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateBufferView => (
        device: Device,
        pCreateInfo: *const BufferViewCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pView: *mut BufferView,
    ) -> Result,
    DestroyBufferView => (
        device: Device,
        bufferView: BufferView,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateImage => (
        device: Device,
        pCreateInfo: *const ImageCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pImage: *mut Image,
    ) -> Result,
    DestroyImage => (
        device: Device,
        image: Image,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetImageSubresourceLayout => (
        device: Device,
        image: Image,
        pSubresource: *const ImageSubresource,
        pLayout: *mut SubresourceLayout,
    ) -> (),
    CreateImageView => (
        device: Device,
        pCreateInfo: *const ImageViewCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pView: *mut ImageView,
    ) -> Result,
    DestroyImageView => (
        device: Device,
        imageView: ImageView,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateShaderModule => (
        device: Device,
        pCreateInfo: *const ShaderModuleCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pShaderModule: *mut ShaderModule,
    ) -> Result,
    DestroyShaderModule => (
        device: Device,
        shaderModule: ShaderModule,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreatePipelineCache => (
        device: Device,
        pCreateInfo: *const PipelineCacheCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPipelineCache: *mut PipelineCache,
    ) -> Result,
    DestroyPipelineCache => (
        device: Device,
        pipelineCache: PipelineCache,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetPipelineCacheData => (
        device: Device,
        pipelineCache: PipelineCache,
        pDataSize: *mut usize,
        pData: *mut c_void,
    ) -> Result,
    MergePipelineCaches => (
        device: Device,
        dstCache: PipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const PipelineCache,
    ) -> Result,
    CreateGraphicsPipelines => (
        device: Device,
        pipelineCache: PipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const GraphicsPipelineCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPipelines: *mut Pipeline,
    ) -> Result,
    CreateComputePipelines => (
        device: Device,
        pipelineCache: PipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const ComputePipelineCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPipelines: *mut Pipeline,
    ) -> Result,
    DestroyPipeline => (
        device: Device,
        pipeline: Pipeline,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreatePipelineLayout => (
        device: Device,
        pCreateInfo: *const PipelineLayoutCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPipelineLayout: *mut PipelineLayout,
    ) -> Result,
    DestroyPipelineLayout => (
        device: Device,
        pipelineLayout: PipelineLayout,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateSampler => (
        device: Device,
        pCreateInfo: *const SamplerCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pSampler: *mut Sampler,
    ) -> Result,
    DestroySampler => (
        device: Device,
        sampler: Sampler,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateDescriptorSetLayout => (
        device: Device,
        pCreateInfo: *const DescriptorSetLayoutCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pSetLayout: *mut DescriptorSetLayout,
    ) -> Result,
    DestroyDescriptorSetLayout => (
        device: Device,
        descriptorSetLayout: DescriptorSetLayout,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateDescriptorPool => (
        device: Device,
        pCreateInfo: *const DescriptorPoolCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pDescriptorPool: *mut DescriptorPool,
    ) -> Result,
    DestroyDescriptorPool => (
        device: Device,
        descriptorPool: DescriptorPool,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    ResetDescriptorPool => (
        device: Device,
        descriptorPool: DescriptorPool,
        flags: DescriptorPoolResetFlags,
    ) -> Result,
    AllocateDescriptorSets => (
        device: Device,
        pAllocateInfo: *const DescriptorSetAllocateInfo,
        pDescriptorSets: *mut DescriptorSet,
    ) -> Result,
    FreeDescriptorSets => (
        device: Device,
        descriptorPool: DescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const DescriptorSet,
    ) -> Result,
    UpdateDescriptorSets => (
        device: Device,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const WriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const CopyDescriptorSet,
    ) -> (),
    CreateFramebuffer => (
        device: Device,
        pCreateInfo: *const FramebufferCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pFramebuffer: *mut Framebuffer,
    ) -> Result,
    DestroyFramebuffer => (
        device: Device,
        framebuffer: Framebuffer,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateRenderPass => (
        device: Device,
        pCreateInfo: *const RenderPassCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pRenderPass: *mut RenderPass,
    ) -> Result,
    DestroyRenderPass => (
        device: Device,
        renderPass: RenderPass,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetRenderAreaGranularity => (
        device: Device,
        renderPass: RenderPass,
        pGranularity: *mut Extent2D,
    ) -> (),
    CreateCommandPool => (
        device: Device,
        pCreateInfo: *const CommandPoolCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pCommandPool: *mut CommandPool,
    ) -> Result,
    DestroyCommandPool => (
        device: Device,
        commandPool: CommandPool,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    ResetCommandPool => (
        device: Device,
        commandPool: CommandPool,
        flags: CommandPoolResetFlags,
    ) -> Result,
    AllocateCommandBuffers => (
        device: Device,
        pAllocateInfo: *const CommandBufferAllocateInfo,
        pCommandBuffers: *mut CommandBuffer,
    ) -> Result,
    FreeCommandBuffers => (
        device: Device,
        commandPool: CommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const CommandBuffer,
    ) -> (),
    BeginCommandBuffer => (
        commandBuffer: CommandBuffer,
        pBeginInfo: *const CommandBufferBeginInfo,
    ) -> Result,
    EndCommandBuffer => (
        commandBuffer: CommandBuffer,
    ) -> Result,
    ResetCommandBuffer => (
        commandBuffer: CommandBuffer,
        flags: CommandBufferResetFlags,
    ) -> Result,
    CmdBindPipeline => (
        commandBuffer: CommandBuffer,
        pipelineBindPoint: PipelineBindPoint,
        pipeline: Pipeline,
    ) -> (),
    CmdSetViewport => (
        commandBuffer: CommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const Viewport,
    ) -> (),
    CmdSetScissor => (
        commandBuffer: CommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const Rect2D,
    ) -> (),
    CmdSetLineWidth => (
        commandBuffer: CommandBuffer,
        lineWidth: f32,
    ) -> (),
    CmdSetDepthBias => (
        commandBuffer: CommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    ) -> (),
    CmdSetBlendConstants => (
        commandBuffer: CommandBuffer,
        blendConstants: [f32; 4],
    ) -> (),
    CmdSetDepthBounds => (
        commandBuffer: CommandBuffer,
        minDepthBounds: f32,
        maxDepthBounds: f32,
    ) -> (),
    CmdSetStencilCompareMask => (
        commandBuffer: CommandBuffer,
        faceMask: StencilFaceFlags,
        compareMask: u32,
    ) -> (),
    CmdSetStencilWriteMask => (
        commandBuffer: CommandBuffer,
        faceMask: StencilFaceFlags,
        writeMask: u32,
    ) -> (),
    CmdSetStencilReference => (
        commandBuffer: CommandBuffer,
        faceMask: StencilFaceFlags,
        reference: u32,
    ) -> (),
    CmdBindDescriptorSets => (
        commandBuffer: CommandBuffer,
        pipelineBindPoint: PipelineBindPoint,
        layout: PipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const DescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    ) -> (),
    CmdBindIndexBuffer => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        indexType: IndexType,
    ) -> (),
    CmdBindVertexBuffers => (
        commandBuffer: CommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const Buffer,
        pOffsets: *const DeviceSize,
    ) -> (),
    CmdDraw => (
        commandBuffer: CommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    ) -> (),
    CmdDrawIndexed => (
        commandBuffer: CommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    ) -> (),
    CmdDrawIndirect => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        drawCount: u32,
        stride: u32,
    ) -> (),
    CmdDrawIndexedIndirect => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        drawCount: u32,
        stride: u32,
    ) -> (),
    CmdDispatch => (
        commandBuffer: CommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ) -> (),
    CmdDispatchIndirect => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
    ) -> (),
    CmdCopyBuffer => (
        commandBuffer: CommandBuffer,
        srcBuffer: Buffer,
        dstBuffer: Buffer,
        regionCount: u32,
        pRegions: *const BufferCopy,
    ) -> (),
    CmdCopyImage => (
        commandBuffer: CommandBuffer,
        srcImage: Image,
        srcImageLayout: ImageLayout,
        dstImage: Image,
        dstImageLayout: ImageLayout,
        regionCount: u32,
        pRegions: *const ImageCopy,
    ) -> (),
    CmdBlitImage => (
        commandBuffer: CommandBuffer,
        srcImage: Image,
        srcImageLayout: ImageLayout,
        dstImage: Image,
        dstImageLayout: ImageLayout,
        regionCount: u32,
        pRegions: *const ImageBlit,
        filter: Filter,
    ) -> (),
    CmdCopyBufferToImage => (
        commandBuffer: CommandBuffer,
        srcBuffer: Buffer,
        dstImage: Image,
        dstImageLayout: ImageLayout,
        regionCount: u32,
        pRegions: *const BufferImageCopy,
    ) -> (),
    CmdCopyImageToBuffer => (
        commandBuffer: CommandBuffer,
        srcImage: Image,
        srcImageLayout: ImageLayout,
        dstBuffer: Buffer,
        regionCount: u32,
        pRegions: *const BufferImageCopy,
    ) -> (),
    CmdUpdateBuffer => (
        commandBuffer: CommandBuffer,
        dstBuffer: Buffer,
        dstOffset: DeviceSize,
        dataSize: DeviceSize,
        pData: *const c_void,
    ) -> (),
    CmdFillBuffer => (
        commandBuffer: CommandBuffer,
        dstBuffer: Buffer,
        dstOffset: DeviceSize,
        size: DeviceSize,
        data: u32,
    ) -> (),
    CmdClearColorImage => (
        commandBuffer: CommandBuffer,
        image: Image,
        imageLayout: ImageLayout,
        pColor: *const ClearColorValue,
        rangeCount: u32,
        pRanges: *const ImageSubresourceRange,
    ) -> (),
    CmdClearDepthStencilImage => (
        commandBuffer: CommandBuffer,
        image: Image,
        imageLayout: ImageLayout,
        pDepthStencil: *const ClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const ImageSubresourceRange,
    ) -> (),
    CmdClearAttachments => (
        commandBuffer: CommandBuffer,
        attachmentCount: u32,
        pAttachments: *const ClearAttachment,
        rectCount: u32,
        pRects: *const ClearRect,
    ) -> (),
    CmdResolveImage => (
        commandBuffer: CommandBuffer,
        srcImage: Image,
        srcImageLayout: ImageLayout,
        dstImage: Image,
        dstImageLayout: ImageLayout,
        regionCount: u32,
        pRegions: *const ImageResolve,
    ) -> (),
    CmdSetEvent => (
        commandBuffer: CommandBuffer,
        event: Event,
        stageMask: PipelineStageFlags,
    ) -> (),
    CmdResetEvent => (
        commandBuffer: CommandBuffer,
        event: Event,
        stageMask: PipelineStageFlags,
    ) -> (),
    CmdWaitEvents => (
        commandBuffer: CommandBuffer,
        eventCount: u32,
        pEvents: *const Event,
        srcStageMask: PipelineStageFlags,
        dstStageMask: PipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const MemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const BufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const ImageMemoryBarrier,
    ) -> (),
    CmdPipelineBarrier => (
        commandBuffer: CommandBuffer,
        srcStageMask: PipelineStageFlags,
        dstStageMask: PipelineStageFlags,
        dependencyFlags: DependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const MemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const BufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const ImageMemoryBarrier,
    ) -> (),
    CmdBeginQuery => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        query: u32,
        flags: QueryControlFlags,
    ) -> (),
    CmdEndQuery => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        query: u32,
    ) -> (),
    CmdResetQueryPool => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        firstQuery: u32,
        queryCount: u32,
    ) -> (),
    CmdWriteTimestamp => (
        commandBuffer: CommandBuffer,
        pipelineStage: PipelineStageFlagBits,
        queryPool: QueryPool,
        query: u32,
    ) -> (),
    CmdCopyQueryPoolResults => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: Buffer,
        dstOffset: DeviceSize,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> (),
    CmdPushConstants => (
        commandBuffer: CommandBuffer,
        layout: PipelineLayout,
        stageFlags: ShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const c_void,
    ) -> (),
    CmdBeginRenderPass => (
        commandBuffer: CommandBuffer,
        pRenderPassBegin: *const RenderPassBeginInfo,
        contents: SubpassContents,
    ) -> (),
    CmdNextSubpass => (
        commandBuffer: CommandBuffer,
        contents: SubpassContents,
    ) -> (),
    CmdEndRenderPass => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CmdExecuteCommands => (
        commandBuffer: CommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const CommandBuffer,
    ) -> (),
    BindBufferMemory2 => (
        device: Device,
        bindInfoCount: u32,
        pBindInfos: *const BindBufferMemoryInfo,
    ) -> Result,
    BindImageMemory2 => (
        device: Device,
        bindInfoCount: u32,
        pBindInfos: *const BindImageMemoryInfo,
    ) -> Result,
    GetDeviceGroupPeerMemoryFeatures => (
        device: Device,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut PeerMemoryFeatureFlags,
    ) -> (),
    CmdSetDeviceMask => (
        commandBuffer: CommandBuffer,
        deviceMask: u32,
    ) -> (),
    CmdDispatchBase => (
        commandBuffer: CommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ) -> (),
    GetImageMemoryRequirements2 => (
        device: Device,
        pInfo: *const ImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetBufferMemoryRequirements2 => (
        device: Device,
        pInfo: *const BufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetImageSparseMemoryRequirements2 => (
        device: Device,
        pInfo: *const ImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
    ) -> (),
    TrimCommandPool => (
        device: Device,
        commandPool: CommandPool,
        flags: CommandPoolTrimFlags,
    ) -> (),
    GetDeviceQueue2 => (
        device: Device,
        pQueueInfo: *const DeviceQueueInfo2,
        pQueue: *mut Queue,
    ) -> (),
    CreateSamplerYcbcrConversion => (
        device: Device,
        pCreateInfo: *const SamplerYcbcrConversionCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pYcbcrConversion: *mut SamplerYcbcrConversion,
    ) -> Result,
    DestroySamplerYcbcrConversion => (
        device: Device,
        ycbcrConversion: SamplerYcbcrConversion,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreateDescriptorUpdateTemplate => (
        device: Device,
        pCreateInfo: *const DescriptorUpdateTemplateCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pDescriptorUpdateTemplate: *mut DescriptorUpdateTemplate,
    ) -> Result,
    DestroyDescriptorUpdateTemplate => (
        device: Device,
        descriptorUpdateTemplate: DescriptorUpdateTemplate,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    UpdateDescriptorSetWithTemplate => (
        device: Device,
        descriptorSet: DescriptorSet,
        descriptorUpdateTemplate: DescriptorUpdateTemplate,
        pData: *const c_void,
    ) -> (),
    GetDescriptorSetLayoutSupport => (
        device: Device,
        pCreateInfo: *const DescriptorSetLayoutCreateInfo,
        pSupport: *mut DescriptorSetLayoutSupport,
    ) -> (),
    CmdDrawIndirectCount => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    CmdDrawIndexedIndirectCount => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    CreateRenderPass2 => (
        device: Device,
        pCreateInfo: *const RenderPassCreateInfo2,
        pAllocator: *const AllocationCallbacks,
        pRenderPass: *mut RenderPass,
    ) -> Result,
    CmdBeginRenderPass2 => (
        commandBuffer: CommandBuffer,
        pRenderPassBegin: *const RenderPassBeginInfo,
        pSubpassBeginInfo: *const SubpassBeginInfo,
    ) -> (),
    CmdNextSubpass2 => (
        commandBuffer: CommandBuffer,
        pSubpassBeginInfo: *const SubpassBeginInfo,
        pSubpassEndInfo: *const SubpassEndInfo,
    ) -> (),
    CmdEndRenderPass2 => (
        commandBuffer: CommandBuffer,
        pSubpassEndInfo: *const SubpassEndInfo,
    ) -> (),
    ResetQueryPool => (
        device: Device,
        queryPool: QueryPool,
        firstQuery: u32,
        queryCount: u32,
    ) -> (),
    GetSemaphoreCounterValue => (
        device: Device,
        semaphore: Semaphore,
        pValue: *mut u64,
    ) -> Result,
    WaitSemaphores => (
        device: Device,
        pWaitInfo: *const SemaphoreWaitInfo,
        timeout: u64,
    ) -> Result,
    SignalSemaphore => (
        device: Device,
        pSignalInfo: *const SemaphoreSignalInfo,
    ) -> Result,
    GetBufferDeviceAddress => (
        device: Device,
        pInfo: *const BufferDeviceAddressInfo,
    ) -> DeviceAddress,
    GetBufferOpaqueCaptureAddress => (
        device: Device,
        pInfo: *const BufferDeviceAddressInfo,
    ) -> u64,
    GetDeviceMemoryOpaqueCaptureAddress => (
        device: Device,
        pInfo: *const DeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64,
    CreatePrivateDataSlot => (
        device: Device,
        pCreateInfo: *const PrivateDataSlotCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPrivateDataSlot: *mut PrivateDataSlot,
    ) -> Result,
    DestroyPrivateDataSlot => (
        device: Device,
        privateDataSlot: PrivateDataSlot,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    SetPrivateData => (
        device: Device,
        objectType: ObjectType,
        objectHandle: u64,
        privateDataSlot: PrivateDataSlot,
        data: u64,
    ) -> Result,
    GetPrivateData => (
        device: Device,
        objectType: ObjectType,
        objectHandle: u64,
        privateDataSlot: PrivateDataSlot,
        pData: *mut u64,
    ) -> (),
    CmdSetEvent2 => (
        commandBuffer: CommandBuffer,
        event: Event,
        pDependencyInfo: *const DependencyInfo,
    ) -> (),
    CmdResetEvent2 => (
        commandBuffer: CommandBuffer,
        event: Event,
        stageMask: PipelineStageFlags2,
    ) -> (),
    CmdWaitEvents2 => (
        commandBuffer: CommandBuffer,
        eventCount: u32,
        pEvents: *const Event,
        pDependencyInfos: *const DependencyInfo,
    ) -> (),
    CmdPipelineBarrier2 => (
        commandBuffer: CommandBuffer,
        pDependencyInfo: *const DependencyInfo,
    ) -> (),
    CmdWriteTimestamp2 => (
        commandBuffer: CommandBuffer,
        stage: PipelineStageFlags2,
        queryPool: QueryPool,
        query: u32,
    ) -> (),
    QueueSubmit2 => (
        queue: Queue,
        submitCount: u32,
        pSubmits: *const SubmitInfo2,
        fence: Fence,
    ) -> Result,
    CmdCopyBuffer2 => (
        commandBuffer: CommandBuffer,
        pCopyBufferInfo: *const CopyBufferInfo2,
    ) -> (),
    CmdCopyImage2 => (
        commandBuffer: CommandBuffer,
        pCopyImageInfo: *const CopyImageInfo2,
    ) -> (),
    CmdCopyBufferToImage2 => (
        commandBuffer: CommandBuffer,
        pCopyBufferToImageInfo: *const CopyBufferToImageInfo2,
    ) -> (),
    CmdCopyImageToBuffer2 => (
        commandBuffer: CommandBuffer,
        pCopyImageToBufferInfo: *const CopyImageToBufferInfo2,
    ) -> (),
    CmdBlitImage2 => (
        commandBuffer: CommandBuffer,
        pBlitImageInfo: *const BlitImageInfo2,
    ) -> (),
    CmdResolveImage2 => (
        commandBuffer: CommandBuffer,
        pResolveImageInfo: *const ResolveImageInfo2,
    ) -> (),
    CmdBeginRendering => (
        commandBuffer: CommandBuffer,
        pRenderingInfo: *const RenderingInfo,
    ) -> (),
    CmdEndRendering => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CmdSetCullMode => (
        commandBuffer: CommandBuffer,
        cullMode: CullModeFlags,
    ) -> (),
    CmdSetFrontFace => (
        commandBuffer: CommandBuffer,
        frontFace: FrontFace,
    ) -> (),
    CmdSetPrimitiveTopology => (
        commandBuffer: CommandBuffer,
        primitiveTopology: PrimitiveTopology,
    ) -> (),
    CmdSetViewportWithCount => (
        commandBuffer: CommandBuffer,
        viewportCount: u32,
        pViewports: *const Viewport,
    ) -> (),
    CmdSetScissorWithCount => (
        commandBuffer: CommandBuffer,
        scissorCount: u32,
        pScissors: *const Rect2D,
    ) -> (),
    CmdBindVertexBuffers2 => (
        commandBuffer: CommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const Buffer,
        pOffsets: *const DeviceSize,
        pSizes: *const DeviceSize,
        pStrides: *const DeviceSize,
    ) -> (),
    CmdSetDepthTestEnable => (
        commandBuffer: CommandBuffer,
        depthTestEnable: Bool32,
    ) -> (),
    CmdSetDepthWriteEnable => (
        commandBuffer: CommandBuffer,
        depthWriteEnable: Bool32,
    ) -> (),
    CmdSetDepthCompareOp => (
        commandBuffer: CommandBuffer,
        depthCompareOp: CompareOp,
    ) -> (),
    CmdSetDepthBoundsTestEnable => (
        commandBuffer: CommandBuffer,
        depthBoundsTestEnable: Bool32,
    ) -> (),
    CmdSetStencilTestEnable => (
        commandBuffer: CommandBuffer,
        stencilTestEnable: Bool32,
    ) -> (),
    CmdSetStencilOp => (
        commandBuffer: CommandBuffer,
        faceMask: StencilFaceFlags,
        failOp: StencilOp,
        passOp: StencilOp,
        depthFailOp: StencilOp,
        compareOp: CompareOp,
    ) -> (),
    CmdSetRasterizerDiscardEnable => (
        commandBuffer: CommandBuffer,
        rasterizerDiscardEnable: Bool32,
    ) -> (),
    CmdSetDepthBiasEnable => (
        commandBuffer: CommandBuffer,
        depthBiasEnable: Bool32,
    ) -> (),
    CmdSetPrimitiveRestartEnable => (
        commandBuffer: CommandBuffer,
        primitiveRestartEnable: Bool32,
    ) -> (),
    GetDeviceBufferMemoryRequirements => (
        device: Device,
        pInfo: *const DeviceBufferMemoryRequirements,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetDeviceImageMemoryRequirements => (
        device: Device,
        pInfo: *const DeviceImageMemoryRequirements,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetDeviceImageSparseMemoryRequirements => (
        device: Device,
        pInfo: *const DeviceImageMemoryRequirements,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
    ) -> (),
    CreateSwapchainKHR => (
        device: Device,
        pCreateInfo: *const SwapchainCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pSwapchain: *mut SwapchainKHR,
    ) -> Result,
    DestroySwapchainKHR => (
        device: Device,
        swapchain: SwapchainKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetSwapchainImagesKHR => (
        device: Device,
        swapchain: SwapchainKHR,
        pSwapchainImageCount: *mut u32,
        pSwapchainImages: *mut Image,
    ) -> Result,
    AcquireNextImageKHR => (
        device: Device,
        swapchain: SwapchainKHR,
        timeout: u64,
        semaphore: Semaphore,
        fence: Fence,
        pImageIndex: *mut u32,
    ) -> Result,
    QueuePresentKHR => (
        queue: Queue,
        pPresentInfo: *const PresentInfoKHR,
    ) -> Result,
    GetDeviceGroupPresentCapabilitiesKHR => (
        device: Device,
        pDeviceGroupPresentCapabilities: *mut DeviceGroupPresentCapabilitiesKHR,
    ) -> Result,
    GetDeviceGroupSurfacePresentModesKHR => (
        device: Device,
        surface: SurfaceKHR,
        pModes: *mut DeviceGroupPresentModeFlagsKHR,
    ) -> Result,
    AcquireNextImage2KHR => (
        device: Device,
        pAcquireInfo: *const AcquireNextImageInfoKHR,
        pImageIndex: *mut u32,
    ) -> Result,
    CreateSharedSwapchainsKHR => (
        device: Device,
        swapchainCount: u32,
        pCreateInfos: *const SwapchainCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pSwapchains: *mut SwapchainKHR,
    ) -> Result,
    DebugMarkerSetObjectTagEXT => (
        device: Device,
        pTagInfo: *const DebugMarkerObjectTagInfoEXT,
    ) -> Result,
    DebugMarkerSetObjectNameEXT => (
        device: Device,
        pNameInfo: *const DebugMarkerObjectNameInfoEXT,
    ) -> Result,
    CmdDebugMarkerBeginEXT => (
        commandBuffer: CommandBuffer,
        pMarkerInfo: *const DebugMarkerMarkerInfoEXT,
    ) -> (),
    CmdDebugMarkerEndEXT => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CmdDebugMarkerInsertEXT => (
        commandBuffer: CommandBuffer,
        pMarkerInfo: *const DebugMarkerMarkerInfoEXT,
    ) -> (),
    CreateVideoSessionKHR => (
        device: Device,
        pCreateInfo: *const VideoSessionCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pVideoSession: *mut VideoSessionKHR,
    ) -> Result,
    DestroyVideoSessionKHR => (
        device: Device,
        videoSession: VideoSessionKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetVideoSessionMemoryRequirementsKHR => (
        device: Device,
        videoSession: VideoSessionKHR,
        pVideoSessionMemoryRequirementsCount: *mut u32,
        pVideoSessionMemoryRequirements: *mut VideoGetMemoryPropertiesKHR,
    ) -> Result,
    BindVideoSessionMemoryKHR => (
        device: Device,
        videoSession: VideoSessionKHR,
        videoSessionBindMemoryCount: u32,
        pVideoSessionBindMemories: *const VideoBindMemoryKHR,
    ) -> Result,
    CreateVideoSessionParametersKHR => (
        device: Device,
        pCreateInfo: *const VideoSessionParametersCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pVideoSessionParameters: *mut VideoSessionParametersKHR,
    ) -> Result,
    UpdateVideoSessionParametersKHR => (
        device: Device,
        videoSessionParameters: VideoSessionParametersKHR,
        pUpdateInfo: *const VideoSessionParametersUpdateInfoKHR,
    ) -> Result,
    DestroyVideoSessionParametersKHR => (
        device: Device,
        videoSessionParameters: VideoSessionParametersKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CmdBeginVideoCodingKHR => (
        commandBuffer: CommandBuffer,
        pBeginInfo: *const VideoBeginCodingInfoKHR,
    ) -> (),
    CmdEndVideoCodingKHR => (
        commandBuffer: CommandBuffer,
        pEndCodingInfo: *const VideoEndCodingInfoKHR,
    ) -> (),
    CmdControlVideoCodingKHR => (
        commandBuffer: CommandBuffer,
        pCodingControlInfo: *const VideoCodingControlInfoKHR,
    ) -> (),
    CmdDecodeVideoKHR => (
        commandBuffer: CommandBuffer,
        pFrameInfo: *const VideoDecodeInfoKHR,
    ) -> (),
    CmdBindTransformFeedbackBuffersEXT => (
        commandBuffer: CommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const Buffer,
        pOffsets: *const DeviceSize,
        pSizes: *const DeviceSize,
    ) -> (),
    CmdBeginTransformFeedbackEXT => (
        commandBuffer: CommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const Buffer,
        pCounterBufferOffsets: *const DeviceSize,
    ) -> (),
    CmdEndTransformFeedbackEXT => (
        commandBuffer: CommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const Buffer,
        pCounterBufferOffsets: *const DeviceSize,
    ) -> (),
    CmdBeginQueryIndexedEXT => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        query: u32,
        flags: QueryControlFlags,
        index: u32,
    ) -> (),
    CmdEndQueryIndexedEXT => (
        commandBuffer: CommandBuffer,
        queryPool: QueryPool,
        query: u32,
        index: u32,
    ) -> (),
    CmdDrawIndirectByteCountEXT => (
        commandBuffer: CommandBuffer,
        instanceCount: u32,
        firstInstance: u32,
        counterBuffer: Buffer,
        counterBufferOffset: DeviceSize,
        counterOffset: u32,
        vertexStride: u32,
    ) -> (),
    CreateCuModuleNVX => (
        device: Device,
        pCreateInfo: *const CuModuleCreateInfoNVX,
        pAllocator: *const AllocationCallbacks,
        pModule: *mut CuModuleNVX,
    ) -> Result,
    CreateCuFunctionNVX => (
        device: Device,
        pCreateInfo: *const CuFunctionCreateInfoNVX,
        pAllocator: *const AllocationCallbacks,
        pFunction: *mut CuFunctionNVX,
    ) -> Result,
    DestroyCuModuleNVX => (
        device: Device,
        module: CuModuleNVX,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    DestroyCuFunctionNVX => (
        device: Device,
        function: CuFunctionNVX,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CmdCuLaunchKernelNVX => (
        commandBuffer: CommandBuffer,
        pLaunchInfo: *const CuLaunchInfoNVX,
    ) -> (),
    GetImageViewHandleNVX => (
        device: Device,
        pInfo: *const ImageViewHandleInfoNVX,
    ) -> u32,
    GetImageViewAddressNVX => (
        device: Device,
        imageView: ImageView,
        pProperties: *mut ImageViewAddressPropertiesNVX,
    ) -> Result,
    CmdDrawIndirectCountAMD => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    CmdDrawIndexedIndirectCountAMD => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    GetShaderInfoAMD => (
        device: Device,
        pipeline: Pipeline,
        shaderStage: ShaderStageFlagBits,
        infoType: ShaderInfoTypeAMD,
        pInfoSize: *mut usize,
        pInfo: *mut c_void,
    ) -> Result,
    CmdBeginRenderingKHR => (
        commandBuffer: CommandBuffer,
        pRenderingInfo: *const RenderingInfo,
    ) -> (),
    CmdEndRenderingKHR => (
        commandBuffer: CommandBuffer,
    ) -> (),
    GetDeviceGroupPeerMemoryFeaturesKHR => (
        device: Device,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut PeerMemoryFeatureFlags,
    ) -> (),
    CmdSetDeviceMaskKHR => (
        commandBuffer: CommandBuffer,
        deviceMask: u32,
    ) -> (),
    CmdDispatchBaseKHR => (
        commandBuffer: CommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ) -> (),
    TrimCommandPoolKHR => (
        device: Device,
        commandPool: CommandPool,
        flags: CommandPoolTrimFlags,
    ) -> (),
    GetMemoryFdKHR => (
        device: Device,
        pGetFdInfo: *const MemoryGetFdInfoKHR,
        pFd: *mut c_int,
    ) -> Result,
    GetMemoryFdPropertiesKHR => (
        device: Device,
        handleType: ExternalMemoryHandleTypeFlagBits,
        fd: c_int,
        pMemoryFdProperties: *mut MemoryFdPropertiesKHR,
    ) -> Result,
    ImportSemaphoreFdKHR => (
        device: Device,
        pImportSemaphoreFdInfo: *const ImportSemaphoreFdInfoKHR,
    ) -> Result,
    GetSemaphoreFdKHR => (
        device: Device,
        pGetFdInfo: *const SemaphoreGetFdInfoKHR,
        pFd: *mut c_int,
    ) -> Result,
    CmdPushDescriptorSetKHR => (
        commandBuffer: CommandBuffer,
        pipelineBindPoint: PipelineBindPoint,
        layout: PipelineLayout,
        set: u32,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const WriteDescriptorSet,
    ) -> (),
    CmdPushDescriptorSetWithTemplateKHR => (
        commandBuffer: CommandBuffer,
        descriptorUpdateTemplate: DescriptorUpdateTemplate,
        layout: PipelineLayout,
        set: u32,
        pData: *const c_void,
    ) -> (),
    CmdBeginConditionalRenderingEXT => (
        commandBuffer: CommandBuffer,
        pConditionalRenderingBegin: *const ConditionalRenderingBeginInfoEXT,
    ) -> (),
    CmdEndConditionalRenderingEXT => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CreateDescriptorUpdateTemplateKHR => (
        device: Device,
        pCreateInfo: *const DescriptorUpdateTemplateCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pDescriptorUpdateTemplate: *mut DescriptorUpdateTemplate,
    ) -> Result,
    DestroyDescriptorUpdateTemplateKHR => (
        device: Device,
        descriptorUpdateTemplate: DescriptorUpdateTemplate,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    UpdateDescriptorSetWithTemplateKHR => (
        device: Device,
        descriptorSet: DescriptorSet,
        descriptorUpdateTemplate: DescriptorUpdateTemplate,
        pData: *const c_void,
    ) -> (),
    CmdSetViewportWScalingNV => (
        commandBuffer: CommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewportWScalings: *const ViewportWScalingNV,
    ) -> (),
    DisplayPowerControlEXT => (
        device: Device,
        display: DisplayKHR,
        pDisplayPowerInfo: *const DisplayPowerInfoEXT,
    ) -> Result,
    RegisterDeviceEventEXT => (
        device: Device,
        pDeviceEventInfo: *const DeviceEventInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pFence: *mut Fence,
    ) -> Result,
    RegisterDisplayEventEXT => (
        device: Device,
        display: DisplayKHR,
        pDisplayEventInfo: *const DisplayEventInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pFence: *mut Fence,
    ) -> Result,
    GetSwapchainCounterEXT => (
        device: Device,
        swapchain: SwapchainKHR,
        counter: SurfaceCounterFlagBitsEXT,
        pCounterValue: *mut u64,
    ) -> Result,
    GetRefreshCycleDurationGOOGLE => (
        device: Device,
        swapchain: SwapchainKHR,
        pDisplayTimingProperties: *mut RefreshCycleDurationGOOGLE,
    ) -> Result,
    GetPastPresentationTimingGOOGLE => (
        device: Device,
        swapchain: SwapchainKHR,
        pPresentationTimingCount: *mut u32,
        pPresentationTimings: *mut PastPresentationTimingGOOGLE,
    ) -> Result,
    CmdSetDiscardRectangleEXT => (
        commandBuffer: CommandBuffer,
        firstDiscardRectangle: u32,
        discardRectangleCount: u32,
        pDiscardRectangles: *const Rect2D,
    ) -> (),
    SetHdrMetadataEXT => (
        device: Device,
        swapchainCount: u32,
        pSwapchains: *const SwapchainKHR,
        pMetadata: *const HdrMetadataEXT,
    ) -> (),
    CreateRenderPass2KHR => (
        device: Device,
        pCreateInfo: *const RenderPassCreateInfo2,
        pAllocator: *const AllocationCallbacks,
        pRenderPass: *mut RenderPass,
    ) -> Result,
    CmdBeginRenderPass2KHR => (
        commandBuffer: CommandBuffer,
        pRenderPassBegin: *const RenderPassBeginInfo,
        pSubpassBeginInfo: *const SubpassBeginInfo,
    ) -> (),
    CmdNextSubpass2KHR => (
        commandBuffer: CommandBuffer,
        pSubpassBeginInfo: *const SubpassBeginInfo,
        pSubpassEndInfo: *const SubpassEndInfo,
    ) -> (),
    CmdEndRenderPass2KHR => (
        commandBuffer: CommandBuffer,
        pSubpassEndInfo: *const SubpassEndInfo,
    ) -> (),
    GetSwapchainStatusKHR => (
        device: Device,
        swapchain: SwapchainKHR,
    ) -> Result,
    ImportFenceFdKHR => (
        device: Device,
        pImportFenceFdInfo: *const ImportFenceFdInfoKHR,
    ) -> Result,
    GetFenceFdKHR => (
        device: Device,
        pGetFdInfo: *const FenceGetFdInfoKHR,
        pFd: *mut c_int,
    ) -> Result,
    AcquireProfilingLockKHR => (
        device: Device,
        pInfo: *const AcquireProfilingLockInfoKHR,
    ) -> Result,
    ReleaseProfilingLockKHR => (
        device: Device,
    ) -> (),
    SetDebugUtilsObjectNameEXT => (
        device: Device,
        pNameInfo: *const DebugUtilsObjectNameInfoEXT,
    ) -> Result,
    SetDebugUtilsObjectTagEXT => (
        device: Device,
        pTagInfo: *const DebugUtilsObjectTagInfoEXT,
    ) -> Result,
    QueueBeginDebugUtilsLabelEXT => (
        queue: Queue,
        pLabelInfo: *const DebugUtilsLabelEXT,
    ) -> (),
    QueueEndDebugUtilsLabelEXT => (
        queue: Queue,
    ) -> (),
    QueueInsertDebugUtilsLabelEXT => (
        queue: Queue,
        pLabelInfo: *const DebugUtilsLabelEXT,
    ) -> (),
    CmdBeginDebugUtilsLabelEXT => (
        commandBuffer: CommandBuffer,
        pLabelInfo: *const DebugUtilsLabelEXT,
    ) -> (),
    CmdEndDebugUtilsLabelEXT => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CmdInsertDebugUtilsLabelEXT => (
        commandBuffer: CommandBuffer,
        pLabelInfo: *const DebugUtilsLabelEXT,
    ) -> (),
    CmdSetSampleLocationsEXT => (
        commandBuffer: CommandBuffer,
        pSampleLocationsInfo: *const SampleLocationsInfoEXT,
    ) -> (),
    GetImageMemoryRequirements2KHR => (
        device: Device,
        pInfo: *const ImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetBufferMemoryRequirements2KHR => (
        device: Device,
        pInfo: *const BufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetImageSparseMemoryRequirements2KHR => (
        device: Device,
        pInfo: *const ImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
    ) -> (),
    CreateAccelerationStructureKHR => (
        device: Device,
        pCreateInfo: *const AccelerationStructureCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pAccelerationStructure: *mut AccelerationStructureKHR,
    ) -> Result,
    DestroyAccelerationStructureKHR => (
        device: Device,
        accelerationStructure: AccelerationStructureKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CmdBuildAccelerationStructuresKHR => (
        commandBuffer: CommandBuffer,
        infoCount: u32,
        pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const AccelerationStructureBuildRangeInfoKHR,
    ) -> (),
    CmdBuildAccelerationStructuresIndirectKHR => (
        commandBuffer: CommandBuffer,
        infoCount: u32,
        pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
        pIndirectDeviceAddresses: *const DeviceAddress,
        pIndirectStrides: *const u32,
        ppMaxPrimitiveCounts: *const *const u32,
    ) -> (),
    BuildAccelerationStructuresKHR => (
        device: Device,
        deferredOperation: DeferredOperationKHR,
        infoCount: u32,
        pInfos: *const AccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const AccelerationStructureBuildRangeInfoKHR,
    ) -> Result,
    CopyAccelerationStructureKHR => (
        device: Device,
        deferredOperation: DeferredOperationKHR,
        pInfo: *const CopyAccelerationStructureInfoKHR,
    ) -> Result,
    CopyAccelerationStructureToMemoryKHR => (
        device: Device,
        deferredOperation: DeferredOperationKHR,
        pInfo: *const CopyAccelerationStructureToMemoryInfoKHR,
    ) -> Result,
    CopyMemoryToAccelerationStructureKHR => (
        device: Device,
        deferredOperation: DeferredOperationKHR,
        pInfo: *const CopyMemoryToAccelerationStructureInfoKHR,
    ) -> Result,
    WriteAccelerationStructuresPropertiesKHR => (
        device: Device,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const AccelerationStructureKHR,
        queryType: QueryType,
        dataSize: usize,
        pData: *mut c_void,
        stride: usize,
    ) -> Result,
    CmdCopyAccelerationStructureKHR => (
        commandBuffer: CommandBuffer,
        pInfo: *const CopyAccelerationStructureInfoKHR,
    ) -> (),
    CmdCopyAccelerationStructureToMemoryKHR => (
        commandBuffer: CommandBuffer,
        pInfo: *const CopyAccelerationStructureToMemoryInfoKHR,
    ) -> (),
    CmdCopyMemoryToAccelerationStructureKHR => (
        commandBuffer: CommandBuffer,
        pInfo: *const CopyMemoryToAccelerationStructureInfoKHR,
    ) -> (),
    GetAccelerationStructureDeviceAddressKHR => (
        device: Device,
        pInfo: *const AccelerationStructureDeviceAddressInfoKHR,
    ) -> DeviceAddress,
    CmdWriteAccelerationStructuresPropertiesKHR => (
        commandBuffer: CommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const AccelerationStructureKHR,
        queryType: QueryType,
        queryPool: QueryPool,
        firstQuery: u32,
    ) -> (),
    GetDeviceAccelerationStructureCompatibilityKHR => (
        device: Device,
        pVersionInfo: *const AccelerationStructureVersionInfoKHR,
        pCompatibility: *mut AccelerationStructureCompatibilityKHR,
    ) -> (),
    GetAccelerationStructureBuildSizesKHR => (
        device: Device,
        buildType: AccelerationStructureBuildTypeKHR,
        pBuildInfo: *const AccelerationStructureBuildGeometryInfoKHR,
        pMaxPrimitiveCounts: *const u32,
        pSizeInfo: *mut AccelerationStructureBuildSizesInfoKHR,
    ) -> (),
    CmdTraceRaysKHR => (
        commandBuffer: CommandBuffer,
        pRaygenShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        width: u32,
        height: u32,
        depth: u32,
    ) -> (),
    CreateRayTracingPipelinesKHR => (
        device: Device,
        deferredOperation: DeferredOperationKHR,
        pipelineCache: PipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const RayTracingPipelineCreateInfoKHR,
        pAllocator: *const AllocationCallbacks,
        pPipelines: *mut Pipeline,
    ) -> Result,
    GetRayTracingShaderGroupHandlesKHR => (
        device: Device,
        pipeline: Pipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: usize,
        pData: *mut c_void,
    ) -> Result,
    GetRayTracingCaptureReplayShaderGroupHandlesKHR => (
        device: Device,
        pipeline: Pipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: usize,
        pData: *mut c_void,
    ) -> Result,
    CmdTraceRaysIndirectKHR => (
        commandBuffer: CommandBuffer,
        pRaygenShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const StridedDeviceAddressRegionKHR,
        indirectDeviceAddress: DeviceAddress,
    ) -> (),
    GetRayTracingShaderGroupStackSizeKHR => (
        device: Device,
        pipeline: Pipeline,
        group: u32,
        groupShader: ShaderGroupShaderKHR,
    ) -> DeviceSize,
    CmdSetRayTracingPipelineStackSizeKHR => (
        commandBuffer: CommandBuffer,
        pipelineStackSize: u32,
    ) -> (),
    CreateSamplerYcbcrConversionKHR => (
        device: Device,
        pCreateInfo: *const SamplerYcbcrConversionCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pYcbcrConversion: *mut SamplerYcbcrConversion,
    ) -> Result,
    DestroySamplerYcbcrConversionKHR => (
        device: Device,
        ycbcrConversion: SamplerYcbcrConversion,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    BindBufferMemory2KHR => (
        device: Device,
        bindInfoCount: u32,
        pBindInfos: *const BindBufferMemoryInfo,
    ) -> Result,
    BindImageMemory2KHR => (
        device: Device,
        bindInfoCount: u32,
        pBindInfos: *const BindImageMemoryInfo,
    ) -> Result,
    GetImageDrmFormatModifierPropertiesEXT => (
        device: Device,
        image: Image,
        pProperties: *mut ImageDrmFormatModifierPropertiesEXT,
    ) -> Result,
    CreateValidationCacheEXT => (
        device: Device,
        pCreateInfo: *const ValidationCacheCreateInfoEXT,
        pAllocator: *const AllocationCallbacks,
        pValidationCache: *mut ValidationCacheEXT,
    ) -> Result,
    DestroyValidationCacheEXT => (
        device: Device,
        validationCache: ValidationCacheEXT,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    MergeValidationCachesEXT => (
        device: Device,
        dstCache: ValidationCacheEXT,
        srcCacheCount: u32,
        pSrcCaches: *const ValidationCacheEXT,
    ) -> Result,
    GetValidationCacheDataEXT => (
        device: Device,
        validationCache: ValidationCacheEXT,
        pDataSize: *mut usize,
        pData: *mut c_void,
    ) -> Result,
    CmdBindShadingRateImageNV => (
        commandBuffer: CommandBuffer,
        imageView: ImageView,
        imageLayout: ImageLayout,
    ) -> (),
    CmdSetViewportShadingRatePaletteNV => (
        commandBuffer: CommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pShadingRatePalettes: *const ShadingRatePaletteNV,
    ) -> (),
    CmdSetCoarseSampleOrderNV => (
        commandBuffer: CommandBuffer,
        sampleOrderType: CoarseSampleOrderTypeNV,
        customSampleOrderCount: u32,
        pCustomSampleOrders: *const CoarseSampleOrderCustomNV,
    ) -> (),
    CreateAccelerationStructureNV => (
        device: Device,
        pCreateInfo: *const AccelerationStructureCreateInfoNV,
        pAllocator: *const AllocationCallbacks,
        pAccelerationStructure: *mut AccelerationStructureNV,
    ) -> Result,
    DestroyAccelerationStructureNV => (
        device: Device,
        accelerationStructure: AccelerationStructureNV,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetAccelerationStructureMemoryRequirementsNV => (
        device: Device,
        pInfo: *const AccelerationStructureMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut MemoryRequirements2KHR,
    ) -> (),
    BindAccelerationStructureMemoryNV => (
        device: Device,
        bindInfoCount: u32,
        pBindInfos: *const BindAccelerationStructureMemoryInfoNV,
    ) -> Result,
    CmdBuildAccelerationStructureNV => (
        commandBuffer: CommandBuffer,
        pInfo: *const AccelerationStructureInfoNV,
        instanceData: Buffer,
        instanceOffset: DeviceSize,
        update: Bool32,
        dst: AccelerationStructureNV,
        src: AccelerationStructureNV,
        scratch: Buffer,
        scratchOffset: DeviceSize,
    ) -> (),
    CmdCopyAccelerationStructureNV => (
        commandBuffer: CommandBuffer,
        dst: AccelerationStructureNV,
        src: AccelerationStructureNV,
        mode: CopyAccelerationStructureModeKHR,
    ) -> (),
    CmdTraceRaysNV => (
        commandBuffer: CommandBuffer,
        raygenShaderBindingTableBuffer: Buffer,
        raygenShaderBindingOffset: DeviceSize,
        missShaderBindingTableBuffer: Buffer,
        missShaderBindingOffset: DeviceSize,
        missShaderBindingStride: DeviceSize,
        hitShaderBindingTableBuffer: Buffer,
        hitShaderBindingOffset: DeviceSize,
        hitShaderBindingStride: DeviceSize,
        callableShaderBindingTableBuffer: Buffer,
        callableShaderBindingOffset: DeviceSize,
        callableShaderBindingStride: DeviceSize,
        width: u32,
        height: u32,
        depth: u32,
    ) -> (),
    CreateRayTracingPipelinesNV => (
        device: Device,
        pipelineCache: PipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const RayTracingPipelineCreateInfoNV,
        pAllocator: *const AllocationCallbacks,
        pPipelines: *mut Pipeline,
    ) -> Result,
    GetRayTracingShaderGroupHandlesNV => (
        device: Device,
        pipeline: Pipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: usize,
        pData: *mut c_void,
    ) -> Result,
    GetAccelerationStructureHandleNV => (
        device: Device,
        accelerationStructure: AccelerationStructureNV,
        dataSize: usize,
        pData: *mut c_void,
    ) -> Result,
    CmdWriteAccelerationStructuresPropertiesNV => (
        commandBuffer: CommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const AccelerationStructureNV,
        queryType: QueryType,
        queryPool: QueryPool,
        firstQuery: u32,
    ) -> (),
    CompileDeferredNV => (
        device: Device,
        pipeline: Pipeline,
        shader: u32,
    ) -> Result,
    GetDescriptorSetLayoutSupportKHR => (
        device: Device,
        pCreateInfo: *const DescriptorSetLayoutCreateInfo,
        pSupport: *mut DescriptorSetLayoutSupport,
    ) -> (),
    CmdDrawIndirectCountKHR => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    CmdDrawIndexedIndirectCountKHR => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    GetMemoryHostPointerPropertiesEXT => (
        device: Device,
        handleType: ExternalMemoryHandleTypeFlagBits,
        pHostPointer: *const c_void,
        pMemoryHostPointerProperties: *mut MemoryHostPointerPropertiesEXT,
    ) -> Result,
    CmdWriteBufferMarkerAMD => (
        commandBuffer: CommandBuffer,
        pipelineStage: PipelineStageFlagBits,
        dstBuffer: Buffer,
        dstOffset: DeviceSize,
        marker: u32,
    ) -> (),
    GetCalibratedTimestampsEXT => (
        device: Device,
        timestampCount: u32,
        pTimestampInfos: *const CalibratedTimestampInfoEXT,
        pTimestamps: *mut u64,
        pMaxDeviation: *mut u64,
    ) -> Result,
    CmdDrawMeshTasksNV => (
        commandBuffer: CommandBuffer,
        taskCount: u32,
        firstTask: u32,
    ) -> (),
    CmdDrawMeshTasksIndirectNV => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        drawCount: u32,
        stride: u32,
    ) -> (),
    CmdDrawMeshTasksIndirectCountNV => (
        commandBuffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        countBuffer: Buffer,
        countBufferOffset: DeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ) -> (),
    CmdSetExclusiveScissorNV => (
        commandBuffer: CommandBuffer,
        firstExclusiveScissor: u32,
        exclusiveScissorCount: u32,
        pExclusiveScissors: *const Rect2D,
    ) -> (),
    CmdSetCheckpointNV => (
        commandBuffer: CommandBuffer,
        pCheckpointMarker: *const c_void,
    ) -> (),
    GetQueueCheckpointDataNV => (
        queue: Queue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut CheckpointDataNV,
    ) -> (),
    GetSemaphoreCounterValueKHR => (
        device: Device,
        semaphore: Semaphore,
        pValue: *mut u64,
    ) -> Result,
    WaitSemaphoresKHR => (
        device: Device,
        pWaitInfo: *const SemaphoreWaitInfo,
        timeout: u64,
    ) -> Result,
    SignalSemaphoreKHR => (
        device: Device,
        pSignalInfo: *const SemaphoreSignalInfo,
    ) -> Result,
    InitializePerformanceApiINTEL => (
        device: Device,
        pInitializeInfo: *const InitializePerformanceApiInfoINTEL,
    ) -> Result,
    UninitializePerformanceApiINTEL => (
        device: Device,
    ) -> (),
    CmdSetPerformanceMarkerINTEL => (
        commandBuffer: CommandBuffer,
        pMarkerInfo: *const PerformanceMarkerInfoINTEL,
    ) -> Result,
    CmdSetPerformanceStreamMarkerINTEL => (
        commandBuffer: CommandBuffer,
        pMarkerInfo: *const PerformanceStreamMarkerInfoINTEL,
    ) -> Result,
    CmdSetPerformanceOverrideINTEL => (
        commandBuffer: CommandBuffer,
        pOverrideInfo: *const PerformanceOverrideInfoINTEL,
    ) -> Result,
    AcquirePerformanceConfigurationINTEL => (
        device: Device,
        pAcquireInfo: *const PerformanceConfigurationAcquireInfoINTEL,
        pConfiguration: *mut PerformanceConfigurationINTEL,
    ) -> Result,
    ReleasePerformanceConfigurationINTEL => (
        device: Device,
        configuration: PerformanceConfigurationINTEL,
    ) -> Result,
    QueueSetPerformanceConfigurationINTEL => (
        queue: Queue,
        configuration: PerformanceConfigurationINTEL,
    ) -> Result,
    GetPerformanceParameterINTEL => (
        device: Device,
        parameter: PerformanceParameterTypeINTEL,
        pValue: *mut PerformanceValueINTEL,
    ) -> Result,
    SetLocalDimmingAMD => (
        device: Device,
        swapChain: SwapchainKHR,
        localDimmingEnable: Bool32,
    ) -> (),
    CmdSetFragmentShadingRateKHR => (
        commandBuffer: CommandBuffer,
        pFragmentSize: *const Extent2D,
        combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
    ) -> (),
    GetBufferDeviceAddressEXT => (
        device: Device,
        pInfo: *const BufferDeviceAddressInfo,
    ) -> DeviceAddress,
    WaitForPresentKHR => (
        device: Device,
        swapchain: SwapchainKHR,
        presentId: u64,
        timeout: u64,
    ) -> Result,
    GetBufferDeviceAddressKHR => (
        device: Device,
        pInfo: *const BufferDeviceAddressInfo,
    ) -> DeviceAddress,
    GetBufferOpaqueCaptureAddressKHR => (
        device: Device,
        pInfo: *const BufferDeviceAddressInfo,
    ) -> u64,
    GetDeviceMemoryOpaqueCaptureAddressKHR => (
        device: Device,
        pInfo: *const DeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64,
    CmdSetLineStippleEXT => (
        commandBuffer: CommandBuffer,
        lineStippleFactor: u32,
        lineStipplePattern: u16,
    ) -> (),
    ResetQueryPoolEXT => (
        device: Device,
        queryPool: QueryPool,
        firstQuery: u32,
        queryCount: u32,
    ) -> (),
    CmdSetCullModeEXT => (
        commandBuffer: CommandBuffer,
        cullMode: CullModeFlags,
    ) -> (),
    CmdSetFrontFaceEXT => (
        commandBuffer: CommandBuffer,
        frontFace: FrontFace,
    ) -> (),
    CmdSetPrimitiveTopologyEXT => (
        commandBuffer: CommandBuffer,
        primitiveTopology: PrimitiveTopology,
    ) -> (),
    CmdSetViewportWithCountEXT => (
        commandBuffer: CommandBuffer,
        viewportCount: u32,
        pViewports: *const Viewport,
    ) -> (),
    CmdSetScissorWithCountEXT => (
        commandBuffer: CommandBuffer,
        scissorCount: u32,
        pScissors: *const Rect2D,
    ) -> (),
    CmdBindVertexBuffers2EXT => (
        commandBuffer: CommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const Buffer,
        pOffsets: *const DeviceSize,
        pSizes: *const DeviceSize,
        pStrides: *const DeviceSize,
    ) -> (),
    CmdSetDepthTestEnableEXT => (
        commandBuffer: CommandBuffer,
        depthTestEnable: Bool32,
    ) -> (),
    CmdSetDepthWriteEnableEXT => (
        commandBuffer: CommandBuffer,
        depthWriteEnable: Bool32,
    ) -> (),
    CmdSetDepthCompareOpEXT => (
        commandBuffer: CommandBuffer,
        depthCompareOp: CompareOp,
    ) -> (),
    CmdSetDepthBoundsTestEnableEXT => (
        commandBuffer: CommandBuffer,
        depthBoundsTestEnable: Bool32,
    ) -> (),
    CmdSetStencilTestEnableEXT => (
        commandBuffer: CommandBuffer,
        stencilTestEnable: Bool32,
    ) -> (),
    CmdSetStencilOpEXT => (
        commandBuffer: CommandBuffer,
        faceMask: StencilFaceFlags,
        failOp: StencilOp,
        passOp: StencilOp,
        depthFailOp: StencilOp,
        compareOp: CompareOp,
    ) -> (),
    CreateDeferredOperationKHR => (
        device: Device,
        pAllocator: *const AllocationCallbacks,
        pDeferredOperation: *mut DeferredOperationKHR,
    ) -> Result,
    DestroyDeferredOperationKHR => (
        device: Device,
        operation: DeferredOperationKHR,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    GetDeferredOperationMaxConcurrencyKHR => (
        device: Device,
        operation: DeferredOperationKHR,
    ) -> u32,
    GetDeferredOperationResultKHR => (
        device: Device,
        operation: DeferredOperationKHR,
    ) -> Result,
    DeferredOperationJoinKHR => (
        device: Device,
        operation: DeferredOperationKHR,
    ) -> Result,
    GetPipelineExecutablePropertiesKHR => (
        device: Device,
        pPipelineInfo: *const PipelineInfoKHR,
        pExecutableCount: *mut u32,
        pProperties: *mut PipelineExecutablePropertiesKHR,
    ) -> Result,
    GetPipelineExecutableStatisticsKHR => (
        device: Device,
        pExecutableInfo: *const PipelineExecutableInfoKHR,
        pStatisticCount: *mut u32,
        pStatistics: *mut PipelineExecutableStatisticKHR,
    ) -> Result,
    GetPipelineExecutableInternalRepresentationsKHR => (
        device: Device,
        pExecutableInfo: *const PipelineExecutableInfoKHR,
        pInternalRepresentationCount: *mut u32,
        pInternalRepresentations: *mut PipelineExecutableInternalRepresentationKHR,
    ) -> Result,
    GetGeneratedCommandsMemoryRequirementsNV => (
        device: Device,
        pInfo: *const GeneratedCommandsMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    CmdPreprocessGeneratedCommandsNV => (
        commandBuffer: CommandBuffer,
        pGeneratedCommandsInfo: *const GeneratedCommandsInfoNV,
    ) -> (),
    CmdExecuteGeneratedCommandsNV => (
        commandBuffer: CommandBuffer,
        isPreprocessed: Bool32,
        pGeneratedCommandsInfo: *const GeneratedCommandsInfoNV,
    ) -> (),
    CmdBindPipelineShaderGroupNV => (
        commandBuffer: CommandBuffer,
        pipelineBindPoint: PipelineBindPoint,
        pipeline: Pipeline,
        groupIndex: u32,
    ) -> (),
    CreateIndirectCommandsLayoutNV => (
        device: Device,
        pCreateInfo: *const IndirectCommandsLayoutCreateInfoNV,
        pAllocator: *const AllocationCallbacks,
        pIndirectCommandsLayout: *mut IndirectCommandsLayoutNV,
    ) -> Result,
    DestroyIndirectCommandsLayoutNV => (
        device: Device,
        indirectCommandsLayout: IndirectCommandsLayoutNV,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    CreatePrivateDataSlotEXT => (
        device: Device,
        pCreateInfo: *const PrivateDataSlotCreateInfo,
        pAllocator: *const AllocationCallbacks,
        pPrivateDataSlot: *mut PrivateDataSlot,
    ) -> Result,
    DestroyPrivateDataSlotEXT => (
        device: Device,
        privateDataSlot: PrivateDataSlot,
        pAllocator: *const AllocationCallbacks,
    ) -> (),
    SetPrivateDataEXT => (
        device: Device,
        objectType: ObjectType,
        objectHandle: u64,
        privateDataSlot: PrivateDataSlot,
        data: u64,
    ) -> Result,
    GetPrivateDataEXT => (
        device: Device,
        objectType: ObjectType,
        objectHandle: u64,
        privateDataSlot: PrivateDataSlot,
        pData: *mut u64,
    ) -> (),
    CmdEncodeVideoKHR => (
        commandBuffer: CommandBuffer,
        pEncodeInfo: *const VideoEncodeInfoKHR,
    ) -> (),
    CmdSetEvent2KHR => (
        commandBuffer: CommandBuffer,
        event: Event,
        pDependencyInfo: *const DependencyInfo,
    ) -> (),
    CmdResetEvent2KHR => (
        commandBuffer: CommandBuffer,
        event: Event,
        stageMask: PipelineStageFlags2,
    ) -> (),
    CmdWaitEvents2KHR => (
        commandBuffer: CommandBuffer,
        eventCount: u32,
        pEvents: *const Event,
        pDependencyInfos: *const DependencyInfo,
    ) -> (),
    CmdPipelineBarrier2KHR => (
        commandBuffer: CommandBuffer,
        pDependencyInfo: *const DependencyInfo,
    ) -> (),
    CmdWriteTimestamp2KHR => (
        commandBuffer: CommandBuffer,
        stage: PipelineStageFlags2,
        queryPool: QueryPool,
        query: u32,
    ) -> (),
    QueueSubmit2KHR => (
        queue: Queue,
        submitCount: u32,
        pSubmits: *const SubmitInfo2,
        fence: Fence,
    ) -> Result,
    CmdWriteBufferMarker2AMD => (
        commandBuffer: CommandBuffer,
        stage: PipelineStageFlags2,
        dstBuffer: Buffer,
        dstOffset: DeviceSize,
        marker: u32,
    ) -> (),
    GetQueueCheckpointData2NV => (
        queue: Queue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut CheckpointData2NV,
    ) -> (),
    CmdSetFragmentShadingRateEnumNV => (
        commandBuffer: CommandBuffer,
        shadingRate: FragmentShadingRateNV,
        combinerOps: [FragmentShadingRateCombinerOpKHR; 2],
    ) -> (),
    CmdCopyBuffer2KHR => (
        commandBuffer: CommandBuffer,
        pCopyBufferInfo: *const CopyBufferInfo2,
    ) -> (),
    CmdCopyImage2KHR => (
        commandBuffer: CommandBuffer,
        pCopyImageInfo: *const CopyImageInfo2,
    ) -> (),
    CmdCopyBufferToImage2KHR => (
        commandBuffer: CommandBuffer,
        pCopyBufferToImageInfo: *const CopyBufferToImageInfo2,
    ) -> (),
    CmdCopyImageToBuffer2KHR => (
        commandBuffer: CommandBuffer,
        pCopyImageToBufferInfo: *const CopyImageToBufferInfo2,
    ) -> (),
    CmdBlitImage2KHR => (
        commandBuffer: CommandBuffer,
        pBlitImageInfo: *const BlitImageInfo2,
    ) -> (),
    CmdResolveImage2KHR => (
        commandBuffer: CommandBuffer,
        pResolveImageInfo: *const ResolveImageInfo2,
    ) -> (),
    CmdSetVertexInputEXT => (
        commandBuffer: CommandBuffer,
        vertexBindingDescriptionCount: u32,
        pVertexBindingDescriptions: *const VertexInputBindingDescription2EXT,
        vertexAttributeDescriptionCount: u32,
        pVertexAttributeDescriptions: *const VertexInputAttributeDescription2EXT,
    ) -> (),
    GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI => (
        device: Device,
        renderpass: RenderPass,
        pMaxWorkgroupSize: *mut Extent2D,
    ) -> Result,
    CmdSubpassShadingHUAWEI => (
        commandBuffer: CommandBuffer,
    ) -> (),
    CmdBindInvocationMaskHUAWEI => (
        commandBuffer: CommandBuffer,
        imageView: ImageView,
        imageLayout: ImageLayout,
    ) -> (),
    GetMemoryRemoteAddressNV => (
        device: Device,
        pMemoryGetRemoteAddressInfo: *const MemoryGetRemoteAddressInfoNV,
        pAddress: *mut RemoteAddressNV,
    ) -> Result,
    CmdSetPatchControlPointsEXT => (
        commandBuffer: CommandBuffer,
        patchControlPoints: u32,
    ) -> (),
    CmdSetRasterizerDiscardEnableEXT => (
        commandBuffer: CommandBuffer,
        rasterizerDiscardEnable: Bool32,
    ) -> (),
    CmdSetDepthBiasEnableEXT => (
        commandBuffer: CommandBuffer,
        depthBiasEnable: Bool32,
    ) -> (),
    CmdSetLogicOpEXT => (
        commandBuffer: CommandBuffer,
        logicOp: LogicOp,
    ) -> (),
    CmdSetPrimitiveRestartEnableEXT => (
        commandBuffer: CommandBuffer,
        primitiveRestartEnable: Bool32,
    ) -> (),
    CmdSetColorWriteEnableEXT => (
        commandBuffer: CommandBuffer,
        attachmentCount: u32,
        pColorWriteEnables: *const Bool32,
    ) -> (),
    CmdDrawMultiEXT => (
        commandBuffer: CommandBuffer,
        drawCount: u32,
        pVertexInfo: *const MultiDrawInfoEXT,
        instanceCount: u32,
        firstInstance: u32,
        stride: u32,
    ) -> (),
    CmdDrawMultiIndexedEXT => (
        commandBuffer: CommandBuffer,
        drawCount: u32,
        pIndexInfo: *const MultiDrawIndexedInfoEXT,
        instanceCount: u32,
        firstInstance: u32,
        stride: u32,
        pVertexOffset: *const i32,
    ) -> (),
    SetDeviceMemoryPriorityEXT => (
        device: Device,
        memory: DeviceMemory,
        priority: f32,
    ) -> (),
    GetDeviceBufferMemoryRequirementsKHR => (
        device: Device,
        pInfo: *const DeviceBufferMemoryRequirements,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetDeviceImageMemoryRequirementsKHR => (
        device: Device,
        pInfo: *const DeviceImageMemoryRequirements,
        pMemoryRequirements: *mut MemoryRequirements2,
    ) -> (),
    GetDeviceImageSparseMemoryRequirementsKHR => (
        device: Device,
        pInfo: *const DeviceImageMemoryRequirements,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut SparseImageMemoryRequirements2,
    ) -> (),
    GetDescriptorSetLayoutHostMappingInfoVALVE => (
        device: Device,
        pBindingReference: *const DescriptorSetBindingReferenceVALVE,
        pHostMapping: *mut DescriptorSetLayoutHostMappingInfoVALVE,
    ) -> (),
    GetDescriptorSetHostMappingVALVE => (
        device: Device,
        descriptorSet: DescriptorSet,
        ppData: *mut *mut c_void,
    ) -> (),
});

