#pragma clang diagnostic ignored "-Wmissing-prototypes"
#pragma clang diagnostic ignored "-Wmissing-braces"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

template<typename T, size_t Num>
struct spvUnsafeArray
{
    T elements[Num ? Num : 1];
    
    thread T& operator [] (size_t pos) thread
    {
        return elements[pos];
    }
    constexpr const thread T& operator [] (size_t pos) const thread
    {
        return elements[pos];
    }
    
    device T& operator [] (size_t pos) device
    {
        return elements[pos];
    }
    constexpr const device T& operator [] (size_t pos) const device
    {
        return elements[pos];
    }
    
    constexpr const constant T& operator [] (size_t pos) const constant
    {
        return elements[pos];
    }
    
    threadgroup T& operator [] (size_t pos) threadgroup
    {
        return elements[pos];
    }
    constexpr const threadgroup T& operator [] (size_t pos) const threadgroup
    {
        return elements[pos];
    }
};

struct type_Globals
{
    float4 MappingPolynomial;
    float3 InverseGamma;
    float4 ColorMatrixR_ColorCurveCd1;
    float4 ColorMatrixG_ColorCurveCd3Cm3;
    float4 ColorMatrixB_ColorCurveCm2;
    float4 ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3;
    float4 ColorCurve_Ch1_Ch2;
    float4 ColorShadow_Luma;
    float4 ColorShadow_Tint1;
    float4 ColorShadow_Tint2;
    float FilmSlope;
    float FilmToe;
    float FilmShoulder;
    float FilmBlackClip;
    float FilmWhiteClip;
    float4 LUTWeights[5];
    float3 ColorScale;
    float4 OverlayColor;
    float WhiteTemp;
    float WhiteTint;
    float4 ColorSaturation;
    float4 ColorContrast;
    float4 ColorGamma;
    float4 ColorGain;
    float4 ColorOffset;
    float4 ColorSaturationShadows;
    float4 ColorContrastShadows;
    float4 ColorGammaShadows;
    float4 ColorGainShadows;
    float4 ColorOffsetShadows;
    float4 ColorSaturationMidtones;
    float4 ColorContrastMidtones;
    float4 ColorGammaMidtones;
    float4 ColorGainMidtones;
    float4 ColorOffsetMidtones;
    float4 ColorSaturationHighlights;
    float4 ColorContrastHighlights;
    float4 ColorGammaHighlights;
    float4 ColorGainHighlights;
    float4 ColorOffsetHighlights;
    float ColorCorrectionShadowsMax;
    float ColorCorrectionHighlightsMin;
    uint OutputDevice;
    uint OutputGamut;
    float BlueCorrection;
    float ExpandGamut;
};

constant spvUnsafeArray<float, 6> _499 = spvUnsafeArray<float, 6>({ -4.0, -4.0, -3.1573765277862548828125, -0.485249996185302734375, 1.84773242473602294921875, 1.84773242473602294921875 });
constant spvUnsafeArray<float, 6> _500 = spvUnsafeArray<float, 6>({ -0.718548238277435302734375, 2.0810306072235107421875, 3.66812419891357421875, 4.0, 4.0, 4.0 });
constant spvUnsafeArray<float, 10> _503 = spvUnsafeArray<float, 10>({ -4.97062206268310546875, -3.0293781757354736328125, -2.1261999607086181640625, -1.5104999542236328125, -1.0578000545501708984375, -0.4668000042438507080078125, 0.11937999725341796875, 0.7088134288787841796875, 1.2911865711212158203125, 1.2911865711212158203125 });
constant spvUnsafeArray<float, 10> _504 = spvUnsafeArray<float, 10>({ 0.80891323089599609375, 1.19108676910400390625, 1.5683000087738037109375, 1.94830000400543212890625, 2.308300018310546875, 2.63840007781982421875, 2.85949993133544921875, 2.9872608184814453125, 3.0127391815185546875, 3.0127391815185546875 });
constant spvUnsafeArray<float, 10> _506 = spvUnsafeArray<float, 10>({ -2.3010299205780029296875, -2.3010299205780029296875, -1.9312000274658203125, -1.5204999446868896484375, -1.0578000545501708984375, -0.4668000042438507080078125, 0.11937999725341796875, 0.7088134288787841796875, 1.2911865711212158203125, 1.2911865711212158203125 });
constant spvUnsafeArray<float, 10> _507 = spvUnsafeArray<float, 10>({ 0.801995217800140380859375, 1.19800484180450439453125, 1.5943000316619873046875, 1.99730002880096435546875, 2.3782999515533447265625, 2.7683999538421630859375, 3.0515000820159912109375, 3.2746293544769287109375, 3.32743072509765625, 3.32743072509765625 });

constant float3 _523 = {};
constant float3 _525 = {};

struct main0_out
{
    float4 out_var_SV_Target0 [[color(0)]];
};

struct main0_in
{
    float2 in_var_TEXCOORD0 [[user(locn0), center_no_perspective]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant type_Globals& _Globals [[buffer(0)]], texture2d<float> Texture1 [[texture(0)]], sampler Texture1Sampler [[sampler(0)]], uint gl_Layer [[render_target_array_index]])
{
    main0_out out = {};
    float3x3 _572 = float3x3(float3(0.41245639324188232421875, 0.3575761020183563232421875, 0.180437505245208740234375), float3(0.21267290413379669189453125, 0.715152204036712646484375, 0.072175003588199615478515625), float3(0.01933390088379383087158203125, 0.119191996753215789794921875, 0.950304090976715087890625)) * float3x3(float3(1.01303005218505859375, 0.0061053098179399967193603515625, -0.014971000142395496368408203125), float3(0.0076982299797236919403076171875, 0.99816501140594482421875, -0.005032029934227466583251953125), float3(-0.0028413101099431514739990234375, 0.0046851597726345062255859375, 0.92450702190399169921875));
    float3x3 _573 = _572 * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125));
    float3x3 _574 = float3x3(float3(0.662454187870025634765625, 0.1340042054653167724609375, 0.1561876833438873291015625), float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625), float3(-0.0055746496655046939849853515625, 0.0040607335977256298065185546875, 1.01033914089202880859375)) * float3x3(float3(0.98722398281097412109375, -0.0061132698319852352142333984375, 0.01595330052077770233154296875), float3(-0.007598360069096088409423828125, 1.00186002254486083984375, 0.0053300200961530208587646484375), float3(0.003072570078074932098388671875, -0.0050959498621523380279541015625, 1.0816800594329833984375));
    float3x3 _575 = _574 * float3x3(float3(3.2409698963165283203125, -1.53738319873809814453125, -0.4986107647418975830078125), float3(-0.96924364566802978515625, 1.875967502593994140625, 0.0415550582110881805419921875), float3(0.055630080401897430419921875, -0.2039769589900970458984375, 1.05697154998779296875));
    float3x3 _576 = float3x3(float3(0.952552378177642822265625, 0.0, 9.25), float3(0.3439664542675018310546875, 0.728166103363037109375, -0.07213254272937774658203125), float3(0.0, 0.0, 1.00882518291473388671875)) * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125));
    float3x3 _577 = float3x3(float3(0.662454187870025634765625, 0.1340042054653167724609375, 0.1561876833438873291015625), float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625), float3(-0.0055746496655046939849853515625, 0.0040607335977256298065185546875, 1.01033914089202880859375)) * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625));
    float3x3 _602;
    for (;;)
    {
        if (_Globals.OutputGamut == 1u)
        {
            _602 = _574 * float3x3(float3(2.493396282196044921875, -0.931345880031585693359375, -0.4026944935321807861328125), float3(-0.829486787319183349609375, 1.76265966892242431640625, 0.02362460084259510040283203125), float3(0.0358506999909877777099609375, -0.076182700693607330322265625, 0.957014024257659912109375));
            break;
        }
        else
        {
            if (_Globals.OutputGamut == 2u)
            {
                _602 = _574 * float3x3(float3(1.71660840511322021484375, -0.3556621074676513671875, -0.253360092639923095703125), float3(-0.666682898998260498046875, 1.61647760868072509765625, 0.01576850004494190216064453125), float3(0.017642199993133544921875, -0.04277630150318145751953125, 0.94222867488861083984375));
                break;
            }
            else
            {
                if (_Globals.OutputGamut == 3u)
                {
                    _602 = float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625));
                    break;
                }
                else
                {
                    if (_Globals.OutputGamut == 4u)
                    {
                        _602 = float3x3(float3(1.0, 0.0, 0.0), float3(0.0, 1.0, 0.0), float3(0.0, 0.0, 1.0));
                        break;
                    }
                    else
                    {
                        _602 = _575;
                        break;
                    }
                }
            }
        }
    }
    float3 _603 = float4((in.in_var_TEXCOORD0 - float2(0.015625)) * float2(1.03225803375244140625), float(gl_Layer) * 0.0322580635547637939453125, 0.0).xyz;
    float3 _625;
    if (_Globals.OutputDevice >= 3u)
    {
        float3 _617 = pow(_603, float3(0.0126833133399486541748046875));
        _625 = pow(fast::max(float3(0.0), _617 - float3(0.8359375)) / (float3(18.8515625) - (float3(18.6875) * _617)), float3(6.277394771575927734375)) * float3(10000.0);
    }
    else
    {
        _625 = (exp2((_603 - float3(0.434017598628997802734375)) * float3(14.0)) * float3(0.180000007152557373046875)) - (exp2(float3(-6.0762462615966796875)) * float3(0.180000007152557373046875));
    }
    float _628 = _Globals.WhiteTemp * 1.00055634975433349609375;
    float _642 = (_628 <= 7000.0) ? (0.24406300485134124755859375 + ((99.1100006103515625 + ((2967800.0 - (4604438528.0 / _Globals.WhiteTemp)) / _628)) / _628)) : (0.23703999817371368408203125 + ((247.4799957275390625 + ((1901800.0 - (2005284352.0 / _Globals.WhiteTemp)) / _628)) / _628));
    float _659 = ((0.860117733478546142578125 + (0.00015411825734190642833709716796875 * _Globals.WhiteTemp)) + ((1.2864121856637211749330163002014e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp)) / ((1.0 + (0.0008424202096648514270782470703125 * _Globals.WhiteTemp)) + ((7.0814513719597016461193561553955e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp));
    float _670 = ((0.317398726940155029296875 + (4.25 * _Globals.WhiteTemp)) + ((4.2048167614439080352894961833954e-08 * _Globals.WhiteTemp) * _Globals.WhiteTemp)) / ((1.0 - (2.8974181986995972692966461181641e-05 * _Globals.WhiteTemp)) + ((1.6145605741257895715534687042236e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp));
    float _675 = ((2.0 * _659) - (8.0 * _670)) + 4.0;
    float2 _679 = float2((3.0 * _659) / _675, (2.0 * _670) / _675);
    float2 _686 = fast::normalize(float2(_659, _670));
    float _691 = _659 + (((-_686.y) * _Globals.WhiteTint) * 0.0500000007450580596923828125);
    float _695 = _670 + ((_686.x * _Globals.WhiteTint) * 0.0500000007450580596923828125);
    float _700 = ((2.0 * _691) - (8.0 * _695)) + 4.0;
    float2 _706 = select(float2(_642, ((((-3.0) * _642) * _642) + (2.86999988555908203125 * _642)) - 0.2750000059604644775390625), _679, bool2(_Globals.WhiteTemp < 4000.0)) + (float2((3.0 * _691) / _700, (2.0 * _695) / _700) - _679);
    float _709 = fast::max(_706.y, 1.0000000133514319600180897396058e-10);
    float3 _711 = _523;
    _711.x = _706.x / _709;
    float3 _712 = _711;
    _712.y = 1.0;
    float3 _716 = _712;
    _716.z = ((1.0 - _706.x) - _706.y) / _709;
    float _717 = fast::max(0.328999996185302734375, 1.0000000133514319600180897396058e-10);
    float3 _719 = _523;
    _719.x = 0.3127000033855438232421875 / _717;
    float3 _720 = _719;
    _720.y = 1.0;
    float3 _722 = _720;
    _722.z = 0.3582999706268310546875 / _717;
    float3 _723 = _716 * float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875));
    float3 _724 = _722 * float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875));
    float3 _743 = (_625 * ((float3x3(float3(0.41245639324188232421875, 0.3575761020183563232421875, 0.180437505245208740234375), float3(0.21267290413379669189453125, 0.715152204036712646484375, 0.072175003588199615478515625), float3(0.01933390088379383087158203125, 0.119191996753215789794921875, 0.950304090976715087890625)) * ((float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875)) * float3x3(float3(_724.x / _723.x, 0.0, 0.0), float3(0.0, _724.y / _723.y, 0.0), float3(0.0, 0.0, _724.z / _723.z))) * float3x3(float3(0.986992895603179931640625, -0.14705429971218109130859375, 0.15996269881725311279296875), float3(0.4323053061962127685546875, 0.518360316753387451171875, 0.049291200935840606689453125), float3(-0.00852870009839534759521484375, 0.0400427989661693572998046875, 0.968486726284027099609375)))) * float3x3(float3(3.2409698963165283203125, -1.53738319873809814453125, -0.4986107647418975830078125), float3(-0.96924364566802978515625, 1.875967502593994140625, 0.0415550582110881805419921875), float3(0.055630080401897430419921875, -0.2039769589900970458984375, 1.05697154998779296875)))) * _573;
    float3 _771;
    if (_Globals.ColorShadow_Tint2.w != 0.0)
    {
        float _750 = dot(_743, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625));
        float3 _753 = (_743 / float3(_750)) - float3(1.0);
        _771 = mix(_743, _743 * (_575 * (float3x3(float3(0.544169127941131591796875, 0.23959259688854217529296875, 0.16669429838657379150390625), float3(0.23946559429168701171875, 0.702153027057647705078125, 0.058381401002407073974609375), float3(-0.0023439000360667705535888671875, 0.0361833982169628143310546875, 1.05521833896636962890625)) * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125)))), float3((1.0 - exp2((-4.0) * dot(_753, _753))) * (1.0 - exp2((((-4.0) * _Globals.ExpandGamut) * _750) * _750))));
    }
    else
    {
        _771 = _743;
    }
    float _772 = dot(_771, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625));
    float4 _777 = _Globals.ColorSaturationShadows * _Globals.ColorSaturation;
    float4 _782 = _Globals.ColorContrastShadows * _Globals.ColorContrast;
    float4 _787 = _Globals.ColorGammaShadows * _Globals.ColorGamma;
    float4 _792 = _Globals.ColorGainShadows * _Globals.ColorGain;
    float4 _797 = _Globals.ColorOffsetShadows + _Globals.ColorOffset;
    float3 _798 = float3(_772);
    float _830 = smoothstep(0.0, _Globals.ColorCorrectionShadowsMax, _772);
    float4 _834 = _Globals.ColorSaturationHighlights * _Globals.ColorSaturation;
    float4 _837 = _Globals.ColorContrastHighlights * _Globals.ColorContrast;
    float4 _840 = _Globals.ColorGammaHighlights * _Globals.ColorGamma;
    float4 _843 = _Globals.ColorGainHighlights * _Globals.ColorGain;
    float4 _846 = _Globals.ColorOffsetHighlights + _Globals.ColorOffset;
    float _878 = smoothstep(_Globals.ColorCorrectionHighlightsMin, 1.0, _772);
    float4 _881 = _Globals.ColorSaturationMidtones * _Globals.ColorSaturation;
    float4 _884 = _Globals.ColorContrastMidtones * _Globals.ColorContrast;
    float4 _887 = _Globals.ColorGammaMidtones * _Globals.ColorGamma;
    float4 _890 = _Globals.ColorGainMidtones * _Globals.ColorGain;
    float4 _893 = _Globals.ColorOffsetMidtones + _Globals.ColorOffset;
    float3 _931 = ((((pow(pow(fast::max(float3(0.0), mix(_798, _771, _777.xyz * float3(_777.w))) * float3(5.5555553436279296875), _782.xyz * float3(_782.w)) * float3(0.180000007152557373046875), float3(1.0) / (_787.xyz * float3(_787.w))) * (_792.xyz * float3(_792.w))) + (_797.xyz + float3(_797.w))) * float3(1.0 - _830)) + (((pow(pow(fast::max(float3(0.0), mix(_798, _771, _881.xyz * float3(_881.w))) * float3(5.5555553436279296875), _884.xyz * float3(_884.w)) * float3(0.180000007152557373046875), float3(1.0) / (_887.xyz * float3(_887.w))) * (_890.xyz * float3(_890.w))) + (_893.xyz + float3(_893.w))) * float3(_830 - _878))) + (((pow(pow(fast::max(float3(0.0), mix(_798, _771, _834.xyz * float3(_834.w))) * float3(5.5555553436279296875), _837.xyz * float3(_837.w)) * float3(0.180000007152557373046875), float3(1.0) / (_840.xyz * float3(_840.w))) * (_843.xyz * float3(_843.w))) + (_846.xyz + float3(_846.w))) * float3(_878));
    float3 _932 = _931 * _575;
    float3 _940 = float3(_Globals.BlueCorrection);
    float3 _942 = mix(_931, _931 * ((_577 * float3x3(float3(0.940437257289886474609375, -0.01830687932670116424560546875, 0.07786960899829864501953125), float3(0.008378696627914905548095703125, 0.82866001129150390625, 0.162961304187774658203125), float3(0.0005471261101774871349334716796875, -0.00088337459601461887359619140625, 1.00033628940582275390625))) * _576), _940) * _577;
    float _943 = _942.x;
    float _944 = _942.y;
    float _946 = _942.z;
    float _949 = fast::max(fast::max(_943, _944), _946);
    float _954 = (fast::max(_949, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_943, _944), _946), 1.0000000133514319600180897396058e-10)) / fast::max(_949, 0.00999999977648258209228515625);
    float _967 = ((_946 + _944) + _943) + (1.75 * sqrt(((_946 * (_946 - _944)) + (_944 * (_944 - _943))) + (_943 * (_943 - _946))));
    float _968 = _967 * 0.3333333432674407958984375;
    float _969 = _954 - 0.4000000059604644775390625;
    float _974 = fast::max(1.0 - abs(_969 * 2.5), 0.0);
    float _982 = (1.0 + (float(int(sign(_969 * 5.0))) * (1.0 - (_974 * _974)))) * 0.02500000037252902984619140625;
    float _995;
    if (_968 <= 0.053333334624767303466796875)
    {
        _995 = _982;
    }
    else
    {
        float _994;
        if (_968 >= 0.1599999964237213134765625)
        {
            _994 = 0.0;
        }
        else
        {
            _994 = _982 * ((0.23999999463558197021484375 / _967) - 0.5);
        }
        _995 = _994;
    }
    float3 _998 = _942 * float3(1.0 + _995);
    float _999 = _998.x;
    float _1000 = _998.y;
    float _1002 = _998.z;
    float _1016;
    if ((_999 == _1000) && (_1000 == _1002))
    {
        _1016 = 0.0;
    }
    else
    {
        _1016 = 57.2957763671875 * precise::atan2(sqrt(3.0) * (_1000 - _1002), ((2.0 * _999) - _1000) - _1002);
    }
    float _1021;
    if (_1016 < 0.0)
    {
        _1021 = _1016 + 360.0;
    }
    else
    {
        _1021 = _1016;
    }
    float _1022 = fast::clamp(_1021, 0.0, 360.0);
    float _1027;
    if (_1022 > 180.0)
    {
        _1027 = _1022 - 360.0;
    }
    else
    {
        _1027 = _1022;
    }
    float _1031 = smoothstep(0.0, 1.0, 1.0 - abs(_1027 * 0.01481481455266475677490234375));
    float3 _1038 = _998;
    _1038.x = _999 + ((((_1031 * _1031) * _954) * (0.02999999932944774627685546875 - _999)) * 0.180000007152557373046875);
    float3 _1040 = fast::max(float3(0.0), _1038 * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)));
    float _1049 = (1.0 + _Globals.FilmBlackClip) - _Globals.FilmToe;
    float _1052 = 1.0 + _Globals.FilmWhiteClip;
    float _1055 = _1052 - _Globals.FilmShoulder;
    float _1082;
    if (_Globals.FilmToe > 0.800000011920928955078125)
    {
        _1082 = ((0.819999992847442626953125 - _Globals.FilmToe) / _Globals.FilmSlope) + (log(0.180000007152557373046875) / log(10.0));
    }
    else
    {
        float _1061 = (0.180000007152557373046875 + _Globals.FilmBlackClip) / _1049;
        _1082 = (log(0.180000007152557373046875) / log(10.0)) - ((0.5 * log(_1061 / (2.0 - _1061))) * (_1049 / _Globals.FilmSlope));
    }
    float _1087 = ((1.0 - _Globals.FilmToe) / _Globals.FilmSlope) - _1082;
    float _1089 = (_Globals.FilmShoulder / _Globals.FilmSlope) - _1087;
    float _1091 = log(10.0);
    float3 _1093 = log(mix(float3(dot(_1040, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1040, float3(0.959999978542327880859375))) / float3(_1091);
    float3 _1097 = float3(_Globals.FilmSlope) * (_1093 + float3(_1087));
    float3 _1105 = float3(_1082);
    float3 _1106 = _1093 - _1105;
    float3 _1118 = float3(_1089);
    float3 _1132 = fast::clamp(_1106 / float3(_1089 - _1082), float3(0.0), float3(1.0));
    float3 _1136 = select(_1132, float3(1.0) - _1132, bool3(_1089 < _1082));
    float3 _1141 = mix(select(_1097, float3(-_Globals.FilmBlackClip) + (float3(2.0 * _1049) / (float3(1.0) + exp(float3(((-2.0) * _Globals.FilmSlope) / _1049) * _1106))), _1093 < _1105), select(_1097, float3(_1052) - (float3(2.0 * _1055) / (float3(1.0) + exp(float3((2.0 * _Globals.FilmSlope) / _1055) * (_1093 - _1118)))), _1093 > _1118), ((float3(3.0) - (float3(2.0) * _1136)) * _1136) * _1136);
    float3 _1145 = fast::max(float3(0.0), mix(float3(dot(_1141, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1141, float3(0.930000007152557373046875)));
    float3 _1215;
    if (_Globals.ColorShadow_Tint2.w == 0.0)
    {
        float3 _1157 = _525;
        _1157.x = dot(_932, _Globals.ColorMatrixR_ColorCurveCd1.xyz);
        float3 _1162 = _1157;
        _1162.y = dot(_932, _Globals.ColorMatrixG_ColorCurveCd3Cm3.xyz);
        float3 _1167 = _1162;
        _1167.z = dot(_932, _Globals.ColorMatrixB_ColorCurveCm2.xyz);
        float3 _1183 = fast::max(float3(0.0), _1167 * (_Globals.ColorShadow_Tint1.xyz + (_Globals.ColorShadow_Tint2.xyz * float3(1.0 / (dot(_932, _Globals.ColorShadow_Luma.xyz) + 1.0)))));
        float3 _1188 = fast::max(float3(0.0), _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.xxx - _1183);
        float3 _1190 = fast::max(_1183, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.zzz);
        _1215 = ((((_1190 * _Globals.ColorCurve_Ch1_Ch2.xxx) + _Globals.ColorCurve_Ch1_Ch2.yyy) * (float3(1.0) / (_1190 + _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.www))) + ((fast::clamp(_1183, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.xxx, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.zzz) * _Globals.ColorMatrixB_ColorCurveCm2.www) + (((_1188 * _Globals.ColorMatrixR_ColorCurveCd1.www) * (float3(1.0) / (_1188 + _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.yyy))) + _Globals.ColorMatrixG_ColorCurveCd3Cm3.www))) - float3(0.00200000009499490261077880859375);
    }
    else
    {
        _1215 = fast::max(float3(0.0), mix(_1145, _1145 * ((_577 * float3x3(float3(1.06317996978759765625, 0.02339559979736804962158203125, -0.08657260239124298095703125), float3(-0.010633699595928192138671875, 1.2063200473785400390625, -0.1956900060176849365234375), float3(-0.0005908869788981974124908447265625, 0.00105247995816171169281005859375, 0.999538004398345947265625))) * _576), _940) * _575);
    }
    float3 _1216 = fast::clamp(_1215, float3(0.0), float3(1.0));
    float _1217 = _1216.x;
    float _1229;
    for (;;)
    {
        if (_1217 < 0.00313066993840038776397705078125)
        {
            _1229 = _1217 * 12.9200000762939453125;
            break;
        }
        _1229 = (pow(_1217, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
        break;
    }
    float _1230 = _1216.y;
    float _1242;
    for (;;)
    {
        if (_1230 < 0.00313066993840038776397705078125)
        {
            _1242 = _1230 * 12.9200000762939453125;
            break;
        }
        _1242 = (pow(_1230, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
        break;
    }
    float _1243 = _1216.z;
    float _1255;
    for (;;)
    {
        if (_1243 < 0.00313066993840038776397705078125)
        {
            _1255 = _1243 * 12.9200000762939453125;
            break;
        }
        _1255 = (pow(_1243, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
        break;
    }
    float3 _1256 = float3(_1229, _1242, _1255);
    float3 _1258 = (_1256 * float3(0.9375)) + float3(0.03125);
    float _1270 = (_1258.z * 16.0) - 0.5;
    float _1271 = floor(_1270);
    float _1275 = (_1258.x + _1271) * 0.0625;
    float _1276 = _1258.y;
    float4 _1279 = Texture1.sample(Texture1Sampler, float2(_1275, _1276));
    float4 _1283 = Texture1.sample(Texture1Sampler, float2(_1275 + 0.0625, _1276));
    float3 _1289 = fast::max(float3(6.1035199905745685100555419921875e-05), (float3(_Globals.LUTWeights[0].x) * _1256) + (float3(_Globals.LUTWeights[1].x) * mix(_1279, _1283, float4(_1270 - _1271)).xyz));
    float3 _1295 = select(_1289 * float3(0.077399380505084991455078125), pow((_1289 * float3(0.94786727428436279296875)) + float3(0.0521326996386051177978515625), float3(2.400000095367431640625)), _1289 > float3(0.040449999272823333740234375));
    float3 _1324 = pow(fast::max(float3(0.0), mix((((float3(_Globals.MappingPolynomial.x) * (_1295 * _1295)) + (float3(_Globals.MappingPolynomial.y) * _1295)) + float3(_Globals.MappingPolynomial.z)) * _Globals.ColorScale, _Globals.OverlayColor.xyz, float3(_Globals.OverlayColor.w))), float3(_Globals.InverseGamma.y));
    float3 _3103;
    if (_Globals.OutputDevice == 0u)
    {
        float _3075;
        for (;;)
        {
            if (_1324.x < 0.00313066993840038776397705078125)
            {
                _3075 = _1324.x * 12.9200000762939453125;
                break;
            }
            _3075 = (pow(_1324.x, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        float _3088;
        for (;;)
        {
            if (_1324.y < 0.00313066993840038776397705078125)
            {
                _3088 = _1324.y * 12.9200000762939453125;
                break;
            }
            _3088 = (pow(_1324.y, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        float _3101;
        for (;;)
        {
            if (_1324.z < 0.00313066993840038776397705078125)
            {
                _3101 = _1324.z * 12.9200000762939453125;
                break;
            }
            _3101 = (pow(_1324.z, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        _3103 = float3(_3075, _3088, _3101);
    }
    else
    {
        float3 _3062;
        if (_Globals.OutputDevice == 1u)
        {
            float3 _3055 = fast::max(float3(6.1035199905745685100555419921875e-05), (_1324 * _573) * _602);
            _3062 = fast::min(_3055 * float3(4.5), (pow(fast::max(_3055, float3(0.017999999225139617919921875)), float3(0.449999988079071044921875)) * float3(1.09899997711181640625)) - float3(0.098999999463558197021484375));
        }
        else
        {
            float3 _3052;
            if ((_Globals.OutputDevice == 3u) || (_Globals.OutputDevice == 5u))
            {
                float3 _2204 = (_932 * float3(1.5)) * (_572 * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625)));
                float _2205 = _2204.x;
                float _2206 = _2204.y;
                float _2208 = _2204.z;
                float _2211 = fast::max(fast::max(_2205, _2206), _2208);
                float _2216 = (fast::max(_2211, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_2205, _2206), _2208), 1.0000000133514319600180897396058e-10)) / fast::max(_2211, 0.00999999977648258209228515625);
                float _2229 = ((_2208 + _2206) + _2205) + (1.75 * sqrt(((_2208 * (_2208 - _2206)) + (_2206 * (_2206 - _2205))) + (_2205 * (_2205 - _2208))));
                float _2230 = _2229 * 0.3333333432674407958984375;
                float _2231 = _2216 - 0.4000000059604644775390625;
                float _2236 = fast::max(1.0 - abs(_2231 * 2.5), 0.0);
                float _2244 = (1.0 + (float(int(sign(_2231 * 5.0))) * (1.0 - (_2236 * _2236)))) * 0.02500000037252902984619140625;
                float _2257;
                if (_2230 <= 0.053333334624767303466796875)
                {
                    _2257 = _2244;
                }
                else
                {
                    float _2256;
                    if (_2230 >= 0.1599999964237213134765625)
                    {
                        _2256 = 0.0;
                    }
                    else
                    {
                        _2256 = _2244 * ((0.23999999463558197021484375 / _2229) - 0.5);
                    }
                    _2257 = _2256;
                }
                float3 _2260 = _2204 * float3(1.0 + _2257);
                float _2261 = _2260.x;
                float _2262 = _2260.y;
                float _2264 = _2260.z;
                float _2278;
                if ((_2261 == _2262) && (_2262 == _2264))
                {
                    _2278 = 0.0;
                }
                else
                {
                    _2278 = 57.2957763671875 * precise::atan2(sqrt(3.0) * (_2262 - _2264), ((2.0 * _2261) - _2262) - _2264);
                }
                float _2283;
                if (_2278 < 0.0)
                {
                    _2283 = _2278 + 360.0;
                }
                else
                {
                    _2283 = _2278;
                }
                float _2284 = fast::clamp(_2283, 0.0, 360.0);
                float _2289;
                if (_2284 > 180.0)
                {
                    _2289 = _2284 - 360.0;
                }
                else
                {
                    _2289 = _2284;
                }
                float _2339;
                if ((_2289 > (-67.5)) && (_2289 < 67.5))
                {
                    float _2296 = (_2289 - (-67.5)) * 0.0296296291053295135498046875;
                    int _2297 = int(_2296);
                    float _2299 = _2296 - float(_2297);
                    float _2300 = _2299 * _2299;
                    float _2301 = _2300 * _2299;
                    float _2338;
                    if (_2297 == 3)
                    {
                        _2338 = (((_2301 * (-0.16666667163372039794921875)) + (_2300 * 0.5)) + (_2299 * (-0.5))) + 0.16666667163372039794921875;
                    }
                    else
                    {
                        float _2331;
                        if (_2297 == 2)
                        {
                            _2331 = ((_2301 * 0.5) + (_2300 * (-1.0))) + 0.666666686534881591796875;
                        }
                        else
                        {
                            float _2326;
                            if (_2297 == 1)
                            {
                                _2326 = (((_2301 * (-0.5)) + (_2300 * 0.5)) + (_2299 * 0.5)) + 0.16666667163372039794921875;
                            }
                            else
                            {
                                float _2319;
                                if (_2297 == 0)
                                {
                                    _2319 = _2301 * 0.16666667163372039794921875;
                                }
                                else
                                {
                                    _2319 = 0.0;
                                }
                                _2326 = _2319;
                            }
                            _2331 = _2326;
                        }
                        _2338 = _2331;
                    }
                    _2339 = _2338;
                }
                else
                {
                    _2339 = 0.0;
                }
                float3 _2346 = _2260;
                _2346.x = _2261 + ((((_2339 * 1.5) * _2216) * (0.02999999932944774627685546875 - _2261)) * 0.180000007152557373046875);
                float3 _2349 = fast::clamp(fast::clamp(_2346, float3(0.0), float3(65535.0)) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)), float3(0.0), float3(65535.0));
                float3 _2352 = mix(float3(dot(_2349, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _2349, float3(0.959999978542327880859375));
                float _2353 = _2352.x;
                float _2357 = 0.17999999225139617919921875 * exp2(18.0);
                float _2359 = exp2(-14.0);
                float _2362 = log((_2353 <= 0.0) ? _2359 : _2353) / _1091;
                float _2364 = log(0.17999999225139617919921875 * exp2(-15.0)) / _1091;
                float _2431;
                if (_2362 <= _2364)
                {
                    _2431 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2371 = log(0.180000007152557373046875) / _1091;
                    float _2428;
                    if ((_2362 > _2364) && (_2362 < _2371))
                    {
                        float _2411 = (3.0 * (_2362 - _2364)) / (_2371 - _2364);
                        int _2412 = int(_2411);
                        float _2414 = _2411 - float(_2412);
                        _2428 = dot(float3(_2414 * _2414, _2414, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_2412], _499[_2412 + 1], _499[_2412 + 2]));
                    }
                    else
                    {
                        float _2379 = log(_2357) / _1091;
                        float _2407;
                        if ((_2362 >= _2371) && (_2362 < _2379))
                        {
                            float _2390 = (3.0 * (_2362 - _2371)) / (_2379 - _2371);
                            int _2391 = int(_2390);
                            float _2393 = _2390 - float(_2391);
                            _2407 = dot(float3(_2393 * _2393, _2393, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2391], _500[_2391 + 1], _500[_2391 + 2]));
                        }
                        else
                        {
                            _2407 = log(10000.0) / _1091;
                        }
                        _2428 = _2407;
                    }
                    _2431 = _2428;
                }
                float3 _2433 = _523;
                _2433.x = pow(10.0, _2431);
                float _2434 = _2352.y;
                float _2438 = log((_2434 <= 0.0) ? _2359 : _2434) / _1091;
                float _2505;
                if (_2438 <= _2364)
                {
                    _2505 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2445 = log(0.180000007152557373046875) / _1091;
                    float _2502;
                    if ((_2438 > _2364) && (_2438 < _2445))
                    {
                        float _2485 = (3.0 * (_2438 - _2364)) / (_2445 - _2364);
                        int _2486 = int(_2485);
                        float _2488 = _2485 - float(_2486);
                        _2502 = dot(float3(_2488 * _2488, _2488, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_2486], _499[_2486 + 1], _499[_2486 + 2]));
                    }
                    else
                    {
                        float _2453 = log(_2357) / _1091;
                        float _2481;
                        if ((_2438 >= _2445) && (_2438 < _2453))
                        {
                            float _2464 = (3.0 * (_2438 - _2445)) / (_2453 - _2445);
                            int _2465 = int(_2464);
                            float _2467 = _2464 - float(_2465);
                            _2481 = dot(float3(_2467 * _2467, _2467, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2465], _500[_2465 + 1], _500[_2465 + 2]));
                        }
                        else
                        {
                            _2481 = log(10000.0) / _1091;
                        }
                        _2502 = _2481;
                    }
                    _2505 = _2502;
                }
                float3 _2507 = _2433;
                _2507.y = pow(10.0, _2505);
                float _2508 = _2352.z;
                float _2512 = log((_2508 <= 0.0) ? _2359 : _2508) / _1091;
                float _2579;
                if (_2512 <= _2364)
                {
                    _2579 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2519 = log(0.180000007152557373046875) / _1091;
                    float _2576;
                    if ((_2512 > _2364) && (_2512 < _2519))
                    {
                        float _2559 = (3.0 * (_2512 - _2364)) / (_2519 - _2364);
                        int _2560 = int(_2559);
                        float _2562 = _2559 - float(_2560);
                        _2576 = dot(float3(_2562 * _2562, _2562, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_2560], _499[_2560 + 1], _499[_2560 + 2]));
                    }
                    else
                    {
                        float _2527 = log(_2357) / _1091;
                        float _2555;
                        if ((_2512 >= _2519) && (_2512 < _2527))
                        {
                            float _2538 = (3.0 * (_2512 - _2519)) / (_2527 - _2519);
                            int _2539 = int(_2538);
                            float _2541 = _2538 - float(_2539);
                            _2555 = dot(float3(_2541 * _2541, _2541, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2539], _500[_2539 + 1], _500[_2539 + 2]));
                        }
                        else
                        {
                            _2555 = log(10000.0) / _1091;
                        }
                        _2576 = _2555;
                    }
                    _2579 = _2576;
                }
                float3 _2581 = _2507;
                _2581.z = pow(10.0, _2579);
                float3 _2583 = (_2581 * float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625))) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375));
                float _2585 = 0.17999999225139617919921875 * pow(2.0, -12.0);
                float _2589 = log((_2585 <= 0.0) ? _2359 : _2585) / _1091;
                float _2656;
                if (_2589 <= _2364)
                {
                    _2656 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2596 = log(0.180000007152557373046875) / _1091;
                    float _2653;
                    if ((_2589 > _2364) && (_2589 < _2596))
                    {
                        float _2636 = (3.0 * (_2589 - _2364)) / (_2596 - _2364);
                        int _2637 = int(_2636);
                        float _2639 = _2636 - float(_2637);
                        _2653 = dot(float3(_2639 * _2639, _2639, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_2637], _499[_2637 + 1], _499[_2637 + 2]));
                    }
                    else
                    {
                        float _2604 = log(_2357) / _1091;
                        float _2632;
                        if ((_2589 >= _2596) && (_2589 < _2604))
                        {
                            float _2615 = (3.0 * (_2589 - _2596)) / (_2604 - _2596);
                            int _2616 = int(_2615);
                            float _2618 = _2615 - float(_2616);
                            _2632 = dot(float3(_2618 * _2618, _2618, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2616], _500[_2616 + 1], _500[_2616 + 2]));
                        }
                        else
                        {
                            _2632 = log(10000.0) / _1091;
                        }
                        _2653 = _2632;
                    }
                    _2656 = _2653;
                }
                float _2659 = log(0.180000007152557373046875) / _1091;
                float _2713;
                if (_2659 <= _2364)
                {
                    _2713 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2710;
                    if ((_2659 > _2364) && (_2659 < _2659))
                    {
                        _2710 = (float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[3], _499[4], _499[5])).z;
                    }
                    else
                    {
                        float _2672 = log(_2357) / _1091;
                        float _2700;
                        if ((_2659 >= _2659) && (_2659 < _2672))
                        {
                            float _2683 = (3.0 * (_2659 - _2659)) / (_2672 - _2659);
                            int _2684 = int(_2683);
                            float _2686 = _2683 - float(_2684);
                            _2700 = dot(float3(_2686 * _2686, _2686, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2684], _500[_2684 + 1], _500[_2684 + 2]));
                        }
                        else
                        {
                            _2700 = log(10000.0) / _1091;
                        }
                        _2710 = _2700;
                    }
                    _2713 = _2710;
                }
                float _2714 = pow(10.0, _2713);
                float _2716 = 0.17999999225139617919921875 * pow(2.0, 10.0);
                float _2720 = log((_2716 <= 0.0) ? _2359 : _2716) / _1091;
                float _2785;
                if (_2720 <= _2364)
                {
                    _2785 = log(9.9999997473787516355514526367188e-05) / _1091;
                }
                else
                {
                    float _2782;
                    if ((_2720 > _2364) && (_2720 < _2659))
                    {
                        float _2765 = (3.0 * (_2720 - _2364)) / (_2659 - _2364);
                        int _2766 = int(_2765);
                        float _2768 = _2765 - float(_2766);
                        _2782 = dot(float3(_2768 * _2768, _2768, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_2766], _499[_2766 + 1], _499[_2766 + 2]));
                    }
                    else
                    {
                        float _2733 = log(_2357) / _1091;
                        float _2761;
                        if ((_2720 >= _2659) && (_2720 < _2733))
                        {
                            float _2744 = (3.0 * (_2720 - _2659)) / (_2733 - _2659);
                            int _2745 = int(_2744);
                            float _2747 = _2744 - float(_2745);
                            _2761 = dot(float3(_2747 * _2747, _2747, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_2745], _500[_2745 + 1], _500[_2745 + 2]));
                        }
                        else
                        {
                            _2761 = log(10000.0) / _1091;
                        }
                        _2782 = _2761;
                    }
                    _2785 = _2782;
                }
                float _2786 = pow(10.0, _2785);
                float _2787 = _2583.x;
                float _2791 = log((_2787 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2787) / _1091;
                float _2792 = log(pow(10.0, _2656));
                float _2793 = _2792 / _1091;
                float _2870;
                if (_2791 <= _2793)
                {
                    _2870 = (_2791 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1091) - ((3.0 * _2792) / _1091));
                }
                else
                {
                    float _2800 = log(_2714) / _1091;
                    float _2862;
                    if ((_2791 > _2793) && (_2791 < _2800))
                    {
                        float _2845 = (7.0 * (_2791 - _2793)) / (_2800 - _2793);
                        int _2846 = int(_2845);
                        float _2848 = _2845 - float(_2846);
                        _2862 = dot(float3(_2848 * _2848, _2848, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_503[_2846], _503[_2846 + 1], _503[_2846 + 2]));
                    }
                    else
                    {
                        float _2807 = log(_2786);
                        float _2808 = _2807 / _1091;
                        float _2841;
                        if ((_2791 >= _2800) && (_2791 < _2808))
                        {
                            float _2824 = (7.0 * (_2791 - _2800)) / (_2808 - _2800);
                            int _2825 = int(_2824);
                            float _2827 = _2824 - float(_2825);
                            _2841 = dot(float3(_2827 * _2827, _2827, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_504[_2825], _504[_2825 + 1], _504[_2825 + 2]));
                        }
                        else
                        {
                            _2841 = (_2791 * 0.0599999986588954925537109375) + ((log(1000.0) / _1091) - ((0.0599999986588954925537109375 * _2807) / _1091));
                        }
                        _2862 = _2841;
                    }
                    _2870 = _2862;
                }
                float3 _2872 = _523;
                _2872.x = pow(10.0, _2870);
                float _2873 = _2583.y;
                float _2877 = log((_2873 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2873) / _1091;
                float _2954;
                if (_2877 <= _2793)
                {
                    _2954 = (_2877 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1091) - ((3.0 * _2792) / _1091));
                }
                else
                {
                    float _2884 = log(_2714) / _1091;
                    float _2946;
                    if ((_2877 > _2793) && (_2877 < _2884))
                    {
                        float _2929 = (7.0 * (_2877 - _2793)) / (_2884 - _2793);
                        int _2930 = int(_2929);
                        float _2932 = _2929 - float(_2930);
                        _2946 = dot(float3(_2932 * _2932, _2932, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_503[_2930], _503[_2930 + 1], _503[_2930 + 2]));
                    }
                    else
                    {
                        float _2891 = log(_2786);
                        float _2892 = _2891 / _1091;
                        float _2925;
                        if ((_2877 >= _2884) && (_2877 < _2892))
                        {
                            float _2908 = (7.0 * (_2877 - _2884)) / (_2892 - _2884);
                            int _2909 = int(_2908);
                            float _2911 = _2908 - float(_2909);
                            _2925 = dot(float3(_2911 * _2911, _2911, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_504[_2909], _504[_2909 + 1], _504[_2909 + 2]));
                        }
                        else
                        {
                            _2925 = (_2877 * 0.0599999986588954925537109375) + ((log(1000.0) / _1091) - ((0.0599999986588954925537109375 * _2891) / _1091));
                        }
                        _2946 = _2925;
                    }
                    _2954 = _2946;
                }
                float3 _2956 = _2872;
                _2956.y = pow(10.0, _2954);
                float _2957 = _2583.z;
                float _2961 = log((_2957 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2957) / _1091;
                float _3038;
                if (_2961 <= _2793)
                {
                    _3038 = (_2961 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1091) - ((3.0 * _2792) / _1091));
                }
                else
                {
                    float _2968 = log(_2714) / _1091;
                    float _3030;
                    if ((_2961 > _2793) && (_2961 < _2968))
                    {
                        float _3013 = (7.0 * (_2961 - _2793)) / (_2968 - _2793);
                        int _3014 = int(_3013);
                        float _3016 = _3013 - float(_3014);
                        _3030 = dot(float3(_3016 * _3016, _3016, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_503[_3014], _503[_3014 + 1], _503[_3014 + 2]));
                    }
                    else
                    {
                        float _2975 = log(_2786);
                        float _2976 = _2975 / _1091;
                        float _3009;
                        if ((_2961 >= _2968) && (_2961 < _2976))
                        {
                            float _2992 = (7.0 * (_2961 - _2968)) / (_2976 - _2968);
                            int _2993 = int(_2992);
                            float _2995 = _2992 - float(_2993);
                            _3009 = dot(float3(_2995 * _2995, _2995, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_504[_2993], _504[_2993 + 1], _504[_2993 + 2]));
                        }
                        else
                        {
                            _3009 = (_2961 * 0.0599999986588954925537109375) + ((log(1000.0) / _1091) - ((0.0599999986588954925537109375 * _2975) / _1091));
                        }
                        _3030 = _3009;
                    }
                    _3038 = _3030;
                }
                float3 _3040 = _2956;
                _3040.z = pow(10.0, _3038);
                float3 _3044 = pow(((_3040 - float3(3.5073844628641381859779357910156e-05)) * _602) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                _3052 = pow((float3(0.8359375) + (float3(18.8515625) * _3044)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _3044))), float3(78.84375));
            }
            else
            {
                float3 _2201;
                if ((_Globals.OutputDevice == 4u) || (_Globals.OutputDevice == 6u))
                {
                    float3 _1369 = (_932 * float3(1.5)) * (_572 * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625)));
                    float _1370 = _1369.x;
                    float _1371 = _1369.y;
                    float _1373 = _1369.z;
                    float _1376 = fast::max(fast::max(_1370, _1371), _1373);
                    float _1381 = (fast::max(_1376, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_1370, _1371), _1373), 1.0000000133514319600180897396058e-10)) / fast::max(_1376, 0.00999999977648258209228515625);
                    float _1394 = ((_1373 + _1371) + _1370) + (1.75 * sqrt(((_1373 * (_1373 - _1371)) + (_1371 * (_1371 - _1370))) + (_1370 * (_1370 - _1373))));
                    float _1395 = _1394 * 0.3333333432674407958984375;
                    float _1396 = _1381 - 0.4000000059604644775390625;
                    float _1401 = fast::max(1.0 - abs(_1396 * 2.5), 0.0);
                    float _1409 = (1.0 + (float(int(sign(_1396 * 5.0))) * (1.0 - (_1401 * _1401)))) * 0.02500000037252902984619140625;
                    float _1422;
                    if (_1395 <= 0.053333334624767303466796875)
                    {
                        _1422 = _1409;
                    }
                    else
                    {
                        float _1421;
                        if (_1395 >= 0.1599999964237213134765625)
                        {
                            _1421 = 0.0;
                        }
                        else
                        {
                            _1421 = _1409 * ((0.23999999463558197021484375 / _1394) - 0.5);
                        }
                        _1422 = _1421;
                    }
                    float3 _1425 = _1369 * float3(1.0 + _1422);
                    float _1426 = _1425.x;
                    float _1427 = _1425.y;
                    float _1429 = _1425.z;
                    float _1443;
                    if ((_1426 == _1427) && (_1427 == _1429))
                    {
                        _1443 = 0.0;
                    }
                    else
                    {
                        _1443 = 57.2957763671875 * precise::atan2(sqrt(3.0) * (_1427 - _1429), ((2.0 * _1426) - _1427) - _1429);
                    }
                    float _1448;
                    if (_1443 < 0.0)
                    {
                        _1448 = _1443 + 360.0;
                    }
                    else
                    {
                        _1448 = _1443;
                    }
                    float _1449 = fast::clamp(_1448, 0.0, 360.0);
                    float _1454;
                    if (_1449 > 180.0)
                    {
                        _1454 = _1449 - 360.0;
                    }
                    else
                    {
                        _1454 = _1449;
                    }
                    float _1504;
                    if ((_1454 > (-67.5)) && (_1454 < 67.5))
                    {
                        float _1461 = (_1454 - (-67.5)) * 0.0296296291053295135498046875;
                        int _1462 = int(_1461);
                        float _1464 = _1461 - float(_1462);
                        float _1465 = _1464 * _1464;
                        float _1466 = _1465 * _1464;
                        float _1503;
                        if (_1462 == 3)
                        {
                            _1503 = (((_1466 * (-0.16666667163372039794921875)) + (_1465 * 0.5)) + (_1464 * (-0.5))) + 0.16666667163372039794921875;
                        }
                        else
                        {
                            float _1496;
                            if (_1462 == 2)
                            {
                                _1496 = ((_1466 * 0.5) + (_1465 * (-1.0))) + 0.666666686534881591796875;
                            }
                            else
                            {
                                float _1491;
                                if (_1462 == 1)
                                {
                                    _1491 = (((_1466 * (-0.5)) + (_1465 * 0.5)) + (_1464 * 0.5)) + 0.16666667163372039794921875;
                                }
                                else
                                {
                                    float _1484;
                                    if (_1462 == 0)
                                    {
                                        _1484 = _1466 * 0.16666667163372039794921875;
                                    }
                                    else
                                    {
                                        _1484 = 0.0;
                                    }
                                    _1491 = _1484;
                                }
                                _1496 = _1491;
                            }
                            _1503 = _1496;
                        }
                        _1504 = _1503;
                    }
                    else
                    {
                        _1504 = 0.0;
                    }
                    float3 _1511 = _1425;
                    _1511.x = _1426 + ((((_1504 * 1.5) * _1381) * (0.02999999932944774627685546875 - _1426)) * 0.180000007152557373046875);
                    float3 _1514 = fast::clamp(fast::clamp(_1511, float3(0.0), float3(65535.0)) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)), float3(0.0), float3(65535.0));
                    float3 _1517 = mix(float3(dot(_1514, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1514, float3(0.959999978542327880859375));
                    float _1518 = _1517.x;
                    float _1522 = 0.17999999225139617919921875 * exp2(18.0);
                    float _1524 = exp2(-14.0);
                    float _1527 = log((_1518 <= 0.0) ? _1524 : _1518) / _1091;
                    float _1529 = log(0.17999999225139617919921875 * exp2(-15.0)) / _1091;
                    float _1596;
                    if (_1527 <= _1529)
                    {
                        _1596 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1536 = log(0.180000007152557373046875) / _1091;
                        float _1593;
                        if ((_1527 > _1529) && (_1527 < _1536))
                        {
                            float _1576 = (3.0 * (_1527 - _1529)) / (_1536 - _1529);
                            int _1577 = int(_1576);
                            float _1579 = _1576 - float(_1577);
                            _1593 = dot(float3(_1579 * _1579, _1579, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_1577], _499[_1577 + 1], _499[_1577 + 2]));
                        }
                        else
                        {
                            float _1544 = log(_1522) / _1091;
                            float _1572;
                            if ((_1527 >= _1536) && (_1527 < _1544))
                            {
                                float _1555 = (3.0 * (_1527 - _1536)) / (_1544 - _1536);
                                int _1556 = int(_1555);
                                float _1558 = _1555 - float(_1556);
                                _1572 = dot(float3(_1558 * _1558, _1558, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1556], _500[_1556 + 1], _500[_1556 + 2]));
                            }
                            else
                            {
                                _1572 = log(10000.0) / _1091;
                            }
                            _1593 = _1572;
                        }
                        _1596 = _1593;
                    }
                    float3 _1598 = _523;
                    _1598.x = pow(10.0, _1596);
                    float _1599 = _1517.y;
                    float _1603 = log((_1599 <= 0.0) ? _1524 : _1599) / _1091;
                    float _1670;
                    if (_1603 <= _1529)
                    {
                        _1670 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1610 = log(0.180000007152557373046875) / _1091;
                        float _1667;
                        if ((_1603 > _1529) && (_1603 < _1610))
                        {
                            float _1650 = (3.0 * (_1603 - _1529)) / (_1610 - _1529);
                            int _1651 = int(_1650);
                            float _1653 = _1650 - float(_1651);
                            _1667 = dot(float3(_1653 * _1653, _1653, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_1651], _499[_1651 + 1], _499[_1651 + 2]));
                        }
                        else
                        {
                            float _1618 = log(_1522) / _1091;
                            float _1646;
                            if ((_1603 >= _1610) && (_1603 < _1618))
                            {
                                float _1629 = (3.0 * (_1603 - _1610)) / (_1618 - _1610);
                                int _1630 = int(_1629);
                                float _1632 = _1629 - float(_1630);
                                _1646 = dot(float3(_1632 * _1632, _1632, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1630], _500[_1630 + 1], _500[_1630 + 2]));
                            }
                            else
                            {
                                _1646 = log(10000.0) / _1091;
                            }
                            _1667 = _1646;
                        }
                        _1670 = _1667;
                    }
                    float3 _1672 = _1598;
                    _1672.y = pow(10.0, _1670);
                    float _1673 = _1517.z;
                    float _1677 = log((_1673 <= 0.0) ? _1524 : _1673) / _1091;
                    float _1744;
                    if (_1677 <= _1529)
                    {
                        _1744 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1684 = log(0.180000007152557373046875) / _1091;
                        float _1741;
                        if ((_1677 > _1529) && (_1677 < _1684))
                        {
                            float _1724 = (3.0 * (_1677 - _1529)) / (_1684 - _1529);
                            int _1725 = int(_1724);
                            float _1727 = _1724 - float(_1725);
                            _1741 = dot(float3(_1727 * _1727, _1727, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_1725], _499[_1725 + 1], _499[_1725 + 2]));
                        }
                        else
                        {
                            float _1692 = log(_1522) / _1091;
                            float _1720;
                            if ((_1677 >= _1684) && (_1677 < _1692))
                            {
                                float _1703 = (3.0 * (_1677 - _1684)) / (_1692 - _1684);
                                int _1704 = int(_1703);
                                float _1706 = _1703 - float(_1704);
                                _1720 = dot(float3(_1706 * _1706, _1706, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1704], _500[_1704 + 1], _500[_1704 + 2]));
                            }
                            else
                            {
                                _1720 = log(10000.0) / _1091;
                            }
                            _1741 = _1720;
                        }
                        _1744 = _1741;
                    }
                    float3 _1746 = _1672;
                    _1746.z = pow(10.0, _1744);
                    float3 _1748 = (_1746 * float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625))) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375));
                    float _1750 = 0.17999999225139617919921875 * pow(2.0, -12.0);
                    float _1754 = log((_1750 <= 0.0) ? _1524 : _1750) / _1091;
                    float _1821;
                    if (_1754 <= _1529)
                    {
                        _1821 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1761 = log(0.180000007152557373046875) / _1091;
                        float _1818;
                        if ((_1754 > _1529) && (_1754 < _1761))
                        {
                            float _1801 = (3.0 * (_1754 - _1529)) / (_1761 - _1529);
                            int _1802 = int(_1801);
                            float _1804 = _1801 - float(_1802);
                            _1818 = dot(float3(_1804 * _1804, _1804, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_1802], _499[_1802 + 1], _499[_1802 + 2]));
                        }
                        else
                        {
                            float _1769 = log(_1522) / _1091;
                            float _1797;
                            if ((_1754 >= _1761) && (_1754 < _1769))
                            {
                                float _1780 = (3.0 * (_1754 - _1761)) / (_1769 - _1761);
                                int _1781 = int(_1780);
                                float _1783 = _1780 - float(_1781);
                                _1797 = dot(float3(_1783 * _1783, _1783, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1781], _500[_1781 + 1], _500[_1781 + 2]));
                            }
                            else
                            {
                                _1797 = log(10000.0) / _1091;
                            }
                            _1818 = _1797;
                        }
                        _1821 = _1818;
                    }
                    float _1824 = log(0.180000007152557373046875) / _1091;
                    float _1878;
                    if (_1824 <= _1529)
                    {
                        _1878 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1875;
                        if ((_1824 > _1529) && (_1824 < _1824))
                        {
                            _1875 = (float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[3], _499[4], _499[5])).z;
                        }
                        else
                        {
                            float _1837 = log(_1522) / _1091;
                            float _1865;
                            if ((_1824 >= _1824) && (_1824 < _1837))
                            {
                                float _1848 = (3.0 * (_1824 - _1824)) / (_1837 - _1824);
                                int _1849 = int(_1848);
                                float _1851 = _1848 - float(_1849);
                                _1865 = dot(float3(_1851 * _1851, _1851, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1849], _500[_1849 + 1], _500[_1849 + 2]));
                            }
                            else
                            {
                                _1865 = log(10000.0) / _1091;
                            }
                            _1875 = _1865;
                        }
                        _1878 = _1875;
                    }
                    float _1879 = pow(10.0, _1878);
                    float _1881 = 0.17999999225139617919921875 * pow(2.0, 11.0);
                    float _1885 = log((_1881 <= 0.0) ? _1524 : _1881) / _1091;
                    float _1950;
                    if (_1885 <= _1529)
                    {
                        _1950 = log(9.9999997473787516355514526367188e-05) / _1091;
                    }
                    else
                    {
                        float _1947;
                        if ((_1885 > _1529) && (_1885 < _1824))
                        {
                            float _1930 = (3.0 * (_1885 - _1529)) / (_1824 - _1529);
                            int _1931 = int(_1930);
                            float _1933 = _1930 - float(_1931);
                            _1947 = dot(float3(_1933 * _1933, _1933, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_499[_1931], _499[_1931 + 1], _499[_1931 + 2]));
                        }
                        else
                        {
                            float _1898 = log(_1522) / _1091;
                            float _1926;
                            if ((_1885 >= _1824) && (_1885 < _1898))
                            {
                                float _1909 = (3.0 * (_1885 - _1824)) / (_1898 - _1824);
                                int _1910 = int(_1909);
                                float _1912 = _1909 - float(_1910);
                                _1926 = dot(float3(_1912 * _1912, _1912, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_500[_1910], _500[_1910 + 1], _500[_1910 + 2]));
                            }
                            else
                            {
                                _1926 = log(10000.0) / _1091;
                            }
                            _1947 = _1926;
                        }
                        _1950 = _1947;
                    }
                    float _1951 = pow(10.0, _1950);
                    float _1952 = _1748.x;
                    float _1956 = log((_1952 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _1952) / _1091;
                    float _1958 = log(pow(10.0, _1821)) / _1091;
                    float _2030;
                    if (_1956 <= _1958)
                    {
                        _2030 = log(0.004999999888241291046142578125) / _1091;
                    }
                    else
                    {
                        float _1965 = log(_1879) / _1091;
                        float _2027;
                        if ((_1956 > _1958) && (_1956 < _1965))
                        {
                            float _2010 = (7.0 * (_1956 - _1958)) / (_1965 - _1958);
                            int _2011 = int(_2010);
                            float _2013 = _2010 - float(_2011);
                            _2027 = dot(float3(_2013 * _2013, _2013, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_506[_2011], _506[_2011 + 1], _506[_2011 + 2]));
                        }
                        else
                        {
                            float _1972 = log(_1951);
                            float _1973 = _1972 / _1091;
                            float _2006;
                            if ((_1956 >= _1965) && (_1956 < _1973))
                            {
                                float _1989 = (7.0 * (_1956 - _1965)) / (_1973 - _1965);
                                int _1990 = int(_1989);
                                float _1992 = _1989 - float(_1990);
                                _2006 = dot(float3(_1992 * _1992, _1992, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_507[_1990], _507[_1990 + 1], _507[_1990 + 2]));
                            }
                            else
                            {
                                _2006 = (_1956 * 0.119999997317790985107421875) + ((log(2000.0) / _1091) - ((0.119999997317790985107421875 * _1972) / _1091));
                            }
                            _2027 = _2006;
                        }
                        _2030 = _2027;
                    }
                    float3 _2032 = _523;
                    _2032.x = pow(10.0, _2030);
                    float _2033 = _1748.y;
                    float _2037 = log((_2033 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2033) / _1091;
                    float _2109;
                    if (_2037 <= _1958)
                    {
                        _2109 = log(0.004999999888241291046142578125) / _1091;
                    }
                    else
                    {
                        float _2044 = log(_1879) / _1091;
                        float _2106;
                        if ((_2037 > _1958) && (_2037 < _2044))
                        {
                            float _2089 = (7.0 * (_2037 - _1958)) / (_2044 - _1958);
                            int _2090 = int(_2089);
                            float _2092 = _2089 - float(_2090);
                            _2106 = dot(float3(_2092 * _2092, _2092, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_506[_2090], _506[_2090 + 1], _506[_2090 + 2]));
                        }
                        else
                        {
                            float _2051 = log(_1951);
                            float _2052 = _2051 / _1091;
                            float _2085;
                            if ((_2037 >= _2044) && (_2037 < _2052))
                            {
                                float _2068 = (7.0 * (_2037 - _2044)) / (_2052 - _2044);
                                int _2069 = int(_2068);
                                float _2071 = _2068 - float(_2069);
                                _2085 = dot(float3(_2071 * _2071, _2071, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_507[_2069], _507[_2069 + 1], _507[_2069 + 2]));
                            }
                            else
                            {
                                _2085 = (_2037 * 0.119999997317790985107421875) + ((log(2000.0) / _1091) - ((0.119999997317790985107421875 * _2051) / _1091));
                            }
                            _2106 = _2085;
                        }
                        _2109 = _2106;
                    }
                    float3 _2111 = _2032;
                    _2111.y = pow(10.0, _2109);
                    float _2112 = _1748.z;
                    float _2116 = log((_2112 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2112) / _1091;
                    float _2188;
                    if (_2116 <= _1958)
                    {
                        _2188 = log(0.004999999888241291046142578125) / _1091;
                    }
                    else
                    {
                        float _2123 = log(_1879) / _1091;
                        float _2185;
                        if ((_2116 > _1958) && (_2116 < _2123))
                        {
                            float _2168 = (7.0 * (_2116 - _1958)) / (_2123 - _1958);
                            int _2169 = int(_2168);
                            float _2171 = _2168 - float(_2169);
                            _2185 = dot(float3(_2171 * _2171, _2171, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_506[_2169], _506[_2169 + 1], _506[_2169 + 2]));
                        }
                        else
                        {
                            float _2130 = log(_1951);
                            float _2131 = _2130 / _1091;
                            float _2164;
                            if ((_2116 >= _2123) && (_2116 < _2131))
                            {
                                float _2147 = (7.0 * (_2116 - _2123)) / (_2131 - _2123);
                                int _2148 = int(_2147);
                                float _2150 = _2147 - float(_2148);
                                _2164 = dot(float3(_2150 * _2150, _2150, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_507[_2148], _507[_2148 + 1], _507[_2148 + 2]));
                            }
                            else
                            {
                                _2164 = (_2116 * 0.119999997317790985107421875) + ((log(2000.0) / _1091) - ((0.119999997317790985107421875 * _2130) / _1091));
                            }
                            _2185 = _2164;
                        }
                        _2188 = _2185;
                    }
                    float3 _2190 = _2111;
                    _2190.z = pow(10.0, _2188);
                    float3 _2193 = pow((_2190 * _602) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                    _2201 = pow((float3(0.8359375) + (float3(18.8515625) * _2193)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _2193))), float3(78.84375));
                }
                else
                {
                    float3 _1366;
                    if (_Globals.OutputDevice == 7u)
                    {
                        float3 _1358 = pow(((_932 * _573) * _602) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                        _1366 = pow((float3(0.8359375) + (float3(18.8515625) * _1358)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _1358))), float3(78.84375));
                    }
                    else
                    {
                        _1366 = pow((_1324 * _573) * _602, float3(_Globals.InverseGamma.z));
                    }
                    _2201 = _1366;
                }
                _3052 = _2201;
            }
            _3062 = _3052;
        }
        _3103 = _3062;
    }
    float3 _3104 = _3103 * float3(0.95238101482391357421875);
    float4 _3106 = float4(_3104.x, _3104.y, _3104.z, float4(0.0).w);
    _3106.w = 0.0;
    out.out_var_SV_Target0 = _3106;
    return out;
}

