// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#[cfg(any(feature = "v0_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
use crate::Align;
use crate::CursorBlinkMode;
use crate::CursorShape;
use crate::EraseBinding;
use crate::Format;
use crate::Pty;
use crate::PtyFlags;
use crate::Regex;
use crate::TextBlinkMode;
use crate::WriteFlags;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "VteTerminal")]
    pub struct Terminal(Object<ffi::VteTerminal, ffi::VteTerminalClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Scrollable;

    match fn {
        type_ => || ffi::vte_terminal_get_type(),
    }
}

impl Terminal {
    pub const NONE: Option<&'static Terminal> = None;

    #[doc(alias = "vte_terminal_new")]
    pub fn new() -> Terminal {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::vte_terminal_new()) }
    }
}

impl Default for Terminal {
    fn default() -> Self {
        Self::new()
    }
}

pub trait TerminalExt: 'static {
    #[doc(alias = "vte_terminal_copy_clipboard_format")]
    fn copy_clipboard_format(&self, format: Format);

    #[doc(alias = "vte_terminal_copy_primary")]
    fn copy_primary(&self);

    #[doc(alias = "vte_terminal_feed")]
    fn feed(&self, data: &[u8]);

    #[doc(alias = "vte_terminal_feed_child")]
    fn feed_child(&self, text: &[u8]);

    #[doc(alias = "vte_terminal_get_allow_hyperlink")]
    #[doc(alias = "get_allow_hyperlink")]
    fn allows_hyperlink(&self) -> bool;

    #[doc(alias = "vte_terminal_get_audible_bell")]
    #[doc(alias = "get_audible_bell")]
    fn is_audible_bell(&self) -> bool;

    #[doc(alias = "vte_terminal_get_bold_is_bright")]
    #[doc(alias = "get_bold_is_bright")]
    fn is_bold_is_bright(&self) -> bool;

    #[doc(alias = "vte_terminal_get_cell_height_scale")]
    #[doc(alias = "get_cell_height_scale")]
    fn cell_height_scale(&self) -> f64;

    #[doc(alias = "vte_terminal_get_cell_width_scale")]
    #[doc(alias = "get_cell_width_scale")]
    fn cell_width_scale(&self) -> f64;

    #[doc(alias = "vte_terminal_get_char_height")]
    #[doc(alias = "get_char_height")]
    fn char_height(&self) -> libc::c_long;

    #[doc(alias = "vte_terminal_get_char_width")]
    #[doc(alias = "get_char_width")]
    fn char_width(&self) -> libc::c_long;

    #[doc(alias = "vte_terminal_get_cjk_ambiguous_width")]
    #[doc(alias = "get_cjk_ambiguous_width")]
    fn cjk_ambiguous_width(&self) -> i32;

    #[doc(alias = "vte_terminal_get_column_count")]
    #[doc(alias = "get_column_count")]
    fn column_count(&self) -> libc::c_long;

    #[doc(alias = "vte_terminal_get_current_directory_uri")]
    #[doc(alias = "get_current_directory_uri")]
    fn current_directory_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "vte_terminal_get_current_file_uri")]
    #[doc(alias = "get_current_file_uri")]
    fn current_file_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "vte_terminal_get_cursor_blink_mode")]
    #[doc(alias = "get_cursor_blink_mode")]
    fn cursor_blink_mode(&self) -> CursorBlinkMode;

    #[doc(alias = "vte_terminal_get_cursor_position")]
    #[doc(alias = "get_cursor_position")]
    fn cursor_position(&self) -> (libc::c_long, libc::c_long);

    #[doc(alias = "vte_terminal_get_cursor_shape")]
    #[doc(alias = "get_cursor_shape")]
    fn cursor_shape(&self) -> CursorShape;

    #[doc(alias = "vte_terminal_get_enable_bidi")]
    #[doc(alias = "get_enable_bidi")]
    fn enables_bidi(&self) -> bool;

    #[doc(alias = "vte_terminal_get_enable_fallback_scrolling")]
    #[doc(alias = "get_enable_fallback_scrolling")]
    fn enables_fallback_scrolling(&self) -> bool;

    #[doc(alias = "vte_terminal_get_enable_shaping")]
    #[doc(alias = "get_enable_shaping")]
    fn enables_shaping(&self) -> bool;

    #[doc(alias = "vte_terminal_get_enable_sixel")]
    #[doc(alias = "get_enable_sixel")]
    fn enables_sixel(&self) -> bool;

    #[doc(alias = "vte_terminal_get_font")]
    #[doc(alias = "get_font")]
    fn font(&self) -> Option<pango::FontDescription>;

    #[doc(alias = "vte_terminal_get_font_scale")]
    #[doc(alias = "get_font_scale")]
    fn font_scale(&self) -> f64;

    #[doc(alias = "vte_terminal_get_has_selection")]
    #[doc(alias = "get_has_selection")]
    fn has_selection(&self) -> bool;

    #[doc(alias = "vte_terminal_get_input_enabled")]
    #[doc(alias = "get_input_enabled")]
    fn is_input_enabled(&self) -> bool;

    #[doc(alias = "vte_terminal_get_mouse_autohide")]
    #[doc(alias = "get_mouse_autohide")]
    fn is_mouse_autohide(&self) -> bool;

    #[doc(alias = "vte_terminal_get_pty")]
    #[doc(alias = "get_pty")]
    fn pty(&self) -> Option<Pty>;

    #[doc(alias = "vte_terminal_get_row_count")]
    #[doc(alias = "get_row_count")]
    fn row_count(&self) -> libc::c_long;

    #[doc(alias = "vte_terminal_get_scroll_on_keystroke")]
    #[doc(alias = "get_scroll_on_keystroke")]
    fn is_scroll_on_keystroke(&self) -> bool;

    #[doc(alias = "vte_terminal_get_scroll_on_output")]
    #[doc(alias = "get_scroll_on_output")]
    fn is_scroll_on_output(&self) -> bool;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_get_scroll_unit_is_pixels")]
    #[doc(alias = "get_scroll_unit_is_pixels")]
    fn is_scroll_unit_is_pixels(&self) -> bool;

    #[doc(alias = "vte_terminal_get_scrollback_lines")]
    #[doc(alias = "get_scrollback_lines")]
    fn scrollback_lines(&self) -> libc::c_long;

    //#[doc(alias = "vte_terminal_get_text")]
    //#[doc(alias = "get_text")]
    //fn text(&self, is_selected: Option<&mut dyn (FnMut(&Terminal, libc::c_long, libc::c_long) -> bool)>, attributes: /*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 1, id: 1 }) -> Option<glib::GString>;

    #[doc(alias = "vte_terminal_get_text_blink_mode")]
    #[doc(alias = "get_text_blink_mode")]
    fn text_blink_mode(&self) -> TextBlinkMode;

    //#[doc(alias = "vte_terminal_get_text_range")]
    //#[doc(alias = "get_text_range")]
    //fn text_range(&self, start_row: libc::c_long, start_col: libc::c_long, end_row: libc::c_long, end_col: libc::c_long, is_selected: Option<&mut dyn (FnMut(&Terminal, libc::c_long, libc::c_long) -> bool)>, attributes: /*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 1, id: 1 }) -> Option<glib::GString>;

    #[doc(alias = "vte_terminal_get_window_title")]
    #[doc(alias = "get_window_title")]
    fn window_title(&self) -> Option<glib::GString>;

    #[doc(alias = "vte_terminal_get_word_char_exceptions")]
    #[doc(alias = "get_word_char_exceptions")]
    fn word_char_exceptions(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_get_xalign")]
    #[doc(alias = "get_xalign")]
    fn xalign(&self) -> Align;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_get_yalign")]
    #[doc(alias = "get_yalign")]
    fn yalign(&self) -> Align;

    #[doc(alias = "vte_terminal_match_add_regex")]
    fn match_add_regex(&self, regex: &Regex, flags: u32) -> i32;

    #[doc(alias = "vte_terminal_match_remove")]
    fn match_remove(&self, tag: i32);

    #[doc(alias = "vte_terminal_match_remove_all")]
    fn match_remove_all(&self);

    #[doc(alias = "vte_terminal_match_set_cursor_name")]
    fn match_set_cursor_name(&self, tag: i32, cursor_name: &str);

    #[doc(alias = "vte_terminal_paste_clipboard")]
    fn paste_clipboard(&self);

    #[doc(alias = "vte_terminal_paste_primary")]
    fn paste_primary(&self);

    #[doc(alias = "vte_terminal_pty_new_sync")]
    fn pty_new_sync(
        &self,
        flags: PtyFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Pty, glib::Error>;

    #[doc(alias = "vte_terminal_reset")]
    fn reset(&self, clear_tabstops: bool, clear_history: bool);

    #[doc(alias = "vte_terminal_search_find_next")]
    fn search_find_next(&self) -> bool;

    #[doc(alias = "vte_terminal_search_find_previous")]
    fn search_find_previous(&self) -> bool;

    #[doc(alias = "vte_terminal_search_get_regex")]
    fn search_get_regex(&self) -> Option<Regex>;

    #[doc(alias = "vte_terminal_search_get_wrap_around")]
    fn search_get_wrap_around(&self) -> bool;

    #[doc(alias = "vte_terminal_search_set_regex")]
    fn search_set_regex(&self, regex: Option<&Regex>, flags: u32);

    #[doc(alias = "vte_terminal_search_set_wrap_around")]
    fn search_set_wrap_around(&self, wrap_around: bool);

    #[doc(alias = "vte_terminal_select_all")]
    fn select_all(&self);

    #[doc(alias = "vte_terminal_set_allow_hyperlink")]
    fn set_allow_hyperlink(&self, allow_hyperlink: bool);

    #[doc(alias = "vte_terminal_set_audible_bell")]
    fn set_audible_bell(&self, is_audible: bool);

    #[doc(alias = "vte_terminal_set_backspace_binding")]
    fn set_backspace_binding(&self, binding: EraseBinding);

    #[doc(alias = "vte_terminal_set_bold_is_bright")]
    fn set_bold_is_bright(&self, bold_is_bright: bool);

    #[doc(alias = "vte_terminal_set_cell_height_scale")]
    fn set_cell_height_scale(&self, scale: f64);

    #[doc(alias = "vte_terminal_set_cell_width_scale")]
    fn set_cell_width_scale(&self, scale: f64);

    #[doc(alias = "vte_terminal_set_cjk_ambiguous_width")]
    fn set_cjk_ambiguous_width(&self, width: i32);

    #[doc(alias = "vte_terminal_set_color_background")]
    fn set_color_background(&self, background: &gdk::RGBA);

    #[doc(alias = "vte_terminal_set_color_bold")]
    fn set_color_bold(&self, bold: Option<&gdk::RGBA>);

    #[doc(alias = "vte_terminal_set_color_cursor")]
    fn set_color_cursor(&self, cursor_background: Option<&gdk::RGBA>);

    #[doc(alias = "vte_terminal_set_color_cursor_foreground")]
    fn set_color_cursor_foreground(&self, cursor_foreground: Option<&gdk::RGBA>);

    #[doc(alias = "vte_terminal_set_color_foreground")]
    fn set_color_foreground(&self, foreground: &gdk::RGBA);

    #[doc(alias = "vte_terminal_set_color_highlight")]
    fn set_color_highlight(&self, highlight_background: Option<&gdk::RGBA>);

    #[doc(alias = "vte_terminal_set_color_highlight_foreground")]
    fn set_color_highlight_foreground(&self, highlight_foreground: Option<&gdk::RGBA>);

    #[doc(alias = "vte_terminal_set_cursor_blink_mode")]
    fn set_cursor_blink_mode(&self, mode: CursorBlinkMode);

    #[doc(alias = "vte_terminal_set_cursor_shape")]
    fn set_cursor_shape(&self, shape: CursorShape);

    #[doc(alias = "vte_terminal_set_default_colors")]
    fn set_default_colors(&self);

    #[doc(alias = "vte_terminal_set_delete_binding")]
    fn set_delete_binding(&self, binding: EraseBinding);

    #[doc(alias = "vte_terminal_set_enable_bidi")]
    fn set_enable_bidi(&self, enable_bidi: bool);

    #[doc(alias = "vte_terminal_set_enable_fallback_scrolling")]
    fn set_enable_fallback_scrolling(&self, enable: bool);

    #[doc(alias = "vte_terminal_set_enable_shaping")]
    fn set_enable_shaping(&self, enable_shaping: bool);

    #[doc(alias = "vte_terminal_set_enable_sixel")]
    fn set_enable_sixel(&self, enabled: bool);

    #[doc(alias = "vte_terminal_set_font")]
    fn set_font(&self, font_desc: Option<&pango::FontDescription>);

    #[doc(alias = "vte_terminal_set_font_scale")]
    fn set_font_scale(&self, scale: f64);

    #[doc(alias = "vte_terminal_set_input_enabled")]
    fn set_input_enabled(&self, enabled: bool);

    #[doc(alias = "vte_terminal_set_mouse_autohide")]
    fn set_mouse_autohide(&self, setting: bool);

    #[doc(alias = "vte_terminal_set_pty")]
    fn set_pty(&self, pty: Option<&Pty>);

    #[doc(alias = "vte_terminal_set_scroll_on_keystroke")]
    fn set_scroll_on_keystroke(&self, scroll: bool);

    #[doc(alias = "vte_terminal_set_scroll_on_output")]
    fn set_scroll_on_output(&self, scroll: bool);

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_set_scroll_unit_is_pixels")]
    fn set_scroll_unit_is_pixels(&self, enable: bool);

    #[doc(alias = "vte_terminal_set_scrollback_lines")]
    fn set_scrollback_lines(&self, lines: libc::c_long);

    #[doc(alias = "vte_terminal_set_size")]
    fn set_size(&self, columns: libc::c_long, rows: libc::c_long);

    #[doc(alias = "vte_terminal_set_text_blink_mode")]
    fn set_text_blink_mode(&self, text_blink_mode: TextBlinkMode);

    #[doc(alias = "vte_terminal_set_word_char_exceptions")]
    fn set_word_char_exceptions(&self, exceptions: &str);

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_set_xalign")]
    fn set_xalign(&self, align: Align);

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "vte_terminal_set_yalign")]
    fn set_yalign(&self, align: Align);

    #[doc(alias = "vte_terminal_spawn_async")]
    fn spawn_async(
        &self,
        pty_flags: PtyFlags,
        working_directory: Option<&str>,
        argv: &[&std::path::Path],
        envv: &[&std::path::Path],
        spawn_flags: glib::SpawnFlags,
        child_setup: Option<Box_<dyn Fn() + 'static>>,
        timeout: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
    );

    #[doc(alias = "vte_terminal_spawn_with_fds_async")]
    fn spawn_with_fds_async(
        &self,
        pty_flags: PtyFlags,
        working_directory: Option<&str>,
        argv: &[&std::path::Path],
        envv: &[&std::path::Path],
        fds: &[i32],
        map_fds: &[i32],
        spawn_flags: glib::SpawnFlags,
        child_setup: Option<Box_<dyn Fn() + 'static>>,
        timeout: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
    );

    #[doc(alias = "vte_terminal_unselect_all")]
    fn unselect_all(&self);

    #[doc(alias = "vte_terminal_write_contents_sync")]
    fn write_contents_sync(
        &self,
        stream: &impl IsA<gio::OutputStream>,
        flags: WriteFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "backspace-binding")]
    fn backspace_binding(&self) -> EraseBinding;

    #[doc(alias = "delete-binding")]
    fn delete_binding(&self) -> EraseBinding;

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription>;

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>);

    #[doc(alias = "hyperlink-hover-uri")]
    fn hyperlink_hover_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "pointer-autohide")]
    fn is_pointer_autohide(&self) -> bool;

    #[doc(alias = "pointer-autohide")]
    fn set_pointer_autohide(&self, pointer_autohide: bool);

    #[doc(alias = "bell")]
    fn connect_bell<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "char-size-changed")]
    fn connect_char_size_changed<F: Fn(&Self, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child-exited")]
    fn connect_child_exited<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "commit")]
    fn connect_commit<F: Fn(&Self, &str, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "contents-changed")]
    fn connect_contents_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "copy-clipboard")]
    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    #[doc(alias = "current-directory-uri-changed")]
    fn connect_current_directory_uri_changed<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "current-file-uri-changed")]
    fn connect_current_file_uri_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-moved")]
    fn connect_cursor_moved<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "decrease-font-size")]
    fn connect_decrease_font_size<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "encoding-changed")]
    fn connect_encoding_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "eof")]
    fn connect_eof<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    //#[doc(alias = "hyperlink-hover-uri-changed")]
    //fn connect_hyperlink_hover_uri_changed<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "increase-font-size")]
    fn connect_increase_font_size<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paste-clipboard")]
    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_paste_clipboard(&self);

    #[doc(alias = "resize-window")]
    fn connect_resize_window<F: Fn(&Self, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "selection-changed")]
    fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "window-title-changed")]
    fn connect_window_title_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "allow-hyperlink")]
    fn connect_allow_hyperlink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "audible-bell")]
    fn connect_audible_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "backspace-binding")]
    fn connect_backspace_binding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "bold-is-bright")]
    fn connect_bold_is_bright_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cell-height-scale")]
    fn connect_cell_height_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cell-width-scale")]
    fn connect_cell_width_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cjk-ambiguous-width")]
    fn connect_cjk_ambiguous_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "current-directory-uri")]
    fn connect_current_directory_uri_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "current-file-uri")]
    fn connect_current_file_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-blink-mode")]
    fn connect_cursor_blink_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-shape")]
    fn connect_cursor_shape_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "delete-binding")]
    fn connect_delete_binding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-bidi")]
    fn connect_enable_bidi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-fallback-scrolling")]
    fn connect_enable_fallback_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "enable-shaping")]
    fn connect_enable_shaping_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-sixel")]
    fn connect_enable_sixel_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-scale")]
    fn connect_font_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hyperlink-hover-uri")]
    fn connect_hyperlink_hover_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-enabled")]
    fn connect_input_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pointer-autohide")]
    fn connect_pointer_autohide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pty")]
    fn connect_pty_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-on-keystroke")]
    fn connect_scroll_on_keystroke_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-on-output")]
    fn connect_scroll_on_output_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "scroll-unit-is-pixels")]
    fn connect_scroll_unit_is_pixels_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "scrollback-lines")]
    fn connect_scrollback_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text-blink-mode")]
    fn connect_text_blink_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "window-title")]
    fn connect_window_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "word-char-exceptions")]
    fn connect_word_char_exceptions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "xalign")]
    fn connect_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    #[doc(alias = "yalign")]
    fn connect_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Terminal>> TerminalExt for O {
    fn copy_clipboard_format(&self, format: Format) {
        unsafe {
            ffi::vte_terminal_copy_clipboard_format(
                self.as_ref().to_glib_none().0,
                format.into_glib(),
            );
        }
    }

    fn copy_primary(&self) {
        unsafe {
            ffi::vte_terminal_copy_primary(self.as_ref().to_glib_none().0);
        }
    }

    fn feed(&self, data: &[u8]) {
        let length = data.len() as isize;
        unsafe {
            ffi::vte_terminal_feed(
                self.as_ref().to_glib_none().0,
                data.to_glib_none().0,
                length,
            );
        }
    }

    fn feed_child(&self, text: &[u8]) {
        let length = text.len() as isize;
        unsafe {
            ffi::vte_terminal_feed_child(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                length,
            );
        }
    }

    fn allows_hyperlink(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_allow_hyperlink(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_audible_bell(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_audible_bell(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_bold_is_bright(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_bold_is_bright(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cell_height_scale(&self) -> f64 {
        unsafe { ffi::vte_terminal_get_cell_height_scale(self.as_ref().to_glib_none().0) }
    }

    fn cell_width_scale(&self) -> f64 {
        unsafe { ffi::vte_terminal_get_cell_width_scale(self.as_ref().to_glib_none().0) }
    }

    fn char_height(&self) -> libc::c_long {
        unsafe { ffi::vte_terminal_get_char_height(self.as_ref().to_glib_none().0) }
    }

    fn char_width(&self) -> libc::c_long {
        unsafe { ffi::vte_terminal_get_char_width(self.as_ref().to_glib_none().0) }
    }

    fn cjk_ambiguous_width(&self) -> i32 {
        unsafe { ffi::vte_terminal_get_cjk_ambiguous_width(self.as_ref().to_glib_none().0) }
    }

    fn column_count(&self) -> libc::c_long {
        unsafe { ffi::vte_terminal_get_column_count(self.as_ref().to_glib_none().0) }
    }

    fn current_directory_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::vte_terminal_get_current_directory_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_file_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::vte_terminal_get_current_file_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cursor_blink_mode(&self) -> CursorBlinkMode {
        unsafe {
            from_glib(ffi::vte_terminal_get_cursor_blink_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cursor_position(&self) -> (libc::c_long, libc::c_long) {
        unsafe {
            let mut column = mem::MaybeUninit::uninit();
            let mut row = mem::MaybeUninit::uninit();
            ffi::vte_terminal_get_cursor_position(
                self.as_ref().to_glib_none().0,
                column.as_mut_ptr(),
                row.as_mut_ptr(),
            );
            let column = column.assume_init();
            let row = row.assume_init();
            (column, row)
        }
    }

    fn cursor_shape(&self) -> CursorShape {
        unsafe {
            from_glib(ffi::vte_terminal_get_cursor_shape(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_bidi(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_enable_bidi(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_fallback_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_enable_fallback_scrolling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_shaping(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_enable_shaping(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_sixel(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_enable_sixel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn font(&self) -> Option<pango::FontDescription> {
        unsafe { from_glib_none(ffi::vte_terminal_get_font(self.as_ref().to_glib_none().0)) }
    }

    fn font_scale(&self) -> f64 {
        unsafe { ffi::vte_terminal_get_font_scale(self.as_ref().to_glib_none().0) }
    }

    fn has_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_has_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_input_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_input_enabled(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_mouse_autohide(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_mouse_autohide(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn pty(&self) -> Option<Pty> {
        unsafe { from_glib_none(ffi::vte_terminal_get_pty(self.as_ref().to_glib_none().0)) }
    }

    fn row_count(&self) -> libc::c_long {
        unsafe { ffi::vte_terminal_get_row_count(self.as_ref().to_glib_none().0) }
    }

    fn is_scroll_on_keystroke(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_scroll_on_keystroke(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_scroll_on_output(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_scroll_on_output(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn is_scroll_unit_is_pixels(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_get_scroll_unit_is_pixels(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn scrollback_lines(&self) -> libc::c_long {
        unsafe { ffi::vte_terminal_get_scrollback_lines(self.as_ref().to_glib_none().0) }
    }

    //fn text(&self, is_selected: Option<&mut dyn (FnMut(&Terminal, libc::c_long, libc::c_long) -> bool)>, attributes: /*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 1, id: 1 }) -> Option<glib::GString> {
    //    unsafe { TODO: call ffi:vte_terminal_get_text() }
    //}

    fn text_blink_mode(&self) -> TextBlinkMode {
        unsafe {
            from_glib(ffi::vte_terminal_get_text_blink_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn text_range(&self, start_row: libc::c_long, start_col: libc::c_long, end_row: libc::c_long, end_col: libc::c_long, is_selected: Option<&mut dyn (FnMut(&Terminal, libc::c_long, libc::c_long) -> bool)>, attributes: /*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 1, id: 1 }) -> Option<glib::GString> {
    //    unsafe { TODO: call ffi:vte_terminal_get_text_range() }
    //}

    fn window_title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::vte_terminal_get_window_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn word_char_exceptions(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::vte_terminal_get_word_char_exceptions(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn xalign(&self) -> Align {
        unsafe { from_glib(ffi::vte_terminal_get_xalign(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn yalign(&self) -> Align {
        unsafe { from_glib(ffi::vte_terminal_get_yalign(self.as_ref().to_glib_none().0)) }
    }

    fn match_add_regex(&self, regex: &Regex, flags: u32) -> i32 {
        unsafe {
            ffi::vte_terminal_match_add_regex(
                self.as_ref().to_glib_none().0,
                regex.to_glib_none().0,
                flags,
            )
        }
    }

    fn match_remove(&self, tag: i32) {
        unsafe {
            ffi::vte_terminal_match_remove(self.as_ref().to_glib_none().0, tag);
        }
    }

    fn match_remove_all(&self) {
        unsafe {
            ffi::vte_terminal_match_remove_all(self.as_ref().to_glib_none().0);
        }
    }

    fn match_set_cursor_name(&self, tag: i32, cursor_name: &str) {
        unsafe {
            ffi::vte_terminal_match_set_cursor_name(
                self.as_ref().to_glib_none().0,
                tag,
                cursor_name.to_glib_none().0,
            );
        }
    }

    fn paste_clipboard(&self) {
        unsafe {
            ffi::vte_terminal_paste_clipboard(self.as_ref().to_glib_none().0);
        }
    }

    fn paste_primary(&self) {
        unsafe {
            ffi::vte_terminal_paste_primary(self.as_ref().to_glib_none().0);
        }
    }

    fn pty_new_sync(
        &self,
        flags: PtyFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Pty, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::vte_terminal_pty_new_sync(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn reset(&self, clear_tabstops: bool, clear_history: bool) {
        unsafe {
            ffi::vte_terminal_reset(
                self.as_ref().to_glib_none().0,
                clear_tabstops.into_glib(),
                clear_history.into_glib(),
            );
        }
    }

    fn search_find_next(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_search_find_next(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_find_previous(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_search_find_previous(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_get_regex(&self) -> Option<Regex> {
        unsafe {
            from_glib_none(ffi::vte_terminal_search_get_regex(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_get_wrap_around(&self) -> bool {
        unsafe {
            from_glib(ffi::vte_terminal_search_get_wrap_around(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_set_regex(&self, regex: Option<&Regex>, flags: u32) {
        unsafe {
            ffi::vte_terminal_search_set_regex(
                self.as_ref().to_glib_none().0,
                regex.to_glib_none().0,
                flags,
            );
        }
    }

    fn search_set_wrap_around(&self, wrap_around: bool) {
        unsafe {
            ffi::vte_terminal_search_set_wrap_around(
                self.as_ref().to_glib_none().0,
                wrap_around.into_glib(),
            );
        }
    }

    fn select_all(&self) {
        unsafe {
            ffi::vte_terminal_select_all(self.as_ref().to_glib_none().0);
        }
    }

    fn set_allow_hyperlink(&self, allow_hyperlink: bool) {
        unsafe {
            ffi::vte_terminal_set_allow_hyperlink(
                self.as_ref().to_glib_none().0,
                allow_hyperlink.into_glib(),
            );
        }
    }

    fn set_audible_bell(&self, is_audible: bool) {
        unsafe {
            ffi::vte_terminal_set_audible_bell(
                self.as_ref().to_glib_none().0,
                is_audible.into_glib(),
            );
        }
    }

    fn set_backspace_binding(&self, binding: EraseBinding) {
        unsafe {
            ffi::vte_terminal_set_backspace_binding(
                self.as_ref().to_glib_none().0,
                binding.into_glib(),
            );
        }
    }

    fn set_bold_is_bright(&self, bold_is_bright: bool) {
        unsafe {
            ffi::vte_terminal_set_bold_is_bright(
                self.as_ref().to_glib_none().0,
                bold_is_bright.into_glib(),
            );
        }
    }

    fn set_cell_height_scale(&self, scale: f64) {
        unsafe {
            ffi::vte_terminal_set_cell_height_scale(self.as_ref().to_glib_none().0, scale);
        }
    }

    fn set_cell_width_scale(&self, scale: f64) {
        unsafe {
            ffi::vte_terminal_set_cell_width_scale(self.as_ref().to_glib_none().0, scale);
        }
    }

    fn set_cjk_ambiguous_width(&self, width: i32) {
        unsafe {
            ffi::vte_terminal_set_cjk_ambiguous_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn set_color_background(&self, background: &gdk::RGBA) {
        unsafe {
            ffi::vte_terminal_set_color_background(
                self.as_ref().to_glib_none().0,
                background.to_glib_none().0,
            );
        }
    }

    fn set_color_bold(&self, bold: Option<&gdk::RGBA>) {
        unsafe {
            ffi::vte_terminal_set_color_bold(self.as_ref().to_glib_none().0, bold.to_glib_none().0);
        }
    }

    fn set_color_cursor(&self, cursor_background: Option<&gdk::RGBA>) {
        unsafe {
            ffi::vte_terminal_set_color_cursor(
                self.as_ref().to_glib_none().0,
                cursor_background.to_glib_none().0,
            );
        }
    }

    fn set_color_cursor_foreground(&self, cursor_foreground: Option<&gdk::RGBA>) {
        unsafe {
            ffi::vte_terminal_set_color_cursor_foreground(
                self.as_ref().to_glib_none().0,
                cursor_foreground.to_glib_none().0,
            );
        }
    }

    fn set_color_foreground(&self, foreground: &gdk::RGBA) {
        unsafe {
            ffi::vte_terminal_set_color_foreground(
                self.as_ref().to_glib_none().0,
                foreground.to_glib_none().0,
            );
        }
    }

    fn set_color_highlight(&self, highlight_background: Option<&gdk::RGBA>) {
        unsafe {
            ffi::vte_terminal_set_color_highlight(
                self.as_ref().to_glib_none().0,
                highlight_background.to_glib_none().0,
            );
        }
    }

    fn set_color_highlight_foreground(&self, highlight_foreground: Option<&gdk::RGBA>) {
        unsafe {
            ffi::vte_terminal_set_color_highlight_foreground(
                self.as_ref().to_glib_none().0,
                highlight_foreground.to_glib_none().0,
            );
        }
    }

    fn set_cursor_blink_mode(&self, mode: CursorBlinkMode) {
        unsafe {
            ffi::vte_terminal_set_cursor_blink_mode(
                self.as_ref().to_glib_none().0,
                mode.into_glib(),
            );
        }
    }

    fn set_cursor_shape(&self, shape: CursorShape) {
        unsafe {
            ffi::vte_terminal_set_cursor_shape(self.as_ref().to_glib_none().0, shape.into_glib());
        }
    }

    fn set_default_colors(&self) {
        unsafe {
            ffi::vte_terminal_set_default_colors(self.as_ref().to_glib_none().0);
        }
    }

    fn set_delete_binding(&self, binding: EraseBinding) {
        unsafe {
            ffi::vte_terminal_set_delete_binding(
                self.as_ref().to_glib_none().0,
                binding.into_glib(),
            );
        }
    }

    fn set_enable_bidi(&self, enable_bidi: bool) {
        unsafe {
            ffi::vte_terminal_set_enable_bidi(
                self.as_ref().to_glib_none().0,
                enable_bidi.into_glib(),
            );
        }
    }

    fn set_enable_fallback_scrolling(&self, enable: bool) {
        unsafe {
            ffi::vte_terminal_set_enable_fallback_scrolling(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_enable_shaping(&self, enable_shaping: bool) {
        unsafe {
            ffi::vte_terminal_set_enable_shaping(
                self.as_ref().to_glib_none().0,
                enable_shaping.into_glib(),
            );
        }
    }

    fn set_enable_sixel(&self, enabled: bool) {
        unsafe {
            ffi::vte_terminal_set_enable_sixel(self.as_ref().to_glib_none().0, enabled.into_glib());
        }
    }

    fn set_font(&self, font_desc: Option<&pango::FontDescription>) {
        unsafe {
            ffi::vte_terminal_set_font(self.as_ref().to_glib_none().0, font_desc.to_glib_none().0);
        }
    }

    fn set_font_scale(&self, scale: f64) {
        unsafe {
            ffi::vte_terminal_set_font_scale(self.as_ref().to_glib_none().0, scale);
        }
    }

    fn set_input_enabled(&self, enabled: bool) {
        unsafe {
            ffi::vte_terminal_set_input_enabled(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    fn set_mouse_autohide(&self, setting: bool) {
        unsafe {
            ffi::vte_terminal_set_mouse_autohide(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_pty(&self, pty: Option<&Pty>) {
        unsafe {
            ffi::vte_terminal_set_pty(self.as_ref().to_glib_none().0, pty.to_glib_none().0);
        }
    }

    fn set_scroll_on_keystroke(&self, scroll: bool) {
        unsafe {
            ffi::vte_terminal_set_scroll_on_keystroke(
                self.as_ref().to_glib_none().0,
                scroll.into_glib(),
            );
        }
    }

    fn set_scroll_on_output(&self, scroll: bool) {
        unsafe {
            ffi::vte_terminal_set_scroll_on_output(
                self.as_ref().to_glib_none().0,
                scroll.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn set_scroll_unit_is_pixels(&self, enable: bool) {
        unsafe {
            ffi::vte_terminal_set_scroll_unit_is_pixels(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_scrollback_lines(&self, lines: libc::c_long) {
        unsafe {
            ffi::vte_terminal_set_scrollback_lines(self.as_ref().to_glib_none().0, lines);
        }
    }

    fn set_size(&self, columns: libc::c_long, rows: libc::c_long) {
        unsafe {
            ffi::vte_terminal_set_size(self.as_ref().to_glib_none().0, columns, rows);
        }
    }

    fn set_text_blink_mode(&self, text_blink_mode: TextBlinkMode) {
        unsafe {
            ffi::vte_terminal_set_text_blink_mode(
                self.as_ref().to_glib_none().0,
                text_blink_mode.into_glib(),
            );
        }
    }

    fn set_word_char_exceptions(&self, exceptions: &str) {
        unsafe {
            ffi::vte_terminal_set_word_char_exceptions(
                self.as_ref().to_glib_none().0,
                exceptions.to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn set_xalign(&self, align: Align) {
        unsafe {
            ffi::vte_terminal_set_xalign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn set_yalign(&self, align: Align) {
        unsafe {
            ffi::vte_terminal_set_yalign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    fn spawn_async(
        &self,
        pty_flags: PtyFlags,
        working_directory: Option<&str>,
        argv: &[&std::path::Path],
        envv: &[&std::path::Path],
        spawn_flags: glib::SpawnFlags,
        child_setup: Option<Box_<dyn Fn() + 'static>>,
        timeout: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
    ) {
        let child_setup_data: Box_<Option<Box_<dyn Fn() + 'static>>> = Box_::new(child_setup);
        unsafe extern "C" fn child_setup_func(user_data: glib::ffi::gpointer) {
            let callback: &Option<Box_<dyn Fn() + 'static>> = &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback()
            } else {
                panic!("cannot get closure...")
            };
        }
        let child_setup = if child_setup_data.is_some() {
            Some(child_setup_func as _)
        } else {
            None
        };
        let callback_data: Box_<
            Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
        > = Box_::new(callback);
        unsafe extern "C" fn callback_func(
            terminal: *mut ffi::VteTerminal,
            pid: glib::ffi::GPid,
            error: *mut glib::ffi::GError,
            user_data: glib::ffi::gpointer,
        ) {
            let terminal = from_glib_borrow(terminal);
            let pid = from_glib(pid);
            let error = from_glib_borrow(error);
            let callback: Box_<
                Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
            > = Box_::from_raw(user_data as *mut _);
            let callback = (*callback).expect("cannot get closure...");
            callback(&terminal, pid, &error)
        }
        let callback = if callback_data.is_some() {
            Some(callback_func as _)
        } else {
            None
        };
        unsafe extern "C" fn child_setup_data_destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn() + 'static>>> = Box_::from_raw(data as *mut _);
        }
        let destroy_call8 = Some(child_setup_data_destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn() + 'static>>> = child_setup_data;
        let super_callback1: Box_<
            Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
        > = callback_data;
        unsafe {
            ffi::vte_terminal_spawn_async(
                self.as_ref().to_glib_none().0,
                pty_flags.into_glib(),
                working_directory.to_glib_none().0,
                argv.to_glib_none().0,
                envv.to_glib_none().0,
                spawn_flags.into_glib(),
                child_setup,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call8,
                timeout,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                callback,
                Box_::into_raw(super_callback1) as *mut _,
            );
        }
    }

    fn spawn_with_fds_async(
        &self,
        pty_flags: PtyFlags,
        working_directory: Option<&str>,
        argv: &[&std::path::Path],
        envv: &[&std::path::Path],
        fds: &[i32],
        map_fds: &[i32],
        spawn_flags: glib::SpawnFlags,
        child_setup: Option<Box_<dyn Fn() + 'static>>,
        timeout: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
    ) {
        let n_fds = fds.len() as i32;
        let n_map_fds = map_fds.len() as i32;
        let child_setup_data: Box_<Option<Box_<dyn Fn() + 'static>>> = Box_::new(child_setup);
        unsafe extern "C" fn child_setup_func(user_data: glib::ffi::gpointer) {
            let callback: &Option<Box_<dyn Fn() + 'static>> = &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback()
            } else {
                panic!("cannot get closure...")
            };
        }
        let child_setup = if child_setup_data.is_some() {
            Some(child_setup_func as _)
        } else {
            None
        };
        let callback_data: Box_<
            Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
        > = Box_::new(callback);
        unsafe extern "C" fn callback_func(
            terminal: *mut ffi::VteTerminal,
            pid: glib::ffi::GPid,
            error: *mut glib::ffi::GError,
            user_data: glib::ffi::gpointer,
        ) {
            let terminal = from_glib_borrow(terminal);
            let pid = from_glib(pid);
            let error = from_glib_borrow(error);
            let callback: Box_<
                Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
            > = Box_::from_raw(user_data as *mut _);
            let callback = (*callback).expect("cannot get closure...");
            callback(&terminal, pid, &error)
        }
        let callback = if callback_data.is_some() {
            Some(callback_func as _)
        } else {
            None
        };
        unsafe extern "C" fn child_setup_data_destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn() + 'static>>> = Box_::from_raw(data as *mut _);
        }
        let destroy_call12 = Some(child_setup_data_destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn() + 'static>>> = child_setup_data;
        let super_callback1: Box_<
            Option<Box_<dyn FnOnce(&Terminal, glib::Pid, &glib::Error) + 'static>>,
        > = callback_data;
        unsafe {
            ffi::vte_terminal_spawn_with_fds_async(
                self.as_ref().to_glib_none().0,
                pty_flags.into_glib(),
                working_directory.to_glib_none().0,
                argv.to_glib_none().0,
                envv.to_glib_none().0,
                fds.to_glib_none().0,
                n_fds,
                map_fds.to_glib_none().0,
                n_map_fds,
                spawn_flags.into_glib(),
                child_setup,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call12,
                timeout,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                callback,
                Box_::into_raw(super_callback1) as *mut _,
            );
        }
    }

    fn unselect_all(&self) {
        unsafe {
            ffi::vte_terminal_unselect_all(self.as_ref().to_glib_none().0);
        }
    }

    fn write_contents_sync(
        &self,
        stream: &impl IsA<gio::OutputStream>,
        flags: WriteFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::vte_terminal_write_contents_sync(
                self.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn backspace_binding(&self) -> EraseBinding {
        glib::ObjectExt::property(self.as_ref(), "backspace-binding")
    }

    fn delete_binding(&self) -> EraseBinding {
        glib::ObjectExt::property(self.as_ref(), "delete-binding")
    }

    fn font_desc(&self) -> Option<pango::FontDescription> {
        glib::ObjectExt::property(self.as_ref(), "font-desc")
    }

    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        glib::ObjectExt::set_property(self.as_ref(), "font-desc", &font_desc)
    }

    fn hyperlink_hover_uri(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "hyperlink-hover-uri")
    }

    fn is_pointer_autohide(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "pointer-autohide")
    }

    fn set_pointer_autohide(&self, pointer_autohide: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "pointer-autohide", &pointer_autohide)
    }

    fn connect_bell<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn bell_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"bell\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    bell_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_char_size_changed<F: Fn(&Self, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn char_size_changed_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P, u32, u32) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            width: libc::c_uint,
            height: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Terminal::from_glib_borrow(this).unsafe_cast_ref(),
                width,
                height,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"char-size-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    char_size_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_exited<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn child_exited_trampoline<P: IsA<Terminal>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::VteTerminal,
            status: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref(), status)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"child-exited\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    child_exited_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_commit<F: Fn(&Self, &str, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn commit_trampoline<P: IsA<Terminal>, F: Fn(&P, &str, u32) + 'static>(
            this: *mut ffi::VteTerminal,
            text: *mut libc::c_char,
            size: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Terminal::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(text),
                size,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"commit\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    commit_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_contents_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn contents_changed_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"contents-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    contents_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        self.emit_by_name::<()>("copy-clipboard", &[]);
    }

    fn connect_current_directory_uri_changed<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn current_directory_uri_changed_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"current-directory-uri-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    current_directory_uri_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_current_file_uri_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn current_file_uri_changed_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"current-file-uri-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    current_file_uri_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_moved<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cursor_moved_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cursor-moved\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cursor_moved_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_decrease_font_size<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn decrease_font_size_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"decrease-font-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    decrease_font_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_encoding_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn encoding_changed_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"encoding-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    encoding_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_eof<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn eof_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"eof\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    eof_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_hyperlink_hover_uri_changed<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Ignored bbox: Gdk.Rectangle
    //}

    fn connect_increase_font_size<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn increase_font_size_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"increase-font-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    increase_font_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        self.emit_by_name::<()>("paste-clipboard", &[]);
    }

    fn connect_resize_window<F: Fn(&Self, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn resize_window_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P, u32, u32) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            width: libc::c_uint,
            height: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Terminal::from_glib_borrow(this).unsafe_cast_ref(),
                width,
                height,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"resize-window\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    resize_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selection_changed_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_window_title_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn window_title_changed_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"window-title-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    window_title_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_allow_hyperlink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_hyperlink_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-hyperlink\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_hyperlink_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_audible_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_audible_bell_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::audible-bell\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_audible_bell_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_backspace_binding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_backspace_binding_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::backspace-binding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_backspace_binding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_bold_is_bright_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_bold_is_bright_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::bold-is-bright\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_bold_is_bright_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cell_height_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cell_height_scale_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cell-height-scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cell_height_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cell_width_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cell_width_scale_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cell-width-scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cell_width_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cjk_ambiguous_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cjk_ambiguous_width_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cjk-ambiguous-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cjk_ambiguous_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_current_directory_uri_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_directory_uri_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::current-directory-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_current_directory_uri_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_current_file_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_file_uri_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::current-file-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_current_file_uri_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_blink_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_blink_mode_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-blink-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_blink_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_shape_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_shape_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-shape\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_shape_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_delete_binding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_delete_binding_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::delete-binding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_delete_binding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_bidi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_bidi_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-bidi\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_bidi_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_fallback_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_fallback_scrolling_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-fallback-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_fallback_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_shaping_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_shaping_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-shaping\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_shaping_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_sixel_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_sixel_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-sixel\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_sixel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_scale_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hyperlink_hover_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hyperlink_hover_uri_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hyperlink-hover-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hyperlink_hover_uri_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_enabled_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-enabled\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_enabled_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pointer_autohide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pointer_autohide_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pointer-autohide\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pointer_autohide_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pty_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pty_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pty\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pty_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scroll_on_keystroke_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_on_keystroke_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-on-keystroke\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_on_keystroke_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scroll_on_output_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_on_output_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-on-output\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_on_output_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn connect_scroll_unit_is_pixels_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_unit_is_pixels_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-unit-is-pixels\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_unit_is_pixels_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scrollback_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scrollback_lines_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scrollback-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scrollback_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_blink_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_blink_mode_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-blink-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_blink_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_window_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_title_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_word_char_exceptions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_word_char_exceptions_trampoline<
            P: IsA<Terminal>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::word-char-exceptions\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_word_char_exceptions_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn connect_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xalign_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::xalign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_xalign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v0_66", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_66")))]
    fn connect_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_yalign_trampoline<P: IsA<Terminal>, F: Fn(&P) + 'static>(
            this: *mut ffi::VteTerminal,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Terminal::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::yalign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_yalign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Terminal {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Terminal")
    }
}
