// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::PtyFlags;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::translate::*;
use glib::StaticType;
use std::fmt;
use std::mem;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "VtePty")]
    pub struct Pty(Object<ffi::VtePty, ffi::VtePtyClass>);

    match fn {
        type_ => || ffi::vte_pty_get_type(),
    }
}

impl Pty {
    #[doc(alias = "vte_pty_new_foreign_sync")]
    #[doc(alias = "new_foreign_sync")]
    pub fn foreign_sync(
        fd: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Pty, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::vte_pty_new_foreign_sync(
                fd,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "vte_pty_new_sync")]
    pub fn new_sync(
        flags: PtyFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Pty, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::vte_pty_new_sync(
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "vte_pty_child_setup")]
    pub fn child_setup(&self) {
        unsafe {
            ffi::vte_pty_child_setup(self.to_glib_none().0);
        }
    }

    #[doc(alias = "vte_pty_get_fd")]
    #[doc(alias = "get_fd")]
    pub fn fd(&self) -> i32 {
        unsafe { ffi::vte_pty_get_fd(self.to_glib_none().0) }
    }

    #[doc(alias = "vte_pty_get_size")]
    #[doc(alias = "get_size")]
    pub fn size(&self) -> Result<(i32, i32), glib::Error> {
        unsafe {
            let mut rows = mem::MaybeUninit::uninit();
            let mut columns = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let is_ok = ffi::vte_pty_get_size(
                self.to_glib_none().0,
                rows.as_mut_ptr(),
                columns.as_mut_ptr(),
                &mut error,
            );
            let rows = rows.assume_init();
            let columns = columns.assume_init();
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok((rows, columns))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "vte_pty_set_size")]
    pub fn set_size(&self, rows: i32, columns: i32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::vte_pty_set_size(self.to_glib_none().0, rows, columns, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "vte_pty_set_utf8")]
    pub fn set_utf8(&self, utf8: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::vte_pty_set_utf8(self.to_glib_none().0, utf8.into_glib(), &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //#[doc(alias = "vte_pty_spawn_async")]
    //pub fn spawn_async<P: FnOnce(Result<glib::Pid, glib::Error>) + Send + 'static>(&self, working_directory: Option<&str>, argv: &[&std::path::Path], envv: &[&std::path::Path], spawn_flags: glib::SpawnFlags, child_setup: Option<Box_<dyn Fn() + 'static>>, child_setup_data_destroy: Fn() + 'static, timeout: i32, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: P) {
    //    unsafe { TODO: call ffi:vte_pty_spawn_async() }
    //}

    //
    //pub fn spawn_future(&self, working_directory: Option<&str>, argv: &[&std::path::Path], envv: &[&std::path::Path], spawn_flags: glib::SpawnFlags, child_setup: Option<Box_<dyn Fn() + 'static>>, child_setup_data_destroy: Fn() + 'static, timeout: i32) -> Pin<Box_<dyn std::future::Future<Output = Result<, >> + 'static>> {

    //let working_directory = working_directory.map(ToOwned::to_owned);
    //let argv = argv.clone();
    //let envv = envv.map(ToOwned::to_owned);
    //let child_setup = child_setup.map(ToOwned::to_owned);
    //let child_setup_data_destroy = child_setup_data_destroy.map(ToOwned::to_owned);
    //Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.spawn_async(
    //        working_directory.as_ref().map(::std::borrow::Borrow::borrow),
    //        &argv,
    //        envv.as_ref().map(::std::borrow::Borrow::borrow),
    //        spawn_flags,
    //        child_setup.as_ref().map(::std::borrow::Borrow::borrow),
    //        child_setup_data_destroy.as_ref().map(::std::borrow::Borrow::borrow),
    //        timeout,
    //        Some(cancellable),
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    //#[doc(alias = "vte_pty_spawn_with_fds_async")]
    //pub fn spawn_with_fds_async<P: FnOnce(Result<(), glib::Error>) + 'static>(&self, working_directory: Option<&str>, argv: &[&std::path::Path], envv: &[&std::path::Path], fds: &[i32], map_fds: &[i32], spawn_flags: glib::SpawnFlags, child_setup: Option<Box_<dyn Fn() + 'static>>, child_setup_data_destroy: Fn() + 'static, timeout: i32, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: P) {
    //    unsafe { TODO: call ffi:vte_pty_spawn_with_fds_async() }
    //}

    //
    //pub fn spawn_with_fds_future(&self, working_directory: Option<&str>, argv: &[&std::path::Path], envv: &[&std::path::Path], fds: &[i32], map_fds: &[i32], spawn_flags: glib::SpawnFlags, child_setup: Option<Box_<dyn Fn() + 'static>>, child_setup_data_destroy: Fn() + 'static, timeout: i32) -> Pin<Box_<dyn std::future::Future<Output = Result<, >> + 'static>> {

    //let working_directory = working_directory.map(ToOwned::to_owned);
    //let argv = argv.clone();
    //let envv = envv.map(ToOwned::to_owned);
    //let fds = fds.map(ToOwned::to_owned);
    //let map_fds = map_fds.map(ToOwned::to_owned);
    //let child_setup = child_setup.map(ToOwned::to_owned);
    //let child_setup_data_destroy = child_setup_data_destroy.map(ToOwned::to_owned);
    //Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.spawn_with_fds_async(
    //        working_directory.as_ref().map(::std::borrow::Borrow::borrow),
    //        &argv,
    //        envv.as_ref().map(::std::borrow::Borrow::borrow),
    //        fds.as_ref().map(::std::borrow::Borrow::borrow),
    //        map_fds.as_ref().map(::std::borrow::Borrow::borrow),
    //        spawn_flags,
    //        child_setup.as_ref().map(::std::borrow::Borrow::borrow),
    //        child_setup_data_destroy.as_ref().map(::std::borrow::Borrow::borrow),
    //        timeout,
    //        Some(cancellable),
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    pub fn flags(&self) -> PtyFlags {
        glib::ObjectExt::property(self, "flags")
    }
}

impl fmt::Display for Pty {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Pty")
    }
}
