# Contributing to vSMTP

Thanks for considering helping this project. There are many ways you can help.

There are opportunities to contribute to vSMTP at any level : using the software
and reporting bugs and usability issues, making improvements to the code, to the
documentation and finding security bugs.

## Reporting bugs

If you believe that you have uncovered a bug, please file a
[github issue](https://github.com/viridIT/vSMTP/issues). Include as much
information as possible : at least a description of the behavior you are seeing
and a simple test case we can use to recreate the problem on our own.

Please do not report security bugs by filing a github issue. Just follow the
procedure described in the
[SECURITY](https://github.com/viridIT/vSMTP/blob/doc/misc/SECURITY.md) file.

## Getting help

If you have reviewed existing documentation and still have questions or are
having problems, you can open a
[GitHub discussion](https://github.com/tokio-rs/tokio/discussions/new) asking
for help. After receiving a response, feel free to contribute by opening some PR
documentation that will help others avoid any issues you have encountered.

## Code changes

Even tiny pull requests (e.g., fixing a typo in API documentation) are greatly
appreciated.\
Before making a large change, it is usually a good idea to first open an issue
describing the change to solicit feedback and guidance.

Feel free to submit a PR even if the work is not totally finished, for feedback
or to hand-over. Prefer not to reference github issue or PR numbers in commits
and try to keep code formatting commits separate from functional commits.

## Testing

If the change being proposed alters code, the pull request should include one or
more tests to ensure that vSMTP does not regress in the future. Please follow
instructions described in the
[testing policies](https://github.com/viridIT/vSMTP/blob/develop/TESTING.md)
file.

PRs which cause test failures or a significant coverage decrease are unlikely to
be accepted.

## Licensing

Contributions are made under the vSMTP project license.

## Conduct

vSMTP project and viridIT teams adheres to the principles described in the
[Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/version/1/4/code-of-conduct/).
This is the minimum behavior expected from all contributors. Instances of
violations of the Code of Conduct can be reported by contacting the project team
at [moderation@viridit.com](mailto:moderation@viridit.com).
