use wasm_bindgen::prelude::*;

#[wasm_bindgen]
extern {
    pub fn alert(s: &str);
}

#[wasm_bindgen]
pub fn greet(name: &str) {
    alert(&format!("Hello, {}!", name));
}

#[no_mangle]
pub extern fn print_hello_from_rust() {
    println!("Hello from Rust");
}

#[cfg(test)]
mod tests {
    use super::{
        print_hello_from_rust
    };

    #[test]
    fn test_print() {
        assert_eq!(print_hello_from_rust(), ());
    }
}
