/*
 * VRChat API Documentation
 *
 *
 * Contact: me@ariesclark.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct LimitedWorld {
    /// A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.
    #[serde(rename = "authorId")]
    pub author_id: String,
    #[serde(rename = "authorName")]
    pub author_name: String,
    #[serde(rename = "capacity")]
    pub capacity: i32,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "favorites")]
    pub favorites: i32,
    #[serde(rename = "heat")]
    pub heat: i32,
    /// WorldID be \"offline\" on User profiles if you are not friends with that user.
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "imageUrl")]
    pub image_url: String,
    #[serde(rename = "labsPublicationDate")]
    pub labs_publication_date: String,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "occupants")]
    pub occupants: i32,
    #[serde(rename = "organization")]
    pub organization: String,
    #[serde(rename = "popularity")]
    pub popularity: i32,
    #[serde(rename = "publicationDate")]
    pub publication_date: String,
    #[serde(rename = "releaseStatus")]
    pub release_status: crate::models::ReleaseStatus,
    #[serde(rename = "tags")]
    pub tags: Vec<String>,
    #[serde(rename = "thumbnailImageUrl")]
    pub thumbnail_image_url: String,
    #[serde(rename = "unityPackages")]
    pub unity_packages: Vec<crate::models::LimitedUnityPackage>,
    #[serde(rename = "updated_at")]
    pub updated_at: String,
}

impl LimitedWorld {
    pub fn new(author_id: String, author_name: String, capacity: i32, created_at: String, favorites: i32, heat: i32, id: String, image_url: String, labs_publication_date: String, name: String, occupants: i32, organization: String, popularity: i32, publication_date: String, release_status: crate::models::ReleaseStatus, tags: Vec<String>, thumbnail_image_url: String, unity_packages: Vec<crate::models::LimitedUnityPackage>, updated_at: String) -> LimitedWorld {
        LimitedWorld {
            author_id,
            author_name,
            capacity,
            created_at,
            favorites,
            heat,
            id,
            image_url,
            labs_publication_date,
            name,
            occupants,
            organization,
            popularity,
            publication_date,
            release_status,
            tags,
            thumbnail_image_url,
            unity_packages,
            updated_at,
        }
    }
}


