/*
 * VRChat API Documentation
 *
 *
 * The version of the OpenAPI document: 1.3.0
 * Contact: me@ruby.js.org
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UnityPackage {
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "assetUrl", skip_serializing_if = "Option::is_none")]
    pub asset_url: Option<String>,
    #[serde(rename = "assetUrlObject", skip_serializing_if = "Option::is_none")]
    pub asset_url_object: Option<serde_json::Value>,
    #[serde(rename = "pluginUrl", skip_serializing_if = "Option::is_none")]
    pub plugin_url: Option<String>,
    #[serde(rename = "pluginUrlObject", skip_serializing_if = "Option::is_none")]
    pub plugin_url_object: Option<serde_json::Value>,
    #[serde(rename = "unityVersion")]
    pub unity_version: String,
    #[serde(rename = "unitySortNumber", skip_serializing_if = "Option::is_none")]
    pub unity_sort_number: Option<f32>,
    #[serde(rename = "assetVersion")]
    pub asset_version: f32,
    /// This can be `standalonewindows` or `android`, but can also pretty much be any random Unity verison such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.
    #[serde(rename = "platform")]
    pub platform: String,
    #[serde(rename = "created_at", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
}

impl UnityPackage {
    pub fn new(id: String, unity_version: String, asset_version: f32, platform: String) -> UnityPackage {
        UnityPackage {
            id,
            asset_url: None,
            asset_url_object: None,
            plugin_url: None,
            plugin_url_object: None,
            unity_version,
            unity_sort_number: None,
            asset_version,
            platform,
            created_at: None,
        }
    }
}


