/*
 * VRChat API Documentation
 *
 *
 * The version of the OpenAPI document: 1.3.0
 * Contact: me@ruby.js.org
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CurrentUser {
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "username")]
    pub username: String,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "userIcon")]
    pub user_icon: String,
    #[serde(rename = "bio")]
    pub bio: String,
    #[serde(rename = "bioLinks")]
    pub bio_links: Vec<String>,
    #[serde(rename = "profilePicOverride")]
    pub profile_pic_override: String,
    #[serde(rename = "statusDescription")]
    pub status_description: String,
    #[serde(rename = "pastDisplayNames")]
    pub past_display_names: Vec<crate::models::PastDisplayName>,
    #[serde(rename = "hasEmail")]
    pub has_email: bool,
    #[serde(rename = "hasPendingEmail")]
    pub has_pending_email: bool,
    #[serde(rename = "obfuscatedEmail")]
    pub obfuscated_email: String,
    #[serde(rename = "obfuscatedPendingEmail")]
    pub obfuscated_pending_email: String,
    #[serde(rename = "emailVerified")]
    pub email_verified: bool,
    #[serde(rename = "hasBirthday")]
    pub has_birthday: bool,
    #[serde(rename = "unsubscribe")]
    pub unsubscribe: bool,
    #[serde(rename = "statusHistory")]
    pub status_history: Vec<String>,
    #[serde(rename = "statusFirstTime")]
    pub status_first_time: bool,
    #[serde(rename = "friends")]
    pub friends: Vec<String>,
    /// Always empty array.
    #[serde(rename = "friendGroupNames")]
    pub friend_group_names: Vec<String>,
    #[serde(rename = "currentAvatarImageUrl")]
    pub current_avatar_image_url: String,
    #[serde(rename = "currentAvatarThumbnailImageUrl")]
    pub current_avatar_thumbnail_image_url: String,
    #[serde(rename = "fallbackAvatar")]
    pub fallback_avatar: String,
    #[serde(rename = "currentAvatar")]
    pub current_avatar: String,
    #[serde(rename = "currentAvatarAssetUrl")]
    pub current_avatar_asset_url: String,
    #[serde(rename = "accountDeletionDate", skip_serializing_if = "Option::is_none")]
    pub account_deletion_date: Option<String>,
    #[serde(rename = "acceptedTOSVersion")]
    pub accepted_tos_version: f32,
    #[serde(rename = "steamId")]
    pub steam_id: String,
    #[serde(rename = "steamDetails")]
    pub steam_details: serde_json::Value,
    #[serde(rename = "oculusId")]
    pub oculus_id: String,
    #[serde(rename = "hasLoggedInFromClient")]
    pub has_logged_in_from_client: bool,
    #[serde(rename = "homeLocation")]
    pub home_location: String,
    #[serde(rename = "twoFactorAuthEnabled")]
    pub two_factor_auth_enabled: bool,
    #[serde(rename = "state")]
    pub state: crate::models::UserState,
    #[serde(rename = "tags")]
    pub tags: Vec<String>,
    #[serde(rename = "developerType")]
    pub developer_type: crate::models::DeveloperType,
    #[serde(rename = "last_login")]
    pub last_login: String,
    /// This can be `standalonewindows` or `android`, but can also pretty much be any random Unity verison such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.
    #[serde(rename = "last_platform")]
    pub last_platform: String,
    #[serde(rename = "allowAvatarCopying")]
    pub allow_avatar_copying: bool,
    #[serde(rename = "status")]
    pub status: crate::models::UserStatus,
    #[serde(rename = "date_joined")]
    pub date_joined: String,
    #[serde(rename = "isFriend")]
    pub is_friend: bool,
    #[serde(rename = "friendKey")]
    pub friend_key: String,
    #[serde(rename = "onlineFriends", skip_serializing_if = "Option::is_none")]
    pub online_friends: Option<Vec<String>>,
    #[serde(rename = "activeFriends", skip_serializing_if = "Option::is_none")]
    pub active_friends: Option<Vec<String>>,
    #[serde(rename = "offlineFriends", skip_serializing_if = "Option::is_none")]
    pub offline_friends: Option<Vec<String>>,
}

impl CurrentUser {
    pub fn new(id: String, username: String, display_name: String, user_icon: String, bio: String, bio_links: Vec<String>, profile_pic_override: String, status_description: String, past_display_names: Vec<crate::models::PastDisplayName>, has_email: bool, has_pending_email: bool, obfuscated_email: String, obfuscated_pending_email: String, email_verified: bool, has_birthday: bool, unsubscribe: bool, status_history: Vec<String>, status_first_time: bool, friends: Vec<String>, friend_group_names: Vec<String>, current_avatar_image_url: String, current_avatar_thumbnail_image_url: String, fallback_avatar: String, current_avatar: String, current_avatar_asset_url: String, accepted_tos_version: f32, steam_id: String, steam_details: serde_json::Value, oculus_id: String, has_logged_in_from_client: bool, home_location: String, two_factor_auth_enabled: bool, state: crate::models::UserState, tags: Vec<String>, developer_type: crate::models::DeveloperType, last_login: String, last_platform: String, allow_avatar_copying: bool, status: crate::models::UserStatus, date_joined: String, is_friend: bool, friend_key: String) -> CurrentUser {
        CurrentUser {
            id,
            username,
            display_name,
            user_icon,
            bio,
            bio_links,
            profile_pic_override,
            status_description,
            past_display_names,
            has_email,
            has_pending_email,
            obfuscated_email,
            obfuscated_pending_email,
            email_verified,
            has_birthday,
            unsubscribe,
            status_history,
            status_first_time,
            friends,
            friend_group_names,
            current_avatar_image_url,
            current_avatar_thumbnail_image_url,
            fallback_avatar,
            current_avatar,
            current_avatar_asset_url,
            account_deletion_date: None,
            accepted_tos_version,
            steam_id,
            steam_details,
            oculus_id,
            has_logged_in_from_client,
            home_location,
            two_factor_auth_enabled,
            state,
            tags,
            developer_type,
            last_login,
            last_platform,
            allow_avatar_copying,
            status,
            date_joined,
            is_friend,
            friend_key,
            online_friends: None,
            active_friends: None,
            offline_friends: None,
        }
    }
}


