/*
 * VRChat API Documentation
 *
 * ![VRChat API Banner](https://raw.githubusercontent.com/vrchatapi/vrchatapi.github.io/master/assets/apibanner.png)  # VRChat API Documentation This project is an [OPEN Open Source Project](https://openopensource.org)  Individuals making significant and valuable contributions are given commit-access to the project to contribute as they see fit. This project is more like an open wiki than a standard guarded open source project.  ## Disclaimer  This is the official response of the VRChat Team (from Tupper more specifically) on the usage of the VRChat API.  > **Use of the API using applications other than the approved methods (website, VRChat application) are not officially supported. You may use the API for your own application, but keep these guidelines in mind:** > * We do not provide documentation or support for the API. > * Do not make queries to the API more than once per 60 seconds. > * Abuse of the API may result in account termination. > * Access to API endpoints may break at any given time, with no warning.  As stated, this documentation was not created with the help of the official VRChat team. Therefore this documentation is not an official documentation of the VRChat API and may not be always up to date with the latest versions. If you find that a page or endpoint is not longer valid please create an issue and tell us so we can fix it.  ## Get in touch with us!  [https://discord.gg/qjZE9C9fkB#vrchat-api](https://discord.gg/qjZE9C9fkB)
 *
 * The version of the OpenAPI document: 1.0.1
 * Contact: me@ruby.js.org
 * Generated by: https://openapi-generator.tech
 */

/// FileVersion : 



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileVersion {
    /// Incremental version counter, can only be increased.
    #[serde(rename = "version")]
    pub version: f32,
    #[serde(rename = "status")]
    pub status: crate::models::FileStatus,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "file", skip_serializing_if = "Option::is_none")]
    pub file: Option<Box<crate::models::FileData>>,
    #[serde(rename = "delta", skip_serializing_if = "Option::is_none")]
    pub delta: Option<Box<crate::models::FileData>>,
    #[serde(rename = "signature", skip_serializing_if = "Option::is_none")]
    pub signature: Option<Box<crate::models::FileData>>,
    /// Usually only present if `true`
    #[serde(rename = "deleted", skip_serializing_if = "Option::is_none")]
    pub deleted: Option<bool>,
}

impl FileVersion {
    /// 
    pub fn new(version: f32, status: crate::models::FileStatus, created_at: String) -> FileVersion {
        FileVersion {
            version,
            status,
            created_at,
            file: None,
            delta: None,
            signature: None,
            deleted: None,
        }
    }
}


