/*
 * VRChat API Documentation
 *
 * ![VRChat API Banner](https://raw.githubusercontent.com/vrchatapi/vrchatapi.github.io/master/assets/apibanner.png)  # VRChat API Documentation This project is an [OPEN Open Source Project](https://openopensource.org)  Individuals making significant and valuable contributions are given commit-access to the project to contribute as they see fit. This project is more like an open wiki than a standard guarded open source project.  ## Disclaimer  This is the official response of the VRChat Team (from Tupper more specifically) on the usage of the VRChat API.  > **Use of the API using applications other than the approved methods (website, VRChat application) are not officially supported. You may use the API for your own application, but keep these guidelines in mind:** > * We do not provide documentation or support for the API. > * Do not make queries to the API more than once per 60 seconds. > * Abuse of the API may result in account termination. > * Access to API endpoints may break at any given time, with no warning.  As stated, this documentation was not created with the help of the official VRChat team. Therefore this documentation is not an official documentation of the VRChat API and may not be always up to date with the latest versions. If you find that a page or endpoint is not longer valid please create an issue and tell us so we can fix it.  ## Get in touch with us!  [https://discord.gg/qjZE9C9fkB#vrchat-api](https://discord.gg/qjZE9C9fkB)
 *
 * The version of the OpenAPI document: 1.0.1
 * Contact: me@ruby.js.org
 * Generated by: https://openapi-generator.tech
 */

/// World : 



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct World {
    #[serde(rename = "assetUrl")]
    pub asset_url: String,
    #[serde(rename = "assetUrlObject")]
    pub asset_url_object: serde_json::Value,
    #[serde(rename = "authorId")]
    pub author_id: String,
    #[serde(rename = "authorName")]
    pub author_name: String,
    #[serde(rename = "capacity")]
    pub capacity: f32,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "favorites", skip_serializing_if = "Option::is_none")]
    pub favorites: Option<f32>,
    #[serde(rename = "featured")]
    pub featured: bool,
    #[serde(rename = "heat")]
    pub heat: f32,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "imageUrl")]
    pub image_url: String,
    #[serde(rename = "instances", skip_serializing_if = "Option::is_none")]
    pub instances: Option<Vec<serde_json::Value>>,
    #[serde(rename = "labsPublicationDate")]
    pub labs_publication_date: String,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "namespace")]
    pub namespace: String,
    #[serde(rename = "occupants", skip_serializing_if = "Option::is_none")]
    pub occupants: Option<f32>,
    #[serde(rename = "organization")]
    pub organization: String,
    #[serde(rename = "pluginUrlObject")]
    pub plugin_url_object: serde_json::Value,
    #[serde(rename = "popularity")]
    pub popularity: f32,
    #[serde(rename = "previewYoutubeId", skip_serializing_if = "Option::is_none")]
    pub preview_youtube_id: Option<String>,
    #[serde(rename = "privateOccupants", skip_serializing_if = "Option::is_none")]
    pub private_occupants: Option<f32>,
    #[serde(rename = "publicOccupants", skip_serializing_if = "Option::is_none")]
    pub public_occupants: Option<f32>,
    #[serde(rename = "publicationDate")]
    pub publication_date: String,
    #[serde(rename = "releaseStatus")]
    pub release_status: crate::models::ReleaseStatus,
    #[serde(rename = "tags")]
    pub tags: Vec<String>,
    #[serde(rename = "thumbnailImageUrl")]
    pub thumbnail_image_url: String,
    #[serde(rename = "unityPackageUrlObject")]
    pub unity_package_url_object: serde_json::Value,
    #[serde(rename = "unityPackages")]
    pub unity_packages: Vec<crate::models::UnityPackage>,
    #[serde(rename = "updated_at")]
    pub updated_at: String,
    #[serde(rename = "version")]
    pub version: f32,
    #[serde(rename = "visits")]
    pub visits: f32,
}

impl World {
    /// 
    pub fn new(asset_url: String, asset_url_object: serde_json::Value, author_id: String, author_name: String, capacity: f32, created_at: String, description: String, featured: bool, heat: f32, id: String, image_url: String, labs_publication_date: String, name: String, namespace: String, organization: String, plugin_url_object: serde_json::Value, popularity: f32, publication_date: String, release_status: crate::models::ReleaseStatus, tags: Vec<String>, thumbnail_image_url: String, unity_package_url_object: serde_json::Value, unity_packages: Vec<crate::models::UnityPackage>, updated_at: String, version: f32, visits: f32) -> World {
        World {
            asset_url,
            asset_url_object,
            author_id,
            author_name,
            capacity,
            created_at,
            description,
            favorites: None,
            featured,
            heat,
            id,
            image_url,
            instances: None,
            labs_publication_date,
            name,
            namespace,
            occupants: None,
            organization,
            plugin_url_object,
            popularity,
            preview_youtube_id: None,
            private_occupants: None,
            public_occupants: None,
            publication_date,
            release_status,
            tags,
            thumbnail_image_url,
            unity_package_url_object,
            unity_packages,
            updated_at,
            version,
            visits,
        }
    }
}


