/*
 * // Copyright (c) 2021 Feng Yang
 * //
 * // I am making my contributions/submissions to this project solely in my
 * // personal capacity and am not conveying any rights to any intellectual
 * // property of any third parties.
 */

use crate::vector_expression::VectorExpression;

///
/// # Generic statically-sized N-D vector class.
///
/// This class defines N-D vector data where its size is determined statically
/// at compile time.
///
/// - tparam T - Number type.
/// - tparam N - Dimension.
///
struct Vector<const N: usize> {
    _elements: [f64; N],
}

impl<const N: usize> VectorExpression for Vector<N> {
    fn size(&self) -> usize {
        return N;
    }

    fn eval(&self, i: usize) -> f64 {
        return self._elements[i];
    }
}