/*
 * // Copyright (c) 2021 Feng Yang
 * //
 * // I am making my contributions/submissions to this project solely in my
 * // personal capacity and am not conveying any rights to any intellectual
 * // property of any third parties.
 */

use crate::matrix_expression::MatrixExpression;
use crate::size2::Size2;

///
/// # Static-sized M x N matrix class.
///
/// This class defines M x N row-major matrix data where its size is determined
/// statically at compile time.
///
/// - tparam T - Real number type.
/// - tparam M - Number of rows.
/// - tparam N - Number of columns.
///

pub struct Matrix<const M: usize, const N: usize, const TOTAL: usize> {
    _elements: [f64; TOTAL],
}

impl<const M: usize, const N: usize, const TOTAL: usize> MatrixExpression for Matrix<M, N, TOTAL> {
    fn size(&self) -> Size2 {
        return Size2::new(M, N);
    }

    fn rows(&self) -> usize {
        return M;
    }

    fn cols(&self) -> usize {
        return N;
    }

    fn eval(&self, x: usize, y: usize) -> f64 {
        return self._elements[x * N + y];
    }
}