use maplit::hashmap;
use std::collections::HashMap;

// TODO: Can we make this static ?
pub fn code_to_country_map() -> HashMap<&'static str, &'static str> {
    return hashmap! {    "bd" => "bangladesh",
        "be" => "belgium",
        "bf" => "burkina_faso",
        "bg" => "bulgaria",
        "ba" => "bosnia_and_herzegovina",
        "bb" => "barbados",
        "bm" => "bermuda",
        "bn" => "brunei",
        "bo" => "bolivia",
        "bh" => "bahrain",
        "bi" => "burundi",
        "bj" => "benin",
        "bt" => "bhutan",
        "jm" => "jamaica",
        "bw" => "botswana",
        "ws" => "samoa",
        "br" => "brazil",
        "bs" => "bahamas",
        "je" => "jersey",
        "by" => "belarus",
        "bz" => "belize",
        "ru" => "russia",
        "rw" => "rwanda",
        "rs" => "serbia",
        "tl" => "east_timor",
        "re" => "reunion",
        "tm" => "turkmenistan",
        "tj" => "tajikistan",
        "ro" => "romania",
        "tk" => "tokelau",
        "gw" => "guinea_bissau",
        "gu" => "guam",
        "gt" => "guatemala",
        "gr" => "greece",
        "gq" => "equatorial_guinea",
        "gp" => "guadeloupe",
        "jp" => "japan",
        "gy" => "guyana",
        "gg" => "guernsey",
        "gf" => "french_guiana",
        "ge" => "georgia",
        "gd" => "grenada",
        "uk" => "united_kingdom",
        "ga" => "gabon",
        "sv" => "el_salvador",
        "gn" => "guinea",
        "gm" => "gambia",
        "gl" => "greenland",
        "gi" => "gibraltar",
        "gh" => "ghana",
        "om" => "oman",
        "tn" => "tunisia",
        "jo" => "jordan",
        "hr" => "croatia",
        "ht" => "haiti",
        "hu" => "hungary",
        "hk" => "hong_kong",
        "hn" => "honduras",
        "ve" => "venezuela",
        "pr" => "puerto_rico",
        "pw" => "palau",
        "pt" => "portugal",
        "py" => "paraguay",
        "iq" => "iraq",
        "pa" => "panama",
        "pf" => "french_polynesia",
        "pg" => "papua_new_guinea",
        "pe" => "peru",
        "pk" => "pakistan",
        "ph" => "philippines",
        "pn" => "pitcairn",
        "pl" => "poland",
        "zm" => "zambia",
        "eh" => "western_sahara",
        "ee" => "estonia",
        "eg" => "egypt",
        "za" => "south_africa",
        "ec" => "ecuador",
        "it" => "italy",
        "vn" => "vietnam",
        "sb" => "solomon_islands",
        "et" => "ethiopia",
        "so" => "somalia",
        "zw" => "zimbabwe",
        "sa" => "saudi_arabia",
        "es" => "spain",
        "er" => "eritrea",
        "me" => "montenegro",
        "md" => "moldova",
        "mg" => "madagascar",
        "mf" => "saint_martin",
        "ma" => "morocco",
        "mc" => "monaco",
        "uz" => "uzbekistan",
        "mm" => "myanmar",
        "ml" => "mali",
        "mo" => "macao",
        "mn" => "mongolia",
        "mh" => "marshall_islands",
        "mk" => "macedonia",
        "mu" => "mauritius",
        "mt" => "malta",
        "mw" => "malawi",
        "mv" => "maldives",
        "mq" => "martinique",
        "ms" => "montserrat",
        "mr" => "mauritania",
        "im" => "isle_of_man",
        "ug" => "uganda",
        "tz" => "tanzania",
        "my" => "malaysia",
        "mx" => "mexico",
        "il" => "israel",
        "fr" => "france",
        "sh" => "saint_helena",
        "fi" => "finland",
        "fj" => "fiji",
        "fk" => "falkland_islands",
        "fm" => "micronesia",
        "fo" => "faroe_islands",
        "ni" => "nicaragua",
        "nl" => "netherlands",
        "no" => "norway",
        "na" => "namibia",
        "vu" => "vanuatu",
        "nc" => "new_caledonia",
        "ne" => "niger",
        "nf" => "norfolk_island",
        "ng" => "nigeria",
        "nz" => "new_zealand",
        "np" => "nepal",
        "nr" => "nauru",
        "nu" => "niue",
        "ck" => "cook_islands",
        "xk" => "kosovo",
        "ci" => "ivory_coast",
        "ch" => "switzerland",
        "co" => "colombia",
        "cn" => "china",
        "cm" => "cameroon",
        "cl" => "chile",
        "cc" => "cocos_islands",
        "ca" => "canada",
        "cg" => "republic_of_the congo",
        "cf" => "central_african_republic",
        "cd" => "congo",
        "cz" => "czech_republic",
        "cy" => "cyprus",
        "cx" => "christmas_island",
        "cr" => "costa_rica",
        "cw" => "curacao",
        "cv" => "cape_verde",
        "cu" => "cuba",
        "sz" => "swaziland",
        "sy" => "syria",
        "sx" => "sint_maarten",
        "kg" => "kyrgyzstan",
        "ke" => "kenya",
        "ss" => "south_sudan",
        "sr" => "suriname",
        "ki" => "kiribati",
        "kh" => "cambodia",
        "km" => "comoros",
        "st" => "sao_tome_and_principe",
        "sk" => "slovakia",
        "kr" => "south_korea",
        "si" => "slovenia",
        "kp" => "north_korea",
        "kw" => "kuwait",
        "sn" => "senegal",
        "sm" => "san_marino",
        "sl" => "sierra_leone",
        "sc" => "seychelles",
        "kz" => "kazakhstan",
        "ky" => "cayman_islands",
        "sg" => "singapore",
        "se" => "sweden",
        "sd" => "sudan",
        "do" => "dominican_republic",
        "dm" => "dominica",
        "dj" => "djibouti",
        "dk" => "denmark",
        "vg" => "british_virgin_islands",
        "de" => "germany",
        "ye" => "yemen",
        "dz" => "algeria",
        "us" => "united_states",
        "usa" => "united_states",
        "uy" => "uruguay",
        "yt" => "mayotte",
        "lb" => "lebanon",
        "lc" => "saint_lucia",
        "la" => "laos",
        "tv" => "tuvalu",
        "tw" => "taiwan",
        "tt" => "trinidad_and_tobago",
        "tr" => "turkey",
        "lk" => "sri_lanka",
        "li" => "liechtenstein",
        "lv" => "latvia",
        "to" => "tonga",
        "lt" => "lithuania",
        "lu" => "luxembourg",
        "lr" => "liberia",
        "ls" => "lesotho",
        "th" => "thailand",
        "tg" => "togo",
        "td" => "chad",
        "ly" => "libya",
        "va" => "vatican",
        "ae" => "united_arab_emirates",
        "ad" => "andorra",
        "ag" => "antigua_and_barbuda",
        "af" => "afghanistan",
        "ai" => "anguilla",
        "vi" => "us_virgin_islands",
        "is" => "iceland",
        "ir" => "iran",
        "am" => "armenia",
        "al" => "albania",
        "ao" => "angola",
        "aq" => "antarctica",
        "as" => "american_samoa",
        "ar" => "argentina",
        "au" => "australia",
        "at" => "austria",
        "aw" => "aruba",
        "in" => "india",
        "az" => "azerbaijan",
        "ie" => "ireland",
        "id" => "indonesia",
        "ua" => "ukraine",
        "qa" => "qatar",
        "mz" => "mozambique",
    };
}

pub fn country_to_code_map() -> HashMap<&'static str, &'static str> {
    return hashmap! {    "bd" => "bangladesh",
        "belgium" => "be",
        "burkina_faso" => "bf",
        "bulgaria" => "bg",
        "bosnia_and_herzegovina" => "ba",
        "barbados" => "bb",
        "bermuda" => "bm",
        "brunei" => "bn",
        "bolivia" => "bo",
        "bahrain" => "bh",
        "burundi" => "bi",
        "benin" => "bj",
        "bhutan" => "bt",
        "jamaica" => "jm",
        "botswana" => "bw",
        "samoa" => "ws",
        "brazil" => "br",
        "bahamas" => "bs",
        "jersey" => "je",
        "belarus" => "by",
        "belize" => "bz",
        "russia" => "ru",
        "rwanda" => "rw",
        "serbia" => "rs",
        "east_timor" => "tl",
        "reunion" => "re",
        "turkmenistan" => "tm",
        "tajikistan" => "tj",
        "romania" => "ro",
        "tokelau" => "tk",
        "guinea_bissau" => "gw",
        "guam" => "gu",
        "guatemala" => "gt",
        "greece" => "gr",
        "equatorial_guinea" => "gq",
        "guadeloupe" => "gp",
        "japan" => "jp",
        "guyana" => "gy",
        "guernsey" => "gg",
        "french_guiana" => "gf",
        "georgia" => "ge",
        "grenada" => "gd",
        "united_kingdom" => "uk",
        "gabon" => "ga",
        "el_salvador" => "sv",
        "guinea" => "gn",
        "gambia" => "gm",
        "greenland" => "gl",
        "gibraltar" => "gi",
        "ghana" => "gh",
        "oman" => "om",
        "tunisia" => "tn",
        "jordan" => "jo",
        "croatia" => "hr",
        "haiti" => "ht",
        "hungary" => "hu",
        "hong_kong" => "hk",
        "honduras" => "hn",
        "venezuela" => "ve",
        "puerto_rico" => "pr",
        "palau" => "pw",
        "portugal" => "pt",
        "paraguay" => "py",
        "iraq" => "iq",
        "panama" => "pa",
        "french_polynesia" => "pf",
        "papua_new_guinea" => "pg",
        "peru" => "pe",
        "pakistan" => "pk",
        "philippines" => "ph",
        "pitcairn" => "pn",
        "poland" => "pl",
        "zambia" => "zm",
        "western_sahara" => "eh",
        "estonia" => "ee",
        "egypt" => "eg",
        "south_africa" => "za",
        "ecuador" => "ec",
        "italy" => "it",
        "vietnam" => "vn",
        "solomon_islands" => "sb",
        "ethiopia" => "et",
        "somalia" => "so",
        "zimbabwe" => "zw",
        "saudi_arabia" => "sa",
        "spain" => "es",
        "eritrea" => "er",
        "montenegro" => "me",
        "moldova" => "md",
        "madagascar" => "mg",
        "saint_martin" => "mf",
        "morocco" => "ma",
        "monaco" => "mc",
        "uzbekistan" => "uz",
        "myanmar" => "mm",
        "mali" => "ml",
        "macao" => "mo",
        "mongolia" => "mn",
        "marshall_islands" => "mh",
        "macedonia" => "mk",
        "north_macedonia" => "mk",
        "mauritius" => "mu",
        "malta" => "mt",
        "malawi" => "mw",
        "maldives" => "mv",
        "martinique" => "mq",
        "montserrat" => "ms",
        "mauritania" => "mr",
        "isle_of_man" => "im",
        "uganda" => "ug",
        "tanzania" => "tz",
        "malaysia" => "my",
        "mexico" => "mx",
        "israel" => "il",
        "france" => "fr",
        "saint_helena" => "sh",
        "finland" => "fi",
        "fiji" => "fj",
        "falkland_islands" => "fk",
        "micronesia" => "fm",
        "faroe_islands" => "fo",
        "nicaragua" => "ni",
        "netherlands" => "nl",
        "norway" => "no",
        "namibia" => "na",
        "vanuatu" => "vu",
        "new_caledonia" => "nc",
        "niger" => "ne",
        "norfolk_island" => "nf",
        "nigeria" => "ng",
        "new_zealand" => "nz",
        "nepal" => "np",
        "nauru" => "nr",
        "niue" => "nu",
        "cook_islands" => "ck",
        "kosovo" => "xk",
        "ivory_coast" => "ci",
        "switzerland" => "ch",
        "colombia" => "co",
        "china" => "cn",
        "cameroon" => "cm",
        "chile" => "cl",
        "cocos_islands" => "cc",
        "canada" => "ca",
        "central_african_republic" => "cf",
        "congo" => "cd",
        "czech_republic" => "cz",
        "cyprus" => "cy",
        "christmas_island" => "cx",
        "costa_rica" => "cr",
        "curacao" => "cw",
        "cape_verde" => "cv",
        "cuba" => "cu",
        "swaziland" => "sz",
        "syria" => "sy",
        "sint_maarten" => "sx",
        "kyrgyzstan" => "kg",
        "kenya" => "ke",
        "south_sudan" => "ss",
        "suriname" => "sr",
        "kiribati" => "ki",
        "cambodia" => "kh",
        "comoros" => "km",
        "sao_tome_and_principe" => "st",
        "slovakia" => "sk",
        "south_korea" => "kr",
        "slovenia" => "si",
        "north_korea" => "kp",
        "kuwait" => "kw",
        "senegal" => "sn",
        "san_marino" => "sm",
        "sierra_leone" => "sl",
        "seychelles" => "sc",
        "kazakhstan" => "kz",
        "cayman_islands" => "ky",
        "singapore" => "sg",
        "sweden" => "se",
        "sudan" => "sd",
        "dominican_republic" => "do",
        "dominica" => "dm",
        "djibouti" => "dj",
        "denmark" => "dk",
        "british_virgin_islands" => "vg",
        "germany" => "de",
        "yemen" => "ye",
        "algeria" => "dz",
        "united_states" => "us",
        "usa" => "us",
        "uruguay" => "uy",
        "mayotte" => "yt",
        "lebanon" => "lb",
        "saint_lucia" => "lc",
        "laos" => "la",
        "tuvalu" => "tv",
        "taiwan" => "tw",
        "trinidad_and_tobago" => "tt",
        "turkey" => "tr",
        "sri_lanka" => "lk",
        "liechtenstein" => "li",
        "latvia" => "lv",
        "tonga" => "to",
        "lithuania" => "lt",
        "luxembourg" => "lu",
        "liberia" => "lr",
        "lesotho" => "ls",
        "thailand" => "th",
        "togo" => "tg",
        "chad" => "td",
        "libya" => "ly",
        "vatican" => "va",
        "united_arab_emirates" => "ae",
        "andorra" => "ad",
        "antigua_and_barbuda" => "ag",
        "afghanistan" => "af",
        "anguilla" => "ai",
        "us_virgin_islands" => "vi",
        "iceland" => "is",
        "iran" => "ir",
        "armenia" => "am",
        "albania" => "al",
        "angola" => "ao",
        "antarctica" => "aq",
        "american_samoa" => "as",
        "argentina" => "ar",
        "australia" => "au",
        "austria" => "at",
        "aruba" => "aw",
        "india" => "in",
        "azerbaijan" => "az",
        "ireland" => "ie",
        "indonesia" => "id",
        "ukraine" => "ua",
        "qatar" => "qa",
        "mozambique" => "mz",
    };
}
