@0xe7920ac44374b30b;
# install capnp and capnp-java
# cd capnp-java dir
# capnp compile -I$(PWD)/compiler/src/main/schema --src-prefix=../dashur/schemas/src/main/resources/META-INF/capnp -o./capnpc-java:../dashur/schemas/src/main/java/com/dashur/capnp ../dashur/schemas/src/main/resources/META-INF/capnp/transaction.capnp

using Cxx = import "c++.capnp";
$Cxx.namespace("transaction");

using Java = import "java.capnp";
$Java.package("com.dashur.capnp");
$Java.outerClassname("TransactionCnp");

struct Transaction {
  id @0 :Int64;
  created @1 :UInt64;
  txId @2 :Text;
  applicationId @3 :Int64;
  parentTransactionId @4 :Int64;
  accountId @5 :Int64;
  companyId @6 :Int64;
  walletId @7 :Int64;
  walletCode @8 :Text;

  category @9 :Category;
  enum Category {
		adjustment @0;
		buy @1;
		commission @2;
		endround @3;
		loyalty @4;
		payout @5;
		refund @6;
		sell @7;
		settlement @8;
		transfer @9;
		unknown @10;
		wager @11;
		withdrawal @12;
        trace @13;
        deposit @14;
	}
  subCategory @10 :Text;
  balanceType @11 :BalanceType;
  enum BalanceType {
	cashBalance @0;
	creditBalance @1;
	unknown @2;
  }
  type @12 :Type;
  enum Type {
	credit @0;
	debit @1;
	unknown @2;
  }
  currencyUnit @13 :CurrencyUnit;
  enum CurrencyUnit {
    aed @0;
    afn @1;
    all @2;
    amd @3;
    ang @4;
    aoa @5;
    ars @6;
    aud @7;
    awg @8;
    azn @9;
    bam @10;
    bbd @11;
    bdt @12;
    bgn @13;
    bhd @14;
    bif @15;
    bmd @16;
    bnd @17;
    bob @18;
    brl @19;
    bsd @20;
    btn @21;
    bwp @22;
    byr @23;
    bzd @24;
    cad @25;
    cdf @26;
    chf @27;
    clf @28;
    clp @29;
    cny @30;
    cop @31;
    crc @32;
    cuc @33;
    cup @34;
    cve @35;
    czk @36;
    djf @37;
    dkk @38;
    dop @39;
    dzd @40;
    egp @41;
    ern @42;
    etb @43;
    eur @44;
    fjd @45;
    fkp @46;
    gbp @47;
    gel @48;
    ghs @49;
    gip @50;
    gmd @51;
    gnf @52;
    gtq @53;
    gyd @54;
    hkd @55;
    hnl @56;
    hrk @57;
    htg @58;
    huf @59;
    idr @60;
    ils @61;
    inr @62;
    iqd @63;
    irr @64;
    isk @65;
    jmd @66;
    jod @67;
    jpy @68;
    kes @69;
    kgs @70;
    khr @71;
    kmf @72;
    kpw @73;
    krw @74;
    kwd @75;
    kyd @76;
    kzt @77;
    lak @78;
    lbp @79;
    lkr @80;
    lrd @81;
    lsl @82;
    lyd @83;
    mad @84;
    mdl @85;
    mga @86;
    mkd @87;
    mmk @88;
    mnt @89;
    mop @90;
    mro @91;
    mur @92;
    mvr @93;
    mwk @94;
    mxn @95;
    myr @96;
    mzn @97;
    nad @98;
    ngn @99;
    nio @100;
    nok @101;
    npr @102;
    nzd @103;
    omr @104;
    pab @105;
    pen @106;
    pgk @107;
    php @108;
    pkr @109;
    pln @110;
    pyg @111;
    qar @112;
    ron @113;
    rsd @114;
    rub @115;
    rwf @116;
    sar @117;
    sbd @118;
    scr @119;
    sdg @120;
    sek @121;
    sgd @122;
    shp @123;
    sll @124;
    sos @125;
    srd @126;
    std @127;
    svc @128;
    syp @129;
    szl @130;
    thb @131;
    tjs @132;
    tmt @133;
    tnd @134;
    top @135;
    try @136;
    ttd @137;
    twd @138;
    tzs @139;
    uah @140;
    ugx @141;
    usd @142;
    uyu @143;
    uzs @144;
    vef @145;
    vnd @146;
    vuv @147;
    wst @148;
    xaf @149;
    xag @150;
    xau @151;
    xcd @152;
    xdr @153;
    xof @154;
    xpd @155;
    xpf @156;
    xpt @157;
    yer @158;
    zar @159;
    zmk @160;
    zmw @161;
    zwl @162;
	}
  amount @14 :Int64;
  bonusAmount @15 :Int64;
  poolAmount @16 :Int64;
  rollingCommission @17 :Int64;
  transactionTime @18 :UInt64;
  metaData @19 :Text;
  externalRef @20 :Text;
  balance @21 :Int64;
  session @22 :Text;
  ip @23 :Int64;
  path @24 :List(Int64);
  test @25 :Bool;
  exchangeRateBatchId @26 :UInt64;
  loginContextId @27 :UInt64;
  campaignId @28 :Int64;
  createdBy @29 :Int64;
  rowCategory @30 :RowCategory;
  enum RowCategory {
        actual @0;
        adjustment @1;
  } 
  itemId @31 :UInt64;
  vendorId @32 :UInt64;
  deviceType @33 :DeviceType;
  enum DeviceType {
    desktop @0;
    mobile @1;
    tablet @2;
    tv @3;
    unknown @4;
  }
  deviceTypeVer @34 :Text;
  os @35 :OperatingSystem;
  enum OperatingSystem {
    android @0;
    ios @1;
    linux @2;
    osx @3;
    win @4;
    unknown @5;
  }
  osVer @36 :Text;
  platform @37 :Platform;
  enum Platform {
    flash @0;
    html5 @1;
    native @2;
    unknown @3;
  }
  platformVer @38 :Text;
  browser @39 :Browser;
  enum Browser {
    firefox @0;
    chrome @1;
    chromeMobile @2;
    safari @3;
    safariMobile @4;
    ie @5;
    edge @6;
    androidNative @7;
    qqBrowser @8;
    none @9;
    qqBrowserMobile @10;
    ucBrowser @11;
    unknown @12;
    samsung @13;
    sogou @14;
    maxthon @15;
    opera @16;
    miuiBrowser @17;
    embedded @18;
  }
  browserVer @40 :Text;   
  countryCode @41 :CountryCode;
  enum CountryCode {
    af @0;
    ax @1;
    al @2;
    dz @3;
    as @4;
    ad @5;
    ao @6;
    ai @7;
    aq @8;
    ag @9;
    ar @10;
    am @11;
    aw @12;
    au @13;
    at @14;
    az @15;
    bs @16;
    bh @17;
    bd @18;
    bb @19;
    by @20;
    be @21;
    bz @22;
    bj @23;
    bm @24;
    bt @25;
    bo @26;
    bq @27;
    ba @28;
    bw @29;
    bv @30;
    br @31;
    io @32;
    bn @33;
    bg @34;
    bf @35;
    bi @36;
    kh @37;
    cm @38;
    ca @39;
    cv @40;
    ky @41;
    cf @42;
    td @43;
    cl @44;
    cn @45;
    cx @46;
    cc @47;
    co @48;
    km @49;
    cg @50;
    cd @51;
    ck @52;
    cr @53;
    ci @54;
    hr @55;
    cu @56;
    cw @57;
    cy @58;
    cz @59;
    dk @60;
    dj @61;
    dm @62;
    do @63;
    ec @64;
    eg @65;
    sv @66;
    gq @67;
    er @68;
    ee @69;
    et @70;
    fk @71;
    fo @72;
    fj @73;
    fi @74;
    fr @75;
    gf @76;
    pf @77;
    tf @78;
    ga @79;
    gm @80;
    ge @81;
    de @82;
    gh @83;
    gi @84;
    gr @85;
    gl @86;
    gd @87;
    gp @88;
    gu @89;
    gt @90;
    gg @91;
    gn @92;
    gw @93;
    gy @94;
    ht @95;
    hm @96;
    va @97;
    hn @98;
    hk @99;
    hu @100;
    is @101;
    in @102;
    id @103;
    ir @104;
    iq @105;
    ie @106;
    im @107;
    il @108;
    it @109;
    jm @110;
    jp @111;
    je @112;
    jo @113;
    kz @114;
    ke @115;
    ki @116;
    kp @117;
    kr @118;
    kw @119;
    kg @120;
    la @121;
    lv @122;
    lb @123;
    ls @124;
    lr @125;
    ly @126;
    li @127;
    lt @128;
    lu @129;
    mo @130;
    mk @131;
    mg @132;
    mw @133;
    my @134;
    mv @135;
    ml @136;
    mt @137;
    mh @138;
    mq @139;
    mr @140;
    mu @141;
    yt @142;
    mx @143;
    fm @144;
    md @145;
    mc @146;
    mn @147;
    me @148;
    ms @149;
    ma @150;
    mz @151;
    mm @152;
    na @153;
    nr @154;
    np @155;
    nl @156;
    nc @157;
    nz @158;
    ni @159;
    ne @160;
    ng @161;
    nu @162;
    nf @163;
    mp @164;
    no @165;
    om @166;
    pk @167;
    pw @168;
    ps @169;
    pa @170;
    pg @171;
    py @172;
    pe @173;
    ph @174;
    pn @175;
    pl @176;
    pt @177;
    pr @178;
    qa @179;
    re @180;
    ro @181;
    ru @182;
    rw @183;
    bl @184;
    sh @185;
    kn @186;
    lc @187;
    mf @188;
    pm @189;
    vc @190;
    ws @191;
    sm @192;
    st @193;
    sa @194;
    sn @195;
    rs @196;
    sc @197;
    sl @198;
    sg @199;
    sx @200;
    sk @201;
    si @202;
    sb @203;
    so @204;
    za @205;
    gs @206;
    ss @207;
    es @208;
    lk @209;
    sd @210;
    sr @211;
    sj @212;
    sz @213;
    se @214;
    ch @215;
    sy @216;
    tw @217;
    tj @218;
    tz @219;
    th @220;
    tl @221;
    tg @222;
    tk @223;
    to @224;
    tt @225;
    tn @226;
    tr @227;
    tm @228;
    tc @229;
    tv @230;
    ug @231;
    ua @232;
    ae @233;
    gb @234;
    us @235;
    um @236;
    uy @237;
    uz @238;
    vu @239;
    ve @240;
    vn @241;
    vg @242;
    vi @243;
    wf @244;
    eh @245;
    ye @246;
    zm @247;
    zw @248;
    un @249;
  }
  countryIpCode @42 :CountryCode;
  promotionCode @43 :Text;
  loginTime @44 :UInt64;
  redirectTime @45 :UInt64;
  city @46 :Text;
  regionId @47 :Text;
  isp @48 :Text;
  accountSeqIds @49 :List(UInt64);
  reportIds @50 :List(UInt64);
  siteId @51 :Int64;
  pageId @52 :Int64;
  deviceId @53 :Int64;
  deviceModel @54 :Text;
  deviceVendor @55 :Text;

}
 