@0x969448c1cbbde319;
# install capnp and capnp-java
# cd capnp-java dir
# capnp compile -I$(PWD)/compiler/src/main/schema --src-prefix=../dashur/schemas/src/main/resources/META-INF/capnp -o./capnpc-java:../dashur/schemas/src/main/java/com/dashur/capnp ../dashur/schemas/src/main/resources/META-INF/capnp/requestlog.capnp

using Cxx = import "c++.capnp";
$Cxx.namespace("requestlog");

using Java = import "java.capnp";
$Java.package("com.dashur.capnp");
$Java.outerClassname("RequestLogCnp");

# For the headers we use two lists as Clickhouse doesn't support structs
# If and when it supports structs we could create a generic map instead
struct RequestLog {
  url @0 :Text;
  processingTime @1 :UInt64;
  requestBody @2 :Text;
  responseBody @3 :Text;
  requestHeader @4 :List(Text);
  requestHeaderValues @5 :List(Text);
  responseHeader @6 :List(Text); 
  responseHeaderValues @7 :List(Text); 
  responseCode @8 :Int32;
  failed @9 :Bool;
  created @10 :UInt64;
  txId @11 :Text;
  ip @12 :Int64;
  username @13 :Text;
  clientId @14 :Text;
  type @15 :Text;
  direction @16 :Direction;
  enum Direction {
    in @0;
    out @1;
  }
  accountId @17 :UInt64;
}