/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.capnproto.BufferedInputStream;

public final class PackedInputStream
implements ReadableByteChannel {
    final BufferedInputStream inner;

    public PackedInputStream(BufferedInputStream bufferedInputStream) {
        this.inner = bufferedInputStream;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        if (n % 8 != 0) {
            throw new Error("PackedInputStream reads must be word-aligned");
        }
        int n2 = byteBuffer.position();
        int n3 = n2 + n;
        ByteBuffer byteBuffer2 = this.inner.getReadBuffer();
        while (true) {
            int n4;
            int n5;
            byte by = 0;
            if (byteBuffer2.remaining() < 10) {
                if (byteBuffer.remaining() == 0) {
                    return n;
                }
                if (byteBuffer2.remaining() == 0) {
                    byteBuffer2 = this.inner.getReadBuffer();
                    continue;
                }
                by = byteBuffer2.get();
                for (n5 = 0; n5 < 8; ++n5) {
                    if ((by & 1 << n5) != 0) {
                        if (byteBuffer2.remaining() == 0) {
                            byteBuffer2 = this.inner.getReadBuffer();
                        }
                        byteBuffer.put(byteBuffer2.get());
                        continue;
                    }
                    byteBuffer.put((byte)0);
                }
                if (byteBuffer2.remaining() == 0 && (by == 0 || by == -1)) {
                    byteBuffer2 = this.inner.getReadBuffer();
                }
            } else {
                by = byteBuffer2.get();
                for (n5 = 0; n5 < 8; ++n5) {
                    n4 = (by & 1 << n5) != 0 ? 1 : 0;
                    byteBuffer.put((byte)(byteBuffer2.get() & (n4 != 0 ? -1 : 0)));
                    byteBuffer2.position(byteBuffer2.position() + (n4 != 0 ? 0 : -1));
                }
            }
            if (by == 0) {
                if (byteBuffer2.remaining() == 0) {
                    throw new Error("Should always have non-empty buffer here.");
                }
                n5 = (0xFF & byteBuffer2.get()) * 8;
                if (n5 > n3 - n2) {
                    throw new Error("Packed input did not end cleanly on a segment boundary");
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    byteBuffer.put((byte)0);
                }
            } else if (by == -1) {
                n5 = (0xFF & byteBuffer2.get()) * 8;
                if (byteBuffer2.remaining() >= n5) {
                    ByteBuffer byteBuffer3 = byteBuffer2.slice();
                    byteBuffer3.limit(n5);
                    byteBuffer.put(byteBuffer3);
                    byteBuffer2.position(byteBuffer2.position() + n5);
                } else {
                    byteBuffer.put(byteBuffer2);
                    ByteBuffer byteBuffer4 = byteBuffer.slice();
                    byteBuffer4.limit(n5 -= byteBuffer2.remaining());
                    this.inner.read(byteBuffer4);
                    byteBuffer.position(byteBuffer.position() + n5);
                    if (byteBuffer.remaining() == 0) {
                        return n;
                    }
                    byteBuffer2 = this.inner.getReadBuffer();
                    continue;
                }
            }
            if (byteBuffer.remaining() == 0) break;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

