@0xdf81c7dce4555ae9;
# install capnp and capnp-java
# cd capnp-java dir
# capnp compile -I$(PWD)/compiler/src/main/schema --src-prefix=../dashur/schemas/src/main/resources/META-INF/capnp -o./capnpc-java:../dashur/schemas/src/main/java/com/dashur/capnp ../dashur/schemas/src/main/resources/META-INF/capnp/extwalletcommand.capnp

using Cxx = import "c++.capnp";
$Cxx.namespace("extwalletcommand");

using Java = import "java.capnp";
$Java.package("com.dashur.capnp");
$Java.outerClassname("ExtWalletCommandCnp");

# For the headers we use two lists as Clickhouse doesn't support structs
# If and when it supports structs we could create a generic map instead
struct ExtWalletCommand {
  requestId @0 :Text;
  processingTime @1 :UInt64;
  requestBody @2 :Text;
  responseBody @3 :Text;
  requestHeader @4 :List(Text);
  requestHeaderValues @5 :List(Text);
  responseHeader @6 :List(Text); 
  responseHeaderValues @7 :List(Text); 
  responseCode @8 :Int32;
  failed @9 :Bool;
  created @10 :UInt64;
  txId @11 :Text;
  companyId @12 :UInt64;
  walletCode @13 :Text;
  memberId @14 :UInt64;
  internalProcessingTime @15 :Int64;
  type @16 :Type;
  enum Type {
    unknown @0;
    auth @1;
    balance @2;
    transaction @3;
    endRound @4;
  }
}