/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.SegmentReader;
import org.capnproto.StructReader;

public class ListReader {
    final SegmentReader segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;
    final int nestingLimit;

    public ListReader() {
        this.segment = null;
        this.ptr = 0;
        this.elementCount = 0;
        this.step = 0;
        this.structDataSize = 0;
        this.structPointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public ListReader(SegmentReader segmentReader, int n, int n2, int n3, int n4, short s, int n5) {
        this.segment = segmentReader;
        this.ptr = n;
        this.elementCount = n2;
        this.step = n3;
        this.structDataSize = n4;
        this.structPointerCount = s;
        this.nestingLimit = n5;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int n) {
        long l = (long)n * (long)this.step;
        byte by = this.segment.buffer.get(this.ptr + (int)(l / 8L));
        return (by & 1 << (int)(l % 8L)) != 0;
    }

    protected byte _getByteElement(int n) {
        return this.segment.buffer.get(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected short _getShortElement(int n) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected int _getIntElement(int n) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected long _getLongElement(int n) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected float _getFloatElement(int n) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int n) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected <T> T _getStructElement(StructReader.Factory<T> factory, int n) {
        long l = (long)n * (long)this.step;
        int n2 = this.ptr + (int)(l / 8L);
        int n3 = n2 + this.structDataSize / 8;
        return factory.constructReader(this.segment, n2, n3 / 8, this.structDataSize, this.structPointerCount, this.nestingLimit - 1);
    }

    protected <T> T _getPointerElement(FromPointerReader<T> fromPointerReader, int n) {
        return fromPointerReader.fromPointerReader(this.segment, (this.ptr + (int)((long)n * (long)this.step / 8L)) / 8, this.nestingLimit);
    }

    protected <T> T _getPointerElement(FromPointerReaderBlobDefault<T> fromPointerReaderBlobDefault, int n, ByteBuffer byteBuffer, int n2, int n3) {
        return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(this.segment, (this.ptr + (int)((long)n * (long)this.step / 8L)) / 8, byteBuffer, n2, n3);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, int var5, short var6, int var7);
    }
}

