/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.PointerFactory;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.WireHelpers;

public final class Data {
    public static final Factory factory = new Factory();

    public static final class Builder {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Builder() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Builder(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.offset = n;
            this.size = n2;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public byte[] toArray() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byte[] byArray = new byte[this.size];
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            return byArray;
        }
    }

    public static final class Reader {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Reader() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Reader(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.offset = n * 8;
            this.size = n2;
        }

        public Reader(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
            this.offset = 0;
            this.size = byArray.length;
        }

        public final int size() {
            return this.size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.asReadOnlyBuffer();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public byte[] toArray() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byte[] byArray = new byte[this.size];
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            return byArray;
        }
    }

    public static final class Factory
    implements FromPointerReaderBlobDefault<Reader>,
    PointerFactory<Builder, Reader>,
    FromPointerBuilderBlobDefault<Builder>,
    SetPointerBuilder<Builder, Reader> {
        @Override
        public final Reader fromPointerReaderBlobDefault(SegmentReader segmentReader, int n, ByteBuffer byteBuffer, int n2, int n3) {
            return WireHelpers.readDataPointer(segmentReader, n, byteBuffer, n2, n3);
        }

        @Override
        public final Reader fromPointerReader(SegmentReader segmentReader, int n, int n2) {
            return WireHelpers.readDataPointer(segmentReader, n, null, 0, 0);
        }

        @Override
        public final Builder fromPointerBuilderBlobDefault(SegmentBuilder segmentBuilder, int n, ByteBuffer byteBuffer, int n2, int n3) {
            return WireHelpers.getWritableDataPointer(n, segmentBuilder, byteBuffer, n2, n3);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segmentBuilder, int n) {
            return WireHelpers.getWritableDataPointer(n, segmentBuilder, null, 0, 0);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segmentBuilder, int n, int n2) {
            return WireHelpers.initDataPointer(n, segmentBuilder, n2);
        }

        @Override
        public final void setPointerBuilder(SegmentBuilder segmentBuilder, int n, Reader reader) {
            WireHelpers.setDataPointer(n, segmentBuilder, reader);
        }
    }
}

