//! Module for http types.

use std::collections::HashMap;

#[doc(inline)]
pub use {method::*, request::*, response::*, status_code::*};

mod method;
mod request;
mod response;
mod status_code;

type Headers = HashMap<String, String>;
type Body = Option<Vec<u8>>;
