# Voidy

## A library to handle HTTP/2 requests asynchronously.

### Status:
 - In development

```rs
use voidy::{
    Server,
    Result,
    http::{Request, Response, StatusCode},
};

#[async_std::main]
async fn main() -> Result {
    let server = Server::bind("localhost:8000").await?;

    server
        .handle(|mut req: Request| async move {
            if req.path() == "/ok" {
                let response = Response::from(StatusCode::Ok);
                req.respond(response).await?;
            } else {
                let response = Response::from(StatusCode::NotFound);
                req.respond(response).await?;
            }
        })
        .await?;

    Ok(())
}
```
