use std::io::Error;

pub fn read(file: &str) -> Result<String, Error> {
    return Ok(std::fs::read_to_string(file)?)
}

pub fn write(file: &str, text: &str) -> Result<(), Error> {
    std::fs::write(file, text)?;
    return Ok(())
}

pub fn remove(file: &str) -> Result<(), Error> {
    std::fs::remove_file(file)?;
    return Ok(())
}

pub fn make_dir(path: &str) -> Result<(), Error> {
    std::fs::create_dir(path)?;
    return Ok(())
}