use crate::writer;

use text_io::read;
use colored::*;

pub fn switch(gpu_mode: &str) { 
    println!("Switch to {} GPU?\n", gpu_mode);
    println!("{}","[ y, N ]".bright_white().italic());

    let line : String = read!("{}\n");

    if line.to_lowercase() != "y" {
        println!("{}", "Cancelling..".red());
        return
    }

    match &gpu_mode[..] {
        "nvidia" => switch_nvidia(),
        "intel" => switch_intel(),
        "hybrid" => switch_hybrid(),
        _ => return,
    }
}

pub fn switch_nvidia() {
    println!("{}", "Writing to /etc/X11/xorg.conf.d/10-nvidia-vom.conf...".yellow().italic().bold());
    // Write to xorg config.
    writer::write("/etc/X11/xorg.conf.d/10-nvidia-vom.conf",
        r#"Section "OutputClass"
        Identifier "intel"
        MatchDriver "i915"
        Driver "modesetting"
    EndSection
    
    Section "OutputClass"
        Identifier "nvidia"
        MatchDriver "nvidia-drm"
        Driver "nvidia"
        Option "AllowEmptyInitialConfiguration"
        Option "PrimaryGPU" "yes"
        ModulePath "/usr/lib/nvidia/xorg"
        ModulePath "/usr/lib/xorg/modules"
    EndSection"#
    ).expect("Couldn't write to xorg config!");

    println!("{}", "Finished writing config file.".yellow().italic().bold());
    println!("{}", "Writing current mode to /var/void-optimus-manager/current_mode...".yellow().italic().bold());

    writer::write("/var/service/void-optimus-manager/current_mode", "nvidia").expect("Couldn't write to /var/void-optimus-manager/current_mode");

    println!("Finished writing current mode.");

    println!("Log out for the changes to take effect.");
}

pub fn switch_intel() {
    println!("{}", "Removing /etc/X11/xorg.conf.d/10-nvidia-vom.conf...".yellow().italic().bold());
    writer::remove("/etc/X11/xorg.conf.d/10-nvidia-vom.conf").expect("Could not remove /etc/X11/xorg.conf.d/10-nvidia-vom.conf");
}

pub fn switch_hybrid() {

}