mod writer;
mod switch;

use structopt::StructOpt;
use colored::*;

#[derive(StructOpt)]
struct CLI {
    /// Initiates void-optimus-manager, creating the directories and files.
    #[structopt(long)]
    init: bool,
    /// Switches GPU mode to Intel or Nvidia
    #[structopt(long, default_value = "none")]
    switch: String,
    /// Prints current GPU mode.
    #[structopt(short, long)]
    print_mode: bool,
}

fn main() {
    let args = CLI::from_args();

    let gpu_mode = args.switch.to_lowercase();

    if args.init {
        writer::make_dir("/var/service/void-optimus-manager")
        .expect("Failed to init ; COuldn't make directory /var/service/void-optimus-manager/current_mode.\nMaybe run with sudo?");

        writer::write("/var/service/void-optimus-manager/current_mode", "intel")
        .expect("Failed to init ; Couldn't write to /var/service/void-optimus-manager/current_mode")
    }

    if args.print_mode {
        println!("Current GPU mode: {:?}", writer::read("/var/service/void-optimus-manager/current_mode"));
    }

    match &gpu_mode[..] {
        "nvidia" | "intel" | "hybrid" => switch::switch(&gpu_mode),
        "none" => println!(),
       _ => println!("{}", "Invalid GPU Mode selected!".red())
    }
}
