# `vnstat` parse

A Rust library to parse `oneline` data output from [vnstat](https://humdi.net/vnstat/) ("a network and traffic monitor for Linux and BSD").

All fields are parsed, with the exception of the API version information.
Dates are parsed to `String`, data values are parsed to `f32` and data units 
are parsed to `String`.

Here is the summary of the `--oneline` option from the `vnstat man` page:

> Show traffic summary for selected interface using one line with a  parsable
  format.  The  output contains 15 fields with ; used as field delimiter. The
  1st field contains the API version information of the output that will only
  be  changed  in  future versions if the field content or structure changes.
  The following fields in order 2) interface name, 3) timestamp for today, 4)
  rx  for today, 5) tx for today, 6) total for today, 7) average traffic rate
  for today, 8) timestamp for current month, 9) rx for current month, 10)  tx
  for  current  month,  11) total for current month, 12) average traffic rate
  for current month, 13) all time total rx, 14) all time total  tx,  15)  all
  time  total  traffic.   An optional mode parameter can be used to force all
  fields to output in bytes without the unit itself shown.

**Example output**

```bash
vnstat eno1 --oneline
1;eno1;2021-11-29;6.02 GiB;0.99 GiB;7.00 GiB;738.84 kbit/s;2021-11;6.02 GiB;0.99 GiB;7.00 GiB;24.06 kbit/s;6.02 GiB;0.99 GiB;7.00 GiB
```

## Library Usage

```rust
use vnstat_parse::{Error, Vnstat};

fn main() -> Result<(), Error> {
    let vnstat_data = Vnstat::get("eno1")?;

    println!("{:?}", vnstat_data);

    Ok(())
}
```

**Example output**

```bash
Vnstat { iface: "eno1", today: "2021-11-29", day_rx: 6.02, day_rx_unit: "GiB", day_tx: 0.99, day_tx_unit: "GiB", day_total: 7.0, day_total_unit: "GiB", day_avg_rate: 738.84, day_avg_rate_unit: "kbit/s", month: "2021-11", month_rx: 6.02, month_rx_unit: "GiB", month_tx: 0.99, month_tx_unit: "GiB", month_total: 7.0, month_total_unit: "GiB", month_avg_rate: 24.06, month_avg_rate_unit: "kbit/s", all_time_rx: 6.02, all_time_rx_unit: "GiB", all_time_tx: 0.99, all_time_tx_unit: "GiB", all_time_total: 7.0, all_time_total_unit: "GiB" }
```

## Optional Features

`Serialize` and `Deserialize` can be optionally derived for the `Vnstat` `struct` using either [miniserde](https://crates.io/crates/miniserde) or [serde](https://crates.io/crates/serde). These features are disabled by default to offer a zero dependency parser. `miniserde` offers a lightweight option when compared with `serde` (one less dependency and shorter compile times).

Specify the desired feature in your `Cargo.toml` manifest:

```toml
vnstat_parse = { version = "0.1", features = ["miniserde"] }
```

## License

MIT.
